---
name: Bug report
about: Create a report to help us improve
title: ''
labels: ''
assignees: ''

---

**Describe the bug**
A clear and concise description of what the bug is.

**Code sample**
```php
echo "A short code snippet that can be used to reproduce the bug";
```

**Custom ruleset**
```xml
<?xml version="1.0"?>
<ruleset name="My Custom Standard">
  <description>If you are using a custom ruleset, please enter it here.</description>
</ruleset>
```

**To reproduce**
Steps to reproduce the behavior:
1. Create a file called `test.php` with the code sample above...
2. Run `phpcs test.php ...`
3. See error message displayed
```
PHPCS output here
```

**Expected behavior**
A clear and concise description of what you expected to happen.

**Versions (please complete the following information):**
 - OS: [e.g., Windows 10, MacOS 10.15]
 - PHP: [e.g., 7.2, 7.4]
 - PHPCS: [e.g., 3.5.5, master]
 - Standard: [e.g., PSR2, PSR12, Squiz]

**Additional context**
Add any other context about the problem here.
