/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.UIManager;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.ClipboardLoop;
import net.sourceforge.plantuml.ErrorStatus;
import net.sourceforge.plantuml.FileGroup;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.OptionPreprocOutputMode;
import net.sourceforge.plantuml.Pipe;
import net.sourceforge.plantuml.ProgressBar;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.SourceFileReaderAbstract;
import net.sourceforge.plantuml.SourceFileReaderCopyCat;
import net.sourceforge.plantuml.SourceFileReaderHardFile;
import net.sourceforge.plantuml.Splash;
import net.sourceforge.plantuml.Stdrpt;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.SuggestedFile;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory;
import net.sourceforge.plantuml.classdiagram.ClassDiagramFactory;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.command.PSystemCommandFactory;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory;
import net.sourceforge.plantuml.ftp.FtpServer;
import net.sourceforge.plantuml.picoweb.PicoWebServer;
import net.sourceforge.plantuml.png.MetadataTag;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.security.ImageIO;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory;
import net.sourceforge.plantuml.sprite.SpriteGrayLevel;
import net.sourceforge.plantuml.sprite.SpriteUtils;
import net.sourceforge.plantuml.statediagram.StateDiagramFactory;
import net.sourceforge.plantuml.stats.StatsUtils;
import net.sourceforge.plantuml.swing.MainWindow2;
import net.sourceforge.plantuml.syntax.LanguageDescriptor;
import net.sourceforge.plantuml.utils.Cypher;
import net.sourceforge.plantuml.version.Version;

public class Run {
    private static Cypher cypher;
    private static String commandLine;
    private static final String httpProtocol = "http://";
    private static final String httpsProtocol = "https://";

    public static void main(String[] argsArray) throws NoPlantumlCompressionException, IOException, InterruptedException {
        System.setProperty("log4j.debug", "false");
        long start = System.currentTimeMillis();
        if (argsArray.length > 0 && argsArray[0].equalsIgnoreCase("-headless")) {
            System.setProperty("java.awt.headless", "true");
        }
        Run.saveCommandLine(argsArray);
        Option option = new Option(argsArray);
        ProgressBar.setEnable(option.isTextProgressBar());
        if (OptionFlags.getInstance().isClipboardLoop()) {
            ClipboardLoop.runLoop();
            return;
        }
        if (OptionFlags.getInstance().isClipboard()) {
            ClipboardLoop.runOnce();
            return;
        }
        if (OptionFlags.getInstance().isExtractStdLib()) {
            Stdlib.extractStdLib();
            return;
        }
        if (OptionFlags.getInstance().isStdLib()) {
            Stdlib.printStdLib();
            return;
        }
        if (OptionFlags.getInstance().isDumpStats()) {
            StatsUtils.dumpStats();
            return;
        }
        if (OptionFlags.getInstance().isLoopStats()) {
            StatsUtils.loopStats();
            return;
        }
        if (OptionFlags.getInstance().isDumpHtmlStats()) {
            StatsUtils.outHtml();
            return;
        }
        if (OptionFlags.getInstance().isEncodesprite()) {
            Run.encodeSprite(option.getResult());
            return;
        }
        Log.info("SecurityProfile " + (Object)((Object)SecurityUtils.getSecurityProfile()));
        if (OptionFlags.getInstance().isVerbose()) {
            Log.info("PlantUML Version " + Version.versionString());
            Log.info("GraphicsEnvironment.isHeadless() " + GraphicsEnvironment.isHeadless());
        }
        if (GraphicsEnvironment.isHeadless()) {
            Log.info("Forcing -Djava.awt.headless=true");
            System.setProperty("java.awt.headless", "true");
            Log.info("java.awt.headless set as true");
        }
        if (OptionFlags.getInstance().isPrintFonts()) {
            Run.printFonts();
            return;
        }
        if (option.getFtpPort() != -1) {
            Run.goFtp(option);
            return;
        }
        if (option.getPicowebPort() != -1) {
            Run.goPicoweb(option);
            return;
        }
        Run.forceOpenJdkResourceLoad();
        if (option.getPreprocessorOutputMode() == OptionPreprocOutputMode.CYPHER) {
            cypher = new LanguageDescriptor().getCypher();
        }
        ErrorStatus error = ErrorStatus.init();
        boolean forceQuit = false;
        if (option.isPattern()) {
            Run.managePattern();
        } else if (OptionFlags.getInstance().isGui()) {
            File f;
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            catch (Exception exception) {
                // empty catch block
            }
            List<String> list = option.getResult();
            File dir = null;
            if (list.size() == 1 && (f = new File(list.get(0))).exists() && f.isDirectory()) {
                dir = f;
            }
            new MainWindow2(option, dir);
        } else if (option.isPipe() || option.isPipeMap() || option.isSyntax()) {
            Run.managePipe(option, error);
            forceQuit = true;
        } else if (option.isFailfast2()) {
            if (option.isSplash()) {
                Splash.createSplash();
            }
            long start2 = System.currentTimeMillis();
            option.setCheckOnly(true);
            Run.manageAllFiles(option, error);
            option.setCheckOnly(false);
            if (option.isDuration()) {
                double duration = (double)(System.currentTimeMillis() - start2) / 1000.0;
                Log.error("Check Duration = " + duration + " seconds");
            }
            if (!error.hasError()) {
                Run.manageAllFiles(option, error);
            }
            forceQuit = true;
        } else {
            if (option.isSplash()) {
                Splash.createSplash();
            }
            Run.manageAllFiles(option, error);
            forceQuit = true;
        }
        if (option.isDuration()) {
            double duration = (double)(System.currentTimeMillis() - start) / 1000.0;
            Log.error("Duration = " + duration + " seconds");
        }
        if (!OptionFlags.getInstance().isGui()) {
            if (error.hasError() || error.isNoData()) {
                option.getStdrpt().finalMessage(error);
                System.exit(error.getExitCode());
            }
            if (forceQuit && OptionFlags.getInstance().isSystemExit()) {
                System.exit(0);
            }
        }
    }

    public static final String getCommandLine() {
        return commandLine;
    }

    private static void saveCommandLine(String[] argsArray) {
        StringBuilder sb = new StringBuilder();
        for (String s : argsArray) {
            sb.append(s);
            sb.append(" ");
        }
        commandLine = sb.toString();
    }

    public static void forceOpenJdkResourceLoad() {
        if (Run.isOpenJdkRunning()) {
            Log.info("Forcing resource load on OpenJdk");
            BufferedImage imDummy = new BufferedImage(10, 10, 1);
            Graphics2D gg = imDummy.createGraphics();
            String text = "Alice";
            Font font = new Font("SansSerif", 0, 12);
            FontMetrics fm = gg.getFontMetrics(font);
            Rectangle2D rectangle2D = fm.getStringBounds("Alice", gg);
        }
    }

    public static boolean isOpenJdkRunning() {
        String jvmName = System.getProperty("java.vm.name");
        return jvmName != null && jvmName.toLowerCase().contains("openjdk");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void encodeSprite(List<String> result) throws IOException {
        BufferedImage im;
        String fileName;
        URL source;
        String path;
        SpriteGrayLevel level = SpriteGrayLevel.GRAY_16;
        boolean compressed = false;
        if (result.size() > 1 && result.get(0).matches("(4|8|16)z?")) {
            if (result.get(0).startsWith("8")) {
                level = SpriteGrayLevel.GRAY_8;
            }
            if (result.get(0).startsWith("4")) {
                level = SpriteGrayLevel.GRAY_4;
            }
            compressed = StringUtils.goLowerCase(result.get(0)).endsWith("z");
            path = result.get(1);
        } else {
            path = result.get(0);
        }
        String lowerPath = StringUtils.goLowerCase(path);
        if (lowerPath.startsWith(httpProtocol) || lowerPath.startsWith(httpsProtocol)) {
            source = new URL(path);
            String p = source.getPath();
            fileName = p.substring(p.lastIndexOf(47) + 1, p.length());
        } else {
            SFile f = new SFile(path);
            source = f.toURI().toURL();
            fileName = f.getName();
        }
        if (source == null) {
            return;
        }
        try (InputStream stream = null;){
            stream = source.openStream();
            im = ImageIO.read(stream);
        }
        String name = Run.getSpriteName(fileName);
        String s = compressed ? SpriteUtils.encodeCompressed(im, name, level) : SpriteUtils.encode(im, name, level);
        System.out.println(s);
    }

    private static String getSpriteName(String fileName) {
        String s = Run.getSpriteNameInternal(fileName);
        if (s.length() == 0) {
            return "test";
        }
        return s;
    }

    private static String getSpriteNameInternal(String fileName) {
        StringBuilder sb = new StringBuilder();
        for (char c : fileName.toCharArray()) {
            if (!("" + c).matches("[\\p{L}0-9_]")) {
                return sb.toString();
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void goFtp(Option option) throws IOException {
        int ftpPort = option.getFtpPort();
        System.err.println("ftpPort=" + ftpPort);
        FtpServer ftpServer = new FtpServer(ftpPort, option.getFileFormatOption().getFileFormat());
        ftpServer.go();
    }

    private static void goPicoweb(Option option) throws IOException {
        int picoWebport = option.getPicowebPort();
        System.err.println("webPort=" + picoWebport);
        PicoWebServer.startServer(picoWebport);
    }

    public static void printFonts() {
        String[] name;
        Font[] fonts;
        for (Font f : fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            System.out.println("f=" + f + "/" + f.getPSName() + "/" + f.getName() + "/" + f.getFontName() + "/" + f.getFamily());
        }
        for (String n : name = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            System.out.println("n=" + n);
        }
    }

    private static void managePattern() {
        Run.printPattern(new SequenceDiagramFactory(null));
        Run.printPattern(new ClassDiagramFactory(null));
        Run.printPattern(new ActivityDiagramFactory(null));
        Run.printPattern(new DescriptionDiagramFactory(null));
        Run.printPattern(new StateDiagramFactory(null));
    }

    private static void printPattern(PSystemCommandFactory factory) {
        System.out.println();
        System.out.println(factory.getClass().getSimpleName().replaceAll("Factory", ""));
        List<String> descriptions = factory.getDescription();
        for (String s : descriptions) {
            System.out.println(s);
        }
    }

    private static void managePipe(Option option, ErrorStatus error) throws IOException {
        String charset = option.getCharset();
        new Pipe(option, System.out, System.in, charset).managePipe(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void manageAllFiles(Option option, ErrorStatus error) throws NoPlantumlCompressionException, InterruptedException {
        SFile lockFile = null;
        try {
            if (OptionFlags.getInstance().isWord()) {
                SFile dir = new SFile(option.getResult().get(0));
                SFile javaIsRunningFile = dir.file("javaisrunning.tmp");
                javaIsRunningFile.delete();
                lockFile = dir.file("javaumllock.tmp");
            }
            Run.processArgs(option, error);
        }
        finally {
            if (lockFile != null) {
                lockFile.delete();
            }
        }
    }

    private static void processArgs(Option option, ErrorStatus error) throws NoPlantumlCompressionException, InterruptedException {
        if (!(option.isDecodeurl() || option.getNbThreads() <= 1 || option.isCheckOnly() || OptionFlags.getInstance().isExtractFromMetadata())) {
            Run.multithread(option, error);
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String s : option.getResult()) {
            if (option.isDecodeurl()) {
                error.goOk();
                Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
                System.out.println("@startuml");
                System.out.println(transcoder.decode(s));
                System.out.println("@enduml");
                continue;
            }
            FileGroup group = new FileGroup(s, option.getExcludes(), option);
            Run.incTotal(group.getFiles().size());
            files.addAll(group.getFiles());
        }
        Run.foundNbFiles(files.size());
        for (File f : files) {
            try {
                Run.manageFileInternal(f, option, error);
                Run.incDone(error.hasError());
                if (!error.hasError() || !option.isFailfastOrFailfast2()) continue;
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void multithread(final Option option, final ErrorStatus error) throws InterruptedException {
        Log.info("Using several threads: " + option.getNbThreads());
        ExecutorService executor = Executors.newFixedThreadPool(option.getNbThreads());
        int nb = 0;
        for (String s : option.getResult()) {
            FileGroup group = new FileGroup(s, option.getExcludes(), option);
            for (final File f : group.getFiles()) {
                Run.incTotal(1);
                ++nb;
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (error.hasError() && option.isFailfastOrFailfast2()) {
                            return;
                        }
                        try {
                            Run.manageFileInternal(f, option, error);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        Run.incDone(error.hasError());
                    }
                });
            }
        }
        Run.foundNbFiles(nb);
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    private static void foundNbFiles(int nb) {
        Log.info("Found " + nb + " files");
    }

    private static void incDone(boolean error) {
        Splash.incDone(error);
        ProgressBar.incDone(error);
    }

    private static void incTotal(int nb) {
        Splash.incTotal(nb);
        ProgressBar.incTotal(nb);
    }

    private static void manageFileInternal(File f, Option option, ErrorStatus error) throws IOException, InterruptedException {
        SourceFileReaderAbstract sourceFileReader;
        Log.info("Working on " + f.getPath());
        if (OptionFlags.getInstance().isExtractFromMetadata()) {
            System.out.println("------------------------");
            System.out.println(f);
            System.out.println();
            error.goOk();
            String data = new MetadataTag(f, "plantuml").getData();
            System.out.println(data);
            System.out.println("------------------------");
            return;
        }
        if (option.getOutputFile() == null) {
            Object outputDir = option.getOutputDir();
            if (outputDir != null && ((File)outputDir).getPath().endsWith("$")) {
                String path = ((File)outputDir).getPath();
                outputDir = new File(path.substring(0, path.length() - 1)).getAbsoluteFile();
                sourceFileReader = new SourceFileReaderCopyCat(option.getDefaultDefines(f), f, (File)outputDir, option.getConfig(), option.getCharset(), option.getFileFormatOption());
            } else {
                sourceFileReader = new SourceFileReader(option.getDefaultDefines(f), f, (File)outputDir, option.getConfig(), option.getCharset(), option.getFileFormatOption());
            }
        } else {
            sourceFileReader = new SourceFileReaderHardFile(option.getDefaultDefines(f), f, option.getOutputFile(), option.getConfig(), option.getCharset(), option.getFileFormatOption());
        }
        sourceFileReader.setCheckMetadata(option.isCheckMetadata());
        if (option.isComputeurl()) {
            error.goOk();
            for (BlockUml s : sourceFileReader.getBlocks()) {
                System.out.println(s.getEncodedUrl());
            }
            return;
        }
        if (option.isCheckOnly()) {
            error.goOk();
            boolean hasError = sourceFileReader.hasError();
            if (hasError) {
                error.goWithError();
            }
            return;
        }
        if (option.getPreprocessorOutputMode() != null) {
            Run.extractPreproc(option, (ISourceFileReader)((Object)sourceFileReader));
            error.goOk();
            return;
        }
        List<GeneratedImage> result = sourceFileReader.getGeneratedImages();
        Stdrpt rpt = option.getStdrpt();
        if (result.size() == 0) {
            Log.error("Warning: no image in " + f.getPath());
            rpt.printInfo(System.err, null);
            return;
        }
        for (BlockUml s : sourceFileReader.getBlocks()) {
            rpt.printInfo(System.err, s.getDiagram());
        }
        Run.hasErrors(f, result, error, rpt);
    }

    private static void extractPreproc(Option option, ISourceFileReader sourceFileReader) throws IOException {
        String charset = option.getCharset();
        for (BlockUml blockUml : sourceFileReader.getBlocks()) {
            SuggestedFile suggested = ((SourceFileReaderAbstract)((Object)sourceFileReader)).getSuggestedFile(blockUml).withPreprocFormat();
            SFile file = suggested.getFile(0);
            Log.info("Export preprocessing source to " + file.getPrintablePath());
            PrintWriter pw = charset == null ? file.createPrintWriter() : file.createPrintWriter(charset);
            int level = 0;
            for (CharSequence charSequence : blockUml.getDefinition(true)) {
                String s = charSequence.toString();
                if (cypher != null) {
                    if (s.contains("skinparam") && s.contains("{")) {
                        ++level;
                    }
                    if (level == 0 && !s.contains("skinparam")) {
                        s = cypher.cypher(s);
                    }
                    if (level > 0 && s.contains("}")) {
                        --level;
                    }
                }
                pw.println(s);
            }
            pw.close();
        }
    }

    private static void hasErrors(File file, List<GeneratedImage> list, ErrorStatus error, Stdrpt stdrpt) throws IOException {
        if (list.size() == 0) {
            return;
        }
        for (GeneratedImage image : list) {
            int lineError = image.lineErrorRaw();
            if (lineError == -1) continue;
            stdrpt.errorLine(lineError, file);
            error.goWithError();
            return;
        }
        error.goOk();
    }

    static {
        commandLine = "";
    }
}

