/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Annotated;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.cucadiagram.DisplaySection;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.style.StyleBuilder;

public abstract class TitledDiagram
extends AbstractPSystem
implements Diagram,
Annotated {
    public static final boolean FORCE_JDOT = false;
    private DisplayPositionned title = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.TOP);
    private DisplayPositionned caption = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private DisplayPositionned legend = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private final DisplaySection header = DisplaySection.none();
    private final DisplaySection footer = DisplaySection.none();
    private Display mainFrame;
    private final SkinParam skinParam;
    private final Pragma pragma = new Pragma();
    private boolean useJDot;

    public Pragma getPragma() {
        return this.pragma;
    }

    public TitledDiagram() {
        this.skinParam = SkinParam.create(this.getUmlDiagramType());
    }

    public final StyleBuilder getCurrentStyleBuilder() {
        return this.skinParam.getCurrentStyleBuilder();
    }

    public TitledDiagram(ISkinSimple orig) {
        this();
        if (orig != null) {
            this.skinParam.copyAllFrom(orig);
        }
    }

    public abstract UmlDiagramType getUmlDiagramType();

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public void setParam(String key, String value) {
        this.skinParam.setParam(StringUtils.goLowerCase(key), value);
    }

    public void addSprite(String name, Sprite sprite) {
        this.skinParam.addSprite(name, sprite);
    }

    public CommandExecutionResult loadSkin(String newSkin) throws IOException {
        this.getSkinParam().setDefaultSkin(newSkin + ".skin");
        return CommandExecutionResult.ok();
    }

    public final void setTitle(DisplayPositionned title) {
        if (title.isNull() || title.getDisplay().isWhite()) {
            return;
        }
        this.title = title;
    }

    @Override
    public final DisplayPositionned getTitle() {
        return this.title;
    }

    public final void setMainFrame(Display mainFrame) {
        this.mainFrame = mainFrame;
    }

    public final void setCaption(DisplayPositionned caption) {
        this.caption = caption;
    }

    @Override
    public final DisplayPositionned getCaption() {
        return this.caption;
    }

    @Override
    public final DisplaySection getHeader() {
        return this.header;
    }

    @Override
    public final DisplaySection getFooter() {
        return this.footer;
    }

    @Override
    public final DisplayPositionned getLegend() {
        return this.legend;
    }

    public void setLegend(DisplayPositionned legend) {
        this.legend = legend;
    }

    @Override
    public final Display getMainFrame() {
        return this.mainFrame;
    }

    public void setUseJDot(boolean useJDot) {
        this.useJDot = useJDot;
    }

    public boolean isUseJDot() {
        return this.useJDot;
    }

    public final double getScaleCoef(FileFormatOption fileFormatOption) {
        if (this.getSkinParam().getDpi() == 96) {
            return fileFormatOption.getScaleCoef();
        }
        return (double)this.getSkinParam().getDpi() * fileFormatOption.getScaleCoef() / 96.0;
    }
}

