/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Election;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockWithUrl;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.AbstractPlacementStrategy;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyVisibility;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Center;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Left;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULayoutGroup;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.utils.CharHidder;

public class MethodsOrFieldsArea
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final FontParam fontParam;
    private final ISkinParam skinParam;
    private final Rose rose = new Rose();
    private final Display members;
    private final HorizontalAlignment align;
    private final Stereotype stereotype;
    private final ILeaf leaf;
    private final Style style;

    public TextBlock asBlockMemberImpl() {
        return new TextBlockLineBefore(TextBlockUtils.withMargin(this, 6.0, 4.0));
    }

    public MethodsOrFieldsArea(Display members, FontParam fontParam, ISkinParam skinParam, Stereotype stereotype, ILeaf leaf, Style style) {
        this(members, fontParam, skinParam, HorizontalAlignment.LEFT, stereotype, leaf, style);
    }

    public MethodsOrFieldsArea(Display members, FontParam fontParam, ISkinParam skinParam, HorizontalAlignment align, Stereotype stereotype, ILeaf leaf, Style style) {
        this.style = style;
        this.leaf = leaf;
        this.stereotype = stereotype;
        this.align = align;
        this.skinParam = skinParam;
        this.fontParam = fontParam;
        this.members = members;
    }

    private boolean hasSmallIcon() {
        if (this.skinParam.classAttributeIconSize() == 0) {
            return false;
        }
        for (CharSequence cs : this.members) {
            Member m;
            if (!(cs instanceof Member) || (m = (Member)cs).getVisibilityModifier() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double smallIcon = 0.0;
        if (this.hasSmallIcon()) {
            smallIcon = this.skinParam.getCircledCharacterRadius() + 3;
        }
        double x = 0.0;
        double y = 0.0;
        for (CharSequence cs : this.members) {
            TextBlock bloc = this.createTextBlock(cs);
            Dimension2D dim = bloc.calculateDimension(stringBounder);
            x = Math.max(dim.getWidth(), x);
            y += dim.getHeight();
        }
        return new Dimension2DDouble(x += smallIcon, y);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        Ports result = new Ports();
        double y = 0.0;
        Election election = new Election();
        for (CharSequence cs : this.members) {
            if (cs instanceof Member) {
                Member m = (Member)cs;
                election.addCandidate(m.getDisplay(false), m);
                continue;
            }
            election.addCandidate(cs.toString(), cs);
        }
        Map<CharSequence, String> memberWithPort = election.getAllElected(this.leaf.getPortShortNames());
        for (CharSequence cs : this.members) {
            TextBlock bloc = this.createTextBlock(cs);
            Dimension2D dim = bloc.calculateDimension(stringBounder);
            String port = memberWithPort.get(cs);
            if (port != null) {
                result.add(port, y, dim.getHeight());
            }
            y += dim.getHeight();
        }
        return result;
    }

    private TextBlock createTextBlock(CharSequence cs) {
        FontConfiguration config = this.style != null ? new FontConfiguration(this.skinParam, this.style) : new FontConfiguration(this.skinParam, this.fontParam, this.stereotype);
        if (cs instanceof Member) {
            Member m = (Member)cs;
            boolean withVisibilityChar = this.skinParam.classAttributeIconSize() == 0;
            String s = m.getDisplay(withVisibilityChar);
            if (withVisibilityChar && s.startsWith("#")) {
                s = CharHidder.addTileAtBegin(s);
            }
            if (m.isAbstract()) {
                config = config.italic();
            }
            if (m.isStatic()) {
                config = config.underline();
            }
            TextBlock bloc = Display.getWithNewlines(s).create8(config, this.align, this.skinParam, CreoleMode.SIMPLE_LINE, this.skinParam.wrapWidth());
            bloc = TextBlockUtils.fullInnerPosition(bloc, m.getDisplay(false));
            return new TextBlockTracer(m, bloc);
        }
        TextBlock bloc = Display.getWithNewlines(cs.toString()).create8(config, this.align, this.skinParam, CreoleMode.SIMPLE_LINE, this.skinParam.wrapWidth());
        return bloc;
    }

    private TextBlock getUBlock(VisibilityModifier modifier, Url url) {
        if (modifier == null) {
            return new AbstractTextBlock(){

                @Override
                public void drawU(UGraphic ug) {
                }

                @Override
                public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                    return null;
                }

                @Override
                public Dimension2D calculateDimension(StringBounder stringBounder) {
                    return new Dimension2DDouble(1.0, 1.0);
                }
            };
        }
        HColor back = modifier.getBackground() == null ? null : this.rose.getHtmlColor(this.skinParam, modifier.getBackground());
        HColor fore = this.rose.getHtmlColor(this.skinParam, modifier.getForeground());
        TextBlock uBlock = modifier.getUBlock(this.skinParam.classAttributeIconSize(), fore, back, url != null);
        return TextBlockWithUrl.withUrl(uBlock, url);
    }

    public boolean contains(String member) {
        for (CharSequence cs : this.members) {
            Member att = (Member)cs;
            if (!att.getDisplay(false).startsWith(member)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        ULayoutGroup group = this.getLayout(stringBounder);
        Dimension2D dim = this.calculateDimension(stringBounder);
        return group.getInnerPosition(member, dim.getWidth(), dim.getHeight(), stringBounder);
    }

    private ULayoutGroup getLayout(StringBounder stringBounder) {
        ULayoutGroup group;
        if (this.hasSmallIcon()) {
            group = new ULayoutGroup(new PlacementStrategyVisibility(stringBounder, this.skinParam.getCircledCharacterRadius() + 3));
            for (CharSequence cs : this.members) {
                Member att = (Member)cs;
                TextBlock bloc = this.createTextBlock(att);
                VisibilityModifier modifier = att.getVisibilityModifier();
                group.add(this.getUBlock(modifier, att.getUrl()));
                group.add(bloc);
            }
        } else {
            AbstractPlacementStrategy placementStrategy = this.align == HorizontalAlignment.LEFT ? new PlacementStrategyY1Y2Left(stringBounder) : (this.align == HorizontalAlignment.CENTER ? new PlacementStrategyY1Y2Center(stringBounder) : new PlacementStrategyY1Y2Left(stringBounder));
            group = new ULayoutGroup(placementStrategy);
            for (CharSequence cs : this.members) {
                TextBlock bloc = this.createTextBlock(cs);
                group.add(bloc);
            }
        }
        return group;
    }

    @Override
    public void drawU(UGraphic ug) {
        ULayoutGroup group = this.getLayout(ug.getStringBounder());
        Dimension2D dim = this.calculateDimension(ug.getStringBounder());
        group.drawU(ug, dim.getWidth(), dim.getHeight());
    }

    static class TextBlockTracer
    extends AbstractTextBlock
    implements TextBlock {
        private final TextBlock bloc;
        private final Url url;

        public TextBlockTracer(Member m, TextBlock bloc) {
            this.bloc = bloc;
            this.url = m.getUrl();
        }

        @Override
        public void drawU(UGraphic ug) {
            if (this.url != null) {
                ug.startUrl(this.url);
            }
            this.bloc.drawU(ug);
            if (this.url != null) {
                ug.closeUrl();
            }
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            Dimension2D dim = this.bloc.calculateDimension(stringBounder);
            return dim;
        }

        @Override
        public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
            return this.bloc.getInnerPosition(member, stringBounder, strategy);
        }
    }
}

