/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.gitlog;

import h.ST_Agedgeinfo_t;
import h.ST_bezier;
import h.ST_pointf;
import h.ST_splines;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.jsondiagram.Arrow;
import net.sourceforge.plantuml.jsondiagram.Mirror;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class GitCurve {
    private final List<Point2D> points = new ArrayList<Point2D>();
    private final Mirror xMirror;
    private final Point2D sp;
    private final Point2D ep;

    public GitCurve(ST_Agedgeinfo_t data, Mirror xMirror) {
        this.xMirror = xMirror;
        ST_splines splines = data.spl;
        if (splines.size != 1) {
            throw new IllegalStateException();
        }
        ST_bezier beziers = splines.list.get__(0);
        for (int i = 0; i < beziers.size; ++i) {
            Point2D pt = this.getPoint(splines, i);
            this.points.add(pt);
        }
        this.sp = beziers.sp.x == 0.0 && beziers.sp.y == 0.0 ? null : new Point2D.Double(beziers.sp.x, beziers.sp.y);
        this.ep = beziers.ep.x == 0.0 && beziers.ep.y == 0.0 ? null : new Point2D.Double(beziers.ep.x, beziers.ep.y);
    }

    private Point2D getPoint(ST_splines splines, int i) {
        ST_bezier beziers = splines.list.get__(0);
        ST_pointf pt = beziers.list.get__(i);
        return new Point2D.Double(pt.x, pt.y);
    }

    public void drawCurve(HColor color, UGraphic ug) {
        ug = ug.apply(new UStroke(2.0, 2.0, 1.0));
        UPath path = new UPath();
        path.moveTo(this.xMirror.invGit(this.points.get(0)));
        for (int i = 1; i < this.points.size(); i += 3) {
            Point2D pt2 = this.xMirror.invGit(this.points.get(i));
            Point2D pt3 = this.xMirror.invGit(this.points.get(i + 1));
            Point2D pt4 = this.xMirror.invGit(this.points.get(i + 2));
            path.cubicTo(pt2, pt3, pt4);
        }
        ug.draw(path);
        if (this.ep != null) {
            Point2D last = this.xMirror.invGit(this.points.get(this.points.size() - 1));
            Point2D trueEp = this.xMirror.invGit(this.ep);
            new Arrow(last, trueEp).drawArrow(ug.apply(color.bg()));
        }
    }
}

