/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.ComplementClose;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Verbs;
import net.sourceforge.plantuml.project.time.DayOfWeek;

public class SubjectDayOfWeek
implements Subject {
    @Override
    public IRegex toRegex() {
        return new RegexLeaf("SUBJECT", "(" + DayOfWeek.getRegexString() + ")");
    }

    @Override
    public Failable<? extends Object> getMe(GanttDiagram project, RegexResult arg) {
        String s = arg.get("SUBJECT", 0);
        return Failable.ok(DayOfWeek.fromString(s));
    }

    @Override
    public Collection<? extends SentenceSimple> getSentences() {
        return Arrays.asList(new AreClose());
    }

    class AreClose
    extends SentenceSimple {
        public AreClose() {
            super(SubjectDayOfWeek.this, Verbs.are(), new ComplementClose());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            DayOfWeek day = (DayOfWeek)((Object)subject);
            project.closeDayOfWeek(day);
            return CommandExecutionResult.ok();
        }
    }
}

