/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.comp;

import java.util.List;
import net.sourceforge.plantuml.ugraphic.comp.PiecewiseAffineTransform;
import net.sourceforge.plantuml.ugraphic.comp.Slot;
import net.sourceforge.plantuml.ugraphic.comp.SlotSet;

public class CompressionTransform
implements PiecewiseAffineTransform {
    private final List<Slot> all;

    public CompressionTransform(SlotSet slotSet) {
        this.all = slotSet.getSlots();
    }

    @Override
    public double transform(double v) {
        return v - this.getCompressDelta(v);
    }

    private double getCompressDelta(double v) {
        double result = 0.0;
        for (Slot s : this.all) {
            if (s.getStart() > v) continue;
            if (v > s.getEnd()) {
                result += s.size();
                continue;
            }
            result += v - s.getStart();
        }
        return result;
    }
}

