/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.TransientSolrCoreCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientSolrCoreCacheDefault
extends TransientSolrCoreCache {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private int cacheSize = Integer.MAX_VALUE;
    protected CoreContainer coreContainer;
    protected final Map<String, CoreDescriptor> transientDescriptors = new LinkedHashMap<String, CoreDescriptor>();
    protected Map<String, SolrCore> transientCores = new LinkedHashMap<String, SolrCore>();

    public TransientSolrCoreCacheDefault(CoreContainer container) {
        this.coreContainer = container;
        NodeConfig cfg = container.getNodeConfig();
        if (cfg.getTransientCachePluginInfo() == null) {
            this.cacheSize = cfg.getTransientCacheSize();
        } else {
            NamedList args = cfg.getTransientCachePluginInfo().initArgs;
            Object obj = args.get("transientCacheSize");
            if (obj != null) {
                this.cacheSize = (Integer)obj;
            }
        }
        this.doInit();
    }

    private void doInit() {
        NodeConfig cfg = this.coreContainer.getNodeConfig();
        if (cfg.getTransientCachePluginInfo() == null) {
            this.cacheSize = cfg.getTransientCacheSize();
        } else {
            NamedList args = cfg.getTransientCachePluginInfo().initArgs;
            Object obj = args.get("transientCacheSize");
            if (obj != null) {
                this.cacheSize = (Integer)obj;
            }
        }
        log.info("Allocating transient cache for {} transient cores", (Object)this.cacheSize);
        if (this.cacheSize < 0) {
            this.cacheSize = Integer.MAX_VALUE;
        }
        this.transientCores = new LinkedHashMap<String, SolrCore>(Math.min(this.cacheSize, 1000), 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, SolrCore> eldest) {
                if (this.size() > TransientSolrCoreCacheDefault.this.cacheSize) {
                    SolrCore coreToClose = eldest.getValue();
                    if (log.isInfoEnabled()) {
                        log.info("Closing transient core [{}]", (Object)coreToClose.getName());
                    }
                    TransientSolrCoreCacheDefault.this.coreContainer.queueCoreToClose(coreToClose);
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public Collection<SolrCore> prepareForShutdown() {
        ArrayList<SolrCore> ret = new ArrayList<SolrCore>(this.transientCores.values());
        this.transientCores.clear();
        return ret;
    }

    @Override
    public CoreContainer getContainer() {
        return this.coreContainer;
    }

    @Override
    public SolrCore addCore(String name, SolrCore core) {
        return this.transientCores.put(name, core);
    }

    @Override
    public Set<String> getAllCoreNames() {
        return this.transientDescriptors.keySet();
    }

    @Override
    public Set<String> getLoadedCoreNames() {
        return this.transientCores.keySet();
    }

    @Override
    public SolrCore removeCore(String name) {
        return this.transientCores.remove(name);
    }

    @Override
    public SolrCore getCore(String name) {
        return this.transientCores.get(name);
    }

    @Override
    public boolean containsCore(String name) {
        return this.transientCores.containsKey(name);
    }

    @Override
    public void addTransientDescriptor(String rawName, CoreDescriptor cd) {
        this.transientDescriptors.put(rawName, cd);
    }

    @Override
    public CoreDescriptor getTransientDescriptor(String name) {
        return this.transientDescriptors.get(name);
    }

    @Override
    public CoreDescriptor removeTransientDescriptor(String name) {
        return this.transientDescriptors.remove(name);
    }

    @Override
    public int getStatus(String coreName) {
        return 0;
    }

    @Override
    public void setStatus(String coreName, int status) {
    }
}

