// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from AT91SAM9X35.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

// +build sam,at91sam9x35

// Atmel AT91SAM9X35 device: ARM926EJ Embedded Microprocessor Unit, 400MHz, LCD, Touchscreen, Ethernet, Dual CAN, HS USB, LPDDR/DDR2/MLC NAND support, 217 Pins (refer to http://www.atmel.com/devices/SAM9X35.aspx for more)
//

package sam

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "AT91SAM9X35"
)

// Interrupt numbers.
const (
	IRQ_FIQ    = 0  // Advanced Interrupt Controller
	IRQ_DBGU   = 1  // Debug Unit
	IRQ_PIOA   = 2  // Parallel Input/Output Controller A
	IRQ_PIOC   = 3  // Parallel Input/Output Controller C
	IRQ_SMD    = 4  // Software Modem Device
	IRQ_USART0 = 5  // Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART1 = 6  // Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART2 = 7  // Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_TWI0   = 9  // Two-wire Interface 0
	IRQ_TWI1   = 10 // Two-wire Interface 1
	IRQ_TWI2   = 11 // Two-wire Interface 2
	IRQ_HSMCI0 = 12 // High Speed MultiMedia Card Interface 0
	IRQ_SPI0   = 13 // Serial Peripheral Interface 0
	IRQ_SPI1   = 14 // Serial Peripheral Interface 1
	IRQ_UART0  = 15 // Universal Asynchronous Receiver Transmitter 0
	IRQ_UART1  = 16 // Universal Asynchronous Receiver Transmitter 1
	IRQ_TC0    = 17 // Timer Counter 0
	IRQ_PWM    = 18 // Pulse Width Modulation Controller
	IRQ_ADC    = 19 // Analog-to-Digital Converter
	IRQ_DMAC0  = 20 // DMA Controller 0
	IRQ_DMAC1  = 21 // DMA Controller 1
	IRQ_UDPHS  = 23 // USB High Speed Device Port
	IRQ_EMAC   = 24 // Ethernet MAC 10/100
	IRQ_LCDC   = 25 // LCD Controller
	IRQ_HSMCI1 = 26 // High Speed MultiMedia Card Interface 1
	IRQ_SSC    = 28 // Synchronous Serial Controller
	IRQ_CAN0   = 29 // Controller Area Network 0
	IRQ_CAN1   = 30 // Controller Area Network 1
	IRQ_IRQ    = 31 // Advanced Interrupt Controller
	IRQ_max    = 31 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_FIQ, "FIQ_IRQHandler")
	_ = interrupt.Register(IRQ_DBGU, "DBGU_IRQHandler")
	_ = interrupt.Register(IRQ_PIOA, "PIOA_IRQHandler")
	_ = interrupt.Register(IRQ_PIOC, "PIOC_IRQHandler")
	_ = interrupt.Register(IRQ_SMD, "SMD_IRQHandler")
	_ = interrupt.Register(IRQ_USART0, "USART0_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_TWI0, "TWI0_IRQHandler")
	_ = interrupt.Register(IRQ_TWI1, "TWI1_IRQHandler")
	_ = interrupt.Register(IRQ_TWI2, "TWI2_IRQHandler")
	_ = interrupt.Register(IRQ_HSMCI0, "HSMCI0_IRQHandler")
	_ = interrupt.Register(IRQ_SPI0, "SPI0_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_UART0, "UART0_IRQHandler")
	_ = interrupt.Register(IRQ_UART1, "UART1_IRQHandler")
	_ = interrupt.Register(IRQ_TC0, "TC0_IRQHandler")
	_ = interrupt.Register(IRQ_PWM, "PWM_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC0, "DMAC0_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC1, "DMAC1_IRQHandler")
	_ = interrupt.Register(IRQ_UDPHS, "UDPHS_IRQHandler")
	_ = interrupt.Register(IRQ_EMAC, "EMAC_IRQHandler")
	_ = interrupt.Register(IRQ_LCDC, "LCDC_IRQHandler")
	_ = interrupt.Register(IRQ_HSMCI1, "HSMCI1_IRQHandler")
	_ = interrupt.Register(IRQ_SSC, "SSC_IRQHandler")
	_ = interrupt.Register(IRQ_CAN0, "CAN0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1, "CAN1_IRQHandler")
	_ = interrupt.Register(IRQ_IRQ, "IRQ_IRQHandler")
)

// Peripherals.
var (
	SMD      = (*SMD_Type)(unsafe.Pointer(uintptr(0x400000)))      // Software Modem Device
	SPI0     = (*SPI_Type)(unsafe.Pointer(uintptr(0xf0000000)))    // Serial Peripheral Interface 0
	SPI1     = (*SPI_Type)(unsafe.Pointer(uintptr(0xf0004000)))    // Serial Peripheral Interface 1
	HSMCI0   = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xf0008000)))  // High Speed MultiMedia Card Interface 0
	HSMCI1   = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xf000c000)))  // High Speed MultiMedia Card Interface 1
	SSC      = (*SSC_Type)(unsafe.Pointer(uintptr(0xf0010000)))    // Synchronous Serial Controller
	CAN0     = (*CAN_Type)(unsafe.Pointer(uintptr(0xf8000000)))    // Controller Area Network 0
	CAN1     = (*CAN_Type)(unsafe.Pointer(uintptr(0xf8004000)))    // Controller Area Network 1
	TC0      = (*TC_Type)(unsafe.Pointer(uintptr(0xf8008000)))     // Timer Counter 0
	TC1      = (*TC_Type)(unsafe.Pointer(uintptr(0xf800c000)))     // Timer Counter 1
	TWI0     = (*TWI_Type)(unsafe.Pointer(uintptr(0xf8010000)))    // Two-wire Interface 0
	TWI1     = (*TWI_Type)(unsafe.Pointer(uintptr(0xf8014000)))    // Two-wire Interface 1
	TWI2     = (*TWI_Type)(unsafe.Pointer(uintptr(0xf8018000)))    // Two-wire Interface 2
	USART0   = (*USART_Type)(unsafe.Pointer(uintptr(0xf801c000)))  // Universal Synchronous Asynchronous Receiver Transmitter 0
	USART1   = (*USART_Type)(unsafe.Pointer(uintptr(0xf8020000)))  // Universal Synchronous Asynchronous Receiver Transmitter 1
	USART2   = (*USART_Type)(unsafe.Pointer(uintptr(0xf8024000)))  // Universal Synchronous Asynchronous Receiver Transmitter 2
	EMAC     = (*EMAC_Type)(unsafe.Pointer(uintptr(0xf802c000)))   // Ethernet MAC 10/100
	PWM      = (*PWM_Type)(unsafe.Pointer(uintptr(0xf8034000)))    // Pulse Width Modulation Controller
	LCDC     = (*LCDC_Type)(unsafe.Pointer(uintptr(0xf8038000)))   // LCD Controller
	UDPHS    = (*UDPHS_Type)(unsafe.Pointer(uintptr(0xf803c000)))  // USB High Speed Device Port
	UART0    = (*UART_Type)(unsafe.Pointer(uintptr(0xf8040000)))   // Universal Asynchronous Receiver Transmitter 0
	UART1    = (*UART_Type)(unsafe.Pointer(uintptr(0xf8044000)))   // Universal Asynchronous Receiver Transmitter 1
	ADC      = (*ADC_Type)(unsafe.Pointer(uintptr(0xf804c000)))    // Analog-to-Digital Converter
	MATRIX   = (*MATRIX_Type)(unsafe.Pointer(uintptr(0xffffde00))) // AHB Bus Matrix
	PMECC    = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe000)))    // Programmable Multibit Error Corrected Code Controller
	PMERRLOC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe600)))    // Programmable Multibit ECC Error Location
	DDRSDRC  = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe800)))    // DDR_SDR SDRAM Controller
	SMC      = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffea00)))    // Static Memory Controller
	DMAC0    = (*DMAC_Type)(unsafe.Pointer(uintptr(0xffffec00)))   // DMA Controller 0
	DMAC1    = (*DMAC_Type)(unsafe.Pointer(uintptr(0xffffee00)))   // DMA Controller 1
	AIC      = (*AIC_Type)(unsafe.Pointer(uintptr(0xfffff000)))    // Advanced Interrupt Controller
	DBGU     = (*DBGU_Type)(unsafe.Pointer(uintptr(0xfffff200)))   // Debug Unit
	PIOA     = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff400)))    // Parallel Input/Output Controller A
	PIOB     = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff600)))    // Parallel Input/Output Controller B
	PIOC     = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff800)))    // Parallel Input/Output Controller C
	PIOD     = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffffa00)))    // Parallel Input/Output Controller D
	PMC      = (*PMC_Type)(unsafe.Pointer(uintptr(0xfffffc00)))    // Power Management Controller
	RSTC     = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe00)))   // Reset Controller
	SHDWC    = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe10)))   // Shutdown Controller
	PIT      = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe30)))   // Periodic Interval Timer
	WDT      = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe40)))   // Watchdog Timer
	SCKC     = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe50)))   // Slow Clock Controller
	BSC      = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe54)))   // Boot Sequence Controller
	GPBR     = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe60)))   // General Purpose Backup Register
	RTC      = (*RTC_Type)(unsafe.Pointer(uintptr(0xfffffeb0)))    // Real-time Clock
)

// Software Modem Device
type SMD_Type struct {
}

// Serial Peripheral Interface 0
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// High Speed MultiMedia Card Interface 0
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	DMA   volatile.Register32 // 0x50
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [276]byte
	FIFO  [256]volatile.Register32 // 0x200
}

// Synchronous Serial Controller
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// Controller Area Network 0
type CAN_Type struct {
	MR      volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	IDR     volatile.Register32 // 0x8
	IMR     volatile.Register32 // 0xC
	SR      volatile.Register32 // 0x10
	BR      volatile.Register32 // 0x14
	TIM     volatile.Register32 // 0x18
	TIMESTP volatile.Register32 // 0x1C
	ECR     volatile.Register32 // 0x20
	TCR     volatile.Register32 // 0x24
	ACR     volatile.Register32 // 0x28
	_       [184]byte
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [276]byte
	MMR0    volatile.Register32 // 0x200
	MAM0    volatile.Register32 // 0x204
	MID0    volatile.Register32 // 0x208
	MFID0   volatile.Register32 // 0x20C
	MSR0    volatile.Register32 // 0x210
	MDL0    volatile.Register32 // 0x214
	MDH0    volatile.Register32 // 0x218
	MCR0    volatile.Register32 // 0x21C
	MMR1    volatile.Register32 // 0x220
	MAM1    volatile.Register32 // 0x224
	MID1    volatile.Register32 // 0x228
	MFID1   volatile.Register32 // 0x22C
	MSR1    volatile.Register32 // 0x230
	MDL1    volatile.Register32 // 0x234
	MDH1    volatile.Register32 // 0x238
	MCR1    volatile.Register32 // 0x23C
	MMR2    volatile.Register32 // 0x240
	MAM2    volatile.Register32 // 0x244
	MID2    volatile.Register32 // 0x248
	MFID2   volatile.Register32 // 0x24C
	MSR2    volatile.Register32 // 0x250
	MDL2    volatile.Register32 // 0x254
	MDH2    volatile.Register32 // 0x258
	MCR2    volatile.Register32 // 0x25C
	MMR3    volatile.Register32 // 0x260
	MAM3    volatile.Register32 // 0x264
	MID3    volatile.Register32 // 0x268
	MFID3   volatile.Register32 // 0x26C
	MSR3    volatile.Register32 // 0x270
	MDL3    volatile.Register32 // 0x274
	MDH3    volatile.Register32 // 0x278
	MCR3    volatile.Register32 // 0x27C
	MMR4    volatile.Register32 // 0x280
	MAM4    volatile.Register32 // 0x284
	MID4    volatile.Register32 // 0x288
	MFID4   volatile.Register32 // 0x28C
	MSR4    volatile.Register32 // 0x290
	MDL4    volatile.Register32 // 0x294
	MDH4    volatile.Register32 // 0x298
	MCR4    volatile.Register32 // 0x29C
	MMR5    volatile.Register32 // 0x2A0
	MAM5    volatile.Register32 // 0x2A4
	MID5    volatile.Register32 // 0x2A8
	MFID5   volatile.Register32 // 0x2AC
	MSR5    volatile.Register32 // 0x2B0
	MDL5    volatile.Register32 // 0x2B4
	MDH5    volatile.Register32 // 0x2B8
	MCR5    volatile.Register32 // 0x2BC
	MMR6    volatile.Register32 // 0x2C0
	MAM6    volatile.Register32 // 0x2C4
	MID6    volatile.Register32 // 0x2C8
	MFID6   volatile.Register32 // 0x2CC
	MSR6    volatile.Register32 // 0x2D0
	MDL6    volatile.Register32 // 0x2D4
	MDH6    volatile.Register32 // 0x2D8
	MCR6    volatile.Register32 // 0x2DC
	MMR7    volatile.Register32 // 0x2E0
	MAM7    volatile.Register32 // 0x2E4
	MID7    volatile.Register32 // 0x2E8
	MFID7   volatile.Register32 // 0x2EC
	MSR7    volatile.Register32 // 0x2F0
	MDL7    volatile.Register32 // 0x2F4
	MDH7    volatile.Register32 // 0x2F8
	MCR7    volatile.Register32 // 0x2FC
}

// Timer Counter 0
type TC_Type struct {
	CCR0 volatile.Register32 // 0x0
	CMR0 volatile.Register32 // 0x4
	_    [8]byte
	CV0  volatile.Register32 // 0x10
	RA0  volatile.Register32 // 0x14
	RB0  volatile.Register32 // 0x18
	RC0  volatile.Register32 // 0x1C
	SR0  volatile.Register32 // 0x20
	IER0 volatile.Register32 // 0x24
	IDR0 volatile.Register32 // 0x28
	IMR0 volatile.Register32 // 0x2C
	_    [16]byte
	CCR1 volatile.Register32 // 0x40
	CMR1 volatile.Register32 // 0x44
	_    [8]byte
	CV1  volatile.Register32 // 0x50
	RA1  volatile.Register32 // 0x54
	RB1  volatile.Register32 // 0x58
	RC1  volatile.Register32 // 0x5C
	SR1  volatile.Register32 // 0x60
	IER1 volatile.Register32 // 0x64
	IDR1 volatile.Register32 // 0x68
	IMR1 volatile.Register32 // 0x6C
	_    [16]byte
	CCR2 volatile.Register32 // 0x80
	CMR2 volatile.Register32 // 0x84
	_    [8]byte
	CV2  volatile.Register32 // 0x90
	RA2  volatile.Register32 // 0x94
	RB2  volatile.Register32 // 0x98
	RC2  volatile.Register32 // 0x9C
	SR2  volatile.Register32 // 0xA0
	IER2 volatile.Register32 // 0xA4
	IDR2 volatile.Register32 // 0xA8
	IMR2 volatile.Register32 // 0xAC
	_    [16]byte
	BCR  volatile.Register32 // 0xC0
	BMR  volatile.Register32 // 0xC4
}

// Two-wire Interface 0
type TWI_Type struct {
	CR           volatile.Register32 // 0x0
	MMR          volatile.Register32 // 0x4
	SMR          volatile.Register32 // 0x8
	IADR         volatile.Register32 // 0xC
	CWGR         volatile.Register32 // 0x10
	_            [12]byte
	SR           volatile.Register32 // 0x20
	IER          volatile.Register32 // 0x24
	IDR          volatile.Register32 // 0x28
	IMR          volatile.Register32 // 0x2C
	RHR          volatile.Register32 // 0x30
	THR          volatile.Register32 // 0x34
	_            [172]byte
	WPROT_MODE   volatile.Register32 // 0xE4
	WPROT_STATUS volatile.Register32 // 0xE8
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	IER   volatile.Register32 // 0x8
	IDR   volatile.Register32 // 0xC
	IMR   volatile.Register32 // 0x10
	CSR   volatile.Register32 // 0x14
	RHR   volatile.Register32 // 0x18
	THR   volatile.Register32 // 0x1C
	BRGR  volatile.Register32 // 0x20
	RTOR  volatile.Register32 // 0x24
	TTGR  volatile.Register32 // 0x28
	_     [20]byte
	FIDI  volatile.Register32 // 0x40
	NER   volatile.Register32 // 0x44
	_     [4]byte
	IF    volatile.Register32 // 0x4C
	MAN   volatile.Register32 // 0x50
	LINMR volatile.Register32 // 0x54
	LINIR volatile.Register32 // 0x58
	_     [136]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// Ethernet MAC 10/100
type EMAC_Type struct {
	NCR   volatile.Register32 // 0x0
	NCFGR volatile.Register32 // 0x4
	NSR   volatile.Register32 // 0x8
	_     [8]byte
	TSR   volatile.Register32 // 0x14
	RBQP  volatile.Register32 // 0x18
	TBQP  volatile.Register32 // 0x1C
	RSR   volatile.Register32 // 0x20
	ISR   volatile.Register32 // 0x24
	IER   volatile.Register32 // 0x28
	IDR   volatile.Register32 // 0x2C
	IMR   volatile.Register32 // 0x30
	MAN   volatile.Register32 // 0x34
	PTR   volatile.Register32 // 0x38
	PFR   volatile.Register32 // 0x3C
	FTO   volatile.Register32 // 0x40
	SCF   volatile.Register32 // 0x44
	MCF   volatile.Register32 // 0x48
	FRO   volatile.Register32 // 0x4C
	FCSE  volatile.Register32 // 0x50
	ALE   volatile.Register32 // 0x54
	DTF   volatile.Register32 // 0x58
	LCOL  volatile.Register32 // 0x5C
	ECOL  volatile.Register32 // 0x60
	TUND  volatile.Register32 // 0x64
	CSE   volatile.Register32 // 0x68
	RRE   volatile.Register32 // 0x6C
	ROV   volatile.Register32 // 0x70
	RSE   volatile.Register32 // 0x74
	ELE   volatile.Register32 // 0x78
	RJA   volatile.Register32 // 0x7C
	USF   volatile.Register32 // 0x80
	STE   volatile.Register32 // 0x84
	RLE   volatile.Register32 // 0x88
	_     [4]byte
	HRB   volatile.Register32 // 0x90
	HRT   volatile.Register32 // 0x94
	SA1B  volatile.Register32 // 0x98
	SA1T  volatile.Register32 // 0x9C
	SA2B  volatile.Register32 // 0xA0
	SA2T  volatile.Register32 // 0xA4
	SA3B  volatile.Register32 // 0xA8
	SA3T  volatile.Register32 // 0xAC
	SA4B  volatile.Register32 // 0xB0
	SA4T  volatile.Register32 // 0xB4
	TID   volatile.Register32 // 0xB8
	_     [4]byte
	USRIO volatile.Register32 // 0xC0
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	MR    volatile.Register32 // 0x0
	ENA   volatile.Register32 // 0x4
	DIS   volatile.Register32 // 0x8
	SR    volatile.Register32 // 0xC
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [480]byte
	CMR0  volatile.Register32 // 0x200
	CDTY0 volatile.Register32 // 0x204
	CPRD0 volatile.Register32 // 0x208
	CCNT0 volatile.Register32 // 0x20C
	CUPD0 volatile.Register32 // 0x210
	_     [12]byte
	CMR1  volatile.Register32 // 0x220
	CDTY1 volatile.Register32 // 0x224
	CPRD1 volatile.Register32 // 0x228
	CCNT1 volatile.Register32 // 0x22C
	CUPD1 volatile.Register32 // 0x230
	_     [12]byte
	CMR2  volatile.Register32 // 0x240
	CDTY2 volatile.Register32 // 0x244
	CPRD2 volatile.Register32 // 0x248
	CCNT2 volatile.Register32 // 0x24C
	CUPD2 volatile.Register32 // 0x250
	_     [12]byte
	CMR3  volatile.Register32 // 0x260
	CDTY3 volatile.Register32 // 0x264
	CPRD3 volatile.Register32 // 0x268
	CCNT3 volatile.Register32 // 0x26C
	CUPD3 volatile.Register32 // 0x270
}

// LCD Controller
type LCDC_Type struct {
	LCDCFG0  volatile.Register32 // 0x0
	LCDCFG1  volatile.Register32 // 0x4
	LCDCFG2  volatile.Register32 // 0x8
	LCDCFG3  volatile.Register32 // 0xC
	LCDCFG4  volatile.Register32 // 0x10
	LCDCFG5  volatile.Register32 // 0x14
	LCDCFG6  volatile.Register32 // 0x18
	_        [4]byte
	LCDEN    volatile.Register32 // 0x20
	LCDDIS   volatile.Register32 // 0x24
	LCDSR    volatile.Register32 // 0x28
	LCDIER   volatile.Register32 // 0x2C
	LCDIDR   volatile.Register32 // 0x30
	LCDIMR   volatile.Register32 // 0x34
	LCDISR   volatile.Register32 // 0x38
	_        [4]byte
	BASECHER volatile.Register32 // 0x40
	BASECHDR volatile.Register32 // 0x44
	BASECHSR volatile.Register32 // 0x48
	BASEIER  volatile.Register32 // 0x4C
	BASEIDR  volatile.Register32 // 0x50
	BASEIMR  volatile.Register32 // 0x54
	BASEISR  volatile.Register32 // 0x58
	BASEHEAD volatile.Register32 // 0x5C
	BASEADDR volatile.Register32 // 0x60
	BASECTRL volatile.Register32 // 0x64
	BASENEXT volatile.Register32 // 0x68
	BASECFG0 volatile.Register32 // 0x6C
	BASECFG1 volatile.Register32 // 0x70
	BASECFG2 volatile.Register32 // 0x74
	BASECFG3 volatile.Register32 // 0x78
	BASECFG4 volatile.Register32 // 0x7C
	_        [128]byte
	OVRCHER1 volatile.Register32 // 0x100
	OVRCHDR1 volatile.Register32 // 0x104
	OVRCHSR1 volatile.Register32 // 0x108
	OVRIER1  volatile.Register32 // 0x10C
	OVRIDR1  volatile.Register32 // 0x110
	OVRIMR1  volatile.Register32 // 0x114
	OVRISR1  volatile.Register32 // 0x118
	OVRHEAD1 volatile.Register32 // 0x11C
	OVRADDR1 volatile.Register32 // 0x120
	OVRCTRL1 volatile.Register32 // 0x124
	OVRNEXT1 volatile.Register32 // 0x128
	OVR1CFG0 volatile.Register32 // 0x12C
	OVR1CFG1 volatile.Register32 // 0x130
	OVR1CFG2 volatile.Register32 // 0x134
	OVR1CFG3 volatile.Register32 // 0x138
	OVR1CFG4 volatile.Register32 // 0x13C
	OVR1CFG5 volatile.Register32 // 0x140
	OVR1CFG6 volatile.Register32 // 0x144
	OVR1CFG7 volatile.Register32 // 0x148
	OVR1CFG8 volatile.Register32 // 0x14C
	OVR1CFG9 volatile.Register32 // 0x150
	_        [300]byte
	HEOCHER  volatile.Register32 // 0x280
	HEOCHDR  volatile.Register32 // 0x284
	HEOCHSR  volatile.Register32 // 0x288
	HEOIER   volatile.Register32 // 0x28C
	HEOIDR   volatile.Register32 // 0x290
	HEOIMR   volatile.Register32 // 0x294
	HEOISR   volatile.Register32 // 0x298
	HEOHEAD  volatile.Register32 // 0x29C
	HEOADDR  volatile.Register32 // 0x2A0
	HEOCTRL  volatile.Register32 // 0x2A4
	HEONEXT  volatile.Register32 // 0x2A8
	HEOUHEAD volatile.Register32 // 0x2AC
	HEOUADDR volatile.Register32 // 0x2B0
	HEOUCTRL volatile.Register32 // 0x2B4
	HEOUNEXT volatile.Register32 // 0x2B8
	HEOVHEAD volatile.Register32 // 0x2BC
	HEOVADDR volatile.Register32 // 0x2C0
	HEOVCTRL volatile.Register32 // 0x2C4
	HEOVNEXT volatile.Register32 // 0x2C8
	HEOCFG0  volatile.Register32 // 0x2CC
	HEOCFG1  volatile.Register32 // 0x2D0
	HEOCFG2  volatile.Register32 // 0x2D4
	HEOCFG3  volatile.Register32 // 0x2D8
	HEOCFG4  volatile.Register32 // 0x2DC
	HEOCFG5  volatile.Register32 // 0x2E0
	HEOCFG6  volatile.Register32 // 0x2E4
	HEOCFG7  volatile.Register32 // 0x2E8
	HEOCFG8  volatile.Register32 // 0x2EC
	HEOCFG9  volatile.Register32 // 0x2F0
	HEOCFG10 volatile.Register32 // 0x2F4
	HEOCFG11 volatile.Register32 // 0x2F8
	HEOCFG12 volatile.Register32 // 0x2FC
	HEOCFG13 volatile.Register32 // 0x300
	HEOCFG14 volatile.Register32 // 0x304
	HEOCFG15 volatile.Register32 // 0x308
	HEOCFG16 volatile.Register32 // 0x30C
	_        [48]byte
	HCRCHER  volatile.Register32 // 0x340
	HCRCHDR  volatile.Register32 // 0x344
	HCRCHSR  volatile.Register32 // 0x348
	HCRIER   volatile.Register32 // 0x34C
	HCRIDR   volatile.Register32 // 0x350
	HCRIMR   volatile.Register32 // 0x354
	HCRISR   volatile.Register32 // 0x358
	HCRHEAD  volatile.Register32 // 0x35C
	HCRADDR  volatile.Register32 // 0x360
	HCRCTRL  volatile.Register32 // 0x364
	HCRNEXT  volatile.Register32 // 0x368
	HCRCFG0  volatile.Register32 // 0x36C
	HCRCFG1  volatile.Register32 // 0x370
	HCRCFG2  volatile.Register32 // 0x374
	HCRCFG3  volatile.Register32 // 0x378
	HCRCFG4  volatile.Register32 // 0x37C
	_        [4]byte
	HCRCFG6  volatile.Register32 // 0x384
	HCRCFG7  volatile.Register32 // 0x388
	HCRCFG8  volatile.Register32 // 0x38C
	HCRCFG9  volatile.Register32 // 0x390
	_        [108]byte
	BASECLUT [256]volatile.Register32 // 0x400
	OVR1CLUT [256]volatile.Register32 // 0x800
	_        [1024]byte
	HEOCLUT  [256]volatile.Register32 // 0x1000
	HCRCLUT  [256]volatile.Register32 // 0x1400
	_        [2028]byte
	ADDRSIZE volatile.Register32    // 0x1FEC
	IPNAME   [2]volatile.Register32 // 0x1FF0
	FEATURES volatile.Register32    // 0x1FF8
	VERSION  volatile.Register32    // 0x1FFC
}

// USB High Speed Device Port
type UDPHS_Type struct {
	CTRL        volatile.Register32 // 0x0
	FNUM        volatile.Register32 // 0x4
	_           [8]byte
	IEN         volatile.Register32 // 0x10
	INTSTA      volatile.Register32 // 0x14
	CLRINT      volatile.Register32 // 0x18
	EPTRST      volatile.Register32 // 0x1C
	_           [192]byte
	TST         volatile.Register32 // 0xE0
	_           [28]byte
	EPTCFG0     volatile.Register32 // 0x100
	EPTCTLENB0  volatile.Register32 // 0x104
	EPTCTLDIS0  volatile.Register32 // 0x108
	EPTCTL0     volatile.Register32 // 0x10C
	_           [4]byte
	EPTSETSTA0  volatile.Register32 // 0x114
	EPTCLRSTA0  volatile.Register32 // 0x118
	EPTSTA0     volatile.Register32 // 0x11C
	EPTCFG1     volatile.Register32 // 0x120
	EPTCTLENB1  volatile.Register32 // 0x124
	EPTCTLDIS1  volatile.Register32 // 0x128
	EPTCTL1     volatile.Register32 // 0x12C
	_           [4]byte
	EPTSETSTA1  volatile.Register32 // 0x134
	EPTCLRSTA1  volatile.Register32 // 0x138
	EPTSTA1     volatile.Register32 // 0x13C
	EPTCFG2     volatile.Register32 // 0x140
	EPTCTLENB2  volatile.Register32 // 0x144
	EPTCTLDIS2  volatile.Register32 // 0x148
	EPTCTL2     volatile.Register32 // 0x14C
	_           [4]byte
	EPTSETSTA2  volatile.Register32 // 0x154
	EPTCLRSTA2  volatile.Register32 // 0x158
	EPTSTA2     volatile.Register32 // 0x15C
	EPTCFG3     volatile.Register32 // 0x160
	EPTCTLENB3  volatile.Register32 // 0x164
	EPTCTLDIS3  volatile.Register32 // 0x168
	EPTCTL3     volatile.Register32 // 0x16C
	_           [4]byte
	EPTSETSTA3  volatile.Register32 // 0x174
	EPTCLRSTA3  volatile.Register32 // 0x178
	EPTSTA3     volatile.Register32 // 0x17C
	EPTCFG4     volatile.Register32 // 0x180
	EPTCTLENB4  volatile.Register32 // 0x184
	EPTCTLDIS4  volatile.Register32 // 0x188
	EPTCTL4     volatile.Register32 // 0x18C
	_           [4]byte
	EPTSETSTA4  volatile.Register32 // 0x194
	EPTCLRSTA4  volatile.Register32 // 0x198
	EPTSTA4     volatile.Register32 // 0x19C
	EPTCFG5     volatile.Register32 // 0x1A0
	EPTCTLENB5  volatile.Register32 // 0x1A4
	EPTCTLDIS5  volatile.Register32 // 0x1A8
	EPTCTL5     volatile.Register32 // 0x1AC
	_           [4]byte
	EPTSETSTA5  volatile.Register32 // 0x1B4
	EPTCLRSTA5  volatile.Register32 // 0x1B8
	EPTSTA5     volatile.Register32 // 0x1BC
	EPTCFG6     volatile.Register32 // 0x1C0
	EPTCTLENB6  volatile.Register32 // 0x1C4
	EPTCTLDIS6  volatile.Register32 // 0x1C8
	EPTCTL6     volatile.Register32 // 0x1CC
	_           [4]byte
	EPTSETSTA6  volatile.Register32 // 0x1D4
	EPTCLRSTA6  volatile.Register32 // 0x1D8
	EPTSTA6     volatile.Register32 // 0x1DC
	_           [288]byte
	DMANXTDSC0  volatile.Register32 // 0x300
	DMAADDRESS0 volatile.Register32 // 0x304
	DMACONTROL0 volatile.Register32 // 0x308
	DMASTATUS0  volatile.Register32 // 0x30C
	DMANXTDSC1  volatile.Register32 // 0x310
	DMAADDRESS1 volatile.Register32 // 0x314
	DMACONTROL1 volatile.Register32 // 0x318
	DMASTATUS1  volatile.Register32 // 0x31C
	DMANXTDSC2  volatile.Register32 // 0x320
	DMAADDRESS2 volatile.Register32 // 0x324
	DMACONTROL2 volatile.Register32 // 0x328
	DMASTATUS2  volatile.Register32 // 0x32C
	DMANXTDSC3  volatile.Register32 // 0x330
	DMAADDRESS3 volatile.Register32 // 0x334
	DMACONTROL3 volatile.Register32 // 0x338
	DMASTATUS3  volatile.Register32 // 0x33C
	DMANXTDSC4  volatile.Register32 // 0x340
	DMAADDRESS4 volatile.Register32 // 0x344
	DMACONTROL4 volatile.Register32 // 0x348
	DMASTATUS4  volatile.Register32 // 0x34C
	DMANXTDSC5  volatile.Register32 // 0x350
	DMAADDRESS5 volatile.Register32 // 0x354
	DMACONTROL5 volatile.Register32 // 0x358
	DMASTATUS5  volatile.Register32 // 0x35C
}

// Universal Asynchronous Receiver Transmitter 0
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	SEQR1  volatile.Register32 // 0x8
	SEQR2  volatile.Register32 // 0xC
	CHER   volatile.Register32 // 0x10
	CHDR   volatile.Register32 // 0x14
	CHSR   volatile.Register32 // 0x18
	_      [4]byte
	LCDR   volatile.Register32 // 0x20
	IER    volatile.Register32 // 0x24
	IDR    volatile.Register32 // 0x28
	IMR    volatile.Register32 // 0x2C
	ISR    volatile.Register32 // 0x30
	_      [8]byte
	OVER   volatile.Register32 // 0x3C
	EMR    volatile.Register32 // 0x40
	CWR    volatile.Register32 // 0x44
	_      [8]byte
	CDR    [12]volatile.Register32 // 0x50
	_      [20]byte
	ACR    volatile.Register32 // 0x94
	_      [24]byte
	TSMR   volatile.Register32 // 0xB0
	XPOSR  volatile.Register32 // 0xB4
	YPOSR  volatile.Register32 // 0xB8
	PRESSR volatile.Register32 // 0xBC
	TRGR   volatile.Register32 // 0xC0
	_      [32]byte
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MCFG  [11]volatile.Register32 // 0x0
	_     [20]byte
	SCFG  [10]volatile.Register32 // 0x40
	_     [24]byte
	PRAS0 volatile.Register32 // 0x80
	PRBS0 volatile.Register32 // 0x84
	PRAS1 volatile.Register32 // 0x88
	PRBS1 volatile.Register32 // 0x8C
	PRAS2 volatile.Register32 // 0x90
	PRBS2 volatile.Register32 // 0x94
	PRAS3 volatile.Register32 // 0x98
	PRBS3 volatile.Register32 // 0x9C
	PRAS4 volatile.Register32 // 0xA0
	PRBS4 volatile.Register32 // 0xA4
	PRAS5 volatile.Register32 // 0xA8
	PRBS5 volatile.Register32 // 0xAC
	PRAS6 volatile.Register32 // 0xB0
	PRBS6 volatile.Register32 // 0xB4
	PRAS7 volatile.Register32 // 0xB8
	PRBS7 volatile.Register32 // 0xBC
	PRAS8 volatile.Register32 // 0xC0
	PRBS8 volatile.Register32 // 0xC4
	PRAS9 volatile.Register32 // 0xC8
	PRBS9 volatile.Register32 // 0xCC
	_     [48]byte
	MRCR  volatile.Register32 // 0x100
	_     [224]byte
	WPMR  volatile.Register32 // 0x1E4
	WPSR  volatile.Register32 // 0x1E8
}

// Programmable Multibit Error Corrected Code Controller
type EBI_Type struct {
	CFG     volatile.Register32 // 0x0
	SAREA   volatile.Register32 // 0x4
	SADDR   volatile.Register32 // 0x8
	EADDR   volatile.Register32 // 0xC
	CLK     volatile.Register32 // 0x10
	CTRL    volatile.Register32 // 0x14
	SR      volatile.Register32 // 0x18
	IER     volatile.Register32 // 0x1C
	IDR     volatile.Register32 // 0x20
	IMR     volatile.Register32 // 0x24
	ISR     volatile.Register32 // 0x28
	_       [20]byte
	ECC0_0  volatile.Register32 // 0x40
	ECC1_0  volatile.Register32 // 0x44
	ECC2_0  volatile.Register32 // 0x48
	ECC3_0  volatile.Register32 // 0x4C
	ECC4_0  volatile.Register32 // 0x50
	ECC5_0  volatile.Register32 // 0x54
	ECC6_0  volatile.Register32 // 0x58
	ECC7_0  volatile.Register32 // 0x5C
	ECC8_0  volatile.Register32 // 0x60
	ECC9_0  volatile.Register32 // 0x64
	ECC10_0 volatile.Register32 // 0x68
	_       [20]byte
	ECC0_1  volatile.Register32 // 0x80
	ECC1_1  volatile.Register32 // 0x84
	ECC2_1  volatile.Register32 // 0x88
	ECC3_1  volatile.Register32 // 0x8C
	ECC4_1  volatile.Register32 // 0x90
	ECC5_1  volatile.Register32 // 0x94
	ECC6_1  volatile.Register32 // 0x98
	ECC7_1  volatile.Register32 // 0x9C
	ECC8_1  volatile.Register32 // 0xA0
	ECC9_1  volatile.Register32 // 0xA4
	ECC10_1 volatile.Register32 // 0xA8
	_       [20]byte
	ECC0_2  volatile.Register32 // 0xC0
	ECC1_2  volatile.Register32 // 0xC4
	ECC2_2  volatile.Register32 // 0xC8
	ECC3_2  volatile.Register32 // 0xCC
	ECC4_2  volatile.Register32 // 0xD0
	ECC5_2  volatile.Register32 // 0xD4
	ECC6_2  volatile.Register32 // 0xD8
	ECC7_2  volatile.Register32 // 0xDC
	ECC8_2  volatile.Register32 // 0xE0
	ECC9_2  volatile.Register32 // 0xE4
	ECC10_2 volatile.Register32 // 0xE8
	_       [20]byte
	ECC0_3  volatile.Register32 // 0x100
	ECC1_3  volatile.Register32 // 0x104
	ECC2_3  volatile.Register32 // 0x108
	ECC3_3  volatile.Register32 // 0x10C
	ECC4_3  volatile.Register32 // 0x110
	ECC5_3  volatile.Register32 // 0x114
	ECC6_3  volatile.Register32 // 0x118
	ECC7_3  volatile.Register32 // 0x11C
	ECC8_3  volatile.Register32 // 0x120
	ECC9_3  volatile.Register32 // 0x124
	ECC10_3 volatile.Register32 // 0x128
	_       [20]byte
	ECC0_4  volatile.Register32 // 0x140
	ECC1_4  volatile.Register32 // 0x144
	ECC2_4  volatile.Register32 // 0x148
	ECC3_4  volatile.Register32 // 0x14C
	ECC4_4  volatile.Register32 // 0x150
	ECC5_4  volatile.Register32 // 0x154
	ECC6_4  volatile.Register32 // 0x158
	ECC7_4  volatile.Register32 // 0x15C
	ECC8_4  volatile.Register32 // 0x160
	ECC9_4  volatile.Register32 // 0x164
	ECC10_4 volatile.Register32 // 0x168
	_       [20]byte
	ECC0_5  volatile.Register32 // 0x180
	ECC1_5  volatile.Register32 // 0x184
	ECC2_5  volatile.Register32 // 0x188
	ECC3_5  volatile.Register32 // 0x18C
	ECC4_5  volatile.Register32 // 0x190
	ECC5_5  volatile.Register32 // 0x194
	ECC6_5  volatile.Register32 // 0x198
	ECC7_5  volatile.Register32 // 0x19C
	ECC8_5  volatile.Register32 // 0x1A0
	ECC9_5  volatile.Register32 // 0x1A4
	ECC10_5 volatile.Register32 // 0x1A8
	_       [20]byte
	ECC0_6  volatile.Register32 // 0x1C0
	ECC1_6  volatile.Register32 // 0x1C4
	ECC2_6  volatile.Register32 // 0x1C8
	ECC3_6  volatile.Register32 // 0x1CC
	ECC4_6  volatile.Register32 // 0x1D0
	ECC5_6  volatile.Register32 // 0x1D4
	ECC6_6  volatile.Register32 // 0x1D8
	ECC7_6  volatile.Register32 // 0x1DC
	ECC8_6  volatile.Register32 // 0x1E0
	ECC9_6  volatile.Register32 // 0x1E4
	ECC10_6 volatile.Register32 // 0x1E8
	_       [20]byte
	ECC0_7  volatile.Register32 // 0x200
	ECC1_7  volatile.Register32 // 0x204
	ECC2_7  volatile.Register32 // 0x208
	ECC3_7  volatile.Register32 // 0x20C
	ECC4_7  volatile.Register32 // 0x210
	ECC5_7  volatile.Register32 // 0x214
	ECC6_7  volatile.Register32 // 0x218
	ECC7_7  volatile.Register32 // 0x21C
	ECC8_7  volatile.Register32 // 0x220
	ECC9_7  volatile.Register32 // 0x224
	ECC10_7 volatile.Register32 // 0x228
	_       [20]byte
	REM0_0  volatile.Register32 // 0x240
	REM1_0  volatile.Register32 // 0x244
	REM2_0  volatile.Register32 // 0x248
	REM3_0  volatile.Register32 // 0x24C
	REM4_0  volatile.Register32 // 0x250
	REM5_0  volatile.Register32 // 0x254
	REM6_0  volatile.Register32 // 0x258
	REM7_0  volatile.Register32 // 0x25C
	REM8_0  volatile.Register32 // 0x260
	REM9_0  volatile.Register32 // 0x264
	REM10_0 volatile.Register32 // 0x268
	REM11_0 volatile.Register32 // 0x26C
	_       [16]byte
	REM0_1  volatile.Register32 // 0x280
	REM1_1  volatile.Register32 // 0x284
	REM2_1  volatile.Register32 // 0x288
	REM3_1  volatile.Register32 // 0x28C
	REM4_1  volatile.Register32 // 0x290
	REM5_1  volatile.Register32 // 0x294
	REM6_1  volatile.Register32 // 0x298
	REM7_1  volatile.Register32 // 0x29C
	REM8_1  volatile.Register32 // 0x2A0
	REM9_1  volatile.Register32 // 0x2A4
	REM10_1 volatile.Register32 // 0x2A8
	REM11_1 volatile.Register32 // 0x2AC
	_       [16]byte
	REM0_2  volatile.Register32 // 0x2C0
	REM1_2  volatile.Register32 // 0x2C4
	REM2_2  volatile.Register32 // 0x2C8
	REM3_2  volatile.Register32 // 0x2CC
	REM4_2  volatile.Register32 // 0x2D0
	REM5_2  volatile.Register32 // 0x2D4
	REM6_2  volatile.Register32 // 0x2D8
	REM7_2  volatile.Register32 // 0x2DC
	REM8_2  volatile.Register32 // 0x2E0
	REM9_2  volatile.Register32 // 0x2E4
	REM10_2 volatile.Register32 // 0x2E8
	REM11_2 volatile.Register32 // 0x2EC
	_       [16]byte
	REM0_3  volatile.Register32 // 0x300
	REM1_3  volatile.Register32 // 0x304
	REM2_3  volatile.Register32 // 0x308
	REM3_3  volatile.Register32 // 0x30C
	REM4_3  volatile.Register32 // 0x310
	REM5_3  volatile.Register32 // 0x314
	REM6_3  volatile.Register32 // 0x318
	REM7_3  volatile.Register32 // 0x31C
	REM8_3  volatile.Register32 // 0x320
	REM9_3  volatile.Register32 // 0x324
	REM10_3 volatile.Register32 // 0x328
	REM11_3 volatile.Register32 // 0x32C
	_       [16]byte
	REM0_4  volatile.Register32 // 0x340
	REM1_4  volatile.Register32 // 0x344
	REM2_4  volatile.Register32 // 0x348
	REM3_4  volatile.Register32 // 0x34C
	REM4_4  volatile.Register32 // 0x350
	REM5_4  volatile.Register32 // 0x354
	REM6_4  volatile.Register32 // 0x358
	REM7_4  volatile.Register32 // 0x35C
	REM8_4  volatile.Register32 // 0x360
	REM9_4  volatile.Register32 // 0x364
	REM10_4 volatile.Register32 // 0x368
	REM11_4 volatile.Register32 // 0x36C
	_       [16]byte
	REM0_5  volatile.Register32 // 0x380
	REM1_5  volatile.Register32 // 0x384
	REM2_5  volatile.Register32 // 0x388
	REM3_5  volatile.Register32 // 0x38C
	REM4_5  volatile.Register32 // 0x390
	REM5_5  volatile.Register32 // 0x394
	REM6_5  volatile.Register32 // 0x398
	REM7_5  volatile.Register32 // 0x39C
	REM8_5  volatile.Register32 // 0x3A0
	REM9_5  volatile.Register32 // 0x3A4
	REM10_5 volatile.Register32 // 0x3A8
	REM11_5 volatile.Register32 // 0x3AC
	_       [16]byte
	REM0_6  volatile.Register32 // 0x3C0
	REM1_6  volatile.Register32 // 0x3C4
	REM2_6  volatile.Register32 // 0x3C8
	REM3_6  volatile.Register32 // 0x3CC
	REM4_6  volatile.Register32 // 0x3D0
	REM5_6  volatile.Register32 // 0x3D4
	REM6_6  volatile.Register32 // 0x3D8
	REM7_6  volatile.Register32 // 0x3DC
	REM8_6  volatile.Register32 // 0x3E0
	REM9_6  volatile.Register32 // 0x3E4
	REM10_6 volatile.Register32 // 0x3E8
	REM11_6 volatile.Register32 // 0x3EC
	_       [16]byte
	REM0_7  volatile.Register32 // 0x400
	REM1_7  volatile.Register32 // 0x404
	REM2_7  volatile.Register32 // 0x408
	REM3_7  volatile.Register32 // 0x40C
	REM4_7  volatile.Register32 // 0x410
	REM5_7  volatile.Register32 // 0x414
	REM6_7  volatile.Register32 // 0x418
	REM7_7  volatile.Register32 // 0x41C
	REM8_7  volatile.Register32 // 0x420
	REM9_7  volatile.Register32 // 0x424
	REM10_7 volatile.Register32 // 0x428
	REM11_7 volatile.Register32 // 0x42C
}

// DMA Controller 0
type DMAC_Type struct {
	GCFG   volatile.Register32 // 0x0
	EN     volatile.Register32 // 0x4
	SREQ   volatile.Register32 // 0x8
	CREQ   volatile.Register32 // 0xC
	LAST   volatile.Register32 // 0x10
	_      [4]byte
	EBCIER volatile.Register32 // 0x18
	EBCIDR volatile.Register32 // 0x1C
	EBCIMR volatile.Register32 // 0x20
	EBCISR volatile.Register32 // 0x24
	CHER   volatile.Register32 // 0x28
	CHDR   volatile.Register32 // 0x2C
	CHSR   volatile.Register32 // 0x30
	_      [8]byte
	SADDR0 volatile.Register32 // 0x3C
	DADDR0 volatile.Register32 // 0x40
	DSCR0  volatile.Register32 // 0x44
	CTRLA0 volatile.Register32 // 0x48
	CTRLB0 volatile.Register32 // 0x4C
	CFG0   volatile.Register32 // 0x50
	SPIP0  volatile.Register32 // 0x54
	DPIP0  volatile.Register32 // 0x58
	_      [8]byte
	SADDR1 volatile.Register32 // 0x64
	DADDR1 volatile.Register32 // 0x68
	DSCR1  volatile.Register32 // 0x6C
	CTRLA1 volatile.Register32 // 0x70
	CTRLB1 volatile.Register32 // 0x74
	CFG1   volatile.Register32 // 0x78
	SPIP1  volatile.Register32 // 0x7C
	DPIP1  volatile.Register32 // 0x80
	_      [8]byte
	SADDR2 volatile.Register32 // 0x8C
	DADDR2 volatile.Register32 // 0x90
	DSCR2  volatile.Register32 // 0x94
	CTRLA2 volatile.Register32 // 0x98
	CTRLB2 volatile.Register32 // 0x9C
	CFG2   volatile.Register32 // 0xA0
	SPIP2  volatile.Register32 // 0xA4
	DPIP2  volatile.Register32 // 0xA8
	_      [8]byte
	SADDR3 volatile.Register32 // 0xB4
	DADDR3 volatile.Register32 // 0xB8
	DSCR3  volatile.Register32 // 0xBC
	CTRLA3 volatile.Register32 // 0xC0
	CTRLB3 volatile.Register32 // 0xC4
	CFG3   volatile.Register32 // 0xC8
	SPIP3  volatile.Register32 // 0xCC
	DPIP3  volatile.Register32 // 0xD0
	_      [8]byte
	SADDR4 volatile.Register32 // 0xDC
	DADDR4 volatile.Register32 // 0xE0
	DSCR4  volatile.Register32 // 0xE4
	CTRLA4 volatile.Register32 // 0xE8
	CTRLB4 volatile.Register32 // 0xEC
	CFG4   volatile.Register32 // 0xF0
	SPIP4  volatile.Register32 // 0xF4
	DPIP4  volatile.Register32 // 0xF8
	_      [8]byte
	SADDR5 volatile.Register32 // 0x104
	DADDR5 volatile.Register32 // 0x108
	DSCR5  volatile.Register32 // 0x10C
	CTRLA5 volatile.Register32 // 0x110
	CTRLB5 volatile.Register32 // 0x114
	CFG5   volatile.Register32 // 0x118
	SPIP5  volatile.Register32 // 0x11C
	DPIP5  volatile.Register32 // 0x120
	_      [8]byte
	SADDR6 volatile.Register32 // 0x12C
	DADDR6 volatile.Register32 // 0x130
	DSCR6  volatile.Register32 // 0x134
	CTRLA6 volatile.Register32 // 0x138
	CTRLB6 volatile.Register32 // 0x13C
	CFG6   volatile.Register32 // 0x140
	SPIP6  volatile.Register32 // 0x144
	DPIP6  volatile.Register32 // 0x148
	_      [8]byte
	SADDR7 volatile.Register32 // 0x154
	DADDR7 volatile.Register32 // 0x158
	DSCR7  volatile.Register32 // 0x15C
	CTRLA7 volatile.Register32 // 0x160
	CTRLB7 volatile.Register32 // 0x164
	CFG7   volatile.Register32 // 0x168
	SPIP7  volatile.Register32 // 0x16C
	DPIP7  volatile.Register32 // 0x170
	_      [112]byte
	WPMR   volatile.Register32 // 0x1E4
	WPSR   volatile.Register32 // 0x1E8
}

// Advanced Interrupt Controller
type AIC_Type struct {
	SMR   [32]volatile.Register32 // 0x0
	SVR   [32]volatile.Register32 // 0x80
	IVR   volatile.Register32     // 0x100
	FVR   volatile.Register32     // 0x104
	ISR   volatile.Register32     // 0x108
	IPR   volatile.Register32     // 0x10C
	IMR   volatile.Register32     // 0x110
	CISR  volatile.Register32     // 0x114
	_     [8]byte
	IECR  volatile.Register32 // 0x120
	IDCR  volatile.Register32 // 0x124
	ICCR  volatile.Register32 // 0x128
	ISCR  volatile.Register32 // 0x12C
	EOICR volatile.Register32 // 0x130
	SPU   volatile.Register32 // 0x134
	DCR   volatile.Register32 // 0x138
	_     [4]byte
	FFER  volatile.Register32 // 0x140
	FFDR  volatile.Register32 // 0x144
	FFSR  volatile.Register32 // 0x148
	_     [152]byte
	WPMR  volatile.Register32 // 0x1E4
	WPSR  volatile.Register32 // 0x1E8
}

// Debug Unit
type DBGU_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [28]byte
	CIDR volatile.Register32 // 0x40
	EXID volatile.Register32 // 0x44
	FNR  volatile.Register32 // 0x48
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER     volatile.Register32 // 0x0
	PDR     volatile.Register32 // 0x4
	PSR     volatile.Register32 // 0x8
	_       [4]byte
	OER     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	OSR     volatile.Register32 // 0x18
	_       [4]byte
	IFER    volatile.Register32 // 0x20
	IFDR    volatile.Register32 // 0x24
	IFSR    volatile.Register32 // 0x28
	_       [4]byte
	SODR    volatile.Register32 // 0x30
	CODR    volatile.Register32 // 0x34
	ODSR    volatile.Register32 // 0x38
	PDSR    volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
	MDER    volatile.Register32 // 0x50
	MDDR    volatile.Register32 // 0x54
	MDSR    volatile.Register32 // 0x58
	_       [4]byte
	PUDR    volatile.Register32 // 0x60
	PUER    volatile.Register32 // 0x64
	PUSR    volatile.Register32 // 0x68
	_       [4]byte
	ABCDSR  [2]volatile.Register32 // 0x70
	_       [8]byte
	IFSCDR  volatile.Register32 // 0x80
	IFSCER  volatile.Register32 // 0x84
	IFSCSR  volatile.Register32 // 0x88
	SCDR    volatile.Register32 // 0x8C
	PPDDR   volatile.Register32 // 0x90
	PPDER   volatile.Register32 // 0x94
	PPDSR   volatile.Register32 // 0x98
	_       [4]byte
	OWER    volatile.Register32 // 0xA0
	OWDR    volatile.Register32 // 0xA4
	OWSR    volatile.Register32 // 0xA8
	_       [4]byte
	AIMER   volatile.Register32 // 0xB0
	AIMDR   volatile.Register32 // 0xB4
	AIMMR   volatile.Register32 // 0xB8
	_       [4]byte
	ESR     volatile.Register32 // 0xC0
	LSR     volatile.Register32 // 0xC4
	ELSR    volatile.Register32 // 0xC8
	_       [4]byte
	FELLSR  volatile.Register32 // 0xD0
	REHLSR  volatile.Register32 // 0xD4
	FRLHSR  volatile.Register32 // 0xD8
	_       [4]byte
	LOCKSR  volatile.Register32 // 0xE0
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [20]byte
	SCHMITT volatile.Register32 // 0x100
	_       [12]byte
	DELAYR  volatile.Register32 // 0x110
	DRIVER1 volatile.Register32 // 0x114
	DRIVER2 volatile.Register32 // 0x118
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER    volatile.Register32 // 0x0
	PMC_SCDR    volatile.Register32 // 0x4
	PMC_SCSR    volatile.Register32 // 0x8
	_           [4]byte
	PMC_PCER    volatile.Register32 // 0x10
	PMC_PCDR    volatile.Register32 // 0x14
	PMC_PCSR    volatile.Register32 // 0x18
	CKGR_UCKR   volatile.Register32 // 0x1C
	CKGR_MOR    volatile.Register32 // 0x20
	CKGR_MCFR   volatile.Register32 // 0x24
	CKGR_PLLAR  volatile.Register32 // 0x28
	_           [4]byte
	PMC_MCKR    volatile.Register32 // 0x30
	_           [4]byte
	PMC_USB     volatile.Register32    // 0x38
	PMC_SMD     volatile.Register32    // 0x3C
	PMC_PCK     [2]volatile.Register32 // 0x40
	_           [24]byte
	PMC_IER     volatile.Register32 // 0x60
	PMC_IDR     volatile.Register32 // 0x64
	PMC_SR      volatile.Register32 // 0x68
	PMC_IMR     volatile.Register32 // 0x6C
	_           [16]byte
	PMC_PLLICPR volatile.Register32 // 0x80
	_           [96]byte
	PMC_WPMR    volatile.Register32 // 0xE4
	PMC_WPSR    volatile.Register32 // 0xE8
	_           [32]byte
	PMC_PCR     volatile.Register32 // 0x10C
}

// Reset Controller
type SYSC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// Real-time Clock
type RTC_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	TIMR   volatile.Register32 // 0x8
	CALR   volatile.Register32 // 0xC
	TIMALR volatile.Register32 // 0x10
	CALALR volatile.Register32 // 0x14
	SR     volatile.Register32 // 0x18
	SCCR   volatile.Register32 // 0x1C
	IER    volatile.Register32 // 0x20
	IDR    volatile.Register32 // 0x24
	IMR    volatile.Register32 // 0x28
	VER    volatile.Register32 // 0x2C
}

// Bitfields for SMD: Software Modem Device
const ()

// Bitfields for SPI0: Serial Peripheral Interface 0
const (
	// CR: Control Register
	SPI_CR_SPIEN_Pos    = 0x0       // Position of SPIEN field.
	SPI_CR_SPIEN_Msk    = 0x1       // Bit mask of SPIEN field.
	SPI_CR_SPIEN        = 0x1       // Bit SPIEN.
	SPI_CR_SPIDIS_Pos   = 0x1       // Position of SPIDIS field.
	SPI_CR_SPIDIS_Msk   = 0x2       // Bit mask of SPIDIS field.
	SPI_CR_SPIDIS       = 0x2       // Bit SPIDIS.
	SPI_CR_SWRST_Pos    = 0x7       // Position of SWRST field.
	SPI_CR_SWRST_Msk    = 0x80      // Bit mask of SWRST field.
	SPI_CR_SWRST        = 0x80      // Bit SWRST.
	SPI_CR_LASTXFER_Pos = 0x18      // Position of LASTXFER field.
	SPI_CR_LASTXFER_Msk = 0x1000000 // Bit mask of LASTXFER field.
	SPI_CR_LASTXFER     = 0x1000000 // Bit LASTXFER.

	// MR: Mode Register
	SPI_MR_MSTR_Pos    = 0x0        // Position of MSTR field.
	SPI_MR_MSTR_Msk    = 0x1        // Bit mask of MSTR field.
	SPI_MR_MSTR        = 0x1        // Bit MSTR.
	SPI_MR_PS_Pos      = 0x1        // Position of PS field.
	SPI_MR_PS_Msk      = 0x2        // Bit mask of PS field.
	SPI_MR_PS          = 0x2        // Bit PS.
	SPI_MR_PCSDEC_Pos  = 0x2        // Position of PCSDEC field.
	SPI_MR_PCSDEC_Msk  = 0x4        // Bit mask of PCSDEC field.
	SPI_MR_PCSDEC      = 0x4        // Bit PCSDEC.
	SPI_MR_MODFDIS_Pos = 0x4        // Position of MODFDIS field.
	SPI_MR_MODFDIS_Msk = 0x10       // Bit mask of MODFDIS field.
	SPI_MR_MODFDIS     = 0x10       // Bit MODFDIS.
	SPI_MR_WDRBT_Pos   = 0x5        // Position of WDRBT field.
	SPI_MR_WDRBT_Msk   = 0x20       // Bit mask of WDRBT field.
	SPI_MR_WDRBT       = 0x20       // Bit WDRBT.
	SPI_MR_LLB_Pos     = 0x7        // Position of LLB field.
	SPI_MR_LLB_Msk     = 0x80       // Bit mask of LLB field.
	SPI_MR_LLB         = 0x80       // Bit LLB.
	SPI_MR_PCS_Pos     = 0x10       // Position of PCS field.
	SPI_MR_PCS_Msk     = 0xf0000    // Bit mask of PCS field.
	SPI_MR_DLYBCS_Pos  = 0x18       // Position of DLYBCS field.
	SPI_MR_DLYBCS_Msk  = 0xff000000 // Bit mask of DLYBCS field.

	// RDR: Receive Data Register
	SPI_RDR_RD_Pos  = 0x0     // Position of RD field.
	SPI_RDR_RD_Msk  = 0xffff  // Bit mask of RD field.
	SPI_RDR_PCS_Pos = 0x10    // Position of PCS field.
	SPI_RDR_PCS_Msk = 0xf0000 // Bit mask of PCS field.

	// TDR: Transmit Data Register
	SPI_TDR_TD_Pos       = 0x0       // Position of TD field.
	SPI_TDR_TD_Msk       = 0xffff    // Bit mask of TD field.
	SPI_TDR_PCS_Pos      = 0x10      // Position of PCS field.
	SPI_TDR_PCS_Msk      = 0xf0000   // Bit mask of PCS field.
	SPI_TDR_LASTXFER_Pos = 0x18      // Position of LASTXFER field.
	SPI_TDR_LASTXFER_Msk = 0x1000000 // Bit mask of LASTXFER field.
	SPI_TDR_LASTXFER     = 0x1000000 // Bit LASTXFER.

	// SR: Status Register
	SPI_SR_RDRF_Pos    = 0x0     // Position of RDRF field.
	SPI_SR_RDRF_Msk    = 0x1     // Bit mask of RDRF field.
	SPI_SR_RDRF        = 0x1     // Bit RDRF.
	SPI_SR_TDRE_Pos    = 0x1     // Position of TDRE field.
	SPI_SR_TDRE_Msk    = 0x2     // Bit mask of TDRE field.
	SPI_SR_TDRE        = 0x2     // Bit TDRE.
	SPI_SR_MODF_Pos    = 0x2     // Position of MODF field.
	SPI_SR_MODF_Msk    = 0x4     // Bit mask of MODF field.
	SPI_SR_MODF        = 0x4     // Bit MODF.
	SPI_SR_OVRES_Pos   = 0x3     // Position of OVRES field.
	SPI_SR_OVRES_Msk   = 0x8     // Bit mask of OVRES field.
	SPI_SR_OVRES       = 0x8     // Bit OVRES.
	SPI_SR_NSSR_Pos    = 0x8     // Position of NSSR field.
	SPI_SR_NSSR_Msk    = 0x100   // Bit mask of NSSR field.
	SPI_SR_NSSR        = 0x100   // Bit NSSR.
	SPI_SR_TXEMPTY_Pos = 0x9     // Position of TXEMPTY field.
	SPI_SR_TXEMPTY_Msk = 0x200   // Bit mask of TXEMPTY field.
	SPI_SR_TXEMPTY     = 0x200   // Bit TXEMPTY.
	SPI_SR_SPIENS_Pos  = 0x10    // Position of SPIENS field.
	SPI_SR_SPIENS_Msk  = 0x10000 // Bit mask of SPIENS field.
	SPI_SR_SPIENS      = 0x10000 // Bit SPIENS.

	// IER: Interrupt Enable Register
	SPI_IER_RDRF_Pos    = 0x0   // Position of RDRF field.
	SPI_IER_RDRF_Msk    = 0x1   // Bit mask of RDRF field.
	SPI_IER_RDRF        = 0x1   // Bit RDRF.
	SPI_IER_TDRE_Pos    = 0x1   // Position of TDRE field.
	SPI_IER_TDRE_Msk    = 0x2   // Bit mask of TDRE field.
	SPI_IER_TDRE        = 0x2   // Bit TDRE.
	SPI_IER_MODF_Pos    = 0x2   // Position of MODF field.
	SPI_IER_MODF_Msk    = 0x4   // Bit mask of MODF field.
	SPI_IER_MODF        = 0x4   // Bit MODF.
	SPI_IER_OVRES_Pos   = 0x3   // Position of OVRES field.
	SPI_IER_OVRES_Msk   = 0x8   // Bit mask of OVRES field.
	SPI_IER_OVRES       = 0x8   // Bit OVRES.
	SPI_IER_TXBUFE_Pos  = 0x7   // Position of TXBUFE field.
	SPI_IER_TXBUFE_Msk  = 0x80  // Bit mask of TXBUFE field.
	SPI_IER_TXBUFE      = 0x80  // Bit TXBUFE.
	SPI_IER_NSSR_Pos    = 0x8   // Position of NSSR field.
	SPI_IER_NSSR_Msk    = 0x100 // Bit mask of NSSR field.
	SPI_IER_NSSR        = 0x100 // Bit NSSR.
	SPI_IER_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	SPI_IER_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	SPI_IER_TXEMPTY     = 0x200 // Bit TXEMPTY.

	// IDR: Interrupt Disable Register
	SPI_IDR_RDRF_Pos    = 0x0   // Position of RDRF field.
	SPI_IDR_RDRF_Msk    = 0x1   // Bit mask of RDRF field.
	SPI_IDR_RDRF        = 0x1   // Bit RDRF.
	SPI_IDR_TDRE_Pos    = 0x1   // Position of TDRE field.
	SPI_IDR_TDRE_Msk    = 0x2   // Bit mask of TDRE field.
	SPI_IDR_TDRE        = 0x2   // Bit TDRE.
	SPI_IDR_MODF_Pos    = 0x2   // Position of MODF field.
	SPI_IDR_MODF_Msk    = 0x4   // Bit mask of MODF field.
	SPI_IDR_MODF        = 0x4   // Bit MODF.
	SPI_IDR_OVRES_Pos   = 0x3   // Position of OVRES field.
	SPI_IDR_OVRES_Msk   = 0x8   // Bit mask of OVRES field.
	SPI_IDR_OVRES       = 0x8   // Bit OVRES.
	SPI_IDR_NSSR_Pos    = 0x8   // Position of NSSR field.
	SPI_IDR_NSSR_Msk    = 0x100 // Bit mask of NSSR field.
	SPI_IDR_NSSR        = 0x100 // Bit NSSR.
	SPI_IDR_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	SPI_IDR_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	SPI_IDR_TXEMPTY     = 0x200 // Bit TXEMPTY.

	// IMR: Interrupt Mask Register
	SPI_IMR_RDRF_Pos    = 0x0   // Position of RDRF field.
	SPI_IMR_RDRF_Msk    = 0x1   // Bit mask of RDRF field.
	SPI_IMR_RDRF        = 0x1   // Bit RDRF.
	SPI_IMR_TDRE_Pos    = 0x1   // Position of TDRE field.
	SPI_IMR_TDRE_Msk    = 0x2   // Bit mask of TDRE field.
	SPI_IMR_TDRE        = 0x2   // Bit TDRE.
	SPI_IMR_MODF_Pos    = 0x2   // Position of MODF field.
	SPI_IMR_MODF_Msk    = 0x4   // Bit mask of MODF field.
	SPI_IMR_MODF        = 0x4   // Bit MODF.
	SPI_IMR_OVRES_Pos   = 0x3   // Position of OVRES field.
	SPI_IMR_OVRES_Msk   = 0x8   // Bit mask of OVRES field.
	SPI_IMR_OVRES       = 0x8   // Bit OVRES.
	SPI_IMR_NSSR_Pos    = 0x8   // Position of NSSR field.
	SPI_IMR_NSSR_Msk    = 0x100 // Bit mask of NSSR field.
	SPI_IMR_NSSR        = 0x100 // Bit NSSR.
	SPI_IMR_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	SPI_IMR_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	SPI_IMR_TXEMPTY     = 0x200 // Bit TXEMPTY.

	// CSR: Chip Select Register
	SPI_CSR_CPOL_Pos    = 0x0        // Position of CPOL field.
	SPI_CSR_CPOL_Msk    = 0x1        // Bit mask of CPOL field.
	SPI_CSR_CPOL        = 0x1        // Bit CPOL.
	SPI_CSR_NCPHA_Pos   = 0x1        // Position of NCPHA field.
	SPI_CSR_NCPHA_Msk   = 0x2        // Bit mask of NCPHA field.
	SPI_CSR_NCPHA       = 0x2        // Bit NCPHA.
	SPI_CSR_CSAAT_Pos   = 0x3        // Position of CSAAT field.
	SPI_CSR_CSAAT_Msk   = 0x8        // Bit mask of CSAAT field.
	SPI_CSR_CSAAT       = 0x8        // Bit CSAAT.
	SPI_CSR_BITS_Pos    = 0x4        // Position of BITS field.
	SPI_CSR_BITS_Msk    = 0xf0       // Bit mask of BITS field.
	SPI_CSR_BITS_8_BIT  = 0x0        // 8 bits for transfer
	SPI_CSR_BITS_9_BIT  = 0x1        // 9 bits for transfer
	SPI_CSR_BITS_10_BIT = 0x2        // 10 bits for transfer
	SPI_CSR_BITS_11_BIT = 0x3        // 11 bits for transfer
	SPI_CSR_BITS_12_BIT = 0x4        // 12 bits for transfer
	SPI_CSR_BITS_13_BIT = 0x5        // 13 bits for transfer
	SPI_CSR_BITS_14_BIT = 0x6        // 14 bits for transfer
	SPI_CSR_BITS_15_BIT = 0x7        // 15 bits for transfer
	SPI_CSR_BITS_16_BIT = 0x8        // 16 bits for transfer
	SPI_CSR_SCBR_Pos    = 0x8        // Position of SCBR field.
	SPI_CSR_SCBR_Msk    = 0xff00     // Bit mask of SCBR field.
	SPI_CSR_DLYBS_Pos   = 0x10       // Position of DLYBS field.
	SPI_CSR_DLYBS_Msk   = 0xff0000   // Bit mask of DLYBS field.
	SPI_CSR_DLYBCT_Pos  = 0x18       // Position of DLYBCT field.
	SPI_CSR_DLYBCT_Msk  = 0xff000000 // Bit mask of DLYBCT field.

	// WPMR: Write Protection Control Register
	SPI_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	SPI_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	SPI_WPMR_WPEN      = 0x1        // Bit WPEN.
	SPI_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	SPI_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protection Status Register
	SPI_WPSR_WPVS_Pos   = 0x0    // Position of WPVS field.
	SPI_WPSR_WPVS_Msk   = 0x1    // Bit mask of WPVS field.
	SPI_WPSR_WPVS       = 0x1    // Bit WPVS.
	SPI_WPSR_WPVSRC_Pos = 0x8    // Position of WPVSRC field.
	SPI_WPSR_WPVSRC_Msk = 0xff00 // Bit mask of WPVSRC field.
)

// Bitfields for HSMCI0: High Speed MultiMedia Card Interface 0
const (
	// CR: Control Register
	HSMCI_CR_MCIEN_Pos  = 0x0  // Position of MCIEN field.
	HSMCI_CR_MCIEN_Msk  = 0x1  // Bit mask of MCIEN field.
	HSMCI_CR_MCIEN      = 0x1  // Bit MCIEN.
	HSMCI_CR_MCIDIS_Pos = 0x1  // Position of MCIDIS field.
	HSMCI_CR_MCIDIS_Msk = 0x2  // Bit mask of MCIDIS field.
	HSMCI_CR_MCIDIS     = 0x2  // Bit MCIDIS.
	HSMCI_CR_PWSEN_Pos  = 0x2  // Position of PWSEN field.
	HSMCI_CR_PWSEN_Msk  = 0x4  // Bit mask of PWSEN field.
	HSMCI_CR_PWSEN      = 0x4  // Bit PWSEN.
	HSMCI_CR_PWSDIS_Pos = 0x3  // Position of PWSDIS field.
	HSMCI_CR_PWSDIS_Msk = 0x8  // Bit mask of PWSDIS field.
	HSMCI_CR_PWSDIS     = 0x8  // Bit PWSDIS.
	HSMCI_CR_SWRST_Pos  = 0x7  // Position of SWRST field.
	HSMCI_CR_SWRST_Msk  = 0x80 // Bit mask of SWRST field.
	HSMCI_CR_SWRST      = 0x80 // Bit SWRST.

	// MR: Mode Register
	HSMCI_MR_CLKDIV_Pos  = 0x0     // Position of CLKDIV field.
	HSMCI_MR_CLKDIV_Msk  = 0xff    // Bit mask of CLKDIV field.
	HSMCI_MR_PWSDIV_Pos  = 0x8     // Position of PWSDIV field.
	HSMCI_MR_PWSDIV_Msk  = 0x700   // Bit mask of PWSDIV field.
	HSMCI_MR_RDPROOF_Pos = 0xb     // Position of RDPROOF field.
	HSMCI_MR_RDPROOF_Msk = 0x800   // Bit mask of RDPROOF field.
	HSMCI_MR_RDPROOF     = 0x800   // Bit RDPROOF.
	HSMCI_MR_WRPROOF_Pos = 0xc     // Position of WRPROOF field.
	HSMCI_MR_WRPROOF_Msk = 0x1000  // Bit mask of WRPROOF field.
	HSMCI_MR_WRPROOF     = 0x1000  // Bit WRPROOF.
	HSMCI_MR_FBYTE_Pos   = 0xd     // Position of FBYTE field.
	HSMCI_MR_FBYTE_Msk   = 0x2000  // Bit mask of FBYTE field.
	HSMCI_MR_FBYTE       = 0x2000  // Bit FBYTE.
	HSMCI_MR_PADV_Pos    = 0xe     // Position of PADV field.
	HSMCI_MR_PADV_Msk    = 0x4000  // Bit mask of PADV field.
	HSMCI_MR_PADV        = 0x4000  // Bit PADV.
	HSMCI_MR_CLKODD_Pos  = 0x10    // Position of CLKODD field.
	HSMCI_MR_CLKODD_Msk  = 0x10000 // Bit mask of CLKODD field.
	HSMCI_MR_CLKODD      = 0x10000 // Bit CLKODD.

	// DTOR: Data Timeout Register
	HSMCI_DTOR_DTOCYC_Pos     = 0x0  // Position of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Msk     = 0xf  // Bit mask of DTOCYC field.
	HSMCI_DTOR_DTOMUL_Pos     = 0x4  // Position of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Msk     = 0x70 // Bit mask of DTOMUL field.
	HSMCI_DTOR_DTOMUL_1       = 0x0  // DTOCYC
	HSMCI_DTOR_DTOMUL_16      = 0x1  // DTOCYC x 16
	HSMCI_DTOR_DTOMUL_128     = 0x2  // DTOCYC x 128
	HSMCI_DTOR_DTOMUL_256     = 0x3  // DTOCYC x 256
	HSMCI_DTOR_DTOMUL_1024    = 0x4  // DTOCYC x 1024
	HSMCI_DTOR_DTOMUL_4096    = 0x5  // DTOCYC x 4096
	HSMCI_DTOR_DTOMUL_65536   = 0x6  // DTOCYC x 65536
	HSMCI_DTOR_DTOMUL_1048576 = 0x7  // DTOCYC x 1048576

	// SDCR: SD/SDIO Card Register
	HSMCI_SDCR_SDCSEL_Pos   = 0x0  // Position of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Msk   = 0x3  // Bit mask of SDCSEL field.
	HSMCI_SDCR_SDCSEL_SLOTA = 0x0  // Slot A is selected.
	HSMCI_SDCR_SDCSEL_SLOTB = 0x1  // -
	HSMCI_SDCR_SDCSEL_SLOTC = 0x2  // -
	HSMCI_SDCR_SDCSEL_SLOTD = 0x3  // -
	HSMCI_SDCR_SDCBUS_Pos   = 0x6  // Position of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Msk   = 0xc0 // Bit mask of SDCBUS field.
	HSMCI_SDCR_SDCBUS_1     = 0x0  // 1 bit
	HSMCI_SDCR_SDCBUS_4     = 0x2  // 4 bit
	HSMCI_SDCR_SDCBUS_8     = 0x3  // 8 bit

	// ARGR: Argument Register
	HSMCI_ARGR_ARG_Pos = 0x0        // Position of ARG field.
	HSMCI_ARGR_ARG_Msk = 0xffffffff // Bit mask of ARG field.

	// CMDR: Command Register
	HSMCI_CMDR_CMDNB_Pos        = 0x0       // Position of CMDNB field.
	HSMCI_CMDR_CMDNB_Msk        = 0x3f      // Bit mask of CMDNB field.
	HSMCI_CMDR_RSPTYP_Pos       = 0x6       // Position of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Msk       = 0xc0      // Bit mask of RSPTYP field.
	HSMCI_CMDR_RSPTYP_NORESP    = 0x0       // No response.
	HSMCI_CMDR_RSPTYP_48_BIT    = 0x1       // 48-bit response.
	HSMCI_CMDR_RSPTYP_136_BIT   = 0x2       // 136-bit response.
	HSMCI_CMDR_RSPTYP_R1B       = 0x3       // R1b response type
	HSMCI_CMDR_SPCMD_Pos        = 0x8       // Position of SPCMD field.
	HSMCI_CMDR_SPCMD_Msk        = 0x700     // Bit mask of SPCMD field.
	HSMCI_CMDR_SPCMD_STD        = 0x0       // Not a special CMD.
	HSMCI_CMDR_SPCMD_INIT       = 0x1       // Initialization CMD: 74 clock cycles for initialization sequence.
	HSMCI_CMDR_SPCMD_SYNC       = 0x2       // Synchronized CMD: Wait for the end of the current data block transfer before sending the pending command.
	HSMCI_CMDR_SPCMD_CE_ATA     = 0x3       // CE-ATA Completion Signal disable Command. The host cancels the ability for the device to return a command completion signal on the command line.
	HSMCI_CMDR_SPCMD_IT_CMD     = 0x4       // Interrupt command: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_RESP    = 0x5       // Interrupt response: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_BOR        = 0x6       // Boot Operation Request. Start a boot operation mode, the host processor can read boot data from the MMC device directly.
	HSMCI_CMDR_SPCMD_EBO        = 0x7       // End Boot Operation. This command allows the host processor to terminate the boot operation mode.
	HSMCI_CMDR_OPDCMD_Pos       = 0xb       // Position of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Msk       = 0x800     // Bit mask of OPDCMD field.
	HSMCI_CMDR_OPDCMD           = 0x800     // Bit OPDCMD.
	HSMCI_CMDR_OPDCMD_PUSHPULL  = 0x0       // Push pull command.
	HSMCI_CMDR_OPDCMD_OPENDRAIN = 0x1       // Open drain command.
	HSMCI_CMDR_MAXLAT_Pos       = 0xc       // Position of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Msk       = 0x1000    // Bit mask of MAXLAT field.
	HSMCI_CMDR_MAXLAT           = 0x1000    // Bit MAXLAT.
	HSMCI_CMDR_MAXLAT_5         = 0x0       // 5-cycle max latency.
	HSMCI_CMDR_MAXLAT_64        = 0x1       // 64-cycle max latency.
	HSMCI_CMDR_TRCMD_Pos        = 0x10      // Position of TRCMD field.
	HSMCI_CMDR_TRCMD_Msk        = 0x30000   // Bit mask of TRCMD field.
	HSMCI_CMDR_TRCMD_NO_DATA    = 0x0       // No data transfer
	HSMCI_CMDR_TRCMD_START_DATA = 0x1       // Start data transfer
	HSMCI_CMDR_TRCMD_STOP_DATA  = 0x2       // Stop data transfer
	HSMCI_CMDR_TRDIR_Pos        = 0x12      // Position of TRDIR field.
	HSMCI_CMDR_TRDIR_Msk        = 0x40000   // Bit mask of TRDIR field.
	HSMCI_CMDR_TRDIR            = 0x40000   // Bit TRDIR.
	HSMCI_CMDR_TRDIR_WRITE      = 0x0       // Write.
	HSMCI_CMDR_TRDIR_READ       = 0x1       // Read.
	HSMCI_CMDR_TRTYP_Pos        = 0x13      // Position of TRTYP field.
	HSMCI_CMDR_TRTYP_Msk        = 0x380000  // Bit mask of TRTYP field.
	HSMCI_CMDR_TRTYP_SINGLE     = 0x0       // MMC/SD Card Single Block
	HSMCI_CMDR_TRTYP_MULTIPLE   = 0x1       // MMC/SD Card Multiple Block
	HSMCI_CMDR_TRTYP_STREAM     = 0x2       // MMC Stream
	HSMCI_CMDR_TRTYP_BYTE       = 0x4       // SDIO Byte
	HSMCI_CMDR_TRTYP_BLOCK      = 0x5       // SDIO Block
	HSMCI_CMDR_IOSPCMD_Pos      = 0x18      // Position of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Msk      = 0x3000000 // Bit mask of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_STD      = 0x0       // Not an SDIO Special Command
	HSMCI_CMDR_IOSPCMD_SUSPEND  = 0x1       // SDIO Suspend Command
	HSMCI_CMDR_IOSPCMD_RESUME   = 0x2       // SDIO Resume Command
	HSMCI_CMDR_ATACS_Pos        = 0x1a      // Position of ATACS field.
	HSMCI_CMDR_ATACS_Msk        = 0x4000000 // Bit mask of ATACS field.
	HSMCI_CMDR_ATACS            = 0x4000000 // Bit ATACS.
	HSMCI_CMDR_ATACS_NORMAL     = 0x0       // Normal operation mode.
	HSMCI_CMDR_ATACS_COMPLETION = 0x1       // This bit indicates that a completion signal is expected within a programmed amount of time (HSMCI_CSTOR).
	HSMCI_CMDR_BOOT_ACK_Pos     = 0x1b      // Position of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Msk     = 0x8000000 // Bit mask of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK         = 0x8000000 // Bit BOOT_ACK.

	// BLKR: Block Register
	HSMCI_BLKR_BCNT_Pos      = 0x0        // Position of BCNT field.
	HSMCI_BLKR_BCNT_Msk      = 0xffff     // Bit mask of BCNT field.
	HSMCI_BLKR_BCNT_MULTIPLE = 0x0        // MMC/SD CARD Multiple BlockFrom 1 to 65635: Value 0 corresponds to an infinite block transfer.
	HSMCI_BLKR_BCNT_BYTE     = 0x4        // SDIO ByteFrom 1 to 512 bytes: Value 0 corresponds to a 512-byte transfer.Values from 0x200 to 0xFFFF are forbidden.
	HSMCI_BLKR_BCNT_BLOCK    = 0x5        // SDIO BlockFrom 1 to 511 blocks: Value 0 corresponds to an infinite block transfer.Values from 0x200 to 0xFFFF are forbidden.
	HSMCI_BLKR_BLKLEN_Pos    = 0x10       // Position of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Msk    = 0xffff0000 // Bit mask of BLKLEN field.

	// CSTOR: Completion Signal Timeout Register
	HSMCI_CSTOR_CSTOCYC_Pos     = 0x0  // Position of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Msk     = 0xf  // Bit mask of CSTOCYC field.
	HSMCI_CSTOR_CSTOMUL_Pos     = 0x4  // Position of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Msk     = 0x70 // Bit mask of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_1       = 0x0  // CSTOCYC x 1
	HSMCI_CSTOR_CSTOMUL_16      = 0x1  // CSTOCYC x 16
	HSMCI_CSTOR_CSTOMUL_128     = 0x2  // CSTOCYC x 128
	HSMCI_CSTOR_CSTOMUL_256     = 0x3  // CSTOCYC x 256
	HSMCI_CSTOR_CSTOMUL_1024    = 0x4  // CSTOCYC x 1024
	HSMCI_CSTOR_CSTOMUL_4096    = 0x5  // CSTOCYC x 4096
	HSMCI_CSTOR_CSTOMUL_65536   = 0x6  // CSTOCYC x 65536
	HSMCI_CSTOR_CSTOMUL_1048576 = 0x7  // CSTOCYC x 1048576

	// RSPR: Response Register
	HSMCI_RSPR_RSP_Pos = 0x0        // Position of RSP field.
	HSMCI_RSPR_RSP_Msk = 0xffffffff // Bit mask of RSP field.

	// RDR: Receive Data Register
	HSMCI_RDR_DATA_Pos = 0x0        // Position of DATA field.
	HSMCI_RDR_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// TDR: Transmit Data Register
	HSMCI_TDR_DATA_Pos = 0x0        // Position of DATA field.
	HSMCI_TDR_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// SR: Status Register
	HSMCI_SR_CMDRDY_Pos    = 0x0        // Position of CMDRDY field.
	HSMCI_SR_CMDRDY_Msk    = 0x1        // Bit mask of CMDRDY field.
	HSMCI_SR_CMDRDY        = 0x1        // Bit CMDRDY.
	HSMCI_SR_RXRDY_Pos     = 0x1        // Position of RXRDY field.
	HSMCI_SR_RXRDY_Msk     = 0x2        // Bit mask of RXRDY field.
	HSMCI_SR_RXRDY         = 0x2        // Bit RXRDY.
	HSMCI_SR_TXRDY_Pos     = 0x2        // Position of TXRDY field.
	HSMCI_SR_TXRDY_Msk     = 0x4        // Bit mask of TXRDY field.
	HSMCI_SR_TXRDY         = 0x4        // Bit TXRDY.
	HSMCI_SR_BLKE_Pos      = 0x3        // Position of BLKE field.
	HSMCI_SR_BLKE_Msk      = 0x8        // Bit mask of BLKE field.
	HSMCI_SR_BLKE          = 0x8        // Bit BLKE.
	HSMCI_SR_DTIP_Pos      = 0x4        // Position of DTIP field.
	HSMCI_SR_DTIP_Msk      = 0x10       // Bit mask of DTIP field.
	HSMCI_SR_DTIP          = 0x10       // Bit DTIP.
	HSMCI_SR_NOTBUSY_Pos   = 0x5        // Position of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Msk   = 0x20       // Bit mask of NOTBUSY field.
	HSMCI_SR_NOTBUSY       = 0x20       // Bit NOTBUSY.
	HSMCI_SR_SDIOIRQA_Pos  = 0x8        // Position of SDIOIRQA field.
	HSMCI_SR_SDIOIRQA_Msk  = 0x100      // Bit mask of SDIOIRQA field.
	HSMCI_SR_SDIOIRQA      = 0x100      // Bit SDIOIRQA.
	HSMCI_SR_SDIOWAIT_Pos  = 0xc        // Position of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Msk  = 0x1000     // Bit mask of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT      = 0x1000     // Bit SDIOWAIT.
	HSMCI_SR_CSRCV_Pos     = 0xd        // Position of CSRCV field.
	HSMCI_SR_CSRCV_Msk     = 0x2000     // Bit mask of CSRCV field.
	HSMCI_SR_CSRCV         = 0x2000     // Bit CSRCV.
	HSMCI_SR_RINDE_Pos     = 0x10       // Position of RINDE field.
	HSMCI_SR_RINDE_Msk     = 0x10000    // Bit mask of RINDE field.
	HSMCI_SR_RINDE         = 0x10000    // Bit RINDE.
	HSMCI_SR_RDIRE_Pos     = 0x11       // Position of RDIRE field.
	HSMCI_SR_RDIRE_Msk     = 0x20000    // Bit mask of RDIRE field.
	HSMCI_SR_RDIRE         = 0x20000    // Bit RDIRE.
	HSMCI_SR_RCRCE_Pos     = 0x12       // Position of RCRCE field.
	HSMCI_SR_RCRCE_Msk     = 0x40000    // Bit mask of RCRCE field.
	HSMCI_SR_RCRCE         = 0x40000    // Bit RCRCE.
	HSMCI_SR_RENDE_Pos     = 0x13       // Position of RENDE field.
	HSMCI_SR_RENDE_Msk     = 0x80000    // Bit mask of RENDE field.
	HSMCI_SR_RENDE         = 0x80000    // Bit RENDE.
	HSMCI_SR_RTOE_Pos      = 0x14       // Position of RTOE field.
	HSMCI_SR_RTOE_Msk      = 0x100000   // Bit mask of RTOE field.
	HSMCI_SR_RTOE          = 0x100000   // Bit RTOE.
	HSMCI_SR_DCRCE_Pos     = 0x15       // Position of DCRCE field.
	HSMCI_SR_DCRCE_Msk     = 0x200000   // Bit mask of DCRCE field.
	HSMCI_SR_DCRCE         = 0x200000   // Bit DCRCE.
	HSMCI_SR_DTOE_Pos      = 0x16       // Position of DTOE field.
	HSMCI_SR_DTOE_Msk      = 0x400000   // Bit mask of DTOE field.
	HSMCI_SR_DTOE          = 0x400000   // Bit DTOE.
	HSMCI_SR_CSTOE_Pos     = 0x17       // Position of CSTOE field.
	HSMCI_SR_CSTOE_Msk     = 0x800000   // Bit mask of CSTOE field.
	HSMCI_SR_CSTOE         = 0x800000   // Bit CSTOE.
	HSMCI_SR_BLKOVRE_Pos   = 0x18       // Position of BLKOVRE field.
	HSMCI_SR_BLKOVRE_Msk   = 0x1000000  // Bit mask of BLKOVRE field.
	HSMCI_SR_BLKOVRE       = 0x1000000  // Bit BLKOVRE.
	HSMCI_SR_DMADONE_Pos   = 0x19       // Position of DMADONE field.
	HSMCI_SR_DMADONE_Msk   = 0x2000000  // Bit mask of DMADONE field.
	HSMCI_SR_DMADONE       = 0x2000000  // Bit DMADONE.
	HSMCI_SR_FIFOEMPTY_Pos = 0x1a       // Position of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Msk = 0x4000000  // Bit mask of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY     = 0x4000000  // Bit FIFOEMPTY.
	HSMCI_SR_XFRDONE_Pos   = 0x1b       // Position of XFRDONE field.
	HSMCI_SR_XFRDONE_Msk   = 0x8000000  // Bit mask of XFRDONE field.
	HSMCI_SR_XFRDONE       = 0x8000000  // Bit XFRDONE.
	HSMCI_SR_ACKRCV_Pos    = 0x1c       // Position of ACKRCV field.
	HSMCI_SR_ACKRCV_Msk    = 0x10000000 // Bit mask of ACKRCV field.
	HSMCI_SR_ACKRCV        = 0x10000000 // Bit ACKRCV.
	HSMCI_SR_ACKRCVE_Pos   = 0x1d       // Position of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Msk   = 0x20000000 // Bit mask of ACKRCVE field.
	HSMCI_SR_ACKRCVE       = 0x20000000 // Bit ACKRCVE.
	HSMCI_SR_OVRE_Pos      = 0x1e       // Position of OVRE field.
	HSMCI_SR_OVRE_Msk      = 0x40000000 // Bit mask of OVRE field.
	HSMCI_SR_OVRE          = 0x40000000 // Bit OVRE.
	HSMCI_SR_UNRE_Pos      = 0x1f       // Position of UNRE field.
	HSMCI_SR_UNRE_Msk      = 0x80000000 // Bit mask of UNRE field.
	HSMCI_SR_UNRE          = 0x80000000 // Bit UNRE.

	// IER: Interrupt Enable Register
	HSMCI_IER_CMDRDY_Pos    = 0x0        // Position of CMDRDY field.
	HSMCI_IER_CMDRDY_Msk    = 0x1        // Bit mask of CMDRDY field.
	HSMCI_IER_CMDRDY        = 0x1        // Bit CMDRDY.
	HSMCI_IER_RXRDY_Pos     = 0x1        // Position of RXRDY field.
	HSMCI_IER_RXRDY_Msk     = 0x2        // Bit mask of RXRDY field.
	HSMCI_IER_RXRDY         = 0x2        // Bit RXRDY.
	HSMCI_IER_TXRDY_Pos     = 0x2        // Position of TXRDY field.
	HSMCI_IER_TXRDY_Msk     = 0x4        // Bit mask of TXRDY field.
	HSMCI_IER_TXRDY         = 0x4        // Bit TXRDY.
	HSMCI_IER_BLKE_Pos      = 0x3        // Position of BLKE field.
	HSMCI_IER_BLKE_Msk      = 0x8        // Bit mask of BLKE field.
	HSMCI_IER_BLKE          = 0x8        // Bit BLKE.
	HSMCI_IER_DTIP_Pos      = 0x4        // Position of DTIP field.
	HSMCI_IER_DTIP_Msk      = 0x10       // Bit mask of DTIP field.
	HSMCI_IER_DTIP          = 0x10       // Bit DTIP.
	HSMCI_IER_NOTBUSY_Pos   = 0x5        // Position of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Msk   = 0x20       // Bit mask of NOTBUSY field.
	HSMCI_IER_NOTBUSY       = 0x20       // Bit NOTBUSY.
	HSMCI_IER_SDIOIRQA_Pos  = 0x8        // Position of SDIOIRQA field.
	HSMCI_IER_SDIOIRQA_Msk  = 0x100      // Bit mask of SDIOIRQA field.
	HSMCI_IER_SDIOIRQA      = 0x100      // Bit SDIOIRQA.
	HSMCI_IER_SDIOWAIT_Pos  = 0xc        // Position of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Msk  = 0x1000     // Bit mask of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT      = 0x1000     // Bit SDIOWAIT.
	HSMCI_IER_CSRCV_Pos     = 0xd        // Position of CSRCV field.
	HSMCI_IER_CSRCV_Msk     = 0x2000     // Bit mask of CSRCV field.
	HSMCI_IER_CSRCV         = 0x2000     // Bit CSRCV.
	HSMCI_IER_RINDE_Pos     = 0x10       // Position of RINDE field.
	HSMCI_IER_RINDE_Msk     = 0x10000    // Bit mask of RINDE field.
	HSMCI_IER_RINDE         = 0x10000    // Bit RINDE.
	HSMCI_IER_RDIRE_Pos     = 0x11       // Position of RDIRE field.
	HSMCI_IER_RDIRE_Msk     = 0x20000    // Bit mask of RDIRE field.
	HSMCI_IER_RDIRE         = 0x20000    // Bit RDIRE.
	HSMCI_IER_RCRCE_Pos     = 0x12       // Position of RCRCE field.
	HSMCI_IER_RCRCE_Msk     = 0x40000    // Bit mask of RCRCE field.
	HSMCI_IER_RCRCE         = 0x40000    // Bit RCRCE.
	HSMCI_IER_RENDE_Pos     = 0x13       // Position of RENDE field.
	HSMCI_IER_RENDE_Msk     = 0x80000    // Bit mask of RENDE field.
	HSMCI_IER_RENDE         = 0x80000    // Bit RENDE.
	HSMCI_IER_RTOE_Pos      = 0x14       // Position of RTOE field.
	HSMCI_IER_RTOE_Msk      = 0x100000   // Bit mask of RTOE field.
	HSMCI_IER_RTOE          = 0x100000   // Bit RTOE.
	HSMCI_IER_DCRCE_Pos     = 0x15       // Position of DCRCE field.
	HSMCI_IER_DCRCE_Msk     = 0x200000   // Bit mask of DCRCE field.
	HSMCI_IER_DCRCE         = 0x200000   // Bit DCRCE.
	HSMCI_IER_DTOE_Pos      = 0x16       // Position of DTOE field.
	HSMCI_IER_DTOE_Msk      = 0x400000   // Bit mask of DTOE field.
	HSMCI_IER_DTOE          = 0x400000   // Bit DTOE.
	HSMCI_IER_CSTOE_Pos     = 0x17       // Position of CSTOE field.
	HSMCI_IER_CSTOE_Msk     = 0x800000   // Bit mask of CSTOE field.
	HSMCI_IER_CSTOE         = 0x800000   // Bit CSTOE.
	HSMCI_IER_BLKOVRE_Pos   = 0x18       // Position of BLKOVRE field.
	HSMCI_IER_BLKOVRE_Msk   = 0x1000000  // Bit mask of BLKOVRE field.
	HSMCI_IER_BLKOVRE       = 0x1000000  // Bit BLKOVRE.
	HSMCI_IER_DMADONE_Pos   = 0x19       // Position of DMADONE field.
	HSMCI_IER_DMADONE_Msk   = 0x2000000  // Bit mask of DMADONE field.
	HSMCI_IER_DMADONE       = 0x2000000  // Bit DMADONE.
	HSMCI_IER_FIFOEMPTY_Pos = 0x1a       // Position of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Msk = 0x4000000  // Bit mask of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY     = 0x4000000  // Bit FIFOEMPTY.
	HSMCI_IER_XFRDONE_Pos   = 0x1b       // Position of XFRDONE field.
	HSMCI_IER_XFRDONE_Msk   = 0x8000000  // Bit mask of XFRDONE field.
	HSMCI_IER_XFRDONE       = 0x8000000  // Bit XFRDONE.
	HSMCI_IER_ACKRCV_Pos    = 0x1c       // Position of ACKRCV field.
	HSMCI_IER_ACKRCV_Msk    = 0x10000000 // Bit mask of ACKRCV field.
	HSMCI_IER_ACKRCV        = 0x10000000 // Bit ACKRCV.
	HSMCI_IER_ACKRCVE_Pos   = 0x1d       // Position of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Msk   = 0x20000000 // Bit mask of ACKRCVE field.
	HSMCI_IER_ACKRCVE       = 0x20000000 // Bit ACKRCVE.
	HSMCI_IER_OVRE_Pos      = 0x1e       // Position of OVRE field.
	HSMCI_IER_OVRE_Msk      = 0x40000000 // Bit mask of OVRE field.
	HSMCI_IER_OVRE          = 0x40000000 // Bit OVRE.
	HSMCI_IER_UNRE_Pos      = 0x1f       // Position of UNRE field.
	HSMCI_IER_UNRE_Msk      = 0x80000000 // Bit mask of UNRE field.
	HSMCI_IER_UNRE          = 0x80000000 // Bit UNRE.

	// IDR: Interrupt Disable Register
	HSMCI_IDR_CMDRDY_Pos    = 0x0        // Position of CMDRDY field.
	HSMCI_IDR_CMDRDY_Msk    = 0x1        // Bit mask of CMDRDY field.
	HSMCI_IDR_CMDRDY        = 0x1        // Bit CMDRDY.
	HSMCI_IDR_RXRDY_Pos     = 0x1        // Position of RXRDY field.
	HSMCI_IDR_RXRDY_Msk     = 0x2        // Bit mask of RXRDY field.
	HSMCI_IDR_RXRDY         = 0x2        // Bit RXRDY.
	HSMCI_IDR_TXRDY_Pos     = 0x2        // Position of TXRDY field.
	HSMCI_IDR_TXRDY_Msk     = 0x4        // Bit mask of TXRDY field.
	HSMCI_IDR_TXRDY         = 0x4        // Bit TXRDY.
	HSMCI_IDR_BLKE_Pos      = 0x3        // Position of BLKE field.
	HSMCI_IDR_BLKE_Msk      = 0x8        // Bit mask of BLKE field.
	HSMCI_IDR_BLKE          = 0x8        // Bit BLKE.
	HSMCI_IDR_DTIP_Pos      = 0x4        // Position of DTIP field.
	HSMCI_IDR_DTIP_Msk      = 0x10       // Bit mask of DTIP field.
	HSMCI_IDR_DTIP          = 0x10       // Bit DTIP.
	HSMCI_IDR_NOTBUSY_Pos   = 0x5        // Position of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Msk   = 0x20       // Bit mask of NOTBUSY field.
	HSMCI_IDR_NOTBUSY       = 0x20       // Bit NOTBUSY.
	HSMCI_IDR_SDIOIRQA_Pos  = 0x8        // Position of SDIOIRQA field.
	HSMCI_IDR_SDIOIRQA_Msk  = 0x100      // Bit mask of SDIOIRQA field.
	HSMCI_IDR_SDIOIRQA      = 0x100      // Bit SDIOIRQA.
	HSMCI_IDR_SDIOWAIT_Pos  = 0xc        // Position of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Msk  = 0x1000     // Bit mask of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT      = 0x1000     // Bit SDIOWAIT.
	HSMCI_IDR_CSRCV_Pos     = 0xd        // Position of CSRCV field.
	HSMCI_IDR_CSRCV_Msk     = 0x2000     // Bit mask of CSRCV field.
	HSMCI_IDR_CSRCV         = 0x2000     // Bit CSRCV.
	HSMCI_IDR_RINDE_Pos     = 0x10       // Position of RINDE field.
	HSMCI_IDR_RINDE_Msk     = 0x10000    // Bit mask of RINDE field.
	HSMCI_IDR_RINDE         = 0x10000    // Bit RINDE.
	HSMCI_IDR_RDIRE_Pos     = 0x11       // Position of RDIRE field.
	HSMCI_IDR_RDIRE_Msk     = 0x20000    // Bit mask of RDIRE field.
	HSMCI_IDR_RDIRE         = 0x20000    // Bit RDIRE.
	HSMCI_IDR_RCRCE_Pos     = 0x12       // Position of RCRCE field.
	HSMCI_IDR_RCRCE_Msk     = 0x40000    // Bit mask of RCRCE field.
	HSMCI_IDR_RCRCE         = 0x40000    // Bit RCRCE.
	HSMCI_IDR_RENDE_Pos     = 0x13       // Position of RENDE field.
	HSMCI_IDR_RENDE_Msk     = 0x80000    // Bit mask of RENDE field.
	HSMCI_IDR_RENDE         = 0x80000    // Bit RENDE.
	HSMCI_IDR_RTOE_Pos      = 0x14       // Position of RTOE field.
	HSMCI_IDR_RTOE_Msk      = 0x100000   // Bit mask of RTOE field.
	HSMCI_IDR_RTOE          = 0x100000   // Bit RTOE.
	HSMCI_IDR_DCRCE_Pos     = 0x15       // Position of DCRCE field.
	HSMCI_IDR_DCRCE_Msk     = 0x200000   // Bit mask of DCRCE field.
	HSMCI_IDR_DCRCE         = 0x200000   // Bit DCRCE.
	HSMCI_IDR_DTOE_Pos      = 0x16       // Position of DTOE field.
	HSMCI_IDR_DTOE_Msk      = 0x400000   // Bit mask of DTOE field.
	HSMCI_IDR_DTOE          = 0x400000   // Bit DTOE.
	HSMCI_IDR_CSTOE_Pos     = 0x17       // Position of CSTOE field.
	HSMCI_IDR_CSTOE_Msk     = 0x800000   // Bit mask of CSTOE field.
	HSMCI_IDR_CSTOE         = 0x800000   // Bit CSTOE.
	HSMCI_IDR_BLKOVRE_Pos   = 0x18       // Position of BLKOVRE field.
	HSMCI_IDR_BLKOVRE_Msk   = 0x1000000  // Bit mask of BLKOVRE field.
	HSMCI_IDR_BLKOVRE       = 0x1000000  // Bit BLKOVRE.
	HSMCI_IDR_DMADONE_Pos   = 0x19       // Position of DMADONE field.
	HSMCI_IDR_DMADONE_Msk   = 0x2000000  // Bit mask of DMADONE field.
	HSMCI_IDR_DMADONE       = 0x2000000  // Bit DMADONE.
	HSMCI_IDR_FIFOEMPTY_Pos = 0x1a       // Position of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Msk = 0x4000000  // Bit mask of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY     = 0x4000000  // Bit FIFOEMPTY.
	HSMCI_IDR_XFRDONE_Pos   = 0x1b       // Position of XFRDONE field.
	HSMCI_IDR_XFRDONE_Msk   = 0x8000000  // Bit mask of XFRDONE field.
	HSMCI_IDR_XFRDONE       = 0x8000000  // Bit XFRDONE.
	HSMCI_IDR_ACKRCV_Pos    = 0x1c       // Position of ACKRCV field.
	HSMCI_IDR_ACKRCV_Msk    = 0x10000000 // Bit mask of ACKRCV field.
	HSMCI_IDR_ACKRCV        = 0x10000000 // Bit ACKRCV.
	HSMCI_IDR_ACKRCVE_Pos   = 0x1d       // Position of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Msk   = 0x20000000 // Bit mask of ACKRCVE field.
	HSMCI_IDR_ACKRCVE       = 0x20000000 // Bit ACKRCVE.
	HSMCI_IDR_OVRE_Pos      = 0x1e       // Position of OVRE field.
	HSMCI_IDR_OVRE_Msk      = 0x40000000 // Bit mask of OVRE field.
	HSMCI_IDR_OVRE          = 0x40000000 // Bit OVRE.
	HSMCI_IDR_UNRE_Pos      = 0x1f       // Position of UNRE field.
	HSMCI_IDR_UNRE_Msk      = 0x80000000 // Bit mask of UNRE field.
	HSMCI_IDR_UNRE          = 0x80000000 // Bit UNRE.

	// IMR: Interrupt Mask Register
	HSMCI_IMR_CMDRDY_Pos    = 0x0        // Position of CMDRDY field.
	HSMCI_IMR_CMDRDY_Msk    = 0x1        // Bit mask of CMDRDY field.
	HSMCI_IMR_CMDRDY        = 0x1        // Bit CMDRDY.
	HSMCI_IMR_RXRDY_Pos     = 0x1        // Position of RXRDY field.
	HSMCI_IMR_RXRDY_Msk     = 0x2        // Bit mask of RXRDY field.
	HSMCI_IMR_RXRDY         = 0x2        // Bit RXRDY.
	HSMCI_IMR_TXRDY_Pos     = 0x2        // Position of TXRDY field.
	HSMCI_IMR_TXRDY_Msk     = 0x4        // Bit mask of TXRDY field.
	HSMCI_IMR_TXRDY         = 0x4        // Bit TXRDY.
	HSMCI_IMR_BLKE_Pos      = 0x3        // Position of BLKE field.
	HSMCI_IMR_BLKE_Msk      = 0x8        // Bit mask of BLKE field.
	HSMCI_IMR_BLKE          = 0x8        // Bit BLKE.
	HSMCI_IMR_DTIP_Pos      = 0x4        // Position of DTIP field.
	HSMCI_IMR_DTIP_Msk      = 0x10       // Bit mask of DTIP field.
	HSMCI_IMR_DTIP          = 0x10       // Bit DTIP.
	HSMCI_IMR_NOTBUSY_Pos   = 0x5        // Position of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Msk   = 0x20       // Bit mask of NOTBUSY field.
	HSMCI_IMR_NOTBUSY       = 0x20       // Bit NOTBUSY.
	HSMCI_IMR_SDIOIRQA_Pos  = 0x8        // Position of SDIOIRQA field.
	HSMCI_IMR_SDIOIRQA_Msk  = 0x100      // Bit mask of SDIOIRQA field.
	HSMCI_IMR_SDIOIRQA      = 0x100      // Bit SDIOIRQA.
	HSMCI_IMR_SDIOWAIT_Pos  = 0xc        // Position of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Msk  = 0x1000     // Bit mask of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT      = 0x1000     // Bit SDIOWAIT.
	HSMCI_IMR_CSRCV_Pos     = 0xd        // Position of CSRCV field.
	HSMCI_IMR_CSRCV_Msk     = 0x2000     // Bit mask of CSRCV field.
	HSMCI_IMR_CSRCV         = 0x2000     // Bit CSRCV.
	HSMCI_IMR_RINDE_Pos     = 0x10       // Position of RINDE field.
	HSMCI_IMR_RINDE_Msk     = 0x10000    // Bit mask of RINDE field.
	HSMCI_IMR_RINDE         = 0x10000    // Bit RINDE.
	HSMCI_IMR_RDIRE_Pos     = 0x11       // Position of RDIRE field.
	HSMCI_IMR_RDIRE_Msk     = 0x20000    // Bit mask of RDIRE field.
	HSMCI_IMR_RDIRE         = 0x20000    // Bit RDIRE.
	HSMCI_IMR_RCRCE_Pos     = 0x12       // Position of RCRCE field.
	HSMCI_IMR_RCRCE_Msk     = 0x40000    // Bit mask of RCRCE field.
	HSMCI_IMR_RCRCE         = 0x40000    // Bit RCRCE.
	HSMCI_IMR_RENDE_Pos     = 0x13       // Position of RENDE field.
	HSMCI_IMR_RENDE_Msk     = 0x80000    // Bit mask of RENDE field.
	HSMCI_IMR_RENDE         = 0x80000    // Bit RENDE.
	HSMCI_IMR_RTOE_Pos      = 0x14       // Position of RTOE field.
	HSMCI_IMR_RTOE_Msk      = 0x100000   // Bit mask of RTOE field.
	HSMCI_IMR_RTOE          = 0x100000   // Bit RTOE.
	HSMCI_IMR_DCRCE_Pos     = 0x15       // Position of DCRCE field.
	HSMCI_IMR_DCRCE_Msk     = 0x200000   // Bit mask of DCRCE field.
	HSMCI_IMR_DCRCE         = 0x200000   // Bit DCRCE.
	HSMCI_IMR_DTOE_Pos      = 0x16       // Position of DTOE field.
	HSMCI_IMR_DTOE_Msk      = 0x400000   // Bit mask of DTOE field.
	HSMCI_IMR_DTOE          = 0x400000   // Bit DTOE.
	HSMCI_IMR_CSTOE_Pos     = 0x17       // Position of CSTOE field.
	HSMCI_IMR_CSTOE_Msk     = 0x800000   // Bit mask of CSTOE field.
	HSMCI_IMR_CSTOE         = 0x800000   // Bit CSTOE.
	HSMCI_IMR_BLKOVRE_Pos   = 0x18       // Position of BLKOVRE field.
	HSMCI_IMR_BLKOVRE_Msk   = 0x1000000  // Bit mask of BLKOVRE field.
	HSMCI_IMR_BLKOVRE       = 0x1000000  // Bit BLKOVRE.
	HSMCI_IMR_DMADONE_Pos   = 0x19       // Position of DMADONE field.
	HSMCI_IMR_DMADONE_Msk   = 0x2000000  // Bit mask of DMADONE field.
	HSMCI_IMR_DMADONE       = 0x2000000  // Bit DMADONE.
	HSMCI_IMR_FIFOEMPTY_Pos = 0x1a       // Position of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Msk = 0x4000000  // Bit mask of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY     = 0x4000000  // Bit FIFOEMPTY.
	HSMCI_IMR_XFRDONE_Pos   = 0x1b       // Position of XFRDONE field.
	HSMCI_IMR_XFRDONE_Msk   = 0x8000000  // Bit mask of XFRDONE field.
	HSMCI_IMR_XFRDONE       = 0x8000000  // Bit XFRDONE.
	HSMCI_IMR_ACKRCV_Pos    = 0x1c       // Position of ACKRCV field.
	HSMCI_IMR_ACKRCV_Msk    = 0x10000000 // Bit mask of ACKRCV field.
	HSMCI_IMR_ACKRCV        = 0x10000000 // Bit ACKRCV.
	HSMCI_IMR_ACKRCVE_Pos   = 0x1d       // Position of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Msk   = 0x20000000 // Bit mask of ACKRCVE field.
	HSMCI_IMR_ACKRCVE       = 0x20000000 // Bit ACKRCVE.
	HSMCI_IMR_OVRE_Pos      = 0x1e       // Position of OVRE field.
	HSMCI_IMR_OVRE_Msk      = 0x40000000 // Bit mask of OVRE field.
	HSMCI_IMR_OVRE          = 0x40000000 // Bit OVRE.
	HSMCI_IMR_UNRE_Pos      = 0x1f       // Position of UNRE field.
	HSMCI_IMR_UNRE_Msk      = 0x80000000 // Bit mask of UNRE field.
	HSMCI_IMR_UNRE          = 0x80000000 // Bit UNRE.

	// DMA: DMA Configuration Register
	HSMCI_DMA_OFFSET_Pos  = 0x0    // Position of OFFSET field.
	HSMCI_DMA_OFFSET_Msk  = 0x3    // Bit mask of OFFSET field.
	HSMCI_DMA_CHKSIZE_Pos = 0x4    // Position of CHKSIZE field.
	HSMCI_DMA_CHKSIZE_Msk = 0x30   // Bit mask of CHKSIZE field.
	HSMCI_DMA_CHKSIZE_1   = 0x0    // 1 data available
	HSMCI_DMA_CHKSIZE_4   = 0x1    // 4 data available
	HSMCI_DMA_DMAEN_Pos   = 0x8    // Position of DMAEN field.
	HSMCI_DMA_DMAEN_Msk   = 0x100  // Bit mask of DMAEN field.
	HSMCI_DMA_DMAEN       = 0x100  // Bit DMAEN.
	HSMCI_DMA_ROPT_Pos    = 0xc    // Position of ROPT field.
	HSMCI_DMA_ROPT_Msk    = 0x1000 // Bit mask of ROPT field.
	HSMCI_DMA_ROPT        = 0x1000 // Bit ROPT.

	// CFG: Configuration Register
	HSMCI_CFG_FIFOMODE_Pos = 0x0    // Position of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Msk = 0x1    // Bit mask of FIFOMODE field.
	HSMCI_CFG_FIFOMODE     = 0x1    // Bit FIFOMODE.
	HSMCI_CFG_FERRCTRL_Pos = 0x4    // Position of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Msk = 0x10   // Bit mask of FERRCTRL field.
	HSMCI_CFG_FERRCTRL     = 0x10   // Bit FERRCTRL.
	HSMCI_CFG_HSMODE_Pos   = 0x8    // Position of HSMODE field.
	HSMCI_CFG_HSMODE_Msk   = 0x100  // Bit mask of HSMODE field.
	HSMCI_CFG_HSMODE       = 0x100  // Bit HSMODE.
	HSMCI_CFG_LSYNC_Pos    = 0xc    // Position of LSYNC field.
	HSMCI_CFG_LSYNC_Msk    = 0x1000 // Bit mask of LSYNC field.
	HSMCI_CFG_LSYNC        = 0x1000 // Bit LSYNC.

	// WPMR: Write Protection Mode Register
	HSMCI_WPMR_WP_EN_Pos  = 0x0        // Position of WP_EN field.
	HSMCI_WPMR_WP_EN_Msk  = 0x1        // Bit mask of WP_EN field.
	HSMCI_WPMR_WP_EN      = 0x1        // Bit WP_EN.
	HSMCI_WPMR_WP_KEY_Pos = 0x8        // Position of WP_KEY field.
	HSMCI_WPMR_WP_KEY_Msk = 0xffffff00 // Bit mask of WP_KEY field.

	// WPSR: Write Protection Status Register
	HSMCI_WPSR_WP_VS_Pos   = 0x0      // Position of WP_VS field.
	HSMCI_WPSR_WP_VS_Msk   = 0xf      // Bit mask of WP_VS field.
	HSMCI_WPSR_WP_VS_NONE  = 0x0      // No Write Protection Violation occurred since the last read of this register (WP_SR)
	HSMCI_WPSR_WP_VS_WRITE = 0x1      // Write Protection detected unauthorized attempt to write a control register had occurred (since the last read.)
	HSMCI_WPSR_WP_VS_RESET = 0x2      // Software reset had been performed while Write Protection was enabled (since the last read).
	HSMCI_WPSR_WP_VS_BOTH  = 0x3      // Both Write Protection violation and software reset with Write Protection enabled have occurred since the last read.
	HSMCI_WPSR_WP_VSRC_Pos = 0x8      // Position of WP_VSRC field.
	HSMCI_WPSR_WP_VSRC_Msk = 0xffff00 // Bit mask of WP_VSRC field.

	// FIFO: FIFO Memory Aperture0
	HSMCI_FIFO_DATA_Pos = 0x0        // Position of DATA field.
	HSMCI_FIFO_DATA_Msk = 0xffffffff // Bit mask of DATA field.
)

// Bitfields for SSC: Synchronous Serial Controller
const (
	// CR: Control Register
	SSC_CR_RXEN_Pos  = 0x0    // Position of RXEN field.
	SSC_CR_RXEN_Msk  = 0x1    // Bit mask of RXEN field.
	SSC_CR_RXEN      = 0x1    // Bit RXEN.
	SSC_CR_RXDIS_Pos = 0x1    // Position of RXDIS field.
	SSC_CR_RXDIS_Msk = 0x2    // Bit mask of RXDIS field.
	SSC_CR_RXDIS     = 0x2    // Bit RXDIS.
	SSC_CR_TXEN_Pos  = 0x8    // Position of TXEN field.
	SSC_CR_TXEN_Msk  = 0x100  // Bit mask of TXEN field.
	SSC_CR_TXEN      = 0x100  // Bit TXEN.
	SSC_CR_TXDIS_Pos = 0x9    // Position of TXDIS field.
	SSC_CR_TXDIS_Msk = 0x200  // Bit mask of TXDIS field.
	SSC_CR_TXDIS     = 0x200  // Bit TXDIS.
	SSC_CR_SWRST_Pos = 0xf    // Position of SWRST field.
	SSC_CR_SWRST_Msk = 0x8000 // Bit mask of SWRST field.
	SSC_CR_SWRST     = 0x8000 // Bit SWRST.

	// CMR: Clock Mode Register
	SSC_CMR_DIV_Pos = 0x0   // Position of DIV field.
	SSC_CMR_DIV_Msk = 0xfff // Bit mask of DIV field.

	// RCMR: Receive Clock Mode Register
	SSC_RCMR_CKS_Pos          = 0x0        // Position of CKS field.
	SSC_RCMR_CKS_Msk          = 0x3        // Bit mask of CKS field.
	SSC_RCMR_CKS_MCK          = 0x0        // Divided Clock
	SSC_RCMR_CKS_TK           = 0x1        // TK Clock signal
	SSC_RCMR_CKS_RK           = 0x2        // RK pin
	SSC_RCMR_CKO_Pos          = 0x2        // Position of CKO field.
	SSC_RCMR_CKO_Msk          = 0x1c       // Bit mask of CKO field.
	SSC_RCMR_CKO_NONE         = 0x0        // None
	SSC_RCMR_CKO_CONTINUOUS   = 0x1        // Continuous Receive Clock
	SSC_RCMR_CKO_TRANSFER     = 0x2        // Receive Clock only during data transfers
	SSC_RCMR_CKI_Pos          = 0x5        // Position of CKI field.
	SSC_RCMR_CKI_Msk          = 0x20       // Bit mask of CKI field.
	SSC_RCMR_CKI              = 0x20       // Bit CKI.
	SSC_RCMR_CKG_Pos          = 0x6        // Position of CKG field.
	SSC_RCMR_CKG_Msk          = 0xc0       // Bit mask of CKG field.
	SSC_RCMR_CKG_NONE         = 0x0        // None
	SSC_RCMR_CKG_CONTINUOUS   = 0x1        // Continuous Receive Clock
	SSC_RCMR_CKG_TRANSFER     = 0x2        // Receive Clock only during data transfers
	SSC_RCMR_START_Pos        = 0x8        // Position of START field.
	SSC_RCMR_START_Msk        = 0xf00      // Bit mask of START field.
	SSC_RCMR_START_CONTINUOUS = 0x0        // Continuous, as soon as the receiver is enabled, and immediately after the end of transfer of the previous data.
	SSC_RCMR_START_TRANSMIT   = 0x1        // Transmit start
	SSC_RCMR_START_RF_LOW     = 0x2        // Detection of a low level on RF signal
	SSC_RCMR_START_RF_HIGH    = 0x3        // Detection of a high level on RF signal
	SSC_RCMR_START_RF_FALLING = 0x4        // Detection of a falling edge on RF signal
	SSC_RCMR_START_RF_RISING  = 0x5        // Detection of a rising edge on RF signal
	SSC_RCMR_START_RF_LEVEL   = 0x6        // Detection of any level change on RF signal
	SSC_RCMR_START_RF_EDGE    = 0x7        // Detection of any edge on RF signal
	SSC_RCMR_START_CMP_0      = 0x8        // Compare 0
	SSC_RCMR_STOP_Pos         = 0xc        // Position of STOP field.
	SSC_RCMR_STOP_Msk         = 0x1000     // Bit mask of STOP field.
	SSC_RCMR_STOP             = 0x1000     // Bit STOP.
	SSC_RCMR_STTDLY_Pos       = 0x10       // Position of STTDLY field.
	SSC_RCMR_STTDLY_Msk       = 0xff0000   // Bit mask of STTDLY field.
	SSC_RCMR_PERIOD_Pos       = 0x18       // Position of PERIOD field.
	SSC_RCMR_PERIOD_Msk       = 0xff000000 // Bit mask of PERIOD field.

	// RFMR: Receive Frame Mode Register
	SSC_RFMR_DATLEN_Pos      = 0x0        // Position of DATLEN field.
	SSC_RFMR_DATLEN_Msk      = 0x1f       // Bit mask of DATLEN field.
	SSC_RFMR_LOOP_Pos        = 0x5        // Position of LOOP field.
	SSC_RFMR_LOOP_Msk        = 0x20       // Bit mask of LOOP field.
	SSC_RFMR_LOOP            = 0x20       // Bit LOOP.
	SSC_RFMR_MSBF_Pos        = 0x7        // Position of MSBF field.
	SSC_RFMR_MSBF_Msk        = 0x80       // Bit mask of MSBF field.
	SSC_RFMR_MSBF            = 0x80       // Bit MSBF.
	SSC_RFMR_DATNB_Pos       = 0x8        // Position of DATNB field.
	SSC_RFMR_DATNB_Msk       = 0xf00      // Bit mask of DATNB field.
	SSC_RFMR_FSLEN_Pos       = 0x10       // Position of FSLEN field.
	SSC_RFMR_FSLEN_Msk       = 0xf0000    // Bit mask of FSLEN field.
	SSC_RFMR_FSOS_Pos        = 0x14       // Position of FSOS field.
	SSC_RFMR_FSOS_Msk        = 0x700000   // Bit mask of FSOS field.
	SSC_RFMR_FSOS_NONE       = 0x0        // None
	SSC_RFMR_FSOS_NEGATIVE   = 0x1        // Negative Pulse
	SSC_RFMR_FSOS_POSITIVE   = 0x2        // Positive Pulse
	SSC_RFMR_FSOS_LOW        = 0x3        // Driven Low during data transfer
	SSC_RFMR_FSOS_HIGH       = 0x4        // Driven High during data transfer
	SSC_RFMR_FSOS_TOGGLING   = 0x5        // Toggling at each start of data transfer
	SSC_RFMR_FSEDGE_Pos      = 0x18       // Position of FSEDGE field.
	SSC_RFMR_FSEDGE_Msk      = 0x1000000  // Bit mask of FSEDGE field.
	SSC_RFMR_FSEDGE          = 0x1000000  // Bit FSEDGE.
	SSC_RFMR_FSEDGE_POSITIVE = 0x0        // Positive Edge Detection
	SSC_RFMR_FSEDGE_NEGATIVE = 0x1        // Negative Edge Detection
	SSC_RFMR_FSLEN_EXT_Pos   = 0x1c       // Position of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Msk   = 0xf0000000 // Bit mask of FSLEN_EXT field.

	// TCMR: Transmit Clock Mode Register
	SSC_TCMR_CKS_Pos          = 0x0        // Position of CKS field.
	SSC_TCMR_CKS_Msk          = 0x3        // Bit mask of CKS field.
	SSC_TCMR_CKS_MCK          = 0x0        // Divided Clock
	SSC_TCMR_CKS_TK           = 0x1        // TK Clock signal
	SSC_TCMR_CKS_RK           = 0x2        // RK pin
	SSC_TCMR_CKO_Pos          = 0x2        // Position of CKO field.
	SSC_TCMR_CKO_Msk          = 0x1c       // Bit mask of CKO field.
	SSC_TCMR_CKO_NONE         = 0x0        // None
	SSC_TCMR_CKO_CONTINUOUS   = 0x1        // Continuous Receive Clock
	SSC_TCMR_CKO_TRANSFER     = 0x2        // Transmit Clock only during data transfers
	SSC_TCMR_CKI_Pos          = 0x5        // Position of CKI field.
	SSC_TCMR_CKI_Msk          = 0x20       // Bit mask of CKI field.
	SSC_TCMR_CKI              = 0x20       // Bit CKI.
	SSC_TCMR_CKG_Pos          = 0x6        // Position of CKG field.
	SSC_TCMR_CKG_Msk          = 0xc0       // Bit mask of CKG field.
	SSC_TCMR_CKG_NONE         = 0x0        // None
	SSC_TCMR_CKG_CONTINUOUS   = 0x1        // Transmit Clock enabled only if TF Low
	SSC_TCMR_CKG_TRANSFER     = 0x2        // Transmit Clock enabled only if TF High
	SSC_TCMR_START_Pos        = 0x8        // Position of START field.
	SSC_TCMR_START_Msk        = 0xf00      // Bit mask of START field.
	SSC_TCMR_START_CONTINUOUS = 0x0        // Continuous, as soon as a word is written in the SSC_THR Register (if Transmit is enabled), and immediately after the end of transfer of the previous data.
	SSC_TCMR_START_RECEIVE    = 0x1        // Receive start
	SSC_TCMR_START_RF_LOW     = 0x2        // Detection of a low level on TF signal
	SSC_TCMR_START_RF_HIGH    = 0x3        // Detection of a high level on TF signal
	SSC_TCMR_START_RF_FALLING = 0x4        // Detection of a falling edge on TF signal
	SSC_TCMR_START_RF_RISING  = 0x5        // Detection of a rising edge on TF signal
	SSC_TCMR_START_RF_LEVEL   = 0x6        // Detection of any level change on TF signal
	SSC_TCMR_START_RF_EDGE    = 0x7        // Detection of any edge on TF signal
	SSC_TCMR_START_CMP_0      = 0x8        // Compare 0
	SSC_TCMR_STTDLY_Pos       = 0x10       // Position of STTDLY field.
	SSC_TCMR_STTDLY_Msk       = 0xff0000   // Bit mask of STTDLY field.
	SSC_TCMR_PERIOD_Pos       = 0x18       // Position of PERIOD field.
	SSC_TCMR_PERIOD_Msk       = 0xff000000 // Bit mask of PERIOD field.

	// TFMR: Transmit Frame Mode Register
	SSC_TFMR_DATLEN_Pos      = 0x0        // Position of DATLEN field.
	SSC_TFMR_DATLEN_Msk      = 0x1f       // Bit mask of DATLEN field.
	SSC_TFMR_DATDEF_Pos      = 0x5        // Position of DATDEF field.
	SSC_TFMR_DATDEF_Msk      = 0x20       // Bit mask of DATDEF field.
	SSC_TFMR_DATDEF          = 0x20       // Bit DATDEF.
	SSC_TFMR_MSBF_Pos        = 0x7        // Position of MSBF field.
	SSC_TFMR_MSBF_Msk        = 0x80       // Bit mask of MSBF field.
	SSC_TFMR_MSBF            = 0x80       // Bit MSBF.
	SSC_TFMR_DATNB_Pos       = 0x8        // Position of DATNB field.
	SSC_TFMR_DATNB_Msk       = 0xf00      // Bit mask of DATNB field.
	SSC_TFMR_FSLEN_Pos       = 0x10       // Position of FSLEN field.
	SSC_TFMR_FSLEN_Msk       = 0xf0000    // Bit mask of FSLEN field.
	SSC_TFMR_FSOS_Pos        = 0x14       // Position of FSOS field.
	SSC_TFMR_FSOS_Msk        = 0x700000   // Bit mask of FSOS field.
	SSC_TFMR_FSOS_NONE       = 0x0        // None
	SSC_TFMR_FSOS_NEGATIVE   = 0x1        // Negative Pulse
	SSC_TFMR_FSOS_POSITIVE   = 0x2        // Positive Pulse
	SSC_TFMR_FSOS_LOW        = 0x3        // Driven Low during data transfer
	SSC_TFMR_FSOS_HIGH       = 0x4        // Driven High during data transfer
	SSC_TFMR_FSOS_TOGGLING   = 0x5        // Toggling at each start of data transfer
	SSC_TFMR_FSDEN_Pos       = 0x17       // Position of FSDEN field.
	SSC_TFMR_FSDEN_Msk       = 0x800000   // Bit mask of FSDEN field.
	SSC_TFMR_FSDEN           = 0x800000   // Bit FSDEN.
	SSC_TFMR_FSEDGE_Pos      = 0x18       // Position of FSEDGE field.
	SSC_TFMR_FSEDGE_Msk      = 0x1000000  // Bit mask of FSEDGE field.
	SSC_TFMR_FSEDGE          = 0x1000000  // Bit FSEDGE.
	SSC_TFMR_FSEDGE_POSITIVE = 0x0        // Positive Edge Detection
	SSC_TFMR_FSEDGE_NEGATIVE = 0x1        // Negative Edge Detection
	SSC_TFMR_FSLEN_EXT_Pos   = 0x1c       // Position of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Msk   = 0xf0000000 // Bit mask of FSLEN_EXT field.

	// RHR: Receive Holding Register
	SSC_RHR_RDAT_Pos = 0x0        // Position of RDAT field.
	SSC_RHR_RDAT_Msk = 0xffffffff // Bit mask of RDAT field.

	// THR: Transmit Holding Register
	SSC_THR_TDAT_Pos = 0x0        // Position of TDAT field.
	SSC_THR_TDAT_Msk = 0xffffffff // Bit mask of TDAT field.

	// RSHR: Receive Sync. Holding Register
	SSC_RSHR_RSDAT_Pos = 0x0    // Position of RSDAT field.
	SSC_RSHR_RSDAT_Msk = 0xffff // Bit mask of RSDAT field.

	// TSHR: Transmit Sync. Holding Register
	SSC_TSHR_TSDAT_Pos = 0x0    // Position of TSDAT field.
	SSC_TSHR_TSDAT_Msk = 0xffff // Bit mask of TSDAT field.

	// RC0R: Receive Compare 0 Register
	SSC_RC0R_CP0_Pos = 0x0    // Position of CP0 field.
	SSC_RC0R_CP0_Msk = 0xffff // Bit mask of CP0 field.

	// RC1R: Receive Compare 1 Register
	SSC_RC1R_CP1_Pos = 0x0    // Position of CP1 field.
	SSC_RC1R_CP1_Msk = 0xffff // Bit mask of CP1 field.

	// SR: Status Register
	SSC_SR_TXRDY_Pos   = 0x0     // Position of TXRDY field.
	SSC_SR_TXRDY_Msk   = 0x1     // Bit mask of TXRDY field.
	SSC_SR_TXRDY       = 0x1     // Bit TXRDY.
	SSC_SR_TXEMPTY_Pos = 0x1     // Position of TXEMPTY field.
	SSC_SR_TXEMPTY_Msk = 0x2     // Bit mask of TXEMPTY field.
	SSC_SR_TXEMPTY     = 0x2     // Bit TXEMPTY.
	SSC_SR_RXRDY_Pos   = 0x4     // Position of RXRDY field.
	SSC_SR_RXRDY_Msk   = 0x10    // Bit mask of RXRDY field.
	SSC_SR_RXRDY       = 0x10    // Bit RXRDY.
	SSC_SR_OVRUN_Pos   = 0x5     // Position of OVRUN field.
	SSC_SR_OVRUN_Msk   = 0x20    // Bit mask of OVRUN field.
	SSC_SR_OVRUN       = 0x20    // Bit OVRUN.
	SSC_SR_CP0_Pos     = 0x8     // Position of CP0 field.
	SSC_SR_CP0_Msk     = 0x100   // Bit mask of CP0 field.
	SSC_SR_CP0         = 0x100   // Bit CP0.
	SSC_SR_CP1_Pos     = 0x9     // Position of CP1 field.
	SSC_SR_CP1_Msk     = 0x200   // Bit mask of CP1 field.
	SSC_SR_CP1         = 0x200   // Bit CP1.
	SSC_SR_TXSYN_Pos   = 0xa     // Position of TXSYN field.
	SSC_SR_TXSYN_Msk   = 0x400   // Bit mask of TXSYN field.
	SSC_SR_TXSYN       = 0x400   // Bit TXSYN.
	SSC_SR_RXSYN_Pos   = 0xb     // Position of RXSYN field.
	SSC_SR_RXSYN_Msk   = 0x800   // Bit mask of RXSYN field.
	SSC_SR_RXSYN       = 0x800   // Bit RXSYN.
	SSC_SR_TXEN_Pos    = 0x10    // Position of TXEN field.
	SSC_SR_TXEN_Msk    = 0x10000 // Bit mask of TXEN field.
	SSC_SR_TXEN        = 0x10000 // Bit TXEN.
	SSC_SR_RXEN_Pos    = 0x11    // Position of RXEN field.
	SSC_SR_RXEN_Msk    = 0x20000 // Bit mask of RXEN field.
	SSC_SR_RXEN        = 0x20000 // Bit RXEN.

	// IER: Interrupt Enable Register
	SSC_IER_TXRDY_Pos   = 0x0   // Position of TXRDY field.
	SSC_IER_TXRDY_Msk   = 0x1   // Bit mask of TXRDY field.
	SSC_IER_TXRDY       = 0x1   // Bit TXRDY.
	SSC_IER_TXEMPTY_Pos = 0x1   // Position of TXEMPTY field.
	SSC_IER_TXEMPTY_Msk = 0x2   // Bit mask of TXEMPTY field.
	SSC_IER_TXEMPTY     = 0x2   // Bit TXEMPTY.
	SSC_IER_RXRDY_Pos   = 0x4   // Position of RXRDY field.
	SSC_IER_RXRDY_Msk   = 0x10  // Bit mask of RXRDY field.
	SSC_IER_RXRDY       = 0x10  // Bit RXRDY.
	SSC_IER_OVRUN_Pos   = 0x5   // Position of OVRUN field.
	SSC_IER_OVRUN_Msk   = 0x20  // Bit mask of OVRUN field.
	SSC_IER_OVRUN       = 0x20  // Bit OVRUN.
	SSC_IER_CP0_Pos     = 0x8   // Position of CP0 field.
	SSC_IER_CP0_Msk     = 0x100 // Bit mask of CP0 field.
	SSC_IER_CP0         = 0x100 // Bit CP0.
	SSC_IER_CP1_Pos     = 0x9   // Position of CP1 field.
	SSC_IER_CP1_Msk     = 0x200 // Bit mask of CP1 field.
	SSC_IER_CP1         = 0x200 // Bit CP1.
	SSC_IER_TXSYN_Pos   = 0xa   // Position of TXSYN field.
	SSC_IER_TXSYN_Msk   = 0x400 // Bit mask of TXSYN field.
	SSC_IER_TXSYN       = 0x400 // Bit TXSYN.
	SSC_IER_RXSYN_Pos   = 0xb   // Position of RXSYN field.
	SSC_IER_RXSYN_Msk   = 0x800 // Bit mask of RXSYN field.
	SSC_IER_RXSYN       = 0x800 // Bit RXSYN.

	// IDR: Interrupt Disable Register
	SSC_IDR_TXRDY_Pos   = 0x0   // Position of TXRDY field.
	SSC_IDR_TXRDY_Msk   = 0x1   // Bit mask of TXRDY field.
	SSC_IDR_TXRDY       = 0x1   // Bit TXRDY.
	SSC_IDR_TXEMPTY_Pos = 0x1   // Position of TXEMPTY field.
	SSC_IDR_TXEMPTY_Msk = 0x2   // Bit mask of TXEMPTY field.
	SSC_IDR_TXEMPTY     = 0x2   // Bit TXEMPTY.
	SSC_IDR_RXRDY_Pos   = 0x4   // Position of RXRDY field.
	SSC_IDR_RXRDY_Msk   = 0x10  // Bit mask of RXRDY field.
	SSC_IDR_RXRDY       = 0x10  // Bit RXRDY.
	SSC_IDR_OVRUN_Pos   = 0x5   // Position of OVRUN field.
	SSC_IDR_OVRUN_Msk   = 0x20  // Bit mask of OVRUN field.
	SSC_IDR_OVRUN       = 0x20  // Bit OVRUN.
	SSC_IDR_CP0_Pos     = 0x8   // Position of CP0 field.
	SSC_IDR_CP0_Msk     = 0x100 // Bit mask of CP0 field.
	SSC_IDR_CP0         = 0x100 // Bit CP0.
	SSC_IDR_CP1_Pos     = 0x9   // Position of CP1 field.
	SSC_IDR_CP1_Msk     = 0x200 // Bit mask of CP1 field.
	SSC_IDR_CP1         = 0x200 // Bit CP1.
	SSC_IDR_TXSYN_Pos   = 0xa   // Position of TXSYN field.
	SSC_IDR_TXSYN_Msk   = 0x400 // Bit mask of TXSYN field.
	SSC_IDR_TXSYN       = 0x400 // Bit TXSYN.
	SSC_IDR_RXSYN_Pos   = 0xb   // Position of RXSYN field.
	SSC_IDR_RXSYN_Msk   = 0x800 // Bit mask of RXSYN field.
	SSC_IDR_RXSYN       = 0x800 // Bit RXSYN.

	// IMR: Interrupt Mask Register
	SSC_IMR_TXRDY_Pos   = 0x0   // Position of TXRDY field.
	SSC_IMR_TXRDY_Msk   = 0x1   // Bit mask of TXRDY field.
	SSC_IMR_TXRDY       = 0x1   // Bit TXRDY.
	SSC_IMR_TXEMPTY_Pos = 0x1   // Position of TXEMPTY field.
	SSC_IMR_TXEMPTY_Msk = 0x2   // Bit mask of TXEMPTY field.
	SSC_IMR_TXEMPTY     = 0x2   // Bit TXEMPTY.
	SSC_IMR_RXRDY_Pos   = 0x4   // Position of RXRDY field.
	SSC_IMR_RXRDY_Msk   = 0x10  // Bit mask of RXRDY field.
	SSC_IMR_RXRDY       = 0x10  // Bit RXRDY.
	SSC_IMR_OVRUN_Pos   = 0x5   // Position of OVRUN field.
	SSC_IMR_OVRUN_Msk   = 0x20  // Bit mask of OVRUN field.
	SSC_IMR_OVRUN       = 0x20  // Bit OVRUN.
	SSC_IMR_CP0_Pos     = 0x8   // Position of CP0 field.
	SSC_IMR_CP0_Msk     = 0x100 // Bit mask of CP0 field.
	SSC_IMR_CP0         = 0x100 // Bit CP0.
	SSC_IMR_CP1_Pos     = 0x9   // Position of CP1 field.
	SSC_IMR_CP1_Msk     = 0x200 // Bit mask of CP1 field.
	SSC_IMR_CP1         = 0x200 // Bit CP1.
	SSC_IMR_TXSYN_Pos   = 0xa   // Position of TXSYN field.
	SSC_IMR_TXSYN_Msk   = 0x400 // Bit mask of TXSYN field.
	SSC_IMR_TXSYN       = 0x400 // Bit TXSYN.
	SSC_IMR_RXSYN_Pos   = 0xb   // Position of RXSYN field.
	SSC_IMR_RXSYN_Msk   = 0x800 // Bit mask of RXSYN field.
	SSC_IMR_RXSYN       = 0x800 // Bit RXSYN.

	// WPMR: Write Protect Mode Register
	SSC_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	SSC_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	SSC_WPMR_WPEN      = 0x1        // Bit WPEN.
	SSC_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	SSC_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.
)

// Bitfields for CAN0: Controller Area Network 0
const (
	// MR: Mode Register
	CAN_MR_CANEN_Pos  = 0x0  // Position of CANEN field.
	CAN_MR_CANEN_Msk  = 0x1  // Bit mask of CANEN field.
	CAN_MR_CANEN      = 0x1  // Bit CANEN.
	CAN_MR_LPM_Pos    = 0x1  // Position of LPM field.
	CAN_MR_LPM_Msk    = 0x2  // Bit mask of LPM field.
	CAN_MR_LPM        = 0x2  // Bit LPM.
	CAN_MR_ABM_Pos    = 0x2  // Position of ABM field.
	CAN_MR_ABM_Msk    = 0x4  // Bit mask of ABM field.
	CAN_MR_ABM        = 0x4  // Bit ABM.
	CAN_MR_OVL_Pos    = 0x3  // Position of OVL field.
	CAN_MR_OVL_Msk    = 0x8  // Bit mask of OVL field.
	CAN_MR_OVL        = 0x8  // Bit OVL.
	CAN_MR_TEOF_Pos   = 0x4  // Position of TEOF field.
	CAN_MR_TEOF_Msk   = 0x10 // Bit mask of TEOF field.
	CAN_MR_TEOF       = 0x10 // Bit TEOF.
	CAN_MR_TTM_Pos    = 0x5  // Position of TTM field.
	CAN_MR_TTM_Msk    = 0x20 // Bit mask of TTM field.
	CAN_MR_TTM        = 0x20 // Bit TTM.
	CAN_MR_TIMFRZ_Pos = 0x6  // Position of TIMFRZ field.
	CAN_MR_TIMFRZ_Msk = 0x40 // Bit mask of TIMFRZ field.
	CAN_MR_TIMFRZ     = 0x40 // Bit TIMFRZ.
	CAN_MR_DRPT_Pos   = 0x7  // Position of DRPT field.
	CAN_MR_DRPT_Msk   = 0x80 // Bit mask of DRPT field.
	CAN_MR_DRPT       = 0x80 // Bit DRPT.

	// IER: Interrupt Enable Register
	CAN_IER_MB0_Pos    = 0x0        // Position of MB0 field.
	CAN_IER_MB0_Msk    = 0x1        // Bit mask of MB0 field.
	CAN_IER_MB0        = 0x1        // Bit MB0.
	CAN_IER_MB1_Pos    = 0x1        // Position of MB1 field.
	CAN_IER_MB1_Msk    = 0x2        // Bit mask of MB1 field.
	CAN_IER_MB1        = 0x2        // Bit MB1.
	CAN_IER_MB2_Pos    = 0x2        // Position of MB2 field.
	CAN_IER_MB2_Msk    = 0x4        // Bit mask of MB2 field.
	CAN_IER_MB2        = 0x4        // Bit MB2.
	CAN_IER_MB3_Pos    = 0x3        // Position of MB3 field.
	CAN_IER_MB3_Msk    = 0x8        // Bit mask of MB3 field.
	CAN_IER_MB3        = 0x8        // Bit MB3.
	CAN_IER_MB4_Pos    = 0x4        // Position of MB4 field.
	CAN_IER_MB4_Msk    = 0x10       // Bit mask of MB4 field.
	CAN_IER_MB4        = 0x10       // Bit MB4.
	CAN_IER_MB5_Pos    = 0x5        // Position of MB5 field.
	CAN_IER_MB5_Msk    = 0x20       // Bit mask of MB5 field.
	CAN_IER_MB5        = 0x20       // Bit MB5.
	CAN_IER_MB6_Pos    = 0x6        // Position of MB6 field.
	CAN_IER_MB6_Msk    = 0x40       // Bit mask of MB6 field.
	CAN_IER_MB6        = 0x40       // Bit MB6.
	CAN_IER_MB7_Pos    = 0x7        // Position of MB7 field.
	CAN_IER_MB7_Msk    = 0x80       // Bit mask of MB7 field.
	CAN_IER_MB7        = 0x80       // Bit MB7.
	CAN_IER_ERRA_Pos   = 0x10       // Position of ERRA field.
	CAN_IER_ERRA_Msk   = 0x10000    // Bit mask of ERRA field.
	CAN_IER_ERRA       = 0x10000    // Bit ERRA.
	CAN_IER_WARN_Pos   = 0x11       // Position of WARN field.
	CAN_IER_WARN_Msk   = 0x20000    // Bit mask of WARN field.
	CAN_IER_WARN       = 0x20000    // Bit WARN.
	CAN_IER_ERRP_Pos   = 0x12       // Position of ERRP field.
	CAN_IER_ERRP_Msk   = 0x40000    // Bit mask of ERRP field.
	CAN_IER_ERRP       = 0x40000    // Bit ERRP.
	CAN_IER_BOFF_Pos   = 0x13       // Position of BOFF field.
	CAN_IER_BOFF_Msk   = 0x80000    // Bit mask of BOFF field.
	CAN_IER_BOFF       = 0x80000    // Bit BOFF.
	CAN_IER_SLEEP_Pos  = 0x14       // Position of SLEEP field.
	CAN_IER_SLEEP_Msk  = 0x100000   // Bit mask of SLEEP field.
	CAN_IER_SLEEP      = 0x100000   // Bit SLEEP.
	CAN_IER_WAKEUP_Pos = 0x15       // Position of WAKEUP field.
	CAN_IER_WAKEUP_Msk = 0x200000   // Bit mask of WAKEUP field.
	CAN_IER_WAKEUP     = 0x200000   // Bit WAKEUP.
	CAN_IER_TOVF_Pos   = 0x16       // Position of TOVF field.
	CAN_IER_TOVF_Msk   = 0x400000   // Bit mask of TOVF field.
	CAN_IER_TOVF       = 0x400000   // Bit TOVF.
	CAN_IER_TSTP_Pos   = 0x17       // Position of TSTP field.
	CAN_IER_TSTP_Msk   = 0x800000   // Bit mask of TSTP field.
	CAN_IER_TSTP       = 0x800000   // Bit TSTP.
	CAN_IER_CERR_Pos   = 0x18       // Position of CERR field.
	CAN_IER_CERR_Msk   = 0x1000000  // Bit mask of CERR field.
	CAN_IER_CERR       = 0x1000000  // Bit CERR.
	CAN_IER_SERR_Pos   = 0x19       // Position of SERR field.
	CAN_IER_SERR_Msk   = 0x2000000  // Bit mask of SERR field.
	CAN_IER_SERR       = 0x2000000  // Bit SERR.
	CAN_IER_AERR_Pos   = 0x1a       // Position of AERR field.
	CAN_IER_AERR_Msk   = 0x4000000  // Bit mask of AERR field.
	CAN_IER_AERR       = 0x4000000  // Bit AERR.
	CAN_IER_FERR_Pos   = 0x1b       // Position of FERR field.
	CAN_IER_FERR_Msk   = 0x8000000  // Bit mask of FERR field.
	CAN_IER_FERR       = 0x8000000  // Bit FERR.
	CAN_IER_BERR_Pos   = 0x1c       // Position of BERR field.
	CAN_IER_BERR_Msk   = 0x10000000 // Bit mask of BERR field.
	CAN_IER_BERR       = 0x10000000 // Bit BERR.

	// IDR: Interrupt Disable Register
	CAN_IDR_MB0_Pos    = 0x0        // Position of MB0 field.
	CAN_IDR_MB0_Msk    = 0x1        // Bit mask of MB0 field.
	CAN_IDR_MB0        = 0x1        // Bit MB0.
	CAN_IDR_MB1_Pos    = 0x1        // Position of MB1 field.
	CAN_IDR_MB1_Msk    = 0x2        // Bit mask of MB1 field.
	CAN_IDR_MB1        = 0x2        // Bit MB1.
	CAN_IDR_MB2_Pos    = 0x2        // Position of MB2 field.
	CAN_IDR_MB2_Msk    = 0x4        // Bit mask of MB2 field.
	CAN_IDR_MB2        = 0x4        // Bit MB2.
	CAN_IDR_MB3_Pos    = 0x3        // Position of MB3 field.
	CAN_IDR_MB3_Msk    = 0x8        // Bit mask of MB3 field.
	CAN_IDR_MB3        = 0x8        // Bit MB3.
	CAN_IDR_MB4_Pos    = 0x4        // Position of MB4 field.
	CAN_IDR_MB4_Msk    = 0x10       // Bit mask of MB4 field.
	CAN_IDR_MB4        = 0x10       // Bit MB4.
	CAN_IDR_MB5_Pos    = 0x5        // Position of MB5 field.
	CAN_IDR_MB5_Msk    = 0x20       // Bit mask of MB5 field.
	CAN_IDR_MB5        = 0x20       // Bit MB5.
	CAN_IDR_MB6_Pos    = 0x6        // Position of MB6 field.
	CAN_IDR_MB6_Msk    = 0x40       // Bit mask of MB6 field.
	CAN_IDR_MB6        = 0x40       // Bit MB6.
	CAN_IDR_MB7_Pos    = 0x7        // Position of MB7 field.
	CAN_IDR_MB7_Msk    = 0x80       // Bit mask of MB7 field.
	CAN_IDR_MB7        = 0x80       // Bit MB7.
	CAN_IDR_ERRA_Pos   = 0x10       // Position of ERRA field.
	CAN_IDR_ERRA_Msk   = 0x10000    // Bit mask of ERRA field.
	CAN_IDR_ERRA       = 0x10000    // Bit ERRA.
	CAN_IDR_WARN_Pos   = 0x11       // Position of WARN field.
	CAN_IDR_WARN_Msk   = 0x20000    // Bit mask of WARN field.
	CAN_IDR_WARN       = 0x20000    // Bit WARN.
	CAN_IDR_ERRP_Pos   = 0x12       // Position of ERRP field.
	CAN_IDR_ERRP_Msk   = 0x40000    // Bit mask of ERRP field.
	CAN_IDR_ERRP       = 0x40000    // Bit ERRP.
	CAN_IDR_BOFF_Pos   = 0x13       // Position of BOFF field.
	CAN_IDR_BOFF_Msk   = 0x80000    // Bit mask of BOFF field.
	CAN_IDR_BOFF       = 0x80000    // Bit BOFF.
	CAN_IDR_SLEEP_Pos  = 0x14       // Position of SLEEP field.
	CAN_IDR_SLEEP_Msk  = 0x100000   // Bit mask of SLEEP field.
	CAN_IDR_SLEEP      = 0x100000   // Bit SLEEP.
	CAN_IDR_WAKEUP_Pos = 0x15       // Position of WAKEUP field.
	CAN_IDR_WAKEUP_Msk = 0x200000   // Bit mask of WAKEUP field.
	CAN_IDR_WAKEUP     = 0x200000   // Bit WAKEUP.
	CAN_IDR_TOVF_Pos   = 0x16       // Position of TOVF field.
	CAN_IDR_TOVF_Msk   = 0x400000   // Bit mask of TOVF field.
	CAN_IDR_TOVF       = 0x400000   // Bit TOVF.
	CAN_IDR_TSTP_Pos   = 0x17       // Position of TSTP field.
	CAN_IDR_TSTP_Msk   = 0x800000   // Bit mask of TSTP field.
	CAN_IDR_TSTP       = 0x800000   // Bit TSTP.
	CAN_IDR_CERR_Pos   = 0x18       // Position of CERR field.
	CAN_IDR_CERR_Msk   = 0x1000000  // Bit mask of CERR field.
	CAN_IDR_CERR       = 0x1000000  // Bit CERR.
	CAN_IDR_SERR_Pos   = 0x19       // Position of SERR field.
	CAN_IDR_SERR_Msk   = 0x2000000  // Bit mask of SERR field.
	CAN_IDR_SERR       = 0x2000000  // Bit SERR.
	CAN_IDR_AERR_Pos   = 0x1a       // Position of AERR field.
	CAN_IDR_AERR_Msk   = 0x4000000  // Bit mask of AERR field.
	CAN_IDR_AERR       = 0x4000000  // Bit AERR.
	CAN_IDR_FERR_Pos   = 0x1b       // Position of FERR field.
	CAN_IDR_FERR_Msk   = 0x8000000  // Bit mask of FERR field.
	CAN_IDR_FERR       = 0x8000000  // Bit FERR.
	CAN_IDR_BERR_Pos   = 0x1c       // Position of BERR field.
	CAN_IDR_BERR_Msk   = 0x10000000 // Bit mask of BERR field.
	CAN_IDR_BERR       = 0x10000000 // Bit BERR.

	// IMR: Interrupt Mask Register
	CAN_IMR_MB0_Pos    = 0x0        // Position of MB0 field.
	CAN_IMR_MB0_Msk    = 0x1        // Bit mask of MB0 field.
	CAN_IMR_MB0        = 0x1        // Bit MB0.
	CAN_IMR_MB1_Pos    = 0x1        // Position of MB1 field.
	CAN_IMR_MB1_Msk    = 0x2        // Bit mask of MB1 field.
	CAN_IMR_MB1        = 0x2        // Bit MB1.
	CAN_IMR_MB2_Pos    = 0x2        // Position of MB2 field.
	CAN_IMR_MB2_Msk    = 0x4        // Bit mask of MB2 field.
	CAN_IMR_MB2        = 0x4        // Bit MB2.
	CAN_IMR_MB3_Pos    = 0x3        // Position of MB3 field.
	CAN_IMR_MB3_Msk    = 0x8        // Bit mask of MB3 field.
	CAN_IMR_MB3        = 0x8        // Bit MB3.
	CAN_IMR_MB4_Pos    = 0x4        // Position of MB4 field.
	CAN_IMR_MB4_Msk    = 0x10       // Bit mask of MB4 field.
	CAN_IMR_MB4        = 0x10       // Bit MB4.
	CAN_IMR_MB5_Pos    = 0x5        // Position of MB5 field.
	CAN_IMR_MB5_Msk    = 0x20       // Bit mask of MB5 field.
	CAN_IMR_MB5        = 0x20       // Bit MB5.
	CAN_IMR_MB6_Pos    = 0x6        // Position of MB6 field.
	CAN_IMR_MB6_Msk    = 0x40       // Bit mask of MB6 field.
	CAN_IMR_MB6        = 0x40       // Bit MB6.
	CAN_IMR_MB7_Pos    = 0x7        // Position of MB7 field.
	CAN_IMR_MB7_Msk    = 0x80       // Bit mask of MB7 field.
	CAN_IMR_MB7        = 0x80       // Bit MB7.
	CAN_IMR_ERRA_Pos   = 0x10       // Position of ERRA field.
	CAN_IMR_ERRA_Msk   = 0x10000    // Bit mask of ERRA field.
	CAN_IMR_ERRA       = 0x10000    // Bit ERRA.
	CAN_IMR_WARN_Pos   = 0x11       // Position of WARN field.
	CAN_IMR_WARN_Msk   = 0x20000    // Bit mask of WARN field.
	CAN_IMR_WARN       = 0x20000    // Bit WARN.
	CAN_IMR_ERRP_Pos   = 0x12       // Position of ERRP field.
	CAN_IMR_ERRP_Msk   = 0x40000    // Bit mask of ERRP field.
	CAN_IMR_ERRP       = 0x40000    // Bit ERRP.
	CAN_IMR_BOFF_Pos   = 0x13       // Position of BOFF field.
	CAN_IMR_BOFF_Msk   = 0x80000    // Bit mask of BOFF field.
	CAN_IMR_BOFF       = 0x80000    // Bit BOFF.
	CAN_IMR_SLEEP_Pos  = 0x14       // Position of SLEEP field.
	CAN_IMR_SLEEP_Msk  = 0x100000   // Bit mask of SLEEP field.
	CAN_IMR_SLEEP      = 0x100000   // Bit SLEEP.
	CAN_IMR_WAKEUP_Pos = 0x15       // Position of WAKEUP field.
	CAN_IMR_WAKEUP_Msk = 0x200000   // Bit mask of WAKEUP field.
	CAN_IMR_WAKEUP     = 0x200000   // Bit WAKEUP.
	CAN_IMR_TOVF_Pos   = 0x16       // Position of TOVF field.
	CAN_IMR_TOVF_Msk   = 0x400000   // Bit mask of TOVF field.
	CAN_IMR_TOVF       = 0x400000   // Bit TOVF.
	CAN_IMR_TSTP_Pos   = 0x17       // Position of TSTP field.
	CAN_IMR_TSTP_Msk   = 0x800000   // Bit mask of TSTP field.
	CAN_IMR_TSTP       = 0x800000   // Bit TSTP.
	CAN_IMR_CERR_Pos   = 0x18       // Position of CERR field.
	CAN_IMR_CERR_Msk   = 0x1000000  // Bit mask of CERR field.
	CAN_IMR_CERR       = 0x1000000  // Bit CERR.
	CAN_IMR_SERR_Pos   = 0x19       // Position of SERR field.
	CAN_IMR_SERR_Msk   = 0x2000000  // Bit mask of SERR field.
	CAN_IMR_SERR       = 0x2000000  // Bit SERR.
	CAN_IMR_AERR_Pos   = 0x1a       // Position of AERR field.
	CAN_IMR_AERR_Msk   = 0x4000000  // Bit mask of AERR field.
	CAN_IMR_AERR       = 0x4000000  // Bit AERR.
	CAN_IMR_FERR_Pos   = 0x1b       // Position of FERR field.
	CAN_IMR_FERR_Msk   = 0x8000000  // Bit mask of FERR field.
	CAN_IMR_FERR       = 0x8000000  // Bit FERR.
	CAN_IMR_BERR_Pos   = 0x1c       // Position of BERR field.
	CAN_IMR_BERR_Msk   = 0x10000000 // Bit mask of BERR field.
	CAN_IMR_BERR       = 0x10000000 // Bit BERR.

	// SR: Status Register
	CAN_SR_MB0_Pos    = 0x0        // Position of MB0 field.
	CAN_SR_MB0_Msk    = 0x1        // Bit mask of MB0 field.
	CAN_SR_MB0        = 0x1        // Bit MB0.
	CAN_SR_MB1_Pos    = 0x1        // Position of MB1 field.
	CAN_SR_MB1_Msk    = 0x2        // Bit mask of MB1 field.
	CAN_SR_MB1        = 0x2        // Bit MB1.
	CAN_SR_MB2_Pos    = 0x2        // Position of MB2 field.
	CAN_SR_MB2_Msk    = 0x4        // Bit mask of MB2 field.
	CAN_SR_MB2        = 0x4        // Bit MB2.
	CAN_SR_MB3_Pos    = 0x3        // Position of MB3 field.
	CAN_SR_MB3_Msk    = 0x8        // Bit mask of MB3 field.
	CAN_SR_MB3        = 0x8        // Bit MB3.
	CAN_SR_MB4_Pos    = 0x4        // Position of MB4 field.
	CAN_SR_MB4_Msk    = 0x10       // Bit mask of MB4 field.
	CAN_SR_MB4        = 0x10       // Bit MB4.
	CAN_SR_MB5_Pos    = 0x5        // Position of MB5 field.
	CAN_SR_MB5_Msk    = 0x20       // Bit mask of MB5 field.
	CAN_SR_MB5        = 0x20       // Bit MB5.
	CAN_SR_MB6_Pos    = 0x6        // Position of MB6 field.
	CAN_SR_MB6_Msk    = 0x40       // Bit mask of MB6 field.
	CAN_SR_MB6        = 0x40       // Bit MB6.
	CAN_SR_MB7_Pos    = 0x7        // Position of MB7 field.
	CAN_SR_MB7_Msk    = 0x80       // Bit mask of MB7 field.
	CAN_SR_MB7        = 0x80       // Bit MB7.
	CAN_SR_ERRA_Pos   = 0x10       // Position of ERRA field.
	CAN_SR_ERRA_Msk   = 0x10000    // Bit mask of ERRA field.
	CAN_SR_ERRA       = 0x10000    // Bit ERRA.
	CAN_SR_WARN_Pos   = 0x11       // Position of WARN field.
	CAN_SR_WARN_Msk   = 0x20000    // Bit mask of WARN field.
	CAN_SR_WARN       = 0x20000    // Bit WARN.
	CAN_SR_ERRP_Pos   = 0x12       // Position of ERRP field.
	CAN_SR_ERRP_Msk   = 0x40000    // Bit mask of ERRP field.
	CAN_SR_ERRP       = 0x40000    // Bit ERRP.
	CAN_SR_BOFF_Pos   = 0x13       // Position of BOFF field.
	CAN_SR_BOFF_Msk   = 0x80000    // Bit mask of BOFF field.
	CAN_SR_BOFF       = 0x80000    // Bit BOFF.
	CAN_SR_SLEEP_Pos  = 0x14       // Position of SLEEP field.
	CAN_SR_SLEEP_Msk  = 0x100000   // Bit mask of SLEEP field.
	CAN_SR_SLEEP      = 0x100000   // Bit SLEEP.
	CAN_SR_WAKEUP_Pos = 0x15       // Position of WAKEUP field.
	CAN_SR_WAKEUP_Msk = 0x200000   // Bit mask of WAKEUP field.
	CAN_SR_WAKEUP     = 0x200000   // Bit WAKEUP.
	CAN_SR_TOVF_Pos   = 0x16       // Position of TOVF field.
	CAN_SR_TOVF_Msk   = 0x400000   // Bit mask of TOVF field.
	CAN_SR_TOVF       = 0x400000   // Bit TOVF.
	CAN_SR_TSTP_Pos   = 0x17       // Position of TSTP field.
	CAN_SR_TSTP_Msk   = 0x800000   // Bit mask of TSTP field.
	CAN_SR_TSTP       = 0x800000   // Bit TSTP.
	CAN_SR_CERR_Pos   = 0x18       // Position of CERR field.
	CAN_SR_CERR_Msk   = 0x1000000  // Bit mask of CERR field.
	CAN_SR_CERR       = 0x1000000  // Bit CERR.
	CAN_SR_SERR_Pos   = 0x19       // Position of SERR field.
	CAN_SR_SERR_Msk   = 0x2000000  // Bit mask of SERR field.
	CAN_SR_SERR       = 0x2000000  // Bit SERR.
	CAN_SR_AERR_Pos   = 0x1a       // Position of AERR field.
	CAN_SR_AERR_Msk   = 0x4000000  // Bit mask of AERR field.
	CAN_SR_AERR       = 0x4000000  // Bit AERR.
	CAN_SR_FERR_Pos   = 0x1b       // Position of FERR field.
	CAN_SR_FERR_Msk   = 0x8000000  // Bit mask of FERR field.
	CAN_SR_FERR       = 0x8000000  // Bit FERR.
	CAN_SR_BERR_Pos   = 0x1c       // Position of BERR field.
	CAN_SR_BERR_Msk   = 0x10000000 // Bit mask of BERR field.
	CAN_SR_BERR       = 0x10000000 // Bit BERR.
	CAN_SR_RBSY_Pos   = 0x1d       // Position of RBSY field.
	CAN_SR_RBSY_Msk   = 0x20000000 // Bit mask of RBSY field.
	CAN_SR_RBSY       = 0x20000000 // Bit RBSY.
	CAN_SR_TBSY_Pos   = 0x1e       // Position of TBSY field.
	CAN_SR_TBSY_Msk   = 0x40000000 // Bit mask of TBSY field.
	CAN_SR_TBSY       = 0x40000000 // Bit TBSY.
	CAN_SR_OVLSY_Pos  = 0x1f       // Position of OVLSY field.
	CAN_SR_OVLSY_Msk  = 0x80000000 // Bit mask of OVLSY field.
	CAN_SR_OVLSY      = 0x80000000 // Bit OVLSY.

	// BR: Baudrate Register
	CAN_BR_PHASE2_Pos = 0x0       // Position of PHASE2 field.
	CAN_BR_PHASE2_Msk = 0x7       // Bit mask of PHASE2 field.
	CAN_BR_PHASE1_Pos = 0x4       // Position of PHASE1 field.
	CAN_BR_PHASE1_Msk = 0x70      // Bit mask of PHASE1 field.
	CAN_BR_PROPAG_Pos = 0x8       // Position of PROPAG field.
	CAN_BR_PROPAG_Msk = 0x700     // Bit mask of PROPAG field.
	CAN_BR_SJW_Pos    = 0xc       // Position of SJW field.
	CAN_BR_SJW_Msk    = 0x3000    // Bit mask of SJW field.
	CAN_BR_BRP_Pos    = 0x10      // Position of BRP field.
	CAN_BR_BRP_Msk    = 0x7f0000  // Bit mask of BRP field.
	CAN_BR_SMP_Pos    = 0x18      // Position of SMP field.
	CAN_BR_SMP_Msk    = 0x1000000 // Bit mask of SMP field.
	CAN_BR_SMP        = 0x1000000 // Bit SMP.
	CAN_BR_SMP_ONCE   = 0x0       // The incoming bit stream is sampled once at sample point.
	CAN_BR_SMP_THREE  = 0x1       // The incoming bit stream is sampled three times with a period of a MCK clock period, centered on sample point.

	// TIM: Timer Register
	CAN_TIM_TIMER_Pos = 0x0    // Position of TIMER field.
	CAN_TIM_TIMER_Msk = 0xffff // Bit mask of TIMER field.

	// TIMESTP: Timestamp Register
	CAN_TIMESTP_MTIMESTAMP_Pos = 0x0    // Position of MTIMESTAMP field.
	CAN_TIMESTP_MTIMESTAMP_Msk = 0xffff // Bit mask of MTIMESTAMP field.

	// ECR: Error Counter Register
	CAN_ECR_REC_Pos = 0x0       // Position of REC field.
	CAN_ECR_REC_Msk = 0xff      // Bit mask of REC field.
	CAN_ECR_TEC_Pos = 0x10      // Position of TEC field.
	CAN_ECR_TEC_Msk = 0x1ff0000 // Bit mask of TEC field.

	// TCR: Transfer Command Register
	CAN_TCR_MB0_Pos    = 0x0        // Position of MB0 field.
	CAN_TCR_MB0_Msk    = 0x1        // Bit mask of MB0 field.
	CAN_TCR_MB0        = 0x1        // Bit MB0.
	CAN_TCR_MB1_Pos    = 0x1        // Position of MB1 field.
	CAN_TCR_MB1_Msk    = 0x2        // Bit mask of MB1 field.
	CAN_TCR_MB1        = 0x2        // Bit MB1.
	CAN_TCR_MB2_Pos    = 0x2        // Position of MB2 field.
	CAN_TCR_MB2_Msk    = 0x4        // Bit mask of MB2 field.
	CAN_TCR_MB2        = 0x4        // Bit MB2.
	CAN_TCR_MB3_Pos    = 0x3        // Position of MB3 field.
	CAN_TCR_MB3_Msk    = 0x8        // Bit mask of MB3 field.
	CAN_TCR_MB3        = 0x8        // Bit MB3.
	CAN_TCR_MB4_Pos    = 0x4        // Position of MB4 field.
	CAN_TCR_MB4_Msk    = 0x10       // Bit mask of MB4 field.
	CAN_TCR_MB4        = 0x10       // Bit MB4.
	CAN_TCR_MB5_Pos    = 0x5        // Position of MB5 field.
	CAN_TCR_MB5_Msk    = 0x20       // Bit mask of MB5 field.
	CAN_TCR_MB5        = 0x20       // Bit MB5.
	CAN_TCR_MB6_Pos    = 0x6        // Position of MB6 field.
	CAN_TCR_MB6_Msk    = 0x40       // Bit mask of MB6 field.
	CAN_TCR_MB6        = 0x40       // Bit MB6.
	CAN_TCR_MB7_Pos    = 0x7        // Position of MB7 field.
	CAN_TCR_MB7_Msk    = 0x80       // Bit mask of MB7 field.
	CAN_TCR_MB7        = 0x80       // Bit MB7.
	CAN_TCR_TIMRST_Pos = 0x1f       // Position of TIMRST field.
	CAN_TCR_TIMRST_Msk = 0x80000000 // Bit mask of TIMRST field.
	CAN_TCR_TIMRST     = 0x80000000 // Bit TIMRST.

	// ACR: Abort Command Register
	CAN_ACR_MB0_Pos = 0x0  // Position of MB0 field.
	CAN_ACR_MB0_Msk = 0x1  // Bit mask of MB0 field.
	CAN_ACR_MB0     = 0x1  // Bit MB0.
	CAN_ACR_MB1_Pos = 0x1  // Position of MB1 field.
	CAN_ACR_MB1_Msk = 0x2  // Bit mask of MB1 field.
	CAN_ACR_MB1     = 0x2  // Bit MB1.
	CAN_ACR_MB2_Pos = 0x2  // Position of MB2 field.
	CAN_ACR_MB2_Msk = 0x4  // Bit mask of MB2 field.
	CAN_ACR_MB2     = 0x4  // Bit MB2.
	CAN_ACR_MB3_Pos = 0x3  // Position of MB3 field.
	CAN_ACR_MB3_Msk = 0x8  // Bit mask of MB3 field.
	CAN_ACR_MB3     = 0x8  // Bit MB3.
	CAN_ACR_MB4_Pos = 0x4  // Position of MB4 field.
	CAN_ACR_MB4_Msk = 0x10 // Bit mask of MB4 field.
	CAN_ACR_MB4     = 0x10 // Bit MB4.
	CAN_ACR_MB5_Pos = 0x5  // Position of MB5 field.
	CAN_ACR_MB5_Msk = 0x20 // Bit mask of MB5 field.
	CAN_ACR_MB5     = 0x20 // Bit MB5.
	CAN_ACR_MB6_Pos = 0x6  // Position of MB6 field.
	CAN_ACR_MB6_Msk = 0x40 // Bit mask of MB6 field.
	CAN_ACR_MB6     = 0x40 // Bit MB6.
	CAN_ACR_MB7_Pos = 0x7  // Position of MB7 field.
	CAN_ACR_MB7_Msk = 0x80 // Bit mask of MB7 field.
	CAN_ACR_MB7     = 0x80 // Bit MB7.

	// WPMR: Write Protect Mode Register
	CAN_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	CAN_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	CAN_WPMR_WPEN      = 0x1        // Bit WPEN.
	CAN_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	CAN_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protect Status Register
	CAN_WPSR_WPVS_Pos   = 0x0    // Position of WPVS field.
	CAN_WPSR_WPVS_Msk   = 0x1    // Bit mask of WPVS field.
	CAN_WPSR_WPVS       = 0x1    // Bit WPVS.
	CAN_WPSR_WPVSRC_Pos = 0x8    // Position of WPVSRC field.
	CAN_WPSR_WPVSRC_Msk = 0xff00 // Bit mask of WPVSRC field.

	// MMR0: Mailbox Mode Register (MB = 0)
	CAN_MMR0_MTIMEMARK_Pos       = 0x0       // Position of MTIMEMARK field.
	CAN_MMR0_MTIMEMARK_Msk       = 0xffff    // Bit mask of MTIMEMARK field.
	CAN_MMR0_PRIOR_Pos           = 0x10      // Position of PRIOR field.
	CAN_MMR0_PRIOR_Msk           = 0xf0000   // Bit mask of PRIOR field.
	CAN_MMR0_MOT_Pos             = 0x18      // Position of MOT field.
	CAN_MMR0_MOT_Msk             = 0x7000000 // Bit mask of MOT field.
	CAN_MMR0_MOT_MB_DISABLED     = 0x0       // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR0_MOT_MB_RX           = 0x1       // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR0_MOT_MB_RX_OVERWRITE = 0x2       // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR0_MOT_MB_TX           = 0x3       // Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR0_MOT_MB_CONSUMER     = 0x4       // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR0_MOT_MB_PRODUCER     = 0x5       // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.

	// MAM0: Mailbox Acceptance Mask Register (MB = 0)
	CAN_MAM0_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MAM0_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MAM0_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MAM0_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MAM0_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MAM0_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MAM0_MIDE      = 0x20000000 // Bit MIDE.

	// MID0: Mailbox ID Register (MB = 0)
	CAN_MID0_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MID0_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MID0_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MID0_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MID0_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MID0_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MID0_MIDE      = 0x20000000 // Bit MIDE.

	// MFID0: Mailbox Family ID Register (MB = 0)
	CAN_MFID0_MFID_Pos = 0x0        // Position of MFID field.
	CAN_MFID0_MFID_Msk = 0x1fffffff // Bit mask of MFID field.

	// MSR0: Mailbox Status Register (MB = 0)
	CAN_MSR0_MTIMESTAMP_Pos = 0x0       // Position of MTIMESTAMP field.
	CAN_MSR0_MTIMESTAMP_Msk = 0xffff    // Bit mask of MTIMESTAMP field.
	CAN_MSR0_MDLC_Pos       = 0x10      // Position of MDLC field.
	CAN_MSR0_MDLC_Msk       = 0xf0000   // Bit mask of MDLC field.
	CAN_MSR0_MRTR_Pos       = 0x14      // Position of MRTR field.
	CAN_MSR0_MRTR_Msk       = 0x100000  // Bit mask of MRTR field.
	CAN_MSR0_MRTR           = 0x100000  // Bit MRTR.
	CAN_MSR0_MABT_Pos       = 0x16      // Position of MABT field.
	CAN_MSR0_MABT_Msk       = 0x400000  // Bit mask of MABT field.
	CAN_MSR0_MABT           = 0x400000  // Bit MABT.
	CAN_MSR0_MRDY_Pos       = 0x17      // Position of MRDY field.
	CAN_MSR0_MRDY_Msk       = 0x800000  // Bit mask of MRDY field.
	CAN_MSR0_MRDY           = 0x800000  // Bit MRDY.
	CAN_MSR0_MMI_Pos        = 0x18      // Position of MMI field.
	CAN_MSR0_MMI_Msk        = 0x1000000 // Bit mask of MMI field.
	CAN_MSR0_MMI            = 0x1000000 // Bit MMI.

	// MDL0: Mailbox Data Low Register (MB = 0)
	CAN_MDL0_MDL_Pos = 0x0        // Position of MDL field.
	CAN_MDL0_MDL_Msk = 0xffffffff // Bit mask of MDL field.

	// MDH0: Mailbox Data High Register (MB = 0)
	CAN_MDH0_MDH_Pos = 0x0        // Position of MDH field.
	CAN_MDH0_MDH_Msk = 0xffffffff // Bit mask of MDH field.

	// MCR0: Mailbox Control Register (MB = 0)
	CAN_MCR0_MDLC_Pos = 0x10     // Position of MDLC field.
	CAN_MCR0_MDLC_Msk = 0xf0000  // Bit mask of MDLC field.
	CAN_MCR0_MRTR_Pos = 0x14     // Position of MRTR field.
	CAN_MCR0_MRTR_Msk = 0x100000 // Bit mask of MRTR field.
	CAN_MCR0_MRTR     = 0x100000 // Bit MRTR.
	CAN_MCR0_MACR_Pos = 0x16     // Position of MACR field.
	CAN_MCR0_MACR_Msk = 0x400000 // Bit mask of MACR field.
	CAN_MCR0_MACR     = 0x400000 // Bit MACR.
	CAN_MCR0_MTCR_Pos = 0x17     // Position of MTCR field.
	CAN_MCR0_MTCR_Msk = 0x800000 // Bit mask of MTCR field.
	CAN_MCR0_MTCR     = 0x800000 // Bit MTCR.

	// MMR1: Mailbox Mode Register (MB = 1)
	CAN_MMR1_MTIMEMARK_Pos       = 0x0       // Position of MTIMEMARK field.
	CAN_MMR1_MTIMEMARK_Msk       = 0xffff    // Bit mask of MTIMEMARK field.
	CAN_MMR1_PRIOR_Pos           = 0x10      // Position of PRIOR field.
	CAN_MMR1_PRIOR_Msk           = 0xf0000   // Bit mask of PRIOR field.
	CAN_MMR1_MOT_Pos             = 0x18      // Position of MOT field.
	CAN_MMR1_MOT_Msk             = 0x7000000 // Bit mask of MOT field.
	CAN_MMR1_MOT_MB_DISABLED     = 0x0       // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR1_MOT_MB_RX           = 0x1       // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR1_MOT_MB_RX_OVERWRITE = 0x2       // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR1_MOT_MB_TX           = 0x3       // Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR1_MOT_MB_CONSUMER     = 0x4       // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR1_MOT_MB_PRODUCER     = 0x5       // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.

	// MAM1: Mailbox Acceptance Mask Register (MB = 1)
	CAN_MAM1_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MAM1_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MAM1_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MAM1_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MAM1_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MAM1_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MAM1_MIDE      = 0x20000000 // Bit MIDE.

	// MID1: Mailbox ID Register (MB = 1)
	CAN_MID1_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MID1_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MID1_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MID1_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MID1_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MID1_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MID1_MIDE      = 0x20000000 // Bit MIDE.

	// MFID1: Mailbox Family ID Register (MB = 1)
	CAN_MFID1_MFID_Pos = 0x0        // Position of MFID field.
	CAN_MFID1_MFID_Msk = 0x1fffffff // Bit mask of MFID field.

	// MSR1: Mailbox Status Register (MB = 1)
	CAN_MSR1_MTIMESTAMP_Pos = 0x0       // Position of MTIMESTAMP field.
	CAN_MSR1_MTIMESTAMP_Msk = 0xffff    // Bit mask of MTIMESTAMP field.
	CAN_MSR1_MDLC_Pos       = 0x10      // Position of MDLC field.
	CAN_MSR1_MDLC_Msk       = 0xf0000   // Bit mask of MDLC field.
	CAN_MSR1_MRTR_Pos       = 0x14      // Position of MRTR field.
	CAN_MSR1_MRTR_Msk       = 0x100000  // Bit mask of MRTR field.
	CAN_MSR1_MRTR           = 0x100000  // Bit MRTR.
	CAN_MSR1_MABT_Pos       = 0x16      // Position of MABT field.
	CAN_MSR1_MABT_Msk       = 0x400000  // Bit mask of MABT field.
	CAN_MSR1_MABT           = 0x400000  // Bit MABT.
	CAN_MSR1_MRDY_Pos       = 0x17      // Position of MRDY field.
	CAN_MSR1_MRDY_Msk       = 0x800000  // Bit mask of MRDY field.
	CAN_MSR1_MRDY           = 0x800000  // Bit MRDY.
	CAN_MSR1_MMI_Pos        = 0x18      // Position of MMI field.
	CAN_MSR1_MMI_Msk        = 0x1000000 // Bit mask of MMI field.
	CAN_MSR1_MMI            = 0x1000000 // Bit MMI.

	// MDL1: Mailbox Data Low Register (MB = 1)
	CAN_MDL1_MDL_Pos = 0x0        // Position of MDL field.
	CAN_MDL1_MDL_Msk = 0xffffffff // Bit mask of MDL field.

	// MDH1: Mailbox Data High Register (MB = 1)
	CAN_MDH1_MDH_Pos = 0x0        // Position of MDH field.
	CAN_MDH1_MDH_Msk = 0xffffffff // Bit mask of MDH field.

	// MCR1: Mailbox Control Register (MB = 1)
	CAN_MCR1_MDLC_Pos = 0x10     // Position of MDLC field.
	CAN_MCR1_MDLC_Msk = 0xf0000  // Bit mask of MDLC field.
	CAN_MCR1_MRTR_Pos = 0x14     // Position of MRTR field.
	CAN_MCR1_MRTR_Msk = 0x100000 // Bit mask of MRTR field.
	CAN_MCR1_MRTR     = 0x100000 // Bit MRTR.
	CAN_MCR1_MACR_Pos = 0x16     // Position of MACR field.
	CAN_MCR1_MACR_Msk = 0x400000 // Bit mask of MACR field.
	CAN_MCR1_MACR     = 0x400000 // Bit MACR.
	CAN_MCR1_MTCR_Pos = 0x17     // Position of MTCR field.
	CAN_MCR1_MTCR_Msk = 0x800000 // Bit mask of MTCR field.
	CAN_MCR1_MTCR     = 0x800000 // Bit MTCR.

	// MMR2: Mailbox Mode Register (MB = 2)
	CAN_MMR2_MTIMEMARK_Pos       = 0x0       // Position of MTIMEMARK field.
	CAN_MMR2_MTIMEMARK_Msk       = 0xffff    // Bit mask of MTIMEMARK field.
	CAN_MMR2_PRIOR_Pos           = 0x10      // Position of PRIOR field.
	CAN_MMR2_PRIOR_Msk           = 0xf0000   // Bit mask of PRIOR field.
	CAN_MMR2_MOT_Pos             = 0x18      // Position of MOT field.
	CAN_MMR2_MOT_Msk             = 0x7000000 // Bit mask of MOT field.
	CAN_MMR2_MOT_MB_DISABLED     = 0x0       // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR2_MOT_MB_RX           = 0x1       // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR2_MOT_MB_RX_OVERWRITE = 0x2       // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR2_MOT_MB_TX           = 0x3       // Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR2_MOT_MB_CONSUMER     = 0x4       // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR2_MOT_MB_PRODUCER     = 0x5       // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.

	// MAM2: Mailbox Acceptance Mask Register (MB = 2)
	CAN_MAM2_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MAM2_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MAM2_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MAM2_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MAM2_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MAM2_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MAM2_MIDE      = 0x20000000 // Bit MIDE.

	// MID2: Mailbox ID Register (MB = 2)
	CAN_MID2_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MID2_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MID2_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MID2_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MID2_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MID2_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MID2_MIDE      = 0x20000000 // Bit MIDE.

	// MFID2: Mailbox Family ID Register (MB = 2)
	CAN_MFID2_MFID_Pos = 0x0        // Position of MFID field.
	CAN_MFID2_MFID_Msk = 0x1fffffff // Bit mask of MFID field.

	// MSR2: Mailbox Status Register (MB = 2)
	CAN_MSR2_MTIMESTAMP_Pos = 0x0       // Position of MTIMESTAMP field.
	CAN_MSR2_MTIMESTAMP_Msk = 0xffff    // Bit mask of MTIMESTAMP field.
	CAN_MSR2_MDLC_Pos       = 0x10      // Position of MDLC field.
	CAN_MSR2_MDLC_Msk       = 0xf0000   // Bit mask of MDLC field.
	CAN_MSR2_MRTR_Pos       = 0x14      // Position of MRTR field.
	CAN_MSR2_MRTR_Msk       = 0x100000  // Bit mask of MRTR field.
	CAN_MSR2_MRTR           = 0x100000  // Bit MRTR.
	CAN_MSR2_MABT_Pos       = 0x16      // Position of MABT field.
	CAN_MSR2_MABT_Msk       = 0x400000  // Bit mask of MABT field.
	CAN_MSR2_MABT           = 0x400000  // Bit MABT.
	CAN_MSR2_MRDY_Pos       = 0x17      // Position of MRDY field.
	CAN_MSR2_MRDY_Msk       = 0x800000  // Bit mask of MRDY field.
	CAN_MSR2_MRDY           = 0x800000  // Bit MRDY.
	CAN_MSR2_MMI_Pos        = 0x18      // Position of MMI field.
	CAN_MSR2_MMI_Msk        = 0x1000000 // Bit mask of MMI field.
	CAN_MSR2_MMI            = 0x1000000 // Bit MMI.

	// MDL2: Mailbox Data Low Register (MB = 2)
	CAN_MDL2_MDL_Pos = 0x0        // Position of MDL field.
	CAN_MDL2_MDL_Msk = 0xffffffff // Bit mask of MDL field.

	// MDH2: Mailbox Data High Register (MB = 2)
	CAN_MDH2_MDH_Pos = 0x0        // Position of MDH field.
	CAN_MDH2_MDH_Msk = 0xffffffff // Bit mask of MDH field.

	// MCR2: Mailbox Control Register (MB = 2)
	CAN_MCR2_MDLC_Pos = 0x10     // Position of MDLC field.
	CAN_MCR2_MDLC_Msk = 0xf0000  // Bit mask of MDLC field.
	CAN_MCR2_MRTR_Pos = 0x14     // Position of MRTR field.
	CAN_MCR2_MRTR_Msk = 0x100000 // Bit mask of MRTR field.
	CAN_MCR2_MRTR     = 0x100000 // Bit MRTR.
	CAN_MCR2_MACR_Pos = 0x16     // Position of MACR field.
	CAN_MCR2_MACR_Msk = 0x400000 // Bit mask of MACR field.
	CAN_MCR2_MACR     = 0x400000 // Bit MACR.
	CAN_MCR2_MTCR_Pos = 0x17     // Position of MTCR field.
	CAN_MCR2_MTCR_Msk = 0x800000 // Bit mask of MTCR field.
	CAN_MCR2_MTCR     = 0x800000 // Bit MTCR.

	// MMR3: Mailbox Mode Register (MB = 3)
	CAN_MMR3_MTIMEMARK_Pos       = 0x0       // Position of MTIMEMARK field.
	CAN_MMR3_MTIMEMARK_Msk       = 0xffff    // Bit mask of MTIMEMARK field.
	CAN_MMR3_PRIOR_Pos           = 0x10      // Position of PRIOR field.
	CAN_MMR3_PRIOR_Msk           = 0xf0000   // Bit mask of PRIOR field.
	CAN_MMR3_MOT_Pos             = 0x18      // Position of MOT field.
	CAN_MMR3_MOT_Msk             = 0x7000000 // Bit mask of MOT field.
	CAN_MMR3_MOT_MB_DISABLED     = 0x0       // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR3_MOT_MB_RX           = 0x1       // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR3_MOT_MB_RX_OVERWRITE = 0x2       // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR3_MOT_MB_TX           = 0x3       // Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR3_MOT_MB_CONSUMER     = 0x4       // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR3_MOT_MB_PRODUCER     = 0x5       // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.

	// MAM3: Mailbox Acceptance Mask Register (MB = 3)
	CAN_MAM3_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MAM3_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MAM3_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MAM3_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MAM3_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MAM3_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MAM3_MIDE      = 0x20000000 // Bit MIDE.

	// MID3: Mailbox ID Register (MB = 3)
	CAN_MID3_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MID3_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MID3_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MID3_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MID3_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MID3_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MID3_MIDE      = 0x20000000 // Bit MIDE.

	// MFID3: Mailbox Family ID Register (MB = 3)
	CAN_MFID3_MFID_Pos = 0x0        // Position of MFID field.
	CAN_MFID3_MFID_Msk = 0x1fffffff // Bit mask of MFID field.

	// MSR3: Mailbox Status Register (MB = 3)
	CAN_MSR3_MTIMESTAMP_Pos = 0x0       // Position of MTIMESTAMP field.
	CAN_MSR3_MTIMESTAMP_Msk = 0xffff    // Bit mask of MTIMESTAMP field.
	CAN_MSR3_MDLC_Pos       = 0x10      // Position of MDLC field.
	CAN_MSR3_MDLC_Msk       = 0xf0000   // Bit mask of MDLC field.
	CAN_MSR3_MRTR_Pos       = 0x14      // Position of MRTR field.
	CAN_MSR3_MRTR_Msk       = 0x100000  // Bit mask of MRTR field.
	CAN_MSR3_MRTR           = 0x100000  // Bit MRTR.
	CAN_MSR3_MABT_Pos       = 0x16      // Position of MABT field.
	CAN_MSR3_MABT_Msk       = 0x400000  // Bit mask of MABT field.
	CAN_MSR3_MABT           = 0x400000  // Bit MABT.
	CAN_MSR3_MRDY_Pos       = 0x17      // Position of MRDY field.
	CAN_MSR3_MRDY_Msk       = 0x800000  // Bit mask of MRDY field.
	CAN_MSR3_MRDY           = 0x800000  // Bit MRDY.
	CAN_MSR3_MMI_Pos        = 0x18      // Position of MMI field.
	CAN_MSR3_MMI_Msk        = 0x1000000 // Bit mask of MMI field.
	CAN_MSR3_MMI            = 0x1000000 // Bit MMI.

	// MDL3: Mailbox Data Low Register (MB = 3)
	CAN_MDL3_MDL_Pos = 0x0        // Position of MDL field.
	CAN_MDL3_MDL_Msk = 0xffffffff // Bit mask of MDL field.

	// MDH3: Mailbox Data High Register (MB = 3)
	CAN_MDH3_MDH_Pos = 0x0        // Position of MDH field.
	CAN_MDH3_MDH_Msk = 0xffffffff // Bit mask of MDH field.

	// MCR3: Mailbox Control Register (MB = 3)
	CAN_MCR3_MDLC_Pos = 0x10     // Position of MDLC field.
	CAN_MCR3_MDLC_Msk = 0xf0000  // Bit mask of MDLC field.
	CAN_MCR3_MRTR_Pos = 0x14     // Position of MRTR field.
	CAN_MCR3_MRTR_Msk = 0x100000 // Bit mask of MRTR field.
	CAN_MCR3_MRTR     = 0x100000 // Bit MRTR.
	CAN_MCR3_MACR_Pos = 0x16     // Position of MACR field.
	CAN_MCR3_MACR_Msk = 0x400000 // Bit mask of MACR field.
	CAN_MCR3_MACR     = 0x400000 // Bit MACR.
	CAN_MCR3_MTCR_Pos = 0x17     // Position of MTCR field.
	CAN_MCR3_MTCR_Msk = 0x800000 // Bit mask of MTCR field.
	CAN_MCR3_MTCR     = 0x800000 // Bit MTCR.

	// MMR4: Mailbox Mode Register (MB = 4)
	CAN_MMR4_MTIMEMARK_Pos       = 0x0       // Position of MTIMEMARK field.
	CAN_MMR4_MTIMEMARK_Msk       = 0xffff    // Bit mask of MTIMEMARK field.
	CAN_MMR4_PRIOR_Pos           = 0x10      // Position of PRIOR field.
	CAN_MMR4_PRIOR_Msk           = 0xf0000   // Bit mask of PRIOR field.
	CAN_MMR4_MOT_Pos             = 0x18      // Position of MOT field.
	CAN_MMR4_MOT_Msk             = 0x7000000 // Bit mask of MOT field.
	CAN_MMR4_MOT_MB_DISABLED     = 0x0       // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR4_MOT_MB_RX           = 0x1       // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR4_MOT_MB_RX_OVERWRITE = 0x2       // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR4_MOT_MB_TX           = 0x3       // Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR4_MOT_MB_CONSUMER     = 0x4       // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR4_MOT_MB_PRODUCER     = 0x5       // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.

	// MAM4: Mailbox Acceptance Mask Register (MB = 4)
	CAN_MAM4_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MAM4_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MAM4_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MAM4_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MAM4_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MAM4_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MAM4_MIDE      = 0x20000000 // Bit MIDE.

	// MID4: Mailbox ID Register (MB = 4)
	CAN_MID4_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MID4_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MID4_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MID4_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MID4_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MID4_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MID4_MIDE      = 0x20000000 // Bit MIDE.

	// MFID4: Mailbox Family ID Register (MB = 4)
	CAN_MFID4_MFID_Pos = 0x0        // Position of MFID field.
	CAN_MFID4_MFID_Msk = 0x1fffffff // Bit mask of MFID field.

	// MSR4: Mailbox Status Register (MB = 4)
	CAN_MSR4_MTIMESTAMP_Pos = 0x0       // Position of MTIMESTAMP field.
	CAN_MSR4_MTIMESTAMP_Msk = 0xffff    // Bit mask of MTIMESTAMP field.
	CAN_MSR4_MDLC_Pos       = 0x10      // Position of MDLC field.
	CAN_MSR4_MDLC_Msk       = 0xf0000   // Bit mask of MDLC field.
	CAN_MSR4_MRTR_Pos       = 0x14      // Position of MRTR field.
	CAN_MSR4_MRTR_Msk       = 0x100000  // Bit mask of MRTR field.
	CAN_MSR4_MRTR           = 0x100000  // Bit MRTR.
	CAN_MSR4_MABT_Pos       = 0x16      // Position of MABT field.
	CAN_MSR4_MABT_Msk       = 0x400000  // Bit mask of MABT field.
	CAN_MSR4_MABT           = 0x400000  // Bit MABT.
	CAN_MSR4_MRDY_Pos       = 0x17      // Position of MRDY field.
	CAN_MSR4_MRDY_Msk       = 0x800000  // Bit mask of MRDY field.
	CAN_MSR4_MRDY           = 0x800000  // Bit MRDY.
	CAN_MSR4_MMI_Pos        = 0x18      // Position of MMI field.
	CAN_MSR4_MMI_Msk        = 0x1000000 // Bit mask of MMI field.
	CAN_MSR4_MMI            = 0x1000000 // Bit MMI.

	// MDL4: Mailbox Data Low Register (MB = 4)
	CAN_MDL4_MDL_Pos = 0x0        // Position of MDL field.
	CAN_MDL4_MDL_Msk = 0xffffffff // Bit mask of MDL field.

	// MDH4: Mailbox Data High Register (MB = 4)
	CAN_MDH4_MDH_Pos = 0x0        // Position of MDH field.
	CAN_MDH4_MDH_Msk = 0xffffffff // Bit mask of MDH field.

	// MCR4: Mailbox Control Register (MB = 4)
	CAN_MCR4_MDLC_Pos = 0x10     // Position of MDLC field.
	CAN_MCR4_MDLC_Msk = 0xf0000  // Bit mask of MDLC field.
	CAN_MCR4_MRTR_Pos = 0x14     // Position of MRTR field.
	CAN_MCR4_MRTR_Msk = 0x100000 // Bit mask of MRTR field.
	CAN_MCR4_MRTR     = 0x100000 // Bit MRTR.
	CAN_MCR4_MACR_Pos = 0x16     // Position of MACR field.
	CAN_MCR4_MACR_Msk = 0x400000 // Bit mask of MACR field.
	CAN_MCR4_MACR     = 0x400000 // Bit MACR.
	CAN_MCR4_MTCR_Pos = 0x17     // Position of MTCR field.
	CAN_MCR4_MTCR_Msk = 0x800000 // Bit mask of MTCR field.
	CAN_MCR4_MTCR     = 0x800000 // Bit MTCR.

	// MMR5: Mailbox Mode Register (MB = 5)
	CAN_MMR5_MTIMEMARK_Pos       = 0x0       // Position of MTIMEMARK field.
	CAN_MMR5_MTIMEMARK_Msk       = 0xffff    // Bit mask of MTIMEMARK field.
	CAN_MMR5_PRIOR_Pos           = 0x10      // Position of PRIOR field.
	CAN_MMR5_PRIOR_Msk           = 0xf0000   // Bit mask of PRIOR field.
	CAN_MMR5_MOT_Pos             = 0x18      // Position of MOT field.
	CAN_MMR5_MOT_Msk             = 0x7000000 // Bit mask of MOT field.
	CAN_MMR5_MOT_MB_DISABLED     = 0x0       // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR5_MOT_MB_RX           = 0x1       // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR5_MOT_MB_RX_OVERWRITE = 0x2       // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR5_MOT_MB_TX           = 0x3       // Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR5_MOT_MB_CONSUMER     = 0x4       // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR5_MOT_MB_PRODUCER     = 0x5       // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.

	// MAM5: Mailbox Acceptance Mask Register (MB = 5)
	CAN_MAM5_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MAM5_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MAM5_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MAM5_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MAM5_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MAM5_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MAM5_MIDE      = 0x20000000 // Bit MIDE.

	// MID5: Mailbox ID Register (MB = 5)
	CAN_MID5_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MID5_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MID5_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MID5_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MID5_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MID5_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MID5_MIDE      = 0x20000000 // Bit MIDE.

	// MFID5: Mailbox Family ID Register (MB = 5)
	CAN_MFID5_MFID_Pos = 0x0        // Position of MFID field.
	CAN_MFID5_MFID_Msk = 0x1fffffff // Bit mask of MFID field.

	// MSR5: Mailbox Status Register (MB = 5)
	CAN_MSR5_MTIMESTAMP_Pos = 0x0       // Position of MTIMESTAMP field.
	CAN_MSR5_MTIMESTAMP_Msk = 0xffff    // Bit mask of MTIMESTAMP field.
	CAN_MSR5_MDLC_Pos       = 0x10      // Position of MDLC field.
	CAN_MSR5_MDLC_Msk       = 0xf0000   // Bit mask of MDLC field.
	CAN_MSR5_MRTR_Pos       = 0x14      // Position of MRTR field.
	CAN_MSR5_MRTR_Msk       = 0x100000  // Bit mask of MRTR field.
	CAN_MSR5_MRTR           = 0x100000  // Bit MRTR.
	CAN_MSR5_MABT_Pos       = 0x16      // Position of MABT field.
	CAN_MSR5_MABT_Msk       = 0x400000  // Bit mask of MABT field.
	CAN_MSR5_MABT           = 0x400000  // Bit MABT.
	CAN_MSR5_MRDY_Pos       = 0x17      // Position of MRDY field.
	CAN_MSR5_MRDY_Msk       = 0x800000  // Bit mask of MRDY field.
	CAN_MSR5_MRDY           = 0x800000  // Bit MRDY.
	CAN_MSR5_MMI_Pos        = 0x18      // Position of MMI field.
	CAN_MSR5_MMI_Msk        = 0x1000000 // Bit mask of MMI field.
	CAN_MSR5_MMI            = 0x1000000 // Bit MMI.

	// MDL5: Mailbox Data Low Register (MB = 5)
	CAN_MDL5_MDL_Pos = 0x0        // Position of MDL field.
	CAN_MDL5_MDL_Msk = 0xffffffff // Bit mask of MDL field.

	// MDH5: Mailbox Data High Register (MB = 5)
	CAN_MDH5_MDH_Pos = 0x0        // Position of MDH field.
	CAN_MDH5_MDH_Msk = 0xffffffff // Bit mask of MDH field.

	// MCR5: Mailbox Control Register (MB = 5)
	CAN_MCR5_MDLC_Pos = 0x10     // Position of MDLC field.
	CAN_MCR5_MDLC_Msk = 0xf0000  // Bit mask of MDLC field.
	CAN_MCR5_MRTR_Pos = 0x14     // Position of MRTR field.
	CAN_MCR5_MRTR_Msk = 0x100000 // Bit mask of MRTR field.
	CAN_MCR5_MRTR     = 0x100000 // Bit MRTR.
	CAN_MCR5_MACR_Pos = 0x16     // Position of MACR field.
	CAN_MCR5_MACR_Msk = 0x400000 // Bit mask of MACR field.
	CAN_MCR5_MACR     = 0x400000 // Bit MACR.
	CAN_MCR5_MTCR_Pos = 0x17     // Position of MTCR field.
	CAN_MCR5_MTCR_Msk = 0x800000 // Bit mask of MTCR field.
	CAN_MCR5_MTCR     = 0x800000 // Bit MTCR.

	// MMR6: Mailbox Mode Register (MB = 6)
	CAN_MMR6_MTIMEMARK_Pos       = 0x0       // Position of MTIMEMARK field.
	CAN_MMR6_MTIMEMARK_Msk       = 0xffff    // Bit mask of MTIMEMARK field.
	CAN_MMR6_PRIOR_Pos           = 0x10      // Position of PRIOR field.
	CAN_MMR6_PRIOR_Msk           = 0xf0000   // Bit mask of PRIOR field.
	CAN_MMR6_MOT_Pos             = 0x18      // Position of MOT field.
	CAN_MMR6_MOT_Msk             = 0x7000000 // Bit mask of MOT field.
	CAN_MMR6_MOT_MB_DISABLED     = 0x0       // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR6_MOT_MB_RX           = 0x1       // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR6_MOT_MB_RX_OVERWRITE = 0x2       // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR6_MOT_MB_TX           = 0x3       // Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR6_MOT_MB_CONSUMER     = 0x4       // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR6_MOT_MB_PRODUCER     = 0x5       // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.

	// MAM6: Mailbox Acceptance Mask Register (MB = 6)
	CAN_MAM6_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MAM6_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MAM6_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MAM6_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MAM6_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MAM6_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MAM6_MIDE      = 0x20000000 // Bit MIDE.

	// MID6: Mailbox ID Register (MB = 6)
	CAN_MID6_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MID6_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MID6_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MID6_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MID6_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MID6_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MID6_MIDE      = 0x20000000 // Bit MIDE.

	// MFID6: Mailbox Family ID Register (MB = 6)
	CAN_MFID6_MFID_Pos = 0x0        // Position of MFID field.
	CAN_MFID6_MFID_Msk = 0x1fffffff // Bit mask of MFID field.

	// MSR6: Mailbox Status Register (MB = 6)
	CAN_MSR6_MTIMESTAMP_Pos = 0x0       // Position of MTIMESTAMP field.
	CAN_MSR6_MTIMESTAMP_Msk = 0xffff    // Bit mask of MTIMESTAMP field.
	CAN_MSR6_MDLC_Pos       = 0x10      // Position of MDLC field.
	CAN_MSR6_MDLC_Msk       = 0xf0000   // Bit mask of MDLC field.
	CAN_MSR6_MRTR_Pos       = 0x14      // Position of MRTR field.
	CAN_MSR6_MRTR_Msk       = 0x100000  // Bit mask of MRTR field.
	CAN_MSR6_MRTR           = 0x100000  // Bit MRTR.
	CAN_MSR6_MABT_Pos       = 0x16      // Position of MABT field.
	CAN_MSR6_MABT_Msk       = 0x400000  // Bit mask of MABT field.
	CAN_MSR6_MABT           = 0x400000  // Bit MABT.
	CAN_MSR6_MRDY_Pos       = 0x17      // Position of MRDY field.
	CAN_MSR6_MRDY_Msk       = 0x800000  // Bit mask of MRDY field.
	CAN_MSR6_MRDY           = 0x800000  // Bit MRDY.
	CAN_MSR6_MMI_Pos        = 0x18      // Position of MMI field.
	CAN_MSR6_MMI_Msk        = 0x1000000 // Bit mask of MMI field.
	CAN_MSR6_MMI            = 0x1000000 // Bit MMI.

	// MDL6: Mailbox Data Low Register (MB = 6)
	CAN_MDL6_MDL_Pos = 0x0        // Position of MDL field.
	CAN_MDL6_MDL_Msk = 0xffffffff // Bit mask of MDL field.

	// MDH6: Mailbox Data High Register (MB = 6)
	CAN_MDH6_MDH_Pos = 0x0        // Position of MDH field.
	CAN_MDH6_MDH_Msk = 0xffffffff // Bit mask of MDH field.

	// MCR6: Mailbox Control Register (MB = 6)
	CAN_MCR6_MDLC_Pos = 0x10     // Position of MDLC field.
	CAN_MCR6_MDLC_Msk = 0xf0000  // Bit mask of MDLC field.
	CAN_MCR6_MRTR_Pos = 0x14     // Position of MRTR field.
	CAN_MCR6_MRTR_Msk = 0x100000 // Bit mask of MRTR field.
	CAN_MCR6_MRTR     = 0x100000 // Bit MRTR.
	CAN_MCR6_MACR_Pos = 0x16     // Position of MACR field.
	CAN_MCR6_MACR_Msk = 0x400000 // Bit mask of MACR field.
	CAN_MCR6_MACR     = 0x400000 // Bit MACR.
	CAN_MCR6_MTCR_Pos = 0x17     // Position of MTCR field.
	CAN_MCR6_MTCR_Msk = 0x800000 // Bit mask of MTCR field.
	CAN_MCR6_MTCR     = 0x800000 // Bit MTCR.

	// MMR7: Mailbox Mode Register (MB = 7)
	CAN_MMR7_MTIMEMARK_Pos       = 0x0       // Position of MTIMEMARK field.
	CAN_MMR7_MTIMEMARK_Msk       = 0xffff    // Bit mask of MTIMEMARK field.
	CAN_MMR7_PRIOR_Pos           = 0x10      // Position of PRIOR field.
	CAN_MMR7_PRIOR_Msk           = 0xf0000   // Bit mask of PRIOR field.
	CAN_MMR7_MOT_Pos             = 0x18      // Position of MOT field.
	CAN_MMR7_MOT_Msk             = 0x7000000 // Bit mask of MOT field.
	CAN_MMR7_MOT_MB_DISABLED     = 0x0       // Mailbox is disabled. This prevents receiving or transmitting any messages with this mailbox.
	CAN_MMR7_MOT_MB_RX           = 0x1       // Reception Mailbox. Mailbox is configured for reception. If a message is received while the mailbox data register is full, it is discarded.
	CAN_MMR7_MOT_MB_RX_OVERWRITE = 0x2       // Reception mailbox with overwrite. Mailbox is configured for reception. If a message is received while the mailbox is full, it overwrites the previous message.
	CAN_MMR7_MOT_MB_TX           = 0x3       // Transmit mailbox. Mailbox is configured for transmission.
	CAN_MMR7_MOT_MB_CONSUMER     = 0x4       // Consumer Mailbox. Mailbox is configured in reception but behaves as a Transmit Mailbox, i.e., it sends a remote frame and waits for an answer.
	CAN_MMR7_MOT_MB_PRODUCER     = 0x5       // Producer Mailbox. Mailbox is configured in transmission but also behaves like a reception mailbox, i.e., it waits to receive a Remote Frame before sending its contents.

	// MAM7: Mailbox Acceptance Mask Register (MB = 7)
	CAN_MAM7_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MAM7_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MAM7_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MAM7_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MAM7_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MAM7_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MAM7_MIDE      = 0x20000000 // Bit MIDE.

	// MID7: Mailbox ID Register (MB = 7)
	CAN_MID7_MIDvB_Pos = 0x0        // Position of MIDvB field.
	CAN_MID7_MIDvB_Msk = 0x3ffff    // Bit mask of MIDvB field.
	CAN_MID7_MIDvA_Pos = 0x12       // Position of MIDvA field.
	CAN_MID7_MIDvA_Msk = 0x1ffc0000 // Bit mask of MIDvA field.
	CAN_MID7_MIDE_Pos  = 0x1d       // Position of MIDE field.
	CAN_MID7_MIDE_Msk  = 0x20000000 // Bit mask of MIDE field.
	CAN_MID7_MIDE      = 0x20000000 // Bit MIDE.

	// MFID7: Mailbox Family ID Register (MB = 7)
	CAN_MFID7_MFID_Pos = 0x0        // Position of MFID field.
	CAN_MFID7_MFID_Msk = 0x1fffffff // Bit mask of MFID field.

	// MSR7: Mailbox Status Register (MB = 7)
	CAN_MSR7_MTIMESTAMP_Pos = 0x0       // Position of MTIMESTAMP field.
	CAN_MSR7_MTIMESTAMP_Msk = 0xffff    // Bit mask of MTIMESTAMP field.
	CAN_MSR7_MDLC_Pos       = 0x10      // Position of MDLC field.
	CAN_MSR7_MDLC_Msk       = 0xf0000   // Bit mask of MDLC field.
	CAN_MSR7_MRTR_Pos       = 0x14      // Position of MRTR field.
	CAN_MSR7_MRTR_Msk       = 0x100000  // Bit mask of MRTR field.
	CAN_MSR7_MRTR           = 0x100000  // Bit MRTR.
	CAN_MSR7_MABT_Pos       = 0x16      // Position of MABT field.
	CAN_MSR7_MABT_Msk       = 0x400000  // Bit mask of MABT field.
	CAN_MSR7_MABT           = 0x400000  // Bit MABT.
	CAN_MSR7_MRDY_Pos       = 0x17      // Position of MRDY field.
	CAN_MSR7_MRDY_Msk       = 0x800000  // Bit mask of MRDY field.
	CAN_MSR7_MRDY           = 0x800000  // Bit MRDY.
	CAN_MSR7_MMI_Pos        = 0x18      // Position of MMI field.
	CAN_MSR7_MMI_Msk        = 0x1000000 // Bit mask of MMI field.
	CAN_MSR7_MMI            = 0x1000000 // Bit MMI.

	// MDL7: Mailbox Data Low Register (MB = 7)
	CAN_MDL7_MDL_Pos = 0x0        // Position of MDL field.
	CAN_MDL7_MDL_Msk = 0xffffffff // Bit mask of MDL field.

	// MDH7: Mailbox Data High Register (MB = 7)
	CAN_MDH7_MDH_Pos = 0x0        // Position of MDH field.
	CAN_MDH7_MDH_Msk = 0xffffffff // Bit mask of MDH field.

	// MCR7: Mailbox Control Register (MB = 7)
	CAN_MCR7_MDLC_Pos = 0x10     // Position of MDLC field.
	CAN_MCR7_MDLC_Msk = 0xf0000  // Bit mask of MDLC field.
	CAN_MCR7_MRTR_Pos = 0x14     // Position of MRTR field.
	CAN_MCR7_MRTR_Msk = 0x100000 // Bit mask of MRTR field.
	CAN_MCR7_MRTR     = 0x100000 // Bit MRTR.
	CAN_MCR7_MACR_Pos = 0x16     // Position of MACR field.
	CAN_MCR7_MACR_Msk = 0x400000 // Bit mask of MACR field.
	CAN_MCR7_MACR     = 0x400000 // Bit MACR.
	CAN_MCR7_MTCR_Pos = 0x17     // Position of MTCR field.
	CAN_MCR7_MTCR_Msk = 0x800000 // Bit mask of MTCR field.
	CAN_MCR7_MTCR     = 0x800000 // Bit MTCR.
)

// Bitfields for TC0: Timer Counter 0
const (
	// CCR0: Channel Control Register (channel = 0)
	TC_CCR0_CLKEN_Pos  = 0x0 // Position of CLKEN field.
	TC_CCR0_CLKEN_Msk  = 0x1 // Bit mask of CLKEN field.
	TC_CCR0_CLKEN      = 0x1 // Bit CLKEN.
	TC_CCR0_CLKDIS_Pos = 0x1 // Position of CLKDIS field.
	TC_CCR0_CLKDIS_Msk = 0x2 // Bit mask of CLKDIS field.
	TC_CCR0_CLKDIS     = 0x2 // Bit CLKDIS.
	TC_CCR0_SWTRG_Pos  = 0x2 // Position of SWTRG field.
	TC_CCR0_SWTRG_Msk  = 0x4 // Bit mask of SWTRG field.
	TC_CCR0_SWTRG      = 0x4 // Bit SWTRG.

	// CMR0: Channel Mode Register (channel = 0)
	TC_CMR0_TCCLKS_Pos          = 0x0     // Position of TCCLKS field.
	TC_CMR0_TCCLKS_Msk          = 0x7     // Bit mask of TCCLKS field.
	TC_CMR0_TCCLKS_TIMER_CLOCK1 = 0x0     // Clock selected: TCLK1
	TC_CMR0_TCCLKS_TIMER_CLOCK2 = 0x1     // Clock selected: TCLK2
	TC_CMR0_TCCLKS_TIMER_CLOCK3 = 0x2     // Clock selected: TCLK3
	TC_CMR0_TCCLKS_TIMER_CLOCK4 = 0x3     // Clock selected: TCLK4
	TC_CMR0_TCCLKS_TIMER_CLOCK5 = 0x4     // Clock selected: TCLK5
	TC_CMR0_TCCLKS_XC0          = 0x5     // Clock selected: XC0
	TC_CMR0_TCCLKS_XC1          = 0x6     // Clock selected: XC1
	TC_CMR0_TCCLKS_XC2          = 0x7     // Clock selected: XC2
	TC_CMR0_CLKI_Pos            = 0x3     // Position of CLKI field.
	TC_CMR0_CLKI_Msk            = 0x8     // Bit mask of CLKI field.
	TC_CMR0_CLKI                = 0x8     // Bit CLKI.
	TC_CMR0_BURST_Pos           = 0x4     // Position of BURST field.
	TC_CMR0_BURST_Msk           = 0x30    // Bit mask of BURST field.
	TC_CMR0_BURST_NONE          = 0x0     // The clock is not gated by an external signal.
	TC_CMR0_BURST_XC0           = 0x1     // XC0 is ANDed with the selected clock.
	TC_CMR0_BURST_XC1           = 0x2     // XC1 is ANDed with the selected clock.
	TC_CMR0_BURST_XC2           = 0x3     // XC2 is ANDed with the selected clock.
	TC_CMR0_LDBSTOP_Pos         = 0x6     // Position of LDBSTOP field.
	TC_CMR0_LDBSTOP_Msk         = 0x40    // Bit mask of LDBSTOP field.
	TC_CMR0_LDBSTOP             = 0x40    // Bit LDBSTOP.
	TC_CMR0_LDBDIS_Pos          = 0x7     // Position of LDBDIS field.
	TC_CMR0_LDBDIS_Msk          = 0x80    // Bit mask of LDBDIS field.
	TC_CMR0_LDBDIS              = 0x80    // Bit LDBDIS.
	TC_CMR0_ETRGEDG_Pos         = 0x8     // Position of ETRGEDG field.
	TC_CMR0_ETRGEDG_Msk         = 0x300   // Bit mask of ETRGEDG field.
	TC_CMR0_ETRGEDG_NONE        = 0x0     // The clock is not gated by an external signal.
	TC_CMR0_ETRGEDG_RISING      = 0x1     // Rising edge
	TC_CMR0_ETRGEDG_FALLING     = 0x2     // Falling edge
	TC_CMR0_ETRGEDG_EDGE        = 0x3     // Each edge
	TC_CMR0_ABETRG_Pos          = 0xa     // Position of ABETRG field.
	TC_CMR0_ABETRG_Msk          = 0x400   // Bit mask of ABETRG field.
	TC_CMR0_ABETRG              = 0x400   // Bit ABETRG.
	TC_CMR0_CPCTRG_Pos          = 0xe     // Position of CPCTRG field.
	TC_CMR0_CPCTRG_Msk          = 0x4000  // Bit mask of CPCTRG field.
	TC_CMR0_CPCTRG              = 0x4000  // Bit CPCTRG.
	TC_CMR0_WAVE_Pos            = 0xf     // Position of WAVE field.
	TC_CMR0_WAVE_Msk            = 0x8000  // Bit mask of WAVE field.
	TC_CMR0_WAVE                = 0x8000  // Bit WAVE.
	TC_CMR0_LDRA_Pos            = 0x10    // Position of LDRA field.
	TC_CMR0_LDRA_Msk            = 0x30000 // Bit mask of LDRA field.
	TC_CMR0_LDRA_NONE           = 0x0     // None
	TC_CMR0_LDRA_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR0_LDRA_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR0_LDRA_EDGE           = 0x3     // Each edge of TIOA
	TC_CMR0_LDRB_Pos            = 0x12    // Position of LDRB field.
	TC_CMR0_LDRB_Msk            = 0xc0000 // Bit mask of LDRB field.
	TC_CMR0_LDRB_NONE           = 0x0     // None
	TC_CMR0_LDRB_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR0_LDRB_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR0_LDRB_EDGE           = 0x3     // Each edge of TIOA

	// CMR0_WAVE_EQ_1: Channel Mode Register (channel = 0)
	TC_CMR0_WAVE_EQ_1_TCCLKS_Pos          = 0x0        // Position of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Msk          = 0x7        // Bit mask of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0        // Clock selected: TCLK1
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1        // Clock selected: TCLK2
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2        // Clock selected: TCLK3
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3        // Clock selected: TCLK4
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4        // Clock selected: TCLK5
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC0          = 0x5        // Clock selected: XC0
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC1          = 0x6        // Clock selected: XC1
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC2          = 0x7        // Clock selected: XC2
	TC_CMR0_WAVE_EQ_1_CLKI_Pos            = 0x3        // Position of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Msk            = 0x8        // Bit mask of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI                = 0x8        // Bit CLKI.
	TC_CMR0_WAVE_EQ_1_BURST_Pos           = 0x4        // Position of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Msk           = 0x30       // Bit mask of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_NONE          = 0x0        // The clock is not gated by an external signal.
	TC_CMR0_WAVE_EQ_1_BURST_XC0           = 0x1        // XC0 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC1           = 0x2        // XC1 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC2           = 0x3        // XC2 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Pos         = 0x6        // Position of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Msk         = 0x40       // Bit mask of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP             = 0x40       // Bit CPCSTOP.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Pos          = 0x7        // Position of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Msk          = 0x80       // Bit mask of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS              = 0x80       // Bit CPCDIS.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Pos         = 0x8        // Position of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Msk         = 0x300      // Bit mask of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_NONE        = 0x0        // None
	TC_CMR0_WAVE_EQ_1_EEVTEDG_RISING      = 0x1        // Rising edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_FALLING     = 0x2        // Falling edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_EDGE        = 0x3        // Each edge
	TC_CMR0_WAVE_EQ_1_EEVT_Pos            = 0xa        // Position of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Msk            = 0xc00      // Bit mask of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_TIOB           = 0x0        // TIOB
	TC_CMR0_WAVE_EQ_1_EEVT_XC0            = 0x1        // XC0
	TC_CMR0_WAVE_EQ_1_EEVT_XC1            = 0x2        // XC1
	TC_CMR0_WAVE_EQ_1_EEVT_XC2            = 0x3        // XC2
	TC_CMR0_WAVE_EQ_1_ENETRG_Pos          = 0xc        // Position of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Msk          = 0x1000     // Bit mask of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG              = 0x1000     // Bit ENETRG.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Pos          = 0xd        // Position of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Msk          = 0x6000     // Bit mask of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP           = 0x0        // UP mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN       = 0x1        // UPDOWN mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP_RC        = 0x2        // UP mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN_RC    = 0x3        // UPDOWN mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVE_Pos            = 0xf        // Position of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Msk            = 0x8000     // Bit mask of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE                = 0x8000     // Bit WAVE.
	TC_CMR0_WAVE_EQ_1_ACPA_Pos            = 0x10       // Position of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Msk            = 0x30000    // Bit mask of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_NONE           = 0x0        // None
	TC_CMR0_WAVE_EQ_1_ACPA_SET            = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_ACPA_CLEAR          = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_ACPA_TOGGLE         = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_ACPC_Pos            = 0x12       // Position of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Msk            = 0xc0000    // Bit mask of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_NONE           = 0x0        // None
	TC_CMR0_WAVE_EQ_1_ACPC_SET            = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_ACPC_CLEAR          = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_ACPC_TOGGLE         = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_AEEVT_Pos           = 0x14       // Position of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Msk           = 0x300000   // Bit mask of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_NONE          = 0x0        // None
	TC_CMR0_WAVE_EQ_1_AEEVT_SET           = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_AEEVT_CLEAR         = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_AEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_ASWTRG_Pos          = 0x16       // Position of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Msk          = 0xc00000   // Bit mask of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_NONE         = 0x0        // None
	TC_CMR0_WAVE_EQ_1_ASWTRG_SET          = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_ASWTRG_CLEAR        = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_ASWTRG_TOGGLE       = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_BCPB_Pos            = 0x18       // Position of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Msk            = 0x3000000  // Bit mask of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_NONE           = 0x0        // None
	TC_CMR0_WAVE_EQ_1_BCPB_SET            = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_BCPB_CLEAR          = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_BCPB_TOGGLE         = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_BCPC_Pos            = 0x1a       // Position of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Msk            = 0xc000000  // Bit mask of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_NONE           = 0x0        // None
	TC_CMR0_WAVE_EQ_1_BCPC_SET            = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_BCPC_CLEAR          = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_BCPC_TOGGLE         = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_BEEVT_Pos           = 0x1c       // Position of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Msk           = 0x30000000 // Bit mask of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_NONE          = 0x0        // None
	TC_CMR0_WAVE_EQ_1_BEEVT_SET           = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_BEEVT_CLEAR         = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_BEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_BSWTRG_Pos          = 0x1e       // Position of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Msk          = 0xc0000000 // Bit mask of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_NONE         = 0x0        // None
	TC_CMR0_WAVE_EQ_1_BSWTRG_SET          = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_BSWTRG_CLEAR        = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_BSWTRG_TOGGLE       = 0x3        // Toggle

	// CV0: Counter Value (channel = 0)
	TC_CV0_CV_Pos = 0x0        // Position of CV field.
	TC_CV0_CV_Msk = 0xffffffff // Bit mask of CV field.

	// RA0: Register A (channel = 0)
	TC_RA0_RA_Pos = 0x0        // Position of RA field.
	TC_RA0_RA_Msk = 0xffffffff // Bit mask of RA field.

	// RB0: Register B (channel = 0)
	TC_RB0_RB_Pos = 0x0        // Position of RB field.
	TC_RB0_RB_Msk = 0xffffffff // Bit mask of RB field.

	// RC0: Register C (channel = 0)
	TC_RC0_RC_Pos = 0x0        // Position of RC field.
	TC_RC0_RC_Msk = 0xffffffff // Bit mask of RC field.

	// SR0: Status Register (channel = 0)
	TC_SR0_COVFS_Pos  = 0x0     // Position of COVFS field.
	TC_SR0_COVFS_Msk  = 0x1     // Bit mask of COVFS field.
	TC_SR0_COVFS      = 0x1     // Bit COVFS.
	TC_SR0_LOVRS_Pos  = 0x1     // Position of LOVRS field.
	TC_SR0_LOVRS_Msk  = 0x2     // Bit mask of LOVRS field.
	TC_SR0_LOVRS      = 0x2     // Bit LOVRS.
	TC_SR0_CPAS_Pos   = 0x2     // Position of CPAS field.
	TC_SR0_CPAS_Msk   = 0x4     // Bit mask of CPAS field.
	TC_SR0_CPAS       = 0x4     // Bit CPAS.
	TC_SR0_CPBS_Pos   = 0x3     // Position of CPBS field.
	TC_SR0_CPBS_Msk   = 0x8     // Bit mask of CPBS field.
	TC_SR0_CPBS       = 0x8     // Bit CPBS.
	TC_SR0_CPCS_Pos   = 0x4     // Position of CPCS field.
	TC_SR0_CPCS_Msk   = 0x10    // Bit mask of CPCS field.
	TC_SR0_CPCS       = 0x10    // Bit CPCS.
	TC_SR0_LDRAS_Pos  = 0x5     // Position of LDRAS field.
	TC_SR0_LDRAS_Msk  = 0x20    // Bit mask of LDRAS field.
	TC_SR0_LDRAS      = 0x20    // Bit LDRAS.
	TC_SR0_LDRBS_Pos  = 0x6     // Position of LDRBS field.
	TC_SR0_LDRBS_Msk  = 0x40    // Bit mask of LDRBS field.
	TC_SR0_LDRBS      = 0x40    // Bit LDRBS.
	TC_SR0_ETRGS_Pos  = 0x7     // Position of ETRGS field.
	TC_SR0_ETRGS_Msk  = 0x80    // Bit mask of ETRGS field.
	TC_SR0_ETRGS      = 0x80    // Bit ETRGS.
	TC_SR0_CLKSTA_Pos = 0x10    // Position of CLKSTA field.
	TC_SR0_CLKSTA_Msk = 0x10000 // Bit mask of CLKSTA field.
	TC_SR0_CLKSTA     = 0x10000 // Bit CLKSTA.
	TC_SR0_MTIOA_Pos  = 0x11    // Position of MTIOA field.
	TC_SR0_MTIOA_Msk  = 0x20000 // Bit mask of MTIOA field.
	TC_SR0_MTIOA      = 0x20000 // Bit MTIOA.
	TC_SR0_MTIOB_Pos  = 0x12    // Position of MTIOB field.
	TC_SR0_MTIOB_Msk  = 0x40000 // Bit mask of MTIOB field.
	TC_SR0_MTIOB      = 0x40000 // Bit MTIOB.

	// IER0: Interrupt Enable Register (channel = 0)
	TC_IER0_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IER0_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IER0_COVFS     = 0x1  // Bit COVFS.
	TC_IER0_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IER0_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IER0_LOVRS     = 0x2  // Bit LOVRS.
	TC_IER0_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IER0_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IER0_CPAS      = 0x4  // Bit CPAS.
	TC_IER0_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IER0_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IER0_CPBS      = 0x8  // Bit CPBS.
	TC_IER0_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IER0_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IER0_CPCS      = 0x10 // Bit CPCS.
	TC_IER0_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IER0_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IER0_LDRAS     = 0x20 // Bit LDRAS.
	TC_IER0_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IER0_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IER0_LDRBS     = 0x40 // Bit LDRBS.
	TC_IER0_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IER0_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IER0_ETRGS     = 0x80 // Bit ETRGS.

	// IDR0: Interrupt Disable Register (channel = 0)
	TC_IDR0_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IDR0_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IDR0_COVFS     = 0x1  // Bit COVFS.
	TC_IDR0_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IDR0_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IDR0_LOVRS     = 0x2  // Bit LOVRS.
	TC_IDR0_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IDR0_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IDR0_CPAS      = 0x4  // Bit CPAS.
	TC_IDR0_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IDR0_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IDR0_CPBS      = 0x8  // Bit CPBS.
	TC_IDR0_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IDR0_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IDR0_CPCS      = 0x10 // Bit CPCS.
	TC_IDR0_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IDR0_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IDR0_LDRAS     = 0x20 // Bit LDRAS.
	TC_IDR0_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IDR0_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IDR0_LDRBS     = 0x40 // Bit LDRBS.
	TC_IDR0_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IDR0_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IDR0_ETRGS     = 0x80 // Bit ETRGS.

	// IMR0: Interrupt Mask Register (channel = 0)
	TC_IMR0_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IMR0_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IMR0_COVFS     = 0x1  // Bit COVFS.
	TC_IMR0_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IMR0_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IMR0_LOVRS     = 0x2  // Bit LOVRS.
	TC_IMR0_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IMR0_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IMR0_CPAS      = 0x4  // Bit CPAS.
	TC_IMR0_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IMR0_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IMR0_CPBS      = 0x8  // Bit CPBS.
	TC_IMR0_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IMR0_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IMR0_CPCS      = 0x10 // Bit CPCS.
	TC_IMR0_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IMR0_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IMR0_LDRAS     = 0x20 // Bit LDRAS.
	TC_IMR0_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IMR0_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IMR0_LDRBS     = 0x40 // Bit LDRBS.
	TC_IMR0_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IMR0_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IMR0_ETRGS     = 0x80 // Bit ETRGS.

	// CCR1: Channel Control Register (channel = 1)
	TC_CCR1_CLKEN_Pos  = 0x0 // Position of CLKEN field.
	TC_CCR1_CLKEN_Msk  = 0x1 // Bit mask of CLKEN field.
	TC_CCR1_CLKEN      = 0x1 // Bit CLKEN.
	TC_CCR1_CLKDIS_Pos = 0x1 // Position of CLKDIS field.
	TC_CCR1_CLKDIS_Msk = 0x2 // Bit mask of CLKDIS field.
	TC_CCR1_CLKDIS     = 0x2 // Bit CLKDIS.
	TC_CCR1_SWTRG_Pos  = 0x2 // Position of SWTRG field.
	TC_CCR1_SWTRG_Msk  = 0x4 // Bit mask of SWTRG field.
	TC_CCR1_SWTRG      = 0x4 // Bit SWTRG.

	// CMR1: Channel Mode Register (channel = 1)
	TC_CMR1_TCCLKS_Pos          = 0x0     // Position of TCCLKS field.
	TC_CMR1_TCCLKS_Msk          = 0x7     // Bit mask of TCCLKS field.
	TC_CMR1_TCCLKS_TIMER_CLOCK1 = 0x0     // Clock selected: TCLK1
	TC_CMR1_TCCLKS_TIMER_CLOCK2 = 0x1     // Clock selected: TCLK2
	TC_CMR1_TCCLKS_TIMER_CLOCK3 = 0x2     // Clock selected: TCLK3
	TC_CMR1_TCCLKS_TIMER_CLOCK4 = 0x3     // Clock selected: TCLK4
	TC_CMR1_TCCLKS_TIMER_CLOCK5 = 0x4     // Clock selected: TCLK5
	TC_CMR1_TCCLKS_XC0          = 0x5     // Clock selected: XC0
	TC_CMR1_TCCLKS_XC1          = 0x6     // Clock selected: XC1
	TC_CMR1_TCCLKS_XC2          = 0x7     // Clock selected: XC2
	TC_CMR1_CLKI_Pos            = 0x3     // Position of CLKI field.
	TC_CMR1_CLKI_Msk            = 0x8     // Bit mask of CLKI field.
	TC_CMR1_CLKI                = 0x8     // Bit CLKI.
	TC_CMR1_BURST_Pos           = 0x4     // Position of BURST field.
	TC_CMR1_BURST_Msk           = 0x30    // Bit mask of BURST field.
	TC_CMR1_BURST_NONE          = 0x0     // The clock is not gated by an external signal.
	TC_CMR1_BURST_XC0           = 0x1     // XC0 is ANDed with the selected clock.
	TC_CMR1_BURST_XC1           = 0x2     // XC1 is ANDed with the selected clock.
	TC_CMR1_BURST_XC2           = 0x3     // XC2 is ANDed with the selected clock.
	TC_CMR1_LDBSTOP_Pos         = 0x6     // Position of LDBSTOP field.
	TC_CMR1_LDBSTOP_Msk         = 0x40    // Bit mask of LDBSTOP field.
	TC_CMR1_LDBSTOP             = 0x40    // Bit LDBSTOP.
	TC_CMR1_LDBDIS_Pos          = 0x7     // Position of LDBDIS field.
	TC_CMR1_LDBDIS_Msk          = 0x80    // Bit mask of LDBDIS field.
	TC_CMR1_LDBDIS              = 0x80    // Bit LDBDIS.
	TC_CMR1_ETRGEDG_Pos         = 0x8     // Position of ETRGEDG field.
	TC_CMR1_ETRGEDG_Msk         = 0x300   // Bit mask of ETRGEDG field.
	TC_CMR1_ETRGEDG_NONE        = 0x0     // The clock is not gated by an external signal.
	TC_CMR1_ETRGEDG_RISING      = 0x1     // Rising edge
	TC_CMR1_ETRGEDG_FALLING     = 0x2     // Falling edge
	TC_CMR1_ETRGEDG_EDGE        = 0x3     // Each edge
	TC_CMR1_ABETRG_Pos          = 0xa     // Position of ABETRG field.
	TC_CMR1_ABETRG_Msk          = 0x400   // Bit mask of ABETRG field.
	TC_CMR1_ABETRG              = 0x400   // Bit ABETRG.
	TC_CMR1_CPCTRG_Pos          = 0xe     // Position of CPCTRG field.
	TC_CMR1_CPCTRG_Msk          = 0x4000  // Bit mask of CPCTRG field.
	TC_CMR1_CPCTRG              = 0x4000  // Bit CPCTRG.
	TC_CMR1_WAVE_Pos            = 0xf     // Position of WAVE field.
	TC_CMR1_WAVE_Msk            = 0x8000  // Bit mask of WAVE field.
	TC_CMR1_WAVE                = 0x8000  // Bit WAVE.
	TC_CMR1_LDRA_Pos            = 0x10    // Position of LDRA field.
	TC_CMR1_LDRA_Msk            = 0x30000 // Bit mask of LDRA field.
	TC_CMR1_LDRA_NONE           = 0x0     // None
	TC_CMR1_LDRA_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR1_LDRA_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR1_LDRA_EDGE           = 0x3     // Each edge of TIOA
	TC_CMR1_LDRB_Pos            = 0x12    // Position of LDRB field.
	TC_CMR1_LDRB_Msk            = 0xc0000 // Bit mask of LDRB field.
	TC_CMR1_LDRB_NONE           = 0x0     // None
	TC_CMR1_LDRB_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR1_LDRB_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR1_LDRB_EDGE           = 0x3     // Each edge of TIOA

	// CMR1_WAVE_EQ_1: Channel Mode Register (channel = 1)
	TC_CMR1_WAVE_EQ_1_TCCLKS_Pos          = 0x0        // Position of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Msk          = 0x7        // Bit mask of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0        // Clock selected: TCLK1
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1        // Clock selected: TCLK2
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2        // Clock selected: TCLK3
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3        // Clock selected: TCLK4
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4        // Clock selected: TCLK5
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC0          = 0x5        // Clock selected: XC0
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC1          = 0x6        // Clock selected: XC1
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC2          = 0x7        // Clock selected: XC2
	TC_CMR1_WAVE_EQ_1_CLKI_Pos            = 0x3        // Position of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Msk            = 0x8        // Bit mask of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI                = 0x8        // Bit CLKI.
	TC_CMR1_WAVE_EQ_1_BURST_Pos           = 0x4        // Position of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Msk           = 0x30       // Bit mask of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_NONE          = 0x0        // The clock is not gated by an external signal.
	TC_CMR1_WAVE_EQ_1_BURST_XC0           = 0x1        // XC0 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC1           = 0x2        // XC1 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC2           = 0x3        // XC2 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Pos         = 0x6        // Position of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Msk         = 0x40       // Bit mask of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP             = 0x40       // Bit CPCSTOP.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Pos          = 0x7        // Position of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Msk          = 0x80       // Bit mask of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS              = 0x80       // Bit CPCDIS.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Pos         = 0x8        // Position of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Msk         = 0x300      // Bit mask of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_NONE        = 0x0        // None
	TC_CMR1_WAVE_EQ_1_EEVTEDG_RISING      = 0x1        // Rising edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_FALLING     = 0x2        // Falling edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_EDGE        = 0x3        // Each edge
	TC_CMR1_WAVE_EQ_1_EEVT_Pos            = 0xa        // Position of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Msk            = 0xc00      // Bit mask of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_TIOB           = 0x0        // TIOB
	TC_CMR1_WAVE_EQ_1_EEVT_XC0            = 0x1        // XC0
	TC_CMR1_WAVE_EQ_1_EEVT_XC1            = 0x2        // XC1
	TC_CMR1_WAVE_EQ_1_EEVT_XC2            = 0x3        // XC2
	TC_CMR1_WAVE_EQ_1_ENETRG_Pos          = 0xc        // Position of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Msk          = 0x1000     // Bit mask of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG              = 0x1000     // Bit ENETRG.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Pos          = 0xd        // Position of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Msk          = 0x6000     // Bit mask of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP           = 0x0        // UP mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN       = 0x1        // UPDOWN mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP_RC        = 0x2        // UP mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN_RC    = 0x3        // UPDOWN mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVE_Pos            = 0xf        // Position of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Msk            = 0x8000     // Bit mask of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE                = 0x8000     // Bit WAVE.
	TC_CMR1_WAVE_EQ_1_ACPA_Pos            = 0x10       // Position of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Msk            = 0x30000    // Bit mask of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_NONE           = 0x0        // None
	TC_CMR1_WAVE_EQ_1_ACPA_SET            = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_ACPA_CLEAR          = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_ACPA_TOGGLE         = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_ACPC_Pos            = 0x12       // Position of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Msk            = 0xc0000    // Bit mask of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_NONE           = 0x0        // None
	TC_CMR1_WAVE_EQ_1_ACPC_SET            = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_ACPC_CLEAR          = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_ACPC_TOGGLE         = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_AEEVT_Pos           = 0x14       // Position of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Msk           = 0x300000   // Bit mask of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_NONE          = 0x0        // None
	TC_CMR1_WAVE_EQ_1_AEEVT_SET           = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_AEEVT_CLEAR         = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_AEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_ASWTRG_Pos          = 0x16       // Position of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Msk          = 0xc00000   // Bit mask of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_NONE         = 0x0        // None
	TC_CMR1_WAVE_EQ_1_ASWTRG_SET          = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_ASWTRG_CLEAR        = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_ASWTRG_TOGGLE       = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_BCPB_Pos            = 0x18       // Position of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Msk            = 0x3000000  // Bit mask of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_NONE           = 0x0        // None
	TC_CMR1_WAVE_EQ_1_BCPB_SET            = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_BCPB_CLEAR          = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_BCPB_TOGGLE         = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_BCPC_Pos            = 0x1a       // Position of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Msk            = 0xc000000  // Bit mask of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_NONE           = 0x0        // None
	TC_CMR1_WAVE_EQ_1_BCPC_SET            = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_BCPC_CLEAR          = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_BCPC_TOGGLE         = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_BEEVT_Pos           = 0x1c       // Position of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Msk           = 0x30000000 // Bit mask of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_NONE          = 0x0        // None
	TC_CMR1_WAVE_EQ_1_BEEVT_SET           = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_BEEVT_CLEAR         = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_BEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_BSWTRG_Pos          = 0x1e       // Position of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Msk          = 0xc0000000 // Bit mask of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_NONE         = 0x0        // None
	TC_CMR1_WAVE_EQ_1_BSWTRG_SET          = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_BSWTRG_CLEAR        = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_BSWTRG_TOGGLE       = 0x3        // Toggle

	// CV1: Counter Value (channel = 1)
	TC_CV1_CV_Pos = 0x0        // Position of CV field.
	TC_CV1_CV_Msk = 0xffffffff // Bit mask of CV field.

	// RA1: Register A (channel = 1)
	TC_RA1_RA_Pos = 0x0        // Position of RA field.
	TC_RA1_RA_Msk = 0xffffffff // Bit mask of RA field.

	// RB1: Register B (channel = 1)
	TC_RB1_RB_Pos = 0x0        // Position of RB field.
	TC_RB1_RB_Msk = 0xffffffff // Bit mask of RB field.

	// RC1: Register C (channel = 1)
	TC_RC1_RC_Pos = 0x0        // Position of RC field.
	TC_RC1_RC_Msk = 0xffffffff // Bit mask of RC field.

	// SR1: Status Register (channel = 1)
	TC_SR1_COVFS_Pos  = 0x0     // Position of COVFS field.
	TC_SR1_COVFS_Msk  = 0x1     // Bit mask of COVFS field.
	TC_SR1_COVFS      = 0x1     // Bit COVFS.
	TC_SR1_LOVRS_Pos  = 0x1     // Position of LOVRS field.
	TC_SR1_LOVRS_Msk  = 0x2     // Bit mask of LOVRS field.
	TC_SR1_LOVRS      = 0x2     // Bit LOVRS.
	TC_SR1_CPAS_Pos   = 0x2     // Position of CPAS field.
	TC_SR1_CPAS_Msk   = 0x4     // Bit mask of CPAS field.
	TC_SR1_CPAS       = 0x4     // Bit CPAS.
	TC_SR1_CPBS_Pos   = 0x3     // Position of CPBS field.
	TC_SR1_CPBS_Msk   = 0x8     // Bit mask of CPBS field.
	TC_SR1_CPBS       = 0x8     // Bit CPBS.
	TC_SR1_CPCS_Pos   = 0x4     // Position of CPCS field.
	TC_SR1_CPCS_Msk   = 0x10    // Bit mask of CPCS field.
	TC_SR1_CPCS       = 0x10    // Bit CPCS.
	TC_SR1_LDRAS_Pos  = 0x5     // Position of LDRAS field.
	TC_SR1_LDRAS_Msk  = 0x20    // Bit mask of LDRAS field.
	TC_SR1_LDRAS      = 0x20    // Bit LDRAS.
	TC_SR1_LDRBS_Pos  = 0x6     // Position of LDRBS field.
	TC_SR1_LDRBS_Msk  = 0x40    // Bit mask of LDRBS field.
	TC_SR1_LDRBS      = 0x40    // Bit LDRBS.
	TC_SR1_ETRGS_Pos  = 0x7     // Position of ETRGS field.
	TC_SR1_ETRGS_Msk  = 0x80    // Bit mask of ETRGS field.
	TC_SR1_ETRGS      = 0x80    // Bit ETRGS.
	TC_SR1_CLKSTA_Pos = 0x10    // Position of CLKSTA field.
	TC_SR1_CLKSTA_Msk = 0x10000 // Bit mask of CLKSTA field.
	TC_SR1_CLKSTA     = 0x10000 // Bit CLKSTA.
	TC_SR1_MTIOA_Pos  = 0x11    // Position of MTIOA field.
	TC_SR1_MTIOA_Msk  = 0x20000 // Bit mask of MTIOA field.
	TC_SR1_MTIOA      = 0x20000 // Bit MTIOA.
	TC_SR1_MTIOB_Pos  = 0x12    // Position of MTIOB field.
	TC_SR1_MTIOB_Msk  = 0x40000 // Bit mask of MTIOB field.
	TC_SR1_MTIOB      = 0x40000 // Bit MTIOB.

	// IER1: Interrupt Enable Register (channel = 1)
	TC_IER1_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IER1_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IER1_COVFS     = 0x1  // Bit COVFS.
	TC_IER1_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IER1_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IER1_LOVRS     = 0x2  // Bit LOVRS.
	TC_IER1_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IER1_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IER1_CPAS      = 0x4  // Bit CPAS.
	TC_IER1_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IER1_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IER1_CPBS      = 0x8  // Bit CPBS.
	TC_IER1_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IER1_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IER1_CPCS      = 0x10 // Bit CPCS.
	TC_IER1_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IER1_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IER1_LDRAS     = 0x20 // Bit LDRAS.
	TC_IER1_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IER1_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IER1_LDRBS     = 0x40 // Bit LDRBS.
	TC_IER1_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IER1_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IER1_ETRGS     = 0x80 // Bit ETRGS.

	// IDR1: Interrupt Disable Register (channel = 1)
	TC_IDR1_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IDR1_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IDR1_COVFS     = 0x1  // Bit COVFS.
	TC_IDR1_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IDR1_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IDR1_LOVRS     = 0x2  // Bit LOVRS.
	TC_IDR1_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IDR1_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IDR1_CPAS      = 0x4  // Bit CPAS.
	TC_IDR1_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IDR1_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IDR1_CPBS      = 0x8  // Bit CPBS.
	TC_IDR1_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IDR1_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IDR1_CPCS      = 0x10 // Bit CPCS.
	TC_IDR1_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IDR1_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IDR1_LDRAS     = 0x20 // Bit LDRAS.
	TC_IDR1_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IDR1_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IDR1_LDRBS     = 0x40 // Bit LDRBS.
	TC_IDR1_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IDR1_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IDR1_ETRGS     = 0x80 // Bit ETRGS.

	// IMR1: Interrupt Mask Register (channel = 1)
	TC_IMR1_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IMR1_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IMR1_COVFS     = 0x1  // Bit COVFS.
	TC_IMR1_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IMR1_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IMR1_LOVRS     = 0x2  // Bit LOVRS.
	TC_IMR1_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IMR1_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IMR1_CPAS      = 0x4  // Bit CPAS.
	TC_IMR1_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IMR1_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IMR1_CPBS      = 0x8  // Bit CPBS.
	TC_IMR1_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IMR1_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IMR1_CPCS      = 0x10 // Bit CPCS.
	TC_IMR1_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IMR1_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IMR1_LDRAS     = 0x20 // Bit LDRAS.
	TC_IMR1_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IMR1_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IMR1_LDRBS     = 0x40 // Bit LDRBS.
	TC_IMR1_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IMR1_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IMR1_ETRGS     = 0x80 // Bit ETRGS.

	// CCR2: Channel Control Register (channel = 2)
	TC_CCR2_CLKEN_Pos  = 0x0 // Position of CLKEN field.
	TC_CCR2_CLKEN_Msk  = 0x1 // Bit mask of CLKEN field.
	TC_CCR2_CLKEN      = 0x1 // Bit CLKEN.
	TC_CCR2_CLKDIS_Pos = 0x1 // Position of CLKDIS field.
	TC_CCR2_CLKDIS_Msk = 0x2 // Bit mask of CLKDIS field.
	TC_CCR2_CLKDIS     = 0x2 // Bit CLKDIS.
	TC_CCR2_SWTRG_Pos  = 0x2 // Position of SWTRG field.
	TC_CCR2_SWTRG_Msk  = 0x4 // Bit mask of SWTRG field.
	TC_CCR2_SWTRG      = 0x4 // Bit SWTRG.

	// CMR2: Channel Mode Register (channel = 2)
	TC_CMR2_TCCLKS_Pos          = 0x0     // Position of TCCLKS field.
	TC_CMR2_TCCLKS_Msk          = 0x7     // Bit mask of TCCLKS field.
	TC_CMR2_TCCLKS_TIMER_CLOCK1 = 0x0     // Clock selected: TCLK1
	TC_CMR2_TCCLKS_TIMER_CLOCK2 = 0x1     // Clock selected: TCLK2
	TC_CMR2_TCCLKS_TIMER_CLOCK3 = 0x2     // Clock selected: TCLK3
	TC_CMR2_TCCLKS_TIMER_CLOCK4 = 0x3     // Clock selected: TCLK4
	TC_CMR2_TCCLKS_TIMER_CLOCK5 = 0x4     // Clock selected: TCLK5
	TC_CMR2_TCCLKS_XC0          = 0x5     // Clock selected: XC0
	TC_CMR2_TCCLKS_XC1          = 0x6     // Clock selected: XC1
	TC_CMR2_TCCLKS_XC2          = 0x7     // Clock selected: XC2
	TC_CMR2_CLKI_Pos            = 0x3     // Position of CLKI field.
	TC_CMR2_CLKI_Msk            = 0x8     // Bit mask of CLKI field.
	TC_CMR2_CLKI                = 0x8     // Bit CLKI.
	TC_CMR2_BURST_Pos           = 0x4     // Position of BURST field.
	TC_CMR2_BURST_Msk           = 0x30    // Bit mask of BURST field.
	TC_CMR2_BURST_NONE          = 0x0     // The clock is not gated by an external signal.
	TC_CMR2_BURST_XC0           = 0x1     // XC0 is ANDed with the selected clock.
	TC_CMR2_BURST_XC1           = 0x2     // XC1 is ANDed with the selected clock.
	TC_CMR2_BURST_XC2           = 0x3     // XC2 is ANDed with the selected clock.
	TC_CMR2_LDBSTOP_Pos         = 0x6     // Position of LDBSTOP field.
	TC_CMR2_LDBSTOP_Msk         = 0x40    // Bit mask of LDBSTOP field.
	TC_CMR2_LDBSTOP             = 0x40    // Bit LDBSTOP.
	TC_CMR2_LDBDIS_Pos          = 0x7     // Position of LDBDIS field.
	TC_CMR2_LDBDIS_Msk          = 0x80    // Bit mask of LDBDIS field.
	TC_CMR2_LDBDIS              = 0x80    // Bit LDBDIS.
	TC_CMR2_ETRGEDG_Pos         = 0x8     // Position of ETRGEDG field.
	TC_CMR2_ETRGEDG_Msk         = 0x300   // Bit mask of ETRGEDG field.
	TC_CMR2_ETRGEDG_NONE        = 0x0     // The clock is not gated by an external signal.
	TC_CMR2_ETRGEDG_RISING      = 0x1     // Rising edge
	TC_CMR2_ETRGEDG_FALLING     = 0x2     // Falling edge
	TC_CMR2_ETRGEDG_EDGE        = 0x3     // Each edge
	TC_CMR2_ABETRG_Pos          = 0xa     // Position of ABETRG field.
	TC_CMR2_ABETRG_Msk          = 0x400   // Bit mask of ABETRG field.
	TC_CMR2_ABETRG              = 0x400   // Bit ABETRG.
	TC_CMR2_CPCTRG_Pos          = 0xe     // Position of CPCTRG field.
	TC_CMR2_CPCTRG_Msk          = 0x4000  // Bit mask of CPCTRG field.
	TC_CMR2_CPCTRG              = 0x4000  // Bit CPCTRG.
	TC_CMR2_WAVE_Pos            = 0xf     // Position of WAVE field.
	TC_CMR2_WAVE_Msk            = 0x8000  // Bit mask of WAVE field.
	TC_CMR2_WAVE                = 0x8000  // Bit WAVE.
	TC_CMR2_LDRA_Pos            = 0x10    // Position of LDRA field.
	TC_CMR2_LDRA_Msk            = 0x30000 // Bit mask of LDRA field.
	TC_CMR2_LDRA_NONE           = 0x0     // None
	TC_CMR2_LDRA_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR2_LDRA_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR2_LDRA_EDGE           = 0x3     // Each edge of TIOA
	TC_CMR2_LDRB_Pos            = 0x12    // Position of LDRB field.
	TC_CMR2_LDRB_Msk            = 0xc0000 // Bit mask of LDRB field.
	TC_CMR2_LDRB_NONE           = 0x0     // None
	TC_CMR2_LDRB_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR2_LDRB_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR2_LDRB_EDGE           = 0x3     // Each edge of TIOA

	// CMR2_WAVE_EQ_1: Channel Mode Register (channel = 2)
	TC_CMR2_WAVE_EQ_1_TCCLKS_Pos          = 0x0        // Position of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Msk          = 0x7        // Bit mask of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0        // Clock selected: TCLK1
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1        // Clock selected: TCLK2
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2        // Clock selected: TCLK3
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3        // Clock selected: TCLK4
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4        // Clock selected: TCLK5
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC0          = 0x5        // Clock selected: XC0
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC1          = 0x6        // Clock selected: XC1
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC2          = 0x7        // Clock selected: XC2
	TC_CMR2_WAVE_EQ_1_CLKI_Pos            = 0x3        // Position of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Msk            = 0x8        // Bit mask of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI                = 0x8        // Bit CLKI.
	TC_CMR2_WAVE_EQ_1_BURST_Pos           = 0x4        // Position of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Msk           = 0x30       // Bit mask of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_NONE          = 0x0        // The clock is not gated by an external signal.
	TC_CMR2_WAVE_EQ_1_BURST_XC0           = 0x1        // XC0 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC1           = 0x2        // XC1 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC2           = 0x3        // XC2 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Pos         = 0x6        // Position of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Msk         = 0x40       // Bit mask of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP             = 0x40       // Bit CPCSTOP.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Pos          = 0x7        // Position of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Msk          = 0x80       // Bit mask of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS              = 0x80       // Bit CPCDIS.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Pos         = 0x8        // Position of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Msk         = 0x300      // Bit mask of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_NONE        = 0x0        // None
	TC_CMR2_WAVE_EQ_1_EEVTEDG_RISING      = 0x1        // Rising edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_FALLING     = 0x2        // Falling edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_EDGE        = 0x3        // Each edge
	TC_CMR2_WAVE_EQ_1_EEVT_Pos            = 0xa        // Position of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Msk            = 0xc00      // Bit mask of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_TIOB           = 0x0        // TIOB
	TC_CMR2_WAVE_EQ_1_EEVT_XC0            = 0x1        // XC0
	TC_CMR2_WAVE_EQ_1_EEVT_XC1            = 0x2        // XC1
	TC_CMR2_WAVE_EQ_1_EEVT_XC2            = 0x3        // XC2
	TC_CMR2_WAVE_EQ_1_ENETRG_Pos          = 0xc        // Position of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Msk          = 0x1000     // Bit mask of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG              = 0x1000     // Bit ENETRG.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Pos          = 0xd        // Position of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Msk          = 0x6000     // Bit mask of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP           = 0x0        // UP mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN       = 0x1        // UPDOWN mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP_RC        = 0x2        // UP mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN_RC    = 0x3        // UPDOWN mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVE_Pos            = 0xf        // Position of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Msk            = 0x8000     // Bit mask of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE                = 0x8000     // Bit WAVE.
	TC_CMR2_WAVE_EQ_1_ACPA_Pos            = 0x10       // Position of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Msk            = 0x30000    // Bit mask of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_NONE           = 0x0        // None
	TC_CMR2_WAVE_EQ_1_ACPA_SET            = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_ACPA_CLEAR          = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_ACPA_TOGGLE         = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_ACPC_Pos            = 0x12       // Position of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Msk            = 0xc0000    // Bit mask of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_NONE           = 0x0        // None
	TC_CMR2_WAVE_EQ_1_ACPC_SET            = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_ACPC_CLEAR          = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_ACPC_TOGGLE         = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_AEEVT_Pos           = 0x14       // Position of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Msk           = 0x300000   // Bit mask of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_NONE          = 0x0        // None
	TC_CMR2_WAVE_EQ_1_AEEVT_SET           = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_AEEVT_CLEAR         = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_AEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_ASWTRG_Pos          = 0x16       // Position of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Msk          = 0xc00000   // Bit mask of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_NONE         = 0x0        // None
	TC_CMR2_WAVE_EQ_1_ASWTRG_SET          = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_ASWTRG_CLEAR        = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_ASWTRG_TOGGLE       = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_BCPB_Pos            = 0x18       // Position of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Msk            = 0x3000000  // Bit mask of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_NONE           = 0x0        // None
	TC_CMR2_WAVE_EQ_1_BCPB_SET            = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_BCPB_CLEAR          = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_BCPB_TOGGLE         = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_BCPC_Pos            = 0x1a       // Position of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Msk            = 0xc000000  // Bit mask of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_NONE           = 0x0        // None
	TC_CMR2_WAVE_EQ_1_BCPC_SET            = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_BCPC_CLEAR          = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_BCPC_TOGGLE         = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_BEEVT_Pos           = 0x1c       // Position of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Msk           = 0x30000000 // Bit mask of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_NONE          = 0x0        // None
	TC_CMR2_WAVE_EQ_1_BEEVT_SET           = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_BEEVT_CLEAR         = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_BEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_BSWTRG_Pos          = 0x1e       // Position of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Msk          = 0xc0000000 // Bit mask of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_NONE         = 0x0        // None
	TC_CMR2_WAVE_EQ_1_BSWTRG_SET          = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_BSWTRG_CLEAR        = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_BSWTRG_TOGGLE       = 0x3        // Toggle

	// CV2: Counter Value (channel = 2)
	TC_CV2_CV_Pos = 0x0        // Position of CV field.
	TC_CV2_CV_Msk = 0xffffffff // Bit mask of CV field.

	// RA2: Register A (channel = 2)
	TC_RA2_RA_Pos = 0x0        // Position of RA field.
	TC_RA2_RA_Msk = 0xffffffff // Bit mask of RA field.

	// RB2: Register B (channel = 2)
	TC_RB2_RB_Pos = 0x0        // Position of RB field.
	TC_RB2_RB_Msk = 0xffffffff // Bit mask of RB field.

	// RC2: Register C (channel = 2)
	TC_RC2_RC_Pos = 0x0        // Position of RC field.
	TC_RC2_RC_Msk = 0xffffffff // Bit mask of RC field.

	// SR2: Status Register (channel = 2)
	TC_SR2_COVFS_Pos  = 0x0     // Position of COVFS field.
	TC_SR2_COVFS_Msk  = 0x1     // Bit mask of COVFS field.
	TC_SR2_COVFS      = 0x1     // Bit COVFS.
	TC_SR2_LOVRS_Pos  = 0x1     // Position of LOVRS field.
	TC_SR2_LOVRS_Msk  = 0x2     // Bit mask of LOVRS field.
	TC_SR2_LOVRS      = 0x2     // Bit LOVRS.
	TC_SR2_CPAS_Pos   = 0x2     // Position of CPAS field.
	TC_SR2_CPAS_Msk   = 0x4     // Bit mask of CPAS field.
	TC_SR2_CPAS       = 0x4     // Bit CPAS.
	TC_SR2_CPBS_Pos   = 0x3     // Position of CPBS field.
	TC_SR2_CPBS_Msk   = 0x8     // Bit mask of CPBS field.
	TC_SR2_CPBS       = 0x8     // Bit CPBS.
	TC_SR2_CPCS_Pos   = 0x4     // Position of CPCS field.
	TC_SR2_CPCS_Msk   = 0x10    // Bit mask of CPCS field.
	TC_SR2_CPCS       = 0x10    // Bit CPCS.
	TC_SR2_LDRAS_Pos  = 0x5     // Position of LDRAS field.
	TC_SR2_LDRAS_Msk  = 0x20    // Bit mask of LDRAS field.
	TC_SR2_LDRAS      = 0x20    // Bit LDRAS.
	TC_SR2_LDRBS_Pos  = 0x6     // Position of LDRBS field.
	TC_SR2_LDRBS_Msk  = 0x40    // Bit mask of LDRBS field.
	TC_SR2_LDRBS      = 0x40    // Bit LDRBS.
	TC_SR2_ETRGS_Pos  = 0x7     // Position of ETRGS field.
	TC_SR2_ETRGS_Msk  = 0x80    // Bit mask of ETRGS field.
	TC_SR2_ETRGS      = 0x80    // Bit ETRGS.
	TC_SR2_CLKSTA_Pos = 0x10    // Position of CLKSTA field.
	TC_SR2_CLKSTA_Msk = 0x10000 // Bit mask of CLKSTA field.
	TC_SR2_CLKSTA     = 0x10000 // Bit CLKSTA.
	TC_SR2_MTIOA_Pos  = 0x11    // Position of MTIOA field.
	TC_SR2_MTIOA_Msk  = 0x20000 // Bit mask of MTIOA field.
	TC_SR2_MTIOA      = 0x20000 // Bit MTIOA.
	TC_SR2_MTIOB_Pos  = 0x12    // Position of MTIOB field.
	TC_SR2_MTIOB_Msk  = 0x40000 // Bit mask of MTIOB field.
	TC_SR2_MTIOB      = 0x40000 // Bit MTIOB.

	// IER2: Interrupt Enable Register (channel = 2)
	TC_IER2_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IER2_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IER2_COVFS     = 0x1  // Bit COVFS.
	TC_IER2_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IER2_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IER2_LOVRS     = 0x2  // Bit LOVRS.
	TC_IER2_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IER2_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IER2_CPAS      = 0x4  // Bit CPAS.
	TC_IER2_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IER2_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IER2_CPBS      = 0x8  // Bit CPBS.
	TC_IER2_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IER2_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IER2_CPCS      = 0x10 // Bit CPCS.
	TC_IER2_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IER2_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IER2_LDRAS     = 0x20 // Bit LDRAS.
	TC_IER2_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IER2_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IER2_LDRBS     = 0x40 // Bit LDRBS.
	TC_IER2_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IER2_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IER2_ETRGS     = 0x80 // Bit ETRGS.

	// IDR2: Interrupt Disable Register (channel = 2)
	TC_IDR2_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IDR2_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IDR2_COVFS     = 0x1  // Bit COVFS.
	TC_IDR2_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IDR2_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IDR2_LOVRS     = 0x2  // Bit LOVRS.
	TC_IDR2_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IDR2_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IDR2_CPAS      = 0x4  // Bit CPAS.
	TC_IDR2_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IDR2_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IDR2_CPBS      = 0x8  // Bit CPBS.
	TC_IDR2_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IDR2_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IDR2_CPCS      = 0x10 // Bit CPCS.
	TC_IDR2_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IDR2_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IDR2_LDRAS     = 0x20 // Bit LDRAS.
	TC_IDR2_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IDR2_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IDR2_LDRBS     = 0x40 // Bit LDRBS.
	TC_IDR2_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IDR2_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IDR2_ETRGS     = 0x80 // Bit ETRGS.

	// IMR2: Interrupt Mask Register (channel = 2)
	TC_IMR2_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IMR2_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IMR2_COVFS     = 0x1  // Bit COVFS.
	TC_IMR2_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IMR2_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IMR2_LOVRS     = 0x2  // Bit LOVRS.
	TC_IMR2_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IMR2_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IMR2_CPAS      = 0x4  // Bit CPAS.
	TC_IMR2_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IMR2_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IMR2_CPBS      = 0x8  // Bit CPBS.
	TC_IMR2_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IMR2_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IMR2_CPCS      = 0x10 // Bit CPCS.
	TC_IMR2_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IMR2_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IMR2_LDRAS     = 0x20 // Bit LDRAS.
	TC_IMR2_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IMR2_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IMR2_LDRBS     = 0x40 // Bit LDRBS.
	TC_IMR2_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IMR2_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IMR2_ETRGS     = 0x80 // Bit ETRGS.

	// BCR: Block Control Register
	TC_BCR_SYNC_Pos = 0x0 // Position of SYNC field.
	TC_BCR_SYNC_Msk = 0x1 // Bit mask of SYNC field.
	TC_BCR_SYNC     = 0x1 // Bit SYNC.

	// BMR: Block Mode Register
	TC_BMR_TC0XC0S_Pos   = 0x0  // Position of TC0XC0S field.
	TC_BMR_TC0XC0S_Msk   = 0x3  // Bit mask of TC0XC0S field.
	TC_BMR_TC0XC0S_TCLK0 = 0x0  // Signal connected to XC0: TCLK0
	TC_BMR_TC0XC0S_TIOA1 = 0x2  // Signal connected to XC0: TIOA1
	TC_BMR_TC0XC0S_TIOA2 = 0x3  // Signal connected to XC0: TIOA2
	TC_BMR_TC1XC1S_Pos   = 0x2  // Position of TC1XC1S field.
	TC_BMR_TC1XC1S_Msk   = 0xc  // Bit mask of TC1XC1S field.
	TC_BMR_TC1XC1S_TCLK1 = 0x0  // Signal connected to XC1: TCLK1
	TC_BMR_TC1XC1S_TIOA0 = 0x2  // Signal connected to XC1: TIOA0
	TC_BMR_TC1XC1S_TIOA2 = 0x3  // Signal connected to XC1: TIOA2
	TC_BMR_TC2XC2S_Pos   = 0x4  // Position of TC2XC2S field.
	TC_BMR_TC2XC2S_Msk   = 0x30 // Bit mask of TC2XC2S field.
	TC_BMR_TC2XC2S_TCLK2 = 0x0  // Signal connected to XC2: TCLK2
	TC_BMR_TC2XC2S_TIOA1 = 0x2  // Signal connected to XC2: TIOA1
	TC_BMR_TC2XC2S_TIOA2 = 0x3  // Signal connected to XC2: TIOA2
)

// Bitfields for TWI0: Two-wire Interface 0
const (
	// CR: Control Register
	TWI_CR_START_Pos = 0x0  // Position of START field.
	TWI_CR_START_Msk = 0x1  // Bit mask of START field.
	TWI_CR_START     = 0x1  // Bit START.
	TWI_CR_STOP_Pos  = 0x1  // Position of STOP field.
	TWI_CR_STOP_Msk  = 0x2  // Bit mask of STOP field.
	TWI_CR_STOP      = 0x2  // Bit STOP.
	TWI_CR_MSEN_Pos  = 0x2  // Position of MSEN field.
	TWI_CR_MSEN_Msk  = 0x4  // Bit mask of MSEN field.
	TWI_CR_MSEN      = 0x4  // Bit MSEN.
	TWI_CR_MSDIS_Pos = 0x3  // Position of MSDIS field.
	TWI_CR_MSDIS_Msk = 0x8  // Bit mask of MSDIS field.
	TWI_CR_MSDIS     = 0x8  // Bit MSDIS.
	TWI_CR_SVEN_Pos  = 0x4  // Position of SVEN field.
	TWI_CR_SVEN_Msk  = 0x10 // Bit mask of SVEN field.
	TWI_CR_SVEN      = 0x10 // Bit SVEN.
	TWI_CR_SVDIS_Pos = 0x5  // Position of SVDIS field.
	TWI_CR_SVDIS_Msk = 0x20 // Bit mask of SVDIS field.
	TWI_CR_SVDIS     = 0x20 // Bit SVDIS.
	TWI_CR_QUICK_Pos = 0x6  // Position of QUICK field.
	TWI_CR_QUICK_Msk = 0x40 // Bit mask of QUICK field.
	TWI_CR_QUICK     = 0x40 // Bit QUICK.
	TWI_CR_SWRST_Pos = 0x7  // Position of SWRST field.
	TWI_CR_SWRST_Msk = 0x80 // Bit mask of SWRST field.
	TWI_CR_SWRST     = 0x80 // Bit SWRST.

	// MMR: Master Mode Register
	TWI_MMR_IADRSZ_Pos    = 0x8      // Position of IADRSZ field.
	TWI_MMR_IADRSZ_Msk    = 0x300    // Bit mask of IADRSZ field.
	TWI_MMR_IADRSZ_NONE   = 0x0      // No internal device address
	TWI_MMR_IADRSZ_1_BYTE = 0x1      // One-byte internal device address
	TWI_MMR_IADRSZ_2_BYTE = 0x2      // Two-byte internal device address
	TWI_MMR_IADRSZ_3_BYTE = 0x3      // Three-byte internal device address
	TWI_MMR_MREAD_Pos     = 0xc      // Position of MREAD field.
	TWI_MMR_MREAD_Msk     = 0x1000   // Bit mask of MREAD field.
	TWI_MMR_MREAD         = 0x1000   // Bit MREAD.
	TWI_MMR_DADR_Pos      = 0x10     // Position of DADR field.
	TWI_MMR_DADR_Msk      = 0x7f0000 // Bit mask of DADR field.

	// SMR: Slave Mode Register
	TWI_SMR_SADR_Pos = 0x10     // Position of SADR field.
	TWI_SMR_SADR_Msk = 0x7f0000 // Bit mask of SADR field.

	// IADR: Internal Address Register
	TWI_IADR_IADR_Pos = 0x0      // Position of IADR field.
	TWI_IADR_IADR_Msk = 0xffffff // Bit mask of IADR field.

	// CWGR: Clock Waveform Generator Register
	TWI_CWGR_CLDIV_Pos = 0x0     // Position of CLDIV field.
	TWI_CWGR_CLDIV_Msk = 0xff    // Bit mask of CLDIV field.
	TWI_CWGR_CHDIV_Pos = 0x8     // Position of CHDIV field.
	TWI_CWGR_CHDIV_Msk = 0xff00  // Bit mask of CHDIV field.
	TWI_CWGR_CKDIV_Pos = 0x10    // Position of CKDIV field.
	TWI_CWGR_CKDIV_Msk = 0x70000 // Bit mask of CKDIV field.

	// SR: Status Register
	TWI_SR_TXCOMP_Pos = 0x0   // Position of TXCOMP field.
	TWI_SR_TXCOMP_Msk = 0x1   // Bit mask of TXCOMP field.
	TWI_SR_TXCOMP     = 0x1   // Bit TXCOMP.
	TWI_SR_RXRDY_Pos  = 0x1   // Position of RXRDY field.
	TWI_SR_RXRDY_Msk  = 0x2   // Bit mask of RXRDY field.
	TWI_SR_RXRDY      = 0x2   // Bit RXRDY.
	TWI_SR_TXRDY_Pos  = 0x2   // Position of TXRDY field.
	TWI_SR_TXRDY_Msk  = 0x4   // Bit mask of TXRDY field.
	TWI_SR_TXRDY      = 0x4   // Bit TXRDY.
	TWI_SR_SVREAD_Pos = 0x3   // Position of SVREAD field.
	TWI_SR_SVREAD_Msk = 0x8   // Bit mask of SVREAD field.
	TWI_SR_SVREAD     = 0x8   // Bit SVREAD.
	TWI_SR_SVACC_Pos  = 0x4   // Position of SVACC field.
	TWI_SR_SVACC_Msk  = 0x10  // Bit mask of SVACC field.
	TWI_SR_SVACC      = 0x10  // Bit SVACC.
	TWI_SR_GACC_Pos   = 0x5   // Position of GACC field.
	TWI_SR_GACC_Msk   = 0x20  // Bit mask of GACC field.
	TWI_SR_GACC       = 0x20  // Bit GACC.
	TWI_SR_OVRE_Pos   = 0x6   // Position of OVRE field.
	TWI_SR_OVRE_Msk   = 0x40  // Bit mask of OVRE field.
	TWI_SR_OVRE       = 0x40  // Bit OVRE.
	TWI_SR_NACK_Pos   = 0x8   // Position of NACK field.
	TWI_SR_NACK_Msk   = 0x100 // Bit mask of NACK field.
	TWI_SR_NACK       = 0x100 // Bit NACK.
	TWI_SR_ARBLST_Pos = 0x9   // Position of ARBLST field.
	TWI_SR_ARBLST_Msk = 0x200 // Bit mask of ARBLST field.
	TWI_SR_ARBLST     = 0x200 // Bit ARBLST.
	TWI_SR_SCLWS_Pos  = 0xa   // Position of SCLWS field.
	TWI_SR_SCLWS_Msk  = 0x400 // Bit mask of SCLWS field.
	TWI_SR_SCLWS      = 0x400 // Bit SCLWS.
	TWI_SR_EOSACC_Pos = 0xb   // Position of EOSACC field.
	TWI_SR_EOSACC_Msk = 0x800 // Bit mask of EOSACC field.
	TWI_SR_EOSACC     = 0x800 // Bit EOSACC.

	// IER: Interrupt Enable Register
	TWI_IER_TXCOMP_Pos = 0x0   // Position of TXCOMP field.
	TWI_IER_TXCOMP_Msk = 0x1   // Bit mask of TXCOMP field.
	TWI_IER_TXCOMP     = 0x1   // Bit TXCOMP.
	TWI_IER_RXRDY_Pos  = 0x1   // Position of RXRDY field.
	TWI_IER_RXRDY_Msk  = 0x2   // Bit mask of RXRDY field.
	TWI_IER_RXRDY      = 0x2   // Bit RXRDY.
	TWI_IER_TXRDY_Pos  = 0x2   // Position of TXRDY field.
	TWI_IER_TXRDY_Msk  = 0x4   // Bit mask of TXRDY field.
	TWI_IER_TXRDY      = 0x4   // Bit TXRDY.
	TWI_IER_SVACC_Pos  = 0x4   // Position of SVACC field.
	TWI_IER_SVACC_Msk  = 0x10  // Bit mask of SVACC field.
	TWI_IER_SVACC      = 0x10  // Bit SVACC.
	TWI_IER_GACC_Pos   = 0x5   // Position of GACC field.
	TWI_IER_GACC_Msk   = 0x20  // Bit mask of GACC field.
	TWI_IER_GACC       = 0x20  // Bit GACC.
	TWI_IER_OVRE_Pos   = 0x6   // Position of OVRE field.
	TWI_IER_OVRE_Msk   = 0x40  // Bit mask of OVRE field.
	TWI_IER_OVRE       = 0x40  // Bit OVRE.
	TWI_IER_NACK_Pos   = 0x8   // Position of NACK field.
	TWI_IER_NACK_Msk   = 0x100 // Bit mask of NACK field.
	TWI_IER_NACK       = 0x100 // Bit NACK.
	TWI_IER_ARBLST_Pos = 0x9   // Position of ARBLST field.
	TWI_IER_ARBLST_Msk = 0x200 // Bit mask of ARBLST field.
	TWI_IER_ARBLST     = 0x200 // Bit ARBLST.
	TWI_IER_SCL_WS_Pos = 0xa   // Position of SCL_WS field.
	TWI_IER_SCL_WS_Msk = 0x400 // Bit mask of SCL_WS field.
	TWI_IER_SCL_WS     = 0x400 // Bit SCL_WS.
	TWI_IER_EOSACC_Pos = 0xb   // Position of EOSACC field.
	TWI_IER_EOSACC_Msk = 0x800 // Bit mask of EOSACC field.
	TWI_IER_EOSACC     = 0x800 // Bit EOSACC.

	// IDR: Interrupt Disable Register
	TWI_IDR_TXCOMP_Pos = 0x0   // Position of TXCOMP field.
	TWI_IDR_TXCOMP_Msk = 0x1   // Bit mask of TXCOMP field.
	TWI_IDR_TXCOMP     = 0x1   // Bit TXCOMP.
	TWI_IDR_RXRDY_Pos  = 0x1   // Position of RXRDY field.
	TWI_IDR_RXRDY_Msk  = 0x2   // Bit mask of RXRDY field.
	TWI_IDR_RXRDY      = 0x2   // Bit RXRDY.
	TWI_IDR_TXRDY_Pos  = 0x2   // Position of TXRDY field.
	TWI_IDR_TXRDY_Msk  = 0x4   // Bit mask of TXRDY field.
	TWI_IDR_TXRDY      = 0x4   // Bit TXRDY.
	TWI_IDR_SVACC_Pos  = 0x4   // Position of SVACC field.
	TWI_IDR_SVACC_Msk  = 0x10  // Bit mask of SVACC field.
	TWI_IDR_SVACC      = 0x10  // Bit SVACC.
	TWI_IDR_GACC_Pos   = 0x5   // Position of GACC field.
	TWI_IDR_GACC_Msk   = 0x20  // Bit mask of GACC field.
	TWI_IDR_GACC       = 0x20  // Bit GACC.
	TWI_IDR_OVRE_Pos   = 0x6   // Position of OVRE field.
	TWI_IDR_OVRE_Msk   = 0x40  // Bit mask of OVRE field.
	TWI_IDR_OVRE       = 0x40  // Bit OVRE.
	TWI_IDR_NACK_Pos   = 0x8   // Position of NACK field.
	TWI_IDR_NACK_Msk   = 0x100 // Bit mask of NACK field.
	TWI_IDR_NACK       = 0x100 // Bit NACK.
	TWI_IDR_ARBLST_Pos = 0x9   // Position of ARBLST field.
	TWI_IDR_ARBLST_Msk = 0x200 // Bit mask of ARBLST field.
	TWI_IDR_ARBLST     = 0x200 // Bit ARBLST.
	TWI_IDR_SCL_WS_Pos = 0xa   // Position of SCL_WS field.
	TWI_IDR_SCL_WS_Msk = 0x400 // Bit mask of SCL_WS field.
	TWI_IDR_SCL_WS     = 0x400 // Bit SCL_WS.
	TWI_IDR_EOSACC_Pos = 0xb   // Position of EOSACC field.
	TWI_IDR_EOSACC_Msk = 0x800 // Bit mask of EOSACC field.
	TWI_IDR_EOSACC     = 0x800 // Bit EOSACC.

	// IMR: Interrupt Mask Register
	TWI_IMR_TXCOMP_Pos = 0x0   // Position of TXCOMP field.
	TWI_IMR_TXCOMP_Msk = 0x1   // Bit mask of TXCOMP field.
	TWI_IMR_TXCOMP     = 0x1   // Bit TXCOMP.
	TWI_IMR_RXRDY_Pos  = 0x1   // Position of RXRDY field.
	TWI_IMR_RXRDY_Msk  = 0x2   // Bit mask of RXRDY field.
	TWI_IMR_RXRDY      = 0x2   // Bit RXRDY.
	TWI_IMR_TXRDY_Pos  = 0x2   // Position of TXRDY field.
	TWI_IMR_TXRDY_Msk  = 0x4   // Bit mask of TXRDY field.
	TWI_IMR_TXRDY      = 0x4   // Bit TXRDY.
	TWI_IMR_SVACC_Pos  = 0x4   // Position of SVACC field.
	TWI_IMR_SVACC_Msk  = 0x10  // Bit mask of SVACC field.
	TWI_IMR_SVACC      = 0x10  // Bit SVACC.
	TWI_IMR_GACC_Pos   = 0x5   // Position of GACC field.
	TWI_IMR_GACC_Msk   = 0x20  // Bit mask of GACC field.
	TWI_IMR_GACC       = 0x20  // Bit GACC.
	TWI_IMR_OVRE_Pos   = 0x6   // Position of OVRE field.
	TWI_IMR_OVRE_Msk   = 0x40  // Bit mask of OVRE field.
	TWI_IMR_OVRE       = 0x40  // Bit OVRE.
	TWI_IMR_NACK_Pos   = 0x8   // Position of NACK field.
	TWI_IMR_NACK_Msk   = 0x100 // Bit mask of NACK field.
	TWI_IMR_NACK       = 0x100 // Bit NACK.
	TWI_IMR_ARBLST_Pos = 0x9   // Position of ARBLST field.
	TWI_IMR_ARBLST_Msk = 0x200 // Bit mask of ARBLST field.
	TWI_IMR_ARBLST     = 0x200 // Bit ARBLST.
	TWI_IMR_SCL_WS_Pos = 0xa   // Position of SCL_WS field.
	TWI_IMR_SCL_WS_Msk = 0x400 // Bit mask of SCL_WS field.
	TWI_IMR_SCL_WS     = 0x400 // Bit SCL_WS.
	TWI_IMR_EOSACC_Pos = 0xb   // Position of EOSACC field.
	TWI_IMR_EOSACC_Msk = 0x800 // Bit mask of EOSACC field.
	TWI_IMR_EOSACC     = 0x800 // Bit EOSACC.

	// RHR: Receive Holding Register
	TWI_RHR_RXDATA_Pos = 0x0  // Position of RXDATA field.
	TWI_RHR_RXDATA_Msk = 0xff // Bit mask of RXDATA field.

	// THR: Transmit Holding Register
	TWI_THR_TXDATA_Pos = 0x0  // Position of TXDATA field.
	TWI_THR_TXDATA_Msk = 0xff // Bit mask of TXDATA field.

	// WPROT_MODE: Protection Mode Register
	TWI_WPROT_MODE_WPROT_Pos         = 0x0        // Position of WPROT field.
	TWI_WPROT_MODE_WPROT_Msk         = 0x1        // Bit mask of WPROT field.
	TWI_WPROT_MODE_WPROT             = 0x1        // Bit WPROT.
	TWI_WPROT_MODE_SECURITY_CODE_Pos = 0x8        // Position of SECURITY_CODE field.
	TWI_WPROT_MODE_SECURITY_CODE_Msk = 0xffffff00 // Bit mask of SECURITY_CODE field.

	// WPROT_STATUS: Protection Status Register
	TWI_WPROT_STATUS_WPROTERR_Pos  = 0x0        // Position of WPROTERR field.
	TWI_WPROT_STATUS_WPROTERR_Msk  = 0x1        // Bit mask of WPROTERR field.
	TWI_WPROT_STATUS_WPROTERR      = 0x1        // Bit WPROTERR.
	TWI_WPROT_STATUS_WPROTADDR_Pos = 0x8        // Position of WPROTADDR field.
	TWI_WPROT_STATUS_WPROTADDR_Msk = 0xffffff00 // Bit mask of WPROTADDR field.
)

// Bitfields for USART0: Universal Synchronous Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	USART_CR_RSTRX_Pos   = 0x2      // Position of RSTRX field.
	USART_CR_RSTRX_Msk   = 0x4      // Bit mask of RSTRX field.
	USART_CR_RSTRX       = 0x4      // Bit RSTRX.
	USART_CR_RSTTX_Pos   = 0x3      // Position of RSTTX field.
	USART_CR_RSTTX_Msk   = 0x8      // Bit mask of RSTTX field.
	USART_CR_RSTTX       = 0x8      // Bit RSTTX.
	USART_CR_RXEN_Pos    = 0x4      // Position of RXEN field.
	USART_CR_RXEN_Msk    = 0x10     // Bit mask of RXEN field.
	USART_CR_RXEN        = 0x10     // Bit RXEN.
	USART_CR_RXDIS_Pos   = 0x5      // Position of RXDIS field.
	USART_CR_RXDIS_Msk   = 0x20     // Bit mask of RXDIS field.
	USART_CR_RXDIS       = 0x20     // Bit RXDIS.
	USART_CR_TXEN_Pos    = 0x6      // Position of TXEN field.
	USART_CR_TXEN_Msk    = 0x40     // Bit mask of TXEN field.
	USART_CR_TXEN        = 0x40     // Bit TXEN.
	USART_CR_TXDIS_Pos   = 0x7      // Position of TXDIS field.
	USART_CR_TXDIS_Msk   = 0x80     // Bit mask of TXDIS field.
	USART_CR_TXDIS       = 0x80     // Bit TXDIS.
	USART_CR_RSTSTA_Pos  = 0x8      // Position of RSTSTA field.
	USART_CR_RSTSTA_Msk  = 0x100    // Bit mask of RSTSTA field.
	USART_CR_RSTSTA      = 0x100    // Bit RSTSTA.
	USART_CR_STTBRK_Pos  = 0x9      // Position of STTBRK field.
	USART_CR_STTBRK_Msk  = 0x200    // Bit mask of STTBRK field.
	USART_CR_STTBRK      = 0x200    // Bit STTBRK.
	USART_CR_STPBRK_Pos  = 0xa      // Position of STPBRK field.
	USART_CR_STPBRK_Msk  = 0x400    // Bit mask of STPBRK field.
	USART_CR_STPBRK      = 0x400    // Bit STPBRK.
	USART_CR_STTTO_Pos   = 0xb      // Position of STTTO field.
	USART_CR_STTTO_Msk   = 0x800    // Bit mask of STTTO field.
	USART_CR_STTTO       = 0x800    // Bit STTTO.
	USART_CR_SENDA_Pos   = 0xc      // Position of SENDA field.
	USART_CR_SENDA_Msk   = 0x1000   // Bit mask of SENDA field.
	USART_CR_SENDA       = 0x1000   // Bit SENDA.
	USART_CR_RSTIT_Pos   = 0xd      // Position of RSTIT field.
	USART_CR_RSTIT_Msk   = 0x2000   // Bit mask of RSTIT field.
	USART_CR_RSTIT       = 0x2000   // Bit RSTIT.
	USART_CR_RSTNACK_Pos = 0xe      // Position of RSTNACK field.
	USART_CR_RSTNACK_Msk = 0x4000   // Bit mask of RSTNACK field.
	USART_CR_RSTNACK     = 0x4000   // Bit RSTNACK.
	USART_CR_RETTO_Pos   = 0xf      // Position of RETTO field.
	USART_CR_RETTO_Msk   = 0x8000   // Bit mask of RETTO field.
	USART_CR_RETTO       = 0x8000   // Bit RETTO.
	USART_CR_RTSEN_Pos   = 0x12     // Position of RTSEN field.
	USART_CR_RTSEN_Msk   = 0x40000  // Bit mask of RTSEN field.
	USART_CR_RTSEN       = 0x40000  // Bit RTSEN.
	USART_CR_RTSDIS_Pos  = 0x13     // Position of RTSDIS field.
	USART_CR_RTSDIS_Msk  = 0x80000  // Bit mask of RTSDIS field.
	USART_CR_RTSDIS      = 0x80000  // Bit RTSDIS.
	USART_CR_LINABT_Pos  = 0x14     // Position of LINABT field.
	USART_CR_LINABT_Msk  = 0x100000 // Bit mask of LINABT field.
	USART_CR_LINABT      = 0x100000 // Bit LINABT.
	USART_CR_LINWKUP_Pos = 0x15     // Position of LINWKUP field.
	USART_CR_LINWKUP_Msk = 0x200000 // Bit mask of LINWKUP field.
	USART_CR_LINWKUP     = 0x200000 // Bit LINWKUP.

	// CR_SPI_MODE: Control Register
	USART_CR_SPI_MODE_RSTRX_Pos  = 0x2     // Position of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Msk  = 0x4     // Bit mask of RSTRX field.
	USART_CR_SPI_MODE_RSTRX      = 0x4     // Bit RSTRX.
	USART_CR_SPI_MODE_RSTTX_Pos  = 0x3     // Position of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Msk  = 0x8     // Bit mask of RSTTX field.
	USART_CR_SPI_MODE_RSTTX      = 0x8     // Bit RSTTX.
	USART_CR_SPI_MODE_RXEN_Pos   = 0x4     // Position of RXEN field.
	USART_CR_SPI_MODE_RXEN_Msk   = 0x10    // Bit mask of RXEN field.
	USART_CR_SPI_MODE_RXEN       = 0x10    // Bit RXEN.
	USART_CR_SPI_MODE_RXDIS_Pos  = 0x5     // Position of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Msk  = 0x20    // Bit mask of RXDIS field.
	USART_CR_SPI_MODE_RXDIS      = 0x20    // Bit RXDIS.
	USART_CR_SPI_MODE_TXEN_Pos   = 0x6     // Position of TXEN field.
	USART_CR_SPI_MODE_TXEN_Msk   = 0x40    // Bit mask of TXEN field.
	USART_CR_SPI_MODE_TXEN       = 0x40    // Bit TXEN.
	USART_CR_SPI_MODE_TXDIS_Pos  = 0x7     // Position of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Msk  = 0x80    // Bit mask of TXDIS field.
	USART_CR_SPI_MODE_TXDIS      = 0x80    // Bit TXDIS.
	USART_CR_SPI_MODE_RSTSTA_Pos = 0x8     // Position of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Msk = 0x100   // Bit mask of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA     = 0x100   // Bit RSTSTA.
	USART_CR_SPI_MODE_FCS_Pos    = 0x12    // Position of FCS field.
	USART_CR_SPI_MODE_FCS_Msk    = 0x40000 // Bit mask of FCS field.
	USART_CR_SPI_MODE_FCS        = 0x40000 // Bit FCS.
	USART_CR_SPI_MODE_RCS_Pos    = 0x13    // Position of RCS field.
	USART_CR_SPI_MODE_RCS_Msk    = 0x80000 // Bit mask of RCS field.
	USART_CR_SPI_MODE_RCS        = 0x80000 // Bit RCS.

	// MR: Mode Register
	USART_MR_USART_MODE_Pos            = 0x0        // Position of USART_MODE field.
	USART_MR_USART_MODE_Msk            = 0xf        // Bit mask of USART_MODE field.
	USART_MR_USART_MODE_NORMAL         = 0x0        // Normal mode
	USART_MR_USART_MODE_RS485          = 0x1        // RS485
	USART_MR_USART_MODE_HW_HANDSHAKING = 0x2        // Hardware Handshaking
	USART_MR_USART_MODE_IS07816_T_0    = 0x4        // IS07816 Protocol: T = 0
	USART_MR_USART_MODE_IS07816_T_1    = 0x6        // IS07816 Protocol: T = 1
	USART_MR_USART_MODE_IRDA           = 0x8        // IrDA
	USART_MR_USART_MODE_LIN_MASTER     = 0xa        // LIN Master
	USART_MR_USART_MODE_LIN_SLAVE      = 0xb        // LIN Slave
	USART_MR_USART_MODE_SPI_MASTER     = 0xe        // SPI Master
	USART_MR_USART_MODE_SPI_SLAVE      = 0xf        // SPI Slave
	USART_MR_USCLKS_Pos                = 0x4        // Position of USCLKS field.
	USART_MR_USCLKS_Msk                = 0x30       // Bit mask of USCLKS field.
	USART_MR_USCLKS_MCK                = 0x0        // Master Clock MCK is selected
	USART_MR_USCLKS_DIV                = 0x1        // Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_USCLKS_SCK                = 0x3        // Serial Clock SLK is selected
	USART_MR_CHRL_Pos                  = 0x6        // Position of CHRL field.
	USART_MR_CHRL_Msk                  = 0xc0       // Bit mask of CHRL field.
	USART_MR_CHRL_5_BIT                = 0x0        // Character length is 5 bits
	USART_MR_CHRL_6_BIT                = 0x1        // Character length is 6 bits
	USART_MR_CHRL_7_BIT                = 0x2        // Character length is 7 bits
	USART_MR_CHRL_8_BIT                = 0x3        // Character length is 8 bits
	USART_MR_SYNC_Pos                  = 0x8        // Position of SYNC field.
	USART_MR_SYNC_Msk                  = 0x100      // Bit mask of SYNC field.
	USART_MR_SYNC                      = 0x100      // Bit SYNC.
	USART_MR_PAR_Pos                   = 0x9        // Position of PAR field.
	USART_MR_PAR_Msk                   = 0xe00      // Bit mask of PAR field.
	USART_MR_PAR_EVEN                  = 0x0        // Even parity
	USART_MR_PAR_ODD                   = 0x1        // Odd parity
	USART_MR_PAR_SPACE                 = 0x2        // Parity forced to 0 (Space)
	USART_MR_PAR_MARK                  = 0x3        // Parity forced to 1 (Mark)
	USART_MR_PAR_NO                    = 0x4        // No parity
	USART_MR_PAR_MULTIDROP             = 0x6        // Multidrop mode
	USART_MR_NBSTOP_Pos                = 0xc        // Position of NBSTOP field.
	USART_MR_NBSTOP_Msk                = 0x3000     // Bit mask of NBSTOP field.
	USART_MR_NBSTOP_1_BIT              = 0x0        // 1 stop bit
	USART_MR_NBSTOP_1_5_BIT            = 0x1        // 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
	USART_MR_NBSTOP_2_BIT              = 0x2        // 2 stop bits
	USART_MR_CHMODE_Pos                = 0xe        // Position of CHMODE field.
	USART_MR_CHMODE_Msk                = 0xc000     // Bit mask of CHMODE field.
	USART_MR_CHMODE_NORMAL             = 0x0        // Normal Mode
	USART_MR_CHMODE_AUTOMATIC          = 0x1        // Automatic Echo. Receiver input is connected to the TXD pin.
	USART_MR_CHMODE_LOCAL_LOOPBACK     = 0x2        // Local Loopback. Transmitter output is connected to the Receiver Input.
	USART_MR_CHMODE_REMOTE_LOOPBACK    = 0x3        // Remote Loopback. RXD pin is internally connected to the TXD pin.
	USART_MR_MSBF_Pos                  = 0x10       // Position of MSBF field.
	USART_MR_MSBF_Msk                  = 0x10000    // Bit mask of MSBF field.
	USART_MR_MSBF                      = 0x10000    // Bit MSBF.
	USART_MR_MODE9_Pos                 = 0x11       // Position of MODE9 field.
	USART_MR_MODE9_Msk                 = 0x20000    // Bit mask of MODE9 field.
	USART_MR_MODE9                     = 0x20000    // Bit MODE9.
	USART_MR_CLKO_Pos                  = 0x12       // Position of CLKO field.
	USART_MR_CLKO_Msk                  = 0x40000    // Bit mask of CLKO field.
	USART_MR_CLKO                      = 0x40000    // Bit CLKO.
	USART_MR_OVER_Pos                  = 0x13       // Position of OVER field.
	USART_MR_OVER_Msk                  = 0x80000    // Bit mask of OVER field.
	USART_MR_OVER                      = 0x80000    // Bit OVER.
	USART_MR_INACK_Pos                 = 0x14       // Position of INACK field.
	USART_MR_INACK_Msk                 = 0x100000   // Bit mask of INACK field.
	USART_MR_INACK                     = 0x100000   // Bit INACK.
	USART_MR_DSNACK_Pos                = 0x15       // Position of DSNACK field.
	USART_MR_DSNACK_Msk                = 0x200000   // Bit mask of DSNACK field.
	USART_MR_DSNACK                    = 0x200000   // Bit DSNACK.
	USART_MR_VAR_SYNC_Pos              = 0x16       // Position of VAR_SYNC field.
	USART_MR_VAR_SYNC_Msk              = 0x400000   // Bit mask of VAR_SYNC field.
	USART_MR_VAR_SYNC                  = 0x400000   // Bit VAR_SYNC.
	USART_MR_MAX_ITERATION_Pos         = 0x18       // Position of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Msk         = 0x7000000  // Bit mask of MAX_ITERATION field.
	USART_MR_FILTER_Pos                = 0x1c       // Position of FILTER field.
	USART_MR_FILTER_Msk                = 0x10000000 // Bit mask of FILTER field.
	USART_MR_FILTER                    = 0x10000000 // Bit FILTER.
	USART_MR_MAN_Pos                   = 0x1d       // Position of MAN field.
	USART_MR_MAN_Msk                   = 0x20000000 // Bit mask of MAN field.
	USART_MR_MAN                       = 0x20000000 // Bit MAN.
	USART_MR_MODSYNC_Pos               = 0x1e       // Position of MODSYNC field.
	USART_MR_MODSYNC_Msk               = 0x40000000 // Bit mask of MODSYNC field.
	USART_MR_MODSYNC                   = 0x40000000 // Bit MODSYNC.
	USART_MR_ONEBIT_Pos                = 0x1f       // Position of ONEBIT field.
	USART_MR_ONEBIT_Msk                = 0x80000000 // Bit mask of ONEBIT field.
	USART_MR_ONEBIT                    = 0x80000000 // Bit ONEBIT.

	// MR_SPI_MODE: Mode Register
	USART_MR_SPI_MODE_USART_MODE_Pos        = 0x0      // Position of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Msk        = 0xf      // Bit mask of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_SPI_MASTER = 0xe      // SPI Master
	USART_MR_SPI_MODE_USART_MODE_SPI_SLAVE  = 0xf      // SPI Slave
	USART_MR_SPI_MODE_USCLKS_Pos            = 0x4      // Position of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Msk            = 0x30     // Bit mask of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_MCK            = 0x0      // Master Clock MCK is selected
	USART_MR_SPI_MODE_USCLKS_DIV            = 0x1      // Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_SPI_MODE_USCLKS_SCK            = 0x3      // Serial Clock SLK is selected
	USART_MR_SPI_MODE_CHRL_Pos              = 0x6      // Position of CHRL field.
	USART_MR_SPI_MODE_CHRL_Msk              = 0xc0     // Bit mask of CHRL field.
	USART_MR_SPI_MODE_CHRL_8_BIT            = 0x3      // Character length is 8 bits
	USART_MR_SPI_MODE_CPHA_Pos              = 0x8      // Position of CPHA field.
	USART_MR_SPI_MODE_CPHA_Msk              = 0x100    // Bit mask of CPHA field.
	USART_MR_SPI_MODE_CPHA                  = 0x100    // Bit CPHA.
	USART_MR_SPI_MODE_CPOL_Pos              = 0x10     // Position of CPOL field.
	USART_MR_SPI_MODE_CPOL_Msk              = 0x10000  // Bit mask of CPOL field.
	USART_MR_SPI_MODE_CPOL                  = 0x10000  // Bit CPOL.
	USART_MR_SPI_MODE_WRDBT_Pos             = 0x14     // Position of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Msk             = 0x100000 // Bit mask of WRDBT field.
	USART_MR_SPI_MODE_WRDBT                 = 0x100000 // Bit WRDBT.

	// IER: Interrupt Enable Register
	USART_IER_RXRDY_Pos   = 0x0       // Position of RXRDY field.
	USART_IER_RXRDY_Msk   = 0x1       // Bit mask of RXRDY field.
	USART_IER_RXRDY       = 0x1       // Bit RXRDY.
	USART_IER_TXRDY_Pos   = 0x1       // Position of TXRDY field.
	USART_IER_TXRDY_Msk   = 0x2       // Bit mask of TXRDY field.
	USART_IER_TXRDY       = 0x2       // Bit TXRDY.
	USART_IER_RXBRK_Pos   = 0x2       // Position of RXBRK field.
	USART_IER_RXBRK_Msk   = 0x4       // Bit mask of RXBRK field.
	USART_IER_RXBRK       = 0x4       // Bit RXBRK.
	USART_IER_OVRE_Pos    = 0x5       // Position of OVRE field.
	USART_IER_OVRE_Msk    = 0x20      // Bit mask of OVRE field.
	USART_IER_OVRE        = 0x20      // Bit OVRE.
	USART_IER_FRAME_Pos   = 0x6       // Position of FRAME field.
	USART_IER_FRAME_Msk   = 0x40      // Bit mask of FRAME field.
	USART_IER_FRAME       = 0x40      // Bit FRAME.
	USART_IER_PARE_Pos    = 0x7       // Position of PARE field.
	USART_IER_PARE_Msk    = 0x80      // Bit mask of PARE field.
	USART_IER_PARE        = 0x80      // Bit PARE.
	USART_IER_TIMEOUT_Pos = 0x8       // Position of TIMEOUT field.
	USART_IER_TIMEOUT_Msk = 0x100     // Bit mask of TIMEOUT field.
	USART_IER_TIMEOUT     = 0x100     // Bit TIMEOUT.
	USART_IER_TXEMPTY_Pos = 0x9       // Position of TXEMPTY field.
	USART_IER_TXEMPTY_Msk = 0x200     // Bit mask of TXEMPTY field.
	USART_IER_TXEMPTY     = 0x200     // Bit TXEMPTY.
	USART_IER_ITER_Pos    = 0xa       // Position of ITER field.
	USART_IER_ITER_Msk    = 0x400     // Bit mask of ITER field.
	USART_IER_ITER        = 0x400     // Bit ITER.
	USART_IER_NACK_Pos    = 0xd       // Position of NACK field.
	USART_IER_NACK_Msk    = 0x2000    // Bit mask of NACK field.
	USART_IER_NACK        = 0x2000    // Bit NACK.
	USART_IER_CTSIC_Pos   = 0x13      // Position of CTSIC field.
	USART_IER_CTSIC_Msk   = 0x80000   // Bit mask of CTSIC field.
	USART_IER_CTSIC       = 0x80000   // Bit CTSIC.
	USART_IER_MANE_Pos    = 0x18      // Position of MANE field.
	USART_IER_MANE_Msk    = 0x1000000 // Bit mask of MANE field.
	USART_IER_MANE        = 0x1000000 // Bit MANE.

	// IER_SPI_MODE: Interrupt Enable Register
	USART_IER_SPI_MODE_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	USART_IER_SPI_MODE_RXRDY       = 0x1   // Bit RXRDY.
	USART_IER_SPI_MODE_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	USART_IER_SPI_MODE_TXRDY       = 0x2   // Bit TXRDY.
	USART_IER_SPI_MODE_OVRE_Pos    = 0x5   // Position of OVRE field.
	USART_IER_SPI_MODE_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	USART_IER_SPI_MODE_OVRE        = 0x20  // Bit OVRE.
	USART_IER_SPI_MODE_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY     = 0x200 // Bit TXEMPTY.
	USART_IER_SPI_MODE_UNRE_Pos    = 0xa   // Position of UNRE field.
	USART_IER_SPI_MODE_UNRE_Msk    = 0x400 // Bit mask of UNRE field.
	USART_IER_SPI_MODE_UNRE        = 0x400 // Bit UNRE.

	// IER_LIN_MODE: Interrupt Enable Register
	USART_IER_LIN_MODE_RXRDY_Pos   = 0x0        // Position of RXRDY field.
	USART_IER_LIN_MODE_RXRDY_Msk   = 0x1        // Bit mask of RXRDY field.
	USART_IER_LIN_MODE_RXRDY       = 0x1        // Bit RXRDY.
	USART_IER_LIN_MODE_TXRDY_Pos   = 0x1        // Position of TXRDY field.
	USART_IER_LIN_MODE_TXRDY_Msk   = 0x2        // Bit mask of TXRDY field.
	USART_IER_LIN_MODE_TXRDY       = 0x2        // Bit TXRDY.
	USART_IER_LIN_MODE_OVRE_Pos    = 0x5        // Position of OVRE field.
	USART_IER_LIN_MODE_OVRE_Msk    = 0x20       // Bit mask of OVRE field.
	USART_IER_LIN_MODE_OVRE        = 0x20       // Bit OVRE.
	USART_IER_LIN_MODE_FRAME_Pos   = 0x6        // Position of FRAME field.
	USART_IER_LIN_MODE_FRAME_Msk   = 0x40       // Bit mask of FRAME field.
	USART_IER_LIN_MODE_FRAME       = 0x40       // Bit FRAME.
	USART_IER_LIN_MODE_PARE_Pos    = 0x7        // Position of PARE field.
	USART_IER_LIN_MODE_PARE_Msk    = 0x80       // Bit mask of PARE field.
	USART_IER_LIN_MODE_PARE        = 0x80       // Bit PARE.
	USART_IER_LIN_MODE_TIMEOUT_Pos = 0x8        // Position of TIMEOUT field.
	USART_IER_LIN_MODE_TIMEOUT_Msk = 0x100      // Bit mask of TIMEOUT field.
	USART_IER_LIN_MODE_TIMEOUT     = 0x100      // Bit TIMEOUT.
	USART_IER_LIN_MODE_TXEMPTY_Pos = 0x9        // Position of TXEMPTY field.
	USART_IER_LIN_MODE_TXEMPTY_Msk = 0x200      // Bit mask of TXEMPTY field.
	USART_IER_LIN_MODE_TXEMPTY     = 0x200      // Bit TXEMPTY.
	USART_IER_LIN_MODE_LINBK_Pos   = 0xd        // Position of LINBK field.
	USART_IER_LIN_MODE_LINBK_Msk   = 0x2000     // Bit mask of LINBK field.
	USART_IER_LIN_MODE_LINBK       = 0x2000     // Bit LINBK.
	USART_IER_LIN_MODE_LINID_Pos   = 0xe        // Position of LINID field.
	USART_IER_LIN_MODE_LINID_Msk   = 0x4000     // Bit mask of LINID field.
	USART_IER_LIN_MODE_LINID       = 0x4000     // Bit LINID.
	USART_IER_LIN_MODE_LINTC_Pos   = 0xf        // Position of LINTC field.
	USART_IER_LIN_MODE_LINTC_Msk   = 0x8000     // Bit mask of LINTC field.
	USART_IER_LIN_MODE_LINTC       = 0x8000     // Bit LINTC.
	USART_IER_LIN_MODE_LINBE_Pos   = 0x19       // Position of LINBE field.
	USART_IER_LIN_MODE_LINBE_Msk   = 0x2000000  // Bit mask of LINBE field.
	USART_IER_LIN_MODE_LINBE       = 0x2000000  // Bit LINBE.
	USART_IER_LIN_MODE_LINISFE_Pos = 0x1a       // Position of LINISFE field.
	USART_IER_LIN_MODE_LINISFE_Msk = 0x4000000  // Bit mask of LINISFE field.
	USART_IER_LIN_MODE_LINISFE     = 0x4000000  // Bit LINISFE.
	USART_IER_LIN_MODE_LINIPE_Pos  = 0x1b       // Position of LINIPE field.
	USART_IER_LIN_MODE_LINIPE_Msk  = 0x8000000  // Bit mask of LINIPE field.
	USART_IER_LIN_MODE_LINIPE      = 0x8000000  // Bit LINIPE.
	USART_IER_LIN_MODE_LINCE_Pos   = 0x1c       // Position of LINCE field.
	USART_IER_LIN_MODE_LINCE_Msk   = 0x10000000 // Bit mask of LINCE field.
	USART_IER_LIN_MODE_LINCE       = 0x10000000 // Bit LINCE.
	USART_IER_LIN_MODE_LINSNRE_Pos = 0x1d       // Position of LINSNRE field.
	USART_IER_LIN_MODE_LINSNRE_Msk = 0x20000000 // Bit mask of LINSNRE field.
	USART_IER_LIN_MODE_LINSNRE     = 0x20000000 // Bit LINSNRE.

	// IDR: Interrupt Disable Register
	USART_IDR_RXRDY_Pos   = 0x0       // Position of RXRDY field.
	USART_IDR_RXRDY_Msk   = 0x1       // Bit mask of RXRDY field.
	USART_IDR_RXRDY       = 0x1       // Bit RXRDY.
	USART_IDR_TXRDY_Pos   = 0x1       // Position of TXRDY field.
	USART_IDR_TXRDY_Msk   = 0x2       // Bit mask of TXRDY field.
	USART_IDR_TXRDY       = 0x2       // Bit TXRDY.
	USART_IDR_RXBRK_Pos   = 0x2       // Position of RXBRK field.
	USART_IDR_RXBRK_Msk   = 0x4       // Bit mask of RXBRK field.
	USART_IDR_RXBRK       = 0x4       // Bit RXBRK.
	USART_IDR_OVRE_Pos    = 0x5       // Position of OVRE field.
	USART_IDR_OVRE_Msk    = 0x20      // Bit mask of OVRE field.
	USART_IDR_OVRE        = 0x20      // Bit OVRE.
	USART_IDR_FRAME_Pos   = 0x6       // Position of FRAME field.
	USART_IDR_FRAME_Msk   = 0x40      // Bit mask of FRAME field.
	USART_IDR_FRAME       = 0x40      // Bit FRAME.
	USART_IDR_PARE_Pos    = 0x7       // Position of PARE field.
	USART_IDR_PARE_Msk    = 0x80      // Bit mask of PARE field.
	USART_IDR_PARE        = 0x80      // Bit PARE.
	USART_IDR_TIMEOUT_Pos = 0x8       // Position of TIMEOUT field.
	USART_IDR_TIMEOUT_Msk = 0x100     // Bit mask of TIMEOUT field.
	USART_IDR_TIMEOUT     = 0x100     // Bit TIMEOUT.
	USART_IDR_TXEMPTY_Pos = 0x9       // Position of TXEMPTY field.
	USART_IDR_TXEMPTY_Msk = 0x200     // Bit mask of TXEMPTY field.
	USART_IDR_TXEMPTY     = 0x200     // Bit TXEMPTY.
	USART_IDR_ITER_Pos    = 0xa       // Position of ITER field.
	USART_IDR_ITER_Msk    = 0x400     // Bit mask of ITER field.
	USART_IDR_ITER        = 0x400     // Bit ITER.
	USART_IDR_NACK_Pos    = 0xd       // Position of NACK field.
	USART_IDR_NACK_Msk    = 0x2000    // Bit mask of NACK field.
	USART_IDR_NACK        = 0x2000    // Bit NACK.
	USART_IDR_CTSIC_Pos   = 0x13      // Position of CTSIC field.
	USART_IDR_CTSIC_Msk   = 0x80000   // Bit mask of CTSIC field.
	USART_IDR_CTSIC       = 0x80000   // Bit CTSIC.
	USART_IDR_MANE_Pos    = 0x18      // Position of MANE field.
	USART_IDR_MANE_Msk    = 0x1000000 // Bit mask of MANE field.
	USART_IDR_MANE        = 0x1000000 // Bit MANE.

	// IDR_SPI_MODE: Interrupt Disable Register
	USART_IDR_SPI_MODE_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY       = 0x1   // Bit RXRDY.
	USART_IDR_SPI_MODE_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY       = 0x2   // Bit TXRDY.
	USART_IDR_SPI_MODE_OVRE_Pos    = 0x5   // Position of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	USART_IDR_SPI_MODE_OVRE        = 0x20  // Bit OVRE.
	USART_IDR_SPI_MODE_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY     = 0x200 // Bit TXEMPTY.
	USART_IDR_SPI_MODE_UNRE_Pos    = 0xa   // Position of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Msk    = 0x400 // Bit mask of UNRE field.
	USART_IDR_SPI_MODE_UNRE        = 0x400 // Bit UNRE.

	// IDR_LIN_MODE: Interrupt Disable Register
	USART_IDR_LIN_MODE_RXRDY_Pos   = 0x0        // Position of RXRDY field.
	USART_IDR_LIN_MODE_RXRDY_Msk   = 0x1        // Bit mask of RXRDY field.
	USART_IDR_LIN_MODE_RXRDY       = 0x1        // Bit RXRDY.
	USART_IDR_LIN_MODE_TXRDY_Pos   = 0x1        // Position of TXRDY field.
	USART_IDR_LIN_MODE_TXRDY_Msk   = 0x2        // Bit mask of TXRDY field.
	USART_IDR_LIN_MODE_TXRDY       = 0x2        // Bit TXRDY.
	USART_IDR_LIN_MODE_OVRE_Pos    = 0x5        // Position of OVRE field.
	USART_IDR_LIN_MODE_OVRE_Msk    = 0x20       // Bit mask of OVRE field.
	USART_IDR_LIN_MODE_OVRE        = 0x20       // Bit OVRE.
	USART_IDR_LIN_MODE_FRAME_Pos   = 0x6        // Position of FRAME field.
	USART_IDR_LIN_MODE_FRAME_Msk   = 0x40       // Bit mask of FRAME field.
	USART_IDR_LIN_MODE_FRAME       = 0x40       // Bit FRAME.
	USART_IDR_LIN_MODE_PARE_Pos    = 0x7        // Position of PARE field.
	USART_IDR_LIN_MODE_PARE_Msk    = 0x80       // Bit mask of PARE field.
	USART_IDR_LIN_MODE_PARE        = 0x80       // Bit PARE.
	USART_IDR_LIN_MODE_TIMEOUT_Pos = 0x8        // Position of TIMEOUT field.
	USART_IDR_LIN_MODE_TIMEOUT_Msk = 0x100      // Bit mask of TIMEOUT field.
	USART_IDR_LIN_MODE_TIMEOUT     = 0x100      // Bit TIMEOUT.
	USART_IDR_LIN_MODE_TXEMPTY_Pos = 0x9        // Position of TXEMPTY field.
	USART_IDR_LIN_MODE_TXEMPTY_Msk = 0x200      // Bit mask of TXEMPTY field.
	USART_IDR_LIN_MODE_TXEMPTY     = 0x200      // Bit TXEMPTY.
	USART_IDR_LIN_MODE_LINBK_Pos   = 0xd        // Position of LINBK field.
	USART_IDR_LIN_MODE_LINBK_Msk   = 0x2000     // Bit mask of LINBK field.
	USART_IDR_LIN_MODE_LINBK       = 0x2000     // Bit LINBK.
	USART_IDR_LIN_MODE_LINID_Pos   = 0xe        // Position of LINID field.
	USART_IDR_LIN_MODE_LINID_Msk   = 0x4000     // Bit mask of LINID field.
	USART_IDR_LIN_MODE_LINID       = 0x4000     // Bit LINID.
	USART_IDR_LIN_MODE_LINTC_Pos   = 0xf        // Position of LINTC field.
	USART_IDR_LIN_MODE_LINTC_Msk   = 0x8000     // Bit mask of LINTC field.
	USART_IDR_LIN_MODE_LINTC       = 0x8000     // Bit LINTC.
	USART_IDR_LIN_MODE_LINBE_Pos   = 0x19       // Position of LINBE field.
	USART_IDR_LIN_MODE_LINBE_Msk   = 0x2000000  // Bit mask of LINBE field.
	USART_IDR_LIN_MODE_LINBE       = 0x2000000  // Bit LINBE.
	USART_IDR_LIN_MODE_LINISFE_Pos = 0x1a       // Position of LINISFE field.
	USART_IDR_LIN_MODE_LINISFE_Msk = 0x4000000  // Bit mask of LINISFE field.
	USART_IDR_LIN_MODE_LINISFE     = 0x4000000  // Bit LINISFE.
	USART_IDR_LIN_MODE_LINIPE_Pos  = 0x1b       // Position of LINIPE field.
	USART_IDR_LIN_MODE_LINIPE_Msk  = 0x8000000  // Bit mask of LINIPE field.
	USART_IDR_LIN_MODE_LINIPE      = 0x8000000  // Bit LINIPE.
	USART_IDR_LIN_MODE_LINCE_Pos   = 0x1c       // Position of LINCE field.
	USART_IDR_LIN_MODE_LINCE_Msk   = 0x10000000 // Bit mask of LINCE field.
	USART_IDR_LIN_MODE_LINCE       = 0x10000000 // Bit LINCE.
	USART_IDR_LIN_MODE_LINSNRE_Pos = 0x1d       // Position of LINSNRE field.
	USART_IDR_LIN_MODE_LINSNRE_Msk = 0x20000000 // Bit mask of LINSNRE field.
	USART_IDR_LIN_MODE_LINSNRE     = 0x20000000 // Bit LINSNRE.

	// IMR: Interrupt Mask Register
	USART_IMR_RXRDY_Pos   = 0x0       // Position of RXRDY field.
	USART_IMR_RXRDY_Msk   = 0x1       // Bit mask of RXRDY field.
	USART_IMR_RXRDY       = 0x1       // Bit RXRDY.
	USART_IMR_TXRDY_Pos   = 0x1       // Position of TXRDY field.
	USART_IMR_TXRDY_Msk   = 0x2       // Bit mask of TXRDY field.
	USART_IMR_TXRDY       = 0x2       // Bit TXRDY.
	USART_IMR_RXBRK_Pos   = 0x2       // Position of RXBRK field.
	USART_IMR_RXBRK_Msk   = 0x4       // Bit mask of RXBRK field.
	USART_IMR_RXBRK       = 0x4       // Bit RXBRK.
	USART_IMR_OVRE_Pos    = 0x5       // Position of OVRE field.
	USART_IMR_OVRE_Msk    = 0x20      // Bit mask of OVRE field.
	USART_IMR_OVRE        = 0x20      // Bit OVRE.
	USART_IMR_FRAME_Pos   = 0x6       // Position of FRAME field.
	USART_IMR_FRAME_Msk   = 0x40      // Bit mask of FRAME field.
	USART_IMR_FRAME       = 0x40      // Bit FRAME.
	USART_IMR_PARE_Pos    = 0x7       // Position of PARE field.
	USART_IMR_PARE_Msk    = 0x80      // Bit mask of PARE field.
	USART_IMR_PARE        = 0x80      // Bit PARE.
	USART_IMR_TIMEOUT_Pos = 0x8       // Position of TIMEOUT field.
	USART_IMR_TIMEOUT_Msk = 0x100     // Bit mask of TIMEOUT field.
	USART_IMR_TIMEOUT     = 0x100     // Bit TIMEOUT.
	USART_IMR_TXEMPTY_Pos = 0x9       // Position of TXEMPTY field.
	USART_IMR_TXEMPTY_Msk = 0x200     // Bit mask of TXEMPTY field.
	USART_IMR_TXEMPTY     = 0x200     // Bit TXEMPTY.
	USART_IMR_ITER_Pos    = 0xa       // Position of ITER field.
	USART_IMR_ITER_Msk    = 0x400     // Bit mask of ITER field.
	USART_IMR_ITER        = 0x400     // Bit ITER.
	USART_IMR_NACK_Pos    = 0xd       // Position of NACK field.
	USART_IMR_NACK_Msk    = 0x2000    // Bit mask of NACK field.
	USART_IMR_NACK        = 0x2000    // Bit NACK.
	USART_IMR_CTSIC_Pos   = 0x13      // Position of CTSIC field.
	USART_IMR_CTSIC_Msk   = 0x80000   // Bit mask of CTSIC field.
	USART_IMR_CTSIC       = 0x80000   // Bit CTSIC.
	USART_IMR_MANE_Pos    = 0x18      // Position of MANE field.
	USART_IMR_MANE_Msk    = 0x1000000 // Bit mask of MANE field.
	USART_IMR_MANE        = 0x1000000 // Bit MANE.

	// IMR_SPI_MODE: Interrupt Mask Register
	USART_IMR_SPI_MODE_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY       = 0x1   // Bit RXRDY.
	USART_IMR_SPI_MODE_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY       = 0x2   // Bit TXRDY.
	USART_IMR_SPI_MODE_OVRE_Pos    = 0x5   // Position of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	USART_IMR_SPI_MODE_OVRE        = 0x20  // Bit OVRE.
	USART_IMR_SPI_MODE_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY     = 0x200 // Bit TXEMPTY.
	USART_IMR_SPI_MODE_UNRE_Pos    = 0xa   // Position of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Msk    = 0x400 // Bit mask of UNRE field.
	USART_IMR_SPI_MODE_UNRE        = 0x400 // Bit UNRE.

	// IMR_LIN_MODE: Interrupt Mask Register
	USART_IMR_LIN_MODE_RXRDY_Pos   = 0x0        // Position of RXRDY field.
	USART_IMR_LIN_MODE_RXRDY_Msk   = 0x1        // Bit mask of RXRDY field.
	USART_IMR_LIN_MODE_RXRDY       = 0x1        // Bit RXRDY.
	USART_IMR_LIN_MODE_TXRDY_Pos   = 0x1        // Position of TXRDY field.
	USART_IMR_LIN_MODE_TXRDY_Msk   = 0x2        // Bit mask of TXRDY field.
	USART_IMR_LIN_MODE_TXRDY       = 0x2        // Bit TXRDY.
	USART_IMR_LIN_MODE_OVRE_Pos    = 0x5        // Position of OVRE field.
	USART_IMR_LIN_MODE_OVRE_Msk    = 0x20       // Bit mask of OVRE field.
	USART_IMR_LIN_MODE_OVRE        = 0x20       // Bit OVRE.
	USART_IMR_LIN_MODE_FRAME_Pos   = 0x6        // Position of FRAME field.
	USART_IMR_LIN_MODE_FRAME_Msk   = 0x40       // Bit mask of FRAME field.
	USART_IMR_LIN_MODE_FRAME       = 0x40       // Bit FRAME.
	USART_IMR_LIN_MODE_PARE_Pos    = 0x7        // Position of PARE field.
	USART_IMR_LIN_MODE_PARE_Msk    = 0x80       // Bit mask of PARE field.
	USART_IMR_LIN_MODE_PARE        = 0x80       // Bit PARE.
	USART_IMR_LIN_MODE_TIMEOUT_Pos = 0x8        // Position of TIMEOUT field.
	USART_IMR_LIN_MODE_TIMEOUT_Msk = 0x100      // Bit mask of TIMEOUT field.
	USART_IMR_LIN_MODE_TIMEOUT     = 0x100      // Bit TIMEOUT.
	USART_IMR_LIN_MODE_TXEMPTY_Pos = 0x9        // Position of TXEMPTY field.
	USART_IMR_LIN_MODE_TXEMPTY_Msk = 0x200      // Bit mask of TXEMPTY field.
	USART_IMR_LIN_MODE_TXEMPTY     = 0x200      // Bit TXEMPTY.
	USART_IMR_LIN_MODE_LINBK_Pos   = 0xd        // Position of LINBK field.
	USART_IMR_LIN_MODE_LINBK_Msk   = 0x2000     // Bit mask of LINBK field.
	USART_IMR_LIN_MODE_LINBK       = 0x2000     // Bit LINBK.
	USART_IMR_LIN_MODE_LINID_Pos   = 0xe        // Position of LINID field.
	USART_IMR_LIN_MODE_LINID_Msk   = 0x4000     // Bit mask of LINID field.
	USART_IMR_LIN_MODE_LINID       = 0x4000     // Bit LINID.
	USART_IMR_LIN_MODE_LINTC_Pos   = 0xf        // Position of LINTC field.
	USART_IMR_LIN_MODE_LINTC_Msk   = 0x8000     // Bit mask of LINTC field.
	USART_IMR_LIN_MODE_LINTC       = 0x8000     // Bit LINTC.
	USART_IMR_LIN_MODE_LINBE_Pos   = 0x19       // Position of LINBE field.
	USART_IMR_LIN_MODE_LINBE_Msk   = 0x2000000  // Bit mask of LINBE field.
	USART_IMR_LIN_MODE_LINBE       = 0x2000000  // Bit LINBE.
	USART_IMR_LIN_MODE_LINISFE_Pos = 0x1a       // Position of LINISFE field.
	USART_IMR_LIN_MODE_LINISFE_Msk = 0x4000000  // Bit mask of LINISFE field.
	USART_IMR_LIN_MODE_LINISFE     = 0x4000000  // Bit LINISFE.
	USART_IMR_LIN_MODE_LINIPE_Pos  = 0x1b       // Position of LINIPE field.
	USART_IMR_LIN_MODE_LINIPE_Msk  = 0x8000000  // Bit mask of LINIPE field.
	USART_IMR_LIN_MODE_LINIPE      = 0x8000000  // Bit LINIPE.
	USART_IMR_LIN_MODE_LINCE_Pos   = 0x1c       // Position of LINCE field.
	USART_IMR_LIN_MODE_LINCE_Msk   = 0x10000000 // Bit mask of LINCE field.
	USART_IMR_LIN_MODE_LINCE       = 0x10000000 // Bit LINCE.
	USART_IMR_LIN_MODE_LINSNRE_Pos = 0x1d       // Position of LINSNRE field.
	USART_IMR_LIN_MODE_LINSNRE_Msk = 0x20000000 // Bit mask of LINSNRE field.
	USART_IMR_LIN_MODE_LINSNRE     = 0x20000000 // Bit LINSNRE.

	// CSR: Channel Status Register
	USART_CSR_RXRDY_Pos   = 0x0       // Position of RXRDY field.
	USART_CSR_RXRDY_Msk   = 0x1       // Bit mask of RXRDY field.
	USART_CSR_RXRDY       = 0x1       // Bit RXRDY.
	USART_CSR_TXRDY_Pos   = 0x1       // Position of TXRDY field.
	USART_CSR_TXRDY_Msk   = 0x2       // Bit mask of TXRDY field.
	USART_CSR_TXRDY       = 0x2       // Bit TXRDY.
	USART_CSR_RXBRK_Pos   = 0x2       // Position of RXBRK field.
	USART_CSR_RXBRK_Msk   = 0x4       // Bit mask of RXBRK field.
	USART_CSR_RXBRK       = 0x4       // Bit RXBRK.
	USART_CSR_OVRE_Pos    = 0x5       // Position of OVRE field.
	USART_CSR_OVRE_Msk    = 0x20      // Bit mask of OVRE field.
	USART_CSR_OVRE        = 0x20      // Bit OVRE.
	USART_CSR_FRAME_Pos   = 0x6       // Position of FRAME field.
	USART_CSR_FRAME_Msk   = 0x40      // Bit mask of FRAME field.
	USART_CSR_FRAME       = 0x40      // Bit FRAME.
	USART_CSR_PARE_Pos    = 0x7       // Position of PARE field.
	USART_CSR_PARE_Msk    = 0x80      // Bit mask of PARE field.
	USART_CSR_PARE        = 0x80      // Bit PARE.
	USART_CSR_TIMEOUT_Pos = 0x8       // Position of TIMEOUT field.
	USART_CSR_TIMEOUT_Msk = 0x100     // Bit mask of TIMEOUT field.
	USART_CSR_TIMEOUT     = 0x100     // Bit TIMEOUT.
	USART_CSR_TXEMPTY_Pos = 0x9       // Position of TXEMPTY field.
	USART_CSR_TXEMPTY_Msk = 0x200     // Bit mask of TXEMPTY field.
	USART_CSR_TXEMPTY     = 0x200     // Bit TXEMPTY.
	USART_CSR_ITER_Pos    = 0xa       // Position of ITER field.
	USART_CSR_ITER_Msk    = 0x400     // Bit mask of ITER field.
	USART_CSR_ITER        = 0x400     // Bit ITER.
	USART_CSR_NACK_Pos    = 0xd       // Position of NACK field.
	USART_CSR_NACK_Msk    = 0x2000    // Bit mask of NACK field.
	USART_CSR_NACK        = 0x2000    // Bit NACK.
	USART_CSR_CTSIC_Pos   = 0x13      // Position of CTSIC field.
	USART_CSR_CTSIC_Msk   = 0x80000   // Bit mask of CTSIC field.
	USART_CSR_CTSIC       = 0x80000   // Bit CTSIC.
	USART_CSR_CTS_Pos     = 0x17      // Position of CTS field.
	USART_CSR_CTS_Msk     = 0x800000  // Bit mask of CTS field.
	USART_CSR_CTS         = 0x800000  // Bit CTS.
	USART_CSR_MANERR_Pos  = 0x18      // Position of MANERR field.
	USART_CSR_MANERR_Msk  = 0x1000000 // Bit mask of MANERR field.
	USART_CSR_MANERR      = 0x1000000 // Bit MANERR.

	// CSR_SPI_MODE: Channel Status Register
	USART_CSR_SPI_MODE_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY       = 0x1   // Bit RXRDY.
	USART_CSR_SPI_MODE_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY       = 0x2   // Bit TXRDY.
	USART_CSR_SPI_MODE_OVRE_Pos    = 0x5   // Position of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	USART_CSR_SPI_MODE_OVRE        = 0x20  // Bit OVRE.
	USART_CSR_SPI_MODE_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY     = 0x200 // Bit TXEMPTY.
	USART_CSR_SPI_MODE_UNRE_Pos    = 0xa   // Position of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Msk    = 0x400 // Bit mask of UNRE field.
	USART_CSR_SPI_MODE_UNRE        = 0x400 // Bit UNRE.

	// CSR_LIN_MODE: Channel Status Register
	USART_CSR_LIN_MODE_RXRDY_Pos   = 0x0        // Position of RXRDY field.
	USART_CSR_LIN_MODE_RXRDY_Msk   = 0x1        // Bit mask of RXRDY field.
	USART_CSR_LIN_MODE_RXRDY       = 0x1        // Bit RXRDY.
	USART_CSR_LIN_MODE_TXRDY_Pos   = 0x1        // Position of TXRDY field.
	USART_CSR_LIN_MODE_TXRDY_Msk   = 0x2        // Bit mask of TXRDY field.
	USART_CSR_LIN_MODE_TXRDY       = 0x2        // Bit TXRDY.
	USART_CSR_LIN_MODE_OVRE_Pos    = 0x5        // Position of OVRE field.
	USART_CSR_LIN_MODE_OVRE_Msk    = 0x20       // Bit mask of OVRE field.
	USART_CSR_LIN_MODE_OVRE        = 0x20       // Bit OVRE.
	USART_CSR_LIN_MODE_FRAME_Pos   = 0x6        // Position of FRAME field.
	USART_CSR_LIN_MODE_FRAME_Msk   = 0x40       // Bit mask of FRAME field.
	USART_CSR_LIN_MODE_FRAME       = 0x40       // Bit FRAME.
	USART_CSR_LIN_MODE_PARE_Pos    = 0x7        // Position of PARE field.
	USART_CSR_LIN_MODE_PARE_Msk    = 0x80       // Bit mask of PARE field.
	USART_CSR_LIN_MODE_PARE        = 0x80       // Bit PARE.
	USART_CSR_LIN_MODE_TIMEOUT_Pos = 0x8        // Position of TIMEOUT field.
	USART_CSR_LIN_MODE_TIMEOUT_Msk = 0x100      // Bit mask of TIMEOUT field.
	USART_CSR_LIN_MODE_TIMEOUT     = 0x100      // Bit TIMEOUT.
	USART_CSR_LIN_MODE_TXEMPTY_Pos = 0x9        // Position of TXEMPTY field.
	USART_CSR_LIN_MODE_TXEMPTY_Msk = 0x200      // Bit mask of TXEMPTY field.
	USART_CSR_LIN_MODE_TXEMPTY     = 0x200      // Bit TXEMPTY.
	USART_CSR_LIN_MODE_LINBK_Pos   = 0xd        // Position of LINBK field.
	USART_CSR_LIN_MODE_LINBK_Msk   = 0x2000     // Bit mask of LINBK field.
	USART_CSR_LIN_MODE_LINBK       = 0x2000     // Bit LINBK.
	USART_CSR_LIN_MODE_LINID_Pos   = 0xe        // Position of LINID field.
	USART_CSR_LIN_MODE_LINID_Msk   = 0x4000     // Bit mask of LINID field.
	USART_CSR_LIN_MODE_LINID       = 0x4000     // Bit LINID.
	USART_CSR_LIN_MODE_LINTC_Pos   = 0xf        // Position of LINTC field.
	USART_CSR_LIN_MODE_LINTC_Msk   = 0x8000     // Bit mask of LINTC field.
	USART_CSR_LIN_MODE_LINTC       = 0x8000     // Bit LINTC.
	USART_CSR_LIN_MODE_LINBLS_Pos  = 0x17       // Position of LINBLS field.
	USART_CSR_LIN_MODE_LINBLS_Msk  = 0x800000   // Bit mask of LINBLS field.
	USART_CSR_LIN_MODE_LINBLS      = 0x800000   // Bit LINBLS.
	USART_CSR_LIN_MODE_LINBE_Pos   = 0x19       // Position of LINBE field.
	USART_CSR_LIN_MODE_LINBE_Msk   = 0x2000000  // Bit mask of LINBE field.
	USART_CSR_LIN_MODE_LINBE       = 0x2000000  // Bit LINBE.
	USART_CSR_LIN_MODE_LINISFE_Pos = 0x1a       // Position of LINISFE field.
	USART_CSR_LIN_MODE_LINISFE_Msk = 0x4000000  // Bit mask of LINISFE field.
	USART_CSR_LIN_MODE_LINISFE     = 0x4000000  // Bit LINISFE.
	USART_CSR_LIN_MODE_LINIPE_Pos  = 0x1b       // Position of LINIPE field.
	USART_CSR_LIN_MODE_LINIPE_Msk  = 0x8000000  // Bit mask of LINIPE field.
	USART_CSR_LIN_MODE_LINIPE      = 0x8000000  // Bit LINIPE.
	USART_CSR_LIN_MODE_LINCE_Pos   = 0x1c       // Position of LINCE field.
	USART_CSR_LIN_MODE_LINCE_Msk   = 0x10000000 // Bit mask of LINCE field.
	USART_CSR_LIN_MODE_LINCE       = 0x10000000 // Bit LINCE.
	USART_CSR_LIN_MODE_LINSNRE_Pos = 0x1d       // Position of LINSNRE field.
	USART_CSR_LIN_MODE_LINSNRE_Msk = 0x20000000 // Bit mask of LINSNRE field.
	USART_CSR_LIN_MODE_LINSNRE     = 0x20000000 // Bit LINSNRE.

	// RHR: Receiver Holding Register
	USART_RHR_RXCHR_Pos  = 0x0    // Position of RXCHR field.
	USART_RHR_RXCHR_Msk  = 0x1ff  // Bit mask of RXCHR field.
	USART_RHR_RXSYNH_Pos = 0xf    // Position of RXSYNH field.
	USART_RHR_RXSYNH_Msk = 0x8000 // Bit mask of RXSYNH field.
	USART_RHR_RXSYNH     = 0x8000 // Bit RXSYNH.

	// THR: Transmitter Holding Register
	USART_THR_TXCHR_Pos  = 0x0    // Position of TXCHR field.
	USART_THR_TXCHR_Msk  = 0x1ff  // Bit mask of TXCHR field.
	USART_THR_TXSYNH_Pos = 0xf    // Position of TXSYNH field.
	USART_THR_TXSYNH_Msk = 0x8000 // Bit mask of TXSYNH field.
	USART_THR_TXSYNH     = 0x8000 // Bit TXSYNH.

	// BRGR: Baud Rate Generator Register
	USART_BRGR_CD_Pos = 0x0     // Position of CD field.
	USART_BRGR_CD_Msk = 0xffff  // Bit mask of CD field.
	USART_BRGR_FP_Pos = 0x10    // Position of FP field.
	USART_BRGR_FP_Msk = 0x70000 // Bit mask of FP field.

	// RTOR: Receiver Time-out Register
	USART_RTOR_TO_Pos = 0x0     // Position of TO field.
	USART_RTOR_TO_Msk = 0x1ffff // Bit mask of TO field.

	// TTGR: Transmitter Timeguard Register
	USART_TTGR_TG_Pos = 0x0  // Position of TG field.
	USART_TTGR_TG_Msk = 0xff // Bit mask of TG field.

	// FIDI: FI DI Ratio Register
	USART_FIDI_FI_DI_RATIO_Pos = 0x0   // Position of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Msk = 0x7ff // Bit mask of FI_DI_RATIO field.

	// NER: Number of Errors Register
	USART_NER_NB_ERRORS_Pos = 0x0  // Position of NB_ERRORS field.
	USART_NER_NB_ERRORS_Msk = 0xff // Bit mask of NB_ERRORS field.

	// IF: IrDA Filter Register
	USART_IF_IRDA_FILTER_Pos = 0x0  // Position of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Msk = 0xff // Bit mask of IRDA_FILTER field.

	// MAN: Manchester Encoder Decoder Register
	USART_MAN_TX_PL_Pos      = 0x0        // Position of TX_PL field.
	USART_MAN_TX_PL_Msk      = 0xf        // Bit mask of TX_PL field.
	USART_MAN_TX_PP_Pos      = 0x8        // Position of TX_PP field.
	USART_MAN_TX_PP_Msk      = 0x300      // Bit mask of TX_PP field.
	USART_MAN_TX_PP_ALL_ONE  = 0x0        // The preamble is composed of '1's
	USART_MAN_TX_PP_ALL_ZERO = 0x1        // The preamble is composed of '0's
	USART_MAN_TX_PP_ZERO_ONE = 0x2        // The preamble is composed of '01's
	USART_MAN_TX_PP_ONE_ZERO = 0x3        // The preamble is composed of '10's
	USART_MAN_TX_MPOL_Pos    = 0xc        // Position of TX_MPOL field.
	USART_MAN_TX_MPOL_Msk    = 0x1000     // Bit mask of TX_MPOL field.
	USART_MAN_TX_MPOL        = 0x1000     // Bit TX_MPOL.
	USART_MAN_RX_PL_Pos      = 0x10       // Position of RX_PL field.
	USART_MAN_RX_PL_Msk      = 0xf0000    // Bit mask of RX_PL field.
	USART_MAN_RX_PP_Pos      = 0x18       // Position of RX_PP field.
	USART_MAN_RX_PP_Msk      = 0x3000000  // Bit mask of RX_PP field.
	USART_MAN_RX_PP_ALL_ONE  = 0x0        // The preamble is composed of '1's
	USART_MAN_RX_PP_ALL_ZERO = 0x1        // The preamble is composed of '0's
	USART_MAN_RX_PP_ZERO_ONE = 0x2        // The preamble is composed of '01's
	USART_MAN_RX_PP_ONE_ZERO = 0x3        // The preamble is composed of '10's
	USART_MAN_RX_MPOL_Pos    = 0x1c       // Position of RX_MPOL field.
	USART_MAN_RX_MPOL_Msk    = 0x10000000 // Bit mask of RX_MPOL field.
	USART_MAN_RX_MPOL        = 0x10000000 // Bit RX_MPOL.
	USART_MAN_ONE_Pos        = 0x1d       // Position of ONE field.
	USART_MAN_ONE_Msk        = 0x20000000 // Bit mask of ONE field.
	USART_MAN_ONE            = 0x20000000 // Bit ONE.
	USART_MAN_DRIFT_Pos      = 0x1e       // Position of DRIFT field.
	USART_MAN_DRIFT_Msk      = 0x40000000 // Bit mask of DRIFT field.
	USART_MAN_DRIFT          = 0x40000000 // Bit DRIFT.

	// LINMR: LIN Mode Register
	USART_LINMR_NACT_Pos       = 0x0     // Position of NACT field.
	USART_LINMR_NACT_Msk       = 0x3     // Bit mask of NACT field.
	USART_LINMR_NACT_PUBLISH   = 0x0     // The USART transmits the response.
	USART_LINMR_NACT_SUBSCRIBE = 0x1     // The USART receives the response.
	USART_LINMR_NACT_IGNORE    = 0x2     // The USART does not transmit and does not receive the response.
	USART_LINMR_PARDIS_Pos     = 0x2     // Position of PARDIS field.
	USART_LINMR_PARDIS_Msk     = 0x4     // Bit mask of PARDIS field.
	USART_LINMR_PARDIS         = 0x4     // Bit PARDIS.
	USART_LINMR_CHKDIS_Pos     = 0x3     // Position of CHKDIS field.
	USART_LINMR_CHKDIS_Msk     = 0x8     // Bit mask of CHKDIS field.
	USART_LINMR_CHKDIS         = 0x8     // Bit CHKDIS.
	USART_LINMR_CHKTYP_Pos     = 0x4     // Position of CHKTYP field.
	USART_LINMR_CHKTYP_Msk     = 0x10    // Bit mask of CHKTYP field.
	USART_LINMR_CHKTYP         = 0x10    // Bit CHKTYP.
	USART_LINMR_DLM_Pos        = 0x5     // Position of DLM field.
	USART_LINMR_DLM_Msk        = 0x20    // Bit mask of DLM field.
	USART_LINMR_DLM            = 0x20    // Bit DLM.
	USART_LINMR_FSDIS_Pos      = 0x6     // Position of FSDIS field.
	USART_LINMR_FSDIS_Msk      = 0x40    // Bit mask of FSDIS field.
	USART_LINMR_FSDIS          = 0x40    // Bit FSDIS.
	USART_LINMR_WKUPTYP_Pos    = 0x7     // Position of WKUPTYP field.
	USART_LINMR_WKUPTYP_Msk    = 0x80    // Bit mask of WKUPTYP field.
	USART_LINMR_WKUPTYP        = 0x80    // Bit WKUPTYP.
	USART_LINMR_DLC_Pos        = 0x8     // Position of DLC field.
	USART_LINMR_DLC_Msk        = 0xff00  // Bit mask of DLC field.
	USART_LINMR_PDCM_Pos       = 0x10    // Position of PDCM field.
	USART_LINMR_PDCM_Msk       = 0x10000 // Bit mask of PDCM field.
	USART_LINMR_PDCM           = 0x10000 // Bit PDCM.

	// LINIR: LIN Identifier Register
	USART_LINIR_IDCHR_Pos = 0x0  // Position of IDCHR field.
	USART_LINIR_IDCHR_Msk = 0xff // Bit mask of IDCHR field.

	// WPMR: Write Protect Mode Register
	USART_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	USART_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	USART_WPMR_WPEN      = 0x1        // Bit WPEN.
	USART_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	USART_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protect Status Register
	USART_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	USART_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	USART_WPSR_WPVS       = 0x1      // Bit WPVS.
	USART_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	USART_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for EMAC: Ethernet MAC 10/100
const (
	// NCR: Network Control Register
	EMAC_NCR_LB_Pos      = 0x0   // Position of LB field.
	EMAC_NCR_LB_Msk      = 0x1   // Bit mask of LB field.
	EMAC_NCR_LB          = 0x1   // Bit LB.
	EMAC_NCR_LLB_Pos     = 0x1   // Position of LLB field.
	EMAC_NCR_LLB_Msk     = 0x2   // Bit mask of LLB field.
	EMAC_NCR_LLB         = 0x2   // Bit LLB.
	EMAC_NCR_RE_Pos      = 0x2   // Position of RE field.
	EMAC_NCR_RE_Msk      = 0x4   // Bit mask of RE field.
	EMAC_NCR_RE          = 0x4   // Bit RE.
	EMAC_NCR_TE_Pos      = 0x3   // Position of TE field.
	EMAC_NCR_TE_Msk      = 0x8   // Bit mask of TE field.
	EMAC_NCR_TE          = 0x8   // Bit TE.
	EMAC_NCR_MPE_Pos     = 0x4   // Position of MPE field.
	EMAC_NCR_MPE_Msk     = 0x10  // Bit mask of MPE field.
	EMAC_NCR_MPE         = 0x10  // Bit MPE.
	EMAC_NCR_CLRSTAT_Pos = 0x5   // Position of CLRSTAT field.
	EMAC_NCR_CLRSTAT_Msk = 0x20  // Bit mask of CLRSTAT field.
	EMAC_NCR_CLRSTAT     = 0x20  // Bit CLRSTAT.
	EMAC_NCR_INCSTAT_Pos = 0x6   // Position of INCSTAT field.
	EMAC_NCR_INCSTAT_Msk = 0x40  // Bit mask of INCSTAT field.
	EMAC_NCR_INCSTAT     = 0x40  // Bit INCSTAT.
	EMAC_NCR_WESTAT_Pos  = 0x7   // Position of WESTAT field.
	EMAC_NCR_WESTAT_Msk  = 0x80  // Bit mask of WESTAT field.
	EMAC_NCR_WESTAT      = 0x80  // Bit WESTAT.
	EMAC_NCR_BP_Pos      = 0x8   // Position of BP field.
	EMAC_NCR_BP_Msk      = 0x100 // Bit mask of BP field.
	EMAC_NCR_BP          = 0x100 // Bit BP.
	EMAC_NCR_TSTART_Pos  = 0x9   // Position of TSTART field.
	EMAC_NCR_TSTART_Msk  = 0x200 // Bit mask of TSTART field.
	EMAC_NCR_TSTART      = 0x200 // Bit TSTART.
	EMAC_NCR_THALT_Pos   = 0xa   // Position of THALT field.
	EMAC_NCR_THALT_Msk   = 0x400 // Bit mask of THALT field.
	EMAC_NCR_THALT       = 0x400 // Bit THALT.

	// NCFGR: Network Configuration Register
	EMAC_NCFGR_SPD_Pos       = 0x0     // Position of SPD field.
	EMAC_NCFGR_SPD_Msk       = 0x1     // Bit mask of SPD field.
	EMAC_NCFGR_SPD           = 0x1     // Bit SPD.
	EMAC_NCFGR_FD_Pos        = 0x1     // Position of FD field.
	EMAC_NCFGR_FD_Msk        = 0x2     // Bit mask of FD field.
	EMAC_NCFGR_FD            = 0x2     // Bit FD.
	EMAC_NCFGR_JFRAME_Pos    = 0x3     // Position of JFRAME field.
	EMAC_NCFGR_JFRAME_Msk    = 0x8     // Bit mask of JFRAME field.
	EMAC_NCFGR_JFRAME        = 0x8     // Bit JFRAME.
	EMAC_NCFGR_CAF_Pos       = 0x4     // Position of CAF field.
	EMAC_NCFGR_CAF_Msk       = 0x10    // Bit mask of CAF field.
	EMAC_NCFGR_CAF           = 0x10    // Bit CAF.
	EMAC_NCFGR_NBC_Pos       = 0x5     // Position of NBC field.
	EMAC_NCFGR_NBC_Msk       = 0x20    // Bit mask of NBC field.
	EMAC_NCFGR_NBC           = 0x20    // Bit NBC.
	EMAC_NCFGR_MTI_Pos       = 0x6     // Position of MTI field.
	EMAC_NCFGR_MTI_Msk       = 0x40    // Bit mask of MTI field.
	EMAC_NCFGR_MTI           = 0x40    // Bit MTI.
	EMAC_NCFGR_UNI_Pos       = 0x7     // Position of UNI field.
	EMAC_NCFGR_UNI_Msk       = 0x80    // Bit mask of UNI field.
	EMAC_NCFGR_UNI           = 0x80    // Bit UNI.
	EMAC_NCFGR_BIG_Pos       = 0x8     // Position of BIG field.
	EMAC_NCFGR_BIG_Msk       = 0x100   // Bit mask of BIG field.
	EMAC_NCFGR_BIG           = 0x100   // Bit BIG.
	EMAC_NCFGR_CLK_Pos       = 0xa     // Position of CLK field.
	EMAC_NCFGR_CLK_Msk       = 0xc00   // Bit mask of CLK field.
	EMAC_NCFGR_CLK_MCK_8     = 0x0     // MCK divided by 8 (MCK up to 20 MHz).
	EMAC_NCFGR_CLK_MCK_16    = 0x1     // MCK divided by 16 (MCK up to 40 MHz).
	EMAC_NCFGR_CLK_MCK_32    = 0x2     // MCK divided by 32 (MCK up to 80 MHz).
	EMAC_NCFGR_CLK_MCK_64    = 0x3     // MCK divided by 64 (MCK up to 160 MHz).
	EMAC_NCFGR_RTY_Pos       = 0xc     // Position of RTY field.
	EMAC_NCFGR_RTY_Msk       = 0x1000  // Bit mask of RTY field.
	EMAC_NCFGR_RTY           = 0x1000  // Bit RTY.
	EMAC_NCFGR_PAE_Pos       = 0xd     // Position of PAE field.
	EMAC_NCFGR_PAE_Msk       = 0x2000  // Bit mask of PAE field.
	EMAC_NCFGR_PAE           = 0x2000  // Bit PAE.
	EMAC_NCFGR_RBOF_Pos      = 0xe     // Position of RBOF field.
	EMAC_NCFGR_RBOF_Msk      = 0xc000  // Bit mask of RBOF field.
	EMAC_NCFGR_RBOF_OFFSET_0 = 0x0     // No offset from start of receive buffer.
	EMAC_NCFGR_RBOF_OFFSET_1 = 0x1     // One-byte offset from start of receive buffer.
	EMAC_NCFGR_RBOF_OFFSET_2 = 0x2     // Two-byte offset from start of receive buffer.
	EMAC_NCFGR_RBOF_OFFSET_3 = 0x3     // Three-byte offset from start of receive buffer.
	EMAC_NCFGR_RLCE_Pos      = 0x10    // Position of RLCE field.
	EMAC_NCFGR_RLCE_Msk      = 0x10000 // Bit mask of RLCE field.
	EMAC_NCFGR_RLCE          = 0x10000 // Bit RLCE.
	EMAC_NCFGR_DRFCS_Pos     = 0x11    // Position of DRFCS field.
	EMAC_NCFGR_DRFCS_Msk     = 0x20000 // Bit mask of DRFCS field.
	EMAC_NCFGR_DRFCS         = 0x20000 // Bit DRFCS.
	EMAC_NCFGR_EFRHD_Pos     = 0x12    // Position of EFRHD field.
	EMAC_NCFGR_EFRHD_Msk     = 0x40000 // Bit mask of EFRHD field.
	EMAC_NCFGR_EFRHD         = 0x40000 // Bit EFRHD.
	EMAC_NCFGR_IRXFCS_Pos    = 0x13    // Position of IRXFCS field.
	EMAC_NCFGR_IRXFCS_Msk    = 0x80000 // Bit mask of IRXFCS field.
	EMAC_NCFGR_IRXFCS        = 0x80000 // Bit IRXFCS.

	// NSR: Network Status Register
	EMAC_NSR_MDIO_Pos = 0x1 // Position of MDIO field.
	EMAC_NSR_MDIO_Msk = 0x2 // Bit mask of MDIO field.
	EMAC_NSR_MDIO     = 0x2 // Bit MDIO.
	EMAC_NSR_IDLE_Pos = 0x2 // Position of IDLE field.
	EMAC_NSR_IDLE_Msk = 0x4 // Bit mask of IDLE field.
	EMAC_NSR_IDLE     = 0x4 // Bit IDLE.

	// TSR: Transmit Status Register
	EMAC_TSR_UBR_Pos  = 0x0  // Position of UBR field.
	EMAC_TSR_UBR_Msk  = 0x1  // Bit mask of UBR field.
	EMAC_TSR_UBR      = 0x1  // Bit UBR.
	EMAC_TSR_COL_Pos  = 0x1  // Position of COL field.
	EMAC_TSR_COL_Msk  = 0x2  // Bit mask of COL field.
	EMAC_TSR_COL      = 0x2  // Bit COL.
	EMAC_TSR_RLES_Pos = 0x2  // Position of RLES field.
	EMAC_TSR_RLES_Msk = 0x4  // Bit mask of RLES field.
	EMAC_TSR_RLES     = 0x4  // Bit RLES.
	EMAC_TSR_TGO_Pos  = 0x3  // Position of TGO field.
	EMAC_TSR_TGO_Msk  = 0x8  // Bit mask of TGO field.
	EMAC_TSR_TGO      = 0x8  // Bit TGO.
	EMAC_TSR_BEX_Pos  = 0x4  // Position of BEX field.
	EMAC_TSR_BEX_Msk  = 0x10 // Bit mask of BEX field.
	EMAC_TSR_BEX      = 0x10 // Bit BEX.
	EMAC_TSR_COMP_Pos = 0x5  // Position of COMP field.
	EMAC_TSR_COMP_Msk = 0x20 // Bit mask of COMP field.
	EMAC_TSR_COMP     = 0x20 // Bit COMP.
	EMAC_TSR_UND_Pos  = 0x6  // Position of UND field.
	EMAC_TSR_UND_Msk  = 0x40 // Bit mask of UND field.
	EMAC_TSR_UND      = 0x40 // Bit UND.

	// RBQP: Receive Buffer Queue Pointer Register
	EMAC_RBQP_ADDR_Pos = 0x2        // Position of ADDR field.
	EMAC_RBQP_ADDR_Msk = 0xfffffffc // Bit mask of ADDR field.

	// TBQP: Transmit Buffer Queue Pointer Register
	EMAC_TBQP_ADDR_Pos = 0x2        // Position of ADDR field.
	EMAC_TBQP_ADDR_Msk = 0xfffffffc // Bit mask of ADDR field.

	// RSR: Receive Status Register
	EMAC_RSR_BNA_Pos = 0x0 // Position of BNA field.
	EMAC_RSR_BNA_Msk = 0x1 // Bit mask of BNA field.
	EMAC_RSR_BNA     = 0x1 // Bit BNA.
	EMAC_RSR_REC_Pos = 0x1 // Position of REC field.
	EMAC_RSR_REC_Msk = 0x2 // Bit mask of REC field.
	EMAC_RSR_REC     = 0x2 // Bit REC.
	EMAC_RSR_OVR_Pos = 0x2 // Position of OVR field.
	EMAC_RSR_OVR_Msk = 0x4 // Bit mask of OVR field.
	EMAC_RSR_OVR     = 0x4 // Bit OVR.

	// ISR: Interrupt Status Register
	EMAC_ISR_MFD_Pos   = 0x0    // Position of MFD field.
	EMAC_ISR_MFD_Msk   = 0x1    // Bit mask of MFD field.
	EMAC_ISR_MFD       = 0x1    // Bit MFD.
	EMAC_ISR_RCOMP_Pos = 0x1    // Position of RCOMP field.
	EMAC_ISR_RCOMP_Msk = 0x2    // Bit mask of RCOMP field.
	EMAC_ISR_RCOMP     = 0x2    // Bit RCOMP.
	EMAC_ISR_RXUBR_Pos = 0x2    // Position of RXUBR field.
	EMAC_ISR_RXUBR_Msk = 0x4    // Bit mask of RXUBR field.
	EMAC_ISR_RXUBR     = 0x4    // Bit RXUBR.
	EMAC_ISR_TXUBR_Pos = 0x3    // Position of TXUBR field.
	EMAC_ISR_TXUBR_Msk = 0x8    // Bit mask of TXUBR field.
	EMAC_ISR_TXUBR     = 0x8    // Bit TXUBR.
	EMAC_ISR_TUND_Pos  = 0x4    // Position of TUND field.
	EMAC_ISR_TUND_Msk  = 0x10   // Bit mask of TUND field.
	EMAC_ISR_TUND      = 0x10   // Bit TUND.
	EMAC_ISR_RLEX_Pos  = 0x5    // Position of RLEX field.
	EMAC_ISR_RLEX_Msk  = 0x20   // Bit mask of RLEX field.
	EMAC_ISR_RLEX      = 0x20   // Bit RLEX.
	EMAC_ISR_TXERR_Pos = 0x6    // Position of TXERR field.
	EMAC_ISR_TXERR_Msk = 0x40   // Bit mask of TXERR field.
	EMAC_ISR_TXERR     = 0x40   // Bit TXERR.
	EMAC_ISR_TCOMP_Pos = 0x7    // Position of TCOMP field.
	EMAC_ISR_TCOMP_Msk = 0x80   // Bit mask of TCOMP field.
	EMAC_ISR_TCOMP     = 0x80   // Bit TCOMP.
	EMAC_ISR_ROVR_Pos  = 0xa    // Position of ROVR field.
	EMAC_ISR_ROVR_Msk  = 0x400  // Bit mask of ROVR field.
	EMAC_ISR_ROVR      = 0x400  // Bit ROVR.
	EMAC_ISR_HRESP_Pos = 0xb    // Position of HRESP field.
	EMAC_ISR_HRESP_Msk = 0x800  // Bit mask of HRESP field.
	EMAC_ISR_HRESP     = 0x800  // Bit HRESP.
	EMAC_ISR_PFRE_Pos  = 0xc    // Position of PFRE field.
	EMAC_ISR_PFRE_Msk  = 0x1000 // Bit mask of PFRE field.
	EMAC_ISR_PFRE      = 0x1000 // Bit PFRE.
	EMAC_ISR_PTZ_Pos   = 0xd    // Position of PTZ field.
	EMAC_ISR_PTZ_Msk   = 0x2000 // Bit mask of PTZ field.
	EMAC_ISR_PTZ       = 0x2000 // Bit PTZ.

	// IER: Interrupt Enable Register
	EMAC_IER_MFD_Pos   = 0x0    // Position of MFD field.
	EMAC_IER_MFD_Msk   = 0x1    // Bit mask of MFD field.
	EMAC_IER_MFD       = 0x1    // Bit MFD.
	EMAC_IER_RCOMP_Pos = 0x1    // Position of RCOMP field.
	EMAC_IER_RCOMP_Msk = 0x2    // Bit mask of RCOMP field.
	EMAC_IER_RCOMP     = 0x2    // Bit RCOMP.
	EMAC_IER_RXUBR_Pos = 0x2    // Position of RXUBR field.
	EMAC_IER_RXUBR_Msk = 0x4    // Bit mask of RXUBR field.
	EMAC_IER_RXUBR     = 0x4    // Bit RXUBR.
	EMAC_IER_TXUBR_Pos = 0x3    // Position of TXUBR field.
	EMAC_IER_TXUBR_Msk = 0x8    // Bit mask of TXUBR field.
	EMAC_IER_TXUBR     = 0x8    // Bit TXUBR.
	EMAC_IER_TUND_Pos  = 0x4    // Position of TUND field.
	EMAC_IER_TUND_Msk  = 0x10   // Bit mask of TUND field.
	EMAC_IER_TUND      = 0x10   // Bit TUND.
	EMAC_IER_RLE_Pos   = 0x5    // Position of RLE field.
	EMAC_IER_RLE_Msk   = 0x20   // Bit mask of RLE field.
	EMAC_IER_RLE       = 0x20   // Bit RLE.
	EMAC_IER_TXERR_Pos = 0x6    // Position of TXERR field.
	EMAC_IER_TXERR_Msk = 0x40   // Bit mask of TXERR field.
	EMAC_IER_TXERR     = 0x40   // Bit TXERR.
	EMAC_IER_TCOMP_Pos = 0x7    // Position of TCOMP field.
	EMAC_IER_TCOMP_Msk = 0x80   // Bit mask of TCOMP field.
	EMAC_IER_TCOMP     = 0x80   // Bit TCOMP.
	EMAC_IER_ROVR_Pos  = 0xa    // Position of ROVR field.
	EMAC_IER_ROVR_Msk  = 0x400  // Bit mask of ROVR field.
	EMAC_IER_ROVR      = 0x400  // Bit ROVR.
	EMAC_IER_HRESP_Pos = 0xb    // Position of HRESP field.
	EMAC_IER_HRESP_Msk = 0x800  // Bit mask of HRESP field.
	EMAC_IER_HRESP     = 0x800  // Bit HRESP.
	EMAC_IER_PFR_Pos   = 0xc    // Position of PFR field.
	EMAC_IER_PFR_Msk   = 0x1000 // Bit mask of PFR field.
	EMAC_IER_PFR       = 0x1000 // Bit PFR.
	EMAC_IER_PTZ_Pos   = 0xd    // Position of PTZ field.
	EMAC_IER_PTZ_Msk   = 0x2000 // Bit mask of PTZ field.
	EMAC_IER_PTZ       = 0x2000 // Bit PTZ.

	// IDR: Interrupt Disable Register
	EMAC_IDR_MFD_Pos   = 0x0    // Position of MFD field.
	EMAC_IDR_MFD_Msk   = 0x1    // Bit mask of MFD field.
	EMAC_IDR_MFD       = 0x1    // Bit MFD.
	EMAC_IDR_RCOMP_Pos = 0x1    // Position of RCOMP field.
	EMAC_IDR_RCOMP_Msk = 0x2    // Bit mask of RCOMP field.
	EMAC_IDR_RCOMP     = 0x2    // Bit RCOMP.
	EMAC_IDR_RXUBR_Pos = 0x2    // Position of RXUBR field.
	EMAC_IDR_RXUBR_Msk = 0x4    // Bit mask of RXUBR field.
	EMAC_IDR_RXUBR     = 0x4    // Bit RXUBR.
	EMAC_IDR_TXUBR_Pos = 0x3    // Position of TXUBR field.
	EMAC_IDR_TXUBR_Msk = 0x8    // Bit mask of TXUBR field.
	EMAC_IDR_TXUBR     = 0x8    // Bit TXUBR.
	EMAC_IDR_TUND_Pos  = 0x4    // Position of TUND field.
	EMAC_IDR_TUND_Msk  = 0x10   // Bit mask of TUND field.
	EMAC_IDR_TUND      = 0x10   // Bit TUND.
	EMAC_IDR_RLE_Pos   = 0x5    // Position of RLE field.
	EMAC_IDR_RLE_Msk   = 0x20   // Bit mask of RLE field.
	EMAC_IDR_RLE       = 0x20   // Bit RLE.
	EMAC_IDR_TXERR_Pos = 0x6    // Position of TXERR field.
	EMAC_IDR_TXERR_Msk = 0x40   // Bit mask of TXERR field.
	EMAC_IDR_TXERR     = 0x40   // Bit TXERR.
	EMAC_IDR_TCOMP_Pos = 0x7    // Position of TCOMP field.
	EMAC_IDR_TCOMP_Msk = 0x80   // Bit mask of TCOMP field.
	EMAC_IDR_TCOMP     = 0x80   // Bit TCOMP.
	EMAC_IDR_ROVR_Pos  = 0xa    // Position of ROVR field.
	EMAC_IDR_ROVR_Msk  = 0x400  // Bit mask of ROVR field.
	EMAC_IDR_ROVR      = 0x400  // Bit ROVR.
	EMAC_IDR_HRESP_Pos = 0xb    // Position of HRESP field.
	EMAC_IDR_HRESP_Msk = 0x800  // Bit mask of HRESP field.
	EMAC_IDR_HRESP     = 0x800  // Bit HRESP.
	EMAC_IDR_PFR_Pos   = 0xc    // Position of PFR field.
	EMAC_IDR_PFR_Msk   = 0x1000 // Bit mask of PFR field.
	EMAC_IDR_PFR       = 0x1000 // Bit PFR.
	EMAC_IDR_PTZ_Pos   = 0xd    // Position of PTZ field.
	EMAC_IDR_PTZ_Msk   = 0x2000 // Bit mask of PTZ field.
	EMAC_IDR_PTZ       = 0x2000 // Bit PTZ.

	// IMR: Interrupt Mask Register
	EMAC_IMR_MFD_Pos   = 0x0    // Position of MFD field.
	EMAC_IMR_MFD_Msk   = 0x1    // Bit mask of MFD field.
	EMAC_IMR_MFD       = 0x1    // Bit MFD.
	EMAC_IMR_RCOMP_Pos = 0x1    // Position of RCOMP field.
	EMAC_IMR_RCOMP_Msk = 0x2    // Bit mask of RCOMP field.
	EMAC_IMR_RCOMP     = 0x2    // Bit RCOMP.
	EMAC_IMR_RXUBR_Pos = 0x2    // Position of RXUBR field.
	EMAC_IMR_RXUBR_Msk = 0x4    // Bit mask of RXUBR field.
	EMAC_IMR_RXUBR     = 0x4    // Bit RXUBR.
	EMAC_IMR_TXUBR_Pos = 0x3    // Position of TXUBR field.
	EMAC_IMR_TXUBR_Msk = 0x8    // Bit mask of TXUBR field.
	EMAC_IMR_TXUBR     = 0x8    // Bit TXUBR.
	EMAC_IMR_TUND_Pos  = 0x4    // Position of TUND field.
	EMAC_IMR_TUND_Msk  = 0x10   // Bit mask of TUND field.
	EMAC_IMR_TUND      = 0x10   // Bit TUND.
	EMAC_IMR_RLE_Pos   = 0x5    // Position of RLE field.
	EMAC_IMR_RLE_Msk   = 0x20   // Bit mask of RLE field.
	EMAC_IMR_RLE       = 0x20   // Bit RLE.
	EMAC_IMR_TXERR_Pos = 0x6    // Position of TXERR field.
	EMAC_IMR_TXERR_Msk = 0x40   // Bit mask of TXERR field.
	EMAC_IMR_TXERR     = 0x40   // Bit TXERR.
	EMAC_IMR_TCOMP_Pos = 0x7    // Position of TCOMP field.
	EMAC_IMR_TCOMP_Msk = 0x80   // Bit mask of TCOMP field.
	EMAC_IMR_TCOMP     = 0x80   // Bit TCOMP.
	EMAC_IMR_ROVR_Pos  = 0xa    // Position of ROVR field.
	EMAC_IMR_ROVR_Msk  = 0x400  // Bit mask of ROVR field.
	EMAC_IMR_ROVR      = 0x400  // Bit ROVR.
	EMAC_IMR_HRESP_Pos = 0xb    // Position of HRESP field.
	EMAC_IMR_HRESP_Msk = 0x800  // Bit mask of HRESP field.
	EMAC_IMR_HRESP     = 0x800  // Bit HRESP.
	EMAC_IMR_PFR_Pos   = 0xc    // Position of PFR field.
	EMAC_IMR_PFR_Msk   = 0x1000 // Bit mask of PFR field.
	EMAC_IMR_PFR       = 0x1000 // Bit PFR.
	EMAC_IMR_PTZ_Pos   = 0xd    // Position of PTZ field.
	EMAC_IMR_PTZ_Msk   = 0x2000 // Bit mask of PTZ field.
	EMAC_IMR_PTZ       = 0x2000 // Bit PTZ.

	// MAN: Phy Maintenance Register
	EMAC_MAN_DATA_Pos = 0x0        // Position of DATA field.
	EMAC_MAN_DATA_Msk = 0xffff     // Bit mask of DATA field.
	EMAC_MAN_CODE_Pos = 0x10       // Position of CODE field.
	EMAC_MAN_CODE_Msk = 0x30000    // Bit mask of CODE field.
	EMAC_MAN_REGA_Pos = 0x12       // Position of REGA field.
	EMAC_MAN_REGA_Msk = 0x7c0000   // Bit mask of REGA field.
	EMAC_MAN_PHYA_Pos = 0x17       // Position of PHYA field.
	EMAC_MAN_PHYA_Msk = 0xf800000  // Bit mask of PHYA field.
	EMAC_MAN_RW_Pos   = 0x1c       // Position of RW field.
	EMAC_MAN_RW_Msk   = 0x30000000 // Bit mask of RW field.
	EMAC_MAN_SOF_Pos  = 0x1e       // Position of SOF field.
	EMAC_MAN_SOF_Msk  = 0xc0000000 // Bit mask of SOF field.

	// PTR: Pause Time Register
	EMAC_PTR_PTIME_Pos = 0x0    // Position of PTIME field.
	EMAC_PTR_PTIME_Msk = 0xffff // Bit mask of PTIME field.

	// PFR: Pause Frames Received Register
	EMAC_PFR_FROK_Pos = 0x0    // Position of FROK field.
	EMAC_PFR_FROK_Msk = 0xffff // Bit mask of FROK field.

	// FTO: Frames Transmitted Ok Register
	EMAC_FTO_FTOK_Pos = 0x0      // Position of FTOK field.
	EMAC_FTO_FTOK_Msk = 0xffffff // Bit mask of FTOK field.

	// SCF: Single Collision Frames Register
	EMAC_SCF_SCF_Pos = 0x0    // Position of SCF field.
	EMAC_SCF_SCF_Msk = 0xffff // Bit mask of SCF field.

	// MCF: Multiple Collision Frames Register
	EMAC_MCF_MCF_Pos = 0x0    // Position of MCF field.
	EMAC_MCF_MCF_Msk = 0xffff // Bit mask of MCF field.

	// FRO: Frames Received Ok Register
	EMAC_FRO_FROK_Pos = 0x0      // Position of FROK field.
	EMAC_FRO_FROK_Msk = 0xffffff // Bit mask of FROK field.

	// FCSE: Frame Check Sequence Errors Register
	EMAC_FCSE_FCSE_Pos = 0x0  // Position of FCSE field.
	EMAC_FCSE_FCSE_Msk = 0xff // Bit mask of FCSE field.

	// ALE: Alignment Errors Register
	EMAC_ALE_ALE_Pos = 0x0  // Position of ALE field.
	EMAC_ALE_ALE_Msk = 0xff // Bit mask of ALE field.

	// DTF: Deferred Transmission Frames Register
	EMAC_DTF_DTF_Pos = 0x0    // Position of DTF field.
	EMAC_DTF_DTF_Msk = 0xffff // Bit mask of DTF field.

	// LCOL: Late Collisions Register
	EMAC_LCOL_LCOL_Pos = 0x0  // Position of LCOL field.
	EMAC_LCOL_LCOL_Msk = 0xff // Bit mask of LCOL field.

	// ECOL: Excessive Collisions Register
	EMAC_ECOL_EXCOL_Pos = 0x0  // Position of EXCOL field.
	EMAC_ECOL_EXCOL_Msk = 0xff // Bit mask of EXCOL field.

	// TUND: Transmit Underrun Errors Register
	EMAC_TUND_TUND_Pos = 0x0  // Position of TUND field.
	EMAC_TUND_TUND_Msk = 0xff // Bit mask of TUND field.

	// CSE: Carrier Sense Errors Register
	EMAC_CSE_CSE_Pos = 0x0  // Position of CSE field.
	EMAC_CSE_CSE_Msk = 0xff // Bit mask of CSE field.

	// RRE: Receive Resource Errors Register
	EMAC_RRE_RRE_Pos = 0x0    // Position of RRE field.
	EMAC_RRE_RRE_Msk = 0xffff // Bit mask of RRE field.

	// ROV: Receive Overrun Errors Register
	EMAC_ROV_ROVR_Pos = 0x0  // Position of ROVR field.
	EMAC_ROV_ROVR_Msk = 0xff // Bit mask of ROVR field.

	// RSE: Receive Symbol Errors Register
	EMAC_RSE_RSE_Pos = 0x0  // Position of RSE field.
	EMAC_RSE_RSE_Msk = 0xff // Bit mask of RSE field.

	// ELE: Excessive Length Errors Register
	EMAC_ELE_EXL_Pos = 0x0  // Position of EXL field.
	EMAC_ELE_EXL_Msk = 0xff // Bit mask of EXL field.

	// RJA: Receive Jabbers Register
	EMAC_RJA_RJB_Pos = 0x0  // Position of RJB field.
	EMAC_RJA_RJB_Msk = 0xff // Bit mask of RJB field.

	// USF: Undersize Frames Register
	EMAC_USF_USF_Pos = 0x0  // Position of USF field.
	EMAC_USF_USF_Msk = 0xff // Bit mask of USF field.

	// STE: SQE Test Errors Register
	EMAC_STE_SQER_Pos = 0x0  // Position of SQER field.
	EMAC_STE_SQER_Msk = 0xff // Bit mask of SQER field.

	// RLE: Received Length Field Mismatch Register
	EMAC_RLE_RLFM_Pos = 0x0  // Position of RLFM field.
	EMAC_RLE_RLFM_Msk = 0xff // Bit mask of RLFM field.

	// HRB: Hash Register Bottom [31:0] Register
	EMAC_HRB_ADDR_Pos = 0x0        // Position of ADDR field.
	EMAC_HRB_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// HRT: Hash Register Top [63:32] Register
	EMAC_HRT_ADDR_Pos = 0x0        // Position of ADDR field.
	EMAC_HRT_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// SA1B: Specific Address 1 Bottom Register
	EMAC_SA1B_ADDR_Pos = 0x0        // Position of ADDR field.
	EMAC_SA1B_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// SA1T: Specific Address 1 Top Register
	EMAC_SA1T_ADDR_Pos = 0x0    // Position of ADDR field.
	EMAC_SA1T_ADDR_Msk = 0xffff // Bit mask of ADDR field.

	// SA2B: Specific Address 2 Bottom Register
	EMAC_SA2B_ADDR_Pos = 0x0        // Position of ADDR field.
	EMAC_SA2B_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// SA2T: Specific Address 2 Top Register
	EMAC_SA2T_ADDR_Pos = 0x0    // Position of ADDR field.
	EMAC_SA2T_ADDR_Msk = 0xffff // Bit mask of ADDR field.

	// SA3B: Specific Address 3 Bottom Register
	EMAC_SA3B_ADDR_Pos = 0x0        // Position of ADDR field.
	EMAC_SA3B_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// SA3T: Specific Address 3 Top Register
	EMAC_SA3T_ADDR_Pos = 0x0    // Position of ADDR field.
	EMAC_SA3T_ADDR_Msk = 0xffff // Bit mask of ADDR field.

	// SA4B: Specific Address 4 Bottom Register
	EMAC_SA4B_ADDR_Pos = 0x0        // Position of ADDR field.
	EMAC_SA4B_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// SA4T: Specific Address 4 Top Register
	EMAC_SA4T_ADDR_Pos = 0x0    // Position of ADDR field.
	EMAC_SA4T_ADDR_Msk = 0xffff // Bit mask of ADDR field.

	// TID: Type ID Checking Register
	EMAC_TID_TID_Pos = 0x0    // Position of TID field.
	EMAC_TID_TID_Msk = 0xffff // Bit mask of TID field.

	// USRIO: User Input/Output Register
	EMAC_USRIO_RMII_Pos  = 0x0 // Position of RMII field.
	EMAC_USRIO_RMII_Msk  = 0x1 // Bit mask of RMII field.
	EMAC_USRIO_RMII      = 0x1 // Bit RMII.
	EMAC_USRIO_CLKEN_Pos = 0x1 // Position of CLKEN field.
	EMAC_USRIO_CLKEN_Msk = 0x2 // Bit mask of CLKEN field.
	EMAC_USRIO_CLKEN     = 0x2 // Bit CLKEN.
)

// Bitfields for PWM: Pulse Width Modulation Controller
const (
	// MR: PWM Mode Register
	PWM_MR_DIVA_Pos        = 0x0       // Position of DIVA field.
	PWM_MR_DIVA_Msk        = 0xff      // Bit mask of DIVA field.
	PWM_MR_DIVA_CLK_OFF    = 0x0       // CLKA, CLKB clock is turned off
	PWM_MR_DIVA_CLK_DIV1   = 0x1       // CLKA, CLKB clock is clock selected by PREA, PREB
	PWM_MR_PREA_Pos        = 0x8       // Position of PREA field.
	PWM_MR_PREA_Msk        = 0xf00     // Bit mask of PREA field.
	PWM_MR_PREA_MCK        = 0x0       // Master Clock
	PWM_MR_PREA_MCKDIV2    = 0x1       // Master Clock divided by 2
	PWM_MR_PREA_MCKDIV4    = 0x2       // Master Clock divided by 4
	PWM_MR_PREA_MCKDIV8    = 0x3       // Master Clock divided by 8
	PWM_MR_PREA_MCKDIV16   = 0x4       // Master Clock divided by 16
	PWM_MR_PREA_MCKDIV32   = 0x5       // Master Clock divided by 32
	PWM_MR_PREA_MCKDIV64   = 0x6       // Master Clock divided by 64
	PWM_MR_PREA_MCKDIV128  = 0x7       // Master Clock divided by 128
	PWM_MR_PREA_MCKDIV256  = 0x8       // Master Clock divided by 256
	PWM_MR_PREA_MCKDIV512  = 0x9       // Master Clock divided by 512
	PWM_MR_PREA_MCKDIV1024 = 0xa       // Master Clock divided by 1024
	PWM_MR_DIVB_Pos        = 0x10      // Position of DIVB field.
	PWM_MR_DIVB_Msk        = 0xff0000  // Bit mask of DIVB field.
	PWM_MR_DIVB_CLK_OFF    = 0x0       // CLKA, CLKB clock is turned off
	PWM_MR_DIVB_CLK_DIV1   = 0x1       // CLKA, CLKB clock is clock selected by PREA, PREB
	PWM_MR_PREB_Pos        = 0x18      // Position of PREB field.
	PWM_MR_PREB_Msk        = 0xf000000 // Bit mask of PREB field.
	PWM_MR_PREB_MCK        = 0x0       // Master Clock
	PWM_MR_PREB_MCKDIV2    = 0x1       // Master Clock divided by 2
	PWM_MR_PREB_MCKDIV4    = 0x2       // Master Clock divided by 4
	PWM_MR_PREB_MCKDIV8    = 0x3       // Master Clock divided by 8
	PWM_MR_PREB_MCKDIV16   = 0x4       // Master Clock divided by 16
	PWM_MR_PREB_MCKDIV32   = 0x5       // Master Clock divided by 32
	PWM_MR_PREB_MCKDIV64   = 0x6       // Master Clock divided by 64
	PWM_MR_PREB_MCKDIV128  = 0x7       // Master Clock divided by 128
	PWM_MR_PREB_MCKDIV256  = 0x8       // Master Clock divided by 256
	PWM_MR_PREB_MCKDIV512  = 0x9       // Master Clock divided by 512
	PWM_MR_PREB_MCKDIV1024 = 0xa       // Master Clock divided by 1024

	// ENA: PWM Enable Register
	PWM_ENA_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_ENA_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_ENA_CHID0     = 0x1 // Bit CHID0.
	PWM_ENA_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_ENA_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_ENA_CHID1     = 0x2 // Bit CHID1.
	PWM_ENA_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_ENA_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_ENA_CHID2     = 0x4 // Bit CHID2.
	PWM_ENA_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_ENA_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_ENA_CHID3     = 0x8 // Bit CHID3.

	// DIS: PWM Disable Register
	PWM_DIS_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_DIS_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_DIS_CHID0     = 0x1 // Bit CHID0.
	PWM_DIS_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_DIS_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_DIS_CHID1     = 0x2 // Bit CHID1.
	PWM_DIS_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_DIS_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_DIS_CHID2     = 0x4 // Bit CHID2.
	PWM_DIS_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_DIS_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_DIS_CHID3     = 0x8 // Bit CHID3.

	// SR: PWM Status Register
	PWM_SR_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_SR_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_SR_CHID0     = 0x1 // Bit CHID0.
	PWM_SR_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_SR_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_SR_CHID1     = 0x2 // Bit CHID1.
	PWM_SR_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_SR_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_SR_CHID2     = 0x4 // Bit CHID2.
	PWM_SR_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_SR_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_SR_CHID3     = 0x8 // Bit CHID3.

	// IER: PWM Interrupt Enable Register
	PWM_IER_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_IER_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_IER_CHID0     = 0x1 // Bit CHID0.
	PWM_IER_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_IER_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_IER_CHID1     = 0x2 // Bit CHID1.
	PWM_IER_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_IER_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_IER_CHID2     = 0x4 // Bit CHID2.
	PWM_IER_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_IER_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_IER_CHID3     = 0x8 // Bit CHID3.

	// IDR: PWM Interrupt Disable Register
	PWM_IDR_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_IDR_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_IDR_CHID0     = 0x1 // Bit CHID0.
	PWM_IDR_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_IDR_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_IDR_CHID1     = 0x2 // Bit CHID1.
	PWM_IDR_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_IDR_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_IDR_CHID2     = 0x4 // Bit CHID2.
	PWM_IDR_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_IDR_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_IDR_CHID3     = 0x8 // Bit CHID3.

	// IMR: PWM Interrupt Mask Register
	PWM_IMR_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_IMR_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_IMR_CHID0     = 0x1 // Bit CHID0.
	PWM_IMR_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_IMR_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_IMR_CHID1     = 0x2 // Bit CHID1.
	PWM_IMR_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_IMR_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_IMR_CHID2     = 0x4 // Bit CHID2.
	PWM_IMR_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_IMR_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_IMR_CHID3     = 0x8 // Bit CHID3.

	// ISR: PWM Interrupt Status Register
	PWM_ISR_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_ISR_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_ISR_CHID0     = 0x1 // Bit CHID0.
	PWM_ISR_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_ISR_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_ISR_CHID1     = 0x2 // Bit CHID1.
	PWM_ISR_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_ISR_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_ISR_CHID2     = 0x4 // Bit CHID2.
	PWM_ISR_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_ISR_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_ISR_CHID3     = 0x8 // Bit CHID3.

	// CMR0: PWM Channel Mode Register (ch_num = 0)
	PWM_CMR0_CPRE_Pos        = 0x0   // Position of CPRE field.
	PWM_CMR0_CPRE_Msk        = 0xf   // Bit mask of CPRE field.
	PWM_CMR0_CPRE_MCK        = 0x0   // Master Clock
	PWM_CMR0_CPRE_MCKDIV2    = 0x1   // Master Clock divided by 2
	PWM_CMR0_CPRE_MCKDIV4    = 0x2   // Master Clock divided by 4
	PWM_CMR0_CPRE_MCKDIV8    = 0x3   // Master Clock divided by 8
	PWM_CMR0_CPRE_MCKDIV16   = 0x4   // Master Clock divided by 16
	PWM_CMR0_CPRE_MCKDIV32   = 0x5   // Master Clock divided by 32
	PWM_CMR0_CPRE_MCKDIV64   = 0x6   // Master Clock divided by 64
	PWM_CMR0_CPRE_MCKDIV128  = 0x7   // Master Clock divided by 128
	PWM_CMR0_CPRE_MCKDIV256  = 0x8   // Master Clock divided by 256
	PWM_CMR0_CPRE_MCKDIV512  = 0x9   // Master Clock divided by 512
	PWM_CMR0_CPRE_MCKDIV1024 = 0xa   // Master Clock divided by 1024
	PWM_CMR0_CPRE_CLKA       = 0xb   // Clock A
	PWM_CMR0_CPRE_CLKB       = 0xc   // Clock B
	PWM_CMR0_CALG_Pos        = 0x8   // Position of CALG field.
	PWM_CMR0_CALG_Msk        = 0x100 // Bit mask of CALG field.
	PWM_CMR0_CALG            = 0x100 // Bit CALG.
	PWM_CMR0_CPOL_Pos        = 0x9   // Position of CPOL field.
	PWM_CMR0_CPOL_Msk        = 0x200 // Bit mask of CPOL field.
	PWM_CMR0_CPOL            = 0x200 // Bit CPOL.
	PWM_CMR0_CPD_Pos         = 0xa   // Position of CPD field.
	PWM_CMR0_CPD_Msk         = 0x400 // Bit mask of CPD field.
	PWM_CMR0_CPD             = 0x400 // Bit CPD.

	// CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
	PWM_CDTY0_CDTY_Pos = 0x0        // Position of CDTY field.
	PWM_CDTY0_CDTY_Msk = 0xffffffff // Bit mask of CDTY field.

	// CPRD0: PWM Channel Period Register (ch_num = 0)
	PWM_CPRD0_CPRD_Pos = 0x0        // Position of CPRD field.
	PWM_CPRD0_CPRD_Msk = 0xffffffff // Bit mask of CPRD field.

	// CCNT0: PWM Channel Counter Register (ch_num = 0)
	PWM_CCNT0_CNT_Pos = 0x0        // Position of CNT field.
	PWM_CCNT0_CNT_Msk = 0xffffffff // Bit mask of CNT field.

	// CUPD0: PWM Channel Update Register (ch_num = 0)
	PWM_CUPD0_CUPD_Pos = 0x0        // Position of CUPD field.
	PWM_CUPD0_CUPD_Msk = 0xffffffff // Bit mask of CUPD field.

	// CMR1: PWM Channel Mode Register (ch_num = 1)
	PWM_CMR1_CPRE_Pos        = 0x0   // Position of CPRE field.
	PWM_CMR1_CPRE_Msk        = 0xf   // Bit mask of CPRE field.
	PWM_CMR1_CPRE_MCK        = 0x0   // Master Clock
	PWM_CMR1_CPRE_MCKDIV2    = 0x1   // Master Clock divided by 2
	PWM_CMR1_CPRE_MCKDIV4    = 0x2   // Master Clock divided by 4
	PWM_CMR1_CPRE_MCKDIV8    = 0x3   // Master Clock divided by 8
	PWM_CMR1_CPRE_MCKDIV16   = 0x4   // Master Clock divided by 16
	PWM_CMR1_CPRE_MCKDIV32   = 0x5   // Master Clock divided by 32
	PWM_CMR1_CPRE_MCKDIV64   = 0x6   // Master Clock divided by 64
	PWM_CMR1_CPRE_MCKDIV128  = 0x7   // Master Clock divided by 128
	PWM_CMR1_CPRE_MCKDIV256  = 0x8   // Master Clock divided by 256
	PWM_CMR1_CPRE_MCKDIV512  = 0x9   // Master Clock divided by 512
	PWM_CMR1_CPRE_MCKDIV1024 = 0xa   // Master Clock divided by 1024
	PWM_CMR1_CPRE_CLKA       = 0xb   // Clock A
	PWM_CMR1_CPRE_CLKB       = 0xc   // Clock B
	PWM_CMR1_CALG_Pos        = 0x8   // Position of CALG field.
	PWM_CMR1_CALG_Msk        = 0x100 // Bit mask of CALG field.
	PWM_CMR1_CALG            = 0x100 // Bit CALG.
	PWM_CMR1_CPOL_Pos        = 0x9   // Position of CPOL field.
	PWM_CMR1_CPOL_Msk        = 0x200 // Bit mask of CPOL field.
	PWM_CMR1_CPOL            = 0x200 // Bit CPOL.
	PWM_CMR1_CPD_Pos         = 0xa   // Position of CPD field.
	PWM_CMR1_CPD_Msk         = 0x400 // Bit mask of CPD field.
	PWM_CMR1_CPD             = 0x400 // Bit CPD.

	// CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
	PWM_CDTY1_CDTY_Pos = 0x0        // Position of CDTY field.
	PWM_CDTY1_CDTY_Msk = 0xffffffff // Bit mask of CDTY field.

	// CPRD1: PWM Channel Period Register (ch_num = 1)
	PWM_CPRD1_CPRD_Pos = 0x0        // Position of CPRD field.
	PWM_CPRD1_CPRD_Msk = 0xffffffff // Bit mask of CPRD field.

	// CCNT1: PWM Channel Counter Register (ch_num = 1)
	PWM_CCNT1_CNT_Pos = 0x0        // Position of CNT field.
	PWM_CCNT1_CNT_Msk = 0xffffffff // Bit mask of CNT field.

	// CUPD1: PWM Channel Update Register (ch_num = 1)
	PWM_CUPD1_CUPD_Pos = 0x0        // Position of CUPD field.
	PWM_CUPD1_CUPD_Msk = 0xffffffff // Bit mask of CUPD field.

	// CMR2: PWM Channel Mode Register (ch_num = 2)
	PWM_CMR2_CPRE_Pos        = 0x0   // Position of CPRE field.
	PWM_CMR2_CPRE_Msk        = 0xf   // Bit mask of CPRE field.
	PWM_CMR2_CPRE_MCK        = 0x0   // Master Clock
	PWM_CMR2_CPRE_MCKDIV2    = 0x1   // Master Clock divided by 2
	PWM_CMR2_CPRE_MCKDIV4    = 0x2   // Master Clock divided by 4
	PWM_CMR2_CPRE_MCKDIV8    = 0x3   // Master Clock divided by 8
	PWM_CMR2_CPRE_MCKDIV16   = 0x4   // Master Clock divided by 16
	PWM_CMR2_CPRE_MCKDIV32   = 0x5   // Master Clock divided by 32
	PWM_CMR2_CPRE_MCKDIV64   = 0x6   // Master Clock divided by 64
	PWM_CMR2_CPRE_MCKDIV128  = 0x7   // Master Clock divided by 128
	PWM_CMR2_CPRE_MCKDIV256  = 0x8   // Master Clock divided by 256
	PWM_CMR2_CPRE_MCKDIV512  = 0x9   // Master Clock divided by 512
	PWM_CMR2_CPRE_MCKDIV1024 = 0xa   // Master Clock divided by 1024
	PWM_CMR2_CPRE_CLKA       = 0xb   // Clock A
	PWM_CMR2_CPRE_CLKB       = 0xc   // Clock B
	PWM_CMR2_CALG_Pos        = 0x8   // Position of CALG field.
	PWM_CMR2_CALG_Msk        = 0x100 // Bit mask of CALG field.
	PWM_CMR2_CALG            = 0x100 // Bit CALG.
	PWM_CMR2_CPOL_Pos        = 0x9   // Position of CPOL field.
	PWM_CMR2_CPOL_Msk        = 0x200 // Bit mask of CPOL field.
	PWM_CMR2_CPOL            = 0x200 // Bit CPOL.
	PWM_CMR2_CPD_Pos         = 0xa   // Position of CPD field.
	PWM_CMR2_CPD_Msk         = 0x400 // Bit mask of CPD field.
	PWM_CMR2_CPD             = 0x400 // Bit CPD.

	// CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
	PWM_CDTY2_CDTY_Pos = 0x0        // Position of CDTY field.
	PWM_CDTY2_CDTY_Msk = 0xffffffff // Bit mask of CDTY field.

	// CPRD2: PWM Channel Period Register (ch_num = 2)
	PWM_CPRD2_CPRD_Pos = 0x0        // Position of CPRD field.
	PWM_CPRD2_CPRD_Msk = 0xffffffff // Bit mask of CPRD field.

	// CCNT2: PWM Channel Counter Register (ch_num = 2)
	PWM_CCNT2_CNT_Pos = 0x0        // Position of CNT field.
	PWM_CCNT2_CNT_Msk = 0xffffffff // Bit mask of CNT field.

	// CUPD2: PWM Channel Update Register (ch_num = 2)
	PWM_CUPD2_CUPD_Pos = 0x0        // Position of CUPD field.
	PWM_CUPD2_CUPD_Msk = 0xffffffff // Bit mask of CUPD field.

	// CMR3: PWM Channel Mode Register (ch_num = 3)
	PWM_CMR3_CPRE_Pos        = 0x0   // Position of CPRE field.
	PWM_CMR3_CPRE_Msk        = 0xf   // Bit mask of CPRE field.
	PWM_CMR3_CPRE_MCK        = 0x0   // Master Clock
	PWM_CMR3_CPRE_MCKDIV2    = 0x1   // Master Clock divided by 2
	PWM_CMR3_CPRE_MCKDIV4    = 0x2   // Master Clock divided by 4
	PWM_CMR3_CPRE_MCKDIV8    = 0x3   // Master Clock divided by 8
	PWM_CMR3_CPRE_MCKDIV16   = 0x4   // Master Clock divided by 16
	PWM_CMR3_CPRE_MCKDIV32   = 0x5   // Master Clock divided by 32
	PWM_CMR3_CPRE_MCKDIV64   = 0x6   // Master Clock divided by 64
	PWM_CMR3_CPRE_MCKDIV128  = 0x7   // Master Clock divided by 128
	PWM_CMR3_CPRE_MCKDIV256  = 0x8   // Master Clock divided by 256
	PWM_CMR3_CPRE_MCKDIV512  = 0x9   // Master Clock divided by 512
	PWM_CMR3_CPRE_MCKDIV1024 = 0xa   // Master Clock divided by 1024
	PWM_CMR3_CPRE_CLKA       = 0xb   // Clock A
	PWM_CMR3_CPRE_CLKB       = 0xc   // Clock B
	PWM_CMR3_CALG_Pos        = 0x8   // Position of CALG field.
	PWM_CMR3_CALG_Msk        = 0x100 // Bit mask of CALG field.
	PWM_CMR3_CALG            = 0x100 // Bit CALG.
	PWM_CMR3_CPOL_Pos        = 0x9   // Position of CPOL field.
	PWM_CMR3_CPOL_Msk        = 0x200 // Bit mask of CPOL field.
	PWM_CMR3_CPOL            = 0x200 // Bit CPOL.
	PWM_CMR3_CPD_Pos         = 0xa   // Position of CPD field.
	PWM_CMR3_CPD_Msk         = 0x400 // Bit mask of CPD field.
	PWM_CMR3_CPD             = 0x400 // Bit CPD.

	// CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
	PWM_CDTY3_CDTY_Pos = 0x0        // Position of CDTY field.
	PWM_CDTY3_CDTY_Msk = 0xffffffff // Bit mask of CDTY field.

	// CPRD3: PWM Channel Period Register (ch_num = 3)
	PWM_CPRD3_CPRD_Pos = 0x0        // Position of CPRD field.
	PWM_CPRD3_CPRD_Msk = 0xffffffff // Bit mask of CPRD field.

	// CCNT3: PWM Channel Counter Register (ch_num = 3)
	PWM_CCNT3_CNT_Pos = 0x0        // Position of CNT field.
	PWM_CCNT3_CNT_Msk = 0xffffffff // Bit mask of CNT field.

	// CUPD3: PWM Channel Update Register (ch_num = 3)
	PWM_CUPD3_CUPD_Pos = 0x0        // Position of CUPD field.
	PWM_CUPD3_CUPD_Msk = 0xffffffff // Bit mask of CUPD field.
)

// Bitfields for LCDC: LCD Controller
const (
	// LCDCFG0: LCD Controller Configuration Register 0
	LCDC_LCDCFG0_CLKPOL_Pos    = 0x0      // Position of CLKPOL field.
	LCDC_LCDCFG0_CLKPOL_Msk    = 0x1      // Bit mask of CLKPOL field.
	LCDC_LCDCFG0_CLKPOL        = 0x1      // Bit CLKPOL.
	LCDC_LCDCFG0_CLKSEL_Pos    = 0x2      // Position of CLKSEL field.
	LCDC_LCDCFG0_CLKSEL_Msk    = 0x4      // Bit mask of CLKSEL field.
	LCDC_LCDCFG0_CLKSEL        = 0x4      // Bit CLKSEL.
	LCDC_LCDCFG0_CLKPWMSEL_Pos = 0x3      // Position of CLKPWMSEL field.
	LCDC_LCDCFG0_CLKPWMSEL_Msk = 0x8      // Bit mask of CLKPWMSEL field.
	LCDC_LCDCFG0_CLKPWMSEL     = 0x8      // Bit CLKPWMSEL.
	LCDC_LCDCFG0_CGDISBASE_Pos = 0x8      // Position of CGDISBASE field.
	LCDC_LCDCFG0_CGDISBASE_Msk = 0x100    // Bit mask of CGDISBASE field.
	LCDC_LCDCFG0_CGDISBASE     = 0x100    // Bit CGDISBASE.
	LCDC_LCDCFG0_CGDISOVR1_Pos = 0x9      // Position of CGDISOVR1 field.
	LCDC_LCDCFG0_CGDISOVR1_Msk = 0x200    // Bit mask of CGDISOVR1 field.
	LCDC_LCDCFG0_CGDISOVR1     = 0x200    // Bit CGDISOVR1.
	LCDC_LCDCFG0_CGDISHEO_Pos  = 0xb      // Position of CGDISHEO field.
	LCDC_LCDCFG0_CGDISHEO_Msk  = 0x800    // Bit mask of CGDISHEO field.
	LCDC_LCDCFG0_CGDISHEO      = 0x800    // Bit CGDISHEO.
	LCDC_LCDCFG0_CGDISHCR_Pos  = 0xc      // Position of CGDISHCR field.
	LCDC_LCDCFG0_CGDISHCR_Msk  = 0x1000   // Bit mask of CGDISHCR field.
	LCDC_LCDCFG0_CGDISHCR      = 0x1000   // Bit CGDISHCR.
	LCDC_LCDCFG0_CLKDIV_Pos    = 0x10     // Position of CLKDIV field.
	LCDC_LCDCFG0_CLKDIV_Msk    = 0xff0000 // Bit mask of CLKDIV field.

	// LCDCFG1: LCD Controller Configuration Register 1
	LCDC_LCDCFG1_HSPW_Pos = 0x0      // Position of HSPW field.
	LCDC_LCDCFG1_HSPW_Msk = 0x3f     // Bit mask of HSPW field.
	LCDC_LCDCFG1_VSPW_Pos = 0x10     // Position of VSPW field.
	LCDC_LCDCFG1_VSPW_Msk = 0x3f0000 // Bit mask of VSPW field.

	// LCDCFG2: LCD Controller Configuration Register 2
	LCDC_LCDCFG2_VFPW_Pos = 0x0      // Position of VFPW field.
	LCDC_LCDCFG2_VFPW_Msk = 0x3f     // Bit mask of VFPW field.
	LCDC_LCDCFG2_VBPW_Pos = 0x10     // Position of VBPW field.
	LCDC_LCDCFG2_VBPW_Msk = 0x3f0000 // Bit mask of VBPW field.

	// LCDCFG3: LCD Controller Configuration Register 3
	LCDC_LCDCFG3_HFPW_Pos = 0x0      // Position of HFPW field.
	LCDC_LCDCFG3_HFPW_Msk = 0xff     // Bit mask of HFPW field.
	LCDC_LCDCFG3_HBPW_Pos = 0x10     // Position of HBPW field.
	LCDC_LCDCFG3_HBPW_Msk = 0xff0000 // Bit mask of HBPW field.

	// LCDCFG4: LCD Controller Configuration Register 4
	LCDC_LCDCFG4_PPL_Pos = 0x0       // Position of PPL field.
	LCDC_LCDCFG4_PPL_Msk = 0x7ff     // Bit mask of PPL field.
	LCDC_LCDCFG4_RPF_Pos = 0x10      // Position of RPF field.
	LCDC_LCDCFG4_RPF_Msk = 0x7ff0000 // Bit mask of RPF field.

	// LCDCFG5: LCD Controller Configuration Register 5
	LCDC_LCDCFG5_HSPOL_Pos         = 0x0      // Position of HSPOL field.
	LCDC_LCDCFG5_HSPOL_Msk         = 0x1      // Bit mask of HSPOL field.
	LCDC_LCDCFG5_HSPOL             = 0x1      // Bit HSPOL.
	LCDC_LCDCFG5_VSPOL_Pos         = 0x1      // Position of VSPOL field.
	LCDC_LCDCFG5_VSPOL_Msk         = 0x2      // Bit mask of VSPOL field.
	LCDC_LCDCFG5_VSPOL             = 0x2      // Bit VSPOL.
	LCDC_LCDCFG5_VSPDLYS_Pos       = 0x2      // Position of VSPDLYS field.
	LCDC_LCDCFG5_VSPDLYS_Msk       = 0x4      // Bit mask of VSPDLYS field.
	LCDC_LCDCFG5_VSPDLYS           = 0x4      // Bit VSPDLYS.
	LCDC_LCDCFG5_VSPDLYE_Pos       = 0x3      // Position of VSPDLYE field.
	LCDC_LCDCFG5_VSPDLYE_Msk       = 0x8      // Bit mask of VSPDLYE field.
	LCDC_LCDCFG5_VSPDLYE           = 0x8      // Bit VSPDLYE.
	LCDC_LCDCFG5_DISPPOL_Pos       = 0x4      // Position of DISPPOL field.
	LCDC_LCDCFG5_DISPPOL_Msk       = 0x10     // Bit mask of DISPPOL field.
	LCDC_LCDCFG5_DISPPOL           = 0x10     // Bit DISPPOL.
	LCDC_LCDCFG5_DITHER_Pos        = 0x6      // Position of DITHER field.
	LCDC_LCDCFG5_DITHER_Msk        = 0x40     // Bit mask of DITHER field.
	LCDC_LCDCFG5_DITHER            = 0x40     // Bit DITHER.
	LCDC_LCDCFG5_DISPDLY_Pos       = 0x7      // Position of DISPDLY field.
	LCDC_LCDCFG5_DISPDLY_Msk       = 0x80     // Bit mask of DISPDLY field.
	LCDC_LCDCFG5_DISPDLY           = 0x80     // Bit DISPDLY.
	LCDC_LCDCFG5_MODE_Pos          = 0x8      // Position of MODE field.
	LCDC_LCDCFG5_MODE_Msk          = 0x300    // Bit mask of MODE field.
	LCDC_LCDCFG5_MODE_OUTPUT_12BPP = 0x0      // LCD output mode is set to 12 bits per pixel
	LCDC_LCDCFG5_MODE_OUTPUT_16BPP = 0x1      // LCD output mode is set to 16 bits per pixel
	LCDC_LCDCFG5_MODE_OUTPUT_18BPP = 0x2      // LCD output mode is set to 18 bits per pixel
	LCDC_LCDCFG5_MODE_OUTPUT_24BPP = 0x3      // LCD output mode is set to 24 bits per pixel
	LCDC_LCDCFG5_VSPSU_Pos         = 0xc      // Position of VSPSU field.
	LCDC_LCDCFG5_VSPSU_Msk         = 0x1000   // Bit mask of VSPSU field.
	LCDC_LCDCFG5_VSPSU             = 0x1000   // Bit VSPSU.
	LCDC_LCDCFG5_VSPHO_Pos         = 0xd      // Position of VSPHO field.
	LCDC_LCDCFG5_VSPHO_Msk         = 0x2000   // Bit mask of VSPHO field.
	LCDC_LCDCFG5_VSPHO             = 0x2000   // Bit VSPHO.
	LCDC_LCDCFG5_GUARDTIME_Pos     = 0x10     // Position of GUARDTIME field.
	LCDC_LCDCFG5_GUARDTIME_Msk     = 0x1f0000 // Bit mask of GUARDTIME field.

	// LCDCFG6: LCD Controller Configuration Register 6
	LCDC_LCDCFG6_PWMPS_Pos   = 0x0    // Position of PWMPS field.
	LCDC_LCDCFG6_PWMPS_Msk   = 0x7    // Bit mask of PWMPS field.
	LCDC_LCDCFG6_PWMPOL_Pos  = 0x4    // Position of PWMPOL field.
	LCDC_LCDCFG6_PWMPOL_Msk  = 0x10   // Bit mask of PWMPOL field.
	LCDC_LCDCFG6_PWMPOL      = 0x10   // Bit PWMPOL.
	LCDC_LCDCFG6_PWMCVAL_Pos = 0x8    // Position of PWMCVAL field.
	LCDC_LCDCFG6_PWMCVAL_Msk = 0xff00 // Bit mask of PWMCVAL field.

	// LCDEN: LCD Controller Enable Register
	LCDC_LCDEN_CLKEN_Pos  = 0x0 // Position of CLKEN field.
	LCDC_LCDEN_CLKEN_Msk  = 0x1 // Bit mask of CLKEN field.
	LCDC_LCDEN_CLKEN      = 0x1 // Bit CLKEN.
	LCDC_LCDEN_SYNCEN_Pos = 0x1 // Position of SYNCEN field.
	LCDC_LCDEN_SYNCEN_Msk = 0x2 // Bit mask of SYNCEN field.
	LCDC_LCDEN_SYNCEN     = 0x2 // Bit SYNCEN.
	LCDC_LCDEN_DISPEN_Pos = 0x2 // Position of DISPEN field.
	LCDC_LCDEN_DISPEN_Msk = 0x4 // Bit mask of DISPEN field.
	LCDC_LCDEN_DISPEN     = 0x4 // Bit DISPEN.
	LCDC_LCDEN_PWMEN_Pos  = 0x3 // Position of PWMEN field.
	LCDC_LCDEN_PWMEN_Msk  = 0x8 // Bit mask of PWMEN field.
	LCDC_LCDEN_PWMEN      = 0x8 // Bit PWMEN.

	// LCDDIS: LCD Controller Disable Register
	LCDC_LCDDIS_CLKDIS_Pos  = 0x0   // Position of CLKDIS field.
	LCDC_LCDDIS_CLKDIS_Msk  = 0x1   // Bit mask of CLKDIS field.
	LCDC_LCDDIS_CLKDIS      = 0x1   // Bit CLKDIS.
	LCDC_LCDDIS_SYNCDIS_Pos = 0x1   // Position of SYNCDIS field.
	LCDC_LCDDIS_SYNCDIS_Msk = 0x2   // Bit mask of SYNCDIS field.
	LCDC_LCDDIS_SYNCDIS     = 0x2   // Bit SYNCDIS.
	LCDC_LCDDIS_DISPDIS_Pos = 0x2   // Position of DISPDIS field.
	LCDC_LCDDIS_DISPDIS_Msk = 0x4   // Bit mask of DISPDIS field.
	LCDC_LCDDIS_DISPDIS     = 0x4   // Bit DISPDIS.
	LCDC_LCDDIS_PWMDIS_Pos  = 0x3   // Position of PWMDIS field.
	LCDC_LCDDIS_PWMDIS_Msk  = 0x8   // Bit mask of PWMDIS field.
	LCDC_LCDDIS_PWMDIS      = 0x8   // Bit PWMDIS.
	LCDC_LCDDIS_CLKRST_Pos  = 0x8   // Position of CLKRST field.
	LCDC_LCDDIS_CLKRST_Msk  = 0x100 // Bit mask of CLKRST field.
	LCDC_LCDDIS_CLKRST      = 0x100 // Bit CLKRST.
	LCDC_LCDDIS_SYNCRST_Pos = 0x9   // Position of SYNCRST field.
	LCDC_LCDDIS_SYNCRST_Msk = 0x200 // Bit mask of SYNCRST field.
	LCDC_LCDDIS_SYNCRST     = 0x200 // Bit SYNCRST.
	LCDC_LCDDIS_DISPRST_Pos = 0xa   // Position of DISPRST field.
	LCDC_LCDDIS_DISPRST_Msk = 0x400 // Bit mask of DISPRST field.
	LCDC_LCDDIS_DISPRST     = 0x400 // Bit DISPRST.
	LCDC_LCDDIS_PWMRST_Pos  = 0xb   // Position of PWMRST field.
	LCDC_LCDDIS_PWMRST_Msk  = 0x800 // Bit mask of PWMRST field.
	LCDC_LCDDIS_PWMRST      = 0x800 // Bit PWMRST.

	// LCDSR: LCD Controller Status Register
	LCDC_LCDSR_CLKSTS_Pos  = 0x0  // Position of CLKSTS field.
	LCDC_LCDSR_CLKSTS_Msk  = 0x1  // Bit mask of CLKSTS field.
	LCDC_LCDSR_CLKSTS      = 0x1  // Bit CLKSTS.
	LCDC_LCDSR_LCDSTS_Pos  = 0x1  // Position of LCDSTS field.
	LCDC_LCDSR_LCDSTS_Msk  = 0x2  // Bit mask of LCDSTS field.
	LCDC_LCDSR_LCDSTS      = 0x2  // Bit LCDSTS.
	LCDC_LCDSR_DISPSTS_Pos = 0x2  // Position of DISPSTS field.
	LCDC_LCDSR_DISPSTS_Msk = 0x4  // Bit mask of DISPSTS field.
	LCDC_LCDSR_DISPSTS     = 0x4  // Bit DISPSTS.
	LCDC_LCDSR_PWMSTS_Pos  = 0x3  // Position of PWMSTS field.
	LCDC_LCDSR_PWMSTS_Msk  = 0x8  // Bit mask of PWMSTS field.
	LCDC_LCDSR_PWMSTS      = 0x8  // Bit PWMSTS.
	LCDC_LCDSR_SIPSTS_Pos  = 0x4  // Position of SIPSTS field.
	LCDC_LCDSR_SIPSTS_Msk  = 0x10 // Bit mask of SIPSTS field.
	LCDC_LCDSR_SIPSTS      = 0x10 // Bit SIPSTS.

	// LCDIER: LCD Controller Interrupt Enable Register
	LCDC_LCDIER_SOFIE_Pos     = 0x0   // Position of SOFIE field.
	LCDC_LCDIER_SOFIE_Msk     = 0x1   // Bit mask of SOFIE field.
	LCDC_LCDIER_SOFIE         = 0x1   // Bit SOFIE.
	LCDC_LCDIER_DISIE_Pos     = 0x1   // Position of DISIE field.
	LCDC_LCDIER_DISIE_Msk     = 0x2   // Bit mask of DISIE field.
	LCDC_LCDIER_DISIE         = 0x2   // Bit DISIE.
	LCDC_LCDIER_DISPIE_Pos    = 0x2   // Position of DISPIE field.
	LCDC_LCDIER_DISPIE_Msk    = 0x4   // Bit mask of DISPIE field.
	LCDC_LCDIER_DISPIE        = 0x4   // Bit DISPIE.
	LCDC_LCDIER_FIFOERRIE_Pos = 0x4   // Position of FIFOERRIE field.
	LCDC_LCDIER_FIFOERRIE_Msk = 0x10  // Bit mask of FIFOERRIE field.
	LCDC_LCDIER_FIFOERRIE     = 0x10  // Bit FIFOERRIE.
	LCDC_LCDIER_BASEIE_Pos    = 0x8   // Position of BASEIE field.
	LCDC_LCDIER_BASEIE_Msk    = 0x100 // Bit mask of BASEIE field.
	LCDC_LCDIER_BASEIE        = 0x100 // Bit BASEIE.
	LCDC_LCDIER_OVR1IE_Pos    = 0x9   // Position of OVR1IE field.
	LCDC_LCDIER_OVR1IE_Msk    = 0x200 // Bit mask of OVR1IE field.
	LCDC_LCDIER_OVR1IE        = 0x200 // Bit OVR1IE.
	LCDC_LCDIER_HEOIE_Pos     = 0xa   // Position of HEOIE field.
	LCDC_LCDIER_HEOIE_Msk     = 0x400 // Bit mask of HEOIE field.
	LCDC_LCDIER_HEOIE         = 0x400 // Bit HEOIE.
	LCDC_LCDIER_HCRIE_Pos     = 0xb   // Position of HCRIE field.
	LCDC_LCDIER_HCRIE_Msk     = 0x800 // Bit mask of HCRIE field.
	LCDC_LCDIER_HCRIE         = 0x800 // Bit HCRIE.

	// LCDIDR: LCD Controller Interrupt Disable Register
	LCDC_LCDIDR_SOFID_Pos     = 0x0   // Position of SOFID field.
	LCDC_LCDIDR_SOFID_Msk     = 0x1   // Bit mask of SOFID field.
	LCDC_LCDIDR_SOFID         = 0x1   // Bit SOFID.
	LCDC_LCDIDR_DISID_Pos     = 0x1   // Position of DISID field.
	LCDC_LCDIDR_DISID_Msk     = 0x2   // Bit mask of DISID field.
	LCDC_LCDIDR_DISID         = 0x2   // Bit DISID.
	LCDC_LCDIDR_DISPID_Pos    = 0x2   // Position of DISPID field.
	LCDC_LCDIDR_DISPID_Msk    = 0x4   // Bit mask of DISPID field.
	LCDC_LCDIDR_DISPID        = 0x4   // Bit DISPID.
	LCDC_LCDIDR_FIFOERRID_Pos = 0x4   // Position of FIFOERRID field.
	LCDC_LCDIDR_FIFOERRID_Msk = 0x10  // Bit mask of FIFOERRID field.
	LCDC_LCDIDR_FIFOERRID     = 0x10  // Bit FIFOERRID.
	LCDC_LCDIDR_BASEID_Pos    = 0x8   // Position of BASEID field.
	LCDC_LCDIDR_BASEID_Msk    = 0x100 // Bit mask of BASEID field.
	LCDC_LCDIDR_BASEID        = 0x100 // Bit BASEID.
	LCDC_LCDIDR_OVR1ID_Pos    = 0x9   // Position of OVR1ID field.
	LCDC_LCDIDR_OVR1ID_Msk    = 0x200 // Bit mask of OVR1ID field.
	LCDC_LCDIDR_OVR1ID        = 0x200 // Bit OVR1ID.
	LCDC_LCDIDR_HEOID_Pos     = 0xa   // Position of HEOID field.
	LCDC_LCDIDR_HEOID_Msk     = 0x400 // Bit mask of HEOID field.
	LCDC_LCDIDR_HEOID         = 0x400 // Bit HEOID.
	LCDC_LCDIDR_HCRID_Pos     = 0xb   // Position of HCRID field.
	LCDC_LCDIDR_HCRID_Msk     = 0x800 // Bit mask of HCRID field.
	LCDC_LCDIDR_HCRID         = 0x800 // Bit HCRID.

	// LCDIMR: LCD Controller Interrupt Mask Register
	LCDC_LCDIMR_SOFIM_Pos     = 0x0   // Position of SOFIM field.
	LCDC_LCDIMR_SOFIM_Msk     = 0x1   // Bit mask of SOFIM field.
	LCDC_LCDIMR_SOFIM         = 0x1   // Bit SOFIM.
	LCDC_LCDIMR_DISIM_Pos     = 0x1   // Position of DISIM field.
	LCDC_LCDIMR_DISIM_Msk     = 0x2   // Bit mask of DISIM field.
	LCDC_LCDIMR_DISIM         = 0x2   // Bit DISIM.
	LCDC_LCDIMR_DISPIM_Pos    = 0x2   // Position of DISPIM field.
	LCDC_LCDIMR_DISPIM_Msk    = 0x4   // Bit mask of DISPIM field.
	LCDC_LCDIMR_DISPIM        = 0x4   // Bit DISPIM.
	LCDC_LCDIMR_FIFOERRIM_Pos = 0x4   // Position of FIFOERRIM field.
	LCDC_LCDIMR_FIFOERRIM_Msk = 0x10  // Bit mask of FIFOERRIM field.
	LCDC_LCDIMR_FIFOERRIM     = 0x10  // Bit FIFOERRIM.
	LCDC_LCDIMR_BASEIM_Pos    = 0x8   // Position of BASEIM field.
	LCDC_LCDIMR_BASEIM_Msk    = 0x100 // Bit mask of BASEIM field.
	LCDC_LCDIMR_BASEIM        = 0x100 // Bit BASEIM.
	LCDC_LCDIMR_OVR1IM_Pos    = 0x9   // Position of OVR1IM field.
	LCDC_LCDIMR_OVR1IM_Msk    = 0x200 // Bit mask of OVR1IM field.
	LCDC_LCDIMR_OVR1IM        = 0x200 // Bit OVR1IM.
	LCDC_LCDIMR_HEOIM_Pos     = 0xa   // Position of HEOIM field.
	LCDC_LCDIMR_HEOIM_Msk     = 0x400 // Bit mask of HEOIM field.
	LCDC_LCDIMR_HEOIM         = 0x400 // Bit HEOIM.
	LCDC_LCDIMR_HCRIM_Pos     = 0xb   // Position of HCRIM field.
	LCDC_LCDIMR_HCRIM_Msk     = 0x800 // Bit mask of HCRIM field.
	LCDC_LCDIMR_HCRIM         = 0x800 // Bit HCRIM.

	// LCDISR: LCD Controller Interrupt Status Register
	LCDC_LCDISR_SOF_Pos     = 0x0   // Position of SOF field.
	LCDC_LCDISR_SOF_Msk     = 0x1   // Bit mask of SOF field.
	LCDC_LCDISR_SOF         = 0x1   // Bit SOF.
	LCDC_LCDISR_DIS_Pos     = 0x1   // Position of DIS field.
	LCDC_LCDISR_DIS_Msk     = 0x2   // Bit mask of DIS field.
	LCDC_LCDISR_DIS         = 0x2   // Bit DIS.
	LCDC_LCDISR_DISP_Pos    = 0x2   // Position of DISP field.
	LCDC_LCDISR_DISP_Msk    = 0x4   // Bit mask of DISP field.
	LCDC_LCDISR_DISP        = 0x4   // Bit DISP.
	LCDC_LCDISR_FIFOERR_Pos = 0x4   // Position of FIFOERR field.
	LCDC_LCDISR_FIFOERR_Msk = 0x10  // Bit mask of FIFOERR field.
	LCDC_LCDISR_FIFOERR     = 0x10  // Bit FIFOERR.
	LCDC_LCDISR_BASE_Pos    = 0x8   // Position of BASE field.
	LCDC_LCDISR_BASE_Msk    = 0x100 // Bit mask of BASE field.
	LCDC_LCDISR_BASE        = 0x100 // Bit BASE.
	LCDC_LCDISR_OVR1_Pos    = 0x9   // Position of OVR1 field.
	LCDC_LCDISR_OVR1_Msk    = 0x200 // Bit mask of OVR1 field.
	LCDC_LCDISR_OVR1        = 0x200 // Bit OVR1.
	LCDC_LCDISR_HEO_Pos     = 0xa   // Position of HEO field.
	LCDC_LCDISR_HEO_Msk     = 0x400 // Bit mask of HEO field.
	LCDC_LCDISR_HEO         = 0x400 // Bit HEO.
	LCDC_LCDISR_HCR_Pos     = 0xb   // Position of HCR field.
	LCDC_LCDISR_HCR_Msk     = 0x800 // Bit mask of HCR field.
	LCDC_LCDISR_HCR         = 0x800 // Bit HCR.

	// BASECHER: Base Layer Channel Enable Register
	LCDC_BASECHER_CHEN_Pos     = 0x0 // Position of CHEN field.
	LCDC_BASECHER_CHEN_Msk     = 0x1 // Bit mask of CHEN field.
	LCDC_BASECHER_CHEN         = 0x1 // Bit CHEN.
	LCDC_BASECHER_UPDATEEN_Pos = 0x1 // Position of UPDATEEN field.
	LCDC_BASECHER_UPDATEEN_Msk = 0x2 // Bit mask of UPDATEEN field.
	LCDC_BASECHER_UPDATEEN     = 0x2 // Bit UPDATEEN.
	LCDC_BASECHER_A2QEN_Pos    = 0x2 // Position of A2QEN field.
	LCDC_BASECHER_A2QEN_Msk    = 0x4 // Bit mask of A2QEN field.
	LCDC_BASECHER_A2QEN        = 0x4 // Bit A2QEN.

	// BASECHDR: Base Layer Channel Disable Register
	LCDC_BASECHDR_CHDIS_Pos = 0x0   // Position of CHDIS field.
	LCDC_BASECHDR_CHDIS_Msk = 0x1   // Bit mask of CHDIS field.
	LCDC_BASECHDR_CHDIS     = 0x1   // Bit CHDIS.
	LCDC_BASECHDR_CHRST_Pos = 0x8   // Position of CHRST field.
	LCDC_BASECHDR_CHRST_Msk = 0x100 // Bit mask of CHRST field.
	LCDC_BASECHDR_CHRST     = 0x100 // Bit CHRST.

	// BASECHSR: Base Layer Channel Status Register
	LCDC_BASECHSR_CHSR_Pos     = 0x0 // Position of CHSR field.
	LCDC_BASECHSR_CHSR_Msk     = 0x1 // Bit mask of CHSR field.
	LCDC_BASECHSR_CHSR         = 0x1 // Bit CHSR.
	LCDC_BASECHSR_UPDATESR_Pos = 0x1 // Position of UPDATESR field.
	LCDC_BASECHSR_UPDATESR_Msk = 0x2 // Bit mask of UPDATESR field.
	LCDC_BASECHSR_UPDATESR     = 0x2 // Bit UPDATESR.
	LCDC_BASECHSR_A2QSR_Pos    = 0x2 // Position of A2QSR field.
	LCDC_BASECHSR_A2QSR_Msk    = 0x4 // Bit mask of A2QSR field.
	LCDC_BASECHSR_A2QSR        = 0x4 // Bit A2QSR.

	// BASEIER: Base Layer Interrupt Enable Register
	LCDC_BASEIER_DMA_Pos  = 0x2  // Position of DMA field.
	LCDC_BASEIER_DMA_Msk  = 0x4  // Bit mask of DMA field.
	LCDC_BASEIER_DMA      = 0x4  // Bit DMA.
	LCDC_BASEIER_DSCR_Pos = 0x3  // Position of DSCR field.
	LCDC_BASEIER_DSCR_Msk = 0x8  // Bit mask of DSCR field.
	LCDC_BASEIER_DSCR     = 0x8  // Bit DSCR.
	LCDC_BASEIER_ADD_Pos  = 0x4  // Position of ADD field.
	LCDC_BASEIER_ADD_Msk  = 0x10 // Bit mask of ADD field.
	LCDC_BASEIER_ADD      = 0x10 // Bit ADD.
	LCDC_BASEIER_DONE_Pos = 0x5  // Position of DONE field.
	LCDC_BASEIER_DONE_Msk = 0x20 // Bit mask of DONE field.
	LCDC_BASEIER_DONE     = 0x20 // Bit DONE.
	LCDC_BASEIER_OVR_Pos  = 0x6  // Position of OVR field.
	LCDC_BASEIER_OVR_Msk  = 0x40 // Bit mask of OVR field.
	LCDC_BASEIER_OVR      = 0x40 // Bit OVR.

	// BASEIDR: Base Layer Interrupt Disabled Register
	LCDC_BASEIDR_DMA_Pos  = 0x2  // Position of DMA field.
	LCDC_BASEIDR_DMA_Msk  = 0x4  // Bit mask of DMA field.
	LCDC_BASEIDR_DMA      = 0x4  // Bit DMA.
	LCDC_BASEIDR_DSCR_Pos = 0x3  // Position of DSCR field.
	LCDC_BASEIDR_DSCR_Msk = 0x8  // Bit mask of DSCR field.
	LCDC_BASEIDR_DSCR     = 0x8  // Bit DSCR.
	LCDC_BASEIDR_ADD_Pos  = 0x4  // Position of ADD field.
	LCDC_BASEIDR_ADD_Msk  = 0x10 // Bit mask of ADD field.
	LCDC_BASEIDR_ADD      = 0x10 // Bit ADD.
	LCDC_BASEIDR_DONE_Pos = 0x5  // Position of DONE field.
	LCDC_BASEIDR_DONE_Msk = 0x20 // Bit mask of DONE field.
	LCDC_BASEIDR_DONE     = 0x20 // Bit DONE.
	LCDC_BASEIDR_OVR_Pos  = 0x6  // Position of OVR field.
	LCDC_BASEIDR_OVR_Msk  = 0x40 // Bit mask of OVR field.
	LCDC_BASEIDR_OVR      = 0x40 // Bit OVR.

	// BASEIMR: Base Layer Interrupt Mask Register
	LCDC_BASEIMR_DMA_Pos  = 0x2  // Position of DMA field.
	LCDC_BASEIMR_DMA_Msk  = 0x4  // Bit mask of DMA field.
	LCDC_BASEIMR_DMA      = 0x4  // Bit DMA.
	LCDC_BASEIMR_DSCR_Pos = 0x3  // Position of DSCR field.
	LCDC_BASEIMR_DSCR_Msk = 0x8  // Bit mask of DSCR field.
	LCDC_BASEIMR_DSCR     = 0x8  // Bit DSCR.
	LCDC_BASEIMR_ADD_Pos  = 0x4  // Position of ADD field.
	LCDC_BASEIMR_ADD_Msk  = 0x10 // Bit mask of ADD field.
	LCDC_BASEIMR_ADD      = 0x10 // Bit ADD.
	LCDC_BASEIMR_DONE_Pos = 0x5  // Position of DONE field.
	LCDC_BASEIMR_DONE_Msk = 0x20 // Bit mask of DONE field.
	LCDC_BASEIMR_DONE     = 0x20 // Bit DONE.
	LCDC_BASEIMR_OVR_Pos  = 0x6  // Position of OVR field.
	LCDC_BASEIMR_OVR_Msk  = 0x40 // Bit mask of OVR field.
	LCDC_BASEIMR_OVR      = 0x40 // Bit OVR.

	// BASEISR: Base Layer Interrupt status Register
	LCDC_BASEISR_DMA_Pos  = 0x2  // Position of DMA field.
	LCDC_BASEISR_DMA_Msk  = 0x4  // Bit mask of DMA field.
	LCDC_BASEISR_DMA      = 0x4  // Bit DMA.
	LCDC_BASEISR_DSCR_Pos = 0x3  // Position of DSCR field.
	LCDC_BASEISR_DSCR_Msk = 0x8  // Bit mask of DSCR field.
	LCDC_BASEISR_DSCR     = 0x8  // Bit DSCR.
	LCDC_BASEISR_ADD_Pos  = 0x4  // Position of ADD field.
	LCDC_BASEISR_ADD_Msk  = 0x10 // Bit mask of ADD field.
	LCDC_BASEISR_ADD      = 0x10 // Bit ADD.
	LCDC_BASEISR_DONE_Pos = 0x5  // Position of DONE field.
	LCDC_BASEISR_DONE_Msk = 0x20 // Bit mask of DONE field.
	LCDC_BASEISR_DONE     = 0x20 // Bit DONE.
	LCDC_BASEISR_OVR_Pos  = 0x6  // Position of OVR field.
	LCDC_BASEISR_OVR_Msk  = 0x40 // Bit mask of OVR field.
	LCDC_BASEISR_OVR      = 0x40 // Bit OVR.

	// BASEHEAD: Base Layer DMA Head Register
	LCDC_BASEHEAD_HEAD_Pos = 0x2        // Position of HEAD field.
	LCDC_BASEHEAD_HEAD_Msk = 0xfffffffc // Bit mask of HEAD field.

	// BASEADDR: Base Layer DMA Address Register
	LCDC_BASEADDR_ADDR_Pos = 0x0        // Position of ADDR field.
	LCDC_BASEADDR_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// BASECTRL: Base Layer DMA Control Register
	LCDC_BASECTRL_DFETCH_Pos  = 0x0  // Position of DFETCH field.
	LCDC_BASECTRL_DFETCH_Msk  = 0x1  // Bit mask of DFETCH field.
	LCDC_BASECTRL_DFETCH      = 0x1  // Bit DFETCH.
	LCDC_BASECTRL_LFETCH_Pos  = 0x1  // Position of LFETCH field.
	LCDC_BASECTRL_LFETCH_Msk  = 0x2  // Bit mask of LFETCH field.
	LCDC_BASECTRL_LFETCH      = 0x2  // Bit LFETCH.
	LCDC_BASECTRL_DMAIEN_Pos  = 0x2  // Position of DMAIEN field.
	LCDC_BASECTRL_DMAIEN_Msk  = 0x4  // Bit mask of DMAIEN field.
	LCDC_BASECTRL_DMAIEN      = 0x4  // Bit DMAIEN.
	LCDC_BASECTRL_DSCRIEN_Pos = 0x3  // Position of DSCRIEN field.
	LCDC_BASECTRL_DSCRIEN_Msk = 0x8  // Bit mask of DSCRIEN field.
	LCDC_BASECTRL_DSCRIEN     = 0x8  // Bit DSCRIEN.
	LCDC_BASECTRL_ADDIEN_Pos  = 0x4  // Position of ADDIEN field.
	LCDC_BASECTRL_ADDIEN_Msk  = 0x10 // Bit mask of ADDIEN field.
	LCDC_BASECTRL_ADDIEN      = 0x10 // Bit ADDIEN.
	LCDC_BASECTRL_DONEIEN_Pos = 0x5  // Position of DONEIEN field.
	LCDC_BASECTRL_DONEIEN_Msk = 0x20 // Bit mask of DONEIEN field.
	LCDC_BASECTRL_DONEIEN     = 0x20 // Bit DONEIEN.

	// BASENEXT: Base Layer DMA Next Register
	LCDC_BASENEXT_NEXT_Pos = 0x0        // Position of NEXT field.
	LCDC_BASENEXT_NEXT_Msk = 0xffffffff // Bit mask of NEXT field.

	// BASECFG0: Base Layer Configuration Register 0
	LCDC_BASECFG0_BLEN_Pos        = 0x4   // Position of BLEN field.
	LCDC_BASECFG0_BLEN_Msk        = 0x30  // Bit mask of BLEN field.
	LCDC_BASECFG0_BLEN_AHB_SINGLE = 0x0   // AHB Access is started as soon as there is enough space in the FIFO to store one 32-bit data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_BASECFG0_BLEN_AHB_INCR4  = 0x1   // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of four 32-bit data. An AHB INCR4 Burst is preferred. SINGLE, INCR and INCR4 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_BASECFG0_BLEN_AHB_INCR8  = 0x2   // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of eight 32-bit data. An AHB INCR8 Burst is preferred. SINGLE, INCR, INCR4 and INCR8 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_BASECFG0_BLEN_AHB_INCR16 = 0x3   // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of sixteen 32-bit data. An AHB INCR16 Burst is preferred. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_BASECFG0_DLBO_Pos        = 0x8   // Position of DLBO field.
	LCDC_BASECFG0_DLBO_Msk        = 0x100 // Bit mask of DLBO field.
	LCDC_BASECFG0_DLBO            = 0x100 // Bit DLBO.

	// BASECFG1: Base Layer Configuration Register 1
	LCDC_BASECFG1_CLUTEN_Pos                   = 0x0   // Position of CLUTEN field.
	LCDC_BASECFG1_CLUTEN_Msk                   = 0x1   // Bit mask of CLUTEN field.
	LCDC_BASECFG1_CLUTEN                       = 0x1   // Bit CLUTEN.
	LCDC_BASECFG1_RGBMODE_Pos                  = 0x4   // Position of RGBMODE field.
	LCDC_BASECFG1_RGBMODE_Msk                  = 0xf0  // Bit mask of RGBMODE field.
	LCDC_BASECFG1_RGBMODE_12BPP_RGB_444        = 0x0   // 12 bpp RGB 444
	LCDC_BASECFG1_RGBMODE_16BPP_ARGB_4444      = 0x1   // 16 bpp ARGB 4444
	LCDC_BASECFG1_RGBMODE_16BPP_RGBA_4444      = 0x2   // 16 bpp RGBA 4444
	LCDC_BASECFG1_RGBMODE_16BPP_RGB_565        = 0x3   // 16 bpp RGB 565
	LCDC_BASECFG1_RGBMODE_16BPP_TRGB_1555      = 0x4   // 16 bpp TRGB 1555
	LCDC_BASECFG1_RGBMODE_18BPP_RGB_666        = 0x5   // 18 bpp RGB 666
	LCDC_BASECFG1_RGBMODE_18BPP_RGB_666_PACKED = 0x6   // 18 bpp RGB 666 PACKED
	LCDC_BASECFG1_RGBMODE_19BPP_TRGB_1666      = 0x7   // 19 bpp TRGB 1666
	LCDC_BASECFG1_RGBMODE_19BPP_TRGB_PACKED    = 0x8   // 19 bpp TRGB 1666 PACKED
	LCDC_BASECFG1_RGBMODE_24BPP_RGB_888        = 0x9   // 24 bpp RGB 888
	LCDC_BASECFG1_RGBMODE_24BPP_RGB_888_PACKED = 0xa   // 24 bpp RGB 888 PACKED
	LCDC_BASECFG1_RGBMODE_25BPP_TRGB_1888      = 0xb   // 25 bpp TRGB 1888
	LCDC_BASECFG1_RGBMODE_32BPP_ARGB_8888      = 0xc   // 32 bpp ARGB 8888
	LCDC_BASECFG1_RGBMODE_32BPP_RGBA_8888      = 0xd   // 32 bpp RGBA 8888
	LCDC_BASECFG1_CLUTMODE_Pos                 = 0x8   // Position of CLUTMODE field.
	LCDC_BASECFG1_CLUTMODE_Msk                 = 0x300 // Bit mask of CLUTMODE field.
	LCDC_BASECFG1_CLUTMODE_1BPP                = 0x0   // color lookup table mode set to 1 bit per pixel
	LCDC_BASECFG1_CLUTMODE_2BPP                = 0x1   // color lookup table mode set to 2 bits per pixel
	LCDC_BASECFG1_CLUTMODE_4BPP                = 0x2   // color lookup table mode set to 4 bits per pixel
	LCDC_BASECFG1_CLUTMODE_8BPP                = 0x3   // color lookup table mode set to 8 bits per pixel

	// BASECFG2: Base Layer Configuration Register 2
	LCDC_BASECFG2_XSTRIDE_Pos = 0x0        // Position of XSTRIDE field.
	LCDC_BASECFG2_XSTRIDE_Msk = 0xffffffff // Bit mask of XSTRIDE field.

	// BASECFG3: Base Layer Configuration Register 3
	LCDC_BASECFG3_BDEF_Pos = 0x0      // Position of BDEF field.
	LCDC_BASECFG3_BDEF_Msk = 0xff     // Bit mask of BDEF field.
	LCDC_BASECFG3_GDEF_Pos = 0x8      // Position of GDEF field.
	LCDC_BASECFG3_GDEF_Msk = 0xff00   // Bit mask of GDEF field.
	LCDC_BASECFG3_RDEF_Pos = 0x10     // Position of RDEF field.
	LCDC_BASECFG3_RDEF_Msk = 0xff0000 // Bit mask of RDEF field.

	// BASECFG4: Base Layer Configuration Register 4
	LCDC_BASECFG4_DMA_Pos = 0x8   // Position of DMA field.
	LCDC_BASECFG4_DMA_Msk = 0x100 // Bit mask of DMA field.
	LCDC_BASECFG4_DMA     = 0x100 // Bit DMA.
	LCDC_BASECFG4_REP_Pos = 0x9   // Position of REP field.
	LCDC_BASECFG4_REP_Msk = 0x200 // Bit mask of REP field.
	LCDC_BASECFG4_REP     = 0x200 // Bit REP.

	// OVRCHER1: Overlay 1 Channel Enable Register
	LCDC_OVRCHER1_CHEN_Pos     = 0x0 // Position of CHEN field.
	LCDC_OVRCHER1_CHEN_Msk     = 0x1 // Bit mask of CHEN field.
	LCDC_OVRCHER1_CHEN         = 0x1 // Bit CHEN.
	LCDC_OVRCHER1_UPDATEEN_Pos = 0x1 // Position of UPDATEEN field.
	LCDC_OVRCHER1_UPDATEEN_Msk = 0x2 // Bit mask of UPDATEEN field.
	LCDC_OVRCHER1_UPDATEEN     = 0x2 // Bit UPDATEEN.
	LCDC_OVRCHER1_A2QEN_Pos    = 0x2 // Position of A2QEN field.
	LCDC_OVRCHER1_A2QEN_Msk    = 0x4 // Bit mask of A2QEN field.
	LCDC_OVRCHER1_A2QEN        = 0x4 // Bit A2QEN.

	// OVRCHDR1: Overlay 1 Channel Disable Register
	LCDC_OVRCHDR1_CHDIS_Pos = 0x0   // Position of CHDIS field.
	LCDC_OVRCHDR1_CHDIS_Msk = 0x1   // Bit mask of CHDIS field.
	LCDC_OVRCHDR1_CHDIS     = 0x1   // Bit CHDIS.
	LCDC_OVRCHDR1_CHRST_Pos = 0x8   // Position of CHRST field.
	LCDC_OVRCHDR1_CHRST_Msk = 0x100 // Bit mask of CHRST field.
	LCDC_OVRCHDR1_CHRST     = 0x100 // Bit CHRST.

	// OVRCHSR1: Overlay 1 Channel Status Register
	LCDC_OVRCHSR1_CHSR_Pos     = 0x0 // Position of CHSR field.
	LCDC_OVRCHSR1_CHSR_Msk     = 0x1 // Bit mask of CHSR field.
	LCDC_OVRCHSR1_CHSR         = 0x1 // Bit CHSR.
	LCDC_OVRCHSR1_UPDATESR_Pos = 0x1 // Position of UPDATESR field.
	LCDC_OVRCHSR1_UPDATESR_Msk = 0x2 // Bit mask of UPDATESR field.
	LCDC_OVRCHSR1_UPDATESR     = 0x2 // Bit UPDATESR.
	LCDC_OVRCHSR1_A2QSR_Pos    = 0x2 // Position of A2QSR field.
	LCDC_OVRCHSR1_A2QSR_Msk    = 0x4 // Bit mask of A2QSR field.
	LCDC_OVRCHSR1_A2QSR        = 0x4 // Bit A2QSR.

	// OVRIER1: Overlay 1 Interrupt Enable Register
	LCDC_OVRIER1_DMA_Pos  = 0x2  // Position of DMA field.
	LCDC_OVRIER1_DMA_Msk  = 0x4  // Bit mask of DMA field.
	LCDC_OVRIER1_DMA      = 0x4  // Bit DMA.
	LCDC_OVRIER1_DSCR_Pos = 0x3  // Position of DSCR field.
	LCDC_OVRIER1_DSCR_Msk = 0x8  // Bit mask of DSCR field.
	LCDC_OVRIER1_DSCR     = 0x8  // Bit DSCR.
	LCDC_OVRIER1_ADD_Pos  = 0x4  // Position of ADD field.
	LCDC_OVRIER1_ADD_Msk  = 0x10 // Bit mask of ADD field.
	LCDC_OVRIER1_ADD      = 0x10 // Bit ADD.
	LCDC_OVRIER1_DONE_Pos = 0x5  // Position of DONE field.
	LCDC_OVRIER1_DONE_Msk = 0x20 // Bit mask of DONE field.
	LCDC_OVRIER1_DONE     = 0x20 // Bit DONE.
	LCDC_OVRIER1_OVR_Pos  = 0x6  // Position of OVR field.
	LCDC_OVRIER1_OVR_Msk  = 0x40 // Bit mask of OVR field.
	LCDC_OVRIER1_OVR      = 0x40 // Bit OVR.

	// OVRIDR1: Overlay 1 Interrupt Disable Register
	LCDC_OVRIDR1_DMA_Pos  = 0x2  // Position of DMA field.
	LCDC_OVRIDR1_DMA_Msk  = 0x4  // Bit mask of DMA field.
	LCDC_OVRIDR1_DMA      = 0x4  // Bit DMA.
	LCDC_OVRIDR1_DSCR_Pos = 0x3  // Position of DSCR field.
	LCDC_OVRIDR1_DSCR_Msk = 0x8  // Bit mask of DSCR field.
	LCDC_OVRIDR1_DSCR     = 0x8  // Bit DSCR.
	LCDC_OVRIDR1_ADD_Pos  = 0x4  // Position of ADD field.
	LCDC_OVRIDR1_ADD_Msk  = 0x10 // Bit mask of ADD field.
	LCDC_OVRIDR1_ADD      = 0x10 // Bit ADD.
	LCDC_OVRIDR1_DONE_Pos = 0x5  // Position of DONE field.
	LCDC_OVRIDR1_DONE_Msk = 0x20 // Bit mask of DONE field.
	LCDC_OVRIDR1_DONE     = 0x20 // Bit DONE.
	LCDC_OVRIDR1_OVR_Pos  = 0x6  // Position of OVR field.
	LCDC_OVRIDR1_OVR_Msk  = 0x40 // Bit mask of OVR field.
	LCDC_OVRIDR1_OVR      = 0x40 // Bit OVR.

	// OVRIMR1: Overlay 1 Interrupt Mask Register
	LCDC_OVRIMR1_DMA_Pos  = 0x2  // Position of DMA field.
	LCDC_OVRIMR1_DMA_Msk  = 0x4  // Bit mask of DMA field.
	LCDC_OVRIMR1_DMA      = 0x4  // Bit DMA.
	LCDC_OVRIMR1_DSCR_Pos = 0x3  // Position of DSCR field.
	LCDC_OVRIMR1_DSCR_Msk = 0x8  // Bit mask of DSCR field.
	LCDC_OVRIMR1_DSCR     = 0x8  // Bit DSCR.
	LCDC_OVRIMR1_ADD_Pos  = 0x4  // Position of ADD field.
	LCDC_OVRIMR1_ADD_Msk  = 0x10 // Bit mask of ADD field.
	LCDC_OVRIMR1_ADD      = 0x10 // Bit ADD.
	LCDC_OVRIMR1_DONE_Pos = 0x5  // Position of DONE field.
	LCDC_OVRIMR1_DONE_Msk = 0x20 // Bit mask of DONE field.
	LCDC_OVRIMR1_DONE     = 0x20 // Bit DONE.
	LCDC_OVRIMR1_OVR_Pos  = 0x6  // Position of OVR field.
	LCDC_OVRIMR1_OVR_Msk  = 0x40 // Bit mask of OVR field.
	LCDC_OVRIMR1_OVR      = 0x40 // Bit OVR.

	// OVRISR1: Overlay 1 Interrupt Status Register
	LCDC_OVRISR1_DMA_Pos  = 0x2  // Position of DMA field.
	LCDC_OVRISR1_DMA_Msk  = 0x4  // Bit mask of DMA field.
	LCDC_OVRISR1_DMA      = 0x4  // Bit DMA.
	LCDC_OVRISR1_DSCR_Pos = 0x3  // Position of DSCR field.
	LCDC_OVRISR1_DSCR_Msk = 0x8  // Bit mask of DSCR field.
	LCDC_OVRISR1_DSCR     = 0x8  // Bit DSCR.
	LCDC_OVRISR1_ADD_Pos  = 0x4  // Position of ADD field.
	LCDC_OVRISR1_ADD_Msk  = 0x10 // Bit mask of ADD field.
	LCDC_OVRISR1_ADD      = 0x10 // Bit ADD.
	LCDC_OVRISR1_DONE_Pos = 0x5  // Position of DONE field.
	LCDC_OVRISR1_DONE_Msk = 0x20 // Bit mask of DONE field.
	LCDC_OVRISR1_DONE     = 0x20 // Bit DONE.
	LCDC_OVRISR1_OVR_Pos  = 0x6  // Position of OVR field.
	LCDC_OVRISR1_OVR_Msk  = 0x40 // Bit mask of OVR field.
	LCDC_OVRISR1_OVR      = 0x40 // Bit OVR.

	// OVRHEAD1: Overlay 1 DMA Head Register
	LCDC_OVRHEAD1_HEAD_Pos = 0x2        // Position of HEAD field.
	LCDC_OVRHEAD1_HEAD_Msk = 0xfffffffc // Bit mask of HEAD field.

	// OVRADDR1: Overlay 1 DMA Address Register
	LCDC_OVRADDR1_ADDR_Pos = 0x0        // Position of ADDR field.
	LCDC_OVRADDR1_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// OVRCTRL1: Overlay1 DMA Control Register
	LCDC_OVRCTRL1_DFETCH_Pos  = 0x0  // Position of DFETCH field.
	LCDC_OVRCTRL1_DFETCH_Msk  = 0x1  // Bit mask of DFETCH field.
	LCDC_OVRCTRL1_DFETCH      = 0x1  // Bit DFETCH.
	LCDC_OVRCTRL1_LFETCH_Pos  = 0x1  // Position of LFETCH field.
	LCDC_OVRCTRL1_LFETCH_Msk  = 0x2  // Bit mask of LFETCH field.
	LCDC_OVRCTRL1_LFETCH      = 0x2  // Bit LFETCH.
	LCDC_OVRCTRL1_DMAIEN_Pos  = 0x2  // Position of DMAIEN field.
	LCDC_OVRCTRL1_DMAIEN_Msk  = 0x4  // Bit mask of DMAIEN field.
	LCDC_OVRCTRL1_DMAIEN      = 0x4  // Bit DMAIEN.
	LCDC_OVRCTRL1_DSCRIEN_Pos = 0x3  // Position of DSCRIEN field.
	LCDC_OVRCTRL1_DSCRIEN_Msk = 0x8  // Bit mask of DSCRIEN field.
	LCDC_OVRCTRL1_DSCRIEN     = 0x8  // Bit DSCRIEN.
	LCDC_OVRCTRL1_ADDIEN_Pos  = 0x4  // Position of ADDIEN field.
	LCDC_OVRCTRL1_ADDIEN_Msk  = 0x10 // Bit mask of ADDIEN field.
	LCDC_OVRCTRL1_ADDIEN      = 0x10 // Bit ADDIEN.
	LCDC_OVRCTRL1_DONEIEN_Pos = 0x5  // Position of DONEIEN field.
	LCDC_OVRCTRL1_DONEIEN_Msk = 0x20 // Bit mask of DONEIEN field.
	LCDC_OVRCTRL1_DONEIEN     = 0x20 // Bit DONEIEN.

	// OVRNEXT1: Overlay1 DMA Next Register
	LCDC_OVRNEXT1_NEXT_Pos = 0x0        // Position of NEXT field.
	LCDC_OVRNEXT1_NEXT_Msk = 0xffffffff // Bit mask of NEXT field.

	// OVR1CFG0: Overlay 1 Configuration 0 Register
	LCDC_OVR1CFG0_BLEN_Pos        = 0x4    // Position of BLEN field.
	LCDC_OVR1CFG0_BLEN_Msk        = 0x30   // Bit mask of BLEN field.
	LCDC_OVR1CFG0_BLEN_AHB_SINGLE = 0x0    // AHB Access is started as soon as there is enough space in the FIFO to store one 32-bit data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts are preferred. INCR is used for a burst of 2 and 3 beats.
	LCDC_OVR1CFG0_BLEN_AHB_INCR4  = 0x1    // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of four 32-bit data. An AHB INCR4 Burst is preferred. SINGLE, INCR and INCR4 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_OVR1CFG0_BLEN_AHB_INCR8  = 0x2    // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of eight 32-bit data. An AHB INCR8 Burst is preferred. SINGLE, INCR, INCR4 and INCR8 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_OVR1CFG0_BLEN_AHB_INCR16 = 0x3    // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of sixteen 32-bit data. An AHB INCR16 Burst is preferred. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_OVR1CFG0_DLBO_Pos        = 0x8    // Position of DLBO field.
	LCDC_OVR1CFG0_DLBO_Msk        = 0x100  // Bit mask of DLBO field.
	LCDC_OVR1CFG0_DLBO            = 0x100  // Bit DLBO.
	LCDC_OVR1CFG0_ROTDIS_Pos      = 0xc    // Position of ROTDIS field.
	LCDC_OVR1CFG0_ROTDIS_Msk      = 0x1000 // Bit mask of ROTDIS field.
	LCDC_OVR1CFG0_ROTDIS          = 0x1000 // Bit ROTDIS.
	LCDC_OVR1CFG0_LOCKDIS_Pos     = 0xd    // Position of LOCKDIS field.
	LCDC_OVR1CFG0_LOCKDIS_Msk     = 0x2000 // Bit mask of LOCKDIS field.
	LCDC_OVR1CFG0_LOCKDIS         = 0x2000 // Bit LOCKDIS.

	// OVR1CFG1: Overlay 1 Configuration 1 Register
	LCDC_OVR1CFG1_CLUTEN_Pos                   = 0x0   // Position of CLUTEN field.
	LCDC_OVR1CFG1_CLUTEN_Msk                   = 0x1   // Bit mask of CLUTEN field.
	LCDC_OVR1CFG1_CLUTEN                       = 0x1   // Bit CLUTEN.
	LCDC_OVR1CFG1_RGBMODE_Pos                  = 0x4   // Position of RGBMODE field.
	LCDC_OVR1CFG1_RGBMODE_Msk                  = 0xf0  // Bit mask of RGBMODE field.
	LCDC_OVR1CFG1_RGBMODE_12BPP_RGB_444        = 0x0   // 12 bpp RGB 444
	LCDC_OVR1CFG1_RGBMODE_16BPP_ARGB_4444      = 0x1   // 16 bpp ARGB 4444
	LCDC_OVR1CFG1_RGBMODE_16BPP_RGBA_4444      = 0x2   // 16 bpp RGBA 4444
	LCDC_OVR1CFG1_RGBMODE_16BPP_RGB_565        = 0x3   // 16 bpp RGB 565
	LCDC_OVR1CFG1_RGBMODE_16BPP_TRGB_1555      = 0x4   // 16 bpp TRGB 1555
	LCDC_OVR1CFG1_RGBMODE_18BPP_RGB_666        = 0x5   // 18 bpp RGB 666
	LCDC_OVR1CFG1_RGBMODE_18BPP_RGB_666_PACKED = 0x6   // 18 bpp RGB 666 PACKED
	LCDC_OVR1CFG1_RGBMODE_19BPP_TRGB_1666      = 0x7   // 19 bpp TRGB 1666
	LCDC_OVR1CFG1_RGBMODE_19BPP_TRGB_PACKED    = 0x8   // 19 bpp TRGB 1666 PACKED
	LCDC_OVR1CFG1_RGBMODE_24BPP_RGB_888        = 0x9   // 24 bpp RGB 888
	LCDC_OVR1CFG1_RGBMODE_24BPP_RGB_888_PACKED = 0xa   // 24 bpp RGB 888 PACKED
	LCDC_OVR1CFG1_RGBMODE_25BPP_TRGB_1888      = 0xb   // 25 bpp TRGB 1888
	LCDC_OVR1CFG1_RGBMODE_32BPP_ARGB_8888      = 0xc   // 32 bpp ARGB 8888
	LCDC_OVR1CFG1_RGBMODE_32BPP_RGBA_8888      = 0xd   // 32 bpp RGBA 8888
	LCDC_OVR1CFG1_CLUTMODE_Pos                 = 0x8   // Position of CLUTMODE field.
	LCDC_OVR1CFG1_CLUTMODE_Msk                 = 0x300 // Bit mask of CLUTMODE field.
	LCDC_OVR1CFG1_CLUTMODE_1BPP                = 0x0   // color lookup table mode set to 1 bit per pixel
	LCDC_OVR1CFG1_CLUTMODE_2BPP                = 0x1   // color lookup table mode set to 2 bits per pixel
	LCDC_OVR1CFG1_CLUTMODE_4BPP                = 0x2   // color lookup table mode set to 4 bits per pixel
	LCDC_OVR1CFG1_CLUTMODE_8BPP                = 0x3   // color lookup table mode set to 8 bits per pixel

	// OVR1CFG2: Overlay 1 Configuration 2 Register
	LCDC_OVR1CFG2_XPOS_Pos = 0x0       // Position of XPOS field.
	LCDC_OVR1CFG2_XPOS_Msk = 0x7ff     // Bit mask of XPOS field.
	LCDC_OVR1CFG2_YPOS_Pos = 0x10      // Position of YPOS field.
	LCDC_OVR1CFG2_YPOS_Msk = 0x7ff0000 // Bit mask of YPOS field.

	// OVR1CFG3: Overlay 1 Configuration 3 Register
	LCDC_OVR1CFG3_XSIZE_Pos = 0x0       // Position of XSIZE field.
	LCDC_OVR1CFG3_XSIZE_Msk = 0x7ff     // Bit mask of XSIZE field.
	LCDC_OVR1CFG3_YSIZE_Pos = 0x10      // Position of YSIZE field.
	LCDC_OVR1CFG3_YSIZE_Msk = 0x7ff0000 // Bit mask of YSIZE field.

	// OVR1CFG4: Overlay 1 Configuration 4 Register
	LCDC_OVR1CFG4_XSTRIDE_Pos = 0x0        // Position of XSTRIDE field.
	LCDC_OVR1CFG4_XSTRIDE_Msk = 0xffffffff // Bit mask of XSTRIDE field.

	// OVR1CFG5: Overlay 1 Configuration 5 Register
	LCDC_OVR1CFG5_PSTRIDE_Pos = 0x0        // Position of PSTRIDE field.
	LCDC_OVR1CFG5_PSTRIDE_Msk = 0xffffffff // Bit mask of PSTRIDE field.

	// OVR1CFG6: Overlay 1 Configuration 6 Register
	LCDC_OVR1CFG6_BDEF_Pos = 0x0      // Position of BDEF field.
	LCDC_OVR1CFG6_BDEF_Msk = 0xff     // Bit mask of BDEF field.
	LCDC_OVR1CFG6_GDEF_Pos = 0x8      // Position of GDEF field.
	LCDC_OVR1CFG6_GDEF_Msk = 0xff00   // Bit mask of GDEF field.
	LCDC_OVR1CFG6_RDEF_Pos = 0x10     // Position of RDEF field.
	LCDC_OVR1CFG6_RDEF_Msk = 0xff0000 // Bit mask of RDEF field.

	// OVR1CFG7: Overlay 1 Configuration 7 Register
	LCDC_OVR1CFG7_BKEY_Pos = 0x0      // Position of BKEY field.
	LCDC_OVR1CFG7_BKEY_Msk = 0xff     // Bit mask of BKEY field.
	LCDC_OVR1CFG7_GKEY_Pos = 0x8      // Position of GKEY field.
	LCDC_OVR1CFG7_GKEY_Msk = 0xff00   // Bit mask of GKEY field.
	LCDC_OVR1CFG7_RKEY_Pos = 0x10     // Position of RKEY field.
	LCDC_OVR1CFG7_RKEY_Msk = 0xff0000 // Bit mask of RKEY field.

	// OVR1CFG8: Overlay 1 Configuration 8 Register
	LCDC_OVR1CFG8_BMASK_Pos = 0x0      // Position of BMASK field.
	LCDC_OVR1CFG8_BMASK_Msk = 0xff     // Bit mask of BMASK field.
	LCDC_OVR1CFG8_GMASK_Pos = 0x8      // Position of GMASK field.
	LCDC_OVR1CFG8_GMASK_Msk = 0xff00   // Bit mask of GMASK field.
	LCDC_OVR1CFG8_RMASK_Pos = 0x10     // Position of RMASK field.
	LCDC_OVR1CFG8_RMASK_Msk = 0xff0000 // Bit mask of RMASK field.

	// OVR1CFG9: Overlay 1 Configuration 9 Register
	LCDC_OVR1CFG9_CRKEY_Pos    = 0x0      // Position of CRKEY field.
	LCDC_OVR1CFG9_CRKEY_Msk    = 0x1      // Bit mask of CRKEY field.
	LCDC_OVR1CFG9_CRKEY        = 0x1      // Bit CRKEY.
	LCDC_OVR1CFG9_INV_Pos      = 0x1      // Position of INV field.
	LCDC_OVR1CFG9_INV_Msk      = 0x2      // Bit mask of INV field.
	LCDC_OVR1CFG9_INV          = 0x2      // Bit INV.
	LCDC_OVR1CFG9_ITER2BL_Pos  = 0x2      // Position of ITER2BL field.
	LCDC_OVR1CFG9_ITER2BL_Msk  = 0x4      // Bit mask of ITER2BL field.
	LCDC_OVR1CFG9_ITER2BL      = 0x4      // Bit ITER2BL.
	LCDC_OVR1CFG9_ITER_Pos     = 0x3      // Position of ITER field.
	LCDC_OVR1CFG9_ITER_Msk     = 0x8      // Bit mask of ITER field.
	LCDC_OVR1CFG9_ITER         = 0x8      // Bit ITER.
	LCDC_OVR1CFG9_REVALPHA_Pos = 0x4      // Position of REVALPHA field.
	LCDC_OVR1CFG9_REVALPHA_Msk = 0x10     // Bit mask of REVALPHA field.
	LCDC_OVR1CFG9_REVALPHA     = 0x10     // Bit REVALPHA.
	LCDC_OVR1CFG9_GAEN_Pos     = 0x5      // Position of GAEN field.
	LCDC_OVR1CFG9_GAEN_Msk     = 0x20     // Bit mask of GAEN field.
	LCDC_OVR1CFG9_GAEN         = 0x20     // Bit GAEN.
	LCDC_OVR1CFG9_LAEN_Pos     = 0x6      // Position of LAEN field.
	LCDC_OVR1CFG9_LAEN_Msk     = 0x40     // Bit mask of LAEN field.
	LCDC_OVR1CFG9_LAEN         = 0x40     // Bit LAEN.
	LCDC_OVR1CFG9_OVR_Pos      = 0x7      // Position of OVR field.
	LCDC_OVR1CFG9_OVR_Msk      = 0x80     // Bit mask of OVR field.
	LCDC_OVR1CFG9_OVR          = 0x80     // Bit OVR.
	LCDC_OVR1CFG9_DMA_Pos      = 0x8      // Position of DMA field.
	LCDC_OVR1CFG9_DMA_Msk      = 0x100    // Bit mask of DMA field.
	LCDC_OVR1CFG9_DMA          = 0x100    // Bit DMA.
	LCDC_OVR1CFG9_REP_Pos      = 0x9      // Position of REP field.
	LCDC_OVR1CFG9_REP_Msk      = 0x200    // Bit mask of REP field.
	LCDC_OVR1CFG9_REP          = 0x200    // Bit REP.
	LCDC_OVR1CFG9_DSTKEY_Pos   = 0xa      // Position of DSTKEY field.
	LCDC_OVR1CFG9_DSTKEY_Msk   = 0x400    // Bit mask of DSTKEY field.
	LCDC_OVR1CFG9_DSTKEY       = 0x400    // Bit DSTKEY.
	LCDC_OVR1CFG9_GA_Pos       = 0x10     // Position of GA field.
	LCDC_OVR1CFG9_GA_Msk       = 0xff0000 // Bit mask of GA field.

	// HEOCHER: High End Overlay Channel Enable Register
	LCDC_HEOCHER_CHEN_Pos     = 0x0 // Position of CHEN field.
	LCDC_HEOCHER_CHEN_Msk     = 0x1 // Bit mask of CHEN field.
	LCDC_HEOCHER_CHEN         = 0x1 // Bit CHEN.
	LCDC_HEOCHER_UPDATEEN_Pos = 0x1 // Position of UPDATEEN field.
	LCDC_HEOCHER_UPDATEEN_Msk = 0x2 // Bit mask of UPDATEEN field.
	LCDC_HEOCHER_UPDATEEN     = 0x2 // Bit UPDATEEN.
	LCDC_HEOCHER_A2QEN_Pos    = 0x2 // Position of A2QEN field.
	LCDC_HEOCHER_A2QEN_Msk    = 0x4 // Bit mask of A2QEN field.
	LCDC_HEOCHER_A2QEN        = 0x4 // Bit A2QEN.

	// HEOCHDR: High End Overlay Channel Disable Register
	LCDC_HEOCHDR_CHDIS_Pos = 0x0   // Position of CHDIS field.
	LCDC_HEOCHDR_CHDIS_Msk = 0x1   // Bit mask of CHDIS field.
	LCDC_HEOCHDR_CHDIS     = 0x1   // Bit CHDIS.
	LCDC_HEOCHDR_CHRST_Pos = 0x8   // Position of CHRST field.
	LCDC_HEOCHDR_CHRST_Msk = 0x100 // Bit mask of CHRST field.
	LCDC_HEOCHDR_CHRST     = 0x100 // Bit CHRST.

	// HEOCHSR: High End Overlay Channel Status Register
	LCDC_HEOCHSR_CHSR_Pos     = 0x0 // Position of CHSR field.
	LCDC_HEOCHSR_CHSR_Msk     = 0x1 // Bit mask of CHSR field.
	LCDC_HEOCHSR_CHSR         = 0x1 // Bit CHSR.
	LCDC_HEOCHSR_UPDATESR_Pos = 0x1 // Position of UPDATESR field.
	LCDC_HEOCHSR_UPDATESR_Msk = 0x2 // Bit mask of UPDATESR field.
	LCDC_HEOCHSR_UPDATESR     = 0x2 // Bit UPDATESR.
	LCDC_HEOCHSR_A2QSR_Pos    = 0x2 // Position of A2QSR field.
	LCDC_HEOCHSR_A2QSR_Msk    = 0x4 // Bit mask of A2QSR field.
	LCDC_HEOCHSR_A2QSR        = 0x4 // Bit A2QSR.

	// HEOIER: High End Overlay Interrupt Enable Register
	LCDC_HEOIER_DMA_Pos   = 0x2      // Position of DMA field.
	LCDC_HEOIER_DMA_Msk   = 0x4      // Bit mask of DMA field.
	LCDC_HEOIER_DMA       = 0x4      // Bit DMA.
	LCDC_HEOIER_DSCR_Pos  = 0x3      // Position of DSCR field.
	LCDC_HEOIER_DSCR_Msk  = 0x8      // Bit mask of DSCR field.
	LCDC_HEOIER_DSCR      = 0x8      // Bit DSCR.
	LCDC_HEOIER_ADD_Pos   = 0x4      // Position of ADD field.
	LCDC_HEOIER_ADD_Msk   = 0x10     // Bit mask of ADD field.
	LCDC_HEOIER_ADD       = 0x10     // Bit ADD.
	LCDC_HEOIER_DONE_Pos  = 0x5      // Position of DONE field.
	LCDC_HEOIER_DONE_Msk  = 0x20     // Bit mask of DONE field.
	LCDC_HEOIER_DONE      = 0x20     // Bit DONE.
	LCDC_HEOIER_OVR_Pos   = 0x6      // Position of OVR field.
	LCDC_HEOIER_OVR_Msk   = 0x40     // Bit mask of OVR field.
	LCDC_HEOIER_OVR       = 0x40     // Bit OVR.
	LCDC_HEOIER_UDMA_Pos  = 0xa      // Position of UDMA field.
	LCDC_HEOIER_UDMA_Msk  = 0x400    // Bit mask of UDMA field.
	LCDC_HEOIER_UDMA      = 0x400    // Bit UDMA.
	LCDC_HEOIER_UDSCR_Pos = 0xb      // Position of UDSCR field.
	LCDC_HEOIER_UDSCR_Msk = 0x800    // Bit mask of UDSCR field.
	LCDC_HEOIER_UDSCR     = 0x800    // Bit UDSCR.
	LCDC_HEOIER_UADD_Pos  = 0xc      // Position of UADD field.
	LCDC_HEOIER_UADD_Msk  = 0x1000   // Bit mask of UADD field.
	LCDC_HEOIER_UADD      = 0x1000   // Bit UADD.
	LCDC_HEOIER_UDONE_Pos = 0xd      // Position of UDONE field.
	LCDC_HEOIER_UDONE_Msk = 0x2000   // Bit mask of UDONE field.
	LCDC_HEOIER_UDONE     = 0x2000   // Bit UDONE.
	LCDC_HEOIER_UOVR_Pos  = 0xe      // Position of UOVR field.
	LCDC_HEOIER_UOVR_Msk  = 0x4000   // Bit mask of UOVR field.
	LCDC_HEOIER_UOVR      = 0x4000   // Bit UOVR.
	LCDC_HEOIER_VDMA_Pos  = 0x12     // Position of VDMA field.
	LCDC_HEOIER_VDMA_Msk  = 0x40000  // Bit mask of VDMA field.
	LCDC_HEOIER_VDMA      = 0x40000  // Bit VDMA.
	LCDC_HEOIER_VDSCR_Pos = 0x13     // Position of VDSCR field.
	LCDC_HEOIER_VDSCR_Msk = 0x80000  // Bit mask of VDSCR field.
	LCDC_HEOIER_VDSCR     = 0x80000  // Bit VDSCR.
	LCDC_HEOIER_VADD_Pos  = 0x14     // Position of VADD field.
	LCDC_HEOIER_VADD_Msk  = 0x100000 // Bit mask of VADD field.
	LCDC_HEOIER_VADD      = 0x100000 // Bit VADD.
	LCDC_HEOIER_VDONE_Pos = 0x15     // Position of VDONE field.
	LCDC_HEOIER_VDONE_Msk = 0x200000 // Bit mask of VDONE field.
	LCDC_HEOIER_VDONE     = 0x200000 // Bit VDONE.
	LCDC_HEOIER_VOVR_Pos  = 0x16     // Position of VOVR field.
	LCDC_HEOIER_VOVR_Msk  = 0x400000 // Bit mask of VOVR field.
	LCDC_HEOIER_VOVR      = 0x400000 // Bit VOVR.

	// HEOIDR: High End Overlay Interrupt Disable Register
	LCDC_HEOIDR_DMA_Pos   = 0x2      // Position of DMA field.
	LCDC_HEOIDR_DMA_Msk   = 0x4      // Bit mask of DMA field.
	LCDC_HEOIDR_DMA       = 0x4      // Bit DMA.
	LCDC_HEOIDR_DSCR_Pos  = 0x3      // Position of DSCR field.
	LCDC_HEOIDR_DSCR_Msk  = 0x8      // Bit mask of DSCR field.
	LCDC_HEOIDR_DSCR      = 0x8      // Bit DSCR.
	LCDC_HEOIDR_ADD_Pos   = 0x4      // Position of ADD field.
	LCDC_HEOIDR_ADD_Msk   = 0x10     // Bit mask of ADD field.
	LCDC_HEOIDR_ADD       = 0x10     // Bit ADD.
	LCDC_HEOIDR_DONE_Pos  = 0x5      // Position of DONE field.
	LCDC_HEOIDR_DONE_Msk  = 0x20     // Bit mask of DONE field.
	LCDC_HEOIDR_DONE      = 0x20     // Bit DONE.
	LCDC_HEOIDR_OVR_Pos   = 0x6      // Position of OVR field.
	LCDC_HEOIDR_OVR_Msk   = 0x40     // Bit mask of OVR field.
	LCDC_HEOIDR_OVR       = 0x40     // Bit OVR.
	LCDC_HEOIDR_UDMA_Pos  = 0xa      // Position of UDMA field.
	LCDC_HEOIDR_UDMA_Msk  = 0x400    // Bit mask of UDMA field.
	LCDC_HEOIDR_UDMA      = 0x400    // Bit UDMA.
	LCDC_HEOIDR_UDSCR_Pos = 0xb      // Position of UDSCR field.
	LCDC_HEOIDR_UDSCR_Msk = 0x800    // Bit mask of UDSCR field.
	LCDC_HEOIDR_UDSCR     = 0x800    // Bit UDSCR.
	LCDC_HEOIDR_UADD_Pos  = 0xc      // Position of UADD field.
	LCDC_HEOIDR_UADD_Msk  = 0x1000   // Bit mask of UADD field.
	LCDC_HEOIDR_UADD      = 0x1000   // Bit UADD.
	LCDC_HEOIDR_UDONE_Pos = 0xd      // Position of UDONE field.
	LCDC_HEOIDR_UDONE_Msk = 0x2000   // Bit mask of UDONE field.
	LCDC_HEOIDR_UDONE     = 0x2000   // Bit UDONE.
	LCDC_HEOIDR_UOVR_Pos  = 0xe      // Position of UOVR field.
	LCDC_HEOIDR_UOVR_Msk  = 0x4000   // Bit mask of UOVR field.
	LCDC_HEOIDR_UOVR      = 0x4000   // Bit UOVR.
	LCDC_HEOIDR_VDMA_Pos  = 0x12     // Position of VDMA field.
	LCDC_HEOIDR_VDMA_Msk  = 0x40000  // Bit mask of VDMA field.
	LCDC_HEOIDR_VDMA      = 0x40000  // Bit VDMA.
	LCDC_HEOIDR_VDSCR_Pos = 0x13     // Position of VDSCR field.
	LCDC_HEOIDR_VDSCR_Msk = 0x80000  // Bit mask of VDSCR field.
	LCDC_HEOIDR_VDSCR     = 0x80000  // Bit VDSCR.
	LCDC_HEOIDR_VADD_Pos  = 0x14     // Position of VADD field.
	LCDC_HEOIDR_VADD_Msk  = 0x100000 // Bit mask of VADD field.
	LCDC_HEOIDR_VADD      = 0x100000 // Bit VADD.
	LCDC_HEOIDR_VDONE_Pos = 0x15     // Position of VDONE field.
	LCDC_HEOIDR_VDONE_Msk = 0x200000 // Bit mask of VDONE field.
	LCDC_HEOIDR_VDONE     = 0x200000 // Bit VDONE.
	LCDC_HEOIDR_VOVR_Pos  = 0x16     // Position of VOVR field.
	LCDC_HEOIDR_VOVR_Msk  = 0x400000 // Bit mask of VOVR field.
	LCDC_HEOIDR_VOVR      = 0x400000 // Bit VOVR.

	// HEOIMR: High End Overlay Interrupt Mask Register
	LCDC_HEOIMR_DMA_Pos   = 0x2      // Position of DMA field.
	LCDC_HEOIMR_DMA_Msk   = 0x4      // Bit mask of DMA field.
	LCDC_HEOIMR_DMA       = 0x4      // Bit DMA.
	LCDC_HEOIMR_DSCR_Pos  = 0x3      // Position of DSCR field.
	LCDC_HEOIMR_DSCR_Msk  = 0x8      // Bit mask of DSCR field.
	LCDC_HEOIMR_DSCR      = 0x8      // Bit DSCR.
	LCDC_HEOIMR_ADD_Pos   = 0x4      // Position of ADD field.
	LCDC_HEOIMR_ADD_Msk   = 0x10     // Bit mask of ADD field.
	LCDC_HEOIMR_ADD       = 0x10     // Bit ADD.
	LCDC_HEOIMR_DONE_Pos  = 0x5      // Position of DONE field.
	LCDC_HEOIMR_DONE_Msk  = 0x20     // Bit mask of DONE field.
	LCDC_HEOIMR_DONE      = 0x20     // Bit DONE.
	LCDC_HEOIMR_OVR_Pos   = 0x6      // Position of OVR field.
	LCDC_HEOIMR_OVR_Msk   = 0x40     // Bit mask of OVR field.
	LCDC_HEOIMR_OVR       = 0x40     // Bit OVR.
	LCDC_HEOIMR_UDMA_Pos  = 0xa      // Position of UDMA field.
	LCDC_HEOIMR_UDMA_Msk  = 0x400    // Bit mask of UDMA field.
	LCDC_HEOIMR_UDMA      = 0x400    // Bit UDMA.
	LCDC_HEOIMR_UDSCR_Pos = 0xb      // Position of UDSCR field.
	LCDC_HEOIMR_UDSCR_Msk = 0x800    // Bit mask of UDSCR field.
	LCDC_HEOIMR_UDSCR     = 0x800    // Bit UDSCR.
	LCDC_HEOIMR_UADD_Pos  = 0xc      // Position of UADD field.
	LCDC_HEOIMR_UADD_Msk  = 0x1000   // Bit mask of UADD field.
	LCDC_HEOIMR_UADD      = 0x1000   // Bit UADD.
	LCDC_HEOIMR_UDONE_Pos = 0xd      // Position of UDONE field.
	LCDC_HEOIMR_UDONE_Msk = 0x2000   // Bit mask of UDONE field.
	LCDC_HEOIMR_UDONE     = 0x2000   // Bit UDONE.
	LCDC_HEOIMR_UOVR_Pos  = 0xe      // Position of UOVR field.
	LCDC_HEOIMR_UOVR_Msk  = 0x4000   // Bit mask of UOVR field.
	LCDC_HEOIMR_UOVR      = 0x4000   // Bit UOVR.
	LCDC_HEOIMR_VDMA_Pos  = 0x12     // Position of VDMA field.
	LCDC_HEOIMR_VDMA_Msk  = 0x40000  // Bit mask of VDMA field.
	LCDC_HEOIMR_VDMA      = 0x40000  // Bit VDMA.
	LCDC_HEOIMR_VDSCR_Pos = 0x13     // Position of VDSCR field.
	LCDC_HEOIMR_VDSCR_Msk = 0x80000  // Bit mask of VDSCR field.
	LCDC_HEOIMR_VDSCR     = 0x80000  // Bit VDSCR.
	LCDC_HEOIMR_VADD_Pos  = 0x14     // Position of VADD field.
	LCDC_HEOIMR_VADD_Msk  = 0x100000 // Bit mask of VADD field.
	LCDC_HEOIMR_VADD      = 0x100000 // Bit VADD.
	LCDC_HEOIMR_VDONE_Pos = 0x15     // Position of VDONE field.
	LCDC_HEOIMR_VDONE_Msk = 0x200000 // Bit mask of VDONE field.
	LCDC_HEOIMR_VDONE     = 0x200000 // Bit VDONE.
	LCDC_HEOIMR_VOVR_Pos  = 0x16     // Position of VOVR field.
	LCDC_HEOIMR_VOVR_Msk  = 0x400000 // Bit mask of VOVR field.
	LCDC_HEOIMR_VOVR      = 0x400000 // Bit VOVR.

	// HEOISR: High End Overlay Interrupt Status Register
	LCDC_HEOISR_DMA_Pos   = 0x2      // Position of DMA field.
	LCDC_HEOISR_DMA_Msk   = 0x4      // Bit mask of DMA field.
	LCDC_HEOISR_DMA       = 0x4      // Bit DMA.
	LCDC_HEOISR_DSCR_Pos  = 0x3      // Position of DSCR field.
	LCDC_HEOISR_DSCR_Msk  = 0x8      // Bit mask of DSCR field.
	LCDC_HEOISR_DSCR      = 0x8      // Bit DSCR.
	LCDC_HEOISR_ADD_Pos   = 0x4      // Position of ADD field.
	LCDC_HEOISR_ADD_Msk   = 0x10     // Bit mask of ADD field.
	LCDC_HEOISR_ADD       = 0x10     // Bit ADD.
	LCDC_HEOISR_DONE_Pos  = 0x5      // Position of DONE field.
	LCDC_HEOISR_DONE_Msk  = 0x20     // Bit mask of DONE field.
	LCDC_HEOISR_DONE      = 0x20     // Bit DONE.
	LCDC_HEOISR_OVR_Pos   = 0x6      // Position of OVR field.
	LCDC_HEOISR_OVR_Msk   = 0x40     // Bit mask of OVR field.
	LCDC_HEOISR_OVR       = 0x40     // Bit OVR.
	LCDC_HEOISR_UDMA_Pos  = 0xa      // Position of UDMA field.
	LCDC_HEOISR_UDMA_Msk  = 0x400    // Bit mask of UDMA field.
	LCDC_HEOISR_UDMA      = 0x400    // Bit UDMA.
	LCDC_HEOISR_UDSCR_Pos = 0xb      // Position of UDSCR field.
	LCDC_HEOISR_UDSCR_Msk = 0x800    // Bit mask of UDSCR field.
	LCDC_HEOISR_UDSCR     = 0x800    // Bit UDSCR.
	LCDC_HEOISR_UADD_Pos  = 0xc      // Position of UADD field.
	LCDC_HEOISR_UADD_Msk  = 0x1000   // Bit mask of UADD field.
	LCDC_HEOISR_UADD      = 0x1000   // Bit UADD.
	LCDC_HEOISR_UDONE_Pos = 0xd      // Position of UDONE field.
	LCDC_HEOISR_UDONE_Msk = 0x2000   // Bit mask of UDONE field.
	LCDC_HEOISR_UDONE     = 0x2000   // Bit UDONE.
	LCDC_HEOISR_UOVR_Pos  = 0xe      // Position of UOVR field.
	LCDC_HEOISR_UOVR_Msk  = 0x4000   // Bit mask of UOVR field.
	LCDC_HEOISR_UOVR      = 0x4000   // Bit UOVR.
	LCDC_HEOISR_VDMA_Pos  = 0x12     // Position of VDMA field.
	LCDC_HEOISR_VDMA_Msk  = 0x40000  // Bit mask of VDMA field.
	LCDC_HEOISR_VDMA      = 0x40000  // Bit VDMA.
	LCDC_HEOISR_VDSCR_Pos = 0x13     // Position of VDSCR field.
	LCDC_HEOISR_VDSCR_Msk = 0x80000  // Bit mask of VDSCR field.
	LCDC_HEOISR_VDSCR     = 0x80000  // Bit VDSCR.
	LCDC_HEOISR_VADD_Pos  = 0x14     // Position of VADD field.
	LCDC_HEOISR_VADD_Msk  = 0x100000 // Bit mask of VADD field.
	LCDC_HEOISR_VADD      = 0x100000 // Bit VADD.
	LCDC_HEOISR_VDONE_Pos = 0x15     // Position of VDONE field.
	LCDC_HEOISR_VDONE_Msk = 0x200000 // Bit mask of VDONE field.
	LCDC_HEOISR_VDONE     = 0x200000 // Bit VDONE.
	LCDC_HEOISR_VOVR_Pos  = 0x16     // Position of VOVR field.
	LCDC_HEOISR_VOVR_Msk  = 0x400000 // Bit mask of VOVR field.
	LCDC_HEOISR_VOVR      = 0x400000 // Bit VOVR.

	// HEOHEAD: High End Overlay DMA Head Register
	LCDC_HEOHEAD_HEAD_Pos = 0x2        // Position of HEAD field.
	LCDC_HEOHEAD_HEAD_Msk = 0xfffffffc // Bit mask of HEAD field.

	// HEOADDR: High End Overlay DMA Address Register
	LCDC_HEOADDR_ADDR_Pos = 0x0        // Position of ADDR field.
	LCDC_HEOADDR_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// HEOCTRL: High End Overlay DMA Control Register
	LCDC_HEOCTRL_DFETCH_Pos  = 0x0  // Position of DFETCH field.
	LCDC_HEOCTRL_DFETCH_Msk  = 0x1  // Bit mask of DFETCH field.
	LCDC_HEOCTRL_DFETCH      = 0x1  // Bit DFETCH.
	LCDC_HEOCTRL_LFETCH_Pos  = 0x1  // Position of LFETCH field.
	LCDC_HEOCTRL_LFETCH_Msk  = 0x2  // Bit mask of LFETCH field.
	LCDC_HEOCTRL_LFETCH      = 0x2  // Bit LFETCH.
	LCDC_HEOCTRL_DMAIEN_Pos  = 0x2  // Position of DMAIEN field.
	LCDC_HEOCTRL_DMAIEN_Msk  = 0x4  // Bit mask of DMAIEN field.
	LCDC_HEOCTRL_DMAIEN      = 0x4  // Bit DMAIEN.
	LCDC_HEOCTRL_DSCRIEN_Pos = 0x3  // Position of DSCRIEN field.
	LCDC_HEOCTRL_DSCRIEN_Msk = 0x8  // Bit mask of DSCRIEN field.
	LCDC_HEOCTRL_DSCRIEN     = 0x8  // Bit DSCRIEN.
	LCDC_HEOCTRL_ADDIEN_Pos  = 0x4  // Position of ADDIEN field.
	LCDC_HEOCTRL_ADDIEN_Msk  = 0x10 // Bit mask of ADDIEN field.
	LCDC_HEOCTRL_ADDIEN      = 0x10 // Bit ADDIEN.
	LCDC_HEOCTRL_DONEIEN_Pos = 0x5  // Position of DONEIEN field.
	LCDC_HEOCTRL_DONEIEN_Msk = 0x20 // Bit mask of DONEIEN field.
	LCDC_HEOCTRL_DONEIEN     = 0x20 // Bit DONEIEN.

	// HEONEXT: High End Overlay DMA Next Register
	LCDC_HEONEXT_NEXT_Pos = 0x0        // Position of NEXT field.
	LCDC_HEONEXT_NEXT_Msk = 0xffffffff // Bit mask of NEXT field.

	// HEOUHEAD: High End Overlay U DMA Head Register
	LCDC_HEOUHEAD_UHEAD_Pos = 0x0        // Position of UHEAD field.
	LCDC_HEOUHEAD_UHEAD_Msk = 0xffffffff // Bit mask of UHEAD field.

	// HEOUADDR: High End Overlay U DMA Address Register
	LCDC_HEOUADDR_UADDR_Pos = 0x0        // Position of UADDR field.
	LCDC_HEOUADDR_UADDR_Msk = 0xffffffff // Bit mask of UADDR field.

	// HEOUCTRL: High End Overlay U DMA Control Register
	LCDC_HEOUCTRL_UDFETCH_Pos  = 0x0  // Position of UDFETCH field.
	LCDC_HEOUCTRL_UDFETCH_Msk  = 0x1  // Bit mask of UDFETCH field.
	LCDC_HEOUCTRL_UDFETCH      = 0x1  // Bit UDFETCH.
	LCDC_HEOUCTRL_UDMAIEN_Pos  = 0x2  // Position of UDMAIEN field.
	LCDC_HEOUCTRL_UDMAIEN_Msk  = 0x4  // Bit mask of UDMAIEN field.
	LCDC_HEOUCTRL_UDMAIEN      = 0x4  // Bit UDMAIEN.
	LCDC_HEOUCTRL_UDSCRIEN_Pos = 0x3  // Position of UDSCRIEN field.
	LCDC_HEOUCTRL_UDSCRIEN_Msk = 0x8  // Bit mask of UDSCRIEN field.
	LCDC_HEOUCTRL_UDSCRIEN     = 0x8  // Bit UDSCRIEN.
	LCDC_HEOUCTRL_UADDIEN_Pos  = 0x4  // Position of UADDIEN field.
	LCDC_HEOUCTRL_UADDIEN_Msk  = 0x10 // Bit mask of UADDIEN field.
	LCDC_HEOUCTRL_UADDIEN      = 0x10 // Bit UADDIEN.
	LCDC_HEOUCTRL_UDONEIEN_Pos = 0x5  // Position of UDONEIEN field.
	LCDC_HEOUCTRL_UDONEIEN_Msk = 0x20 // Bit mask of UDONEIEN field.
	LCDC_HEOUCTRL_UDONEIEN     = 0x20 // Bit UDONEIEN.

	// HEOUNEXT: High End Overlay U DMA Next Register
	LCDC_HEOUNEXT_UNEXT_Pos = 0x0        // Position of UNEXT field.
	LCDC_HEOUNEXT_UNEXT_Msk = 0xffffffff // Bit mask of UNEXT field.

	// HEOVHEAD: High End Overlay V DMA Head Register
	LCDC_HEOVHEAD_VHEAD_Pos = 0x0        // Position of VHEAD field.
	LCDC_HEOVHEAD_VHEAD_Msk = 0xffffffff // Bit mask of VHEAD field.

	// HEOVADDR: High End Overlay V DMA Address Register
	LCDC_HEOVADDR_VADDR_Pos = 0x0        // Position of VADDR field.
	LCDC_HEOVADDR_VADDR_Msk = 0xffffffff // Bit mask of VADDR field.

	// HEOVCTRL: High End Overlay V DMA Control Register
	LCDC_HEOVCTRL_VDFETCH_Pos  = 0x0  // Position of VDFETCH field.
	LCDC_HEOVCTRL_VDFETCH_Msk  = 0x1  // Bit mask of VDFETCH field.
	LCDC_HEOVCTRL_VDFETCH      = 0x1  // Bit VDFETCH.
	LCDC_HEOVCTRL_VDMAIEN_Pos  = 0x2  // Position of VDMAIEN field.
	LCDC_HEOVCTRL_VDMAIEN_Msk  = 0x4  // Bit mask of VDMAIEN field.
	LCDC_HEOVCTRL_VDMAIEN      = 0x4  // Bit VDMAIEN.
	LCDC_HEOVCTRL_VDSCRIEN_Pos = 0x3  // Position of VDSCRIEN field.
	LCDC_HEOVCTRL_VDSCRIEN_Msk = 0x8  // Bit mask of VDSCRIEN field.
	LCDC_HEOVCTRL_VDSCRIEN     = 0x8  // Bit VDSCRIEN.
	LCDC_HEOVCTRL_VADDIEN_Pos  = 0x4  // Position of VADDIEN field.
	LCDC_HEOVCTRL_VADDIEN_Msk  = 0x10 // Bit mask of VADDIEN field.
	LCDC_HEOVCTRL_VADDIEN      = 0x10 // Bit VADDIEN.
	LCDC_HEOVCTRL_VDONEIEN_Pos = 0x5  // Position of VDONEIEN field.
	LCDC_HEOVCTRL_VDONEIEN_Msk = 0x20 // Bit mask of VDONEIEN field.
	LCDC_HEOVCTRL_VDONEIEN     = 0x20 // Bit VDONEIEN.

	// HEOVNEXT: High End Overlay VDMA Next Register
	LCDC_HEOVNEXT_VNEXT_Pos = 0x0        // Position of VNEXT field.
	LCDC_HEOVNEXT_VNEXT_Msk = 0xffffffff // Bit mask of VNEXT field.

	// HEOCFG0: High End Overlay Configuration Register 0
	LCDC_HEOCFG0_BLEN_Pos          = 0x4    // Position of BLEN field.
	LCDC_HEOCFG0_BLEN_Msk          = 0x30   // Bit mask of BLEN field.
	LCDC_HEOCFG0_BLEN_AHB_SINGLE   = 0x0    // AHB Access is started as soon as there is enough space in the FIFO to store one 32-bit data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLEN_AHB_INCR4    = 0x1    // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of four 32-bit data. An AHB INCR4 Burst is preferred. SINGLE, INCR and INCR4 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLEN_AHB_INCR8    = 0x2    // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of eight 32-bit data. An AHB INCR8 Burst is preferred. SINGLE, INCR, INCR4 and INCR8 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLEN_AHB_INCR16   = 0x3    // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of sixteen 32-bit data. An AHB INCR16 Burst is preferred. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLENUV_Pos        = 0x6    // Position of BLENUV field.
	LCDC_HEOCFG0_BLENUV_Msk        = 0xc0   // Bit mask of BLENUV field.
	LCDC_HEOCFG0_BLENUV_AHB_SINGLE = 0x0    // AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLENUV_AHB_INCR4  = 0x1    // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of four 32-bit data. An AHB INCR4 Burst is preferred. SINGLE, INCR and INCR4 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLENUV_AHB_INCR8  = 0x2    // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of 8 data. An AHB INCR8 Burst is preferred. SINGLE, INCR, INCR4 and INCR8 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_BLENUV_AHB_INCR16 = 0x3    // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of sixteen 32-bit data. An AHB INCR16 Burst is preferred. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HEOCFG0_DLBO_Pos          = 0x8    // Position of DLBO field.
	LCDC_HEOCFG0_DLBO_Msk          = 0x100  // Bit mask of DLBO field.
	LCDC_HEOCFG0_DLBO              = 0x100  // Bit DLBO.
	LCDC_HEOCFG0_ROTDIS_Pos        = 0xc    // Position of ROTDIS field.
	LCDC_HEOCFG0_ROTDIS_Msk        = 0x1000 // Bit mask of ROTDIS field.
	LCDC_HEOCFG0_ROTDIS            = 0x1000 // Bit ROTDIS.
	LCDC_HEOCFG0_LOCKDIS_Pos       = 0xd    // Position of LOCKDIS field.
	LCDC_HEOCFG0_LOCKDIS_Msk       = 0x2000 // Bit mask of LOCKDIS field.
	LCDC_HEOCFG0_LOCKDIS           = 0x2000 // Bit LOCKDIS.

	// HEOCFG1: High End Overlay Configuration Register 1
	LCDC_HEOCFG1_CLUTEN_Pos                     = 0x0     // Position of CLUTEN field.
	LCDC_HEOCFG1_CLUTEN_Msk                     = 0x1     // Bit mask of CLUTEN field.
	LCDC_HEOCFG1_CLUTEN                         = 0x1     // Bit CLUTEN.
	LCDC_HEOCFG1_YUVEN_Pos                      = 0x1     // Position of YUVEN field.
	LCDC_HEOCFG1_YUVEN_Msk                      = 0x2     // Bit mask of YUVEN field.
	LCDC_HEOCFG1_YUVEN                          = 0x2     // Bit YUVEN.
	LCDC_HEOCFG1_RGBMODE_Pos                    = 0x4     // Position of RGBMODE field.
	LCDC_HEOCFG1_RGBMODE_Msk                    = 0xf0    // Bit mask of RGBMODE field.
	LCDC_HEOCFG1_RGBMODE_12BPP_RGB_444          = 0x0     // 12 bpp RGB 444
	LCDC_HEOCFG1_RGBMODE_16BPP_ARGB_4444        = 0x1     // 16 bpp ARGB 4444
	LCDC_HEOCFG1_RGBMODE_16BPP_RGBA_4444        = 0x2     // 16 bpp RGBA 4444
	LCDC_HEOCFG1_RGBMODE_16BPP_RGB_565          = 0x3     // 16 bpp RGB 565
	LCDC_HEOCFG1_RGBMODE_16BPP_TRGB_1555        = 0x4     // 16 bpp TRGB 1555
	LCDC_HEOCFG1_RGBMODE_18BPP_RGB_666          = 0x5     // 18 bpp RGB 666
	LCDC_HEOCFG1_RGBMODE_18BPP_RGB_666_PACKED   = 0x6     // 18 bpp RGB 666 PACKED
	LCDC_HEOCFG1_RGBMODE_19BPP_TRGB_1666        = 0x7     // 19 bpp TRGB 1666
	LCDC_HEOCFG1_RGBMODE_19BPP_TRGB_PACKED      = 0x8     // 19 bpp TRGB 1666 PACKED
	LCDC_HEOCFG1_RGBMODE_24BPP_RGB_888          = 0x9     // 24 bpp RGB 888
	LCDC_HEOCFG1_RGBMODE_24BPP_RGB_888_PACKED   = 0xa     // 24 bpp RGB 888 PACKED
	LCDC_HEOCFG1_RGBMODE_25BPP_TRGB_1888        = 0xb     // 25 bpp TRGB 1888
	LCDC_HEOCFG1_RGBMODE_32BPP_ARGB_8888        = 0xc     // 32 bpp ARGB 8888
	LCDC_HEOCFG1_RGBMODE_32BPP_RGBA_8888        = 0xd     // 32 bpp RGBA 8888
	LCDC_HEOCFG1_CLUTMODE_Pos                   = 0x8     // Position of CLUTMODE field.
	LCDC_HEOCFG1_CLUTMODE_Msk                   = 0x300   // Bit mask of CLUTMODE field.
	LCDC_HEOCFG1_CLUTMODE_1BPP                  = 0x0     // color lookup table mode set to 1 bit per pixel
	LCDC_HEOCFG1_CLUTMODE_2BPP                  = 0x1     // color lookup table mode set to 2 bits per pixel
	LCDC_HEOCFG1_CLUTMODE_4BPP                  = 0x2     // color lookup table mode set to 4 bits per pixel
	LCDC_HEOCFG1_CLUTMODE_8BPP                  = 0x3     // color lookup table mode set to 8 bits per pixel
	LCDC_HEOCFG1_YUVMODE_Pos                    = 0xc     // Position of YUVMODE field.
	LCDC_HEOCFG1_YUVMODE_Msk                    = 0xf000  // Bit mask of YUVMODE field.
	LCDC_HEOCFG1_YUVMODE_32BPP_AYCBCR           = 0x0     // 32 bpp AYCbCr 444
	LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_MODE0      = 0x1     // 16 bpp Cr(n)Y(n+1)Cb(n)Y(n) 422
	LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_MODE1      = 0x2     // 16 bpp Y(n+1)Cr(n)Y(n)Cb(n) 422
	LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_MODE2      = 0x3     // 16 bpp Cb(n)Y(+1)Cr(n)Y(n) 422
	LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_MODE3      = 0x4     // 16 bpp Y(n+1)Cb(n)Y(n)Cr(n) 422
	LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_SEMIPLANAR = 0x5     // 16 bpp Semiplanar 422 YCbCr
	LCDC_HEOCFG1_YUVMODE_16BPP_YCBCR_PLANAR     = 0x6     // 16 bpp Planar 422 YCbCr
	LCDC_HEOCFG1_YUVMODE_12BPP_YCBCR_SEMIPLANAR = 0x7     // 12 bpp Semiplanar 420 YCbCr
	LCDC_HEOCFG1_YUVMODE_12BPP_YCBCR_PLANAR     = 0x8     // 12 bpp Planar 420 YCbCr
	LCDC_HEOCFG1_YUV422ROT_Pos                  = 0x10    // Position of YUV422ROT field.
	LCDC_HEOCFG1_YUV422ROT_Msk                  = 0x10000 // Bit mask of YUV422ROT field.
	LCDC_HEOCFG1_YUV422ROT                      = 0x10000 // Bit YUV422ROT.
	LCDC_HEOCFG1_YUV422SWP_Pos                  = 0x11    // Position of YUV422SWP field.
	LCDC_HEOCFG1_YUV422SWP_Msk                  = 0x20000 // Bit mask of YUV422SWP field.
	LCDC_HEOCFG1_YUV422SWP                      = 0x20000 // Bit YUV422SWP.

	// HEOCFG2: High End Overlay Configuration Register 2
	LCDC_HEOCFG2_XPOS_Pos = 0x0       // Position of XPOS field.
	LCDC_HEOCFG2_XPOS_Msk = 0x7ff     // Bit mask of XPOS field.
	LCDC_HEOCFG2_YPOS_Pos = 0x10      // Position of YPOS field.
	LCDC_HEOCFG2_YPOS_Msk = 0x7ff0000 // Bit mask of YPOS field.

	// HEOCFG3: High End Overlay Configuration Register 3
	LCDC_HEOCFG3_XSIZE_Pos = 0x0       // Position of XSIZE field.
	LCDC_HEOCFG3_XSIZE_Msk = 0x7ff     // Bit mask of XSIZE field.
	LCDC_HEOCFG3_YSIZE_Pos = 0x10      // Position of YSIZE field.
	LCDC_HEOCFG3_YSIZE_Msk = 0x7ff0000 // Bit mask of YSIZE field.

	// HEOCFG4: High End Overlay Configuration Register 4
	LCDC_HEOCFG4_XMEM_SIZE_Pos = 0x0       // Position of XMEM_SIZE field.
	LCDC_HEOCFG4_XMEM_SIZE_Msk = 0x7ff     // Bit mask of XMEM_SIZE field.
	LCDC_HEOCFG4_YMEM_SIZE_Pos = 0x10      // Position of YMEM_SIZE field.
	LCDC_HEOCFG4_YMEM_SIZE_Msk = 0x7ff0000 // Bit mask of YMEM_SIZE field.

	// HEOCFG5: High End Overlay Configuration Register 5
	LCDC_HEOCFG5_XSTRIDE_Pos = 0x0        // Position of XSTRIDE field.
	LCDC_HEOCFG5_XSTRIDE_Msk = 0xffffffff // Bit mask of XSTRIDE field.

	// HEOCFG6: High End Overlay Configuration Register 6
	LCDC_HEOCFG6_PSTRIDE_Pos = 0x0        // Position of PSTRIDE field.
	LCDC_HEOCFG6_PSTRIDE_Msk = 0xffffffff // Bit mask of PSTRIDE field.

	// HEOCFG7: High End Overlay Configuration Register 7
	LCDC_HEOCFG7_UVXSTRIDE_Pos = 0x0        // Position of UVXSTRIDE field.
	LCDC_HEOCFG7_UVXSTRIDE_Msk = 0xffffffff // Bit mask of UVXSTRIDE field.

	// HEOCFG8: High End Overlay Configuration Register 8
	LCDC_HEOCFG8_UVPSTRIDE_Pos = 0x0        // Position of UVPSTRIDE field.
	LCDC_HEOCFG8_UVPSTRIDE_Msk = 0xffffffff // Bit mask of UVPSTRIDE field.

	// HEOCFG9: High End Overlay Configuration Register 9
	LCDC_HEOCFG9_BDEF_Pos = 0x0      // Position of BDEF field.
	LCDC_HEOCFG9_BDEF_Msk = 0xff     // Bit mask of BDEF field.
	LCDC_HEOCFG9_GDEF_Pos = 0x8      // Position of GDEF field.
	LCDC_HEOCFG9_GDEF_Msk = 0xff00   // Bit mask of GDEF field.
	LCDC_HEOCFG9_RDEF_Pos = 0x10     // Position of RDEF field.
	LCDC_HEOCFG9_RDEF_Msk = 0xff0000 // Bit mask of RDEF field.

	// HEOCFG10: High End Overlay Configuration Register 10
	LCDC_HEOCFG10_BKEY_Pos = 0x0      // Position of BKEY field.
	LCDC_HEOCFG10_BKEY_Msk = 0xff     // Bit mask of BKEY field.
	LCDC_HEOCFG10_GKEY_Pos = 0x8      // Position of GKEY field.
	LCDC_HEOCFG10_GKEY_Msk = 0xff00   // Bit mask of GKEY field.
	LCDC_HEOCFG10_RKEY_Pos = 0x10     // Position of RKEY field.
	LCDC_HEOCFG10_RKEY_Msk = 0xff0000 // Bit mask of RKEY field.

	// HEOCFG11: High End Overlay Configuration Register 11
	LCDC_HEOCFG11_BMASK_Pos = 0x0      // Position of BMASK field.
	LCDC_HEOCFG11_BMASK_Msk = 0xff     // Bit mask of BMASK field.
	LCDC_HEOCFG11_GMASK_Pos = 0x8      // Position of GMASK field.
	LCDC_HEOCFG11_GMASK_Msk = 0xff00   // Bit mask of GMASK field.
	LCDC_HEOCFG11_RMASK_Pos = 0x10     // Position of RMASK field.
	LCDC_HEOCFG11_RMASK_Msk = 0xff0000 // Bit mask of RMASK field.

	// HEOCFG12: High End Overlay Configuration Register 12
	LCDC_HEOCFG12_CRKEY_Pos    = 0x0      // Position of CRKEY field.
	LCDC_HEOCFG12_CRKEY_Msk    = 0x1      // Bit mask of CRKEY field.
	LCDC_HEOCFG12_CRKEY        = 0x1      // Bit CRKEY.
	LCDC_HEOCFG12_INV_Pos      = 0x1      // Position of INV field.
	LCDC_HEOCFG12_INV_Msk      = 0x2      // Bit mask of INV field.
	LCDC_HEOCFG12_INV          = 0x2      // Bit INV.
	LCDC_HEOCFG12_ITER2BL_Pos  = 0x2      // Position of ITER2BL field.
	LCDC_HEOCFG12_ITER2BL_Msk  = 0x4      // Bit mask of ITER2BL field.
	LCDC_HEOCFG12_ITER2BL      = 0x4      // Bit ITER2BL.
	LCDC_HEOCFG12_ITER_Pos     = 0x3      // Position of ITER field.
	LCDC_HEOCFG12_ITER_Msk     = 0x8      // Bit mask of ITER field.
	LCDC_HEOCFG12_ITER         = 0x8      // Bit ITER.
	LCDC_HEOCFG12_REVALPHA_Pos = 0x4      // Position of REVALPHA field.
	LCDC_HEOCFG12_REVALPHA_Msk = 0x10     // Bit mask of REVALPHA field.
	LCDC_HEOCFG12_REVALPHA     = 0x10     // Bit REVALPHA.
	LCDC_HEOCFG12_GAEN_Pos     = 0x5      // Position of GAEN field.
	LCDC_HEOCFG12_GAEN_Msk     = 0x20     // Bit mask of GAEN field.
	LCDC_HEOCFG12_GAEN         = 0x20     // Bit GAEN.
	LCDC_HEOCFG12_LAEN_Pos     = 0x6      // Position of LAEN field.
	LCDC_HEOCFG12_LAEN_Msk     = 0x40     // Bit mask of LAEN field.
	LCDC_HEOCFG12_LAEN         = 0x40     // Bit LAEN.
	LCDC_HEOCFG12_OVR_Pos      = 0x7      // Position of OVR field.
	LCDC_HEOCFG12_OVR_Msk      = 0x80     // Bit mask of OVR field.
	LCDC_HEOCFG12_OVR          = 0x80     // Bit OVR.
	LCDC_HEOCFG12_DMA_Pos      = 0x8      // Position of DMA field.
	LCDC_HEOCFG12_DMA_Msk      = 0x100    // Bit mask of DMA field.
	LCDC_HEOCFG12_DMA          = 0x100    // Bit DMA.
	LCDC_HEOCFG12_REP_Pos      = 0x9      // Position of REP field.
	LCDC_HEOCFG12_REP_Msk      = 0x200    // Bit mask of REP field.
	LCDC_HEOCFG12_REP          = 0x200    // Bit REP.
	LCDC_HEOCFG12_DSTKEY_Pos   = 0xa      // Position of DSTKEY field.
	LCDC_HEOCFG12_DSTKEY_Msk   = 0x400    // Bit mask of DSTKEY field.
	LCDC_HEOCFG12_DSTKEY       = 0x400    // Bit DSTKEY.
	LCDC_HEOCFG12_VIDPRI_Pos   = 0xc      // Position of VIDPRI field.
	LCDC_HEOCFG12_VIDPRI_Msk   = 0x1000   // Bit mask of VIDPRI field.
	LCDC_HEOCFG12_VIDPRI       = 0x1000   // Bit VIDPRI.
	LCDC_HEOCFG12_GA_Pos       = 0x10     // Position of GA field.
	LCDC_HEOCFG12_GA_Msk       = 0xff0000 // Bit mask of GA field.

	// HEOCFG13: High End Overlay Configuration Register 13
	LCDC_HEOCFG13_XFACTOR_Pos = 0x0        // Position of XFACTOR field.
	LCDC_HEOCFG13_XFACTOR_Msk = 0x1fff     // Bit mask of XFACTOR field.
	LCDC_HEOCFG13_YFACTOR_Pos = 0x10       // Position of YFACTOR field.
	LCDC_HEOCFG13_YFACTOR_Msk = 0x1fff0000 // Bit mask of YFACTOR field.
	LCDC_HEOCFG13_SCALEN_Pos  = 0x1f       // Position of SCALEN field.
	LCDC_HEOCFG13_SCALEN_Msk  = 0x80000000 // Bit mask of SCALEN field.
	LCDC_HEOCFG13_SCALEN      = 0x80000000 // Bit SCALEN.

	// HEOCFG14: High End Overlay Configuration Register 14
	LCDC_HEOCFG14_CSCRY_Pos   = 0x0        // Position of CSCRY field.
	LCDC_HEOCFG14_CSCRY_Msk   = 0x3ff      // Bit mask of CSCRY field.
	LCDC_HEOCFG14_CSCRU_Pos   = 0xa        // Position of CSCRU field.
	LCDC_HEOCFG14_CSCRU_Msk   = 0xffc00    // Bit mask of CSCRU field.
	LCDC_HEOCFG14_CSCRV_Pos   = 0x14       // Position of CSCRV field.
	LCDC_HEOCFG14_CSCRV_Msk   = 0x3ff00000 // Bit mask of CSCRV field.
	LCDC_HEOCFG14_CSCYOFF_Pos = 0x1e       // Position of CSCYOFF field.
	LCDC_HEOCFG14_CSCYOFF_Msk = 0x40000000 // Bit mask of CSCYOFF field.
	LCDC_HEOCFG14_CSCYOFF     = 0x40000000 // Bit CSCYOFF.

	// HEOCFG15: High End Overlay Configuration Register 15
	LCDC_HEOCFG15_CSCGY_Pos   = 0x0        // Position of CSCGY field.
	LCDC_HEOCFG15_CSCGY_Msk   = 0x3ff      // Bit mask of CSCGY field.
	LCDC_HEOCFG15_CSCGU_Pos   = 0xa        // Position of CSCGU field.
	LCDC_HEOCFG15_CSCGU_Msk   = 0xffc00    // Bit mask of CSCGU field.
	LCDC_HEOCFG15_CSCGV_Pos   = 0x14       // Position of CSCGV field.
	LCDC_HEOCFG15_CSCGV_Msk   = 0x3ff00000 // Bit mask of CSCGV field.
	LCDC_HEOCFG15_CSCUOFF_Pos = 0x1e       // Position of CSCUOFF field.
	LCDC_HEOCFG15_CSCUOFF_Msk = 0x40000000 // Bit mask of CSCUOFF field.
	LCDC_HEOCFG15_CSCUOFF     = 0x40000000 // Bit CSCUOFF.

	// HEOCFG16: High End Overlay Configuration Register 16
	LCDC_HEOCFG16_CSCBY_Pos   = 0x0        // Position of CSCBY field.
	LCDC_HEOCFG16_CSCBY_Msk   = 0x3ff      // Bit mask of CSCBY field.
	LCDC_HEOCFG16_CSCBU_Pos   = 0xa        // Position of CSCBU field.
	LCDC_HEOCFG16_CSCBU_Msk   = 0xffc00    // Bit mask of CSCBU field.
	LCDC_HEOCFG16_CSCBV_Pos   = 0x14       // Position of CSCBV field.
	LCDC_HEOCFG16_CSCBV_Msk   = 0x3ff00000 // Bit mask of CSCBV field.
	LCDC_HEOCFG16_CSCVOFF_Pos = 0x1e       // Position of CSCVOFF field.
	LCDC_HEOCFG16_CSCVOFF_Msk = 0x40000000 // Bit mask of CSCVOFF field.
	LCDC_HEOCFG16_CSCVOFF     = 0x40000000 // Bit CSCVOFF.

	// HCRCHER: Hardware Cursor Channel Enable Register
	LCDC_HCRCHER_CHEN_Pos     = 0x0 // Position of CHEN field.
	LCDC_HCRCHER_CHEN_Msk     = 0x1 // Bit mask of CHEN field.
	LCDC_HCRCHER_CHEN         = 0x1 // Bit CHEN.
	LCDC_HCRCHER_UPDATEEN_Pos = 0x1 // Position of UPDATEEN field.
	LCDC_HCRCHER_UPDATEEN_Msk = 0x2 // Bit mask of UPDATEEN field.
	LCDC_HCRCHER_UPDATEEN     = 0x2 // Bit UPDATEEN.
	LCDC_HCRCHER_A2QEN_Pos    = 0x2 // Position of A2QEN field.
	LCDC_HCRCHER_A2QEN_Msk    = 0x4 // Bit mask of A2QEN field.
	LCDC_HCRCHER_A2QEN        = 0x4 // Bit A2QEN.

	// HCRCHDR: Hardware Cursor Channel Disable Register
	LCDC_HCRCHDR_CHDIS_Pos = 0x0   // Position of CHDIS field.
	LCDC_HCRCHDR_CHDIS_Msk = 0x1   // Bit mask of CHDIS field.
	LCDC_HCRCHDR_CHDIS     = 0x1   // Bit CHDIS.
	LCDC_HCRCHDR_CHRST_Pos = 0x8   // Position of CHRST field.
	LCDC_HCRCHDR_CHRST_Msk = 0x100 // Bit mask of CHRST field.
	LCDC_HCRCHDR_CHRST     = 0x100 // Bit CHRST.

	// HCRCHSR: Hardware Cursor Channel Status Register
	LCDC_HCRCHSR_CHSR_Pos     = 0x0 // Position of CHSR field.
	LCDC_HCRCHSR_CHSR_Msk     = 0x1 // Bit mask of CHSR field.
	LCDC_HCRCHSR_CHSR         = 0x1 // Bit CHSR.
	LCDC_HCRCHSR_UPDATESR_Pos = 0x1 // Position of UPDATESR field.
	LCDC_HCRCHSR_UPDATESR_Msk = 0x2 // Bit mask of UPDATESR field.
	LCDC_HCRCHSR_UPDATESR     = 0x2 // Bit UPDATESR.
	LCDC_HCRCHSR_A2QSR_Pos    = 0x2 // Position of A2QSR field.
	LCDC_HCRCHSR_A2QSR_Msk    = 0x4 // Bit mask of A2QSR field.
	LCDC_HCRCHSR_A2QSR        = 0x4 // Bit A2QSR.

	// HCRIER: Hardware Cursor Interrupt Enable Register
	LCDC_HCRIER_DMA_Pos  = 0x2  // Position of DMA field.
	LCDC_HCRIER_DMA_Msk  = 0x4  // Bit mask of DMA field.
	LCDC_HCRIER_DMA      = 0x4  // Bit DMA.
	LCDC_HCRIER_DSCR_Pos = 0x3  // Position of DSCR field.
	LCDC_HCRIER_DSCR_Msk = 0x8  // Bit mask of DSCR field.
	LCDC_HCRIER_DSCR     = 0x8  // Bit DSCR.
	LCDC_HCRIER_ADD_Pos  = 0x4  // Position of ADD field.
	LCDC_HCRIER_ADD_Msk  = 0x10 // Bit mask of ADD field.
	LCDC_HCRIER_ADD      = 0x10 // Bit ADD.
	LCDC_HCRIER_DONE_Pos = 0x5  // Position of DONE field.
	LCDC_HCRIER_DONE_Msk = 0x20 // Bit mask of DONE field.
	LCDC_HCRIER_DONE     = 0x20 // Bit DONE.
	LCDC_HCRIER_OVR_Pos  = 0x6  // Position of OVR field.
	LCDC_HCRIER_OVR_Msk  = 0x40 // Bit mask of OVR field.
	LCDC_HCRIER_OVR      = 0x40 // Bit OVR.

	// HCRIDR: Hardware Cursor Interrupt Disable Register
	LCDC_HCRIDR_DMA_Pos  = 0x2  // Position of DMA field.
	LCDC_HCRIDR_DMA_Msk  = 0x4  // Bit mask of DMA field.
	LCDC_HCRIDR_DMA      = 0x4  // Bit DMA.
	LCDC_HCRIDR_DSCR_Pos = 0x3  // Position of DSCR field.
	LCDC_HCRIDR_DSCR_Msk = 0x8  // Bit mask of DSCR field.
	LCDC_HCRIDR_DSCR     = 0x8  // Bit DSCR.
	LCDC_HCRIDR_ADD_Pos  = 0x4  // Position of ADD field.
	LCDC_HCRIDR_ADD_Msk  = 0x10 // Bit mask of ADD field.
	LCDC_HCRIDR_ADD      = 0x10 // Bit ADD.
	LCDC_HCRIDR_DONE_Pos = 0x5  // Position of DONE field.
	LCDC_HCRIDR_DONE_Msk = 0x20 // Bit mask of DONE field.
	LCDC_HCRIDR_DONE     = 0x20 // Bit DONE.
	LCDC_HCRIDR_OVR_Pos  = 0x6  // Position of OVR field.
	LCDC_HCRIDR_OVR_Msk  = 0x40 // Bit mask of OVR field.
	LCDC_HCRIDR_OVR      = 0x40 // Bit OVR.

	// HCRIMR: Hardware Cursor Interrupt Mask Register
	LCDC_HCRIMR_DMA_Pos  = 0x2  // Position of DMA field.
	LCDC_HCRIMR_DMA_Msk  = 0x4  // Bit mask of DMA field.
	LCDC_HCRIMR_DMA      = 0x4  // Bit DMA.
	LCDC_HCRIMR_DSCR_Pos = 0x3  // Position of DSCR field.
	LCDC_HCRIMR_DSCR_Msk = 0x8  // Bit mask of DSCR field.
	LCDC_HCRIMR_DSCR     = 0x8  // Bit DSCR.
	LCDC_HCRIMR_ADD_Pos  = 0x4  // Position of ADD field.
	LCDC_HCRIMR_ADD_Msk  = 0x10 // Bit mask of ADD field.
	LCDC_HCRIMR_ADD      = 0x10 // Bit ADD.
	LCDC_HCRIMR_DONE_Pos = 0x5  // Position of DONE field.
	LCDC_HCRIMR_DONE_Msk = 0x20 // Bit mask of DONE field.
	LCDC_HCRIMR_DONE     = 0x20 // Bit DONE.
	LCDC_HCRIMR_OVR_Pos  = 0x6  // Position of OVR field.
	LCDC_HCRIMR_OVR_Msk  = 0x40 // Bit mask of OVR field.
	LCDC_HCRIMR_OVR      = 0x40 // Bit OVR.

	// HCRISR: Hardware Cursor Interrupt Status Register
	LCDC_HCRISR_DMA_Pos  = 0x2  // Position of DMA field.
	LCDC_HCRISR_DMA_Msk  = 0x4  // Bit mask of DMA field.
	LCDC_HCRISR_DMA      = 0x4  // Bit DMA.
	LCDC_HCRISR_DSCR_Pos = 0x3  // Position of DSCR field.
	LCDC_HCRISR_DSCR_Msk = 0x8  // Bit mask of DSCR field.
	LCDC_HCRISR_DSCR     = 0x8  // Bit DSCR.
	LCDC_HCRISR_ADD_Pos  = 0x4  // Position of ADD field.
	LCDC_HCRISR_ADD_Msk  = 0x10 // Bit mask of ADD field.
	LCDC_HCRISR_ADD      = 0x10 // Bit ADD.
	LCDC_HCRISR_DONE_Pos = 0x5  // Position of DONE field.
	LCDC_HCRISR_DONE_Msk = 0x20 // Bit mask of DONE field.
	LCDC_HCRISR_DONE     = 0x20 // Bit DONE.
	LCDC_HCRISR_OVR_Pos  = 0x6  // Position of OVR field.
	LCDC_HCRISR_OVR_Msk  = 0x40 // Bit mask of OVR field.
	LCDC_HCRISR_OVR      = 0x40 // Bit OVR.

	// HCRHEAD: Hardware Cursor DMA Head Register
	LCDC_HCRHEAD_HEAD_Pos = 0x2        // Position of HEAD field.
	LCDC_HCRHEAD_HEAD_Msk = 0xfffffffc // Bit mask of HEAD field.

	// HCRADDR: Hardware cursor DMA Address Register
	LCDC_HCRADDR_ADDR_Pos = 0x0        // Position of ADDR field.
	LCDC_HCRADDR_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// HCRCTRL: Hardware Cursor DMA Control Register
	LCDC_HCRCTRL_DFETCH_Pos  = 0x0  // Position of DFETCH field.
	LCDC_HCRCTRL_DFETCH_Msk  = 0x1  // Bit mask of DFETCH field.
	LCDC_HCRCTRL_DFETCH      = 0x1  // Bit DFETCH.
	LCDC_HCRCTRL_LFETCH_Pos  = 0x1  // Position of LFETCH field.
	LCDC_HCRCTRL_LFETCH_Msk  = 0x2  // Bit mask of LFETCH field.
	LCDC_HCRCTRL_LFETCH      = 0x2  // Bit LFETCH.
	LCDC_HCRCTRL_DMAIEN_Pos  = 0x2  // Position of DMAIEN field.
	LCDC_HCRCTRL_DMAIEN_Msk  = 0x4  // Bit mask of DMAIEN field.
	LCDC_HCRCTRL_DMAIEN      = 0x4  // Bit DMAIEN.
	LCDC_HCRCTRL_DSCRIEN_Pos = 0x3  // Position of DSCRIEN field.
	LCDC_HCRCTRL_DSCRIEN_Msk = 0x8  // Bit mask of DSCRIEN field.
	LCDC_HCRCTRL_DSCRIEN     = 0x8  // Bit DSCRIEN.
	LCDC_HCRCTRL_ADDIEN_Pos  = 0x4  // Position of ADDIEN field.
	LCDC_HCRCTRL_ADDIEN_Msk  = 0x10 // Bit mask of ADDIEN field.
	LCDC_HCRCTRL_ADDIEN      = 0x10 // Bit ADDIEN.
	LCDC_HCRCTRL_DONEIEN_Pos = 0x5  // Position of DONEIEN field.
	LCDC_HCRCTRL_DONEIEN_Msk = 0x20 // Bit mask of DONEIEN field.
	LCDC_HCRCTRL_DONEIEN     = 0x20 // Bit DONEIEN.

	// HCRNEXT: Hardware Cursor DMA NExt Register
	LCDC_HCRNEXT_NEXT_Pos = 0x0        // Position of NEXT field.
	LCDC_HCRNEXT_NEXT_Msk = 0xffffffff // Bit mask of NEXT field.

	// HCRCFG0: Hardware Cursor Configuration 0 Register
	LCDC_HCRCFG0_BLEN_Pos        = 0x4   // Position of BLEN field.
	LCDC_HCRCFG0_BLEN_Msk        = 0x30  // Bit mask of BLEN field.
	LCDC_HCRCFG0_BLEN_AHB_SINGLE = 0x0   // AHB Access is started as soon as there is enough space in the FIFO to store one data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HCRCFG0_BLEN_AHB_INCR4  = 0x1   // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of four 32-bit data. An AHB INCR4 Burst is preferred. SINGLE, INCR and INCR4 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HCRCFG0_BLEN_AHB_INCR8  = 0x2   // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of eight 32-bit data. An AHB INCR8 Burst is preferred. SINGLE, INCR, INCR4 and INCR8 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HCRCFG0_BLEN_AHB_INCR16 = 0x3   // AHB Access is started as soon as there is enough space in the FIFO to store a total amount of sixteen 32-bit data. An AHB INCR16 Burst is preferred. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_HCRCFG0_DLBO_Pos        = 0x8   // Position of DLBO field.
	LCDC_HCRCFG0_DLBO_Msk        = 0x100 // Bit mask of DLBO field.
	LCDC_HCRCFG0_DLBO            = 0x100 // Bit DLBO.

	// HCRCFG1: Hardware Cursor Configuration 1 Register
	LCDC_HCRCFG1_CLUTEN_Pos                   = 0x0   // Position of CLUTEN field.
	LCDC_HCRCFG1_CLUTEN_Msk                   = 0x1   // Bit mask of CLUTEN field.
	LCDC_HCRCFG1_CLUTEN                       = 0x1   // Bit CLUTEN.
	LCDC_HCRCFG1_RGBMODE_Pos                  = 0x4   // Position of RGBMODE field.
	LCDC_HCRCFG1_RGBMODE_Msk                  = 0xf0  // Bit mask of RGBMODE field.
	LCDC_HCRCFG1_RGBMODE_12BPP_RGB_444        = 0x0   // 12 bpp RGB 444
	LCDC_HCRCFG1_RGBMODE_16BPP_ARGB_4444      = 0x1   // 16 bpp ARGB 4444
	LCDC_HCRCFG1_RGBMODE_16BPP_RGBA_4444      = 0x2   // 16 bpp RGBA 4444
	LCDC_HCRCFG1_RGBMODE_16BPP_RGB_565        = 0x3   // 16 bpp RGB 565
	LCDC_HCRCFG1_RGBMODE_16BPP_TRGB_1555      = 0x4   // 16 bpp TRGB 1555
	LCDC_HCRCFG1_RGBMODE_18BPP_RGB_666        = 0x5   // 18 bpp RGB 666
	LCDC_HCRCFG1_RGBMODE_18BPP_RGB_666_PACKED = 0x6   // 18 bpp RGB 666 PACKED
	LCDC_HCRCFG1_RGBMODE_19BPP_TRGB_1666      = 0x7   // 19 bpp TRGB 1666
	LCDC_HCRCFG1_RGBMODE_19BPP_TRGB_PACKED    = 0x8   // 19 bpp TRGB 1666 PACKED
	LCDC_HCRCFG1_RGBMODE_24BPP_RGB_888        = 0x9   // 24 bpp RGB 888
	LCDC_HCRCFG1_RGBMODE_24BPP_RGB_888_PACKED = 0xa   // 24 bpp RGB 888 PACKED
	LCDC_HCRCFG1_RGBMODE_25BPP_TRGB_1888      = 0xb   // 25 bpp TRGB 1888
	LCDC_HCRCFG1_RGBMODE_32BPP_ARGB_8888      = 0xc   // 32 bpp ARGB 8888
	LCDC_HCRCFG1_RGBMODE_32BPP_RGBA_8888      = 0xd   // 32 bpp RGBA 8888
	LCDC_HCRCFG1_CLUTMODE_Pos                 = 0x8   // Position of CLUTMODE field.
	LCDC_HCRCFG1_CLUTMODE_Msk                 = 0x300 // Bit mask of CLUTMODE field.
	LCDC_HCRCFG1_CLUTMODE_1BPP                = 0x0   // color lookup table mode set to 1 bit per pixel
	LCDC_HCRCFG1_CLUTMODE_2BPP                = 0x1   // color lookup table mode set to 2 bits per pixel
	LCDC_HCRCFG1_CLUTMODE_4BPP                = 0x2   // color lookup table mode set to 4 bits per pixel
	LCDC_HCRCFG1_CLUTMODE_8BPP                = 0x3   // color lookup table mode set to 8 bits per pixel

	// HCRCFG2: Hardware Cursor Configuration 2 Register
	LCDC_HCRCFG2_XPOS_Pos = 0x0       // Position of XPOS field.
	LCDC_HCRCFG2_XPOS_Msk = 0x7ff     // Bit mask of XPOS field.
	LCDC_HCRCFG2_YPOS_Pos = 0x10      // Position of YPOS field.
	LCDC_HCRCFG2_YPOS_Msk = 0x7ff0000 // Bit mask of YPOS field.

	// HCRCFG3: Hardware Cursor Configuration 3 Register
	LCDC_HCRCFG3_XSIZE_Pos = 0x0      // Position of XSIZE field.
	LCDC_HCRCFG3_XSIZE_Msk = 0x7f     // Bit mask of XSIZE field.
	LCDC_HCRCFG3_YSIZE_Pos = 0x10     // Position of YSIZE field.
	LCDC_HCRCFG3_YSIZE_Msk = 0x7f0000 // Bit mask of YSIZE field.

	// HCRCFG4: Hardware Cursor Configuration 4 Register
	LCDC_HCRCFG4_XSTRIDE_Pos = 0x0        // Position of XSTRIDE field.
	LCDC_HCRCFG4_XSTRIDE_Msk = 0xffffffff // Bit mask of XSTRIDE field.

	// HCRCFG6: Hardware Cursor Configuration 6 Register
	LCDC_HCRCFG6_BDEF_Pos = 0x0      // Position of BDEF field.
	LCDC_HCRCFG6_BDEF_Msk = 0xff     // Bit mask of BDEF field.
	LCDC_HCRCFG6_GDEF_Pos = 0x8      // Position of GDEF field.
	LCDC_HCRCFG6_GDEF_Msk = 0xff00   // Bit mask of GDEF field.
	LCDC_HCRCFG6_RDEF_Pos = 0x10     // Position of RDEF field.
	LCDC_HCRCFG6_RDEF_Msk = 0xff0000 // Bit mask of RDEF field.

	// HCRCFG7: Hardware Cursor Configuration 7 Register
	LCDC_HCRCFG7_BKEY_Pos = 0x0      // Position of BKEY field.
	LCDC_HCRCFG7_BKEY_Msk = 0xff     // Bit mask of BKEY field.
	LCDC_HCRCFG7_GKEY_Pos = 0x8      // Position of GKEY field.
	LCDC_HCRCFG7_GKEY_Msk = 0xff00   // Bit mask of GKEY field.
	LCDC_HCRCFG7_RKEY_Pos = 0x10     // Position of RKEY field.
	LCDC_HCRCFG7_RKEY_Msk = 0xff0000 // Bit mask of RKEY field.

	// HCRCFG8: Hardware Cursor Configuration 8 Register
	LCDC_HCRCFG8_BMASK_Pos = 0x0      // Position of BMASK field.
	LCDC_HCRCFG8_BMASK_Msk = 0xff     // Bit mask of BMASK field.
	LCDC_HCRCFG8_GMASK_Pos = 0x8      // Position of GMASK field.
	LCDC_HCRCFG8_GMASK_Msk = 0xff00   // Bit mask of GMASK field.
	LCDC_HCRCFG8_RMASK_Pos = 0x10     // Position of RMASK field.
	LCDC_HCRCFG8_RMASK_Msk = 0xff0000 // Bit mask of RMASK field.

	// HCRCFG9: Hardware Cursor Configuration 9 Register
	LCDC_HCRCFG9_CRKEY_Pos    = 0x0      // Position of CRKEY field.
	LCDC_HCRCFG9_CRKEY_Msk    = 0x1      // Bit mask of CRKEY field.
	LCDC_HCRCFG9_CRKEY        = 0x1      // Bit CRKEY.
	LCDC_HCRCFG9_INV_Pos      = 0x1      // Position of INV field.
	LCDC_HCRCFG9_INV_Msk      = 0x2      // Bit mask of INV field.
	LCDC_HCRCFG9_INV          = 0x2      // Bit INV.
	LCDC_HCRCFG9_ITER2BL_Pos  = 0x2      // Position of ITER2BL field.
	LCDC_HCRCFG9_ITER2BL_Msk  = 0x4      // Bit mask of ITER2BL field.
	LCDC_HCRCFG9_ITER2BL      = 0x4      // Bit ITER2BL.
	LCDC_HCRCFG9_ITER_Pos     = 0x3      // Position of ITER field.
	LCDC_HCRCFG9_ITER_Msk     = 0x8      // Bit mask of ITER field.
	LCDC_HCRCFG9_ITER         = 0x8      // Bit ITER.
	LCDC_HCRCFG9_REVALPHA_Pos = 0x4      // Position of REVALPHA field.
	LCDC_HCRCFG9_REVALPHA_Msk = 0x10     // Bit mask of REVALPHA field.
	LCDC_HCRCFG9_REVALPHA     = 0x10     // Bit REVALPHA.
	LCDC_HCRCFG9_GAEN_Pos     = 0x5      // Position of GAEN field.
	LCDC_HCRCFG9_GAEN_Msk     = 0x20     // Bit mask of GAEN field.
	LCDC_HCRCFG9_GAEN         = 0x20     // Bit GAEN.
	LCDC_HCRCFG9_LAEN_Pos     = 0x6      // Position of LAEN field.
	LCDC_HCRCFG9_LAEN_Msk     = 0x40     // Bit mask of LAEN field.
	LCDC_HCRCFG9_LAEN         = 0x40     // Bit LAEN.
	LCDC_HCRCFG9_OVR_Pos      = 0x7      // Position of OVR field.
	LCDC_HCRCFG9_OVR_Msk      = 0x80     // Bit mask of OVR field.
	LCDC_HCRCFG9_OVR          = 0x80     // Bit OVR.
	LCDC_HCRCFG9_DMA_Pos      = 0x8      // Position of DMA field.
	LCDC_HCRCFG9_DMA_Msk      = 0x100    // Bit mask of DMA field.
	LCDC_HCRCFG9_DMA          = 0x100    // Bit DMA.
	LCDC_HCRCFG9_REP_Pos      = 0x9      // Position of REP field.
	LCDC_HCRCFG9_REP_Msk      = 0x200    // Bit mask of REP field.
	LCDC_HCRCFG9_REP          = 0x200    // Bit REP.
	LCDC_HCRCFG9_DSTKEY_Pos   = 0xa      // Position of DSTKEY field.
	LCDC_HCRCFG9_DSTKEY_Msk   = 0x400    // Bit mask of DSTKEY field.
	LCDC_HCRCFG9_DSTKEY       = 0x400    // Bit DSTKEY.
	LCDC_HCRCFG9_GA_Pos       = 0x10     // Position of GA field.
	LCDC_HCRCFG9_GA_Msk       = 0xff0000 // Bit mask of GA field.

	// BASECLUT: Base CLUT Register
	LCDC_BASECLUT_BCLUT_Pos = 0x0      // Position of BCLUT field.
	LCDC_BASECLUT_BCLUT_Msk = 0xff     // Bit mask of BCLUT field.
	LCDC_BASECLUT_GCLUT_Pos = 0x8      // Position of GCLUT field.
	LCDC_BASECLUT_GCLUT_Msk = 0xff00   // Bit mask of GCLUT field.
	LCDC_BASECLUT_RCLUT_Pos = 0x10     // Position of RCLUT field.
	LCDC_BASECLUT_RCLUT_Msk = 0xff0000 // Bit mask of RCLUT field.

	// OVR1CLUT: Overlay 1 CLUT Register
	LCDC_OVR1CLUT_BCLUT_Pos = 0x0        // Position of BCLUT field.
	LCDC_OVR1CLUT_BCLUT_Msk = 0xff       // Bit mask of BCLUT field.
	LCDC_OVR1CLUT_GCLUT_Pos = 0x8        // Position of GCLUT field.
	LCDC_OVR1CLUT_GCLUT_Msk = 0xff00     // Bit mask of GCLUT field.
	LCDC_OVR1CLUT_RCLUT_Pos = 0x10       // Position of RCLUT field.
	LCDC_OVR1CLUT_RCLUT_Msk = 0xff0000   // Bit mask of RCLUT field.
	LCDC_OVR1CLUT_ACLUT_Pos = 0x18       // Position of ACLUT field.
	LCDC_OVR1CLUT_ACLUT_Msk = 0xff000000 // Bit mask of ACLUT field.

	// HEOCLUT: High End Overlay CLUT Register
	LCDC_HEOCLUT_BCLUT_Pos = 0x0        // Position of BCLUT field.
	LCDC_HEOCLUT_BCLUT_Msk = 0xff       // Bit mask of BCLUT field.
	LCDC_HEOCLUT_GCLUT_Pos = 0x8        // Position of GCLUT field.
	LCDC_HEOCLUT_GCLUT_Msk = 0xff00     // Bit mask of GCLUT field.
	LCDC_HEOCLUT_RCLUT_Pos = 0x10       // Position of RCLUT field.
	LCDC_HEOCLUT_RCLUT_Msk = 0xff0000   // Bit mask of RCLUT field.
	LCDC_HEOCLUT_ACLUT_Pos = 0x18       // Position of ACLUT field.
	LCDC_HEOCLUT_ACLUT_Msk = 0xff000000 // Bit mask of ACLUT field.

	// HCRCLUT: Hardware Cursor CLUT Register
	LCDC_HCRCLUT_BCLUT_Pos = 0x0        // Position of BCLUT field.
	LCDC_HCRCLUT_BCLUT_Msk = 0xff       // Bit mask of BCLUT field.
	LCDC_HCRCLUT_GCLUT_Pos = 0x8        // Position of GCLUT field.
	LCDC_HCRCLUT_GCLUT_Msk = 0xff00     // Bit mask of GCLUT field.
	LCDC_HCRCLUT_RCLUT_Pos = 0x10       // Position of RCLUT field.
	LCDC_HCRCLUT_RCLUT_Msk = 0xff0000   // Bit mask of RCLUT field.
	LCDC_HCRCLUT_ACLUT_Pos = 0x18       // Position of ACLUT field.
	LCDC_HCRCLUT_ACLUT_Msk = 0xff000000 // Bit mask of ACLUT field.
)

// Bitfields for UDPHS: USB High Speed Device Port
const (
	// CTRL: UDPHS Control Register
	UDPHS_CTRL_DEV_ADDR_Pos  = 0x0   // Position of DEV_ADDR field.
	UDPHS_CTRL_DEV_ADDR_Msk  = 0x7f  // Bit mask of DEV_ADDR field.
	UDPHS_CTRL_FADDR_EN_Pos  = 0x7   // Position of FADDR_EN field.
	UDPHS_CTRL_FADDR_EN_Msk  = 0x80  // Bit mask of FADDR_EN field.
	UDPHS_CTRL_FADDR_EN      = 0x80  // Bit FADDR_EN.
	UDPHS_CTRL_EN_UDPHS_Pos  = 0x8   // Position of EN_UDPHS field.
	UDPHS_CTRL_EN_UDPHS_Msk  = 0x100 // Bit mask of EN_UDPHS field.
	UDPHS_CTRL_EN_UDPHS      = 0x100 // Bit EN_UDPHS.
	UDPHS_CTRL_DETACH_Pos    = 0x9   // Position of DETACH field.
	UDPHS_CTRL_DETACH_Msk    = 0x200 // Bit mask of DETACH field.
	UDPHS_CTRL_DETACH        = 0x200 // Bit DETACH.
	UDPHS_CTRL_REWAKEUP_Pos  = 0xa   // Position of REWAKEUP field.
	UDPHS_CTRL_REWAKEUP_Msk  = 0x400 // Bit mask of REWAKEUP field.
	UDPHS_CTRL_REWAKEUP      = 0x400 // Bit REWAKEUP.
	UDPHS_CTRL_PULLD_DIS_Pos = 0xb   // Position of PULLD_DIS field.
	UDPHS_CTRL_PULLD_DIS_Msk = 0x800 // Bit mask of PULLD_DIS field.
	UDPHS_CTRL_PULLD_DIS     = 0x800 // Bit PULLD_DIS.

	// FNUM: UDPHS Frame Number Register
	UDPHS_FNUM_MICRO_FRAME_NUM_Pos = 0x0        // Position of MICRO_FRAME_NUM field.
	UDPHS_FNUM_MICRO_FRAME_NUM_Msk = 0x7        // Bit mask of MICRO_FRAME_NUM field.
	UDPHS_FNUM_FRAME_NUMBER_Pos    = 0x3        // Position of FRAME_NUMBER field.
	UDPHS_FNUM_FRAME_NUMBER_Msk    = 0x3ff8     // Bit mask of FRAME_NUMBER field.
	UDPHS_FNUM_FNUM_ERR_Pos        = 0x1f       // Position of FNUM_ERR field.
	UDPHS_FNUM_FNUM_ERR_Msk        = 0x80000000 // Bit mask of FNUM_ERR field.
	UDPHS_FNUM_FNUM_ERR            = 0x80000000 // Bit FNUM_ERR.

	// IEN: UDPHS Interrupt Enable Register
	UDPHS_IEN_DET_SUSPD_Pos = 0x1        // Position of DET_SUSPD field.
	UDPHS_IEN_DET_SUSPD_Msk = 0x2        // Bit mask of DET_SUSPD field.
	UDPHS_IEN_DET_SUSPD     = 0x2        // Bit DET_SUSPD.
	UDPHS_IEN_MICRO_SOF_Pos = 0x2        // Position of MICRO_SOF field.
	UDPHS_IEN_MICRO_SOF_Msk = 0x4        // Bit mask of MICRO_SOF field.
	UDPHS_IEN_MICRO_SOF     = 0x4        // Bit MICRO_SOF.
	UDPHS_IEN_INT_SOF_Pos   = 0x3        // Position of INT_SOF field.
	UDPHS_IEN_INT_SOF_Msk   = 0x8        // Bit mask of INT_SOF field.
	UDPHS_IEN_INT_SOF       = 0x8        // Bit INT_SOF.
	UDPHS_IEN_ENDRESET_Pos  = 0x4        // Position of ENDRESET field.
	UDPHS_IEN_ENDRESET_Msk  = 0x10       // Bit mask of ENDRESET field.
	UDPHS_IEN_ENDRESET      = 0x10       // Bit ENDRESET.
	UDPHS_IEN_WAKE_UP_Pos   = 0x5        // Position of WAKE_UP field.
	UDPHS_IEN_WAKE_UP_Msk   = 0x20       // Bit mask of WAKE_UP field.
	UDPHS_IEN_WAKE_UP       = 0x20       // Bit WAKE_UP.
	UDPHS_IEN_ENDOFRSM_Pos  = 0x6        // Position of ENDOFRSM field.
	UDPHS_IEN_ENDOFRSM_Msk  = 0x40       // Bit mask of ENDOFRSM field.
	UDPHS_IEN_ENDOFRSM      = 0x40       // Bit ENDOFRSM.
	UDPHS_IEN_UPSTR_RES_Pos = 0x7        // Position of UPSTR_RES field.
	UDPHS_IEN_UPSTR_RES_Msk = 0x80       // Bit mask of UPSTR_RES field.
	UDPHS_IEN_UPSTR_RES     = 0x80       // Bit UPSTR_RES.
	UDPHS_IEN_EPT_0_Pos     = 0x8        // Position of EPT_0 field.
	UDPHS_IEN_EPT_0_Msk     = 0x100      // Bit mask of EPT_0 field.
	UDPHS_IEN_EPT_0         = 0x100      // Bit EPT_0.
	UDPHS_IEN_EPT_1_Pos     = 0x9        // Position of EPT_1 field.
	UDPHS_IEN_EPT_1_Msk     = 0x200      // Bit mask of EPT_1 field.
	UDPHS_IEN_EPT_1         = 0x200      // Bit EPT_1.
	UDPHS_IEN_EPT_2_Pos     = 0xa        // Position of EPT_2 field.
	UDPHS_IEN_EPT_2_Msk     = 0x400      // Bit mask of EPT_2 field.
	UDPHS_IEN_EPT_2         = 0x400      // Bit EPT_2.
	UDPHS_IEN_EPT_3_Pos     = 0xb        // Position of EPT_3 field.
	UDPHS_IEN_EPT_3_Msk     = 0x800      // Bit mask of EPT_3 field.
	UDPHS_IEN_EPT_3         = 0x800      // Bit EPT_3.
	UDPHS_IEN_EPT_4_Pos     = 0xc        // Position of EPT_4 field.
	UDPHS_IEN_EPT_4_Msk     = 0x1000     // Bit mask of EPT_4 field.
	UDPHS_IEN_EPT_4         = 0x1000     // Bit EPT_4.
	UDPHS_IEN_EPT_5_Pos     = 0xd        // Position of EPT_5 field.
	UDPHS_IEN_EPT_5_Msk     = 0x2000     // Bit mask of EPT_5 field.
	UDPHS_IEN_EPT_5         = 0x2000     // Bit EPT_5.
	UDPHS_IEN_EPT_6_Pos     = 0xe        // Position of EPT_6 field.
	UDPHS_IEN_EPT_6_Msk     = 0x4000     // Bit mask of EPT_6 field.
	UDPHS_IEN_EPT_6         = 0x4000     // Bit EPT_6.
	UDPHS_IEN_DMA_1_Pos     = 0x19       // Position of DMA_1 field.
	UDPHS_IEN_DMA_1_Msk     = 0x2000000  // Bit mask of DMA_1 field.
	UDPHS_IEN_DMA_1         = 0x2000000  // Bit DMA_1.
	UDPHS_IEN_DMA_2_Pos     = 0x1a       // Position of DMA_2 field.
	UDPHS_IEN_DMA_2_Msk     = 0x4000000  // Bit mask of DMA_2 field.
	UDPHS_IEN_DMA_2         = 0x4000000  // Bit DMA_2.
	UDPHS_IEN_DMA_3_Pos     = 0x1b       // Position of DMA_3 field.
	UDPHS_IEN_DMA_3_Msk     = 0x8000000  // Bit mask of DMA_3 field.
	UDPHS_IEN_DMA_3         = 0x8000000  // Bit DMA_3.
	UDPHS_IEN_DMA_4_Pos     = 0x1c       // Position of DMA_4 field.
	UDPHS_IEN_DMA_4_Msk     = 0x10000000 // Bit mask of DMA_4 field.
	UDPHS_IEN_DMA_4         = 0x10000000 // Bit DMA_4.
	UDPHS_IEN_DMA_5_Pos     = 0x1d       // Position of DMA_5 field.
	UDPHS_IEN_DMA_5_Msk     = 0x20000000 // Bit mask of DMA_5 field.
	UDPHS_IEN_DMA_5         = 0x20000000 // Bit DMA_5.
	UDPHS_IEN_DMA_6_Pos     = 0x1e       // Position of DMA_6 field.
	UDPHS_IEN_DMA_6_Msk     = 0x40000000 // Bit mask of DMA_6 field.
	UDPHS_IEN_DMA_6         = 0x40000000 // Bit DMA_6.

	// INTSTA: UDPHS Interrupt Status Register
	UDPHS_INTSTA_SPEED_Pos     = 0x0        // Position of SPEED field.
	UDPHS_INTSTA_SPEED_Msk     = 0x1        // Bit mask of SPEED field.
	UDPHS_INTSTA_SPEED         = 0x1        // Bit SPEED.
	UDPHS_INTSTA_DET_SUSPD_Pos = 0x1        // Position of DET_SUSPD field.
	UDPHS_INTSTA_DET_SUSPD_Msk = 0x2        // Bit mask of DET_SUSPD field.
	UDPHS_INTSTA_DET_SUSPD     = 0x2        // Bit DET_SUSPD.
	UDPHS_INTSTA_MICRO_SOF_Pos = 0x2        // Position of MICRO_SOF field.
	UDPHS_INTSTA_MICRO_SOF_Msk = 0x4        // Bit mask of MICRO_SOF field.
	UDPHS_INTSTA_MICRO_SOF     = 0x4        // Bit MICRO_SOF.
	UDPHS_INTSTA_INT_SOF_Pos   = 0x3        // Position of INT_SOF field.
	UDPHS_INTSTA_INT_SOF_Msk   = 0x8        // Bit mask of INT_SOF field.
	UDPHS_INTSTA_INT_SOF       = 0x8        // Bit INT_SOF.
	UDPHS_INTSTA_ENDRESET_Pos  = 0x4        // Position of ENDRESET field.
	UDPHS_INTSTA_ENDRESET_Msk  = 0x10       // Bit mask of ENDRESET field.
	UDPHS_INTSTA_ENDRESET      = 0x10       // Bit ENDRESET.
	UDPHS_INTSTA_WAKE_UP_Pos   = 0x5        // Position of WAKE_UP field.
	UDPHS_INTSTA_WAKE_UP_Msk   = 0x20       // Bit mask of WAKE_UP field.
	UDPHS_INTSTA_WAKE_UP       = 0x20       // Bit WAKE_UP.
	UDPHS_INTSTA_ENDOFRSM_Pos  = 0x6        // Position of ENDOFRSM field.
	UDPHS_INTSTA_ENDOFRSM_Msk  = 0x40       // Bit mask of ENDOFRSM field.
	UDPHS_INTSTA_ENDOFRSM      = 0x40       // Bit ENDOFRSM.
	UDPHS_INTSTA_UPSTR_RES_Pos = 0x7        // Position of UPSTR_RES field.
	UDPHS_INTSTA_UPSTR_RES_Msk = 0x80       // Bit mask of UPSTR_RES field.
	UDPHS_INTSTA_UPSTR_RES     = 0x80       // Bit UPSTR_RES.
	UDPHS_INTSTA_EPT_0_Pos     = 0x8        // Position of EPT_0 field.
	UDPHS_INTSTA_EPT_0_Msk     = 0x100      // Bit mask of EPT_0 field.
	UDPHS_INTSTA_EPT_0         = 0x100      // Bit EPT_0.
	UDPHS_INTSTA_EPT_1_Pos     = 0x9        // Position of EPT_1 field.
	UDPHS_INTSTA_EPT_1_Msk     = 0x200      // Bit mask of EPT_1 field.
	UDPHS_INTSTA_EPT_1         = 0x200      // Bit EPT_1.
	UDPHS_INTSTA_EPT_2_Pos     = 0xa        // Position of EPT_2 field.
	UDPHS_INTSTA_EPT_2_Msk     = 0x400      // Bit mask of EPT_2 field.
	UDPHS_INTSTA_EPT_2         = 0x400      // Bit EPT_2.
	UDPHS_INTSTA_EPT_3_Pos     = 0xb        // Position of EPT_3 field.
	UDPHS_INTSTA_EPT_3_Msk     = 0x800      // Bit mask of EPT_3 field.
	UDPHS_INTSTA_EPT_3         = 0x800      // Bit EPT_3.
	UDPHS_INTSTA_EPT_4_Pos     = 0xc        // Position of EPT_4 field.
	UDPHS_INTSTA_EPT_4_Msk     = 0x1000     // Bit mask of EPT_4 field.
	UDPHS_INTSTA_EPT_4         = 0x1000     // Bit EPT_4.
	UDPHS_INTSTA_EPT_5_Pos     = 0xd        // Position of EPT_5 field.
	UDPHS_INTSTA_EPT_5_Msk     = 0x2000     // Bit mask of EPT_5 field.
	UDPHS_INTSTA_EPT_5         = 0x2000     // Bit EPT_5.
	UDPHS_INTSTA_EPT_6_Pos     = 0xe        // Position of EPT_6 field.
	UDPHS_INTSTA_EPT_6_Msk     = 0x4000     // Bit mask of EPT_6 field.
	UDPHS_INTSTA_EPT_6         = 0x4000     // Bit EPT_6.
	UDPHS_INTSTA_DMA_1_Pos     = 0x19       // Position of DMA_1 field.
	UDPHS_INTSTA_DMA_1_Msk     = 0x2000000  // Bit mask of DMA_1 field.
	UDPHS_INTSTA_DMA_1         = 0x2000000  // Bit DMA_1.
	UDPHS_INTSTA_DMA_2_Pos     = 0x1a       // Position of DMA_2 field.
	UDPHS_INTSTA_DMA_2_Msk     = 0x4000000  // Bit mask of DMA_2 field.
	UDPHS_INTSTA_DMA_2         = 0x4000000  // Bit DMA_2.
	UDPHS_INTSTA_DMA_3_Pos     = 0x1b       // Position of DMA_3 field.
	UDPHS_INTSTA_DMA_3_Msk     = 0x8000000  // Bit mask of DMA_3 field.
	UDPHS_INTSTA_DMA_3         = 0x8000000  // Bit DMA_3.
	UDPHS_INTSTA_DMA_4_Pos     = 0x1c       // Position of DMA_4 field.
	UDPHS_INTSTA_DMA_4_Msk     = 0x10000000 // Bit mask of DMA_4 field.
	UDPHS_INTSTA_DMA_4         = 0x10000000 // Bit DMA_4.
	UDPHS_INTSTA_DMA_5_Pos     = 0x1d       // Position of DMA_5 field.
	UDPHS_INTSTA_DMA_5_Msk     = 0x20000000 // Bit mask of DMA_5 field.
	UDPHS_INTSTA_DMA_5         = 0x20000000 // Bit DMA_5.
	UDPHS_INTSTA_DMA_6_Pos     = 0x1e       // Position of DMA_6 field.
	UDPHS_INTSTA_DMA_6_Msk     = 0x40000000 // Bit mask of DMA_6 field.
	UDPHS_INTSTA_DMA_6         = 0x40000000 // Bit DMA_6.

	// CLRINT: UDPHS Clear Interrupt Register
	UDPHS_CLRINT_DET_SUSPD_Pos = 0x1  // Position of DET_SUSPD field.
	UDPHS_CLRINT_DET_SUSPD_Msk = 0x2  // Bit mask of DET_SUSPD field.
	UDPHS_CLRINT_DET_SUSPD     = 0x2  // Bit DET_SUSPD.
	UDPHS_CLRINT_MICRO_SOF_Pos = 0x2  // Position of MICRO_SOF field.
	UDPHS_CLRINT_MICRO_SOF_Msk = 0x4  // Bit mask of MICRO_SOF field.
	UDPHS_CLRINT_MICRO_SOF     = 0x4  // Bit MICRO_SOF.
	UDPHS_CLRINT_INT_SOF_Pos   = 0x3  // Position of INT_SOF field.
	UDPHS_CLRINT_INT_SOF_Msk   = 0x8  // Bit mask of INT_SOF field.
	UDPHS_CLRINT_INT_SOF       = 0x8  // Bit INT_SOF.
	UDPHS_CLRINT_ENDRESET_Pos  = 0x4  // Position of ENDRESET field.
	UDPHS_CLRINT_ENDRESET_Msk  = 0x10 // Bit mask of ENDRESET field.
	UDPHS_CLRINT_ENDRESET      = 0x10 // Bit ENDRESET.
	UDPHS_CLRINT_WAKE_UP_Pos   = 0x5  // Position of WAKE_UP field.
	UDPHS_CLRINT_WAKE_UP_Msk   = 0x20 // Bit mask of WAKE_UP field.
	UDPHS_CLRINT_WAKE_UP       = 0x20 // Bit WAKE_UP.
	UDPHS_CLRINT_ENDOFRSM_Pos  = 0x6  // Position of ENDOFRSM field.
	UDPHS_CLRINT_ENDOFRSM_Msk  = 0x40 // Bit mask of ENDOFRSM field.
	UDPHS_CLRINT_ENDOFRSM      = 0x40 // Bit ENDOFRSM.
	UDPHS_CLRINT_UPSTR_RES_Pos = 0x7  // Position of UPSTR_RES field.
	UDPHS_CLRINT_UPSTR_RES_Msk = 0x80 // Bit mask of UPSTR_RES field.
	UDPHS_CLRINT_UPSTR_RES     = 0x80 // Bit UPSTR_RES.

	// EPTRST: UDPHS Endpoints Reset Register
	UDPHS_EPTRST_EPT_0_Pos = 0x0  // Position of EPT_0 field.
	UDPHS_EPTRST_EPT_0_Msk = 0x1  // Bit mask of EPT_0 field.
	UDPHS_EPTRST_EPT_0     = 0x1  // Bit EPT_0.
	UDPHS_EPTRST_EPT_1_Pos = 0x1  // Position of EPT_1 field.
	UDPHS_EPTRST_EPT_1_Msk = 0x2  // Bit mask of EPT_1 field.
	UDPHS_EPTRST_EPT_1     = 0x2  // Bit EPT_1.
	UDPHS_EPTRST_EPT_2_Pos = 0x2  // Position of EPT_2 field.
	UDPHS_EPTRST_EPT_2_Msk = 0x4  // Bit mask of EPT_2 field.
	UDPHS_EPTRST_EPT_2     = 0x4  // Bit EPT_2.
	UDPHS_EPTRST_EPT_3_Pos = 0x3  // Position of EPT_3 field.
	UDPHS_EPTRST_EPT_3_Msk = 0x8  // Bit mask of EPT_3 field.
	UDPHS_EPTRST_EPT_3     = 0x8  // Bit EPT_3.
	UDPHS_EPTRST_EPT_4_Pos = 0x4  // Position of EPT_4 field.
	UDPHS_EPTRST_EPT_4_Msk = 0x10 // Bit mask of EPT_4 field.
	UDPHS_EPTRST_EPT_4     = 0x10 // Bit EPT_4.
	UDPHS_EPTRST_EPT_5_Pos = 0x5  // Position of EPT_5 field.
	UDPHS_EPTRST_EPT_5_Msk = 0x20 // Bit mask of EPT_5 field.
	UDPHS_EPTRST_EPT_5     = 0x20 // Bit EPT_5.
	UDPHS_EPTRST_EPT_6_Pos = 0x6  // Position of EPT_6 field.
	UDPHS_EPTRST_EPT_6_Msk = 0x40 // Bit mask of EPT_6 field.
	UDPHS_EPTRST_EPT_6     = 0x40 // Bit EPT_6.

	// TST: UDPHS Test Register
	UDPHS_TST_SPEED_CFG_Pos        = 0x0  // Position of SPEED_CFG field.
	UDPHS_TST_SPEED_CFG_Msk        = 0x3  // Bit mask of SPEED_CFG field.
	UDPHS_TST_SPEED_CFG_NORMAL     = 0x0  // Normal Mode: The macro is in Full Speed mode, ready to make a High Speed identification, if the host supports it and then to automatically switch to High Speed mode
	UDPHS_TST_SPEED_CFG_HIGH_SPEED = 0x2  // Force High Speed: Set this value to force the hardware to work in High Speed mode. Only for debug or test purpose.
	UDPHS_TST_SPEED_CFG_FULL_SPEED = 0x3  // Force Full Speed: Set this value to force the hardware to work only in Full Speed mode. In this configuration, the macro will not respond to a High Speed reset handshake.
	UDPHS_TST_TST_J_Pos            = 0x2  // Position of TST_J field.
	UDPHS_TST_TST_J_Msk            = 0x4  // Bit mask of TST_J field.
	UDPHS_TST_TST_J                = 0x4  // Bit TST_J.
	UDPHS_TST_TST_K_Pos            = 0x3  // Position of TST_K field.
	UDPHS_TST_TST_K_Msk            = 0x8  // Bit mask of TST_K field.
	UDPHS_TST_TST_K                = 0x8  // Bit TST_K.
	UDPHS_TST_TST_PKT_Pos          = 0x4  // Position of TST_PKT field.
	UDPHS_TST_TST_PKT_Msk          = 0x10 // Bit mask of TST_PKT field.
	UDPHS_TST_TST_PKT              = 0x10 // Bit TST_PKT.
	UDPHS_TST_OPMODE2_Pos          = 0x5  // Position of OPMODE2 field.
	UDPHS_TST_OPMODE2_Msk          = 0x20 // Bit mask of OPMODE2 field.
	UDPHS_TST_OPMODE2              = 0x20 // Bit OPMODE2.

	// EPTCFG0: UDPHS Endpoint Configuration Register (endpoint = 0)
	UDPHS_EPTCFG0_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG0_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG0_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG0_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG0_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG0_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG0_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG0_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG0_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG0_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG0_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG0_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG0_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG0_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG0_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG0_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG0_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG0_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG0_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG0_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG0_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG0_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG0_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG0_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG0_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG0_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG0_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG0_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG0_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG0_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB0: UDPHS Endpoint Control Enable Register (endpoint = 0)
	UDPHS_EPTCTLENB0_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB0_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB0_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB0_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB0_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB0_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB0_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB0_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB0_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB0_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB0_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB0_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB0_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB0_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB0_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB0_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB0_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB0_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB0_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB0_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB0_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB0_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB0_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB0_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB0_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB0_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB0_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB0_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB0_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB0_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB0_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB0_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB0_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB0_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB0_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 0)
	UDPHS_EPTCTLENB0_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB0_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB0_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB0_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB0_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB0_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB0_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB0_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB0_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB0_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB0_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB0_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB0_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB0_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB0_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB0_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB0_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB0_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB0_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB0_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS0: UDPHS Endpoint Control Disable Register (endpoint = 0)
	UDPHS_EPTCTLDIS0_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS0_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS0_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS0_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS0_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS0_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS0_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS0_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS0_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS0_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS0_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS0_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS0_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS0_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS0_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS0_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS0_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS0_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS0_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS0_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS0_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS0_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS0_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS0_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS0_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS0_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS0_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 0)
	UDPHS_EPTCTLDIS0_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS0_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS0_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS0_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS0_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS0_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS0_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS0_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS0_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS0_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL0: UDPHS Endpoint Control Register (endpoint = 0)
	UDPHS_EPTCTL0_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL0_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL0_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL0_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL0_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL0_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL0_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL0_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL0_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL0_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL0_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL0_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL0_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL0_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL0_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL0_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL0_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL0_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL0_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL0_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL0_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL0_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL0_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL0_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL0_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL0_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL0_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL0_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL0_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL0_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL0_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL0_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL0_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL0_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL0_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL0_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL0_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL0_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL0_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL0_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL0_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL0_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL0_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 0)
	UDPHS_EPTCTL0_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL0_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL0_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL0_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL0_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL0_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL0_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL0_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL0_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL0_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL0_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL0_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL0_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL0_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL0_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL0_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL0_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL0_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL0_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL0_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL0_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL0_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL0_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL0_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL0_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL0_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL0_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL0_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL0_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL0_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL0_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA0: UDPHS Endpoint Set Status Register (endpoint = 0)
	UDPHS_EPTSETSTA0_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA0_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA0_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA0_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA0_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA0_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA0_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA0_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 0)
	UDPHS_EPTSETSTA0_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA0_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA0_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA0_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA0: UDPHS Endpoint Clear Status Register (endpoint = 0)
	UDPHS_EPTCLRSTA0_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA0_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA0_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA0_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA0_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA0_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA0_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA0_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA0_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA0_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA0_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA0_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA0_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA0_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA0_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA0_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA0_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA0_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA0_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 0)
	UDPHS_EPTCLRSTA0_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA0_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA0_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA0: UDPHS Endpoint Status Register (endpoint = 0)
	UDPHS_EPTSTA0_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA0_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA0_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA0_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA0_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA0_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA0_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA0_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA0_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA0_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA0_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA0_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA0_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA0_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA0_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA0_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA0_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA0_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA0_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA0_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA0_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA0_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA0_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA0_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA0_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA0_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA0_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA0_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA0_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA0_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA0_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA0_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA0_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA0_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA0_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA0_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA0_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA0_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA0_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA0_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA0_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA0_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 0)
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA0_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA0_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA0_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA0_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA0_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA0_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA0_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA0_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA0_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA0_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA0_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA0_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA0_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA0_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA0_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA0_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA0_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA0_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA0_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA0_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA0_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTCFG1: UDPHS Endpoint Configuration Register (endpoint = 1)
	UDPHS_EPTCFG1_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG1_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG1_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG1_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG1_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG1_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG1_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG1_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG1_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG1_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG1_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG1_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG1_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG1_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG1_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG1_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG1_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG1_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG1_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG1_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG1_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG1_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG1_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG1_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG1_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG1_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG1_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG1_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG1_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG1_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB1: UDPHS Endpoint Control Enable Register (endpoint = 1)
	UDPHS_EPTCTLENB1_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB1_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB1_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB1_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB1_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB1_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB1_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB1_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB1_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB1_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB1_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB1_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB1_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB1_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB1_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB1_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB1_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB1_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB1_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB1_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB1_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB1_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB1_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB1_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB1_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB1_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB1_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB1_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB1_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB1_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB1_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB1_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB1_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB1_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB1_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 1)
	UDPHS_EPTCTLENB1_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB1_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB1_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB1_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB1_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB1_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB1_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB1_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB1_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB1_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB1_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB1_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB1_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB1_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB1_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB1_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB1_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB1_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB1_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB1_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS1: UDPHS Endpoint Control Disable Register (endpoint = 1)
	UDPHS_EPTCTLDIS1_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS1_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS1_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS1_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS1_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS1_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS1_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS1_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS1_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS1_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS1_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS1_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS1_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS1_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS1_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS1_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS1_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS1_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS1_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS1_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS1_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS1_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS1_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS1_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS1_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS1_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS1_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 1)
	UDPHS_EPTCTLDIS1_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS1_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS1_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS1_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS1_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS1_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS1_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS1_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS1_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS1_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL1: UDPHS Endpoint Control Register (endpoint = 1)
	UDPHS_EPTCTL1_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL1_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL1_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL1_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL1_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL1_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL1_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL1_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL1_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL1_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL1_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL1_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL1_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL1_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL1_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL1_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL1_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL1_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL1_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL1_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL1_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL1_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL1_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL1_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL1_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL1_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL1_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL1_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL1_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL1_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL1_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL1_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL1_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL1_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL1_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL1_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL1_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL1_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL1_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL1_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL1_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL1_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL1_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 1)
	UDPHS_EPTCTL1_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL1_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL1_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL1_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL1_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL1_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL1_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL1_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL1_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL1_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL1_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL1_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL1_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL1_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL1_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL1_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL1_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL1_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL1_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL1_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL1_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL1_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL1_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL1_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL1_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL1_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL1_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL1_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL1_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL1_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL1_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA1: UDPHS Endpoint Set Status Register (endpoint = 1)
	UDPHS_EPTSETSTA1_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA1_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA1_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA1_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA1_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA1_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA1_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA1_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 1)
	UDPHS_EPTSETSTA1_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA1_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA1_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA1_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA1: UDPHS Endpoint Clear Status Register (endpoint = 1)
	UDPHS_EPTCLRSTA1_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA1_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA1_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA1_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA1_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA1_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA1_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA1_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA1_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA1_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA1_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA1_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA1_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA1_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA1_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA1_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA1_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA1_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA1_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 1)
	UDPHS_EPTCLRSTA1_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA1_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA1_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA1: UDPHS Endpoint Status Register (endpoint = 1)
	UDPHS_EPTSTA1_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA1_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA1_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA1_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA1_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA1_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA1_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA1_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA1_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA1_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA1_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA1_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA1_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA1_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA1_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA1_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA1_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA1_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA1_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA1_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA1_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA1_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA1_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA1_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA1_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA1_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA1_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA1_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA1_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA1_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA1_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA1_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA1_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA1_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA1_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA1_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA1_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA1_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA1_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA1_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA1_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA1_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 1)
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA1_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA1_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA1_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA1_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA1_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA1_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA1_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA1_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA1_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA1_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA1_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA1_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA1_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA1_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA1_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA1_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA1_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA1_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA1_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA1_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA1_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTCFG2: UDPHS Endpoint Configuration Register (endpoint = 2)
	UDPHS_EPTCFG2_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG2_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG2_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG2_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG2_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG2_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG2_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG2_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG2_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG2_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG2_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG2_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG2_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG2_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG2_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG2_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG2_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG2_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG2_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG2_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG2_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG2_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG2_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG2_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG2_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG2_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG2_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG2_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG2_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG2_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB2: UDPHS Endpoint Control Enable Register (endpoint = 2)
	UDPHS_EPTCTLENB2_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB2_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB2_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB2_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB2_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB2_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB2_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB2_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB2_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB2_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB2_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB2_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB2_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB2_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB2_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB2_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB2_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB2_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB2_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB2_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB2_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB2_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB2_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB2_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB2_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB2_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB2_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB2_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB2_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB2_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB2_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB2_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB2_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB2_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB2_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 2)
	UDPHS_EPTCTLENB2_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB2_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB2_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB2_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB2_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB2_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB2_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB2_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB2_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB2_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB2_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB2_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB2_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB2_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB2_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB2_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB2_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB2_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB2_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB2_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS2: UDPHS Endpoint Control Disable Register (endpoint = 2)
	UDPHS_EPTCTLDIS2_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS2_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS2_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS2_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS2_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS2_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS2_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS2_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS2_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS2_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS2_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS2_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS2_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS2_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS2_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS2_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS2_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS2_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS2_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS2_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS2_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS2_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS2_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS2_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS2_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS2_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS2_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 2)
	UDPHS_EPTCTLDIS2_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS2_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS2_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS2_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS2_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS2_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS2_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS2_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS2_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS2_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL2: UDPHS Endpoint Control Register (endpoint = 2)
	UDPHS_EPTCTL2_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL2_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL2_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL2_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL2_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL2_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL2_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL2_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL2_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL2_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL2_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL2_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL2_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL2_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL2_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL2_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL2_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL2_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL2_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL2_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL2_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL2_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL2_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL2_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL2_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL2_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL2_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL2_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL2_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL2_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL2_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL2_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL2_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL2_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL2_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL2_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL2_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL2_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL2_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL2_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL2_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL2_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL2_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 2)
	UDPHS_EPTCTL2_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL2_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL2_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL2_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL2_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL2_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL2_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL2_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL2_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL2_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL2_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL2_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL2_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL2_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL2_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL2_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL2_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL2_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL2_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL2_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL2_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL2_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL2_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL2_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL2_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL2_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL2_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL2_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL2_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL2_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL2_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA2: UDPHS Endpoint Set Status Register (endpoint = 2)
	UDPHS_EPTSETSTA2_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA2_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA2_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA2_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA2_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA2_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA2_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA2_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 2)
	UDPHS_EPTSETSTA2_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA2_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA2_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA2_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA2: UDPHS Endpoint Clear Status Register (endpoint = 2)
	UDPHS_EPTCLRSTA2_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA2_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA2_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA2_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA2_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA2_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA2_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA2_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA2_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA2_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA2_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA2_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA2_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA2_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA2_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA2_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA2_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA2_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA2_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 2)
	UDPHS_EPTCLRSTA2_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA2_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA2_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA2: UDPHS Endpoint Status Register (endpoint = 2)
	UDPHS_EPTSTA2_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA2_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA2_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA2_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA2_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA2_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA2_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA2_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA2_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA2_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA2_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA2_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA2_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA2_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA2_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA2_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA2_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA2_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA2_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA2_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA2_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA2_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA2_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA2_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA2_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA2_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA2_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA2_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA2_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA2_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA2_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA2_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA2_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA2_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA2_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA2_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA2_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA2_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA2_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA2_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA2_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA2_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 2)
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA2_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA2_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA2_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA2_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA2_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA2_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA2_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA2_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA2_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA2_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA2_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA2_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA2_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA2_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA2_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA2_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA2_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA2_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA2_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA2_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA2_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTCFG3: UDPHS Endpoint Configuration Register (endpoint = 3)
	UDPHS_EPTCFG3_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG3_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG3_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG3_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG3_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG3_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG3_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG3_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG3_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG3_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG3_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG3_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG3_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG3_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG3_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG3_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG3_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG3_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG3_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG3_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG3_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG3_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG3_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG3_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG3_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG3_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG3_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG3_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG3_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG3_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB3: UDPHS Endpoint Control Enable Register (endpoint = 3)
	UDPHS_EPTCTLENB3_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB3_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB3_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB3_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB3_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB3_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB3_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB3_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB3_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB3_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB3_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB3_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB3_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB3_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB3_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB3_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB3_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB3_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB3_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB3_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB3_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB3_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB3_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB3_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB3_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB3_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB3_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB3_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB3_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB3_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB3_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB3_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB3_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB3_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB3_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 3)
	UDPHS_EPTCTLENB3_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB3_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB3_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB3_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB3_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB3_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB3_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB3_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB3_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB3_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB3_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB3_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB3_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB3_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB3_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB3_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB3_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB3_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB3_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB3_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS3: UDPHS Endpoint Control Disable Register (endpoint = 3)
	UDPHS_EPTCTLDIS3_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS3_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS3_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS3_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS3_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS3_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS3_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS3_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS3_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS3_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS3_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS3_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS3_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS3_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS3_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS3_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS3_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS3_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS3_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS3_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS3_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS3_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS3_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS3_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS3_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS3_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS3_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 3)
	UDPHS_EPTCTLDIS3_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS3_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS3_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS3_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS3_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS3_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS3_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS3_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS3_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS3_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL3: UDPHS Endpoint Control Register (endpoint = 3)
	UDPHS_EPTCTL3_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL3_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL3_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL3_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL3_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL3_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL3_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL3_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL3_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL3_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL3_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL3_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL3_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL3_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL3_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL3_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL3_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL3_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL3_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL3_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL3_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL3_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL3_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL3_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL3_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL3_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL3_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL3_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL3_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL3_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL3_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL3_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL3_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL3_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL3_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL3_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL3_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL3_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL3_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL3_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL3_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL3_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL3_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 3)
	UDPHS_EPTCTL3_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL3_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL3_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL3_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL3_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL3_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL3_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL3_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL3_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL3_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL3_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL3_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL3_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL3_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL3_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL3_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL3_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL3_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL3_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL3_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL3_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL3_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL3_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL3_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL3_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL3_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL3_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL3_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL3_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL3_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL3_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA3: UDPHS Endpoint Set Status Register (endpoint = 3)
	UDPHS_EPTSETSTA3_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA3_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA3_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA3_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA3_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA3_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA3_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA3_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 3)
	UDPHS_EPTSETSTA3_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA3_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA3_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA3_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA3: UDPHS Endpoint Clear Status Register (endpoint = 3)
	UDPHS_EPTCLRSTA3_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA3_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA3_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA3_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA3_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA3_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA3_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA3_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA3_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA3_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA3_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA3_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA3_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA3_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA3_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA3_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA3_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA3_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA3_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 3)
	UDPHS_EPTCLRSTA3_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA3_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA3_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA3: UDPHS Endpoint Status Register (endpoint = 3)
	UDPHS_EPTSTA3_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA3_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA3_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA3_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA3_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA3_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA3_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA3_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA3_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA3_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA3_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA3_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA3_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA3_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA3_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA3_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA3_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA3_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA3_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA3_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA3_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA3_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA3_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA3_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA3_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA3_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA3_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA3_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA3_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA3_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA3_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA3_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA3_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA3_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA3_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA3_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA3_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA3_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA3_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA3_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA3_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA3_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 3)
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA3_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA3_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA3_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA3_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA3_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA3_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA3_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA3_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA3_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA3_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA3_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA3_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA3_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA3_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA3_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA3_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA3_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA3_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA3_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA3_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA3_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTCFG4: UDPHS Endpoint Configuration Register (endpoint = 4)
	UDPHS_EPTCFG4_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG4_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG4_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG4_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG4_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG4_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG4_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG4_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG4_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG4_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG4_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG4_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG4_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG4_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG4_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG4_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG4_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG4_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG4_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG4_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG4_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG4_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG4_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG4_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG4_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG4_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG4_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG4_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG4_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG4_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB4: UDPHS Endpoint Control Enable Register (endpoint = 4)
	UDPHS_EPTCTLENB4_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB4_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB4_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB4_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB4_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB4_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB4_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB4_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB4_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB4_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB4_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB4_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB4_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB4_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB4_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB4_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB4_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB4_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB4_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB4_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB4_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB4_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB4_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB4_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB4_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB4_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB4_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB4_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB4_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB4_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB4_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB4_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB4_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB4_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB4_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 4)
	UDPHS_EPTCTLENB4_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB4_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB4_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB4_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB4_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB4_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB4_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB4_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB4_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB4_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB4_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB4_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB4_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB4_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB4_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB4_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB4_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB4_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB4_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB4_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS4: UDPHS Endpoint Control Disable Register (endpoint = 4)
	UDPHS_EPTCTLDIS4_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS4_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS4_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS4_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS4_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS4_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS4_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS4_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS4_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS4_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS4_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS4_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS4_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS4_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS4_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS4_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS4_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS4_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS4_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS4_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS4_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS4_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS4_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS4_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS4_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS4_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS4_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 4)
	UDPHS_EPTCTLDIS4_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS4_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS4_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS4_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS4_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS4_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS4_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS4_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS4_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS4_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL4: UDPHS Endpoint Control Register (endpoint = 4)
	UDPHS_EPTCTL4_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL4_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL4_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL4_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL4_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL4_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL4_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL4_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL4_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL4_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL4_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL4_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL4_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL4_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL4_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL4_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL4_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL4_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL4_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL4_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL4_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL4_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL4_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL4_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL4_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL4_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL4_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL4_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL4_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL4_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL4_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL4_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL4_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL4_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL4_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL4_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL4_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL4_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL4_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL4_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL4_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL4_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL4_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 4)
	UDPHS_EPTCTL4_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL4_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL4_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL4_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL4_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL4_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL4_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL4_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL4_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL4_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL4_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL4_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL4_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL4_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL4_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL4_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL4_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL4_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL4_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL4_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL4_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL4_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL4_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL4_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL4_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL4_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL4_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL4_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL4_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL4_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL4_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA4: UDPHS Endpoint Set Status Register (endpoint = 4)
	UDPHS_EPTSETSTA4_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA4_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA4_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA4_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA4_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA4_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA4_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA4_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 4)
	UDPHS_EPTSETSTA4_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA4_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA4_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA4_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA4: UDPHS Endpoint Clear Status Register (endpoint = 4)
	UDPHS_EPTCLRSTA4_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA4_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA4_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA4_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA4_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA4_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA4_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA4_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA4_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA4_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA4_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA4_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA4_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA4_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA4_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA4_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA4_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA4_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA4_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 4)
	UDPHS_EPTCLRSTA4_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA4_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA4_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA4: UDPHS Endpoint Status Register (endpoint = 4)
	UDPHS_EPTSTA4_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA4_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA4_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA4_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA4_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA4_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA4_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA4_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA4_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA4_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA4_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA4_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA4_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA4_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA4_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA4_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA4_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA4_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA4_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA4_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA4_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA4_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA4_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA4_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA4_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA4_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA4_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA4_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA4_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA4_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA4_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA4_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA4_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA4_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA4_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA4_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA4_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA4_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA4_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA4_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA4_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA4_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 4)
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA4_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA4_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA4_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA4_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA4_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA4_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA4_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA4_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA4_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA4_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA4_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA4_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA4_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA4_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA4_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA4_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA4_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA4_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA4_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA4_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA4_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTCFG5: UDPHS Endpoint Configuration Register (endpoint = 5)
	UDPHS_EPTCFG5_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG5_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG5_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG5_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG5_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG5_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG5_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG5_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG5_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG5_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG5_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG5_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG5_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG5_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG5_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG5_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG5_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG5_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG5_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG5_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG5_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG5_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG5_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG5_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG5_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG5_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG5_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG5_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG5_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG5_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB5: UDPHS Endpoint Control Enable Register (endpoint = 5)
	UDPHS_EPTCTLENB5_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB5_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB5_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB5_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB5_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB5_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB5_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB5_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB5_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB5_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB5_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB5_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB5_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB5_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB5_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB5_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB5_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB5_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB5_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB5_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB5_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB5_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB5_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB5_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB5_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB5_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB5_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB5_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB5_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB5_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB5_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB5_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB5_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB5_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB5_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 5)
	UDPHS_EPTCTLENB5_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB5_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB5_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB5_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB5_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB5_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB5_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB5_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB5_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB5_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB5_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB5_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB5_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB5_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB5_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB5_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB5_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB5_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB5_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB5_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS5: UDPHS Endpoint Control Disable Register (endpoint = 5)
	UDPHS_EPTCTLDIS5_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS5_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS5_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS5_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS5_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS5_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS5_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS5_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS5_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS5_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS5_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS5_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS5_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS5_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS5_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS5_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS5_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS5_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS5_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS5_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS5_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS5_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS5_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS5_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS5_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS5_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS5_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 5)
	UDPHS_EPTCTLDIS5_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS5_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS5_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS5_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS5_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS5_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS5_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS5_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS5_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS5_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL5: UDPHS Endpoint Control Register (endpoint = 5)
	UDPHS_EPTCTL5_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL5_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL5_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL5_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL5_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL5_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL5_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL5_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL5_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL5_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL5_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL5_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL5_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL5_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL5_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL5_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL5_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL5_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL5_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL5_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL5_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL5_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL5_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL5_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL5_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL5_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL5_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL5_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL5_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL5_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL5_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL5_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL5_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL5_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL5_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL5_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL5_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL5_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL5_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL5_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL5_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL5_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL5_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 5)
	UDPHS_EPTCTL5_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL5_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL5_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL5_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL5_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL5_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL5_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL5_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL5_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL5_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL5_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL5_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL5_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL5_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL5_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL5_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL5_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL5_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL5_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL5_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL5_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL5_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL5_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL5_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL5_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL5_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL5_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL5_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL5_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL5_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL5_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA5: UDPHS Endpoint Set Status Register (endpoint = 5)
	UDPHS_EPTSETSTA5_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA5_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA5_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA5_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA5_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA5_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA5_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA5_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 5)
	UDPHS_EPTSETSTA5_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA5_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA5_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA5_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA5: UDPHS Endpoint Clear Status Register (endpoint = 5)
	UDPHS_EPTCLRSTA5_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA5_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA5_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA5_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA5_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA5_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA5_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA5_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA5_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA5_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA5_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA5_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA5_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA5_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA5_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA5_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA5_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA5_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA5_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 5)
	UDPHS_EPTCLRSTA5_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA5_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA5_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA5: UDPHS Endpoint Status Register (endpoint = 5)
	UDPHS_EPTSTA5_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA5_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA5_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA5_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA5_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA5_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA5_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA5_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA5_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA5_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA5_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA5_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA5_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA5_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA5_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA5_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA5_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA5_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA5_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA5_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA5_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA5_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA5_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA5_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA5_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA5_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA5_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA5_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA5_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA5_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA5_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA5_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA5_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA5_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA5_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA5_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA5_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA5_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA5_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA5_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA5_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA5_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 5)
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA5_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA5_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA5_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA5_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA5_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA5_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA5_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA5_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA5_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA5_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA5_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA5_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA5_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA5_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA5_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA5_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA5_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA5_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA5_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA5_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA5_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTCFG6: UDPHS Endpoint Configuration Register (endpoint = 6)
	UDPHS_EPTCFG6_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG6_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG6_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG6_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG6_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG6_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG6_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG6_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG6_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG6_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG6_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG6_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG6_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG6_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG6_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG6_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG6_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG6_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG6_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG6_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG6_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG6_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG6_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG6_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG6_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG6_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG6_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG6_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG6_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG6_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB6: UDPHS Endpoint Control Enable Register (endpoint = 6)
	UDPHS_EPTCTLENB6_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB6_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB6_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB6_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB6_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB6_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB6_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB6_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB6_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB6_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB6_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB6_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB6_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB6_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB6_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB6_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB6_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB6_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB6_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB6_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB6_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB6_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB6_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB6_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB6_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB6_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB6_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB6_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB6_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB6_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB6_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB6_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB6_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB6_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB6_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 6)
	UDPHS_EPTCTLENB6_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB6_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB6_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB6_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB6_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB6_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB6_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB6_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB6_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB6_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB6_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB6_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB6_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB6_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB6_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB6_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB6_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB6_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB6_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB6_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS6: UDPHS Endpoint Control Disable Register (endpoint = 6)
	UDPHS_EPTCTLDIS6_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS6_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS6_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS6_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS6_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS6_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS6_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS6_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS6_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS6_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS6_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS6_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS6_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS6_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS6_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS6_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS6_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS6_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS6_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS6_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS6_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS6_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS6_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS6_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS6_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS6_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS6_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 6)
	UDPHS_EPTCTLDIS6_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS6_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS6_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS6_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS6_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS6_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS6_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS6_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS6_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS6_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL6: UDPHS Endpoint Control Register (endpoint = 6)
	UDPHS_EPTCTL6_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL6_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL6_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL6_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL6_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL6_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL6_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL6_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL6_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL6_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL6_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL6_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL6_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL6_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL6_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL6_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL6_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL6_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL6_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL6_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL6_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL6_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL6_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL6_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL6_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL6_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL6_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL6_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL6_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL6_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL6_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL6_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL6_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL6_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL6_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL6_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL6_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL6_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL6_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL6_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL6_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL6_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL6_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 6)
	UDPHS_EPTCTL6_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL6_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL6_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL6_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL6_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL6_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL6_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL6_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL6_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL6_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL6_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL6_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL6_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL6_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL6_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL6_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL6_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL6_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL6_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL6_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL6_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL6_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL6_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL6_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL6_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL6_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL6_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL6_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL6_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL6_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL6_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA6: UDPHS Endpoint Set Status Register (endpoint = 6)
	UDPHS_EPTSETSTA6_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA6_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA6_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA6_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA6_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA6_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA6_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA6_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 6)
	UDPHS_EPTSETSTA6_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA6_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA6_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA6_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA6: UDPHS Endpoint Clear Status Register (endpoint = 6)
	UDPHS_EPTCLRSTA6_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA6_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA6_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA6_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA6_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA6_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA6_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA6_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA6_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA6_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA6_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA6_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA6_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA6_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA6_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA6_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA6_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA6_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA6_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 6)
	UDPHS_EPTCLRSTA6_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA6_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA6_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA6: UDPHS Endpoint Status Register (endpoint = 6)
	UDPHS_EPTSTA6_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA6_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA6_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA6_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA6_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA6_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA6_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA6_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA6_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA6_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA6_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA6_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA6_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA6_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA6_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA6_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA6_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA6_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA6_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA6_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA6_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA6_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA6_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA6_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA6_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA6_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA6_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA6_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA6_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA6_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA6_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA6_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA6_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA6_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA6_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA6_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA6_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA6_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA6_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA6_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA6_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA6_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 6)
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA6_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA6_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA6_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA6_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA6_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA6_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA6_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA6_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA6_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA6_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA6_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA6_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA6_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA6_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA6_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA6_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA6_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA6_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA6_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA6_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA6_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// DMANXTDSC0: UDPHS DMA Next Descriptor Address Register (channel = 0)
	UDPHS_DMANXTDSC0_NXT_DSC_ADD_Pos = 0x0        // Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC0_NXT_DSC_ADD_Msk = 0xffffffff // Bit mask of NXT_DSC_ADD field.

	// DMAADDRESS0: UDPHS DMA Channel Address Register (channel = 0)
	UDPHS_DMAADDRESS0_BUFF_ADD_Pos = 0x0        // Position of BUFF_ADD field.
	UDPHS_DMAADDRESS0_BUFF_ADD_Msk = 0xffffffff // Bit mask of BUFF_ADD field.

	// DMACONTROL0: UDPHS DMA Channel Control Register (channel = 0)
	UDPHS_DMACONTROL0_CHANN_ENB_Pos   = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMACONTROL0_CHANN_ENB_Msk   = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL0_CHANN_ENB       = 0x1        // Bit CHANN_ENB.
	UDPHS_DMACONTROL0_LDNXT_DSC_Pos   = 0x1        // Position of LDNXT_DSC field.
	UDPHS_DMACONTROL0_LDNXT_DSC_Msk   = 0x2        // Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL0_LDNXT_DSC       = 0x2        // Bit LDNXT_DSC.
	UDPHS_DMACONTROL0_END_TR_EN_Pos   = 0x2        // Position of END_TR_EN field.
	UDPHS_DMACONTROL0_END_TR_EN_Msk   = 0x4        // Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL0_END_TR_EN       = 0x4        // Bit END_TR_EN.
	UDPHS_DMACONTROL0_END_B_EN_Pos    = 0x3        // Position of END_B_EN field.
	UDPHS_DMACONTROL0_END_B_EN_Msk    = 0x8        // Bit mask of END_B_EN field.
	UDPHS_DMACONTROL0_END_B_EN        = 0x8        // Bit END_B_EN.
	UDPHS_DMACONTROL0_END_TR_IT_Pos   = 0x4        // Position of END_TR_IT field.
	UDPHS_DMACONTROL0_END_TR_IT_Msk   = 0x10       // Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL0_END_TR_IT       = 0x10       // Bit END_TR_IT.
	UDPHS_DMACONTROL0_END_BUFFIT_Pos  = 0x5        // Position of END_BUFFIT field.
	UDPHS_DMACONTROL0_END_BUFFIT_Msk  = 0x20       // Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL0_END_BUFFIT      = 0x20       // Bit END_BUFFIT.
	UDPHS_DMACONTROL0_DESC_LD_IT_Pos  = 0x6        // Position of DESC_LD_IT field.
	UDPHS_DMACONTROL0_DESC_LD_IT_Msk  = 0x40       // Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL0_DESC_LD_IT      = 0x40       // Bit DESC_LD_IT.
	UDPHS_DMACONTROL0_BURST_LCK_Pos   = 0x7        // Position of BURST_LCK field.
	UDPHS_DMACONTROL0_BURST_LCK_Msk   = 0x80       // Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL0_BURST_LCK       = 0x80       // Bit BURST_LCK.
	UDPHS_DMACONTROL0_BUFF_LENGTH_Pos = 0x10       // Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL0_BUFF_LENGTH_Msk = 0xffff0000 // Bit mask of BUFF_LENGTH field.

	// DMASTATUS0: UDPHS DMA Channel Status Register (channel = 0)
	UDPHS_DMASTATUS0_CHANN_ENB_Pos  = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMASTATUS0_CHANN_ENB_Msk  = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS0_CHANN_ENB      = 0x1        // Bit CHANN_ENB.
	UDPHS_DMASTATUS0_CHANN_ACT_Pos  = 0x1        // Position of CHANN_ACT field.
	UDPHS_DMASTATUS0_CHANN_ACT_Msk  = 0x2        // Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS0_CHANN_ACT      = 0x2        // Bit CHANN_ACT.
	UDPHS_DMASTATUS0_END_TR_ST_Pos  = 0x4        // Position of END_TR_ST field.
	UDPHS_DMASTATUS0_END_TR_ST_Msk  = 0x10       // Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS0_END_TR_ST      = 0x10       // Bit END_TR_ST.
	UDPHS_DMASTATUS0_END_BF_ST_Pos  = 0x5        // Position of END_BF_ST field.
	UDPHS_DMASTATUS0_END_BF_ST_Msk  = 0x20       // Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS0_END_BF_ST      = 0x20       // Bit END_BF_ST.
	UDPHS_DMASTATUS0_DESC_LDST_Pos  = 0x6        // Position of DESC_LDST field.
	UDPHS_DMASTATUS0_DESC_LDST_Msk  = 0x40       // Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS0_DESC_LDST      = 0x40       // Bit DESC_LDST.
	UDPHS_DMASTATUS0_BUFF_COUNT_Pos = 0x10       // Position of BUFF_COUNT field.
	UDPHS_DMASTATUS0_BUFF_COUNT_Msk = 0xffff0000 // Bit mask of BUFF_COUNT field.

	// DMANXTDSC1: UDPHS DMA Next Descriptor Address Register (channel = 1)
	UDPHS_DMANXTDSC1_NXT_DSC_ADD_Pos = 0x0        // Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC1_NXT_DSC_ADD_Msk = 0xffffffff // Bit mask of NXT_DSC_ADD field.

	// DMAADDRESS1: UDPHS DMA Channel Address Register (channel = 1)
	UDPHS_DMAADDRESS1_BUFF_ADD_Pos = 0x0        // Position of BUFF_ADD field.
	UDPHS_DMAADDRESS1_BUFF_ADD_Msk = 0xffffffff // Bit mask of BUFF_ADD field.

	// DMACONTROL1: UDPHS DMA Channel Control Register (channel = 1)
	UDPHS_DMACONTROL1_CHANN_ENB_Pos   = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMACONTROL1_CHANN_ENB_Msk   = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL1_CHANN_ENB       = 0x1        // Bit CHANN_ENB.
	UDPHS_DMACONTROL1_LDNXT_DSC_Pos   = 0x1        // Position of LDNXT_DSC field.
	UDPHS_DMACONTROL1_LDNXT_DSC_Msk   = 0x2        // Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL1_LDNXT_DSC       = 0x2        // Bit LDNXT_DSC.
	UDPHS_DMACONTROL1_END_TR_EN_Pos   = 0x2        // Position of END_TR_EN field.
	UDPHS_DMACONTROL1_END_TR_EN_Msk   = 0x4        // Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL1_END_TR_EN       = 0x4        // Bit END_TR_EN.
	UDPHS_DMACONTROL1_END_B_EN_Pos    = 0x3        // Position of END_B_EN field.
	UDPHS_DMACONTROL1_END_B_EN_Msk    = 0x8        // Bit mask of END_B_EN field.
	UDPHS_DMACONTROL1_END_B_EN        = 0x8        // Bit END_B_EN.
	UDPHS_DMACONTROL1_END_TR_IT_Pos   = 0x4        // Position of END_TR_IT field.
	UDPHS_DMACONTROL1_END_TR_IT_Msk   = 0x10       // Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL1_END_TR_IT       = 0x10       // Bit END_TR_IT.
	UDPHS_DMACONTROL1_END_BUFFIT_Pos  = 0x5        // Position of END_BUFFIT field.
	UDPHS_DMACONTROL1_END_BUFFIT_Msk  = 0x20       // Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL1_END_BUFFIT      = 0x20       // Bit END_BUFFIT.
	UDPHS_DMACONTROL1_DESC_LD_IT_Pos  = 0x6        // Position of DESC_LD_IT field.
	UDPHS_DMACONTROL1_DESC_LD_IT_Msk  = 0x40       // Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL1_DESC_LD_IT      = 0x40       // Bit DESC_LD_IT.
	UDPHS_DMACONTROL1_BURST_LCK_Pos   = 0x7        // Position of BURST_LCK field.
	UDPHS_DMACONTROL1_BURST_LCK_Msk   = 0x80       // Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL1_BURST_LCK       = 0x80       // Bit BURST_LCK.
	UDPHS_DMACONTROL1_BUFF_LENGTH_Pos = 0x10       // Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL1_BUFF_LENGTH_Msk = 0xffff0000 // Bit mask of BUFF_LENGTH field.

	// DMASTATUS1: UDPHS DMA Channel Status Register (channel = 1)
	UDPHS_DMASTATUS1_CHANN_ENB_Pos  = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMASTATUS1_CHANN_ENB_Msk  = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS1_CHANN_ENB      = 0x1        // Bit CHANN_ENB.
	UDPHS_DMASTATUS1_CHANN_ACT_Pos  = 0x1        // Position of CHANN_ACT field.
	UDPHS_DMASTATUS1_CHANN_ACT_Msk  = 0x2        // Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS1_CHANN_ACT      = 0x2        // Bit CHANN_ACT.
	UDPHS_DMASTATUS1_END_TR_ST_Pos  = 0x4        // Position of END_TR_ST field.
	UDPHS_DMASTATUS1_END_TR_ST_Msk  = 0x10       // Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS1_END_TR_ST      = 0x10       // Bit END_TR_ST.
	UDPHS_DMASTATUS1_END_BF_ST_Pos  = 0x5        // Position of END_BF_ST field.
	UDPHS_DMASTATUS1_END_BF_ST_Msk  = 0x20       // Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS1_END_BF_ST      = 0x20       // Bit END_BF_ST.
	UDPHS_DMASTATUS1_DESC_LDST_Pos  = 0x6        // Position of DESC_LDST field.
	UDPHS_DMASTATUS1_DESC_LDST_Msk  = 0x40       // Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS1_DESC_LDST      = 0x40       // Bit DESC_LDST.
	UDPHS_DMASTATUS1_BUFF_COUNT_Pos = 0x10       // Position of BUFF_COUNT field.
	UDPHS_DMASTATUS1_BUFF_COUNT_Msk = 0xffff0000 // Bit mask of BUFF_COUNT field.

	// DMANXTDSC2: UDPHS DMA Next Descriptor Address Register (channel = 2)
	UDPHS_DMANXTDSC2_NXT_DSC_ADD_Pos = 0x0        // Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC2_NXT_DSC_ADD_Msk = 0xffffffff // Bit mask of NXT_DSC_ADD field.

	// DMAADDRESS2: UDPHS DMA Channel Address Register (channel = 2)
	UDPHS_DMAADDRESS2_BUFF_ADD_Pos = 0x0        // Position of BUFF_ADD field.
	UDPHS_DMAADDRESS2_BUFF_ADD_Msk = 0xffffffff // Bit mask of BUFF_ADD field.

	// DMACONTROL2: UDPHS DMA Channel Control Register (channel = 2)
	UDPHS_DMACONTROL2_CHANN_ENB_Pos   = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMACONTROL2_CHANN_ENB_Msk   = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL2_CHANN_ENB       = 0x1        // Bit CHANN_ENB.
	UDPHS_DMACONTROL2_LDNXT_DSC_Pos   = 0x1        // Position of LDNXT_DSC field.
	UDPHS_DMACONTROL2_LDNXT_DSC_Msk   = 0x2        // Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL2_LDNXT_DSC       = 0x2        // Bit LDNXT_DSC.
	UDPHS_DMACONTROL2_END_TR_EN_Pos   = 0x2        // Position of END_TR_EN field.
	UDPHS_DMACONTROL2_END_TR_EN_Msk   = 0x4        // Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL2_END_TR_EN       = 0x4        // Bit END_TR_EN.
	UDPHS_DMACONTROL2_END_B_EN_Pos    = 0x3        // Position of END_B_EN field.
	UDPHS_DMACONTROL2_END_B_EN_Msk    = 0x8        // Bit mask of END_B_EN field.
	UDPHS_DMACONTROL2_END_B_EN        = 0x8        // Bit END_B_EN.
	UDPHS_DMACONTROL2_END_TR_IT_Pos   = 0x4        // Position of END_TR_IT field.
	UDPHS_DMACONTROL2_END_TR_IT_Msk   = 0x10       // Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL2_END_TR_IT       = 0x10       // Bit END_TR_IT.
	UDPHS_DMACONTROL2_END_BUFFIT_Pos  = 0x5        // Position of END_BUFFIT field.
	UDPHS_DMACONTROL2_END_BUFFIT_Msk  = 0x20       // Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL2_END_BUFFIT      = 0x20       // Bit END_BUFFIT.
	UDPHS_DMACONTROL2_DESC_LD_IT_Pos  = 0x6        // Position of DESC_LD_IT field.
	UDPHS_DMACONTROL2_DESC_LD_IT_Msk  = 0x40       // Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL2_DESC_LD_IT      = 0x40       // Bit DESC_LD_IT.
	UDPHS_DMACONTROL2_BURST_LCK_Pos   = 0x7        // Position of BURST_LCK field.
	UDPHS_DMACONTROL2_BURST_LCK_Msk   = 0x80       // Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL2_BURST_LCK       = 0x80       // Bit BURST_LCK.
	UDPHS_DMACONTROL2_BUFF_LENGTH_Pos = 0x10       // Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL2_BUFF_LENGTH_Msk = 0xffff0000 // Bit mask of BUFF_LENGTH field.

	// DMASTATUS2: UDPHS DMA Channel Status Register (channel = 2)
	UDPHS_DMASTATUS2_CHANN_ENB_Pos  = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMASTATUS2_CHANN_ENB_Msk  = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS2_CHANN_ENB      = 0x1        // Bit CHANN_ENB.
	UDPHS_DMASTATUS2_CHANN_ACT_Pos  = 0x1        // Position of CHANN_ACT field.
	UDPHS_DMASTATUS2_CHANN_ACT_Msk  = 0x2        // Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS2_CHANN_ACT      = 0x2        // Bit CHANN_ACT.
	UDPHS_DMASTATUS2_END_TR_ST_Pos  = 0x4        // Position of END_TR_ST field.
	UDPHS_DMASTATUS2_END_TR_ST_Msk  = 0x10       // Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS2_END_TR_ST      = 0x10       // Bit END_TR_ST.
	UDPHS_DMASTATUS2_END_BF_ST_Pos  = 0x5        // Position of END_BF_ST field.
	UDPHS_DMASTATUS2_END_BF_ST_Msk  = 0x20       // Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS2_END_BF_ST      = 0x20       // Bit END_BF_ST.
	UDPHS_DMASTATUS2_DESC_LDST_Pos  = 0x6        // Position of DESC_LDST field.
	UDPHS_DMASTATUS2_DESC_LDST_Msk  = 0x40       // Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS2_DESC_LDST      = 0x40       // Bit DESC_LDST.
	UDPHS_DMASTATUS2_BUFF_COUNT_Pos = 0x10       // Position of BUFF_COUNT field.
	UDPHS_DMASTATUS2_BUFF_COUNT_Msk = 0xffff0000 // Bit mask of BUFF_COUNT field.

	// DMANXTDSC3: UDPHS DMA Next Descriptor Address Register (channel = 3)
	UDPHS_DMANXTDSC3_NXT_DSC_ADD_Pos = 0x0        // Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC3_NXT_DSC_ADD_Msk = 0xffffffff // Bit mask of NXT_DSC_ADD field.

	// DMAADDRESS3: UDPHS DMA Channel Address Register (channel = 3)
	UDPHS_DMAADDRESS3_BUFF_ADD_Pos = 0x0        // Position of BUFF_ADD field.
	UDPHS_DMAADDRESS3_BUFF_ADD_Msk = 0xffffffff // Bit mask of BUFF_ADD field.

	// DMACONTROL3: UDPHS DMA Channel Control Register (channel = 3)
	UDPHS_DMACONTROL3_CHANN_ENB_Pos   = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMACONTROL3_CHANN_ENB_Msk   = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL3_CHANN_ENB       = 0x1        // Bit CHANN_ENB.
	UDPHS_DMACONTROL3_LDNXT_DSC_Pos   = 0x1        // Position of LDNXT_DSC field.
	UDPHS_DMACONTROL3_LDNXT_DSC_Msk   = 0x2        // Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL3_LDNXT_DSC       = 0x2        // Bit LDNXT_DSC.
	UDPHS_DMACONTROL3_END_TR_EN_Pos   = 0x2        // Position of END_TR_EN field.
	UDPHS_DMACONTROL3_END_TR_EN_Msk   = 0x4        // Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL3_END_TR_EN       = 0x4        // Bit END_TR_EN.
	UDPHS_DMACONTROL3_END_B_EN_Pos    = 0x3        // Position of END_B_EN field.
	UDPHS_DMACONTROL3_END_B_EN_Msk    = 0x8        // Bit mask of END_B_EN field.
	UDPHS_DMACONTROL3_END_B_EN        = 0x8        // Bit END_B_EN.
	UDPHS_DMACONTROL3_END_TR_IT_Pos   = 0x4        // Position of END_TR_IT field.
	UDPHS_DMACONTROL3_END_TR_IT_Msk   = 0x10       // Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL3_END_TR_IT       = 0x10       // Bit END_TR_IT.
	UDPHS_DMACONTROL3_END_BUFFIT_Pos  = 0x5        // Position of END_BUFFIT field.
	UDPHS_DMACONTROL3_END_BUFFIT_Msk  = 0x20       // Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL3_END_BUFFIT      = 0x20       // Bit END_BUFFIT.
	UDPHS_DMACONTROL3_DESC_LD_IT_Pos  = 0x6        // Position of DESC_LD_IT field.
	UDPHS_DMACONTROL3_DESC_LD_IT_Msk  = 0x40       // Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL3_DESC_LD_IT      = 0x40       // Bit DESC_LD_IT.
	UDPHS_DMACONTROL3_BURST_LCK_Pos   = 0x7        // Position of BURST_LCK field.
	UDPHS_DMACONTROL3_BURST_LCK_Msk   = 0x80       // Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL3_BURST_LCK       = 0x80       // Bit BURST_LCK.
	UDPHS_DMACONTROL3_BUFF_LENGTH_Pos = 0x10       // Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL3_BUFF_LENGTH_Msk = 0xffff0000 // Bit mask of BUFF_LENGTH field.

	// DMASTATUS3: UDPHS DMA Channel Status Register (channel = 3)
	UDPHS_DMASTATUS3_CHANN_ENB_Pos  = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMASTATUS3_CHANN_ENB_Msk  = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS3_CHANN_ENB      = 0x1        // Bit CHANN_ENB.
	UDPHS_DMASTATUS3_CHANN_ACT_Pos  = 0x1        // Position of CHANN_ACT field.
	UDPHS_DMASTATUS3_CHANN_ACT_Msk  = 0x2        // Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS3_CHANN_ACT      = 0x2        // Bit CHANN_ACT.
	UDPHS_DMASTATUS3_END_TR_ST_Pos  = 0x4        // Position of END_TR_ST field.
	UDPHS_DMASTATUS3_END_TR_ST_Msk  = 0x10       // Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS3_END_TR_ST      = 0x10       // Bit END_TR_ST.
	UDPHS_DMASTATUS3_END_BF_ST_Pos  = 0x5        // Position of END_BF_ST field.
	UDPHS_DMASTATUS3_END_BF_ST_Msk  = 0x20       // Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS3_END_BF_ST      = 0x20       // Bit END_BF_ST.
	UDPHS_DMASTATUS3_DESC_LDST_Pos  = 0x6        // Position of DESC_LDST field.
	UDPHS_DMASTATUS3_DESC_LDST_Msk  = 0x40       // Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS3_DESC_LDST      = 0x40       // Bit DESC_LDST.
	UDPHS_DMASTATUS3_BUFF_COUNT_Pos = 0x10       // Position of BUFF_COUNT field.
	UDPHS_DMASTATUS3_BUFF_COUNT_Msk = 0xffff0000 // Bit mask of BUFF_COUNT field.

	// DMANXTDSC4: UDPHS DMA Next Descriptor Address Register (channel = 4)
	UDPHS_DMANXTDSC4_NXT_DSC_ADD_Pos = 0x0        // Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC4_NXT_DSC_ADD_Msk = 0xffffffff // Bit mask of NXT_DSC_ADD field.

	// DMAADDRESS4: UDPHS DMA Channel Address Register (channel = 4)
	UDPHS_DMAADDRESS4_BUFF_ADD_Pos = 0x0        // Position of BUFF_ADD field.
	UDPHS_DMAADDRESS4_BUFF_ADD_Msk = 0xffffffff // Bit mask of BUFF_ADD field.

	// DMACONTROL4: UDPHS DMA Channel Control Register (channel = 4)
	UDPHS_DMACONTROL4_CHANN_ENB_Pos   = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMACONTROL4_CHANN_ENB_Msk   = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL4_CHANN_ENB       = 0x1        // Bit CHANN_ENB.
	UDPHS_DMACONTROL4_LDNXT_DSC_Pos   = 0x1        // Position of LDNXT_DSC field.
	UDPHS_DMACONTROL4_LDNXT_DSC_Msk   = 0x2        // Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL4_LDNXT_DSC       = 0x2        // Bit LDNXT_DSC.
	UDPHS_DMACONTROL4_END_TR_EN_Pos   = 0x2        // Position of END_TR_EN field.
	UDPHS_DMACONTROL4_END_TR_EN_Msk   = 0x4        // Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL4_END_TR_EN       = 0x4        // Bit END_TR_EN.
	UDPHS_DMACONTROL4_END_B_EN_Pos    = 0x3        // Position of END_B_EN field.
	UDPHS_DMACONTROL4_END_B_EN_Msk    = 0x8        // Bit mask of END_B_EN field.
	UDPHS_DMACONTROL4_END_B_EN        = 0x8        // Bit END_B_EN.
	UDPHS_DMACONTROL4_END_TR_IT_Pos   = 0x4        // Position of END_TR_IT field.
	UDPHS_DMACONTROL4_END_TR_IT_Msk   = 0x10       // Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL4_END_TR_IT       = 0x10       // Bit END_TR_IT.
	UDPHS_DMACONTROL4_END_BUFFIT_Pos  = 0x5        // Position of END_BUFFIT field.
	UDPHS_DMACONTROL4_END_BUFFIT_Msk  = 0x20       // Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL4_END_BUFFIT      = 0x20       // Bit END_BUFFIT.
	UDPHS_DMACONTROL4_DESC_LD_IT_Pos  = 0x6        // Position of DESC_LD_IT field.
	UDPHS_DMACONTROL4_DESC_LD_IT_Msk  = 0x40       // Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL4_DESC_LD_IT      = 0x40       // Bit DESC_LD_IT.
	UDPHS_DMACONTROL4_BURST_LCK_Pos   = 0x7        // Position of BURST_LCK field.
	UDPHS_DMACONTROL4_BURST_LCK_Msk   = 0x80       // Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL4_BURST_LCK       = 0x80       // Bit BURST_LCK.
	UDPHS_DMACONTROL4_BUFF_LENGTH_Pos = 0x10       // Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL4_BUFF_LENGTH_Msk = 0xffff0000 // Bit mask of BUFF_LENGTH field.

	// DMASTATUS4: UDPHS DMA Channel Status Register (channel = 4)
	UDPHS_DMASTATUS4_CHANN_ENB_Pos  = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMASTATUS4_CHANN_ENB_Msk  = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS4_CHANN_ENB      = 0x1        // Bit CHANN_ENB.
	UDPHS_DMASTATUS4_CHANN_ACT_Pos  = 0x1        // Position of CHANN_ACT field.
	UDPHS_DMASTATUS4_CHANN_ACT_Msk  = 0x2        // Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS4_CHANN_ACT      = 0x2        // Bit CHANN_ACT.
	UDPHS_DMASTATUS4_END_TR_ST_Pos  = 0x4        // Position of END_TR_ST field.
	UDPHS_DMASTATUS4_END_TR_ST_Msk  = 0x10       // Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS4_END_TR_ST      = 0x10       // Bit END_TR_ST.
	UDPHS_DMASTATUS4_END_BF_ST_Pos  = 0x5        // Position of END_BF_ST field.
	UDPHS_DMASTATUS4_END_BF_ST_Msk  = 0x20       // Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS4_END_BF_ST      = 0x20       // Bit END_BF_ST.
	UDPHS_DMASTATUS4_DESC_LDST_Pos  = 0x6        // Position of DESC_LDST field.
	UDPHS_DMASTATUS4_DESC_LDST_Msk  = 0x40       // Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS4_DESC_LDST      = 0x40       // Bit DESC_LDST.
	UDPHS_DMASTATUS4_BUFF_COUNT_Pos = 0x10       // Position of BUFF_COUNT field.
	UDPHS_DMASTATUS4_BUFF_COUNT_Msk = 0xffff0000 // Bit mask of BUFF_COUNT field.

	// DMANXTDSC5: UDPHS DMA Next Descriptor Address Register (channel = 5)
	UDPHS_DMANXTDSC5_NXT_DSC_ADD_Pos = 0x0        // Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC5_NXT_DSC_ADD_Msk = 0xffffffff // Bit mask of NXT_DSC_ADD field.

	// DMAADDRESS5: UDPHS DMA Channel Address Register (channel = 5)
	UDPHS_DMAADDRESS5_BUFF_ADD_Pos = 0x0        // Position of BUFF_ADD field.
	UDPHS_DMAADDRESS5_BUFF_ADD_Msk = 0xffffffff // Bit mask of BUFF_ADD field.

	// DMACONTROL5: UDPHS DMA Channel Control Register (channel = 5)
	UDPHS_DMACONTROL5_CHANN_ENB_Pos   = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMACONTROL5_CHANN_ENB_Msk   = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL5_CHANN_ENB       = 0x1        // Bit CHANN_ENB.
	UDPHS_DMACONTROL5_LDNXT_DSC_Pos   = 0x1        // Position of LDNXT_DSC field.
	UDPHS_DMACONTROL5_LDNXT_DSC_Msk   = 0x2        // Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL5_LDNXT_DSC       = 0x2        // Bit LDNXT_DSC.
	UDPHS_DMACONTROL5_END_TR_EN_Pos   = 0x2        // Position of END_TR_EN field.
	UDPHS_DMACONTROL5_END_TR_EN_Msk   = 0x4        // Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL5_END_TR_EN       = 0x4        // Bit END_TR_EN.
	UDPHS_DMACONTROL5_END_B_EN_Pos    = 0x3        // Position of END_B_EN field.
	UDPHS_DMACONTROL5_END_B_EN_Msk    = 0x8        // Bit mask of END_B_EN field.
	UDPHS_DMACONTROL5_END_B_EN        = 0x8        // Bit END_B_EN.
	UDPHS_DMACONTROL5_END_TR_IT_Pos   = 0x4        // Position of END_TR_IT field.
	UDPHS_DMACONTROL5_END_TR_IT_Msk   = 0x10       // Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL5_END_TR_IT       = 0x10       // Bit END_TR_IT.
	UDPHS_DMACONTROL5_END_BUFFIT_Pos  = 0x5        // Position of END_BUFFIT field.
	UDPHS_DMACONTROL5_END_BUFFIT_Msk  = 0x20       // Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL5_END_BUFFIT      = 0x20       // Bit END_BUFFIT.
	UDPHS_DMACONTROL5_DESC_LD_IT_Pos  = 0x6        // Position of DESC_LD_IT field.
	UDPHS_DMACONTROL5_DESC_LD_IT_Msk  = 0x40       // Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL5_DESC_LD_IT      = 0x40       // Bit DESC_LD_IT.
	UDPHS_DMACONTROL5_BURST_LCK_Pos   = 0x7        // Position of BURST_LCK field.
	UDPHS_DMACONTROL5_BURST_LCK_Msk   = 0x80       // Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL5_BURST_LCK       = 0x80       // Bit BURST_LCK.
	UDPHS_DMACONTROL5_BUFF_LENGTH_Pos = 0x10       // Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL5_BUFF_LENGTH_Msk = 0xffff0000 // Bit mask of BUFF_LENGTH field.

	// DMASTATUS5: UDPHS DMA Channel Status Register (channel = 5)
	UDPHS_DMASTATUS5_CHANN_ENB_Pos  = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMASTATUS5_CHANN_ENB_Msk  = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS5_CHANN_ENB      = 0x1        // Bit CHANN_ENB.
	UDPHS_DMASTATUS5_CHANN_ACT_Pos  = 0x1        // Position of CHANN_ACT field.
	UDPHS_DMASTATUS5_CHANN_ACT_Msk  = 0x2        // Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS5_CHANN_ACT      = 0x2        // Bit CHANN_ACT.
	UDPHS_DMASTATUS5_END_TR_ST_Pos  = 0x4        // Position of END_TR_ST field.
	UDPHS_DMASTATUS5_END_TR_ST_Msk  = 0x10       // Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS5_END_TR_ST      = 0x10       // Bit END_TR_ST.
	UDPHS_DMASTATUS5_END_BF_ST_Pos  = 0x5        // Position of END_BF_ST field.
	UDPHS_DMASTATUS5_END_BF_ST_Msk  = 0x20       // Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS5_END_BF_ST      = 0x20       // Bit END_BF_ST.
	UDPHS_DMASTATUS5_DESC_LDST_Pos  = 0x6        // Position of DESC_LDST field.
	UDPHS_DMASTATUS5_DESC_LDST_Msk  = 0x40       // Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS5_DESC_LDST      = 0x40       // Bit DESC_LDST.
	UDPHS_DMASTATUS5_BUFF_COUNT_Pos = 0x10       // Position of BUFF_COUNT field.
	UDPHS_DMASTATUS5_BUFF_COUNT_Msk = 0xffff0000 // Bit mask of BUFF_COUNT field.
)

// Bitfields for UART0: Universal Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	UART_CR_RSTRX_Pos  = 0x2   // Position of RSTRX field.
	UART_CR_RSTRX_Msk  = 0x4   // Bit mask of RSTRX field.
	UART_CR_RSTRX      = 0x4   // Bit RSTRX.
	UART_CR_RSTTX_Pos  = 0x3   // Position of RSTTX field.
	UART_CR_RSTTX_Msk  = 0x8   // Bit mask of RSTTX field.
	UART_CR_RSTTX      = 0x8   // Bit RSTTX.
	UART_CR_RXEN_Pos   = 0x4   // Position of RXEN field.
	UART_CR_RXEN_Msk   = 0x10  // Bit mask of RXEN field.
	UART_CR_RXEN       = 0x10  // Bit RXEN.
	UART_CR_RXDIS_Pos  = 0x5   // Position of RXDIS field.
	UART_CR_RXDIS_Msk  = 0x20  // Bit mask of RXDIS field.
	UART_CR_RXDIS      = 0x20  // Bit RXDIS.
	UART_CR_TXEN_Pos   = 0x6   // Position of TXEN field.
	UART_CR_TXEN_Msk   = 0x40  // Bit mask of TXEN field.
	UART_CR_TXEN       = 0x40  // Bit TXEN.
	UART_CR_TXDIS_Pos  = 0x7   // Position of TXDIS field.
	UART_CR_TXDIS_Msk  = 0x80  // Bit mask of TXDIS field.
	UART_CR_TXDIS      = 0x80  // Bit TXDIS.
	UART_CR_RSTSTA_Pos = 0x8   // Position of RSTSTA field.
	UART_CR_RSTSTA_Msk = 0x100 // Bit mask of RSTSTA field.
	UART_CR_RSTSTA     = 0x100 // Bit RSTSTA.

	// MR: Mode Register
	UART_MR_PAR_Pos                = 0x9    // Position of PAR field.
	UART_MR_PAR_Msk                = 0xe00  // Bit mask of PAR field.
	UART_MR_PAR_EVEN               = 0x0    // Even Parity
	UART_MR_PAR_ODD                = 0x1    // Odd Parity
	UART_MR_PAR_SPACE              = 0x2    // Space: parity forced to 0
	UART_MR_PAR_MARK               = 0x3    // Mark: parity forced to 1
	UART_MR_PAR_NO                 = 0x4    // No Parity
	UART_MR_CHMODE_Pos             = 0xe    // Position of CHMODE field.
	UART_MR_CHMODE_Msk             = 0xc000 // Bit mask of CHMODE field.
	UART_MR_CHMODE_NORMAL          = 0x0    // Normal Mode
	UART_MR_CHMODE_AUTOMATIC       = 0x1    // Automatic Echo
	UART_MR_CHMODE_LOCAL_LOOPBACK  = 0x2    // Local Loopback
	UART_MR_CHMODE_REMOTE_LOOPBACK = 0x3    // Remote Loopback

	// IER: Interrupt Enable Register
	UART_IER_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	UART_IER_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	UART_IER_RXRDY       = 0x1   // Bit RXRDY.
	UART_IER_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	UART_IER_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	UART_IER_TXRDY       = 0x2   // Bit TXRDY.
	UART_IER_OVRE_Pos    = 0x5   // Position of OVRE field.
	UART_IER_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	UART_IER_OVRE        = 0x20  // Bit OVRE.
	UART_IER_FRAME_Pos   = 0x6   // Position of FRAME field.
	UART_IER_FRAME_Msk   = 0x40  // Bit mask of FRAME field.
	UART_IER_FRAME       = 0x40  // Bit FRAME.
	UART_IER_PARE_Pos    = 0x7   // Position of PARE field.
	UART_IER_PARE_Msk    = 0x80  // Bit mask of PARE field.
	UART_IER_PARE        = 0x80  // Bit PARE.
	UART_IER_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	UART_IER_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	UART_IER_TXEMPTY     = 0x200 // Bit TXEMPTY.

	// IDR: Interrupt Disable Register
	UART_IDR_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	UART_IDR_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	UART_IDR_RXRDY       = 0x1   // Bit RXRDY.
	UART_IDR_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	UART_IDR_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	UART_IDR_TXRDY       = 0x2   // Bit TXRDY.
	UART_IDR_OVRE_Pos    = 0x5   // Position of OVRE field.
	UART_IDR_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	UART_IDR_OVRE        = 0x20  // Bit OVRE.
	UART_IDR_FRAME_Pos   = 0x6   // Position of FRAME field.
	UART_IDR_FRAME_Msk   = 0x40  // Bit mask of FRAME field.
	UART_IDR_FRAME       = 0x40  // Bit FRAME.
	UART_IDR_PARE_Pos    = 0x7   // Position of PARE field.
	UART_IDR_PARE_Msk    = 0x80  // Bit mask of PARE field.
	UART_IDR_PARE        = 0x80  // Bit PARE.
	UART_IDR_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	UART_IDR_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	UART_IDR_TXEMPTY     = 0x200 // Bit TXEMPTY.

	// IMR: Interrupt Mask Register
	UART_IMR_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	UART_IMR_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	UART_IMR_RXRDY       = 0x1   // Bit RXRDY.
	UART_IMR_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	UART_IMR_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	UART_IMR_TXRDY       = 0x2   // Bit TXRDY.
	UART_IMR_OVRE_Pos    = 0x5   // Position of OVRE field.
	UART_IMR_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	UART_IMR_OVRE        = 0x20  // Bit OVRE.
	UART_IMR_FRAME_Pos   = 0x6   // Position of FRAME field.
	UART_IMR_FRAME_Msk   = 0x40  // Bit mask of FRAME field.
	UART_IMR_FRAME       = 0x40  // Bit FRAME.
	UART_IMR_PARE_Pos    = 0x7   // Position of PARE field.
	UART_IMR_PARE_Msk    = 0x80  // Bit mask of PARE field.
	UART_IMR_PARE        = 0x80  // Bit PARE.
	UART_IMR_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	UART_IMR_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	UART_IMR_TXEMPTY     = 0x200 // Bit TXEMPTY.

	// SR: Status Register
	UART_SR_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	UART_SR_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	UART_SR_RXRDY       = 0x1   // Bit RXRDY.
	UART_SR_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	UART_SR_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	UART_SR_TXRDY       = 0x2   // Bit TXRDY.
	UART_SR_OVRE_Pos    = 0x5   // Position of OVRE field.
	UART_SR_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	UART_SR_OVRE        = 0x20  // Bit OVRE.
	UART_SR_FRAME_Pos   = 0x6   // Position of FRAME field.
	UART_SR_FRAME_Msk   = 0x40  // Bit mask of FRAME field.
	UART_SR_FRAME       = 0x40  // Bit FRAME.
	UART_SR_PARE_Pos    = 0x7   // Position of PARE field.
	UART_SR_PARE_Msk    = 0x80  // Bit mask of PARE field.
	UART_SR_PARE        = 0x80  // Bit PARE.
	UART_SR_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	UART_SR_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	UART_SR_TXEMPTY     = 0x200 // Bit TXEMPTY.

	// RHR: Receive Holding Register
	UART_RHR_RXCHR_Pos = 0x0  // Position of RXCHR field.
	UART_RHR_RXCHR_Msk = 0xff // Bit mask of RXCHR field.

	// THR: Transmit Holding Register
	UART_THR_TXCHR_Pos = 0x0  // Position of TXCHR field.
	UART_THR_TXCHR_Msk = 0xff // Bit mask of TXCHR field.

	// BRGR: Baud Rate Generator Register
	UART_BRGR_CD_Pos = 0x0    // Position of CD field.
	UART_BRGR_CD_Msk = 0xffff // Bit mask of CD field.
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// CR: Control Register
	ADC_CR_SWRST_Pos   = 0x0 // Position of SWRST field.
	ADC_CR_SWRST_Msk   = 0x1 // Bit mask of SWRST field.
	ADC_CR_SWRST       = 0x1 // Bit SWRST.
	ADC_CR_START_Pos   = 0x1 // Position of START field.
	ADC_CR_START_Msk   = 0x2 // Bit mask of START field.
	ADC_CR_START       = 0x2 // Bit START.
	ADC_CR_TSCALIB_Pos = 0x2 // Position of TSCALIB field.
	ADC_CR_TSCALIB_Msk = 0x4 // Bit mask of TSCALIB field.
	ADC_CR_TSCALIB     = 0x4 // Bit TSCALIB.

	// MR: Mode Register
	ADC_MR_LOWRES_Pos     = 0x4        // Position of LOWRES field.
	ADC_MR_LOWRES_Msk     = 0x10       // Bit mask of LOWRES field.
	ADC_MR_LOWRES         = 0x10       // Bit LOWRES.
	ADC_MR_LOWRES_BITS_10 = 0x0        // 10-bit resolution
	ADC_MR_LOWRES_BITS_8  = 0x1        // 8-bit resolution
	ADC_MR_SLEEP_Pos      = 0x5        // Position of SLEEP field.
	ADC_MR_SLEEP_Msk      = 0x20       // Bit mask of SLEEP field.
	ADC_MR_SLEEP          = 0x20       // Bit SLEEP.
	ADC_MR_SLEEP_NORMAL   = 0x0        // Normal Mode: The ADC Core and reference voltage circuitry are kept ON between conversions
	ADC_MR_SLEEP_SLEEP    = 0x1        // Sleep Mode: The ADC Core and reference voltage circuitry are OFF between conversions
	ADC_MR_FWUP_Pos       = 0x6        // Position of FWUP field.
	ADC_MR_FWUP_Msk       = 0x40       // Bit mask of FWUP field.
	ADC_MR_FWUP           = 0x40       // Bit FWUP.
	ADC_MR_FWUP_OFF       = 0x0        // Normal Sleep Mode: The sleep mode is defined by the SLEEP bit
	ADC_MR_FWUP_ON        = 0x1        // Fast Wake Up Sleep Mode: The Voltage reference is ON between conversions and ADC Core is OFF
	ADC_MR_PRESCAL_Pos    = 0x8        // Position of PRESCAL field.
	ADC_MR_PRESCAL_Msk    = 0xff00     // Bit mask of PRESCAL field.
	ADC_MR_STARTUP_Pos    = 0x10       // Position of STARTUP field.
	ADC_MR_STARTUP_Msk    = 0xf0000    // Bit mask of STARTUP field.
	ADC_MR_STARTUP_SUT0   = 0x0        // 0 periods of ADCClock
	ADC_MR_STARTUP_SUT8   = 0x1        // 8 periods of ADCClock
	ADC_MR_STARTUP_SUT16  = 0x2        // 16 periods of ADCClock
	ADC_MR_STARTUP_SUT24  = 0x3        // 24 periods of ADCClock
	ADC_MR_STARTUP_SUT64  = 0x4        // 64 periods of ADCClock
	ADC_MR_STARTUP_SUT80  = 0x5        // 80 periods of ADCClock
	ADC_MR_STARTUP_SUT96  = 0x6        // 96 periods of ADCClock
	ADC_MR_STARTUP_SUT112 = 0x7        // 112 periods of ADCClock
	ADC_MR_STARTUP_SUT512 = 0x8        // 512 periods of ADCClock
	ADC_MR_STARTUP_SUT576 = 0x9        // 576 periods of ADCClock
	ADC_MR_STARTUP_SUT640 = 0xa        // 640 periods of ADCClock
	ADC_MR_STARTUP_SUT704 = 0xb        // 704 periods of ADCClock
	ADC_MR_STARTUP_SUT768 = 0xc        // 768 periods of ADCClock
	ADC_MR_STARTUP_SUT832 = 0xd        // 832 periods of ADCClock
	ADC_MR_STARTUP_SUT896 = 0xe        // 896 periods of ADCClock
	ADC_MR_STARTUP_SUT960 = 0xf        // 960 periods of ADCClock
	ADC_MR_TRACKTIM_Pos   = 0x18       // Position of TRACKTIM field.
	ADC_MR_TRACKTIM_Msk   = 0xf000000  // Bit mask of TRACKTIM field.
	ADC_MR_USEQ_Pos       = 0x1f       // Position of USEQ field.
	ADC_MR_USEQ_Msk       = 0x80000000 // Bit mask of USEQ field.
	ADC_MR_USEQ           = 0x80000000 // Bit USEQ.
	ADC_MR_USEQ_NUM_ORDER = 0x0        // Normal Mode: The controller converts channels in a simple numeric order depending only on the channel index.
	ADC_MR_USEQ_REG_ORDER = 0x1        // User Sequence Mode: The sequence respects what is defined in ADC_SEQR1 and ADC_SEQR2 registers and can be used to convert several times the same channel.

	// SEQR1: Channel Sequence Register 1
	ADC_SEQR1_USCH1_Pos = 0x0        // Position of USCH1 field.
	ADC_SEQR1_USCH1_Msk = 0xf        // Bit mask of USCH1 field.
	ADC_SEQR1_USCH2_Pos = 0x4        // Position of USCH2 field.
	ADC_SEQR1_USCH2_Msk = 0xf0       // Bit mask of USCH2 field.
	ADC_SEQR1_USCH3_Pos = 0x8        // Position of USCH3 field.
	ADC_SEQR1_USCH3_Msk = 0xf00      // Bit mask of USCH3 field.
	ADC_SEQR1_USCH4_Pos = 0xc        // Position of USCH4 field.
	ADC_SEQR1_USCH4_Msk = 0xf000     // Bit mask of USCH4 field.
	ADC_SEQR1_USCH5_Pos = 0x10       // Position of USCH5 field.
	ADC_SEQR1_USCH5_Msk = 0xf0000    // Bit mask of USCH5 field.
	ADC_SEQR1_USCH6_Pos = 0x14       // Position of USCH6 field.
	ADC_SEQR1_USCH6_Msk = 0xf00000   // Bit mask of USCH6 field.
	ADC_SEQR1_USCH7_Pos = 0x18       // Position of USCH7 field.
	ADC_SEQR1_USCH7_Msk = 0xf000000  // Bit mask of USCH7 field.
	ADC_SEQR1_USCH8_Pos = 0x1c       // Position of USCH8 field.
	ADC_SEQR1_USCH8_Msk = 0xf0000000 // Bit mask of USCH8 field.

	// SEQR2: Channel Sequence Register 2
	ADC_SEQR2_USCH9_Pos  = 0x0        // Position of USCH9 field.
	ADC_SEQR2_USCH9_Msk  = 0xf        // Bit mask of USCH9 field.
	ADC_SEQR2_USCH10_Pos = 0x4        // Position of USCH10 field.
	ADC_SEQR2_USCH10_Msk = 0xf0       // Bit mask of USCH10 field.
	ADC_SEQR2_USCH11_Pos = 0x8        // Position of USCH11 field.
	ADC_SEQR2_USCH11_Msk = 0xf00      // Bit mask of USCH11 field.
	ADC_SEQR2_USCH12_Pos = 0xc        // Position of USCH12 field.
	ADC_SEQR2_USCH12_Msk = 0xf000     // Bit mask of USCH12 field.
	ADC_SEQR2_USCH13_Pos = 0x10       // Position of USCH13 field.
	ADC_SEQR2_USCH13_Msk = 0xf0000    // Bit mask of USCH13 field.
	ADC_SEQR2_USCH14_Pos = 0x14       // Position of USCH14 field.
	ADC_SEQR2_USCH14_Msk = 0xf00000   // Bit mask of USCH14 field.
	ADC_SEQR2_USCH15_Pos = 0x18       // Position of USCH15 field.
	ADC_SEQR2_USCH15_Msk = 0xf000000  // Bit mask of USCH15 field.
	ADC_SEQR2_USCH16_Pos = 0x1c       // Position of USCH16 field.
	ADC_SEQR2_USCH16_Msk = 0xf0000000 // Bit mask of USCH16 field.

	// CHER: Channel Enable Register
	ADC_CHER_CH0_Pos  = 0x0   // Position of CH0 field.
	ADC_CHER_CH0_Msk  = 0x1   // Bit mask of CH0 field.
	ADC_CHER_CH0      = 0x1   // Bit CH0.
	ADC_CHER_CH1_Pos  = 0x1   // Position of CH1 field.
	ADC_CHER_CH1_Msk  = 0x2   // Bit mask of CH1 field.
	ADC_CHER_CH1      = 0x2   // Bit CH1.
	ADC_CHER_CH2_Pos  = 0x2   // Position of CH2 field.
	ADC_CHER_CH2_Msk  = 0x4   // Bit mask of CH2 field.
	ADC_CHER_CH2      = 0x4   // Bit CH2.
	ADC_CHER_CH3_Pos  = 0x3   // Position of CH3 field.
	ADC_CHER_CH3_Msk  = 0x8   // Bit mask of CH3 field.
	ADC_CHER_CH3      = 0x8   // Bit CH3.
	ADC_CHER_CH4_Pos  = 0x4   // Position of CH4 field.
	ADC_CHER_CH4_Msk  = 0x10  // Bit mask of CH4 field.
	ADC_CHER_CH4      = 0x10  // Bit CH4.
	ADC_CHER_CH5_Pos  = 0x5   // Position of CH5 field.
	ADC_CHER_CH5_Msk  = 0x20  // Bit mask of CH5 field.
	ADC_CHER_CH5      = 0x20  // Bit CH5.
	ADC_CHER_CH6_Pos  = 0x6   // Position of CH6 field.
	ADC_CHER_CH6_Msk  = 0x40  // Bit mask of CH6 field.
	ADC_CHER_CH6      = 0x40  // Bit CH6.
	ADC_CHER_CH7_Pos  = 0x7   // Position of CH7 field.
	ADC_CHER_CH7_Msk  = 0x80  // Bit mask of CH7 field.
	ADC_CHER_CH7      = 0x80  // Bit CH7.
	ADC_CHER_CH8_Pos  = 0x8   // Position of CH8 field.
	ADC_CHER_CH8_Msk  = 0x100 // Bit mask of CH8 field.
	ADC_CHER_CH8      = 0x100 // Bit CH8.
	ADC_CHER_CH9_Pos  = 0x9   // Position of CH9 field.
	ADC_CHER_CH9_Msk  = 0x200 // Bit mask of CH9 field.
	ADC_CHER_CH9      = 0x200 // Bit CH9.
	ADC_CHER_CH10_Pos = 0xa   // Position of CH10 field.
	ADC_CHER_CH10_Msk = 0x400 // Bit mask of CH10 field.
	ADC_CHER_CH10     = 0x400 // Bit CH10.
	ADC_CHER_CH11_Pos = 0xb   // Position of CH11 field.
	ADC_CHER_CH11_Msk = 0x800 // Bit mask of CH11 field.
	ADC_CHER_CH11     = 0x800 // Bit CH11.

	// CHDR: Channel Disable Register
	ADC_CHDR_CH0_Pos  = 0x0   // Position of CH0 field.
	ADC_CHDR_CH0_Msk  = 0x1   // Bit mask of CH0 field.
	ADC_CHDR_CH0      = 0x1   // Bit CH0.
	ADC_CHDR_CH1_Pos  = 0x1   // Position of CH1 field.
	ADC_CHDR_CH1_Msk  = 0x2   // Bit mask of CH1 field.
	ADC_CHDR_CH1      = 0x2   // Bit CH1.
	ADC_CHDR_CH2_Pos  = 0x2   // Position of CH2 field.
	ADC_CHDR_CH2_Msk  = 0x4   // Bit mask of CH2 field.
	ADC_CHDR_CH2      = 0x4   // Bit CH2.
	ADC_CHDR_CH3_Pos  = 0x3   // Position of CH3 field.
	ADC_CHDR_CH3_Msk  = 0x8   // Bit mask of CH3 field.
	ADC_CHDR_CH3      = 0x8   // Bit CH3.
	ADC_CHDR_CH4_Pos  = 0x4   // Position of CH4 field.
	ADC_CHDR_CH4_Msk  = 0x10  // Bit mask of CH4 field.
	ADC_CHDR_CH4      = 0x10  // Bit CH4.
	ADC_CHDR_CH5_Pos  = 0x5   // Position of CH5 field.
	ADC_CHDR_CH5_Msk  = 0x20  // Bit mask of CH5 field.
	ADC_CHDR_CH5      = 0x20  // Bit CH5.
	ADC_CHDR_CH6_Pos  = 0x6   // Position of CH6 field.
	ADC_CHDR_CH6_Msk  = 0x40  // Bit mask of CH6 field.
	ADC_CHDR_CH6      = 0x40  // Bit CH6.
	ADC_CHDR_CH7_Pos  = 0x7   // Position of CH7 field.
	ADC_CHDR_CH7_Msk  = 0x80  // Bit mask of CH7 field.
	ADC_CHDR_CH7      = 0x80  // Bit CH7.
	ADC_CHDR_CH8_Pos  = 0x8   // Position of CH8 field.
	ADC_CHDR_CH8_Msk  = 0x100 // Bit mask of CH8 field.
	ADC_CHDR_CH8      = 0x100 // Bit CH8.
	ADC_CHDR_CH9_Pos  = 0x9   // Position of CH9 field.
	ADC_CHDR_CH9_Msk  = 0x200 // Bit mask of CH9 field.
	ADC_CHDR_CH9      = 0x200 // Bit CH9.
	ADC_CHDR_CH10_Pos = 0xa   // Position of CH10 field.
	ADC_CHDR_CH10_Msk = 0x400 // Bit mask of CH10 field.
	ADC_CHDR_CH10     = 0x400 // Bit CH10.
	ADC_CHDR_CH11_Pos = 0xb   // Position of CH11 field.
	ADC_CHDR_CH11_Msk = 0x800 // Bit mask of CH11 field.
	ADC_CHDR_CH11     = 0x800 // Bit CH11.

	// CHSR: Channel Status Register
	ADC_CHSR_CH0_Pos  = 0x0   // Position of CH0 field.
	ADC_CHSR_CH0_Msk  = 0x1   // Bit mask of CH0 field.
	ADC_CHSR_CH0      = 0x1   // Bit CH0.
	ADC_CHSR_CH1_Pos  = 0x1   // Position of CH1 field.
	ADC_CHSR_CH1_Msk  = 0x2   // Bit mask of CH1 field.
	ADC_CHSR_CH1      = 0x2   // Bit CH1.
	ADC_CHSR_CH2_Pos  = 0x2   // Position of CH2 field.
	ADC_CHSR_CH2_Msk  = 0x4   // Bit mask of CH2 field.
	ADC_CHSR_CH2      = 0x4   // Bit CH2.
	ADC_CHSR_CH3_Pos  = 0x3   // Position of CH3 field.
	ADC_CHSR_CH3_Msk  = 0x8   // Bit mask of CH3 field.
	ADC_CHSR_CH3      = 0x8   // Bit CH3.
	ADC_CHSR_CH4_Pos  = 0x4   // Position of CH4 field.
	ADC_CHSR_CH4_Msk  = 0x10  // Bit mask of CH4 field.
	ADC_CHSR_CH4      = 0x10  // Bit CH4.
	ADC_CHSR_CH5_Pos  = 0x5   // Position of CH5 field.
	ADC_CHSR_CH5_Msk  = 0x20  // Bit mask of CH5 field.
	ADC_CHSR_CH5      = 0x20  // Bit CH5.
	ADC_CHSR_CH6_Pos  = 0x6   // Position of CH6 field.
	ADC_CHSR_CH6_Msk  = 0x40  // Bit mask of CH6 field.
	ADC_CHSR_CH6      = 0x40  // Bit CH6.
	ADC_CHSR_CH7_Pos  = 0x7   // Position of CH7 field.
	ADC_CHSR_CH7_Msk  = 0x80  // Bit mask of CH7 field.
	ADC_CHSR_CH7      = 0x80  // Bit CH7.
	ADC_CHSR_CH8_Pos  = 0x8   // Position of CH8 field.
	ADC_CHSR_CH8_Msk  = 0x100 // Bit mask of CH8 field.
	ADC_CHSR_CH8      = 0x100 // Bit CH8.
	ADC_CHSR_CH9_Pos  = 0x9   // Position of CH9 field.
	ADC_CHSR_CH9_Msk  = 0x200 // Bit mask of CH9 field.
	ADC_CHSR_CH9      = 0x200 // Bit CH9.
	ADC_CHSR_CH10_Pos = 0xa   // Position of CH10 field.
	ADC_CHSR_CH10_Msk = 0x400 // Bit mask of CH10 field.
	ADC_CHSR_CH10     = 0x400 // Bit CH10.
	ADC_CHSR_CH11_Pos = 0xb   // Position of CH11 field.
	ADC_CHSR_CH11_Msk = 0x800 // Bit mask of CH11 field.
	ADC_CHSR_CH11     = 0x800 // Bit CH11.

	// LCDR: Last Converted Data Register
	ADC_LCDR_LDATA_Pos = 0x0    // Position of LDATA field.
	ADC_LCDR_LDATA_Msk = 0xfff  // Bit mask of LDATA field.
	ADC_LCDR_CHNB_Pos  = 0xc    // Position of CHNB field.
	ADC_LCDR_CHNB_Msk  = 0xf000 // Bit mask of CHNB field.

	// IER: Interrupt Enable Register
	ADC_IER_EOC0_Pos  = 0x0        // Position of EOC0 field.
	ADC_IER_EOC0_Msk  = 0x1        // Bit mask of EOC0 field.
	ADC_IER_EOC0      = 0x1        // Bit EOC0.
	ADC_IER_EOC1_Pos  = 0x1        // Position of EOC1 field.
	ADC_IER_EOC1_Msk  = 0x2        // Bit mask of EOC1 field.
	ADC_IER_EOC1      = 0x2        // Bit EOC1.
	ADC_IER_EOC2_Pos  = 0x2        // Position of EOC2 field.
	ADC_IER_EOC2_Msk  = 0x4        // Bit mask of EOC2 field.
	ADC_IER_EOC2      = 0x4        // Bit EOC2.
	ADC_IER_EOC3_Pos  = 0x3        // Position of EOC3 field.
	ADC_IER_EOC3_Msk  = 0x8        // Bit mask of EOC3 field.
	ADC_IER_EOC3      = 0x8        // Bit EOC3.
	ADC_IER_EOC4_Pos  = 0x4        // Position of EOC4 field.
	ADC_IER_EOC4_Msk  = 0x10       // Bit mask of EOC4 field.
	ADC_IER_EOC4      = 0x10       // Bit EOC4.
	ADC_IER_EOC5_Pos  = 0x5        // Position of EOC5 field.
	ADC_IER_EOC5_Msk  = 0x20       // Bit mask of EOC5 field.
	ADC_IER_EOC5      = 0x20       // Bit EOC5.
	ADC_IER_EOC6_Pos  = 0x6        // Position of EOC6 field.
	ADC_IER_EOC6_Msk  = 0x40       // Bit mask of EOC6 field.
	ADC_IER_EOC6      = 0x40       // Bit EOC6.
	ADC_IER_EOC7_Pos  = 0x7        // Position of EOC7 field.
	ADC_IER_EOC7_Msk  = 0x80       // Bit mask of EOC7 field.
	ADC_IER_EOC7      = 0x80       // Bit EOC7.
	ADC_IER_EOC8_Pos  = 0x8        // Position of EOC8 field.
	ADC_IER_EOC8_Msk  = 0x100      // Bit mask of EOC8 field.
	ADC_IER_EOC8      = 0x100      // Bit EOC8.
	ADC_IER_EOC9_Pos  = 0x9        // Position of EOC9 field.
	ADC_IER_EOC9_Msk  = 0x200      // Bit mask of EOC9 field.
	ADC_IER_EOC9      = 0x200      // Bit EOC9.
	ADC_IER_EOC10_Pos = 0xa        // Position of EOC10 field.
	ADC_IER_EOC10_Msk = 0x400      // Bit mask of EOC10 field.
	ADC_IER_EOC10     = 0x400      // Bit EOC10.
	ADC_IER_EOC11_Pos = 0xb        // Position of EOC11 field.
	ADC_IER_EOC11_Msk = 0x800      // Bit mask of EOC11 field.
	ADC_IER_EOC11     = 0x800      // Bit EOC11.
	ADC_IER_XRDY_Pos  = 0x14       // Position of XRDY field.
	ADC_IER_XRDY_Msk  = 0x100000   // Bit mask of XRDY field.
	ADC_IER_XRDY      = 0x100000   // Bit XRDY.
	ADC_IER_YRDY_Pos  = 0x15       // Position of YRDY field.
	ADC_IER_YRDY_Msk  = 0x200000   // Bit mask of YRDY field.
	ADC_IER_YRDY      = 0x200000   // Bit YRDY.
	ADC_IER_PRDY_Pos  = 0x16       // Position of PRDY field.
	ADC_IER_PRDY_Msk  = 0x400000   // Bit mask of PRDY field.
	ADC_IER_PRDY      = 0x400000   // Bit PRDY.
	ADC_IER_DRDY_Pos  = 0x18       // Position of DRDY field.
	ADC_IER_DRDY_Msk  = 0x1000000  // Bit mask of DRDY field.
	ADC_IER_DRDY      = 0x1000000  // Bit DRDY.
	ADC_IER_GOVRE_Pos = 0x19       // Position of GOVRE field.
	ADC_IER_GOVRE_Msk = 0x2000000  // Bit mask of GOVRE field.
	ADC_IER_GOVRE     = 0x2000000  // Bit GOVRE.
	ADC_IER_COMPE_Pos = 0x1a       // Position of COMPE field.
	ADC_IER_COMPE_Msk = 0x4000000  // Bit mask of COMPE field.
	ADC_IER_COMPE     = 0x4000000  // Bit COMPE.
	ADC_IER_PEN_Pos   = 0x1d       // Position of PEN field.
	ADC_IER_PEN_Msk   = 0x20000000 // Bit mask of PEN field.
	ADC_IER_PEN       = 0x20000000 // Bit PEN.
	ADC_IER_NOPEN_Pos = 0x1e       // Position of NOPEN field.
	ADC_IER_NOPEN_Msk = 0x40000000 // Bit mask of NOPEN field.
	ADC_IER_NOPEN     = 0x40000000 // Bit NOPEN.

	// IDR: Interrupt Disable Register
	ADC_IDR_EOC0_Pos  = 0x0        // Position of EOC0 field.
	ADC_IDR_EOC0_Msk  = 0x1        // Bit mask of EOC0 field.
	ADC_IDR_EOC0      = 0x1        // Bit EOC0.
	ADC_IDR_EOC1_Pos  = 0x1        // Position of EOC1 field.
	ADC_IDR_EOC1_Msk  = 0x2        // Bit mask of EOC1 field.
	ADC_IDR_EOC1      = 0x2        // Bit EOC1.
	ADC_IDR_EOC2_Pos  = 0x2        // Position of EOC2 field.
	ADC_IDR_EOC2_Msk  = 0x4        // Bit mask of EOC2 field.
	ADC_IDR_EOC2      = 0x4        // Bit EOC2.
	ADC_IDR_EOC3_Pos  = 0x3        // Position of EOC3 field.
	ADC_IDR_EOC3_Msk  = 0x8        // Bit mask of EOC3 field.
	ADC_IDR_EOC3      = 0x8        // Bit EOC3.
	ADC_IDR_EOC4_Pos  = 0x4        // Position of EOC4 field.
	ADC_IDR_EOC4_Msk  = 0x10       // Bit mask of EOC4 field.
	ADC_IDR_EOC4      = 0x10       // Bit EOC4.
	ADC_IDR_EOC5_Pos  = 0x5        // Position of EOC5 field.
	ADC_IDR_EOC5_Msk  = 0x20       // Bit mask of EOC5 field.
	ADC_IDR_EOC5      = 0x20       // Bit EOC5.
	ADC_IDR_EOC6_Pos  = 0x6        // Position of EOC6 field.
	ADC_IDR_EOC6_Msk  = 0x40       // Bit mask of EOC6 field.
	ADC_IDR_EOC6      = 0x40       // Bit EOC6.
	ADC_IDR_EOC7_Pos  = 0x7        // Position of EOC7 field.
	ADC_IDR_EOC7_Msk  = 0x80       // Bit mask of EOC7 field.
	ADC_IDR_EOC7      = 0x80       // Bit EOC7.
	ADC_IDR_EOC8_Pos  = 0x8        // Position of EOC8 field.
	ADC_IDR_EOC8_Msk  = 0x100      // Bit mask of EOC8 field.
	ADC_IDR_EOC8      = 0x100      // Bit EOC8.
	ADC_IDR_EOC9_Pos  = 0x9        // Position of EOC9 field.
	ADC_IDR_EOC9_Msk  = 0x200      // Bit mask of EOC9 field.
	ADC_IDR_EOC9      = 0x200      // Bit EOC9.
	ADC_IDR_EOC10_Pos = 0xa        // Position of EOC10 field.
	ADC_IDR_EOC10_Msk = 0x400      // Bit mask of EOC10 field.
	ADC_IDR_EOC10     = 0x400      // Bit EOC10.
	ADC_IDR_EOC11_Pos = 0xb        // Position of EOC11 field.
	ADC_IDR_EOC11_Msk = 0x800      // Bit mask of EOC11 field.
	ADC_IDR_EOC11     = 0x800      // Bit EOC11.
	ADC_IDR_XRDY_Pos  = 0x14       // Position of XRDY field.
	ADC_IDR_XRDY_Msk  = 0x100000   // Bit mask of XRDY field.
	ADC_IDR_XRDY      = 0x100000   // Bit XRDY.
	ADC_IDR_YRDY_Pos  = 0x15       // Position of YRDY field.
	ADC_IDR_YRDY_Msk  = 0x200000   // Bit mask of YRDY field.
	ADC_IDR_YRDY      = 0x200000   // Bit YRDY.
	ADC_IDR_PRDY_Pos  = 0x16       // Position of PRDY field.
	ADC_IDR_PRDY_Msk  = 0x400000   // Bit mask of PRDY field.
	ADC_IDR_PRDY      = 0x400000   // Bit PRDY.
	ADC_IDR_DRDY_Pos  = 0x18       // Position of DRDY field.
	ADC_IDR_DRDY_Msk  = 0x1000000  // Bit mask of DRDY field.
	ADC_IDR_DRDY      = 0x1000000  // Bit DRDY.
	ADC_IDR_GOVRE_Pos = 0x19       // Position of GOVRE field.
	ADC_IDR_GOVRE_Msk = 0x2000000  // Bit mask of GOVRE field.
	ADC_IDR_GOVRE     = 0x2000000  // Bit GOVRE.
	ADC_IDR_COMPE_Pos = 0x1a       // Position of COMPE field.
	ADC_IDR_COMPE_Msk = 0x4000000  // Bit mask of COMPE field.
	ADC_IDR_COMPE     = 0x4000000  // Bit COMPE.
	ADC_IDR_PEN_Pos   = 0x1d       // Position of PEN field.
	ADC_IDR_PEN_Msk   = 0x20000000 // Bit mask of PEN field.
	ADC_IDR_PEN       = 0x20000000 // Bit PEN.
	ADC_IDR_NOPEN_Pos = 0x1e       // Position of NOPEN field.
	ADC_IDR_NOPEN_Msk = 0x40000000 // Bit mask of NOPEN field.
	ADC_IDR_NOPEN     = 0x40000000 // Bit NOPEN.

	// IMR: Interrupt Mask Register
	ADC_IMR_EOC0_Pos  = 0x0        // Position of EOC0 field.
	ADC_IMR_EOC0_Msk  = 0x1        // Bit mask of EOC0 field.
	ADC_IMR_EOC0      = 0x1        // Bit EOC0.
	ADC_IMR_EOC1_Pos  = 0x1        // Position of EOC1 field.
	ADC_IMR_EOC1_Msk  = 0x2        // Bit mask of EOC1 field.
	ADC_IMR_EOC1      = 0x2        // Bit EOC1.
	ADC_IMR_EOC2_Pos  = 0x2        // Position of EOC2 field.
	ADC_IMR_EOC2_Msk  = 0x4        // Bit mask of EOC2 field.
	ADC_IMR_EOC2      = 0x4        // Bit EOC2.
	ADC_IMR_EOC3_Pos  = 0x3        // Position of EOC3 field.
	ADC_IMR_EOC3_Msk  = 0x8        // Bit mask of EOC3 field.
	ADC_IMR_EOC3      = 0x8        // Bit EOC3.
	ADC_IMR_EOC4_Pos  = 0x4        // Position of EOC4 field.
	ADC_IMR_EOC4_Msk  = 0x10       // Bit mask of EOC4 field.
	ADC_IMR_EOC4      = 0x10       // Bit EOC4.
	ADC_IMR_EOC5_Pos  = 0x5        // Position of EOC5 field.
	ADC_IMR_EOC5_Msk  = 0x20       // Bit mask of EOC5 field.
	ADC_IMR_EOC5      = 0x20       // Bit EOC5.
	ADC_IMR_EOC6_Pos  = 0x6        // Position of EOC6 field.
	ADC_IMR_EOC6_Msk  = 0x40       // Bit mask of EOC6 field.
	ADC_IMR_EOC6      = 0x40       // Bit EOC6.
	ADC_IMR_EOC7_Pos  = 0x7        // Position of EOC7 field.
	ADC_IMR_EOC7_Msk  = 0x80       // Bit mask of EOC7 field.
	ADC_IMR_EOC7      = 0x80       // Bit EOC7.
	ADC_IMR_EOC8_Pos  = 0x8        // Position of EOC8 field.
	ADC_IMR_EOC8_Msk  = 0x100      // Bit mask of EOC8 field.
	ADC_IMR_EOC8      = 0x100      // Bit EOC8.
	ADC_IMR_EOC9_Pos  = 0x9        // Position of EOC9 field.
	ADC_IMR_EOC9_Msk  = 0x200      // Bit mask of EOC9 field.
	ADC_IMR_EOC9      = 0x200      // Bit EOC9.
	ADC_IMR_EOC10_Pos = 0xa        // Position of EOC10 field.
	ADC_IMR_EOC10_Msk = 0x400      // Bit mask of EOC10 field.
	ADC_IMR_EOC10     = 0x400      // Bit EOC10.
	ADC_IMR_EOC11_Pos = 0xb        // Position of EOC11 field.
	ADC_IMR_EOC11_Msk = 0x800      // Bit mask of EOC11 field.
	ADC_IMR_EOC11     = 0x800      // Bit EOC11.
	ADC_IMR_XRDY_Pos  = 0x14       // Position of XRDY field.
	ADC_IMR_XRDY_Msk  = 0x100000   // Bit mask of XRDY field.
	ADC_IMR_XRDY      = 0x100000   // Bit XRDY.
	ADC_IMR_YRDY_Pos  = 0x15       // Position of YRDY field.
	ADC_IMR_YRDY_Msk  = 0x200000   // Bit mask of YRDY field.
	ADC_IMR_YRDY      = 0x200000   // Bit YRDY.
	ADC_IMR_PRDY_Pos  = 0x16       // Position of PRDY field.
	ADC_IMR_PRDY_Msk  = 0x400000   // Bit mask of PRDY field.
	ADC_IMR_PRDY      = 0x400000   // Bit PRDY.
	ADC_IMR_DRDY_Pos  = 0x18       // Position of DRDY field.
	ADC_IMR_DRDY_Msk  = 0x1000000  // Bit mask of DRDY field.
	ADC_IMR_DRDY      = 0x1000000  // Bit DRDY.
	ADC_IMR_GOVRE_Pos = 0x19       // Position of GOVRE field.
	ADC_IMR_GOVRE_Msk = 0x2000000  // Bit mask of GOVRE field.
	ADC_IMR_GOVRE     = 0x2000000  // Bit GOVRE.
	ADC_IMR_COMPE_Pos = 0x1a       // Position of COMPE field.
	ADC_IMR_COMPE_Msk = 0x4000000  // Bit mask of COMPE field.
	ADC_IMR_COMPE     = 0x4000000  // Bit COMPE.
	ADC_IMR_PEN_Pos   = 0x1d       // Position of PEN field.
	ADC_IMR_PEN_Msk   = 0x20000000 // Bit mask of PEN field.
	ADC_IMR_PEN       = 0x20000000 // Bit PEN.
	ADC_IMR_NOPEN_Pos = 0x1e       // Position of NOPEN field.
	ADC_IMR_NOPEN_Msk = 0x40000000 // Bit mask of NOPEN field.
	ADC_IMR_NOPEN     = 0x40000000 // Bit NOPEN.

	// ISR: Interrupt Status Register
	ADC_ISR_EOC0_Pos  = 0x0        // Position of EOC0 field.
	ADC_ISR_EOC0_Msk  = 0x1        // Bit mask of EOC0 field.
	ADC_ISR_EOC0      = 0x1        // Bit EOC0.
	ADC_ISR_EOC1_Pos  = 0x1        // Position of EOC1 field.
	ADC_ISR_EOC1_Msk  = 0x2        // Bit mask of EOC1 field.
	ADC_ISR_EOC1      = 0x2        // Bit EOC1.
	ADC_ISR_EOC2_Pos  = 0x2        // Position of EOC2 field.
	ADC_ISR_EOC2_Msk  = 0x4        // Bit mask of EOC2 field.
	ADC_ISR_EOC2      = 0x4        // Bit EOC2.
	ADC_ISR_EOC3_Pos  = 0x3        // Position of EOC3 field.
	ADC_ISR_EOC3_Msk  = 0x8        // Bit mask of EOC3 field.
	ADC_ISR_EOC3      = 0x8        // Bit EOC3.
	ADC_ISR_EOC4_Pos  = 0x4        // Position of EOC4 field.
	ADC_ISR_EOC4_Msk  = 0x10       // Bit mask of EOC4 field.
	ADC_ISR_EOC4      = 0x10       // Bit EOC4.
	ADC_ISR_EOC5_Pos  = 0x5        // Position of EOC5 field.
	ADC_ISR_EOC5_Msk  = 0x20       // Bit mask of EOC5 field.
	ADC_ISR_EOC5      = 0x20       // Bit EOC5.
	ADC_ISR_EOC6_Pos  = 0x6        // Position of EOC6 field.
	ADC_ISR_EOC6_Msk  = 0x40       // Bit mask of EOC6 field.
	ADC_ISR_EOC6      = 0x40       // Bit EOC6.
	ADC_ISR_EOC7_Pos  = 0x7        // Position of EOC7 field.
	ADC_ISR_EOC7_Msk  = 0x80       // Bit mask of EOC7 field.
	ADC_ISR_EOC7      = 0x80       // Bit EOC7.
	ADC_ISR_EOC8_Pos  = 0x8        // Position of EOC8 field.
	ADC_ISR_EOC8_Msk  = 0x100      // Bit mask of EOC8 field.
	ADC_ISR_EOC8      = 0x100      // Bit EOC8.
	ADC_ISR_EOC9_Pos  = 0x9        // Position of EOC9 field.
	ADC_ISR_EOC9_Msk  = 0x200      // Bit mask of EOC9 field.
	ADC_ISR_EOC9      = 0x200      // Bit EOC9.
	ADC_ISR_EOC10_Pos = 0xa        // Position of EOC10 field.
	ADC_ISR_EOC10_Msk = 0x400      // Bit mask of EOC10 field.
	ADC_ISR_EOC10     = 0x400      // Bit EOC10.
	ADC_ISR_EOC11_Pos = 0xb        // Position of EOC11 field.
	ADC_ISR_EOC11_Msk = 0x800      // Bit mask of EOC11 field.
	ADC_ISR_EOC11     = 0x800      // Bit EOC11.
	ADC_ISR_XRDY_Pos  = 0x14       // Position of XRDY field.
	ADC_ISR_XRDY_Msk  = 0x100000   // Bit mask of XRDY field.
	ADC_ISR_XRDY      = 0x100000   // Bit XRDY.
	ADC_ISR_YRDY_Pos  = 0x15       // Position of YRDY field.
	ADC_ISR_YRDY_Msk  = 0x200000   // Bit mask of YRDY field.
	ADC_ISR_YRDY      = 0x200000   // Bit YRDY.
	ADC_ISR_PRDY_Pos  = 0x16       // Position of PRDY field.
	ADC_ISR_PRDY_Msk  = 0x400000   // Bit mask of PRDY field.
	ADC_ISR_PRDY      = 0x400000   // Bit PRDY.
	ADC_ISR_DRDY_Pos  = 0x18       // Position of DRDY field.
	ADC_ISR_DRDY_Msk  = 0x1000000  // Bit mask of DRDY field.
	ADC_ISR_DRDY      = 0x1000000  // Bit DRDY.
	ADC_ISR_GOVRE_Pos = 0x19       // Position of GOVRE field.
	ADC_ISR_GOVRE_Msk = 0x2000000  // Bit mask of GOVRE field.
	ADC_ISR_GOVRE     = 0x2000000  // Bit GOVRE.
	ADC_ISR_COMPE_Pos = 0x1a       // Position of COMPE field.
	ADC_ISR_COMPE_Msk = 0x4000000  // Bit mask of COMPE field.
	ADC_ISR_COMPE     = 0x4000000  // Bit COMPE.
	ADC_ISR_PEN_Pos   = 0x1d       // Position of PEN field.
	ADC_ISR_PEN_Msk   = 0x20000000 // Bit mask of PEN field.
	ADC_ISR_PEN       = 0x20000000 // Bit PEN.
	ADC_ISR_NOPEN_Pos = 0x1e       // Position of NOPEN field.
	ADC_ISR_NOPEN_Msk = 0x40000000 // Bit mask of NOPEN field.
	ADC_ISR_NOPEN     = 0x40000000 // Bit NOPEN.
	ADC_ISR_PENS_Pos  = 0x1f       // Position of PENS field.
	ADC_ISR_PENS_Msk  = 0x80000000 // Bit mask of PENS field.
	ADC_ISR_PENS      = 0x80000000 // Bit PENS.

	// OVER: Overrun Status Register
	ADC_OVER_OVRE0_Pos  = 0x0   // Position of OVRE0 field.
	ADC_OVER_OVRE0_Msk  = 0x1   // Bit mask of OVRE0 field.
	ADC_OVER_OVRE0      = 0x1   // Bit OVRE0.
	ADC_OVER_OVRE1_Pos  = 0x1   // Position of OVRE1 field.
	ADC_OVER_OVRE1_Msk  = 0x2   // Bit mask of OVRE1 field.
	ADC_OVER_OVRE1      = 0x2   // Bit OVRE1.
	ADC_OVER_OVRE2_Pos  = 0x2   // Position of OVRE2 field.
	ADC_OVER_OVRE2_Msk  = 0x4   // Bit mask of OVRE2 field.
	ADC_OVER_OVRE2      = 0x4   // Bit OVRE2.
	ADC_OVER_OVRE3_Pos  = 0x3   // Position of OVRE3 field.
	ADC_OVER_OVRE3_Msk  = 0x8   // Bit mask of OVRE3 field.
	ADC_OVER_OVRE3      = 0x8   // Bit OVRE3.
	ADC_OVER_OVRE4_Pos  = 0x4   // Position of OVRE4 field.
	ADC_OVER_OVRE4_Msk  = 0x10  // Bit mask of OVRE4 field.
	ADC_OVER_OVRE4      = 0x10  // Bit OVRE4.
	ADC_OVER_OVRE5_Pos  = 0x5   // Position of OVRE5 field.
	ADC_OVER_OVRE5_Msk  = 0x20  // Bit mask of OVRE5 field.
	ADC_OVER_OVRE5      = 0x20  // Bit OVRE5.
	ADC_OVER_OVRE6_Pos  = 0x6   // Position of OVRE6 field.
	ADC_OVER_OVRE6_Msk  = 0x40  // Bit mask of OVRE6 field.
	ADC_OVER_OVRE6      = 0x40  // Bit OVRE6.
	ADC_OVER_OVRE7_Pos  = 0x7   // Position of OVRE7 field.
	ADC_OVER_OVRE7_Msk  = 0x80  // Bit mask of OVRE7 field.
	ADC_OVER_OVRE7      = 0x80  // Bit OVRE7.
	ADC_OVER_OVRE8_Pos  = 0x8   // Position of OVRE8 field.
	ADC_OVER_OVRE8_Msk  = 0x100 // Bit mask of OVRE8 field.
	ADC_OVER_OVRE8      = 0x100 // Bit OVRE8.
	ADC_OVER_OVRE9_Pos  = 0x9   // Position of OVRE9 field.
	ADC_OVER_OVRE9_Msk  = 0x200 // Bit mask of OVRE9 field.
	ADC_OVER_OVRE9      = 0x200 // Bit OVRE9.
	ADC_OVER_OVRE10_Pos = 0xa   // Position of OVRE10 field.
	ADC_OVER_OVRE10_Msk = 0x400 // Bit mask of OVRE10 field.
	ADC_OVER_OVRE10     = 0x400 // Bit OVRE10.
	ADC_OVER_OVRE11_Pos = 0xb   // Position of OVRE11 field.
	ADC_OVER_OVRE11_Msk = 0x800 // Bit mask of OVRE11 field.
	ADC_OVER_OVRE11     = 0x800 // Bit OVRE11.

	// EMR: Extended Mode Register
	ADC_EMR_CMPMODE_Pos   = 0x0       // Position of CMPMODE field.
	ADC_EMR_CMPMODE_Msk   = 0x3       // Bit mask of CMPMODE field.
	ADC_EMR_CMPMODE_LOW   = 0x0       // Generates an event when the converted data is lower than the low threshold of the window.
	ADC_EMR_CMPMODE_HIGH  = 0x1       // Generates an event when the converted data is higher than the high threshold of the window.
	ADC_EMR_CMPMODE_IN    = 0x2       // Generates an event when the converted data is in the comparison window.
	ADC_EMR_CMPMODE_OUT   = 0x3       // Generates an event when the converted data is out of the comparison window.
	ADC_EMR_CMPSEL_Pos    = 0x4       // Position of CMPSEL field.
	ADC_EMR_CMPSEL_Msk    = 0xf0      // Bit mask of CMPSEL field.
	ADC_EMR_CMPALL_Pos    = 0x9       // Position of CMPALL field.
	ADC_EMR_CMPALL_Msk    = 0x200     // Bit mask of CMPALL field.
	ADC_EMR_CMPALL        = 0x200     // Bit CMPALL.
	ADC_EMR_CMPFILTER_Pos = 0xc       // Position of CMPFILTER field.
	ADC_EMR_CMPFILTER_Msk = 0x3000    // Bit mask of CMPFILTER field.
	ADC_EMR_TAG_Pos       = 0x18      // Position of TAG field.
	ADC_EMR_TAG_Msk       = 0x1000000 // Bit mask of TAG field.
	ADC_EMR_TAG           = 0x1000000 // Bit TAG.

	// CWR: Compare Window Register
	ADC_CWR_LOWTHRES_Pos  = 0x0       // Position of LOWTHRES field.
	ADC_CWR_LOWTHRES_Msk  = 0xfff     // Bit mask of LOWTHRES field.
	ADC_CWR_HIGHTHRES_Pos = 0x10      // Position of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Msk = 0xfff0000 // Bit mask of HIGHTHRES field.

	// CDR: Channel Data Register
	ADC_CDR_DATA_Pos = 0x0   // Position of DATA field.
	ADC_CDR_DATA_Msk = 0xfff // Bit mask of DATA field.

	// ACR: Analog Control Register
	ADC_ACR_PENDETSENS_Pos = 0x0 // Position of PENDETSENS field.
	ADC_ACR_PENDETSENS_Msk = 0x3 // Bit mask of PENDETSENS field.

	// TSMR: Touchscreen Mode Register
	ADC_TSMR_TSMODE_Pos          = 0x0        // Position of TSMODE field.
	ADC_TSMR_TSMODE_Msk          = 0x3        // Bit mask of TSMODE field.
	ADC_TSMR_TSMODE_NONE         = 0x0        // No Touchscreen
	ADC_TSMR_TSMODE_4_WIRE_NO_PM = 0x1        // 4-wire Touchscreen without pressure measurement
	ADC_TSMR_TSMODE_4_WIRE       = 0x2        // 4-wire Touchscreen with pressure measurement
	ADC_TSMR_TSMODE_5_WIRE       = 0x3        // 5-wire Touchscreen
	ADC_TSMR_TSAV_Pos            = 0x4        // Position of TSAV field.
	ADC_TSMR_TSAV_Msk            = 0x30       // Bit mask of TSAV field.
	ADC_TSMR_TSAV_NO_FILTER      = 0x0        // No Filtering. Only one ADC conversion per measure
	ADC_TSMR_TSAV_AVG2CONV       = 0x1        // Averages 2 ADC conversions
	ADC_TSMR_TSAV_AVG4CONV       = 0x2        // Averages 4 ADC conversions
	ADC_TSMR_TSAV_AVG8CONV       = 0x3        // Averages 8 ADC conversions
	ADC_TSMR_TSFREQ_Pos          = 0x8        // Position of TSFREQ field.
	ADC_TSMR_TSFREQ_Msk          = 0xf00      // Bit mask of TSFREQ field.
	ADC_TSMR_TSSCTIM_Pos         = 0x10       // Position of TSSCTIM field.
	ADC_TSMR_TSSCTIM_Msk         = 0xf0000    // Bit mask of TSSCTIM field.
	ADC_TSMR_NOTSDMA_Pos         = 0x16       // Position of NOTSDMA field.
	ADC_TSMR_NOTSDMA_Msk         = 0x400000   // Bit mask of NOTSDMA field.
	ADC_TSMR_NOTSDMA             = 0x400000   // Bit NOTSDMA.
	ADC_TSMR_PENDET_Pos          = 0x18       // Position of PENDET field.
	ADC_TSMR_PENDET_Msk          = 0x1000000  // Bit mask of PENDET field.
	ADC_TSMR_PENDET              = 0x1000000  // Bit PENDET.
	ADC_TSMR_PENDBC_Pos          = 0x1c       // Position of PENDBC field.
	ADC_TSMR_PENDBC_Msk          = 0xf0000000 // Bit mask of PENDBC field.

	// XPOSR: Touchscreen X Position Register
	ADC_XPOSR_XPOS_Pos   = 0x0       // Position of XPOS field.
	ADC_XPOSR_XPOS_Msk   = 0xfff     // Bit mask of XPOS field.
	ADC_XPOSR_XSCALE_Pos = 0x10      // Position of XSCALE field.
	ADC_XPOSR_XSCALE_Msk = 0xfff0000 // Bit mask of XSCALE field.

	// YPOSR: Touchscreen Y Position Register
	ADC_YPOSR_YPOS_Pos   = 0x0       // Position of YPOS field.
	ADC_YPOSR_YPOS_Msk   = 0xfff     // Bit mask of YPOS field.
	ADC_YPOSR_YSCALE_Pos = 0x10      // Position of YSCALE field.
	ADC_YPOSR_YSCALE_Msk = 0xfff0000 // Bit mask of YSCALE field.

	// PRESSR: Touchscreen Pressure Register
	ADC_PRESSR_Z1_Pos = 0x0       // Position of Z1 field.
	ADC_PRESSR_Z1_Msk = 0xfff     // Bit mask of Z1 field.
	ADC_PRESSR_Z2_Pos = 0x10      // Position of Z2 field.
	ADC_PRESSR_Z2_Msk = 0xfff0000 // Bit mask of Z2 field.

	// TRGR: Trigger Register
	ADC_TRGR_TRGMOD_Pos           = 0x0        // Position of TRGMOD field.
	ADC_TRGR_TRGMOD_Msk           = 0x7        // Bit mask of TRGMOD field.
	ADC_TRGR_TRGMOD_NO_TRIGGER    = 0x0        // No trigger, only software trigger can start conversions
	ADC_TRGR_TRGMOD_EXT_TRIG_RISE = 0x1        // External Trigger Rising Edge
	ADC_TRGR_TRGMOD_EXT_TRIG_FALL = 0x2        // External Trigger Falling Edge
	ADC_TRGR_TRGMOD_EXT_TRIG_ANY  = 0x3        // External Trigger Any Edge
	ADC_TRGR_TRGMOD_PEN_TRIG      = 0x4        // Pen Detect Trigger (shall be selected only if PENDET is set and TSAMOD = Touchscreen only mode)
	ADC_TRGR_TRGMOD_PERIOD_TRIG   = 0x5        // Periodic Trigger (TRGPER shall be initiated appropriately)
	ADC_TRGR_TRGMOD_CONTINUOUS    = 0x6        // Continuous Mode
	ADC_TRGR_TRGPER_Pos           = 0x10       // Position of TRGPER field.
	ADC_TRGR_TRGPER_Msk           = 0xffff0000 // Bit mask of TRGPER field.

	// WPMR: Write Protect Mode Register
	ADC_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	ADC_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	ADC_WPMR_WPEN      = 0x1        // Bit WPEN.
	ADC_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	ADC_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protect Status Register
	ADC_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	ADC_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	ADC_WPSR_WPVS       = 0x1      // Bit WPVS.
	ADC_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	ADC_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for MATRIX: AHB Bus Matrix
const (
	// MCFG: Master Configuration Register
	MATRIX_MCFG_ULBT_Pos = 0x0 // Position of ULBT field.
	MATRIX_MCFG_ULBT_Msk = 0x7 // Bit mask of ULBT field.

	// SCFG: Slave Configuration Register
	MATRIX_SCFG_SLOT_CYCLE_Pos    = 0x0      // Position of SLOT_CYCLE field.
	MATRIX_SCFG_SLOT_CYCLE_Msk    = 0x1ff    // Bit mask of SLOT_CYCLE field.
	MATRIX_SCFG_DEFMSTR_TYPE_Pos  = 0x10     // Position of DEFMSTR_TYPE field.
	MATRIX_SCFG_DEFMSTR_TYPE_Msk  = 0x30000  // Bit mask of DEFMSTR_TYPE field.
	MATRIX_SCFG_FIXED_DEFMSTR_Pos = 0x12     // Position of FIXED_DEFMSTR field.
	MATRIX_SCFG_FIXED_DEFMSTR_Msk = 0x3c0000 // Bit mask of FIXED_DEFMSTR field.

	// PRAS0: Priority Register A for Slave 0
	MATRIX_PRAS0_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS0_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS0_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS0_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS0_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS0_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS0_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS0_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS0_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS0_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS0_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS0_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS0_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS0_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS0_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS0_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS0: Priority Register B for Slave 0
	MATRIX_PRBS0_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS0_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS0_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS0_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS0_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS0_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS1: Priority Register A for Slave 1
	MATRIX_PRAS1_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS1_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS1_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS1_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS1_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS1_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS1_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS1_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS1_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS1_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS1_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS1_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS1_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS1_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS1_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS1_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS1: Priority Register B for Slave 1
	MATRIX_PRBS1_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS1_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS1_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS1_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS1_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS1_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS2: Priority Register A for Slave 2
	MATRIX_PRAS2_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS2_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS2_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS2_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS2_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS2_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS2_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS2_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS2_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS2_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS2_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS2_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS2_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS2_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS2_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS2_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS2: Priority Register B for Slave 2
	MATRIX_PRBS2_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS2_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS2_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS2_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS2_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS2_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS3: Priority Register A for Slave 3
	MATRIX_PRAS3_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS3_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS3_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS3_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS3_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS3_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS3_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS3_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS3_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS3_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS3_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS3_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS3_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS3_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS3_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS3_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS3: Priority Register B for Slave 3
	MATRIX_PRBS3_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS3_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS3_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS3_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS3_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS3_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS4: Priority Register A for Slave 4
	MATRIX_PRAS4_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS4_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS4_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS4_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS4_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS4_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS4_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS4_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS4_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS4_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS4_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS4_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS4_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS4_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS4_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS4_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS4: Priority Register B for Slave 4
	MATRIX_PRBS4_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS4_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS4_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS4_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS4_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS4_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS5: Priority Register A for Slave 5
	MATRIX_PRAS5_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS5_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS5_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS5_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS5_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS5_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS5_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS5_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS5_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS5_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS5_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS5_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS5_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS5_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS5_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS5_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS5: Priority Register B for Slave 5
	MATRIX_PRBS5_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS5_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS5_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS5_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS5_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS5_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS6: Priority Register A for Slave 6
	MATRIX_PRAS6_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS6_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS6_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS6_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS6_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS6_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS6_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS6_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS6_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS6_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS6_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS6_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS6_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS6_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS6_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS6_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS6: Priority Register B for Slave 6
	MATRIX_PRBS6_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS6_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS6_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS6_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS6_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS6_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS7: Priority Register A for Slave 7
	MATRIX_PRAS7_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS7_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS7_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS7_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS7_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS7_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS7_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS7_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS7_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS7_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS7_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS7_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS7_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS7_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS7_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS7_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS7: Priority Register B for Slave 7
	MATRIX_PRBS7_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS7_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS7_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS7_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS7_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS7_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS8: Priority Register A for Slave 8
	MATRIX_PRAS8_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS8_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS8_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS8_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS8_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS8_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS8_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS8_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS8_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS8_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS8_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS8_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS8_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS8_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS8_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS8_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS8: Priority Register B for Slave 8
	MATRIX_PRBS8_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS8_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS8_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS8_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS8_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS8_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS9: Priority Register A for Slave 9
	MATRIX_PRAS9_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS9_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS9_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS9_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS9_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS9_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS9_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS9_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS9_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS9_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS9_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS9_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS9_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS9_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS9_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS9_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS9: Priority Register B for Slave 9
	MATRIX_PRBS9_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS9_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS9_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS9_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS9_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS9_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// MRCR: Master Remap Control Register
	MATRIX_MRCR_RCB0_Pos  = 0x0   // Position of RCB0 field.
	MATRIX_MRCR_RCB0_Msk  = 0x1   // Bit mask of RCB0 field.
	MATRIX_MRCR_RCB0      = 0x1   // Bit RCB0.
	MATRIX_MRCR_RCB1_Pos  = 0x1   // Position of RCB1 field.
	MATRIX_MRCR_RCB1_Msk  = 0x2   // Bit mask of RCB1 field.
	MATRIX_MRCR_RCB1      = 0x2   // Bit RCB1.
	MATRIX_MRCR_RCB2_Pos  = 0x2   // Position of RCB2 field.
	MATRIX_MRCR_RCB2_Msk  = 0x4   // Bit mask of RCB2 field.
	MATRIX_MRCR_RCB2      = 0x4   // Bit RCB2.
	MATRIX_MRCR_RCB3_Pos  = 0x3   // Position of RCB3 field.
	MATRIX_MRCR_RCB3_Msk  = 0x8   // Bit mask of RCB3 field.
	MATRIX_MRCR_RCB3      = 0x8   // Bit RCB3.
	MATRIX_MRCR_RCB4_Pos  = 0x4   // Position of RCB4 field.
	MATRIX_MRCR_RCB4_Msk  = 0x10  // Bit mask of RCB4 field.
	MATRIX_MRCR_RCB4      = 0x10  // Bit RCB4.
	MATRIX_MRCR_RCB5_Pos  = 0x5   // Position of RCB5 field.
	MATRIX_MRCR_RCB5_Msk  = 0x20  // Bit mask of RCB5 field.
	MATRIX_MRCR_RCB5      = 0x20  // Bit RCB5.
	MATRIX_MRCR_RCB6_Pos  = 0x6   // Position of RCB6 field.
	MATRIX_MRCR_RCB6_Msk  = 0x40  // Bit mask of RCB6 field.
	MATRIX_MRCR_RCB6      = 0x40  // Bit RCB6.
	MATRIX_MRCR_RCB7_Pos  = 0x7   // Position of RCB7 field.
	MATRIX_MRCR_RCB7_Msk  = 0x80  // Bit mask of RCB7 field.
	MATRIX_MRCR_RCB7      = 0x80  // Bit RCB7.
	MATRIX_MRCR_RCB8_Pos  = 0x8   // Position of RCB8 field.
	MATRIX_MRCR_RCB8_Msk  = 0x100 // Bit mask of RCB8 field.
	MATRIX_MRCR_RCB8      = 0x100 // Bit RCB8.
	MATRIX_MRCR_RCB9_Pos  = 0x9   // Position of RCB9 field.
	MATRIX_MRCR_RCB9_Msk  = 0x200 // Bit mask of RCB9 field.
	MATRIX_MRCR_RCB9      = 0x200 // Bit RCB9.
	MATRIX_MRCR_RCB10_Pos = 0xa   // Position of RCB10 field.
	MATRIX_MRCR_RCB10_Msk = 0x400 // Bit mask of RCB10 field.
	MATRIX_MRCR_RCB10     = 0x400 // Bit RCB10.

	// WPMR: Write Protect Mode Register
	MATRIX_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	MATRIX_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	MATRIX_WPMR_WPEN      = 0x1        // Bit WPEN.
	MATRIX_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	MATRIX_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protect Status Register
	MATRIX_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	MATRIX_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	MATRIX_WPSR_WPVS       = 0x1      // Bit WPVS.
	MATRIX_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	MATRIX_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for PMECC: Programmable Multibit Error Corrected Code Controller
const (
	// CFG: PMECC Configuration Register
	EBI_CFG_BCH_ERR_Pos            = 0x0      // Position of BCH_ERR field.
	EBI_CFG_BCH_ERR_Msk            = 0x7      // Bit mask of BCH_ERR field.
	EBI_CFG_BCH_ERR_BCH_ERR2       = 0x0      // 2 errors
	EBI_CFG_BCH_ERR_BCH_ERR4       = 0x1      // 4 errors
	EBI_CFG_BCH_ERR_BCH_ERR8       = 0x2      // 8 errors
	EBI_CFG_BCH_ERR_BCH_ERR12      = 0x3      // 12 errors
	EBI_CFG_BCH_ERR_BCH_ERR24      = 0x4      // 24 errors
	EBI_CFG_SECTORSZ_Pos           = 0x4      // Position of SECTORSZ field.
	EBI_CFG_SECTORSZ_Msk           = 0x10     // Bit mask of SECTORSZ field.
	EBI_CFG_SECTORSZ               = 0x10     // Bit SECTORSZ.
	EBI_CFG_PAGESIZE_Pos           = 0x8      // Position of PAGESIZE field.
	EBI_CFG_PAGESIZE_Msk           = 0x300    // Bit mask of PAGESIZE field.
	EBI_CFG_PAGESIZE_PAGESIZE_1SEC = 0x0      // 1 sector for main area (512 or 1024 bytes)
	EBI_CFG_PAGESIZE_PAGESIZE_2SEC = 0x1      // 2 sectors for main area (1024 or 2048 bytes)
	EBI_CFG_PAGESIZE_PAGESIZE_4SEC = 0x2      // 4 sectors for main area (2048 or 4096 bytes)
	EBI_CFG_PAGESIZE_PAGESIZE_8SEC = 0x3      // 8 errors for main area (4096 or 8192 bytes)
	EBI_CFG_NANDWR_Pos             = 0xc      // Position of NANDWR field.
	EBI_CFG_NANDWR_Msk             = 0x1000   // Bit mask of NANDWR field.
	EBI_CFG_NANDWR                 = 0x1000   // Bit NANDWR.
	EBI_CFG_SPAREEN_Pos            = 0x10     // Position of SPAREEN field.
	EBI_CFG_SPAREEN_Msk            = 0x10000  // Bit mask of SPAREEN field.
	EBI_CFG_SPAREEN                = 0x10000  // Bit SPAREEN.
	EBI_CFG_AUTO_Pos               = 0x14     // Position of AUTO field.
	EBI_CFG_AUTO_Msk               = 0x100000 // Bit mask of AUTO field.
	EBI_CFG_AUTO                   = 0x100000 // Bit AUTO.

	// SAREA: PMECC Spare Area Size Register
	EBI_SAREA_SPARESIZE_Pos = 0x0   // Position of SPARESIZE field.
	EBI_SAREA_SPARESIZE_Msk = 0x1ff // Bit mask of SPARESIZE field.

	// SADDR: PMECC Start Address Register
	EBI_SADDR_STARTADDR_Pos = 0x0   // Position of STARTADDR field.
	EBI_SADDR_STARTADDR_Msk = 0x1ff // Bit mask of STARTADDR field.

	// EADDR: PMECC End Address Register
	EBI_EADDR_ENDADDR_Pos = 0x0   // Position of ENDADDR field.
	EBI_EADDR_ENDADDR_Msk = 0x1ff // Bit mask of ENDADDR field.

	// CLK: PMECC Clock Control Register
	EBI_CLK_CLKCTRL_Pos = 0x0 // Position of CLKCTRL field.
	EBI_CLK_CLKCTRL_Msk = 0x7 // Bit mask of CLKCTRL field.

	// CTRL: PMECC Control Register
	EBI_CTRL_RST_Pos     = 0x0  // Position of RST field.
	EBI_CTRL_RST_Msk     = 0x1  // Bit mask of RST field.
	EBI_CTRL_RST         = 0x1  // Bit RST.
	EBI_CTRL_DATA_Pos    = 0x1  // Position of DATA field.
	EBI_CTRL_DATA_Msk    = 0x2  // Bit mask of DATA field.
	EBI_CTRL_DATA        = 0x2  // Bit DATA.
	EBI_CTRL_USER_Pos    = 0x2  // Position of USER field.
	EBI_CTRL_USER_Msk    = 0x4  // Bit mask of USER field.
	EBI_CTRL_USER        = 0x4  // Bit USER.
	EBI_CTRL_ENABLE_Pos  = 0x4  // Position of ENABLE field.
	EBI_CTRL_ENABLE_Msk  = 0x10 // Bit mask of ENABLE field.
	EBI_CTRL_ENABLE      = 0x10 // Bit ENABLE.
	EBI_CTRL_DISABLE_Pos = 0x5  // Position of DISABLE field.
	EBI_CTRL_DISABLE_Msk = 0x20 // Bit mask of DISABLE field.
	EBI_CTRL_DISABLE     = 0x20 // Bit DISABLE.

	// SR: PMECC Status Register
	EBI_SR_BUSY_Pos   = 0x0  // Position of BUSY field.
	EBI_SR_BUSY_Msk   = 0x1  // Bit mask of BUSY field.
	EBI_SR_BUSY       = 0x1  // Bit BUSY.
	EBI_SR_ENABLE_Pos = 0x4  // Position of ENABLE field.
	EBI_SR_ENABLE_Msk = 0x10 // Bit mask of ENABLE field.
	EBI_SR_ENABLE     = 0x10 // Bit ENABLE.

	// IER: PMECC Interrupt Enable register
	EBI_IER_ERRIE_Pos = 0x0 // Position of ERRIE field.
	EBI_IER_ERRIE_Msk = 0x1 // Bit mask of ERRIE field.
	EBI_IER_ERRIE     = 0x1 // Bit ERRIE.

	// IDR: PMECC Interrupt Disable Register
	EBI_IDR_ERRID_Pos = 0x0 // Position of ERRID field.
	EBI_IDR_ERRID_Msk = 0x1 // Bit mask of ERRID field.
	EBI_IDR_ERRID     = 0x1 // Bit ERRID.

	// IMR: PMECC Interrupt Mask Register
	EBI_IMR_ERRIM_Pos = 0x0 // Position of ERRIM field.
	EBI_IMR_ERRIM_Msk = 0x1 // Bit mask of ERRIM field.
	EBI_IMR_ERRIM     = 0x1 // Bit ERRIM.

	// ISR: PMECC Interrupt Status Register
	EBI_ISR_ERRIS_Pos = 0x0  // Position of ERRIS field.
	EBI_ISR_ERRIS_Msk = 0xff // Bit mask of ERRIS field.

	// ECC0_0: PMECC ECC 0 Register (sec_num = 0)
	EBI_ECC0_0_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC0_0_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC1_0: PMECC ECC 1 Register (sec_num = 0)
	EBI_ECC1_0_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC1_0_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC2_0: PMECC ECC 2 Register (sec_num = 0)
	EBI_ECC2_0_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC2_0_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC3_0: PMECC ECC 3 Register (sec_num = 0)
	EBI_ECC3_0_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC3_0_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC4_0: PMECC ECC 4 Register (sec_num = 0)
	EBI_ECC4_0_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC4_0_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC5_0: PMECC ECC 5 Register (sec_num = 0)
	EBI_ECC5_0_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC5_0_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC6_0: PMECC ECC 6 Register (sec_num = 0)
	EBI_ECC6_0_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC6_0_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC7_0: PMECC ECC 7 Register (sec_num = 0)
	EBI_ECC7_0_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC7_0_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC8_0: PMECC ECC 8 Register (sec_num = 0)
	EBI_ECC8_0_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC8_0_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC9_0: PMECC ECC 9 Register (sec_num = 0)
	EBI_ECC9_0_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC9_0_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC10_0: PMECC ECC 10 Register (sec_num = 0)
	EBI_ECC10_0_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC10_0_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC0_1: PMECC ECC 0 Register (sec_num = 1)
	EBI_ECC0_1_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC0_1_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC1_1: PMECC ECC 1 Register (sec_num = 1)
	EBI_ECC1_1_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC1_1_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC2_1: PMECC ECC 2 Register (sec_num = 1)
	EBI_ECC2_1_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC2_1_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC3_1: PMECC ECC 3 Register (sec_num = 1)
	EBI_ECC3_1_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC3_1_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC4_1: PMECC ECC 4 Register (sec_num = 1)
	EBI_ECC4_1_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC4_1_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC5_1: PMECC ECC 5 Register (sec_num = 1)
	EBI_ECC5_1_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC5_1_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC6_1: PMECC ECC 6 Register (sec_num = 1)
	EBI_ECC6_1_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC6_1_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC7_1: PMECC ECC 7 Register (sec_num = 1)
	EBI_ECC7_1_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC7_1_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC8_1: PMECC ECC 8 Register (sec_num = 1)
	EBI_ECC8_1_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC8_1_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC9_1: PMECC ECC 9 Register (sec_num = 1)
	EBI_ECC9_1_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC9_1_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC10_1: PMECC ECC 10 Register (sec_num = 1)
	EBI_ECC10_1_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC10_1_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC0_2: PMECC ECC 0 Register (sec_num = 2)
	EBI_ECC0_2_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC0_2_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC1_2: PMECC ECC 1 Register (sec_num = 2)
	EBI_ECC1_2_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC1_2_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC2_2: PMECC ECC 2 Register (sec_num = 2)
	EBI_ECC2_2_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC2_2_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC3_2: PMECC ECC 3 Register (sec_num = 2)
	EBI_ECC3_2_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC3_2_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC4_2: PMECC ECC 4 Register (sec_num = 2)
	EBI_ECC4_2_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC4_2_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC5_2: PMECC ECC 5 Register (sec_num = 2)
	EBI_ECC5_2_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC5_2_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC6_2: PMECC ECC 6 Register (sec_num = 2)
	EBI_ECC6_2_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC6_2_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC7_2: PMECC ECC 7 Register (sec_num = 2)
	EBI_ECC7_2_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC7_2_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC8_2: PMECC ECC 8 Register (sec_num = 2)
	EBI_ECC8_2_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC8_2_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC9_2: PMECC ECC 9 Register (sec_num = 2)
	EBI_ECC9_2_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC9_2_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC10_2: PMECC ECC 10 Register (sec_num = 2)
	EBI_ECC10_2_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC10_2_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC0_3: PMECC ECC 0 Register (sec_num = 3)
	EBI_ECC0_3_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC0_3_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC1_3: PMECC ECC 1 Register (sec_num = 3)
	EBI_ECC1_3_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC1_3_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC2_3: PMECC ECC 2 Register (sec_num = 3)
	EBI_ECC2_3_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC2_3_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC3_3: PMECC ECC 3 Register (sec_num = 3)
	EBI_ECC3_3_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC3_3_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC4_3: PMECC ECC 4 Register (sec_num = 3)
	EBI_ECC4_3_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC4_3_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC5_3: PMECC ECC 5 Register (sec_num = 3)
	EBI_ECC5_3_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC5_3_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC6_3: PMECC ECC 6 Register (sec_num = 3)
	EBI_ECC6_3_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC6_3_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC7_3: PMECC ECC 7 Register (sec_num = 3)
	EBI_ECC7_3_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC7_3_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC8_3: PMECC ECC 8 Register (sec_num = 3)
	EBI_ECC8_3_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC8_3_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC9_3: PMECC ECC 9 Register (sec_num = 3)
	EBI_ECC9_3_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC9_3_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC10_3: PMECC ECC 10 Register (sec_num = 3)
	EBI_ECC10_3_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC10_3_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC0_4: PMECC ECC 0 Register (sec_num = 4)
	EBI_ECC0_4_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC0_4_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC1_4: PMECC ECC 1 Register (sec_num = 4)
	EBI_ECC1_4_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC1_4_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC2_4: PMECC ECC 2 Register (sec_num = 4)
	EBI_ECC2_4_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC2_4_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC3_4: PMECC ECC 3 Register (sec_num = 4)
	EBI_ECC3_4_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC3_4_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC4_4: PMECC ECC 4 Register (sec_num = 4)
	EBI_ECC4_4_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC4_4_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC5_4: PMECC ECC 5 Register (sec_num = 4)
	EBI_ECC5_4_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC5_4_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC6_4: PMECC ECC 6 Register (sec_num = 4)
	EBI_ECC6_4_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC6_4_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC7_4: PMECC ECC 7 Register (sec_num = 4)
	EBI_ECC7_4_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC7_4_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC8_4: PMECC ECC 8 Register (sec_num = 4)
	EBI_ECC8_4_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC8_4_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC9_4: PMECC ECC 9 Register (sec_num = 4)
	EBI_ECC9_4_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC9_4_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC10_4: PMECC ECC 10 Register (sec_num = 4)
	EBI_ECC10_4_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC10_4_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC0_5: PMECC ECC 0 Register (sec_num = 5)
	EBI_ECC0_5_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC0_5_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC1_5: PMECC ECC 1 Register (sec_num = 5)
	EBI_ECC1_5_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC1_5_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC2_5: PMECC ECC 2 Register (sec_num = 5)
	EBI_ECC2_5_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC2_5_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC3_5: PMECC ECC 3 Register (sec_num = 5)
	EBI_ECC3_5_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC3_5_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC4_5: PMECC ECC 4 Register (sec_num = 5)
	EBI_ECC4_5_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC4_5_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC5_5: PMECC ECC 5 Register (sec_num = 5)
	EBI_ECC5_5_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC5_5_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC6_5: PMECC ECC 6 Register (sec_num = 5)
	EBI_ECC6_5_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC6_5_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC7_5: PMECC ECC 7 Register (sec_num = 5)
	EBI_ECC7_5_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC7_5_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC8_5: PMECC ECC 8 Register (sec_num = 5)
	EBI_ECC8_5_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC8_5_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC9_5: PMECC ECC 9 Register (sec_num = 5)
	EBI_ECC9_5_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC9_5_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC10_5: PMECC ECC 10 Register (sec_num = 5)
	EBI_ECC10_5_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC10_5_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC0_6: PMECC ECC 0 Register (sec_num = 6)
	EBI_ECC0_6_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC0_6_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC1_6: PMECC ECC 1 Register (sec_num = 6)
	EBI_ECC1_6_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC1_6_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC2_6: PMECC ECC 2 Register (sec_num = 6)
	EBI_ECC2_6_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC2_6_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC3_6: PMECC ECC 3 Register (sec_num = 6)
	EBI_ECC3_6_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC3_6_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC4_6: PMECC ECC 4 Register (sec_num = 6)
	EBI_ECC4_6_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC4_6_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC5_6: PMECC ECC 5 Register (sec_num = 6)
	EBI_ECC5_6_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC5_6_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC6_6: PMECC ECC 6 Register (sec_num = 6)
	EBI_ECC6_6_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC6_6_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC7_6: PMECC ECC 7 Register (sec_num = 6)
	EBI_ECC7_6_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC7_6_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC8_6: PMECC ECC 8 Register (sec_num = 6)
	EBI_ECC8_6_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC8_6_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC9_6: PMECC ECC 9 Register (sec_num = 6)
	EBI_ECC9_6_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC9_6_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC10_6: PMECC ECC 10 Register (sec_num = 6)
	EBI_ECC10_6_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC10_6_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC0_7: PMECC ECC 0 Register (sec_num = 7)
	EBI_ECC0_7_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC0_7_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC1_7: PMECC ECC 1 Register (sec_num = 7)
	EBI_ECC1_7_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC1_7_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC2_7: PMECC ECC 2 Register (sec_num = 7)
	EBI_ECC2_7_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC2_7_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC3_7: PMECC ECC 3 Register (sec_num = 7)
	EBI_ECC3_7_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC3_7_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC4_7: PMECC ECC 4 Register (sec_num = 7)
	EBI_ECC4_7_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC4_7_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC5_7: PMECC ECC 5 Register (sec_num = 7)
	EBI_ECC5_7_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC5_7_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC6_7: PMECC ECC 6 Register (sec_num = 7)
	EBI_ECC6_7_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC6_7_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC7_7: PMECC ECC 7 Register (sec_num = 7)
	EBI_ECC7_7_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC7_7_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC8_7: PMECC ECC 8 Register (sec_num = 7)
	EBI_ECC8_7_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC8_7_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC9_7: PMECC ECC 9 Register (sec_num = 7)
	EBI_ECC9_7_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC9_7_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// ECC10_7: PMECC ECC 10 Register (sec_num = 7)
	EBI_ECC10_7_ECC_Pos = 0x0        // Position of ECC field.
	EBI_ECC10_7_ECC_Msk = 0xffffffff // Bit mask of ECC field.

	// REM0_0: PMECC REM 0 Register (sec_num = 0)
	EBI_REM0_0_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM0_0_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM0_0_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM0_0_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM1_0: PMECC REM 1 Register (sec_num = 0)
	EBI_REM1_0_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM1_0_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM1_0_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM1_0_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM2_0: PMECC REM 2 Register (sec_num = 0)
	EBI_REM2_0_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM2_0_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM2_0_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM2_0_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM3_0: PMECC REM 3 Register (sec_num = 0)
	EBI_REM3_0_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM3_0_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM3_0_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM3_0_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM4_0: PMECC REM 4 Register (sec_num = 0)
	EBI_REM4_0_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM4_0_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM4_0_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM4_0_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM5_0: PMECC REM 5 Register (sec_num = 0)
	EBI_REM5_0_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM5_0_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM5_0_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM5_0_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM6_0: PMECC REM 6 Register (sec_num = 0)
	EBI_REM6_0_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM6_0_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM6_0_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM6_0_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM7_0: PMECC REM 7 Register (sec_num = 0)
	EBI_REM7_0_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM7_0_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM7_0_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM7_0_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM8_0: PMECC REM 8 Register (sec_num = 0)
	EBI_REM8_0_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM8_0_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM8_0_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM8_0_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM9_0: PMECC REM 9 Register (sec_num = 0)
	EBI_REM9_0_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM9_0_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM9_0_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM9_0_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM10_0: PMECC REM 10 Register (sec_num = 0)
	EBI_REM10_0_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM10_0_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM10_0_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM10_0_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM11_0: PMECC REM 11 Register (sec_num = 0)
	EBI_REM11_0_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM11_0_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM11_0_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM11_0_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM0_1: PMECC REM 0 Register (sec_num = 1)
	EBI_REM0_1_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM0_1_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM0_1_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM0_1_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM1_1: PMECC REM 1 Register (sec_num = 1)
	EBI_REM1_1_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM1_1_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM1_1_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM1_1_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM2_1: PMECC REM 2 Register (sec_num = 1)
	EBI_REM2_1_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM2_1_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM2_1_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM2_1_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM3_1: PMECC REM 3 Register (sec_num = 1)
	EBI_REM3_1_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM3_1_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM3_1_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM3_1_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM4_1: PMECC REM 4 Register (sec_num = 1)
	EBI_REM4_1_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM4_1_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM4_1_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM4_1_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM5_1: PMECC REM 5 Register (sec_num = 1)
	EBI_REM5_1_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM5_1_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM5_1_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM5_1_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM6_1: PMECC REM 6 Register (sec_num = 1)
	EBI_REM6_1_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM6_1_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM6_1_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM6_1_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM7_1: PMECC REM 7 Register (sec_num = 1)
	EBI_REM7_1_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM7_1_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM7_1_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM7_1_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM8_1: PMECC REM 8 Register (sec_num = 1)
	EBI_REM8_1_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM8_1_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM8_1_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM8_1_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM9_1: PMECC REM 9 Register (sec_num = 1)
	EBI_REM9_1_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM9_1_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM9_1_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM9_1_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM10_1: PMECC REM 10 Register (sec_num = 1)
	EBI_REM10_1_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM10_1_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM10_1_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM10_1_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM11_1: PMECC REM 11 Register (sec_num = 1)
	EBI_REM11_1_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM11_1_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM11_1_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM11_1_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM0_2: PMECC REM 0 Register (sec_num = 2)
	EBI_REM0_2_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM0_2_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM0_2_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM0_2_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM1_2: PMECC REM 1 Register (sec_num = 2)
	EBI_REM1_2_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM1_2_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM1_2_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM1_2_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM2_2: PMECC REM 2 Register (sec_num = 2)
	EBI_REM2_2_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM2_2_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM2_2_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM2_2_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM3_2: PMECC REM 3 Register (sec_num = 2)
	EBI_REM3_2_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM3_2_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM3_2_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM3_2_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM4_2: PMECC REM 4 Register (sec_num = 2)
	EBI_REM4_2_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM4_2_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM4_2_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM4_2_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM5_2: PMECC REM 5 Register (sec_num = 2)
	EBI_REM5_2_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM5_2_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM5_2_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM5_2_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM6_2: PMECC REM 6 Register (sec_num = 2)
	EBI_REM6_2_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM6_2_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM6_2_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM6_2_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM7_2: PMECC REM 7 Register (sec_num = 2)
	EBI_REM7_2_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM7_2_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM7_2_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM7_2_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM8_2: PMECC REM 8 Register (sec_num = 2)
	EBI_REM8_2_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM8_2_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM8_2_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM8_2_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM9_2: PMECC REM 9 Register (sec_num = 2)
	EBI_REM9_2_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM9_2_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM9_2_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM9_2_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM10_2: PMECC REM 10 Register (sec_num = 2)
	EBI_REM10_2_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM10_2_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM10_2_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM10_2_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM11_2: PMECC REM 11 Register (sec_num = 2)
	EBI_REM11_2_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM11_2_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM11_2_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM11_2_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM0_3: PMECC REM 0 Register (sec_num = 3)
	EBI_REM0_3_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM0_3_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM0_3_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM0_3_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM1_3: PMECC REM 1 Register (sec_num = 3)
	EBI_REM1_3_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM1_3_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM1_3_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM1_3_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM2_3: PMECC REM 2 Register (sec_num = 3)
	EBI_REM2_3_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM2_3_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM2_3_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM2_3_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM3_3: PMECC REM 3 Register (sec_num = 3)
	EBI_REM3_3_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM3_3_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM3_3_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM3_3_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM4_3: PMECC REM 4 Register (sec_num = 3)
	EBI_REM4_3_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM4_3_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM4_3_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM4_3_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM5_3: PMECC REM 5 Register (sec_num = 3)
	EBI_REM5_3_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM5_3_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM5_3_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM5_3_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM6_3: PMECC REM 6 Register (sec_num = 3)
	EBI_REM6_3_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM6_3_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM6_3_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM6_3_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM7_3: PMECC REM 7 Register (sec_num = 3)
	EBI_REM7_3_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM7_3_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM7_3_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM7_3_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM8_3: PMECC REM 8 Register (sec_num = 3)
	EBI_REM8_3_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM8_3_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM8_3_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM8_3_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM9_3: PMECC REM 9 Register (sec_num = 3)
	EBI_REM9_3_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM9_3_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM9_3_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM9_3_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM10_3: PMECC REM 10 Register (sec_num = 3)
	EBI_REM10_3_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM10_3_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM10_3_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM10_3_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM11_3: PMECC REM 11 Register (sec_num = 3)
	EBI_REM11_3_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM11_3_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM11_3_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM11_3_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM0_4: PMECC REM 0 Register (sec_num = 4)
	EBI_REM0_4_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM0_4_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM0_4_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM0_4_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM1_4: PMECC REM 1 Register (sec_num = 4)
	EBI_REM1_4_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM1_4_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM1_4_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM1_4_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM2_4: PMECC REM 2 Register (sec_num = 4)
	EBI_REM2_4_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM2_4_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM2_4_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM2_4_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM3_4: PMECC REM 3 Register (sec_num = 4)
	EBI_REM3_4_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM3_4_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM3_4_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM3_4_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM4_4: PMECC REM 4 Register (sec_num = 4)
	EBI_REM4_4_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM4_4_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM4_4_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM4_4_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM5_4: PMECC REM 5 Register (sec_num = 4)
	EBI_REM5_4_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM5_4_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM5_4_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM5_4_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM6_4: PMECC REM 6 Register (sec_num = 4)
	EBI_REM6_4_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM6_4_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM6_4_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM6_4_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM7_4: PMECC REM 7 Register (sec_num = 4)
	EBI_REM7_4_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM7_4_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM7_4_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM7_4_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM8_4: PMECC REM 8 Register (sec_num = 4)
	EBI_REM8_4_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM8_4_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM8_4_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM8_4_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM9_4: PMECC REM 9 Register (sec_num = 4)
	EBI_REM9_4_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM9_4_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM9_4_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM9_4_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM10_4: PMECC REM 10 Register (sec_num = 4)
	EBI_REM10_4_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM10_4_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM10_4_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM10_4_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM11_4: PMECC REM 11 Register (sec_num = 4)
	EBI_REM11_4_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM11_4_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM11_4_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM11_4_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM0_5: PMECC REM 0 Register (sec_num = 5)
	EBI_REM0_5_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM0_5_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM0_5_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM0_5_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM1_5: PMECC REM 1 Register (sec_num = 5)
	EBI_REM1_5_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM1_5_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM1_5_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM1_5_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM2_5: PMECC REM 2 Register (sec_num = 5)
	EBI_REM2_5_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM2_5_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM2_5_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM2_5_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM3_5: PMECC REM 3 Register (sec_num = 5)
	EBI_REM3_5_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM3_5_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM3_5_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM3_5_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM4_5: PMECC REM 4 Register (sec_num = 5)
	EBI_REM4_5_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM4_5_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM4_5_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM4_5_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM5_5: PMECC REM 5 Register (sec_num = 5)
	EBI_REM5_5_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM5_5_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM5_5_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM5_5_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM6_5: PMECC REM 6 Register (sec_num = 5)
	EBI_REM6_5_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM6_5_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM6_5_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM6_5_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM7_5: PMECC REM 7 Register (sec_num = 5)
	EBI_REM7_5_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM7_5_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM7_5_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM7_5_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM8_5: PMECC REM 8 Register (sec_num = 5)
	EBI_REM8_5_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM8_5_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM8_5_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM8_5_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM9_5: PMECC REM 9 Register (sec_num = 5)
	EBI_REM9_5_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM9_5_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM9_5_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM9_5_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM10_5: PMECC REM 10 Register (sec_num = 5)
	EBI_REM10_5_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM10_5_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM10_5_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM10_5_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM11_5: PMECC REM 11 Register (sec_num = 5)
	EBI_REM11_5_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM11_5_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM11_5_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM11_5_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM0_6: PMECC REM 0 Register (sec_num = 6)
	EBI_REM0_6_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM0_6_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM0_6_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM0_6_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM1_6: PMECC REM 1 Register (sec_num = 6)
	EBI_REM1_6_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM1_6_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM1_6_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM1_6_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM2_6: PMECC REM 2 Register (sec_num = 6)
	EBI_REM2_6_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM2_6_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM2_6_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM2_6_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM3_6: PMECC REM 3 Register (sec_num = 6)
	EBI_REM3_6_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM3_6_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM3_6_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM3_6_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM4_6: PMECC REM 4 Register (sec_num = 6)
	EBI_REM4_6_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM4_6_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM4_6_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM4_6_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM5_6: PMECC REM 5 Register (sec_num = 6)
	EBI_REM5_6_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM5_6_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM5_6_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM5_6_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM6_6: PMECC REM 6 Register (sec_num = 6)
	EBI_REM6_6_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM6_6_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM6_6_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM6_6_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM7_6: PMECC REM 7 Register (sec_num = 6)
	EBI_REM7_6_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM7_6_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM7_6_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM7_6_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM8_6: PMECC REM 8 Register (sec_num = 6)
	EBI_REM8_6_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM8_6_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM8_6_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM8_6_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM9_6: PMECC REM 9 Register (sec_num = 6)
	EBI_REM9_6_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM9_6_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM9_6_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM9_6_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM10_6: PMECC REM 10 Register (sec_num = 6)
	EBI_REM10_6_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM10_6_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM10_6_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM10_6_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM11_6: PMECC REM 11 Register (sec_num = 6)
	EBI_REM11_6_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM11_6_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM11_6_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM11_6_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM0_7: PMECC REM 0 Register (sec_num = 7)
	EBI_REM0_7_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM0_7_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM0_7_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM0_7_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM1_7: PMECC REM 1 Register (sec_num = 7)
	EBI_REM1_7_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM1_7_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM1_7_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM1_7_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM2_7: PMECC REM 2 Register (sec_num = 7)
	EBI_REM2_7_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM2_7_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM2_7_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM2_7_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM3_7: PMECC REM 3 Register (sec_num = 7)
	EBI_REM3_7_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM3_7_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM3_7_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM3_7_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM4_7: PMECC REM 4 Register (sec_num = 7)
	EBI_REM4_7_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM4_7_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM4_7_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM4_7_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM5_7: PMECC REM 5 Register (sec_num = 7)
	EBI_REM5_7_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM5_7_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM5_7_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM5_7_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM6_7: PMECC REM 6 Register (sec_num = 7)
	EBI_REM6_7_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM6_7_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM6_7_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM6_7_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM7_7: PMECC REM 7 Register (sec_num = 7)
	EBI_REM7_7_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM7_7_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM7_7_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM7_7_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM8_7: PMECC REM 8 Register (sec_num = 7)
	EBI_REM8_7_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM8_7_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM8_7_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM8_7_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM9_7: PMECC REM 9 Register (sec_num = 7)
	EBI_REM9_7_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM9_7_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM9_7_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM9_7_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM10_7: PMECC REM 10 Register (sec_num = 7)
	EBI_REM10_7_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM10_7_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM10_7_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM10_7_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.

	// REM11_7: PMECC REM 11 Register (sec_num = 7)
	EBI_REM11_7_REM2NP1_Pos = 0x0        // Position of REM2NP1 field.
	EBI_REM11_7_REM2NP1_Msk = 0x3fff     // Bit mask of REM2NP1 field.
	EBI_REM11_7_REM2NP3_Pos = 0x10       // Position of REM2NP3 field.
	EBI_REM11_7_REM2NP3_Msk = 0x3fff0000 // Bit mask of REM2NP3 field.
)

// Bitfields for DMAC0: DMA Controller 0
const (
	// GCFG: DMAC Global Configuration Register
	DMAC_GCFG_ARB_CFG_Pos         = 0x4  // Position of ARB_CFG field.
	DMAC_GCFG_ARB_CFG_Msk         = 0x10 // Bit mask of ARB_CFG field.
	DMAC_GCFG_ARB_CFG             = 0x10 // Bit ARB_CFG.
	DMAC_GCFG_ARB_CFG_FIXED       = 0x0  // Fixed priority arbiter.
	DMAC_GCFG_ARB_CFG_ROUND_ROBIN = 0x1  // Modified round robin arbiter.

	// EN: DMAC Enable Register
	DMAC_EN_ENABLE_Pos = 0x0 // Position of ENABLE field.
	DMAC_EN_ENABLE_Msk = 0x1 // Bit mask of ENABLE field.
	DMAC_EN_ENABLE     = 0x1 // Bit ENABLE.

	// SREQ: DMAC Software Single Request Register
	DMAC_SREQ_SSREQ0_Pos = 0x0    // Position of SSREQ0 field.
	DMAC_SREQ_SSREQ0_Msk = 0x1    // Bit mask of SSREQ0 field.
	DMAC_SREQ_SSREQ0     = 0x1    // Bit SSREQ0.
	DMAC_SREQ_DSREQ0_Pos = 0x1    // Position of DSREQ0 field.
	DMAC_SREQ_DSREQ0_Msk = 0x2    // Bit mask of DSREQ0 field.
	DMAC_SREQ_DSREQ0     = 0x2    // Bit DSREQ0.
	DMAC_SREQ_SSREQ1_Pos = 0x2    // Position of SSREQ1 field.
	DMAC_SREQ_SSREQ1_Msk = 0x4    // Bit mask of SSREQ1 field.
	DMAC_SREQ_SSREQ1     = 0x4    // Bit SSREQ1.
	DMAC_SREQ_DSREQ1_Pos = 0x3    // Position of DSREQ1 field.
	DMAC_SREQ_DSREQ1_Msk = 0x8    // Bit mask of DSREQ1 field.
	DMAC_SREQ_DSREQ1     = 0x8    // Bit DSREQ1.
	DMAC_SREQ_SSREQ2_Pos = 0x4    // Position of SSREQ2 field.
	DMAC_SREQ_SSREQ2_Msk = 0x10   // Bit mask of SSREQ2 field.
	DMAC_SREQ_SSREQ2     = 0x10   // Bit SSREQ2.
	DMAC_SREQ_DSREQ2_Pos = 0x5    // Position of DSREQ2 field.
	DMAC_SREQ_DSREQ2_Msk = 0x20   // Bit mask of DSREQ2 field.
	DMAC_SREQ_DSREQ2     = 0x20   // Bit DSREQ2.
	DMAC_SREQ_SSREQ3_Pos = 0x6    // Position of SSREQ3 field.
	DMAC_SREQ_SSREQ3_Msk = 0x40   // Bit mask of SSREQ3 field.
	DMAC_SREQ_SSREQ3     = 0x40   // Bit SSREQ3.
	DMAC_SREQ_DSREQ3_Pos = 0x7    // Position of DSREQ3 field.
	DMAC_SREQ_DSREQ3_Msk = 0x80   // Bit mask of DSREQ3 field.
	DMAC_SREQ_DSREQ3     = 0x80   // Bit DSREQ3.
	DMAC_SREQ_SSREQ4_Pos = 0x8    // Position of SSREQ4 field.
	DMAC_SREQ_SSREQ4_Msk = 0x100  // Bit mask of SSREQ4 field.
	DMAC_SREQ_SSREQ4     = 0x100  // Bit SSREQ4.
	DMAC_SREQ_DSREQ4_Pos = 0x9    // Position of DSREQ4 field.
	DMAC_SREQ_DSREQ4_Msk = 0x200  // Bit mask of DSREQ4 field.
	DMAC_SREQ_DSREQ4     = 0x200  // Bit DSREQ4.
	DMAC_SREQ_SSREQ5_Pos = 0xa    // Position of SSREQ5 field.
	DMAC_SREQ_SSREQ5_Msk = 0x400  // Bit mask of SSREQ5 field.
	DMAC_SREQ_SSREQ5     = 0x400  // Bit SSREQ5.
	DMAC_SREQ_DSREQ5_Pos = 0xb    // Position of DSREQ5 field.
	DMAC_SREQ_DSREQ5_Msk = 0x800  // Bit mask of DSREQ5 field.
	DMAC_SREQ_DSREQ5     = 0x800  // Bit DSREQ5.
	DMAC_SREQ_SSREQ6_Pos = 0xc    // Position of SSREQ6 field.
	DMAC_SREQ_SSREQ6_Msk = 0x1000 // Bit mask of SSREQ6 field.
	DMAC_SREQ_SSREQ6     = 0x1000 // Bit SSREQ6.
	DMAC_SREQ_DSREQ6_Pos = 0xd    // Position of DSREQ6 field.
	DMAC_SREQ_DSREQ6_Msk = 0x2000 // Bit mask of DSREQ6 field.
	DMAC_SREQ_DSREQ6     = 0x2000 // Bit DSREQ6.
	DMAC_SREQ_SSREQ7_Pos = 0xe    // Position of SSREQ7 field.
	DMAC_SREQ_SSREQ7_Msk = 0x4000 // Bit mask of SSREQ7 field.
	DMAC_SREQ_SSREQ7     = 0x4000 // Bit SSREQ7.
	DMAC_SREQ_DSREQ7_Pos = 0xf    // Position of DSREQ7 field.
	DMAC_SREQ_DSREQ7_Msk = 0x8000 // Bit mask of DSREQ7 field.
	DMAC_SREQ_DSREQ7     = 0x8000 // Bit DSREQ7.

	// CREQ: DMAC Software Chunk Transfer Request Register
	DMAC_CREQ_SCREQ0_Pos = 0x0    // Position of SCREQ0 field.
	DMAC_CREQ_SCREQ0_Msk = 0x1    // Bit mask of SCREQ0 field.
	DMAC_CREQ_SCREQ0     = 0x1    // Bit SCREQ0.
	DMAC_CREQ_DCREQ0_Pos = 0x1    // Position of DCREQ0 field.
	DMAC_CREQ_DCREQ0_Msk = 0x2    // Bit mask of DCREQ0 field.
	DMAC_CREQ_DCREQ0     = 0x2    // Bit DCREQ0.
	DMAC_CREQ_SCREQ1_Pos = 0x2    // Position of SCREQ1 field.
	DMAC_CREQ_SCREQ1_Msk = 0x4    // Bit mask of SCREQ1 field.
	DMAC_CREQ_SCREQ1     = 0x4    // Bit SCREQ1.
	DMAC_CREQ_DCREQ1_Pos = 0x3    // Position of DCREQ1 field.
	DMAC_CREQ_DCREQ1_Msk = 0x8    // Bit mask of DCREQ1 field.
	DMAC_CREQ_DCREQ1     = 0x8    // Bit DCREQ1.
	DMAC_CREQ_SCREQ2_Pos = 0x4    // Position of SCREQ2 field.
	DMAC_CREQ_SCREQ2_Msk = 0x10   // Bit mask of SCREQ2 field.
	DMAC_CREQ_SCREQ2     = 0x10   // Bit SCREQ2.
	DMAC_CREQ_DCREQ2_Pos = 0x5    // Position of DCREQ2 field.
	DMAC_CREQ_DCREQ2_Msk = 0x20   // Bit mask of DCREQ2 field.
	DMAC_CREQ_DCREQ2     = 0x20   // Bit DCREQ2.
	DMAC_CREQ_SCREQ3_Pos = 0x6    // Position of SCREQ3 field.
	DMAC_CREQ_SCREQ3_Msk = 0x40   // Bit mask of SCREQ3 field.
	DMAC_CREQ_SCREQ3     = 0x40   // Bit SCREQ3.
	DMAC_CREQ_DCREQ3_Pos = 0x7    // Position of DCREQ3 field.
	DMAC_CREQ_DCREQ3_Msk = 0x80   // Bit mask of DCREQ3 field.
	DMAC_CREQ_DCREQ3     = 0x80   // Bit DCREQ3.
	DMAC_CREQ_SCREQ4_Pos = 0x8    // Position of SCREQ4 field.
	DMAC_CREQ_SCREQ4_Msk = 0x100  // Bit mask of SCREQ4 field.
	DMAC_CREQ_SCREQ4     = 0x100  // Bit SCREQ4.
	DMAC_CREQ_DCREQ4_Pos = 0x9    // Position of DCREQ4 field.
	DMAC_CREQ_DCREQ4_Msk = 0x200  // Bit mask of DCREQ4 field.
	DMAC_CREQ_DCREQ4     = 0x200  // Bit DCREQ4.
	DMAC_CREQ_SCREQ5_Pos = 0xa    // Position of SCREQ5 field.
	DMAC_CREQ_SCREQ5_Msk = 0x400  // Bit mask of SCREQ5 field.
	DMAC_CREQ_SCREQ5     = 0x400  // Bit SCREQ5.
	DMAC_CREQ_DCREQ5_Pos = 0xb    // Position of DCREQ5 field.
	DMAC_CREQ_DCREQ5_Msk = 0x800  // Bit mask of DCREQ5 field.
	DMAC_CREQ_DCREQ5     = 0x800  // Bit DCREQ5.
	DMAC_CREQ_SCREQ6_Pos = 0xc    // Position of SCREQ6 field.
	DMAC_CREQ_SCREQ6_Msk = 0x1000 // Bit mask of SCREQ6 field.
	DMAC_CREQ_SCREQ6     = 0x1000 // Bit SCREQ6.
	DMAC_CREQ_DCREQ6_Pos = 0xd    // Position of DCREQ6 field.
	DMAC_CREQ_DCREQ6_Msk = 0x2000 // Bit mask of DCREQ6 field.
	DMAC_CREQ_DCREQ6     = 0x2000 // Bit DCREQ6.
	DMAC_CREQ_SCREQ7_Pos = 0xe    // Position of SCREQ7 field.
	DMAC_CREQ_SCREQ7_Msk = 0x4000 // Bit mask of SCREQ7 field.
	DMAC_CREQ_SCREQ7     = 0x4000 // Bit SCREQ7.
	DMAC_CREQ_DCREQ7_Pos = 0xf    // Position of DCREQ7 field.
	DMAC_CREQ_DCREQ7_Msk = 0x8000 // Bit mask of DCREQ7 field.
	DMAC_CREQ_DCREQ7     = 0x8000 // Bit DCREQ7.

	// LAST: DMAC Software Last Transfer Flag Register
	DMAC_LAST_SLAST0_Pos = 0x0    // Position of SLAST0 field.
	DMAC_LAST_SLAST0_Msk = 0x1    // Bit mask of SLAST0 field.
	DMAC_LAST_SLAST0     = 0x1    // Bit SLAST0.
	DMAC_LAST_DLAST0_Pos = 0x1    // Position of DLAST0 field.
	DMAC_LAST_DLAST0_Msk = 0x2    // Bit mask of DLAST0 field.
	DMAC_LAST_DLAST0     = 0x2    // Bit DLAST0.
	DMAC_LAST_SLAST1_Pos = 0x2    // Position of SLAST1 field.
	DMAC_LAST_SLAST1_Msk = 0x4    // Bit mask of SLAST1 field.
	DMAC_LAST_SLAST1     = 0x4    // Bit SLAST1.
	DMAC_LAST_DLAST1_Pos = 0x3    // Position of DLAST1 field.
	DMAC_LAST_DLAST1_Msk = 0x8    // Bit mask of DLAST1 field.
	DMAC_LAST_DLAST1     = 0x8    // Bit DLAST1.
	DMAC_LAST_SLAST2_Pos = 0x4    // Position of SLAST2 field.
	DMAC_LAST_SLAST2_Msk = 0x10   // Bit mask of SLAST2 field.
	DMAC_LAST_SLAST2     = 0x10   // Bit SLAST2.
	DMAC_LAST_DLAST2_Pos = 0x5    // Position of DLAST2 field.
	DMAC_LAST_DLAST2_Msk = 0x20   // Bit mask of DLAST2 field.
	DMAC_LAST_DLAST2     = 0x20   // Bit DLAST2.
	DMAC_LAST_SLAST3_Pos = 0x6    // Position of SLAST3 field.
	DMAC_LAST_SLAST3_Msk = 0x40   // Bit mask of SLAST3 field.
	DMAC_LAST_SLAST3     = 0x40   // Bit SLAST3.
	DMAC_LAST_DLAST3_Pos = 0x7    // Position of DLAST3 field.
	DMAC_LAST_DLAST3_Msk = 0x80   // Bit mask of DLAST3 field.
	DMAC_LAST_DLAST3     = 0x80   // Bit DLAST3.
	DMAC_LAST_SLAST4_Pos = 0x8    // Position of SLAST4 field.
	DMAC_LAST_SLAST4_Msk = 0x100  // Bit mask of SLAST4 field.
	DMAC_LAST_SLAST4     = 0x100  // Bit SLAST4.
	DMAC_LAST_DLAST4_Pos = 0x9    // Position of DLAST4 field.
	DMAC_LAST_DLAST4_Msk = 0x200  // Bit mask of DLAST4 field.
	DMAC_LAST_DLAST4     = 0x200  // Bit DLAST4.
	DMAC_LAST_SLAST5_Pos = 0xa    // Position of SLAST5 field.
	DMAC_LAST_SLAST5_Msk = 0x400  // Bit mask of SLAST5 field.
	DMAC_LAST_SLAST5     = 0x400  // Bit SLAST5.
	DMAC_LAST_DLAST5_Pos = 0xb    // Position of DLAST5 field.
	DMAC_LAST_DLAST5_Msk = 0x800  // Bit mask of DLAST5 field.
	DMAC_LAST_DLAST5     = 0x800  // Bit DLAST5.
	DMAC_LAST_SLAST6_Pos = 0xc    // Position of SLAST6 field.
	DMAC_LAST_SLAST6_Msk = 0x1000 // Bit mask of SLAST6 field.
	DMAC_LAST_SLAST6     = 0x1000 // Bit SLAST6.
	DMAC_LAST_DLAST6_Pos = 0xd    // Position of DLAST6 field.
	DMAC_LAST_DLAST6_Msk = 0x2000 // Bit mask of DLAST6 field.
	DMAC_LAST_DLAST6     = 0x2000 // Bit DLAST6.
	DMAC_LAST_SLAST7_Pos = 0xe    // Position of SLAST7 field.
	DMAC_LAST_SLAST7_Msk = 0x4000 // Bit mask of SLAST7 field.
	DMAC_LAST_SLAST7     = 0x4000 // Bit SLAST7.
	DMAC_LAST_DLAST7_Pos = 0xf    // Position of DLAST7 field.
	DMAC_LAST_DLAST7_Msk = 0x8000 // Bit mask of DLAST7 field.
	DMAC_LAST_DLAST7     = 0x8000 // Bit DLAST7.

	// EBCIER: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Enable register.
	DMAC_EBCIER_BTC0_Pos  = 0x0      // Position of BTC0 field.
	DMAC_EBCIER_BTC0_Msk  = 0x1      // Bit mask of BTC0 field.
	DMAC_EBCIER_BTC0      = 0x1      // Bit BTC0.
	DMAC_EBCIER_BTC1_Pos  = 0x1      // Position of BTC1 field.
	DMAC_EBCIER_BTC1_Msk  = 0x2      // Bit mask of BTC1 field.
	DMAC_EBCIER_BTC1      = 0x2      // Bit BTC1.
	DMAC_EBCIER_BTC2_Pos  = 0x2      // Position of BTC2 field.
	DMAC_EBCIER_BTC2_Msk  = 0x4      // Bit mask of BTC2 field.
	DMAC_EBCIER_BTC2      = 0x4      // Bit BTC2.
	DMAC_EBCIER_BTC3_Pos  = 0x3      // Position of BTC3 field.
	DMAC_EBCIER_BTC3_Msk  = 0x8      // Bit mask of BTC3 field.
	DMAC_EBCIER_BTC3      = 0x8      // Bit BTC3.
	DMAC_EBCIER_BTC4_Pos  = 0x4      // Position of BTC4 field.
	DMAC_EBCIER_BTC4_Msk  = 0x10     // Bit mask of BTC4 field.
	DMAC_EBCIER_BTC4      = 0x10     // Bit BTC4.
	DMAC_EBCIER_BTC5_Pos  = 0x5      // Position of BTC5 field.
	DMAC_EBCIER_BTC5_Msk  = 0x20     // Bit mask of BTC5 field.
	DMAC_EBCIER_BTC5      = 0x20     // Bit BTC5.
	DMAC_EBCIER_BTC6_Pos  = 0x6      // Position of BTC6 field.
	DMAC_EBCIER_BTC6_Msk  = 0x40     // Bit mask of BTC6 field.
	DMAC_EBCIER_BTC6      = 0x40     // Bit BTC6.
	DMAC_EBCIER_BTC7_Pos  = 0x7      // Position of BTC7 field.
	DMAC_EBCIER_BTC7_Msk  = 0x80     // Bit mask of BTC7 field.
	DMAC_EBCIER_BTC7      = 0x80     // Bit BTC7.
	DMAC_EBCIER_CBTC0_Pos = 0x8      // Position of CBTC0 field.
	DMAC_EBCIER_CBTC0_Msk = 0x100    // Bit mask of CBTC0 field.
	DMAC_EBCIER_CBTC0     = 0x100    // Bit CBTC0.
	DMAC_EBCIER_CBTC1_Pos = 0x9      // Position of CBTC1 field.
	DMAC_EBCIER_CBTC1_Msk = 0x200    // Bit mask of CBTC1 field.
	DMAC_EBCIER_CBTC1     = 0x200    // Bit CBTC1.
	DMAC_EBCIER_CBTC2_Pos = 0xa      // Position of CBTC2 field.
	DMAC_EBCIER_CBTC2_Msk = 0x400    // Bit mask of CBTC2 field.
	DMAC_EBCIER_CBTC2     = 0x400    // Bit CBTC2.
	DMAC_EBCIER_CBTC3_Pos = 0xb      // Position of CBTC3 field.
	DMAC_EBCIER_CBTC3_Msk = 0x800    // Bit mask of CBTC3 field.
	DMAC_EBCIER_CBTC3     = 0x800    // Bit CBTC3.
	DMAC_EBCIER_CBTC4_Pos = 0xc      // Position of CBTC4 field.
	DMAC_EBCIER_CBTC4_Msk = 0x1000   // Bit mask of CBTC4 field.
	DMAC_EBCIER_CBTC4     = 0x1000   // Bit CBTC4.
	DMAC_EBCIER_CBTC5_Pos = 0xd      // Position of CBTC5 field.
	DMAC_EBCIER_CBTC5_Msk = 0x2000   // Bit mask of CBTC5 field.
	DMAC_EBCIER_CBTC5     = 0x2000   // Bit CBTC5.
	DMAC_EBCIER_CBTC6_Pos = 0xe      // Position of CBTC6 field.
	DMAC_EBCIER_CBTC6_Msk = 0x4000   // Bit mask of CBTC6 field.
	DMAC_EBCIER_CBTC6     = 0x4000   // Bit CBTC6.
	DMAC_EBCIER_CBTC7_Pos = 0xf      // Position of CBTC7 field.
	DMAC_EBCIER_CBTC7_Msk = 0x8000   // Bit mask of CBTC7 field.
	DMAC_EBCIER_CBTC7     = 0x8000   // Bit CBTC7.
	DMAC_EBCIER_ERR0_Pos  = 0x10     // Position of ERR0 field.
	DMAC_EBCIER_ERR0_Msk  = 0x10000  // Bit mask of ERR0 field.
	DMAC_EBCIER_ERR0      = 0x10000  // Bit ERR0.
	DMAC_EBCIER_ERR1_Pos  = 0x11     // Position of ERR1 field.
	DMAC_EBCIER_ERR1_Msk  = 0x20000  // Bit mask of ERR1 field.
	DMAC_EBCIER_ERR1      = 0x20000  // Bit ERR1.
	DMAC_EBCIER_ERR2_Pos  = 0x12     // Position of ERR2 field.
	DMAC_EBCIER_ERR2_Msk  = 0x40000  // Bit mask of ERR2 field.
	DMAC_EBCIER_ERR2      = 0x40000  // Bit ERR2.
	DMAC_EBCIER_ERR3_Pos  = 0x13     // Position of ERR3 field.
	DMAC_EBCIER_ERR3_Msk  = 0x80000  // Bit mask of ERR3 field.
	DMAC_EBCIER_ERR3      = 0x80000  // Bit ERR3.
	DMAC_EBCIER_ERR4_Pos  = 0x14     // Position of ERR4 field.
	DMAC_EBCIER_ERR4_Msk  = 0x100000 // Bit mask of ERR4 field.
	DMAC_EBCIER_ERR4      = 0x100000 // Bit ERR4.
	DMAC_EBCIER_ERR5_Pos  = 0x15     // Position of ERR5 field.
	DMAC_EBCIER_ERR5_Msk  = 0x200000 // Bit mask of ERR5 field.
	DMAC_EBCIER_ERR5      = 0x200000 // Bit ERR5.
	DMAC_EBCIER_ERR6_Pos  = 0x16     // Position of ERR6 field.
	DMAC_EBCIER_ERR6_Msk  = 0x400000 // Bit mask of ERR6 field.
	DMAC_EBCIER_ERR6      = 0x400000 // Bit ERR6.
	DMAC_EBCIER_ERR7_Pos  = 0x17     // Position of ERR7 field.
	DMAC_EBCIER_ERR7_Msk  = 0x800000 // Bit mask of ERR7 field.
	DMAC_EBCIER_ERR7      = 0x800000 // Bit ERR7.

	// EBCIDR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Disable register.
	DMAC_EBCIDR_BTC0_Pos  = 0x0      // Position of BTC0 field.
	DMAC_EBCIDR_BTC0_Msk  = 0x1      // Bit mask of BTC0 field.
	DMAC_EBCIDR_BTC0      = 0x1      // Bit BTC0.
	DMAC_EBCIDR_BTC1_Pos  = 0x1      // Position of BTC1 field.
	DMAC_EBCIDR_BTC1_Msk  = 0x2      // Bit mask of BTC1 field.
	DMAC_EBCIDR_BTC1      = 0x2      // Bit BTC1.
	DMAC_EBCIDR_BTC2_Pos  = 0x2      // Position of BTC2 field.
	DMAC_EBCIDR_BTC2_Msk  = 0x4      // Bit mask of BTC2 field.
	DMAC_EBCIDR_BTC2      = 0x4      // Bit BTC2.
	DMAC_EBCIDR_BTC3_Pos  = 0x3      // Position of BTC3 field.
	DMAC_EBCIDR_BTC3_Msk  = 0x8      // Bit mask of BTC3 field.
	DMAC_EBCIDR_BTC3      = 0x8      // Bit BTC3.
	DMAC_EBCIDR_BTC4_Pos  = 0x4      // Position of BTC4 field.
	DMAC_EBCIDR_BTC4_Msk  = 0x10     // Bit mask of BTC4 field.
	DMAC_EBCIDR_BTC4      = 0x10     // Bit BTC4.
	DMAC_EBCIDR_BTC5_Pos  = 0x5      // Position of BTC5 field.
	DMAC_EBCIDR_BTC5_Msk  = 0x20     // Bit mask of BTC5 field.
	DMAC_EBCIDR_BTC5      = 0x20     // Bit BTC5.
	DMAC_EBCIDR_BTC6_Pos  = 0x6      // Position of BTC6 field.
	DMAC_EBCIDR_BTC6_Msk  = 0x40     // Bit mask of BTC6 field.
	DMAC_EBCIDR_BTC6      = 0x40     // Bit BTC6.
	DMAC_EBCIDR_BTC7_Pos  = 0x7      // Position of BTC7 field.
	DMAC_EBCIDR_BTC7_Msk  = 0x80     // Bit mask of BTC7 field.
	DMAC_EBCIDR_BTC7      = 0x80     // Bit BTC7.
	DMAC_EBCIDR_CBTC0_Pos = 0x8      // Position of CBTC0 field.
	DMAC_EBCIDR_CBTC0_Msk = 0x100    // Bit mask of CBTC0 field.
	DMAC_EBCIDR_CBTC0     = 0x100    // Bit CBTC0.
	DMAC_EBCIDR_CBTC1_Pos = 0x9      // Position of CBTC1 field.
	DMAC_EBCIDR_CBTC1_Msk = 0x200    // Bit mask of CBTC1 field.
	DMAC_EBCIDR_CBTC1     = 0x200    // Bit CBTC1.
	DMAC_EBCIDR_CBTC2_Pos = 0xa      // Position of CBTC2 field.
	DMAC_EBCIDR_CBTC2_Msk = 0x400    // Bit mask of CBTC2 field.
	DMAC_EBCIDR_CBTC2     = 0x400    // Bit CBTC2.
	DMAC_EBCIDR_CBTC3_Pos = 0xb      // Position of CBTC3 field.
	DMAC_EBCIDR_CBTC3_Msk = 0x800    // Bit mask of CBTC3 field.
	DMAC_EBCIDR_CBTC3     = 0x800    // Bit CBTC3.
	DMAC_EBCIDR_CBTC4_Pos = 0xc      // Position of CBTC4 field.
	DMAC_EBCIDR_CBTC4_Msk = 0x1000   // Bit mask of CBTC4 field.
	DMAC_EBCIDR_CBTC4     = 0x1000   // Bit CBTC4.
	DMAC_EBCIDR_CBTC5_Pos = 0xd      // Position of CBTC5 field.
	DMAC_EBCIDR_CBTC5_Msk = 0x2000   // Bit mask of CBTC5 field.
	DMAC_EBCIDR_CBTC5     = 0x2000   // Bit CBTC5.
	DMAC_EBCIDR_CBTC6_Pos = 0xe      // Position of CBTC6 field.
	DMAC_EBCIDR_CBTC6_Msk = 0x4000   // Bit mask of CBTC6 field.
	DMAC_EBCIDR_CBTC6     = 0x4000   // Bit CBTC6.
	DMAC_EBCIDR_CBTC7_Pos = 0xf      // Position of CBTC7 field.
	DMAC_EBCIDR_CBTC7_Msk = 0x8000   // Bit mask of CBTC7 field.
	DMAC_EBCIDR_CBTC7     = 0x8000   // Bit CBTC7.
	DMAC_EBCIDR_ERR0_Pos  = 0x10     // Position of ERR0 field.
	DMAC_EBCIDR_ERR0_Msk  = 0x10000  // Bit mask of ERR0 field.
	DMAC_EBCIDR_ERR0      = 0x10000  // Bit ERR0.
	DMAC_EBCIDR_ERR1_Pos  = 0x11     // Position of ERR1 field.
	DMAC_EBCIDR_ERR1_Msk  = 0x20000  // Bit mask of ERR1 field.
	DMAC_EBCIDR_ERR1      = 0x20000  // Bit ERR1.
	DMAC_EBCIDR_ERR2_Pos  = 0x12     // Position of ERR2 field.
	DMAC_EBCIDR_ERR2_Msk  = 0x40000  // Bit mask of ERR2 field.
	DMAC_EBCIDR_ERR2      = 0x40000  // Bit ERR2.
	DMAC_EBCIDR_ERR3_Pos  = 0x13     // Position of ERR3 field.
	DMAC_EBCIDR_ERR3_Msk  = 0x80000  // Bit mask of ERR3 field.
	DMAC_EBCIDR_ERR3      = 0x80000  // Bit ERR3.
	DMAC_EBCIDR_ERR4_Pos  = 0x14     // Position of ERR4 field.
	DMAC_EBCIDR_ERR4_Msk  = 0x100000 // Bit mask of ERR4 field.
	DMAC_EBCIDR_ERR4      = 0x100000 // Bit ERR4.
	DMAC_EBCIDR_ERR5_Pos  = 0x15     // Position of ERR5 field.
	DMAC_EBCIDR_ERR5_Msk  = 0x200000 // Bit mask of ERR5 field.
	DMAC_EBCIDR_ERR5      = 0x200000 // Bit ERR5.
	DMAC_EBCIDR_ERR6_Pos  = 0x16     // Position of ERR6 field.
	DMAC_EBCIDR_ERR6_Msk  = 0x400000 // Bit mask of ERR6 field.
	DMAC_EBCIDR_ERR6      = 0x400000 // Bit ERR6.
	DMAC_EBCIDR_ERR7_Pos  = 0x17     // Position of ERR7 field.
	DMAC_EBCIDR_ERR7_Msk  = 0x800000 // Bit mask of ERR7 field.
	DMAC_EBCIDR_ERR7      = 0x800000 // Bit ERR7.

	// EBCIMR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Mask Register.
	DMAC_EBCIMR_BTC0_Pos  = 0x0      // Position of BTC0 field.
	DMAC_EBCIMR_BTC0_Msk  = 0x1      // Bit mask of BTC0 field.
	DMAC_EBCIMR_BTC0      = 0x1      // Bit BTC0.
	DMAC_EBCIMR_BTC1_Pos  = 0x1      // Position of BTC1 field.
	DMAC_EBCIMR_BTC1_Msk  = 0x2      // Bit mask of BTC1 field.
	DMAC_EBCIMR_BTC1      = 0x2      // Bit BTC1.
	DMAC_EBCIMR_BTC2_Pos  = 0x2      // Position of BTC2 field.
	DMAC_EBCIMR_BTC2_Msk  = 0x4      // Bit mask of BTC2 field.
	DMAC_EBCIMR_BTC2      = 0x4      // Bit BTC2.
	DMAC_EBCIMR_BTC3_Pos  = 0x3      // Position of BTC3 field.
	DMAC_EBCIMR_BTC3_Msk  = 0x8      // Bit mask of BTC3 field.
	DMAC_EBCIMR_BTC3      = 0x8      // Bit BTC3.
	DMAC_EBCIMR_BTC4_Pos  = 0x4      // Position of BTC4 field.
	DMAC_EBCIMR_BTC4_Msk  = 0x10     // Bit mask of BTC4 field.
	DMAC_EBCIMR_BTC4      = 0x10     // Bit BTC4.
	DMAC_EBCIMR_BTC5_Pos  = 0x5      // Position of BTC5 field.
	DMAC_EBCIMR_BTC5_Msk  = 0x20     // Bit mask of BTC5 field.
	DMAC_EBCIMR_BTC5      = 0x20     // Bit BTC5.
	DMAC_EBCIMR_BTC6_Pos  = 0x6      // Position of BTC6 field.
	DMAC_EBCIMR_BTC6_Msk  = 0x40     // Bit mask of BTC6 field.
	DMAC_EBCIMR_BTC6      = 0x40     // Bit BTC6.
	DMAC_EBCIMR_BTC7_Pos  = 0x7      // Position of BTC7 field.
	DMAC_EBCIMR_BTC7_Msk  = 0x80     // Bit mask of BTC7 field.
	DMAC_EBCIMR_BTC7      = 0x80     // Bit BTC7.
	DMAC_EBCIMR_CBTC0_Pos = 0x8      // Position of CBTC0 field.
	DMAC_EBCIMR_CBTC0_Msk = 0x100    // Bit mask of CBTC0 field.
	DMAC_EBCIMR_CBTC0     = 0x100    // Bit CBTC0.
	DMAC_EBCIMR_CBTC1_Pos = 0x9      // Position of CBTC1 field.
	DMAC_EBCIMR_CBTC1_Msk = 0x200    // Bit mask of CBTC1 field.
	DMAC_EBCIMR_CBTC1     = 0x200    // Bit CBTC1.
	DMAC_EBCIMR_CBTC2_Pos = 0xa      // Position of CBTC2 field.
	DMAC_EBCIMR_CBTC2_Msk = 0x400    // Bit mask of CBTC2 field.
	DMAC_EBCIMR_CBTC2     = 0x400    // Bit CBTC2.
	DMAC_EBCIMR_CBTC3_Pos = 0xb      // Position of CBTC3 field.
	DMAC_EBCIMR_CBTC3_Msk = 0x800    // Bit mask of CBTC3 field.
	DMAC_EBCIMR_CBTC3     = 0x800    // Bit CBTC3.
	DMAC_EBCIMR_CBTC4_Pos = 0xc      // Position of CBTC4 field.
	DMAC_EBCIMR_CBTC4_Msk = 0x1000   // Bit mask of CBTC4 field.
	DMAC_EBCIMR_CBTC4     = 0x1000   // Bit CBTC4.
	DMAC_EBCIMR_CBTC5_Pos = 0xd      // Position of CBTC5 field.
	DMAC_EBCIMR_CBTC5_Msk = 0x2000   // Bit mask of CBTC5 field.
	DMAC_EBCIMR_CBTC5     = 0x2000   // Bit CBTC5.
	DMAC_EBCIMR_CBTC6_Pos = 0xe      // Position of CBTC6 field.
	DMAC_EBCIMR_CBTC6_Msk = 0x4000   // Bit mask of CBTC6 field.
	DMAC_EBCIMR_CBTC6     = 0x4000   // Bit CBTC6.
	DMAC_EBCIMR_CBTC7_Pos = 0xf      // Position of CBTC7 field.
	DMAC_EBCIMR_CBTC7_Msk = 0x8000   // Bit mask of CBTC7 field.
	DMAC_EBCIMR_CBTC7     = 0x8000   // Bit CBTC7.
	DMAC_EBCIMR_ERR0_Pos  = 0x10     // Position of ERR0 field.
	DMAC_EBCIMR_ERR0_Msk  = 0x10000  // Bit mask of ERR0 field.
	DMAC_EBCIMR_ERR0      = 0x10000  // Bit ERR0.
	DMAC_EBCIMR_ERR1_Pos  = 0x11     // Position of ERR1 field.
	DMAC_EBCIMR_ERR1_Msk  = 0x20000  // Bit mask of ERR1 field.
	DMAC_EBCIMR_ERR1      = 0x20000  // Bit ERR1.
	DMAC_EBCIMR_ERR2_Pos  = 0x12     // Position of ERR2 field.
	DMAC_EBCIMR_ERR2_Msk  = 0x40000  // Bit mask of ERR2 field.
	DMAC_EBCIMR_ERR2      = 0x40000  // Bit ERR2.
	DMAC_EBCIMR_ERR3_Pos  = 0x13     // Position of ERR3 field.
	DMAC_EBCIMR_ERR3_Msk  = 0x80000  // Bit mask of ERR3 field.
	DMAC_EBCIMR_ERR3      = 0x80000  // Bit ERR3.
	DMAC_EBCIMR_ERR4_Pos  = 0x14     // Position of ERR4 field.
	DMAC_EBCIMR_ERR4_Msk  = 0x100000 // Bit mask of ERR4 field.
	DMAC_EBCIMR_ERR4      = 0x100000 // Bit ERR4.
	DMAC_EBCIMR_ERR5_Pos  = 0x15     // Position of ERR5 field.
	DMAC_EBCIMR_ERR5_Msk  = 0x200000 // Bit mask of ERR5 field.
	DMAC_EBCIMR_ERR5      = 0x200000 // Bit ERR5.
	DMAC_EBCIMR_ERR6_Pos  = 0x16     // Position of ERR6 field.
	DMAC_EBCIMR_ERR6_Msk  = 0x400000 // Bit mask of ERR6 field.
	DMAC_EBCIMR_ERR6      = 0x400000 // Bit ERR6.
	DMAC_EBCIMR_ERR7_Pos  = 0x17     // Position of ERR7 field.
	DMAC_EBCIMR_ERR7_Msk  = 0x800000 // Bit mask of ERR7 field.
	DMAC_EBCIMR_ERR7      = 0x800000 // Bit ERR7.

	// EBCISR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Status Register.
	DMAC_EBCISR_BTC0_Pos  = 0x0      // Position of BTC0 field.
	DMAC_EBCISR_BTC0_Msk  = 0x1      // Bit mask of BTC0 field.
	DMAC_EBCISR_BTC0      = 0x1      // Bit BTC0.
	DMAC_EBCISR_BTC1_Pos  = 0x1      // Position of BTC1 field.
	DMAC_EBCISR_BTC1_Msk  = 0x2      // Bit mask of BTC1 field.
	DMAC_EBCISR_BTC1      = 0x2      // Bit BTC1.
	DMAC_EBCISR_BTC2_Pos  = 0x2      // Position of BTC2 field.
	DMAC_EBCISR_BTC2_Msk  = 0x4      // Bit mask of BTC2 field.
	DMAC_EBCISR_BTC2      = 0x4      // Bit BTC2.
	DMAC_EBCISR_BTC3_Pos  = 0x3      // Position of BTC3 field.
	DMAC_EBCISR_BTC3_Msk  = 0x8      // Bit mask of BTC3 field.
	DMAC_EBCISR_BTC3      = 0x8      // Bit BTC3.
	DMAC_EBCISR_BTC4_Pos  = 0x4      // Position of BTC4 field.
	DMAC_EBCISR_BTC4_Msk  = 0x10     // Bit mask of BTC4 field.
	DMAC_EBCISR_BTC4      = 0x10     // Bit BTC4.
	DMAC_EBCISR_BTC5_Pos  = 0x5      // Position of BTC5 field.
	DMAC_EBCISR_BTC5_Msk  = 0x20     // Bit mask of BTC5 field.
	DMAC_EBCISR_BTC5      = 0x20     // Bit BTC5.
	DMAC_EBCISR_BTC6_Pos  = 0x6      // Position of BTC6 field.
	DMAC_EBCISR_BTC6_Msk  = 0x40     // Bit mask of BTC6 field.
	DMAC_EBCISR_BTC6      = 0x40     // Bit BTC6.
	DMAC_EBCISR_BTC7_Pos  = 0x7      // Position of BTC7 field.
	DMAC_EBCISR_BTC7_Msk  = 0x80     // Bit mask of BTC7 field.
	DMAC_EBCISR_BTC7      = 0x80     // Bit BTC7.
	DMAC_EBCISR_CBTC0_Pos = 0x8      // Position of CBTC0 field.
	DMAC_EBCISR_CBTC0_Msk = 0x100    // Bit mask of CBTC0 field.
	DMAC_EBCISR_CBTC0     = 0x100    // Bit CBTC0.
	DMAC_EBCISR_CBTC1_Pos = 0x9      // Position of CBTC1 field.
	DMAC_EBCISR_CBTC1_Msk = 0x200    // Bit mask of CBTC1 field.
	DMAC_EBCISR_CBTC1     = 0x200    // Bit CBTC1.
	DMAC_EBCISR_CBTC2_Pos = 0xa      // Position of CBTC2 field.
	DMAC_EBCISR_CBTC2_Msk = 0x400    // Bit mask of CBTC2 field.
	DMAC_EBCISR_CBTC2     = 0x400    // Bit CBTC2.
	DMAC_EBCISR_CBTC3_Pos = 0xb      // Position of CBTC3 field.
	DMAC_EBCISR_CBTC3_Msk = 0x800    // Bit mask of CBTC3 field.
	DMAC_EBCISR_CBTC3     = 0x800    // Bit CBTC3.
	DMAC_EBCISR_CBTC4_Pos = 0xc      // Position of CBTC4 field.
	DMAC_EBCISR_CBTC4_Msk = 0x1000   // Bit mask of CBTC4 field.
	DMAC_EBCISR_CBTC4     = 0x1000   // Bit CBTC4.
	DMAC_EBCISR_CBTC5_Pos = 0xd      // Position of CBTC5 field.
	DMAC_EBCISR_CBTC5_Msk = 0x2000   // Bit mask of CBTC5 field.
	DMAC_EBCISR_CBTC5     = 0x2000   // Bit CBTC5.
	DMAC_EBCISR_CBTC6_Pos = 0xe      // Position of CBTC6 field.
	DMAC_EBCISR_CBTC6_Msk = 0x4000   // Bit mask of CBTC6 field.
	DMAC_EBCISR_CBTC6     = 0x4000   // Bit CBTC6.
	DMAC_EBCISR_CBTC7_Pos = 0xf      // Position of CBTC7 field.
	DMAC_EBCISR_CBTC7_Msk = 0x8000   // Bit mask of CBTC7 field.
	DMAC_EBCISR_CBTC7     = 0x8000   // Bit CBTC7.
	DMAC_EBCISR_ERR0_Pos  = 0x10     // Position of ERR0 field.
	DMAC_EBCISR_ERR0_Msk  = 0x10000  // Bit mask of ERR0 field.
	DMAC_EBCISR_ERR0      = 0x10000  // Bit ERR0.
	DMAC_EBCISR_ERR1_Pos  = 0x11     // Position of ERR1 field.
	DMAC_EBCISR_ERR1_Msk  = 0x20000  // Bit mask of ERR1 field.
	DMAC_EBCISR_ERR1      = 0x20000  // Bit ERR1.
	DMAC_EBCISR_ERR2_Pos  = 0x12     // Position of ERR2 field.
	DMAC_EBCISR_ERR2_Msk  = 0x40000  // Bit mask of ERR2 field.
	DMAC_EBCISR_ERR2      = 0x40000  // Bit ERR2.
	DMAC_EBCISR_ERR3_Pos  = 0x13     // Position of ERR3 field.
	DMAC_EBCISR_ERR3_Msk  = 0x80000  // Bit mask of ERR3 field.
	DMAC_EBCISR_ERR3      = 0x80000  // Bit ERR3.
	DMAC_EBCISR_ERR4_Pos  = 0x14     // Position of ERR4 field.
	DMAC_EBCISR_ERR4_Msk  = 0x100000 // Bit mask of ERR4 field.
	DMAC_EBCISR_ERR4      = 0x100000 // Bit ERR4.
	DMAC_EBCISR_ERR5_Pos  = 0x15     // Position of ERR5 field.
	DMAC_EBCISR_ERR5_Msk  = 0x200000 // Bit mask of ERR5 field.
	DMAC_EBCISR_ERR5      = 0x200000 // Bit ERR5.
	DMAC_EBCISR_ERR6_Pos  = 0x16     // Position of ERR6 field.
	DMAC_EBCISR_ERR6_Msk  = 0x400000 // Bit mask of ERR6 field.
	DMAC_EBCISR_ERR6      = 0x400000 // Bit ERR6.
	DMAC_EBCISR_ERR7_Pos  = 0x17     // Position of ERR7 field.
	DMAC_EBCISR_ERR7_Msk  = 0x800000 // Bit mask of ERR7 field.
	DMAC_EBCISR_ERR7      = 0x800000 // Bit ERR7.

	// CHER: DMAC Channel Handler Enable Register
	DMAC_CHER_ENA0_Pos  = 0x0        // Position of ENA0 field.
	DMAC_CHER_ENA0_Msk  = 0x1        // Bit mask of ENA0 field.
	DMAC_CHER_ENA0      = 0x1        // Bit ENA0.
	DMAC_CHER_ENA1_Pos  = 0x1        // Position of ENA1 field.
	DMAC_CHER_ENA1_Msk  = 0x2        // Bit mask of ENA1 field.
	DMAC_CHER_ENA1      = 0x2        // Bit ENA1.
	DMAC_CHER_ENA2_Pos  = 0x2        // Position of ENA2 field.
	DMAC_CHER_ENA2_Msk  = 0x4        // Bit mask of ENA2 field.
	DMAC_CHER_ENA2      = 0x4        // Bit ENA2.
	DMAC_CHER_ENA3_Pos  = 0x3        // Position of ENA3 field.
	DMAC_CHER_ENA3_Msk  = 0x8        // Bit mask of ENA3 field.
	DMAC_CHER_ENA3      = 0x8        // Bit ENA3.
	DMAC_CHER_ENA4_Pos  = 0x4        // Position of ENA4 field.
	DMAC_CHER_ENA4_Msk  = 0x10       // Bit mask of ENA4 field.
	DMAC_CHER_ENA4      = 0x10       // Bit ENA4.
	DMAC_CHER_ENA5_Pos  = 0x5        // Position of ENA5 field.
	DMAC_CHER_ENA5_Msk  = 0x20       // Bit mask of ENA5 field.
	DMAC_CHER_ENA5      = 0x20       // Bit ENA5.
	DMAC_CHER_ENA6_Pos  = 0x6        // Position of ENA6 field.
	DMAC_CHER_ENA6_Msk  = 0x40       // Bit mask of ENA6 field.
	DMAC_CHER_ENA6      = 0x40       // Bit ENA6.
	DMAC_CHER_ENA7_Pos  = 0x7        // Position of ENA7 field.
	DMAC_CHER_ENA7_Msk  = 0x80       // Bit mask of ENA7 field.
	DMAC_CHER_ENA7      = 0x80       // Bit ENA7.
	DMAC_CHER_SUSP0_Pos = 0x8        // Position of SUSP0 field.
	DMAC_CHER_SUSP0_Msk = 0x100      // Bit mask of SUSP0 field.
	DMAC_CHER_SUSP0     = 0x100      // Bit SUSP0.
	DMAC_CHER_SUSP1_Pos = 0x9        // Position of SUSP1 field.
	DMAC_CHER_SUSP1_Msk = 0x200      // Bit mask of SUSP1 field.
	DMAC_CHER_SUSP1     = 0x200      // Bit SUSP1.
	DMAC_CHER_SUSP2_Pos = 0xa        // Position of SUSP2 field.
	DMAC_CHER_SUSP2_Msk = 0x400      // Bit mask of SUSP2 field.
	DMAC_CHER_SUSP2     = 0x400      // Bit SUSP2.
	DMAC_CHER_SUSP3_Pos = 0xb        // Position of SUSP3 field.
	DMAC_CHER_SUSP3_Msk = 0x800      // Bit mask of SUSP3 field.
	DMAC_CHER_SUSP3     = 0x800      // Bit SUSP3.
	DMAC_CHER_SUSP4_Pos = 0xc        // Position of SUSP4 field.
	DMAC_CHER_SUSP4_Msk = 0x1000     // Bit mask of SUSP4 field.
	DMAC_CHER_SUSP4     = 0x1000     // Bit SUSP4.
	DMAC_CHER_SUSP5_Pos = 0xd        // Position of SUSP5 field.
	DMAC_CHER_SUSP5_Msk = 0x2000     // Bit mask of SUSP5 field.
	DMAC_CHER_SUSP5     = 0x2000     // Bit SUSP5.
	DMAC_CHER_SUSP6_Pos = 0xe        // Position of SUSP6 field.
	DMAC_CHER_SUSP6_Msk = 0x4000     // Bit mask of SUSP6 field.
	DMAC_CHER_SUSP6     = 0x4000     // Bit SUSP6.
	DMAC_CHER_SUSP7_Pos = 0xf        // Position of SUSP7 field.
	DMAC_CHER_SUSP7_Msk = 0x8000     // Bit mask of SUSP7 field.
	DMAC_CHER_SUSP7     = 0x8000     // Bit SUSP7.
	DMAC_CHER_KEEP0_Pos = 0x18       // Position of KEEP0 field.
	DMAC_CHER_KEEP0_Msk = 0x1000000  // Bit mask of KEEP0 field.
	DMAC_CHER_KEEP0     = 0x1000000  // Bit KEEP0.
	DMAC_CHER_KEEP1_Pos = 0x19       // Position of KEEP1 field.
	DMAC_CHER_KEEP1_Msk = 0x2000000  // Bit mask of KEEP1 field.
	DMAC_CHER_KEEP1     = 0x2000000  // Bit KEEP1.
	DMAC_CHER_KEEP2_Pos = 0x1a       // Position of KEEP2 field.
	DMAC_CHER_KEEP2_Msk = 0x4000000  // Bit mask of KEEP2 field.
	DMAC_CHER_KEEP2     = 0x4000000  // Bit KEEP2.
	DMAC_CHER_KEEP3_Pos = 0x1b       // Position of KEEP3 field.
	DMAC_CHER_KEEP3_Msk = 0x8000000  // Bit mask of KEEP3 field.
	DMAC_CHER_KEEP3     = 0x8000000  // Bit KEEP3.
	DMAC_CHER_KEEP4_Pos = 0x1c       // Position of KEEP4 field.
	DMAC_CHER_KEEP4_Msk = 0x10000000 // Bit mask of KEEP4 field.
	DMAC_CHER_KEEP4     = 0x10000000 // Bit KEEP4.
	DMAC_CHER_KEEP5_Pos = 0x1d       // Position of KEEP5 field.
	DMAC_CHER_KEEP5_Msk = 0x20000000 // Bit mask of KEEP5 field.
	DMAC_CHER_KEEP5     = 0x20000000 // Bit KEEP5.
	DMAC_CHER_KEEP6_Pos = 0x1e       // Position of KEEP6 field.
	DMAC_CHER_KEEP6_Msk = 0x40000000 // Bit mask of KEEP6 field.
	DMAC_CHER_KEEP6     = 0x40000000 // Bit KEEP6.
	DMAC_CHER_KEEP7_Pos = 0x1f       // Position of KEEP7 field.
	DMAC_CHER_KEEP7_Msk = 0x80000000 // Bit mask of KEEP7 field.
	DMAC_CHER_KEEP7     = 0x80000000 // Bit KEEP7.

	// CHDR: DMAC Channel Handler Disable Register
	DMAC_CHDR_DIS0_Pos = 0x0    // Position of DIS0 field.
	DMAC_CHDR_DIS0_Msk = 0x1    // Bit mask of DIS0 field.
	DMAC_CHDR_DIS0     = 0x1    // Bit DIS0.
	DMAC_CHDR_DIS1_Pos = 0x1    // Position of DIS1 field.
	DMAC_CHDR_DIS1_Msk = 0x2    // Bit mask of DIS1 field.
	DMAC_CHDR_DIS1     = 0x2    // Bit DIS1.
	DMAC_CHDR_DIS2_Pos = 0x2    // Position of DIS2 field.
	DMAC_CHDR_DIS2_Msk = 0x4    // Bit mask of DIS2 field.
	DMAC_CHDR_DIS2     = 0x4    // Bit DIS2.
	DMAC_CHDR_DIS3_Pos = 0x3    // Position of DIS3 field.
	DMAC_CHDR_DIS3_Msk = 0x8    // Bit mask of DIS3 field.
	DMAC_CHDR_DIS3     = 0x8    // Bit DIS3.
	DMAC_CHDR_DIS4_Pos = 0x4    // Position of DIS4 field.
	DMAC_CHDR_DIS4_Msk = 0x10   // Bit mask of DIS4 field.
	DMAC_CHDR_DIS4     = 0x10   // Bit DIS4.
	DMAC_CHDR_DIS5_Pos = 0x5    // Position of DIS5 field.
	DMAC_CHDR_DIS5_Msk = 0x20   // Bit mask of DIS5 field.
	DMAC_CHDR_DIS5     = 0x20   // Bit DIS5.
	DMAC_CHDR_DIS6_Pos = 0x6    // Position of DIS6 field.
	DMAC_CHDR_DIS6_Msk = 0x40   // Bit mask of DIS6 field.
	DMAC_CHDR_DIS6     = 0x40   // Bit DIS6.
	DMAC_CHDR_DIS7_Pos = 0x7    // Position of DIS7 field.
	DMAC_CHDR_DIS7_Msk = 0x80   // Bit mask of DIS7 field.
	DMAC_CHDR_DIS7     = 0x80   // Bit DIS7.
	DMAC_CHDR_RES0_Pos = 0x8    // Position of RES0 field.
	DMAC_CHDR_RES0_Msk = 0x100  // Bit mask of RES0 field.
	DMAC_CHDR_RES0     = 0x100  // Bit RES0.
	DMAC_CHDR_RES1_Pos = 0x9    // Position of RES1 field.
	DMAC_CHDR_RES1_Msk = 0x200  // Bit mask of RES1 field.
	DMAC_CHDR_RES1     = 0x200  // Bit RES1.
	DMAC_CHDR_RES2_Pos = 0xa    // Position of RES2 field.
	DMAC_CHDR_RES2_Msk = 0x400  // Bit mask of RES2 field.
	DMAC_CHDR_RES2     = 0x400  // Bit RES2.
	DMAC_CHDR_RES3_Pos = 0xb    // Position of RES3 field.
	DMAC_CHDR_RES3_Msk = 0x800  // Bit mask of RES3 field.
	DMAC_CHDR_RES3     = 0x800  // Bit RES3.
	DMAC_CHDR_RES4_Pos = 0xc    // Position of RES4 field.
	DMAC_CHDR_RES4_Msk = 0x1000 // Bit mask of RES4 field.
	DMAC_CHDR_RES4     = 0x1000 // Bit RES4.
	DMAC_CHDR_RES5_Pos = 0xd    // Position of RES5 field.
	DMAC_CHDR_RES5_Msk = 0x2000 // Bit mask of RES5 field.
	DMAC_CHDR_RES5     = 0x2000 // Bit RES5.
	DMAC_CHDR_RES6_Pos = 0xe    // Position of RES6 field.
	DMAC_CHDR_RES6_Msk = 0x4000 // Bit mask of RES6 field.
	DMAC_CHDR_RES6     = 0x4000 // Bit RES6.
	DMAC_CHDR_RES7_Pos = 0xf    // Position of RES7 field.
	DMAC_CHDR_RES7_Msk = 0x8000 // Bit mask of RES7 field.
	DMAC_CHDR_RES7     = 0x8000 // Bit RES7.

	// CHSR: DMAC Channel Handler Status Register
	DMAC_CHSR_ENA0_Pos  = 0x0        // Position of ENA0 field.
	DMAC_CHSR_ENA0_Msk  = 0x1        // Bit mask of ENA0 field.
	DMAC_CHSR_ENA0      = 0x1        // Bit ENA0.
	DMAC_CHSR_ENA1_Pos  = 0x1        // Position of ENA1 field.
	DMAC_CHSR_ENA1_Msk  = 0x2        // Bit mask of ENA1 field.
	DMAC_CHSR_ENA1      = 0x2        // Bit ENA1.
	DMAC_CHSR_ENA2_Pos  = 0x2        // Position of ENA2 field.
	DMAC_CHSR_ENA2_Msk  = 0x4        // Bit mask of ENA2 field.
	DMAC_CHSR_ENA2      = 0x4        // Bit ENA2.
	DMAC_CHSR_ENA3_Pos  = 0x3        // Position of ENA3 field.
	DMAC_CHSR_ENA3_Msk  = 0x8        // Bit mask of ENA3 field.
	DMAC_CHSR_ENA3      = 0x8        // Bit ENA3.
	DMAC_CHSR_ENA4_Pos  = 0x4        // Position of ENA4 field.
	DMAC_CHSR_ENA4_Msk  = 0x10       // Bit mask of ENA4 field.
	DMAC_CHSR_ENA4      = 0x10       // Bit ENA4.
	DMAC_CHSR_ENA5_Pos  = 0x5        // Position of ENA5 field.
	DMAC_CHSR_ENA5_Msk  = 0x20       // Bit mask of ENA5 field.
	DMAC_CHSR_ENA5      = 0x20       // Bit ENA5.
	DMAC_CHSR_ENA6_Pos  = 0x6        // Position of ENA6 field.
	DMAC_CHSR_ENA6_Msk  = 0x40       // Bit mask of ENA6 field.
	DMAC_CHSR_ENA6      = 0x40       // Bit ENA6.
	DMAC_CHSR_ENA7_Pos  = 0x7        // Position of ENA7 field.
	DMAC_CHSR_ENA7_Msk  = 0x80       // Bit mask of ENA7 field.
	DMAC_CHSR_ENA7      = 0x80       // Bit ENA7.
	DMAC_CHSR_SUSP0_Pos = 0x8        // Position of SUSP0 field.
	DMAC_CHSR_SUSP0_Msk = 0x100      // Bit mask of SUSP0 field.
	DMAC_CHSR_SUSP0     = 0x100      // Bit SUSP0.
	DMAC_CHSR_SUSP1_Pos = 0x9        // Position of SUSP1 field.
	DMAC_CHSR_SUSP1_Msk = 0x200      // Bit mask of SUSP1 field.
	DMAC_CHSR_SUSP1     = 0x200      // Bit SUSP1.
	DMAC_CHSR_SUSP2_Pos = 0xa        // Position of SUSP2 field.
	DMAC_CHSR_SUSP2_Msk = 0x400      // Bit mask of SUSP2 field.
	DMAC_CHSR_SUSP2     = 0x400      // Bit SUSP2.
	DMAC_CHSR_SUSP3_Pos = 0xb        // Position of SUSP3 field.
	DMAC_CHSR_SUSP3_Msk = 0x800      // Bit mask of SUSP3 field.
	DMAC_CHSR_SUSP3     = 0x800      // Bit SUSP3.
	DMAC_CHSR_SUSP4_Pos = 0xc        // Position of SUSP4 field.
	DMAC_CHSR_SUSP4_Msk = 0x1000     // Bit mask of SUSP4 field.
	DMAC_CHSR_SUSP4     = 0x1000     // Bit SUSP4.
	DMAC_CHSR_SUSP5_Pos = 0xd        // Position of SUSP5 field.
	DMAC_CHSR_SUSP5_Msk = 0x2000     // Bit mask of SUSP5 field.
	DMAC_CHSR_SUSP5     = 0x2000     // Bit SUSP5.
	DMAC_CHSR_SUSP6_Pos = 0xe        // Position of SUSP6 field.
	DMAC_CHSR_SUSP6_Msk = 0x4000     // Bit mask of SUSP6 field.
	DMAC_CHSR_SUSP6     = 0x4000     // Bit SUSP6.
	DMAC_CHSR_SUSP7_Pos = 0xf        // Position of SUSP7 field.
	DMAC_CHSR_SUSP7_Msk = 0x8000     // Bit mask of SUSP7 field.
	DMAC_CHSR_SUSP7     = 0x8000     // Bit SUSP7.
	DMAC_CHSR_EMPT0_Pos = 0x10       // Position of EMPT0 field.
	DMAC_CHSR_EMPT0_Msk = 0x10000    // Bit mask of EMPT0 field.
	DMAC_CHSR_EMPT0     = 0x10000    // Bit EMPT0.
	DMAC_CHSR_EMPT1_Pos = 0x11       // Position of EMPT1 field.
	DMAC_CHSR_EMPT1_Msk = 0x20000    // Bit mask of EMPT1 field.
	DMAC_CHSR_EMPT1     = 0x20000    // Bit EMPT1.
	DMAC_CHSR_EMPT2_Pos = 0x12       // Position of EMPT2 field.
	DMAC_CHSR_EMPT2_Msk = 0x40000    // Bit mask of EMPT2 field.
	DMAC_CHSR_EMPT2     = 0x40000    // Bit EMPT2.
	DMAC_CHSR_EMPT3_Pos = 0x13       // Position of EMPT3 field.
	DMAC_CHSR_EMPT3_Msk = 0x80000    // Bit mask of EMPT3 field.
	DMAC_CHSR_EMPT3     = 0x80000    // Bit EMPT3.
	DMAC_CHSR_EMPT4_Pos = 0x14       // Position of EMPT4 field.
	DMAC_CHSR_EMPT4_Msk = 0x100000   // Bit mask of EMPT4 field.
	DMAC_CHSR_EMPT4     = 0x100000   // Bit EMPT4.
	DMAC_CHSR_EMPT5_Pos = 0x15       // Position of EMPT5 field.
	DMAC_CHSR_EMPT5_Msk = 0x200000   // Bit mask of EMPT5 field.
	DMAC_CHSR_EMPT5     = 0x200000   // Bit EMPT5.
	DMAC_CHSR_EMPT6_Pos = 0x16       // Position of EMPT6 field.
	DMAC_CHSR_EMPT6_Msk = 0x400000   // Bit mask of EMPT6 field.
	DMAC_CHSR_EMPT6     = 0x400000   // Bit EMPT6.
	DMAC_CHSR_EMPT7_Pos = 0x17       // Position of EMPT7 field.
	DMAC_CHSR_EMPT7_Msk = 0x800000   // Bit mask of EMPT7 field.
	DMAC_CHSR_EMPT7     = 0x800000   // Bit EMPT7.
	DMAC_CHSR_STAL0_Pos = 0x18       // Position of STAL0 field.
	DMAC_CHSR_STAL0_Msk = 0x1000000  // Bit mask of STAL0 field.
	DMAC_CHSR_STAL0     = 0x1000000  // Bit STAL0.
	DMAC_CHSR_STAL1_Pos = 0x19       // Position of STAL1 field.
	DMAC_CHSR_STAL1_Msk = 0x2000000  // Bit mask of STAL1 field.
	DMAC_CHSR_STAL1     = 0x2000000  // Bit STAL1.
	DMAC_CHSR_STAL2_Pos = 0x1a       // Position of STAL2 field.
	DMAC_CHSR_STAL2_Msk = 0x4000000  // Bit mask of STAL2 field.
	DMAC_CHSR_STAL2     = 0x4000000  // Bit STAL2.
	DMAC_CHSR_STAL3_Pos = 0x1b       // Position of STAL3 field.
	DMAC_CHSR_STAL3_Msk = 0x8000000  // Bit mask of STAL3 field.
	DMAC_CHSR_STAL3     = 0x8000000  // Bit STAL3.
	DMAC_CHSR_STAL4_Pos = 0x1c       // Position of STAL4 field.
	DMAC_CHSR_STAL4_Msk = 0x10000000 // Bit mask of STAL4 field.
	DMAC_CHSR_STAL4     = 0x10000000 // Bit STAL4.
	DMAC_CHSR_STAL5_Pos = 0x1d       // Position of STAL5 field.
	DMAC_CHSR_STAL5_Msk = 0x20000000 // Bit mask of STAL5 field.
	DMAC_CHSR_STAL5     = 0x20000000 // Bit STAL5.
	DMAC_CHSR_STAL6_Pos = 0x1e       // Position of STAL6 field.
	DMAC_CHSR_STAL6_Msk = 0x40000000 // Bit mask of STAL6 field.
	DMAC_CHSR_STAL6     = 0x40000000 // Bit STAL6.
	DMAC_CHSR_STAL7_Pos = 0x1f       // Position of STAL7 field.
	DMAC_CHSR_STAL7_Msk = 0x80000000 // Bit mask of STAL7 field.
	DMAC_CHSR_STAL7     = 0x80000000 // Bit STAL7.

	// SADDR0: DMAC Channel Source Address Register (ch_num = 0)
	DMAC_SADDR0_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR0_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR0: DMAC Channel Destination Address Register (ch_num = 0)
	DMAC_DADDR0_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR0_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR0: DMAC Channel Descriptor Address Register (ch_num = 0)
	DMAC_DSCR0_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR0_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR0_DSCR_IF_AHB_IF0 = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR0_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR0_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR0_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA0: DMAC Channel Control A Register (ch_num = 0)
	DMAC_CTRLA0_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA0_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA0_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA0_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA0_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA0_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA0_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA0_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA0_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA0_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA0_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA0_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA0_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA0_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA0_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA0_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA0_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA0_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA0_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA0_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA0_DONE                = 0x80000000 // Bit DONE.

	// CTRLB0: DMAC Channel Control B Register (ch_num = 0)
	DMAC_CTRLB0_SIF_Pos                 = 0x0        // Position of SIF field.
	DMAC_CTRLB0_SIF_Msk                 = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB0_SIF_AHB_IF0             = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB0_SIF_AHB_IF1             = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB0_DIF_Pos                 = 0x4        // Position of DIF field.
	DMAC_CTRLB0_DIF_Msk                 = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB0_DIF_AHB_IF0             = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB0_DIF_AHB_IF1             = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB0_SRC_PIP_Pos             = 0x8        // Position of SRC_PIP field.
	DMAC_CTRLB0_SRC_PIP_Msk             = 0x100      // Bit mask of SRC_PIP field.
	DMAC_CTRLB0_SRC_PIP                 = 0x100      // Bit SRC_PIP.
	DMAC_CTRLB0_SRC_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB0_SRC_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB0_DST_PIP_Pos             = 0xc        // Position of DST_PIP field.
	DMAC_CTRLB0_DST_PIP_Msk             = 0x1000     // Bit mask of DST_PIP field.
	DMAC_CTRLB0_DST_PIP                 = 0x1000     // Bit DST_PIP.
	DMAC_CTRLB0_DST_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB0_DST_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB0_SRC_DSCR_Pos            = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB0_SRC_DSCR_Msk            = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB0_SRC_DSCR                = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB0_SRC_DSCR_FETCH_FROM_MEM = 0x0        // Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB0_SRC_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB0_DST_DSCR_Pos            = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB0_DST_DSCR_Msk            = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB0_DST_DSCR                = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB0_DST_DSCR_FETCH_FROM_MEM = 0x0        // Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB0_DST_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB0_FC_Pos                  = 0x15       // Position of FC field.
	DMAC_CTRLB0_FC_Msk                  = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB0_FC_MEM2MEM_DMA_FC       = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_MEM2PER_DMA_FC       = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2MEM_DMA_FC       = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2PER_DMA_FC       = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_SRC_INCR_Pos            = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB0_SRC_INCR_Msk            = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB0_SRC_INCR_INCREMENTING   = 0x0        // The source address is incremented
	DMAC_CTRLB0_SRC_INCR_DECREMENTING   = 0x1        // The source address is decremented
	DMAC_CTRLB0_SRC_INCR_FIXED          = 0x2        // The source address remains unchanged
	DMAC_CTRLB0_DST_INCR_Pos            = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB0_DST_INCR_Msk            = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB0_DST_INCR_INCREMENTING   = 0x0        // The destination address is incremented
	DMAC_CTRLB0_DST_INCR_DECREMENTING   = 0x1        // The destination address is decremented
	DMAC_CTRLB0_DST_INCR_FIXED          = 0x2        // The destination address remains unchanged
	DMAC_CTRLB0_IEN_Pos                 = 0x1e       // Position of IEN field.
	DMAC_CTRLB0_IEN_Msk                 = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB0_IEN                     = 0x40000000 // Bit IEN.
	DMAC_CTRLB0_AUTO_Pos                = 0x1f       // Position of AUTO field.
	DMAC_CTRLB0_AUTO_Msk                = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB0_AUTO                    = 0x80000000 // Bit AUTO.
	DMAC_CTRLB0_AUTO_DISABLE            = 0x0        // Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB0_AUTO_ENABLE             = 0x1        // Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.

	// CFG0: DMAC Channel Configuration Register (ch_num = 0)
	DMAC_CFG0_SRC_PER_Pos             = 0x0        // Position of SRC_PER field.
	DMAC_CFG0_SRC_PER_Msk             = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG0_DST_PER_Pos             = 0x4        // Position of DST_PER field.
	DMAC_CFG0_DST_PER_Msk             = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG0_SRC_REP_Pos             = 0x8        // Position of SRC_REP field.
	DMAC_CFG0_SRC_REP_Msk             = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG0_SRC_REP                 = 0x100      // Bit SRC_REP.
	DMAC_CFG0_SRC_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG0_SRC_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG0_SRC_H2SEL_Pos           = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG0_SRC_H2SEL_Msk           = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG0_SRC_H2SEL               = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG0_SRC_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_SRC_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_DST_REP_Pos             = 0xc        // Position of DST_REP field.
	DMAC_CFG0_DST_REP_Msk             = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG0_DST_REP                 = 0x1000     // Bit DST_REP.
	DMAC_CFG0_DST_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG0_DST_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG0_DST_H2SEL_Pos           = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG0_DST_H2SEL_Msk           = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG0_DST_H2SEL               = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG0_DST_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_DST_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_SOD_Pos                 = 0x10       // Position of SOD field.
	DMAC_CFG0_SOD_Msk                 = 0x10000    // Bit mask of SOD field.
	DMAC_CFG0_SOD                     = 0x10000    // Bit SOD.
	DMAC_CFG0_SOD_DISABLE             = 0x0        // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG0_SOD_ENABLE              = 0x1        // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG0_LOCK_IF_Pos             = 0x14       // Position of LOCK_IF field.
	DMAC_CFG0_LOCK_IF_Msk             = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG0_LOCK_IF                 = 0x100000   // Bit LOCK_IF.
	DMAC_CFG0_LOCK_IF_DISABLE         = 0x0        // Interface Lock capability is disabled
	DMAC_CFG0_LOCK_IF_ENABLE          = 0x1        // Interface Lock capability is enabled
	DMAC_CFG0_LOCK_B_Pos              = 0x15       // Position of LOCK_B field.
	DMAC_CFG0_LOCK_B_Msk              = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG0_LOCK_B                  = 0x200000   // Bit LOCK_B.
	DMAC_CFG0_LOCK_B_DISABLE          = 0x0        // AHB Bus Locking capability is disabled.
	DMAC_CFG0_LOCK_IF_L_Pos           = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG0_LOCK_IF_L_Msk           = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG0_LOCK_IF_L               = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG0_LOCK_IF_L_CHUNK         = 0x0        // The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG0_LOCK_IF_L_BUFFER        = 0x1        // The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG0_AHB_PROT_Pos            = 0x18       // Position of AHB_PROT field.
	DMAC_CFG0_AHB_PROT_Msk            = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG0_FIFOCFG_Pos             = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG0_FIFOCFG_Msk             = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG0_FIFOCFG_ALAP_CFG        = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG0_FIFOCFG_HALF_CFG        = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG0_FIFOCFG_ASAP_CFG        = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SPIP0: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 0)
	DMAC_SPIP0_SPIP_HOLE_Pos     = 0x0       // Position of SPIP_HOLE field.
	DMAC_SPIP0_SPIP_HOLE_Msk     = 0xffff    // Bit mask of SPIP_HOLE field.
	DMAC_SPIP0_SPIP_BOUNDARY_Pos = 0x10      // Position of SPIP_BOUNDARY field.
	DMAC_SPIP0_SPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of SPIP_BOUNDARY field.

	// DPIP0: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 0)
	DMAC_DPIP0_DPIP_HOLE_Pos     = 0x0       // Position of DPIP_HOLE field.
	DMAC_DPIP0_DPIP_HOLE_Msk     = 0xffff    // Bit mask of DPIP_HOLE field.
	DMAC_DPIP0_DPIP_BOUNDARY_Pos = 0x10      // Position of DPIP_BOUNDARY field.
	DMAC_DPIP0_DPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of DPIP_BOUNDARY field.

	// SADDR1: DMAC Channel Source Address Register (ch_num = 1)
	DMAC_SADDR1_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR1_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR1: DMAC Channel Destination Address Register (ch_num = 1)
	DMAC_DADDR1_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR1_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR1: DMAC Channel Descriptor Address Register (ch_num = 1)
	DMAC_DSCR1_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR1_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR1_DSCR_IF_AHB_IF0 = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR1_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR1_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR1_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA1: DMAC Channel Control A Register (ch_num = 1)
	DMAC_CTRLA1_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA1_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA1_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA1_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA1_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA1_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA1_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA1_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA1_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA1_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA1_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA1_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA1_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA1_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA1_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA1_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA1_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA1_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA1_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA1_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA1_DONE                = 0x80000000 // Bit DONE.

	// CTRLB1: DMAC Channel Control B Register (ch_num = 1)
	DMAC_CTRLB1_SIF_Pos                 = 0x0        // Position of SIF field.
	DMAC_CTRLB1_SIF_Msk                 = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB1_SIF_AHB_IF0             = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB1_SIF_AHB_IF1             = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB1_DIF_Pos                 = 0x4        // Position of DIF field.
	DMAC_CTRLB1_DIF_Msk                 = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB1_DIF_AHB_IF0             = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB1_DIF_AHB_IF1             = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB1_SRC_PIP_Pos             = 0x8        // Position of SRC_PIP field.
	DMAC_CTRLB1_SRC_PIP_Msk             = 0x100      // Bit mask of SRC_PIP field.
	DMAC_CTRLB1_SRC_PIP                 = 0x100      // Bit SRC_PIP.
	DMAC_CTRLB1_SRC_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB1_SRC_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB1_DST_PIP_Pos             = 0xc        // Position of DST_PIP field.
	DMAC_CTRLB1_DST_PIP_Msk             = 0x1000     // Bit mask of DST_PIP field.
	DMAC_CTRLB1_DST_PIP                 = 0x1000     // Bit DST_PIP.
	DMAC_CTRLB1_DST_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB1_DST_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB1_SRC_DSCR_Pos            = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB1_SRC_DSCR_Msk            = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB1_SRC_DSCR                = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB1_SRC_DSCR_FETCH_FROM_MEM = 0x0        // Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB1_SRC_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB1_DST_DSCR_Pos            = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB1_DST_DSCR_Msk            = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB1_DST_DSCR                = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB1_DST_DSCR_FETCH_FROM_MEM = 0x0        // Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB1_DST_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB1_FC_Pos                  = 0x15       // Position of FC field.
	DMAC_CTRLB1_FC_Msk                  = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB1_FC_MEM2MEM_DMA_FC       = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_MEM2PER_DMA_FC       = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2MEM_DMA_FC       = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2PER_DMA_FC       = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_SRC_INCR_Pos            = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB1_SRC_INCR_Msk            = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB1_SRC_INCR_INCREMENTING   = 0x0        // The source address is incremented
	DMAC_CTRLB1_SRC_INCR_DECREMENTING   = 0x1        // The source address is decremented
	DMAC_CTRLB1_SRC_INCR_FIXED          = 0x2        // The source address remains unchanged
	DMAC_CTRLB1_DST_INCR_Pos            = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB1_DST_INCR_Msk            = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB1_DST_INCR_INCREMENTING   = 0x0        // The destination address is incremented
	DMAC_CTRLB1_DST_INCR_DECREMENTING   = 0x1        // The destination address is decremented
	DMAC_CTRLB1_DST_INCR_FIXED          = 0x2        // The destination address remains unchanged
	DMAC_CTRLB1_IEN_Pos                 = 0x1e       // Position of IEN field.
	DMAC_CTRLB1_IEN_Msk                 = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB1_IEN                     = 0x40000000 // Bit IEN.
	DMAC_CTRLB1_AUTO_Pos                = 0x1f       // Position of AUTO field.
	DMAC_CTRLB1_AUTO_Msk                = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB1_AUTO                    = 0x80000000 // Bit AUTO.
	DMAC_CTRLB1_AUTO_DISABLE            = 0x0        // Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB1_AUTO_ENABLE             = 0x1        // Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.

	// CFG1: DMAC Channel Configuration Register (ch_num = 1)
	DMAC_CFG1_SRC_PER_Pos             = 0x0        // Position of SRC_PER field.
	DMAC_CFG1_SRC_PER_Msk             = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG1_DST_PER_Pos             = 0x4        // Position of DST_PER field.
	DMAC_CFG1_DST_PER_Msk             = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG1_SRC_REP_Pos             = 0x8        // Position of SRC_REP field.
	DMAC_CFG1_SRC_REP_Msk             = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG1_SRC_REP                 = 0x100      // Bit SRC_REP.
	DMAC_CFG1_SRC_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG1_SRC_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG1_SRC_H2SEL_Pos           = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG1_SRC_H2SEL_Msk           = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG1_SRC_H2SEL               = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG1_SRC_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_SRC_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_DST_REP_Pos             = 0xc        // Position of DST_REP field.
	DMAC_CFG1_DST_REP_Msk             = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG1_DST_REP                 = 0x1000     // Bit DST_REP.
	DMAC_CFG1_DST_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG1_DST_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG1_DST_H2SEL_Pos           = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG1_DST_H2SEL_Msk           = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG1_DST_H2SEL               = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG1_DST_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_DST_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_SOD_Pos                 = 0x10       // Position of SOD field.
	DMAC_CFG1_SOD_Msk                 = 0x10000    // Bit mask of SOD field.
	DMAC_CFG1_SOD                     = 0x10000    // Bit SOD.
	DMAC_CFG1_SOD_DISABLE             = 0x0        // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG1_SOD_ENABLE              = 0x1        // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG1_LOCK_IF_Pos             = 0x14       // Position of LOCK_IF field.
	DMAC_CFG1_LOCK_IF_Msk             = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG1_LOCK_IF                 = 0x100000   // Bit LOCK_IF.
	DMAC_CFG1_LOCK_IF_DISABLE         = 0x0        // Interface Lock capability is disabled
	DMAC_CFG1_LOCK_IF_ENABLE          = 0x1        // Interface Lock capability is enabled
	DMAC_CFG1_LOCK_B_Pos              = 0x15       // Position of LOCK_B field.
	DMAC_CFG1_LOCK_B_Msk              = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG1_LOCK_B                  = 0x200000   // Bit LOCK_B.
	DMAC_CFG1_LOCK_B_DISABLE          = 0x0        // AHB Bus Locking capability is disabled.
	DMAC_CFG1_LOCK_IF_L_Pos           = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG1_LOCK_IF_L_Msk           = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG1_LOCK_IF_L               = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG1_LOCK_IF_L_CHUNK         = 0x0        // The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG1_LOCK_IF_L_BUFFER        = 0x1        // The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG1_AHB_PROT_Pos            = 0x18       // Position of AHB_PROT field.
	DMAC_CFG1_AHB_PROT_Msk            = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG1_FIFOCFG_Pos             = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG1_FIFOCFG_Msk             = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG1_FIFOCFG_ALAP_CFG        = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG1_FIFOCFG_HALF_CFG        = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG1_FIFOCFG_ASAP_CFG        = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SPIP1: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 1)
	DMAC_SPIP1_SPIP_HOLE_Pos     = 0x0       // Position of SPIP_HOLE field.
	DMAC_SPIP1_SPIP_HOLE_Msk     = 0xffff    // Bit mask of SPIP_HOLE field.
	DMAC_SPIP1_SPIP_BOUNDARY_Pos = 0x10      // Position of SPIP_BOUNDARY field.
	DMAC_SPIP1_SPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of SPIP_BOUNDARY field.

	// DPIP1: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 1)
	DMAC_DPIP1_DPIP_HOLE_Pos     = 0x0       // Position of DPIP_HOLE field.
	DMAC_DPIP1_DPIP_HOLE_Msk     = 0xffff    // Bit mask of DPIP_HOLE field.
	DMAC_DPIP1_DPIP_BOUNDARY_Pos = 0x10      // Position of DPIP_BOUNDARY field.
	DMAC_DPIP1_DPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of DPIP_BOUNDARY field.

	// SADDR2: DMAC Channel Source Address Register (ch_num = 2)
	DMAC_SADDR2_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR2_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR2: DMAC Channel Destination Address Register (ch_num = 2)
	DMAC_DADDR2_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR2_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR2: DMAC Channel Descriptor Address Register (ch_num = 2)
	DMAC_DSCR2_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR2_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR2_DSCR_IF_AHB_IF0 = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR2_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR2_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR2_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA2: DMAC Channel Control A Register (ch_num = 2)
	DMAC_CTRLA2_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA2_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA2_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA2_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA2_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA2_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA2_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA2_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA2_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA2_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA2_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA2_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA2_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA2_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA2_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA2_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA2_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA2_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA2_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA2_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA2_DONE                = 0x80000000 // Bit DONE.

	// CTRLB2: DMAC Channel Control B Register (ch_num = 2)
	DMAC_CTRLB2_SIF_Pos                 = 0x0        // Position of SIF field.
	DMAC_CTRLB2_SIF_Msk                 = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB2_SIF_AHB_IF0             = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB2_SIF_AHB_IF1             = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB2_DIF_Pos                 = 0x4        // Position of DIF field.
	DMAC_CTRLB2_DIF_Msk                 = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB2_DIF_AHB_IF0             = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB2_DIF_AHB_IF1             = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB2_SRC_PIP_Pos             = 0x8        // Position of SRC_PIP field.
	DMAC_CTRLB2_SRC_PIP_Msk             = 0x100      // Bit mask of SRC_PIP field.
	DMAC_CTRLB2_SRC_PIP                 = 0x100      // Bit SRC_PIP.
	DMAC_CTRLB2_SRC_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB2_SRC_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB2_DST_PIP_Pos             = 0xc        // Position of DST_PIP field.
	DMAC_CTRLB2_DST_PIP_Msk             = 0x1000     // Bit mask of DST_PIP field.
	DMAC_CTRLB2_DST_PIP                 = 0x1000     // Bit DST_PIP.
	DMAC_CTRLB2_DST_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB2_DST_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB2_SRC_DSCR_Pos            = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB2_SRC_DSCR_Msk            = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB2_SRC_DSCR                = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB2_SRC_DSCR_FETCH_FROM_MEM = 0x0        // Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB2_SRC_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB2_DST_DSCR_Pos            = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB2_DST_DSCR_Msk            = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB2_DST_DSCR                = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB2_DST_DSCR_FETCH_FROM_MEM = 0x0        // Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB2_DST_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB2_FC_Pos                  = 0x15       // Position of FC field.
	DMAC_CTRLB2_FC_Msk                  = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB2_FC_MEM2MEM_DMA_FC       = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_MEM2PER_DMA_FC       = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2MEM_DMA_FC       = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2PER_DMA_FC       = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_SRC_INCR_Pos            = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB2_SRC_INCR_Msk            = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB2_SRC_INCR_INCREMENTING   = 0x0        // The source address is incremented
	DMAC_CTRLB2_SRC_INCR_DECREMENTING   = 0x1        // The source address is decremented
	DMAC_CTRLB2_SRC_INCR_FIXED          = 0x2        // The source address remains unchanged
	DMAC_CTRLB2_DST_INCR_Pos            = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB2_DST_INCR_Msk            = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB2_DST_INCR_INCREMENTING   = 0x0        // The destination address is incremented
	DMAC_CTRLB2_DST_INCR_DECREMENTING   = 0x1        // The destination address is decremented
	DMAC_CTRLB2_DST_INCR_FIXED          = 0x2        // The destination address remains unchanged
	DMAC_CTRLB2_IEN_Pos                 = 0x1e       // Position of IEN field.
	DMAC_CTRLB2_IEN_Msk                 = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB2_IEN                     = 0x40000000 // Bit IEN.
	DMAC_CTRLB2_AUTO_Pos                = 0x1f       // Position of AUTO field.
	DMAC_CTRLB2_AUTO_Msk                = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB2_AUTO                    = 0x80000000 // Bit AUTO.
	DMAC_CTRLB2_AUTO_DISABLE            = 0x0        // Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB2_AUTO_ENABLE             = 0x1        // Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.

	// CFG2: DMAC Channel Configuration Register (ch_num = 2)
	DMAC_CFG2_SRC_PER_Pos             = 0x0        // Position of SRC_PER field.
	DMAC_CFG2_SRC_PER_Msk             = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG2_DST_PER_Pos             = 0x4        // Position of DST_PER field.
	DMAC_CFG2_DST_PER_Msk             = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG2_SRC_REP_Pos             = 0x8        // Position of SRC_REP field.
	DMAC_CFG2_SRC_REP_Msk             = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG2_SRC_REP                 = 0x100      // Bit SRC_REP.
	DMAC_CFG2_SRC_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG2_SRC_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG2_SRC_H2SEL_Pos           = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG2_SRC_H2SEL_Msk           = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG2_SRC_H2SEL               = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG2_SRC_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_SRC_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_DST_REP_Pos             = 0xc        // Position of DST_REP field.
	DMAC_CFG2_DST_REP_Msk             = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG2_DST_REP                 = 0x1000     // Bit DST_REP.
	DMAC_CFG2_DST_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG2_DST_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG2_DST_H2SEL_Pos           = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG2_DST_H2SEL_Msk           = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG2_DST_H2SEL               = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG2_DST_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_DST_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_SOD_Pos                 = 0x10       // Position of SOD field.
	DMAC_CFG2_SOD_Msk                 = 0x10000    // Bit mask of SOD field.
	DMAC_CFG2_SOD                     = 0x10000    // Bit SOD.
	DMAC_CFG2_SOD_DISABLE             = 0x0        // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG2_SOD_ENABLE              = 0x1        // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG2_LOCK_IF_Pos             = 0x14       // Position of LOCK_IF field.
	DMAC_CFG2_LOCK_IF_Msk             = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG2_LOCK_IF                 = 0x100000   // Bit LOCK_IF.
	DMAC_CFG2_LOCK_IF_DISABLE         = 0x0        // Interface Lock capability is disabled
	DMAC_CFG2_LOCK_IF_ENABLE          = 0x1        // Interface Lock capability is enabled
	DMAC_CFG2_LOCK_B_Pos              = 0x15       // Position of LOCK_B field.
	DMAC_CFG2_LOCK_B_Msk              = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG2_LOCK_B                  = 0x200000   // Bit LOCK_B.
	DMAC_CFG2_LOCK_B_DISABLE          = 0x0        // AHB Bus Locking capability is disabled.
	DMAC_CFG2_LOCK_IF_L_Pos           = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG2_LOCK_IF_L_Msk           = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG2_LOCK_IF_L               = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG2_LOCK_IF_L_CHUNK         = 0x0        // The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG2_LOCK_IF_L_BUFFER        = 0x1        // The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG2_AHB_PROT_Pos            = 0x18       // Position of AHB_PROT field.
	DMAC_CFG2_AHB_PROT_Msk            = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG2_FIFOCFG_Pos             = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG2_FIFOCFG_Msk             = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG2_FIFOCFG_ALAP_CFG        = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG2_FIFOCFG_HALF_CFG        = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG2_FIFOCFG_ASAP_CFG        = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SPIP2: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 2)
	DMAC_SPIP2_SPIP_HOLE_Pos     = 0x0       // Position of SPIP_HOLE field.
	DMAC_SPIP2_SPIP_HOLE_Msk     = 0xffff    // Bit mask of SPIP_HOLE field.
	DMAC_SPIP2_SPIP_BOUNDARY_Pos = 0x10      // Position of SPIP_BOUNDARY field.
	DMAC_SPIP2_SPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of SPIP_BOUNDARY field.

	// DPIP2: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 2)
	DMAC_DPIP2_DPIP_HOLE_Pos     = 0x0       // Position of DPIP_HOLE field.
	DMAC_DPIP2_DPIP_HOLE_Msk     = 0xffff    // Bit mask of DPIP_HOLE field.
	DMAC_DPIP2_DPIP_BOUNDARY_Pos = 0x10      // Position of DPIP_BOUNDARY field.
	DMAC_DPIP2_DPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of DPIP_BOUNDARY field.

	// SADDR3: DMAC Channel Source Address Register (ch_num = 3)
	DMAC_SADDR3_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR3_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR3: DMAC Channel Destination Address Register (ch_num = 3)
	DMAC_DADDR3_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR3_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR3: DMAC Channel Descriptor Address Register (ch_num = 3)
	DMAC_DSCR3_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR3_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR3_DSCR_IF_AHB_IF0 = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR3_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR3_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR3_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA3: DMAC Channel Control A Register (ch_num = 3)
	DMAC_CTRLA3_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA3_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA3_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA3_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA3_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA3_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA3_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA3_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA3_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA3_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA3_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA3_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA3_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA3_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA3_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA3_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA3_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA3_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA3_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA3_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA3_DONE                = 0x80000000 // Bit DONE.

	// CTRLB3: DMAC Channel Control B Register (ch_num = 3)
	DMAC_CTRLB3_SIF_Pos                 = 0x0        // Position of SIF field.
	DMAC_CTRLB3_SIF_Msk                 = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB3_SIF_AHB_IF0             = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB3_SIF_AHB_IF1             = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB3_DIF_Pos                 = 0x4        // Position of DIF field.
	DMAC_CTRLB3_DIF_Msk                 = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB3_DIF_AHB_IF0             = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB3_DIF_AHB_IF1             = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB3_SRC_PIP_Pos             = 0x8        // Position of SRC_PIP field.
	DMAC_CTRLB3_SRC_PIP_Msk             = 0x100      // Bit mask of SRC_PIP field.
	DMAC_CTRLB3_SRC_PIP                 = 0x100      // Bit SRC_PIP.
	DMAC_CTRLB3_SRC_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB3_SRC_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB3_DST_PIP_Pos             = 0xc        // Position of DST_PIP field.
	DMAC_CTRLB3_DST_PIP_Msk             = 0x1000     // Bit mask of DST_PIP field.
	DMAC_CTRLB3_DST_PIP                 = 0x1000     // Bit DST_PIP.
	DMAC_CTRLB3_DST_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB3_DST_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB3_SRC_DSCR_Pos            = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB3_SRC_DSCR_Msk            = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB3_SRC_DSCR                = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB3_SRC_DSCR_FETCH_FROM_MEM = 0x0        // Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB3_SRC_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB3_DST_DSCR_Pos            = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB3_DST_DSCR_Msk            = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB3_DST_DSCR                = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB3_DST_DSCR_FETCH_FROM_MEM = 0x0        // Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB3_DST_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB3_FC_Pos                  = 0x15       // Position of FC field.
	DMAC_CTRLB3_FC_Msk                  = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB3_FC_MEM2MEM_DMA_FC       = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_MEM2PER_DMA_FC       = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2MEM_DMA_FC       = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2PER_DMA_FC       = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_SRC_INCR_Pos            = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB3_SRC_INCR_Msk            = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB3_SRC_INCR_INCREMENTING   = 0x0        // The source address is incremented
	DMAC_CTRLB3_SRC_INCR_DECREMENTING   = 0x1        // The source address is decremented
	DMAC_CTRLB3_SRC_INCR_FIXED          = 0x2        // The source address remains unchanged
	DMAC_CTRLB3_DST_INCR_Pos            = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB3_DST_INCR_Msk            = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB3_DST_INCR_INCREMENTING   = 0x0        // The destination address is incremented
	DMAC_CTRLB3_DST_INCR_DECREMENTING   = 0x1        // The destination address is decremented
	DMAC_CTRLB3_DST_INCR_FIXED          = 0x2        // The destination address remains unchanged
	DMAC_CTRLB3_IEN_Pos                 = 0x1e       // Position of IEN field.
	DMAC_CTRLB3_IEN_Msk                 = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB3_IEN                     = 0x40000000 // Bit IEN.
	DMAC_CTRLB3_AUTO_Pos                = 0x1f       // Position of AUTO field.
	DMAC_CTRLB3_AUTO_Msk                = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB3_AUTO                    = 0x80000000 // Bit AUTO.
	DMAC_CTRLB3_AUTO_DISABLE            = 0x0        // Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB3_AUTO_ENABLE             = 0x1        // Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.

	// CFG3: DMAC Channel Configuration Register (ch_num = 3)
	DMAC_CFG3_SRC_PER_Pos             = 0x0        // Position of SRC_PER field.
	DMAC_CFG3_SRC_PER_Msk             = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG3_DST_PER_Pos             = 0x4        // Position of DST_PER field.
	DMAC_CFG3_DST_PER_Msk             = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG3_SRC_REP_Pos             = 0x8        // Position of SRC_REP field.
	DMAC_CFG3_SRC_REP_Msk             = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG3_SRC_REP                 = 0x100      // Bit SRC_REP.
	DMAC_CFG3_SRC_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG3_SRC_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG3_SRC_H2SEL_Pos           = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG3_SRC_H2SEL_Msk           = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG3_SRC_H2SEL               = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG3_SRC_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_SRC_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_DST_REP_Pos             = 0xc        // Position of DST_REP field.
	DMAC_CFG3_DST_REP_Msk             = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG3_DST_REP                 = 0x1000     // Bit DST_REP.
	DMAC_CFG3_DST_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG3_DST_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG3_DST_H2SEL_Pos           = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG3_DST_H2SEL_Msk           = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG3_DST_H2SEL               = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG3_DST_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_DST_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_SOD_Pos                 = 0x10       // Position of SOD field.
	DMAC_CFG3_SOD_Msk                 = 0x10000    // Bit mask of SOD field.
	DMAC_CFG3_SOD                     = 0x10000    // Bit SOD.
	DMAC_CFG3_SOD_DISABLE             = 0x0        // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG3_SOD_ENABLE              = 0x1        // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG3_LOCK_IF_Pos             = 0x14       // Position of LOCK_IF field.
	DMAC_CFG3_LOCK_IF_Msk             = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG3_LOCK_IF                 = 0x100000   // Bit LOCK_IF.
	DMAC_CFG3_LOCK_IF_DISABLE         = 0x0        // Interface Lock capability is disabled
	DMAC_CFG3_LOCK_IF_ENABLE          = 0x1        // Interface Lock capability is enabled
	DMAC_CFG3_LOCK_B_Pos              = 0x15       // Position of LOCK_B field.
	DMAC_CFG3_LOCK_B_Msk              = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG3_LOCK_B                  = 0x200000   // Bit LOCK_B.
	DMAC_CFG3_LOCK_B_DISABLE          = 0x0        // AHB Bus Locking capability is disabled.
	DMAC_CFG3_LOCK_IF_L_Pos           = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG3_LOCK_IF_L_Msk           = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG3_LOCK_IF_L               = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG3_LOCK_IF_L_CHUNK         = 0x0        // The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG3_LOCK_IF_L_BUFFER        = 0x1        // The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG3_AHB_PROT_Pos            = 0x18       // Position of AHB_PROT field.
	DMAC_CFG3_AHB_PROT_Msk            = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG3_FIFOCFG_Pos             = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG3_FIFOCFG_Msk             = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG3_FIFOCFG_ALAP_CFG        = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG3_FIFOCFG_HALF_CFG        = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG3_FIFOCFG_ASAP_CFG        = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SPIP3: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 3)
	DMAC_SPIP3_SPIP_HOLE_Pos     = 0x0       // Position of SPIP_HOLE field.
	DMAC_SPIP3_SPIP_HOLE_Msk     = 0xffff    // Bit mask of SPIP_HOLE field.
	DMAC_SPIP3_SPIP_BOUNDARY_Pos = 0x10      // Position of SPIP_BOUNDARY field.
	DMAC_SPIP3_SPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of SPIP_BOUNDARY field.

	// DPIP3: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 3)
	DMAC_DPIP3_DPIP_HOLE_Pos     = 0x0       // Position of DPIP_HOLE field.
	DMAC_DPIP3_DPIP_HOLE_Msk     = 0xffff    // Bit mask of DPIP_HOLE field.
	DMAC_DPIP3_DPIP_BOUNDARY_Pos = 0x10      // Position of DPIP_BOUNDARY field.
	DMAC_DPIP3_DPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of DPIP_BOUNDARY field.

	// SADDR4: DMAC Channel Source Address Register (ch_num = 4)
	DMAC_SADDR4_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR4_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR4: DMAC Channel Destination Address Register (ch_num = 4)
	DMAC_DADDR4_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR4_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR4: DMAC Channel Descriptor Address Register (ch_num = 4)
	DMAC_DSCR4_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR4_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR4_DSCR_IF_AHB_IF0 = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR4_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR4_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR4_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA4: DMAC Channel Control A Register (ch_num = 4)
	DMAC_CTRLA4_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA4_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA4_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA4_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA4_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA4_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA4_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA4_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA4_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA4_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA4_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA4_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA4_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA4_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA4_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA4_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA4_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA4_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA4_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA4_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA4_DONE                = 0x80000000 // Bit DONE.

	// CTRLB4: DMAC Channel Control B Register (ch_num = 4)
	DMAC_CTRLB4_SIF_Pos                 = 0x0        // Position of SIF field.
	DMAC_CTRLB4_SIF_Msk                 = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB4_SIF_AHB_IF0             = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB4_SIF_AHB_IF1             = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB4_DIF_Pos                 = 0x4        // Position of DIF field.
	DMAC_CTRLB4_DIF_Msk                 = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB4_DIF_AHB_IF0             = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB4_DIF_AHB_IF1             = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB4_SRC_PIP_Pos             = 0x8        // Position of SRC_PIP field.
	DMAC_CTRLB4_SRC_PIP_Msk             = 0x100      // Bit mask of SRC_PIP field.
	DMAC_CTRLB4_SRC_PIP                 = 0x100      // Bit SRC_PIP.
	DMAC_CTRLB4_SRC_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB4_SRC_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB4_DST_PIP_Pos             = 0xc        // Position of DST_PIP field.
	DMAC_CTRLB4_DST_PIP_Msk             = 0x1000     // Bit mask of DST_PIP field.
	DMAC_CTRLB4_DST_PIP                 = 0x1000     // Bit DST_PIP.
	DMAC_CTRLB4_DST_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB4_DST_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB4_SRC_DSCR_Pos            = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB4_SRC_DSCR_Msk            = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB4_SRC_DSCR                = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB4_SRC_DSCR_FETCH_FROM_MEM = 0x0        // Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB4_SRC_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB4_DST_DSCR_Pos            = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB4_DST_DSCR_Msk            = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB4_DST_DSCR                = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB4_DST_DSCR_FETCH_FROM_MEM = 0x0        // Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB4_DST_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB4_FC_Pos                  = 0x15       // Position of FC field.
	DMAC_CTRLB4_FC_Msk                  = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB4_FC_MEM2MEM_DMA_FC       = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_MEM2PER_DMA_FC       = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_PER2MEM_DMA_FC       = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_PER2PER_DMA_FC       = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB4_SRC_INCR_Pos            = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB4_SRC_INCR_Msk            = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB4_SRC_INCR_INCREMENTING   = 0x0        // The source address is incremented
	DMAC_CTRLB4_SRC_INCR_DECREMENTING   = 0x1        // The source address is decremented
	DMAC_CTRLB4_SRC_INCR_FIXED          = 0x2        // The source address remains unchanged
	DMAC_CTRLB4_DST_INCR_Pos            = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB4_DST_INCR_Msk            = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB4_DST_INCR_INCREMENTING   = 0x0        // The destination address is incremented
	DMAC_CTRLB4_DST_INCR_DECREMENTING   = 0x1        // The destination address is decremented
	DMAC_CTRLB4_DST_INCR_FIXED          = 0x2        // The destination address remains unchanged
	DMAC_CTRLB4_IEN_Pos                 = 0x1e       // Position of IEN field.
	DMAC_CTRLB4_IEN_Msk                 = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB4_IEN                     = 0x40000000 // Bit IEN.
	DMAC_CTRLB4_AUTO_Pos                = 0x1f       // Position of AUTO field.
	DMAC_CTRLB4_AUTO_Msk                = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB4_AUTO                    = 0x80000000 // Bit AUTO.
	DMAC_CTRLB4_AUTO_DISABLE            = 0x0        // Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB4_AUTO_ENABLE             = 0x1        // Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.

	// CFG4: DMAC Channel Configuration Register (ch_num = 4)
	DMAC_CFG4_SRC_PER_Pos             = 0x0        // Position of SRC_PER field.
	DMAC_CFG4_SRC_PER_Msk             = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG4_DST_PER_Pos             = 0x4        // Position of DST_PER field.
	DMAC_CFG4_DST_PER_Msk             = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG4_SRC_REP_Pos             = 0x8        // Position of SRC_REP field.
	DMAC_CFG4_SRC_REP_Msk             = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG4_SRC_REP                 = 0x100      // Bit SRC_REP.
	DMAC_CFG4_SRC_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG4_SRC_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG4_SRC_H2SEL_Pos           = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG4_SRC_H2SEL_Msk           = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG4_SRC_H2SEL               = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG4_SRC_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG4_SRC_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG4_DST_REP_Pos             = 0xc        // Position of DST_REP field.
	DMAC_CFG4_DST_REP_Msk             = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG4_DST_REP                 = 0x1000     // Bit DST_REP.
	DMAC_CFG4_DST_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG4_DST_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG4_DST_H2SEL_Pos           = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG4_DST_H2SEL_Msk           = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG4_DST_H2SEL               = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG4_DST_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG4_DST_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG4_SOD_Pos                 = 0x10       // Position of SOD field.
	DMAC_CFG4_SOD_Msk                 = 0x10000    // Bit mask of SOD field.
	DMAC_CFG4_SOD                     = 0x10000    // Bit SOD.
	DMAC_CFG4_SOD_DISABLE             = 0x0        // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG4_SOD_ENABLE              = 0x1        // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG4_LOCK_IF_Pos             = 0x14       // Position of LOCK_IF field.
	DMAC_CFG4_LOCK_IF_Msk             = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG4_LOCK_IF                 = 0x100000   // Bit LOCK_IF.
	DMAC_CFG4_LOCK_IF_DISABLE         = 0x0        // Interface Lock capability is disabled
	DMAC_CFG4_LOCK_IF_ENABLE          = 0x1        // Interface Lock capability is enabled
	DMAC_CFG4_LOCK_B_Pos              = 0x15       // Position of LOCK_B field.
	DMAC_CFG4_LOCK_B_Msk              = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG4_LOCK_B                  = 0x200000   // Bit LOCK_B.
	DMAC_CFG4_LOCK_B_DISABLE          = 0x0        // AHB Bus Locking capability is disabled.
	DMAC_CFG4_LOCK_IF_L_Pos           = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG4_LOCK_IF_L_Msk           = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG4_LOCK_IF_L               = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG4_LOCK_IF_L_CHUNK         = 0x0        // The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG4_LOCK_IF_L_BUFFER        = 0x1        // The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG4_AHB_PROT_Pos            = 0x18       // Position of AHB_PROT field.
	DMAC_CFG4_AHB_PROT_Msk            = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG4_FIFOCFG_Pos             = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG4_FIFOCFG_Msk             = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG4_FIFOCFG_ALAP_CFG        = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG4_FIFOCFG_HALF_CFG        = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG4_FIFOCFG_ASAP_CFG        = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SPIP4: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 4)
	DMAC_SPIP4_SPIP_HOLE_Pos     = 0x0       // Position of SPIP_HOLE field.
	DMAC_SPIP4_SPIP_HOLE_Msk     = 0xffff    // Bit mask of SPIP_HOLE field.
	DMAC_SPIP4_SPIP_BOUNDARY_Pos = 0x10      // Position of SPIP_BOUNDARY field.
	DMAC_SPIP4_SPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of SPIP_BOUNDARY field.

	// DPIP4: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 4)
	DMAC_DPIP4_DPIP_HOLE_Pos     = 0x0       // Position of DPIP_HOLE field.
	DMAC_DPIP4_DPIP_HOLE_Msk     = 0xffff    // Bit mask of DPIP_HOLE field.
	DMAC_DPIP4_DPIP_BOUNDARY_Pos = 0x10      // Position of DPIP_BOUNDARY field.
	DMAC_DPIP4_DPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of DPIP_BOUNDARY field.

	// SADDR5: DMAC Channel Source Address Register (ch_num = 5)
	DMAC_SADDR5_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR5_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR5: DMAC Channel Destination Address Register (ch_num = 5)
	DMAC_DADDR5_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR5_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR5: DMAC Channel Descriptor Address Register (ch_num = 5)
	DMAC_DSCR5_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR5_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR5_DSCR_IF_AHB_IF0 = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR5_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR5_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR5_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA5: DMAC Channel Control A Register (ch_num = 5)
	DMAC_CTRLA5_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA5_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA5_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA5_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA5_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA5_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA5_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA5_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA5_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA5_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA5_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA5_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA5_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA5_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA5_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA5_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA5_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA5_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA5_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA5_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA5_DONE                = 0x80000000 // Bit DONE.

	// CTRLB5: DMAC Channel Control B Register (ch_num = 5)
	DMAC_CTRLB5_SIF_Pos                 = 0x0        // Position of SIF field.
	DMAC_CTRLB5_SIF_Msk                 = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB5_SIF_AHB_IF0             = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB5_SIF_AHB_IF1             = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB5_DIF_Pos                 = 0x4        // Position of DIF field.
	DMAC_CTRLB5_DIF_Msk                 = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB5_DIF_AHB_IF0             = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB5_DIF_AHB_IF1             = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB5_SRC_PIP_Pos             = 0x8        // Position of SRC_PIP field.
	DMAC_CTRLB5_SRC_PIP_Msk             = 0x100      // Bit mask of SRC_PIP field.
	DMAC_CTRLB5_SRC_PIP                 = 0x100      // Bit SRC_PIP.
	DMAC_CTRLB5_SRC_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB5_SRC_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB5_DST_PIP_Pos             = 0xc        // Position of DST_PIP field.
	DMAC_CTRLB5_DST_PIP_Msk             = 0x1000     // Bit mask of DST_PIP field.
	DMAC_CTRLB5_DST_PIP                 = 0x1000     // Bit DST_PIP.
	DMAC_CTRLB5_DST_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB5_DST_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB5_SRC_DSCR_Pos            = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB5_SRC_DSCR_Msk            = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB5_SRC_DSCR                = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB5_SRC_DSCR_FETCH_FROM_MEM = 0x0        // Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB5_SRC_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB5_DST_DSCR_Pos            = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB5_DST_DSCR_Msk            = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB5_DST_DSCR                = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB5_DST_DSCR_FETCH_FROM_MEM = 0x0        // Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB5_DST_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB5_FC_Pos                  = 0x15       // Position of FC field.
	DMAC_CTRLB5_FC_Msk                  = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB5_FC_MEM2MEM_DMA_FC       = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_MEM2PER_DMA_FC       = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_PER2MEM_DMA_FC       = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_PER2PER_DMA_FC       = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB5_SRC_INCR_Pos            = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB5_SRC_INCR_Msk            = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB5_SRC_INCR_INCREMENTING   = 0x0        // The source address is incremented
	DMAC_CTRLB5_SRC_INCR_DECREMENTING   = 0x1        // The source address is decremented
	DMAC_CTRLB5_SRC_INCR_FIXED          = 0x2        // The source address remains unchanged
	DMAC_CTRLB5_DST_INCR_Pos            = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB5_DST_INCR_Msk            = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB5_DST_INCR_INCREMENTING   = 0x0        // The destination address is incremented
	DMAC_CTRLB5_DST_INCR_DECREMENTING   = 0x1        // The destination address is decremented
	DMAC_CTRLB5_DST_INCR_FIXED          = 0x2        // The destination address remains unchanged
	DMAC_CTRLB5_IEN_Pos                 = 0x1e       // Position of IEN field.
	DMAC_CTRLB5_IEN_Msk                 = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB5_IEN                     = 0x40000000 // Bit IEN.
	DMAC_CTRLB5_AUTO_Pos                = 0x1f       // Position of AUTO field.
	DMAC_CTRLB5_AUTO_Msk                = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB5_AUTO                    = 0x80000000 // Bit AUTO.
	DMAC_CTRLB5_AUTO_DISABLE            = 0x0        // Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB5_AUTO_ENABLE             = 0x1        // Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.

	// CFG5: DMAC Channel Configuration Register (ch_num = 5)
	DMAC_CFG5_SRC_PER_Pos             = 0x0        // Position of SRC_PER field.
	DMAC_CFG5_SRC_PER_Msk             = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG5_DST_PER_Pos             = 0x4        // Position of DST_PER field.
	DMAC_CFG5_DST_PER_Msk             = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG5_SRC_REP_Pos             = 0x8        // Position of SRC_REP field.
	DMAC_CFG5_SRC_REP_Msk             = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG5_SRC_REP                 = 0x100      // Bit SRC_REP.
	DMAC_CFG5_SRC_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG5_SRC_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG5_SRC_H2SEL_Pos           = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG5_SRC_H2SEL_Msk           = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG5_SRC_H2SEL               = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG5_SRC_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG5_SRC_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG5_DST_REP_Pos             = 0xc        // Position of DST_REP field.
	DMAC_CFG5_DST_REP_Msk             = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG5_DST_REP                 = 0x1000     // Bit DST_REP.
	DMAC_CFG5_DST_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG5_DST_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG5_DST_H2SEL_Pos           = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG5_DST_H2SEL_Msk           = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG5_DST_H2SEL               = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG5_DST_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG5_DST_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG5_SOD_Pos                 = 0x10       // Position of SOD field.
	DMAC_CFG5_SOD_Msk                 = 0x10000    // Bit mask of SOD field.
	DMAC_CFG5_SOD                     = 0x10000    // Bit SOD.
	DMAC_CFG5_SOD_DISABLE             = 0x0        // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG5_SOD_ENABLE              = 0x1        // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG5_LOCK_IF_Pos             = 0x14       // Position of LOCK_IF field.
	DMAC_CFG5_LOCK_IF_Msk             = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG5_LOCK_IF                 = 0x100000   // Bit LOCK_IF.
	DMAC_CFG5_LOCK_IF_DISABLE         = 0x0        // Interface Lock capability is disabled
	DMAC_CFG5_LOCK_IF_ENABLE          = 0x1        // Interface Lock capability is enabled
	DMAC_CFG5_LOCK_B_Pos              = 0x15       // Position of LOCK_B field.
	DMAC_CFG5_LOCK_B_Msk              = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG5_LOCK_B                  = 0x200000   // Bit LOCK_B.
	DMAC_CFG5_LOCK_B_DISABLE          = 0x0        // AHB Bus Locking capability is disabled.
	DMAC_CFG5_LOCK_IF_L_Pos           = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG5_LOCK_IF_L_Msk           = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG5_LOCK_IF_L               = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG5_LOCK_IF_L_CHUNK         = 0x0        // The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG5_LOCK_IF_L_BUFFER        = 0x1        // The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG5_AHB_PROT_Pos            = 0x18       // Position of AHB_PROT field.
	DMAC_CFG5_AHB_PROT_Msk            = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG5_FIFOCFG_Pos             = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG5_FIFOCFG_Msk             = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG5_FIFOCFG_ALAP_CFG        = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG5_FIFOCFG_HALF_CFG        = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG5_FIFOCFG_ASAP_CFG        = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SPIP5: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 5)
	DMAC_SPIP5_SPIP_HOLE_Pos     = 0x0       // Position of SPIP_HOLE field.
	DMAC_SPIP5_SPIP_HOLE_Msk     = 0xffff    // Bit mask of SPIP_HOLE field.
	DMAC_SPIP5_SPIP_BOUNDARY_Pos = 0x10      // Position of SPIP_BOUNDARY field.
	DMAC_SPIP5_SPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of SPIP_BOUNDARY field.

	// DPIP5: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 5)
	DMAC_DPIP5_DPIP_HOLE_Pos     = 0x0       // Position of DPIP_HOLE field.
	DMAC_DPIP5_DPIP_HOLE_Msk     = 0xffff    // Bit mask of DPIP_HOLE field.
	DMAC_DPIP5_DPIP_BOUNDARY_Pos = 0x10      // Position of DPIP_BOUNDARY field.
	DMAC_DPIP5_DPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of DPIP_BOUNDARY field.

	// SADDR6: DMAC Channel Source Address Register (ch_num = 6)
	DMAC_SADDR6_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR6_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR6: DMAC Channel Destination Address Register (ch_num = 6)
	DMAC_DADDR6_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR6_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR6: DMAC Channel Descriptor Address Register (ch_num = 6)
	DMAC_DSCR6_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR6_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR6_DSCR_IF_AHB_IF0 = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR6_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR6_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR6_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA6: DMAC Channel Control A Register (ch_num = 6)
	DMAC_CTRLA6_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA6_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA6_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA6_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA6_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA6_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA6_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA6_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA6_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA6_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA6_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA6_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA6_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA6_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA6_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA6_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA6_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA6_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA6_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA6_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA6_DONE                = 0x80000000 // Bit DONE.

	// CTRLB6: DMAC Channel Control B Register (ch_num = 6)
	DMAC_CTRLB6_SIF_Pos                 = 0x0        // Position of SIF field.
	DMAC_CTRLB6_SIF_Msk                 = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB6_SIF_AHB_IF0             = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB6_SIF_AHB_IF1             = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB6_DIF_Pos                 = 0x4        // Position of DIF field.
	DMAC_CTRLB6_DIF_Msk                 = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB6_DIF_AHB_IF0             = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB6_DIF_AHB_IF1             = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB6_SRC_PIP_Pos             = 0x8        // Position of SRC_PIP field.
	DMAC_CTRLB6_SRC_PIP_Msk             = 0x100      // Bit mask of SRC_PIP field.
	DMAC_CTRLB6_SRC_PIP                 = 0x100      // Bit SRC_PIP.
	DMAC_CTRLB6_SRC_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB6_SRC_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB6_DST_PIP_Pos             = 0xc        // Position of DST_PIP field.
	DMAC_CTRLB6_DST_PIP_Msk             = 0x1000     // Bit mask of DST_PIP field.
	DMAC_CTRLB6_DST_PIP                 = 0x1000     // Bit DST_PIP.
	DMAC_CTRLB6_DST_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB6_DST_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB6_SRC_DSCR_Pos            = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB6_SRC_DSCR_Msk            = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB6_SRC_DSCR                = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB6_SRC_DSCR_FETCH_FROM_MEM = 0x0        // Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB6_SRC_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB6_DST_DSCR_Pos            = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB6_DST_DSCR_Msk            = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB6_DST_DSCR                = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB6_DST_DSCR_FETCH_FROM_MEM = 0x0        // Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB6_DST_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB6_FC_Pos                  = 0x15       // Position of FC field.
	DMAC_CTRLB6_FC_Msk                  = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB6_FC_MEM2MEM_DMA_FC       = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_MEM2PER_DMA_FC       = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_PER2MEM_DMA_FC       = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_PER2PER_DMA_FC       = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB6_SRC_INCR_Pos            = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB6_SRC_INCR_Msk            = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB6_SRC_INCR_INCREMENTING   = 0x0        // The source address is incremented
	DMAC_CTRLB6_SRC_INCR_DECREMENTING   = 0x1        // The source address is decremented
	DMAC_CTRLB6_SRC_INCR_FIXED          = 0x2        // The source address remains unchanged
	DMAC_CTRLB6_DST_INCR_Pos            = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB6_DST_INCR_Msk            = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB6_DST_INCR_INCREMENTING   = 0x0        // The destination address is incremented
	DMAC_CTRLB6_DST_INCR_DECREMENTING   = 0x1        // The destination address is decremented
	DMAC_CTRLB6_DST_INCR_FIXED          = 0x2        // The destination address remains unchanged
	DMAC_CTRLB6_IEN_Pos                 = 0x1e       // Position of IEN field.
	DMAC_CTRLB6_IEN_Msk                 = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB6_IEN                     = 0x40000000 // Bit IEN.
	DMAC_CTRLB6_AUTO_Pos                = 0x1f       // Position of AUTO field.
	DMAC_CTRLB6_AUTO_Msk                = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB6_AUTO                    = 0x80000000 // Bit AUTO.
	DMAC_CTRLB6_AUTO_DISABLE            = 0x0        // Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB6_AUTO_ENABLE             = 0x1        // Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.

	// CFG6: DMAC Channel Configuration Register (ch_num = 6)
	DMAC_CFG6_SRC_PER_Pos             = 0x0        // Position of SRC_PER field.
	DMAC_CFG6_SRC_PER_Msk             = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG6_DST_PER_Pos             = 0x4        // Position of DST_PER field.
	DMAC_CFG6_DST_PER_Msk             = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG6_SRC_REP_Pos             = 0x8        // Position of SRC_REP field.
	DMAC_CFG6_SRC_REP_Msk             = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG6_SRC_REP                 = 0x100      // Bit SRC_REP.
	DMAC_CFG6_SRC_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG6_SRC_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG6_SRC_H2SEL_Pos           = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG6_SRC_H2SEL_Msk           = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG6_SRC_H2SEL               = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG6_SRC_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG6_SRC_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG6_DST_REP_Pos             = 0xc        // Position of DST_REP field.
	DMAC_CFG6_DST_REP_Msk             = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG6_DST_REP                 = 0x1000     // Bit DST_REP.
	DMAC_CFG6_DST_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG6_DST_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG6_DST_H2SEL_Pos           = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG6_DST_H2SEL_Msk           = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG6_DST_H2SEL               = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG6_DST_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG6_DST_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG6_SOD_Pos                 = 0x10       // Position of SOD field.
	DMAC_CFG6_SOD_Msk                 = 0x10000    // Bit mask of SOD field.
	DMAC_CFG6_SOD                     = 0x10000    // Bit SOD.
	DMAC_CFG6_SOD_DISABLE             = 0x0        // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG6_SOD_ENABLE              = 0x1        // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG6_LOCK_IF_Pos             = 0x14       // Position of LOCK_IF field.
	DMAC_CFG6_LOCK_IF_Msk             = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG6_LOCK_IF                 = 0x100000   // Bit LOCK_IF.
	DMAC_CFG6_LOCK_IF_DISABLE         = 0x0        // Interface Lock capability is disabled
	DMAC_CFG6_LOCK_IF_ENABLE          = 0x1        // Interface Lock capability is enabled
	DMAC_CFG6_LOCK_B_Pos              = 0x15       // Position of LOCK_B field.
	DMAC_CFG6_LOCK_B_Msk              = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG6_LOCK_B                  = 0x200000   // Bit LOCK_B.
	DMAC_CFG6_LOCK_B_DISABLE          = 0x0        // AHB Bus Locking capability is disabled.
	DMAC_CFG6_LOCK_IF_L_Pos           = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG6_LOCK_IF_L_Msk           = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG6_LOCK_IF_L               = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG6_LOCK_IF_L_CHUNK         = 0x0        // The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG6_LOCK_IF_L_BUFFER        = 0x1        // The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG6_AHB_PROT_Pos            = 0x18       // Position of AHB_PROT field.
	DMAC_CFG6_AHB_PROT_Msk            = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG6_FIFOCFG_Pos             = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG6_FIFOCFG_Msk             = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG6_FIFOCFG_ALAP_CFG        = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG6_FIFOCFG_HALF_CFG        = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG6_FIFOCFG_ASAP_CFG        = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SPIP6: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 6)
	DMAC_SPIP6_SPIP_HOLE_Pos     = 0x0       // Position of SPIP_HOLE field.
	DMAC_SPIP6_SPIP_HOLE_Msk     = 0xffff    // Bit mask of SPIP_HOLE field.
	DMAC_SPIP6_SPIP_BOUNDARY_Pos = 0x10      // Position of SPIP_BOUNDARY field.
	DMAC_SPIP6_SPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of SPIP_BOUNDARY field.

	// DPIP6: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 6)
	DMAC_DPIP6_DPIP_HOLE_Pos     = 0x0       // Position of DPIP_HOLE field.
	DMAC_DPIP6_DPIP_HOLE_Msk     = 0xffff    // Bit mask of DPIP_HOLE field.
	DMAC_DPIP6_DPIP_BOUNDARY_Pos = 0x10      // Position of DPIP_BOUNDARY field.
	DMAC_DPIP6_DPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of DPIP_BOUNDARY field.

	// SADDR7: DMAC Channel Source Address Register (ch_num = 7)
	DMAC_SADDR7_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR7_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR7: DMAC Channel Destination Address Register (ch_num = 7)
	DMAC_DADDR7_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR7_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR7: DMAC Channel Descriptor Address Register (ch_num = 7)
	DMAC_DSCR7_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR7_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR7_DSCR_IF_AHB_IF0 = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR7_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR7_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR7_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA7: DMAC Channel Control A Register (ch_num = 7)
	DMAC_CTRLA7_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA7_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA7_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA7_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA7_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA7_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA7_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA7_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA7_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA7_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA7_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA7_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA7_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA7_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA7_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA7_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA7_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA7_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA7_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA7_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA7_DONE                = 0x80000000 // Bit DONE.

	// CTRLB7: DMAC Channel Control B Register (ch_num = 7)
	DMAC_CTRLB7_SIF_Pos                 = 0x0        // Position of SIF field.
	DMAC_CTRLB7_SIF_Msk                 = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB7_SIF_AHB_IF0             = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB7_SIF_AHB_IF1             = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB7_DIF_Pos                 = 0x4        // Position of DIF field.
	DMAC_CTRLB7_DIF_Msk                 = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB7_DIF_AHB_IF0             = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB7_DIF_AHB_IF1             = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB7_SRC_PIP_Pos             = 0x8        // Position of SRC_PIP field.
	DMAC_CTRLB7_SRC_PIP_Msk             = 0x100      // Bit mask of SRC_PIP field.
	DMAC_CTRLB7_SRC_PIP                 = 0x100      // Bit SRC_PIP.
	DMAC_CTRLB7_SRC_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB7_SRC_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB7_DST_PIP_Pos             = 0xc        // Position of DST_PIP field.
	DMAC_CTRLB7_DST_PIP_Msk             = 0x1000     // Bit mask of DST_PIP field.
	DMAC_CTRLB7_DST_PIP                 = 0x1000     // Bit DST_PIP.
	DMAC_CTRLB7_DST_PIP_DISABLE         = 0x0        // Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB7_DST_PIP_ENABLE          = 0x1        // Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB7_SRC_DSCR_Pos            = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB7_SRC_DSCR_Msk            = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB7_SRC_DSCR                = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB7_SRC_DSCR_FETCH_FROM_MEM = 0x0        // Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB7_SRC_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB7_DST_DSCR_Pos            = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB7_DST_DSCR_Msk            = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB7_DST_DSCR                = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB7_DST_DSCR_FETCH_FROM_MEM = 0x0        // Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB7_DST_DSCR_FETCH_DISABLE  = 0x1        // Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB7_FC_Pos                  = 0x15       // Position of FC field.
	DMAC_CTRLB7_FC_Msk                  = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB7_FC_MEM2MEM_DMA_FC       = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_MEM2PER_DMA_FC       = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_PER2MEM_DMA_FC       = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_PER2PER_DMA_FC       = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB7_SRC_INCR_Pos            = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB7_SRC_INCR_Msk            = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB7_SRC_INCR_INCREMENTING   = 0x0        // The source address is incremented
	DMAC_CTRLB7_SRC_INCR_DECREMENTING   = 0x1        // The source address is decremented
	DMAC_CTRLB7_SRC_INCR_FIXED          = 0x2        // The source address remains unchanged
	DMAC_CTRLB7_DST_INCR_Pos            = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB7_DST_INCR_Msk            = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB7_DST_INCR_INCREMENTING   = 0x0        // The destination address is incremented
	DMAC_CTRLB7_DST_INCR_DECREMENTING   = 0x1        // The destination address is decremented
	DMAC_CTRLB7_DST_INCR_FIXED          = 0x2        // The destination address remains unchanged
	DMAC_CTRLB7_IEN_Pos                 = 0x1e       // Position of IEN field.
	DMAC_CTRLB7_IEN_Msk                 = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB7_IEN                     = 0x40000000 // Bit IEN.
	DMAC_CTRLB7_AUTO_Pos                = 0x1f       // Position of AUTO field.
	DMAC_CTRLB7_AUTO_Msk                = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB7_AUTO                    = 0x80000000 // Bit AUTO.
	DMAC_CTRLB7_AUTO_DISABLE            = 0x0        // Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB7_AUTO_ENABLE             = 0x1        // Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.

	// CFG7: DMAC Channel Configuration Register (ch_num = 7)
	DMAC_CFG7_SRC_PER_Pos             = 0x0        // Position of SRC_PER field.
	DMAC_CFG7_SRC_PER_Msk             = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG7_DST_PER_Pos             = 0x4        // Position of DST_PER field.
	DMAC_CFG7_DST_PER_Msk             = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG7_SRC_REP_Pos             = 0x8        // Position of SRC_REP field.
	DMAC_CFG7_SRC_REP_Msk             = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG7_SRC_REP                 = 0x100      // Bit SRC_REP.
	DMAC_CFG7_SRC_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG7_SRC_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG7_SRC_H2SEL_Pos           = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG7_SRC_H2SEL_Msk           = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG7_SRC_H2SEL               = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG7_SRC_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG7_SRC_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG7_DST_REP_Pos             = 0xc        // Position of DST_REP field.
	DMAC_CFG7_DST_REP_Msk             = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG7_DST_REP                 = 0x1000     // Bit DST_REP.
	DMAC_CFG7_DST_REP_CONTIGUOUS_ADDR = 0x0        // When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG7_DST_REP_RELOAD_ADDR     = 0x1        // When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG7_DST_H2SEL_Pos           = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG7_DST_H2SEL_Msk           = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG7_DST_H2SEL               = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG7_DST_H2SEL_SW            = 0x0        // Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG7_DST_H2SEL_HW            = 0x1        // Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG7_SOD_Pos                 = 0x10       // Position of SOD field.
	DMAC_CFG7_SOD_Msk                 = 0x10000    // Bit mask of SOD field.
	DMAC_CFG7_SOD                     = 0x10000    // Bit SOD.
	DMAC_CFG7_SOD_DISABLE             = 0x0        // STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG7_SOD_ENABLE              = 0x1        // STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG7_LOCK_IF_Pos             = 0x14       // Position of LOCK_IF field.
	DMAC_CFG7_LOCK_IF_Msk             = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG7_LOCK_IF                 = 0x100000   // Bit LOCK_IF.
	DMAC_CFG7_LOCK_IF_DISABLE         = 0x0        // Interface Lock capability is disabled
	DMAC_CFG7_LOCK_IF_ENABLE          = 0x1        // Interface Lock capability is enabled
	DMAC_CFG7_LOCK_B_Pos              = 0x15       // Position of LOCK_B field.
	DMAC_CFG7_LOCK_B_Msk              = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG7_LOCK_B                  = 0x200000   // Bit LOCK_B.
	DMAC_CFG7_LOCK_B_DISABLE          = 0x0        // AHB Bus Locking capability is disabled.
	DMAC_CFG7_LOCK_IF_L_Pos           = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG7_LOCK_IF_L_Msk           = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG7_LOCK_IF_L               = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG7_LOCK_IF_L_CHUNK         = 0x0        // The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG7_LOCK_IF_L_BUFFER        = 0x1        // The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG7_AHB_PROT_Pos            = 0x18       // Position of AHB_PROT field.
	DMAC_CFG7_AHB_PROT_Msk            = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG7_FIFOCFG_Pos             = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG7_FIFOCFG_Msk             = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG7_FIFOCFG_ALAP_CFG        = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG7_FIFOCFG_HALF_CFG        = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG7_FIFOCFG_ASAP_CFG        = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SPIP7: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 7)
	DMAC_SPIP7_SPIP_HOLE_Pos     = 0x0       // Position of SPIP_HOLE field.
	DMAC_SPIP7_SPIP_HOLE_Msk     = 0xffff    // Bit mask of SPIP_HOLE field.
	DMAC_SPIP7_SPIP_BOUNDARY_Pos = 0x10      // Position of SPIP_BOUNDARY field.
	DMAC_SPIP7_SPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of SPIP_BOUNDARY field.

	// DPIP7: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 7)
	DMAC_DPIP7_DPIP_HOLE_Pos     = 0x0       // Position of DPIP_HOLE field.
	DMAC_DPIP7_DPIP_HOLE_Msk     = 0xffff    // Bit mask of DPIP_HOLE field.
	DMAC_DPIP7_DPIP_BOUNDARY_Pos = 0x10      // Position of DPIP_BOUNDARY field.
	DMAC_DPIP7_DPIP_BOUNDARY_Msk = 0x3ff0000 // Bit mask of DPIP_BOUNDARY field.

	// WPMR: DMAC Write Protect Mode Register
	DMAC_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	DMAC_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	DMAC_WPMR_WPEN      = 0x1        // Bit WPEN.
	DMAC_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	DMAC_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: DMAC Write Protect Status Register
	DMAC_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	DMAC_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	DMAC_WPSR_WPVS       = 0x1      // Bit WPVS.
	DMAC_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	DMAC_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for AIC: Advanced Interrupt Controller
const (
	// SMR: Source Mode Register
	AIC_SMR_PRIOR_Pos                   = 0x0  // Position of PRIOR field.
	AIC_SMR_PRIOR_Msk                   = 0x7  // Bit mask of PRIOR field.
	AIC_SMR_SRCTYPE_Pos                 = 0x5  // Position of SRCTYPE field.
	AIC_SMR_SRCTYPE_Msk                 = 0x60 // Bit mask of SRCTYPE field.
	AIC_SMR_SRCTYPE_INT_LEVEL_SENSITIVE = 0x0  // High level Sensitive for internal sourceLow level Sensitive for external source
	AIC_SMR_SRCTYPE_INT_EDGE_TRIGGERED  = 0x1  // Positive edge triggered for internal sourceNegative edge triggered for external source
	AIC_SMR_SRCTYPE_EXT_HIGH_LEVEL      = 0x2  // High level Sensitive for internal sourceHigh level Sensitive for external source
	AIC_SMR_SRCTYPE_EXT_POSITIVE_EDGE   = 0x3  // Positive edge triggered for internal sourcePositive edge triggered for external source

	// SVR: Source Vector Register
	AIC_SVR_VECTOR_Pos = 0x0        // Position of VECTOR field.
	AIC_SVR_VECTOR_Msk = 0xffffffff // Bit mask of VECTOR field.

	// IVR: Interrupt Vector Register
	AIC_IVR_IRQV_Pos = 0x0        // Position of IRQV field.
	AIC_IVR_IRQV_Msk = 0xffffffff // Bit mask of IRQV field.

	// FVR: FIQ Interrupt Vector Register
	AIC_FVR_FIQV_Pos = 0x0        // Position of FIQV field.
	AIC_FVR_FIQV_Msk = 0xffffffff // Bit mask of FIQV field.

	// ISR: Interrupt Status Register
	AIC_ISR_IRQID_Pos = 0x0  // Position of IRQID field.
	AIC_ISR_IRQID_Msk = 0x1f // Bit mask of IRQID field.

	// IPR: Interrupt Pending Register
	AIC_IPR_FIQ_Pos   = 0x0        // Position of FIQ field.
	AIC_IPR_FIQ_Msk   = 0x1        // Bit mask of FIQ field.
	AIC_IPR_FIQ       = 0x1        // Bit FIQ.
	AIC_IPR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_IPR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_IPR_SYS       = 0x2        // Bit SYS.
	AIC_IPR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_IPR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_IPR_PID2      = 0x4        // Bit PID2.
	AIC_IPR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_IPR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_IPR_PID3      = 0x8        // Bit PID3.
	AIC_IPR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_IPR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_IPR_PID4      = 0x10       // Bit PID4.
	AIC_IPR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_IPR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_IPR_PID5      = 0x20       // Bit PID5.
	AIC_IPR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_IPR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_IPR_PID6      = 0x40       // Bit PID6.
	AIC_IPR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_IPR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_IPR_PID7      = 0x80       // Bit PID7.
	AIC_IPR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_IPR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_IPR_PID8      = 0x100      // Bit PID8.
	AIC_IPR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_IPR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_IPR_PID9      = 0x200      // Bit PID9.
	AIC_IPR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_IPR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_IPR_PID10     = 0x400      // Bit PID10.
	AIC_IPR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_IPR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_IPR_PID11     = 0x800      // Bit PID11.
	AIC_IPR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_IPR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_IPR_PID12     = 0x1000     // Bit PID12.
	AIC_IPR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_IPR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_IPR_PID13     = 0x2000     // Bit PID13.
	AIC_IPR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_IPR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_IPR_PID14     = 0x4000     // Bit PID14.
	AIC_IPR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_IPR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_IPR_PID15     = 0x8000     // Bit PID15.
	AIC_IPR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_IPR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_IPR_PID16     = 0x10000    // Bit PID16.
	AIC_IPR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_IPR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_IPR_PID17     = 0x20000    // Bit PID17.
	AIC_IPR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_IPR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_IPR_PID18     = 0x40000    // Bit PID18.
	AIC_IPR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_IPR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_IPR_PID19     = 0x80000    // Bit PID19.
	AIC_IPR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_IPR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_IPR_PID20     = 0x100000   // Bit PID20.
	AIC_IPR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_IPR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_IPR_PID21     = 0x200000   // Bit PID21.
	AIC_IPR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_IPR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_IPR_PID22     = 0x400000   // Bit PID22.
	AIC_IPR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_IPR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_IPR_PID23     = 0x800000   // Bit PID23.
	AIC_IPR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_IPR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_IPR_PID24     = 0x1000000  // Bit PID24.
	AIC_IPR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_IPR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_IPR_PID25     = 0x2000000  // Bit PID25.
	AIC_IPR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_IPR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_IPR_PID26     = 0x4000000  // Bit PID26.
	AIC_IPR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_IPR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_IPR_PID27     = 0x8000000  // Bit PID27.
	AIC_IPR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_IPR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_IPR_PID28     = 0x10000000 // Bit PID28.
	AIC_IPR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_IPR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_IPR_PID29     = 0x20000000 // Bit PID29.
	AIC_IPR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_IPR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_IPR_PID30     = 0x40000000 // Bit PID30.
	AIC_IPR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_IPR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_IPR_PID31     = 0x80000000 // Bit PID31.

	// IMR: Interrupt Mask Register
	AIC_IMR_FIQ_Pos   = 0x0        // Position of FIQ field.
	AIC_IMR_FIQ_Msk   = 0x1        // Bit mask of FIQ field.
	AIC_IMR_FIQ       = 0x1        // Bit FIQ.
	AIC_IMR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_IMR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_IMR_SYS       = 0x2        // Bit SYS.
	AIC_IMR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_IMR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_IMR_PID2      = 0x4        // Bit PID2.
	AIC_IMR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_IMR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_IMR_PID3      = 0x8        // Bit PID3.
	AIC_IMR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_IMR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_IMR_PID4      = 0x10       // Bit PID4.
	AIC_IMR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_IMR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_IMR_PID5      = 0x20       // Bit PID5.
	AIC_IMR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_IMR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_IMR_PID6      = 0x40       // Bit PID6.
	AIC_IMR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_IMR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_IMR_PID7      = 0x80       // Bit PID7.
	AIC_IMR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_IMR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_IMR_PID8      = 0x100      // Bit PID8.
	AIC_IMR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_IMR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_IMR_PID9      = 0x200      // Bit PID9.
	AIC_IMR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_IMR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_IMR_PID10     = 0x400      // Bit PID10.
	AIC_IMR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_IMR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_IMR_PID11     = 0x800      // Bit PID11.
	AIC_IMR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_IMR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_IMR_PID12     = 0x1000     // Bit PID12.
	AIC_IMR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_IMR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_IMR_PID13     = 0x2000     // Bit PID13.
	AIC_IMR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_IMR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_IMR_PID14     = 0x4000     // Bit PID14.
	AIC_IMR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_IMR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_IMR_PID15     = 0x8000     // Bit PID15.
	AIC_IMR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_IMR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_IMR_PID16     = 0x10000    // Bit PID16.
	AIC_IMR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_IMR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_IMR_PID17     = 0x20000    // Bit PID17.
	AIC_IMR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_IMR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_IMR_PID18     = 0x40000    // Bit PID18.
	AIC_IMR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_IMR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_IMR_PID19     = 0x80000    // Bit PID19.
	AIC_IMR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_IMR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_IMR_PID20     = 0x100000   // Bit PID20.
	AIC_IMR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_IMR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_IMR_PID21     = 0x200000   // Bit PID21.
	AIC_IMR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_IMR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_IMR_PID22     = 0x400000   // Bit PID22.
	AIC_IMR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_IMR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_IMR_PID23     = 0x800000   // Bit PID23.
	AIC_IMR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_IMR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_IMR_PID24     = 0x1000000  // Bit PID24.
	AIC_IMR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_IMR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_IMR_PID25     = 0x2000000  // Bit PID25.
	AIC_IMR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_IMR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_IMR_PID26     = 0x4000000  // Bit PID26.
	AIC_IMR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_IMR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_IMR_PID27     = 0x8000000  // Bit PID27.
	AIC_IMR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_IMR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_IMR_PID28     = 0x10000000 // Bit PID28.
	AIC_IMR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_IMR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_IMR_PID29     = 0x20000000 // Bit PID29.
	AIC_IMR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_IMR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_IMR_PID30     = 0x40000000 // Bit PID30.
	AIC_IMR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_IMR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_IMR_PID31     = 0x80000000 // Bit PID31.

	// CISR: Core Interrupt Status Register
	AIC_CISR_NFIQ_Pos = 0x0 // Position of NFIQ field.
	AIC_CISR_NFIQ_Msk = 0x1 // Bit mask of NFIQ field.
	AIC_CISR_NFIQ     = 0x1 // Bit NFIQ.
	AIC_CISR_NIRQ_Pos = 0x1 // Position of NIRQ field.
	AIC_CISR_NIRQ_Msk = 0x2 // Bit mask of NIRQ field.
	AIC_CISR_NIRQ     = 0x2 // Bit NIRQ.

	// IECR: Interrupt Enable Command Register
	AIC_IECR_FIQ_Pos   = 0x0        // Position of FIQ field.
	AIC_IECR_FIQ_Msk   = 0x1        // Bit mask of FIQ field.
	AIC_IECR_FIQ       = 0x1        // Bit FIQ.
	AIC_IECR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_IECR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_IECR_SYS       = 0x2        // Bit SYS.
	AIC_IECR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_IECR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_IECR_PID2      = 0x4        // Bit PID2.
	AIC_IECR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_IECR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_IECR_PID3      = 0x8        // Bit PID3.
	AIC_IECR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_IECR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_IECR_PID4      = 0x10       // Bit PID4.
	AIC_IECR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_IECR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_IECR_PID5      = 0x20       // Bit PID5.
	AIC_IECR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_IECR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_IECR_PID6      = 0x40       // Bit PID6.
	AIC_IECR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_IECR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_IECR_PID7      = 0x80       // Bit PID7.
	AIC_IECR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_IECR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_IECR_PID8      = 0x100      // Bit PID8.
	AIC_IECR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_IECR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_IECR_PID9      = 0x200      // Bit PID9.
	AIC_IECR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_IECR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_IECR_PID10     = 0x400      // Bit PID10.
	AIC_IECR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_IECR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_IECR_PID11     = 0x800      // Bit PID11.
	AIC_IECR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_IECR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_IECR_PID12     = 0x1000     // Bit PID12.
	AIC_IECR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_IECR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_IECR_PID13     = 0x2000     // Bit PID13.
	AIC_IECR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_IECR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_IECR_PID14     = 0x4000     // Bit PID14.
	AIC_IECR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_IECR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_IECR_PID15     = 0x8000     // Bit PID15.
	AIC_IECR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_IECR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_IECR_PID16     = 0x10000    // Bit PID16.
	AIC_IECR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_IECR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_IECR_PID17     = 0x20000    // Bit PID17.
	AIC_IECR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_IECR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_IECR_PID18     = 0x40000    // Bit PID18.
	AIC_IECR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_IECR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_IECR_PID19     = 0x80000    // Bit PID19.
	AIC_IECR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_IECR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_IECR_PID20     = 0x100000   // Bit PID20.
	AIC_IECR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_IECR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_IECR_PID21     = 0x200000   // Bit PID21.
	AIC_IECR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_IECR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_IECR_PID22     = 0x400000   // Bit PID22.
	AIC_IECR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_IECR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_IECR_PID23     = 0x800000   // Bit PID23.
	AIC_IECR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_IECR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_IECR_PID24     = 0x1000000  // Bit PID24.
	AIC_IECR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_IECR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_IECR_PID25     = 0x2000000  // Bit PID25.
	AIC_IECR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_IECR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_IECR_PID26     = 0x4000000  // Bit PID26.
	AIC_IECR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_IECR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_IECR_PID27     = 0x8000000  // Bit PID27.
	AIC_IECR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_IECR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_IECR_PID28     = 0x10000000 // Bit PID28.
	AIC_IECR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_IECR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_IECR_PID29     = 0x20000000 // Bit PID29.
	AIC_IECR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_IECR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_IECR_PID30     = 0x40000000 // Bit PID30.
	AIC_IECR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_IECR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_IECR_PID31     = 0x80000000 // Bit PID31.

	// IDCR: Interrupt Disable Command Register
	AIC_IDCR_FIQ_Pos   = 0x0        // Position of FIQ field.
	AIC_IDCR_FIQ_Msk   = 0x1        // Bit mask of FIQ field.
	AIC_IDCR_FIQ       = 0x1        // Bit FIQ.
	AIC_IDCR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_IDCR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_IDCR_SYS       = 0x2        // Bit SYS.
	AIC_IDCR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_IDCR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_IDCR_PID2      = 0x4        // Bit PID2.
	AIC_IDCR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_IDCR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_IDCR_PID3      = 0x8        // Bit PID3.
	AIC_IDCR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_IDCR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_IDCR_PID4      = 0x10       // Bit PID4.
	AIC_IDCR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_IDCR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_IDCR_PID5      = 0x20       // Bit PID5.
	AIC_IDCR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_IDCR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_IDCR_PID6      = 0x40       // Bit PID6.
	AIC_IDCR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_IDCR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_IDCR_PID7      = 0x80       // Bit PID7.
	AIC_IDCR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_IDCR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_IDCR_PID8      = 0x100      // Bit PID8.
	AIC_IDCR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_IDCR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_IDCR_PID9      = 0x200      // Bit PID9.
	AIC_IDCR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_IDCR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_IDCR_PID10     = 0x400      // Bit PID10.
	AIC_IDCR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_IDCR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_IDCR_PID11     = 0x800      // Bit PID11.
	AIC_IDCR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_IDCR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_IDCR_PID12     = 0x1000     // Bit PID12.
	AIC_IDCR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_IDCR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_IDCR_PID13     = 0x2000     // Bit PID13.
	AIC_IDCR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_IDCR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_IDCR_PID14     = 0x4000     // Bit PID14.
	AIC_IDCR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_IDCR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_IDCR_PID15     = 0x8000     // Bit PID15.
	AIC_IDCR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_IDCR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_IDCR_PID16     = 0x10000    // Bit PID16.
	AIC_IDCR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_IDCR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_IDCR_PID17     = 0x20000    // Bit PID17.
	AIC_IDCR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_IDCR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_IDCR_PID18     = 0x40000    // Bit PID18.
	AIC_IDCR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_IDCR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_IDCR_PID19     = 0x80000    // Bit PID19.
	AIC_IDCR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_IDCR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_IDCR_PID20     = 0x100000   // Bit PID20.
	AIC_IDCR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_IDCR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_IDCR_PID21     = 0x200000   // Bit PID21.
	AIC_IDCR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_IDCR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_IDCR_PID22     = 0x400000   // Bit PID22.
	AIC_IDCR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_IDCR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_IDCR_PID23     = 0x800000   // Bit PID23.
	AIC_IDCR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_IDCR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_IDCR_PID24     = 0x1000000  // Bit PID24.
	AIC_IDCR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_IDCR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_IDCR_PID25     = 0x2000000  // Bit PID25.
	AIC_IDCR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_IDCR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_IDCR_PID26     = 0x4000000  // Bit PID26.
	AIC_IDCR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_IDCR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_IDCR_PID27     = 0x8000000  // Bit PID27.
	AIC_IDCR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_IDCR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_IDCR_PID28     = 0x10000000 // Bit PID28.
	AIC_IDCR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_IDCR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_IDCR_PID29     = 0x20000000 // Bit PID29.
	AIC_IDCR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_IDCR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_IDCR_PID30     = 0x40000000 // Bit PID30.
	AIC_IDCR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_IDCR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_IDCR_PID31     = 0x80000000 // Bit PID31.

	// ICCR: Interrupt Clear Command Register
	AIC_ICCR_FIQ_Pos   = 0x0        // Position of FIQ field.
	AIC_ICCR_FIQ_Msk   = 0x1        // Bit mask of FIQ field.
	AIC_ICCR_FIQ       = 0x1        // Bit FIQ.
	AIC_ICCR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_ICCR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_ICCR_SYS       = 0x2        // Bit SYS.
	AIC_ICCR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_ICCR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_ICCR_PID2      = 0x4        // Bit PID2.
	AIC_ICCR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_ICCR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_ICCR_PID3      = 0x8        // Bit PID3.
	AIC_ICCR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_ICCR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_ICCR_PID4      = 0x10       // Bit PID4.
	AIC_ICCR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_ICCR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_ICCR_PID5      = 0x20       // Bit PID5.
	AIC_ICCR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_ICCR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_ICCR_PID6      = 0x40       // Bit PID6.
	AIC_ICCR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_ICCR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_ICCR_PID7      = 0x80       // Bit PID7.
	AIC_ICCR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_ICCR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_ICCR_PID8      = 0x100      // Bit PID8.
	AIC_ICCR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_ICCR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_ICCR_PID9      = 0x200      // Bit PID9.
	AIC_ICCR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_ICCR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_ICCR_PID10     = 0x400      // Bit PID10.
	AIC_ICCR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_ICCR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_ICCR_PID11     = 0x800      // Bit PID11.
	AIC_ICCR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_ICCR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_ICCR_PID12     = 0x1000     // Bit PID12.
	AIC_ICCR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_ICCR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_ICCR_PID13     = 0x2000     // Bit PID13.
	AIC_ICCR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_ICCR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_ICCR_PID14     = 0x4000     // Bit PID14.
	AIC_ICCR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_ICCR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_ICCR_PID15     = 0x8000     // Bit PID15.
	AIC_ICCR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_ICCR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_ICCR_PID16     = 0x10000    // Bit PID16.
	AIC_ICCR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_ICCR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_ICCR_PID17     = 0x20000    // Bit PID17.
	AIC_ICCR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_ICCR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_ICCR_PID18     = 0x40000    // Bit PID18.
	AIC_ICCR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_ICCR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_ICCR_PID19     = 0x80000    // Bit PID19.
	AIC_ICCR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_ICCR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_ICCR_PID20     = 0x100000   // Bit PID20.
	AIC_ICCR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_ICCR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_ICCR_PID21     = 0x200000   // Bit PID21.
	AIC_ICCR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_ICCR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_ICCR_PID22     = 0x400000   // Bit PID22.
	AIC_ICCR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_ICCR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_ICCR_PID23     = 0x800000   // Bit PID23.
	AIC_ICCR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_ICCR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_ICCR_PID24     = 0x1000000  // Bit PID24.
	AIC_ICCR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_ICCR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_ICCR_PID25     = 0x2000000  // Bit PID25.
	AIC_ICCR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_ICCR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_ICCR_PID26     = 0x4000000  // Bit PID26.
	AIC_ICCR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_ICCR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_ICCR_PID27     = 0x8000000  // Bit PID27.
	AIC_ICCR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_ICCR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_ICCR_PID28     = 0x10000000 // Bit PID28.
	AIC_ICCR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_ICCR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_ICCR_PID29     = 0x20000000 // Bit PID29.
	AIC_ICCR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_ICCR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_ICCR_PID30     = 0x40000000 // Bit PID30.
	AIC_ICCR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_ICCR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_ICCR_PID31     = 0x80000000 // Bit PID31.

	// ISCR: Interrupt Set Command Register
	AIC_ISCR_FIQ_Pos   = 0x0        // Position of FIQ field.
	AIC_ISCR_FIQ_Msk   = 0x1        // Bit mask of FIQ field.
	AIC_ISCR_FIQ       = 0x1        // Bit FIQ.
	AIC_ISCR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_ISCR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_ISCR_SYS       = 0x2        // Bit SYS.
	AIC_ISCR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_ISCR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_ISCR_PID2      = 0x4        // Bit PID2.
	AIC_ISCR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_ISCR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_ISCR_PID3      = 0x8        // Bit PID3.
	AIC_ISCR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_ISCR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_ISCR_PID4      = 0x10       // Bit PID4.
	AIC_ISCR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_ISCR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_ISCR_PID5      = 0x20       // Bit PID5.
	AIC_ISCR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_ISCR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_ISCR_PID6      = 0x40       // Bit PID6.
	AIC_ISCR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_ISCR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_ISCR_PID7      = 0x80       // Bit PID7.
	AIC_ISCR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_ISCR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_ISCR_PID8      = 0x100      // Bit PID8.
	AIC_ISCR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_ISCR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_ISCR_PID9      = 0x200      // Bit PID9.
	AIC_ISCR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_ISCR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_ISCR_PID10     = 0x400      // Bit PID10.
	AIC_ISCR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_ISCR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_ISCR_PID11     = 0x800      // Bit PID11.
	AIC_ISCR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_ISCR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_ISCR_PID12     = 0x1000     // Bit PID12.
	AIC_ISCR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_ISCR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_ISCR_PID13     = 0x2000     // Bit PID13.
	AIC_ISCR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_ISCR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_ISCR_PID14     = 0x4000     // Bit PID14.
	AIC_ISCR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_ISCR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_ISCR_PID15     = 0x8000     // Bit PID15.
	AIC_ISCR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_ISCR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_ISCR_PID16     = 0x10000    // Bit PID16.
	AIC_ISCR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_ISCR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_ISCR_PID17     = 0x20000    // Bit PID17.
	AIC_ISCR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_ISCR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_ISCR_PID18     = 0x40000    // Bit PID18.
	AIC_ISCR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_ISCR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_ISCR_PID19     = 0x80000    // Bit PID19.
	AIC_ISCR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_ISCR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_ISCR_PID20     = 0x100000   // Bit PID20.
	AIC_ISCR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_ISCR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_ISCR_PID21     = 0x200000   // Bit PID21.
	AIC_ISCR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_ISCR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_ISCR_PID22     = 0x400000   // Bit PID22.
	AIC_ISCR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_ISCR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_ISCR_PID23     = 0x800000   // Bit PID23.
	AIC_ISCR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_ISCR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_ISCR_PID24     = 0x1000000  // Bit PID24.
	AIC_ISCR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_ISCR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_ISCR_PID25     = 0x2000000  // Bit PID25.
	AIC_ISCR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_ISCR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_ISCR_PID26     = 0x4000000  // Bit PID26.
	AIC_ISCR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_ISCR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_ISCR_PID27     = 0x8000000  // Bit PID27.
	AIC_ISCR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_ISCR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_ISCR_PID28     = 0x10000000 // Bit PID28.
	AIC_ISCR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_ISCR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_ISCR_PID29     = 0x20000000 // Bit PID29.
	AIC_ISCR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_ISCR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_ISCR_PID30     = 0x40000000 // Bit PID30.
	AIC_ISCR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_ISCR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_ISCR_PID31     = 0x80000000 // Bit PID31.

	// SPU: Spurious Interrupt Vector Register
	AIC_SPU_SIVR_Pos = 0x0        // Position of SIVR field.
	AIC_SPU_SIVR_Msk = 0xffffffff // Bit mask of SIVR field.

	// DCR: Debug Control Register
	AIC_DCR_PROT_Pos = 0x0 // Position of PROT field.
	AIC_DCR_PROT_Msk = 0x1 // Bit mask of PROT field.
	AIC_DCR_PROT     = 0x1 // Bit PROT.
	AIC_DCR_GMSK_Pos = 0x1 // Position of GMSK field.
	AIC_DCR_GMSK_Msk = 0x2 // Bit mask of GMSK field.
	AIC_DCR_GMSK     = 0x2 // Bit GMSK.

	// FFER: Fast Forcing Enable Register
	AIC_FFER_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_FFER_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_FFER_SYS       = 0x2        // Bit SYS.
	AIC_FFER_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_FFER_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_FFER_PID2      = 0x4        // Bit PID2.
	AIC_FFER_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_FFER_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_FFER_PID3      = 0x8        // Bit PID3.
	AIC_FFER_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_FFER_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_FFER_PID4      = 0x10       // Bit PID4.
	AIC_FFER_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_FFER_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_FFER_PID5      = 0x20       // Bit PID5.
	AIC_FFER_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_FFER_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_FFER_PID6      = 0x40       // Bit PID6.
	AIC_FFER_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_FFER_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_FFER_PID7      = 0x80       // Bit PID7.
	AIC_FFER_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_FFER_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_FFER_PID8      = 0x100      // Bit PID8.
	AIC_FFER_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_FFER_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_FFER_PID9      = 0x200      // Bit PID9.
	AIC_FFER_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_FFER_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_FFER_PID10     = 0x400      // Bit PID10.
	AIC_FFER_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_FFER_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_FFER_PID11     = 0x800      // Bit PID11.
	AIC_FFER_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_FFER_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_FFER_PID12     = 0x1000     // Bit PID12.
	AIC_FFER_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_FFER_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_FFER_PID13     = 0x2000     // Bit PID13.
	AIC_FFER_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_FFER_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_FFER_PID14     = 0x4000     // Bit PID14.
	AIC_FFER_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_FFER_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_FFER_PID15     = 0x8000     // Bit PID15.
	AIC_FFER_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_FFER_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_FFER_PID16     = 0x10000    // Bit PID16.
	AIC_FFER_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_FFER_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_FFER_PID17     = 0x20000    // Bit PID17.
	AIC_FFER_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_FFER_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_FFER_PID18     = 0x40000    // Bit PID18.
	AIC_FFER_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_FFER_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_FFER_PID19     = 0x80000    // Bit PID19.
	AIC_FFER_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_FFER_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_FFER_PID20     = 0x100000   // Bit PID20.
	AIC_FFER_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_FFER_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_FFER_PID21     = 0x200000   // Bit PID21.
	AIC_FFER_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_FFER_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_FFER_PID22     = 0x400000   // Bit PID22.
	AIC_FFER_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_FFER_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_FFER_PID23     = 0x800000   // Bit PID23.
	AIC_FFER_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_FFER_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_FFER_PID24     = 0x1000000  // Bit PID24.
	AIC_FFER_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_FFER_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_FFER_PID25     = 0x2000000  // Bit PID25.
	AIC_FFER_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_FFER_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_FFER_PID26     = 0x4000000  // Bit PID26.
	AIC_FFER_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_FFER_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_FFER_PID27     = 0x8000000  // Bit PID27.
	AIC_FFER_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_FFER_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_FFER_PID28     = 0x10000000 // Bit PID28.
	AIC_FFER_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_FFER_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_FFER_PID29     = 0x20000000 // Bit PID29.
	AIC_FFER_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_FFER_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_FFER_PID30     = 0x40000000 // Bit PID30.
	AIC_FFER_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_FFER_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_FFER_PID31     = 0x80000000 // Bit PID31.

	// FFDR: Fast Forcing Disable Register
	AIC_FFDR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_FFDR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_FFDR_SYS       = 0x2        // Bit SYS.
	AIC_FFDR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_FFDR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_FFDR_PID2      = 0x4        // Bit PID2.
	AIC_FFDR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_FFDR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_FFDR_PID3      = 0x8        // Bit PID3.
	AIC_FFDR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_FFDR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_FFDR_PID4      = 0x10       // Bit PID4.
	AIC_FFDR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_FFDR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_FFDR_PID5      = 0x20       // Bit PID5.
	AIC_FFDR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_FFDR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_FFDR_PID6      = 0x40       // Bit PID6.
	AIC_FFDR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_FFDR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_FFDR_PID7      = 0x80       // Bit PID7.
	AIC_FFDR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_FFDR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_FFDR_PID8      = 0x100      // Bit PID8.
	AIC_FFDR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_FFDR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_FFDR_PID9      = 0x200      // Bit PID9.
	AIC_FFDR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_FFDR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_FFDR_PID10     = 0x400      // Bit PID10.
	AIC_FFDR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_FFDR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_FFDR_PID11     = 0x800      // Bit PID11.
	AIC_FFDR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_FFDR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_FFDR_PID12     = 0x1000     // Bit PID12.
	AIC_FFDR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_FFDR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_FFDR_PID13     = 0x2000     // Bit PID13.
	AIC_FFDR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_FFDR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_FFDR_PID14     = 0x4000     // Bit PID14.
	AIC_FFDR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_FFDR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_FFDR_PID15     = 0x8000     // Bit PID15.
	AIC_FFDR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_FFDR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_FFDR_PID16     = 0x10000    // Bit PID16.
	AIC_FFDR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_FFDR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_FFDR_PID17     = 0x20000    // Bit PID17.
	AIC_FFDR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_FFDR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_FFDR_PID18     = 0x40000    // Bit PID18.
	AIC_FFDR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_FFDR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_FFDR_PID19     = 0x80000    // Bit PID19.
	AIC_FFDR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_FFDR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_FFDR_PID20     = 0x100000   // Bit PID20.
	AIC_FFDR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_FFDR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_FFDR_PID21     = 0x200000   // Bit PID21.
	AIC_FFDR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_FFDR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_FFDR_PID22     = 0x400000   // Bit PID22.
	AIC_FFDR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_FFDR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_FFDR_PID23     = 0x800000   // Bit PID23.
	AIC_FFDR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_FFDR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_FFDR_PID24     = 0x1000000  // Bit PID24.
	AIC_FFDR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_FFDR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_FFDR_PID25     = 0x2000000  // Bit PID25.
	AIC_FFDR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_FFDR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_FFDR_PID26     = 0x4000000  // Bit PID26.
	AIC_FFDR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_FFDR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_FFDR_PID27     = 0x8000000  // Bit PID27.
	AIC_FFDR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_FFDR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_FFDR_PID28     = 0x10000000 // Bit PID28.
	AIC_FFDR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_FFDR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_FFDR_PID29     = 0x20000000 // Bit PID29.
	AIC_FFDR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_FFDR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_FFDR_PID30     = 0x40000000 // Bit PID30.
	AIC_FFDR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_FFDR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_FFDR_PID31     = 0x80000000 // Bit PID31.

	// FFSR: Fast Forcing Status Register
	AIC_FFSR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_FFSR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_FFSR_SYS       = 0x2        // Bit SYS.
	AIC_FFSR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_FFSR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_FFSR_PID2      = 0x4        // Bit PID2.
	AIC_FFSR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_FFSR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_FFSR_PID3      = 0x8        // Bit PID3.
	AIC_FFSR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_FFSR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_FFSR_PID4      = 0x10       // Bit PID4.
	AIC_FFSR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_FFSR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_FFSR_PID5      = 0x20       // Bit PID5.
	AIC_FFSR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_FFSR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_FFSR_PID6      = 0x40       // Bit PID6.
	AIC_FFSR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_FFSR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_FFSR_PID7      = 0x80       // Bit PID7.
	AIC_FFSR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_FFSR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_FFSR_PID8      = 0x100      // Bit PID8.
	AIC_FFSR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_FFSR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_FFSR_PID9      = 0x200      // Bit PID9.
	AIC_FFSR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_FFSR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_FFSR_PID10     = 0x400      // Bit PID10.
	AIC_FFSR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_FFSR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_FFSR_PID11     = 0x800      // Bit PID11.
	AIC_FFSR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_FFSR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_FFSR_PID12     = 0x1000     // Bit PID12.
	AIC_FFSR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_FFSR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_FFSR_PID13     = 0x2000     // Bit PID13.
	AIC_FFSR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_FFSR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_FFSR_PID14     = 0x4000     // Bit PID14.
	AIC_FFSR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_FFSR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_FFSR_PID15     = 0x8000     // Bit PID15.
	AIC_FFSR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_FFSR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_FFSR_PID16     = 0x10000    // Bit PID16.
	AIC_FFSR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_FFSR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_FFSR_PID17     = 0x20000    // Bit PID17.
	AIC_FFSR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_FFSR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_FFSR_PID18     = 0x40000    // Bit PID18.
	AIC_FFSR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_FFSR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_FFSR_PID19     = 0x80000    // Bit PID19.
	AIC_FFSR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_FFSR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_FFSR_PID20     = 0x100000   // Bit PID20.
	AIC_FFSR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_FFSR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_FFSR_PID21     = 0x200000   // Bit PID21.
	AIC_FFSR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_FFSR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_FFSR_PID22     = 0x400000   // Bit PID22.
	AIC_FFSR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_FFSR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_FFSR_PID23     = 0x800000   // Bit PID23.
	AIC_FFSR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_FFSR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_FFSR_PID24     = 0x1000000  // Bit PID24.
	AIC_FFSR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_FFSR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_FFSR_PID25     = 0x2000000  // Bit PID25.
	AIC_FFSR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_FFSR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_FFSR_PID26     = 0x4000000  // Bit PID26.
	AIC_FFSR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_FFSR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_FFSR_PID27     = 0x8000000  // Bit PID27.
	AIC_FFSR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_FFSR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_FFSR_PID28     = 0x10000000 // Bit PID28.
	AIC_FFSR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_FFSR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_FFSR_PID29     = 0x20000000 // Bit PID29.
	AIC_FFSR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_FFSR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_FFSR_PID30     = 0x40000000 // Bit PID30.
	AIC_FFSR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_FFSR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_FFSR_PID31     = 0x80000000 // Bit PID31.

	// WPMR: Write Protect Mode Register
	AIC_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	AIC_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	AIC_WPMR_WPEN      = 0x1        // Bit WPEN.
	AIC_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	AIC_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protect Status Register
	AIC_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	AIC_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	AIC_WPSR_WPVS       = 0x1      // Bit WPVS.
	AIC_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	AIC_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for DBGU: Debug Unit
const (
	// CR: Control Register
	DBGU_CR_RSTRX_Pos  = 0x2   // Position of RSTRX field.
	DBGU_CR_RSTRX_Msk  = 0x4   // Bit mask of RSTRX field.
	DBGU_CR_RSTRX      = 0x4   // Bit RSTRX.
	DBGU_CR_RSTTX_Pos  = 0x3   // Position of RSTTX field.
	DBGU_CR_RSTTX_Msk  = 0x8   // Bit mask of RSTTX field.
	DBGU_CR_RSTTX      = 0x8   // Bit RSTTX.
	DBGU_CR_RXEN_Pos   = 0x4   // Position of RXEN field.
	DBGU_CR_RXEN_Msk   = 0x10  // Bit mask of RXEN field.
	DBGU_CR_RXEN       = 0x10  // Bit RXEN.
	DBGU_CR_RXDIS_Pos  = 0x5   // Position of RXDIS field.
	DBGU_CR_RXDIS_Msk  = 0x20  // Bit mask of RXDIS field.
	DBGU_CR_RXDIS      = 0x20  // Bit RXDIS.
	DBGU_CR_TXEN_Pos   = 0x6   // Position of TXEN field.
	DBGU_CR_TXEN_Msk   = 0x40  // Bit mask of TXEN field.
	DBGU_CR_TXEN       = 0x40  // Bit TXEN.
	DBGU_CR_TXDIS_Pos  = 0x7   // Position of TXDIS field.
	DBGU_CR_TXDIS_Msk  = 0x80  // Bit mask of TXDIS field.
	DBGU_CR_TXDIS      = 0x80  // Bit TXDIS.
	DBGU_CR_RSTSTA_Pos = 0x8   // Position of RSTSTA field.
	DBGU_CR_RSTSTA_Msk = 0x100 // Bit mask of RSTSTA field.
	DBGU_CR_RSTSTA     = 0x100 // Bit RSTSTA.

	// MR: Mode Register
	DBGU_MR_PAR_Pos        = 0x9    // Position of PAR field.
	DBGU_MR_PAR_Msk        = 0xe00  // Bit mask of PAR field.
	DBGU_MR_PAR_EVEN       = 0x0    // Even Parity
	DBGU_MR_PAR_ODD        = 0x1    // Odd Parity
	DBGU_MR_PAR_SPACE      = 0x2    // Space: Parity forced to 0
	DBGU_MR_PAR_MARK       = 0x3    // Mark: Parity forced to 1
	DBGU_MR_PAR_NONE       = 0x4    // No Parity
	DBGU_MR_CHMODE_Pos     = 0xe    // Position of CHMODE field.
	DBGU_MR_CHMODE_Msk     = 0xc000 // Bit mask of CHMODE field.
	DBGU_MR_CHMODE_NORM    = 0x0    // Normal Mode
	DBGU_MR_CHMODE_AUTO    = 0x1    // Automatic Echo
	DBGU_MR_CHMODE_LOCLOOP = 0x2    // Local Loopback
	DBGU_MR_CHMODE_REMLOOP = 0x3    // Remote Loopback

	// IER: Interrupt Enable Register
	DBGU_IER_RXRDY_Pos   = 0x0        // Position of RXRDY field.
	DBGU_IER_RXRDY_Msk   = 0x1        // Bit mask of RXRDY field.
	DBGU_IER_RXRDY       = 0x1        // Bit RXRDY.
	DBGU_IER_TXRDY_Pos   = 0x1        // Position of TXRDY field.
	DBGU_IER_TXRDY_Msk   = 0x2        // Bit mask of TXRDY field.
	DBGU_IER_TXRDY       = 0x2        // Bit TXRDY.
	DBGU_IER_OVRE_Pos    = 0x5        // Position of OVRE field.
	DBGU_IER_OVRE_Msk    = 0x20       // Bit mask of OVRE field.
	DBGU_IER_OVRE        = 0x20       // Bit OVRE.
	DBGU_IER_FRAME_Pos   = 0x6        // Position of FRAME field.
	DBGU_IER_FRAME_Msk   = 0x40       // Bit mask of FRAME field.
	DBGU_IER_FRAME       = 0x40       // Bit FRAME.
	DBGU_IER_PARE_Pos    = 0x7        // Position of PARE field.
	DBGU_IER_PARE_Msk    = 0x80       // Bit mask of PARE field.
	DBGU_IER_PARE        = 0x80       // Bit PARE.
	DBGU_IER_TXEMPTY_Pos = 0x9        // Position of TXEMPTY field.
	DBGU_IER_TXEMPTY_Msk = 0x200      // Bit mask of TXEMPTY field.
	DBGU_IER_TXEMPTY     = 0x200      // Bit TXEMPTY.
	DBGU_IER_COMMTX_Pos  = 0x1e       // Position of COMMTX field.
	DBGU_IER_COMMTX_Msk  = 0x40000000 // Bit mask of COMMTX field.
	DBGU_IER_COMMTX      = 0x40000000 // Bit COMMTX.
	DBGU_IER_COMMRX_Pos  = 0x1f       // Position of COMMRX field.
	DBGU_IER_COMMRX_Msk  = 0x80000000 // Bit mask of COMMRX field.
	DBGU_IER_COMMRX      = 0x80000000 // Bit COMMRX.

	// IDR: Interrupt Disable Register
	DBGU_IDR_RXRDY_Pos   = 0x0        // Position of RXRDY field.
	DBGU_IDR_RXRDY_Msk   = 0x1        // Bit mask of RXRDY field.
	DBGU_IDR_RXRDY       = 0x1        // Bit RXRDY.
	DBGU_IDR_TXRDY_Pos   = 0x1        // Position of TXRDY field.
	DBGU_IDR_TXRDY_Msk   = 0x2        // Bit mask of TXRDY field.
	DBGU_IDR_TXRDY       = 0x2        // Bit TXRDY.
	DBGU_IDR_OVRE_Pos    = 0x5        // Position of OVRE field.
	DBGU_IDR_OVRE_Msk    = 0x20       // Bit mask of OVRE field.
	DBGU_IDR_OVRE        = 0x20       // Bit OVRE.
	DBGU_IDR_FRAME_Pos   = 0x6        // Position of FRAME field.
	DBGU_IDR_FRAME_Msk   = 0x40       // Bit mask of FRAME field.
	DBGU_IDR_FRAME       = 0x40       // Bit FRAME.
	DBGU_IDR_PARE_Pos    = 0x7        // Position of PARE field.
	DBGU_IDR_PARE_Msk    = 0x80       // Bit mask of PARE field.
	DBGU_IDR_PARE        = 0x80       // Bit PARE.
	DBGU_IDR_TXEMPTY_Pos = 0x9        // Position of TXEMPTY field.
	DBGU_IDR_TXEMPTY_Msk = 0x200      // Bit mask of TXEMPTY field.
	DBGU_IDR_TXEMPTY     = 0x200      // Bit TXEMPTY.
	DBGU_IDR_COMMTX_Pos  = 0x1e       // Position of COMMTX field.
	DBGU_IDR_COMMTX_Msk  = 0x40000000 // Bit mask of COMMTX field.
	DBGU_IDR_COMMTX      = 0x40000000 // Bit COMMTX.
	DBGU_IDR_COMMRX_Pos  = 0x1f       // Position of COMMRX field.
	DBGU_IDR_COMMRX_Msk  = 0x80000000 // Bit mask of COMMRX field.
	DBGU_IDR_COMMRX      = 0x80000000 // Bit COMMRX.

	// IMR: Interrupt Mask Register
	DBGU_IMR_RXRDY_Pos   = 0x0        // Position of RXRDY field.
	DBGU_IMR_RXRDY_Msk   = 0x1        // Bit mask of RXRDY field.
	DBGU_IMR_RXRDY       = 0x1        // Bit RXRDY.
	DBGU_IMR_TXRDY_Pos   = 0x1        // Position of TXRDY field.
	DBGU_IMR_TXRDY_Msk   = 0x2        // Bit mask of TXRDY field.
	DBGU_IMR_TXRDY       = 0x2        // Bit TXRDY.
	DBGU_IMR_OVRE_Pos    = 0x5        // Position of OVRE field.
	DBGU_IMR_OVRE_Msk    = 0x20       // Bit mask of OVRE field.
	DBGU_IMR_OVRE        = 0x20       // Bit OVRE.
	DBGU_IMR_FRAME_Pos   = 0x6        // Position of FRAME field.
	DBGU_IMR_FRAME_Msk   = 0x40       // Bit mask of FRAME field.
	DBGU_IMR_FRAME       = 0x40       // Bit FRAME.
	DBGU_IMR_PARE_Pos    = 0x7        // Position of PARE field.
	DBGU_IMR_PARE_Msk    = 0x80       // Bit mask of PARE field.
	DBGU_IMR_PARE        = 0x80       // Bit PARE.
	DBGU_IMR_TXEMPTY_Pos = 0x9        // Position of TXEMPTY field.
	DBGU_IMR_TXEMPTY_Msk = 0x200      // Bit mask of TXEMPTY field.
	DBGU_IMR_TXEMPTY     = 0x200      // Bit TXEMPTY.
	DBGU_IMR_COMMTX_Pos  = 0x1e       // Position of COMMTX field.
	DBGU_IMR_COMMTX_Msk  = 0x40000000 // Bit mask of COMMTX field.
	DBGU_IMR_COMMTX      = 0x40000000 // Bit COMMTX.
	DBGU_IMR_COMMRX_Pos  = 0x1f       // Position of COMMRX field.
	DBGU_IMR_COMMRX_Msk  = 0x80000000 // Bit mask of COMMRX field.
	DBGU_IMR_COMMRX      = 0x80000000 // Bit COMMRX.

	// SR: Status Register
	DBGU_SR_RXRDY_Pos   = 0x0        // Position of RXRDY field.
	DBGU_SR_RXRDY_Msk   = 0x1        // Bit mask of RXRDY field.
	DBGU_SR_RXRDY       = 0x1        // Bit RXRDY.
	DBGU_SR_TXRDY_Pos   = 0x1        // Position of TXRDY field.
	DBGU_SR_TXRDY_Msk   = 0x2        // Bit mask of TXRDY field.
	DBGU_SR_TXRDY       = 0x2        // Bit TXRDY.
	DBGU_SR_OVRE_Pos    = 0x5        // Position of OVRE field.
	DBGU_SR_OVRE_Msk    = 0x20       // Bit mask of OVRE field.
	DBGU_SR_OVRE        = 0x20       // Bit OVRE.
	DBGU_SR_FRAME_Pos   = 0x6        // Position of FRAME field.
	DBGU_SR_FRAME_Msk   = 0x40       // Bit mask of FRAME field.
	DBGU_SR_FRAME       = 0x40       // Bit FRAME.
	DBGU_SR_PARE_Pos    = 0x7        // Position of PARE field.
	DBGU_SR_PARE_Msk    = 0x80       // Bit mask of PARE field.
	DBGU_SR_PARE        = 0x80       // Bit PARE.
	DBGU_SR_TXEMPTY_Pos = 0x9        // Position of TXEMPTY field.
	DBGU_SR_TXEMPTY_Msk = 0x200      // Bit mask of TXEMPTY field.
	DBGU_SR_TXEMPTY     = 0x200      // Bit TXEMPTY.
	DBGU_SR_COMMTX_Pos  = 0x1e       // Position of COMMTX field.
	DBGU_SR_COMMTX_Msk  = 0x40000000 // Bit mask of COMMTX field.
	DBGU_SR_COMMTX      = 0x40000000 // Bit COMMTX.
	DBGU_SR_COMMRX_Pos  = 0x1f       // Position of COMMRX field.
	DBGU_SR_COMMRX_Msk  = 0x80000000 // Bit mask of COMMRX field.
	DBGU_SR_COMMRX      = 0x80000000 // Bit COMMRX.

	// RHR: Receive Holding Register
	DBGU_RHR_RXCHR_Pos = 0x0  // Position of RXCHR field.
	DBGU_RHR_RXCHR_Msk = 0xff // Bit mask of RXCHR field.

	// THR: Transmit Holding Register
	DBGU_THR_TXCHR_Pos = 0x0  // Position of TXCHR field.
	DBGU_THR_TXCHR_Msk = 0xff // Bit mask of TXCHR field.

	// BRGR: Baud Rate Generator Register
	DBGU_BRGR_CD_Pos      = 0x0    // Position of CD field.
	DBGU_BRGR_CD_Msk      = 0xffff // Bit mask of CD field.
	DBGU_BRGR_CD_DISABLED = 0x0    // DBGU Disabled
	DBGU_BRGR_CD_MCK      = 0x1    // MCK

	// CIDR: Chip ID Register
	DBGU_CIDR_VERSION_Pos       = 0x0        // Position of VERSION field.
	DBGU_CIDR_VERSION_Msk       = 0x1f       // Bit mask of VERSION field.
	DBGU_CIDR_EPROC_Pos         = 0x5        // Position of EPROC field.
	DBGU_CIDR_EPROC_Msk         = 0xe0       // Bit mask of EPROC field.
	DBGU_CIDR_EPROC_ARM946ES    = 0x1        // ARM946ES
	DBGU_CIDR_EPROC_ARM7TDMI    = 0x2        // ARM7TDMI
	DBGU_CIDR_EPROC_CM3         = 0x3        // Cortex-M3
	DBGU_CIDR_EPROC_ARM920T     = 0x4        // ARM920T
	DBGU_CIDR_EPROC_ARM926EJS   = 0x5        // ARM926EJS
	DBGU_CIDR_EPROC_CA5         = 0x6        // Cortex-A5
	DBGU_CIDR_NVPSIZ_Pos        = 0x8        // Position of NVPSIZ field.
	DBGU_CIDR_NVPSIZ_Msk        = 0xf00      // Bit mask of NVPSIZ field.
	DBGU_CIDR_NVPSIZ_NONE       = 0x0        // None
	DBGU_CIDR_NVPSIZ_8K         = 0x1        // 8K bytes
	DBGU_CIDR_NVPSIZ_16K        = 0x2        // 16K bytes
	DBGU_CIDR_NVPSIZ_32K        = 0x3        // 32K bytes
	DBGU_CIDR_NVPSIZ_64K        = 0x5        // 64K bytes
	DBGU_CIDR_NVPSIZ_128K       = 0x7        // 128K bytes
	DBGU_CIDR_NVPSIZ_256K       = 0x9        // 256K bytes
	DBGU_CIDR_NVPSIZ_512K       = 0xa        // 512K bytes
	DBGU_CIDR_NVPSIZ_1024K      = 0xc        // 1024K bytes
	DBGU_CIDR_NVPSIZ_2048K      = 0xe        // 2048K bytes
	DBGU_CIDR_NVPSIZ2_Pos       = 0xc        // Position of NVPSIZ2 field.
	DBGU_CIDR_NVPSIZ2_Msk       = 0xf000     // Bit mask of NVPSIZ2 field.
	DBGU_CIDR_NVPSIZ2_NONE      = 0x0        // None
	DBGU_CIDR_NVPSIZ2_8K        = 0x1        // 8K bytes
	DBGU_CIDR_NVPSIZ2_16K       = 0x2        // 16K bytes
	DBGU_CIDR_NVPSIZ2_32K       = 0x3        // 32K bytes
	DBGU_CIDR_NVPSIZ2_64K       = 0x5        // 64K bytes
	DBGU_CIDR_NVPSIZ2_128K      = 0x7        // 128K bytes
	DBGU_CIDR_NVPSIZ2_256K      = 0x9        // 256K bytes
	DBGU_CIDR_NVPSIZ2_512K      = 0xa        // 512K bytes
	DBGU_CIDR_NVPSIZ2_1024K     = 0xc        // 1024K bytes
	DBGU_CIDR_NVPSIZ2_2048K     = 0xe        // 2048K bytes
	DBGU_CIDR_SRAMSIZ_Pos       = 0x10       // Position of SRAMSIZ field.
	DBGU_CIDR_SRAMSIZ_Msk       = 0xf0000    // Bit mask of SRAMSIZ field.
	DBGU_CIDR_SRAMSIZ_1K        = 0x1        // 1K bytes
	DBGU_CIDR_SRAMSIZ_2K        = 0x2        // 2K bytes
	DBGU_CIDR_SRAMSIZ_6K        = 0x3        // 6K bytes
	DBGU_CIDR_SRAMSIZ_112K      = 0x4        // 112K bytes
	DBGU_CIDR_SRAMSIZ_4K        = 0x5        // 4K bytes
	DBGU_CIDR_SRAMSIZ_80K       = 0x6        // 80K bytes
	DBGU_CIDR_SRAMSIZ_160K      = 0x7        // 160K bytes
	DBGU_CIDR_SRAMSIZ_8K        = 0x8        // 8K bytes
	DBGU_CIDR_SRAMSIZ_16K       = 0x9        // 16K bytes
	DBGU_CIDR_SRAMSIZ_32K       = 0xa        // 32K bytes
	DBGU_CIDR_SRAMSIZ_64K       = 0xb        // 64K bytes
	DBGU_CIDR_SRAMSIZ_128K      = 0xc        // 128K bytes
	DBGU_CIDR_SRAMSIZ_256K      = 0xd        // 256K bytes
	DBGU_CIDR_SRAMSIZ_96K       = 0xe        // 96K bytes
	DBGU_CIDR_SRAMSIZ_512K      = 0xf        // 512K bytes
	DBGU_CIDR_ARCH_Pos          = 0x14       // Position of ARCH field.
	DBGU_CIDR_ARCH_Msk          = 0xff00000  // Bit mask of ARCH field.
	DBGU_CIDR_ARCH_AT91SAM9xx   = 0x19       // AT91SAM9xx Series
	DBGU_CIDR_ARCH_AT91SAM9XExx = 0x29       // AT91SAM9XExx Series
	DBGU_CIDR_ARCH_AT91x34      = 0x34       // AT91x34 Series
	DBGU_CIDR_ARCH_CAP7         = 0x37       // CAP7 Series
	DBGU_CIDR_ARCH_CAP9         = 0x39       // CAP9 Series
	DBGU_CIDR_ARCH_CAP11        = 0x3b       // CAP11 Series
	DBGU_CIDR_ARCH_AT91x40      = 0x40       // AT91x40 Series
	DBGU_CIDR_ARCH_AT91x42      = 0x42       // AT91x42 Series
	DBGU_CIDR_ARCH_AT91x55      = 0x55       // AT91x55 Series
	DBGU_CIDR_ARCH_AT91SAM7Axx  = 0x60       // AT91SAM7Axx Series
	DBGU_CIDR_ARCH_AT91SAM7AQxx = 0x61       // AT91SAM7AQxx Series
	DBGU_CIDR_ARCH_AT91x63      = 0x63       // AT91x63 Series
	DBGU_CIDR_ARCH_AT91SAM7Sxx  = 0x70       // AT91SAM7Sxx Series
	DBGU_CIDR_ARCH_AT91SAM7XCxx = 0x71       // AT91SAM7XCxx Series
	DBGU_CIDR_ARCH_AT91SAM7SExx = 0x72       // AT91SAM7SExx Series
	DBGU_CIDR_ARCH_AT91SAM7Lxx  = 0x73       // AT91SAM7Lxx Series
	DBGU_CIDR_ARCH_AT91SAM7Xxx  = 0x75       // AT91SAM7Xxx Series
	DBGU_CIDR_ARCH_AT91SAM7SLxx = 0x76       // AT91SAM7SLxx Series
	DBGU_CIDR_ARCH_ATSAM3UxC    = 0x80       // ATSAM3UxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3UxE    = 0x81       // ATSAM3UxE Series (144-pin version)
	DBGU_CIDR_ARCH_ATSAM3AxC    = 0x83       // ATSAM3AxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3XxC    = 0x84       // ATSAM3XxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3XxE    = 0x85       // ATSAM3XxE Series (144-pin version)
	DBGU_CIDR_ARCH_ATSAM3XxG    = 0x86       // ATSAM3XxG Series (208/217-pin version)
	DBGU_CIDR_ARCH_ATSAM3SxA    = 0x88       // ATSAM3SxA Series (48-pin version)
	DBGU_CIDR_ARCH_ATSAM3SxB    = 0x89       // ATSAM3SxB Series (64-pin version)
	DBGU_CIDR_ARCH_ATSAM3SxC    = 0x8a       // ATSAM3SxC Series (100-pin version)
	DBGU_CIDR_ARCH_AT91x92      = 0x92       // AT91x92 Series
	DBGU_CIDR_ARCH_ATSAM3NxA    = 0x93       // ATSAM3NxA Series (48-pin version)
	DBGU_CIDR_ARCH_ATSAM3NxB    = 0x94       // ATSAM3NxB Series (64-pin version)
	DBGU_CIDR_ARCH_ATSAM3NxC    = 0x95       // ATSAM3NxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3SDxA   = 0x98       // ATSAM3SDxA Series (48-pin version)
	DBGU_CIDR_ARCH_ATSAM3SDxB   = 0x99       // ATSAM3SDxB Series (64-pin version)
	DBGU_CIDR_ARCH_ATSAM3SDxC   = 0x9a       // ATSAM3SDxC Series (100-pin version)
	DBGU_CIDR_ARCH_AT75Cxx      = 0xf0       // AT75Cxx Series
	DBGU_CIDR_NVPTYP_Pos        = 0x1c       // Position of NVPTYP field.
	DBGU_CIDR_NVPTYP_Msk        = 0x70000000 // Bit mask of NVPTYP field.
	DBGU_CIDR_NVPTYP_ROM        = 0x0        // ROM
	DBGU_CIDR_NVPTYP_ROMLESS    = 0x1        // ROMless or on-chip Flash
	DBGU_CIDR_NVPTYP_FLASH      = 0x2        // Embedded Flash Memory
	DBGU_CIDR_NVPTYP_ROM_FLASH  = 0x3        // ROM and Embedded Flash MemoryNVPSIZ is ROM size      NVPSIZ2 is Flash size
	DBGU_CIDR_NVPTYP_SRAM       = 0x4        // SRAM emulating ROM
	DBGU_CIDR_EXT_Pos           = 0x1f       // Position of EXT field.
	DBGU_CIDR_EXT_Msk           = 0x80000000 // Bit mask of EXT field.
	DBGU_CIDR_EXT               = 0x80000000 // Bit EXT.

	// EXID: Chip ID Extension Register
	DBGU_EXID_EXID_Pos = 0x0        // Position of EXID field.
	DBGU_EXID_EXID_Msk = 0xffffffff // Bit mask of EXID field.

	// FNR: Force NTRST Register
	DBGU_FNR_FNTRST_Pos = 0x0 // Position of FNTRST field.
	DBGU_FNR_FNTRST_Msk = 0x1 // Bit mask of FNTRST field.
	DBGU_FNR_FNTRST     = 0x1 // Bit FNTRST.
)

// Bitfields for PIOA: Parallel Input/Output Controller A
const (
	// PER: PIO Enable Register
	PIO_PER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PER_P0      = 0x1        // Bit P0.
	PIO_PER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PER_P1      = 0x2        // Bit P1.
	PIO_PER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PER_P2      = 0x4        // Bit P2.
	PIO_PER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PER_P3      = 0x8        // Bit P3.
	PIO_PER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PER_P4      = 0x10       // Bit P4.
	PIO_PER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PER_P5      = 0x20       // Bit P5.
	PIO_PER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PER_P6      = 0x40       // Bit P6.
	PIO_PER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PER_P7      = 0x80       // Bit P7.
	PIO_PER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PER_P8      = 0x100      // Bit P8.
	PIO_PER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PER_P9      = 0x200      // Bit P9.
	PIO_PER_P10_Pos = 0xa        // Position of P10 field.
	PIO_PER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PER_P10     = 0x400      // Bit P10.
	PIO_PER_P11_Pos = 0xb        // Position of P11 field.
	PIO_PER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PER_P11     = 0x800      // Bit P11.
	PIO_PER_P12_Pos = 0xc        // Position of P12 field.
	PIO_PER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PER_P12     = 0x1000     // Bit P12.
	PIO_PER_P13_Pos = 0xd        // Position of P13 field.
	PIO_PER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PER_P13     = 0x2000     // Bit P13.
	PIO_PER_P14_Pos = 0xe        // Position of P14 field.
	PIO_PER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PER_P14     = 0x4000     // Bit P14.
	PIO_PER_P15_Pos = 0xf        // Position of P15 field.
	PIO_PER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PER_P15     = 0x8000     // Bit P15.
	PIO_PER_P16_Pos = 0x10       // Position of P16 field.
	PIO_PER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PER_P16     = 0x10000    // Bit P16.
	PIO_PER_P17_Pos = 0x11       // Position of P17 field.
	PIO_PER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PER_P17     = 0x20000    // Bit P17.
	PIO_PER_P18_Pos = 0x12       // Position of P18 field.
	PIO_PER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PER_P18     = 0x40000    // Bit P18.
	PIO_PER_P19_Pos = 0x13       // Position of P19 field.
	PIO_PER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PER_P19     = 0x80000    // Bit P19.
	PIO_PER_P20_Pos = 0x14       // Position of P20 field.
	PIO_PER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PER_P20     = 0x100000   // Bit P20.
	PIO_PER_P21_Pos = 0x15       // Position of P21 field.
	PIO_PER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PER_P21     = 0x200000   // Bit P21.
	PIO_PER_P22_Pos = 0x16       // Position of P22 field.
	PIO_PER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PER_P22     = 0x400000   // Bit P22.
	PIO_PER_P23_Pos = 0x17       // Position of P23 field.
	PIO_PER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PER_P23     = 0x800000   // Bit P23.
	PIO_PER_P24_Pos = 0x18       // Position of P24 field.
	PIO_PER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PER_P24     = 0x1000000  // Bit P24.
	PIO_PER_P25_Pos = 0x19       // Position of P25 field.
	PIO_PER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PER_P25     = 0x2000000  // Bit P25.
	PIO_PER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PER_P26     = 0x4000000  // Bit P26.
	PIO_PER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PER_P27     = 0x8000000  // Bit P27.
	PIO_PER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PER_P28     = 0x10000000 // Bit P28.
	PIO_PER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PER_P29     = 0x20000000 // Bit P29.
	PIO_PER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PER_P30     = 0x40000000 // Bit P30.
	PIO_PER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PER_P31     = 0x80000000 // Bit P31.

	// PDR: PIO Disable Register
	PIO_PDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PDR_P0      = 0x1        // Bit P0.
	PIO_PDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PDR_P1      = 0x2        // Bit P1.
	PIO_PDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PDR_P2      = 0x4        // Bit P2.
	PIO_PDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PDR_P3      = 0x8        // Bit P3.
	PIO_PDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PDR_P4      = 0x10       // Bit P4.
	PIO_PDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PDR_P5      = 0x20       // Bit P5.
	PIO_PDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PDR_P6      = 0x40       // Bit P6.
	PIO_PDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PDR_P7      = 0x80       // Bit P7.
	PIO_PDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PDR_P8      = 0x100      // Bit P8.
	PIO_PDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PDR_P9      = 0x200      // Bit P9.
	PIO_PDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PDR_P10     = 0x400      // Bit P10.
	PIO_PDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PDR_P11     = 0x800      // Bit P11.
	PIO_PDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PDR_P12     = 0x1000     // Bit P12.
	PIO_PDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PDR_P13     = 0x2000     // Bit P13.
	PIO_PDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PDR_P14     = 0x4000     // Bit P14.
	PIO_PDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PDR_P15     = 0x8000     // Bit P15.
	PIO_PDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PDR_P16     = 0x10000    // Bit P16.
	PIO_PDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PDR_P17     = 0x20000    // Bit P17.
	PIO_PDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PDR_P18     = 0x40000    // Bit P18.
	PIO_PDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PDR_P19     = 0x80000    // Bit P19.
	PIO_PDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PDR_P20     = 0x100000   // Bit P20.
	PIO_PDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PDR_P21     = 0x200000   // Bit P21.
	PIO_PDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PDR_P22     = 0x400000   // Bit P22.
	PIO_PDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PDR_P23     = 0x800000   // Bit P23.
	PIO_PDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PDR_P24     = 0x1000000  // Bit P24.
	PIO_PDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PDR_P25     = 0x2000000  // Bit P25.
	PIO_PDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PDR_P26     = 0x4000000  // Bit P26.
	PIO_PDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PDR_P27     = 0x8000000  // Bit P27.
	PIO_PDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PDR_P28     = 0x10000000 // Bit P28.
	PIO_PDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PDR_P29     = 0x20000000 // Bit P29.
	PIO_PDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PDR_P30     = 0x40000000 // Bit P30.
	PIO_PDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PDR_P31     = 0x80000000 // Bit P31.

	// PSR: PIO Status Register
	PIO_PSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PSR_P0      = 0x1        // Bit P0.
	PIO_PSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PSR_P1      = 0x2        // Bit P1.
	PIO_PSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PSR_P2      = 0x4        // Bit P2.
	PIO_PSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PSR_P3      = 0x8        // Bit P3.
	PIO_PSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PSR_P4      = 0x10       // Bit P4.
	PIO_PSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PSR_P5      = 0x20       // Bit P5.
	PIO_PSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PSR_P6      = 0x40       // Bit P6.
	PIO_PSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PSR_P7      = 0x80       // Bit P7.
	PIO_PSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PSR_P8      = 0x100      // Bit P8.
	PIO_PSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PSR_P9      = 0x200      // Bit P9.
	PIO_PSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PSR_P10     = 0x400      // Bit P10.
	PIO_PSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PSR_P11     = 0x800      // Bit P11.
	PIO_PSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PSR_P12     = 0x1000     // Bit P12.
	PIO_PSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PSR_P13     = 0x2000     // Bit P13.
	PIO_PSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PSR_P14     = 0x4000     // Bit P14.
	PIO_PSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PSR_P15     = 0x8000     // Bit P15.
	PIO_PSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PSR_P16     = 0x10000    // Bit P16.
	PIO_PSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PSR_P17     = 0x20000    // Bit P17.
	PIO_PSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PSR_P18     = 0x40000    // Bit P18.
	PIO_PSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PSR_P19     = 0x80000    // Bit P19.
	PIO_PSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PSR_P20     = 0x100000   // Bit P20.
	PIO_PSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PSR_P21     = 0x200000   // Bit P21.
	PIO_PSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PSR_P22     = 0x400000   // Bit P22.
	PIO_PSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PSR_P23     = 0x800000   // Bit P23.
	PIO_PSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PSR_P24     = 0x1000000  // Bit P24.
	PIO_PSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PSR_P25     = 0x2000000  // Bit P25.
	PIO_PSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PSR_P26     = 0x4000000  // Bit P26.
	PIO_PSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PSR_P27     = 0x8000000  // Bit P27.
	PIO_PSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PSR_P28     = 0x10000000 // Bit P28.
	PIO_PSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PSR_P29     = 0x20000000 // Bit P29.
	PIO_PSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PSR_P30     = 0x40000000 // Bit P30.
	PIO_PSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PSR_P31     = 0x80000000 // Bit P31.

	// OER: Output Enable Register
	PIO_OER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_OER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_OER_P0      = 0x1        // Bit P0.
	PIO_OER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_OER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_OER_P1      = 0x2        // Bit P1.
	PIO_OER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_OER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_OER_P2      = 0x4        // Bit P2.
	PIO_OER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_OER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_OER_P3      = 0x8        // Bit P3.
	PIO_OER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_OER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_OER_P4      = 0x10       // Bit P4.
	PIO_OER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_OER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_OER_P5  