// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAML11E15A.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

// +build sam,atsaml11e15a

// Microchip ATSAML11E15A Microcontroller
//

package sam

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATSAML11E15A"
)

// Interrupt numbers.
const (
	IRQ_WDT            = 1  // Watchdog Timer
	IRQ_RTC            = 2  // Real-Time Counter
	IRQ_EIC_0          = 3  // External Interrupt Controller
	IRQ_EIC_1          = 4  // External Interrupt Controller
	IRQ_EIC_2          = 5  // External Interrupt Controller
	IRQ_EIC_3          = 6  // External Interrupt Controller
	IRQ_EIC_OTHER      = 7  // External Interrupt Controller
	IRQ_FREQM          = 8  // Frequency Meter
	IRQ_NVMCTRL        = 9  // Non-Volatile Memory Controller
	IRQ_PORT           = 10 // Port Module
	IRQ_DMAC_0         = 11 // Direct Memory Access Controller
	IRQ_DMAC_1         = 12 // Direct Memory Access Controller
	IRQ_DMAC_2         = 13 // Direct Memory Access Controller
	IRQ_DMAC_3         = 14 // Direct Memory Access Controller
	IRQ_DMAC_OTHER     = 15 // Direct Memory Access Controller
	IRQ_EVSYS_0        = 16 // Event System Interface
	IRQ_EVSYS_1        = 17 // Event System Interface
	IRQ_EVSYS_2        = 18 // Event System Interface
	IRQ_EVSYS_3        = 19 // Event System Interface
	IRQ_EVSYS_NSCHK    = 20 // Event System Interface
	IRQ_PAC            = 21 // Peripheral Access Controller
	IRQ_SERCOM0_0      = 22 // Serial Communication Interface
	IRQ_SERCOM0_1      = 23 // Serial Communication Interface
	IRQ_SERCOM0_2      = 24 // Serial Communication Interface
	IRQ_SERCOM0_OTHER  = 25 // Serial Communication Interface
	IRQ_SERCOM1_0      = 26 //
	IRQ_SERCOM1_1      = 27 //
	IRQ_SERCOM1_2      = 28 //
	IRQ_SERCOM1_OTHER  = 29 //
	IRQ_SERCOM2_0      = 30 //
	IRQ_SERCOM2_1      = 31 //
	IRQ_SERCOM2_2      = 32 //
	IRQ_SERCOM2_OTHER  = 33 //
	IRQ_TC0            = 34 // Basic Timer Counter
	IRQ_TC1            = 35 //
	IRQ_TC2            = 36 //
	IRQ_ADC_OTHER      = 37 // Analog Digital Converter
	IRQ_ADC_RESRDY     = 38 // Analog Digital Converter
	IRQ_AC             = 39 // Analog Comparators
	IRQ_DAC_UNDERRUN_A = 40 // Digital Analog Converter
	IRQ_DAC_EMPTY      = 41 // Digital Analog Converter
	IRQ_PTC            = 42 // Peripheral Touch Controller
	IRQ_TRNG           = 43 // True Random Generator
	IRQ_TRAM           = 44 // TrustRAM
	IRQ_max            = 44 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WDT, "WDT_IRQHandler")
	_ = interrupt.Register(IRQ_RTC, "RTC_IRQHandler")
	_ = interrupt.Register(IRQ_EIC_0, "EIC_0_IRQHandler")
	_ = interrupt.Register(IRQ_EIC_1, "EIC_1_IRQHandler")
	_ = interrupt.Register(IRQ_EIC_2, "EIC_2_IRQHandler")
	_ = interrupt.Register(IRQ_EIC_3, "EIC_3_IRQHandler")
	_ = interrupt.Register(IRQ_EIC_OTHER, "EIC_OTHER_IRQHandler")
	_ = interrupt.Register(IRQ_FREQM, "FREQM_IRQHandler")
	_ = interrupt.Register(IRQ_NVMCTRL, "NVMCTRL_IRQHandler")
	_ = interrupt.Register(IRQ_PORT, "PORT_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC_0, "DMAC_0_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC_1, "DMAC_1_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC_2, "DMAC_2_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC_3, "DMAC_3_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC_OTHER, "DMAC_OTHER_IRQHandler")
	_ = interrupt.Register(IRQ_EVSYS_0, "EVSYS_0_IRQHandler")
	_ = interrupt.Register(IRQ_EVSYS_1, "EVSYS_1_IRQHandler")
	_ = interrupt.Register(IRQ_EVSYS_2, "EVSYS_2_IRQHandler")
	_ = interrupt.Register(IRQ_EVSYS_3, "EVSYS_3_IRQHandler")
	_ = interrupt.Register(IRQ_EVSYS_NSCHK, "EVSYS_NSCHK_IRQHandler")
	_ = interrupt.Register(IRQ_PAC, "PAC_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM0_0, "SERCOM0_0_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM0_1, "SERCOM0_1_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM0_2, "SERCOM0_2_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM0_OTHER, "SERCOM0_OTHER_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM1_0, "SERCOM1_0_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM1_1, "SERCOM1_1_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM1_2, "SERCOM1_2_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM1_OTHER, "SERCOM1_OTHER_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM2_0, "SERCOM2_0_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM2_1, "SERCOM2_1_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM2_2, "SERCOM2_2_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM2_OTHER, "SERCOM2_OTHER_IRQHandler")
	_ = interrupt.Register(IRQ_TC0, "TC0_IRQHandler")
	_ = interrupt.Register(IRQ_TC1, "TC1_IRQHandler")
	_ = interrupt.Register(IRQ_TC2, "TC2_IRQHandler")
	_ = interrupt.Register(IRQ_ADC_OTHER, "ADC_OTHER_IRQHandler")
	_ = interrupt.Register(IRQ_ADC_RESRDY, "ADC_RESRDY_IRQHandler")
	_ = interrupt.Register(IRQ_AC, "AC_IRQHandler")
	_ = interrupt.Register(IRQ_DAC_UNDERRUN_A, "DAC_UNDERRUN_A_IRQHandler")
	_ = interrupt.Register(IRQ_DAC_EMPTY, "DAC_EMPTY_IRQHandler")
	_ = interrupt.Register(IRQ_PTC, "PTC_IRQHandler")
	_ = interrupt.Register(IRQ_TRNG, "TRNG_IRQHandler")
	_ = interrupt.Register(IRQ_TRAM, "TRAM_IRQHandler")
)

// Peripherals.
var (
	AC             = (*AC_Type)(unsafe.Pointer(uintptr(0x40003400)))           // Analog Comparators
	ADC            = (*ADC_Type)(unsafe.Pointer(uintptr(0x42001c00)))          // Analog Digital Converter
	CCL            = (*CCL_Type)(unsafe.Pointer(uintptr(0x42002c00)))          // Configurable Custom Logic
	DAC            = (*DAC_Type)(unsafe.Pointer(uintptr(0x42002000)))          // Digital Analog Converter
	DMAC           = (*DMAC_Type)(unsafe.Pointer(uintptr(0x41006000)))         // Direct Memory Access Controller
	DSU            = (*DSU_Type)(unsafe.Pointer(uintptr(0x41002000)))          // Device Service Unit
	DSU_EXT        = (*DSU_Type)(unsafe.Pointer(uintptr(0x41002100)))          // Device Service Unit
	EIC            = (*EIC_Type)(unsafe.Pointer(uintptr(0x40002800)))          // External Interrupt Controller
	EIC_SEC        = (*EIC_Type)(unsafe.Pointer(uintptr(0x40002a00)))          // External Interrupt Controller
	EVSYS          = (*EVSYS_Type)(unsafe.Pointer(uintptr(0x42000000)))        // Event System Interface
	EVSYS_SEC      = (*EVSYS_Type)(unsafe.Pointer(uintptr(0x42000200)))        // Event System Interface
	FREQM          = (*FREQM_Type)(unsafe.Pointer(uintptr(0x40002c00)))        // Frequency Meter
	GCLK           = (*GCLK_Type)(unsafe.Pointer(uintptr(0x40001c00)))         // Generic Clock Generator
	IDAU           = (*IDAU_Type)(unsafe.Pointer(uintptr(0x41000000)))         // Implementation Defined Attribution Unit
	MCLK           = (*MCLK_Type)(unsafe.Pointer(uintptr(0x40000800)))         // Main Clock
	NVMCTRL        = (*NVMCTRL_Type)(unsafe.Pointer(uintptr(0x41004000)))      // Non-Volatile Memory Controller
	NVMCTRL_SEC    = (*NVMCTRL_Type)(unsafe.Pointer(uintptr(0x41005000)))      // Non-Volatile Memory Controller
	OPAMP          = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x42003000)))        // Operational Amplifier
	OSCCTRL        = (*OSCCTRL_Type)(unsafe.Pointer(uintptr(0x40001000)))      // Oscillators Control
	OSC32KCTRL     = (*OSC32KCTRL_Type)(unsafe.Pointer(uintptr(0x40001400)))   // 32k Oscillators Control
	PAC            = (*PAC_Type)(unsafe.Pointer(uintptr(0x40000000)))          // Peripheral Access Controller
	PAC_SEC        = (*PAC_Type)(unsafe.Pointer(uintptr(0x40000200)))          // Peripheral Access Controller
	PM             = (*PM_Type)(unsafe.Pointer(uintptr(0x40000400)))           // Power Manager
	PORT           = (*PORT_Type)(unsafe.Pointer(uintptr(0x40003000)))         // Port Module
	PORT_SEC       = (*PORT_Type)(unsafe.Pointer(uintptr(0x40003200)))         // Port Module
	PORT_IOBUS     = (*PORT_Type)(unsafe.Pointer(uintptr(0x60000000)))         // Port Module
	PORT_IOBUS_SEC = (*PORT_Type)(unsafe.Pointer(uintptr(0x60000200)))         // Port Module
	PTC            = (*PTC_Type)(unsafe.Pointer(uintptr(0x42002400)))          // Peripheral Touch Controller
	RSTC           = (*RSTC_Type)(unsafe.Pointer(uintptr(0x40000c00)))         // Reset Controller
	RTC            = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002400)))          // Real-Time Counter
	RTC_MODE0      = (*RTC_MODE0_Type)(unsafe.Pointer(uintptr(0x40002400)))    // Real-Time Counter - MODE0
	RTC_MODE1      = (*RTC_MODE1_Type)(unsafe.Pointer(uintptr(0x40002400)))    // Real-Time Counter - MODE1
	RTC_MODE2      = (*RTC_MODE2_Type)(unsafe.Pointer(uintptr(0x40002400)))    // Real-Time Counter - MODE2
	SERCOM0        = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42000400)))       // Serial Communication Interface
	SERCOM0_I2CM   = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42000400)))  // Serial Communication Interface - I2CM
	SERCOM0_I2CS   = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42000400)))  // Serial Communication Interface - I2CS
	SERCOM0_SPI    = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42000400)))   // Serial Communication Interface - SPI
	SERCOM0_USART  = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42000400))) // Serial Communication Interface - USART
	SUPC           = (*SUPC_Type)(unsafe.Pointer(uintptr(0x40001800)))         // Supply Controller
	TC0            = (*TC_Type)(unsafe.Pointer(uintptr(0x42001000)))           // Basic Timer Counter
	TC0_COUNT8     = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42001000)))    // Basic Timer Counter - COUNT8
	TC0_COUNT16    = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42001000)))   // Basic Timer Counter - COUNT16
	TC0_COUNT32    = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42001000)))   // Basic Timer Counter - COUNT32
	TRAM           = (*TRAM_Type)(unsafe.Pointer(uintptr(0x42003400)))         // TrustRAM
	TRNG           = (*TRNG_Type)(unsafe.Pointer(uintptr(0x42002800)))         // True Random Generator
	WDT            = (*WDT_Type)(unsafe.Pointer(uintptr(0x40002000)))          // Watchdog Timer
	CoreDebug      = (*CoreDebug_Type)(unsafe.Pointer(uintptr(0xe000edf0)))    // Debug Control Block
	CoreDebug_NS   = (*CoreDebug_Type)(unsafe.Pointer(uintptr(0xe002edf0)))    // Debug Control Block
	DIB            = (*DIB_Type)(unsafe.Pointer(uintptr(0xe000efb0)))          // Debug Identification Block
	DIB_NS         = (*DIB_Type)(unsafe.Pointer(uintptr(0xe002efb0)))          // Debug Identification Block
	DWT            = (*DWT_Type)(unsafe.Pointer(uintptr(0xe0001000)))          // Data Watchpoint and Trace
	FPB            = (*FPB_Type)(unsafe.Pointer(uintptr(0xe0002000)))          // Flash Patch and Breakpoint
	ICB            = (*ICB_Type)(unsafe.Pointer(uintptr(0xe000e000)))          // Implementation Control Block
	ICB_NS         = (*ICB_Type)(unsafe.Pointer(uintptr(0xe002e000)))          // Implementation Control Block
	MPU            = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))          // Memory Protection Unit
	MPU_NS         = (*MPU_Type)(unsafe.Pointer(uintptr(0xe002ed90)))          // Memory Protection Unit
	NVIC           = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))         // Nested Vectored Interrupt Controller
	NVIC_NS        = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe002e100)))         // Nested Vectored Interrupt Controller
	SCB            = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))          // System Control Block
	SCB_NS         = (*SCB_Type)(unsafe.Pointer(uintptr(0xe002ed00)))          // System Control Block
	SysTick        = (*SysTick_Type)(unsafe.Pointer(uintptr(0xe000e010)))      // SysTick Timer
	SysTick_NS     = (*SysTick_Type)(unsafe.Pointer(uintptr(0xe002e010)))      // SysTick Timer
	SERCOM1        = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42000800)))       // Serial Communication Interface
	SERCOM1_I2CM   = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42000800)))  // Serial Communication Interface - I2CM
	SERCOM1_I2CS   = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42000800)))  // Serial Communication Interface - I2CS
	SERCOM1_SPI    = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42000800)))   // Serial Communication Interface - SPI
	SERCOM1_USART  = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42000800))) // Serial Communication Interface - USART
	SERCOM2        = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42000c00)))       // Serial Communication Interface
	SERCOM2_I2CM   = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42000c00)))  // Serial Communication Interface - I2CM
	SERCOM2_I2CS   = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42000c00)))  // Serial Communication Interface - I2CS
	SERCOM2_SPI    = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42000c00)))   // Serial Communication Interface - SPI
	SERCOM2_USART  = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42000c00))) // Serial Communication Interface - USART
	TC1            = (*TC_Type)(unsafe.Pointer(uintptr(0x42001400)))           // Basic Timer Counter
	TC1_COUNT8     = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42001400)))    // Basic Timer Counter - COUNT8
	TC1_COUNT16    = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42001400)))   // Basic Timer Counter - COUNT16
	TC1_COUNT32    = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42001400)))   // Basic Timer Counter - COUNT32
	TC2            = (*TC_Type)(unsafe.Pointer(uintptr(0x42001800)))           // Basic Timer Counter
	TC2_COUNT8     = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42001800)))    // Basic Timer Counter - COUNT8
	TC2_COUNT16    = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42001800)))   // Basic Timer Counter - COUNT16
	TC2_COUNT32    = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42001800)))   // Basic Timer Counter - COUNT32
)

// Analog Comparators
type AC_Type struct {
	CTRLA    volatile.Register8  // 0x0
	CTRLB    volatile.Register8  // 0x1
	EVCTRL   volatile.Register16 // 0x2
	INTENCLR volatile.Register8  // 0x4
	INTENSET volatile.Register8  // 0x5
	INTFLAG  volatile.Register8  // 0x6
	STATUSA  volatile.Register8  // 0x7
	STATUSB  volatile.Register8  // 0x8
	DBGCTRL  volatile.Register8  // 0x9
	WINCTRL  volatile.Register8  // 0xA
	_        byte
	SCALER   [2]volatile.Register8 // 0xC
	_        [2]byte
	COMPCTRL [2]volatile.Register32 // 0x10
	_        [8]byte
	SYNCBUSY volatile.Register32 // 0x20
}

// Analog Digital Converter
type ADC_Type struct {
	CTRLA      volatile.Register8  // 0x0
	CTRLB      volatile.Register8  // 0x1
	REFCTRL    volatile.Register8  // 0x2
	EVCTRL     volatile.Register8  // 0x3
	INTENCLR   volatile.Register8  // 0x4
	INTENSET   volatile.Register8  // 0x5
	INTFLAG    volatile.Register8  // 0x6
	SEQSTATUS  volatile.Register8  // 0x7
	INPUTCTRL  volatile.Register16 // 0x8
	CTRLC      volatile.Register16 // 0xA
	AVGCTRL    volatile.Register8  // 0xC
	SAMPCTRL   volatile.Register8  // 0xD
	WINLT      volatile.Register16 // 0xE
	WINUT      volatile.Register16 // 0x10
	GAINCORR   volatile.Register16 // 0x12
	OFFSETCORR volatile.Register16 // 0x14
	_          [2]byte
	SWTRIG     volatile.Register8 // 0x18
	_          [3]byte
	DBGCTRL    volatile.Register8 // 0x1C
	_          [3]byte
	SYNCBUSY   volatile.Register16 // 0x20
	_          [2]byte
	RESULT     volatile.Register16 // 0x24
	_          [2]byte
	SEQCTRL    volatile.Register32 // 0x28
	CALIB      volatile.Register16 // 0x2C
}

// Configurable Custom Logic
type CCL_Type struct {
	CTRL    volatile.Register8 // 0x0
	_       [3]byte
	SEQCTRL [1]volatile.Register8 // 0x4
	_       [3]byte
	LUTCTRL [2]volatile.Register32 // 0x8
}

// Digital Analog Converter
type DAC_Type struct {
	CTRLA    volatile.Register8 // 0x0
	CTRLB    volatile.Register8 // 0x1
	EVCTRL   volatile.Register8 // 0x2
	_        byte
	INTENCLR volatile.Register8  // 0x4
	INTENSET volatile.Register8  // 0x5
	INTFLAG  volatile.Register8  // 0x6
	STATUS   volatile.Register8  // 0x7
	DATA     volatile.Register16 // 0x8
	_        [2]byte
	DATABUF  volatile.Register16 // 0xC
	_        [2]byte
	SYNCBUSY volatile.Register32 // 0x10
	DBGCTRL  volatile.Register8  // 0x14
}

// Direct Memory Access Controller
type DMAC_Type struct {
	CTRL       volatile.Register16 // 0x0
	CRCCTRL    volatile.Register16 // 0x2
	CRCDATAIN  volatile.Register32 // 0x4
	CRCCHKSUM  volatile.Register32 // 0x8
	CRCSTATUS  volatile.Register8  // 0xC
	DBGCTRL    volatile.Register8  // 0xD
	QOSCTRL    volatile.Register8  // 0xE
	_          byte
	SWTRIGCTRL volatile.Register32 // 0x10
	PRICTRL0   volatile.Register32 // 0x14
	_          [8]byte
	INTPEND    volatile.Register16 // 0x20
	_          [2]byte
	INTSTATUS  volatile.Register32 // 0x24
	BUSYCH     volatile.Register32 // 0x28
	PENDCH     volatile.Register32 // 0x2C
	ACTIVE     volatile.Register32 // 0x30
	BASEADDR   volatile.Register32 // 0x34
	WRBADDR    volatile.Register32 // 0x38
	_          [3]byte
	CHID       volatile.Register8 // 0x3F
	CHCTRLA    volatile.Register8 // 0x40
	_          [3]byte
	CHCTRLB    volatile.Register32 // 0x44
	_          [4]byte
	CHINTENCLR volatile.Register8 // 0x4C
	CHINTENSET volatile.Register8 // 0x4D
	CHINTFLAG  volatile.Register8 // 0x4E
	CHSTATUS   volatile.Register8 // 0x4F
}

// Device Service Unit
type DSU_Type struct {
	CTRL    volatile.Register8     // 0x0
	STATUSA volatile.Register8     // 0x1
	STATUSB volatile.Register8     // 0x2
	STATUSC volatile.Register8     // 0x3
	ADDR    volatile.Register32    // 0x4
	LENGTH  volatile.Register32    // 0x8
	DATA    volatile.Register32    // 0xC
	DCC     [2]volatile.Register32 // 0x10
	DID     volatile.Register32    // 0x18
	CFG     volatile.Register32    // 0x1C
	BCC     [2]volatile.Register32 // 0x20
	_       [200]byte
	DCFG    [2]volatile.Register32 // 0xF0
	_       [3848]byte
	ENTRY0  volatile.Register32 // 0x1000
	ENTRY1  volatile.Register32 // 0x1004
	END     volatile.Register32 // 0x1008
	_       [4032]byte
	MEMTYPE volatile.Register32 // 0x1FCC
	PID4    volatile.Register32 // 0x1FD0
	PID5    volatile.Register32 // 0x1FD4
	PID6    volatile.Register32 // 0x1FD8
	PID7    volatile.Register32 // 0x1FDC
	PID0    volatile.Register32 // 0x1FE0
	PID1    volatile.Register32 // 0x1FE4
	PID2    volatile.Register32 // 0x1FE8
	PID3    volatile.Register32 // 0x1FEC
	CID0    volatile.Register32 // 0x1FF0
	CID1    volatile.Register32 // 0x1FF4
	CID2    volatile.Register32 // 0x1FF8
	CID3    volatile.Register32 // 0x1FFC
}

// External Interrupt Controller
type EIC_Type struct {
	CTRLA      volatile.Register8 // 0x0
	NMICTRL    volatile.Register8 // 0x1
	NMIFLAG    volatile.Register8 // 0x2
	_          byte
	SYNCBUSY   volatile.Register32    // 0x4
	EVCTRL     volatile.Register32    // 0x8
	INTENCLR   volatile.Register32    // 0xC
	INTENSET   volatile.Register32    // 0x10
	INTFLAG    volatile.Register32    // 0x14
	ASYNCH     volatile.Register32    // 0x18
	CONFIG     [1]volatile.Register32 // 0x1C
	_          [16]byte
	DEBOUNCEN  volatile.Register32 // 0x30
	DPRESCALER volatile.Register32 // 0x34
	PINSTATE   volatile.Register32 // 0x38
	NSCHK      volatile.Register32 // 0x3C
	NONSEC     volatile.Register32 // 0x40
}

// Event System Interface
type EVSYS_Type struct {
	CTRLA     volatile.Register8 // 0x0
	_         [3]byte
	SWEVT     volatile.Register32 // 0x4
	PRICTRL   volatile.Register8  // 0x8
	_         [7]byte
	INTPEND   volatile.Register16 // 0x10
	_         [2]byte
	INTSTATUS volatile.Register32 // 0x14
	BUSYCH    volatile.Register32 // 0x18
	READYUSR  volatile.Register32 // 0x1C
	CHANNEL   [8]struct {
		CHANNEL    volatile.Register32
		CHINTENCLR volatile.Register8
		CHINTENSET volatile.Register8
		CHINTFLAG  volatile.Register8
		CHSTATUS   volatile.Register8
	} // 0x20
	_          [192]byte
	USER       [23]volatile.Register8 // 0x120
	_          [157]byte
	INTENCLR   volatile.Register8 // 0x1D4
	INTENSET   volatile.Register8 // 0x1D5
	INTFLAG    volatile.Register8 // 0x1D6
	_          byte
	NONSECCHAN volatile.Register32    // 0x1D8
	NSCHKCHAN  volatile.Register32    // 0x1DC
	NONSECUSER [1]volatile.Register32 // 0x1E0
	_          [12]byte
	NSCHKUSER  [1]volatile.Register32 // 0x1F0
}

// Frequency Meter
type FREQM_Type struct {
	CTRLA    volatile.Register8  // 0x0
	CTRLB    volatile.Register8  // 0x1
	CFGA     volatile.Register16 // 0x2
	_        [4]byte
	INTENCLR volatile.Register8  // 0x8
	INTENSET volatile.Register8  // 0x9
	INTFLAG  volatile.Register8  // 0xA
	STATUS   volatile.Register8  // 0xB
	SYNCBUSY volatile.Register32 // 0xC
	VALUE    volatile.Register32 // 0x10
}

// Generic Clock Generator
type GCLK_Type struct {
	CTRLA    volatile.Register8 // 0x0
	_        [3]byte
	SYNCBUSY volatile.Register32 // 0x4
	_        [24]byte
	GENCTRL  [5]volatile.Register32 // 0x20
	_        [76]byte
	PCHCTRL  [21]volatile.Register32 // 0x80
}

// Implementation Defined Attribution Unit
type IDAU_Type struct {
	_       byte
	SECCTRL volatile.Register8 // 0x1
	_       [2]byte
	SCFGB   volatile.Register32 // 0x4
	SCFGA   volatile.Register32 // 0x8
	SCFGR   volatile.Register8  // 0xC
}

// Main Clock
type MCLK_Type struct {
	CTRLA    volatile.Register8 // 0x0
	INTENCLR volatile.Register8 // 0x1
	INTENSET volatile.Register8 // 0x2
	INTFLAG  volatile.Register8 // 0x3
	CPUDIV   volatile.Register8 // 0x4
	_        [11]byte
	AHBMASK  volatile.Register32 // 0x10
	APBAMASK volatile.Register32 // 0x14
	APBBMASK volatile.Register32 // 0x18
	APBCMASK volatile.Register32 // 0x1C
}

// Non-Volatile Memory Controller
type NVMCTRL_Type struct {
	CTRLA    volatile.Register16 // 0x0
	_        [2]byte
	CTRLB    volatile.Register32 // 0x4
	CTRLC    volatile.Register8  // 0x8
	_        byte
	EVCTRL   volatile.Register8 // 0xA
	_        byte
	INTENCLR volatile.Register8 // 0xC
	_        [3]byte
	INTENSET volatile.Register8 // 0x10
	_        [3]byte
	INTFLAG  volatile.Register8 // 0x14
	_        [3]byte
	STATUS   volatile.Register16 // 0x18
	_        [2]byte
	ADDR     volatile.Register32 // 0x1C
	SULCK    volatile.Register16 // 0x20
	NSULCK   volatile.Register16 // 0x22
	PARAM    volatile.Register32 // 0x24
	_        [8]byte
	DSCC     volatile.Register32 // 0x30
	SECCTRL  volatile.Register32 // 0x34
	SCFGB    volatile.Register32 // 0x38
	SCFGAD   volatile.Register32 // 0x3C
	NONSEC   volatile.Register32 // 0x40
	NSCHK    volatile.Register32 // 0x44
}

// Operational Amplifier
type OPAMP_Type struct {
	CTRLA     volatile.Register8 // 0x0
	_         byte
	STATUS    volatile.Register8 // 0x2
	_         byte
	OPAMPCTRL [3]volatile.Register32 // 0x4
	RESCTRL   volatile.Register8     // 0x10
}

// Oscillators Control
type OSCCTRL_Type struct {
	EVCTRL          volatile.Register8 // 0x0
	_               [3]byte
	INTENCLR        volatile.Register32 // 0x4
	INTENSET        volatile.Register32 // 0x8
	INTFLAG         volatile.Register32 // 0xC
	STATUS          volatile.Register32 // 0x10
	XOSCCTRL        volatile.Register16 // 0x14
	CFDPRESC        volatile.Register8  // 0x16
	_               byte
	OSC16MCTRL      volatile.Register8 // 0x18
	_               [3]byte
	DFLLULPCTRL     volatile.Register16 // 0x1C
	DFLLULPDITHER   volatile.Register8  // 0x1E
	DFLLULPRREQ     volatile.Register8  // 0x1F
	DFLLULPDLY      volatile.Register32 // 0x20
	DFLLULPRATIO    volatile.Register32 // 0x24
	DFLLULPSYNCBUSY volatile.Register32 // 0x28
	DPLLCTRLA       volatile.Register8  // 0x2C
	_               [3]byte
	DPLLRATIO       volatile.Register32 // 0x30
	DPLLCTRLB       volatile.Register32 // 0x34
	DPLLPRESC       volatile.Register8  // 0x38
	_               [3]byte
	DPLLSYNCBUSY    volatile.Register8 // 0x3C
	_               [3]byte
	DPLLSTATUS      volatile.Register8 // 0x40
}

// 32k Oscillators Control
type OSC32KCTRL_Type struct {
	INTENCLR  volatile.Register32 // 0x0
	INTENSET  volatile.Register32 // 0x4
	INTFLAG   volatile.Register32 // 0x8
	STATUS    volatile.Register32 // 0xC
	RTCCTRL   volatile.Register8  // 0x10
	_         [3]byte
	XOSC32K   volatile.Register16 // 0x14
	CFDCTRL   volatile.Register8  // 0x16
	EVCTRL    volatile.Register8  // 0x17
	_         [4]byte
	OSCULP32K volatile.Register32 // 0x1C
}

// Peripheral Access Controller
type PAC_Type struct {
	WRCTRL     volatile.Register32 // 0x0
	EVCTRL     volatile.Register8  // 0x4
	_          [3]byte
	INTENCLR   volatile.Register8 // 0x8
	INTENSET   volatile.Register8 // 0x9
	_          [6]byte
	INTFLAGAHB volatile.Register32 // 0x10
	INTFLAGA   volatile.Register32 // 0x14
	INTFLAGB   volatile.Register32 // 0x18
	INTFLAGC   volatile.Register32 // 0x1C
	_          [20]byte
	STATUSA    volatile.Register32 // 0x34
	STATUSB    volatile.Register32 // 0x38
	STATUSC    volatile.Register32 // 0x3C
	_          [20]byte
	NONSECA    volatile.Register32 // 0x54
	NONSECB    volatile.Register32 // 0x58
	NONSECC    volatile.Register32 // 0x5C
	_          [20]byte
	SECLOCKA   volatile.Register32 // 0x74
	SECLOCKB   volatile.Register32 // 0x78
	SECLOCKC   volatile.Register32 // 0x7C
}

// Power Manager
type PM_Type struct {
	_        byte
	SLEEPCFG volatile.Register8 // 0x1
	PLCFG    volatile.Register8 // 0x2
	PWCFG    volatile.Register8 // 0x3
	INTENCLR volatile.Register8 // 0x4
	INTENSET volatile.Register8 // 0x5
	INTFLAG  volatile.Register8 // 0x6
	_        byte
	STDBYCFG volatile.Register16 // 0x8
}

// Port Module
type PORT_Type struct {
	GROUP [1]struct {
		DIR      volatile.Register32
		DIRCLR   volatile.Register32
		DIRSET   volatile.Register32
		DIRTGL   volatile.Register32
		OUT      volatile.Register32
		OUTCLR   volatile.Register32
		OUTSET   volatile.Register32
		OUTTGL   volatile.Register32
		IN       volatile.Register32
		CTRL     volatile.Register32
		WRCONFIG volatile.Register32
		EVCTRL   volatile.Register32
		PMUX     [16]volatile.Register8
		PINCFG   [32]volatile.Register8
		INTENCLR volatile.Register32
		INTENSET volatile.Register32
		INTFLAG  volatile.Register32
		NONSEC   volatile.Register32
		NSCHK    volatile.Register32
		_        [18446744073709551612]byte
	} // 0x0
}

// Peripheral Touch Controller
type PTC_Type struct {
}

// Reset Controller
type RSTC_Type struct {
	RCAUSE volatile.Register8 // 0x0
}

// Real-Time Counter
type RTC_Type struct {
}

// Real-Time Counter - MODE0
type RTC_MODE0_Type struct {
	CTRLA     volatile.Register16 // 0x0
	CTRLB     volatile.Register16 // 0x2
	EVCTRL    volatile.Register32 // 0x4
	INTENCLR  volatile.Register16 // 0x8
	INTENSET  volatile.Register16 // 0xA
	INTFLAG   volatile.Register16 // 0xC
	DBGCTRL   volatile.Register8  // 0xE
	_         byte
	SYNCBUSY  volatile.Register32 // 0x10
	FREQCORR  volatile.Register8  // 0x14
	_         [3]byte
	COUNT     volatile.Register32 // 0x18
	_         [4]byte
	COMP      [1]volatile.Register32 // 0x20
	_         [28]byte
	GP        [2]volatile.Register32 // 0x40
	_         [24]byte
	TAMPCTRL  volatile.Register32 // 0x60
	TIMESTAMP volatile.Register32 // 0x64
	TAMPID    volatile.Register32 // 0x68
	TAMPCTRLB volatile.Register32 // 0x6C
}

// Real-Time Counter - MODE1
type RTC_MODE1_Type struct {
	CTRLA     volatile.Register16 // 0x0
	CTRLB     volatile.Register16 // 0x2
	EVCTRL    volatile.Register32 // 0x4
	INTENCLR  volatile.Register16 // 0x8
	INTENSET  volatile.Register16 // 0xA
	INTFLAG   volatile.Register16 // 0xC
	DBGCTRL   volatile.Register8  // 0xE
	_         byte
	SYNCBUSY  volatile.Register32 // 0x10
	FREQCORR  volatile.Register8  // 0x14
	_         [3]byte
	COUNT     volatile.Register16 // 0x18
	_         [2]byte
	PER       volatile.Register16 // 0x1C
	_         [2]byte
	COMP      [2]volatile.Register16 // 0x20
	_         [28]byte
	GP        [2]volatile.Register32 // 0x40
	_         [24]byte
	TAMPCTRL  volatile.Register32 // 0x60
	TIMESTAMP volatile.Register32 // 0x64
	TAMPID    volatile.Register32 // 0x68
	TAMPCTRLB volatile.Register32 // 0x6C
}

// Real-Time Counter - MODE2
type RTC_MODE2_Type struct {
	CTRLA     volatile.Register16 // 0x0
	CTRLB     volatile.Register16 // 0x2
	EVCTRL    volatile.Register32 // 0x4
	INTENCLR  volatile.Register16 // 0x8
	INTENSET  volatile.Register16 // 0xA
	INTFLAG   volatile.Register16 // 0xC
	DBGCTRL   volatile.Register8  // 0xE
	_         byte
	SYNCBUSY  volatile.Register32 // 0x10
	FREQCORR  volatile.Register8  // 0x14
	_         [3]byte
	CLOCK     volatile.Register32 // 0x18
	_         [4]byte
	ALARM     volatile.Register32 // 0x20
	MASK      volatile.Register8  // 0x24
	_         [27]byte
	GP        [2]volatile.Register32 // 0x40
	_         [24]byte
	TAMPCTRL  volatile.Register32 // 0x60
	TIMESTAMP volatile.Register32 // 0x64
	TAMPID    volatile.Register32 // 0x68
	TAMPCTRLB volatile.Register32 // 0x6C
}

// Serial Communication Interface
type SERCOM_Type struct {
}

// Serial Communication Interface - I2CM
type SERCOM_I2CM_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [4]byte
	BAUD     volatile.Register32 // 0xC
	_        [4]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register8  // 0x28
	_        [7]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// Serial Communication Interface - I2CS
type SERCOM_I2CS_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [12]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register8  // 0x28
}

// Serial Communication Interface - SPI
type SERCOM_SPI_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [4]byte
	BAUD     volatile.Register8 // 0xC
	_        [7]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register32 // 0x28
	_        [4]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// Serial Communication Interface - USART
type SERCOM_USART_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	CTRLC    volatile.Register32 // 0x8
	BAUD     volatile.Register16 // 0xC
	RXPL     volatile.Register8  // 0xE
	_        [5]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	RXERRCNT volatile.Register8  // 0x20
	_        [7]byte
	DATA     volatile.Register16 // 0x28
	_        [6]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// Supply Controller
type SUPC_Type struct {
	INTENCLR volatile.Register32 // 0x0
	INTENSET volatile.Register32 // 0x4
	INTFLAG  volatile.Register32 // 0x8
	STATUS   volatile.Register32 // 0xC
	BOD33    volatile.Register32 // 0x10
	BOD12    volatile.Register32 // 0x14
	VREG     volatile.Register32 // 0x18
	VREF     volatile.Register32 // 0x1C
	_        [12]byte
	EVCTRL   volatile.Register32 // 0x2C
	VREGSUSP volatile.Register32 // 0x30
}

// Basic Timer Counter
type TC_Type struct {
}

// Basic Timer Counter - COUNT8
type TC_COUNT8_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	EVCTRL   volatile.Register16 // 0x6
	INTENCLR volatile.Register8  // 0x8
	INTENSET volatile.Register8  // 0x9
	INTFLAG  volatile.Register8  // 0xA
	STATUS   volatile.Register8  // 0xB
	WAVE     volatile.Register8  // 0xC
	DRVCTRL  volatile.Register8  // 0xD
	_        byte
	DBGCTRL  volatile.Register8  // 0xF
	SYNCBUSY volatile.Register32 // 0x10
	COUNT    volatile.Register8  // 0x14
	_        [6]byte
	PER      volatile.Register8    // 0x1B
	CC       [2]volatile.Register8 // 0x1C
	_        [17]byte
	PERBUF   volatile.Register8    // 0x2F
	CCBUF    [2]volatile.Register8 // 0x30
}

// Basic Timer Counter - COUNT16
type TC_COUNT16_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	EVCTRL   volatile.Register16 // 0x6
	INTENCLR volatile.Register8  // 0x8
	INTENSET volatile.Register8  // 0x9
	INTFLAG  volatile.Register8  // 0xA
	STATUS   volatile.Register8  // 0xB
	WAVE     volatile.Register8  // 0xC
	DRVCTRL  volatile.Register8  // 0xD
	_        byte
	DBGCTRL  volatile.Register8  // 0xF
	SYNCBUSY volatile.Register32 // 0x10
	COUNT    volatile.Register16 // 0x14
	_        [4]byte
	PER      volatile.Register16    // 0x1A
	CC       [2]volatile.Register16 // 0x1C
	_        [14]byte
	PERBUF   volatile.Register16    // 0x2E
	CCBUF    [2]volatile.Register16 // 0x30
}

// Basic Timer Counter - COUNT32
type TC_COUNT32_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	EVCTRL   volatile.Register16 // 0x6
	INTENCLR volatile.Register8  // 0x8
	INTENSET volatile.Register8  // 0x9
	INTFLAG  volatile.Register8  // 0xA
	STATUS   volatile.Register8  // 0xB
	WAVE     volatile.Register8  // 0xC
	DRVCTRL  volatile.Register8  // 0xD
	_        byte
	DBGCTRL  volatile.Register8     // 0xF
	SYNCBUSY volatile.Register32    // 0x10
	COUNT    volatile.Register32    // 0x14
	PER      volatile.Register32    // 0x18
	CC       [2]volatile.Register32 // 0x1C
	_        [8]byte
	PERBUF   volatile.Register32    // 0x2C
	CCBUF    [2]volatile.Register32 // 0x30
}

// TrustRAM
type TRAM_Type struct {
	CTRLA    volatile.Register8 // 0x0
	_        [3]byte
	INTENCLR volatile.Register8  // 0x4
	INTENSET volatile.Register8  // 0x5
	INTFLAG  volatile.Register8  // 0x6
	STATUS   volatile.Register8  // 0x7
	SYNCBUSY volatile.Register32 // 0x8
	DSCC     volatile.Register32 // 0xC
	PERMW    volatile.Register8  // 0x10
	PERMR    volatile.Register8  // 0x11
	_        [238]byte
	RAM      [64]volatile.Register32 // 0x100
}

// True Random Generator
type TRNG_Type struct {
	CTRLA    volatile.Register8 // 0x0
	_        [3]byte
	EVCTRL   volatile.Register8 // 0x4
	_        [3]byte
	INTENCLR volatile.Register8 // 0x8
	INTENSET volatile.Register8 // 0x9
	INTFLAG  volatile.Register8 // 0xA
	_        [21]byte
	DATA     volatile.Register32 // 0x20
}

// Watchdog Timer
type WDT_Type struct {
	CTRLA    volatile.Register8 // 0x0
	CONFIG   volatile.Register8 // 0x1
	EWCTRL   volatile.Register8 // 0x2
	_        byte
	INTENCLR volatile.Register8 // 0x4
	INTENSET volatile.Register8 // 0x5
	INTFLAG  volatile.Register8 // 0x6
	_        byte
	SYNCBUSY volatile.Register32 // 0x8
	CLEAR    volatile.Register8  // 0xC
}

// Debug Control Block
type CoreDebug_Type struct {
	DHCSR     volatile.Register32 // 0x0
	DCRSR     volatile.Register32 // 0x4
	_         [4]byte
	DEMCR     volatile.Register32 // 0xC
	_         [4]byte
	DAUTHCTRL volatile.Register32 // 0x14
	DSCSR     volatile.Register32 // 0x18
}

// Debug Identification Block
type DIB_Type struct {
	DLAR        volatile.Register32 // 0x0
	DLSR        volatile.Register32 // 0x4
	DAUTHSTATUS volatile.Register32 // 0x8
	DDEVARCH    volatile.Register32 // 0xC
	_           [12]byte
	DDEVTYPE    volatile.Register32 // 0x1C
	DPIDR4      volatile.Register32 // 0x20
	DPIDR5      volatile.Register32 // 0x24
	DPIDR6      volatile.Register32 // 0x28
	DPIDR7      volatile.Register32 // 0x2C
	DPIDR0      volatile.Register32 // 0x30
	DPIDR1      volatile.Register32 // 0x34
	DPIDR2      volatile.Register32 // 0x38
	DPIDR3      volatile.Register32 // 0x3C
	DCIDR0      volatile.Register32 // 0x40
	DCIDR1      volatile.Register32 // 0x44
	DCIDR2      volatile.Register32 // 0x48
	DCIDR3      volatile.Register32 // 0x4C
}

// Data Watchpoint and Trace
type DWT_Type struct {
	DWT_CTRL   volatile.Register32 // 0x0
	_          [24]byte
	DWT_PCSR   volatile.Register32 // 0x1C
	COMPARATOR [2]struct {
		DWT_COMP     volatile.Register32
		_            [4]byte
		DWT_FUNCTION volatile.Register32
		_            [4]byte
	} // 0x20
	_           [3952]byte
	DWT_LAR     volatile.Register32 // 0xFB0
	DWT_LSR     volatile.Register32 // 0xFB4
	_           [4]byte
	DWT_DEVARCH volatile.Register32 // 0xFBC
	_           [12]byte
	DWT_DEVTYPE volatile.Register32 // 0xFCC
	DWT_PIDR4   volatile.Register32 // 0xFD0
	DWT_PIDR5   volatile.Register32 // 0xFD4
	DWT_PIDR6   volatile.Register32 // 0xFD8
	DWT_PIDR7   volatile.Register32 // 0xFDC
	DWT_PIDR0   volatile.Register32 // 0xFE0
	DWT_PIDR1   volatile.Register32 // 0xFE4
	DWT_PIDR2   volatile.Register32 // 0xFE8
	DWT_PIDR3   volatile.Register32 // 0xFEC
	DWT_CIDR0   volatile.Register32 // 0xFF0
	DWT_CIDR1   volatile.Register32 // 0xFF4
	DWT_CIDR2   volatile.Register32 // 0xFF8
	DWT_CIDR3   volatile.Register32 // 0xFFC
}

// Flash Patch and Breakpoint
type FPB_Type struct {
	FP_CTRL    volatile.Register32    // 0x0
	FP_REMAP   volatile.Register32    // 0x4
	FP_COMP    [4]volatile.Register32 // 0x8
	_          [3992]byte
	FP_LAR     volatile.Register32 // 0xFB0
	FP_LSR     volatile.Register32 // 0xFB4
	_          [4]byte
	FP_DEVARCH volatile.Register32 // 0xFBC
	_          [12]byte
	FP_DEVTYPE volatile.Register32 // 0xFCC
	FP_PIDR4   volatile.Register32 // 0xFD0
	FP_PIDR5   volatile.Register32 // 0xFD4
	FP_PIDR6   volatile.Register32 // 0xFD8
	FP_PIDR7   volatile.Register32 // 0xFDC
	FP_PIDR0   volatile.Register32 // 0xFE0
	FP_PIDR1   volatile.Register32 // 0xFE4
	FP_PIDR2   volatile.Register32 // 0xFE8
	FP_PIDR3   volatile.Register32 // 0xFEC
	FP_CIDR0   volatile.Register32 // 0xFF0
	FP_CIDR1   volatile.Register32 // 0xFF4
	FP_CIDR2   volatile.Register32 // 0xFF8
	FP_CIDR3   volatile.Register32 // 0xFFC
}

// Implementation Control Block
type ICB_Type struct {
	_     [4]byte
	ICTR  volatile.Register32 // 0x4
	ACTLR volatile.Register32 // 0x8
}

// Memory Protection Unit
type MPU_Type struct {
	MPU_TYPE  volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RLAR  volatile.Register32 // 0x10
	_         [28]byte
	MPU_MAIR0 volatile.Register32 // 0x30
	MPU_MAIR1 volatile.Register32 // 0x34
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	NVIC_ISER [2]volatile.Register32 // 0x0
	_         [120]byte
	NVIC_ICER [2]volatile.Register32 // 0x80
	_         [120]byte
	NVIC_ISPR [2]volatile.Register32 // 0x100
	_         [120]byte
	NVIC_ICPR [2]volatile.Register32 // 0x180
	_         [120]byte
	NVIC_IABR [2]volatile.Register32 // 0x200
	_         [120]byte
	NVIC_ITNS [2]volatile.Register32 // 0x280
	_         [120]byte
	NVIC_IPR  [12]volatile.Register32 // 0x300
}

// System Control Block
type SCB_Type struct {
	CPUID  volatile.Register32 // 0x0
	ICSR   volatile.Register32 // 0x4
	VTOR   volatile.Register32 // 0x8
	AIRCR  volatile.Register32 // 0xC
	SCR    volatile.Register32 // 0x10
	CCR    volatile.Register32 // 0x14
	_      [4]byte
	SHPR2  volatile.Register32 // 0x1C
	SHPR3  volatile.Register32 // 0x20
	SHCSR  volatile.Register32 // 0x24
	_      [8]byte
	DFSR   volatile.Register32 // 0x30
	_      [8]byte
	AFSR   volatile.Register32 // 0x3C
	_      [56]byte
	CLIDR  volatile.Register32 // 0x78
	CTR    volatile.Register32 // 0x7C
	CCSIDR volatile.Register32 // 0x80
	CSSELR volatile.Register32 // 0x84
}

// SysTick Timer
type SysTick_Type struct {
	SYST_CSR   volatile.Register32 // 0x0
	SYST_RVR   volatile.Register32 // 0x4
	SYST_CVR   volatile.Register32 // 0x8
	SYST_CALIB volatile.Register32 // 0xC
}

// Bitfields for AC: Analog Comparators
const (
	// CTRLA: Control A
	AC_CTRLA_SWRST_Pos  = 0x0 // Position of SWRST field.
	AC_CTRLA_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	AC_CTRLA_SWRST      = 0x1 // Bit SWRST.
	AC_CTRLA_ENABLE_Pos = 0x1 // Position of ENABLE field.
	AC_CTRLA_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	AC_CTRLA_ENABLE     = 0x2 // Bit ENABLE.

	// CTRLB: Control B
	AC_CTRLB_START0_Pos = 0x0 // Position of START0 field.
	AC_CTRLB_START0_Msk = 0x1 // Bit mask of START0 field.
	AC_CTRLB_START0     = 0x1 // Bit START0.
	AC_CTRLB_START1_Pos = 0x1 // Position of START1 field.
	AC_CTRLB_START1_Msk = 0x2 // Bit mask of START1 field.
	AC_CTRLB_START1     = 0x2 // Bit START1.

	// EVCTRL: Event Control
	AC_EVCTRL_COMPEO0_Pos = 0x0    // Position of COMPEO0 field.
	AC_EVCTRL_COMPEO0_Msk = 0x1    // Bit mask of COMPEO0 field.
	AC_EVCTRL_COMPEO0     = 0x1    // Bit COMPEO0.
	AC_EVCTRL_COMPEO1_Pos = 0x1    // Position of COMPEO1 field.
	AC_EVCTRL_COMPEO1_Msk = 0x2    // Bit mask of COMPEO1 field.
	AC_EVCTRL_COMPEO1     = 0x2    // Bit COMPEO1.
	AC_EVCTRL_WINEO0_Pos  = 0x4    // Position of WINEO0 field.
	AC_EVCTRL_WINEO0_Msk  = 0x10   // Bit mask of WINEO0 field.
	AC_EVCTRL_WINEO0      = 0x10   // Bit WINEO0.
	AC_EVCTRL_COMPEI0_Pos = 0x8    // Position of COMPEI0 field.
	AC_EVCTRL_COMPEI0_Msk = 0x100  // Bit mask of COMPEI0 field.
	AC_EVCTRL_COMPEI0     = 0x100  // Bit COMPEI0.
	AC_EVCTRL_COMPEI1_Pos = 0x9    // Position of COMPEI1 field.
	AC_EVCTRL_COMPEI1_Msk = 0x200  // Bit mask of COMPEI1 field.
	AC_EVCTRL_COMPEI1     = 0x200  // Bit COMPEI1.
	AC_EVCTRL_INVEI0_Pos  = 0xc    // Position of INVEI0 field.
	AC_EVCTRL_INVEI0_Msk  = 0x1000 // Bit mask of INVEI0 field.
	AC_EVCTRL_INVEI0      = 0x1000 // Bit INVEI0.
	AC_EVCTRL_INVEI1_Pos  = 0xd    // Position of INVEI1 field.
	AC_EVCTRL_INVEI1_Msk  = 0x2000 // Bit mask of INVEI1 field.
	AC_EVCTRL_INVEI1      = 0x2000 // Bit INVEI1.

	// INTENCLR: Interrupt Enable Clear
	AC_INTENCLR_COMP0_Pos = 0x0  // Position of COMP0 field.
	AC_INTENCLR_COMP0_Msk = 0x1  // Bit mask of COMP0 field.
	AC_INTENCLR_COMP0     = 0x1  // Bit COMP0.
	AC_INTENCLR_COMP1_Pos = 0x1  // Position of COMP1 field.
	AC_INTENCLR_COMP1_Msk = 0x2  // Bit mask of COMP1 field.
	AC_INTENCLR_COMP1     = 0x2  // Bit COMP1.
	AC_INTENCLR_WIN0_Pos  = 0x4  // Position of WIN0 field.
	AC_INTENCLR_WIN0_Msk  = 0x10 // Bit mask of WIN0 field.
	AC_INTENCLR_WIN0      = 0x10 // Bit WIN0.

	// INTENSET: Interrupt Enable Set
	AC_INTENSET_COMP0_Pos = 0x0  // Position of COMP0 field.
	AC_INTENSET_COMP0_Msk = 0x1  // Bit mask of COMP0 field.
	AC_INTENSET_COMP0     = 0x1  // Bit COMP0.
	AC_INTENSET_COMP1_Pos = 0x1  // Position of COMP1 field.
	AC_INTENSET_COMP1_Msk = 0x2  // Bit mask of COMP1 field.
	AC_INTENSET_COMP1     = 0x2  // Bit COMP1.
	AC_INTENSET_WIN0_Pos  = 0x4  // Position of WIN0 field.
	AC_INTENSET_WIN0_Msk  = 0x10 // Bit mask of WIN0 field.
	AC_INTENSET_WIN0      = 0x10 // Bit WIN0.

	// INTFLAG: Interrupt Flag Status and Clear
	AC_INTFLAG_COMP0_Pos = 0x0  // Position of COMP0 field.
	AC_INTFLAG_COMP0_Msk = 0x1  // Bit mask of COMP0 field.
	AC_INTFLAG_COMP0     = 0x1  // Bit COMP0.
	AC_INTFLAG_COMP1_Pos = 0x1  // Position of COMP1 field.
	AC_INTFLAG_COMP1_Msk = 0x2  // Bit mask of COMP1 field.
	AC_INTFLAG_COMP1     = 0x2  // Bit COMP1.
	AC_INTFLAG_WIN0_Pos  = 0x4  // Position of WIN0 field.
	AC_INTFLAG_WIN0_Msk  = 0x10 // Bit mask of WIN0 field.
	AC_INTFLAG_WIN0      = 0x10 // Bit WIN0.

	// STATUSA: Status A
	AC_STATUSA_STATE0_Pos     = 0x0  // Position of STATE0 field.
	AC_STATUSA_STATE0_Msk     = 0x1  // Bit mask of STATE0 field.
	AC_STATUSA_STATE0         = 0x1  // Bit STATE0.
	AC_STATUSA_STATE1_Pos     = 0x1  // Position of STATE1 field.
	AC_STATUSA_STATE1_Msk     = 0x2  // Bit mask of STATE1 field.
	AC_STATUSA_STATE1         = 0x2  // Bit STATE1.
	AC_STATUSA_WSTATE0_Pos    = 0x4  // Position of WSTATE0 field.
	AC_STATUSA_WSTATE0_Msk    = 0x30 // Bit mask of WSTATE0 field.
	AC_STATUSA_WSTATE0_ABOVE  = 0x0  // Signal is above window
	AC_STATUSA_WSTATE0_INSIDE = 0x1  // Signal is inside window
	AC_STATUSA_WSTATE0_BELOW  = 0x2  // Signal is below window

	// STATUSB: Status B
	AC_STATUSB_READY0_Pos = 0x0 // Position of READY0 field.
	AC_STATUSB_READY0_Msk = 0x1 // Bit mask of READY0 field.
	AC_STATUSB_READY0     = 0x1 // Bit READY0.
	AC_STATUSB_READY1_Pos = 0x1 // Position of READY1 field.
	AC_STATUSB_READY1_Msk = 0x2 // Bit mask of READY1 field.
	AC_STATUSB_READY1     = 0x2 // Bit READY1.

	// DBGCTRL: Debug Control
	AC_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	AC_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	AC_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// WINCTRL: Window Control
	AC_WINCTRL_WEN0_Pos         = 0x0 // Position of WEN0 field.
	AC_WINCTRL_WEN0_Msk         = 0x1 // Bit mask of WEN0 field.
	AC_WINCTRL_WEN0             = 0x1 // Bit WEN0.
	AC_WINCTRL_WINTSEL0_Pos     = 0x1 // Position of WINTSEL0 field.
	AC_WINCTRL_WINTSEL0_Msk     = 0x6 // Bit mask of WINTSEL0 field.
	AC_WINCTRL_WINTSEL0_ABOVE   = 0x0 // Interrupt on signal above window
	AC_WINCTRL_WINTSEL0_INSIDE  = 0x1 // Interrupt on signal inside window
	AC_WINCTRL_WINTSEL0_BELOW   = 0x2 // Interrupt on signal below window
	AC_WINCTRL_WINTSEL0_OUTSIDE = 0x3 // Interrupt on signal outside window

	// SCALER: Scaler n
	AC_SCALER_VALUE_Pos = 0x0  // Position of VALUE field.
	AC_SCALER_VALUE_Msk = 0x3f // Bit mask of VALUE field.

	// COMPCTRL: Comparator Control n
	AC_COMPCTRL_ENABLE_Pos     = 0x1        // Position of ENABLE field.
	AC_COMPCTRL_ENABLE_Msk     = 0x2        // Bit mask of ENABLE field.
	AC_COMPCTRL_ENABLE         = 0x2        // Bit ENABLE.
	AC_COMPCTRL_SINGLE_Pos     = 0x2        // Position of SINGLE field.
	AC_COMPCTRL_SINGLE_Msk     = 0x4        // Bit mask of SINGLE field.
	AC_COMPCTRL_SINGLE         = 0x4        // Bit SINGLE.
	AC_COMPCTRL_INTSEL_Pos     = 0x3        // Position of INTSEL field.
	AC_COMPCTRL_INTSEL_Msk     = 0x18       // Bit mask of INTSEL field.
	AC_COMPCTRL_INTSEL_TOGGLE  = 0x0        // Interrupt on comparator output toggle
	AC_COMPCTRL_INTSEL_RISING  = 0x1        // Interrupt on comparator output rising
	AC_COMPCTRL_INTSEL_FALLING = 0x2        // Interrupt on comparator output falling
	AC_COMPCTRL_INTSEL_EOC     = 0x3        // Interrupt on end of comparison (single-shot mode only)
	AC_COMPCTRL_RUNSTDBY_Pos   = 0x6        // Position of RUNSTDBY field.
	AC_COMPCTRL_RUNSTDBY_Msk   = 0x40       // Bit mask of RUNSTDBY field.
	AC_COMPCTRL_RUNSTDBY       = 0x40       // Bit RUNSTDBY.
	AC_COMPCTRL_MUXNEG_Pos     = 0x8        // Position of MUXNEG field.
	AC_COMPCTRL_MUXNEG_Msk     = 0x700      // Bit mask of MUXNEG field.
	AC_COMPCTRL_MUXNEG_PIN0    = 0x0        // I/O pin 0
	AC_COMPCTRL_MUXNEG_PIN1    = 0x1        // I/O pin 1
	AC_COMPCTRL_MUXNEG_PIN2    = 0x2        // I/O pin 2
	AC_COMPCTRL_MUXNEG_PIN3    = 0x3        // I/O pin 3
	AC_COMPCTRL_MUXNEG_GND     = 0x4        // Ground
	AC_COMPCTRL_MUXNEG_VSCALE  = 0x5        // VDD scaler
	AC_COMPCTRL_MUXNEG_BANDGAP = 0x6        // Internal bandgap voltage
	AC_COMPCTRL_MUXNEG_OPAMP   = 0x7        // OPAMP output (on AC1)
	AC_COMPCTRL_MUXNEG_DAC     = 0x7        // DAC output (on AC0)
	AC_COMPCTRL_MUXPOS_Pos     = 0xc        // Position of MUXPOS field.
	AC_COMPCTRL_MUXPOS_Msk     = 0x7000     // Bit mask of MUXPOS field.
	AC_COMPCTRL_MUXPOS_PIN0    = 0x0        // I/O pin 0
	AC_COMPCTRL_MUXPOS_PIN1    = 0x1        // I/O pin 1
	AC_COMPCTRL_MUXPOS_PIN2    = 0x2        // I/O pin 2
	AC_COMPCTRL_MUXPOS_PIN3    = 0x3        // I/O pin 3
	AC_COMPCTRL_MUXPOS_VSCALE  = 0x4        // VDD Scaler
	AC_COMPCTRL_SWAP_Pos       = 0xf        // Position of SWAP field.
	AC_COMPCTRL_SWAP_Msk       = 0x8000     // Bit mask of SWAP field.
	AC_COMPCTRL_SWAP           = 0x8000     // Bit SWAP.
	AC_COMPCTRL_SPEED_Pos      = 0x10       // Position of SPEED field.
	AC_COMPCTRL_SPEED_Msk      = 0x30000    // Bit mask of SPEED field.
	AC_COMPCTRL_SPEED_LOW      = 0x0        // Low speed
	AC_COMPCTRL_SPEED_MEDLOW   = 0x1        // Medium low speed
	AC_COMPCTRL_SPEED_MEDHIGH  = 0x2        // Medium high speed
	AC_COMPCTRL_SPEED_HIGH     = 0x3        // High speed
	AC_COMPCTRL_HYSTEN_Pos     = 0x13       // Position of HYSTEN field.
	AC_COMPCTRL_HYSTEN_Msk     = 0x80000    // Bit mask of HYSTEN field.
	AC_COMPCTRL_HYSTEN         = 0x80000    // Bit HYSTEN.
	AC_COMPCTRL_HYST_Pos       = 0x14       // Position of HYST field.
	AC_COMPCTRL_HYST_Msk       = 0x300000   // Bit mask of HYST field.
	AC_COMPCTRL_HYST_HYST50    = 0x0        // 50mV
	AC_COMPCTRL_HYST_HYST70    = 0x1        // 70mV
	AC_COMPCTRL_HYST_HYST90    = 0x2        // 90mV
	AC_COMPCTRL_HYST_HYST110   = 0x3        // 110mV
	AC_COMPCTRL_FLEN_Pos       = 0x18       // Position of FLEN field.
	AC_COMPCTRL_FLEN_Msk       = 0x7000000  // Bit mask of FLEN field.
	AC_COMPCTRL_FLEN_OFF       = 0x0        // No filtering
	AC_COMPCTRL_FLEN_MAJ3      = 0x1        // 3-bit majority function (2 of 3)
	AC_COMPCTRL_FLEN_MAJ5      = 0x2        // 5-bit majority function (3 of 5)
	AC_COMPCTRL_OUT_Pos        = 0x1c       // Position of OUT field.
	AC_COMPCTRL_OUT_Msk        = 0x30000000 // Bit mask of OUT field.
	AC_COMPCTRL_OUT_OFF        = 0x0        // The output of COMPn is not routed to the COMPn I/O port
	AC_COMPCTRL_OUT_ASYNC      = 0x1        // The asynchronous output of COMPn is routed to the COMPn I/O port
	AC_COMPCTRL_OUT_SYNC       = 0x2        // The synchronous output (including filtering) of COMPn is routed to the COMPn I/O port

	// SYNCBUSY: Synchronization Busy
	AC_SYNCBUSY_SWRST_Pos     = 0x0  // Position of SWRST field.
	AC_SYNCBUSY_SWRST_Msk     = 0x1  // Bit mask of SWRST field.
	AC_SYNCBUSY_SWRST         = 0x1  // Bit SWRST.
	AC_SYNCBUSY_ENABLE_Pos    = 0x1  // Position of ENABLE field.
	AC_SYNCBUSY_ENABLE_Msk    = 0x2  // Bit mask of ENABLE field.
	AC_SYNCBUSY_ENABLE        = 0x2  // Bit ENABLE.
	AC_SYNCBUSY_WINCTRL_Pos   = 0x2  // Position of WINCTRL field.
	AC_SYNCBUSY_WINCTRL_Msk   = 0x4  // Bit mask of WINCTRL field.
	AC_SYNCBUSY_WINCTRL       = 0x4  // Bit WINCTRL.
	AC_SYNCBUSY_COMPCTRL0_Pos = 0x3  // Position of COMPCTRL0 field.
	AC_SYNCBUSY_COMPCTRL0_Msk = 0x8  // Bit mask of COMPCTRL0 field.
	AC_SYNCBUSY_COMPCTRL0     = 0x8  // Bit COMPCTRL0.
	AC_SYNCBUSY_COMPCTRL1_Pos = 0x4  // Position of COMPCTRL1 field.
	AC_SYNCBUSY_COMPCTRL1_Msk = 0x10 // Bit mask of COMPCTRL1 field.
	AC_SYNCBUSY_COMPCTRL1     = 0x10 // Bit COMPCTRL1.
)

// Bitfields for ADC: Analog Digital Converter
const (
	// CTRLA: Control A
	ADC_CTRLA_SWRST_Pos    = 0x0  // Position of SWRST field.
	ADC_CTRLA_SWRST_Msk    = 0x1  // Bit mask of SWRST field.
	ADC_CTRLA_SWRST        = 0x1  // Bit SWRST.
	ADC_CTRLA_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	ADC_CTRLA_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	ADC_CTRLA_ENABLE       = 0x2  // Bit ENABLE.
	ADC_CTRLA_SLAVEEN_Pos  = 0x5  // Position of SLAVEEN field.
	ADC_CTRLA_SLAVEEN_Msk  = 0x20 // Bit mask of SLAVEEN field.
	ADC_CTRLA_SLAVEEN      = 0x20 // Bit SLAVEEN.
	ADC_CTRLA_RUNSTDBY_Pos = 0x6  // Position of RUNSTDBY field.
	ADC_CTRLA_RUNSTDBY_Msk = 0x40 // Bit mask of RUNSTDBY field.
	ADC_CTRLA_RUNSTDBY     = 0x40 // Bit RUNSTDBY.
	ADC_CTRLA_ONDEMAND_Pos = 0x7  // Position of ONDEMAND field.
	ADC_CTRLA_ONDEMAND_Msk = 0x80 // Bit mask of ONDEMAND field.
	ADC_CTRLA_ONDEMAND     = 0x80 // Bit ONDEMAND.

	// CTRLB: Control B
	ADC_CTRLB_PRESCALER_Pos    = 0x0 // Position of PRESCALER field.
	ADC_CTRLB_PRESCALER_Msk    = 0x7 // Bit mask of PRESCALER field.
	ADC_CTRLB_PRESCALER_DIV2   = 0x0 // Peripheral clock divided by 2
	ADC_CTRLB_PRESCALER_DIV4   = 0x1 // Peripheral clock divided by 4
	ADC_CTRLB_PRESCALER_DIV8   = 0x2 // Peripheral clock divided by 8
	ADC_CTRLB_PRESCALER_DIV16  = 0x3 // Peripheral clock divided by 16
	ADC_CTRLB_PRESCALER_DIV32  = 0x4 // Peripheral clock divided by 32
	ADC_CTRLB_PRESCALER_DIV64  = 0x5 // Peripheral clock divided by 64
	ADC_CTRLB_PRESCALER_DIV128 = 0x6 // Peripheral clock divided by 128
	ADC_CTRLB_PRESCALER_DIV256 = 0x7 // Peripheral clock divided by 256

	// REFCTRL: Reference Control
	ADC_REFCTRL_REFSEL_Pos     = 0x0  // Position of REFSEL field.
	ADC_REFCTRL_REFSEL_Msk     = 0xf  // Bit mask of REFSEL field.
	ADC_REFCTRL_REFSEL_INTREF  = 0x0  // Internal Bandgap Reference
	ADC_REFCTRL_REFSEL_INTVCC0 = 0x1  // 1/1.6 VDDANA
	ADC_REFCTRL_REFSEL_INTVCC1 = 0x2  // 1/2 VDDANA
	ADC_REFCTRL_REFSEL_AREFA   = 0x3  // External Reference
	ADC_REFCTRL_REFSEL_AREFB   = 0x4  // External Reference
	ADC_REFCTRL_REFSEL_INTVCC2 = 0x5  // VCCANA
	ADC_REFCTRL_REFCOMP_Pos    = 0x7  // Position of REFCOMP field.
	ADC_REFCTRL_REFCOMP_Msk    = 0x80 // Bit mask of REFCOMP field.
	ADC_REFCTRL_REFCOMP        = 0x80 // Bit REFCOMP.

	// EVCTRL: Event Control
	ADC_EVCTRL_FLUSHEI_Pos  = 0x0  // Position of FLUSHEI field.
	ADC_EVCTRL_FLUSHEI_Msk  = 0x1  // Bit mask of FLUSHEI field.
	ADC_EVCTRL_FLUSHEI      = 0x1  // Bit FLUSHEI.
	ADC_EVCTRL_STARTEI_Pos  = 0x1  // Position of STARTEI field.
	ADC_EVCTRL_STARTEI_Msk  = 0x2  // Bit mask of STARTEI field.
	ADC_EVCTRL_STARTEI      = 0x2  // Bit STARTEI.
	ADC_EVCTRL_FLUSHINV_Pos = 0x2  // Position of FLUSHINV field.
	ADC_EVCTRL_FLUSHINV_Msk = 0x4  // Bit mask of FLUSHINV field.
	ADC_EVCTRL_FLUSHINV     = 0x4  // Bit FLUSHINV.
	ADC_EVCTRL_STARTINV_Pos = 0x3  // Position of STARTINV field.
	ADC_EVCTRL_STARTINV_Msk = 0x8  // Bit mask of STARTINV field.
	ADC_EVCTRL_STARTINV     = 0x8  // Bit STARTINV.
	ADC_EVCTRL_RESRDYEO_Pos = 0x4  // Position of RESRDYEO field.
	ADC_EVCTRL_RESRDYEO_Msk = 0x10 // Bit mask of RESRDYEO field.
	ADC_EVCTRL_RESRDYEO     = 0x10 // Bit RESRDYEO.
	ADC_EVCTRL_WINMONEO_Pos = 0x5  // Position of WINMONEO field.
	ADC_EVCTRL_WINMONEO_Msk = 0x20 // Bit mask of WINMONEO field.
	ADC_EVCTRL_WINMONEO     = 0x20 // Bit WINMONEO.

	// INTENCLR: Interrupt Enable Clear
	ADC_INTENCLR_RESRDY_Pos  = 0x0 // Position of RESRDY field.
	ADC_INTENCLR_RESRDY_Msk  = 0x1 // Bit mask of RESRDY field.
	ADC_INTENCLR_RESRDY      = 0x1 // Bit RESRDY.
	ADC_INTENCLR_OVERRUN_Pos = 0x1 // Position of OVERRUN field.
	ADC_INTENCLR_OVERRUN_Msk = 0x2 // Bit mask of OVERRUN field.
	ADC_INTENCLR_OVERRUN     = 0x2 // Bit OVERRUN.
	ADC_INTENCLR_WINMON_Pos  = 0x2 // Position of WINMON field.
	ADC_INTENCLR_WINMON_Msk  = 0x4 // Bit mask of WINMON field.
	ADC_INTENCLR_WINMON      = 0x4 // Bit WINMON.

	// INTENSET: Interrupt Enable Set
	ADC_INTENSET_RESRDY_Pos  = 0x0 // Position of RESRDY field.
	ADC_INTENSET_RESRDY_Msk  = 0x1 // Bit mask of RESRDY field.
	ADC_INTENSET_RESRDY      = 0x1 // Bit RESRDY.
	ADC_INTENSET_OVERRUN_Pos = 0x1 // Position of OVERRUN field.
	ADC_INTENSET_OVERRUN_Msk = 0x2 // Bit mask of OVERRUN field.
	ADC_INTENSET_OVERRUN     = 0x2 // Bit OVERRUN.
	ADC_INTENSET_WINMON_Pos  = 0x2 // Position of WINMON field.
	ADC_INTENSET_WINMON_Msk  = 0x4 // Bit mask of WINMON field.
	ADC_INTENSET_WINMON      = 0x4 // Bit WINMON.

	// INTFLAG: Interrupt Flag Status and Clear
	ADC_INTFLAG_RESRDY_Pos  = 0x0 // Position of RESRDY field.
	ADC_INTFLAG_RESRDY_Msk  = 0x1 // Bit mask of RESRDY field.
	ADC_INTFLAG_RESRDY      = 0x1 // Bit RESRDY.
	ADC_INTFLAG_OVERRUN_Pos = 0x1 // Position of OVERRUN field.
	ADC_INTFLAG_OVERRUN_Msk = 0x2 // Bit mask of OVERRUN field.
	ADC_INTFLAG_OVERRUN     = 0x2 // Bit OVERRUN.
	ADC_INTFLAG_WINMON_Pos  = 0x2 // Position of WINMON field.
	ADC_INTFLAG_WINMON_Msk  = 0x4 // Bit mask of WINMON field.
	ADC_INTFLAG_WINMON      = 0x4 // Bit WINMON.

	// SEQSTATUS: Sequence Status
	ADC_SEQSTATUS_SEQSTATE_Pos = 0x0  // Position of SEQSTATE field.
	ADC_SEQSTATUS_SEQSTATE_Msk = 0x1f // Bit mask of SEQSTATE field.
	ADC_SEQSTATUS_SEQBUSY_Pos  = 0x7  // Position of SEQBUSY field.
	ADC_SEQSTATUS_SEQBUSY_Msk  = 0x80 // Bit mask of SEQBUSY field.
	ADC_SEQSTATUS_SEQBUSY      = 0x80 // Bit SEQBUSY.

	// INPUTCTRL: Input Control
	ADC_INPUTCTRL_MUXPOS_Pos           = 0x0    // Position of MUXPOS field.
	ADC_INPUTCTRL_MUXPOS_Msk           = 0x1f   // Bit mask of MUXPOS field.
	ADC_INPUTCTRL_MUXPOS_AIN0          = 0x0    // ADC AIN0 Pin
	ADC_INPUTCTRL_MUXPOS_AIN1          = 0x1    // ADC AIN1 Pin
	ADC_INPUTCTRL_MUXPOS_AIN2          = 0x2    // ADC AIN2 Pin
	ADC_INPUTCTRL_MUXPOS_AIN3          = 0x3    // ADC AIN3 Pin
	ADC_INPUTCTRL_MUXPOS_AIN4          = 0x4    // ADC AIN4 Pin
	ADC_INPUTCTRL_MUXPOS_AIN5          = 0x5    // ADC AIN5 Pin
	ADC_INPUTCTRL_MUXPOS_AIN6          = 0x6    // ADC AIN6 Pin
	ADC_INPUTCTRL_MUXPOS_AIN7          = 0x7    // ADC AIN7 Pin
	ADC_INPUTCTRL_MUXPOS_AIN8          = 0x8    // ADC AIN8 Pin
	ADC_INPUTCTRL_MUXPOS_AIN9          = 0x9    // ADC AIN9 Pin
	ADC_INPUTCTRL_MUXPOS_AIN10         = 0xa    // ADC AIN10 Pin
	ADC_INPUTCTRL_MUXPOS_AIN11         = 0xb    // ADC AIN11 Pin
	ADC_INPUTCTRL_MUXPOS_AIN12         = 0xc    // ADC AIN12 Pin
	ADC_INPUTCTRL_MUXPOS_AIN13         = 0xd    // ADC AIN13 Pin
	ADC_INPUTCTRL_MUXPOS_AIN14         = 0xe    // ADC AIN14 Pin
	ADC_INPUTCTRL_MUXPOS_AIN15         = 0xf    // ADC AIN15 Pin
	ADC_INPUTCTRL_MUXPOS_AIN16         = 0x10   // ADC AIN16 Pin
	ADC_INPUTCTRL_MUXPOS_AIN17         = 0x11   // ADC AIN17 Pin
	ADC_INPUTCTRL_MUXPOS_AIN18         = 0x12   // ADC AIN18 Pin
	ADC_INPUTCTRL_MUXPOS_AIN19         = 0x13   // ADC AIN19 Pin
	ADC_INPUTCTRL_MUXPOS_AIN20         = 0x14   // ADC AIN20 Pin
	ADC_INPUTCTRL_MUXPOS_AIN21         = 0x15   // ADC AIN21 Pin
	ADC_INPUTCTRL_MUXPOS_AIN22         = 0x16   // ADC AIN22 Pin
	ADC_INPUTCTRL_MUXPOS_AIN23         = 0x17   // ADC AIN23 Pin
	ADC_INPUTCTRL_MUXPOS_TEMP          = 0x18   // Temperature Sensor
	ADC_INPUTCTRL_MUXPOS_BANDGAP       = 0x19   // Bandgap Voltage
	ADC_INPUTCTRL_MUXPOS_SCALEDCOREVCC = 0x1a   // 1/4 Scaled Core Supply
	ADC_INPUTCTRL_MUXPOS_SCALEDIOVCC   = 0x1b   // 1/4 Scaled I/O Supply
	ADC_INPUTCTRL_MUXPOS_DAC           = 0x1c   // DAC Output
	ADC_INPUTCTRL_MUXPOS_SCALEDVBAT    = 0x1d   // 1/4 Scaled VBAT Supply
	ADC_INPUTCTRL_MUXPOS_OPAMP01       = 0x1e   // OPAMP0 or OPAMP1 output
	ADC_INPUTCTRL_MUXPOS_OPAMP2        = 0x1f   // OPAMP2 output
	ADC_INPUTCTRL_MUXNEG_Pos           = 0x8    // Position of MUXNEG field.
	ADC_INPUTCTRL_MUXNEG_Msk           = 0x1f00 // Bit mask of MUXNEG field.
	ADC_INPUTCTRL_MUXNEG_AIN0          = 0x0    // ADC AIN0 Pin
	ADC_INPUTCTRL_MUXNEG_AIN1          = 0x1    // ADC AIN1 Pin
	ADC_INPUTCTRL_MUXNEG_AIN2          = 0x2    // ADC AIN2 Pin
	ADC_INPUTCTRL_MUXNEG_AIN3          = 0x3    // ADC AIN3 Pin
	ADC_INPUTCTRL_MUXNEG_AIN4          = 0x4    // ADC AIN4 Pin
	ADC_INPUTCTRL_MUXNEG_AIN5          = 0x5    // ADC AIN5 Pin
	ADC_INPUTCTRL_MUXNEG_AIN6          = 0x6    // ADC AIN6 Pin
	ADC_INPUTCTRL_MUXNEG_AIN7          = 0x7    // ADC AIN7 Pin

	// CTRLC: Control C
	ADC_CTRLC_DIFFMODE_Pos       = 0x0    // Position of DIFFMODE field.
	ADC_CTRLC_DIFFMODE_Msk       = 0x1    // Bit mask of DIFFMODE field.
	ADC_CTRLC_DIFFMODE           = 0x1    // Bit DIFFMODE.
	ADC_CTRLC_LEFTADJ_Pos        = 0x1    // Position of LEFTADJ field.
	ADC_CTRLC_LEFTADJ_Msk        = 0x2    // Bit mask of LEFTADJ field.
	ADC_CTRLC_LEFTADJ            = 0x2    // Bit LEFTADJ.
	ADC_CTRLC_FREERUN_Pos        = 0x2    // Position of FREERUN field.
	ADC_CTRLC_FREERUN_Msk        = 0x4    // Bit mask of FREERUN field.
	ADC_CTRLC_FREERUN            = 0x4    // Bit FREERUN.
	ADC_CTRLC_CORREN_Pos         = 0x3    // Position of CORREN field.
	ADC_CTRLC_CORREN_Msk         = 0x8    // Bit mask of CORREN field.
	ADC_CTRLC_CORREN             = 0x8    // Bit CORREN.
	ADC_CTRLC_RESSEL_Pos         = 0x4    // Position of RESSEL field.
	ADC_CTRLC_RESSEL_Msk         = 0x30   // Bit mask of RESSEL field.
	ADC_CTRLC_RESSEL_12BIT       = 0x0    // 12-bit result
	ADC_CTRLC_RESSEL_16BIT       = 0x1    // For averaging mode output
	ADC_CTRLC_RESSEL_10BIT       = 0x2    // 10-bit result
	ADC_CTRLC_RESSEL_8BIT        = 0x3    // 8-bit result
	ADC_CTRLC_R2R_Pos            = 0x7    // Position of R2R field.
	ADC_CTRLC_R2R_Msk            = 0x80   // Bit mask of R2R field.
	ADC_CTRLC_R2R                = 0x80   // Bit R2R.
	ADC_CTRLC_WINMODE_Pos        = 0x8    // Position of WINMODE field.
	ADC_CTRLC_WINMODE_Msk        = 0x700  // Bit mask of WINMODE field.
	ADC_CTRLC_WINMODE_DISABLE    = 0x0    // No window mode (default)
	ADC_CTRLC_WINMODE_MODE1      = 0x1    // RESULT > WINLT
	ADC_CTRLC_WINMODE_MODE2      = 0x2    // RESULT < WINUT
	ADC_CTRLC_WINMODE_MODE3      = 0x3    // WINLT < RESULT < WINUT
	ADC_CTRLC_WINMODE_MODE4      = 0x4    // !(WINLT < RESULT < WINUT)
	ADC_CTRLC_DUALSEL_Pos        = 0xc    // Position of DUALSEL field.
	ADC_CTRLC_DUALSEL_Msk        = 0x3000 // Bit mask of DUALSEL field.
	ADC_CTRLC_DUALSEL_BOTH       = 0x0    // Start event or software trigger will start a conversion on both ADCs
	ADC_CTRLC_DUALSEL_INTERLEAVE = 0x1    // START event or software trigger will alternatingly start a conversion on ADC0 and ADC1

	// AVGCTRL: Average Control
	ADC_AVGCTRL_SAMPLENUM_Pos  = 0x0  // Position of SAMPLENUM field.
	ADC_AVGCTRL_SAMPLENUM_Msk  = 0xf  // Bit mask of SAMPLENUM field.
	ADC_AVGCTRL_SAMPLENUM_1    = 0x0  // 1 sample
	ADC_AVGCTRL_SAMPLENUM_2    = 0x1  // 2 samples
	ADC_AVGCTRL_SAMPLENUM_4    = 0x2  // 4 samples
	ADC_AVGCTRL_SAMPLENUM_8    = 0x3  // 8 samples
	ADC_AVGCTRL_SAMPLENUM_16   = 0x4  // 16 samples
	ADC_AVGCTRL_SAMPLENUM_32   = 0x5  // 32 samples
	ADC_AVGCTRL_SAMPLENUM_64   = 0x6  // 64 samples
	ADC_AVGCTRL_SAMPLENUM_128  = 0x7  // 128 samples
	ADC_AVGCTRL_SAMPLENUM_256  = 0x8  // 256 samples
	ADC_AVGCTRL_SAMPLENUM_512  = 0x9  // 512 samples
	ADC_AVGCTRL_SAMPLENUM_1024 = 0xa  // 1024 samples
	ADC_AVGCTRL_ADJRES_Pos     = 0x4  // Position of ADJRES field.
	ADC_AVGCTRL_ADJRES_Msk     = 0x70 // Bit mask of ADJRES field.

	// SAMPCTRL: Sample Time Control
	ADC_SAMPCTRL_SAMPLEN_Pos = 0x0  // Position of SAMPLEN field.
	ADC_SAMPCTRL_SAMPLEN_Msk = 0x3f // Bit mask of SAMPLEN field.
	ADC_SAMPCTRL_OFFCOMP_Pos = 0x7  // Position of OFFCOMP field.
	ADC_SAMPCTRL_OFFCOMP_Msk = 0x80 // Bit mask of OFFCOMP field.
	ADC_SAMPCTRL_OFFCOMP     = 0x80 // Bit OFFCOMP.

	// WINLT: Window Monitor Lower Threshold
	ADC_WINLT_WINLT_Pos = 0x0    // Position of WINLT field.
	ADC_WINLT_WINLT_Msk = 0xffff // Bit mask of WINLT field.

	// WINUT: Window Monitor Upper Threshold
	ADC_WINUT_WINUT_Pos = 0x0    // Position of WINUT field.
	ADC_WINUT_WINUT_Msk = 0xffff // Bit mask of WINUT field.

	// GAINCORR: Gain Correction
	ADC_GAINCORR_GAINCORR_Pos = 0x0   // Position of GAINCORR field.
	ADC_GAINCORR_GAINCORR_Msk = 0xfff // Bit mask of GAINCORR field.

	// OFFSETCORR: Offset Correction
	ADC_OFFSETCORR_OFFSETCORR_Pos = 0x0   // Position of OFFSETCORR field.
	ADC_OFFSETCORR_OFFSETCORR_Msk = 0xfff // Bit mask of OFFSETCORR field.

	// SWTRIG: Software Trigger
	ADC_SWTRIG_FLUSH_Pos = 0x0 // Position of FLUSH field.
	ADC_SWTRIG_FLUSH_Msk = 0x1 // Bit mask of FLUSH field.
	ADC_SWTRIG_FLUSH     = 0x1 // Bit FLUSH.
	ADC_SWTRIG_START_Pos = 0x1 // Position of START field.
	ADC_SWTRIG_START_Msk = 0x2 // Bit mask of START field.
	ADC_SWTRIG_START     = 0x2 // Bit START.

	// DBGCTRL: Debug Control
	ADC_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	ADC_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	ADC_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// SYNCBUSY: Synchronization Busy
	ADC_SYNCBUSY_SWRST_Pos      = 0x0   // Position of SWRST field.
	ADC_SYNCBUSY_SWRST_Msk      = 0x1   // Bit mask of SWRST field.
	ADC_SYNCBUSY_SWRST          = 0x1   // Bit SWRST.
	ADC_SYNCBUSY_ENABLE_Pos     = 0x1   // Position of ENABLE field.
	ADC_SYNCBUSY_ENABLE_Msk     = 0x2   // Bit mask of ENABLE field.
	ADC_SYNCBUSY_ENABLE         = 0x2   // Bit ENABLE.
	ADC_SYNCBUSY_INPUTCTRL_Pos  = 0x2   // Position of INPUTCTRL field.
	ADC_SYNCBUSY_INPUTCTRL_Msk  = 0x4   // Bit mask of INPUTCTRL field.
	ADC_SYNCBUSY_INPUTCTRL      = 0x4   // Bit INPUTCTRL.
	ADC_SYNCBUSY_CTRLC_Pos      = 0x3   // Position of CTRLC field.
	ADC_SYNCBUSY_CTRLC_Msk      = 0x8   // Bit mask of CTRLC field.
	ADC_SYNCBUSY_CTRLC          = 0x8   // Bit CTRLC.
	ADC_SYNCBUSY_AVGCTRL_Pos    = 0x4   // Position of AVGCTRL field.
	ADC_SYNCBUSY_AVGCTRL_Msk    = 0x10  // Bit mask of AVGCTRL field.
	ADC_SYNCBUSY_AVGCTRL        = 0x10  // Bit AVGCTRL.
	ADC_SYNCBUSY_SAMPCTRL_Pos   = 0x5   // Position of SAMPCTRL field.
	ADC_SYNCBUSY_SAMPCTRL_Msk   = 0x20  // Bit mask of SAMPCTRL field.
	ADC_SYNCBUSY_SAMPCTRL       = 0x20  // Bit SAMPCTRL.
	ADC_SYNCBUSY_WINLT_Pos      = 0x6   // Position of WINLT field.
	ADC_SYNCBUSY_WINLT_Msk      = 0x40  // Bit mask of WINLT field.
	ADC_SYNCBUSY_WINLT          = 0x40  // Bit WINLT.
	ADC_SYNCBUSY_WINUT_Pos      = 0x7   // Position of WINUT field.
	ADC_SYNCBUSY_WINUT_Msk      = 0x80  // Bit mask of WINUT field.
	ADC_SYNCBUSY_WINUT          = 0x80  // Bit WINUT.
	ADC_SYNCBUSY_GAINCORR_Pos   = 0x8   // Position of GAINCORR field.
	ADC_SYNCBUSY_GAINCORR_Msk   = 0x100 // Bit mask of GAINCORR field.
	ADC_SYNCBUSY_GAINCORR       = 0x100 // Bit GAINCORR.
	ADC_SYNCBUSY_OFFSETCORR_Pos = 0x9   // Position of OFFSETCORR field.
	ADC_SYNCBUSY_OFFSETCORR_Msk = 0x200 // Bit mask of OFFSETCORR field.
	ADC_SYNCBUSY_OFFSETCORR     = 0x200 // Bit OFFSETCORR.
	ADC_SYNCBUSY_SWTRIG_Pos     = 0xa   // Position of SWTRIG field.
	ADC_SYNCBUSY_SWTRIG_Msk     = 0x400 // Bit mask of SWTRIG field.
	ADC_SYNCBUSY_SWTRIG         = 0x400 // Bit SWTRIG.

	// RESULT: Result
	ADC_RESULT_RESULT_Pos = 0x0    // Position of RESULT field.
	ADC_RESULT_RESULT_Msk = 0xffff // Bit mask of RESULT field.

	// SEQCTRL: Sequence Control
	ADC_SEQCTRL_SEQEN_Pos = 0x0        // Position of SEQEN field.
	ADC_SEQCTRL_SEQEN_Msk = 0xffffffff // Bit mask of SEQEN field.

	// CALIB: Calibration
	ADC_CALIB_BIASCOMP_Pos   = 0x0   // Position of BIASCOMP field.
	ADC_CALIB_BIASCOMP_Msk   = 0x7   // Bit mask of BIASCOMP field.
	ADC_CALIB_BIASREFBUF_Pos = 0x8   // Position of BIASREFBUF field.
	ADC_CALIB_BIASREFBUF_Msk = 0x700 // Bit mask of BIASREFBUF field.
)

// Bitfields for CCL: Configurable Custom Logic
const (
	// CTRL: Control
	CCL_CTRL_SWRST_Pos    = 0x0  // Position of SWRST field.
	CCL_CTRL_SWRST_Msk    = 0x1  // Bit mask of SWRST field.
	CCL_CTRL_SWRST        = 0x1  // Bit SWRST.
	CCL_CTRL_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	CCL_CTRL_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	CCL_CTRL_ENABLE       = 0x2  // Bit ENABLE.
	CCL_CTRL_RUNSTDBY_Pos = 0x6  // Position of RUNSTDBY field.
	CCL_CTRL_RUNSTDBY_Msk = 0x40 // Bit mask of RUNSTDBY field.
	CCL_CTRL_RUNSTDBY     = 0x40 // Bit RUNSTDBY.

	// SEQCTRL: SEQ Control x
	CCL_SEQCTRL_SEQSEL_Pos     = 0x0 // Position of SEQSEL field.
	CCL_SEQCTRL_SEQSEL_Msk     = 0xf // Bit mask of SEQSEL field.
	CCL_SEQCTRL_SEQSEL_DISABLE = 0x0 // Sequential logic is disabled
	CCL_SEQCTRL_SEQSEL_DFF     = 0x1 // D flip flop
	CCL_SEQCTRL_SEQSEL_JK      = 0x2 // JK flip flop
	CCL_SEQCTRL_SEQSEL_LATCH   = 0x3 // D latch
	CCL_SEQCTRL_SEQSEL_RS      = 0x4 // RS latch

	// LUTCTRL: LUT Control x
	CCL_LUTCTRL_ENABLE_Pos        = 0x1        // Position of ENABLE field.
	CCL_LUTCTRL_ENABLE_Msk        = 0x2        // Bit mask of ENABLE field.
	CCL_LUTCTRL_ENABLE            = 0x2        // Bit ENABLE.
	CCL_LUTCTRL_FILTSEL_Pos       = 0x4        // Position of FILTSEL field.
	CCL_LUTCTRL_FILTSEL_Msk       = 0x30       // Bit mask of FILTSEL field.
	CCL_LUTCTRL_FILTSEL_DISABLE   = 0x0        // Filter disabled
	CCL_LUTCTRL_FILTSEL_SYNCH     = 0x1        // Synchronizer enabled
	CCL_LUTCTRL_FILTSEL_FILTER    = 0x2        // Filter enabled
	CCL_LUTCTRL_EDGESEL_Pos       = 0x7        // Position of EDGESEL field.
	CCL_LUTCTRL_EDGESEL_Msk       = 0x80       // Bit mask of EDGESEL field.
	CCL_LUTCTRL_EDGESEL           = 0x80       // Bit EDGESEL.
	CCL_LUTCTRL_INSEL0_Pos        = 0x8        // Position of INSEL0 field.
	CCL_LUTCTRL_INSEL0_Msk        = 0xf00      // Bit mask of INSEL0 field.
	CCL_LUTCTRL_INSEL0_MASK       = 0x0        // Masked input
	CCL_LUTCTRL_INSEL0_FEEDBACK   = 0x1        // Feedback input source
	CCL_LUTCTRL_INSEL0_LINK       = 0x2        // Linked LUT input source
	CCL_LUTCTRL_INSEL0_EVENT      = 0x3        // Event input source
	CCL_LUTCTRL_INSEL0_IO         = 0x4        // I/O pin input source
	CCL_LUTCTRL_INSEL0_AC         = 0x5        // AC input source
	CCL_LUTCTRL_INSEL0_TC         = 0x6        // TC input source
	CCL_LUTCTRL_INSEL0_ALTTC      = 0x7        // Alternate TC input source
	CCL_LUTCTRL_INSEL0_TCC        = 0x8        // TCC input source
	CCL_LUTCTRL_INSEL0_SERCOM     = 0x9        // SERCOM input source
	CCL_LUTCTRL_INSEL0_ALT2TC     = 0xa        // Alternate 2 TC input source
	CCL_LUTCTRL_INSEL0_ASYNCEVENT = 0xb        // Asynchronous event input source. The EVENT input will bypass edge detection logic.
	CCL_LUTCTRL_INSEL1_Pos        = 0xc        // Position of INSEL1 field.
	CCL_LUTCTRL_INSEL1_Msk        = 0xf000     // Bit mask of INSEL1 field.
	CCL_LUTCTRL_INSEL1_MASK       = 0x0        // Masked input
	CCL_LUTCTRL_INSEL1_FEEDBACK   = 0x1        // Feedback input source
	CCL_LUTCTRL_INSEL1_LINK       = 0x2        // Linked LUT input source
	CCL_LUTCTRL_INSEL1_EVENT      = 0x3        // Event input source
	CCL_LUTCTRL_INSEL1_IO         = 0x4        // I/O pin input source
	CCL_LUTCTRL_INSEL1_AC         = 0x5        // AC input source
	CCL_LUTCTRL_INSEL1_TC         = 0x6        // TC input source
	CCL_LUTCTRL_INSEL1_ALTTC      = 0x7        // Alternate TC input source
	CCL_LUTCTRL_INSEL1_TCC        = 0x8        // TCC input source
	CCL_LUTCTRL_INSEL1_SERCOM     = 0x9        // SERCOM input source
	CCL_LUTCTRL_INSEL1_ALT2TC     = 0xa        // Alternate 2 TC input source
	CCL_LUTCTRL_INSEL1_ASYNCEVENT = 0xb        // Asynchronous event input source. The EVENT input will bypass edge detection logic.
	CCL_LUTCTRL_INSEL2_Pos        = 0x10       // Position of INSEL2 field.
	CCL_LUTCTRL_INSEL2_Msk        = 0xf0000    // Bit mask of INSEL2 field.
	CCL_LUTCTRL_INSEL2_MASK       = 0x0        // Masked input
	CCL_LUTCTRL_INSEL2_FEEDBACK   = 0x1        // Feedback input source
	CCL_LUTCTRL_INSEL2_LINK       = 0x2        // Linked LUT input source
	CCL_LUTCTRL_INSEL2_EVENT      = 0x3        // Event input source
	CCL_LUTCTRL_INSEL2_IO         = 0x4        // I/O pin input source
	CCL_LUTCTRL_INSEL2_AC         = 0x5        // AC input source
	CCL_LUTCTRL_INSEL2_TC         = 0x6        // TC input source
	CCL_LUTCTRL_INSEL2_ALTTC      = 0x7        // Alternate TC input source
	CCL_LUTCTRL_INSEL2_TCC        = 0x8        // TCC input source
	CCL_LUTCTRL_INSEL2_SERCOM     = 0x9        // SERCOM input source
	CCL_LUTCTRL_INSEL2_ALT2TC     = 0xa        // Alternate 2 TC input source
	CCL_LUTCTRL_INSEL2_ASYNCEVENT = 0xb        // Asynchronous event input source. The EVENT input will bypass edge detection logic.
	CCL_LUTCTRL_INVEI_Pos         = 0x14       // Position of INVEI field.
	CCL_LUTCTRL_INVEI_Msk         = 0x100000   // Bit mask of INVEI field.
	CCL_LUTCTRL_INVEI             = 0x100000   // Bit INVEI.
	CCL_LUTCTRL_LUTEI_Pos         = 0x15       // Position of LUTEI field.
	CCL_LUTCTRL_LUTEI_Msk         = 0x200000   // Bit mask of LUTEI field.
	CCL_LUTCTRL_LUTEI             = 0x200000   // Bit LUTEI.
	CCL_LUTCTRL_LUTEO_Pos         = 0x16       // Position of LUTEO field.
	CCL_LUTCTRL_LUTEO_Msk         = 0x400000   // Bit mask of LUTEO field.
	CCL_LUTCTRL_LUTEO             = 0x400000   // Bit LUTEO.
	CCL_LUTCTRL_TRUTH_Pos         = 0x18       // Position of TRUTH field.
	CCL_LUTCTRL_TRUTH_Msk         = 0xff000000 // Bit mask of TRUTH field.
)

// Bitfields for DAC: Digital Analog Converter
const (
	// CTRLA: Control A
	DAC_CTRLA_SWRST_Pos    = 0x0  // Position of SWRST field.
	DAC_CTRLA_SWRST_Msk    = 0x1  // Bit mask of SWRST field.
	DAC_CTRLA_SWRST        = 0x1  // Bit SWRST.
	DAC_CTRLA_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	DAC_CTRLA_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	DAC_CTRLA_ENABLE       = 0x2  // Bit ENABLE.
	DAC_CTRLA_RUNSTDBY_Pos = 0x6  // Position of RUNSTDBY field.
	DAC_CTRLA_RUNSTDBY_Msk = 0x40 // Bit mask of RUNSTDBY field.
	DAC_CTRLA_RUNSTDBY     = 0x40 // Bit RUNSTDBY.

	// CTRLB: Control B
	DAC_CTRLB_EOEN_Pos     = 0x0  // Position of EOEN field.
	DAC_CTRLB_EOEN_Msk     = 0x1  // Bit mask of EOEN field.
	DAC_CTRLB_EOEN         = 0x1  // Bit EOEN.
	DAC_CTRLB_IOEN_Pos     = 0x1  // Position of IOEN field.
	DAC_CTRLB_IOEN_Msk     = 0x2  // Bit mask of IOEN field.
	DAC_CTRLB_IOEN         = 0x2  // Bit IOEN.
	DAC_CTRLB_LEFTADJ_Pos  = 0x2  // Position of LEFTADJ field.
	DAC_CTRLB_LEFTADJ_Msk  = 0x4  // Bit mask of LEFTADJ field.
	DAC_CTRLB_LEFTADJ      = 0x4  // Bit LEFTADJ.
	DAC_CTRLB_VPD_Pos      = 0x3  // Position of VPD field.
	DAC_CTRLB_VPD_Msk      = 0x8  // Bit mask of VPD field.
	DAC_CTRLB_VPD          = 0x8  // Bit VPD.
	DAC_CTRLB_DITHER_Pos   = 0x5  // Position of DITHER field.
	DAC_CTRLB_DITHER_Msk   = 0x20 // Bit mask of DITHER field.
	DAC_CTRLB_DITHER       = 0x20 // Bit DITHER.
	DAC_CTRLB_REFSEL_Pos   = 0x6  // Position of REFSEL field.
	DAC_CTRLB_REFSEL_Msk   = 0xc0 // Bit mask of REFSEL field.
	DAC_CTRLB_REFSEL_INT1V = 0x0  // Internal 1.0V reference
	DAC_CTRLB_REFSEL_AVCC  = 0x1  // AVCC
	DAC_CTRLB_REFSEL_VREFP = 0x2  // External reference

	// EVCTRL: Event Control
	DAC_EVCTRL_STARTEI_Pos = 0x0 // Position of STARTEI field.
	DAC_EVCTRL_STARTEI_Msk = 0x1 // Bit mask of STARTEI field.
	DAC_EVCTRL_STARTEI     = 0x1 // Bit STARTEI.
	DAC_EVCTRL_EMPTYEO_Pos = 0x1 // Position of EMPTYEO field.
	DAC_EVCTRL_EMPTYEO_Msk = 0x2 // Bit mask of EMPTYEO field.
	DAC_EVCTRL_EMPTYEO     = 0x2 // Bit EMPTYEO.
	DAC_EVCTRL_INVEI_Pos   = 0x2 // Position of INVEI field.
	DAC_EVCTRL_INVEI_Msk   = 0x4 // Bit mask of INVEI field.
	DAC_EVCTRL_INVEI       = 0x4 // Bit INVEI.

	// INTENCLR: Interrupt Enable Clear
	DAC_INTENCLR_UNDERRUN_Pos = 0x0 // Position of UNDERRUN field.
	DAC_INTENCLR_UNDERRUN_Msk = 0x1 // Bit mask of UNDERRUN field.
	DAC_INTENCLR_UNDERRUN     = 0x1 // Bit UNDERRUN.
	DAC_INTENCLR_EMPTY_Pos    = 0x1 // Position of EMPTY field.
	DAC_INTENCLR_EMPTY_Msk    = 0x2 // Bit mask of EMPTY field.
	DAC_INTENCLR_EMPTY        = 0x2 // Bit EMPTY.

	// INTENSET: Interrupt Enable Set
	DAC_INTENSET_UNDERRUN_Pos = 0x0 // Position of UNDERRUN field.
	DAC_INTENSET_UNDERRUN_Msk = 0x1 // Bit mask of UNDERRUN field.
	DAC_INTENSET_UNDERRUN     = 0x1 // Bit UNDERRUN.
	DAC_INTENSET_EMPTY_Pos    = 0x1 // Position of EMPTY field.
	DAC_INTENSET_EMPTY_Msk    = 0x2 // Bit mask of EMPTY field.
	DAC_INTENSET_EMPTY        = 0x2 // Bit EMPTY.

	// INTFLAG: Interrupt Flag Status and Clear
	DAC_INTFLAG_UNDERRUN_Pos = 0x0 // Position of UNDERRUN field.
	DAC_INTFLAG_UNDERRUN_Msk = 0x1 // Bit mask of UNDERRUN field.
	DAC_INTFLAG_UNDERRUN     = 0x1 // Bit UNDERRUN.
	DAC_INTFLAG_EMPTY_Pos    = 0x1 // Position of EMPTY field.
	DAC_INTFLAG_EMPTY_Msk    = 0x2 // Bit mask of EMPTY field.
	DAC_INTFLAG_EMPTY        = 0x2 // Bit EMPTY.

	// STATUS: Status
	DAC_STATUS_READY_Pos = 0x0 // Position of READY field.
	DAC_STATUS_READY_Msk = 0x1 // Bit mask of READY field.
	DAC_STATUS_READY     = 0x1 // Bit READY.

	// DATA: Data
	DAC_DATA_DATA_Pos = 0x0    // Position of DATA field.
	DAC_DATA_DATA_Msk = 0xffff // Bit mask of DATA field.

	// DATABUF: Data Buffer
	DAC_DATABUF_DATABUF_Pos = 0x0    // Position of DATABUF field.
	DAC_DATABUF_DATABUF_Msk = 0xffff // Bit mask of DATABUF field.

	// SYNCBUSY: Synchronization Busy
	DAC_SYNCBUSY_SWRST_Pos   = 0x0 // Position of SWRST field.
	DAC_SYNCBUSY_SWRST_Msk   = 0x1 // Bit mask of SWRST field.
	DAC_SYNCBUSY_SWRST       = 0x1 // Bit SWRST.
	DAC_SYNCBUSY_ENABLE_Pos  = 0x1 // Position of ENABLE field.
	DAC_SYNCBUSY_ENABLE_Msk  = 0x2 // Bit mask of ENABLE field.
	DAC_SYNCBUSY_ENABLE      = 0x2 // Bit ENABLE.
	DAC_SYNCBUSY_DATA_Pos    = 0x2 // Position of DATA field.
	DAC_SYNCBUSY_DATA_Msk    = 0x4 // Bit mask of DATA field.
	DAC_SYNCBUSY_DATA        = 0x4 // Bit DATA.
	DAC_SYNCBUSY_DATABUF_Pos = 0x3 // Position of DATABUF field.
	DAC_SYNCBUSY_DATABUF_Msk = 0x8 // Bit mask of DATABUF field.
	DAC_SYNCBUSY_DATABUF     = 0x8 // Bit DATABUF.

	// DBGCTRL: Debug Control
	DAC_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	DAC_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	DAC_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.
)

// Bitfields for DMAC: Direct Memory Access Controller
const (
	// CTRL: Control
	DMAC_CTRL_SWRST_Pos     = 0x0   // Position of SWRST field.
	DMAC_CTRL_SWRST_Msk     = 0x1   // Bit mask of SWRST field.
	DMAC_CTRL_SWRST         = 0x1   // Bit SWRST.
	DMAC_CTRL_DMAENABLE_Pos = 0x1   // Position of DMAENABLE field.
	DMAC_CTRL_DMAENABLE_Msk = 0x2   // Bit mask of DMAENABLE field.
	DMAC_CTRL_DMAENABLE     = 0x2   // Bit DMAENABLE.
	DMAC_CTRL_CRCENABLE_Pos = 0x2   // Position of CRCENABLE field.
	DMAC_CTRL_CRCENABLE_Msk = 0x4   // Bit mask of CRCENABLE field.
	DMAC_CTRL_CRCENABLE     = 0x4   // Bit CRCENABLE.
	DMAC_CTRL_LVLEN0_Pos    = 0x8   // Position of LVLEN0 field.
	DMAC_CTRL_LVLEN0_Msk    = 0x100 // Bit mask of LVLEN0 field.
	DMAC_CTRL_LVLEN0        = 0x100 // Bit LVLEN0.
	DMAC_CTRL_LVLEN1_Pos    = 0x9   // Position of LVLEN1 field.
	DMAC_CTRL_LVLEN1_Msk    = 0x200 // Bit mask of LVLEN1 field.
	DMAC_CTRL_LVLEN1        = 0x200 // Bit LVLEN1.
	DMAC_CTRL_LVLEN2_Pos    = 0xa   // Position of LVLEN2 field.
	DMAC_CTRL_LVLEN2_Msk    = 0x400 // Bit mask of LVLEN2 field.
	DMAC_CTRL_LVLEN2        = 0x400 // Bit LVLEN2.
	DMAC_CTRL_LVLEN3_Pos    = 0xb   // Position of LVLEN3 field.
	DMAC_CTRL_LVLEN3_Msk    = 0x800 // Bit mask of LVLEN3 field.
	DMAC_CTRL_LVLEN3        = 0x800 // Bit LVLEN3.

	// CRCCTRL: CRC Control
	DMAC_CRCCTRL_CRCBEATSIZE_Pos   = 0x0    // Position of CRCBEATSIZE field.
	DMAC_CRCCTRL_CRCBEATSIZE_Msk   = 0x3    // Bit mask of CRCBEATSIZE field.
	DMAC_CRCCTRL_CRCBEATSIZE_BYTE  = 0x0    // 8-bit bus transfer
	DMAC_CRCCTRL_CRCBEATSIZE_HWORD = 0x1    // 16-bit bus transfer
	DMAC_CRCCTRL_CRCBEATSIZE_WORD  = 0x2    // 32-bit bus transfer
	DMAC_CRCCTRL_CRCPOLY_Pos       = 0x2    // Position of CRCPOLY field.
	DMAC_CRCCTRL_CRCPOLY_Msk       = 0xc    // Bit mask of CRCPOLY field.
	DMAC_CRCCTRL_CRCPOLY_CRC16     = 0x0    // CRC-16 (CRC-CCITT)
	DMAC_CRCCTRL_CRCPOLY_CRC32     = 0x1    // CRC32 (IEEE 802.3)
	DMAC_CRCCTRL_CRCSRC_Pos        = 0x8    // Position of CRCSRC field.
	DMAC_CRCCTRL_CRCSRC_Msk        = 0x3f00 // Bit mask of CRCSRC field.
	DMAC_CRCCTRL_CRCSRC_NOACT      = 0x0    // No action
	DMAC_CRCCTRL_CRCSRC_IO         = 0x1    // I/O interface

	// CRCDATAIN: CRC Data Input
	DMAC_CRCDATAIN_CRCDATAIN_Pos = 0x0        // Position of CRCDATAIN field.
	DMAC_CRCDATAIN_CRCDATAIN_Msk = 0xffffffff // Bit mask of CRCDATAIN field.

	// CRCCHKSUM: CRC Checksum
	DMAC_CRCCHKSUM_CRCCHKSUM_Pos = 0x0        // Position of CRCCHKSUM field.
	DMAC_CRCCHKSUM_CRCCHKSUM_Msk = 0xffffffff // Bit mask of CRCCHKSUM field.

	// CRCSTATUS: CRC Status
	DMAC_CRCSTATUS_CRCBUSY_Pos = 0x0 // Position of CRCBUSY field.
	DMAC_CRCSTATUS_CRCBUSY_Msk = 0x1 // Bit mask of CRCBUSY field.
	DMAC_CRCSTATUS_CRCBUSY     = 0x1 // Bit CRCBUSY.
	DMAC_CRCSTATUS_CRCZERO_Pos = 0x1 // Position of CRCZERO field.
	DMAC_CRCSTATUS_CRCZERO_Msk = 0x2 // Bit mask of CRCZERO field.
	DMAC_CRCSTATUS_CRCZERO     = 0x2 // Bit CRCZERO.

	// DBGCTRL: Debug Control
	DMAC_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	DMAC_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	DMAC_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// QOSCTRL: QOS Control
	DMAC_QOSCTRL_WRBQOS_Pos     = 0x0  // Position of WRBQOS field.
	DMAC_QOSCTRL_WRBQOS_Msk     = 0x3  // Bit mask of WRBQOS field.
	DMAC_QOSCTRL_WRBQOS_DISABLE = 0x0  // Background (no sensitive operation)
	DMAC_QOSCTRL_WRBQOS_LOW     = 0x1  // Sensitive Bandwidth
	DMAC_QOSCTRL_WRBQOS_MEDIUM  = 0x2  // Sensitive Latency
	DMAC_QOSCTRL_WRBQOS_HIGH    = 0x3  // Critical Latency
	DMAC_QOSCTRL_FQOS_Pos       = 0x2  // Position of FQOS field.
	DMAC_QOSCTRL_FQOS_Msk       = 0xc  // Bit mask of FQOS field.
	DMAC_QOSCTRL_FQOS_DISABLE   = 0x0  // Background (no sensitive operation)
	DMAC_QOSCTRL_FQOS_LOW       = 0x1  // Sensitive Bandwidth
	DMAC_QOSCTRL_FQOS_MEDIUM    = 0x2  // Sensitive Latency
	DMAC_QOSCTRL_FQOS_HIGH      = 0x3  // Critical Latency
	DMAC_QOSCTRL_DQOS_Pos       = 0x4  // Position of DQOS field.
	DMAC_QOSCTRL_DQOS_Msk       = 0x30 // Bit mask of DQOS field.
	DMAC_QOSCTRL_DQOS_DISABLE   = 0x0  // Background (no sensitive operation)
	DMAC_QOSCTRL_DQOS_LOW       = 0x1  // Sensitive Bandwidth
	DMAC_QOSCTRL_DQOS_MEDIUM    = 0x2  // Sensitive Latency
	DMAC_QOSCTRL_DQOS_HIGH      = 0x3  // Critical Latency

	// SWTRIGCTRL: Software Trigger Control
	DMAC_SWTRIGCTRL_SWTRIG0_Pos = 0x0  // Position of SWTRIG0 field.
	DMAC_SWTRIGCTRL_SWTRIG0_Msk = 0x1  // Bit mask of SWTRIG0 field.
	DMAC_SWTRIGCTRL_SWTRIG0     = 0x1  // Bit SWTRIG0.
	DMAC_SWTRIGCTRL_SWTRIG1_Pos = 0x1  // Position of SWTRIG1 field.
	DMAC_SWTRIGCTRL_SWTRIG1_Msk = 0x2  // Bit mask of SWTRIG1 field.
	DMAC_SWTRIGCTRL_SWTRIG1     = 0x2  // Bit SWTRIG1.
	DMAC_SWTRIGCTRL_SWTRIG2_Pos = 0x2  // Position of SWTRIG2 field.
	DMAC_SWTRIGCTRL_SWTRIG2_Msk = 0x4  // Bit mask of SWTRIG2 field.
	DMAC_SWTRIGCTRL_SWTRIG2     = 0x4  // Bit SWTRIG2.
	DMAC_SWTRIGCTRL_SWTRIG3_Pos = 0x3  // Position of SWTRIG3 field.
	DMAC_SWTRIGCTRL_SWTRIG3_Msk = 0x8  // Bit mask of SWTRIG3 field.
	DMAC_SWTRIGCTRL_SWTRIG3     = 0x8  // Bit SWTRIG3.
	DMAC_SWTRIGCTRL_SWTRIG4_Pos = 0x4  // Position of SWTRIG4 field.
	DMAC_SWTRIGCTRL_SWTRIG4_Msk = 0x10 // Bit mask of SWTRIG4 field.
	DMAC_SWTRIGCTRL_SWTRIG4     = 0x10 // Bit SWTRIG4.
	DMAC_SWTRIGCTRL_SWTRIG5_Pos = 0x5  // Position of SWTRIG5 field.
	DMAC_SWTRIGCTRL_SWTRIG5_Msk = 0x20 // Bit mask of SWTRIG5 field.
	DMAC_SWTRIGCTRL_SWTRIG5     = 0x20 // Bit SWTRIG5.
	DMAC_SWTRIGCTRL_SWTRIG6_Pos = 0x6  // Position of SWTRIG6 field.
	DMAC_SWTRIGCTRL_SWTRIG6_Msk = 0x40 // Bit mask of SWTRIG6 field.
	DMAC_SWTRIGCTRL_SWTRIG6     = 0x40 // Bit SWTRIG6.
	DMAC_SWTRIGCTRL_SWTRIG7_Pos = 0x7  // Position of SWTRIG7 field.
	DMAC_SWTRIGCTRL_SWTRIG7_Msk = 0x80 // Bit mask of SWTRIG7 field.
	DMAC_SWTRIGCTRL_SWTRIG7     = 0x80 // Bit SWTRIG7.

	// PRICTRL0: Priority Control 0
	DMAC_PRICTRL0_LVLPRI0_Pos  = 0x0        // Position of LVLPRI0 field.
	DMAC_PRICTRL0_LVLPRI0_Msk  = 0x7        // Bit mask of LVLPRI0 field.
	DMAC_PRICTRL0_RRLVLEN0_Pos = 0x7        // Position of RRLVLEN0 field.
	DMAC_PRICTRL0_RRLVLEN0_Msk = 0x80       // Bit mask of RRLVLEN0 field.
	DMAC_PRICTRL0_RRLVLEN0     = 0x80       // Bit RRLVLEN0.
	DMAC_PRICTRL0_LVLPRI1_Pos  = 0x8        // Position of LVLPRI1 field.
	DMAC_PRICTRL0_LVLPRI1_Msk  = 0x700      // Bit mask of LVLPRI1 field.
	DMAC_PRICTRL0_RRLVLEN1_Pos = 0xf        // Position of RRLVLEN1 field.
	DMAC_PRICTRL0_RRLVLEN1_Msk = 0x8000     // Bit mask of RRLVLEN1 field.
	DMAC_PRICTRL0_RRLVLEN1     = 0x8000     // Bit RRLVLEN1.
	DMAC_PRICTRL0_LVLPRI2_Pos  = 0x10       // Position of LVLPRI2 field.
	DMAC_PRICTRL0_LVLPRI2_Msk  = 0x70000    // Bit mask of LVLPRI2 field.
	DMAC_PRICTRL0_RRLVLEN2_Pos = 0x17       // Position of RRLVLEN2 field.
	DMAC_PRICTRL0_RRLVLEN2_Msk = 0x800000   // Bit mask of RRLVLEN2 field.
	DMAC_PRICTRL0_RRLVLEN2     = 0x800000   // Bit RRLVLEN2.
	DMAC_PRICTRL0_LVLPRI3_Pos  = 0x18       // Position of LVLPRI3 field.
	DMAC_PRICTRL0_LVLPRI3_Msk  = 0x7000000  // Bit mask of LVLPRI3 field.
	DMAC_PRICTRL0_RRLVLEN3_Pos = 0x1f       // Position of RRLVLEN3 field.
	DMAC_PRICTRL0_RRLVLEN3_Msk = 0x80000000 // Bit mask of RRLVLEN3 field.
	DMAC_PRICTRL0_RRLVLEN3     = 0x80000000 // Bit RRLVLEN3.

	// INTPEND: Interrupt Pending
	DMAC_INTPEND_ID_Pos    = 0x0    // Position of ID field.
	DMAC_INTPEND_ID_Msk    = 0x7    // Bit mask of ID field.
	DMAC_INTPEND_TERR_Pos  = 0x8    // Position of TERR field.
	DMAC_INTPEND_TERR_Msk  = 0x100  // Bit mask of TERR field.
	DMAC_INTPEND_TERR      = 0x100  // Bit TERR.
	DMAC_INTPEND_TCMPL_Pos = 0x9    // Position of TCMPL field.
	DMAC_INTPEND_TCMPL_Msk = 0x200  // Bit mask of TCMPL field.
	DMAC_INTPEND_TCMPL     = 0x200  // Bit TCMPL.
	DMAC_INTPEND_SUSP_Pos  = 0xa    // Position of SUSP field.
	DMAC_INTPEND_SUSP_Msk  = 0x400  // Bit mask of SUSP field.
	DMAC_INTPEND_SUSP      = 0x400  // Bit SUSP.
	DMAC_INTPEND_FERR_Pos  = 0xd    // Position of FERR field.
	DMAC_INTPEND_FERR_Msk  = 0x2000 // Bit mask of FERR field.
	DMAC_INTPEND_FERR      = 0x2000 // Bit FERR.
	DMAC_INTPEND_BUSY_Pos  = 0xe    // Position of BUSY field.
	DMAC_INTPEND_BUSY_Msk  = 0x4000 // Bit mask of BUSY field.
	DMAC_INTPEND_BUSY      = 0x4000 // Bit BUSY.
	DMAC_INTPEND_PEND_Pos  = 0xf    // Position of PEND field.
	DMAC_INTPEND_PEND_Msk  = 0x8000 // Bit mask of PEND field.
	DMAC_INTPEND_PEND      = 0x8000 // Bit PEND.

	// INTSTATUS: Interrupt Status
	DMAC_INTSTATUS_CHINT0_Pos = 0x0  // Position of CHINT0 field.
	DMAC_INTSTATUS_CHINT0_Msk = 0x1  // Bit mask of CHINT0 field.
	DMAC_INTSTATUS_CHINT0     = 0x1  // Bit CHINT0.
	DMAC_INTSTATUS_CHINT1_Pos = 0x1  // Position of CHINT1 field.
	DMAC_INTSTATUS_CHINT1_Msk = 0x2  // Bit mask of CHINT1 field.
	DMAC_INTSTATUS_CHINT1     = 0x2  // Bit CHINT1.
	DMAC_INTSTATUS_CHINT2_Pos = 0x2  // Position of CHINT2 field.
	DMAC_INTSTATUS_CHINT2_Msk = 0x4  // Bit mask of CHINT2 field.
	DMAC_INTSTATUS_CHINT2     = 0x4  // Bit CHINT2.
	DMAC_INTSTATUS_CHINT3_Pos = 0x3  // Position of CHINT3 field.
	DMAC_INTSTATUS_CHINT3_Msk = 0x8  // Bit mask of CHINT3 field.
	DMAC_INTSTATUS_CHINT3     = 0x8  // Bit CHINT3.
	DMAC_INTSTATUS_CHINT4_Pos = 0x4  // Position of CHINT4 field.
	DMAC_INTSTATUS_CHINT4_Msk = 0x10 // Bit mask of CHINT4 field.
	DMAC_INTSTATUS_CHINT4     = 0x10 // Bit CHINT4.
	DMAC_INTSTATUS_CHINT5_Pos = 0x5  // Position of CHINT5 field.
	DMAC_INTSTATUS_CHINT5_Msk = 0x20 // Bit mask of CHINT5 field.
	DMAC_INTSTATUS_CHINT5     = 0x20 // Bit CHINT5.
	DMAC_INTSTATUS_CHINT6_Pos = 0x6  // Position of CHINT6 field.
	DMAC_INTSTATUS_CHINT6_Msk = 0x40 // Bit mask of CHINT6 field.
	DMAC_INTSTATUS_CHINT6     = 0x40 // Bit CHINT6.
	DMAC_INTSTATUS_CHINT7_Pos = 0x7  // Position of CHINT7 field.
	DMAC_INTSTATUS_CHINT7_Msk = 0x80 // Bit mask of CHINT7 field.
	DMAC_INTSTATUS_CHINT7     = 0x80 // Bit CHINT7.

	// BUSYCH: Busy Channels
	DMAC_BUSYCH_BUSYCH0_Pos = 0x0  // Position of BUSYCH0 field.
	DMAC_BUSYCH_BUSYCH0_Msk = 0x1  // Bit mask of BUSYCH0 field.
	DMAC_BUSYCH_BUSYCH0     = 0x1  // Bit BUSYCH0.
	DMAC_BUSYCH_BUSYCH1_Pos = 0x1  // Position of BUSYCH1 field.
	DMAC_BUSYCH_BUSYCH1_Msk = 0x2  // Bit mask of BUSYCH1 field.
	DMAC_BUSYCH_BUSYCH1     = 0x2  // Bit BUSYCH1.
	DMAC_BUSYCH_BUSYCH2_Pos = 0x2  // Position of BUSYCH2 field.
	DMAC_BUSYCH_BUSYCH2_Msk = 0x4  // Bit mask of BUSYCH2 field.
	DMAC_BUSYCH_BUSYCH2     = 0x4  // Bit BUSYCH2.
	DMAC_BUSYCH_BUSYCH3_Pos = 0x3  // Position of BUSYCH3 field.
	DMAC_BUSYCH_BUSYCH3_Msk = 0x8  // Bit mask of BUSYCH3 field.
	DMAC_BUSYCH_BUSYCH3     = 0x8  // Bit BUSYCH3.
	DMAC_BUSYCH_BUSYCH4_Pos = 0x4  // Position of BUSYCH4 field.
	DMAC_BUSYCH_BUSYCH4_Msk = 0x10 // Bit mask of BUSYCH4 field.
	DMAC_BUSYCH_BUSYCH4     = 0x10 // Bit BUSYCH4.
	DMAC_BUSYCH_BUSYCH5_Pos = 0x5  // Position of BUSYCH5 field.
	DMAC_BUSYCH_BUSYCH5_Msk = 0x20 // Bit mask of BUSYCH5 field.
	DMAC_BUSYCH_BUSYCH5     = 0x20 // Bit BUSYCH5.
	DMAC_BUSYCH_BUSYCH6_Pos = 0x6  // Position of BUSYCH6 field.
	DMAC_BUSYCH_BUSYCH6_Msk = 0x40 // Bit mask of BUSYCH6 field.
	DMAC_BUSYCH_BUSYCH6     = 0x40 // Bit BUSYCH6.
	DMAC_BUSYCH_BUSYCH7_Pos = 0x7  // Position of BUSYCH7 field.
	DMAC_BUSYCH_BUSYCH7_Msk = 0x80 // Bit mask of BUSYCH7 field.
	DMAC_BUSYCH_BUSYCH7     = 0x80 // Bit BUSYCH7.

	// PENDCH: Pending Channels
	DMAC_PENDCH_PENDCH0_Pos = 0x0  // Position of PENDCH0 field.
	DMAC_PENDCH_PENDCH0_Msk = 0x1  // Bit mask of PENDCH0 field.
	DMAC_PENDCH_PENDCH0     = 0x1  // Bit PENDCH0.
	DMAC_PENDCH_PENDCH1_Pos = 0x1  // Position of PENDCH1 field.
	DMAC_PENDCH_PENDCH1_Msk = 0x2  // Bit mask of PENDCH1 field.
	DMAC_PENDCH_PENDCH1     = 0x2  // Bit PENDCH1.
	DMAC_PENDCH_PENDCH2_Pos = 0x2  // Position of PENDCH2 field.
	DMAC_PENDCH_PENDCH2_Msk = 0x4  // Bit mask of PENDCH2 field.
	DMAC_PENDCH_PENDCH2     = 0x4  // Bit PENDCH2.
	DMAC_PENDCH_PENDCH3_Pos = 0x3  // Position of PENDCH3 field.
	DMAC_PENDCH_PENDCH3_Msk = 0x8  // Bit mask of PENDCH3 field.
	DMAC_PENDCH_PENDCH3     = 0x8  // Bit PENDCH3.
	DMAC_PENDCH_PENDCH4_Pos = 0x4  // Position of PENDCH4 field.
	DMAC_PENDCH_PENDCH4_Msk = 0x10 // Bit mask of PENDCH4 field.
	DMAC_PENDCH_PENDCH4     = 0x10 // Bit PENDCH4.
	DMAC_PENDCH_PENDCH5_Pos = 0x5  // Position of PENDCH5 field.
	DMAC_PENDCH_PENDCH5_Msk = 0x20 // Bit mask of PENDCH5 field.
	DMAC_PENDCH_PENDCH5     = 0x20 // Bit PENDCH5.
	DMAC_PENDCH_PENDCH6_Pos = 0x6  // Position of PENDCH6 field.
	DMAC_PENDCH_PENDCH6_Msk = 0x40 // Bit mask of PENDCH6 field.
	DMAC_PENDCH_PENDCH6     = 0x40 // Bit PENDCH6.
	DMAC_PENDCH_PENDCH7_Pos = 0x7  // Position of PENDCH7 field.
	DMAC_PENDCH_PENDCH7_Msk = 0x80 // Bit mask of PENDCH7 field.
	DMAC_PENDCH_PENDCH7     = 0x80 // Bit PENDCH7.

	// ACTIVE: Active Channel and Levels
	DMAC_ACTIVE_LVLEX0_Pos = 0x0        // Position of LVLEX0 field.
	DMAC_ACTIVE_LVLEX0_Msk = 0x1        // Bit mask of LVLEX0 field.
	DMAC_ACTIVE_LVLEX0     = 0x1        // Bit LVLEX0.
	DMAC_ACTIVE_LVLEX1_Pos = 0x1        // Position of LVLEX1 field.
	DMAC_ACTIVE_LVLEX1_Msk = 0x2        // Bit mask of LVLEX1 field.
	DMAC_ACTIVE_LVLEX1     = 0x2        // Bit LVLEX1.
	DMAC_ACTIVE_LVLEX2_Pos = 0x2        // Position of LVLEX2 field.
	DMAC_ACTIVE_LVLEX2_Msk = 0x4        // Bit mask of LVLEX2 field.
	DMAC_ACTIVE_LVLEX2     = 0x4        // Bit LVLEX2.
	DMAC_ACTIVE_LVLEX3_Pos = 0x3        // Position of LVLEX3 field.
	DMAC_ACTIVE_LVLEX3_Msk = 0x8        // Bit mask of LVLEX3 field.
	DMAC_ACTIVE_LVLEX3     = 0x8        // Bit LVLEX3.
	DMAC_ACTIVE_ID_Pos     = 0x8        // Position of ID field.
	DMAC_ACTIVE_ID_Msk     = 0x1f00     // Bit mask of ID field.
	DMAC_ACTIVE_ABUSY_Pos  = 0xf        // Position of ABUSY field.
	DMAC_ACTIVE_ABUSY_Msk  = 0x8000     // Bit mask of ABUSY field.
	DMAC_ACTIVE_ABUSY      = 0x8000     // Bit ABUSY.
	DMAC_ACTIVE_BTCNT_Pos  = 0x10       // Position of BTCNT field.
	DMAC_ACTIVE_BTCNT_Msk  = 0xffff0000 // Bit mask of BTCNT field.

	// BASEADDR: Descriptor Memory Section Base Address
	DMAC_BASEADDR_BASEADDR_Pos = 0x0        // Position of BASEADDR field.
	DMAC_BASEADDR_BASEADDR_Msk = 0xffffffff // Bit mask of BASEADDR field.

	// WRBADDR: Write-Back Memory Section Base Address
	DMAC_WRBADDR_WRBADDR_Pos = 0x0        // Position of WRBADDR field.
	DMAC_WRBADDR_WRBADDR_Msk = 0xffffffff // Bit mask of WRBADDR field.

	// CHID: Channel ID
	DMAC_CHID_ID_Pos = 0x0 // Position of ID field.
	DMAC_CHID_ID_Msk = 0x7 // Bit mask of ID field.

	// CHCTRLA: Channel Control A
	DMAC_CHCTRLA_SWRST_Pos    = 0x0  // Position of SWRST field.
	DMAC_CHCTRLA_SWRST_Msk    = 0x1  // Bit mask of SWRST field.
	DMAC_CHCTRLA_SWRST        = 0x1  // Bit SWRST.
	DMAC_CHCTRLA_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	DMAC_CHCTRLA_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	DMAC_CHCTRLA_ENABLE       = 0x2  // Bit ENABLE.
	DMAC_CHCTRLA_RUNSTDBY_Pos = 0x6  // Position of RUNSTDBY field.
	DMAC_CHCTRLA_RUNSTDBY_Msk = 0x40 // Bit mask of RUNSTDBY field.
	DMAC_CHCTRLA_RUNSTDBY     = 0x40 // Bit RUNSTDBY.

	// CHCTRLB: Channel Control B
	DMAC_CHCTRLB_EVACT_Pos           = 0x0       // Position of EVACT field.
	DMAC_CHCTRLB_EVACT_Msk           = 0x7       // Bit mask of EVACT field.
	DMAC_CHCTRLB_EVACT_NOACT         = 0x0       // No action
	DMAC_CHCTRLB_EVACT_TRIG          = 0x1       // Transfer and periodic transfer trigger
	DMAC_CHCTRLB_EVACT_CTRIG         = 0x2       // Conditional transfer trigger
	DMAC_CHCTRLB_EVACT_CBLOCK        = 0x3       // Conditional block transfer
	DMAC_CHCTRLB_EVACT_SUSPEND       = 0x4       // Channel suspend operation
	DMAC_CHCTRLB_EVACT_RESUME        = 0x5       // Channel resume operation
	DMAC_CHCTRLB_EVACT_SSKIP         = 0x6       // Skip next block suspend action
	DMAC_CHCTRLB_EVIE_Pos            = 0x3       // Position of EVIE field.
	DMAC_CHCTRLB_EVIE_Msk            = 0x8       // Bit mask of EVIE field.
	DMAC_CHCTRLB_EVIE                = 0x8       // Bit EVIE.
	DMAC_CHCTRLB_EVOE_Pos            = 0x4       // Position of EVOE field.
	DMAC_CHCTRLB_EVOE_Msk            = 0x10      // Bit mask of EVOE field.
	DMAC_CHCTRLB_EVOE                = 0x10      // Bit EVOE.
	DMAC_CHCTRLB_LVL_Pos             = 0x5       // Position of LVL field.
	DMAC_CHCTRLB_LVL_Msk             = 0x60      // Bit mask of LVL field.
	DMAC_CHCTRLB_TRIGSRC_Pos         = 0x8       // Position of TRIGSRC field.
	DMAC_CHCTRLB_TRIGSRC_Msk         = 0x1f00    // Bit mask of TRIGSRC field.
	DMAC_CHCTRLB_TRIGSRC_DISABLE     = 0x0       // Only software/event triggers
	DMAC_CHCTRLB_TRIGACT_Pos         = 0x16      // Position of TRIGACT field.
	DMAC_CHCTRLB_TRIGACT_Msk         = 0xc00000  // Bit mask of TRIGACT field.
	DMAC_CHCTRLB_TRIGACT_BLOCK       = 0x0       // One trigger required for each block transfer
	DMAC_CHCTRLB_TRIGACT_BEAT        = 0x2       // One trigger required for each beat transfer
	DMAC_CHCTRLB_TRIGACT_TRANSACTION = 0x3       // One trigger required for each transaction
	DMAC_CHCTRLB_CMD_Pos             = 0x18      // Position of CMD field.
	DMAC_CHCTRLB_CMD_Msk             = 0x3000000 // Bit mask of CMD field.
	DMAC_CHCTRLB_CMD_NOACT           = 0x0       // No action
	DMAC_CHCTRLB_CMD_SUSPEND         = 0x1       // Channel suspend operation
	DMAC_CHCTRLB_CMD_RESUME          = 0x2       // Channel resume operation

	// CHINTENCLR: Channel Interrupt Enable Clear
	DMAC_CHINTENCLR_TERR_Pos  = 0x0 // Position of TERR field.
	DMAC_CHINTENCLR_TERR_Msk  = 0x1 // Bit mask of TERR field.
	DMAC_CHINTENCLR_TERR      = 0x1 // Bit TERR.
	DMAC_CHINTENCLR_TCMPL_Pos = 0x1 // Position of TCMPL field.
	DMAC_CHINTENCLR_TCMPL_Msk = 0x2 // Bit mask of TCMPL field.
	DMAC_CHINTENCLR_TCMPL     = 0x2 // Bit TCMPL.
	DMAC_CHINTENCLR_SUSP_Pos  = 0x2 // Position of SUSP field.
	DMAC_CHINTENCLR_SUSP_Msk  = 0x4 // Bit mask of SUSP field.
	DMAC_CHINTENCLR_SUSP      = 0x4 // Bit SUSP.

	// CHINTENSET: Channel Interrupt Enable Set
	DMAC_CHINTENSET_TERR_Pos  = 0x0 // Position of TERR field.
	DMAC_CHINTENSET_TERR_Msk  = 0x1 // Bit mask of TERR field.
	DMAC_CHINTENSET_TERR      = 0x1 // Bit TERR.
	DMAC_CHINTENSET_TCMPL_Pos = 0x1 // Position of TCMPL field.
	DMAC_CHINTENSET_TCMPL_Msk = 0x2 // Bit mask of TCMPL field.
	DMAC_CHINTENSET_TCMPL     = 0x2 // Bit TCMPL.
	DMAC_CHINTENSET_SUSP_Pos  = 0x2 // Position of SUSP field.
	DMAC_CHINTENSET_SUSP_Msk  = 0x4 // Bit mask of SUSP field.
	DMAC_CHINTENSET_SUSP      = 0x4 // Bit SUSP.

	// CHINTFLAG: Channel Interrupt Flag Status and Clear
	DMAC_CHINTFLAG_TERR_Pos  = 0x0 // Position of TERR field.
	DMAC_CHINTFLAG_TERR_Msk  = 0x1 // Bit mask of TERR field.
	DMAC_CHINTFLAG_TERR      = 0x1 // Bit TERR.
	DMAC_CHINTFLAG_TCMPL_Pos = 0x1 // Position of TCMPL field.
	DMAC_CHINTFLAG_TCMPL_Msk = 0x2 // Bit mask of TCMPL field.
	DMAC_CHINTFLAG_TCMPL     = 0x2 // Bit TCMPL.
	DMAC_CHINTFLAG_SUSP_Pos  = 0x2 // Position of SUSP field.
	DMAC_CHINTFLAG_SUSP_Msk  = 0x4 // Bit mask of SUSP field.
	DMAC_CHINTFLAG_SUSP      = 0x4 // Bit SUSP.

	// CHSTATUS: Channel Status
	DMAC_CHSTATUS_PEND_Pos = 0x0 // Position of PEND field.
	DMAC_CHSTATUS_PEND_Msk = 0x1 // Bit mask of PEND field.
	DMAC_CHSTATUS_PEND     = 0x1 // Bit PEND.
	DMAC_CHSTATUS_BUSY_Pos = 0x1 // Position of BUSY field.
	DMAC_CHSTATUS_BUSY_Msk = 0x2 // Bit mask of BUSY field.
	DMAC_CHSTATUS_BUSY     = 0x2 // Bit BUSY.
	DMAC_CHSTATUS_FERR_Pos = 0x2 // Position of FERR field.
	DMAC_CHSTATUS_FERR_Msk = 0x4 // Bit mask of FERR field.
	DMAC_CHSTATUS_FERR     = 0x4 // Bit FERR.
)

// Bitfields for DSU: Device Service Unit
const (
	// CTRL: Control
	DSU_CTRL_SWRST_Pos = 0x0 // Position of SWRST field.
	DSU_CTRL_SWRST_Msk = 0x1 // Bit mask of SWRST field.
	DSU_CTRL_SWRST     = 0x1 // Bit SWRST.
	DSU_CTRL_CRC_Pos   = 0x2 // Position of CRC field.
	DSU_CTRL_CRC_Msk   = 0x4 // Bit mask of CRC field.
	DSU_CTRL_CRC       = 0x4 // Bit CRC.
	DSU_CTRL_MBIST_Pos = 0x3 // Position of MBIST field.
	DSU_CTRL_MBIST_Msk = 0x8 // Bit mask of MBIST field.
	DSU_CTRL_MBIST     = 0x8 // Bit MBIST.

	// STATUSA: Status A
	DSU_STATUSA_DONE_Pos    = 0x0  // Position of DONE field.
	DSU_STATUSA_DONE_Msk    = 0x1  // Bit mask of DONE field.
	DSU_STATUSA_DONE        = 0x1  // Bit DONE.
	DSU_STATUSA_CRSTEXT_Pos = 0x1  // Position of CRSTEXT field.
	DSU_STATUSA_CRSTEXT_Msk = 0x2  // Bit mask of CRSTEXT field.
	DSU_STATUSA_CRSTEXT     = 0x2  // Bit CRSTEXT.
	DSU_STATUSA_BERR_Pos    = 0x2  // Position of BERR field.
	DSU_STATUSA_BERR_Msk    = 0x4  // Bit mask of BERR field.
	DSU_STATUSA_BERR        = 0x4  // Bit BERR.
	DSU_STATUSA_FAIL_Pos    = 0x3  // Position of FAIL field.
	DSU_STATUSA_FAIL_Msk    = 0x8  // Bit mask of FAIL field.
	DSU_STATUSA_FAIL        = 0x8  // Bit FAIL.
	DSU_STATUSA_PERR_Pos    = 0x4  // Position of PERR field.
	DSU_STATUSA_PERR_Msk    = 0x10 // Bit mask of PERR field.
	DSU_STATUSA_PERR        = 0x10 // Bit PERR.
	DSU_STATUSA_BREXT_Pos   = 0x5  // Position of BREXT field.
	DSU_STATUSA_BREXT_Msk   = 0x20 // Bit mask of BREXT field.
	DSU_STATUSA_BREXT       = 0x20 // Bit BREXT.

	// STATUSB: Status B
	DSU_STATUSB_DAL_Pos        = 0x0 // Position of DAL field.
	DSU_STATUSB_DAL_Msk        = 0x3 // Bit mask of DAL field.
	DSU_STATUSB_DAL_SECURED    = 0x0
	DSU_STATUSB_DAL_NS_DEBUG   = 0x1
	DSU_STATUSB_DAL_FULL_DEBUG = 0x2
	DSU_STATUSB_DBGPRES_Pos    = 0x2  // Position of DBGPRES field.
	DSU_STATUSB_DBGPRES_Msk    = 0x4  // Bit mask of DBGPRES field.
	DSU_STATUSB_DBGPRES        = 0x4  // Bit DBGPRES.
	DSU_STATUSB_HPE_Pos        = 0x3  // Position of HPE field.
	DSU_STATUSB_HPE_Msk        = 0x8  // Bit mask of HPE field.
	DSU_STATUSB_HPE            = 0x8  // Bit HPE.
	DSU_STATUSB_DCCD0_Pos      = 0x4  // Position of DCCD0 field.
	DSU_STATUSB_DCCD0_Msk      = 0x10 // Bit mask of DCCD0 field.
	DSU_STATUSB_DCCD0          = 0x10 // Bit DCCD0.
	DSU_STATUSB_DCCD1_Pos      = 0x5  // Position of DCCD1 field.
	DSU_STATUSB_DCCD1_Msk      = 0x20 // Bit mask of DCCD1 field.
	DSU_STATUSB_DCCD1          = 0x20 // Bit DCCD1.
	DSU_STATUSB_BCCD0_Pos      = 0x6  // Position of BCCD0 field.
	DSU_STATUSB_BCCD0_Msk      = 0x40 // Bit mask of BCCD0 field.
	DSU_STATUSB_BCCD0          = 0x40 // Bit BCCD0.
	DSU_STATUSB_BCCD1_Pos      = 0x7  // Position of BCCD1 field.
	DSU_STATUSB_BCCD1_Msk      = 0x80 // Bit mask of BCCD1 field.
	DSU_STATUSB_BCCD1          = 0x80 // Bit BCCD1.

	// ADDR: Address
	DSU_ADDR_AMOD_Pos = 0x0        // Position of AMOD field.
	DSU_ADDR_AMOD_Msk = 0x3        // Bit mask of AMOD field.
	DSU_ADDR_ADDR_Pos = 0x2        // Position of ADDR field.
	DSU_ADDR_ADDR_Msk = 0xfffffffc // Bit mask of ADDR field.

	// LENGTH: Length
	DSU_LENGTH_LENGTH_Pos = 0x2        // Position of LENGTH field.
	DSU_LENGTH_LENGTH_Msk = 0xfffffffc // Bit mask of LENGTH field.

	// DATA: Data
	DSU_DATA_DATA_Pos = 0x0        // Position of DATA field.
	DSU_DATA_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// DCC: Debug Communication Channel n
	DSU_DCC_DATA_Pos = 0x0        // Position of DATA field.
	DSU_DCC_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// DID: Device Identification
	DSU_DID_DEVSEL_Pos     = 0x0        // Position of DEVSEL field.
	DSU_DID_DEVSEL_Msk     = 0xff       // Bit mask of DEVSEL field.
	DSU_DID_REVISION_Pos   = 0x8        // Position of REVISION field.
	DSU_DID_REVISION_Msk   = 0xf00      // Bit mask of REVISION field.
	DSU_DID_DIE_Pos        = 0xc        // Position of DIE field.
	DSU_DID_DIE_Msk        = 0xf000     // Bit mask of DIE field.
	DSU_DID_SERIES_Pos     = 0x10       // Position of SERIES field.
	DSU_DID_SERIES_Msk     = 0x3f0000   // Bit mask of SERIES field.
	DSU_DID_SERIES_0       = 0x0        // Cortex-M0+ processor, basic feature set
	DSU_DID_SERIES_1       = 0x1        // Cortex-M0+ processor, USB
	DSU_DID_FAMILY_Pos     = 0x17       // Position of FAMILY field.
	DSU_DID_FAMILY_Msk     = 0xf800000  // Bit mask of FAMILY field.
	DSU_DID_FAMILY_0       = 0x0        // General purpose microcontroller
	DSU_DID_FAMILY_1       = 0x1        // PicoPower
	DSU_DID_PROCESSOR_Pos  = 0x1c       // Position of PROCESSOR field.
	DSU_DID_PROCESSOR_Msk  = 0xf0000000 // Bit mask of PROCESSOR field.
	DSU_DID_PROCESSOR_CM0P = 0x1        // Cortex-M0+
	DSU_DID_PROCESSOR_CM23 = 0x2        // Cortex-M23
	DSU_DID_PROCESSOR_CM3  = 0x3        // Cortex-M3
	DSU_DID_PROCESSOR_CM4  = 0x5        // Cortex-M4
	DSU_DID_PROCESSOR_CM4F = 0x6        // Cortex-M4 with FPU
	DSU_DID_PROCESSOR_CM33 = 0x7        // Cortex-M33

	// CFG: Configuration
	DSU_CFG_LQOS_Pos          = 0x0 // Position of LQOS field.
	DSU_CFG_LQOS_Msk          = 0x3 // Bit mask of LQOS field.
	DSU_CFG_DCCDMALEVEL_Pos   = 0x2 // Position of DCCDMALEVEL field.
	DSU_CFG_DCCDMALEVEL_Msk   = 0xc // Bit mask of DCCDMALEVEL field.
	DSU_CFG_DCCDMALEVEL_EMPTY = 0x0 // Trigger rises when DCC is empty
	DSU_CFG_DCCDMALEVEL_FULL  = 0x1 // Trigger rises when DCC is full

	// BCC: Boot ROM Communication Channel n
	DSU_BCC_DATA_Pos = 0x0        // Position of DATA field.
	DSU_BCC_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// DCFG: Device Configuration
	DSU_DCFG_DCFG_Pos = 0x0        // Position of DCFG field.
	DSU_DCFG_DCFG_Msk = 0xffffffff // Bit mask of DCFG field.

	// ENTRY0: CoreSight ROM Table Entry 0
	DSU_ENTRY0_EPRES_Pos  = 0x0        // Position of EPRES field.
	DSU_ENTRY0_EPRES_Msk  = 0x1        // Bit mask of EPRES field.
	DSU_ENTRY0_EPRES      = 0x1        // Bit EPRES.
	DSU_ENTRY0_FMT_Pos    = 0x1        // Position of FMT field.
	DSU_ENTRY0_FMT_Msk    = 0x2        // Bit mask of FMT field.
	DSU_ENTRY0_FMT        = 0x2        // Bit FMT.
	DSU_ENTRY0_ADDOFF_Pos = 0xc        // Position of ADDOFF field.
	DSU_ENTRY0_ADDOFF_Msk = 0xfffff000 // Bit mask of ADDOFF field.

	// END: CoreSight ROM Table End
	DSU_END_END_Pos = 0x0        // Position of END field.
	DSU_END_END_Msk = 0xffffffff // Bit mask of END field.

	// MEMTYPE: CoreSight ROM Table Memory Type
	DSU_MEMTYPE_SMEMP_Pos = 0x0 // Position of SMEMP field.
	DSU_MEMTYPE_SMEMP_Msk = 0x1 // Bit mask of SMEMP field.
	DSU_MEMTYPE_SMEMP     = 0x1 // Bit SMEMP.

	// PID4: Peripheral Identification 4
	DSU_PID4_JEPCC_Pos = 0x0  // Position of JEPCC field.
	DSU_PID4_JEPCC_Msk = 0xf  // Bit mask of JEPCC field.
	DSU_PID4_FKBC_Pos  = 0x4  // Position of FKBC field.
	DSU_PID4_FKBC_Msk  = 0xf0 // Bit mask of FKBC field.

	// PID0: Peripheral Identification 0
	DSU_PID0_PARTNBL_Pos = 0x0  // Position of PARTNBL field.
	DSU_PID0_PARTNBL_Msk = 0xff // Bit mask of PARTNBL field.

	// PID1: Peripheral Identification 1
	DSU_PID1_PARTNBH_Pos = 0x0  // Position of PARTNBH field.
	DSU_PID1_PARTNBH_Msk = 0xf  // Bit mask of PARTNBH field.
	DSU_PID1_JEPIDCL_Pos = 0x4  // Position of JEPIDCL field.
	DSU_PID1_JEPIDCL_Msk = 0xf0 // Bit mask of JEPIDCL field.

	// PID2: Peripheral Identification 2
	DSU_PID2_JEPIDCH_Pos  = 0x0  // Position of JEPIDCH field.
	DSU_PID2_JEPIDCH_Msk  = 0x7  // Bit mask of JEPIDCH field.
	DSU_PID2_JEPU_Pos     = 0x3  // Position of JEPU field.
	DSU_PID2_JEPU_Msk     = 0x8  // Bit mask of JEPU field.
	DSU_PID2_JEPU         = 0x8  // Bit JEPU.
	DSU_PID2_REVISION_Pos = 0x4  // Position of REVISION field.
	DSU_PID2_REVISION_Msk = 0xf0 // Bit mask of REVISION field.

	// PID3: Peripheral Identification 3
	DSU_PID3_CUSMOD_Pos = 0x0  // Position of CUSMOD field.
	DSU_PID3_CUSMOD_Msk = 0xf  // Bit mask of CUSMOD field.
	DSU_PID3_REVAND_Pos = 0x4  // Position of REVAND field.
	DSU_PID3_REVAND_Msk = 0xf0 // Bit mask of REVAND field.

	// CID0: Component Identification 0
	DSU_CID0_PREAMBLEB0_Pos = 0x0  // Position of PREAMBLEB0 field.
	DSU_CID0_PREAMBLEB0_Msk = 0xff // Bit mask of PREAMBLEB0 field.

	// CID1: Component Identification 1
	DSU_CID1_PREAMBLE_Pos = 0x0  // Position of PREAMBLE field.
	DSU_CID1_PREAMBLE_Msk = 0xf  // Bit mask of PREAMBLE field.
	DSU_CID1_CCLASS_Pos   = 0x4  // Position of CCLASS field.
	DSU_CID1_CCLASS_Msk   = 0xf0 // Bit mask of CCLASS field.

	// CID2: Component Identification 2
	DSU_CID2_PREAMBLEB2_Pos = 0x0  // Position of PREAMBLEB2 field.
	DSU_CID2_PREAMBLEB2_Msk = 0xff // Bit mask of PREAMBLEB2 field.

	// CID3: Component Identification 3
	DSU_CID3_PREAMBLEB3_Pos = 0x0  // Position of PREAMBLEB3 field.
	DSU_CID3_PREAMBLEB3_Msk = 0xff // Bit mask of PREAMBLEB3 field.
)

// Bitfields for EIC: External Interrupt Controller
const (
	// CTRLA: Control A
	EIC_CTRLA_SWRST_Pos  = 0x0  // Position of SWRST field.
	EIC_CTRLA_SWRST_Msk  = 0x1  // Bit mask of SWRST field.
	EIC_CTRLA_SWRST      = 0x1  // Bit SWRST.
	EIC_CTRLA_ENABLE_Pos = 0x1  // Position of ENABLE field.
	EIC_CTRLA_ENABLE_Msk = 0x2  // Bit mask of ENABLE field.
	EIC_CTRLA_ENABLE     = 0x2  // Bit ENABLE.
	EIC_CTRLA_CKSEL_Pos  = 0x4  // Position of CKSEL field.
	EIC_CTRLA_CKSEL_Msk  = 0x10 // Bit mask of CKSEL field.
	EIC_CTRLA_CKSEL      = 0x10 // Bit CKSEL.

	// NMICTRL: Non-Maskable Interrupt Control
	EIC_NMICTRL_NMISENSE_Pos  = 0x0  // Position of NMISENSE field.
	EIC_NMICTRL_NMISENSE_Msk  = 0x7  // Bit mask of NMISENSE field.
	EIC_NMICTRL_NMISENSE_NONE = 0x0  // No detection
	EIC_NMICTRL_NMISENSE_RISE = 0x1  // Rising-edge detection
	EIC_NMICTRL_NMISENSE_FALL = 0x2  // Falling-edge detection
	EIC_NMICTRL_NMISENSE_BOTH = 0x3  // Both-edges detection
	EIC_NMICTRL_NMISENSE_HIGH = 0x4  // High-level detection
	EIC_NMICTRL_NMISENSE_LOW  = 0x5  // Low-level detection
	EIC_NMICTRL_NMIFILTEN_Pos = 0x3  // Position of NMIFILTEN field.
	EIC_NMICTRL_NMIFILTEN_Msk = 0x8  // Bit mask of NMIFILTEN field.
	EIC_NMICTRL_NMIFILTEN     = 0x8  // Bit NMIFILTEN.
	EIC_NMICTRL_NMIASYNCH_Pos = 0x4  // Position of NMIASYNCH field.
	EIC_NMICTRL_NMIASYNCH_Msk = 0x10 // Bit mask of NMIASYNCH field.
	EIC_NMICTRL_NMIASYNCH     = 0x10 // Bit NMIASYNCH.

	// NMIFLAG: Non-Maskable Interrupt Flag Status and Clear
	EIC_NMIFLAG_NMI_Pos = 0x0 // Position of NMI field.
	EIC_NMIFLAG_NMI_Msk = 0x1 // Bit mask of NMI field.
	EIC_NMIFLAG_NMI     = 0x1 // Bit NMI.

	// SYNCBUSY: Synchronization Busy
	EIC_SYNCBUSY_SWRST_Pos  = 0x0 // Position of SWRST field.
	EIC_SYNCBUSY_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	EIC_SYNCBUSY_SWRST      = 0x1 // Bit SWRST.
	EIC_SYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	EIC_SYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	EIC_SYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.

	// EVCTRL: Event Control
	EIC_EVCTRL_EXTINTEO_Pos = 0x0  // Position of EXTINTEO field.
	EIC_EVCTRL_EXTINTEO_Msk = 0xff // Bit mask of EXTINTEO field.

	// INTENCLR: Interrupt Enable Clear
	EIC_INTENCLR_EXTINT_Pos = 0x0        // Position of EXTINT field.
	EIC_INTENCLR_EXTINT_Msk = 0xff       // Bit mask of EXTINT field.
	EIC_INTENCLR_NSCHK_Pos  = 0x1f       // Position of NSCHK field.
	EIC_INTENCLR_NSCHK_Msk  = 0x80000000 // Bit mask of NSCHK field.
	EIC_INTENCLR_NSCHK      = 0x80000000 // Bit NSCHK.

	// INTENSET: Interrupt Enable Set
	EIC_INTENSET_EXTINT_Pos = 0x0        // Position of EXTINT field.
	EIC_INTENSET_EXTINT_Msk = 0xff       // Bit mask of EXTINT field.
	EIC_INTENSET_NSCHK_Pos  = 0x1f       // Position of NSCHK field.
	EIC_INTENSET_NSCHK_Msk  = 0x80000000 // Bit mask of NSCHK field.
	EIC_INTENSET_NSCHK      = 0x80000000 // Bit NSCHK.

	// INTFLAG: Interrupt Flag Status and Clear
	EIC_INTFLAG_EXTINT_Pos = 0x0        // Position of EXTINT field.
	EIC_INTFLAG_EXTINT_Msk = 0xff       // Bit mask of EXTINT field.
	EIC_INTFLAG_NSCHK_Pos  = 0x1f       // Position of NSCHK field.
	EIC_INTFLAG_NSCHK_Msk  = 0x80000000 // Bit mask of NSCHK field.
	EIC_INTFLAG_NSCHK      = 0x80000000 // Bit NSCHK.

	// ASYNCH: External Interrupt Asynchronous Mode
	EIC_ASYNCH_ASYNCH_Pos = 0x0  // Position of ASYNCH field.
	EIC_ASYNCH_ASYNCH_Msk = 0xff // Bit mask of ASYNCH field.

	// CONFIG: External Interrupt Sense Configuration
	EIC_CONFIG_SENSE0_Pos  = 0x0        // Position of SENSE0 field.
	EIC_CONFIG_SENSE0_Msk  = 0x7        // Bit mask of SENSE0 field.
	EIC_CONFIG_SENSE0_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE0_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE0_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE0_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE0_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE0_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN0_Pos = 0x3        // Position of FILTEN0 field.
	EIC_CONFIG_FILTEN0_Msk = 0x8        // Bit mask of FILTEN0 field.
	EIC_CONFIG_FILTEN0     = 0x8        // Bit FILTEN0.
	EIC_CONFIG_SENSE1_Pos  = 0x4        // Position of SENSE1 field.
	EIC_CONFIG_SENSE1_Msk  = 0x70       // Bit mask of SENSE1 field.
	EIC_CONFIG_SENSE1_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE1_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE1_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE1_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE1_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE1_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN1_Pos = 0x7        // Position of FILTEN1 field.
	EIC_CONFIG_FILTEN1_Msk = 0x80       // Bit mask of FILTEN1 field.
	EIC_CONFIG_FILTEN1     = 0x80       // Bit FILTEN1.
	EIC_CONFIG_SENSE2_Pos  = 0x8        // Position of SENSE2 field.
	EIC_CONFIG_SENSE2_Msk  = 0x700      // Bit mask of SENSE2 field.
	EIC_CONFIG_SENSE2_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE2_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE2_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE2_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE2_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE2_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN2_Pos = 0xb        // Position of FILTEN2 field.
	EIC_CONFIG_FILTEN2_Msk = 0x800      // Bit mask of FILTEN2 field.
	EIC_CONFIG_FILTEN2     = 0x800      // Bit FILTEN2.
	EIC_CONFIG_SENSE3_Pos  = 0xc        // Position of SENSE3 field.
	EIC_CONFIG_SENSE3_Msk  = 0x7000     // Bit mask of SENSE3 field.
	EIC_CONFIG_SENSE3_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE3_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE3_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE3_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE3_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE3_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN3_Pos = 0xf        // Position of FILTEN3 field.
	EIC_CONFIG_FILTEN3_Msk = 0x8000     // Bit mask of FILTEN3 field.
	EIC_CONFIG_FILTEN3     = 0x8000     // Bit FILTEN3.
	EIC_CONFIG_SENSE4_Pos  = 0x10       // Position of SENSE4 field.
	EIC_CONFIG_SENSE4_Msk  = 0x70000    // Bit mask of SENSE4 field.
	EIC_CONFIG_SENSE4_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE4_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE4_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE4_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE4_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE4_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN4_Pos = 0x13       // Position of FILTEN4 field.
	EIC_CONFIG_FILTEN4_Msk = 0x80000    // Bit mask of FILTEN4 field.
	EIC_CONFIG_FILTEN4     = 0x80000    // Bit FILTEN4.
	EIC_CONFIG_SENSE5_Pos  = 0x14       // Position of SENSE5 field.
	EIC_CONFIG_SENSE5_Msk  = 0x700000   // Bit mask of SENSE5 field.
	EIC_CONFIG_SENSE5_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE5_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE5_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE5_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE5_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE5_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN5_Pos = 0x17       // Position of FILTEN5 field.
	EIC_CONFIG_FILTEN5_Msk = 0x800000   // Bit mask of FILTEN5 field.
	EIC_CONFIG_FILTEN5     = 0x800000   // Bit FILTEN5.
	EIC_CONFIG_SENSE6_Pos  = 0x18       // Position of SENSE6 field.
	EIC_CONFIG_SENSE6_Msk  = 0x7000000  // Bit mask of SENSE6 field.
	EIC_CONFIG_SENSE6_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE6_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE6_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE6_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE6_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE6_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN6_Pos = 0x1b       // Position of FILTEN6 field.
	EIC_CONFIG_FILTEN6_Msk = 0x8000000  // Bit mask of FILTEN6 field.
	EIC_CONFIG_FILTEN6     = 0x8000000  // Bit FILTEN6.
	EIC_CONFIG_SENSE7_Pos  = 0x1c       // Position of SENSE7 field.
	EIC_CONFIG_SENSE7_Msk  = 0x70000000 // Bit mask of SENSE7 field.
	EIC_CONFIG_SENSE7_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE7_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE7_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE7_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE7_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE7_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN7_Pos = 0x1f       // Position of FILTEN7 field.
	EIC_CONFIG_FILTEN7_Msk = 0x80000000 // Bit mask of FILTEN7 field.
	EIC_CONFIG_FILTEN7     = 0x80000000 // Bit FILTEN7.

	// DEBOUNCEN: Debouncer Enable
	EIC_DEBOUNCEN_DEBOUNCEN_Pos = 0x0  // Position of DEBOUNCEN field.
	EIC_DEBOUNCEN_DEBOUNCEN_Msk = 0xff // Bit mask of DEBOUNCEN field.

	// DPRESCALER: Debouncer Prescaler
	EIC_DPRESCALER_PRESCALER0_Pos = 0x0     // Position of PRESCALER0 field.
	EIC_DPRESCALER_PRESCALER0_Msk = 0x7     // Bit mask of PRESCALER0 field.
	EIC_DPRESCALER_STATES0_Pos    = 0x3     // Position of STATES0 field.
	EIC_DPRESCALER_STATES0_Msk    = 0x8     // Bit mask of STATES0 field.
	EIC_DPRESCALER_STATES0        = 0x8     // Bit STATES0.
	EIC_DPRESCALER_TICKON_Pos     = 0x10    // Position of TICKON field.
	EIC_DPRESCALER_TICKON_Msk     = 0x10000 // Bit mask of TICKON field.
	EIC_DPRESCALER_TICKON         = 0x10000 // Bit TICKON.

	// PINSTATE: Pin State
	EIC_PINSTATE_PINSTATE_Pos = 0x0  // Position of PINSTATE field.
	EIC_PINSTATE_PINSTATE_Msk = 0xff // Bit mask of PINSTATE field.

	// NSCHK: Non-secure Interrupt Check Enable
	EIC_NSCHK_EXTINT_Pos = 0x0        // Position of EXTINT field.
	EIC_NSCHK_EXTINT_Msk = 0xff       // Bit mask of EXTINT field.
	EIC_NSCHK_NMI_Pos    = 0x1f       // Position of NMI field.
	EIC_NSCHK_NMI_Msk    = 0x80000000 // Bit mask of NMI field.
	EIC_NSCHK_NMI        = 0x80000000 // Bit NMI.

	// NONSEC: Non-secure Interrupt
	EIC_NONSEC_EXTINT_Pos = 0x0        // Position of EXTINT field.
	EIC_NONSEC_EXTINT_Msk = 0xff       // Bit mask of EXTINT field.
	EIC_NONSEC_NMI_Pos    = 0x1f       // Position of NMI field.
	EIC_NONSEC_NMI_Msk    = 0x80000000 // Bit mask of NMI field.
	EIC_NONSEC_NMI        = 0x80000000 // Bit NMI.
)

// Bitfields for EVSYS: Event System Interface
const (
	// CTRLA: Control
	EVSYS_CTRLA_SWRST_Pos = 0x0 // Position of SWRST field.
	EVSYS_CTRLA_SWRST_Msk = 0x1 // Bit mask of SWRST field.
	EVSYS_CTRLA_SWRST     = 0x1 // Bit SWRST.

	// SWEVT: Software Event
	EVSYS_SWEVT_CHANNEL0_Pos = 0x0  // Position of CHANNEL0 field.
	EVSYS_SWEVT_CHANNEL0_Msk = 0x1  // Bit mask of CHANNEL0 field.
	EVSYS_SWEVT_CHANNEL0     = 0x1  // Bit CHANNEL0.
	EVSYS_SWEVT_CHANNEL1_Pos = 0x1  // Position of CHANNEL1 field.
	EVSYS_SWEVT_CHANNEL1_Msk = 0x2  // Bit mask of CHANNEL1 field.
	EVSYS_SWEVT_CHANNEL1     = 0x2  // Bit CHANNEL1.
	EVSYS_SWEVT_CHANNEL2_Pos = 0x2  // Position of CHANNEL2 field.
	EVSYS_SWEVT_CHANNEL2_Msk = 0x4  // Bit mask of CHANNEL2 field.
	EVSYS_SWEVT_CHANNEL2     = 0x4  // Bit CHANNEL2.
	EVSYS_SWEVT_CHANNEL3_Pos = 0x3  // Position of CHANNEL3 field.
	EVSYS_SWEVT_CHANNEL3_Msk = 0x8  // Bit mask of CHANNEL3 field.
	EVSYS_SWEVT_CHANNEL3     = 0x8  // Bit CHANNEL3.
	EVSYS_SWEVT_CHANNEL4_Pos = 0x4  // Position of CHANNEL4 field.
	EVSYS_SWEVT_CHANNEL4_Msk = 0x10 // Bit mask of CHANNEL4 field.
	EVSYS_SWEVT_CHANNEL4     = 0x10 // Bit CHANNEL4.
	EVSYS_SWEVT_CHANNEL5_Pos = 0x5  // Position of CHANNEL5 field.
	EVSYS_SWEVT_CHANNEL5_Msk = 0x20 // Bit mask of CHANNEL5 field.
	EVSYS_SWEVT_CHANNEL5     = 0x20 // Bit CHANNEL5.
	EVSYS_SWEVT_CHANNEL6_Pos = 0x6  // Position of CHANNEL6 field.
	EVSYS_SWEVT_CHANNEL6_Msk = 0x40 // Bit mask of CHANNEL6 field.
	EVSYS_SWEVT_CHANNEL6     = 0x40 // Bit CHANNEL6.
	EVSYS_SWEVT_CHANNEL7_Pos = 0x7  // Position of CHANNEL7 field.
	EVSYS_SWEVT_CHANNEL7_Msk = 0x80 // Bit mask of CHANNEL7 field.
	EVSYS_SWEVT_CHANNEL7     = 0x80 // Bit CHANNEL7.

	// PRICTRL: Priority Control
	EVSYS_PRICTRL_PRI_Pos  = 0x0  // Position of PRI field.
	EVSYS_PRICTRL_PRI_Msk  = 0x3  // Bit mask of PRI field.
	EVSYS_PRICTRL_RREN_Pos = 0x7  // Position of RREN field.
	EVSYS_PRICTRL_RREN_Msk = 0x80 // Bit mask of RREN field.
	EVSYS_PRICTRL_RREN     = 0x80 // Bit RREN.

	// INTPEND: Channel Pending Interrupt
	EVSYS_INTPEND_ID_Pos    = 0x0    // Position of ID field.
	EVSYS_INTPEND_ID_Msk    = 0x3    // Bit mask of ID field.
	EVSYS_INTPEND_OVR_Pos   = 0x8    // Position of OVR field.
	EVSYS_INTPEND_OVR_Msk   = 0x100  // Bit mask of OVR field.
	EVSYS_INTPEND_OVR       = 0x100  // Bit OVR.
	EVSYS_INTPEND_EVD_Pos   = 0x9    // Position of EVD field.
	EVSYS_INTPEND_EVD_Msk   = 0x200  // Bit mask of EVD field.
	EVSYS_INTPEND_EVD       = 0x200  // Bit EVD.
	EVSYS_INTPEND_READY_Pos = 0xe    // Position of READY field.
	EVSYS_INTPEND_READY_Msk = 0x4000 // Bit mask of READY field.
	EVSYS_INTPEND_READY     = 0x4000 // Bit READY.
	EVSYS_INTPEND_BUSY_Pos  = 0xf    // Position of BUSY field.
	EVSYS_INTPEND_BUSY_Msk  = 0x8000 // Bit mask of BUSY field.
	EVSYS_INTPEND_BUSY      = 0x8000 // Bit BUSY.

	// INTSTATUS: Interrupt Status
	EVSYS_INTSTATUS_CHINT0_Pos = 0x0 // Position of CHINT0 field.
	EVSYS_INTSTATUS_CHINT0_Msk = 0x1 // Bit mask of CHINT0 field.
	EVSYS_INTSTATUS_CHINT0     = 0x1 // Bit CHINT0.
	EVSYS_INTSTATUS_CHINT1_Pos = 0x1 // Position of CHINT1 field.
	EVSYS_INTSTATUS_CHINT1_Msk = 0x2 // Bit mask of CHINT1 field.
	EVSYS_INTSTATUS_CHINT1     = 0x2 // Bit CHINT1.
	EVSYS_INTSTATUS_CHINT2_Pos = 0x2 // Position of CHINT2 field.
	EVSYS_INTSTATUS_CHINT2_Msk = 0x4 // Bit mask of CHINT2 field.
	EVSYS_INTSTATUS_CHINT2     = 0x4 // Bit CHINT2.
	EVSYS_INTSTATUS_CHINT3_Pos = 0x3 // Position of CHINT3 field.
	EVSYS_INTSTATUS_CHINT3_Msk = 0x8 // Bit mask of CHINT3 field.
	EVSYS_INTSTATUS_CHINT3     = 0x8 // Bit CHINT3.

	// BUSYCH: Busy Channels
	EVSYS_BUSYCH_BUSYCH0_Pos = 0x0 // Position of BUSYCH0 field.
	EVSYS_BUSYCH_BUSYCH0_Msk = 0x1 // Bit mask of BUSYCH0 field.
	EVSYS_BUSYCH_BUSYCH0     = 0x1 // Bit BUSYCH0.
	EVSYS_BUSYCH_BUSYCH1_Pos = 0x1 // Position of BUSYCH1 field.
	EVSYS_BUSYCH_BUSYCH1_Msk = 0x2 // Bit mask of BUSYCH1 field.
	EVSYS_BUSYCH_BUSYCH1     = 0x2 // Bit BUSYCH1.
	EVSYS_BUSYCH_BUSYCH2_Pos = 0x2 // Position of BUSYCH2 field.
	EVSYS_BUSYCH_BUSYCH2_Msk = 0x4 // Bit mask of BUSYCH2 field.
	EVSYS_BUSYCH_BUSYCH2     = 0x4 // Bit BUSYCH2.
	EVSYS_BUSYCH_BUSYCH3_Pos = 0x3 // Position of BUSYCH3 field.
	EVSYS_BUSYCH_BUSYCH3_Msk = 0x8 // Bit mask of BUSYCH3 field.
	EVSYS_BUSYCH_BUSYCH3     = 0x8 // Bit BUSYCH3.

	// READYUSR: Ready Users
	EVSYS_READYUSR_READYUSR0_Pos = 0x0 // Position of READYUSR0 field.
	EVSYS_READYUSR_READYUSR0_Msk = 0x1 // Bit mask of READYUSR0 field.
	EVSYS_READYUSR_READYUSR0     = 0x1 // Bit READYUSR0.
	EVSYS_READYUSR_READYUSR1_Pos = 0x1 // Position of READYUSR1 field.
	EVSYS_READYUSR_READYUSR1_Msk = 0x2 // Bit mask of READYUSR1 field.
	EVSYS_READYUSR_READYUSR1     = 0x2 // Bit READYUSR1.
	EVSYS_READYUSR_READYUSR2_Pos = 0x2 // Position of READYUSR2 field.
	EVSYS_READYUSR_READYUSR2_Msk = 0x4 // Bit mask of READYUSR2 field.
	EVSYS_READYUSR_READYUSR2     = 0x4 // Bit READYUSR2.
	EVSYS_READYUSR_READYUSR3_Pos = 0x3 // Position of READYUSR3 field.
	EVSYS_READYUSR_READYUSR3_Msk = 0x8 // Bit mask of READYUSR3 field.
	EVSYS_READYUSR_READYUSR3     = 0x8 // Bit READYUSR3.

	// CHANNEL.CHANNEL: Channel n Control
	EVSYS_CHANNEL_CHANNEL_EVGEN_Pos            = 0x0    // Position of EVGEN field.
	EVSYS_CHANNEL_CHANNEL_EVGEN_Msk            = 0x3f   // Bit mask of EVGEN field.
	EVSYS_CHANNEL_CHANNEL_PATH_Pos             = 0x8    // Position of PATH field.
	EVSYS_CHANNEL_CHANNEL_PATH_Msk             = 0x300  // Bit mask of PATH field.
	EVSYS_CHANNEL_CHANNEL_PATH_SYNCHRONOUS     = 0x0    // Synchronous path
	EVSYS_CHANNEL_CHANNEL_PATH_RESYNCHRONIZED  = 0x1    // Resynchronized path
	EVSYS_CHANNEL_CHANNEL_PATH_ASYNCHRONOUS    = 0x2    // Asynchronous path
	EVSYS_CHANNEL_CHANNEL_EDGSEL_Pos           = 0xa    // Position of EDGSEL field.
	EVSYS_CHANNEL_CHANNEL_EDGSEL_Msk           = 0xc00  // Bit mask of EDGSEL field.
	EVSYS_CHANNEL_CHANNEL_EDGSEL_NO_EVT_OUTPUT = 0x0    // No event output when using the resynchronized or synchronous path
	EVSYS_CHANNEL_CHANNEL_EDGSEL_RISING_EDGE   = 0x1    // Event detection only on the rising edge of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_CHANNEL_EDGSEL_FALLING_EDGE  = 0x2    // Event detection only on the falling edge of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_CHANNEL_EDGSEL_BOTH_EDGES    = 0x3    // Event detection on rising and falling edges of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_CHANNEL_RUNSTDBY_Pos         = 0xe    // Position of RUNSTDBY field.
	EVSYS_CHANNEL_CHANNEL_RUNSTDBY_Msk         = 0x4000 // Bit mask of RUNSTDBY field.
	EVSYS_CHANNEL_CHANNEL_RUNSTDBY             = 0x4000 // Bit RUNSTDBY.
	EVSYS_CHANNEL_CHANNEL_ONDEMAND_Pos         = 0xf    // Position of ONDEMAND field.
	EVSYS_CHANNEL_CHANNEL_ONDEMAND_Msk         = 0x8000 // Bit mask of ONDEMAND field.
	EVSYS_CHANNEL_CHANNEL_ONDEMAND             = 0x8000 // Bit ONDEMAND.

	// CHANNEL.CHINTENCLR: Channel n Interrupt Enable Clear
	EVSYS_CHANNEL_CHINTENCLR_OVR_Pos = 0x0 // Position of OVR field.
	EVSYS_CHANNEL_CHINTENCLR_OVR_Msk = 0x1 // Bit mask of OVR field.
	EVSYS_CHANNEL_CHINTENCLR_OVR     = 0x1 // Bit OVR.
	EVSYS_CHANNEL_CHINTENCLR_EVD_Pos = 0x1 // Position of EVD field.
	EVSYS_CHANNEL_CHINTENCLR_EVD_Msk = 0x2 // Bit mask of EVD field.
	EVSYS_CHANNEL_CHINTENCLR_EVD     = 0x2 // Bit EVD.

	// CHANNEL.CHINTENSET: Channel n Interrupt Enable Set
	EVSYS_CHANNEL_CHINTENSET_OVR_Pos = 0x0 // Position of OVR field.
	EVSYS_CHANNEL_CHINTENSET_OVR_Msk = 0x1 // Bit mask of OVR field.
	EVSYS_CHANNEL_CHINTENSET_OVR     = 0x1 // Bit OVR.
	EVSYS_CHANNEL_CHINTENSET_EVD_Pos = 0x1 // Position of EVD field.
	EVSYS_CHANNEL_CHINTENSET_EVD_Msk = 0x2 // Bit mask of EVD field.
	EVSYS_CHANNEL_CHINTENSET_EVD     = 0x2 // Bit EVD.

	// CHANNEL.CHINTFLAG: Channel n Interrupt Flag Status and Clear
	EVSYS_CHANNEL_CHINTFLAG_OVR_Pos = 0x0 // Position of OVR field.
	EVSYS_CHANNEL_CHINTFLAG_OVR_Msk = 0x1 // Bit mask of OVR field.
	EVSYS_CHANNEL_CHINTFLAG_OVR     = 0x1 // Bit OVR.
	EVSYS_CHANNEL_CHINTFLAG_EVD_Pos = 0x1 // Position of EVD field.
	EVSYS_CHANNEL_CHINTFLAG_EVD_Msk = 0x2 // Bit mask of EVD field.
	EVSYS_CHANNEL_CHINTFLAG_EVD     = 0x2 // Bit EVD.

	// CHANNEL.CHSTATUS: Channel n Status
	EVSYS_CHANNEL_CHSTATUS_RDYUSR_Pos = 0x0 // Position of RDYUSR field.
	EVSYS_CHANNEL_CHSTATUS_RDYUSR_Msk = 0x1 // Bit mask of RDYUSR field.
	EVSYS_CHANNEL_CHSTATUS_RDYUSR     = 0x1 // Bit RDYUSR.
	EVSYS_CHANNEL_CHSTATUS_BUSYCH_Pos = 0x1 // Position of BUSYCH field.
	EVSYS_CHANNEL_CHSTATUS_BUSYCH_Msk = 0x2 // Bit mask of BUSYCH field.
	EVSYS_CHANNEL_CHSTATUS_BUSYCH     = 0x2 // Bit BUSYCH.

	// USER: User Multiplexer n
	EVSYS_USER_CHANNEL_Pos = 0x0 // Position of CHANNEL field.
	EVSYS_USER_CHANNEL_Msk = 0xf // Bit mask of CHANNEL field.

	// INTENCLR: Interrupt Enable Clear
	EVSYS_INTENCLR_NSCHK_Pos = 0x0 // Position of NSCHK field.
	EVSYS_INTENCLR_NSCHK_Msk = 0x1 // Bit mask of NSCHK field.
	EVSYS_INTENCLR_NSCHK     = 0x1 // Bit NSCHK.

	// INTENSET: Interrupt Enable Set
	EVSYS_INTENSET_NSCHK_Pos = 0x0 // Position of NSCHK field.
	EVSYS_INTENSET_NSCHK_Msk = 0x1 // Bit mask of NSCHK field.
	EVSYS_INTENSET_NSCHK     = 0x1 // Bit NSCHK.

	// INTFLAG: Interrupt Flag Status and Clear
	EVSYS_INTFLAG_NSCHK_Pos = 0x0 // Position of NSCHK field.
	EVSYS_INTFLAG_NSCHK_Msk = 0x1 // Bit mask of NSCHK field.
	EVSYS_INTFLAG_NSCHK     = 0x1 // Bit NSCHK.

	// NONSECCHAN: Channels Security Attribution
	EVSYS_NONSECCHAN_CHANNEL0_Pos = 0x0  // Position of CHANNEL0 field.
	EVSYS_NONSECCHAN_CHANNEL0_Msk = 0x1  // Bit mask of CHANNEL0 field.
	EVSYS_NONSECCHAN_CHANNEL0     = 0x1  // Bit CHANNEL0.
	EVSYS_NONSECCHAN_CHANNEL1_Pos = 0x1  // Position of CHANNEL1 field.
	EVSYS_NONSECCHAN_CHANNEL1_Msk = 0x2  // Bit mask of CHANNEL1 field.
	EVSYS_NONSECCHAN_CHANNEL1     = 0x2  // Bit CHANNEL1.
	EVSYS_NONSECCHAN_CHANNEL2_Pos = 0x2  // Position of CHANNEL2 field.
	EVSYS_NONSECCHAN_CHANNEL2_Msk = 0x4  // Bit mask of CHANNEL2 field.
	EVSYS_NONSECCHAN_CHANNEL2     = 0x4  // Bit CHANNEL2.
	EVSYS_NONSECCHAN_CHANNEL3_Pos = 0x3  // Position of CHANNEL3 field.
	EVSYS_NONSECCHAN_CHANNEL3_Msk = 0x8  // Bit mask of CHANNEL3 field.
	EVSYS_NONSECCHAN_CHANNEL3     = 0x8  // Bit CHANNEL3.
	EVSYS_NONSECCHAN_CHANNEL4_Pos = 0x4  // Position of CHANNEL4 field.
	EVSYS_NONSECCHAN_CHANNEL4_Msk = 0x10 // Bit mask of CHANNEL4 field.
	EVSYS_NONSECCHAN_CHANNEL4     = 0x10 // Bit CHANNEL4.
	EVSYS_NONSECCHAN_CHANNEL5_Pos = 0x5  // Position of CHANNEL5 field.
	EVSYS_NONSECCHAN_CHANNEL5_Msk = 0x20 // Bit mask of CHANNEL5 field.
	EVSYS_NONSECCHAN_CHANNEL5     = 0x20 // Bit CHANNEL5.
	EVSYS_NONSECCHAN_CHANNEL6_Pos = 0x6  // Position of CHANNEL6 field.
	EVSYS_NONSECCHAN_CHANNEL6_Msk = 0x40 // Bit mask of CHANNEL6 field.
	EVSYS_NONSECCHAN_CHANNEL6     = 0x40 // Bit CHANNEL6.
	EVSYS_NONSECCHAN_CHANNEL7_Pos = 0x7  // Position of CHANNEL7 field.
	EVSYS_NONSECCHAN_CHANNEL7_Msk = 0x80 // Bit mask of CHANNEL7 field.
	EVSYS_NONSECCHAN_CHANNEL7     = 0x80 // Bit CHANNEL7.

	// NSCHKCHAN: Non-Secure Channels Check
	EVSYS_NSCHKCHAN_CHANNEL0_Pos = 0x0  // Position of CHANNEL0 field.
	EVSYS_NSCHKCHAN_CHANNEL0_Msk = 0x1  // Bit mask of CHANNEL0 field.
	EVSYS_NSCHKCHAN_CHANNEL0     = 0x1  // Bit CHANNEL0.
	EVSYS_NSCHKCHAN_CHANNEL1_Pos = 0x1  // Position of CHANNEL1 field.
	EVSYS_NSCHKCHAN_CHANNEL1_Msk = 0x2  // Bit mask of CHANNEL1 field.
	EVSYS_NSCHKCHAN_CHANNEL1     = 0x2  // Bit CHANNEL1.
	EVSYS_NSCHKCHAN_CHANNEL2_Pos = 0x2  // Position of CHANNEL2 field.
	EVSYS_NSCHKCHAN_CHANNEL2_Msk = 0x4  // Bit mask of CHANNEL2 field.
	EVSYS_NSCHKCHAN_CHANNEL2     = 0x4  // Bit CHANNEL2.
	EVSYS_NSCHKCHAN_CHANNEL3_Pos = 0x3  // Position of CHANNEL3 field.
	EVSYS_NSCHKCHAN_CHANNEL3_Msk = 0x8  // Bit mask of CHANNEL3 field.
	EVSYS_NSCHKCHAN_CHANNEL3     = 0x8  // Bit CHANNEL3.
	EVSYS_NSCHKCHAN_CHANNEL4_Pos = 0x4  // Position of CHANNEL4 field.
	EVSYS_NSCHKCHAN_CHANNEL4_Msk = 0x10 // Bit mask of CHANNEL4 field.
	EVSYS_NSCHKCHAN_CHANNEL4     = 0x10 // Bit CHANNEL4.
	EVSYS_NSCHKCHAN_CHANNEL5_Pos = 0x5  // Position of CHANNEL5 field.
	EVSYS_NSCHKCHAN_CHANNEL5_Msk = 0x20 // Bit mask of CHANNEL5 field.
	EVSYS_NSCHKCHAN_CHANNEL5     = 0x20 // Bit CHANNEL5.
	EVSYS_NSCHKCHAN_CHANNEL6_Pos = 0x6  // Position of CHANNEL6 field.
	EVSYS_NSCHKCHAN_CHANNEL6_Msk = 0x40 // Bit mask of CHANNEL6 field.
	EVSYS_NSCHKCHAN_CHANNEL6     = 0x40 // Bit CHANNEL6.
	EVSYS_NSCHKCHAN_CHANNEL7_Pos = 0x7  // Position of CHANNEL7 field.
	EVSYS_NSCHKCHAN_CHANNEL7_Msk = 0x80 // Bit mask of CHANNEL7 field.
	EVSYS_NSCHKCHAN_CHANNEL7     = 0x80 // Bit CHANNEL7.

	// NONSECUSER: Users Security Attribution
	EVSYS_NONSECUSER_USER0_Pos  = 0x0      // Position of USER0 field.
	EVSYS_NONSECUSER_USER0_Msk  = 0x1      // Bit mask of USER0 field.
	EVSYS_NONSECUSER_USER0      = 0x1      // Bit USER0.
	EVSYS_NONSECUSER_USER1_Pos  = 0x1      // Position of USER1 field.
	EVSYS_NONSECUSER_USER1_Msk  = 0x2      // Bit mask of USER1 field.
	EVSYS_NONSECUSER_USER1      = 0x2      // Bit USER1.
	EVSYS_NONSECUSER_USER2_Pos  = 0x2      // Position of USER2 field.
	EVSYS_NONSECUSER_USER2_Msk  = 0x4      // Bit mask of USER2 field.
	EVSYS_NONSECUSER_USER2      = 0x4      // Bit USER2.
	EVSYS_NONSECUSER_USER3_Pos  = 0x3      // Position of USER3 field.
	EVSYS_NONSECUSER_USER3_Msk  = 0x8      // Bit mask of USER3 field.
	EVSYS_NONSECUSER_USER3      = 0x8      // Bit USER3.
	EVSYS_NONSECUSER_USER4_Pos  = 0x4      // Position of USER4 field.
	EVSYS_NONSECUSER_USER4_Msk  = 0x10     // Bit mask of USER4 field.
	EVSYS_NONSECUSER_USER4      = 0x10     // Bit USER4.
	EVSYS_NONSECUSER_USER5_Pos  = 0x5      // Position of USER5 field.
	EVSYS_NONSECUSER_USER5_Msk  = 0x20     // Bit mask of USER5 field.
	EVSYS_NONSECUSER_USER5      = 0x20     // Bit USER5.
	EVSYS_NONSECUSER_USER6_Pos  = 0x6      // Position of USER6 field.
	EVSYS_NONSECUSER_USER6_Msk  = 0x40     // Bit mask of USER6 field.
	EVSYS_NONSECUSER_USER6      = 0x40     // Bit USER6.
	EVSYS_NONSECUSER_USER7_Pos  = 0x7      // Position of USER7 field.
	EVSYS_NONSECUSER_USER7_Msk  = 0x80     // Bit mask of USER7 field.
	EVSYS_NONSECUSER_USER7      = 0x80     // Bit USER7.
	EVSYS_NONSECUSER_USER8_Pos  = 0x8      // Position of USER8 field.
	EVSYS_NONSECUSER_USER8_Msk  = 0x100    // Bit mask of USER8 field.
	EVSYS_NONSECUSER_USER8      = 0x100    // Bit USER8.
	EVSYS_NONSECUSER_USER9_Pos  = 0x9      // Position of USER9 field.
	EVSYS_NONSECUSER_USER9_Msk  = 0x200    // Bit mask of USER9 field.
	EVSYS_NONSECUSER_USER9      = 0x200    // Bit USER9.
	EVSYS_NONSECUSER_USER10_Pos = 0xa      // Position of USER10 field.
	EVSYS_NONSECUSER_USER10_Msk = 0x400    // Bit mask of USER10 field.
	EVSYS_NONSECUSER_USER10     = 0x400    // Bit USER10.
	EVSYS_NONSECUSER_USER11_Pos = 0xb      // Position of USER11 field.
	EVSYS_NONSECUSER_USER11_Msk = 0x800    // Bit mask of USER11 field.
	EVSYS_NONSECUSER_USER11     = 0x800    // Bit USER11.
	EVSYS_NONSECUSER_USER12_Pos = 0xc      // Position of USER12 field.
	EVSYS_NONSECUSER_USER12_Msk = 0x1000   // Bit mask of USER12 field.
	EVSYS_NONSECUSER_USER12     = 0x1000   // Bit USER12.
	EVSYS_NONSECUSER_USER13_Pos = 0xd      // Position of USER13 field.
	EVSYS_NONSECUSER_USER13_Msk = 0x2000   // Bit mask of USER13 field.
	EVSYS_NONSECUSER_USER13     = 0x2000   // Bit USER13.
	EVSYS_NONSECUSER_USER14_Pos = 0xe      // Position of USER14 field.
	EVSYS_NONSECUSER_USER14_Msk = 0x4000   // Bit mask of USER14 field.
	EVSYS_NONSECUSER_USER14     = 0x4000   // Bit USER14.
	EVSYS_NONSECUSER_USER15_Pos = 0xf      // Position of USER15 field.
	EVSYS_NONSECUSER_USER15_Msk = 0x8000   // Bit mask of USER15 field.
	EVSYS_NONSECUSER_USER15     = 0x8000   // Bit USER15.
	EVSYS_NONSECUSER_USER16_Pos = 0x10     // Position of USER16 field.
	EVSYS_NONSECUSER_USER16_Msk = 0x10000  // Bit mask of USER16 field.
	EVSYS_NONSECUSER_USER16     = 0x10000  // Bit USER16.
	EVSYS_NONSECUSER_USER17_Pos = 0x11     // Position of USER17 field.
	EVSYS_NONSECUSER_USER17_Msk = 0x20000  // Bit mask of USER17 field.
	EVSYS_NONSECUSER_USER17     = 0x20000  // Bit USER17.
	EVSYS_NONSECUSER_USER18_Pos = 0x12     // Position of USER18 field.
	EVSYS_NONSECUSER_USER18_Msk = 0x40000  // Bit mask of USER18 field.
	EVSYS_NONSECUSER_USER18     = 0x40000  // Bit USER18.
	EVSYS_NONSECUSER_USER19_Pos = 0x13     // Position of USER19 field.
	EVSYS_NONSECUSER_USER19_Msk = 0x80000  // Bit mask of USER19 field.
	EVSYS_NONSECUSER_USER19     = 0x80000  // Bit USER19.
	EVSYS_NONSECUSER_USER20_Pos = 0x14     // Position of USER20 field.
	EVSYS_NONSECUSER_USER20_Msk = 0x100000 // Bit mask of USER20 field.
	EVSYS_NONSECUSER_USER20     = 0x100000 // Bit USER20.
	EVSYS_NONSECUSER_USER21_Pos = 0x15     // Position of USER21 field.
	EVSYS_NONSECUSER_USER21_Msk = 0x200000 // Bit mask of USER21 field.
	EVSYS_NONSECUSER_USER21     = 0x200000 // Bit USER21.
	EVSYS_NONSECUSER_USER22_Pos = 0x16     // Position of USER22 field.
	EVSYS_NONSECUSER_USER22_Msk = 0x400000 // Bit mask of USER22 field.
	EVSYS_NONSECUSER_USER22     = 0x400000 // Bit USER22.

	// NSCHKUSER: Non-Secure Users Check
	EVSYS_NSCHKUSER_USER0_Pos  = 0x0      // Position of USER0 field.
	EVSYS_NSCHKUSER_USER0_Msk  = 0x1      // Bit mask of USER0 field.
	EVSYS_NSCHKUSER_USER0      = 0x1      // Bit USER0.
	EVSYS_NSCHKUSER_USER1_Pos  = 0x1      // Position of USER1 field.
	EVSYS_NSCHKUSER_USER1_Msk  = 0x2      // Bit mask of USER1 field.
	EVSYS_NSCHKUSER_USER1      = 0x2      // Bit USER1.
	EVSYS_NSCHKUSER_USER2_Pos  = 0x2      // Position of USER2 field.
	EVSYS_NSCHKUSER_USER2_Msk  = 0x4      // Bit mask of USER2 field.
	EVSYS_NSCHKUSER_USER2      = 0x4      // Bit USER2.
	EVSYS_NSCHKUSER_USER3_Pos  = 0x3      // Position of USER3 field.
	EVSYS_NSCHKUSER_USER3_Msk  = 0x8      // Bit mask of USER3 field.
	EVSYS_NSCHKUSER_USER3      = 0x8      // Bit USER3.
	EVSYS_NSCHKUSER_USER4_Pos  = 0x4      // Position of USER4 field.
	EVSYS_NSCHKUSER_USER4_Msk  = 0x10     // Bit mask of USER4 field.
	EVSYS_NSCHKUSER_USER4      = 0x10     // Bit USER4.
	EVSYS_NSCHKUSER_USER5_Pos  = 0x5      // Position of USER5 field.
	EVSYS_NSCHKUSER_USER5_Msk  = 0x20     // Bit mask of USER5 field.
	EVSYS_NSCHKUSER_USER5      = 0x20     // Bit USER5.
	EVSYS_NSCHKUSER_USER6_Pos  = 0x6      // Position of USER6 field.
	EVSYS_NSCHKUSER_USER6_Msk  = 0x40     // Bit mask of USER6 field.
	EVSYS_NSCHKUSER_USER6      = 0x40     // Bit USER6.
	EVSYS_NSCHKUSER_USER7_Pos  = 0x7      // Position of USER7 field.
	EVSYS_NSCHKUSER_USER7_Msk  = 0x80     // Bit mask of USER7 field.
	EVSYS_NSCHKUSER_USER7      = 0x80     // Bit USER7.
	EVSYS_NSCHKUSER_USER8_Pos  = 0x8      // Position of USER8 field.
	EVSYS_NSCHKUSER_USER8_Msk  = 0x100    // Bit mask of USER8 field.
	EVSYS_NSCHKUSER_USER8      = 0x100    // Bit USER8.
	EVSYS_NSCHKUSER_USER9_Pos  = 0x9      // Position of USER9 field.
	EVSYS_NSCHKUSER_USER9_Msk  = 0x200    // Bit mask of USER9 field.
	EVSYS_NSCHKUSER_USER9      = 0x200    // Bit USER9.
	EVSYS_NSCHKUSER_USER10_Pos = 0xa      // Position of USER10 field.
	EVSYS_NSCHKUSER_USER10_Msk = 0x400    // Bit mask of USER10 field.
	EVSYS_NSCHKUSER_USER10     = 0x400    // Bit USER10.
	EVSYS_NSCHKUSER_USER11_Pos = 0xb      // Position of USER11 field.
	EVSYS_NSCHKUSER_USER11_Msk = 0x800    // Bit mask of USER11 field.
	EVSYS_NSCHKUSER_USER11     = 0x800    // Bit USER11.
	EVSYS_NSCHKUSER_USER12_Pos = 0xc      // Position of USER12 field.
	EVSYS_NSCHKUSER_USER12_Msk = 0x1000   // Bit mask of USER12 field.
	EVSYS_NSCHKUSER_USER12     = 0x1000   // Bit USER12.
	EVSYS_NSCHKUSER_USER13_Pos = 0xd      // Position of USER13 field.
	EVSYS_NSCHKUSER_USER13_Msk = 0x2000   // Bit mask of USER13 field.
	EVSYS_NSCHKUSER_USER13     = 0x2000   // Bit USER13.
	EVSYS_NSCHKUSER_USER14_Pos = 0xe      // Position of USER14 field.
	EVSYS_NSCHKUSER_USER14_Msk = 0x4000   // Bit mask of USER14 field.
	EVSYS_NSCHKUSER_USER14     = 0x4000   // Bit USER14.
	EVSYS_NSCHKUSER_USER15_Pos = 0xf      // Position of USER15 field.
	EVSYS_NSCHKUSER_USER15_Msk = 0x8000   // Bit mask of USER15 field.
	EVSYS_NSCHKUSER_USER15     = 0x8000   // Bit USER15.
	EVSYS_NSCHKUSER_USER16_Pos = 0x10     // Position of USER16 field.
	EVSYS_NSCHKUSER_USER16_Msk = 0x10000  // Bit mask of USER16 field.
	EVSYS_NSCHKUSER_USER16     = 0x10000  // Bit USER16.
	EVSYS_NSCHKUSER_USER17_Pos = 0x11     // Position of USER17 field.
	EVSYS_NSCHKUSER_USER17_Msk = 0x20000  // Bit mask of USER17 field.
	EVSYS_NSCHKUSER_USER17     = 0x20000  // Bit USER17.
	EVSYS_NSCHKUSER_USER18_Pos = 0x12     // Position of USER18 field.
	EVSYS_NSCHKUSER_USER18_Msk = 0x40000  // Bit mask of USER18 field.
	EVSYS_NSCHKUSER_USER18     = 0x40000  // Bit USER18.
	EVSYS_NSCHKUSER_USER19_Pos = 0x13     // Position of USER19 field.
	EVSYS_NSCHKUSER_USER19_Msk = 0x80000  // Bit mask of USER19 field.
	EVSYS_NSCHKUSER_USER19     = 0x80000  // Bit USER19.
	EVSYS_NSCHKUSER_USER20_Pos = 0x14     // Position of USER20 field.
	EVSYS_NSCHKUSER_USER20_Msk = 0x100000 // Bit mask of USER20 field.
	EVSYS_NSCHKUSER_USER20     = 0x100000 // Bit USER20.
	EVSYS_NSCHKUSER_USER21_Pos = 0x15     // Position of USER21 field.
	EVSYS_NSCHKUSER_USER21_Msk = 0x200000 // Bit mask of USER21 field.
	EVSYS_NSCHKUSER_USER21     = 0x200000 // Bit USER21.
	EVSYS_NSCHKUSER_USER22_Pos = 0x16     // Position of USER22 field.
	EVSYS_NSCHKUSER_USER22_Msk = 0x400000 // Bit mask of USER22 field.
	EVSYS_NSCHKUSER_USER22     = 0x400000 // Bit USER22.
)

// Bitfields for FREQM: Frequency Meter
const (
	// CTRLA: Control A Register
	FREQM_CTRLA_SWRST_Pos  = 0x0 // Position of SWRST field.
	FREQM_CTRLA_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	FREQM_CTRLA_SWRST      = 0x1 // Bit SWRST.
	FREQM_CTRLA_ENABLE_Pos = 0x1 // Position of ENABLE field.
	FREQM_CTRLA_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	FREQM_CTRLA_ENABLE     = 0x2 // Bit ENABLE.

	// CTRLB: Control B Register
	FREQM_CTRLB_START_Pos = 0x0 // Position of START field.
	FREQM_CTRLB_START_Msk = 0x1 // Bit mask of START field.
	FREQM_CTRLB_START     = 0x1 // Bit START.

	// CFGA: Config A register
	FREQM_CFGA_REFNUM_Pos = 0x0    // Position of REFNUM field.
	FREQM_CFGA_REFNUM_Msk = 0xff   // Bit mask of REFNUM field.
	FREQM_CFGA_DIVREF_Pos = 0xf    // Position of DIVREF field.
	FREQM_CFGA_DIVREF_Msk = 0x8000 // Bit mask of DIVREF field.
	FREQM_CFGA_DIVREF     = 0x8000 // Bit DIVREF.

	// INTENCLR: Interrupt Enable Clear Register
	FREQM_INTENCLR_DONE_Pos = 0x0 // Position of DONE field.
	FREQM_INTENCLR_DONE_Msk = 0x1 // Bit mask of DONE field.
	FREQM_INTENCLR_DONE     = 0x1 // Bit DONE.

	// INTENSET: Interrupt Enable Set Register
	FREQM_INTENSET_DONE_Pos = 0x0 // Position of DONE field.
	FREQM_INTENSET_DONE_Msk = 0x1 // Bit mask of DONE field.
	FREQM_INTENSET_DONE     = 0x1 // Bit DONE.

	// INTFLAG: Interrupt Flag Register
	FREQM_INTFLAG_DONE_Pos = 0x0 // Position of DONE field.
	FREQM_INTFLAG_DONE_Msk = 0x1 // Bit mask of DONE field.
	FREQM_INTFLAG_DONE     = 0x1 // Bit DONE.

	// STATUS: Status Register
	FREQM_STATUS_BUSY_Pos = 0x0 // Position of BUSY field.
	FREQM_STATUS_BUSY_Msk = 0x1 // Bit mask of BUSY field.
	FREQM_STATUS_BUSY     = 0x1 // Bit BUSY.
	FREQM_STATUS_OVF_Pos  = 0x1 // Position of OVF field.
	FREQM_STATUS_OVF_Msk  = 0x2 // Bit mask of OVF field.
	FREQM_STATUS_OVF      = 0x2 // Bit OVF.

	// SYNCBUSY: Synchronization Busy Register
	FREQM_SYNCBUSY_SWRST_Pos  = 0x0 // Position of SWRST field.
	FREQM_SYNCBUSY_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	FREQM_SYNCBUSY_SWRST      = 0x1 // Bit SWRST.
	FREQM_SYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	FREQM_SYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	FREQM_SYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.

	// VALUE: Count Value Register
	FREQM_VALUE_VALUE_Pos = 0x0      // Position of VALUE field.
	FREQM_VALUE_VALUE_Msk = 0xffffff // Bit mask of VALUE field.
)

// Bitfields for GCLK: Generic Clock Generator
const (
	// CTRLA: Control
	GCLK_CTRLA_SWRST_Pos = 0x0 // Position of SWRST field.
	GCLK_CTRLA_SWRST_Msk = 0x1 // Bit mask of SWRST field.
	GCLK_CTRLA_SWRST     = 0x1 // Bit SWRST.

	// SYNCBUSY: Synchronization Busy
	GCLK_SYNCBUSY_SWRST_Pos    = 0x0  // Position of SWRST field.
	GCLK_SYNCBUSY_SWRST_Msk    = 0x1  // Bit mask of SWRST field.
	GCLK_SYNCBUSY_SWRST        = 0x1  // Bit SWRST.
	GCLK_SYNCBUSY_GENCTRL0_Pos = 0x2  // Position of GENCTRL0 field.
	GCLK_SYNCBUSY_GENCTRL0_Msk = 0x4  // Bit mask of GENCTRL0 field.
	GCLK_SYNCBUSY_GENCTRL0     = 0x4  // Bit GENCTRL0.
	GCLK_SYNCBUSY_GENCTRL1_Pos = 0x3  // Position of GENCTRL1 field.
	GCLK_SYNCBUSY_GENCTRL1_Msk = 0x8  // Bit mask of GENCTRL1 field.
	GCLK_SYNCBUSY_GENCTRL1     = 0x8  // Bit GENCTRL1.
	GCLK_SYNCBUSY_GENCTRL2_Pos = 0x4  // Position of GENCTRL2 field.
	GCLK_SYNCBUSY_GENCTRL2_Msk = 0x10 // Bit mask of GENCTRL2 field.
	GCLK_SYNCBUSY_GENCTRL2     = 0x10 // Bit GENCTRL2.
	GCLK_SYNCBUSY_GENCTRL3_Pos = 0x5  // Position of GENCTRL3 field.
	GCLK_SYNCBUSY_GENCTRL3_Msk = 0x20 // Bit mask of GENCTRL3 field.
	GCLK_SYNCBUSY_GENCTRL3     = 0x20 // Bit GENCTRL3.
	GCLK_SYNCBUSY_GENCTRL4_Pos = 0x6  // Position of GENCTRL4 field.
	GCLK_SYNCBUSY_GENCTRL4_Msk = 0x40 // Bit mask of GENCTRL4 field.
	GCLK_SYNCBUSY_GENCTRL4     = 0x40 // Bit GENCTRL4.

	// GENCTRL: Generic Clock Generator Control
	GCLK_GENCTRL_SRC_Pos       = 0x0        // Position of SRC field.
	GCLK_GENCTRL_SRC_Msk       = 0x7        // Bit mask of SRC field.
	GCLK_GENCTRL_SRC_XOSC      = 0x0        // XOSC oscillator output
	GCLK_GENCTRL_SRC_GCLKIN    = 0x1        // Generator input pad
	GCLK_GENCTRL_SRC_GCLKGEN1  = 0x2        // Generic clock generator 1 output
	GCLK_GENCTRL_SRC_OSCULP32K = 0x3        // OSCULP32K oscillator output
	GCLK_GENCTRL_SRC_XOSC32K   = 0x4        // XOSC32K oscillator output
	GCLK_GENCTRL_SRC_OSC16M    = 0x5        // OSC16M oscillator output
	GCLK_GENCTRL_SRC_DFLLULP   = 0x6        // DFLLULP output
	GCLK_GENCTRL_SRC_FDPLL96M  = 0x7        // FDPLL output
	GCLK_GENCTRL_GENEN_Pos     = 0x8        // Position of GENEN field.
	GCLK_GENCTRL_GENEN_Msk     = 0x100      // Bit mask of GENEN field.
	GCLK_GENCTRL_GENEN         = 0x100      // Bit GENEN.
	GCLK_GENCTRL_IDC_Pos       = 0x9        // Position of IDC field.
	GCLK_GENCTRL_IDC_Msk       = 0x200      // Bit mask of IDC field.
	GCLK_GENCTRL_IDC           = 0x200      // Bit IDC.
	GCLK_GENCTRL_OOV_Pos       = 0xa        // Position of OOV field.
	GCLK_GENCTRL_OOV_Msk       = 0x400      // Bit mask of OOV field.
	GCLK_GENCTRL_OOV           = 0x400      // Bit OOV.
	GCLK_GENCTRL_OE_Pos        = 0xb        // Position of OE field.
	GCLK_GENCTRL_OE_Msk        = 0x800      // Bit mask of OE field.
	GCLK_GENCTRL_OE            = 0x800      // Bit OE.
	GCLK_GENCTRL_DIVSEL_Pos    = 0xc        // Position of DIVSEL field.
	GCLK_GENCTRL_DIVSEL_Msk    = 0x1000     // Bit mask of DIVSEL field.
	GCLK_GENCTRL_DIVSEL        = 0x1000     // Bit DIVSEL.
	GCLK_GENCTRL_RUNSTDBY_Pos  = 0xd        // Position of RUNSTDBY field.
	GCLK_GENCTRL_RUNSTDBY_Msk  = 0x2000     // Bit mask of RUNSTDBY field.
	GCLK_GENCTRL_RUNSTDBY      = 0x2000     // Bit RUNSTDBY.
	GCLK_GENCTRL_DIV_Pos       = 0x10       // Position of DIV field.
	GCLK_GENCTRL_DIV_Msk       = 0xffff0000 // Bit mask of DIV field.

	// PCHCTRL: Peripheral Clock Control
	GCLK_PCHCTRL_GEN_Pos     = 0x0  // Position of GEN field.
	GCLK_PCHCTRL_GEN_Msk     = 0x7  // Bit mask of GEN field.
	GCLK_PCHCTRL_GEN_GCLK0   = 0x0  // Generic clock generator 0
	GCLK_PCHCTRL_GEN_GCLK1   = 0x1  // Generic clock generator 1
	GCLK_PCHCTRL_GEN_GCLK2   = 0x2  // Generic clock generator 2
	GCLK_PCHCTRL_GEN_GCLK3   = 0x3  // Generic clock generator 3
	GCLK_PCHCTRL_GEN_GCLK4   = 0x4  // Generic clock generator 4
	GCLK_PCHCTRL_CHEN_Pos    = 0x6  // Position of CHEN field.
	GCLK_PCHCTRL_CHEN_Msk    = 0x40 // Bit mask of CHEN field.
	GCLK_PCHCTRL_CHEN        = 0x40 // Bit CHEN.
	GCLK_PCHCTRL_WRTLOCK_Pos = 0x7  // Position of WRTLOCK field.
	GCLK_PCHCTRL_WRTLOCK_Msk = 0x80 // Bit mask of WRTLOCK field.
	GCLK_PCHCTRL_WRTLOCK     = 0x80 // Bit WRTLOCK.
)

// Bitfields for IDAU: Implementation Defined Attribution Unit
const (
	// SECCTRL: SECCTRL
	IDAU_SECCTRL_RXN_Pos = 0x2 // Position of RXN field.
	IDAU_SECCTRL_RXN_Msk = 0x4 // Bit mask of RXN field.
	IDAU_SECCTRL_RXN     = 0x4 // Bit RXN.

	// SCFGB: SCFGB
	IDAU_SCFGB_BS_Pos       = 0x0      // Position of BS field.
	IDAU_SCFGB_BS_Msk       = 0xff     // Bit mask of BS field.
	IDAU_SCFGB_BNSC_Pos     = 0x8      // Position of BNSC field.
	IDAU_SCFGB_BNSC_Msk     = 0x3f00   // Bit mask of BNSC field.
	IDAU_SCFGB_BOOTPROT_Pos = 0x10     // Position of BOOTPROT field.
	IDAU_SCFGB_BOOTPROT_Msk = 0xff0000 // Bit mask of BOOTPROT field.

	// SCFGA: SCFGA
	IDAU_SCFGA_AS_Pos   = 0x0     // Position of AS field.
	IDAU_SCFGA_AS_Msk   = 0xff    // Bit mask of AS field.
	IDAU_SCFGA_ANSC_Pos = 0x8     // Position of ANSC field.
	IDAU_SCFGA_ANSC_Msk = 0x3f00  // Bit mask of ANSC field.
	IDAU_SCFGA_DS_Pos   = 0x10    // Position of DS field.
	IDAU_SCFGA_DS_Msk   = 0xf0000 // Bit mask of DS field.

	// SCFGR: SCFGR
	IDAU_SCFGR_RS_Pos = 0x0  // Position of RS field.
	IDAU_SCFGR_RS_Msk = 0x7f // Bit mask of RS field.
)

// Bitfields for MCLK: Main Clock
const (
	// CTRLA: Control
	MCLK_CTRLA_CKSEL_Pos = 0x2 // Position of CKSEL field.
	MCLK_CTRLA_CKSEL_Msk = 0x4 // Bit mask of CKSEL field.
	MCLK_CTRLA_CKSEL     = 0x4 // Bit CKSEL.

	// INTENCLR: Interrupt Enable Clear
	MCLK_INTENCLR_CKRDY_Pos = 0x0 // Position of CKRDY field.
	MCLK_INTENCLR_CKRDY_Msk = 0x1 // Bit mask of CKRDY field.
	MCLK_INTENCLR_CKRDY     = 0x1 // Bit CKRDY.

	// INTENSET: Interrupt Enable Set
	MCLK_INTENSET_CKRDY_Pos = 0x0 // Position of CKRDY field.
	MCLK_INTENSET_CKRDY_Msk = 0x1 // Bit mask of CKRDY field.
	MCLK_INTENSET_CKRDY     = 0x1 // Bit CKRDY.

	// INTFLAG: Interrupt Flag Status and Clear
	MCLK_INTFLAG_CKRDY_Pos = 0x0 // Position of CKRDY field.
	MCLK_INTFLAG_CKRDY_Msk = 0x1 // Bit mask of CKRDY field.
	MCLK_INTFLAG_CKRDY     = 0x1 // Bit CKRDY.

	// CPUDIV: CPU Clock Division
	MCLK_CPUDIV_CPUDIV_Pos    = 0x0  // Position of CPUDIV field.
	MCLK_CPUDIV_CPUDIV_Msk    = 0xff // Bit mask of CPUDIV field.
	MCLK_CPUDIV_CPUDIV_DIV1   = 0x1  // Divide by 1
	MCLK_CPUDIV_CPUDIV_DIV2   = 0x2  // Divide by 2
	MCLK_CPUDIV_CPUDIV_DIV4   = 0x4  // Divide by 4
	MCLK_CPUDIV_CPUDIV_DIV8   = 0x8  // Divide by 8
	MCLK_CPUDIV_CPUDIV_DIV16  = 0x10 // Divide by 16
	MCLK_CPUDIV_CPUDIV_DIV32  = 0x20 // Divide by 32
	MCLK_CPUDIV_CPUDIV_DIV64  = 0x40 // Divide by 64
	MCLK_CPUDIV_CPUDIV_DIV128 = 0x80 // Divide by 128

	// AHBMASK: AHB Mask
	MCLK_AHBMASK_HPB0__Pos    = 0x0    // Position of HPB0_ field.
	MCLK_AHBMASK_HPB0__Msk    = 0x1    // Bit mask of HPB0_ field.
	MCLK_AHBMASK_HPB0_        = 0x1    // Bit HPB0_.
	MCLK_AHBMASK_HPB1__Pos    = 0x1    // Position of HPB1_ field.
	MCLK_AHBMASK_HPB1__Msk    = 0x2    // Bit mask of HPB1_ field.
	MCLK_AHBMASK_HPB1_        = 0x2    // Bit HPB1_.
	MCLK_AHBMASK_HPB2__Pos    = 0x2    // Position of HPB2_ field.
	MCLK_AHBMASK_HPB2__Msk    = 0x4    // Bit mask of HPB2_ field.
	MCLK_AHBMASK_HPB2_        = 0x4    // Bit HPB2_.
	MCLK_AHBMASK_DMAC__Pos    = 0x3    // Position of DMAC_ field.
	MCLK_AHBMASK_DMAC__Msk    = 0x8    // Bit mask of DMAC_ field.
	MCLK_AHBMASK_DMAC_        = 0x8    // Bit DMAC_.
	MCLK_AHBMASK_DSU__Pos     = 0x4    // Position of DSU_ field.
	MCLK_AHBMASK_DSU__Msk     = 0x10   // Bit mask of DSU_ field.
	MCLK_AHBMASK_DSU_         = 0x10   // Bit DSU_.
	MCLK_AHBMASK_PAC__Pos     = 0x6    // Position of PAC_ field.
	MCLK_AHBMASK_PAC__Msk     = 0x40   // Bit mask of PAC_ field.
	MCLK_AHBMASK_PAC_         = 0x40   // Bit PAC_.
	MCLK_AHBMASK_NVMCTRL__Pos = 0x7    // Position of NVMCTRL_ field.
	MCLK_AHBMASK_NVMCTRL__Msk = 0x80   // Bit mask of NVMCTRL_ field.
	MCLK_AHBMASK_NVMCTRL_     = 0x80   // Bit NVMCTRL_.
	MCLK_AHBMASK_TRAM__Pos    = 0xc    // Position of TRAM_ field.
	MCLK_AHBMASK_TRAM__Msk    = 0x1000 // Bit mask of TRAM_ field.
	MCLK_AHBMASK_TRAM_        = 0x1000 // Bit TRAM_.

	// APBAMASK: APBA Mask
	MCLK_APBAMASK_PAC__Pos        = 0x0    // Position of PAC_ field.
	MCLK_APBAMASK_PAC__Msk        = 0x1    // Bit mask of PAC_ field.
	MCLK_APBAMASK_PAC_            = 0x1    // Bit PAC_.
	MCLK_APBAMASK_PM__Pos         = 0x1    // Position of PM_ field.
	MCLK_APBAMASK_PM__Msk         = 0x2    // Bit mask of PM_ field.
	MCLK_APBAMASK_PM_             = 0x2    // Bit PM_.
	MCLK_APBAMASK_MCLK__Pos       = 0x2    // Position of MCLK_ field.
	MCLK_APBAMASK_MCLK__Msk       = 0x4    // Bit mask of MCLK_ field.
	MCLK_APBAMASK_MCLK_           = 0x4    // Bit MCLK_.
	MCLK_APBAMASK_RSTC__Pos       = 0x3    // Position of RSTC_ field.
	MCLK_APBAMASK_RSTC__Msk       = 0x8    // Bit mask of RSTC_ field.
	MCLK_APBAMASK_RSTC_           = 0x8    // Bit RSTC_.
	MCLK_APBAMASK_OSCCTRL__Pos    = 0x4    // Position of OSCCTRL_ field.
	MCLK_APBAMASK_OSCCTRL__Msk    = 0x10   // Bit mask of OSCCTRL_ field.
	MCLK_APBAMASK_OSCCTRL_        = 0x10   // Bit OSCCTRL_.
	MCLK_APBAMASK_OSC32KCTRL__Pos = 0x5    // Position of OSC32KCTRL_ field.
	MCLK_APBAMASK_OSC32KCTRL__Msk = 0x20   // Bit mask of OSC32KCTRL_ field.
	MCLK_APBAMASK_OSC32KCTRL_     = 0x20   // Bit OSC32KCTRL_.
	MCLK_APBAMASK_SUPC__Pos       = 0x6    // Position of SUPC_ field.
	MCLK_APBAMASK_SUPC__Msk       = 0x40   // Bit mask of SUPC_ field.
	MCLK_APBAMASK_SUPC_           = 0x40   // Bit SUPC_.
	MCLK_APBAMASK_GCLK__Pos       = 0x7    // Position of GCLK_ field.
	MCLK_APBAMASK_GCLK__Msk       = 0x80   // Bit mask of GCLK_ field.
	MCLK_APBAMASK_GCLK_           = 0x80   // Bit GCLK_.
	MCLK_APBAMASK_WDT__Pos        = 0x8    // Position of WDT_ field.
	MCLK_APBAMASK_WDT__Msk        = 0x100  // Bit mask of WDT_ field.
	MCLK_APBAMASK_WDT_            = 0x100  // Bit WDT_.
	MCLK_APBAMASK_RTC__Pos        = 0x9    // Position of RTC_ field.
	MCLK_APBAMASK_RTC__Msk        = 0x200  // Bit mask of RTC_ field.
	MCLK_APBAMASK_RTC_            = 0x200  // Bit RTC_.
	MCLK_APBAMASK_EIC__Pos        = 0xa    // Position of EIC_ field.
	MCLK_APBAMASK_EIC__Msk        = 0x400  // Bit mask of EIC_ field.
	MCLK_APBAMASK_EIC_            = 0x400  // Bit EIC_.
	MCLK_APBAMASK_FREQM__Pos      = 0xb    // Position of FREQM_ field.
	MCLK_APBAMASK_FREQM__Msk      = 0x800  // Bit mask of FREQM_ field.
	MCLK_APBAMASK_FREQM_          = 0x800  // Bit FREQM_.
	MCLK_APBAMASK_PORT__Pos       = 0xc    // Position of PORT_ field.
	MCLK_APBAMASK_PORT__Msk       = 0x1000 // Bit mask of PORT_ field.
	MCLK_APBAMASK_PORT_           = 0x1000 // Bit PORT_.
	MCLK_APBAMASK_AC__Pos         = 0xd    // Position of AC_ field.
	MCLK_APBAMASK_AC__Msk         = 0x2000 // Bit mask of AC_ field.
	MCLK_APBAMASK_AC_             = 0x2000 // Bit AC_.

	// APBBMASK: APBB Mask
	MCLK_APBBMASK_IDAU__Pos    = 0x0 // Position of IDAU_ field.
	MCLK_APBBMASK_IDAU__Msk    = 0x1 // Bit mask of IDAU_ field.
	MCLK_APBBMASK_IDAU_        = 0x1 // Bit IDAU_.
	MCLK_APBBMASK_DSU__Pos     = 0x1 // Position of DSU_ field.
	MCLK_APBBMASK_DSU__Msk     = 0x2 // Bit mask of DSU_ field.
	MCLK_APBBMASK_DSU_         = 0x2 // Bit DSU_.
	MCLK_APBBMASK_NVMCTRL__Pos = 0x2 // Position of NVMCTRL_ field.
	MCLK_APBBMASK_NVMCTRL__Msk = 0x4 // Bit mask of NVMCTRL_ field.
	MCLK_APBBMASK_NVMCTRL_     = 0x4 // Bit NVMCTRL_.

	// APBCMASK: APBC Mask
	MCLK_APBCMASK_EVSYS__Pos   = 0x0    // Position of EVSYS_ field.
	MCLK_APBCMASK_EVSYS__Msk   = 0x1    // Bit mask of EVSYS_ field.
	MCLK_APBCMASK_EVSYS_       = 0x1    // Bit EVSYS_.
	MCLK_APBCMASK_SERCOM0__Pos = 0x1    // Position of SERCOM0_ field.
	MCLK_APBCMASK_SERCOM0__Msk = 0x2    // Bit mask of SERCOM0_ field.
	MCLK_APBCMASK_SERCOM0_     = 0x2    // Bit SERCOM0_.
	MCLK_APBCMASK_SERCOM1__Pos = 0x2    // Position of SERCOM1_ field.
	MCLK_APBCMASK_SERCOM1__Msk = 0x4    // Bit mask of SERCOM1_ field.
	MCLK_APBCMASK_SERCOM1_     = 0x4    // Bit SERCOM1_.
	MCLK_APBCMASK_SERCOM2__Pos = 0x3    // Position of SERCOM2_ field.
	MCLK_APBCMASK_SERCOM2__Msk = 0x8    // Bit mask of SERCOM2_ field.
	MCLK_APBCMASK_SERCOM2_     = 0x8    // Bit SERCOM2_.
	MCLK_APBCMASK_TC0__Pos     = 0x4    // Position of TC0_ field.
	MCLK_APBCMASK_TC0__Msk     = 0x10   // Bit mask of TC0_ field.
	MCLK_APBCMASK_TC0_         = 0x10   // Bit TC0_.
	MCLK_APBCMASK_TC1__Pos     = 0x5    // Position of TC1_ field.
	MCLK_APBCMASK_TC1__Msk     = 0x20   // Bit mask of TC1_ field.
	MCLK_APBCMASK_TC1_         = 0x20   // Bit TC1_.
	MCLK_APBCMASK_TC2__Pos     = 0x6    // Position of TC2_ field.
	MCLK_APBCMASK_TC2__Msk     = 0x40   // Bit mask of TC2_ field.
	MCLK_APBCMASK_TC2_         = 0x40   // Bit TC2_.
	MCLK_APBCMASK_ADC__Pos     = 0x7    // Position of ADC_ field.
	MCLK_APBCMASK_ADC__Msk     = 0x80   // Bit mask of ADC_ field.
	MCLK_APBCMASK_ADC_         = 0x80   // Bit ADC_.
	MCLK_APBCMASK_DAC__Pos     = 0x8    // Position of DAC_ field.
	MCLK_APBCMASK_DAC__Msk     = 0x100  // Bit mask of DAC_ field.
	MCLK_APBCMASK_DAC_         = 0x100  // Bit DAC_.
	MCLK_APBCMASK_PTC__Pos     = 0x9    // Position of PTC_ field.
	MCLK_APBCMASK_PTC__Msk     = 0x200  // Bit mask of PTC_ field.
	MCLK_APBCMASK_PTC_         = 0x200  // Bit PTC_.
	MCLK_APBCMASK_TRNG__Pos    = 0xa    // Position of TRNG_ field.
	MCLK_APBCMASK_TRNG__Msk    = 0x400  // Bit mask of TRNG_ field.
	MCLK_APBCMASK_TRNG_        = 0x400  // Bit TRNG_.
	MCLK_APBCMASK_CCL__Pos     = 0xb    // Position of CCL_ field.
	MCLK_APBCMASK_CCL__Msk     = 0x800  // Bit mask of CCL_ field.
	MCLK_APBCMASK_CCL_         = 0x800  // Bit CCL_.
	MCLK_APBCMASK_OPAMP__Pos   = 0xc    // Position of OPAMP_ field.
	MCLK_APBCMASK_OPAMP__Msk   = 0x1000 // Bit mask of OPAMP_ field.
	MCLK_APBCMASK_OPAMP_       = 0x1000 // Bit OPAMP_.
)

// Bitfields for NVMCTRL: Non-Volatile Memory Controller
const (
	// CTRLA: Control A
	NVMCTRL_CTRLA_CMD_Pos    = 0x0    // Position of CMD field.
	NVMCTRL_CTRLA_CMD_Msk    = 0x7f   // Bit mask of CMD field.
	NVMCTRL_CTRLA_CMD_ER     = 0x2    // Erase Row - Erases the row addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_WP     = 0x4    // Write Page - Writes the contents of the page buffer to the page addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_SPRM   = 0x42   // Sets the power reduction mode.
	NVMCTRL_CTRLA_CMD_CPRM   = 0x43   // Clears the power reduction mode.
	NVMCTRL_CTRLA_CMD_PBC    = 0x44   // Page Buffer Clear - Clears the page buffer.
	NVMCTRL_CTRLA_CMD_INVALL = 0x46   // Invalidate all cache lines.
	NVMCTRL_CTRLA_CMD_SDAL0  = 0x4b   // Set DAL=0
	NVMCTRL_CTRLA_CMD_SDAL1  = 0x4c   // Set DAL=1
	NVMCTRL_CTRLA_CMDEX_Pos  = 0x8    // Position of CMDEX field.
	NVMCTRL_CTRLA_CMDEX_Msk  = 0xff00 // Bit mask of CMDEX field.
	NVMCTRL_CTRLA_CMDEX_KEY  = 0xa5   // Execution Key

	// CTRLB: Control B
	NVMCTRL_CTRLB_RWS_Pos                  = 0x1     // Position of RWS field.
	NVMCTRL_CTRLB_RWS_Msk                  = 0x1e    // Bit mask of RWS field.
	NVMCTRL_CTRLB_SLEEPPRM_Pos             = 0x8     // Position of SLEEPPRM field.
	NVMCTRL_CTRLB_SLEEPPRM_Msk             = 0x300   // Bit mask of SLEEPPRM field.
	NVMCTRL_CTRLB_SLEEPPRM_WAKEONACCESS    = 0x0     // NVM block enters low-power mode when entering sleep.NVM block exits low-power mode upon first access.
	NVMCTRL_CTRLB_SLEEPPRM_WAKEUPINSTANT   = 0x1     // NVM block enters low-power mode when entering sleep.NVM block exits low-power mode when exiting sleep.
	NVMCTRL_CTRLB_SLEEPPRM_DISABLED        = 0x3     // Auto power reduction disabled.
	NVMCTRL_CTRLB_FWUP_Pos                 = 0xb     // Position of FWUP field.
	NVMCTRL_CTRLB_FWUP_Msk                 = 0x800   // Bit mask of FWUP field.
	NVMCTRL_CTRLB_FWUP                     = 0x800   // Bit FWUP.
	NVMCTRL_CTRLB_READMODE_Pos             = 0x10    // Position of READMODE field.
	NVMCTRL_CTRLB_READMODE_Msk             = 0x30000 // Bit mask of READMODE field.
	NVMCTRL_CTRLB_READMODE_NO_MISS_PENALTY = 0x0     // The NVM Controller (cache system) does not insert wait states on a cache miss. Gives the best system performance.
	NVMCTRL_CTRLB_READMODE_LOW_POWER       = 0x1     // Reduces power consumption of the cache system, but inserts a wait state each time there is a cache miss. This mode may not be relevant if CPU performance is required, as the application will be stalled and may lead to increase run time.
	NVMCTRL_CTRLB_READMODE_DETERMINISTIC   = 0x2     // The cache system ensures that a cache hit or miss takes the same amount of time, determined by the number of programmed flash wait states. This mode can be used for real-time applications that require deterministic execution timings.
	NVMCTRL_CTRLB_CACHEDIS_Pos             = 0x12    // Position of CACHEDIS field.
	NVMCTRL_CTRLB_CACHEDIS_Msk             = 0x40000 // Bit mask of CACHEDIS field.
	NVMCTRL_CTRLB_CACHEDIS                 = 0x40000 // Bit CACHEDIS.
	NVMCTRL_CTRLB_QWEN_Pos                 = 0x13    // Position of QWEN field.
	NVMCTRL_CTRLB_QWEN_Msk                 = 0x80000 // Bit mask of QWEN field.
	NVMCTRL_CTRLB_QWEN                     = 0x80000 // Bit QWEN.

	// CTRLC: Control C
	NVMCTRL_CTRLC_MANW_Pos = 0x0 // Position of MANW field.
	NVMCTRL_CTRLC_MANW_Msk = 0x1 // Bit mask of MANW field.
	NVMCTRL_CTRLC_MANW     = 0x1 // Bit MANW.

	// EVCTRL: Event Control
	NVMCTRL_EVCTRL_AUTOWEI_Pos  = 0x0 // Position of AUTOWEI field.
	NVMCTRL_EVCTRL_AUTOWEI_Msk  = 0x1 // Bit mask of AUTOWEI field.
	NVMCTRL_EVCTRL_AUTOWEI      = 0x1 // Bit AUTOWEI.
	NVMCTRL_EVCTRL_AUTOWINV_Pos = 0x1 // Position of AUTOWINV field.
	NVMCTRL_EVCTRL_AUTOWINV_Msk = 0x2 // Bit mask of AUTOWINV field.
	NVMCTRL_EVCTRL_AUTOWINV     = 0x2 // Bit AUTOWINV.

	// INTENCLR: Interrupt Enable Clear
	NVMCTRL_INTENCLR_DONE_Pos  = 0x0  // Position of DONE field.
	NVMCTRL_INTENCLR_DONE_Msk  = 0x1  // Bit mask of DONE field.
	NVMCTRL_INTENCLR_DONE      = 0x1  // Bit DONE.
	NVMCTRL_INTENCLR_PROGE_Pos = 0x1  // Position of PROGE field.
	NVMCTRL_INTENCLR_PROGE_Msk = 0x2  // Bit mask of PROGE field.
	NVMCTRL_INTENCLR_PROGE     = 0x2  // Bit PROGE.
	NVMCTRL_INTENCLR_LOCKE_Pos = 0x2  // Position of LOCKE field.
	NVMCTRL_INTENCLR_LOCKE_Msk = 0x4  // Bit mask of LOCKE field.
	NVMCTRL_INTENCLR_LOCKE     = 0x4  // Bit LOCKE.
	NVMCTRL_INTENCLR_NVME_Pos  = 0x3  // Position of NVME field.
	NVMCTRL_INTENCLR_NVME_Msk  = 0x8  // Bit mask of NVME field.
	NVMCTRL_INTENCLR_NVME      = 0x8  // Bit NVME.
	NVMCTRL_INTENCLR_KEYE_Pos  = 0x4  // Position of KEYE field.
	NVMCTRL_INTENCLR_KEYE_Msk  = 0x10 // Bit mask of KEYE field.
	NVMCTRL_INTENCLR_KEYE      = 0x10 // Bit KEYE.
	NVMCTRL_INTENCLR_NSCHK_Pos = 0x5  // Position of NSCHK field.
	NVMCTRL_INTENCLR_NSCHK_Msk = 0x20 // Bit mask of NSCHK field.
	NVMCTRL_INTENCLR_NSCHK     = 0x20 // Bit NSCHK.

	// INTENSET: Interrupt Enable Set
	NVMCTRL_INTENSET_DONE_Pos  = 0x0  // Position of DONE field.
	NVMCTRL_INTENSET_DONE_Msk  = 0x1  // Bit mask of DONE field.
	NVMCTRL_INTENSET_DONE      = 0x1  // Bit DONE.
	NVMCTRL_INTENSET_PROGE_Pos = 0x1  // Position of PROGE field.
	NVMCTRL_INTENSET_PROGE_Msk = 0x2  // Bit mask of PROGE field.
	NVMCTRL_INTENSET_PROGE     = 0x2  // Bit PROGE.
	NVMCTRL_INTENSET_LOCKE_Pos = 0x2  // Position of LOCKE field.
	NVMCTRL_INTENSET_LOCKE_Msk = 0x4  // Bit mask of LOCKE field.
	NVMCTRL_INTENSET_LOCKE     = 0x4  // Bit LOCKE.
	NVMCTRL_INTENSET_NVME_Pos  = 0x3  // Position of NVME field.
	NVMCTRL_INTENSET_NVME_Msk  = 0x8  // Bit mask of NVME field.
	NVMCTRL_INTENSET_NVME      = 0x8  // Bit NVME.
	NVMCTRL_INTENSET_KEYE_Pos  = 0x4  // Position of KEYE field.
	NVMCTRL_INTENSET_KEYE_Msk  = 0x10 // Bit mask of KEYE field.
	NVMCTRL_INTENSET_KEYE      = 0x10 // Bit KEYE.
	NVMCTRL_INTENSET_NSCHK_Pos = 0x5  // Position of NSCHK field.
	NVMCTRL_INTENSET_NSCHK_Msk = 0x20 // Bit mask of NSCHK field.
	NVMCTRL_INTENSET_NSCHK     = 0x20 // Bit NSCHK.

	// INTFLAG: Interrupt Flag Status and Clear
	NVMCTRL_INTFLAG_DONE_Pos  = 0x0  // Position of DONE field.
	NVMCTRL_INTFLAG_DONE_Msk  = 0x1  // Bit mask of DONE field.
	NVMCTRL_INTFLAG_DONE      = 0x1  // Bit DONE.
	NVMCTRL_INTFLAG_PROGE_Pos = 0x1  // Position of PROGE field.
	NVMCTRL_INTFLAG_PROGE_Msk = 0x2  // Bit mask of PROGE field.
	NVMCTRL_INTFLAG_PROGE     = 0x2  // Bit PROGE.
	NVMCTRL_INTFLAG_LOCKE_Pos = 0x2  // Position of LOCKE field.
	NVMCTRL_INTFLAG_LOCKE_Msk = 0x4  // Bit mask of LOCKE field.
	NVMCTRL_INTFLAG_LOCKE     = 0x4  // Bit LOCKE.
	NVMCTRL_INTFLAG_NVME_Pos  = 0x3  // Position of NVME field.
	NVMCTRL_INTFLAG_NVME_Msk  = 0x8  // Bit mask of NVME field.
	NVMCTRL_INTFLAG_NVME      = 0x8  // Bit NVME.
	NVMCTRL_INTFLAG_KEYE_Pos  = 0x4  // Position of KEYE field.
	NVMCTRL_INTFLAG_KEYE_Msk  = 0x10 // Bit mask of KEYE field.
	NVMCTRL_INTFLAG_KEYE      = 0x10 // Bit KEYE.
	NVMCTRL_INTFLAG_NSCHK_Pos = 0x5  // Position of NSCHK field.
	NVMCTRL_INTFLAG_NSCHK_Msk = 0x20 // Bit mask of NSCHK field.
	NVMCTRL_INTFLAG_NSCHK     = 0x20 // Bit NSCHK.

	// STATUS: Status
	NVMCTRL_STATUS_PRM_Pos     = 0x0  // Position of PRM field.
	NVMCTRL_STATUS_PRM_Msk     = 0x1  // Bit mask of PRM field.
	NVMCTRL_STATUS_PRM         = 0x1  // Bit PRM.
	NVMCTRL_STATUS_LOAD_Pos    = 0x1  // Position of LOAD field.
	NVMCTRL_STATUS_LOAD_Msk    = 0x2  // Bit mask of LOAD field.
	NVMCTRL_STATUS_LOAD        = 0x2  // Bit LOAD.
	NVMCTRL_STATUS_READY_Pos   = 0x2  // Position of READY field.
	NVMCTRL_STATUS_READY_Msk   = 0x4  // Bit mask of READY field.
	NVMCTRL_STATUS_READY       = 0x4  // Bit READY.
	NVMCTRL_STATUS_DALFUSE_Pos = 0x3  // Position of DALFUSE field.
	NVMCTRL_STATUS_DALFUSE_Msk = 0x18 // Bit mask of DALFUSE field.

	// ADDR: Address
	NVMCTRL_ADDR_AOFFSET_Pos     = 0x0      // Position of AOFFSET field.
	NVMCTRL_ADDR_AOFFSET_Msk     = 0xffff   // Bit mask of AOFFSET field.
	NVMCTRL_ADDR_ARRAY_Pos       = 0x16     // Position of ARRAY field.
	NVMCTRL_ADDR_ARRAY_Msk       = 0xc00000 // Bit mask of ARRAY field.
	NVMCTRL_ADDR_ARRAY_FLASH     = 0x0      // FLASH Array
	NVMCTRL_ADDR_ARRAY_DATAFLASH = 0x1      // DATA FLASH Array
	NVMCTRL_ADDR_ARRAY_AUX       = 0x2      // Auxilliary Space

	// SULCK: Secure Unlock Register
	NVMCTRL_SULCK_BS_Pos    = 0x0    // Position of BS field.
	NVMCTRL_SULCK_BS_Msk    = 0x1    // Bit mask of BS field.
	NVMCTRL_SULCK_BS        = 0x1    // Bit BS.
	NVMCTRL_SULCK_AS_Pos    = 0x1    // Position of AS field.
	NVMCTRL_SULCK_AS_Msk    = 0x2    // Bit mask of AS field.
	NVMCTRL_SULCK_AS        = 0x2    // Bit AS.
	NVMCTRL_SULCK_DS_Pos    = 0x2    // Position of DS field.
	NVMCTRL_SULCK_DS_Msk    = 0x4    // Bit mask of DS field.
	NVMCTRL_SULCK_DS        = 0x4    // Bit DS.
	NVMCTRL_SULCK_SLKEY_Pos = 0x8    // Position of SLKEY field.
	NVMCTRL_SULCK_SLKEY_Msk = 0xff00 // Bit mask of SLKEY field.
	NVMCTRL_SULCK_SLKEY_KEY = 0xa5   // Write Key

	// NSULCK: Non-Secure Unlock Register
	NVMCTRL_NSULCK_BNS_Pos    = 0x0    // Position of BNS field.
	NVMCTRL_NSULCK_BNS_Msk    = 0x1    // Bit mask of BNS field.
	NVMCTRL_NSULCK_BNS        = 0x1    // Bit BNS.
	NVMCTRL_NSULCK_ANS_Pos    = 0x1    // Position of ANS field.
	NVMCTRL_NSULCK_ANS_Msk    = 0x2    // Bit mask of ANS field.
	NVMCTRL_NSULCK_ANS        = 0x2    // Bit ANS.
	NVMCTRL_NSULCK_DNS_Pos    = 0x2    // Position of DNS field.
	NVMCTRL_NSULCK_DNS_Msk    = 0x4    // Bit mask of DNS field.
	NVMCTRL_NSULCK_DNS        = 0x4    // Bit DNS.
	NVMCTRL_NSULCK_NSLKEY_Pos = 0x8    // Position of NSLKEY field.
	NVMCTRL_NSULCK_NSLKEY_Msk = 0xff00 // Bit mask of NSLKEY field.
	NVMCTRL_NSULCK_NSLKEY_KEY = 0xa5   // Write Key

	// PARAM: NVM Parameter
	NVMCTRL_PARAM_FLASHP_Pos  = 0x0        // Position of FLASHP field.
	NVMCTRL_PARAM_FLASHP_Msk  = 0xffff     // Bit mask of FLASHP field.
	NVMCTRL_PARAM_PSZ_Pos     = 0x10       // Position of PSZ field.
	NVMCTRL_PARAM_PSZ_Msk     = 0x70000    // Bit mask of PSZ field.
	NVMCTRL_PARAM_PSZ_8       = 0x0        // 8 bytes
	NVMCTRL_PARAM_PSZ_16      = 0x1        // 16 bytes
	NVMCTRL_PARAM_PSZ_32      = 0x2        // 32 bytes
	NVMCTRL_PARAM_PSZ_64      = 0x3        // 64 bytes
	NVMCTRL_PARAM_PSZ_128     = 0x4        // 128 bytes
	NVMCTRL_PARAM_PSZ_256     = 0x5        // 256 bytes
	NVMCTRL_PARAM_PSZ_512     = 0x6        // 512 bytes
	NVMCTRL_PARAM_PSZ_1024    = 0x7        // 1024 bytes
	NVMCTRL_PARAM_DFLASHP_Pos = 0x14       // Position of DFLASHP field.
	NVMCTRL_PARAM_DFLASHP_Msk = 0xfff00000 // Bit mask of DFLASHP field.

	// DSCC: Data Scramble Configuration
	NVMCTRL_DSCC_DSCKEY_Pos = 0x0        // Position of DSCKEY field.
	NVMCTRL_DSCC_DSCKEY_Msk = 0x3fffffff // Bit mask of DSCKEY field.

	// SECCTRL: Security Control
	NVMCTRL_SECCTRL_TAMPEEN_Pos = 0x0        // Position of TAMPEEN field.
	NVMCTRL_SECCTRL_TAMPEEN_Msk = 0x1        // Bit mask of TAMPEEN field.
	NVMCTRL_SECCTRL_TAMPEEN     = 0x1        // Bit TAMPEEN.
	NVMCTRL_SECCTRL_SILACC_Pos  = 0x2        // Position of SILACC field.
	NVMCTRL_SECCTRL_SILACC_Msk  = 0x4        // Bit mask of SILACC field.
	NVMCTRL_SECCTRL_SILACC      = 0x4        // Bit SILACC.
	NVMCTRL_SECCTRL_DSCEN_Pos   = 0x3        // Position of DSCEN field.
	NVMCTRL_SECCTRL_DSCEN_Msk   = 0x8        // Bit mask of DSCEN field.
	NVMCTRL_SECCTRL_DSCEN       = 0x8        // Bit DSCEN.
	NVMCTRL_SECCTRL_DXN_Pos     = 0x6        // Position of DXN field.
	NVMCTRL_SECCTRL_DXN_Msk     = 0x40       // Bit mask of DXN field.
	NVMCTRL_SECCTRL_DXN         = 0x40       // Bit DXN.
	NVMCTRL_SECCTRL_TEROW_Pos   = 0x8        // Position of TEROW field.
	NVMCTRL_SECCTRL_TEROW_Msk   = 0x700      // Bit mask of TEROW field.
	NVMCTRL_SECCTRL_KEY_Pos     = 0x18       // Position of KEY field.
	NVMCTRL_SECCTRL_KEY_Msk     = 0xff000000 // Bit mask of KEY field.
	NVMCTRL_SECCTRL_KEY_KEY     = 0xa5       // Write Key

	// SCFGB: Secure Boot Configuration
	NVMCTRL_SCFGB_BCREN_Pos = 0x0 // Position of BCREN field.
	NVMCTRL_SCFGB_BCREN_Msk = 0x1 // Bit mask of BCREN field.
	NVMCTRL_SCFGB_BCREN     = 0x1 // Bit BCREN.
	NVMCTRL_SCFGB_BCWEN_Pos = 0x1 // Position of BCWEN field.
	NVMCTRL_SCFGB_BCWEN_Msk = 0x2 // Bit mask of BCWEN field.
	NVMCTRL_SCFGB_BCWEN     = 0x2 // Bit BCWEN.

	// SCFGAD: Secure Application and Data Configuration
	NVMCTRL_SCFGAD_URWEN_Pos = 0x0 // Position of URWEN field.
	NVMCTRL_SCFGAD_URWEN_Msk = 0x1 // Bit mask of URWEN field.
	NVMCTRL_SCFGAD_URWEN     = 0x1 // Bit URWEN.

	// NONSEC: Non-secure Write Enable
	NVMCTRL_NONSEC_WRITE_Pos = 0x0 // Position of WRITE field.
	NVMCTRL_NONSEC_WRITE_Msk = 0x1 // Bit mask of WRITE field.
	NVMCTRL_NONSEC_WRITE     = 0x1 // Bit WRITE.

	// NSCHK: Non-secure Write Reference Value
	NVMCTRL_NSCHK_WRITE_Pos = 0x0 // Position of WRITE field.
	NVMCTRL_NSCHK_WRITE_Msk = 0x1 // Bit mask of WRITE field.
	NVMCTRL_NSCHK_WRITE     = 0x1 // Bit WRITE.
)

// Bitfields for OPAMP: Operational Amplifier
const (
	// CTRLA: Control A
	OPAMP_CTRLA_SWRST_Pos  = 0x0  // Position of SWRST field.
	OPAMP_CTRLA_SWRST_Msk  = 0x1  // Bit mask of SWRST field.
	OPAMP_CTRLA_SWRST      = 0x1  // Bit SWRST.
	OPAMP_CTRLA_ENABLE_Pos = 0x1  // Position of ENABLE field.
	OPAMP_CTRLA_ENABLE_Msk = 0x2  // Bit mask of ENABLE field.
	OPAMP_CTRLA_ENABLE     = 0x2  // Bit ENABLE.
	OPAMP_CTRLA_LPMUX_Pos  = 0x7  // Position of LPMUX field.
	OPAMP_CTRLA_LPMUX_Msk  = 0x80 // Bit mask of LPMUX field.
	OPAMP_CTRLA_LPMUX      = 0x80 // Bit LPMUX.

	// STATUS: Status
	OPAMP_STATUS_READY0_Pos = 0x0 // Position of READY0 field.
	OPAMP_STATUS_READY0_Msk = 0x1 // Bit mask of READY0 field.
	OPAMP_STATUS_READY0     = 0x1 // Bit READY0.
	OPAMP_STATUS_READY1_Pos = 0x1 // Position of READY1 field.
	OPAMP_STATUS_READY1_Msk = 0x2 // Bit mask of READY1 field.
	OPAMP_STATUS_READY1     = 0x2 // Bit READY1.
	OPAMP_STATUS_READY2_Pos = 0x2 // Position of READY2 field.
	OPAMP_STATUS_READY2_Msk = 0x4 // Bit mask of READY2 field.
	OPAMP_STATUS_READY2     = 0x4 // Bit READY2.

	// OPAMPCTRL: OPAMP n Control
	OPAMP_OPAMPCTRL_ENABLE_Pos   = 0x1      // Position of ENABLE field.
	OPAMP_OPAMPCTRL_ENABLE_Msk   = 0x2      // Bit mask of ENABLE field.
	OPAMP_OPAMPCTRL_ENABLE       = 0x2      // Bit ENABLE.
	OPAMP_OPAMPCTRL_ANAOUT_Pos   = 0x2      // Position of ANAOUT field.
	OPAMP_OPAMPCTRL_ANAOUT_Msk   = 0x4      // Bit mask of ANAOUT field.
	OPAMP_OPAMPCTRL_ANAOUT       = 0x4      // Bit ANAOUT.
	OPAMP_OPAMPCTRL_BIAS_Pos     = 0x3      // Position of BIAS field.
	OPAMP_OPAMPCTRL_BIAS_Msk     = 0x18     // Bit mask of BIAS field.
	OPAMP_OPAMPCTRL_RES2VCC_Pos  = 0x5      // Position of RES2VCC field.
	OPAMP_OPAMPCTRL_RES2VCC_Msk  = 0x20     // Bit mask of RES2VCC field.
	OPAMP_OPAMPCTRL_RES2VCC      = 0x20     // Bit RES2VCC.
	OPAMP_OPAMPCTRL_RUNSTDBY_Pos = 0x6      // Position of RUNSTDBY field.
	OPAMP_OPAMPCTRL_RUNSTDBY_Msk = 0x40     // Bit mask of RUNSTDBY field.
	OPAMP_OPAMPCTRL_RUNSTDBY     = 0x40     // Bit RUNSTDBY.
	OPAMP_OPAMPCTRL_ONDEMAND_Pos = 0x7      // Position of ONDEMAND field.
	OPAMP_OPAMPCTRL_ONDEMAND_Msk = 0x80     // Bit mask of ONDEMAND field.
	OPAMP_OPAMPCTRL_ONDEMAND     = 0x80     // Bit ONDEMAND.
	OPAMP_OPAMPCTRL_RES2OUT_Pos  = 0x8      // Position of RES2OUT field.
	OPAMP_OPAMPCTRL_RES2OUT_Msk  = 0x100    // Bit mask of RES2OUT field.
	OPAMP_OPAMPCTRL_RES2OUT      = 0x100    // Bit RES2OUT.
	OPAMP_OPAMPCTRL_RES1EN_Pos   = 0x9      // Position of RES1EN field.
	OPAMP_OPAMPCTRL_RES1EN_Msk   = 0x200    // Bit mask of RES1EN field.
	OPAMP_OPAMPCTRL_RES1EN       = 0x200    // Bit RES1EN.
	OPAMP_OPAMPCTRL_RES1MUX_Pos  = 0xa      // Position of RES1MUX field.
	OPAMP_OPAMPCTRL_RES1MUX_Msk  = 0x1c00   // Bit mask of RES1MUX field.
	OPAMP_OPAMPCTRL_POTMUX_Pos   = 0xd      // Position of POTMUX field.
	OPAMP_OPAMPCTRL_POTMUX_Msk   = 0xe000   // Bit mask of POTMUX field.
	OPAMP_OPAMPCTRL_MUXPOS_Pos   = 0x10     // Position of MUXPOS field.
	OPAMP_OPAMPCTRL_MUXPOS_Msk   = 0xf0000  // Bit mask of MUXPOS field.
	OPAMP_OPAMPCTRL_MUXNEG_Pos   = 0x14     // Position of MUXNEG field.
	OPAMP_OPAMPCTRL_MUXNEG_Msk   = 0xf00000 // Bit mask of MUXNEG field.

	// RESCTRL: Resister Control
	OPAMP_RESCTRL_RES2OUT_Pos     = 0x0  // Position of RES2OUT field.
	OPAMP_RESCTRL_RES2OUT_Msk     = 0x1  // Bit mask of RES2OUT field.
	OPAMP_RESCTRL_RES2OUT         = 0x1  // Bit RES2OUT.
	OPAMP_RESCTRL_RES1EN_Pos      = 0x1  // Position of RES1EN field.
	OPAMP_RESCTRL_RES1EN_Msk      = 0x2  // Bit mask of RES1EN field.
	OPAMP_RESCTRL_RES1EN          = 0x2  // Bit RES1EN.
	OPAMP_RESCTRL_RES1MUX_Pos     = 0x2  // Position of RES1MUX field.
	OPAMP_RESCTRL_RES1MUX_Msk     = 0x4  // Bit mask of RES1MUX field.
	OPAMP_RESCTRL_RES1MUX         = 0x4  // Bit RES1MUX.
	OPAMP_RESCTRL_POTMUX_Pos      = 0x3  // Position of POTMUX field.
	OPAMP_RESCTRL_POTMUX_Msk      = 0x38 // Bit mask of POTMUX field.
	OPAMP_RESCTRL_REFBUFLEVEL_Pos = 0x6  // Position of REFBUFLEVEL field.
	OPAMP_RESCTRL_REFBUFLEVEL_Msk = 0xc0 // Bit mask of REFBUFLEVEL field.
)

// Bitfields for OSCCTRL: Oscillators Control
const (
	// EVCTRL: Event Control
	OSCCTRL_EVCTRL_CFDEO_Pos   = 0x0 // Position of CFDEO field.
	OSCCTRL_EVCTRL_CFDEO_Msk   = 0x1 // Bit mask of CFDEO field.
	OSCCTRL_EVCTRL_CFDEO       = 0x1 // Bit CFDEO.
	OSCCTRL_EVCTRL_TUNEEI_Pos  = 0x1 // Position of TUNEEI field.
	OSCCTRL_EVCTRL_TUNEEI_Msk  = 0x2 // Bit mask of TUNEEI field.
	OSCCTRL_EVCTRL_TUNEEI      = 0x2 // Bit TUNEEI.
	OSCCTRL_EVCTRL_TUNEINV_Pos = 0x2 // Position of TUNEINV field.
	OSCCTRL_EVCTRL_TUNEINV_Msk = 0x4 // Bit mask of TUNEINV field.
	OSCCTRL_EVCTRL_TUNEINV     = 0x4 // Bit TUNEINV.

	// INTENCLR: Interrupt Enable Clear
	OSCCTRL_INTENCLR_XOSCRDY_Pos       = 0x0     // Position of XOSCRDY field.
	OSCCTRL_INTENCLR_XOSCRDY_Msk       = 0x1     // Bit mask of XOSCRDY field.
	OSCCTRL_INTENCLR_XOSCRDY           = 0x1     // Bit XOSCRDY.
	OSCCTRL_INTENCLR_XOSCFAIL_Pos      = 0x1     // Position of XOSCFAIL field.
	OSCCTRL_INTENCLR_XOSCFAIL_Msk      = 0x2     // Bit mask of XOSCFAIL field.
	OSCCTRL_INTENCLR_XOSCFAIL          = 0x2     // Bit XOSCFAIL.
	OSCCTRL_INTENCLR_OSC16MRDY_Pos     = 0x4     // Position of OSC16MRDY field.
	OSCCTRL_INTENCLR_OSC16MRDY_Msk     = 0x10    // Bit mask of OSC16MRDY field.
	OSCCTRL_INTENCLR_OSC16MRDY         = 0x10    // Bit OSC16MRDY.
	OSCCTRL_INTENCLR_DFLLULPRDY_Pos    = 0x8     // Position of DFLLULPRDY field.
	OSCCTRL_INTENCLR_DFLLULPRDY_Msk    = 0x100   // Bit mask of DFLLULPRDY field.
	OSCCTRL_INTENCLR_DFLLULPRDY        = 0x100   // Bit DFLLULPRDY.
	OSCCTRL_INTENCLR_DFLLULPLOCK_Pos   = 0x9     // Position of DFLLULPLOCK field.
	OSCCTRL_INTENCLR_DFLLULPLOCK_Msk   = 0x200   // Bit mask of DFLLULPLOCK field.
	OSCCTRL_INTENCLR_DFLLULPLOCK       = 0x200   // Bit DFLLULPLOCK.
	OSCCTRL_INTENCLR_DFLLULPNOLOCK_Pos = 0xa     // Position of DFLLULPNOLOCK field.
	OSCCTRL_INTENCLR_DFLLULPNOLOCK_Msk = 0x400   // Bit mask of DFLLULPNOLOCK field.
	OSCCTRL_INTENCLR_DFLLULPNOLOCK     = 0x400   // Bit DFLLULPNOLOCK.
	OSCCTRL_INTENCLR_DPLLLCKR_Pos      = 0x10    // Position of DPLLLCKR field.
	OSCCTRL_INTENCLR_DPLLLCKR_Msk      = 0x10000 // Bit mask of DPLLLCKR field.
	OSCCTRL_INTENCLR_DPLLLCKR          = 0x10000 // Bit DPLLLCKR.
	OSCCTRL_INTENCLR_DPLLLCKF_Pos      = 0x11    // Position of DPLLLCKF field.
	OSCCTRL_INTENCLR_DPLLLCKF_Msk      = 0x20000 // Bit mask of DPLLLCKF field.
	OSCCTRL_INTENCLR_DPLLLCKF          = 0x20000 // Bit DPLLLCKF.
	OSCCTRL_INTENCLR_DPLLLTO_Pos       = 0x12    // Position of DPLLLTO field.
	OSCCTRL_INTENCLR_DPLLLTO_Msk       = 0x40000 // Bit mask of DPLLLTO field.
	OSCCTRL_INTENCLR_DPLLLTO           = 0x40000 // Bit DPLLLTO.
	OSCCTRL_INTENCLR_DPLLLDRTO_Pos     = 0x13    // Position of DPLLLDRTO field.
	OSCCTRL_INTENCLR_DPLLLDRTO_Msk     = 0x80000 // Bit mask of DPLLLDRTO field.
	OSCCTRL_INTENCLR_DPLLLDRTO         = 0x80000 // Bit DPLLLDRTO.

	// INTENSET: Interrupt Enable Set
	OSCCTRL_INTENSET_XOSCRDY_Pos       = 0x0     // Position of XOSCRDY field.
	OSCCTRL_INTENSET_XOSCRDY_Msk       = 0x1     // Bit mask of XOSCRDY field.
	OSCCTRL_INTENSET_XOSCRDY           = 0x1     // Bit XOSCRDY.
	OSCCTRL_INTENSET_XOSCFAIL_Pos      = 0x1     // Position of XOSCFAIL field.
	OSCCTRL_INTENSET_XOSCFAIL_Msk      = 0x2     // Bit mask of XOSCFAIL field.
	OSCCTRL_INTENSET_XOSCFAIL          = 0x2     // Bit XOSCFAIL.
	OSCCTRL_INTENSET_OSC16MRDY_Pos     = 0x4     // Position of OSC16MRDY field.
	OSCCTRL_INTENSET_OSC16MRDY_Msk     = 0x10    // Bit mask of OSC16MRDY field.
	OSCCTRL_INTENSET_OSC16MRDY         = 0x10    // Bit OSC16MRDY.
	OSCCTRL_INTENSET_DFLLULPRDY_Pos    = 0x8     // Position of DFLLULPRDY field.
	OSCCTRL_INTENSET_DFLLULPRDY_Msk    = 0x100   // Bit mask of DFLLULPRDY field.
	OSCCTRL_INTENSET_DFLLULPRDY        = 0x100   // Bit DFLLULPRDY.
	OSCCTRL_INTENSET_DFLLULPLOCK_Pos   = 0x9     // Position of DFLLULPLOCK field.
	OSCCTRL_INTENSET_DFLLULPLOCK_Msk   = 0x200   // Bit mask of DFLLULPLOCK field.
	OSCCTRL_INTENSET_DFLLULPLOCK       = 0x200   // Bit DFLLULPLOCK.
	OSCCTRL_INTENSET_DFLLULPNOLOCK_Pos = 0xa     // Position of DFLLULPNOLOCK field.
	OSCCTRL_INTENSET_DFLLULPNOLOCK_Msk = 0x400   // Bit mask of DFLLULPNOLOCK field.
	OSCCTRL_INTENSET_DFLLULPNOLOCK     = 0x400   // Bit DFLLULPNOLOCK.
	OSCCTRL_INTENSET_DPLLLCKR_Pos      = 0x10    // Position of DPLLLCKR field.
	OSCCTRL_INTENSET_DPLLLCKR_Msk      = 0x10000 // Bit mask of DPLLLCKR field.
	OSCCTRL_INTENSET_DPLLLCKR          = 0x10000 // Bit DPLLLCKR.
	OSCCTRL_INTENSET_DPLLLCKF_Pos      = 0x11    // Position of DPLLLCKF field.
	OSCCTRL_INTENSET_DPLLLCKF_Msk      = 0x20000 // Bit mask of DPLLLCKF field.
	OSCCTRL_INTENSET_DPLLLCKF          = 0x20000 // Bit DPLLLCKF.
	OSCCTRL_INTENSET_DPLLLTO_Pos       = 0x12    // Position of DPLLLTO field.
	OSCCTRL_INTENSET_DPLLLTO_Msk       = 0x40000 // Bit mask of DPLLLTO field.
	OSCCTRL_INTENSET_DPLLLTO           = 0x40000 // Bit DPLLLTO.
	OSCCTRL_INTENSET_DPLLLDRTO_Pos     = 0x13    // Position of DPLLLDRTO field.
	OSCCTRL_INTENSET_DPLLLDRTO_Msk     = 0x80000 // Bit mask of DPLLLDRTO field.
	OSCCTRL_INTENSET_DPLLLDRTO         = 0x80000 // Bit DPLLLDRTO.

	// INTFLAG: Interrupt Flag Status and Clear
	OSCCTRL_INTFLAG_XOSCRDY_Pos       = 0x0     // Position of XOSCRDY field.
	OSCCTRL_INTFLAG_XOSCRDY_Msk       = 0x1     // Bit mask of XOSCRDY field.
	OSCCTRL_INTFLAG_XOSCRDY           = 0x1     // Bit XOSCRDY.
	OSCCTRL_INTFLAG_XOSCFAIL_Pos      = 0x1     // Position of XOSCFAIL field.
	OSCCTRL_INTFLAG_XOSCFAIL_Msk      = 0x2     // Bit mask of XOSCFAIL field.
	OSCCTRL_INTFLAG_XOSCFAIL          = 0x2     // Bit XOSCFAIL.
	OSCCTRL_INTFLAG_OSC16MRDY_Pos     = 0x4     // Position of OSC16MRDY field.
	OSCCTRL_INTFLAG_OSC16MRDY_Msk     = 0x10    // Bit mask of OSC16MRDY field.
	OSCCTRL_INTFLAG_OSC16MRDY         = 0x10    // Bit OSC16MRDY.
	OSCCTRL_INTFLAG_DFLLULPRDY_Pos    = 0x8     // Position of DFLLULPRDY field.
	OSCCTRL_INTFLAG_DFLLULPRDY_Msk    = 0x100   // Bit mask of DFLLULPRDY field.
	OSCCTRL_INTFLAG_DFLLULPRDY        = 0x100   // Bit DFLLULPRDY.
	OSCCTRL_INTFLAG_DFLLULPLOCK_Pos   = 0x9     // Position of DFLLULPLOCK field.
	OSCCTRL_INTFLAG_DFLLULPLOCK_Msk   = 0x200   // Bit mask of DFLLULPLOCK field.
	OSCCTRL_INTFLAG_DFLLULPLOCK       = 0x200   // Bit DFLLULPLOCK.
	OSCCTRL_INTFLAG_DFLLULPNOLOCK_Pos = 0xa     // Position of DFLLULPNOLOCK field.
	OSCCTRL_INTFLAG_DFLLULPNOLOCK_Msk = 0x400   // Bit mask of DFLLULPNOLOCK field.
	OSCCTRL_INTFLAG_DFLLULPNOLOCK     = 0x400   // Bit DFLLULPNOLOCK.
	OSCCTRL_INTFLAG_DPLLLCKR_Pos      = 0x10    // Position of DPLLLCKR field.
	OSCCTRL_INTFLAG_DPLLLCKR_Msk      = 0x10000 // Bit mask of DPLLLCKR field.
	OSCCTRL_INTFLAG_DPLLLCKR          = 0x10000 // Bit DPLLLCKR.
	OSCCTRL_INTFLAG_DPLLLCKF_Pos      = 0x11    // Position of DPLLLCKF field.
	OSCCTRL_INTFLAG_DPLLLCKF_Msk      = 0x20000 // Bit mask of DPLLLCKF field.
	OSCCTRL_INTFLAG_DPLLLCKF          = 0x20000 // Bit DPLLLCKF.
	OSCCTRL_INTFLAG_DPLLLTO_Pos       = 0x12    // Position of DPLLLTO field.
	OSCCTRL_INTFLAG_DPLLLTO_Msk       = 0x40000 // Bit mask of DPLLLTO field.
	OSCCTRL_INTFLAG_DPLLLTO           = 0x40000 // Bit DPLLLTO.
	OSCCTRL_INTFLAG_DPLLLDRTO_Pos     = 0x13    // Position of DPLLLDRTO field.
	OSCCTRL_INTFLAG_DPLLLDRTO_Msk     = 0x80000 // Bit mask of DPLLLDRTO field.
	OSCCTRL_INTFLAG_DPLLLDRTO         = 0x80000 // Bit DPLLLDRTO.

	// STATUS: Status
	OSCCTRL_STATUS_XOSCRDY_Pos       = 0x0     // Position of XOSCRDY field.
	OSCCTRL_STATUS_XOSCRDY_Msk       = 0x1     // Bit mask of XOSCRDY field.
	OSCCTRL_STATUS_XOSCRDY           = 0x1     // Bit XOSCRDY.
	OSCCTRL_STATUS_XOSCFAIL_Pos      = 0x1     // Position of XOSCFAIL field.
	OSCCTRL_STATUS_XOSCFAIL_Msk      = 0x2     // Bit mask of XOSCFAIL field.
	OSCCTRL_STATUS_XOSCFAIL          = 0x2     // Bit XOSCFAIL.
	OSCCTRL_STATUS_XOSCCKSW_Pos      = 0x2     // Position of XOSCCKSW field.
	OSCCTRL_STATUS_XOSCCKSW_Msk      = 0x4     // Bit mask of XOSCCKSW field.
	OSCCTRL_STATUS_XOSCCKSW          = 0x4     // Bit XOSCCKSW.
	OSCCTRL_STATUS_OSC16MRDY_Pos     = 0x4     // Position of OSC16MRDY field.
	OSCCTRL_STATUS_OSC16MRDY_Msk     = 0x10    // Bit mask of OSC16MRDY field.
	OSCCTRL_STATUS_OSC16MRDY         = 0x10    // Bit OSC16MRDY.
	OSCCTRL_STATUS_DFLLULPRDY_Pos    = 0x8     // Position of DFLLULPRDY field.
	OSCCTRL_STATUS_DFLLULPRDY_Msk    = 0x100   // Bit mask of DFLLULPRDY field.
	OSCCTRL_STATUS_DFLLULPRDY        = 0x100   // Bit DFLLULPRDY.
	OSCCTRL_STATUS_DFLLULPLOCK_Pos   = 0x9     // Position of DFLLULPLOCK field.
	OSCCTRL_STATUS_DFLLULPLOCK_Msk   = 0x200   // Bit mask of DFLLULPLOCK field.
	OSCCTRL_STATUS_DFLLULPLOCK       = 0x200   // Bit DFLLULPLOCK.
	OSCCTRL_STATUS_DFLLULPNOLOCK_Pos = 0xa     // Position of DFLLULPNOLOCK field.
	OSCCTRL_STATUS_DFLLULPNOLOCK_Msk = 0x400   // Bit mask of DFLLULPNOLOCK field.
	OSCCTRL_STATUS_DFLLULPNOLOCK     = 0x400   // Bit DFLLULPNOLOCK.
	OSCCTRL_STATUS_DPLLLCKR_Pos      = 0x10    // Position of DPLLLCKR field.
	OSCCTRL_STATUS_DPLLLCKR_Msk      = 0x10000 // Bit mask of DPLLLCKR field.
	OSCCTRL_STATUS_DPLLLCKR          = 0x10000 // Bit DPLLLCKR.
	OSCCTRL_STATUS_DPLLLCKF_Pos      = 0x11    // Position of DPLLLCKF field.
	OSCCTRL_STATUS_DPLLLCKF_Msk      = 0x20000 // Bit mask of DPLLLCKF field.
	OSCCTRL_STATUS_DPLLLCKF          = 0x20000 // Bit DPLLLCKF.
	OSCCTRL_STATUS_DPLLTO_Pos        = 0x12    // Position of DPLLTO field.
	OSCCTRL_STATUS_DPLLTO_Msk        = 0x40000 // Bit mask of DPLLTO field.
	OSCCTRL_STATUS_DPLLTO            = 0x40000 // Bit DPLLTO.
	OSCCTRL_STATUS_DPLLLDRTO_Pos     = 0x13    // Position of DPLLLDRTO field.
	OSCCTRL_STATUS_DPLLLDRTO_Msk     = 0x80000 // Bit mask of DPLLLDRTO field.
	OSCCTRL_STATUS_DPLLLDRTO         = 0x80000 // Bit DPLLLDRTO.

	// XOSCCTRL: External Multipurpose Crystal Oscillator (XOSC) Control
	OSCCTRL_XOSCCTRL_ENABLE_Pos   = 0x1    // Position of ENABLE field.
	OSCCTRL_XOSCCTRL_ENABLE_Msk   = 0x2    // Bit mask of ENABLE field.
	OSCCTRL_XOSCCTRL_ENABLE       = 0x2    // Bit ENABLE.
	OSCCTRL_XOSCCTRL_XTALEN_Pos   = 0x2    // Position of XTALEN field.
	OSCCTRL_XOSCCTRL_XTALEN_Msk   = 0x4    // Bit mask of XTALEN field.
	OSCCTRL_XOSCCTRL_XTALEN       = 0x4    // Bit XTALEN.
	OSCCTRL_XOSCCTRL_CFDEN_Pos    = 0x3    // Position of CFDEN field.
	OSCCTRL_XOSCCTRL_CFDEN_Msk    = 0x8    // Bit mask of CFDEN field.
	OSCCTRL_XOSCCTRL_CFDEN        = 0x8    // Bit CFDEN.
	OSCCTRL_XOSCCTRL_SWBEN_Pos    = 0x4    // Position of SWBEN field.
	OSCCTRL_XOSCCTRL_SWBEN_Msk    = 0x10   // Bit mask of SWBEN field.
	OSCCTRL_XOSCCTRL_SWBEN        = 0x10   // Bit SWBEN.
	OSCCTRL_XOSCCTRL_RUNSTDBY_Pos = 0x6    // Position of RUNSTDBY field.
	OSCCTRL_XOSCCTRL_RUNSTDBY_Msk = 0x40   // Bit mask of RUNSTDBY field.
	OSCCTRL_XOSCCTRL_RUNSTDBY     = 0x40   // Bit RUNSTDBY.
	OSCCTRL_XOSCCTRL_ONDEMAND_Pos = 0x7    // Position of ONDEMAND field.
	OSCCTRL_XOSCCTRL_ONDEMAND_Msk = 0x80   // Bit mask of ONDEMAND field.
	OSCCTRL_XOSCCTRL_ONDEMAND     = 0x80   // Bit ONDEMAND.
	OSCCTRL_XOSCCTRL_GAIN_Pos     = 0x8    // Position of GAIN field.
	OSCCTRL_XOSCCTRL_GAIN_Msk     = 0x700  // Bit mask of GAIN field.
	OSCCTRL_XOSCCTRL_AMPGC_Pos    = 0xb    // Position of AMPGC field.
	OSCCTRL_XOSCCTRL_AMPGC_Msk    = 0x800  // Bit mask of AMPGC field.
	OSCCTRL_XOSCCTRL_AMPGC        = 0x800  // Bit AMPGC.
	OSCCTRL_XOSCCTRL_STARTUP_Pos  = 0xc    // Position of STARTUP field.
	OSCCTRL_XOSCCTRL_STARTUP_Msk  = 0xf000 // Bit mask of STARTUP field.

	// CFDPRESC: Clock Failure Detector Prescaler
	OSCCTRL_CFDPRESC_CFDPRESC_Pos = 0x0 // Position of CFDPRESC field.
	OSCCTRL_CFDPRESC_CFDPRESC_Msk = 0x7 // Bit mask of CFDPRESC field.

	// OSC16MCTRL: 16MHz Internal Oscillator (OSC16M) Control
	OSCCTRL_OSC16MCTRL_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	OSCCTRL_OSC16MCTRL_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	OSCCTRL_OSC16MCTRL_ENABLE       = 0x2  // Bit ENABLE.
	OSCCTRL_OSC16MCTRL_FSEL_Pos     = 0x2  // Position of FSEL field.
	OSCCTRL_OSC16MCTRL_FSEL_Msk     = 0xc  // Bit mask of FSEL field.
	OSCCTRL_OSC16MCTRL_FSEL_4       = 0x0  // 4MHz
	OSCCTRL_OSC16MCTRL_FSEL_8       = 0x1  // 8MHz
	OSCCTRL_OSC16MCTRL_FSEL_12      = 0x2  // 12MHz
	OSCCTRL_OSC16MCTRL_FSEL_16      = 0x3  // 16MHz
	OSCCTRL_OSC16MCTRL_RUNSTDBY_Pos = 0x6  // Position of RUNSTDBY field.
	OSCCTRL_OSC16MCTRL_RUNSTDBY_Msk = 0x40 // Bit mask of RUNSTDBY field.
	OSCCTRL_OSC16MCTRL_RUNSTDBY     = 0x40 // Bit RUNSTDBY.
	OSCCTRL_OSC16MCTRL_ONDEMAND_Pos = 0x7  // Position of ONDEMAND field.
	OSCCTRL_OSC16MCTRL_ONDEMAND_Msk = 0x80 // Bit mask of ONDEMAND field.
	OSCCTRL_OSC16MCTRL_ONDEMAND     = 0x80 // Bit ONDEMAND.

	// DFLLULPCTRL: DFLLULP Control
	OSCCTRL_DFLLULPCTRL_ENABLE_Pos   = 0x1   // Position of ENABLE field.
	OSCCTRL_DFLLULPCTRL_ENABLE_Msk   = 0x2   // Bit mask of ENABLE field.
	OSCCTRL_DFLLULPCTRL_ENABLE       = 0x2   // Bit ENABLE.
	OSCCTRL_DFLLULPCTRL_BINSE_Pos    = 0x3   // Position of BINSE field.
	OSCCTRL_DFLLULPCTRL_BINSE_Msk    = 0x8   // Bit mask of BINSE field.
	OSCCTRL_DFLLULPCTRL_BINSE        = 0x8   // Bit BINSE.
	OSCCTRL_DFLLULPCTRL_SAFE_Pos     = 0x4   // Position of SAFE field.
	OSCCTRL_DFLLULPCTRL_SAFE_Msk     = 0x10  // Bit mask of SAFE field.
	OSCCTRL_DFLLULPCTRL_SAFE         = 0x10  // Bit SAFE.
	OSCCTRL_DFLLULPCTRL_DITHER_Pos   = 0x5   // Position of DITHER field.
	OSCCTRL_DFLLULPCTRL_DITHER_Msk   = 0x20  // Bit mask of DITHER field.
	OSCCTRL_DFLLULPCTRL_DITHER       = 0x20  // Bit DITHER.
	OSCCTRL_DFLLULPCTRL_RUNSTDBY_Pos = 0x6   // Position of RUNSTDBY field.
	OSCCTRL_DFLLULPCTRL_RUNSTDBY_Msk = 0x40  // Bit mask of RUNSTDBY field.
	OSCCTRL_DFLLULPCTRL_RUNSTDBY     = 0x40  // Bit RUNSTDBY.
	OSCCTRL_DFLLULPCTRL_ONDEMAND_Pos = 0x7   // Position of ONDEMAND field.
	OSCCTRL_DFLLULPCTRL_ONDEMAND_Msk = 0x80  // Bit mask of ONDEMAND field.
	OSCCTRL_DFLLULPCTRL_ONDEMAND     = 0x80  // Bit ONDEMAND.
	OSCCTRL_DFLLULPCTRL_DIV_Pos      = 0x8   // Position of DIV field.
	OSCCTRL_DFLLULPCTRL_DIV_Msk      = 0x700 // Bit mask of DIV field.
	OSCCTRL_DFLLULPCTRL_DIV_DIV1     = 0x0   // Frequency Divided by 1
	OSCCTRL_DFLLULPCTRL_DIV_DIV2     = 0x1   // Frequency Divided by 2
	OSCCTRL_DFLLULPCTRL_DIV_DIV4     = 0x2   // Frequency Divided by 4
	OSCCTRL_DFLLULPCTRL_DIV_DIV8     = 0x3   // Frequency Divided by 8
	OSCCTRL_DFLLULPCTRL_DIV_DIV16    = 0x4   // Frequency Divided by 16
	OSCCTRL_DFLLULPCTRL_DIV_DIV32    = 0x5   // Frequency Divided by 32

	// DFLLULPDITHER: DFLLULP Dither Control
	OSCCTRL_DFLLULPDITHER_STEP_Pos   = 0x0  // Position of STEP field.
	OSCCTRL_DFLLULPDITHER_STEP_Msk   = 0x7  // Bit mask of STEP field.
	OSCCTRL_DFLLULPDITHER_STEP_STEP1 = 0x0  // Dither Step = 1
	OSCCTRL_DFLLULPDITHER_STEP_STEP2 = 0x1  // Dither Step = 2
	OSCCTRL_DFLLULPDITHER_STEP_STEP4 = 0x2  // Dither Step = 4
	OSCCTRL_DFLLULPDITHER_STEP_STEP8 = 0x3  // Dither Step = 8
	OSCCTRL_DFLLULPDITHER_PER_Pos    = 0x4  // Position of PER field.
	OSCCTRL_DFLLULPDITHER_PER_Msk    = 0x70 // Bit mask of PER field.
	OSCCTRL_DFLLULPDITHER_PER_PER1   = 0x0  // Dither Over 1 Reference Clock Period
	OSCCTRL_DFLLULPDITHER_PER_PER2   = 0x1  // Dither Over 2 Reference Clock Period
	OSCCTRL_DFLLULPDITHER_PER_PER4   = 0x2  // Dither Over 4 Reference Clock Period
	OSCCTRL_DFLLULPDITHER_PER_PER8   = 0x3  // Dither Over 8 Reference Clock Period
	OSCCTRL_DFLLULPDITHER_PER_PER16  = 0x4  // Dither Over 16 Reference Clock Period
	OSCCTRL_DFLLULPDITHER_PER_PER32  = 0x5  // Dither Over 32 Reference Clock Period

	// DFLLULPRREQ: DFLLULP Read Request
	OSCCTRL_DFLLULPRREQ_RREQ_Pos = 0x7  // Position of RREQ field.
	OSCCTRL_DFLLULPRREQ_RREQ_Msk = 0x80 // Bit mask of RREQ field.
	OSCCTRL_DFLLULPRREQ_RREQ     = 0x80 // Bit RREQ.

	// DFLLULPDLY: DFLLULP Delay Value
	OSCCTRL_DFLLULPDLY_DELAY_Pos = 0x0  // Position of DELAY field.
	OSCCTRL_DFLLULPDLY_DELAY_Msk = 0xff // Bit mask of DELAY field.

	// DFLLULPRATIO: DFLLULP Target Ratio
	OSCCTRL_DFLLULPRATIO_RATIO_Pos = 0x0   // Position of RATIO field.
	OSCCTRL_DFLLULPRATIO_RATIO_Msk = 0x7ff // Bit mask of RATIO field.

	// DFLLULPSYNCBUSY: DFLLULP Synchronization Busy
	OSCCTRL_DFLLULPSYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	OSCCTRL_DFLLULPSYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	OSCCTRL_DFLLULPSYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.
	OSCCTRL_DFLLULPSYNCBUSY_TUNE_Pos   = 0x2 // Position of TUNE field.
	OSCCTRL_DFLLULPSYNCBUSY_TUNE_Msk   = 0x4 // Bit mask of TUNE field.
	OSCCTRL_DFLLULPSYNCBUSY_TUNE       = 0x4 // Bit TUNE.
	OSCCTRL_DFLLULPSYNCBUSY_DELAY_Pos  = 0x3 // Position of DELAY field.
	OSCCTRL_DFLLULPSYNCBUSY_DELAY_Msk  = 0x8 // Bit mask of DELAY field.
	OSCCTRL_DFLLULPSYNCBUSY_DELAY      = 0x8 // Bit DELAY.

	// DPLLCTRLA: DPLL Control A
	OSCCTRL_DPLLCTRLA_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	OSCCTRL_DPLLCTRLA_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	OSCCTRL_DPLLCTRLA_ENABLE       = 0x2  // Bit ENABLE.
	OSCCTRL_DPLLCTRLA_RUNSTDBY_Pos = 0x6  // Position of RUNSTDBY field.
	OSCCTRL_DPLLCTRLA_RUNSTDBY_Msk = 0x40 // Bit mask of RUNSTDBY field.
	OSCCTRL_DPLLCTRLA_RUNSTDBY     = 0x40 // Bit RUNSTDBY.
	OSCCTRL_DPLLCTRLA_ONDEMAND_Pos = 0x7  // Position of ONDEMAND field.
	OSCCTRL_DPLLCTRLA_ONDEMAND_Msk = 0x80 // Bit mask of ONDEMAND field.
	OSCCTRL_DPLLCTRLA_ONDEMAND     = 0x80 // Bit ONDEMAND.

	// DPLLRATIO: DPLL Ratio Control
	OSCCTRL_DPLLRATIO_LDR_Pos     = 0x0     // Position of LDR field.
	OSCCTRL_DPLLRATIO_LDR_Msk     = 0xfff   // Bit mask of LDR field.
	OSCCTRL_DPLLRATIO_LDRFRAC_Pos = 0x10    // Position of LDRFRAC field.
	OSCCTRL_DPLLRATIO_LDRFRAC_Msk = 0xf0000 // Bit mask of LDRFRAC field.

	// DPLLCTRLB: DPLL Control B
	OSCCTRL_DPLLCTRLB_FILTER_Pos     = 0x0       // Position of FILTER field.
	OSCCTRL_DPLLCTRLB_FILTER_Msk     = 0x3       // Bit mask of FILTER field.
	OSCCTRL_DPLLCTRLB_FILTER_Default = 0x0       // Default Filter Mode
	OSCCTRL_DPLLCTRLB_FILTER_LBFILT  = 0x1       // Low Bandwidth Filter
	OSCCTRL_DPLLCTRLB_FILTER_HBFILT  = 0x2       // High Bandwidth Filter
	OSCCTRL_DPLLCTRLB_FILTER_HDFILT  = 0x3       // High Damping Filter
	OSCCTRL_DPLLCTRLB_LPEN_Pos       = 0x2       // Position of LPEN field.
	OSCCTRL_DPLLCTRLB_LPEN_Msk       = 0x4       // Bit mask of LPEN field.
	OSCCTRL_DPLLCTRLB_LPEN           = 0x4       // Bit LPEN.
	OSCCTRL_DPLLCTRLB_WUF_Pos        = 0x3       // Position of WUF field.
	OSCCTRL_DPLLCTRLB_WUF_Msk        = 0x8       // Bit mask of WUF field.
	OSCCTRL_DPLLCTRLB_WUF            = 0x8       // Bit WUF.
	OSCCTRL_DPLLCTRLB_REFCLK_Pos     = 0x4       // Position of REFCLK field.
	OSCCTRL_DPLLCTRLB_REFCLK_Msk     = 0x30      // Bit mask of REFCLK field.
	OSCCTRL_DPLLCTRLB_REFCLK_XOSC32K = 0x0       // XOSC32K Clock Reference
	OSCCTRL_DPLLCTRLB_REFCLK_XOSC    = 0x1       // XOSC Clock Reference
	OSCCTRL_DPLLCTRLB_REFCLK_GCLK    = 0x2       // GCLK Clock Reference
	OSCCTRL_DPLLCTRLB_LTIME_Pos      = 0x8       // Position of LTIME field.
	OSCCTRL_DPLLCTRLB_LTIME_Msk      = 0x700     // Bit mask of LTIME field.
	OSCCTRL_DPLLCTRLB_LTIME_Default  = 0x0       // No time-out. Automatic lock
	OSCCTRL_DPLLCTRLB_LTIME_8MS      = 0x4       // Time-out if no lock within 8 ms
	OSCCTRL_DPLLCTRLB_LTIME_9MS      = 0x5       // Time-out if no lock within 9 ms
	OSCCTRL_DPLLCTRLB_LTIME_10MS     = 0x6       // Time-out if no lock within 10 ms
	OSCCTRL_DPLLCTRLB_LTIME_11MS     = 0x7       // Time-out if no lock within 11 ms
	OSCCTRL_DPLLCTRLB_LBYPASS_Pos    = 0xc       // Position of LBYPASS field.
	OSCCTRL_DPLLCTRLB_LBYPASS_Msk    = 0x1000    // Bit mask of LBYPASS field.
	OSCCTRL_DPLLCTRLB_LBYPASS        = 0x1000    // Bit LBYPASS.
	OSCCTRL_DPLLCTRLB_DIV_Pos        = 0x10      // Position of DIV field.
	OSCCTRL_DPLLCTRLB_DIV_Msk        = 0x7ff0000 // Bit mask of DIV field.

	// DPLLPRESC: DPLL Prescaler
	OSCCTRL_DPLLPRESC_PRESC_Pos  = 0x0 // Position of PRESC field.
	OSCCTRL_DPLLPRESC_PRESC_Msk  = 0x3 // Bit mask of PRESC field.
	OSCCTRL_DPLLPRESC_PRESC_DIV1 = 0x0 // DPLL output is divided by 1
	OSCCTRL_DPLLPRESC_PRESC_DIV2 = 0x1 // DPLL output is divided by 2
	OSCCTRL_DPLLPRESC_PRESC_DIV4 = 0x2 // DPLL output is divided by 4

	// DPLLSYNCBUSY: DPLL Synchronization Busy
	OSCCTRL_DPLLSYNCBUSY_ENABLE_Pos    = 0x1 // Position of ENABLE field.
	OSCCTRL_DPLLSYNCBUSY_ENABLE_Msk    = 0x2 // Bit mask of ENABLE field.
	OSCCTRL_DPLLSYNCBUSY_ENABLE        = 0x2 // Bit ENABLE.
	OSCCTRL_DPLLSYNCBUSY_DPLLRATIO_Pos = 0x2 // Position of DPLLRATIO field.
	OSCCTRL_DPLLSYNCBUSY_DPLLRATIO_Msk = 0x4 // Bit mask of DPLLRATIO field.
	OSCCTRL_DPLLSYNCBUSY_DPLLRATIO     = 0x4 // Bit DPLLRATIO.
	OSCCTRL_DPLLSYNCBUSY_DPLLPRESC_Pos = 0x3 // Position of DPLLPRESC field.
	OSCCTRL_DPLLSYNCBUSY_DPLLPRESC_Msk = 0x8 // Bit mask of DPLLPRESC field.
	OSCCTRL_DPLLSYNCBUSY_DPLLPRESC     = 0x8 // Bit DPLLPRESC.

	// DPLLSTATUS: DPLL Status
	OSCCTRL_DPLLSTATUS_LOCK_Pos   = 0x0 // Position of LOCK field.
	OSCCTRL_DPLLSTATUS_LOCK_Msk   = 0x1 // Bit mask of LOCK field.
	OSCCTRL_DPLLSTATUS_LOCK       = 0x1 // Bit LOCK.
	OSCCTRL_DPLLSTATUS_CLKRDY_Pos = 0x1 // Position of CLKRDY field.
	OSCCTRL_DPLLSTATUS_CLKRDY_Msk = 0x2 // Bit mask of CLKRDY field.
	OSCCTRL_DPLLSTATUS_CLKRDY     = 0x2 // Bit CLKRDY.
)

// Bitfields for OSC32KCTRL: 32k Oscillators Control
const (
	// INTENCLR: Interrupt Enable Clear
	OSC32KCTRL_INTENCLR_XOSC32KRDY_Pos = 0x0 // Position of XOSC32KRDY field.
	OSC32KCTRL_INTENCLR_XOSC32KRDY_Msk = 0x1 // Bit mask of XOSC32KRDY field.
	OSC32KCTRL_INTENCLR_XOSC32KRDY     = 0x1 // Bit XOSC32KRDY.
	OSC32KCTRL_INTENCLR_CLKFAIL_Pos    = 0x2 // Position of CLKFAIL field.
	OSC32KCTRL_INTENCLR_CLKFAIL_Msk    = 0x4 // Bit mask of CLKFAIL field.
	OSC32KCTRL_INTENCLR_CLKFAIL        = 0x4 // Bit CLKFAIL.

	// INTENSET: Interrupt Enable Set
	OSC32KCTRL_INTENSET_XOSC32KRDY_Pos = 0x0 // Position of XOSC32KRDY field.
	OSC32KCTRL_INTENSET_XOSC32KRDY_Msk = 0x1 // Bit mask of XOSC32KRDY field.
	OSC32KCTRL_INTENSET_XOSC32KRDY     = 0x1 // Bit XOSC32KRDY.
	OSC32KCTRL_INTENSET_CLKFAIL_Pos    = 0x2 // Position of CLKFAIL field.
	OSC32KCTRL_INTENSET_CLKFAIL_Msk    = 0x4 // Bit mask of CLKFAIL field.
	OSC32KCTRL_INTENSET_CLKFAIL        = 0x4 // Bit CLKFAIL.

	// INTFLAG: Interrupt Flag Status and Clear
	OSC32KCTRL_INTFLAG_XOSC32KRDY_Pos = 0x0 // Position of XOSC32KRDY field.
	OSC32KCTRL_INTFLAG_XOSC32KRDY_Msk = 0x1 // Bit mask of XOSC32KRDY field.
	OSC32KCTRL_INTFLAG_XOSC32KRDY     = 0x1 // Bit XOSC32KRDY.
	OSC32KCTRL_INTFLAG_CLKFAIL_Pos    = 0x2 // Position of CLKFAIL field.
	OSC32KCTRL_INTFLAG_CLKFAIL_Msk    = 0x4 // Bit mask of CLKFAIL field.
	OSC32KCTRL_INTFLAG_CLKFAIL        = 0x4 // Bit CLKFAIL.

	// STATUS: Power and Clocks Status
	OSC32KCTRL_STATUS_XOSC32KRDY_Pos = 0x0  // Position of XOSC32KRDY field.
	OSC32KCTRL_STATUS_XOSC32KRDY_Msk = 0x1  // Bit mask of XOSC32KRDY field.
	OSC32KCTRL_STATUS_XOSC32KRDY     = 0x1  // Bit XOSC32KRDY.
	OSC32KCTRL_STATUS_CLKFAIL_Pos    = 0x2  // Position of CLKFAIL field.
	OSC32KCTRL_STATUS_CLKFAIL_Msk    = 0x4  // Bit mask of CLKFAIL field.
	OSC32KCTRL_STATUS_CLKFAIL        = 0x4  // Bit CLKFAIL.
	OSC32KCTRL_STATUS_CLKSW_Pos      = 0x3  // Position of CLKSW field.
	OSC32KCTRL_STATUS_CLKSW_Msk      = 0x8  // Bit mask of CLKSW field.
	OSC32KCTRL_STATUS_CLKSW          = 0x8  // Bit CLKSW.
	OSC32KCTRL_STATUS_ULP32KSW_Pos   = 0x4  // Position of ULP32KSW field.
	OSC32KCTRL_STATUS_ULP32KSW_Msk   = 0x10 // Bit mask of ULP32KSW field.
	OSC32KCTRL_STATUS_ULP32KSW       = 0x10 // Bit ULP32KSW.

	// RTCCTRL: RTC Clock Selection
	OSC32KCTRL_RTCCTRL_RTCSEL_Pos     = 0x0 // Position of RTCSEL field.
	OSC32KCTRL_RTCCTRL_RTCSEL_Msk     = 0x7 // Bit mask of RTCSEL field.
	OSC32KCTRL_RTCCTRL_RTCSEL_ULP1K   = 0x0 // 1.024kHz from 32kHz internal ULP oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_ULP32K  = 0x1 // 32.768kHz from 32kHz internal ULP oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_OSC1K   = 0x2 // 1.024kHz from 32.768kHz internal oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_OSC32K  = 0x3 // 32.768kHz from 32.768kHz internal oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_XOSC1K  = 0x4 // 1.024kHz from 32.768kHz internal oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_XOSC32K = 0x5 // 32.768kHz from 32.768kHz external crystal oscillator

	// XOSC32K: 32kHz External Crystal Oscillator (XOSC32K) Control
	OSC32KCTRL_XOSC32K_ENABLE_Pos   = 0x1    // Position of ENABLE field.
	OSC32KCTRL_XOSC32K_ENABLE_Msk   = 0x2    // Bit mask of ENABLE field.
	OSC32KCTRL_XOSC32K_ENABLE       = 0x2    // Bit ENABLE.
	OSC32KCTRL_XOSC32K_XTALEN_Pos   = 0x2    // Position of XTALEN field.
	OSC32KCTRL_XOSC32K_XTALEN_Msk   = 0x4    // Bit mask of XTALEN field.
	OSC32KCTRL_XOSC32K_XTALEN       = 0x4    // Bit XTALEN.
	OSC32KCTRL_XOSC32K_EN32K_Pos    = 0x3    // Position of EN32K field.
	OSC32KCTRL_XOSC32K_EN32K_Msk    = 0x8    // Bit mask of EN32K field.
	OSC32KCTRL_XOSC32K_EN32K        = 0x8    // Bit EN32K.
	OSC32KCTRL_XOSC32K_EN1K_Pos     = 0x4    // Position of EN1K field.
	OSC32KCTRL_XOSC32K_EN1K_Msk     = 0x10   // Bit mask of EN1K field.
	OSC32KCTRL_XOSC32K_EN1K         = 0x10   // Bit EN1K.
	OSC32KCTRL_XOSC32K_RUNSTDBY_Pos = 0x6    // Position of RUNSTDBY field.
	OSC32KCTRL_XOSC32K_RUNSTDBY_Msk = 0x40   // Bit mask of RUNSTDBY field.
	OSC32KCTRL_XOSC32K_RUNSTDBY     = 0x40   // Bit RUNSTDBY.
	OSC32KCTRL_XOSC32K_ONDEMAND_Pos = 0x7    // Position of ONDEMAND field.
	OSC32KCTRL_XOSC32K_ONDEMAND_Msk = 0x80   // Bit mask of ONDEMAND field.
	OSC32KCTRL_XOSC32K_ONDEMAND     = 0x80   // Bit ONDEMAND.
	OSC32KCTRL_XOSC32K_STARTUP_Pos  = 0x8    // Position of STARTUP field.
	OSC32KCTRL_XOSC32K_STARTUP_Msk  = 0x700  // Bit mask of STARTUP field.
	OSC32KCTRL_XOSC32K_WRTLOCK_Pos  = 0xc    // Position of WRTLOCK field.
	OSC32KCTRL_XOSC32K_WRTLOCK_Msk  = 0x1000 // Bit mask of WRTLOCK field.
	OSC32KCTRL_XOSC32K_WRTLOCK      = 0x1000 // Bit WRTLOCK.

	// CFDCTRL: Clock Failure Detector Control
	OSC32KCTRL_CFDCTRL_CFDEN_Pos    = 0x0 // Position of CFDEN field.
	OSC32KCTRL_CFDCTRL_CFDEN_Msk    = 0x1 // Bit mask of CFDEN field.
	OSC32KCTRL_CFDCTRL_CFDEN        = 0x1 // Bit CFDEN.
	OSC32KCTRL_CFDCTRL_SWBACK_Pos   = 0x1 // Position of SWBACK field.
	OSC32KCTRL_CFDCTRL_SWBACK_Msk   = 0x2 // Bit mask of SWBACK field.
	OSC32KCTRL_CFDCTRL_SWBACK       = 0x2 // Bit SWBACK.
	OSC32KCTRL_CFDCTRL_CFDPRESC_Pos = 0x2 // Position of CFDPRESC field.
	OSC32KCTRL_CFDCTRL_CFDPRESC_Msk = 0x4 // Bit mask of CFDPRESC field.
	OSC32KCTRL_CFDCTRL_CFDPRESC     = 0x4 // Bit CFDPRESC.

	// EVCTRL: Event Control
	OSC32KCTRL_EVCTRL_CFDEO_Pos = 0x0 // Position of CFDEO field.
	OSC32KCTRL_EVCTRL_CFDEO_Msk = 0x1 // Bit mask of CFDEO field.
	OSC32KCTRL_EVCTRL_CFDEO     = 0x1 // Bit CFDEO.

	// OSCULP32K: 32kHz Ultra Low Power Internal Oscillator (OSCULP32K) Control
	OSC32KCTRL_OSCULP32K_ULP32KSW_Pos = 0x5    // Position of ULP32KSW field.
	OSC32KCTRL_OSCULP32K_ULP32KSW_Msk = 0x20   // Bit mask of ULP32KSW field.
	OSC32KCTRL_OSCULP32K_ULP32KSW     = 0x20   // Bit ULP32KSW.
	OSC32KCTRL_OSCULP32K_CALIB_Pos    = 0x8    // Position of CALIB field.
	OSC32KCTRL_OSCULP32K_CALIB_Msk    = 0x1f00 // Bit mask of CALIB field.
	OSC32KCTRL_OSCULP32K_WRTLOCK_Pos  = 0xf    // Position of WRTLOCK field.
	OSC32KCTRL_OSCULP32K_WRTLOCK_Msk  = 0x8000 // Bit mask of WRTLOCK field.
	OSC32KCTRL_OSCULP32K_WRTLOCK      = 0x8000 // Bit WRTLOCK.
)

// Bitfields for PAC: Peripheral Access Controller
const (
	// WRCTRL: Write control
	PAC_WRCTRL_PERID_Pos     = 0x0      // Position of PERID field.
	PAC_WRCTRL_PERID_Msk     = 0xffff   // Bit mask of PERID field.
	PAC_WRCTRL_KEY_Pos       = 0x10     // Position of KEY field.
	PAC_WRCTRL_KEY_Msk       = 0xff0000 // Bit mask of KEY field.
	PAC_WRCTRL_KEY_OFF       = 0x0      // No action
	PAC_WRCTRL_KEY_CLR       = 0x1      // Clear protection
	PAC_WRCTRL_KEY_SET       = 0x2      // Set protection
	PAC_WRCTRL_KEY_SETLCK    = 0x3      // Set and lock protection
	PAC_WRCTRL_KEY_SETSEC    = 0x4      // Set IP secure
	PAC_WRCTRL_KEY_SETNONSEC = 0x5      // Set IP non-secure
	PAC_WRCTRL_KEY_SECLOCK   = 0x6      // Lock IP security value

	// EVCTRL: Event control
	PAC_EVCTRL_ERREO_Pos = 0x0 // Position of ERREO field.
	PAC_EVCTRL_ERREO_Msk = 0x1 // Bit mask of ERREO field.
	PAC_EVCTRL_ERREO     = 0x1 // Bit ERREO.

	// INTENCLR: Interrupt enable clear
	PAC_INTENCLR_ERR_Pos = 0x0 // Position of ERR field.
	PAC_INTENCLR_ERR_Msk = 0x1 // Bit mask of ERR field.
	PAC_INTENCLR_ERR     = 0x1 // Bit ERR.

	// INTENSET: Interrupt enable set
	PAC_INTENSET_ERR_Pos = 0x0 // Position of ERR field.
	PAC_INTENSET_ERR_Msk = 0x1 // Bit mask of ERR field.
	PAC_INTENSET_ERR     = 0x1 // Bit ERR.

	// INTFLAGAHB: Bridge interrupt flag status
	PAC_INTFLAGAHB_FLASH__Pos     = 0x0  // Position of FLASH_ field.
	PAC_INTFLAGAHB_FLASH__Msk     = 0x1  // Bit mask of FLASH_ field.
	PAC_INTFLAGAHB_FLASH_         = 0x1  // Bit FLASH_.
	PAC_INTFLAGAHB_HPB0__Pos      = 0x1  // Position of HPB0_ field.
	PAC_INTFLAGAHB_HPB0__Msk      = 0x2  // Bit mask of HPB0_ field.
	PAC_INTFLAGAHB_HPB0_          = 0x2  // Bit HPB0_.
	PAC_INTFLAGAHB_HPB1__Pos      = 0x2  // Position of HPB1_ field.
	PAC_INTFLAGAHB_HPB1__Msk      = 0x4  // Bit mask of HPB1_ field.
	PAC_INTFLAGAHB_HPB1_          = 0x4  // Bit HPB1_.
	PAC_INTFLAGAHB_HPB2__Pos      = 0x3  // Position of HPB2_ field.
	PAC_INTFLAGAHB_HPB2__Msk      = 0x8  // Bit mask of HPB2_ field.
	PAC_INTFLAGAHB_HPB2_          = 0x8  // Bit HPB2_.
	PAC_INTFLAGAHB_HSRAMCPU__Pos  = 0x4  // Position of HSRAMCPU_ field.
	PAC_INTFLAGAHB_HSRAMCPU__Msk  = 0x10 // Bit mask of HSRAMCPU_ field.
	PAC_INTFLAGAHB_HSRAMCPU_      = 0x10 // Bit HSRAMCPU_.
	PAC_INTFLAGAHB_HSRAMDMAC__Pos = 0x5  // Position of HSRAMDMAC_ field.
	PAC_INTFLAGAHB_HSRAMDMAC__Msk = 0x20 // Bit mask of HSRAMDMAC_ field.
	PAC_INTFLAGAHB_HSRAMDMAC_     = 0x20 // Bit HSRAMDMAC_.
	PAC_INTFLAGAHB_HSRAMDSU__Pos  = 0x6  // Position of HSRAMDSU_ field.
	PAC_INTFLAGAHB_HSRAMDSU__Msk  = 0x40 // Bit mask of HSRAMDSU_ field.
	PAC_INTFLAGAHB_HSRAMDSU_      = 0x40 // Bit HSRAMDSU_.

	// INTFLAGA: Peripheral interrupt flag status - Bridge A
	PAC_INTFLAGA_PAC__Pos        = 0x0    // Position of PAC_ field.
	PAC_INTFLAGA_PAC__Msk        = 0x1    // Bit mask of PAC_ field.
	PAC_INTFLAGA_PAC_            = 0x1    // Bit PAC_.
	PAC_INTFLAGA_PM__Pos         = 0x1    // Position of PM_ field.
	PAC_INTFLAGA_PM__Msk         = 0x2    // Bit mask of PM_ field.
	PAC_INTFLAGA_PM_             = 0x2    // Bit PM_.
	PAC_INTFLAGA_MCLK__Pos       = 0x2    // Position of MCLK_ field.
	PAC_INTFLAGA_MCLK__Msk       = 0x4    // Bit mask of MCLK_ field.
	PAC_INTFLAGA_MCLK_           = 0x4    // Bit MCLK_.
	PAC_INTFLAGA_RSTC__Pos       = 0x3    // Position of RSTC_ field.
	PAC_INTFLAGA_RSTC__Msk       = 0x8    // Bit mask of RSTC_ field.
	PAC_INTFLAGA_RSTC_           = 0x8    // Bit RSTC_.
	PAC_INTFLAGA_OSCCTRL__Pos    = 0x4    // Position of OSCCTRL_ field.
	PAC_INTFLAGA_OSCCTRL__Msk    = 0x10   // Bit mask of OSCCTRL_ field.
	PAC_INTFLAGA_OSCCTRL_        = 0x10   // Bit OSCCTRL_.
	PAC_INTFLAGA_OSC32KCTRL__Pos = 0x5    // Position of OSC32KCTRL_ field.
	PAC_INTFLAGA_OSC32KCTRL__Msk = 0x20   // Bit mask of OSC32KCTRL_ field.
	PAC_INTFLAGA_OSC32KCTRL_     = 0x20   // Bit OSC32KCTRL_.
	PAC_INTFLAGA_SUPC__Pos       = 0x6    // Position of SUPC_ field.
	PAC_INTFLAGA_SUPC__Msk       = 0x40   // Bit mask of SUPC_ field.
	PAC_INTFLAGA_SUPC_           = 0x40   // Bit SUPC_.
	PAC_INTFLAGA_GCLK__Pos       = 0x7    // Position of GCLK_ field.
	PAC_INTFLAGA_GCLK__Msk       = 0x80   // Bit mask of GCLK_ field.
	PAC_INTFLAGA_GCLK_           = 0x80   // Bit GCLK_.
	PAC_INTFLAGA_WDT__Pos        = 0x8    // Position of WDT_ field.
	PAC_INTFLAGA_WDT__Msk        = 0x100  // Bit mask of WDT_ field.
	PAC_INTFLAGA_WDT_            = 0x100  // Bit WDT_.
	PAC_INTFLAGA_RTC__Pos        = 0x9    // Position of RTC_ field.
	PAC_INTFLAGA_RTC__Msk        = 0x200  // Bit mask of RTC_ field.
	PAC_INTFLAGA_RTC_            = 0x200  // Bit RTC_.
	PAC_INTFLAGA_EIC__Pos        = 0xa    // Position of EIC_ field.
	PAC_INTFLAGA_EIC__Msk        = 0x400  // Bit mask of EIC_ field.
	PAC_INTFLAGA_EIC_            = 0x400  // Bit EIC_.
	PAC_INTFLAGA_FREQM__Pos      = 0xb    // Position of FREQM_ field.
	PAC_INTFLAGA_FREQM__Msk      = 0x800  // Bit mask of FREQM_ field.
	PAC_INTFLAGA_FREQM_          = 0x800  // Bit FREQM_.
	PAC_INTFLAGA_PORT__Pos       = 0xc    // Position of PORT_ field.
	PAC_INTFLAGA_PORT__Msk       = 0x1000 // Bit mask of PORT_ field.
	PAC_INTFLAGA_PORT_           = 0x1000 // Bit PORT_.
	PAC_INTFLAGA_AC__Pos         = 0xd    // Position of AC_ field.
	PAC_INTFLAGA_AC__Msk         = 0x2000 // Bit mask of AC_ field.
	PAC_INTFLAGA_AC_             = 0x2000 // Bit AC_.

	// INTFLAGB: Peripheral interrupt flag status - Bridge B
	PAC_INTFLAGB_IDAU__Pos    = 0x0 // Position of IDAU_ field.
	PAC_INTFLAGB_IDAU__Msk    = 0x1 // Bit mask of IDAU_ field.
	PAC_INTFLAGB_IDAU_        = 0x1 // Bit IDAU_.
	PAC_INTFLAGB_DSU__Pos     = 0x1 // Position of DSU_ field.
	PAC_INTFLAGB_DSU__Msk     = 0x2 // Bit mask of DSU_ field.
	PAC_INTFLAGB_DSU_         = 0x2 // Bit DSU_.
	PAC_INTFLAGB_NVMCTRL__Pos = 0x2 // Position of NVMCTRL_ field.
	PAC_INTFLAGB_NVMCTRL__Msk = 0x4 // Bit mask of NVMCTRL_ field.
	PAC_INTFLAGB_NVMCTRL_     = 0x4 // Bit NVMCTRL_.
	PAC_INTFLAGB_DMAC__Pos    = 0x3 // Position of DMAC_ field.
	PAC_INTFLAGB_DMAC__Msk    = 0x8 // Bit mask of DMAC_ field.
	PAC_INTFLAGB_DMAC_        = 0x8 // Bit DMAC_.

	// INTFLAGC: Peripheral interrupt flag status - Bridge C
	PAC_INTFLAGC_EVSYS__Pos   = 0x0    // Position of EVSYS_ field.
	PAC_INTFLAGC_EVSYS__Msk   = 0x1    // Bit mask of EVSYS_ field.
	PAC_INTFLAGC_EVSYS_       = 0x1    // Bit EVSYS_.
	PAC_INTFLAGC_SERCOM0__Pos = 0x1    // Position of SERCOM0_ field.
	PAC_INTFLAGC_SERCOM0__Msk = 0x2    // Bit mask of SERCOM0_ field.
	PAC_INTFLAGC_SERCOM0_     = 0x2    // Bit SERCOM0_.
	PAC_INTFLAGC_SERCOM1__Pos = 0x2    // Position of SERCOM1_ field.
	PAC_INTFLAGC_SERCOM1__Msk = 0x4    // Bit mask of SERCOM1_ field.
	PAC_INTFLAGC_SERCOM1_     = 0x4    // Bit SERCOM1_.
	PAC_INTFLAGC_SERCOM2__Pos = 0x3    // Position of SERCOM2_ field.
	PAC_INTFLAGC_SERCOM2__Msk = 0x8    // Bit mask of SERCOM2_ field.
	PAC_INTFLAGC_SERCOM2_     = 0x8    // Bit SERCOM2_.
	PAC_INTFLAGC_TC0__Pos     = 0x4    // Position of TC0_ field.
	PAC_INTFLAGC_TC0__Msk     = 0x10   // Bit mask of TC0_ field.
	PAC_INTFLAGC_TC0_         = 0x10   // Bit TC0_.
	PAC_INTFLAGC_TC1__Pos     = 0x5    // Position of TC1_ field.
	PAC_INTFLAGC_TC1__Msk     = 0x20   // Bit mask of TC1_ field.
	PAC_INTFLAGC_TC1_         = 0x20   // Bit TC1_.
	PAC_INTFLAGC_TC2__Pos     = 0x6    // Position of TC2_ field.
	PAC_INTFLAGC_TC2__Msk     = 0x40   // Bit mask of TC2_ field.
	PAC_INTFLAGC_TC2_         = 0x40   // Bit TC2_.
	PAC_INTFLAGC_ADC__Pos     = 0x7    // Position of ADC_ field.
	PAC_INTFLAGC_ADC__Msk     = 0x80   // Bit mask of ADC_ field.
	PAC_INTFLAGC_ADC_         = 0x80   // Bit ADC_.
	PAC_INTFLAGC_DAC__Pos     = 0x8    // Position of DAC_ field.
	PAC_INTFLAGC_DAC__Msk     = 0x100  // Bit mask of DAC_ field.
	PAC_INTFLAGC_DAC_         = 0x100  // Bit DAC_.
	PAC_INTFLAGC_PTC__Pos     = 0x9    // Position of PTC_ field.
	PAC_INTFLAGC_PTC__Msk     = 0x200  // Bit mask of PTC_ field.
	PAC_INTFLAGC_PTC_         = 0x200  // Bit PTC_.
	PAC_INTFLAGC_TRNG__Pos    = 0xa    // Position of TRNG_ field.
	PAC_INTFLAGC_TRNG__Msk    = 0x400  // Bit mask of TRNG_ field.
	PAC_INTFLAGC_TRNG_        = 0x400  // Bit TRNG_.
	PAC_INTFLAGC_CCL__Pos     = 0xb    // Position of CCL_ field.
	PAC_INTFLAGC_CCL__Msk     = 0x800  // Bit mask of CCL_ field.
	PAC_INTFLAGC_CCL_         = 0x800  // Bit CCL_.
	PAC_INTFLAGC_OPAMP__Pos   = 0xc    // Position of OPAMP_ field.
	PAC_INTFLAGC_OPAMP__Msk   = 0x1000 // Bit mask of OPAMP_ field.
	PAC_INTFLAGC_OPAMP_       = 0x1000 // Bit OPAMP_.
	PAC_INTFLAGC_TRAM__Pos    = 0xd    // Position of TRAM_ field.
	PAC_INTFLAGC_TRAM__Msk    = 0x2000 // Bit mask of TRAM_ field.
	PAC_INTFLAGC_TRAM_        = 0x2000 // Bit TRAM_.

	// STATUSA: Peripheral write protection status - Bridge A
	PAC_STATUSA_PAC__Pos        = 0x0    // Position of PAC_ field.
	PAC_STATUSA_PAC__Msk        = 0x1    // Bit mask of PAC_ field.
	PAC_STATUSA_PAC_            = 0x1    // Bit PAC_.
	PAC_STATUSA_PM__Pos         = 0x1    // Position of PM_ field.
	PAC_STATUSA_PM__Msk         = 0x2    // Bit mask of PM_ field.
	PAC_STATUSA_PM_             = 0x2    // Bit PM_.
	PAC_STATUSA_MCLK__Pos       = 0x2    // Position of MCLK_ field.
	PAC_STATUSA_MCLK__Msk       = 0x4    // Bit mask of MCLK_ field.
	PAC_STATUSA_MCLK_           = 0x4    // Bit MCLK_.
	PAC_STATUSA_RSTC__Pos       = 0x3    // Position of RSTC_ field.
	PAC_STATUSA_RSTC__Msk       = 0x8    // Bit mask of RSTC_ field.
	PAC_STATUSA_RSTC_           = 0x8    // Bit RSTC_.
	PAC_STATUSA_OSCCTRL__Pos    = 0x4    // Position of OSCCTRL_ field.
	PAC_STATUSA_OSCCTRL__Msk    = 0x10   // Bit mask of OSCCTRL_ field.
	PAC_STATUSA_OSCCTRL_        = 0x10   // Bit OSCCTRL_.
	PAC_STATUSA_OSC32KCTRL__Pos = 0x5    // Position of OSC32KCTRL_ field.
	PAC_STATUSA_OSC32KCTRL__Msk = 0x20   // Bit mask of OSC32KCTRL_ field.
	PAC_STATUSA_OSC32KCTRL_     = 0x20   // Bit OSC32KCTRL_.
	PAC_STATUSA_SUPC__Pos       = 0x6    // Position of SUPC_ field.
	PAC_STATUSA_SUPC__Msk       = 0x40   // Bit mask of SUPC_ field.
	PAC_STATUSA_SUPC_           = 0x40   // Bit SUPC_.
	PAC_STATUSA_GCLK__Pos       = 0x7    // Position of GCLK_ field.
	PAC_STATUSA_GCLK__Msk       = 0x80   // Bit mask of GCLK_ field.
	PAC_STATUSA_GCLK_           = 0x80   // Bit GCLK_.
	PAC_STATUSA_WDT__Pos        = 0x8    // Position of WDT_ field.
	PAC_STATUSA_WDT__Msk        = 0x100  // Bit mask of WDT_ field.
	PAC_STATUSA_WDT_            = 0x100  // Bit WDT_.
	PAC_STATUSA_RTC__Pos        = 0x9    // Position of RTC_ field.
	PAC_STATUSA_RTC__Msk        = 0x200  // Bit mask of RTC_ field.
	PAC_STATUSA_RTC_            = 0x200  // Bit RTC_.
	PAC_STATUSA_EIC__Pos        = 0xa    // Position of EIC_ field.
	PAC_STATUSA_EIC__Msk        = 0x400  // Bit mask of EIC_ field.
	PAC_STATUSA_EIC_            = 0x400  // Bit EIC_.
	PAC_STATUSA_FREQM__Pos      = 0xb    // Position of FREQM_ field.
	PAC_STATUSA_FREQM__Msk      = 0x800  // Bit mask of FREQM_ field.
	PAC_STATUSA_FREQM_          = 0x800  // Bit FREQM_.
	PAC_STATUSA_PORT__Pos       = 0xc    // Position of PORT_ field.
	PAC_STATUSA_PORT__Msk       = 0x1000 // Bit mask of PORT_ field.
	PAC_STATUSA_PORT_           = 0x1000 // Bit PORT_.
	PAC_STATUSA_AC__Pos         = 0xd    // Position of AC_ field.
	PAC_STATUSA_AC__Msk         = 0x2000 // Bit mask of AC_ field.
	PAC_STATUSA_AC_             = 0x2000 // Bit AC_.

	// STATUSB: Peripheral write protection status - Bridge B
	PAC_STATUSB_IDAU__Pos    = 0x0 // Position of IDAU_ field.
	PAC_STATUSB_IDAU__Msk    = 0x1 // Bit mask of IDAU_ field.
	PAC_STATUSB_IDAU_        = 0x1 // Bit IDAU_.
	PAC_STATUSB_DSU__Pos     = 0x1 // Position of DSU_ field.
	PAC_STATUSB_DSU__Msk     = 0x2 // Bit mask of DSU_ field.
	PAC_STATUSB_DSU_         = 0x2 // Bit DSU_.
	PAC_STATUSB_NVMCTRL__Pos = 0x2 // Position of NVMCTRL_ field.
	PAC_STATUSB_NVMCTRL__Msk = 0x4 // Bit mask of NVMCTRL_ field.
	PAC_STATUSB_NVMCTRL_     = 0x4 // Bit NVMCTRL_.
	PAC_STATUSB_DMAC__Pos    = 0x3 // Position of DMAC_ field.
	PAC_STATUSB_DMAC__Msk    = 0x8 // Bit mask of DMAC_ field.
	PAC_STATUSB_DMAC_        = 0x8 // Bit DMAC_.

	// STATUSC: Peripheral write protection status - Bridge C
	PAC_STATUSC_EVSYS__Pos   = 0x0    // Position of EVSYS_ field.
	PAC_STATUSC_EVSYS__Msk   = 0x1    // Bit mask of EVSYS_ field.
	PAC_STATUSC_EVSYS_       = 0x1    // Bit EVSYS_.
	PAC_STATUSC_SERCOM0__Pos = 0x1    // Position of SERCOM0_ field.
	PAC_STATUSC_SERCOM0__Msk = 0x2    // Bit mask of SERCOM0_ field.
	PAC_STATUSC_SERCOM0_     = 0x2    // Bit SERCOM0_.
	PAC_STATUSC_SERCOM1__Pos = 0x2    // Position of SERCOM1_ field.
	PAC_STATUSC_SERCOM1__Msk = 0x4    // Bit mask of SERCOM1_ field.
	PAC_STATUSC_SERCOM1_     = 0x4    // Bit SERCOM1_.
	PAC_STATUSC_SERCOM2__Pos = 0x3    // Position of SERCOM2_ field.
	PAC_STATUSC_SERCOM2__Msk = 0x8    // Bit mask of SERCOM2_ field.
	PAC_STATUSC_SERCOM2_     = 0x8    // Bit SERCOM2_.
	PAC_STATUSC_TC0__Pos     = 0x4    // Position of TC0_ field.
	PAC_STATUSC_TC0__Msk     = 0x10   // Bit mask of TC0_ field.
	PAC_STATUSC_TC0_         = 0x10   // Bit TC0_.
	PAC_STATUSC_TC1__Pos     = 0x5    // Position of TC1_ field.
	PAC_STATUSC_TC1__Msk     = 0x20   // Bit mask of TC1_ field.
	PAC_STATUSC_TC1_         = 0x20   // Bit TC1_.
	PAC_STATUSC_TC2__Pos     = 0x6    // Position of TC2_ field.
	PAC_STATUSC_TC2__Msk     = 0x40   // Bit mask of TC2_ field.
	PAC_STATUSC_TC2_         = 0x40   // Bit TC2_.
	PAC_STATUSC_ADC__Pos     = 0x7    // Position of ADC_ field.
	PAC_STATUSC_ADC__Msk     = 0x80   // Bit mask of ADC_ field.
	PAC_STATUSC_ADC_         = 0x80   // Bit ADC_.
	PAC_STATUSC_DAC__Pos     = 0x8    // Position of DAC_ field.
	PAC_STATUSC_DAC__Msk     = 0x100  // Bit mask of DAC_ field.
	PAC_STATUSC_DAC_         = 0x100  // Bit DAC_.
	PAC_STATUSC_PTC__Pos     = 0x9    // Position of PTC_ field.
	PAC_STATUSC_PTC__Msk     = 0x200  // Bit mask of PTC_ field.
	PAC_STATUSC_PTC_         = 0x200  // Bit PTC_.
	PAC_STATUSC_TRNG__Pos    = 0xa    // Position of TRNG_ field.
	PAC_STATUSC_TRNG__Msk    = 0x400  // Bit mask of TRNG_ field.
	PAC_STATUSC_TRNG_        = 0x400  // Bit TRNG_.
	PAC_STATUSC_CCL__Pos     = 0xb    // Position of CCL_ field.
	PAC_STATUSC_CCL__Msk     = 0x800  // Bit mask of CCL_ field.
	PAC_STATUSC_CCL_         = 0x800  // Bit CCL_.
	PAC_STATUSC_OPAMP__Pos   = 0xc    // Position of OPAMP_ field.
	PAC_STATUSC_OPAMP__Msk   = 0x1000 // Bit mask of OPAMP_ field.
	PAC_STATUSC_OPAMP_       = 0x1000 // Bit OPAMP_.
	PAC_STATUSC_TRAM__Pos    = 0xd    // Position of TRAM_ field.
	PAC_STATUSC_TRAM__Msk    = 0x2000 // Bit mask of TRAM_ field.
	PAC_STATUSC_TRAM_        = 0x2000 // Bit TRAM_.

	// NONSECA: Peripheral non-secure status - Bridge A
	PAC_NONSECA_PAC__Pos        = 0x0    // Position of PAC_ field.
	PAC_NONSECA_PAC__Msk        = 0x1    // Bit mask of PAC_ field.
	PAC_NONSECA_PAC_            = 0x1    // Bit PAC_.
	PAC_NONSECA_PM__Pos         = 0x1    // Position of PM_ field.
	PAC_NONSECA_PM__Msk         = 0x2    // Bit mask of PM_ field.
	PAC_NONSECA_PM_             = 0x2    // Bit PM_.
	PAC_NONSECA_MCLK__Pos       = 0x2    // Position of MCLK_ field.
	PAC_NONSECA_MCLK__Msk       = 0x4    // Bit mask of MCLK_ field.
	PAC_NONSECA_MCLK_           = 0x4    // Bit MCLK_.
	PAC_NONSECA_RSTC__Pos       = 0x3    // Position of RSTC_ field.
	PAC_NONSECA_RSTC__Msk       = 0x8    // Bit mask of RSTC_ field.
	PAC_NONSECA_RSTC_           = 0x8    // Bit RSTC_.
	PAC_NONSECA_OSCCTRL__Pos    = 0x4    // Position of OSCCTRL_ field.
	PAC_NONSECA_OSCCTRL__Msk    = 0x10   // Bit mask of OSCCTRL_ field.
	PAC_NONSECA_OSCCTRL_        = 0x10   // Bit OSCCTRL_.
	PAC_NONSECA_OSC32KCTRL__Pos = 0x5    // Position of OSC32KCTRL_ field.
	PAC_NONSECA_OSC32KCTRL__Msk = 0x20   // Bit mask of OSC32KCTRL_ field.
	PAC_NONSECA_OSC32KCTRL_     = 0x20   // Bit OSC32KCTRL_.
	PAC_NONSECA_SUPC__Pos       = 0x6    // Position of SUPC_ field.
	PAC_NONSECA_SUPC__Msk       = 0x40   // Bit mask of SUPC_ field.
	PAC_NONSECA_SUPC_           = 0x40   // Bit SUPC_.
	PAC_NONSECA_GCLK__Pos       = 0x7    // Position of GCLK_ field.
	PAC_NONSECA_GCLK__Msk       = 0x80   // Bit mask of GCLK_ field.
	PAC_NONSECA_GCLK_           = 0x80   // Bit GCLK_.
	PAC_NONSECA_WDT__Pos        = 0x8    // Position of WDT_ field.
	PAC_NONSECA_WDT__Msk        = 0x100  // Bit mask of WDT_ field.
	PAC_NONSECA_WDT_            = 0x100  // Bit WDT_.
	PAC_NONSECA_RTC__Pos        = 0x9    // Position of RTC_ field.
	PAC_NONSECA_RTC__Msk        = 0x200  // Bit mask of RTC_ field.
	PAC_NONSECA_RTC_            = 0x200  // Bit RTC_.
	PAC_NONSECA_EIC__Pos        = 0xa    // Position of EIC_ field.
	PAC_NONSECA_EIC__Msk        = 0x400  // Bit mask of EIC_ field.
	PAC_NONSECA_EIC_            = 0x400  // Bit EIC_.
	PAC_NONSECA_FREQM__Pos      = 0xb    // Position of FREQM_ field.
	PAC_NONSECA_FREQM__Msk      = 0x800  // Bit mask of FREQM_ field.
	PAC_NONSECA_FREQM_          = 0x800  // Bit FREQM_.
	PAC_NONSECA_PORT__Pos       = 0xc    // Position of PORT_ field.
	PAC_NONSECA_PORT__Msk       = 0x1000 // Bit mask of PORT_ field.
	PAC_NONSECA_PORT_           = 0x1000 // Bit PORT_.
	PAC_NONSECA_AC__Pos         = 0xd    // Position of AC_ field.
	PAC_NONSECA_AC__Msk         = 0x2000 // Bit mask of AC_ field.
	PAC_NONSECA_AC_             = 0x2000 // Bit AC_.

	// NONSECB: Peripheral non-secure status - Bridge B
	PAC_NONSECB_IDAU__Pos    = 0x0 // Position of IDAU_ field.
	PAC_NONSECB_IDAU__Msk    = 0x1 // Bit mask of IDAU_ field.
	PAC_NONSECB_IDAU_        = 0x1 // Bit IDAU_.
	PAC_NONSECB_DSU__Pos     = 0x1 // Position of DSU_ field.
	PAC_NONSECB_DSU__Msk     = 0x2 // Bit mask of DSU_ field.
	PAC_NONSECB_DSU_         = 0x2 // Bit DSU_.
	PAC_NONSECB_NVMCTRL__Pos = 0x2 // Position of NVMCTRL_ field.
	PAC_NONSECB_NVMCTRL__Msk = 0x4 // Bit mask of NVMCTRL_ field.
	PAC_NONSECB_NVMCTRL_     = 0x4 // Bit NVMCTRL_.
	PAC_NONSECB_DMAC__Pos    = 0x3 // Position of DMAC_ field.
	PAC_NONSECB_DMAC__Msk    = 0x8 // Bit mask of DMAC_ field.
	PAC_NONSECB_DMAC_        = 0x8 // Bit DMAC_.

	// NONSECC: Peripheral non-secure status - Bridge C
	PAC_NONSECC_EVSYS__Pos   = 0x0    // Position of EVSYS_ field.
	PAC_NONSECC_EVSYS__Msk   = 0x1    // Bit mask of EVSYS_ field.
	PAC_NONSECC_EVSYS_       = 0x1    // Bit EVSYS_.
	PAC_NONSECC_SERCOM0__Pos = 0x1    // Position of SERCOM0_ field.
	PAC_NONSECC_SERCOM0__Msk = 0x2    // Bit mask of SERCOM0_ field.
	PAC_NONSECC_SERCOM0_     = 0x2    // Bit SERCOM0_.
	PAC_NONSECC_SERCOM1__Pos = 0x2    // Position of SERCOM1_ field.
	PAC_NONSECC_SERCOM1__Msk = 0x4    // Bit mask of SERCOM1_ field.
	PAC_NONSECC_SERCOM1_     = 0x4    // Bit SERCOM1_.
	PAC_NONSECC_SERCOM2__Pos = 0x3    // Position of SERCOM2_ field.
	PAC_NONSECC_SERCOM2__Msk = 0x8    // Bit mask of SERCOM2_ field.
	PAC_NONSECC_SERCOM2_     = 0x8    // Bit SERCOM2_.
	PAC_NONSECC_TC0__Pos     = 0x4    // Position of TC0_ field.
	PAC_NONSECC_TC0__Msk     = 0x10   // Bit mask of TC0_ field.
	PAC_NONSECC_TC0_         = 0x10   // Bit TC0_.
	PAC_NONSECC_TC1__Pos     = 0x5    // Position of TC1_ field.
	PAC_NONSECC_TC1__Msk     = 0x20   // Bit mask of TC1_ field.
	PAC_NONSECC_TC1_         = 0x20   // Bit TC1_.
	PAC_NONSECC_TC2__Pos     = 0x6    // Position of TC2_ field.
	PAC_NONSECC_TC2__Msk     = 0x40   // Bit mask of TC2_ field.
	PAC_NONSECC_TC2_         = 0x40   // Bit TC2_.
	PAC_NONSECC_ADC__Pos     = 0x7    // Position of ADC_ field.
	PAC_NONSECC_ADC__Msk     = 0x80   // Bit mask of ADC_ field.
	PAC_NONSECC_ADC_         = 0x80   // Bit ADC_.
	PAC_NONSECC_DAC__Pos     = 0x8    // Position of DAC_ field.
	PAC_NONSECC_DAC__Msk     = 0x100  // Bit mask of DAC_ field.
	PAC_NONSECC_DAC_         = 0x100  // Bit DAC_.
	PAC_NONSECC_PTC__Pos     = 0x9    // Position of PTC_ field.
	PAC_NONSECC_PTC__Msk     = 0x200  // Bit mask of PTC_ field.
	PAC_NONSECC_PTC_         = 0x200  // Bit PTC_.
	PAC_NONSECC_TRNG__Pos    = 0xa    // Position of TRNG_ field.
	PAC_NONSECC_TRNG__Msk    = 0x400  // Bit mask of TRNG_ field.
	PAC_NONSECC_TRNG_        = 0x400  // Bit TRNG_.
	PAC_NONSECC_CCL__Pos     = 0xb    // Position of CCL_ field.
	PAC_NONSECC_CCL__Msk     = 0x800  // Bit mask of CCL_ field.
	PAC_NONSECC_CCL_         = 0x800  // Bit CCL_.
	PAC_NONSECC_OPAMP__Pos   = 0xc    // Position of OPAMP_ field.
	PAC_NONSECC_OPAMP__Msk   = 0x1000 // Bit mask of OPAMP_ field.
	PAC_NONSECC_OPAMP_       = 0x1000 // Bit OPAMP_.
	PAC_NONSECC_TRAM__Pos    = 0xd    // Position of TRAM_ field.
	PAC_NONSECC_TRAM__Msk    = 0x2000 // Bit mask of TRAM_ field.
	PAC_NONSECC_TRAM_        = 0x2000 // Bit TRAM_.

	// SECLOCKA: Peripheral secure status locked - Bridge A
	PAC_SECLOCKA_PAC__Pos        = 0x0    // Position of PAC_ field.
	PAC_SECLOCKA_PAC__Msk        = 0x1    // Bit mask of PAC_ field.
	PAC_SECLOCKA_PAC_            = 0x1    // Bit PAC_.
	PAC_SECLOCKA_PM__Pos         = 0x1    // Position of PM_ field.
	PAC_SECLOCKA_PM__Msk         = 0x2    // Bit mask of PM_ field.
	PAC_SECLOCKA_PM_             = 0x2    // Bit PM_.
	PAC_SECLOCKA_MCLK__Pos       = 0x2    // Position of MCLK_ field.
	PAC_SECLOCKA_MCLK__Msk       = 0x4    // Bit mask of MCLK_ field.
	PAC_SECLOCKA_MCLK_           = 0x4    // Bit MCLK_.
	PAC_SECLOCKA_RSTC__Pos       = 0x3    // Position of RSTC_ field.
	PAC_SECLOCKA_RSTC__Msk       = 0x8    // Bit mask of RSTC_ field.
	PAC_SECLOCKA_RSTC_           = 0x8    // Bit RSTC_.
	PAC_SECLOCKA_OSCCTRL__Pos    = 0x4    // Position of OSCCTRL_ field.
	PAC_SECLOCKA_OSCCTRL__Msk    = 0x10   // Bit mask of OSCCTRL_ field.
	PAC_SECLOCKA_OSCCTRL_        = 0x10   // Bit OSCCTRL_.
	PAC_SECLOCKA_OSC32KCTRL__Pos = 0x5    // Position of OSC32KCTRL_ field.
	PAC_SECLOCKA_OSC32KCTRL__Msk = 0x20   // Bit mask of OSC32KCTRL_ field.
	PAC_SECLOCKA_OSC32KCTRL_     = 0x20   // Bit OSC32KCTRL_.
	PAC_SECLOCKA_SUPC__Pos       = 0x6    // Position of SUPC_ field.
	PAC_SECLOCKA_SUPC__Msk       = 0x40   // Bit mask of SUPC_ field.
	PAC_SECLOCKA_SUPC_           = 0x40   // Bit SUPC_.
	PAC_SECLOCKA_GCLK__Pos       = 0x7    // Position of GCLK_ field.
	PAC_SECLOCKA_GCLK__Msk       = 0x80   // Bit mask of GCLK_ field.
	PAC_SECLOCKA_GCLK_           = 0x80   // Bit GCLK_.
	PAC_SECLOCKA_WDT__Pos        = 0x8    // Position of WDT_ field.
	PAC_SECLOCKA_WDT__Msk        = 0x100  // Bit mask of WDT_ field.
	PAC_SECLOCKA_WDT_            = 0x100  // Bit WDT_.
	PAC_SECLOCKA_RTC__Pos        = 0x9    // Position of RTC_ field.
	PAC_SECLOCKA_RTC__Msk        = 0x200  // Bit mask of RTC_ field.
	PAC_SECLOCKA_RTC_            = 0x200  // Bit RTC_.
	PAC_SECLOCKA_EIC__Pos        = 0xa    // Position of EIC_ field.
	PAC_SECLOCKA_EIC__Msk        = 0x400  // Bit mask of EIC_ field.
	PAC_SECLOCKA_EIC_            = 0x400  // Bit EIC_.
	PAC_SECLOCKA_FREQM__Pos      = 0xb    // Position of FREQM_ field.
	PAC_SECLOCKA_FREQM__Msk      = 0x800  // Bit mask of FREQM_ field.
	PAC_SECLOCKA_FREQM_          = 0x800  // Bit FREQM_.
	PAC_SECLOCKA_PORT__Pos       = 0xc    // Position of PORT_ field.
	PAC_SECLOCKA_PORT__Msk       = 0x1000 // Bit mask of PORT_ field.
	PAC_SECLOCKA_PORT_           = 0x1000 // Bit PORT_.
	PAC_SECLOCKA_AC__Pos         = 0xd    // Position of AC_ field.
	PAC_SECLOCKA_AC__Msk         = 0x2000 // Bit mask of AC_ field.
	PAC_SECLOCKA_AC_             = 0x2000 // Bit AC_.

	// SECLOCKB: Peripheral secure status locked - Bridge B
	PAC_SECLOCKB_IDAU__Pos    = 0x0 // Position of IDAU_ field.
	PAC_SECLOCKB_IDAU__Msk    = 0x1 // Bit mask of IDAU_ field.
	PAC_SECLOCKB_IDAU_        = 0x1 // Bit IDAU_.
	PAC_SECLOCKB_DSU__Pos     = 0x1 // Position of DSU_ field.
	PAC_SECLOCKB_DSU__Msk     = 0x2 // Bit mask of DSU_ field.
	PAC_SECLOCKB_DSU_         = 0x2 // Bit DSU_.
	PAC_SECLOCKB_NVMCTRL__Pos = 0x2 // Position of NVMCTRL_ field.
	PAC_SECLOCKB_NVMCTRL__Msk = 0x4 // Bit mask of NVMCTRL_ field.
	PAC_SECLOCKB_NVMCTRL_     = 0x4 // Bit NVMCTRL_.
	PAC_SECLOCKB_DMAC__Pos    = 0x3 // Position of DMAC_ field.
	PAC_SECLOCKB_DMAC__Msk    = 0x8 // Bit mask of DMAC_ field.
	PAC_SECLOCKB_DMAC_        = 0x8 // Bit DMAC_.

	// SECLOCKC: Peripheral secure status locked - Bridge C
	PAC_SECLOCKC_EVSYS__Pos   = 0x0    // Position of EVSYS_ field.
	PAC_SECLOCKC_EVSYS__Msk   = 0x1    // Bit mask of EVSYS_ field.
	PAC_SECLOCKC_EVSYS_       = 0x1    // Bit EVSYS_.
	PAC_SECLOCKC_SERCOM0__Pos = 0x1    // Position of SERCOM0_ field.
	PAC_SECLOCKC_SERCOM0__Msk = 0x2    // Bit mask of SERCOM0_ field.
	PAC_SECLOCKC_SERCOM0_     = 0x2    // Bit SERCOM0_.
	PAC_SECLOCKC_SERCOM1__Pos = 0x2    // Position of SERCOM1_ field.
	PAC_SECLOCKC_SERCOM1__Msk = 0x4    // Bit mask of SERCOM1_ field.
	PAC_SECLOCKC_SERCOM1_     = 0x4    // Bit SERCOM1_.
	PAC_SECLOCKC_SERCOM2__Pos = 0x3    // Position of SERCOM2_ field.
	PAC_SECLOCKC_SERCOM2__Msk = 0x8    // Bit mask of SERCOM2_ field.
	PAC_SECLOCKC_SERCOM2_     = 0x8    // Bit SERCOM2_.
	PAC_SECLOCKC_TC0__Pos     = 0x4    // Position of TC0_ field.
	PAC_SECLOCKC_TC0__Msk     = 0x10   // Bit mask of TC0_ field.
	PAC_SECLOCKC_TC0_         = 0x10   // Bit TC0_.
	PAC_SECLOCKC_TC1__Pos     = 0x5    // Position of TC1_ field.
	PAC_SECLOCKC_TC1__Msk     = 0x20   // Bit mask of TC1_ field.
	PAC_SECLOCKC_TC1_         = 0x20   // Bit TC1_.
	PAC_SECLOCKC_TC2__Pos     = 0x6    // Position of TC2_ field.
	PAC_SECLOCKC_TC2__Msk     = 0x40   // Bit mask of TC2_ field.
	PAC_SECLOCKC_TC2_         = 0x40   // Bit TC2_.
	PAC_SECLOCKC_ADC__Pos     = 0x7    // Position of ADC_ field.
	PAC_SECLOCKC_ADC__Msk     = 0x80   // Bit mask of ADC_ field.
	PAC_SECLOCKC_ADC_         = 0x80   // Bit ADC_.
	PAC_SECLOCKC_DAC__Pos     = 0x8    // Position of DAC_ field.
	PAC_SECLOCKC_DAC__Msk     = 0x100  // Bit mask of DAC_ field.
	PAC_SECLOCKC_DAC_         = 0x100  // Bit DAC_.
	PAC_SECLOCKC_PTC__Pos     = 0x9    // Position of PTC_ field.
	PAC_SECLOCKC_PTC__Msk     = 0x200  // Bit mask of PTC_ field.
	PAC_SECLOCKC_PTC_         = 0x200  // Bit PTC_.
	PAC_SECLOCKC_TRNG__Pos    = 0xa    // Position of TRNG_ field.
	PAC_SECLOCKC_TRNG__Msk    = 0x400  // Bit mask of TRNG_ field.
	PAC_SECLOCKC_TRNG_        = 0x400  // Bit TRNG_.
	PAC_SECLOCKC_CCL__Pos     = 0xb    // Position of CCL_ field.
	PAC_SECLOCKC_CCL__Msk     = 0x800  // Bit mask of CCL_ field.
	PAC_SECLOCKC_CCL_         = 0x800  // Bit CCL_.
	PAC_SECLOCKC_OPAMP__Pos   = 0xc    // Position of OPAMP_ field.
	PAC_SECLOCKC_OPAMP__Msk   = 0x1000 // Bit mask of OPAMP_ field.
	PAC_SECLOCKC_OPAMP_       = 0x1000 // Bit OPAMP_.
	PAC_SECLOCKC_TRAM__Pos    = 0xd    // Position of TRAM_ field.
	PAC_SECLOCKC_TRAM__Msk    = 0x2000 // Bit mask of TRAM_ field.
	PAC_SECLOCKC_TRAM_        = 0x2000 // Bit TRAM_.
)

// Bitfields for PM: Power Manager
const (
	// SLEEPCFG: Sleep Configuration
	PM_SLEEPCFG_SLEEPMODE_Pos     = 0x0 // Position of SLEEPMODE field.
	PM_SLEEPCFG_SLEEPMODE_Msk     = 0x7 // Bit mask of SLEEPMODE field.
	PM_SLEEPCFG_SLEEPMODE_IDLE    = 0x2 // CPU, AHB, APB clocks are OFF
	PM_SLEEPCFG_SLEEPMODE_STANDBY = 0x4 // All Clocks are OFF
	PM_SLEEPCFG_SLEEPMODE_OFF     = 0x6 // All power domains are powered OFF

	// PLCFG: Performance Level Configuration
	PM_PLCFG_PLSEL_Pos = 0x0  // Position of PLSEL field.
	PM_PLCFG_PLSEL_Msk = 0x3  // Bit mask of PLSEL field.
	PM_PLCFG_PLSEL_PL0 = 0x0  // Performance Level 0
	PM_PLCFG_PLSEL_PL2 = 0x2  // Performance Level 2
	PM_PLCFG_PLDIS_Pos = 0x7  // Position of PLDIS field.
	PM_PLCFG_PLDIS_Msk = 0x80 // Bit mask of PLDIS field.
	PM_PLCFG_PLDIS     = 0x80 // Bit PLDIS.

	// PWCFG: Power Configuration
	PM_PWCFG_RAMPSWC_Pos  = 0x0 // Position of RAMPSWC field.
	PM_PWCFG_RAMPSWC_Msk  = 0x3 // Bit mask of RAMPSWC field.
	PM_PWCFG_RAMPSWC_16KB = 0x0 // 16KB Available
	PM_PWCFG_RAMPSWC_12KB = 0x1 // 12KB Available
	PM_PWCFG_RAMPSWC_8KB  = 0x2 // 8KB Available
	PM_PWCFG_RAMPSWC_4KB  = 0x3 // 4KB Available

	// INTENCLR: Interrupt Enable Clear
	PM_INTENCLR_PLRDY_Pos = 0x0 // Position of PLRDY field.
	PM_INTENCLR_PLRDY_Msk = 0x1 // Bit mask of PLRDY field.
	PM_INTENCLR_PLRDY     = 0x1 // Bit PLRDY.

	// INTENSET: Interrupt Enable Set
	PM_INTENSET_PLRDY_Pos = 0x0 // Position of PLRDY field.
	PM_INTENSET_PLRDY_Msk = 0x1 // Bit mask of PLRDY field.
	PM_INTENSET_PLRDY     = 0x1 // Bit PLRDY.

	// INTFLAG: Interrupt Flag Status and Clear
	PM_INTFLAG_PLRDY_Pos = 0x0 // Position of PLRDY field.
	PM_INTFLAG_PLRDY_Msk = 0x1 // Bit mask of PLRDY field.
	PM_INTFLAG_PLRDY     = 0x1 // Bit PLRDY.

	// STDBYCFG: Standby Configuration
	PM_STDBYCFG_PDCFG_Pos            = 0x0    // Position of PDCFG field.
	PM_STDBYCFG_PDCFG_Msk            = 0x1    // Bit mask of PDCFG field.
	PM_STDBYCFG_PDCFG                = 0x1    // Bit PDCFG.
	PM_STDBYCFG_PDCFG_DEFAULT        = 0x0    // PDSW power domain switching is handled by hardware.
	PM_STDBYCFG_PDCFG_PDSW           = 0x1    // PDSW is forced ACTIVE.
	PM_STDBYCFG_DPGPDSW_Pos          = 0x4    // Position of DPGPDSW field.
	PM_STDBYCFG_DPGPDSW_Msk          = 0x10   // Bit mask of DPGPDSW field.
	PM_STDBYCFG_DPGPDSW              = 0x10   // Bit DPGPDSW.
	PM_STDBYCFG_DPGPDSW_0            = 0x0    // Dynamic Power Gating disabled
	PM_STDBYCFG_DPGPDSW_1            = 0x1    // Dynamic Power Gating enabled
	PM_STDBYCFG_VREGSMOD_Pos         = 0x6    // Position of VREGSMOD field.
	PM_STDBYCFG_VREGSMOD_Msk         = 0xc0   // Bit mask of VREGSMOD field.
	PM_STDBYCFG_VREGSMOD_AUTO        = 0x0    // Automatic mode
	PM_STDBYCFG_VREGSMOD_PERFORMANCE = 0x1    // Performance oriented
	PM_STDBYCFG_VREGSMOD_LP          = 0x2    // Low Power oriented
	PM_STDBYCFG_BBIASHS_Pos          = 0xa    // Position of BBIASHS field.
	PM_STDBYCFG_BBIASHS_Msk          = 0x400  // Bit mask of BBIASHS field.
	PM_STDBYCFG_BBIASHS              = 0x400  // Bit BBIASHS.
	PM_STDBYCFG_BBIASTR_Pos          = 0xc    // Position of BBIASTR field.
	PM_STDBYCFG_BBIASTR_Msk          = 0x1000 // Bit mask of BBIASTR field.
	PM_STDBYCFG_BBIASTR              = 0x1000 // Bit BBIASTR.
)

// Bitfields for PORT: Port Module
const (
	// GROUP.DIR: Data Direction
	PORT_GROUP_DIR_DIR_Pos = 0x0        // Position of DIR field.
	PORT_GROUP_DIR_DIR_Msk = 0xffffffff // Bit mask of DIR field.

	// GROUP.DIRCLR: Data Direction Clear
	PORT_GROUP_DIRCLR_DIRCLR_Pos = 0x0        // Position of DIRCLR field.
	PORT_GROUP_DIRCLR_DIRCLR_Msk = 0xffffffff // Bit mask of DIRCLR field.

	// GROUP.DIRSET: Data Direction Set
	PORT_GROUP_DIRSET_DIRSET_Pos = 0x0        // Position of DIRSET field.
	PORT_GROUP_DIRSET_DIRSET_Msk = 0xffffffff // Bit mask of DIRSET field.

	// GROUP.DIRTGL: Data Direction Toggle
	PORT_GROUP_DIRTGL_DIRTGL_Pos = 0x0        // Position of DIRTGL field.
	PORT_GROUP_DIRTGL_DIRTGL_Msk = 0xffffffff // Bit mask of DIRTGL field.

	// GROUP.OUT: Data Output Value
	PORT_GROUP_OUT_OUT_Pos = 0x0        // Position of OUT field.
	PORT_GROUP_OUT_OUT_Msk = 0xffffffff // Bit mask of OUT field.

	// GROUP.OUTCLR: Data Output Value Clear
	PORT_GROUP_OUTCLR_OUTCLR_Pos = 0x0        // Position of OUTCLR field.
	PORT_GROUP_OUTCLR_OUTCLR_Msk = 0xffffffff // Bit mask of OUTCLR field.

	// GROUP.OUTSET: Data Output Value Set
	PORT_GROUP_OUTSET_OUTSET_Pos = 0x0        // Position of OUTSET field.
	PORT_GROUP_OUTSET_OUTSET_Msk = 0xffffffff // Bit mask of OUTSET field.

	// GROUP.OUTTGL: Data Output Value Toggle
	PORT_GROUP_OUTTGL_OUTTGL_Pos = 0x0        // Position of OUTTGL field.
	PORT_GROUP_OUTTGL_OUTTGL_Msk = 0xffffffff // Bit mask of OUTTGL field.

	// GROUP.IN: Data Input Value
	PORT_GROUP_IN_IN_Pos = 0x0        // Position of IN field.
	PORT_GROUP_IN_IN_Msk = 0xffffffff // Bit mask of IN field.

	// GROUP.CTRL: Control
	PORT_GROUP_CTRL_SAMPLING_Pos = 0x0        // Position of SAMPLING field.
	PORT_GROUP_CTRL_SAMPLING_Msk = 0xffffffff // Bit mask of SAMPLING field.

	// GROUP.WRCONFIG: Write Configuration
	PORT_GROUP_WRCONFIG_PINMASK_Pos  = 0x0        // Position of PINMASK field.
	PORT_GROUP_WRCONFIG_PINMASK_Msk  = 0xffff     // Bit mask of PINMASK field.
	PORT_GROUP_WRCONFIG_PMUXEN_Pos   = 0x10       // Position of PMUXEN field.
	PORT_GROUP_WRCONFIG_PMUXEN_Msk   = 0x10000    // Bit mask of PMUXEN field.
	PORT_GROUP_WRCONFIG_PMUXEN       = 0x10000    // Bit PMUXEN.
	PORT_GROUP_WRCONFIG_INEN_Pos     = 0x11       // Position of INEN field.
	PORT_GROUP_WRCONFIG_INEN_Msk     = 0x20000    // Bit mask of INEN field.
	PORT_GROUP_WRCONFIG_INEN         = 0x20000    // Bit INEN.
	PORT_GROUP_WRCONFIG_PULLEN_Pos   = 0x12       // Position of PULLEN field.
	PORT_GROUP_WRCONFIG_PULLEN_Msk   = 0x40000    // Bit mask of PULLEN field.
	PORT_GROUP_WRCONFIG_PULLEN       = 0x40000    // Bit PULLEN.
	PORT_GROUP_WRCONFIG_DRVSTR_Pos   = 0x16       // Position of DRVSTR field.
	PORT_GROUP_WRCONFIG_DRVSTR_Msk   = 0x400000   // Bit mask of DRVSTR field.
	PORT_GROUP_WRCONFIG_DRVSTR       = 0x400000   // Bit DRVSTR.
	PORT_GROUP_WRCONFIG_PMUX_Pos     = 0x18       // Position of PMUX field.
	PORT_GROUP_WRCONFIG_PMUX_Msk     = 0xf000000  // Bit mask of PMUX field.
	PORT_GROUP_WRCONFIG_WRPMUX_Pos   = 0x1c       // Position of WRPMUX field.
	PORT_GROUP_WRCONFIG_WRPMUX_Msk   = 0x10000000 // Bit mask of WRPMUX field.
	PORT_GROUP_WRCONFIG_WRPMUX       = 0x10000000 // Bit WRPMUX.
	PORT_GROUP_WRCONFIG_WRPINCFG_Pos = 0x1e       // Position of WRPINCFG field.
	PORT_GROUP_WRCONFIG_WRPINCFG_Msk = 0x40000000 // Bit mask of WRPINCFG field.
	PORT_GROUP_WRCONFIG_WRPINCFG     = 0x40000000 // Bit WRPINCFG.
	PORT_GROUP_WRCONFIG_HWSEL_Pos    = 0x1f       // Position of HWSEL field.
	PORT_GROUP_WRCONFIG_HWSEL_Msk    = 0x80000000 // Bit mask of HWSEL field.
	PORT_GROUP_WRCONFIG_HWSEL        = 0x80000000 // Bit HWSEL.

	// GROUP.EVCTRL: Event Input Control
	PORT_GROUP_EVCTRL_PID0_Pos    = 0x0        // Position of PID0 field.
	PORT_GROUP_EVCTRL_PID0_Msk    = 0x1f       // Bit mask of PID0 field.
	PORT_GROUP_EVCTRL_EVACT0_Pos  = 0x5        // Position of EVACT0 field.
	PORT_GROUP_EVCTRL_EVACT0_Msk  = 0x60       // Bit mask of EVACT0 field.
	PORT_GROUP_EVCTRL_EVACT0_OUT  = 0x0        // Event output to pin
	PORT_GROUP_EVCTRL_EVACT0_SET  = 0x1        // Set output register of pin on event
	PORT_GROUP_EVCTRL_EVACT0_CLR  = 0x2        // Clear output register of pin on event
	PORT_GROUP_EVCTRL_EVACT0_TGL  = 0x3        // Toggle output register of pin on event
	PORT_GROUP_EVCTRL_PORTEI0_Pos = 0x7        // Position of PORTEI0 field.
	PORT_GROUP_EVCTRL_PORTEI0_Msk = 0x80       // Bit mask of PORTEI0 field.
	PORT_GROUP_EVCTRL_PORTEI0     = 0x80       // Bit PORTEI0.
	PORT_GROUP_EVCTRL_PID1_Pos    = 0x8        // Position of PID1 field.
	PORT_GROUP_EVCTRL_PID1_Msk    = 0x1f00     // Bit mask of PID1 field.
	PORT_GROUP_EVCTRL_EVACT1_Pos  = 0xd        // Position of EVACT1 field.
	PORT_GROUP_EVCTRL_EVACT1_Msk  = 0x6000     // Bit mask of EVACT1 field.
	PORT_GROUP_EVCTRL_PORTEI1_Pos = 0xf        // Position of PORTEI1 field.
	PORT_GROUP_EVCTRL_PORTEI1_Msk = 0x8000     // Bit mask of PORTEI1 field.
	PORT_GROUP_EVCTRL_PORTEI1     = 0x8000     // Bit PORTEI1.
	PORT_GROUP_EVCTRL_PID2_Pos    = 0x10       // Position of PID2 field.
	PORT_GROUP_EVCTRL_PID2_Msk    = 0x1f0000   // Bit mask of PID2 field.
	PORT_GROUP_EVCTRL_EVACT2_Pos  = 0x15       // Position of EVACT2 field.
	PORT_GROUP_EVCTRL_EVACT2_Msk  = 0x600000   // Bit mask of EVACT2 field.
	PORT_GROUP_EVCTRL_PORTEI2_Pos = 0x17       // Position of PORTEI2 field.
	PORT_GROUP_EVCTRL_PORTEI2_Msk = 0x800000   // Bit mask of PORTEI2 field.
	PORT_GROUP_EVCTRL_PORTEI2     = 0x800000   // Bit PORTEI2.
	PORT_GROUP_EVCTRL_PID3_Pos    = 0x18       // Position of PID3 field.
	PORT_GROUP_EVCTRL_PID3_Msk    = 0x1f000000 // Bit mask of PID3 field.
	PORT_GROUP_EVCTRL_EVACT3_Pos  = 0x1d       // Position of EVACT3 field.
	PORT_GROUP_EVCTRL_EVACT3_Msk  = 0x60000000 // Bit mask of EVACT3 field.
	PORT_GROUP_EVCTRL_PORTEI3_Pos = 0x1f       // Position of PORTEI3 field.
	PORT_GROUP_EVCTRL_PORTEI3_Msk = 0x80000000 // Bit mask of PORTEI3 field.
	PORT_GROUP_EVCTRL_PORTEI3     = 0x80000000 // Bit PORTEI3.

	// GROUP.PMUX: Peripheral Multiplexing
	PORT_GROUP_PMUX_PMUXE_Pos = 0x0  // Position of PMUXE field.
	PORT_GROUP_PMUX_PMUXE_Msk = 0xf  // Bit mask of PMUXE field.
	PORT_GROUP_PMUX_PMUXO_Pos = 0x4  // Position of PMUXO field.
	PORT_GROUP_PMUX_PMUXO_Msk = 0xf0 // Bit mask of PMUXO field.

	// GROUP.PINCFG: Pin Configuration
	PORT_GROUP_PINCFG_PMUXEN_Pos = 0x0  // Position of PMUXEN field.
	PORT_GROUP_PINCFG_PMUXEN_Msk = 0x1  // Bit mask of PMUXEN field.
	PORT_GROUP_PINCFG_PMUXEN     = 0x1  // Bit PMUXEN.
	PORT_GROUP_PINCFG_INEN_Pos   = 0x1  // Position of INEN field.
	PORT_GROUP_PINCFG_INEN_Msk   = 0x2  // Bit mask of INEN field.
	PORT_GROUP_PINCFG_INEN       = 0x2  // Bit INEN.
	PORT_GROUP_PINCFG_PULLEN_Pos = 0x2  // Position of PULLEN field.
	PORT_GROUP_PINCFG_PULLEN_Msk = 0x4  // Bit mask of PULLEN field.
	PORT_GROUP_PINCFG_PULLEN     = 0x4  // Bit PULLEN.
	PORT_GROUP_PINCFG_DRVSTR_Pos = 0x6  // Position of DRVSTR field.
	PORT_GROUP_PINCFG_DRVSTR_Msk = 0x40 // Bit mask of DRVSTR field.
	PORT_GROUP_PINCFG_DRVSTR     = 0x40 // Bit DRVSTR.

	// GROUP.INTENCLR: Interrupt Enable Clear
	PORT_GROUP_INTENCLR_NSCHK_Pos = 0x0 // Position of NSCHK field.
	PORT_GROUP_INTENCLR_NSCHK_Msk = 0x1 // Bit mask of NSCHK field.
	PORT_GROUP_INTENCLR_NSCHK     = 0x1 // Bit NSCHK.

	// GROUP.INTENSET: Interrupt Enable Set
	PORT_GROUP_INTENSET_NSCHK_Pos = 0x0 // Position of NSCHK field.
	PORT_GROUP_INTENSET_NSCHK_Msk = 0x1 // Bit mask of NSCHK field.
	PORT_GROUP_INTENSET_NSCHK     = 0x1 // Bit NSCHK.

	// GROUP.INTFLAG: Interrupt Flag Status and Clear
	PORT_GROUP_INTFLAG_NSCHK_Pos = 0x0 // Position of NSCHK field.
	PORT_GROUP_INTFLAG_NSCHK_Msk = 0x1 // Bit mask of NSCHK field.
	PORT_GROUP_INTFLAG_NSCHK     = 0x1 // Bit NSCHK.

	// GROUP.NONSEC: Security Attribution
	PORT_GROUP_NONSEC_NONSEC_Pos = 0x0        // Position of NONSEC field.
	PORT_GROUP_NONSEC_NONSEC_Msk = 0xffffffff // Bit mask of NONSEC field.

	// GROUP.NSCHK: Security Attribution Check
	PORT_GROUP_NSCHK_NSCHK_Pos = 0x0        // Position of NSCHK field.
	PORT_GROUP_NSCHK_NSCHK_Msk = 0xffffffff // Bit mask of NSCHK field.
)

// Bitfields for PTC: Peripheral Touch Controller
const ()

// Bitfields for RSTC: Reset Controller
const (
	// RCAUSE: Reset Cause
	RSTC_RCAUSE_POR_Pos     = 0x0  // Position of POR field.
	RSTC_RCAUSE_POR_Msk     = 0x1  // Bit mask of POR field.
	RSTC_RCAUSE_POR         = 0x1  // Bit POR.
	RSTC_RCAUSE_BODCORE_Pos = 0x1  // Position of BODCORE field.
	RSTC_RCAUSE_BODCORE_Msk = 0x2  // Bit mask of BODCORE field.
	RSTC_RCAUSE_BODCORE     = 0x2  // Bit BODCORE.
	RSTC_RCAUSE_BODVDD_Pos  = 0x2  // Position of BODVDD field.
	RSTC_RCAUSE_BODVDD_Msk  = 0x4  // Bit mask of BODVDD field.
	RSTC_RCAUSE_BODVDD      = 0x4  // Bit BODVDD.
	RSTC_RCAUSE_EXT_Pos     = 0x4  // Position of EXT field.
	RSTC_RCAUSE_EXT_Msk     = 0x10 // Bit mask of EXT field.
	RSTC_RCAUSE_EXT         = 0x10 // Bit EXT.
	RSTC_RCAUSE_WDT_Pos     = 0x5  // Position of WDT field.
	RSTC_RCAUSE_WDT_Msk     = 0x20 // Bit mask of WDT field.
	RSTC_RCAUSE_WDT         = 0x20 // Bit WDT.
	RSTC_RCAUSE_SYST_Pos    = 0x6  // Position of SYST field.
	RSTC_RCAUSE_SYST_Msk    = 0x40 // Bit mask of SYST field.
	RSTC_RCAUSE_SYST        = 0x40 // Bit SYST.
)

// Bitfields for RTC: Real-Time Counter
const ()

// Bitfields for RTC_MODE0: Real-Time Counter - MODE0
const (
	// CTRLA: MODE0 Control A
	RTC_MODE0_CTRLA_SWRST_Pos         = 0x0    // Position of SWRST field.
	RTC_MODE0_CTRLA_SWRST_Msk         = 0x1    // Bit mask of SWRST field.
	RTC_MODE0_CTRLA_SWRST             = 0x1    // Bit SWRST.
	RTC_MODE0_CTRLA_ENABLE_Pos        = 0x1    // Position of ENABLE field.
	RTC_MODE0_CTRLA_ENABLE_Msk        = 0x2    // Bit mask of ENABLE field.
	RTC_MODE0_CTRLA_ENABLE            = 0x2    // Bit ENABLE.
	RTC_MODE0_CTRLA_MODE_Pos          = 0x2    // Position of MODE field.
	RTC_MODE0_CTRLA_MODE_Msk          = 0xc    // Bit mask of MODE field.
	RTC_MODE0_CTRLA_MODE_COUNT32      = 0x0    // Mode 0: 32-bit Counter
	RTC_MODE0_CTRLA_MODE_COUNT16      = 0x1    // Mode 1: 16-bit Counter
	RTC_MODE0_CTRLA_MODE_CLOCK        = 0x2    // Mode 2: Clock/Calendar
	RTC_MODE0_CTRLA_MATCHCLR_Pos      = 0x7    // Position of MATCHCLR field.
	RTC_MODE0_CTRLA_MATCHCLR_Msk      = 0x80   // Bit mask of MATCHCLR field.
	RTC_MODE0_CTRLA_MATCHCLR          = 0x80   // Bit MATCHCLR.
	RTC_MODE0_CTRLA_PRESCALER_Pos     = 0x8    // Position of PRESCALER field.
	RTC_MODE0_CTRLA_PRESCALER_Msk     = 0xf00  // Bit mask of PRESCALER field.
	RTC_MODE0_CTRLA_PRESCALER_OFF     = 0x0    // CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE0_CTRLA_PRESCALER_DIV1    = 0x1    // CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE0_CTRLA_PRESCALER_DIV2    = 0x2    // CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE0_CTRLA_PRESCALER_DIV4    = 0x3    // CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE0_CTRLA_PRESCALER_DIV8    = 0x4    // CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE0_CTRLA_PRESCALER_DIV16   = 0x5    // CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE0_CTRLA_PRESCALER_DIV32   = 0x6    // CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE0_CTRLA_PRESCALER_DIV64   = 0x7    // CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE0_CTRLA_PRESCALER_DIV128  = 0x8    // CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE0_CTRLA_PRESCALER_DIV256  = 0x9    // CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE0_CTRLA_PRESCALER_DIV512  = 0xa    // CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE0_CTRLA_PRESCALER_DIV1024 = 0xb    // CLK_RTC_CNT = GCLK_RTC/1024
	RTC_MODE0_CTRLA_GPTRST_Pos        = 0xe    // Position of GPTRST field.
	RTC_MODE0_CTRLA_GPTRST_Msk        = 0x4000 // Bit mask of GPTRST field.
	RTC_MODE0_CTRLA_GPTRST            = 0x4000 // Bit GPTRST.
	RTC_MODE0_CTRLA_COUNTSYNC_Pos     = 0xf    // Position of COUNTSYNC field.
	RTC_MODE0_CTRLA_COUNTSYNC_Msk     = 0x8000 // Bit mask of COUNTSYNC field.
	RTC_MODE0_CTRLA_COUNTSYNC         = 0x8000 // Bit COUNTSYNC.

	// CTRLB: MODE0 Control B
	RTC_MODE0_CTRLB_GP0EN_Pos    = 0x0    // Position of GP0EN field.
	RTC_MODE0_CTRLB_GP0EN_Msk    = 0x1    // Bit mask of GP0EN field.
	RTC_MODE0_CTRLB_GP0EN        = 0x1    // Bit GP0EN.
	RTC_MODE0_CTRLB_DEBMAJ_Pos   = 0x4    // Position of DEBMAJ field.
	RTC_MODE0_CTRLB_DEBMAJ_Msk   = 0x10   // Bit mask of DEBMAJ field.
	RTC_MODE0_CTRLB_DEBMAJ       = 0x10   // Bit DEBMAJ.
	RTC_MODE0_CTRLB_DEBASYNC_Pos = 0x5    // Position of DEBASYNC field.
	RTC_MODE0_CTRLB_DEBASYNC_Msk = 0x20   // Bit mask of DEBASYNC field.
	RTC_MODE0_CTRLB_DEBASYNC     = 0x20   // Bit DEBASYNC.
	RTC_MODE0_CTRLB_RTCOUT_Pos   = 0x6    // Position of RTCOUT field.
	RTC_MODE0_CTRLB_RTCOUT_Msk   = 0x40   // Bit mask of RTCOUT field.
	RTC_MODE0_CTRLB_RTCOUT       = 0x40   // Bit RTCOUT.
	RTC_MODE0_CTRLB_DMAEN_Pos    = 0x7    // Position of DMAEN field.
	RTC_MODE0_CTRLB_DMAEN_Msk    = 0x80   // Bit mask of DMAEN field.
	RTC_MODE0_CTRLB_DMAEN        = 0x80   // Bit DMAEN.
	RTC_MODE0_CTRLB_DEBF_Pos     = 0x8    // Position of DEBF field.
	RTC_MODE0_CTRLB_DEBF_Msk     = 0x700  // Bit mask of DEBF field.
	RTC_MODE0_CTRLB_DEBF_DIV2    = 0x0    // CLK_RTC_DEB = CLK_RTC/2
	RTC_MODE0_CTRLB_DEBF_DIV4    = 0x1    // CLK_RTC_DEB = CLK_RTC/4
	RTC_MODE0_CTRLB_DEBF_DIV8    = 0x2    // CLK_RTC_DEB = CLK_RTC/8
	RTC_MODE0_CTRLB_DEBF_DIV16   = 0x3    // CLK_RTC_DEB = CLK_RTC/16
	RTC_MODE0_CTRLB_DEBF_DIV32   = 0x4    // CLK_RTC_DEB = CLK_RTC/32
	RTC_MODE0_CTRLB_DEBF_DIV64   = 0x5    // CLK_RTC_DEB = CLK_RTC/64
	RTC_MODE0_CTRLB_DEBF_DIV128  = 0x6    // CLK_RTC_DEB = CLK_RTC/128
	RTC_MODE0_CTRLB_DEBF_DIV256  = 0x7    // CLK_RTC_DEB = CLK_RTC/256
	RTC_MODE0_CTRLB_ACTF_Pos     = 0xc    // Position of ACTF field.
	RTC_MODE0_CTRLB_ACTF_Msk     = 0x7000 // Bit mask of ACTF field.
	RTC_MODE0_CTRLB_ACTF_DIV2    = 0x0    // CLK_RTC_OUT = CLK_RTC/2
	RTC_MODE0_CTRLB_ACTF_DIV4    = 0x1    // CLK_RTC_OUT = CLK_RTC/4
	RTC_MODE0_CTRLB_ACTF_DIV8    = 0x2    // CLK_RTC_OUT = CLK_RTC/8
	RTC_MODE0_CTRLB_ACTF_DIV16   = 0x3    // CLK_RTC_OUT = CLK_RTC/16
	RTC_MODE0_CTRLB_ACTF_DIV32   = 0x4    // CLK_RTC_OUT = CLK_RTC/32
	RTC_MODE0_CTRLB_ACTF_DIV64   = 0x5    // CLK_RTC_OUT = CLK_RTC/64
	RTC_MODE0_CTRLB_ACTF_DIV128  = 0x6    // CLK_RTC_OUT = CLK_RTC/128
	RTC_MODE0_CTRLB_ACTF_DIV256  = 0x7    // CLK_RTC_OUT = CLK_RTC/256
	RTC_MODE0_CTRLB_SEPTO_Pos    = 0xf    // Position of SEPTO field.
	RTC_MODE0_CTRLB_SEPTO_Msk    = 0x8000 // Bit mask of SEPTO field.
	RTC_MODE0_CTRLB_SEPTO        = 0x8000 // Bit SEPTO.

	// EVCTRL: MODE0 Event Control
	RTC_MODE0_EVCTRL_PEREO0_Pos   = 0x0       // Position of PEREO0 field.
	RTC_MODE0_EVCTRL_PEREO0_Msk   = 0x1       // Bit mask of PEREO0 field.
	RTC_MODE0_EVCTRL_PEREO0       = 0x1       // Bit PEREO0.
	RTC_MODE0_EVCTRL_PEREO1_Pos   = 0x1       // Position of PEREO1 field.
	RTC_MODE0_EVCTRL_PEREO1_Msk   = 0x2       // Bit mask of PEREO1 field.
	RTC_MODE0_EVCTRL_PEREO1       = 0x2       // Bit PEREO1.
	RTC_MODE0_EVCTRL_PEREO2_Pos   = 0x2       // Position of PEREO2 field.
	RTC_MODE0_EVCTRL_PEREO2_Msk   = 0x4       // Bit mask of PEREO2 field.
	RTC_MODE0_EVCTRL_PEREO2       = 0x4       // Bit PEREO2.
	RTC_MODE0_EVCTRL_PEREO3_Pos   = 0x3       // Position of PEREO3 field.
	RTC_MODE0_EVCTRL_PEREO3_Msk   = 0x8       // Bit mask of PEREO3 field.
	RTC_MODE0_EVCTRL_PEREO3       = 0x8       // Bit PEREO3.
	RTC_MODE0_EVCTRL_PEREO4_Pos   = 0x4       // Position of PEREO4 field.
	RTC_MODE0_EVCTRL_PEREO4_Msk   = 0x10      // Bit mask of PEREO4 field.
	RTC_MODE0_EVCTRL_PEREO4       = 0x10      // Bit PEREO4.
	RTC_MODE0_EVCTRL_PEREO5_Pos   = 0x5       // Position of PEREO5 field.
	RTC_MODE0_EVCTRL_PEREO5_Msk   = 0x20      // Bit mask of PEREO5 field.
	RTC_MODE0_EVCTRL_PEREO5       = 0x20      // Bit PEREO5.
	RTC_MODE0_EVCTRL_PEREO6_Pos   = 0x6       // Position of PEREO6 field.
	RTC_MODE0_EVCTRL_PEREO6_Msk   = 0x40      // Bit mask of PEREO6 field.
	RTC_MODE0_EVCTRL_PEREO6       = 0x40      // Bit PEREO6.
	RTC_MODE0_EVCTRL_PEREO7_Pos   = 0x7       // Position of PEREO7 field.
	RTC_MODE0_EVCTRL_PEREO7_Msk   = 0x80      // Bit mask of PEREO7 field.
	RTC_MODE0_EVCTRL_PEREO7       = 0x80      // Bit PEREO7.
	RTC_MODE0_EVCTRL_CMPEO0_Pos   = 0x8       // Position of CMPEO0 field.
	RTC_MODE0_EVCTRL_CMPEO0_Msk   = 0x100     // Bit mask of CMPEO0 field.
	RTC_MODE0_EVCTRL_CMPEO0       = 0x100     // Bit CMPEO0.
	RTC_MODE0_EVCTRL_TAMPEREO_Pos = 0xe       // Position of TAMPEREO field.
	RTC_MODE0_EVCTRL_TAMPEREO_Msk = 0x4000    // Bit mask of TAMPEREO field.
	RTC_MODE0_EVCTRL_TAMPEREO     = 0x4000    // Bit TAMPEREO.
	RTC_MODE0_EVCTRL_OVFEO_Pos    = 0xf       // Position of OVFEO field.
	RTC_MODE0_EVCTRL_OVFEO_Msk    = 0x8000    // Bit mask of OVFEO field.
	RTC_MODE0_EVCTRL_OVFEO        = 0x8000    // Bit OVFEO.
	RTC_MODE0_EVCTRL_TAMPEVEI_Pos = 0x10      // Position of TAMPEVEI field.
	RTC_MODE0_EVCTRL_TAMPEVEI_Msk = 0x10000   // Bit mask of TAMPEVEI field.
	RTC_MODE0_EVCTRL_TAMPEVEI     = 0x10000   // Bit TAMPEVEI.
	RTC_MODE0_EVCTRL_PERDEO_Pos   = 0x18      // Position of PERDEO field.
	RTC_MODE0_EVCTRL_PERDEO_Msk   = 0x1000000 // Bit mask of PERDEO field.
	RTC_MODE0_EVCTRL_PERDEO       = 0x1000000 // Bit PERDEO.

	// INTENCLR: MODE0 Interrupt Enable Clear
	RTC_MODE0_INTENCLR_PER0_Pos   = 0x0    // Position of PER0 field.
	RTC_MODE0_INTENCLR_PER0_Msk   = 0x1    // Bit mask of PER0 field.
	RTC_MODE0_INTENCLR_PER0       = 0x1    // Bit PER0.
	RTC_MODE0_INTENCLR_PER1_Pos   = 0x1    // Position of PER1 field.
	RTC_MODE0_INTENCLR_PER1_Msk   = 0x2    // Bit mask of PER1 field.
	RTC_MODE0_INTENCLR_PER1       = 0x2    // Bit PER1.
	RTC_MODE0_INTENCLR_PER2_Pos   = 0x2    // Position of PER2 field.
	RTC_MODE0_INTENCLR_PER2_Msk   = 0x4    // Bit mask of PER2 field.
	RTC_MODE0_INTENCLR_PER2       = 0x4    // Bit PER2.
	RTC_MODE0_INTENCLR_PER3_Pos   = 0x3    // Position of PER3 field.
	RTC_MODE0_INTENCLR_PER3_Msk   = 0x8    // Bit mask of PER3 field.
	RTC_MODE0_INTENCLR_PER3       = 0x8    // Bit PER3.
	RTC_MODE0_INTENCLR_PER4_Pos   = 0x4    // Position of PER4 field.
	RTC_MODE0_INTENCLR_PER4_Msk   = 0x10   // Bit mask of PER4 field.
	RTC_MODE0_INTENCLR_PER4       = 0x10   // Bit PER4.
	RTC_MODE0_INTENCLR_PER5_Pos   = 0x5    // Position of PER5 field.
	RTC_MODE0_INTENCLR_PER5_Msk   = 0x20   // Bit mask of PER5 field.
	RTC_MODE0_INTENCLR_PER5       = 0x20   // Bit PER5.
	RTC_MODE0_INTENCLR_PER6_Pos   = 0x6    // Position of PER6 field.
	RTC_MODE0_INTENCLR_PER6_Msk   = 0x40   // Bit mask of PER6 field.
	RTC_MODE0_INTENCLR_PER6       = 0x40   // Bit PER6.
	RTC_MODE0_INTENCLR_PER7_Pos   = 0x7    // Position of PER7 field.
	RTC_MODE0_INTENCLR_PER7_Msk   = 0x80   // Bit mask of PER7 field.
	RTC_MODE0_INTENCLR_PER7       = 0x80   // Bit PER7.
	RTC_MODE0_INTENCLR_CMP0_Pos   = 0x8    // Position of CMP0 field.
	RTC_MODE0_INTENCLR_CMP0_Msk   = 0x100  // Bit mask of CMP0 field.
	RTC_MODE0_INTENCLR_CMP0       = 0x100  // Bit CMP0.
	RTC_MODE0_INTENCLR_TAMPER_Pos = 0xe    // Position of TAMPER field.
	RTC_MODE0_INTENCLR_TAMPER_Msk = 0x4000 // Bit mask of TAMPER field.
	RTC_MODE0_INTENCLR_TAMPER     = 0x4000 // Bit TAMPER.
	RTC_MODE0_INTENCLR_OVF_Pos    = 0xf    // Position of OVF field.
	RTC_MODE0_INTENCLR_OVF_Msk    = 0x8000 // Bit mask of OVF field.
	RTC_MODE0_INTENCLR_OVF        = 0x8000 // Bit OVF.

	// INTENSET: MODE0 Interrupt Enable Set
	RTC_MODE0_INTENSET_PER0_Pos   = 0x0    // Position of PER0 field.
	RTC_MODE0_INTENSET_PER0_Msk   = 0x1    // Bit mask of PER0 field.
	RTC_MODE0_INTENSET_PER0       = 0x1    // Bit PER0.
	RTC_MODE0_INTENSET_PER1_Pos   = 0x1    // Position of PER1 field.
	RTC_MODE0_INTENSET_PER1_Msk   = 0x2    // Bit mask of PER1 field.
	RTC_MODE0_INTENSET_PER1       = 0x2    // Bit PER1.
	RTC_MODE0_INTENSET_PER2_Pos   = 0x2    // Position of PER2 field.
	RTC_MODE0_INTENSET_PER2_Msk   = 0x4    // Bit mask of PER2 field.
	RTC_MODE0_INTENSET_PER2       = 0x4    // Bit PER2.
	RTC_MODE0_INTENSET_PER3_Pos   = 0x3    // Position of PER3 field.
	RTC_MODE0_INTENSET_PER3_Msk   = 0x8    // Bit mask of PER3 field.
	RTC_MODE0_INTENSET_PER3       = 0x8    // Bit PER3.
	RTC_MODE0_INTENSET_PER4_Pos   = 0x4    // Position of PER4 field.
	RTC_MODE0_INTENSET_PER4_Msk   = 0x10   // Bit mask of PER4 field.
	RTC_MODE0_INTENSET_PER4       = 0x10   // Bit PER4.
	RTC_MODE0_INTENSET_PER5_Pos   = 0x5    // Position of PER5 field.
	RTC_MODE0_INTENSET_PER5_Msk   = 0x20   // Bit mask of PER5 field.
	RTC_MODE0_INTENSET_PER5       = 0x20   // Bit PER5.
	RTC_MODE0_INTENSET_PER6_Pos   = 0x6    // Position of PER6 field.
	RTC_MODE0_INTENSET_PER6_Msk   = 0x40   // Bit mask of PER6 field.
	RTC_MODE0_INTENSET_PER6       = 0x40   // Bit PER6.
	RTC_MODE0_INTENSET_PER7_Pos   = 0x7    // Position of PER7 field.
	RTC_MODE0_INTENSET_PER7_Msk   = 0x80   // Bit mask of PER7 field.
	RTC_MODE0_INTENSET_PER7       = 0x80   // Bit PER7.
	RTC_MODE0_INTENSET_CMP0_Pos   = 0x8    // Position of CMP0 field.
	RTC_MODE0_INTENSET_CMP0_Msk   = 0x100  // Bit mask of CMP0 field.
	RTC_MODE0_INTENSET_CMP0       = 0x100  // Bit CMP0.
	RTC_MODE0_INTENSET_TAMPER_Pos = 0xe    // Position of TAMPER field.
	RTC_MODE0_INTENSET_TAMPER_Msk = 0x4000 // Bit mask of TAMPER field.
	RTC_MODE0_INTENSET_TAMPER     = 0x4000 // Bit TAMPER.
	RTC_MODE0_INTENSET_OVF_Pos    = 0xf    // Position of OVF field.
	RTC_MODE0_INTENSET_OVF_Msk    = 0x8000 // Bit mask of OVF field.
	RTC_MODE0_INTENSET_OVF        = 0x8000 // Bit OVF.

	// INTFLAG: MODE0 Interrupt Flag Status and Clear
	RTC_MODE0_INTFLAG_PER0_Pos   = 0x0    // Position of PER0 field.
	RTC_MODE0_INTFLAG_PER0_Msk   = 0x1    // Bit mask of PER0 field.
	RTC_MODE0_INTFLAG_PER0       = 0x1    // Bit PER0.
	RTC_MODE0_INTFLAG_PER1_Pos   = 0x1    // Position of PER1 field.
	RTC_MODE0_INTFLAG_PER1_Msk   = 0x2    // Bit mask of PER1 field.
	RTC_MODE0_INTFLAG_PER1       = 0x2    // Bit PER1.
	RTC_MODE0_INTFLAG_PER2_Pos   = 0x2    // Position of PER2 field.
	RTC_MODE0_INTFLAG_PER2_Msk   = 0x4    // Bit mask of PER2 field.
	RTC_MODE0_INTFLAG_PER2       = 0x4    // Bit PER2.
	RTC_MODE0_INTFLAG_PER3_Pos   = 0x3    // Position of PER3 field.
	RTC_MODE0_INTFLAG_PER3_Msk   = 0x8    // Bit mask of PER3 field.
	RTC_MODE0_INTFLAG_PER3       = 0x8    // Bit PER3.
	RTC_MODE0_INTFLAG_PER4_Pos   = 0x4    // Position of PER4 field.
	RTC_MODE0_INTFLAG_PER4_Msk   = 0x10   // Bit mask of PER4 field.
	RTC_MODE0_INTFLAG_PER4       = 0x10   // Bit PER4.
	RTC_MODE0_INTFLAG_PER5_Pos   = 0x5    // Position of PER5 field.
	RTC_MODE0_INTFLAG_PER5_Msk   = 0x20   // Bit mask of PER5 field.
	RTC_MODE0_INTFLAG_PER5       = 0x20   // Bit PER5.
	RTC_MODE0_INTFLAG_PER6_Pos   = 0x6    // Position of PER6 field.
	RTC_MODE0_INTFLAG_PER6_Msk   = 0x40   // Bit mask of PER6 field.
	RTC_MODE0_INTFLAG_PER6       = 0x40   // Bit PER6.
	RTC_MODE0_INTFLAG_PER7_Pos   = 0x7    // Position of PER7 field.
	RTC_MODE0_INTFLAG_PER7_Msk   = 0x80   // Bit mask of PER7 field.
	RTC_MODE0_INTFLAG_PER7       = 0x80   // Bit PER7.
	RTC_MODE0_INTFLAG_CMP0_Pos   = 0x8    // Position of CMP0 field.
	RTC_MODE0_INTFLAG_CMP0_Msk   = 0x100  // Bit mask of CMP0 field.
	RTC_MODE0_INTFLAG_CMP0       = 0x100  // Bit CMP0.
	RTC_MODE0_INTFLAG_TAMPER_Pos = 0xe    // Position of TAMPER field.
	RTC_MODE0_INTFLAG_TAMPER_Msk = 0x4000 // Bit mask of TAMPER field.
	RTC_MODE0_INTFLAG_TAMPER     = 0x4000 // Bit TAMPER.
	RTC_MODE0_INTFLAG_OVF_Pos    = 0xf    // Position of OVF field.
	RTC_MODE0_INTFLAG_OVF_Msk    = 0x8000 // Bit mask of OVF field.
	RTC_MODE0_INTFLAG_OVF        = 0x8000 // Bit OVF.

	// DBGCTRL: Debug Control
	RTC_MODE0_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	RTC_MODE0_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	RTC_MODE0_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// SYNCBUSY: MODE0 Synchronization Busy Status
	RTC_MODE0_SYNCBUSY_SWRST_Pos     = 0x0     // Position of SWRST field.
	RTC_MODE0_SYNCBUSY_SWRST_Msk     = 0x1     // Bit mask of SWRST field.
	RTC_MODE0_SYNCBUSY_SWRST         = 0x1     // Bit SWRST.
	RTC_MODE0_SYNCBUSY_ENABLE_Pos    = 0x1     // Position of ENABLE field.
	RTC_MODE0_SYNCBUSY_ENABLE_Msk    = 0x2     // Bit mask of ENABLE field.
	RTC_MODE0_SYNCBUSY_ENABLE        = 0x2     // Bit ENABLE.
	RTC_MODE0_SYNCBUSY_FREQCORR_Pos  = 0x2     // Position of FREQCORR field.
	RTC_MODE0_SYNCBUSY_FREQCORR_Msk  = 0x4     // Bit mask of FREQCORR field.
	RTC_MODE0_SYNCBUSY_FREQCORR      = 0x4     // Bit FREQCORR.
	RTC_MODE0_SYNCBUSY_COUNT_Pos     = 0x3     // Position of COUNT field.
	RTC_MODE0_SYNCBUSY_COUNT_Msk     = 0x8     // Bit mask of COUNT field.
	RTC_MODE0_SYNCBUSY_COUNT         = 0x8     // Bit COUNT.
	RTC_MODE0_SYNCBUSY_COMP0_Pos     = 0x5     // Position of COMP0 field.
	RTC_MODE0_SYNCBUSY_COMP0_Msk     = 0x20    // Bit mask of COMP0 field.
	RTC_MODE0_SYNCBUSY_COMP0         = 0x20    // Bit COMP0.
	RTC_MODE0_SYNCBUSY_COUNTSYNC_Pos = 0xf     // Position of COUNTSYNC field.
	RTC_MODE0_SYNCBUSY_COUNTSYNC_Msk = 0x8000  // Bit mask of COUNTSYNC field.
	RTC_MODE0_SYNCBUSY_COUNTSYNC     = 0x8000  // Bit COUNTSYNC.
	RTC_MODE0_SYNCBUSY_GP0_Pos       = 0x10    // Position of GP0 field.
	RTC_MODE0_SYNCBUSY_GP0_Msk       = 0x10000 // Bit mask of GP0 field.
	RTC_MODE0_SYNCBUSY_GP0           = 0x10000 // Bit GP0.
	RTC_MODE0_SYNCBUSY_GP1_Pos       = 0x11    // Position of GP1 field.
	RTC_MODE0_SYNCBUSY_GP1_Msk       = 0x20000 // Bit mask of GP1 field.
	RTC_MODE0_SYNCBUSY_GP1           = 0x20000 // Bit GP1.

	// FREQCORR: Frequency Correction
	RTC_MODE0_FREQCORR_VALUE_Pos = 0x0  // Position of VALUE field.
	RTC_MODE0_FREQCORR_VALUE_Msk = 0x7f // Bit mask of VALUE field.
	RTC_MODE0_FREQCORR_SIGN_Pos  = 0x7  // Position of SIGN field.
	RTC_MODE0_FREQCORR_SIGN_Msk  = 0x80 // Bit mask of SIGN field.
	RTC_MODE0_FREQCORR_SIGN      = 0x80 // Bit SIGN.

	// COUNT: MODE0 Counter Value
	RTC_MODE0_COUNT_COUNT_Pos = 0x0        // Position of COUNT field.
	RTC_MODE0_COUNT_COUNT_Msk = 0xffffffff // Bit mask of COUNT field.

	// COMP: MODE0 Compare n Value
	RTC_MODE0_COMP_COMP_Pos = 0x0        // Position of COMP field.
	RTC_MODE0_COMP_COMP_Msk = 0xffffffff // Bit mask of COMP field.

	// GP: General Purpose
	RTC_MODE0_GP_GP_Pos = 0x0        // Position of GP field.
	RTC_MODE0_GP_GP_Msk = 0xffffffff // Bit mask of GP field.

	// TAMPCTRL: Tamper Control
	RTC_MODE0_TAMPCTRL_IN0ACT_Pos     = 0x0       // Position of IN0ACT field.
	RTC_MODE0_TAMPCTRL_IN0ACT_Msk     = 0x3       // Bit mask of IN0ACT field.
	RTC_MODE0_TAMPCTRL_IN0ACT_OFF     = 0x0       // Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN0ACT_WAKE    = 0x1       // Wake and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN0ACT_CAPTURE = 0x2       // Capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN0ACT_ACTL    = 0x3       // Compare IN0 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN1ACT_Pos     = 0x2       // Position of IN1ACT field.
	RTC_MODE0_TAMPCTRL_IN1ACT_Msk     = 0xc       // Bit mask of IN1ACT field.
	RTC_MODE0_TAMPCTRL_IN1ACT_OFF     = 0x0       // Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN1ACT_WAKE    = 0x1       // Wake and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN1ACT_CAPTURE = 0x2       // Capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN1ACT_ACTL    = 0x3       // Compare IN1 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN2ACT_Pos     = 0x4       // Position of IN2ACT field.
	RTC_MODE0_TAMPCTRL_IN2ACT_Msk     = 0x30      // Bit mask of IN2ACT field.
	RTC_MODE0_TAMPCTRL_IN2ACT_OFF     = 0x0       // Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN2ACT_WAKE    = 0x1       // Wake and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN2ACT_CAPTURE = 0x2       // Capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN2ACT_ACTL    = 0x3       // Compare IN2 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN3ACT_Pos     = 0x6       // Position of IN3ACT field.
	RTC_MODE0_TAMPCTRL_IN3ACT_Msk     = 0xc0      // Bit mask of IN3ACT field.
	RTC_MODE0_TAMPCTRL_IN3ACT_OFF     = 0x0       // Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN3ACT_WAKE    = 0x1       // Wake and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN3ACT_CAPTURE = 0x2       // Capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_IN3ACT_ACTL    = 0x3       // Compare IN3 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE0_TAMPCTRL_TAMLVL0_Pos    = 0x10      // Position of TAMLVL0 field.
	RTC_MODE0_TAMPCTRL_TAMLVL0_Msk    = 0x10000   // Bit mask of TAMLVL0 field.
	RTC_MODE0_TAMPCTRL_TAMLVL0        = 0x10000   // Bit TAMLVL0.
	RTC_MODE0_TAMPCTRL_TAMLVL1_Pos    = 0x11      // Position of TAMLVL1 field.
	RTC_MODE0_TAMPCTRL_TAMLVL1_Msk    = 0x20000   // Bit mask of TAMLVL1 field.
	RTC_MODE0_TAMPCTRL_TAMLVL1        = 0x20000   // Bit TAMLVL1.
	RTC_MODE0_TAMPCTRL_TAMLVL2_Pos    = 0x12      // Position of TAMLVL2 field.
	RTC_MODE0_TAMPCTRL_TAMLVL2_Msk    = 0x40000   // Bit mask of TAMLVL2 field.
	RTC_MODE0_TAMPCTRL_TAMLVL2        = 0x40000   // Bit TAMLVL2.
	RTC_MODE0_TAMPCTRL_TAMLVL3_Pos    = 0x13      // Position of TAMLVL3 field.
	RTC_MODE0_TAMPCTRL_TAMLVL3_Msk    = 0x80000   // Bit mask of TAMLVL3 field.
	RTC_MODE0_TAMPCTRL_TAMLVL3        = 0x80000   // Bit TAMLVL3.
	RTC_MODE0_TAMPCTRL_DEBNC0_Pos     = 0x18      // Position of DEBNC0 field.
	RTC_MODE0_TAMPCTRL_DEBNC0_Msk     = 0x1000000 // Bit mask of DEBNC0 field.
	RTC_MODE0_TAMPCTRL_DEBNC0         = 0x1000000 // Bit DEBNC0.
	RTC_MODE0_TAMPCTRL_DEBNC1_Pos     = 0x19      // Position of DEBNC1 field.
	RTC_MODE0_TAMPCTRL_DEBNC1_Msk     = 0x2000000 // Bit mask of DEBNC1 field.
	RTC_MODE0_TAMPCTRL_DEBNC1         = 0x2000000 // Bit DEBNC1.
	RTC_MODE0_TAMPCTRL_DEBNC2_Pos     = 0x1a      // Position of DEBNC2 field.
	RTC_MODE0_TAMPCTRL_DEBNC2_Msk     = 0x4000000 // Bit mask of DEBNC2 field.
	RTC_MODE0_TAMPCTRL_DEBNC2         = 0x4000000 // Bit DEBNC2.
	RTC_MODE0_TAMPCTRL_DEBNC3_Pos     = 0x1b      // Position of DEBNC3 field.
	RTC_MODE0_TAMPCTRL_DEBNC3_Msk     = 0x8000000 // Bit mask of DEBNC3 field.
	RTC_MODE0_TAMPCTRL_DEBNC3         = 0x8000000 // Bit DEBNC3.

	// TIMESTAMP: MODE0 Timestamp
	RTC_MODE0_TIMESTAMP_COUNT_Pos = 0x0        // Position of COUNT field.
	RTC_MODE0_TIMESTAMP_COUNT_Msk = 0xffffffff // Bit mask of COUNT field.

	// TAMPID: Tamper ID
	RTC_MODE0_TAMPID_TAMPID0_Pos = 0x0        // Position of TAMPID0 field.
	RTC_MODE0_TAMPID_TAMPID0_Msk = 0x1        // Bit mask of TAMPID0 field.
	RTC_MODE0_TAMPID_TAMPID0     = 0x1        // Bit TAMPID0.
	RTC_MODE0_TAMPID_TAMPID1_Pos = 0x1        // Position of TAMPID1 field.
	RTC_MODE0_TAMPID_TAMPID1_Msk = 0x2        // Bit mask of TAMPID1 field.
	RTC_MODE0_TAMPID_TAMPID1     = 0x2        // Bit TAMPID1.
	RTC_MODE0_TAMPID_TAMPID2_Pos = 0x2        // Position of TAMPID2 field.
	RTC_MODE0_TAMPID_TAMPID2_Msk = 0x4        // Bit mask of TAMPID2 field.
	RTC_MODE0_TAMPID_TAMPID2     = 0x4        // Bit TAMPID2.
	RTC_MODE0_TAMPID_TAMPID3_Pos = 0x3        // Position of TAMPID3 field.
	RTC_MODE0_TAMPID_TAMPID3_Msk = 0x8        // Bit mask of TAMPID3 field.
	RTC_MODE0_TAMPID_TAMPID3     = 0x8        // Bit TAMPID3.
	RTC_MODE0_TAMPID_TAMPEVT_Pos = 0x1f       // Position of TAMPEVT field.
	RTC_MODE0_TAMPID_TAMPEVT_Msk = 0x80000000 // Bit mask of TAMPEVT field.
	RTC_MODE0_TAMPID_TAMPEVT     = 0x80000000 // Bit TAMPEVT.

	// TAMPCTRLB: Tamper Control B
	RTC_MODE0_TAMPCTRLB_ALSI0_Pos = 0x0 // Position of ALSI0 field.
	RTC_MODE0_TAMPCTRLB_ALSI0_Msk = 0x1 // Bit mask of ALSI0 field.
	RTC_MODE0_TAMPCTRLB_ALSI0     = 0x1 // Bit ALSI0.
	RTC_MODE0_TAMPCTRLB_ALSI1_Pos = 0x1 // Position of ALSI1 field.
	RTC_MODE0_TAMPCTRLB_ALSI1_Msk = 0x2 // Bit mask of ALSI1 field.
	RTC_MODE0_TAMPCTRLB_ALSI1     = 0x2 // Bit ALSI1.
	RTC_MODE0_TAMPCTRLB_ALSI2_Pos = 0x2 // Position of ALSI2 field.
	RTC_MODE0_TAMPCTRLB_ALSI2_Msk = 0x4 // Bit mask of ALSI2 field.
	RTC_MODE0_TAMPCTRLB_ALSI2     = 0x4 // Bit ALSI2.
	RTC_MODE0_TAMPCTRLB_ALSI3_Pos = 0x3 // Position of ALSI3 field.
	RTC_MODE0_TAMPCTRLB_ALSI3_Msk = 0x8 // Bit mask of ALSI3 field.
	RTC_MODE0_TAMPCTRLB_ALSI3     = 0x8 // Bit ALSI3.
)

// Bitfields for RTC_MODE1: Real-Time Counter - MODE1
const (
	// CTRLA: MODE1 Control A
	RTC_MODE1_CTRLA_SWRST_Pos         = 0x0    // Position of SWRST field.
	RTC_MODE1_CTRLA_SWRST_Msk         = 0x1    // Bit mask of SWRST field.
	RTC_MODE1_CTRLA_SWRST             = 0x1    // Bit SWRST.
	RTC_MODE1_CTRLA_ENABLE_Pos        = 0x1    // Position of ENABLE field.
	RTC_MODE1_CTRLA_ENABLE_Msk        = 0x2    // Bit mask of ENABLE field.
	RTC_MODE1_CTRLA_ENABLE            = 0x2    // Bit ENABLE.
	RTC_MODE1_CTRLA_MODE_Pos          = 0x2    // Position of MODE field.
	RTC_MODE1_CTRLA_MODE_Msk          = 0xc    // Bit mask of MODE field.
	RTC_MODE1_CTRLA_MODE_COUNT32      = 0x0    // Mode 0: 32-bit Counter
	RTC_MODE1_CTRLA_MODE_COUNT16      = 0x1    // Mode 1: 16-bit Counter
	RTC_MODE1_CTRLA_MODE_CLOCK        = 0x2    // Mode 2: Clock/Calendar
	RTC_MODE1_CTRLA_PRESCALER_Pos     = 0x8    // Position of PRESCALER field.
	RTC_MODE1_CTRLA_PRESCALER_Msk     = 0xf00  // Bit mask of PRESCALER field.
	RTC_MODE1_CTRLA_PRESCALER_OFF     = 0x0    // CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE1_CTRLA_PRESCALER_DIV1    = 0x1    // CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE1_CTRLA_PRESCALER_DIV2    = 0x2    // CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE1_CTRLA_PRESCALER_DIV4    = 0x3    // CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE1_CTRLA_PRESCALER_DIV8    = 0x4    // CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE1_CTRLA_PRESCALER_DIV16   = 0x5    // CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE1_CTRLA_PRESCALER_DIV32   = 0x6    // CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE1_CTRLA_PRESCALER_DIV64   = 0x7    // CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE1_CTRLA_PRESCALER_DIV128  = 0x8    // CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE1_CTRLA_PRESCALER_DIV256  = 0x9    // CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE1_CTRLA_PRESCALER_DIV512  = 0xa    // CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE1_CTRLA_PRESCALER_DIV1024 = 0xb    // CLK_RTC_CNT = GCLK_RTC/1024
	RTC_MODE1_CTRLA_GPTRST_Pos        = 0xe    // Position of GPTRST field.
	RTC_MODE1_CTRLA_GPTRST_Msk        = 0x4000 // Bit mask of GPTRST field.
	RTC_MODE1_CTRLA_GPTRST            = 0x4000 // Bit GPTRST.
	RTC_MODE1_CTRLA_COUNTSYNC_Pos     = 0xf    // Position of COUNTSYNC field.
	RTC_MODE1_CTRLA_COUNTSYNC_Msk     = 0x8000 // Bit mask of COUNTSYNC field.
	RTC_MODE1_CTRLA_COUNTSYNC         = 0x8000 // Bit COUNTSYNC.

	// CTRLB: MODE1 Control B
	RTC_MODE1_CTRLB_GP0EN_Pos    = 0x0    // Position of GP0EN field.
	RTC_MODE1_CTRLB_GP0EN_Msk    = 0x1    // Bit mask of GP0EN field.
	RTC_MODE1_CTRLB_GP0EN        = 0x1    // Bit GP0EN.
	RTC_MODE1_CTRLB_DEBMAJ_Pos   = 0x4    // Position of DEBMAJ field.
	RTC_MODE1_CTRLB_DEBMAJ_Msk   = 0x10   // Bit mask of DEBMAJ field.
	RTC_MODE1_CTRLB_DEBMAJ       = 0x10   // Bit DEBMAJ.
	RTC_MODE1_CTRLB_DEBASYNC_Pos = 0x5    // Position of DEBASYNC field.
	RTC_MODE1_CTRLB_DEBASYNC_Msk = 0x20   // Bit mask of DEBASYNC field.
	RTC_MODE1_CTRLB_DEBASYNC     = 0x20   // Bit DEBASYNC.
	RTC_MODE1_CTRLB_RTCOUT_Pos   = 0x6    // Position of RTCOUT field.
	RTC_MODE1_CTRLB_RTCOUT_Msk   = 0x40   // Bit mask of RTCOUT field.
	RTC_MODE1_CTRLB_RTCOUT       = 0x40   // Bit RTCOUT.
	RTC_MODE1_CTRLB_DMAEN_Pos    = 0x7    // Position of DMAEN field.
	RTC_MODE1_CTRLB_DMAEN_Msk    = 0x80   // Bit mask of DMAEN field.
	RTC_MODE1_CTRLB_DMAEN        = 0x80   // Bit DMAEN.
	RTC_MODE1_CTRLB_DEBF_Pos     = 0x8    // Position of DEBF field.
	RTC_MODE1_CTRLB_DEBF_Msk     = 0x700  // Bit mask of DEBF field.
	RTC_MODE1_CTRLB_DEBF_DIV2    = 0x0    // CLK_RTC_DEB = CLK_RTC/2
	RTC_MODE1_CTRLB_DEBF_DIV4    = 0x1    // CLK_RTC_DEB = CLK_RTC/4
	RTC_MODE1_CTRLB_DEBF_DIV8    = 0x2    // CLK_RTC_DEB = CLK_RTC/8
	RTC_MODE1_CTRLB_DEBF_DIV16   = 0x3    // CLK_RTC_DEB = CLK_RTC/16
	RTC_MODE1_CTRLB_DEBF_DIV32   = 0x4    // CLK_RTC_DEB = CLK_RTC/32
	RTC_MODE1_CTRLB_DEBF_DIV64   = 0x5    // CLK_RTC_DEB = CLK_RTC/64
	RTC_MODE1_CTRLB_DEBF_DIV128  = 0x6    // CLK_RTC_DEB = CLK_RTC/128
	RTC_MODE1_CTRLB_DEBF_DIV256  = 0x7    // CLK_RTC_DEB = CLK_RTC/256
	RTC_MODE1_CTRLB_ACTF_Pos     = 0xc    // Position of ACTF field.
	RTC_MODE1_CTRLB_ACTF_Msk     = 0x7000 // Bit mask of ACTF field.
	RTC_MODE1_CTRLB_ACTF_DIV2    = 0x0    // CLK_RTC_OUT = CLK_RTC/2
	RTC_MODE1_CTRLB_ACTF_DIV4    = 0x1    // CLK_RTC_OUT = CLK_RTC/4
	RTC_MODE1_CTRLB_ACTF_DIV8    = 0x2    // CLK_RTC_OUT = CLK_RTC/8
	RTC_MODE1_CTRLB_ACTF_DIV16   = 0x3    // CLK_RTC_OUT = CLK_RTC/16
	RTC_MODE1_CTRLB_ACTF_DIV32   = 0x4    // CLK_RTC_OUT = CLK_RTC/32
	RTC_MODE1_CTRLB_ACTF_DIV64   = 0x5    // CLK_RTC_OUT = CLK_RTC/64
	RTC_MODE1_CTRLB_ACTF_DIV128  = 0x6    // CLK_RTC_OUT = CLK_RTC/128
	RTC_MODE1_CTRLB_ACTF_DIV256  = 0x7    // CLK_RTC_OUT = CLK_RTC/256
	RTC_MODE1_CTRLB_SEPTO_Pos    = 0xf    // Position of SEPTO field.
	RTC_MODE1_CTRLB_SEPTO_Msk    = 0x8000 // Bit mask of SEPTO field.
	RTC_MODE1_CTRLB_SEPTO        = 0x8000 // Bit SEPTO.

	// EVCTRL: MODE1 Event Control
	RTC_MODE1_EVCTRL_PEREO0_Pos   = 0x0       // Position of PEREO0 field.
	RTC_MODE1_EVCTRL_PEREO0_Msk   = 0x1       // Bit mask of PEREO0 field.
	RTC_MODE1_EVCTRL_PEREO0       = 0x1       // Bit PEREO0.
	RTC_MODE1_EVCTRL_PEREO1_Pos   = 0x1       // Position of PEREO1 field.
	RTC_MODE1_EVCTRL_PEREO1_Msk   = 0x2       // Bit mask of PEREO1 field.
	RTC_MODE1_EVCTRL_PEREO1       = 0x2       // Bit PEREO1.
	RTC_MODE1_EVCTRL_PEREO2_Pos   = 0x2       // Position of PEREO2 field.
	RTC_MODE1_EVCTRL_PEREO2_Msk   = 0x4       // Bit mask of PEREO2 field.
	RTC_MODE1_EVCTRL_PEREO2       = 0x4       // Bit PEREO2.
	RTC_MODE1_EVCTRL_PEREO3_Pos   = 0x3       // Position of PEREO3 field.
	RTC_MODE1_EVCTRL_PEREO3_Msk   = 0x8       // Bit mask of PEREO3 field.
	RTC_MODE1_EVCTRL_PEREO3       = 0x8       // Bit PEREO3.
	RTC_MODE1_EVCTRL_PEREO4_Pos   = 0x4       // Position of PEREO4 field.
	RTC_MODE1_EVCTRL_PEREO4_Msk   = 0x10      // Bit mask of PEREO4 field.
	RTC_MODE1_EVCTRL_PEREO4       = 0x10      // Bit PEREO4.
	RTC_MODE1_EVCTRL_PEREO5_Pos   = 0x5       // Position of PEREO5 field.
	RTC_MODE1_EVCTRL_PEREO5_Msk   = 0x20      // Bit mask of PEREO5 field.
	RTC_MODE1_EVCTRL_PEREO5       = 0x20      // Bit PEREO5.
	RTC_MODE1_EVCTRL_PEREO6_Pos   = 0x6       // Position of PEREO6 field.
	RTC_MODE1_EVCTRL_PEREO6_Msk   = 0x40      // Bit mask of PEREO6 field.
	RTC_MODE1_EVCTRL_PEREO6       = 0x40      // Bit PEREO6.
	RTC_MODE1_EVCTRL_PEREO7_Pos   = 0x7       // Position of PEREO7 field.
	RTC_MODE1_EVCTRL_PEREO7_Msk   = 0x80      // Bit mask of PEREO7 field.
	RTC_MODE1_EVCTRL_PEREO7       = 0x80      // Bit PEREO7.
	RTC_MODE1_EVCTRL_CMPEO0_Pos   = 0x8       // Position of CMPEO0 field.
	RTC_MODE1_EVCTRL_CMPEO0_Msk   = 0x100     // Bit mask of CMPEO0 field.
	RTC_MODE1_EVCTRL_CMPEO0       = 0x100     // Bit CMPEO0.
	RTC_MODE1_EVCTRL_CMPEO1_Pos   = 0x9       // Position of CMPEO1 field.
	RTC_MODE1_EVCTRL_CMPEO1_Msk   = 0x200     // Bit mask of CMPEO1 field.
	RTC_MODE1_EVCTRL_CMPEO1       = 0x200     // Bit CMPEO1.
	RTC_MODE1_EVCTRL_TAMPEREO_Pos = 0xe       // Position of TAMPEREO field.
	RTC_MODE1_EVCTRL_TAMPEREO_Msk = 0x4000    // Bit mask of TAMPEREO field.
	RTC_MODE1_EVCTRL_TAMPEREO     = 0x4000    // Bit TAMPEREO.
	RTC_MODE1_EVCTRL_OVFEO_Pos    = 0xf       // Position of OVFEO field.
	RTC_MODE1_EVCTRL_OVFEO_Msk    = 0x8000    // Bit mask of OVFEO field.
	RTC_MODE1_EVCTRL_OVFEO        = 0x8000    // Bit OVFEO.
	RTC_MODE1_EVCTRL_TAMPEVEI_Pos = 0x10      // Position of TAMPEVEI field.
	RTC_MODE1_EVCTRL_TAMPEVEI_Msk = 0x10000   // Bit mask of TAMPEVEI field.
	RTC_MODE1_EVCTRL_TAMPEVEI     = 0x10000   // Bit TAMPEVEI.
	RTC_MODE1_EVCTRL_PERDEO_Pos   = 0x18      // Position of PERDEO field.
	RTC_MODE1_EVCTRL_PERDEO_Msk   = 0x1000000 // Bit mask of PERDEO field.
	RTC_MODE1_EVCTRL_PERDEO       = 0x1000000 // Bit PERDEO.

	// INTENCLR: MODE1 Interrupt Enable Clear
	RTC_MODE1_INTENCLR_PER0_Pos   = 0x0    // Position of PER0 field.
	RTC_MODE1_INTENCLR_PER0_Msk   = 0x1    // Bit mask of PER0 field.
	RTC_MODE1_INTENCLR_PER0       = 0x1    // Bit PER0.
	RTC_MODE1_INTENCLR_PER1_Pos   = 0x1    // Position of PER1 field.
	RTC_MODE1_INTENCLR_PER1_Msk   = 0x2    // Bit mask of PER1 field.
	RTC_MODE1_INTENCLR_PER1       = 0x2    // Bit PER1.
	RTC_MODE1_INTENCLR_PER2_Pos   = 0x2    // Position of PER2 field.
	RTC_MODE1_INTENCLR_PER2_Msk   = 0x4    // Bit mask of PER2 field.
	RTC_MODE1_INTENCLR_PER2       = 0x4    // Bit PER2.
	RTC_MODE1_INTENCLR_PER3_Pos   = 0x3    // Position of PER3 field.
	RTC_MODE1_INTENCLR_PER3_Msk   = 0x8    // Bit mask of PER3 field.
	RTC_MODE1_INTENCLR_PER3       = 0x8    // Bit PER3.
	RTC_MODE1_INTENCLR_PER4_Pos   = 0x4    // Position of PER4 field.
	RTC_MODE1_INTENCLR_PER4_Msk   = 0x10   // Bit mask of PER4 field.
	RTC_MODE1_INTENCLR_PER4       = 0x10   // Bit PER4.
	RTC_MODE1_INTENCLR_PER5_Pos   = 0x5    // Position of PER5 field.
	RTC_MODE1_INTENCLR_PER5_Msk   = 0x20   // Bit mask of PER5 field.
	RTC_MODE1_INTENCLR_PER5       = 0x20   // Bit PER5.
	RTC_MODE1_INTENCLR_PER6_Pos   = 0x6    // Position of PER6 field.
	RTC_MODE1_INTENCLR_PER6_Msk   = 0x40   // Bit mask of PER6 field.
	RTC_MODE1_INTENCLR_PER6       = 0x40   // Bit PER6.
	RTC_MODE1_INTENCLR_PER7_Pos   = 0x7    // Position of PER7 field.
	RTC_MODE1_INTENCLR_PER7_Msk   = 0x80   // Bit mask of PER7 field.
	RTC_MODE1_INTENCLR_PER7       = 0x80   // Bit PER7.
	RTC_MODE1_INTENCLR_CMP0_Pos   = 0x8    // Position of CMP0 field.
	RTC_MODE1_INTENCLR_CMP0_Msk   = 0x100  // Bit mask of CMP0 field.
	RTC_MODE1_INTENCLR_CMP0       = 0x100  // Bit CMP0.
	RTC_MODE1_INTENCLR_CMP1_Pos   = 0x9    // Position of CMP1 field.
	RTC_MODE1_INTENCLR_CMP1_Msk   = 0x200  // Bit mask of CMP1 field.
	RTC_MODE1_INTENCLR_CMP1       = 0x200  // Bit CMP1.
	RTC_MODE1_INTENCLR_TAMPER_Pos = 0xe    // Position of TAMPER field.
	RTC_MODE1_INTENCLR_TAMPER_Msk = 0x4000 // Bit mask of TAMPER field.
	RTC_MODE1_INTENCLR_TAMPER     = 0x4000 // Bit TAMPER.
	RTC_MODE1_INTENCLR_OVF_Pos    = 0xf    // Position of OVF field.
	RTC_MODE1_INTENCLR_OVF_Msk    = 0x8000 // Bit mask of OVF field.
	RTC_MODE1_INTENCLR_OVF        = 0x8000 // Bit OVF.

	// INTENSET: MODE1 Interrupt Enable Set
	RTC_MODE1_INTENSET_PER0_Pos   = 0x0    // Position of PER0 field.
	RTC_MODE1_INTENSET_PER0_Msk   = 0x1    // Bit mask of PER0 field.
	RTC_MODE1_INTENSET_PER0       = 0x1    // Bit PER0.
	RTC_MODE1_INTENSET_PER1_Pos   = 0x1    // Position of PER1 field.
	RTC_MODE1_INTENSET_PER1_Msk   = 0x2    // Bit mask of PER1 field.
	RTC_MODE1_INTENSET_PER1       = 0x2    // Bit PER1.
	RTC_MODE1_INTENSET_PER2_Pos   = 0x2    // Position of PER2 field.
	RTC_MODE1_INTENSET_PER2_Msk   = 0x4    // Bit mask of PER2 field.
	RTC_MODE1_INTENSET_PER2       = 0x4    // Bit PER2.
	RTC_MODE1_INTENSET_PER3_Pos   = 0x3    // Position of PER3 field.
	RTC_MODE1_INTENSET_PER3_Msk   = 0x8    // Bit mask of PER3 field.
	RTC_MODE1_INTENSET_PER3       = 0x8    // Bit PER3.
	RTC_MODE1_INTENSET_PER4_Pos   = 0x4    // Position of PER4 field.
	RTC_MODE1_INTENSET_PER4_Msk   = 0x10   // Bit mask of PER4 field.
	RTC_MODE1_INTENSET_PER4       = 0x10   // Bit PER4.
	RTC_MODE1_INTENSET_PER5_Pos   = 0x5    // Position of PER5 field.
	RTC_MODE1_INTENSET_PER5_Msk   = 0x20   // Bit mask of PER5 field.
	RTC_MODE1_INTENSET_PER5       = 0x20   // Bit PER5.
	RTC_MODE1_INTENSET_PER6_Pos   = 0x6    // Position of PER6 field.
	RTC_MODE1_INTENSET_PER6_Msk   = 0x40   // Bit mask of PER6 field.
	RTC_MODE1_INTENSET_PER6       = 0x40   // Bit PER6.
	RTC_MODE1_INTENSET_PER7_Pos   = 0x7    // Position of PER7 field.
	RTC_MODE1_INTENSET_PER7_Msk   = 0x80   // Bit mask of PER7 field.
	RTC_MODE1_INTENSET_PER7       = 0x80   // Bit PER7.
	RTC_MODE1_INTENSET_CMP0_Pos   = 0x8    // Position of CMP0 field.
	RTC_MODE1_INTENSET_CMP0_Msk   = 0x100  // Bit mask of CMP0 field.
	RTC_MODE1_INTENSET_CMP0       = 0x100  // Bit CMP0.
	RTC_MODE1_INTENSET_CMP1_Pos   = 0x9    // Position of CMP1 field.
	RTC_MODE1_INTENSET_CMP1_Msk   = 0x200  // Bit mask of CMP1 field.
	RTC_MODE1_INTENSET_CMP1       = 0x200  // Bit CMP1.
	RTC_MODE1_INTENSET_TAMPER_Pos = 0xe    // Position of TAMPER field.
	RTC_MODE1_INTENSET_TAMPER_Msk = 0x4000 // Bit mask of TAMPER field.
	RTC_MODE1_INTENSET_TAMPER     = 0x4000 // Bit TAMPER.
	RTC_MODE1_INTENSET_OVF_Pos    = 0xf    // Position of OVF field.
	RTC_MODE1_INTENSET_OVF_Msk    = 0x8000 // Bit mask of OVF field.
	RTC_MODE1_INTENSET_OVF        = 0x8000 // Bit OVF.

	// INTFLAG: MODE1 Interrupt Flag Status and Clear
	RTC_MODE1_INTFLAG_PER0_Pos   = 0x0    // Position of PER0 field.
	RTC_MODE1_INTFLAG_PER0_Msk   = 0x1    // Bit mask of PER0 field.
	RTC_MODE1_INTFLAG_PER0       = 0x1    // Bit PER0.
	RTC_MODE1_INTFLAG_PER1_Pos   = 0x1    // Position of PER1 field.
	RTC_MODE1_INTFLAG_PER1_Msk   = 0x2    // Bit mask of PER1 field.
	RTC_MODE1_INTFLAG_PER1       = 0x2    // Bit PER1.
	RTC_MODE1_INTFLAG_PER2_Pos   = 0x2    // Position of PER2 field.
	RTC_MODE1_INTFLAG_PER2_Msk   = 0x4    // Bit mask of PER2 field.
	RTC_MODE1_INTFLAG_PER2       = 0x4    // Bit PER2.
	RTC_MODE1_INTFLAG_PER3_Pos   = 0x3    // Position of PER3 field.
	RTC_MODE1_INTFLAG_PER3_Msk   = 0x8    // Bit mask of PER3 field.
	RTC_MODE1_INTFLAG_PER3       = 0x8    // Bit PER3.
	RTC_MODE1_INTFLAG_PER4_Pos   = 0x4    // Position of PER4 field.
	RTC_MODE1_INTFLAG_PER4_Msk   = 0x10   // Bit mask of PER4 field.
	RTC_MODE1_INTFLAG_PER4       = 0x10   // Bit PER4.
	RTC_MODE1_INTFLAG_PER5_Pos   = 0x5    // Position of PER5 field.
	RTC_MODE1_INTFLAG_PER5_Msk   = 0x20   // Bit mask of PER5 field.
	RTC_MODE1_INTFLAG_PER5       = 0x20   // Bit PER5.
	RTC_MODE1_INTFLAG_PER6_Pos   = 0x6    // Position of PER6 field.
	RTC_MODE1_INTFLAG_PER6_Msk   = 0x40   // Bit mask of PER6 field.
	RTC_MODE1_INTFLAG_PER6       = 0x40   // Bit PER6.
	RTC_MODE1_INTFLAG_PER7_Pos   = 0x7    // Position of PER7 field.
	RTC_MODE1_INTFLAG_PER7_Msk   = 0x80   // Bit mask of PER7 field.
	RTC_MODE1_INTFLAG_PER7       = 0x80   // Bit PER7.
	RTC_MODE1_INTFLAG_CMP0_Pos   = 0x8    // Position of CMP0 field.
	RTC_MODE1_INTFLAG_CMP0_Msk   = 0x100  // Bit mask of CMP0 field.
	RTC_MODE1_INTFLAG_CMP0       = 0x100  // Bit CMP0.
	RTC_MODE1_INTFLAG_CMP1_Pos   = 0x9    // Position of CMP1 field.
	RTC_MODE1_INTFLAG_CMP1_Msk   = 0x200  // Bit mask of CMP1 field.
	RTC_MODE1_INTFLAG_CMP1       = 0x200  // Bit CMP1.
	RTC_MODE1_INTFLAG_TAMPER_Pos = 0xe    // Position of TAMPER field.
	RTC_MODE1_INTFLAG_TAMPER_Msk = 0x4000 // Bit mask of TAMPER field.
	RTC_MODE1_INTFLAG_TAMPER     = 0x4000 // Bit TAMPER.
	RTC_MODE1_INTFLAG_OVF_Pos    = 0xf    // Position of OVF field.
	RTC_MODE1_INTFLAG_OVF_Msk    = 0x8000 // Bit mask of OVF field.
	RTC_MODE1_INTFLAG_OVF        = 0x8000 // Bit OVF.

	// DBGCTRL: Debug Control
	RTC_MODE1_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	RTC_MODE1_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	RTC_MODE1_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// SYNCBUSY: MODE1 Synchronization Busy Status
	RTC_MODE1_SYNCBUSY_SWRST_Pos     = 0x0     // Position of SWRST field.
	RTC_MODE1_SYNCBUSY_SWRST_Msk     = 0x1     // Bit mask of SWRST field.
	RTC_MODE1_SYNCBUSY_SWRST         = 0x1     // Bit SWRST.
	RTC_MODE1_SYNCBUSY_ENABLE_Pos    = 0x1     // Position of ENABLE field.
	RTC_MODE1_SYNCBUSY_ENABLE_Msk    = 0x2     // Bit mask of ENABLE field.
	RTC_MODE1_SYNCBUSY_ENABLE        = 0x2     // Bit ENABLE.
	RTC_MODE1_SYNCBUSY_FREQCORR_Pos  = 0x2     // Position of FREQCORR field.
	RTC_MODE1_SYNCBUSY_FREQCORR_Msk  = 0x4     // Bit mask of FREQCORR field.
	RTC_MODE1_SYNCBUSY_FREQCORR      = 0x4     // Bit FREQCORR.
	RTC_MODE1_SYNCBUSY_COUNT_Pos     = 0x3     // Position of COUNT field.
	RTC_MODE1_SYNCBUSY_COUNT_Msk     = 0x8     // Bit mask of COUNT field.
	RTC_MODE1_SYNCBUSY_COUNT         = 0x8     // Bit COUNT.
	RTC_MODE1_SYNCBUSY_PER_Pos       = 0x4     // Position of PER field.
	RTC_MODE1_SYNCBUSY_PER_Msk       = 0x10    // Bit mask of PER field.
	RTC_MODE1_SYNCBUSY_PER           = 0x10    // Bit PER.
	RTC_MODE1_SYNCBUSY_COMP0_Pos     = 0x5     // Position of COMP0 field.
	RTC_MODE1_SYNCBUSY_COMP0_Msk     = 0x20    // Bit mask of COMP0 field.
	RTC_MODE1_SYNCBUSY_COMP0         = 0x20    // Bit COMP0.
	RTC_MODE1_SYNCBUSY_COMP1_Pos     = 0x6     // Position of COMP1 field.
	RTC_MODE1_SYNCBUSY_COMP1_Msk     = 0x40    // Bit mask of COMP1 field.
	RTC_MODE1_SYNCBUSY_COMP1         = 0x40    // Bit COMP1.
	RTC_MODE1_SYNCBUSY_COUNTSYNC_Pos = 0xf     // Position of COUNTSYNC field.
	RTC_MODE1_SYNCBUSY_COUNTSYNC_Msk = 0x8000  // Bit mask of COUNTSYNC field.
	RTC_MODE1_SYNCBUSY_COUNTSYNC     = 0x8000  // Bit COUNTSYNC.
	RTC_MODE1_SYNCBUSY_GP0_Pos       = 0x10    // Position of GP0 field.
	RTC_MODE1_SYNCBUSY_GP0_Msk       = 0x10000 // Bit mask of GP0 field.
	RTC_MODE1_SYNCBUSY_GP0           = 0x10000 // Bit GP0.
	RTC_MODE1_SYNCBUSY_GP1_Pos       = 0x11    // Position of GP1 field.
	RTC_MODE1_SYNCBUSY_GP1_Msk       = 0x20000 // Bit mask of GP1 field.
	RTC_MODE1_SYNCBUSY_GP1           = 0x20000 // Bit GP1.

	// FREQCORR: Frequency Correction
	RTC_MODE1_FREQCORR_VALUE_Pos = 0x0  // Position of VALUE field.
	RTC_MODE1_FREQCORR_VALUE_Msk = 0x7f // Bit mask of VALUE field.
	RTC_MODE1_FREQCORR_SIGN_Pos  = 0x7  // Position of SIGN field.
	RTC_MODE1_FREQCORR_SIGN_Msk  = 0x80 // Bit mask of SIGN field.
	RTC_MODE1_FREQCORR_SIGN      = 0x80 // Bit SIGN.

	// COUNT: MODE1 Counter Value
	RTC_MODE1_COUNT_COUNT_Pos = 0x0    // Position of COUNT field.
	RTC_MODE1_COUNT_COUNT_Msk = 0xffff // Bit mask of COUNT field.

	// PER: MODE1 Counter Period
	RTC_MODE1_PER_PER_Pos = 0x0    // Position of PER field.
	RTC_MODE1_PER_PER_Msk = 0xffff // Bit mask of PER field.

	// COMP: MODE1 Compare n Value
	RTC_MODE1_COMP_COMP_Pos = 0x0    // Position of COMP field.
	RTC_MODE1_COMP_COMP_Msk = 0xffff // Bit mask of COMP field.

	// GP: General Purpose
	RTC_MODE1_GP_GP_Pos = 0x0        // Position of GP field.
	RTC_MODE1_GP_GP_Msk = 0xffffffff // Bit mask of GP field.

	// TAMPCTRL: Tamper Control
	RTC_MODE1_TAMPCTRL_IN0ACT_Pos     = 0x0       // Position of IN0ACT field.
	RTC_MODE1_TAMPCTRL_IN0ACT_Msk     = 0x3       // Bit mask of IN0ACT field.
	RTC_MODE1_TAMPCTRL_IN0ACT_OFF     = 0x0       // Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN0ACT_WAKE    = 0x1       // Wake and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN0ACT_CAPTURE = 0x2       // Capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN0ACT_ACTL    = 0x3       // Compare IN0 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN1ACT_Pos     = 0x2       // Position of IN1ACT field.
	RTC_MODE1_TAMPCTRL_IN1ACT_Msk     = 0xc       // Bit mask of IN1ACT field.
	RTC_MODE1_TAMPCTRL_IN1ACT_OFF     = 0x0       // Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN1ACT_WAKE    = 0x1       // Wake and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN1ACT_CAPTURE = 0x2       // Capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN1ACT_ACTL    = 0x3       // Compare IN1 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN2ACT_Pos     = 0x4       // Position of IN2ACT field.
	RTC_MODE1_TAMPCTRL_IN2ACT_Msk     = 0x30      // Bit mask of IN2ACT field.
	RTC_MODE1_TAMPCTRL_IN2ACT_OFF     = 0x0       // Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN2ACT_WAKE    = 0x1       // Wake and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN2ACT_CAPTURE = 0x2       // Capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN2ACT_ACTL    = 0x3       // Compare IN2 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN3ACT_Pos     = 0x6       // Position of IN3ACT field.
	RTC_MODE1_TAMPCTRL_IN3ACT_Msk     = 0xc0      // Bit mask of IN3ACT field.
	RTC_MODE1_TAMPCTRL_IN3ACT_OFF     = 0x0       // Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN3ACT_WAKE    = 0x1       // Wake and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN3ACT_CAPTURE = 0x2       // Capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_IN3ACT_ACTL    = 0x3       // Compare IN3 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE1_TAMPCTRL_TAMLVL0_Pos    = 0x10      // Position of TAMLVL0 field.
	RTC_MODE1_TAMPCTRL_TAMLVL0_Msk    = 0x10000   // Bit mask of TAMLVL0 field.
	RTC_MODE1_TAMPCTRL_TAMLVL0        = 0x10000   // Bit TAMLVL0.
	RTC_MODE1_TAMPCTRL_TAMLVL1_Pos    = 0x11      // Position of TAMLVL1 field.
	RTC_MODE1_TAMPCTRL_TAMLVL1_Msk    = 0x20000   // Bit mask of TAMLVL1 field.
	RTC_MODE1_TAMPCTRL_TAMLVL1        = 0x20000   // Bit TAMLVL1.
	RTC_MODE1_TAMPCTRL_TAMLVL2_Pos    = 0x12      // Position of TAMLVL2 field.
	RTC_MODE1_TAMPCTRL_TAMLVL2_Msk    = 0x40000   // Bit mask of TAMLVL2 field.
	RTC_MODE1_TAMPCTRL_TAMLVL2        = 0x40000   // Bit TAMLVL2.
	RTC_MODE1_TAMPCTRL_TAMLVL3_Pos    = 0x13      // Position of TAMLVL3 field.
	RTC_MODE1_TAMPCTRL_TAMLVL3_Msk    = 0x80000   // Bit mask of TAMLVL3 field.
	RTC_MODE1_TAMPCTRL_TAMLVL3        = 0x80000   // Bit TAMLVL3.
	RTC_MODE1_TAMPCTRL_DEBNC0_Pos     = 0x18      // Position of DEBNC0 field.
	RTC_MODE1_TAMPCTRL_DEBNC0_Msk     = 0x1000000 // Bit mask of DEBNC0 field.
	RTC_MODE1_TAMPCTRL_DEBNC0         = 0x1000000 // Bit DEBNC0.
	RTC_MODE1_TAMPCTRL_DEBNC1_Pos     = 0x19      // Position of DEBNC1 field.
	RTC_MODE1_TAMPCTRL_DEBNC1_Msk     = 0x2000000 // Bit mask of DEBNC1 field.
	RTC_MODE1_TAMPCTRL_DEBNC1         = 0x2000000 // Bit DEBNC1.
	RTC_MODE1_TAMPCTRL_DEBNC2_Pos     = 0x1a      // Position of DEBNC2 field.
	RTC_MODE1_TAMPCTRL_DEBNC2_Msk     = 0x4000000 // Bit mask of DEBNC2 field.
	RTC_MODE1_TAMPCTRL_DEBNC2         = 0x4000000 // Bit DEBNC2.
	RTC_MODE1_TAMPCTRL_DEBNC3_Pos     = 0x1b      // Position of DEBNC3 field.
	RTC_MODE1_TAMPCTRL_DEBNC3_Msk     = 0x8000000 // Bit mask of DEBNC3 field.
	RTC_MODE1_TAMPCTRL_DEBNC3         = 0x8000000 // Bit DEBNC3.

	// TIMESTAMP: MODE1 Timestamp
	RTC_MODE1_TIMESTAMP_COUNT_Pos = 0x0    // Position of COUNT field.
	RTC_MODE1_TIMESTAMP_COUNT_Msk = 0xffff // Bit mask of COUNT field.

	// TAMPID: Tamper ID
	RTC_MODE1_TAMPID_TAMPID0_Pos = 0x0        // Position of TAMPID0 field.
	RTC_MODE1_TAMPID_TAMPID0_Msk = 0x1        // Bit mask of TAMPID0 field.
	RTC_MODE1_TAMPID_TAMPID0     = 0x1        // Bit TAMPID0.
	RTC_MODE1_TAMPID_TAMPID1_Pos = 0x1        // Position of TAMPID1 field.
	RTC_MODE1_TAMPID_TAMPID1_Msk = 0x2        // Bit mask of TAMPID1 field.
	RTC_MODE1_TAMPID_TAMPID1     = 0x2        // Bit TAMPID1.
	RTC_MODE1_TAMPID_TAMPID2_Pos = 0x2        // Position of TAMPID2 field.
	RTC_MODE1_TAMPID_TAMPID2_Msk = 0x4        // Bit mask of TAMPID2 field.
	RTC_MODE1_TAMPID_TAMPID2     = 0x4        // Bit TAMPID2.
	RTC_MODE1_TAMPID_TAMPID3_Pos = 0x3        // Position of TAMPID3 field.
	RTC_MODE1_TAMPID_TAMPID3_Msk = 0x8        // Bit mask of TAMPID3 field.
	RTC_MODE1_TAMPID_TAMPID3     = 0x8        // Bit TAMPID3.
	RTC_MODE1_TAMPID_TAMPEVT_Pos = 0x1f       // Position of TAMPEVT field.
	RTC_MODE1_TAMPID_TAMPEVT_Msk = 0x80000000 // Bit mask of TAMPEVT field.
	RTC_MODE1_TAMPID_TAMPEVT     = 0x80000000 // Bit TAMPEVT.

	// TAMPCTRLB: Tamper Control B
	RTC_MODE1_TAMPCTRLB_ALSI0_Pos = 0x0 // Position of ALSI0 field.
	RTC_MODE1_TAMPCTRLB_ALSI0_Msk = 0x1 // Bit mask of ALSI0 field.
	RTC_MODE1_TAMPCTRLB_ALSI0     = 0x1 // Bit ALSI0.
	RTC_MODE1_TAMPCTRLB_ALSI1_Pos = 0x1 // Position of ALSI1 field.
	RTC_MODE1_TAMPCTRLB_ALSI1_Msk = 0x2 // Bit mask of ALSI1 field.
	RTC_MODE1_TAMPCTRLB_ALSI1     = 0x2 // Bit ALSI1.
	RTC_MODE1_TAMPCTRLB_ALSI2_Pos = 0x2 // Position of ALSI2 field.
	RTC_MODE1_TAMPCTRLB_ALSI2_Msk = 0x4 // Bit mask of ALSI2 field.
	RTC_MODE1_TAMPCTRLB_ALSI2     = 0x4 // Bit ALSI2.
	RTC_MODE1_TAMPCTRLB_ALSI3_Pos = 0x3 // Position of ALSI3 field.
	RTC_MODE1_TAMPCTRLB_ALSI3_Msk = 0x8 // Bit mask of ALSI3 field.
	RTC_MODE1_TAMPCTRLB_ALSI3     = 0x8 // Bit ALSI3.
)

// Bitfields for RTC_MODE2: Real-Time Counter - MODE2
const (
	// CTRLA: MODE2 Control A
	RTC_MODE2_CTRLA_SWRST_Pos         = 0x0    // Position of SWRST field.
	RTC_MODE2_CTRLA_SWRST_Msk         = 0x1    // Bit mask of SWRST field.
	RTC_MODE2_CTRLA_SWRST             = 0x1    // Bit SWRST.
	RTC_MODE2_CTRLA_ENABLE_Pos        = 0x1    // Position of ENABLE field.
	RTC_MODE2_CTRLA_ENABLE_Msk        = 0x2    // Bit mask of ENABLE field.
	RTC_MODE2_CTRLA_ENABLE            = 0x2    // Bit ENABLE.
	RTC_MODE2_CTRLA_MODE_Pos          = 0x2    // Position of MODE field.
	RTC_MODE2_CTRLA_MODE_Msk          = 0xc    // Bit mask of MODE field.
	RTC_MODE2_CTRLA_MODE_COUNT32      = 0x0    // Mode 0: 32-bit Counter
	RTC_MODE2_CTRLA_MODE_COUNT16      = 0x1    // Mode 1: 16-bit Counter
	RTC_MODE2_CTRLA_MODE_CLOCK        = 0x2    // Mode 2: Clock/Calendar
	RTC_MODE2_CTRLA_CLKREP_Pos        = 0x6    // Position of CLKREP field.
	RTC_MODE2_CTRLA_CLKREP_Msk        = 0x40   // Bit mask of CLKREP field.
	RTC_MODE2_CTRLA_CLKREP            = 0x40   // Bit CLKREP.
	RTC_MODE2_CTRLA_MATCHCLR_Pos      = 0x7    // Position of MATCHCLR field.
	RTC_MODE2_CTRLA_MATCHCLR_Msk      = 0x80   // Bit mask of MATCHCLR field.
	RTC_MODE2_CTRLA_MATCHCLR          = 0x80   // Bit MATCHCLR.
	RTC_MODE2_CTRLA_PRESCALER_Pos     = 0x8    // Position of PRESCALER field.
	RTC_MODE2_CTRLA_PRESCALER_Msk     = 0xf00  // Bit mask of PRESCALER field.
	RTC_MODE2_CTRLA_PRESCALER_OFF     = 0x0    // CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE2_CTRLA_PRESCALER_DIV1    = 0x1    // CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE2_CTRLA_PRESCALER_DIV2    = 0x2    // CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE2_CTRLA_PRESCALER_DIV4    = 0x3    // CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE2_CTRLA_PRESCALER_DIV8    = 0x4    // CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE2_CTRLA_PRESCALER_DIV16   = 0x5    // CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE2_CTRLA_PRESCALER_DIV32   = 0x6    // CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE2_CTRLA_PRESCALER_DIV64   = 0x7    // CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE2_CTRLA_PRESCALER_DIV128  = 0x8    // CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE2_CTRLA_PRESCALER_DIV256  = 0x9    // CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE2_CTRLA_PRESCALER_DIV512  = 0xa    // CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE2_CTRLA_PRESCALER_DIV1024 = 0xb    // CLK_RTC_CNT = GCLK_RTC/1024
	RTC_MODE2_CTRLA_GPTRST_Pos        = 0xe    // Position of GPTRST field.
	RTC_MODE2_CTRLA_GPTRST_Msk        = 0x4000 // Bit mask of GPTRST field.
	RTC_MODE2_CTRLA_GPTRST            = 0x4000 // Bit GPTRST.
	RTC_MODE2_CTRLA_CLOCKSYNC_Pos     = 0xf    // Position of CLOCKSYNC field.
	RTC_MODE2_CTRLA_CLOCKSYNC_Msk     = 0x8000 // Bit mask of CLOCKSYNC field.
	RTC_MODE2_CTRLA_CLOCKSYNC         = 0x8000 // Bit CLOCKSYNC.

	// CTRLB: MODE2 Control B
	RTC_MODE2_CTRLB_GP0EN_Pos    = 0x0    // Position of GP0EN field.
	RTC_MODE2_CTRLB_GP0EN_Msk    = 0x1    // Bit mask of GP0EN field.
	RTC_MODE2_CTRLB_GP0EN        = 0x1    // Bit GP0EN.
	RTC_MODE2_CTRLB_DEBMAJ_Pos   = 0x4    // Position of DEBMAJ field.
	RTC_MODE2_CTRLB_DEBMAJ_Msk   = 0x10   // Bit mask of DEBMAJ field.
	RTC_MODE2_CTRLB_DEBMAJ       = 0x10   // Bit DEBMAJ.
	RTC_MODE2_CTRLB_DEBASYNC_Pos = 0x5    // Position of DEBASYNC field.
	RTC_MODE2_CTRLB_DEBASYNC_Msk = 0x20   // Bit mask of DEBASYNC field.
	RTC_MODE2_CTRLB_DEBASYNC     = 0x20   // Bit DEBASYNC.
	RTC_MODE2_CTRLB_RTCOUT_Pos   = 0x6    // Position of RTCOUT field.
	RTC_MODE2_CTRLB_RTCOUT_Msk   = 0x40   // Bit mask of RTCOUT field.
	RTC_MODE2_CTRLB_RTCOUT       = 0x40   // Bit RTCOUT.
	RTC_MODE2_CTRLB_DMAEN_Pos    = 0x7    // Position of DMAEN field.
	RTC_MODE2_CTRLB_DMAEN_Msk    = 0x80   // Bit mask of DMAEN field.
	RTC_MODE2_CTRLB_DMAEN        = 0x80   // Bit DMAEN.
	RTC_MODE2_CTRLB_DEBF_Pos     = 0x8    // Position of DEBF field.
	RTC_MODE2_CTRLB_DEBF_Msk     = 0x700  // Bit mask of DEBF field.
	RTC_MODE2_CTRLB_DEBF_DIV2    = 0x0    // CLK_RTC_DEB = CLK_RTC/2
	RTC_MODE2_CTRLB_DEBF_DIV4    = 0x1    // CLK_RTC_DEB = CLK_RTC/4
	RTC_MODE2_CTRLB_DEBF_DIV8    = 0x2    // CLK_RTC_DEB = CLK_RTC/8
	RTC_MODE2_CTRLB_DEBF_DIV16   = 0x3    // CLK_RTC_DEB = CLK_RTC/16
	RTC_MODE2_CTRLB_DEBF_DIV32   = 0x4    // CLK_RTC_DEB = CLK_RTC/32
	RTC_MODE2_CTRLB_DEBF_DIV64   = 0x5    // CLK_RTC_DEB = CLK_RTC/64
	RTC_MODE2_CTRLB_DEBF_DIV128  = 0x6    // CLK_RTC_DEB = CLK_RTC/128
	RTC_MODE2_CTRLB_DEBF_DIV256  = 0x7    // CLK_RTC_DEB = CLK_RTC/256
	RTC_MODE2_CTRLB_ACTF_Pos     = 0xc    // Position of ACTF field.
	RTC_MODE2_CTRLB_ACTF_Msk     = 0x7000 // Bit mask of ACTF field.
	RTC_MODE2_CTRLB_ACTF_DIV2    = 0x0    // CLK_RTC_OUT = CLK_RTC/2
	RTC_MODE2_CTRLB_ACTF_DIV4    = 0x1    // CLK_RTC_OUT = CLK_RTC/4
	RTC_MODE2_CTRLB_ACTF_DIV8    = 0x2    // CLK_RTC_OUT = CLK_RTC/8
	RTC_MODE2_CTRLB_ACTF_DIV16   = 0x3    // CLK_RTC_OUT = CLK_RTC/16
	RTC_MODE2_CTRLB_ACTF_DIV32   = 0x4    // CLK_RTC_OUT = CLK_RTC/32
	RTC_MODE2_CTRLB_ACTF_DIV64   = 0x5    // CLK_RTC_OUT = CLK_RTC/64
	RTC_MODE2_CTRLB_ACTF_DIV128  = 0x6    // CLK_RTC_OUT = CLK_RTC/128
	RTC_MODE2_CTRLB_ACTF_DIV256  = 0x7    // CLK_RTC_OUT = CLK_RTC/256
	RTC_MODE2_CTRLB_SEPTO_Pos    = 0xf    // Position of SEPTO field.
	RTC_MODE2_CTRLB_SEPTO_Msk    = 0x8000 // Bit mask of SEPTO field.
	RTC_MODE2_CTRLB_SEPTO        = 0x8000 // Bit SEPTO.

	// EVCTRL: MODE2 Event Control
	RTC_MODE2_EVCTRL_PEREO0_Pos   = 0x0       // Position of PEREO0 field.
	RTC_MODE2_EVCTRL_PEREO0_Msk   = 0x1       // Bit mask of PEREO0 field.
	RTC_MODE2_EVCTRL_PEREO0       = 0x1       // Bit PEREO0.
	RTC_MODE2_EVCTRL_PEREO1_Pos   = 0x1       // Position of PEREO1 field.
	RTC_MODE2_EVCTRL_PEREO1_Msk   = 0x2       // Bit mask of PEREO1 field.
	RTC_MODE2_EVCTRL_PEREO1       = 0x2       // Bit PEREO1.
	RTC_MODE2_EVCTRL_PEREO2_Pos   = 0x2       // Position of PEREO2 field.
	RTC_MODE2_EVCTRL_PEREO2_Msk   = 0x4       // Bit mask of PEREO2 field.
	RTC_MODE2_EVCTRL_PEREO2       = 0x4       // Bit PEREO2.
	RTC_MODE2_EVCTRL_PEREO3_Pos   = 0x3       // Position of PEREO3 field.
	RTC_MODE2_EVCTRL_PEREO3_Msk   = 0x8       // Bit mask of PEREO3 field.
	RTC_MODE2_EVCTRL_PEREO3       = 0x8       // Bit PEREO3.
	RTC_MODE2_EVCTRL_PEREO4_Pos   = 0x4       // Position of PEREO4 field.
	RTC_MODE2_EVCTRL_PEREO4_Msk   = 0x10      // Bit mask of PEREO4 field.
	RTC_MODE2_EVCTRL_PEREO4       = 0x10      // Bit PEREO4.
	RTC_MODE2_EVCTRL_PEREO5_Pos   = 0x5       // Position of PEREO5 field.
	RTC_MODE2_EVCTRL_PEREO5_Msk   = 0x20      // Bit mask of PEREO5 field.
	RTC_MODE2_EVCTRL_PEREO5       = 0x20      // Bit PEREO5.
	RTC_MODE2_EVCTRL_PEREO6_Pos   = 0x6       // Position of PEREO6 field.
	RTC_MODE2_EVCTRL_PEREO6_Msk   = 0x40      // Bit mask of PEREO6 field.
	RTC_MODE2_EVCTRL_PEREO6       = 0x40      // Bit PEREO6.
	RTC_MODE2_EVCTRL_PEREO7_Pos   = 0x7       // Position of PEREO7 field.
	RTC_MODE2_EVCTRL_PEREO7_Msk   = 0x80      // Bit mask of PEREO7 field.
	RTC_MODE2_EVCTRL_PEREO7       = 0x80      // Bit PEREO7.
	RTC_MODE2_EVCTRL_ALARMEO0_Pos = 0x8       // Position of ALARMEO0 field.
	RTC_MODE2_EVCTRL_ALARMEO0_Msk = 0x100     // Bit mask of ALARMEO0 field.
	RTC_MODE2_EVCTRL_ALARMEO0     = 0x100     // Bit ALARMEO0.
	RTC_MODE2_EVCTRL_TAMPEREO_Pos = 0xe       // Position of TAMPEREO field.
	RTC_MODE2_EVCTRL_TAMPEREO_Msk = 0x4000    // Bit mask of TAMPEREO field.
	RTC_MODE2_EVCTRL_TAMPEREO     = 0x4000    // Bit TAMPEREO.
	RTC_MODE2_EVCTRL_OVFEO_Pos    = 0xf       // Position of OVFEO field.
	RTC_MODE2_EVCTRL_OVFEO_Msk    = 0x8000    // Bit mask of OVFEO field.
	RTC_MODE2_EVCTRL_OVFEO        = 0x8000    // Bit OVFEO.
	RTC_MODE2_EVCTRL_TAMPEVEI_Pos = 0x10      // Position of TAMPEVEI field.
	RTC_MODE2_EVCTRL_TAMPEVEI_Msk = 0x10000   // Bit mask of TAMPEVEI field.
	RTC_MODE2_EVCTRL_TAMPEVEI     = 0x10000   // Bit TAMPEVEI.
	RTC_MODE2_EVCTRL_PERDEO_Pos   = 0x18      // Position of PERDEO field.
	RTC_MODE2_EVCTRL_PERDEO_Msk   = 0x1000000 // Bit mask of PERDEO field.
	RTC_MODE2_EVCTRL_PERDEO       = 0x1000000 // Bit PERDEO.

	// INTENCLR: MODE2 Interrupt Enable Clear
	RTC_MODE2_INTENCLR_PER0_Pos   = 0x0    // Position of PER0 field.
	RTC_MODE2_INTENCLR_PER0_Msk   = 0x1    // Bit mask of PER0 field.
	RTC_MODE2_INTENCLR_PER0       = 0x1    // Bit PER0.
	RTC_MODE2_INTENCLR_PER1_Pos   = 0x1    // Position of PER1 field.
	RTC_MODE2_INTENCLR_PER1_Msk   = 0x2    // Bit mask of PER1 field.
	RTC_MODE2_INTENCLR_PER1       = 0x2    // Bit PER1.
	RTC_MODE2_INTENCLR_PER2_Pos   = 0x2    // Position of PER2 field.
	RTC_MODE2_INTENCLR_PER2_Msk   = 0x4    // Bit mask of PER2 field.
	RTC_MODE2_INTENCLR_PER2       = 0x4    // Bit PER2.
	RTC_MODE2_INTENCLR_PER3_Pos   = 0x3    // Position of PER3 field.
	RTC_MODE2_INTENCLR_PER3_Msk   = 0x8    // Bit mask of PER3 field.
	RTC_MODE2_INTENCLR_PER3       = 0x8    // Bit PER3.
	RTC_MODE2_INTENCLR_PER4_Pos   = 0x4    // Position of PER4 field.
	RTC_MODE2_INTENCLR_PER4_Msk   = 0x10   // Bit mask of PER4 field.
	RTC_MODE2_INTENCLR_PER4       = 0x10   // Bit PER4.
	RTC_MODE2_INTENCLR_PER5_Pos   = 0x5    // Position of PER5 field.
	RTC_MODE2_INTENCLR_PER5_Msk   = 0x20   // Bit mask of PER5 field.
	RTC_MODE2_INTENCLR_PER5       = 0x20   // Bit PER5.
	RTC_MODE2_INTENCLR_PER6_Pos   = 0x6    // Position of PER6 field.
	RTC_MODE2_INTENCLR_PER6_Msk   = 0x40   // Bit mask of PER6 field.
	RTC_MODE2_INTENCLR_PER6       = 0x40   // Bit PER6.
	RTC_MODE2_INTENCLR_PER7_Pos   = 0x7    // Position of PER7 field.
	RTC_MODE2_INTENCLR_PER7_Msk   = 0x80   // Bit mask of PER7 field.
	RTC_MODE2_INTENCLR_PER7       = 0x80   // Bit PER7.
	RTC_MODE2_INTENCLR_ALARM0_Pos = 0x8    // Position of ALARM0 field.
	RTC_MODE2_INTENCLR_ALARM0_Msk = 0x100  // Bit mask of ALARM0 field.
	RTC_MODE2_INTENCLR_ALARM0     = 0x100  // Bit ALARM0.
	RTC_MODE2_INTENCLR_TAMPER_Pos = 0xe    // Position of TAMPER field.
	RTC_MODE2_INTENCLR_TAMPER_Msk = 0x4000 // Bit mask of TAMPER field.
	RTC_MODE2_INTENCLR_TAMPER     = 0x4000 // Bit TAMPER.
	RTC_MODE2_INTENCLR_OVF_Pos    = 0xf    // Position of OVF field.
	RTC_MODE2_INTENCLR_OVF_Msk    = 0x8000 // Bit mask of OVF field.
	RTC_MODE2_INTENCLR_OVF        = 0x8000 // Bit OVF.

	// INTENSET: MODE2 Interrupt Enable Set
	RTC_MODE2_INTENSET_PER0_Pos   = 0x0    // Position of PER0 field.
	RTC_MODE2_INTENSET_PER0_Msk   = 0x1    // Bit mask of PER0 field.
	RTC_MODE2_INTENSET_PER0       = 0x1    // Bit PER0.
	RTC_MODE2_INTENSET_PER1_Pos   = 0x1    // Position of PER1 field.
	RTC_MODE2_INTENSET_PER1_Msk   = 0x2    // Bit mask of PER1 field.
	RTC_MODE2_INTENSET_PER1       = 0x2    // Bit PER1.
	RTC_MODE2_INTENSET_PER2_Pos   = 0x2    // Position of PER2 field.
	RTC_MODE2_INTENSET_PER2_Msk   = 0x4    // Bit mask of PER2 field.
	RTC_MODE2_INTENSET_PER2       = 0x4    // Bit PER2.
	RTC_MODE2_INTENSET_PER3_Pos   = 0x3    // Position of PER3 field.
	RTC_MODE2_INTENSET_PER3_Msk   = 0x8    // Bit mask of PER3 field.
	RTC_MODE2_INTENSET_PER3       = 0x8    // Bit PER3.
	RTC_MODE2_INTENSET_PER4_Pos   = 0x4    // Position of PER4 field.
	RTC_MODE2_INTENSET_PER4_Msk   = 0x10   // Bit mask of PER4 field.
	RTC_MODE2_INTENSET_PER4       = 0x10   // Bit PER4.
	RTC_MODE2_INTENSET_PER5_Pos   = 0x5    // Position of PER5 field.
	RTC_MODE2_INTENSET_PER5_Msk   = 0x20   // Bit mask of PER5 field.
	RTC_MODE2_INTENSET_PER5       = 0x20   // Bit PER5.
	RTC_MODE2_INTENSET_PER6_Pos   = 0x6    // Position of PER6 field.
	RTC_MODE2_INTENSET_PER6_Msk   = 0x40   // Bit mask of PER6 field.
	RTC_MODE2_INTENSET_PER6       = 0x40   // Bit PER6.
	RTC_MODE2_INTENSET_PER7_Pos   = 0x7    // Position of PER7 field.
	RTC_MODE2_INTENSET_PER7_Msk   = 0x80   // Bit mask of PER7 field.
	RTC_MODE2_INTENSET_PER7       = 0x80   // Bit PER7.
	RTC_MODE2_INTENSET_ALARM0_Pos = 0x8    // Position of ALARM0 field.
	RTC_MODE2_INTENSET_ALARM0_Msk = 0x100  // Bit mask of ALARM0 field.
	RTC_MODE2_INTENSET_ALARM0     = 0x100  // Bit ALARM0.
	RTC_MODE2_INTENSET_TAMPER_Pos = 0xe    // Position of TAMPER field.
	RTC_MODE2_INTENSET_TAMPER_Msk = 0x4000 // Bit mask of TAMPER field.
	RTC_MODE2_INTENSET_TAMPER     = 0x4000 // Bit TAMPER.
	RTC_MODE2_INTENSET_OVF_Pos    = 0xf    // Position of OVF field.
	RTC_MODE2_INTENSET_OVF_Msk    = 0x8000 // Bit mask of OVF field.
	RTC_MODE2_INTENSET_OVF        = 0x8000 // Bit OVF.

	// INTFLAG: MODE2 Interrupt Flag Status and Clear
	RTC_MODE2_INTFLAG_PER0_Pos   = 0x0    // Position of PER0 field.
	RTC_MODE2_INTFLAG_PER0_Msk   = 0x1    // Bit mask of PER0 field.
	RTC_MODE2_INTFLAG_PER0       = 0x1    // Bit PER0.
	RTC_MODE2_INTFLAG_PER1_Pos   = 0x1    // Position of PER1 field.
	RTC_MODE2_INTFLAG_PER1_Msk   = 0x2    // Bit mask of PER1 field.
	RTC_MODE2_INTFLAG_PER1       = 0x2    // Bit PER1.
	RTC_MODE2_INTFLAG_PER2_Pos   = 0x2    // Position of PER2 field.
	RTC_MODE2_INTFLAG_PER2_Msk   = 0x4    // Bit mask of PER2 field.
	RTC_MODE2_INTFLAG_PER2       = 0x4    // Bit PER2.
	RTC_MODE2_INTFLAG_PER3_Pos   = 0x3    // Position of PER3 field.
	RTC_MODE2_INTFLAG_PER3_Msk   = 0x8    // Bit mask of PER3 field.
	RTC_MODE2_INTFLAG_PER3       = 0x8    // Bit PER3.
	RTC_MODE2_INTFLAG_PER4_Pos   = 0x4    // Position of PER4 field.
	RTC_MODE2_INTFLAG_PER4_Msk   = 0x10   // Bit mask of PER4 field.
	RTC_MODE2_INTFLAG_PER4       = 0x10   // Bit PER4.
	RTC_MODE2_INTFLAG_PER5_Pos   = 0x5    // Position of PER5 field.
	RTC_MODE2_INTFLAG_PER5_Msk   = 0x20   // Bit mask of PER5 field.
	RTC_MODE2_INTFLAG_PER5       = 0x20   // Bit PER5.
	RTC_MODE2_INTFLAG_PER6_Pos   = 0x6    // Position of PER6 field.
	RTC_MODE2_INTFLAG_PER6_Msk   = 0x40   // Bit mask of PER6 field.
	RTC_MODE2_INTFLAG_PER6       = 0x40   // Bit PER6.
	RTC_MODE2_INTFLAG_PER7_Pos   = 0x7    // Position of PER7 field.
	RTC_MODE2_INTFLAG_PER7_Msk   = 0x80   // Bit mask of PER7 field.
	RTC_MODE2_INTFLAG_PER7       = 0x80   // Bit PER7.
	RTC_MODE2_INTFLAG_ALARM0_Pos = 0x8    // Position of ALARM0 field.
	RTC_MODE2_INTFLAG_ALARM0_Msk = 0x100  // Bit mask of ALARM0 field.
	RTC_MODE2_INTFLAG_ALARM0     = 0x100  // Bit ALARM0.
	RTC_MODE2_INTFLAG_TAMPER_Pos = 0xe    // Position of TAMPER field.
	RTC_MODE2_INTFLAG_TAMPER_Msk = 0x4000 // Bit mask of TAMPER field.
	RTC_MODE2_INTFLAG_TAMPER     = 0x4000 // Bit TAMPER.
	RTC_MODE2_INTFLAG_OVF_Pos    = 0xf    // Position of OVF field.
	RTC_MODE2_INTFLAG_OVF_Msk    = 0x8000 // Bit mask of OVF field.
	RTC_MODE2_INTFLAG_OVF        = 0x8000 // Bit OVF.

	// DBGCTRL: Debug Control
	RTC_MODE2_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	RTC_MODE2_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	RTC_MODE2_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// SYNCBUSY: MODE2 Synchronization Busy Status
	RTC_MODE2_SYNCBUSY_SWRST_Pos     = 0x0     // Position of SWRST field.
	RTC_MODE2_SYNCBUSY_SWRST_Msk     = 0x1     // Bit mask of SWRST field.
	RTC_MODE2_SYNCBUSY_SWRST         = 0x1     // Bit SWRST.
	RTC_MODE2_SYNCBUSY_ENABLE_Pos    = 0x1     // Position of ENABLE field.
	RTC_MODE2_SYNCBUSY_ENABLE_Msk    = 0x2     // Bit mask of ENABLE field.
	RTC_MODE2_SYNCBUSY_ENABLE        = 0x2     // Bit ENABLE.
	RTC_MODE2_SYNCBUSY_FREQCORR_Pos  = 0x2     // Position of FREQCORR field.
	RTC_MODE2_SYNCBUSY_FREQCORR_Msk  = 0x4     // Bit mask of FREQCORR field.
	RTC_MODE2_SYNCBUSY_FREQCORR      = 0x4     // Bit FREQCORR.
	RTC_MODE2_SYNCBUSY_CLOCK_Pos     = 0x3     // Position of CLOCK field.
	RTC_MODE2_SYNCBUSY_CLOCK_Msk     = 0x8     // Bit mask of CLOCK field.
	RTC_MODE2_SYNCBUSY_CLOCK         = 0x8     // Bit CLOCK.
	RTC_MODE2_SYNCBUSY_ALARM0_Pos    = 0x5     // Position of ALARM0 field.
	RTC_MODE2_SYNCBUSY_ALARM0_Msk    = 0x20    // Bit mask of ALARM0 field.
	RTC_MODE2_SYNCBUSY_ALARM0        = 0x20    // Bit ALARM0.
	RTC_MODE2_SYNCBUSY_MASK0_Pos     = 0xb     // Position of MASK0 field.
	RTC_MODE2_SYNCBUSY_MASK0_Msk     = 0x800   // Bit mask of MASK0 field.
	RTC_MODE2_SYNCBUSY_MASK0         = 0x800   // Bit MASK0.
	RTC_MODE2_SYNCBUSY_CLOCKSYNC_Pos = 0xf     // Position of CLOCKSYNC field.
	RTC_MODE2_SYNCBUSY_CLOCKSYNC_Msk = 0x8000  // Bit mask of CLOCKSYNC field.
	RTC_MODE2_SYNCBUSY_CLOCKSYNC     = 0x8000  // Bit CLOCKSYNC.
	RTC_MODE2_SYNCBUSY_GP0_Pos       = 0x10    // Position of GP0 field.
	RTC_MODE2_SYNCBUSY_GP0_Msk       = 0x10000 // Bit mask of GP0 field.
	RTC_MODE2_SYNCBUSY_GP0           = 0x10000 // Bit GP0.
	RTC_MODE2_SYNCBUSY_GP1_Pos       = 0x11    // Position of GP1 field.
	RTC_MODE2_SYNCBUSY_GP1_Msk       = 0x20000 // Bit mask of GP1 field.
	RTC_MODE2_SYNCBUSY_GP1           = 0x20000 // Bit GP1.

	// FREQCORR: Frequency Correction
	RTC_MODE2_FREQCORR_VALUE_Pos = 0x0  // Position of VALUE field.
	RTC_MODE2_FREQCORR_VALUE_Msk = 0x7f // Bit mask of VALUE field.
	RTC_MODE2_FREQCORR_SIGN_Pos  = 0x7  // Position of SIGN field.
	RTC_MODE2_FREQCORR_SIGN_Msk  = 0x80 // Bit mask of SIGN field.
	RTC_MODE2_FREQCORR_SIGN      = 0x80 // Bit SIGN.

	// CLOCK: MODE2 Clock Value
	RTC_MODE2_CLOCK_SECOND_Pos = 0x0        // Position of SECOND field.
	RTC_MODE2_CLOCK_SECOND_Msk = 0x3f       // Bit mask of SECOND field.
	RTC_MODE2_CLOCK_MINUTE_Pos = 0x6        // Position of MINUTE field.
	RTC_MODE2_CLOCK_MINUTE_Msk = 0xfc0      // Bit mask of MINUTE field.
	RTC_MODE2_CLOCK_HOUR_Pos   = 0xc        // Position of HOUR field.
	RTC_MODE2_CLOCK_HOUR_Msk   = 0x1f000    // Bit mask of HOUR field.
	RTC_MODE2_CLOCK_DAY_Pos    = 0x11       // Position of DAY field.
	RTC_MODE2_CLOCK_DAY_Msk    = 0x3e0000   // Bit mask of DAY field.
	RTC_MODE2_CLOCK_MONTH_Pos  = 0x16       // Position of MONTH field.
	RTC_MODE2_CLOCK_MONTH_Msk  = 0x3c00000  // Bit mask of MONTH field.
	RTC_MODE2_CLOCK_YEAR_Pos   = 0x1a       // Position of YEAR field.
	RTC_MODE2_CLOCK_YEAR_Msk   = 0xfc000000 // Bit mask of YEAR field.

	// ALARM: MODE2_ALARM Alarm n Value
	ALARM_MODE2_ALARM_ALARM_SECOND_Pos = 0x0        // Position of SECOND field.
	ALARM_MODE2_ALARM_ALARM_SECOND_Msk = 0x3f       // Bit mask of SECOND field.
	ALARM_MODE2_ALARM_ALARM_MINUTE_Pos = 0x6        // Position of MINUTE field.
	ALARM_MODE2_ALARM_ALARM_MINUTE_Msk = 0xfc0      // Bit mask of MINUTE field.
	ALARM_MODE2_ALARM_ALARM_HOUR_Pos   = 0xc        // Position of HOUR field.
	ALARM_MODE2_ALARM_ALARM_HOUR_Msk   = 0x1f000    // Bit mask of HOUR field.
	ALARM_MODE2_ALARM_ALARM_HOUR_AM    = 0x0        // Morning hour
	ALARM_MODE2_ALARM_ALARM_HOUR_PM    = 0x10       // Afternoon hour
	ALARM_MODE2_ALARM_ALARM_DAY_Pos    = 0x11       // Position of DAY field.
	ALARM_MODE2_ALARM_ALARM_DAY_Msk    = 0x3e0000   // Bit mask of DAY field.
	ALARM_MODE2_ALARM_ALARM_MONTH_Pos  = 0x16       // Position of MONTH field.
	ALARM_MODE2_ALARM_ALARM_MONTH_Msk  = 0x3c00000  // Bit mask of MONTH field.
	ALARM_MODE2_ALARM_ALARM_YEAR_Pos   = 0x1a       // Position of YEAR field.
	ALARM_MODE2_ALARM_ALARM_YEAR_Msk   = 0xfc000000 // Bit mask of YEAR field.

	// MASK: MODE2_ALARM Alarm n Mask
	MASK_MODE2_ALARM_MASK_SEL_Pos          = 0x0 // Position of SEL field.
	MASK_MODE2_ALARM_MASK_SEL_Msk          = 0x7 // Bit mask of SEL field.
	MASK_MODE2_ALARM_MASK_SEL_OFF          = 0x0 // Alarm Disabled
	MASK_MODE2_ALARM_MASK_SEL_SS           = 0x1 // Match seconds only
	MASK_MODE2_ALARM_MASK_SEL_MMSS         = 0x2 // Match seconds and minutes only
	MASK_MODE2_ALARM_MASK_SEL_HHMMSS       = 0x3 // Match seconds, minutes, and hours only
	MASK_MODE2_ALARM_MASK_SEL_DDHHMMSS     = 0x4 // Match seconds, minutes, hours, and days only
	MASK_MODE2_ALARM_MASK_SEL_MMDDHHMMSS   = 0x5 // Match seconds, minutes, hours, days, and months only
	MASK_MODE2_ALARM_MASK_SEL_YYMMDDHHMMSS = 0x6 // Match seconds, minutes, hours, days, months, and years

	// GP: General Purpose
	RTC_MODE2_GP_GP_Pos = 0x0        // Position of GP field.
	RTC_MODE2_GP_GP_Msk = 0xffffffff // Bit mask of GP field.

	// TAMPCTRL: Tamper Control
	RTC_MODE2_TAMPCTRL_IN0ACT_Pos     = 0x0       // Position of IN0ACT field.
	RTC_MODE2_TAMPCTRL_IN0ACT_Msk     = 0x3       // Bit mask of IN0ACT field.
	RTC_MODE2_TAMPCTRL_IN0ACT_OFF     = 0x0       // Off (Disabled)
	RTC_MODE2_TAMPCTRL_IN0ACT_WAKE    = 0x1       // Wake and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN0ACT_CAPTURE = 0x2       // Capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN0ACT_ACTL    = 0x3       // Compare IN0 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN1ACT_Pos     = 0x2       // Position of IN1ACT field.
	RTC_MODE2_TAMPCTRL_IN1ACT_Msk     = 0xc       // Bit mask of IN1ACT field.
	RTC_MODE2_TAMPCTRL_IN1ACT_OFF     = 0x0       // Off (Disabled)
	RTC_MODE2_TAMPCTRL_IN1ACT_WAKE    = 0x1       // Wake and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN1ACT_CAPTURE = 0x2       // Capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN1ACT_ACTL    = 0x3       // Compare IN1 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN2ACT_Pos     = 0x4       // Position of IN2ACT field.
	RTC_MODE2_TAMPCTRL_IN2ACT_Msk     = 0x30      // Bit mask of IN2ACT field.
	RTC_MODE2_TAMPCTRL_IN2ACT_OFF     = 0x0       // Off (Disabled)
	RTC_MODE2_TAMPCTRL_IN2ACT_WAKE    = 0x1       // Wake and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN2ACT_CAPTURE = 0x2       // Capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN2ACT_ACTL    = 0x3       // Compare IN2 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN3ACT_Pos     = 0x6       // Position of IN3ACT field.
	RTC_MODE2_TAMPCTRL_IN3ACT_Msk     = 0xc0      // Bit mask of IN3ACT field.
	RTC_MODE2_TAMPCTRL_IN3ACT_OFF     = 0x0       // Off (Disabled)
	RTC_MODE2_TAMPCTRL_IN3ACT_WAKE    = 0x1       // Wake and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN3ACT_CAPTURE = 0x2       // Capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_IN3ACT_ACTL    = 0x3       // Compare IN3 to OUT. When a mismatch occurs, capture timestamp and set Tamper flag
	RTC_MODE2_TAMPCTRL_TAMLVL0_Pos    = 0x10      // Position of TAMLVL0 field.
	RTC_MODE2_TAMPCTRL_TAMLVL0_Msk    = 0x10000   // Bit mask of TAMLVL0 field.
	RTC_MODE2_TAMPCTRL_TAMLVL0        = 0x10000   // Bit TAMLVL0.
	RTC_MODE2_TAMPCTRL_TAMLVL1_Pos    = 0x11      // Position of TAMLVL1 field.
	RTC_MODE2_TAMPCTRL_TAMLVL1_Msk    = 0x20000   // Bit mask of TAMLVL1 field.
	RTC_MODE2_TAMPCTRL_TAMLVL1        = 0x20000   // Bit TAMLVL1.
	RTC_MODE2_TAMPCTRL_TAMLVL2_Pos    = 0x12      // Position of TAMLVL2 field.
	RTC_MODE2_TAMPCTRL_TAMLVL2_Msk    = 0x40000   // Bit mask of TAMLVL2 field.
	RTC_MODE2_TAMPCTRL_TAMLVL2        = 0x40000   // Bit TAMLVL2.
	RTC_MODE2_TAMPCTRL_TAMLVL3_Pos    = 0x13      // Position of TAMLVL3 field.
	RTC_MODE2_TAMPCTRL_TAMLVL3_Msk    = 0x80000   // Bit mask of TAMLVL3 field.
	RTC_MODE2_TAMPCTRL_TAMLVL3        = 0x80000   // Bit TAMLVL3.
	RTC_MODE2_TAMPCTRL_DEBNC0_Pos     = 0x18      // Position of DEBNC0 field.
	RTC_MODE2_TAMPCTRL_DEBNC0_Msk     = 0x1000000 // Bit mask of DEBNC0 field.
	RTC_MODE2_TAMPCTRL_DEBNC0         = 0x1000000 // Bit DEBNC0.
	RTC_MODE2_TAMPCTRL_DEBNC1_Pos     = 0x19      // Position of DEBNC1 field.
	RTC_MODE2_TAMPCTRL_DEBNC1_Msk     = 0x2000000 // Bit mask of DEBNC1 field.
	RTC_MODE2_TAMPCTRL_DEBNC1         = 0x2000000 // Bit DEBNC1.
	RTC_MODE2_TAMPCTRL_DEBNC2_Pos     = 0x1a      // Position of DEBNC2 field.
	RTC_MODE2_TAMPCTRL_DEBNC2_Msk     = 0x4000000 // Bit mask of DEBNC2 field.
	RTC_MODE2_TAMPCTRL_DEBNC2         = 0x4000000 // Bit DEBNC2.
	RTC_MODE2_TAMPCTRL_DEBNC3_Pos     = 0x1b      // Position of DEBNC3 field.
	RTC_MODE2_TAMPCTRL_DEBNC3_Msk     = 0x8000000 // Bit mask of DEBNC3 field.
	RTC_MODE2_TAMPCTRL_DEBNC3         = 0x8000000 // Bit DEBNC3.

	// TIMESTAMP: MODE2 Timestamp
	RTC_MODE2_TIMESTAMP_SECOND_Pos = 0x0        // Position of SECOND field.
	RTC_MODE2_TIMESTAMP_SECOND_Msk = 0x3f       // Bit mask of SECOND field.
	RTC_MODE2_TIMESTAMP_MINUTE_Pos = 0x6        // Position of MINUTE field.
	RTC_MODE2_TIMESTAMP_MINUTE_Msk = 0xfc0      // Bit mask of MINUTE field.
	RTC_MODE2_TIMESTAMP_HOUR_Pos   = 0xc        // Position of HOUR field.
	RTC_MODE2_TIMESTAMP_HOUR_Msk   = 0x1f000    // Bit mask of HOUR field.
	RTC_MODE2_TIMESTAMP_DAY_Pos    = 0x11       // Position of DAY field.
	RTC_MODE2_TIMESTAMP_DAY_Msk    = 0x3e0000   // Bit mask of DAY field.
	RTC_MODE2_TIMESTAMP_MONTH_Pos  = 0x16       // Position of MONTH field.
	RTC_MODE2_TIMESTAMP_MONTH_Msk  = 0x3c00000  // Bit mask of MONTH field.
	RTC_MODE2_TIMESTAMP_YEAR_Pos   = 0x1a       // Position of YEAR field.
	RTC_MODE2_TIMESTAMP_YEAR_Msk   = 0xfc000000 // Bit mask of YEAR field.

	// TAMPID: Tamper ID
	RTC_MODE2_TAMPID_TAMPID0_Pos = 0x0        // Position of TAMPID0 field.
	RTC_MODE2_TAMPID_TAMPID0_Msk = 0x1        // Bit mask of TAMPID0 field.
	RTC_MODE2_TAMPID_TAMPID0     = 0x1        // Bit TAMPID0.
	RTC_MODE2_TAMPID_TAMPID1_Pos = 0x1        // Position of TAMPID1 field.
	RTC_MODE2_TAMPID_TAMPID1_Msk = 0x2        // Bit mask of TAMPID1 field.
	RTC_MODE2_TAMPID_TAMPID1     = 0x2        // Bit TAMPID1.
	RTC_MODE2_TAMPID_TAMPID2_Pos = 0x2        // Position of TAMPID2 field.
	RTC_MODE2_TAMPID_TAMPID2_Msk = 0x4        // Bit mask of TAMPID2 field.
	RTC_MODE2_TAMPID_TAMPID2     = 0x4        // Bit TAMPID2.
	RTC_MODE2_TAMPID_TAMPID3_Pos = 0x3        // Position of TAMPID3 field.
	RTC_MODE2_TAMPID_TAMPID3_Msk = 0x8        // Bit mask of TAMPID3 field.
	RTC_MODE2_TAMPID_TAMPID3     = 0x8        // Bit TAMPID3.
	RTC_MODE2_TAMPID_TAMPEVT_Pos = 0x1f       // Position of TAMPEVT field.
	RTC_MODE2_TAMPID_TAMPEVT_Msk = 0x80000000 // Bit mask of TAMPEVT field.
	RTC_MODE2_TAMPID_TAMPEVT     = 0x80000000 // Bit TAMPEVT.

	// TAMPCTRLB: Tamper Control B
	RTC_MODE2_TAMPCTRLB_ALSI0_Pos = 0x0 // Position of ALSI0 field.
	RTC_MODE2_TAMPCTRLB_ALSI0_Msk = 0x1 // Bit mask of ALSI0 field.
	RTC_MODE2_TAMPCTRLB_ALSI0     = 0x1 // Bit ALSI0.
	RTC_MODE2_TAMPCTRLB_ALSI1_Pos = 0x1 // Position of ALSI1 field.
	RTC_MODE2_TAMPCTRLB_ALSI1_Msk = 0x2 // Bit mask of ALSI1 field.
	RTC_MODE2_TAMPCTRLB_ALSI1     = 0x2 // Bit ALSI1.
	RTC_MODE2_TAMPCTRLB_ALSI2_Pos = 0x2 // Position of ALSI2 field.
	RTC_MODE2_TAMPCTRLB_ALSI2_Msk = 0x4 // Bit mask of ALSI2 field.
	RTC_MODE2_TAMPCTRLB_ALSI2     = 0x4 // Bit ALSI2.
	RTC_MODE2_TAMPCTRLB_ALSI3_Pos = 0x3 // Position of ALSI3 field.
	RTC_MODE2_TAMPCTRLB_ALSI3_Msk = 0x8 // Bit mask of ALSI3 field.
	RTC_MODE2_TAMPCTRLB_ALSI3     = 0x8 // Bit ALSI3.
)

// Bitfields for SERCOM0: Serial Communication Interface
const ()

// Bitfields for SERCOM0_I2CM: Serial Communication Interface - I2CM
const (
	// CTRLA: I2CM Control A
	SERCOM_I2CM_CTRLA_SWRST_Pos     = 0x0        // Position of SWRST field.
	SERCOM_I2CM_CTRLA_SWRST_Msk     = 0x1        // Bit mask of SWRST field.
	SERCOM_I2CM_CTRLA_SWRST         = 0x1        // Bit SWRST.
	SERCOM_I2CM_CTRLA_ENABLE_Pos    = 0x1        // Position of ENABLE field.
	SERCOM_I2CM_CTRLA_ENABLE_Msk    = 0x2        // Bit mask of ENABLE field.
	SERCOM_I2CM_CTRLA_ENABLE        = 0x2        // Bit ENABLE.
	SERCOM_I2CM_CTRLA_MODE_Pos      = 0x2        // Position of MODE field.
	SERCOM_I2CM_CTRLA_MODE_Msk      = 0x1c       // Bit mask of MODE field.
	SERCOM_I2CM_CTRLA_RUNSTDBY_Pos  = 0x7        // Position of RUNSTDBY field.
	SERCOM_I2CM_CTRLA_RUNSTDBY_Msk  = 0x80       // Bit mask of RUNSTDBY field.
	SERCOM_I2CM_CTRLA_RUNSTDBY      = 0x80       // Bit RUNSTDBY.
	SERCOM_I2CM_CTRLA_PINOUT_Pos    = 0x10       // Position of PINOUT field.
	SERCOM_I2CM_CTRLA_PINOUT_Msk    = 0x10000    // Bit mask of PINOUT field.
	SERCOM_I2CM_CTRLA_PINOUT        = 0x10000    // Bit PINOUT.
	SERCOM_I2CM_CTRLA_SDAHOLD_Pos   = 0x14       // Position of SDAHOLD field.
	SERCOM_I2CM_CTRLA_SDAHOLD_Msk   = 0x300000   // Bit mask of SDAHOLD field.
	SERCOM_I2CM_CTRLA_MEXTTOEN_Pos  = 0x16       // Position of MEXTTOEN field.
	SERCOM_I2CM_CTRLA_MEXTTOEN_Msk  = 0x400000   // Bit mask of MEXTTOEN field.
	SERCOM_I2CM_CTRLA_MEXTTOEN      = 0x400000   // Bit MEXTTOEN.
	SERCOM_I2CM_CTRLA_SEXTTOEN_Pos  = 0x17       // Position of SEXTTOEN field.
	SERCOM_I2CM_CTRLA_SEXTTOEN_Msk  = 0x800000   // Bit mask of SEXTTOEN field.
	SERCOM_I2CM_CTRLA_SEXTTOEN      = 0x800000   // Bit SEXTTOEN.
	SERCOM_I2CM_CTRLA_SPEED_Pos     = 0x18       // Position of SPEED field.
	SERCOM_I2CM_CTRLA_SPEED_Msk     = 0x3000000  // Bit mask of SPEED field.
	SERCOM_I2CM_CTRLA_SCLSM_Pos     = 0x1b       // Position of SCLSM field.
	SERCOM_I2CM_CTRLA_SCLSM_Msk     = 0x8000000  // Bit mask of SCLSM field.
	SERCOM_I2CM_CTRLA_SCLSM         = 0x8000000  // Bit SCLSM.
	SERCOM_I2CM_CTRLA_INACTOUT_Pos  = 0x1c       // Position of INACTOUT field.
	SERCOM_I2CM_CTRLA_INACTOUT_Msk  = 0x30000000 // Bit mask of INACTOUT field.
	SERCOM_I2CM_CTRLA_LOWTOUTEN_Pos = 0x1e       // Position of LOWTOUTEN field.
	SERCOM_I2CM_CTRLA_LOWTOUTEN_Msk = 0x40000000 // Bit mask of LOWTOUTEN field.
	SERCOM_I2CM_CTRLA_LOWTOUTEN     = 0x40000000 // Bit LOWTOUTEN.

	// CTRLB: I2CM Control B
	SERCOM_I2CM_CTRLB_SMEN_Pos   = 0x8     // Position of SMEN field.
	SERCOM_I2CM_CTRLB_SMEN_Msk   = 0x100   // Bit mask of SMEN field.
	SERCOM_I2CM_CTRLB_SMEN       = 0x100   // Bit SMEN.
	SERCOM_I2CM_CTRLB_QCEN_Pos   = 0x9     // Position of QCEN field.
	SERCOM_I2CM_CTRLB_QCEN_Msk   = 0x200   // Bit mask of QCEN field.
	SERCOM_I2CM_CTRLB_QCEN       = 0x200   // Bit QCEN.
	SERCOM_I2CM_CTRLB_CMD_Pos    = 0x10    // Position of CMD field.
	SERCOM_I2CM_CTRLB_CMD_Msk    = 0x30000 // Bit mask of CMD field.
	SERCOM_I2CM_CTRLB_ACKACT_Pos = 0x12    // Position of ACKACT field.
	SERCOM_I2CM_CTRLB_ACKACT_Msk = 0x40000 // Bit mask of ACKACT field.
	SERCOM_I2CM_CTRLB_ACKACT     = 0x40000 // Bit ACKACT.

	// BAUD: I2CM Baud Rate
	SERCOM_I2CM_BAUD_BAUD_Pos      = 0x0        // Position of BAUD field.
	SERCOM_I2CM_BAUD_BAUD_Msk      = 0xff       // Bit mask of BAUD field.
	SERCOM_I2CM_BAUD_BAUDLOW_Pos   = 0x8        // Position of BAUDLOW field.
	SERCOM_I2CM_BAUD_BAUDLOW_Msk   = 0xff00     // Bit mask of BAUDLOW field.
	SERCOM_I2CM_BAUD_HSBAUD_Pos    = 0x10       // Position of HSBAUD field.
	SERCOM_I2CM_BAUD_HSBAUD_Msk    = 0xff0000   // Bit mask of HSBAUD field.
	SERCOM_I2CM_BAUD_HSBAUDLOW_Pos = 0x18       // Position of HSBAUDLOW field.
	SERCOM_I2CM_BAUD_HSBAUDLOW_Msk = 0xff000000 // Bit mask of HSBAUDLOW field.

	// INTENCLR: I2CM Interrupt Enable Clear
	SERCOM_I2CM_INTENCLR_MB_Pos    = 0x0  // Position of MB field.
	SERCOM_I2CM_INTENCLR_MB_Msk    = 0x1  // Bit mask of MB field.
	SERCOM_I2CM_INTENCLR_MB        = 0x1  // Bit MB.
	SERCOM_I2CM_INTENCLR_SB_Pos    = 0x1  // Position of SB field.
	SERCOM_I2CM_INTENCLR_SB_Msk    = 0x2  // Bit mask of SB field.
	SERCOM_I2CM_INTENCLR_SB        = 0x2  // Bit SB.
	SERCOM_I2CM_INTENCLR_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_I2CM_INTENCLR_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_I2CM_INTENCLR_ERROR     = 0x80 // Bit ERROR.

	// INTENSET: I2CM Interrupt Enable Set
	SERCOM_I2CM_INTENSET_MB_Pos    = 0x0  // Position of MB field.
	SERCOM_I2CM_INTENSET_MB_Msk    = 0x1  // Bit mask of MB field.
	SERCOM_I2CM_INTENSET_MB        = 0x1  // Bit MB.
	SERCOM_I2CM_INTENSET_SB_Pos    = 0x1  // Position of SB field.
	SERCOM_I2CM_INTENSET_SB_Msk    = 0x2  // Bit mask of SB field.
	SERCOM_I2CM_INTENSET_SB        = 0x2  // Bit SB.
	SERCOM_I2CM_INTENSET_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_I2CM_INTENSET_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_I2CM_INTENSET_ERROR     = 0x80 // Bit ERROR.

	// INTFLAG: I2CM Interrupt Flag Status and Clear
	SERCOM_I2CM_INTFLAG_MB_Pos    = 0x0  // Position of MB field.
	SERCOM_I2CM_INTFLAG_MB_Msk    = 0x1  // Bit mask of MB field.
	SERCOM_I2CM_INTFLAG_MB        = 0x1  // Bit MB.
	SERCOM_I2CM_INTFLAG_SB_Pos    = 0x1  // Position of SB field.
	SERCOM_I2CM_INTFLAG_SB_Msk    = 0x2  // Bit mask of SB field.
	SERCOM_I2CM_INTFLAG_SB        = 0x2  // Bit SB.
	SERCOM_I2CM_INTFLAG_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_I2CM_INTFLAG_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_I2CM_INTFLAG_ERROR     = 0x80 // Bit ERROR.

	// STATUS: I2CM Status
	SERCOM_I2CM_STATUS_BUSERR_Pos   = 0x0   // Position of BUSERR field.
	SERCOM_I2CM_STATUS_BUSERR_Msk   = 0x1   // Bit mask of BUSERR field.
	SERCOM_I2CM_STATUS_BUSERR       = 0x1   // Bit BUSERR.
	SERCOM_I2CM_STATUS_ARBLOST_Pos  = 0x1   // Position of ARBLOST field.
	SERCOM_I2CM_STATUS_ARBLOST_Msk  = 0x2   // Bit mask of ARBLOST field.
	SERCOM_I2CM_STATUS_ARBLOST      = 0x2   // Bit ARBLOST.
	SERCOM_I2CM_STATUS_RXNACK_Pos   = 0x2   // Position of RXNACK field.
	SERCOM_I2CM_STATUS_RXNACK_Msk   = 0x4   // Bit mask of RXNACK field.
	SERCOM_I2CM_STATUS_RXNACK       = 0x4   // Bit RXNACK.
	SERCOM_I2CM_STATUS_BUSSTATE_Pos = 0x4   // Position of BUSSTATE field.
	SERCOM_I2CM_STATUS_BUSSTATE_Msk = 0x30  // Bit mask of BUSSTATE field.
	SERCOM_I2CM_STATUS_LOWTOUT_Pos  = 0x6   // Position of LOWTOUT field.
	SERCOM_I2CM_STATUS_LOWTOUT_Msk  = 0x40  // Bit mask of LOWTOUT field.
	SERCOM_I2CM_STATUS_LOWTOUT      = 0x40  // Bit LOWTOUT.
	SERCOM_I2CM_STATUS_CLKHOLD_Pos  = 0x7   // Position of CLKHOLD field.
	SERCOM_I2CM_STATUS_CLKHOLD_Msk  = 0x80  // Bit mask of CLKHOLD field.
	SERCOM_I2CM_STATUS_CLKHOLD      = 0x80  // Bit CLKHOLD.
	SERCOM_I2CM_STATUS_MEXTTOUT_Pos = 0x8   // Position of MEXTTOUT field.
	SERCOM_I2CM_STATUS_MEXTTOUT_Msk = 0x100 // Bit mask of MEXTTOUT field.
	SERCOM_I2CM_STATUS_MEXTTOUT     = 0x100 // Bit MEXTTOUT.
	SERCOM_I2CM_STATUS_SEXTTOUT_Pos = 0x9   // Position of SEXTTOUT field.
	SERCOM_I2CM_STATUS_SEXTTOUT_Msk = 0x200 // Bit mask of SEXTTOUT field.
	SERCOM_I2CM_STATUS_SEXTTOUT     = 0x200 // Bit SEXTTOUT.
	SERCOM_I2CM_STATUS_LENERR_Pos   = 0xa   // Position of LENERR field.
	SERCOM_I2CM_STATUS_LENERR_Msk   = 0x400 // Bit mask of LENERR field.
	SERCOM_I2CM_STATUS_LENERR       = 0x400 // Bit LENERR.

	// SYNCBUSY: I2CM Synchronization Busy
	SERCOM_I2CM_SYNCBUSY_SWRST_Pos  = 0x0 // Position of SWRST field.
	SERCOM_I2CM_SYNCBUSY_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	SERCOM_I2CM_SYNCBUSY_SWRST      = 0x1 // Bit SWRST.
	SERCOM_I2CM_SYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	SERCOM_I2CM_SYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	SERCOM_I2CM_SYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.
	SERCOM_I2CM_SYNCBUSY_SYSOP_Pos  = 0x2 // Position of SYSOP field.
	SERCOM_I2CM_SYNCBUSY_SYSOP_Msk  = 0x4 // Bit mask of SYSOP field.
	SERCOM_I2CM_SYNCBUSY_SYSOP      = 0x4 // Bit SYSOP.

	// ADDR: I2CM Address
	SERCOM_I2CM_ADDR_ADDR_Pos     = 0x0      // Position of ADDR field.
	SERCOM_I2CM_ADDR_ADDR_Msk     = 0x7ff    // Bit mask of ADDR field.
	SERCOM_I2CM_ADDR_LENEN_Pos    = 0xd      // Position of LENEN field.
	SERCOM_I2CM_ADDR_LENEN_Msk    = 0x2000   // Bit mask of LENEN field.
	SERCOM_I2CM_ADDR_LENEN        = 0x2000   // Bit LENEN.
	SERCOM_I2CM_ADDR_HS_Pos       = 0xe      // Position of HS field.
	SERCOM_I2CM_ADDR_HS_Msk       = 0x4000   // Bit mask of HS field.
	SERCOM_I2CM_ADDR_HS           = 0x4000   // Bit HS.
	SERCOM_I2CM_ADDR_TENBITEN_Pos = 0xf      // Position of TENBITEN field.
	SERCOM_I2CM_ADDR_TENBITEN_Msk = 0x8000   // Bit mask of TENBITEN field.
	SERCOM_I2CM_ADDR_TENBITEN     = 0x8000   // Bit TENBITEN.
	SERCOM_I2CM_ADDR_LEN_Pos      = 0x10     // Position of LEN field.
	SERCOM_I2CM_ADDR_LEN_Msk      = 0xff0000 // Bit mask of LEN field.

	// DATA: I2CM Data
	SERCOM_I2CM_DATA_DATA_Pos = 0x0  // Position of DATA field.
	SERCOM_I2CM_DATA_DATA_Msk = 0xff // Bit mask of DATA field.

	// DBGCTRL: I2CM Debug Control
	SERCOM_I2CM_DBGCTRL_DBGSTOP_Pos = 0x0 // Position of DBGSTOP field.
	SERCOM_I2CM_DBGCTRL_DBGSTOP_Msk = 0x1 // Bit mask of DBGSTOP field.
	SERCOM_I2CM_DBGCTRL_DBGSTOP     = 0x1 // Bit DBGSTOP.
)

// Bitfields for SERCOM0_I2CS: Serial Communication Interface - I2CS
const (
	// CTRLA: I2CS Control A
	SERCOM_I2CS_CTRLA_SWRST_Pos     = 0x0        // Position of SWRST field.
	SERCOM_I2CS_CTRLA_SWRST_Msk     = 0x1        // Bit mask of SWRST field.
	SERCOM_I2CS_CTRLA_SWRST         = 0x1        // Bit SWRST.
	SERCOM_I2CS_CTRLA_ENABLE_Pos    = 0x1        // Position of ENABLE field.
	SERCOM_I2CS_CTRLA_ENABLE_Msk    = 0x2        // Bit mask of ENABLE field.
	SERCOM_I2CS_CTRLA_ENABLE        = 0x2        // Bit ENABLE.
	SERCOM_I2CS_CTRLA_MODE_Pos      = 0x2        // Position of MODE field.
	SERCOM_I2CS_CTRLA_MODE_Msk      = 0x1c       // Bit mask of MODE field.
	SERCOM_I2CS_CTRLA_RUNSTDBY_Pos  = 0x7        // Position of RUNSTDBY field.
	SERCOM_I2CS_CTRLA_RUNSTDBY_Msk  = 0x80       // Bit mask of RUNSTDBY field.
	SERCOM_I2CS_CTRLA_RUNSTDBY      = 0x80       // Bit RUNSTDBY.
	SERCOM_I2CS_CTRLA_PINOUT_Pos    = 0x10       // Position of PINOUT field.
	SERCOM_I2CS_CTRLA_PINOUT_Msk    = 0x10000    // Bit mask of PINOUT field.
	SERCOM_I2CS_CTRLA_PINOUT        = 0x10000    // Bit PINOUT.
	SERCOM_I2CS_CTRLA_SDAHOLD_Pos   = 0x14       // Position of SDAHOLD field.
	SERCOM_I2CS_CTRLA_SDAHOLD_Msk   = 0x300000   // Bit mask of SDAHOLD field.
	SERCOM_I2CS_CTRLA_SEXTTOEN_Pos  = 0x17       // Position of SEXTTOEN field.
	SERCOM_I2CS_CTRLA_SEXTTOEN_Msk  = 0x800000   // Bit mask of SEXTTOEN field.
	SERCOM_I2CS_CTRLA_SEXTTOEN      = 0x800000   // Bit SEXTTOEN.
	SERCOM_I2CS_CTRLA_SPEED_Pos     = 0x18       // Position of SPEED field.
	SERCOM_I2CS_CTRLA_SPEED_Msk     = 0x3000000  // Bit mask of SPEED field.
	SERCOM_I2CS_CTRLA_SCLSM_Pos     = 0x1b       // Position of SCLSM field.
	SERCOM_I2CS_CTRLA_SCLSM_Msk     = 0x8000000  // Bit mask of SCLSM field.
	SERCOM_I2CS_CTRLA_SCLSM         = 0x8000000  // Bit SCLSM.
	SERCOM_I2CS_CTRLA_LOWTOUTEN_Pos = 0x1e       // Position of LOWTOUTEN field.
	SERCOM_I2CS_CTRLA_LOWTOUTEN_Msk = 0x40000000 // Bit mask of LOWTOUTEN field.
	SERCOM_I2CS_CTRLA_LOWTOUTEN     = 0x40000000 // Bit LOWTOUTEN.

	// CTRLB: I2CS Control B
	SERCOM_I2CS_CTRLB_SMEN_Pos   = 0x8     // Position of SMEN field.
	SERCOM_I2CS_CTRLB_SMEN_Msk   = 0x100   // Bit mask of SMEN field.
	SERCOM_I2CS_CTRLB_SMEN       = 0x100   // Bit SMEN.
	SERCOM_I2CS_CTRLB_GCMD_Pos   = 0x9     // Position of GCMD field.
	SERCOM_I2CS_CTRLB_GCMD_Msk   = 0x200   // Bit mask of GCMD field.
	SERCOM_I2CS_CTRLB_GCMD       = 0x200   // Bit GCMD.
	SERCOM_I2CS_CTRLB_AACKEN_Pos = 0xa     // Position of AACKEN field.
	SERCOM_I2CS_CTRLB_AACKEN_Msk = 0x400   // Bit mask of AACKEN field.
	SERCOM_I2CS_CTRLB_AACKEN     = 0x400   // Bit AACKEN.
	SERCOM_I2CS_CTRLB_AMODE_Pos  = 0xe     // Position of AMODE field.
	SERCOM_I2CS_CTRLB_AMODE_Msk  = 0xc000  // Bit mask of AMODE field.
	SERCOM_I2CS_CTRLB_CMD_Pos    = 0x10    // Position of CMD field.
	SERCOM_I2CS_CTRLB_CMD_Msk    = 0x30000 // Bit mask of CMD field.
	SERCOM_I2CS_CTRLB_ACKACT_Pos = 0x12    // Position of ACKACT field.
	SERCOM_I2CS_CTRLB_ACKACT_Msk = 0x40000 // Bit mask of ACKACT field.
	SERCOM_I2CS_CTRLB_ACKACT     = 0x40000 // Bit ACKACT.

	// INTENCLR: I2CS Interrupt Enable Clear
	SERCOM_I2CS_INTENCLR_PREC_Pos   = 0x0  // Position of PREC field.
	SERCOM_I2CS_INTENCLR_PREC_Msk   = 0x1  // Bit mask of PREC field.
	SERCOM_I2CS_INTENCLR_PREC       = 0x1  // Bit PREC.
	SERCOM_I2CS_INTENCLR_AMATCH_Pos = 0x1  // Position of AMATCH field.
	SERCOM_I2CS_INTENCLR_AMATCH_Msk = 0x2  // Bit mask of AMATCH field.
	SERCOM_I2CS_INTENCLR_AMATCH     = 0x2  // Bit AMATCH.
	SERCOM_I2CS_INTENCLR_DRDY_Pos   = 0x2  // Position of DRDY field.
	SERCOM_I2CS_INTENCLR_DRDY_Msk   = 0x4  // Bit mask of DRDY field.
	SERCOM_I2CS_INTENCLR_DRDY       = 0x4  // Bit DRDY.
	SERCOM_I2CS_INTENCLR_ERROR_Pos  = 0x7  // Position of ERROR field.
	SERCOM_I2CS_INTENCLR_ERROR_Msk  = 0x80 // Bit mask of ERROR field.
	SERCOM_I2CS_INTENCLR_ERROR      = 0x80 // Bit ERROR.

	// INTENSET: I2CS Interrupt Enable Set
	SERCOM_I2CS_INTENSET_PREC_Pos   = 0x0  // Position of PREC field.
	SERCOM_I2CS_INTENSET_PREC_Msk   = 0x1  // Bit mask of PREC field.
	SERCOM_I2CS_INTENSET_PREC       = 0x1  // Bit PREC.
	SERCOM_I2CS_INTENSET_AMATCH_Pos = 0x1  // Position of AMATCH field.
	SERCOM_I2CS_INTENSET_AMATCH_Msk = 0x2  // Bit mask of AMATCH field.
	SERCOM_I2CS_INTENSET_AMATCH     = 0x2  // Bit AMATCH.
	SERCOM_I2CS_INTENSET_DRDY_Pos   = 0x2  // Position of DRDY field.
	SERCOM_I2CS_INTENSET_DRDY_Msk   = 0x4  // Bit mask of DRDY field.
	SERCOM_I2CS_INTENSET_DRDY       = 0x4  // Bit DRDY.
	SERCOM_I2CS_INTENSET_ERROR_Pos  = 0x7  // Position of ERROR field.
	SERCOM_I2CS_INTENSET_ERROR_Msk  = 0x80 // Bit mask of ERROR field.
	SERCOM_I2CS_INTENSET_ERROR      = 0x80 // Bit ERROR.

	// INTFLAG: I2CS Interrupt Flag Status and Clear
	SERCOM_I2CS_INTFLAG_PREC_Pos   = 0x0  // Position of PREC field.
	SERCOM_I2CS_INTFLAG_PREC_Msk   = 0x1  // Bit mask of PREC field.
	SERCOM_I2CS_INTFLAG_PREC       = 0x1  // Bit PREC.
	SERCOM_I2CS_INTFLAG_AMATCH_Pos = 0x1  // Position of AMATCH field.
	SERCOM_I2CS_INTFLAG_AMATCH_Msk = 0x2  // Bit mask of AMATCH field.
	SERCOM_I2CS_INTFLAG_AMATCH     = 0x2  // Bit AMATCH.
	SERCOM_I2CS_INTFLAG_DRDY_Pos   = 0x2  // Position of DRDY field.
	SERCOM_I2CS_INTFLAG_DRDY_Msk   = 0x4  // Bit mask of DRDY field.
	SERCOM_I2CS_INTFLAG_DRDY       = 0x4  // Bit DRDY.
	SERCOM_I2CS_INTFLAG_ERROR_Pos  = 0x7  // Position of ERROR field.
	SERCOM_I2CS_INTFLAG_ERROR_Msk  = 0x80 // Bit mask of ERROR field.
	SERCOM_I2CS_INTFLAG_ERROR      = 0x80 // Bit ERROR.

	// STATUS: I2CS Status
	SERCOM_I2CS_STATUS_BUSERR_Pos   = 0x0   // Position of BUSERR field.
	SERCOM_I2CS_STATUS_BUSERR_Msk   = 0x1   // Bit mask of BUSERR field.
	SERCOM_I2CS_STATUS_BUSERR       = 0x1   // Bit BUSERR.
	SERCOM_I2CS_STATUS_COLL_Pos     = 0x1   // Position of COLL field.
	SERCOM_I2CS_STATUS_COLL_Msk     = 0x2   // Bit mask of COLL field.
	SERCOM_I2CS_STATUS_COLL         = 0x2   // Bit COLL.
	SERCOM_I2CS_STATUS_RXNACK_Pos   = 0x2   // Position of RXNACK field.
	SERCOM_I2CS_STATUS_RXNACK_Msk   = 0x4   // Bit mask of RXNACK field.
	SERCOM_I2CS_STATUS_RXNACK       = 0x4   // Bit RXNACK.
	SERCOM_I2CS_STATUS_DIR_Pos      = 0x3   // Position of DIR field.
	SERCOM_I2CS_STATUS_DIR_Msk      = 0x8   // Bit mask of DIR field.
	SERCOM_I2CS_STATUS_DIR          = 0x8   // Bit DIR.
	SERCOM_I2CS_STATUS_SR_Pos       = 0x4   // Position of SR field.
	SERCOM_I2CS_STATUS_SR_Msk       = 0x10  // Bit mask of SR field.
	SERCOM_I2CS_STATUS_SR           = 0x10  // Bit SR.
	SERCOM_I2CS_STATUS_LOWTOUT_Pos  = 0x6   // Position of LOWTOUT field.
	SERCOM_I2CS_STATUS_LOWTOUT_Msk  = 0x40  // Bit mask of LOWTOUT field.
	SERCOM_I2CS_STATUS_LOWTOUT      = 0x40  // Bit LOWTOUT.
	SERCOM_I2CS_STATUS_CLKHOLD_Pos  = 0x7   // Position of CLKHOLD field.
	SERCOM_I2CS_STATUS_CLKHOLD_Msk  = 0x80  // Bit mask of CLKHOLD field.
	SERCOM_I2CS_STATUS_CLKHOLD      = 0x80  // Bit CLKHOLD.
	SERCOM_I2CS_STATUS_SEXTTOUT_Pos = 0x9   // Position of SEXTTOUT field.
	SERCOM_I2CS_STATUS_SEXTTOUT_Msk = 0x200 // Bit mask of SEXTTOUT field.
	SERCOM_I2CS_STATUS_SEXTTOUT     = 0x200 // Bit SEXTTOUT.
	SERCOM_I2CS_STATUS_HS_Pos       = 0xa   // Position of HS field.
	SERCOM_I2CS_STATUS_HS_Msk       = 0x400 // Bit mask of HS field.
	SERCOM_I2CS_STATUS_HS           = 0x400 // Bit HS.

	// SYNCBUSY: I2CS Synchronization Busy
	SERCOM_I2CS_SYNCBUSY_SWRST_Pos  = 0x0 // Position of SWRST field.
	SERCOM_I2CS_SYNCBUSY_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	SERCOM_I2CS_SYNCBUSY_SWRST      = 0x1 // Bit SWRST.
	SERCOM_I2CS_SYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	SERCOM_I2CS_SYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	SERCOM_I2CS_SYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.

	// ADDR: I2CS Address
	SERCOM_I2CS_ADDR_GENCEN_Pos   = 0x0       // Position of GENCEN field.
	SERCOM_I2CS_ADDR_GENCEN_Msk   = 0x1       // Bit mask of GENCEN field.
	SERCOM_I2CS_ADDR_GENCEN       = 0x1       // Bit GENCEN.
	SERCOM_I2CS_ADDR_ADDR_Pos     = 0x1       // Position of ADDR field.
	SERCOM_I2CS_ADDR_ADDR_Msk     = 0x7fe     // Bit mask of ADDR field.
	SERCOM_I2CS_ADDR_TENBITEN_Pos = 0xf       // Position of TENBITEN field.
	SERCOM_I2CS_ADDR_TENBITEN_Msk = 0x8000    // Bit mask of TENBITEN field.
	SERCOM_I2CS_ADDR_TENBITEN     = 0x8000    // Bit TENBITEN.
	SERCOM_I2CS_ADDR_ADDRMASK_Pos = 0x11      // Position of ADDRMASK field.
	SERCOM_I2CS_ADDR_ADDRMASK_Msk = 0x7fe0000 // Bit mask of ADDRMASK field.

	// DATA: I2CS Data
	SERCOM_I2CS_DATA_DATA_Pos = 0x0  // Position of DATA field.
	SERCOM_I2CS_DATA_DATA_Msk = 0xff // Bit mask of DATA field.
)

// Bitfields for SERCOM0_SPI: Serial Communication Interface - SPI
const (
	// CTRLA: SPI Control A
	SERCOM_SPI_CTRLA_SWRST_Pos    = 0x0        // Position of SWRST field.
	SERCOM_SPI_CTRLA_SWRST_Msk    = 0x1        // Bit mask of SWRST field.
	SERCOM_SPI_CTRLA_SWRST        = 0x1        // Bit SWRST.
	SERCOM_SPI_CTRLA_ENABLE_Pos   = 0x1        // Position of ENABLE field.
	SERCOM_SPI_CTRLA_ENABLE_Msk   = 0x2        // Bit mask of ENABLE field.
	SERCOM_SPI_CTRLA_ENABLE       = 0x2        // Bit ENABLE.
	SERCOM_SPI_CTRLA_MODE_Pos     = 0x2        // Position of MODE field.
	SERCOM_SPI_CTRLA_MODE_Msk     = 0x1c       // Bit mask of MODE field.
	SERCOM_SPI_CTRLA_RUNSTDBY_Pos = 0x7        // Position of RUNSTDBY field.
	SERCOM_SPI_CTRLA_RUNSTDBY_Msk = 0x80       // Bit mask of RUNSTDBY field.
	SERCOM_SPI_CTRLA_RUNSTDBY     = 0x80       // Bit RUNSTDBY.
	SERCOM_SPI_CTRLA_IBON_Pos     = 0x8        // Position of IBON field.
	SERCOM_SPI_CTRLA_IBON_Msk     = 0x100      // Bit mask of IBON field.
	SERCOM_SPI_CTRLA_IBON         = 0x100      // Bit IBON.
	SERCOM_SPI_CTRLA_DOPO_Pos     = 0x10       // Position of DOPO field.
	SERCOM_SPI_CTRLA_DOPO_Msk     = 0x30000    // Bit mask of DOPO field.
	SERCOM_SPI_CTRLA_DIPO_Pos     = 0x14       // Position of DIPO field.
	SERCOM_SPI_CTRLA_DIPO_Msk     = 0x300000   // Bit mask of DIPO field.
	SERCOM_SPI_CTRLA_FORM_Pos     = 0x18       // Position of FORM field.
	SERCOM_SPI_CTRLA_FORM_Msk     = 0xf000000  // Bit mask of FORM field.
	SERCOM_SPI_CTRLA_CPHA_Pos     = 0x1c       // Position of CPHA field.
	SERCOM_SPI_CTRLA_CPHA_Msk     = 0x10000000 // Bit mask of CPHA field.
	SERCOM_SPI_CTRLA_CPHA         = 0x10000000 // Bit CPHA.
	SERCOM_SPI_CTRLA_CPOL_Pos     = 0x1d       // Position of CPOL field.
	SERCOM_SPI_CTRLA_CPOL_Msk     = 0x20000000 // Bit mask of CPOL field.
	SERCOM_SPI_CTRLA_CPOL         = 0x20000000 // Bit CPOL.
	SERCOM_SPI_CTRLA_DORD_Pos     = 0x1e       // Position of DORD field.
	SERCOM_SPI_CTRLA_DORD_Msk     = 0x40000000 // Bit mask of DORD field.
	SERCOM_SPI_CTRLA_DORD         = 0x40000000 // Bit DORD.

	// CTRLB: SPI Control B
	SERCOM_SPI_CTRLB_CHSIZE_Pos  = 0x0     // Position of CHSIZE field.
	SERCOM_SPI_CTRLB_CHSIZE_Msk  = 0x7     // Bit mask of CHSIZE field.
	SERCOM_SPI_CTRLB_PLOADEN_Pos = 0x6     // Position of PLOADEN field.
	SERCOM_SPI_CTRLB_PLOADEN_Msk = 0x40    // Bit mask of PLOADEN field.
	SERCOM_SPI_CTRLB_PLOADEN     = 0x40    // Bit PLOADEN.
	SERCOM_SPI_CTRLB_SSDE_Pos    = 0x9     // Position of SSDE field.
	SERCOM_SPI_CTRLB_SSDE_Msk    = 0x200   // Bit mask of SSDE field.
	SERCOM_SPI_CTRLB_SSDE        = 0x200   // Bit SSDE.
	SERCOM_SPI_CTRLB_MSSEN_Pos   = 0xd     // Position of MSSEN field.
	SERCOM_SPI_CTRLB_MSSEN_Msk   = 0x2000  // Bit mask of MSSEN field.
	SERCOM_SPI_CTRLB_MSSEN       = 0x2000  // Bit MSSEN.
	SERCOM_SPI_CTRLB_AMODE_Pos   = 0xe     // Position of AMODE field.
	SERCOM_SPI_CTRLB_AMODE_Msk   = 0xc000  // Bit mask of AMODE field.
	SERCOM_SPI_CTRLB_RXEN_Pos    = 0x11    // Position of RXEN field.
	SERCOM_SPI_CTRLB_RXEN_Msk    = 0x20000 // Bit mask of RXEN field.
	SERCOM_SPI_CTRLB_RXEN        = 0x20000 // Bit RXEN.

	// BAUD: SPI Baud Rate
	SERCOM_SPI_BAUD_BAUD_Pos = 0x0  // Position of BAUD field.
	SERCOM_SPI_BAUD_BAUD_Msk = 0xff // Bit mask of BAUD field.

	// INTENCLR: SPI Interrupt Enable Clear
	SERCOM_SPI_INTENCLR_DRE_Pos   = 0x0  // Position of DRE field.
	SERCOM_SPI_INTENCLR_DRE_Msk   = 0x1  // Bit mask of DRE field.
	SERCOM_SPI_INTENCLR_DRE       = 0x1  // Bit DRE.
	SERCOM_SPI_INTENCLR_TXC_Pos   = 0x1  // Position of TXC field.
	SERCOM_SPI_INTENCLR_TXC_Msk   = 0x2  // Bit mask of TXC field.
	SERCOM_SPI_INTENCLR_TXC       = 0x2  // Bit TXC.
	SERCOM_SPI_INTENCLR_RXC_Pos   = 0x2  // Position of RXC field.
	SERCOM_SPI_INTENCLR_RXC_Msk   = 0x4  // Bit mask of RXC field.
	SERCOM_SPI_INTENCLR_RXC       = 0x4  // Bit RXC.
	SERCOM_SPI_INTENCLR_SSL_Pos   = 0x3  // Position of SSL field.
	SERCOM_SPI_INTENCLR_SSL_Msk   = 0x8  // Bit mask of SSL field.
	SERCOM_SPI_INTENCLR_SSL       = 0x8  // Bit SSL.
	SERCOM_SPI_INTENCLR_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_SPI_INTENCLR_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_SPI_INTENCLR_ERROR     = 0x80 // Bit ERROR.

	// INTENSET: SPI Interrupt Enable Set
	SERCOM_SPI_INTENSET_DRE_Pos   = 0x0  // Position of DRE field.
	SERCOM_SPI_INTENSET_DRE_Msk   = 0x1  // Bit mask of DRE field.
	SERCOM_SPI_INTENSET_DRE       = 0x1  // Bit DRE.
	SERCOM_SPI_INTENSET_TXC_Pos   = 0x1  // Position of TXC field.
	SERCOM_SPI_INTENSET_TXC_Msk   = 0x2  // Bit mask of TXC field.
	SERCOM_SPI_INTENSET_TXC       = 0x2  // Bit TXC.
	SERCOM_SPI_INTENSET_RXC_Pos   = 0x2  // Position of RXC field.
	SERCOM_SPI_INTENSET_RXC_Msk   = 0x4  // Bit mask of RXC field.
	SERCOM_SPI_INTENSET_RXC       = 0x4  // Bit RXC.
	SERCOM_SPI_INTENSET_SSL_Pos   = 0x3  // Position of SSL field.
	SERCOM_SPI_INTENSET_SSL_Msk   = 0x8  // Bit mask of SSL field.
	SERCOM_SPI_INTENSET_SSL       = 0x8  // Bit SSL.
	SERCOM_SPI_INTENSET_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_SPI_INTENSET_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_SPI_INTENSET_ERROR     = 0x80 // Bit ERROR.

	// INTFLAG: SPI Interrupt Flag Status and Clear
	SERCOM_SPI_INTFLAG_DRE_Pos   = 0x0  // Position of DRE field.
	SERCOM_SPI_INTFLAG_DRE_Msk   = 0x1  // Bit mask of DRE field.
	SERCOM_SPI_INTFLAG_DRE       = 0x1  // Bit DRE.
	SERCOM_SPI_INTFLAG_TXC_Pos   = 0x1  // Position of TXC field.
	SERCOM_SPI_INTFLAG_TXC_Msk   = 0x2  // Bit mask of TXC field.
	SERCOM_SPI_INTFLAG_TXC       = 0x2  // Bit TXC.
	SERCOM_SPI_INTFLAG_RXC_Pos   = 0x2  // Position of RXC field.
	SERCOM_SPI_INTFLAG_RXC_Msk   = 0x4  // Bit mask of RXC field.
	SERCOM_SPI_INTFLAG_RXC       = 0x4  // Bit RXC.
	SERCOM_SPI_INTFLAG_SSL_Pos   = 0x3  // Position of SSL field.
	SERCOM_SPI_INTFLAG_SSL_Msk   = 0x8  // Bit mask of SSL field.
	SERCOM_SPI_INTFLAG_SSL       = 0x8  // Bit SSL.
	SERCOM_SPI_INTFLAG_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_SPI_INTFLAG_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_SPI_INTFLAG_ERROR     = 0x80 // Bit ERROR.

	// STATUS: SPI Status
	SERCOM_SPI_STATUS_BUFOVF_Pos = 0x2 // Position of BUFOVF field.
	SERCOM_SPI_STATUS_BUFOVF_Msk = 0x4 // Bit mask of BUFOVF field.
	SERCOM_SPI_STATUS_BUFOVF     = 0x4 // Bit BUFOVF.

	// SYNCBUSY: SPI Synchronization Busy
	SERCOM_SPI_SYNCBUSY_SWRST_Pos  = 0x0 // Position of SWRST field.
	SERCOM_SPI_SYNCBUSY_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	SERCOM_SPI_SYNCBUSY_SWRST      = 0x1 // Bit SWRST.
	SERCOM_SPI_SYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	SERCOM_SPI_SYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	SERCOM_SPI_SYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.
	SERCOM_SPI_SYNCBUSY_CTRLB_Pos  = 0x2 // Position of CTRLB field.
	SERCOM_SPI_SYNCBUSY_CTRLB_Msk  = 0x4 // Bit mask of CTRLB field.
	SERCOM_SPI_SYNCBUSY_CTRLB      = 0x4 // Bit CTRLB.

	// ADDR: SPI Address
	SERCOM_SPI_ADDR_ADDR_Pos     = 0x0      // Position of ADDR field.
	SERCOM_SPI_ADDR_ADDR_Msk     = 0xff     // Bit mask of ADDR field.
	SERCOM_SPI_ADDR_ADDRMASK_Pos = 0x10     // Position of ADDRMASK field.
	SERCOM_SPI_ADDR_ADDRMASK_Msk = 0xff0000 // Bit mask of ADDRMASK field.

	// DATA: SPI Data
	SERCOM_SPI_DATA_DATA_Pos = 0x0   // Position of DATA field.
	SERCOM_SPI_DATA_DATA_Msk = 0x1ff // Bit mask of DATA field.

	// DBGCTRL: SPI Debug Control
	SERCOM_SPI_DBGCTRL_DBGSTOP_Pos = 0x0 // Position of DBGSTOP field.
	SERCOM_SPI_DBGCTRL_DBGSTOP_Msk = 0x1 // Bit mask of DBGSTOP field.
	SERCOM_SPI_DBGCTRL_DBGSTOP     = 0x1 // Bit DBGSTOP.
)

// Bitfields for SERCOM0_USART: Serial Communication Interface - USART
const (
	// CTRLA: USART Control A
	SERCOM_USART_CTRLA_SWRST_Pos    = 0x0        // Position of SWRST field.
	SERCOM_USART_CTRLA_SWRST_Msk    = 0x1        // Bit mask of SWRST field.
	SERCOM_USART_CTRLA_SWRST        = 0x1        // Bit SWRST.
	SERCOM_USART_CTRLA_ENABLE_Pos   = 0x1        // Position of ENABLE field.
	SERCOM_USART_CTRLA_ENABLE_Msk   = 0x2        // Bit mask of ENABLE field.
	SERCOM_USART_CTRLA_ENABLE       = 0x2        // Bit ENABLE.
	SERCOM_USART_CTRLA_MODE_Pos     = 0x2        // Position of MODE field.
	SERCOM_USART_CTRLA_MODE_Msk     = 0x1c       // Bit mask of MODE field.
	SERCOM_USART_CTRLA_RUNSTDBY_Pos = 0x7        // Position of RUNSTDBY field.
	SERCOM_USART_CTRLA_RUNSTDBY_Msk = 0x80       // Bit mask of RUNSTDBY field.
	SERCOM_USART_CTRLA_RUNSTDBY     = 0x80       // Bit RUNSTDBY.
	SERCOM_USART_CTRLA_IBON_Pos     = 0x8        // Position of IBON field.
	SERCOM_USART_CTRLA_IBON_Msk     = 0x100      // Bit mask of IBON field.
	SERCOM_USART_CTRLA_IBON         = 0x100      // Bit IBON.
	SERCOM_USART_CTRLA_TXINV_Pos    = 0x9        // Position of TXINV field.
	SERCOM_USART_CTRLA_TXINV_Msk    = 0x200      // Bit mask of TXINV field.
	SERCOM_USART_CTRLA_TXINV        = 0x200      // Bit TXINV.
	SERCOM_USART_CTRLA_RXINV_Pos    = 0xa        // Position of RXINV field.
	SERCOM_USART_CTRLA_RXINV_Msk    = 0x400      // Bit mask of RXINV field.
	SERCOM_USART_CTRLA_RXINV        = 0x400      // Bit RXINV.
	SERCOM_USART_CTRLA_SAMPR_Pos    = 0xd        // Position of SAMPR field.
	SERCOM_USART_CTRLA_SAMPR_Msk    = 0xe000     // Bit mask of SAMPR field.
	SERCOM_USART_CTRLA_TXPO_Pos     = 0x10       // Position of TXPO field.
	SERCOM_USART_CTRLA_TXPO_Msk     = 0x30000    // Bit mask of TXPO field.
	SERCOM_USART_CTRLA_RXPO_Pos     = 0x14       // Position of RXPO field.
	SERCOM_USART_CTRLA_RXPO_Msk     = 0x300000   // Bit mask of RXPO field.
	SERCOM_USART_CTRLA_SAMPA_Pos    = 0x16       // Position of SAMPA field.
	SERCOM_USART_CTRLA_SAMPA_Msk    = 0xc00000   // Bit mask of SAMPA field.
	SERCOM_USART_CTRLA_FORM_Pos     = 0x18       // Position of FORM field.
	SERCOM_USART_CTRLA_FORM_Msk     = 0xf000000  // Bit mask of FORM field.
	SERCOM_USART_CTRLA_CMODE_Pos    = 0x1c       // Position of CMODE field.
	SERCOM_USART_CTRLA_CMODE_Msk    = 0x10000000 // Bit mask of CMODE field.
	SERCOM_USART_CTRLA_CMODE        = 0x10000000 // Bit CMODE.
	SERCOM_USART_CTRLA_CPOL_Pos     = 0x1d       // Position of CPOL field.
	SERCOM_USART_CTRLA_CPOL_Msk     = 0x20000000 // Bit mask of CPOL field.
	SERCOM_USART_CTRLA_CPOL         = 0x20000000 // Bit CPOL.
	SERCOM_USART_CTRLA_DORD_Pos     = 0x1e       // Position of DORD field.
	SERCOM_USART_CTRLA_DORD_Msk     = 0x40000000 // Bit mask of DORD field.
	SERCOM_USART_CTRLA_DORD         = 0x40000000 // Bit DORD.

	// CTRLB: USART Control B
	SERCOM_USART_CTRLB_CHSIZE_Pos = 0x0       // Position of CHSIZE field.
	SERCOM_USART_CTRLB_CHSIZE_Msk = 0x7       // Bit mask of CHSIZE field.
	SERCOM_USART_CTRLB_SBMODE_Pos = 0x6       // Position of SBMODE field.
	SERCOM_USART_CTRLB_SBMODE_Msk = 0x40      // Bit mask of SBMODE field.
	SERCOM_USART_CTRLB_SBMODE     = 0x40      // Bit SBMODE.
	SERCOM_USART_CTRLB_COLDEN_Pos = 0x8       // Position of COLDEN field.
	SERCOM_USART_CTRLB_COLDEN_Msk = 0x100     // Bit mask of COLDEN field.
	SERCOM_USART_CTRLB_COLDEN     = 0x100     // Bit COLDEN.
	SERCOM_USART_CTRLB_SFDE_Pos   = 0x9       // Position of SFDE field.
	SERCOM_USART_CTRLB_SFDE_Msk   = 0x200     // Bit mask of SFDE field.
	SERCOM_USART_CTRLB_SFDE       = 0x200     // Bit SFDE.
	SERCOM_USART_CTRLB_ENC_Pos    = 0xa       // Position of ENC field.
	SERCOM_USART_CTRLB_ENC_Msk    = 0x400     // Bit mask of ENC field.
	SERCOM_USART_CTRLB_ENC        = 0x400     // Bit ENC.
	SERCOM_USART_CTRLB_PMODE_Pos  = 0xd       // Position of PMODE field.
	SERCOM_USART_CTRLB_PMODE_Msk  = 0x2000    // Bit mask of PMODE field.
	SERCOM_USART_CTRLB_PMODE      = 0x2000    // Bit PMODE.
	SERCOM_USART_CTRLB_TXEN_Pos   = 0x10      // Position of TXEN field.
	SERCOM_USART_CTRLB_TXEN_Msk   = 0x10000   // Bit mask of TXEN field.
	SERCOM_USART_CTRLB_TXEN       = 0x10000   // Bit TXEN.
	SERCOM_USART_CTRLB_RXEN_Pos   = 0x11      // Position of RXEN field.
	SERCOM_USART_CTRLB_RXEN_Msk   = 0x20000   // Bit mask of RXEN field.
	SERCOM_USART_CTRLB_RXEN       = 0x20000   // Bit RXEN.
	SERCOM_USART_CTRLB_LINCMD_Pos = 0x18      // Position of LINCMD field.
	SERCOM_USART_CTRLB_LINCMD_Msk = 0x3000000 // Bit mask of LINCMD field.

	// CTRLC: USART Control C
	SERCOM_USART_CTRLC_GTIME_Pos   = 0x0      // Position of GTIME field.
	SERCOM_USART_CTRLC_GTIME_Msk   = 0x7      // Bit mask of GTIME field.
	SERCOM_USART_CTRLC_BRKLEN_Pos  = 0x8      // Position of BRKLEN field.
	SERCOM_USART_CTRLC_BRKLEN_Msk  = 0x300    // Bit mask of BRKLEN field.
	SERCOM_USART_CTRLC_HDRDLY_Pos  = 0xa      // Position of HDRDLY field.
	SERCOM_USART_CTRLC_HDRDLY_Msk  = 0xc00    // Bit mask of HDRDLY field.
	SERCOM_USART_CTRLC_INACK_Pos   = 0x10     // Position of INACK field.
	SERCOM_USART_CTRLC_INACK_Msk   = 0x10000  // Bit mask of INACK field.
	SERCOM_USART_CTRLC_INACK       = 0x10000  // Bit INACK.
	SERCOM_USART_CTRLC_DSNACK_Pos  = 0x11     // Position of DSNACK field.
	SERCOM_USART_CTRLC_DSNACK_Msk  = 0x20000  // Bit mask of DSNACK field.
	SERCOM_USART_CTRLC_DSNACK      = 0x20000  // Bit DSNACK.
	SERCOM_USART_CTRLC_MAXITER_Pos = 0x14     // Position of MAXITER field.
	SERCOM_USART_CTRLC_MAXITER_Msk = 0x700000 // Bit mask of MAXITER field.

	// BAUD: USART Baud Rate
	SERCOM_USART_BAUD_BAUD_Pos = 0x0    // Position of BAUD field.
	SERCOM_USART_BAUD_BAUD_Msk = 0xffff // Bit mask of BAUD field.

	// BAUD_FRAC_MODE: USART Baud Rate
	SERCOM_USART_BAUD_FRAC_MODE_BAUD_Pos = 0x0    // Position of BAUD field.
	SERCOM_USART_BAUD_FRAC_MODE_BAUD_Msk = 0x1fff // Bit mask of BAUD field.
	SERCOM_USART_BAUD_FRAC_MODE_FP_Pos   = 0xd    // Position of FP field.
	SERCOM_USART_BAUD_FRAC_MODE_FP_Msk   = 0xe000 // Bit mask of FP field.

	// BAUD_FRACFP_MODE: USART Baud Rate
	SERCOM_USART_BAUD_FRACFP_MODE_BAUD_Pos = 0x0    // Position of BAUD field.
	SERCOM_USART_BAUD_FRACFP_MODE_BAUD_Msk = 0x1fff // Bit mask of BAUD field.
	SERCOM_USART_BAUD_FRACFP_MODE_FP_Pos   = 0xd    // Position of FP field.
	SERCOM_USART_BAUD_FRACFP_MODE_FP_Msk   = 0xe000 // Bit mask of FP field.

	// BAUD_USARTFP_MODE: USART Baud Rate
	SERCOM_USART_BAUD_USARTFP_MODE_BAUD_Pos = 0x0    // Position of BAUD field.
	SERCOM_USART_BAUD_USARTFP_MODE_BAUD_Msk = 0xffff // Bit mask of BAUD field.

	// RXPL: USART Receive Pulse Length
	SERCOM_USART_RXPL_RXPL_Pos = 0x0  // Position of RXPL field.
	SERCOM_USART_RXPL_RXPL_Msk = 0xff // Bit mask of RXPL field.

	// INTENCLR: USART Interrupt Enable Clear
	SERCOM_USART_INTENCLR_DRE_Pos   = 0x0  // Position of DRE field.
	SERCOM_USART_INTENCLR_DRE_Msk   = 0x1  // Bit mask of DRE field.
	SERCOM_USART_INTENCLR_DRE       = 0x1  // Bit DRE.
	SERCOM_USART_INTENCLR_TXC_Pos   = 0x1  // Position of TXC field.
	SERCOM_USART_INTENCLR_TXC_Msk   = 0x2  // Bit mask of TXC field.
	SERCOM_USART_INTENCLR_TXC       = 0x2  // Bit TXC.
	SERCOM_USART_INTENCLR_RXC_Pos   = 0x2  // Position of RXC field.
	SERCOM_USART_INTENCLR_RXC_Msk   = 0x4  // Bit mask of RXC field.
	SERCOM_USART_INTENCLR_RXC       = 0x4  // Bit RXC.
	SERCOM_USART_INTENCLR_RXS_Pos   = 0x3  // Position of RXS field.
	SERCOM_USART_INTENCLR_RXS_Msk   = 0x8  // Bit mask of RXS field.
	SERCOM_USART_INTENCLR_RXS       = 0x8  // Bit RXS.
	SERCOM_USART_INTENCLR_CTSIC_Pos = 0x4  // Position of CTSIC field.
	SERCOM_USART_INTENCLR_CTSIC_Msk = 0x10 // Bit mask of CTSIC field.
	SERCOM_USART_INTENCLR_CTSIC     = 0x10 // Bit CTSIC.
	SERCOM_USART_INTENCLR_RXBRK_Pos = 0x5  // Position of RXBRK field.
	SERCOM_USART_INTENCLR_RXBRK_Msk = 0x20 // Bit mask of RXBRK field.
	SERCOM_USART_INTENCLR_RXBRK     = 0x20 // Bit RXBRK.
	SERCOM_USART_INTENCLR_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_USART_INTENCLR_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_USART_INTENCLR_ERROR     = 0x80 // Bit ERROR.

	// INTENSET: USART Interrupt Enable Set
	SERCOM_USART_INTENSET_DRE_Pos   = 0x0  // Position of DRE field.
	SERCOM_USART_INTENSET_DRE_Msk   = 0x1  // Bit mask of DRE field.
	SERCOM_USART_INTENSET_DRE       = 0x1  // Bit DRE.
	SERCOM_USART_INTENSET_TXC_Pos   = 0x1  // Position of TXC field.
	SERCOM_USART_INTENSET_TXC_Msk   = 0x2  // Bit mask of TXC field.
	SERCOM_USART_INTENSET_TXC       = 0x2  // Bit TXC.
	SERCOM_USART_INTENSET_RXC_Pos   = 0x2  // Position of RXC field.
	SERCOM_USART_INTENSET_RXC_Msk   = 0x4  // Bit mask of RXC field.
	SERCOM_USART_INTENSET_RXC       = 0x4  // Bit RXC.
	SERCOM_USART_INTENSET_RXS_Pos   = 0x3  // Position of RXS field.
	SERCOM_USART_INTENSET_RXS_Msk   = 0x8  // Bit mask of RXS field.
	SERCOM_USART_INTENSET_RXS       = 0x8  // Bit RXS.
	SERCOM_USART_INTENSET_CTSIC_Pos = 0x4  // Position of CTSIC field.
	SERCOM_USART_INTENSET_CTSIC_Msk = 0x10 // Bit mask of CTSIC field.
	SERCOM_USART_INTENSET_CTSIC     = 0x10 // Bit CTSIC.
	SERCOM_USART_INTENSET_RXBRK_Pos = 0x5  // Position of RXBRK field.
	SERCOM_USART_INTENSET_RXBRK_Msk = 0x20 // Bit mask of RXBRK field.
	SERCOM_USART_INTENSET_RXBRK     = 0x20 // Bit RXBRK.
	SERCOM_USART_INTENSET_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_USART_INTENSET_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_USART_INTENSET_ERROR     = 0x80 // Bit ERROR.

	// INTFLAG: USART Interrupt Flag Status and Clear
	SERCOM_USART_INTFLAG_DRE_Pos   = 0x0  // Position of DRE field.
	SERCOM_USART_INTFLAG_DRE_Msk   = 0x1  // Bit mask of DRE field.
	SERCOM_USART_INTFLAG_DRE       = 0x1  // Bit DRE.
	SERCOM_USART_INTFLAG_TXC_Pos   = 0x1  // Position of TXC field.
	SERCOM_USART_INTFLAG_TXC_Msk   = 0x2  // Bit mask of TXC field.
	SERCOM_USART_INTFLAG_TXC       = 0x2  // Bit TXC.
	SERCOM_USART_INTFLAG_RXC_Pos   = 0x2  // Position of RXC field.
	SERCOM_USART_INTFLAG_RXC_Msk   = 0x4  // Bit mask of RXC field.
	SERCOM_USART_INTFLAG_RXC       = 0x4  // Bit RXC.
	SERCOM_USART_INTFLAG_RXS_Pos   = 0x3  // Position of RXS field.
	SERCOM_USART_INTFLAG_RXS_Msk   = 0x8  // Bit mask of RXS field.
	SERCOM_USART_INTFLAG_RXS       = 0x8  // Bit RXS.
	SERCOM_USART_INTFLAG_CTSIC_Pos = 0x4  // Position of CTSIC field.
	SERCOM_USART_INTFLAG_CTSIC_Msk = 0x10 // Bit mask of CTSIC field.
	SERCOM_USART_INTFLAG_CTSIC     = 0x10 // Bit CTSIC.
	SERCOM_USART_INTFLAG_RXBRK_Pos = 0x5  // Position of RXBRK field.
	SERCOM_USART_INTFLAG_RXBRK_Msk = 0x20 // Bit mask of RXBRK field.
	SERCOM_USART_INTFLAG_RXBRK     = 0x20 // Bit RXBRK.
	SERCOM_USART_INTFLAG_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_USART_INTFLAG_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_USART_INTFLAG_ERROR     = 0x80 // Bit ERROR.

	// STATUS: USART Status
	SERCOM_USART_STATUS_PERR_Pos   = 0x0  // Position of PERR field.
	SERCOM_USART_STATUS_PERR_Msk   = 0x1  // Bit mask of PERR field.
	SERCOM_USART_STATUS_PERR       = 0x1  // Bit PERR.
	SERCOM_USART_STATUS_FERR_Pos   = 0x1  // Position of FERR field.
	SERCOM_USART_STATUS_FERR_Msk   = 0x2  // Bit mask of FERR field.
	SERCOM_USART_STATUS_FERR       = 0x2  // Bit FERR.
	SERCOM_USART_STATUS_BUFOVF_Pos = 0x2  // Position of BUFOVF field.
	SERCOM_USART_STATUS_BUFOVF_Msk = 0x4  // Bit mask of BUFOVF field.
	SERCOM_USART_STATUS_BUFOVF     = 0x4  // Bit BUFOVF.
	SERCOM_USART_STATUS_CTS_Pos    = 0x3  // Position of CTS field.
	SERCOM_USART_STATUS_CTS_Msk    = 0x8  // Bit mask of CTS field.
	SERCOM_USART_STATUS_CTS        = 0x8  // Bit CTS.
	SERCOM_USART_STATUS_ISF_Pos    = 0x4  // Position of ISF field.
	SERCOM_USART_STATUS_ISF_Msk    = 0x10 // Bit mask of ISF field.
	SERCOM_USART_STATUS_ISF        = 0x10 // Bit ISF.
	SERCOM_USART_STATUS_COLL_Pos   = 0x5  // Position of COLL field.
	SERCOM_USART_STATUS_COLL_Msk   = 0x20 // Bit mask of COLL field.
	SERCOM_USART_STATUS_COLL       = 0x20 // Bit COLL.
	SERCOM_USART_STATUS_TXE_Pos    = 0x6  // Position of TXE field.
	SERCOM_USART_STATUS_TXE_Msk    = 0x40 // Bit mask of TXE field.
	SERCOM_USART_STATUS_TXE        = 0x40 // Bit TXE.
	SERCOM_USART_STATUS_ITER_Pos   = 0x7  // Position of ITER field.
	SERCOM_USART_STATUS_ITER_Msk   = 0x80 // Bit mask of ITER field.
	SERCOM_USART_STATUS_ITER       = 0x80 // Bit ITER.

	// SYNCBUSY: USART Synchronization Busy
	SERCOM_USART_SYNCBUSY_SWRST_Pos    = 0x0 // Position of SWRST field.
	SERCOM_USART_SYNCBUSY_SWRST_Msk    = 0x1 // Bit mask of SWRST field.
	SERCOM_USART_SYNCBUSY_SWRST        = 0x1 // Bit SWRST.
	SERCOM_USART_SYNCBUSY_ENABLE_Pos   = 0x1 // Position of ENABLE field.
	SERCOM_USART_SYNCBUSY_ENABLE_Msk   = 0x2 // Bit mask of ENABLE field.
	SERCOM_USART_SYNCBUSY_ENABLE       = 0x2 // Bit ENABLE.
	SERCOM_USART_SYNCBUSY_CTRLB_Pos    = 0x2 // Position of CTRLB field.
	SERCOM_USART_SYNCBUSY_CTRLB_Msk    = 0x4 // Bit mask of CTRLB field.
	SERCOM_USART_SYNCBUSY_CTRLB        = 0x4 // Bit CTRLB.
	SERCOM_USART_SYNCBUSY_RXERRCNT_Pos = 0x3 // Position of RXERRCNT field.
	SERCOM_USART_SYNCBUSY_RXERRCNT_Msk = 0x8 // Bit mask of RXERRCNT field.
	SERCOM_USART_SYNCBUSY_RXERRCNT     = 0x8 // Bit RXERRCNT.

	// DATA: USART Data
	SERCOM_USART_DATA_DATA_Pos = 0x0   // Position of DATA field.
	SERCOM_USART_DATA_DATA_Msk = 0x1ff // Bit mask of DATA field.

	// DBGCTRL: USART Debug Control
	SERCOM_USART_DBGCTRL_DBGSTOP_Pos = 0x0 // Position of DBGSTOP field.
	SERCOM_USART_DBGCTRL_DBGSTOP_Msk = 0x1 // Bit mask of DBGSTOP field.
	SERCOM_USART_DBGCTRL_DBGSTOP     = 0x1 // Bit DBGSTOP.
)

// Bitfields for SUPC: Supply Controller
const (
	// INTENCLR: Interrupt Enable Clear
	SUPC_INTENCLR_BOD33RDY_Pos   = 0x0   // Position of BOD33RDY field.
	SUPC_INTENCLR_BOD33RDY_Msk   = 0x1   // Bit mask of BOD33RDY field.
	SUPC_INTENCLR_BOD33RDY       = 0x1   // Bit BOD33RDY.
	SUPC_INTENCLR_BOD33DET_Pos   = 0x1   // Position of BOD33DET field.
	SUPC_INTENCLR_BOD33DET_Msk   = 0x2   // Bit mask of BOD33DET field.
	SUPC_INTENCLR_BOD33DET       = 0x2   // Bit BOD33DET.
	SUPC_INTENCLR_B33SRDY_Pos    = 0x2   // Position of B33SRDY field.
	SUPC_INTENCLR_B33SRDY_Msk    = 0x4   // Bit mask of B33SRDY field.
	SUPC_INTENCLR_B33SRDY        = 0x4   // Bit B33SRDY.
	SUPC_INTENCLR_BOD12RDY_Pos   = 0x3   // Position of BOD12RDY field.
	SUPC_INTENCLR_BOD12RDY_Msk   = 0x8   // Bit mask of BOD12RDY field.
	SUPC_INTENCLR_BOD12RDY       = 0x8   // Bit BOD12RDY.
	SUPC_INTENCLR_BOD12DET_Pos   = 0x4   // Position of BOD12DET field.
	SUPC_INTENCLR_BOD12DET_Msk   = 0x10  // Bit mask of BOD12DET field.
	SUPC_INTENCLR_BOD12DET       = 0x10  // Bit BOD12DET.
	SUPC_INTENCLR_B12SRDY_Pos    = 0x5   // Position of B12SRDY field.
	SUPC_INTENCLR_B12SRDY_Msk    = 0x20  // Bit mask of B12SRDY field.
	SUPC_INTENCLR_B12SRDY        = 0x20  // Bit B12SRDY.
	SUPC_INTENCLR_VREGRDY_Pos    = 0x8   // Position of VREGRDY field.
	SUPC_INTENCLR_VREGRDY_Msk    = 0x100 // Bit mask of VREGRDY field.
	SUPC_INTENCLR_VREGRDY        = 0x100 // Bit VREGRDY.
	SUPC_INTENCLR_VCORERDY_Pos   = 0xa   // Position of VCORERDY field.
	SUPC_INTENCLR_VCORERDY_Msk   = 0x400 // Bit mask of VCORERDY field.
	SUPC_INTENCLR_VCORERDY       = 0x400 // Bit VCORERDY.
	SUPC_INTENCLR_ULPVREFRDY_Pos = 0xb   // Position of ULPVREFRDY field.
	SUPC_INTENCLR_ULPVREFRDY_Msk = 0x800 // Bit mask of ULPVREFRDY field.
	SUPC_INTENCLR_ULPVREFRDY     = 0x800 // Bit ULPVREFRDY.

	// INTENSET: Interrupt Enable Set
	SUPC_INTENSET_BOD33RDY_Pos   = 0x0   // Position of BOD33RDY field.
	SUPC_INTENSET_BOD33RDY_Msk   = 0x1   // Bit mask of BOD33RDY field.
	SUPC_INTENSET_BOD33RDY       = 0x1   // Bit BOD33RDY.
	SUPC_INTENSET_BOD33DET_Pos   = 0x1   // Position of BOD33DET field.
	SUPC_INTENSET_BOD33DET_Msk   = 0x2   // Bit mask of BOD33DET field.
	SUPC_INTENSET_BOD33DET       = 0x2   // Bit BOD33DET.
	SUPC_INTENSET_B33SRDY_Pos    = 0x2   // Position of B33SRDY field.
	SUPC_INTENSET_B33SRDY_Msk    = 0x4   // Bit mask of B33SRDY field.
	SUPC_INTENSET_B33SRDY        = 0x4   // Bit B33SRDY.
	SUPC_INTENSET_BOD12RDY_Pos   = 0x3   // Position of BOD12RDY field.
	SUPC_INTENSET_BOD12RDY_Msk   = 0x8   // Bit mask of BOD12RDY field.
	SUPC_INTENSET_BOD12RDY       = 0x8   // Bit BOD12RDY.
	SUPC_INTENSET_BOD12DET_Pos   = 0x4   // Position of BOD12DET field.
	SUPC_INTENSET_BOD12DET_Msk   = 0x10  // Bit mask of BOD12DET field.
	SUPC_INTENSET_BOD12DET       = 0x10  // Bit BOD12DET.
	SUPC_INTENSET_B12SRDY_Pos    = 0x5   // Position of B12SRDY field.
	SUPC_INTENSET_B12SRDY_Msk    = 0x20  // Bit mask of B12SRDY field.
	SUPC_INTENSET_B12SRDY        = 0x20  // Bit B12SRDY.
	SUPC_INTENSET_VREGRDY_Pos    = 0x8   // Position of VREGRDY field.
	SUPC_INTENSET_VREGRDY_Msk    = 0x100 // Bit mask of VREGRDY field.
	SUPC_INTENSET_VREGRDY        = 0x100 // Bit VREGRDY.
	SUPC_INTENSET_VCORERDY_Pos   = 0xa   // Position of VCORERDY field.
	SUPC_INTENSET_VCORERDY_Msk   = 0x400 // Bit mask of VCORERDY field.
	SUPC_INTENSET_VCORERDY       = 0x400 // Bit VCORERDY.
	SUPC_INTENSET_ULPVREFRDY_Pos = 0xb   // Position of ULPVREFRDY field.
	SUPC_INTENSET_ULPVREFRDY_Msk = 0x800 // Bit mask of ULPVREFRDY field.
	SUPC_INTENSET_ULPVREFRDY     = 0x800 // Bit ULPVREFRDY.

	// INTFLAG: Interrupt Flag Status and Clear
	SUPC_INTFLAG_BOD33RDY_Pos   = 0x0   // Position of BOD33RDY field.
	SUPC_INTFLAG_BOD33RDY_Msk   = 0x1   // Bit mask of BOD33RDY field.
	SUPC_INTFLAG_BOD33RDY       = 0x1   // Bit BOD33RDY.
	SUPC_INTFLAG_BOD33DET_Pos   = 0x1   // Position of BOD33DET field.
	SUPC_INTFLAG_BOD33DET_Msk   = 0x2   // Bit mask of BOD33DET field.
	SUPC_INTFLAG_BOD33DET       = 0x2   // Bit BOD33DET.
	SUPC_INTFLAG_B33SRDY_Pos    = 0x2   // Position of B33SRDY field.
	SUPC_INTFLAG_B33SRDY_Msk    = 0x4   // Bit mask of B33SRDY field.
	SUPC_INTFLAG_B33SRDY        = 0x4   // Bit B33SRDY.
	SUPC_INTFLAG_BOD12RDY_Pos   = 0x3   // Position of BOD12RDY field.
	SUPC_INTFLAG_BOD12RDY_Msk   = 0x8   // Bit mask of BOD12RDY field.
	SUPC_INTFLAG_BOD12RDY       = 0x8   // Bit BOD12RDY.
	SUPC_INTFLAG_BOD12DET_Pos   = 0x4   // Position of BOD12DET field.
	SUPC_INTFLAG_BOD12DET_Msk   = 0x10  // Bit mask of BOD12DET field.
	SUPC_INTFLAG_BOD12DET       = 0x10  // Bit BOD12DET.
	SUPC_INTFLAG_B12SRDY_Pos    = 0x5   // Position of B12SRDY field.
	SUPC_INTFLAG_B12SRDY_Msk    = 0x20  // Bit mask of B12SRDY field.
	SUPC_INTFLAG_B12SRDY        = 0x20  // Bit B12SRDY.
	SUPC_INTFLAG_VREGRDY_Pos    = 0x8   // Position of VREGRDY field.
	SUPC_INTFLAG_VREGRDY_Msk    = 0x100 // Bit mask of VREGRDY field.
	SUPC_INTFLAG_VREGRDY        = 0x100 // Bit VREGRDY.
	SUPC_INTFLAG_VCORERDY_Pos   = 0xa   // Position of VCORERDY field.
	SUPC_INTFLAG_VCORERDY_Msk   = 0x400 // Bit mask of VCORERDY field.
	SUPC_INTFLAG_VCORERDY       = 0x400 // Bit VCORERDY.
	SUPC_INTFLAG_ULPVREFRDY_Pos = 0xb   // Position of ULPVREFRDY field.
	SUPC_INTFLAG_ULPVREFRDY_Msk = 0x800 // Bit mask of ULPVREFRDY field.
	SUPC_INTFLAG_ULPVREFRDY     = 0x800 // Bit ULPVREFRDY.

	// STATUS: Power and Clocks Status
	SUPC_STATUS_BOD33RDY_Pos   = 0x0    // Position of BOD33RDY field.
	SUPC_STATUS_BOD33RDY_Msk   = 0x1    // Bit mask of BOD33RDY field.
	SUPC_STATUS_BOD33RDY       = 0x1    // Bit BOD33RDY.
	SUPC_STATUS_BOD33DET_Pos   = 0x1    // Position of BOD33DET field.
	SUPC_STATUS_BOD33DET_Msk   = 0x2    // Bit mask of BOD33DET field.
	SUPC_STATUS_BOD33DET       = 0x2    // Bit BOD33DET.
	SUPC_STATUS_B33SRDY_Pos    = 0x2    // Position of B33SRDY field.
	SUPC_STATUS_B33SRDY_Msk    = 0x4    // Bit mask of B33SRDY field.
	SUPC_STATUS_B33SRDY        = 0x4    // Bit B33SRDY.
	SUPC_STATUS_BOD12RDY_Pos   = 0x3    // Position of BOD12RDY field.
	SUPC_STATUS_BOD12RDY_Msk   = 0x8    // Bit mask of BOD12RDY field.
	SUPC_STATUS_BOD12RDY       = 0x8    // Bit BOD12RDY.
	SUPC_STATUS_BOD12DET_Pos   = 0x4    // Position of BOD12DET field.
	SUPC_STATUS_BOD12DET_Msk   = 0x10   // Bit mask of BOD12DET field.
	SUPC_STATUS_BOD12DET       = 0x10   // Bit BOD12DET.
	SUPC_STATUS_B12SRDY_Pos    = 0x5    // Position of B12SRDY field.
	SUPC_STATUS_B12SRDY_Msk    = 0x20   // Bit mask of B12SRDY field.
	SUPC_STATUS_B12SRDY        = 0x20   // Bit B12SRDY.
	SUPC_STATUS_VREGRDY_Pos    = 0x8    // Position of VREGRDY field.
	SUPC_STATUS_VREGRDY_Msk    = 0x100  // Bit mask of VREGRDY field.
	SUPC_STATUS_VREGRDY        = 0x100  // Bit VREGRDY.
	SUPC_STATUS_VCORERDY_Pos   = 0xa    // Position of VCORERDY field.
	SUPC_STATUS_VCORERDY_Msk   = 0x400  // Bit mask of VCORERDY field.
	SUPC_STATUS_VCORERDY       = 0x400  // Bit VCORERDY.
	SUPC_STATUS_ULPVREFRDY_Pos = 0xc    // Position of ULPVREFRDY field.
	SUPC_STATUS_ULPVREFRDY_Msk = 0x1000 // Bit mask of ULPVREFRDY field.
	SUPC_STATUS_ULPVREFRDY     = 0x1000 // Bit ULPVREFRDY.
	SUPC_STATUS_ULPBIASRDY_Pos = 0xd    // Position of ULPBIASRDY field.
	SUPC_STATUS_ULPBIASRDY_Msk = 0x2000 // Bit mask of ULPBIASRDY field.
	SUPC_STATUS_ULPBIASRDY     = 0x2000 // Bit ULPBIASRDY.

	// BOD33: BOD33 Control
	SUPC_BOD33_ENABLE_Pos            = 0x1      // Position of ENABLE field.
	SUPC_BOD33_ENABLE_Msk            = 0x2      // Bit mask of ENABLE field.
	SUPC_BOD33_ENABLE                = 0x2      // Bit ENABLE.
	SUPC_BOD33_HYST_Pos              = 0x2      // Position of HYST field.
	SUPC_BOD33_HYST_Msk              = 0x4      // Bit mask of HYST field.
	SUPC_BOD33_HYST                  = 0x4      // Bit HYST.
	SUPC_BOD33_ACTION_Pos            = 0x3      // Position of ACTION field.
	SUPC_BOD33_ACTION_Msk            = 0x18     // Bit mask of ACTION field.
	SUPC_BOD33_ACTION_NONE           = 0x0      // No action
	SUPC_BOD33_ACTION_RESET          = 0x1      // The BOD33 generates a reset
	SUPC_BOD33_ACTION_INT            = 0x2      // The BOD33 generates an interrupt
	SUPC_BOD33_ACTION_BKUP           = 0x3      // The BOD33 puts the device in backup sleep mode if VMON=0
	SUPC_BOD33_STDBYCFG_Pos          = 0x5      // Position of STDBYCFG field.
	SUPC_BOD33_STDBYCFG_Msk          = 0x20     // Bit mask of STDBYCFG field.
	SUPC_BOD33_STDBYCFG              = 0x20     // Bit STDBYCFG.
	SUPC_BOD33_RUNSTDBY_Pos          = 0x6      // Position of RUNSTDBY field.
	SUPC_BOD33_RUNSTDBY_Msk          = 0x40     // Bit mask of RUNSTDBY field.
	SUPC_BOD33_RUNSTDBY              = 0x40     // Bit RUNSTDBY.
	SUPC_BOD33_ACTCFG_Pos            = 0x8      // Position of ACTCFG field.
	SUPC_BOD33_ACTCFG_Msk            = 0x100    // Bit mask of ACTCFG field.
	SUPC_BOD33_ACTCFG                = 0x100    // Bit ACTCFG.
	SUPC_BOD33_REFSEL_Pos            = 0xb      // Position of REFSEL field.
	SUPC_BOD33_REFSEL_Msk            = 0x800    // Bit mask of REFSEL field.
	SUPC_BOD33_REFSEL                = 0x800    // Bit REFSEL.
	SUPC_BOD33_REFSEL_SEL_VREFDETREF = 0x0      // Selects VREFDETREF for the BOD33
	SUPC_BOD33_REFSEL_SEL_ULPVREF    = 0x1      // Selects ULPVREF for the BOD33
	SUPC_BOD33_PSEL_Pos              = 0xc      // Position of PSEL field.
	SUPC_BOD33_PSEL_Msk              = 0xf000   // Bit mask of PSEL field.
	SUPC_BOD33_PSEL_DIV2             = 0x0      // Divide clock by 2
	SUPC_BOD33_PSEL_DIV4             = 0x1      // Divide clock by 4
	SUPC_BOD33_PSEL_DIV8             = 0x2      // Divide clock by 8
	SUPC_BOD33_PSEL_DIV16            = 0x3      // Divide clock by 16
	SUPC_BOD33_PSEL_DIV32            = 0x4      // Divide clock by 32
	SUPC_BOD33_PSEL_DIV64            = 0x5      // Divide clock by 64
	SUPC_BOD33_PSEL_DIV128           = 0x6      // Divide clock by 128
	SUPC_BOD33_PSEL_DIV256           = 0x7      // Divide clock by 256
	SUPC_BOD33_PSEL_DIV512           = 0x8      // Divide clock by 512
	SUPC_BOD33_PSEL_DIV1024          = 0x9      // Divide clock by 1024
	SUPC_BOD33_PSEL_DIV2048          = 0xa      // Divide clock by 2048
	SUPC_BOD33_PSEL_DIV4096          = 0xb      // Divide clock by 4096
	SUPC_BOD33_PSEL_DIV8192          = 0xc      // Divide clock by 8192
	SUPC_BOD33_PSEL_DIV16384         = 0xd      // Divide clock by 16384
	SUPC_BOD33_PSEL_DIV32768         = 0xe      // Divide clock by 32768
	SUPC_BOD33_PSEL_DIV65536         = 0xf      // Divide clock by 65536
	SUPC_BOD33_LEVEL_Pos             = 0x10     // Position of LEVEL field.
	SUPC_BOD33_LEVEL_Msk             = 0x3f0000 // Bit mask of LEVEL field.

	// BOD12: BOD12 Control
	SUPC_BOD12_ENABLE_Pos    = 0x1      // Position of ENABLE field.
	SUPC_BOD12_ENABLE_Msk    = 0x2      // Bit mask of ENABLE field.
	SUPC_BOD12_ENABLE        = 0x2      // Bit ENABLE.
	SUPC_BOD12_HYST_Pos      = 0x2      // Position of HYST field.
	SUPC_BOD12_HYST_Msk      = 0x4      // Bit mask of HYST field.
	SUPC_BOD12_HYST          = 0x4      // Bit HYST.
	SUPC_BOD12_ACTION_Pos    = 0x3      // Position of ACTION field.
	SUPC_BOD12_ACTION_Msk    = 0x18     // Bit mask of ACTION field.
	SUPC_BOD12_ACTION_NONE   = 0x0      // No action
	SUPC_BOD12_ACTION_RESET  = 0x1      // The BOD12 generates a reset
	SUPC_BOD12_ACTION_INT    = 0x2      // The BOD12 generates an interrupt
	SUPC_BOD12_STDBYCFG_Pos  = 0x5      // Position of STDBYCFG field.
	SUPC_BOD12_STDBYCFG_Msk  = 0x20     // Bit mask of STDBYCFG field.
	SUPC_BOD12_STDBYCFG      = 0x20     // Bit STDBYCFG.
	SUPC_BOD12_RUNSTDBY_Pos  = 0x6      // Position of RUNSTDBY field.
	SUPC_BOD12_RUNSTDBY_Msk  = 0x40     // Bit mask of RUNSTDBY field.
	SUPC_BOD12_RUNSTDBY      = 0x40     // Bit RUNSTDBY.
	SUPC_BOD12_ACTCFG_Pos    = 0x8      // Position of ACTCFG field.
	SUPC_BOD12_ACTCFG_Msk    = 0x100    // Bit mask of ACTCFG field.
	SUPC_BOD12_ACTCFG        = 0x100    // Bit ACTCFG.
	SUPC_BOD12_PSEL_Pos      = 0xc      // Position of PSEL field.
	SUPC_BOD12_PSEL_Msk      = 0xf000   // Bit mask of PSEL field.
	SUPC_BOD12_PSEL_DIV2     = 0x0      // Divide clock by 2
	SUPC_BOD12_PSEL_DIV4     = 0x1      // Divide clock by 4
	SUPC_BOD12_PSEL_DIV8     = 0x2      // Divide clock by 8
	SUPC_BOD12_PSEL_DIV16    = 0x3      // Divide clock by 16
	SUPC_BOD12_PSEL_DIV32    = 0x4      // Divide clock by 32
	SUPC_BOD12_PSEL_DIV64    = 0x5      // Divide clock by 64
	SUPC_BOD12_PSEL_DIV128   = 0x6      // Divide clock by 128
	SUPC_BOD12_PSEL_DIV256   = 0x7      // Divide clock by 256
	SUPC_BOD12_PSEL_DIV512   = 0x8      // Divide clock by 512
	SUPC_BOD12_PSEL_DIV1024  = 0x9      // Divide clock by 1024
	SUPC_BOD12_PSEL_DIV2048  = 0xa      // Divide clock by 2048
	SUPC_BOD12_PSEL_DIV4096  = 0xb      // Divide clock by 4096
	SUPC_BOD12_PSEL_DIV8192  = 0xc      // Divide clock by 8192
	SUPC_BOD12_PSEL_DIV16384 = 0xd      // Divide clock by 16384
	SUPC_BOD12_PSEL_DIV32768 = 0xe      // Divide clock by 32768
	SUPC_BOD12_PSEL_DIV65536 = 0xf      // Divide clock by 65536
	SUPC_BOD12_LEVEL_Pos     = 0x10     // Position of LEVEL field.
	SUPC_BOD12_LEVEL_Msk     = 0x3f0000 // Bit mask of LEVEL field.

	// VREG: VREG Control
	SUPC_VREG_ENABLE_Pos   = 0x1        // Position of ENABLE field.
	SUPC_VREG_ENABLE_Msk   = 0x2        // Bit mask of ENABLE field.
	SUPC_VREG_ENABLE       = 0x2        // Bit ENABLE.
	SUPC_VREG_SEL_Pos      = 0x2        // Position of SEL field.
	SUPC_VREG_SEL_Msk      = 0xc        // Bit mask of SEL field.
	SUPC_VREG_SEL_LDO      = 0x0        // LDO selection
	SUPC_VREG_SEL_BUCK     = 0x1        // Buck selection
	SUPC_VREG_STDBYPL0_Pos = 0x5        // Position of STDBYPL0 field.
	SUPC_VREG_STDBYPL0_Msk = 0x20       // Bit mask of STDBYPL0 field.
	SUPC_VREG_STDBYPL0     = 0x20       // Bit STDBYPL0.
	SUPC_VREG_RUNSTDBY_Pos = 0x6        // Position of RUNSTDBY field.
	SUPC_VREG_RUNSTDBY_Msk = 0x40       // Bit mask of RUNSTDBY field.
	SUPC_VREG_RUNSTDBY     = 0x40       // Bit RUNSTDBY.
	SUPC_VREG_LPEFF_Pos    = 0x8        // Position of LPEFF field.
	SUPC_VREG_LPEFF_Msk    = 0x100      // Bit mask of LPEFF field.
	SUPC_VREG_LPEFF        = 0x100      // Bit LPEFF.
	SUPC_VREG_VREFSEL_Pos  = 0x9        // Position of VREFSEL field.
	SUPC_VREG_VREFSEL_Msk  = 0x200      // Bit mask of VREFSEL field.
	SUPC_VREG_VREFSEL      = 0x200      // Bit VREFSEL.
	SUPC_VREG_VSVSTEP_Pos  = 0x10       // Position of VSVSTEP field.
	SUPC_VREG_VSVSTEP_Msk  = 0xf0000    // Bit mask of VSVSTEP field.
	SUPC_VREG_VSPER_Pos    = 0x18       // Position of VSPER field.
	SUPC_VREG_VSPER_Msk    = 0xff000000 // Bit mask of VSPER field.

	// VREF: VREF Control
	SUPC_VREF_TSEN_Pos     = 0x1     // Position of TSEN field.
	SUPC_VREF_TSEN_Msk     = 0x2     // Bit mask of TSEN field.
	SUPC_VREF_TSEN         = 0x2     // Bit TSEN.
	SUPC_VREF_VREFOE_Pos   = 0x2     // Position of VREFOE field.
	SUPC_VREF_VREFOE_Msk   = 0x4     // Bit mask of VREFOE field.
	SUPC_VREF_VREFOE       = 0x4     // Bit VREFOE.
	SUPC_VREF_TSSEL_Pos    = 0x3     // Position of TSSEL field.
	SUPC_VREF_TSSEL_Msk    = 0x8     // Bit mask of TSSEL field.
	SUPC_VREF_TSSEL        = 0x8     // Bit TSSEL.
	SUPC_VREF_RUNSTDBY_Pos = 0x6     // Position of RUNSTDBY field.
	SUPC_VREF_RUNSTDBY_Msk = 0x40    // Bit mask of RUNSTDBY field.
	SUPC_VREF_RUNSTDBY     = 0x40    // Bit RUNSTDBY.
	SUPC_VREF_ONDEMAND_Pos = 0x7     // Position of ONDEMAND field.
	SUPC_VREF_ONDEMAND_Msk = 0x80    // Bit mask of ONDEMAND field.
	SUPC_VREF_ONDEMAND     = 0x80    // Bit ONDEMAND.
	SUPC_VREF_SEL_Pos      = 0x10    // Position of SEL field.
	SUPC_VREF_SEL_Msk      = 0xf0000 // Bit mask of SEL field.
	SUPC_VREF_SEL_1V0      = 0x0     // 1.0V voltage reference typical value
	SUPC_VREF_SEL_1V1      = 0x1     // 1.1V voltage reference typical value
	SUPC_VREF_SEL_1V2      = 0x2     // 1.2V voltage reference typical value
	SUPC_VREF_SEL_1V25     = 0x3     // 1.25V voltage reference typical value
	SUPC_VREF_SEL_2V0      = 0x4     // 2.0V voltage reference typical value
	SUPC_VREF_SEL_2V2      = 0x5     // 2.2V voltage reference typical value
	SUPC_VREF_SEL_2V4      = 0x6     // 2.4V voltage reference typical value
	SUPC_VREF_SEL_2V5      = 0x7     // 2.5V voltage reference typical value

	// EVCTRL: Event Control
	SUPC_EVCTRL_BOD33DETEO_Pos = 0x1  // Position of BOD33DETEO field.
	SUPC_EVCTRL_BOD33DETEO_Msk = 0x2  // Bit mask of BOD33DETEO field.
	SUPC_EVCTRL_BOD33DETEO     = 0x2  // Bit BOD33DETEO.
	SUPC_EVCTRL_BOD12DETEO_Pos = 0x4  // Position of BOD12DETEO field.
	SUPC_EVCTRL_BOD12DETEO_Msk = 0x10 // Bit mask of BOD12DETEO field.
	SUPC_EVCTRL_BOD12DETEO     = 0x10 // Bit BOD12DETEO.

	// VREGSUSP: VREG Suspend Control
	SUPC_VREGSUSP_VREGSEN_Pos = 0x0 // Position of VREGSEN field.
	SUPC_VREGSUSP_VREGSEN_Msk = 0x1 // Bit mask of VREGSEN field.
	SUPC_VREGSUSP_VREGSEN     = 0x1 // Bit VREGSEN.
)

// Bitfields for TC0: Basic Timer Counter
const ()

// Bitfields for TC0_COUNT8: Basic Timer Counter - COUNT8
const (
	// CTRLA: Control A
	TC_COUNT8_CTRLA_SWRST_Pos         = 0x0        // Position of SWRST field.
	TC_COUNT8_CTRLA_SWRST_Msk         = 0x1        // Bit mask of SWRST field.
	TC_COUNT8_CTRLA_SWRST             = 0x1        // Bit SWRST.
	TC_COUNT8_CTRLA_ENABLE_Pos        = 0x1        // Position of ENABLE field.
	TC_COUNT8_CTRLA_ENABLE_Msk        = 0x2        // Bit mask of ENABLE field.
	TC_COUNT8_CTRLA_ENABLE            = 0x2        // Bit ENABLE.
	TC_COUNT8_CTRLA_MODE_Pos          = 0x2        // Position of MODE field.
	TC_COUNT8_CTRLA_MODE_Msk          = 0xc        // Bit mask of MODE field.
	TC_COUNT8_CTRLA_MODE_COUNT16      = 0x0        // Counter in 16-bit mode
	TC_COUNT8_CTRLA_MODE_COUNT8       = 0x1        // Counter in 8-bit mode
	TC_COUNT8_CTRLA_MODE_COUNT32      = 0x2        // Counter in 32-bit mode
	TC_COUNT8_CTRLA_PRESCSYNC_Pos     = 0x4        // Position of PRESCSYNC field.
	TC_COUNT8_CTRLA_PRESCSYNC_Msk     = 0x30       // Bit mask of PRESCSYNC field.
	TC_COUNT8_CTRLA_PRESCSYNC_GCLK    = 0x0        // Reload or reset the counter on next generic clock
	TC_COUNT8_CTRLA_PRESCSYNC_PRESC   = 0x1        // Reload or reset the counter on next prescaler clock
	TC_COUNT8_CTRLA_PRESCSYNC_RESYNC  = 0x2        // Reload or reset the counter on next generic clock and reset the prescaler counter
	TC_COUNT8_CTRLA_RUNSTDBY_Pos      = 0x6        // Position of RUNSTDBY field.
	TC_COUNT8_CTRLA_RUNSTDBY_Msk      = 0x40       // Bit mask of RUNSTDBY field.
	TC_COUNT8_CTRLA_RUNSTDBY          = 0x40       // Bit RUNSTDBY.
	TC_COUNT8_CTRLA_ONDEMAND_Pos      = 0x7        // Position of ONDEMAND field.
	TC_COUNT8_CTRLA_ONDEMAND_Msk      = 0x80       // Bit mask of ONDEMAND field.
	TC_COUNT8_CTRLA_ONDEMAND          = 0x80       // Bit ONDEMAND.
	TC_COUNT8_CTRLA_PRESCALER_Pos     = 0x8        // Position of PRESCALER field.
	TC_COUNT8_CTRLA_PRESCALER_Msk     = 0x700      // Bit mask of PRESCALER field.
	TC_COUNT8_CTRLA_PRESCALER_DIV1    = 0x0        // Prescaler: GCLK_TC
	TC_COUNT8_CTRLA_PRESCALER_DIV2    = 0x1        // Prescaler: GCLK_TC/2
	TC_COUNT8_CTRLA_PRESCALER_DIV4    = 0x2        // Prescaler: GCLK_TC/4
	TC_COUNT8_CTRLA_PRESCALER_DIV8    = 0x3        // Prescaler: GCLK_TC/8
	TC_COUNT8_CTRLA_PRESCALER_DIV16   = 0x4        // Prescaler: GCLK_TC/16
	TC_COUNT8_CTRLA_PRESCALER_DIV64   = 0x5        // Prescaler: GCLK_TC/64
	TC_COUNT8_CTRLA_PRESCALER_DIV256  = 0x6        // Prescaler: GCLK_TC/256
	TC_COUNT8_CTRLA_PRESCALER_DIV1024 = 0x7        // Prescaler: GCLK_TC/1024
	TC_COUNT8_CTRLA_ALOCK_Pos         = 0xb        // Position of ALOCK field.
	TC_COUNT8_CTRLA_ALOCK_Msk         = 0x800      // Bit mask of ALOCK field.
	TC_COUNT8_CTRLA_ALOCK             = 0x800      // Bit ALOCK.
	TC_COUNT8_CTRLA_CAPTEN0_Pos       = 0x10       // Position of CAPTEN0 field.
	TC_COUNT8_CTRLA_CAPTEN0_Msk       = 0x10000    // Bit mask of CAPTEN0 field.
	TC_COUNT8_CTRLA_CAPTEN0           = 0x10000    // Bit CAPTEN0.
	TC_COUNT8_CTRLA_CAPTEN1_Pos       = 0x11       // Position of CAPTEN1 field.
	TC_COUNT8_CTRLA_CAPTEN1_Msk       = 0x20000    // Bit mask of CAPTEN1 field.
	TC_COUNT8_CTRLA_CAPTEN1           = 0x20000    // Bit CAPTEN1.
	TC_COUNT8_CTRLA_COPEN0_Pos        = 0x14       // Position of COPEN0 field.
	TC_COUNT8_CTRLA_COPEN0_Msk        = 0x100000   // Bit mask of COPEN0 field.
	TC_COUNT8_CTRLA_COPEN0            = 0x100000   // Bit COPEN0.
	TC_COUNT8_CTRLA_COPEN1_Pos        = 0x15       // Position of COPEN1 field.
	TC_COUNT8_CTRLA_COPEN1_Msk        = 0x200000   // Bit mask of COPEN1 field.
	TC_COUNT8_CTRLA_COPEN1            = 0x200000   // Bit COPEN1.
	TC_COUNT8_CTRLA_CAPTMODE0_Pos     = 0x18       // Position of CAPTMODE0 field.
	TC_COUNT8_CTRLA_CAPTMODE0_Msk     = 0x3000000  // Bit mask of CAPTMODE0 field.
	TC_COUNT8_CTRLA_CAPTMODE0_DEFAULT = 0x0        // Default capture
	TC_COUNT8_CTRLA_CAPTMODE0_CAPTMIN = 0x1        // Minimum capture
	TC_COUNT8_CTRLA_CAPTMODE0_CAPTMAX = 0x2        // Maximum capture
	TC_COUNT8_CTRLA_CAPTMODE1_Pos     = 0x1b       // Position of CAPTMODE1 field.
	TC_COUNT8_CTRLA_CAPTMODE1_Msk     = 0x18000000 // Bit mask of CAPTMODE1 field.
	TC_COUNT8_CTRLA_CAPTMODE1_DEFAULT = 0x0        // Default capture
	TC_COUNT8_CTRLA_CAPTMODE1_CAPTMIN = 0x1        // Minimum capture
	TC_COUNT8_CTRLA_CAPTMODE1_CAPTMAX = 0x2        // Maximum capture

	// CTRLBCLR: Control B Clear
	TC_COUNT8_CTRLBCLR_DIR_Pos       = 0x0  // Position of DIR field.
	TC_COUNT8_CTRLBCLR_DIR_Msk       = 0x1  // Bit mask of DIR field.
	TC_COUNT8_CTRLBCLR_DIR           = 0x1  // Bit DIR.
	TC_COUNT8_CTRLBCLR_LUPD_Pos      = 0x1  // Position of LUPD field.
	TC_COUNT8_CTRLBCLR_LUPD_Msk      = 0x2  // Bit mask of LUPD field.
	TC_COUNT8_CTRLBCLR_LUPD          = 0x2  // Bit LUPD.
	TC_COUNT8_CTRLBCLR_ONESHOT_Pos   = 0x2  // Position of ONESHOT field.
	TC_COUNT8_CTRLBCLR_ONESHOT_Msk   = 0x4  // Bit mask of ONESHOT field.
	TC_COUNT8_CTRLBCLR_ONESHOT       = 0x4  // Bit ONESHOT.
	TC_COUNT8_CTRLBCLR_CMD_Pos       = 0x5  // Position of CMD field.
	TC_COUNT8_CTRLBCLR_CMD_Msk       = 0xe0 // Bit mask of CMD field.
	TC_COUNT8_CTRLBCLR_CMD_NONE      = 0x0  // No action
	TC_COUNT8_CTRLBCLR_CMD_RETRIGGER = 0x1  // Force a start, restart or retrigger
	TC_COUNT8_CTRLBCLR_CMD_STOP      = 0x2  // Force a stop
	TC_COUNT8_CTRLBCLR_CMD_UPDATE    = 0x3  // Force update of double-buffered register
	TC_COUNT8_CTRLBCLR_CMD_READSYNC  = 0x4  // Force a read synchronization of COUNT
	TC_COUNT8_CTRLBCLR_CMD_DMAOS     = 0x5  // One-shot DMA trigger

	// CTRLBSET: Control B Set
	TC_COUNT8_CTRLBSET_DIR_Pos       = 0x0  // Position of DIR field.
	TC_COUNT8_CTRLBSET_DIR_Msk       = 0x1  // Bit mask of DIR field.
	TC_COUNT8_CTRLBSET_DIR           = 0x1  // Bit DIR.
	TC_COUNT8_CTRLBSET_LUPD_Pos      = 0x1  // Position of LUPD field.
	TC_COUNT8_CTRLBSET_LUPD_Msk      = 0x2  // Bit mask of LUPD field.
	TC_COUNT8_CTRLBSET_LUPD          = 0x2  // Bit LUPD.
	TC_COUNT8_CTRLBSET_ONESHOT_Pos   = 0x2  // Position of ONESHOT field.
	TC_COUNT8_CTRLBSET_ONESHOT_Msk   = 0x4  // Bit mask of ONESHOT field.
	TC_COUNT8_CTRLBSET_ONESHOT       = 0x4  // Bit ONESHOT.
	TC_COUNT8_CTRLBSET_CMD_Pos       = 0x5  // Position of CMD field.
	TC_COUNT8_CTRLBSET_CMD_Msk       = 0xe0 // Bit mask of CMD field.
	TC_COUNT8_CTRLBSET_CMD_NONE      = 0x0  // No action
	TC_COUNT8_CTRLBSET_CMD_RETRIGGER = 0x1  // Force a start, restart or retrigger
	TC_COUNT8_CTRLBSET_CMD_STOP      = 0x2  // Force a stop
	TC_COUNT8_CTRLBSET_CMD_UPDATE    = 0x3  // Force update of double-buffered register
	TC_COUNT8_CTRLBSET_CMD_READSYNC  = 0x4  // Force a read synchronization of COUNT
	TC_COUNT8_CTRLBSET_CMD_DMAOS     = 0x5  // One-shot DMA trigger

	// EVCTRL: Event Control
	TC_COUNT8_EVCTRL_EVACT_Pos       = 0x0    // Position of EVACT field.
	TC_COUNT8_EVCTRL_EVACT_Msk       = 0x7    // Bit mask of EVACT field.
	TC_COUNT8_EVCTRL_EVACT_OFF       = 0x0    // Event action disabled
	TC_COUNT8_EVCTRL_EVACT_RETRIGGER = 0x1    // Start, restart or retrigger TC on event
	TC_COUNT8_EVCTRL_EVACT_COUNT     = 0x2    // Count on event
	TC_COUNT8_EVCTRL_EVACT_START     = 0x3    // Start TC on event
	TC_COUNT8_EVCTRL_EVACT_STAMP     = 0x4    // Time stamp capture
	TC_COUNT8_EVCTRL_EVACT_PPW       = 0x5    // Period catured in CC0, pulse width in CC1
	TC_COUNT8_EVCTRL_EVACT_PWP       = 0x6    // Period catured in CC1, pulse width in CC0
	TC_COUNT8_EVCTRL_EVACT_PW        = 0x7    // Pulse width capture
	TC_COUNT8_EVCTRL_TCINV_Pos       = 0x4    // Position of TCINV field.
	TC_COUNT8_EVCTRL_TCINV_Msk       = 0x10   // Bit mask of TCINV field.
	TC_COUNT8_EVCTRL_TCINV           = 0x10   // Bit TCINV.
	TC_COUNT8_EVCTRL_TCEI_Pos        = 0x5    // Position of TCEI field.
	TC_COUNT8_EVCTRL_TCEI_Msk        = 0x20   // Bit mask of TCEI field.
	TC_COUNT8_EVCTRL_TCEI            = 0x20   // Bit TCEI.
	TC_COUNT8_EVCTRL_OVFEO_Pos       = 0x8    // Position of OVFEO field.
	TC_COUNT8_EVCTRL_OVFEO_Msk       = 0x100  // Bit mask of OVFEO field.
	TC_COUNT8_EVCTRL_OVFEO           = 0x100  // Bit OVFEO.
	TC_COUNT8_EVCTRL_MCEO0_Pos       = 0xc    // Position of MCEO0 field.
	TC_COUNT8_EVCTRL_MCEO0_Msk       = 0x1000 // Bit mask of MCEO0 field.
	TC_COUNT8_EVCTRL_MCEO0           = 0x1000 // Bit MCEO0.
	TC_COUNT8_EVCTRL_MCEO1_Pos       = 0xd    // Position of MCEO1 field.
	TC_COUNT8_EVCTRL_MCEO1_Msk       = 0x2000 // Bit mask of MCEO1 field.
	TC_COUNT8_EVCTRL_MCEO1           = 0x2000 // Bit MCEO1.

	// INTENCLR: Interrupt Enable Clear
	TC_COUNT8_INTENCLR_OVF_Pos = 0x0  // Position of OVF field.
	TC_COUNT8_INTENCLR_OVF_Msk = 0x1  // Bit mask of OVF field.
	TC_COUNT8_INTENCLR_OVF     = 0x1  // Bit OVF.
	TC_COUNT8_INTENCLR_ERR_Pos = 0x1  // Position of ERR field.
	TC_COUNT8_INTENCLR_ERR_Msk = 0x2  // Bit mask of ERR field.
	TC_COUNT8_INTENCLR_ERR     = 0x2  // Bit ERR.
	TC_COUNT8_INTENCLR_MC0_Pos = 0x4  // Position of MC0 field.
	TC_COUNT8_INTENCLR_MC0_Msk = 0x10 // Bit mask of MC0 field.
	TC_COUNT8_INTENCLR_MC0     = 0x10 // Bit MC0.
	TC_COUNT8_INTENCLR_MC1_Pos = 0x5  // Position of MC1 field.
	TC_COUNT8_INTENCLR_MC1_Msk = 0x20 // Bit mask of MC1 field.
	TC_COUNT8_INTENCLR_MC1     = 0x20 // Bit MC1.

	// INTENSET: Interrupt Enable Set
	TC_COUNT8_INTENSET_OVF_Pos = 0x0  // Position of OVF field.
	TC_COUNT8_INTENSET_OVF_Msk = 0x1  // Bit mask of OVF field.
	TC_COUNT8_INTENSET_OVF     = 0x1  // Bit OVF.
	TC_COUNT8_INTENSET_ERR_Pos = 0x1  // Position of ERR field.
	TC_COUNT8_INTENSET_ERR_Msk = 0x2  // Bit mask of ERR field.
	TC_COUNT8_INTENSET_ERR     = 0x2  // Bit ERR.
	TC_COUNT8_INTENSET_MC0_Pos = 0x4  // Position of MC0 field.
	TC_COUNT8_INTENSET_MC0_Msk = 0x10 // Bit mask of MC0 field.
	TC_COUNT8_INTENSET_MC0     = 0x10 // Bit MC0.
	TC_COUNT8_INTENSET_MC1_Pos = 0x5  // Position of MC1 field.
	TC_COUNT8_INTENSET_MC1_Msk = 0x20 // Bit mask of MC1 field.
	TC_COUNT8_INTENSET_MC1     = 0x20 // Bit MC1.

	// INTFLAG: Interrupt Flag Status and Clear
	TC_COUNT8_INTFLAG_OVF_Pos = 0x0  // Position of OVF field.
	TC_COUNT8_INTFLAG_OVF_Msk = 0x1  // Bit mask of OVF field.
	TC_COUNT8_INTFLAG_OVF     = 0x1  // Bit OVF.
	TC_COUNT8_INTFLAG_ERR_Pos = 0x1  // Position of ERR field.
	TC_COUNT8_INTFLAG_ERR_Msk = 0x2  // Bit mask of ERR field.
	TC_COUNT8_INTFLAG_ERR     = 0x2  // Bit ERR.
	TC_COUNT8_INTFLAG_MC0_Pos = 0x4  // Position of MC0 field.
	TC_COUNT8_INTFLAG_MC0_Msk = 0x10 // Bit mask of MC0 field.
	TC_COUNT8_INTFLAG_MC0     = 0x10 // Bit MC0.
	TC_COUNT8_INTFLAG_MC1_Pos = 0x5  // Position of MC1 field.
	TC_COUNT8_INTFLAG_MC1_Msk = 0x20 // Bit mask of MC1 field.
	TC_COUNT8_INTFLAG_MC1     = 0x20 // Bit MC1.

	// STATUS: Status
	TC_COUNT8_STATUS_STOP_Pos    = 0x0  // Position of STOP field.
	TC_COUNT8_STATUS_STOP_Msk    = 0x1  // Bit mask of STOP field.
	TC_COUNT8_STATUS_STOP        = 0x1  // Bit STOP.
	TC_COUNT8_STATUS_SLAVE_Pos   = 0x1  // Position of SLAVE field.
	TC_COUNT8_STATUS_SLAVE_Msk   = 0x2  // Bit mask of SLAVE field.
	TC_COUNT8_STATUS_SLAVE       = 0x2  // Bit SLAVE.
	TC_COUNT8_STATUS_PERBUFV_Pos = 0x3  // Position of PERBUFV field.
	TC_COUNT8_STATUS_PERBUFV_Msk = 0x8  // Bit mask of PERBUFV field.
	TC_COUNT8_STATUS_PERBUFV     = 0x8  // Bit PERBUFV.
	TC_COUNT8_STATUS_CCBUFV0_Pos = 0x4  // Position of CCBUFV0 field.
	TC_COUNT8_STATUS_CCBUFV0_Msk = 0x10 // Bit mask of CCBUFV0 field.
	TC_COUNT8_STATUS_CCBUFV0     = 0x10 // Bit CCBUFV0.
	TC_COUNT8_STATUS_CCBUFV1_Pos = 0x5  // Position of CCBUFV1 field.
	TC_COUNT8_STATUS_CCBUFV1_Msk = 0x20 // Bit mask of CCBUFV1 field.
	TC_COUNT8_STATUS_CCBUFV1     = 0x20 // Bit CCBUFV1.

	// WAVE: Waveform Generation Control
	TC_COUNT8_WAVE_WAVEGEN_Pos  = 0x0 // Position of WAVEGEN field.
	TC_COUNT8_WAVE_WAVEGEN_Msk  = 0x3 // Bit mask of WAVEGEN field.
	TC_COUNT8_WAVE_WAVEGEN_NFRQ = 0x0 // Normal frequency
	TC_COUNT8_WAVE_WAVEGEN_MFRQ = 0x1 // Match frequency
	TC_COUNT8_WAVE_WAVEGEN_NPWM = 0x2 // Normal PWM
	TC_COUNT8_WAVE_WAVEGEN_MPWM = 0x3 // Match PWM

	// DRVCTRL: Control C
	TC_COUNT8_DRVCTRL_INVEN0_Pos = 0x0 // Position of INVEN0 field.
	TC_COUNT8_DRVCTRL_INVEN0_Msk = 0x1 // Bit mask of INVEN0 field.
	TC_COUNT8_DRVCTRL_INVEN0     = 0x1 // Bit INVEN0.
	TC_COUNT8_DRVCTRL_INVEN1_Pos = 0x1 // Position of INVEN1 field.
	TC_COUNT8_DRVCTRL_INVEN1_Msk = 0x2 // Bit mask of INVEN1 field.
	TC_COUNT8_DRVCTRL_INVEN1     = 0x2 // Bit INVEN1.

	// DBGCTRL: Debug Control
	TC_COUNT8_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	TC_COUNT8_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	TC_COUNT8_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// SYNCBUSY: Synchronization Status
	TC_COUNT8_SYNCBUSY_SWRST_Pos  = 0x0  // Position of SWRST field.
	TC_COUNT8_SYNCBUSY_SWRST_Msk  = 0x1  // Bit mask of SWRST field.
	TC_COUNT8_SYNCBUSY_SWRST      = 0x1  // Bit SWRST.
	TC_COUNT8_SYNCBUSY_ENABLE_Pos = 0x1  // Position of ENABLE field.
	TC_COUNT8_SYNCBUSY_ENABLE_Msk = 0x2  // Bit mask of ENABLE field.
	TC_COUNT8_SYNCBUSY_ENABLE     = 0x2  // Bit ENABLE.
	TC_COUNT8_SYNCBUSY_CTRLB_Pos  = 0x2  // Position of CTRLB field.
	TC_COUNT8_SYNCBUSY_CTRLB_Msk  = 0x4  // Bit mask of CTRLB field.
	TC_COUNT8_SYNCBUSY_CTRLB      = 0x4  // Bit CTRLB.
	TC_COUNT8_SYNCBUSY_STATUS_Pos = 0x3  // Position of STATUS field.
	TC_COUNT8_SYNCBUSY_STATUS_Msk = 0x8  // Bit mask of STATUS field.
	TC_COUNT8_SYNCBUSY_STATUS     = 0x8  // Bit STATUS.
	TC_COUNT8_SYNCBUSY_COUNT_Pos  = 0x4  // Position of COUNT field.
	TC_COUNT8_SYNCBUSY_COUNT_Msk  = 0x10 // Bit mask of COUNT field.
	TC_COUNT8_SYNCBUSY_COUNT      = 0x10 // Bit COUNT.
	TC_COUNT8_SYNCBUSY_PER_Pos    = 0x5  // Position of PER field.
	TC_COUNT8_SYNCBUSY_PER_Msk    = 0x20 // Bit mask of PER field.
	TC_COUNT8_SYNCBUSY_PER        = 0x20 // Bit PER.
	TC_COUNT8_SYNCBUSY_CC0_Pos    = 0x6  // Position of CC0 field.
	TC_COUNT8_SYNCBUSY_CC0_Msk    = 0x40 // Bit mask of CC0 field.
	TC_COUNT8_SYNCBUSY_CC0        = 0x40 // Bit CC0.
	TC_COUNT8_SYNCBUSY_CC1_Pos    = 0x7  // Position of CC1 field.
	TC_COUNT8_SYNCBUSY_CC1_Msk    = 0x80 // Bit mask of CC1 field.
	TC_COUNT8_SYNCBUSY_CC1        = 0x80 // Bit CC1.

	// COUNT: COUNT8 Count
	TC_COUNT8_COUNT_COUNT_Pos = 0x0  // Position of COUNT field.
	TC_COUNT8_COUNT_COUNT_Msk = 0xff // Bit mask of COUNT field.

	// PER: COUNT8 Period
	TC_COUNT8_PER_PER_Pos = 0x0  // Position of PER field.
	TC_COUNT8_PER_PER_Msk = 0xff // Bit mask of PER field.

	// CC: COUNT8 Compare and Capture
	TC_COUNT8_CC_CC_Pos = 0x0  // Position of CC field.
	TC_COUNT8_CC_CC_Msk = 0xff // Bit mask of CC field.

	// PERBUF: COUNT8 Period Buffer
	TC_COUNT8_PERBUF_PERBUF_Pos = 0x0  // Position of PERBUF field.
	TC_COUNT8_PERBUF_PERBUF_Msk = 0xff // Bit mask of PERBUF field.

	// CCBUF: COUNT8 Compare and Capture Buffer
	TC_COUNT8_CCBUF_CCBUF_Pos = 0x0  // Position of CCBUF field.
	TC_COUNT8_CCBUF_CCBUF_Msk = 0xff // Bit mask of CCBUF field.
)

// Bitfields for TC0_COUNT16: Basic Timer Counter - COUNT16
const (
	// CTRLA: Control A
	TC_COUNT16_CTRLA_SWRST_Pos         = 0x0        // Position of SWRST field.
	TC_COUNT16_CTRLA_SWRST_Msk         = 0x1        // Bit mask of SWRST field.
	TC_COUNT16_CTRLA_SWRST             = 0x1        // Bit SWRST.
	TC_COUNT16_CTRLA_ENABLE_Pos        = 0x1        // Position of ENABLE field.
	TC_COUNT16_CTRLA_ENABLE_Msk        = 0x2        // Bit mask of ENABLE field.
	TC_COUNT16_CTRLA_ENABLE            = 0x2        // Bit ENABLE.
	TC_COUNT16_CTRLA_MODE_Pos          = 0x2        // Position of MODE field.
	TC_COUNT16_CTRLA_MODE_Msk          = 0xc        // Bit mask of MODE field.
	TC_COUNT16_CTRLA_MODE_COUNT16      = 0x0        // Counter in 16-bit mode
	TC_COUNT16_CTRLA_MODE_COUNT8       = 0x1        // Counter in 8-bit mode
	TC_COUNT16_CTRLA_MODE_COUNT32      = 0x2        // Counter in 32-bit mode
	TC_COUNT16_CTRLA_PRESCSYNC_Pos     = 0x4        // Position of PRESCSYNC field.
	TC_COUNT16_CTRLA_PRESCSYNC_Msk     = 0x30       // Bit mask of PRESCSYNC field.
	TC_COUNT16_CTRLA_PRESCSYNC_GCLK    = 0x0        // Reload or reset the counter on next generic clock
	TC_COUNT16_CTRLA_PRESCSYNC_PRESC   = 0x1        // Reload or reset the counter on next prescaler clock
	TC_COUNT16_CTRLA_PRESCSYNC_RESYNC  = 0x2        // Reload or reset the counter on next generic clock and reset the prescaler counter
	TC_COUNT16_CTRLA_RUNSTDBY_Pos      = 0x6        // Position of RUNSTDBY field.
	TC_COUNT16_CTRLA_RUNSTDBY_Msk      = 0x40       // Bit mask of RUNSTDBY field.
	TC_COUNT16_CTRLA_RUNSTDBY          = 0x40       // Bit RUNSTDBY.
	TC_COUNT16_CTRLA_ONDEMAND_Pos      = 0x7        // Position of ONDEMAND field.
	TC_COUNT16_CTRLA_ONDEMAND_Msk      = 0x80       // Bit mask of ONDEMAND field.
	TC_COUNT16_CTRLA_ONDEMAND          = 0x80       // Bit ONDEMAND.
	TC_COUNT16_CTRLA_PRESCALER_Pos     = 0x8        // Position of PRESCALER field.
	TC_COUNT16_CTRLA_PRESCALER_Msk     = 0x700      // Bit mask of PRESCALER field.
	TC_COUNT16_CTRLA_PRESCALER_DIV1    = 0x0        // Prescaler: GCLK_TC
	TC_COUNT16_CTRLA_PRESCALER_DIV2    = 0x1        // Prescaler: GCLK_TC/2
	TC_COUNT16_CTRLA_PRESCALER_DIV4    = 0x2        // Prescaler: GCLK_TC/4
	TC_COUNT16_CTRLA_PRESCALER_DIV8    = 0x3        // Prescaler: GCLK_TC/8
	TC_COUNT16_CTRLA_PRESCALER_DIV16   = 0x4        // Prescaler: GCLK_TC/16
	TC_COUNT16_CTRLA_PRESCALER_DIV64   = 0x5        // Prescaler: GCLK_TC/64
	TC_COUNT16_CTRLA_PRESCALER_DIV256  = 0x6        // Prescaler: GCLK_TC/256
	TC_COUNT16_CTRLA_PRESCALER_DIV1024 = 0x7        // Prescaler: GCLK_TC/1024
	TC_COUNT16_CTRLA_ALOCK_Pos         = 0xb        // Position of ALOCK field.
	TC_COUNT16_CTRLA_ALOCK_Msk         = 0x800      // Bit mask of ALOCK field.
	TC_COUNT16_CTRLA_ALOCK             = 0x800      // Bit ALOCK.
	TC_COUNT16_CTRLA_CAPTEN0_Pos       = 0x10       // Position of CAPTEN0 field.
	TC_COUNT16_CTRLA_CAPTEN0_Msk       = 0x10000    // Bit mask of CAPTEN0 field.
	TC_COUNT16_CTRLA_CAPTEN0           = 0x10000    // Bit CAPTEN0.
	TC_COUNT16_CTRLA_CAPTEN1_Pos       = 0x11       // Position of CAPTEN1 field.
	TC_COUNT16_CTRLA_CAPTEN1_Msk       = 0x20000    // Bit mask of CAPTEN1 field.
	TC_COUNT16_CTRLA_CAPTEN1           = 0x20000    // Bit CAPTEN1.
	TC_COUNT16_CTRLA_COPEN0_Pos        = 0x14       // Position of COPEN0 field.
	TC_COUNT16_CTRLA_COPEN0_Msk        = 0x100000   // Bit mask of COPEN0 field.
	TC_COUNT16_CTRLA_COPEN0            = 0x100000   // Bit COPEN0.
	TC_COUNT16_CTRLA_COPEN1_Pos        = 0x15       // Position of COPEN1 field.
	TC_COUNT16_CTRLA_COPEN1_Msk        = 0x200000   // Bit mask of COPEN1 field.
	TC_COUNT16_CTRLA_COPEN1            = 0x200000   // Bit COPEN1.
	TC_COUNT16_CTRLA_CAPTMODE0_Pos     = 0x18       // Position of CAPTMODE0 field.
	TC_COUNT16_CTRLA_CAPTMODE0_Msk     = 0x3000000  // Bit mask of CAPTMODE0 field.
	TC_COUNT16_CTRLA_CAPTMODE0_DEFAULT = 0x0        // Default capture
	TC_COUNT16_CTRLA_CAPTMODE0_CAPTMIN = 0x1        // Minimum capture
	TC_COUNT16_CTRLA_CAPTMODE0_CAPTMAX = 0x2        // Maximum capture
	TC_COUNT16_CTRLA_CAPTMODE1_Pos     = 0x1b       // Position of CAPTMODE1 field.
	TC_COUNT16_CTRLA_CAPTMODE1_Msk     = 0x18000000 // Bit mask of CAPTMODE1 field.
	TC_COUNT16_CTRLA_CAPTMODE1_DEFAULT = 0x0        // Default capture
	TC_COUNT16_CTRLA_CAPTMODE1_CAPTMIN = 0x1        // Minimum capture
	TC_COUNT16_CTRLA_CAPTMODE1_CAPTMAX = 0x2        // Maximum capture

	// CTRLBCLR: Control B Clear
	TC_COUNT16_CTRLBCLR_DIR_Pos       = 0x0  // Position of DIR field.
	TC_COUNT16_CTRLBCLR_DIR_Msk       = 0x1  // Bit mask of DIR field.
	TC_COUNT16_CTRLBCLR_DIR           = 0x1  // Bit DIR.
	TC_COUNT16_CTRLBCLR_LUPD_Pos      = 0x1  // Position of LUPD field.
	TC_COUNT16_CTRLBCLR_LUPD_Msk      = 0x2  // Bit mask of LUPD field.
	TC_COUNT16_CTRLBCLR_LUPD          = 0x2  // Bit LUPD.
	TC_COUNT16_CTRLBCLR_ONESHOT_Pos   = 0x2  // Position of ONESHOT field.
	TC_COUNT16_CTRLBCLR_ONESHOT_Msk   = 0x4  // Bit mask of ONESHOT field.
	TC_COUNT16_CTRLBCLR_ONESHOT       = 0x4  // Bit ONESHOT.
	TC_COUNT16_CTRLBCLR_CMD_Pos       = 0x5  // Position of CMD field.
	TC_COUNT16_CTRLBCLR_CMD_Msk       = 0xe0 // Bit mask of CMD field.
	TC_COUNT16_CTRLBCLR_CMD_NONE      = 0x0  // No action
	TC_COUNT16_CTRLBCLR_CMD_RETRIGGER = 0x1  // Force a start, restart or retrigger
	TC_COUNT16_CTRLBCLR_CMD_STOP      = 0x2  // Force a stop
	TC_COUNT16_CTRLBCLR_CMD_UPDATE    = 0x3  // Force update of double-buffered register
	TC_COUNT16_CTRLBCLR_CMD_READSYNC  = 0x4  // Force a read synchronization of COUNT
	TC_COUNT16_CTRLBCLR_CMD_DMAOS     = 0x5  // One-shot DMA trigger

	// CTRLBSET: Control B Set
	TC_COUNT16_CTRLBSET_DIR_Pos       = 0x0  // Position of DIR field.
	TC_COUNT16_CTRLBSET_DIR_Msk       = 0x1  // Bit mask of DIR field.
	TC_COUNT16_CTRLBSET_DIR           = 0x1  // Bit DIR.
	TC_COUNT16_CTRLBSET_LUPD_Pos      = 0x1  // Position of LUPD field.
	TC_COUNT16_CTRLBSET_LUPD_Msk      = 0x2  // Bit mask of LUPD field.
	TC_COUNT16_CTRLBSET_LUPD          = 0x2  // Bit LUPD.
	TC_COUNT16_CTRLBSET_ONESHOT_Pos   = 0x2  // Position of ONESHOT field.
	TC_COUNT16_CTRLBSET_ONESHOT_Msk   = 0x4  // Bit mask of ONESHOT field.
	TC_COUNT16_CTRLBSET_ONESHOT       = 0x4  // Bit ONESHOT.
	TC_COUNT16_CTRLBSET_CMD_Pos       = 0x5  // Position of CMD field.
	TC_COUNT16_CTRLBSET_CMD_Msk       = 0xe0 // Bit mask of CMD field.
	TC_COUNT16_CTRLBSET_CMD_NONE      = 0x0  // No action
	TC_COUNT16_CTRLBSET_CMD_RETRIGGER = 0x1  // Force a start, restart or retrigger
	TC_COUNT16_CTRLBSET_CMD_STOP      = 0x2  // Force a stop
	TC_COUNT16_CTRLBSET_CMD_UPDATE    = 0x3  // Force update of double-buffered register
	TC_COUNT16_CTRLBSET_CMD_READSYNC  = 0x4  // Force a read synchronization of COUNT
	TC_COUNT16_CTRLBSET_CMD_DMAOS     = 0x5  // One-shot DMA trigger

	// EVCTRL: Event Control
	TC_COUNT16_EVCTRL_EVACT_Pos       = 0x0    // Position of EVACT field.
	TC_COUNT16_EVCTRL_EVACT_Msk       = 0x7    // Bit mask of EVACT field.
	TC_COUNT16_EVCTRL_EVACT_OFF       = 0x0    // Event action disabled
	TC_COUNT16_EVCTRL_EVACT_RETRIGGER = 0x1    // Start, restart or retrigger TC on event
	TC_COUNT16_EVCTRL_EVACT_COUNT     = 0x2    // Count on event
	TC_COUNT16_EVCTRL_EVACT_START     = 0x3    // Start TC on event
	TC_COUNT16_EVCTRL_EVACT_STAMP     = 0x4    // Time stamp capture
	TC_COUNT16_EVCTRL_EVACT_PPW       = 0x5    // Period catured in CC0, pulse width in CC1
	TC_COUNT16_EVCTRL_EVACT_PWP       = 0x6    // Period catured in CC1, pulse width in CC0
	TC_COUNT16_EVCTRL_EVACT_PW        = 0x7    // Pulse width capture
	TC_COUNT16_EVCTRL_TCINV_Pos       = 0x4    // Position of TCINV field.
	TC_COUNT16_EVCTRL_TCINV_Msk       = 0x10   // Bit mask of TCINV field.
	TC_COUNT16_EVCTRL_TCINV           = 0x10   // Bit TCINV.
	TC_COUNT16_EVCTRL_TCEI_Pos        = 0x5    // Position of TCEI field.
	TC_COUNT16_EVCTRL_TCEI_Msk        = 0x20   // Bit mask of TCEI field.
	TC_COUNT16_EVCTRL_TCEI            = 0x20   // Bit TCEI.
	TC_COUNT16_EVCTRL_OVFEO_Pos       = 0x8    // Position of OVFEO field.
	TC_COUNT16_EVCTRL_OVFEO_Msk       = 0x100  // Bit mask of OVFEO field.
	TC_COUNT16_EVCTRL_OVFEO           = 0x100  // Bit OVFEO.
	TC_COUNT16_EVCTRL_MCEO0_Pos       = 0xc    // Position of MCEO0 field.
	TC_COUNT16_EVCTRL_MCEO0_Msk       = 0x1000 // Bit mask of MCEO0 field.
	TC_COUNT16_EVCTRL_MCEO0           = 0x1000 // Bit MCEO0.
	TC_COUNT16_EVCTRL_MCEO1_Pos       = 0xd    // Position of MCEO1 field.
	TC_COUNT16_EVCTRL_MCEO1_Msk       = 0x2000 // Bit mask of MCEO1 field.
	TC_COUNT16_EVCTRL_MCEO1           = 0x2000 // Bit MCEO1.

	// INTENCLR: Interrupt Enable Clear
	TC_COUNT16_INTENCLR_OVF_Pos = 0x0  // Position of OVF field.
	TC_COUNT16_INTENCLR_OVF_Msk = 0x1  // Bit mask of OVF field.
	TC_COUNT16_INTENCLR_OVF     = 0x1  // Bit OVF.
	TC_COUNT16_INTENCLR_ERR_Pos = 0x1  // Position of ERR field.
	TC_COUNT16_INTENCLR_ERR_Msk = 0x2  // Bit mask of ERR field.
	TC_COUNT16_INTENCLR_ERR     = 0x2  // Bit ERR.
	TC_COUNT16_INTENCLR_MC0_Pos = 0x4  // Position of MC0 field.
	TC_COUNT16_INTENCLR_MC0_Msk = 0x10 // Bit mask of MC0 field.
	TC_COUNT16_INTENCLR_MC0     = 0x10 // Bit MC0.
	TC_COUNT16_INTENCLR_MC1_Pos = 0x5  // Position of MC1 field.
	TC_COUNT16_INTENCLR_MC1_Msk = 0x20 // Bit mask of MC1 field.
	TC_COUNT16_INTENCLR_MC1     = 0x20 // Bit MC1.

	// INTENSET: Interrupt Enable Set
	TC_COUNT16_INTENSET_OVF_Pos = 0x0  // Position of OVF field.
	TC_COUNT16_INTENSET_OVF_Msk = 0x1  // Bit mask of OVF field.
	TC_COUNT16_INTENSET_OVF     = 0x1  // Bit OVF.
	TC_COUNT16_INTENSET_ERR_Pos = 0x1  // Position of ERR field.
	TC_COUNT16_INTENSET_ERR_Msk = 0x2  // Bit mask of ERR field.
	TC_COUNT16_INTENSET_ERR     = 0x2  // Bit ERR.
	TC_COUNT16_INTENSET_MC0_Pos = 0x4  // Position of MC0 field.
	TC_COUNT16_INTENSET_MC0_Msk = 0x10 // Bit mask of MC0 field.
	TC_COUNT16_INTENSET_MC0     = 0x10 // Bit MC0.
	TC_COUNT16_INTENSET_MC1_Pos = 0x5  // Position of MC1 field.
	TC_COUNT16_INTENSET_MC1_Msk = 0x20 // Bit mask of MC1 field.
	TC_COUNT16_INTENSET_MC1     = 0x20 // Bit MC1.

	// INTFLAG: Interrupt Flag Status and Clear
	TC_COUNT16_INTFLAG_OVF_Pos = 0x0  // Position of OVF field.
	TC_COUNT16_INTFLAG_OVF_Msk = 0x1  // Bit mask of OVF field.
	TC_COUNT16_INTFLAG_OVF     = 0x1  // Bit OVF.
	TC_COUNT16_INTFLAG_ERR_Pos = 0x1  // Position of ERR field.
	TC_COUNT16_INTFLAG_ERR_Msk = 0x2  // Bit mask of ERR field.
	TC_COUNT16_INTFLAG_ERR     = 0x2  // Bit ERR.
	TC_COUNT16_INTFLAG_MC0_Pos = 0x4  // Position of MC0 field.
	TC_COUNT16_INTFLAG_MC0_Msk = 0x10 // Bit mask of MC0 field.
	TC_COUNT16_INTFLAG_MC0     = 0x10 // Bit MC0.
	TC_COUNT16_INTFLAG_MC1_Pos = 0x5  // Position of MC1 field.
	TC_COUNT16_INTFLAG_MC1_Msk = 0x20 // Bit mask of MC1 field.
	TC_COUNT16_INTFLAG_MC1     = 0x20 // Bit MC1.

	// STATUS: Status
	TC_COUNT16_STATUS_STOP_Pos    = 0x0  // Position of STOP field.
	TC_COUNT16_STATUS_STOP_Msk    = 0x1  // Bit mask of STOP field.
	TC_COUNT16_STATUS_STOP        = 0x1  // Bit STOP.
	TC_COUNT16_STATUS_SLAVE_Pos   = 0x1  // Position of SLAVE field.
	TC_COUNT16_STATUS_SLAVE_Msk   = 0x2  // Bit mask of SLAVE field.
	TC_COUNT16_STATUS_SLAVE       = 0x2  // Bit SLAVE.
	TC_COUNT16_STATUS_PERBUFV_Pos = 0x3  // Position of PERBUFV field.
	TC_COUNT16_STATUS_PERBUFV_Msk = 0x8  // Bit mask of PERBUFV field.
	TC_COUNT16_STATUS_PERBUFV     = 0x8  // Bit PERBUFV.
	TC_COUNT16_STATUS_CCBUFV0_Pos = 0x4  // Position of CCBUFV0 field.
	TC_COUNT16_STATUS_CCBUFV0_Msk = 0x10 // Bit mask of CCBUFV0 field.
	TC_COUNT16_STATUS_CCBUFV0     = 0x10 // Bit CCBUFV0.
	TC_COUNT16_STATUS_CCBUFV1_Pos = 0x5  // Position of CCBUFV1 field.
	TC_COUNT16_STATUS_CCBUFV1_Msk = 0x20 // Bit mask of CCBUFV1 field.
	TC_COUNT16_STATUS_CCBUFV1     = 0x20 // Bit CCBUFV1.

	// WAVE: Waveform Generation Control
	TC_COUNT16_WAVE_WAVEGEN_Pos  = 0x0 // Position of WAVEGEN field.
	TC_COUNT16_WAVE_WAVEGEN_Msk  = 0x3 // Bit mask of WAVEGEN field.
	TC_COUNT16_WAVE_WAVEGEN_NFRQ = 0x0 // Normal frequency
	TC_COUNT16_WAVE_WAVEGEN_MFRQ = 0x1 // Match frequency
	TC_COUNT16_WAVE_WAVEGEN_NPWM = 0x2 // Normal PWM
	TC_COUNT16_WAVE_WAVEGEN_MPWM = 0x3 // Match PWM

	// DRVCTRL: Control C
	TC_COUNT16_DRVCTRL_INVEN0_Pos = 0x0 // Position of INVEN0 field.
	TC_COUNT16_DRVCTRL_INVEN0_Msk = 0x1 // Bit mask of INVEN0 field.
	TC_COUNT16_DRVCTRL_INVEN0     = 0x1 // Bit INVEN0.
	TC_COUNT16_DRVCTRL_INVEN1_Pos = 0x1 // Position of INVEN1 field.
	TC_COUNT16_DRVCTRL_INVEN1_Msk = 0x2 // Bit mask of INVEN1 field.
	TC_COUNT16_DRVCTRL_INVEN1     = 0x2 // Bit INVEN1.

	// DBGCTRL: Debug Control
	TC_COUNT16_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	TC_COUNT16_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	TC_COUNT16_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// SYNCBUSY: Synchronization Status
	TC_COUNT16_SYNCBUSY_SWRST_Pos  = 0x0  // Position of SWRST field.
	TC_COUNT16_SYNCBUSY_SWRST_Msk  = 0x1  // Bit mask of SWRST field.
	TC_COUNT16_SYNCBUSY_SWRST      = 0x1  // Bit SWRST.
	TC_COUNT16_SYNCBUSY_ENABLE_Pos = 0x1  // Position of ENABLE field.
	TC_COUNT16_SYNCBUSY_ENABLE_Msk = 0x2  // Bit mask of ENABLE field.
	TC_COUNT16_SYNCBUSY_ENABLE     = 0x2  // Bit ENABLE.
	TC_COUNT16_SYNCBUSY_CTRLB_Pos  = 0x2  // Position of CTRLB field.
	TC_COUNT16_SYNCBUSY_CTRLB_Msk  = 0x4  // Bit mask of CTRLB field.
	TC_COUNT16_SYNCBUSY_CTRLB      = 0x4  // Bit CTRLB.
	TC_COUNT16_SYNCBUSY_STATUS_Pos = 0x3  // Position of STATUS field.
	TC_COUNT16_SYNCBUSY_STATUS_Msk = 0x8  // Bit mask of STATUS field.
	TC_COUNT16_SYNCBUSY_STATUS     = 0x8  // Bit STATUS.
	TC_COUNT16_SYNCBUSY_COUNT_Pos  = 0x4  // Position of COUNT field.
	TC_COUNT16_SYNCBUSY_COUNT_Msk  = 0x10 // Bit mask of COUNT field.
	TC_COUNT16_SYNCBUSY_COUNT      = 0x10 // Bit COUNT.
	TC_COUNT16_SYNCBUSY_PER_Pos    = 0x5  // Position of PER field.
	TC_COUNT16_SYNCBUSY_PER_Msk    = 0x20 // Bit mask of PER field.
	TC_COUNT16_SYNCBUSY_PER        = 0x20 // Bit PER.
	TC_COUNT16_SYNCBUSY_CC0_Pos    = 0x6  // Position of CC0 field.
	TC_COUNT16_SYNCBUSY_CC0_Msk    = 0x40 // Bit mask of CC0 field.
	TC_COUNT16_SYNCBUSY_CC0        = 0x40 // Bit CC0.
	TC_COUNT16_SYNCBUSY_CC1_Pos    = 0x7  // Position of CC1 field.
	TC_COUNT16_SYNCBUSY_CC1_Msk    = 0x80 // Bit mask of CC1 field.
	TC_COUNT16_SYNCBUSY_CC1        = 0x80 // Bit CC1.

	// COUNT: COUNT16 Count
	TC_COUNT16_COUNT_COUNT_Pos = 0x0    // Position of COUNT field.
	TC_COUNT16_COUNT_COUNT_Msk = 0xffff // Bit mask of COUNT field.

	// PER: COUNT16 Period
	TC_COUNT16_PER_PER_Pos = 0x0    // Position of PER field.
	TC_COUNT16_PER_PER_Msk = 0xffff // Bit mask of PER field.

	// CC: COUNT16 Compare and Capture
	TC_COUNT16_CC_CC_Pos = 0x0    // Position of CC field.
	TC_COUNT16_CC_CC_Msk = 0xffff // Bit mask of CC field.

	// PERBUF: COUNT16 Period Buffer
	TC_COUNT16_PERBUF_PERBUF_Pos = 0x0    // Position of PERBUF field.
	TC_COUNT16_PERBUF_PERBUF_Msk = 0xffff // Bit mask of PERBUF field.

	// CCBUF: COUNT16 Compare and Capture Buffer
	TC_COUNT16_CCBUF_CCBUF_Pos = 0x0    // Position of CCBUF field.
	TC_COUNT16_CCBUF_CCBUF_Msk = 0xffff // Bit mask of CCBUF field.
)

// Bitfields for TC0_COUNT32: Basic Timer Counter - COUNT32
const (
	// CTRLA: Control A
	TC_COUNT32_CTRLA_SWRST_Pos         = 0x0        // Position of SWRST field.
	TC_COUNT32_CTRLA_SWRST_Msk         = 0x1        // Bit mask of SWRST field.
	TC_COUNT32_CTRLA_SWRST             = 0x1        // Bit SWRST.
	TC_COUNT32_CTRLA_ENABLE_Pos        = 0x1        // Position of ENABLE field.
	TC_COUNT32_CTRLA_ENABLE_Msk        = 0x2        // Bit mask of ENABLE field.
	TC_COUNT32_CTRLA_ENABLE            = 0x2        // Bit ENABLE.
	TC_COUNT32_CTRLA_MODE_Pos          = 0x2        // Position of MODE field.
	TC_COUNT32_CTRLA_MODE_Msk          = 0xc        // Bit mask of MODE field.
	TC_COUNT32_CTRLA_MODE_COUNT16      = 0x0        // Counter in 16-bit mode
	TC_COUNT32_CTRLA_MODE_COUNT8       = 0x1        // Counter in 8-bit mode
	TC_COUNT32_CTRLA_MODE_COUNT32      = 0x2        // Counter in 32-bit mode
	TC_COUNT32_CTRLA_PRESCSYNC_Pos     = 0x4        // Position of PRESCSYNC field.
	TC_COUNT32_CTRLA_PRESCSYNC_Msk     = 0x30       // Bit mask of PRESCSYNC field.
	TC_COUNT32_CTRLA_PRESCSYNC_GCLK    = 0x0        // Reload or reset the counter on next generic clock
	TC_COUNT32_CTRLA_PRESCSYNC_PRESC   = 0x1        // Reload or reset the counter on next prescaler clock
	TC_COUNT32_CTRLA_PRESCSYNC_RESYNC  = 0x2        // Reload or reset the counter on next generic clock and reset the prescaler counter
	TC_COUNT32_CTRLA_RUNSTDBY_Pos      = 0x6        // Position of RUNSTDBY field.
	TC_COUNT32_CTRLA_RUNSTDBY_Msk      = 0x40       // Bit mask of RUNSTDBY field.
	TC_COUNT32_CTRLA_RUNSTDBY          = 0x40       // Bit RUNSTDBY.
	TC_COUNT32_CTRLA_ONDEMAND_Pos      = 0x7        // Position of ONDEMAND field.
	TC_COUNT32_CTRLA_ONDEMAND_Msk      = 0x80       // Bit mask of ONDEMAND field.
	TC_COUNT32_CTRLA_ONDEMAND          = 0x80       // Bit ONDEMAND.
	TC_COUNT32_CTRLA_PRESCALER_Pos     = 0x8        // Position of PRESCALER field.
	TC_COUNT32_CTRLA_PRESCALER_Msk     = 0x700      // Bit mask of PRESCALER field.
	TC_COUNT32_CTRLA_PRESCALER_DIV1    = 0x0        // Prescaler: GCLK_TC
	TC_COUNT32_CTRLA_PRESCALER_DIV2    = 0x1        // Prescaler: GCLK_TC/2
	TC_COUNT32_CTRLA_PRESCALER_DIV4    = 0x2        // Prescaler: GCLK_TC/4
	TC_COUNT32_CTRLA_PRESCALER_DIV8    = 0x3        // Prescaler: GCLK_TC/8
	TC_COUNT32_CTRLA_PRESCALER_DIV16   = 0x4        // Prescaler: GCLK_TC/16
	TC_COUNT32_CTRLA_PRESCALER_DIV64   = 0x5        // Prescaler: GCLK_TC/64
	TC_COUNT32_CTRLA_PRESCALER_DIV256  = 0x6        // Prescaler: GCLK_TC/256
	TC_COUNT32_CTRLA_PRESCALER_DIV1024 = 0x7        // Prescaler: GCLK_TC/1024
	TC_COUNT32_CTRLA_ALOCK_Pos         = 0xb        // Position of ALOCK field.
	TC_COUNT32_CTRLA_ALOCK_Msk         = 0x800      // Bit mask of ALOCK field.
	TC_COUNT32_CTRLA_ALOCK             = 0x800      // Bit ALOCK.
	TC_COUNT32_CTRLA_CAPTEN0_Pos       = 0x10       // Position of CAPTEN0 field.
	TC_COUNT32_CTRLA_CAPTEN0_Msk       = 0x10000    // Bit mask of CAPTEN0 field.
	TC_COUNT32_CTRLA_CAPTEN0           = 0x10000    // Bit CAPTEN0.
	TC_COUNT32_CTRLA_CAPTEN1_Pos       = 0x11       // Position of CAPTEN1 field.
	TC_COUNT32_CTRLA_CAPTEN1_Msk       = 0x20000    // Bit mask of CAPTEN1 field.
	TC_COUNT32_CTRLA_CAPTEN1           = 0x20000    // Bit CAPTEN1.
	TC_COUNT32_CTRLA_COPEN0_Pos        = 0x14       // Position of COPEN0 field.
	TC_COUNT32_CTRLA_COPEN0_Msk        = 0x100000   // Bit mask of COPEN0 field.
	TC_COUNT32_CTRLA_COPEN0            = 0x100000   // Bit COPEN0.
	TC_COUNT32_CTRLA_COPEN1_Pos        = 0x15       // Position of COPEN1 field.
	TC_COUNT32_CTRLA_COPEN1_Msk        = 0x200000   // Bit mask of COPEN1 field.
	TC_COUNT32_CTRLA_COPEN1            = 0x200000   // Bit COPEN1.
	TC_COUNT32_CTRLA_CAPTMODE0_Pos     = 0x18       // Position of CAPTMODE0 field.
	TC_COUNT32_CTRLA_CAPTMODE0_Msk     = 0x3000000  // Bit mask of CAPTMODE0 field.
	TC_COUNT32_CTRLA_CAPTMODE0_DEFAULT = 0x0        // Default capture
	TC_COUNT32_CTRLA_CAPTMODE0_CAPTMIN = 0x1        // Minimum capture
	TC_COUNT32_CTRLA_CAPTMODE0_CAPTMAX = 0x2        // Maximum capture
	TC_COUNT32_CTRLA_CAPTMODE1_Pos     = 0x1b       // Position of CAPTMODE1 field.
	TC_COUNT32_CTRLA_CAPTMODE1_Msk     = 0x18000000 // Bit mask of CAPTMODE1 field.
	TC_COUNT32_CTRLA_CAPTMODE1_DEFAULT = 0x0        // Default capture
	TC_COUNT32_CTRLA_CAPTMODE1_CAPTMIN = 0x1        // Minimum capture
	TC_COUNT32_CTRLA_CAPTMODE1_CAPTMAX = 0x2        // Maximum capture

	// CTRLBCLR: Control B Clear
	TC_COUNT32_CTRLBCLR_DIR_Pos       = 0x0  // Position of DIR field.
	TC_COUNT32_CTRLBCLR_DIR_Msk       = 0x1  // Bit mask of DIR field.
	TC_COUNT32_CTRLBCLR_DIR           = 0x1  // Bit DIR.
	TC_COUNT32_CTRLBCLR_LUPD_Pos      = 0x1  // Position of LUPD field.
	TC_COUNT32_CTRLBCLR_LUPD_Msk      = 0x2  // Bit mask of LUPD field.
	TC_COUNT32_CTRLBCLR_LUPD          = 0x2  // Bit LUPD.
	TC_COUNT32_CTRLBCLR_ONESHOT_Pos   = 0x2  // Position of ONESHOT field.
	TC_COUNT32_CTRLBCLR_ONESHOT_Msk   = 0x4  // Bit mask of ONESHOT field.
	TC_COUNT32_CTRLBCLR_ONESHOT       = 0x4  // Bit ONESHOT.
	TC_COUNT32_CTRLBCLR_CMD_Pos       = 0x5  // Position of CMD field.
	TC_COUNT32_CTRLBCLR_CMD_Msk       = 0xe0 // Bit mask of CMD field.
	TC_COUNT32_CTRLBCLR_CMD_NONE      = 0x0  // No action
	TC_COUNT32_CTRLBCLR_CMD_RETRIGGER = 0x1  // Force a start, restart or retrigger
	TC_COUNT32_CTRLBCLR_CMD_STOP      = 0x2  // Force a stop
	TC_COUNT32_CTRLBCLR_CMD_UPDATE    = 0x3  // Force update of double-buffered register
	TC_COUNT32_CTRLBCLR_CMD_READSYNC  = 0x4  // Force a read synchronization of COUNT
	TC_COUNT32_CTRLBCLR_CMD_DMAOS     = 0x5  // One-shot DMA trigger

	// CTRLBSET: Control B Set
	TC_COUNT32_CTRLBSET_DIR_Pos       = 0x0  // Position of DIR field.
	TC_COUNT32_CTRLBSET_DIR_Msk       = 0x1  // Bit mask of DIR field.
	TC_COUNT32_CTRLBSET_DIR           = 0x1  // Bit DIR.
	TC_COUNT32_CTRLBSET_LUPD_Pos      = 0x1  // Position of LUPD field.
	TC_COUNT32_CTRLBSET_LUPD_Msk      = 0x2  // Bit mask of LUPD field.
	TC_COUNT32_CTRLBSET_LUPD          = 0x2  // Bit LUPD.
	TC_COUNT32_CTRLBSET_ONESHOT_Pos   = 0x2  // Position of ONESHOT field.
	TC_COUNT32_CTRLBSET_ONESHOT_Msk   = 0x4  // Bit mask of ONESHOT field.
	TC_COUNT32_CTRLBSET_ONESHOT       = 0x4  // Bit ONESHOT.
	TC_COUNT32_CTRLBSET_CMD_Pos       = 0x5  // Position of CMD field.
	TC_COUNT32_CTRLBSET_CMD_Msk       = 0xe0 // Bit mask of CMD field.
	TC_COUNT32_CTRLBSET_CMD_NONE      = 0x0  // No action
	TC_COUNT32_CTRLBSET_CMD_RETRIGGER = 0x1  // Force a start, restart or retrigger
	TC_COUNT32_CTRLBSET_CMD_STOP      = 0x2  // Force a stop
	TC_COUNT32_CTRLBSET_CMD_UPDATE    = 0x3  // Force update of double-buffered register
	TC_COUNT32_CTRLBSET_CMD_READSYNC  = 0x4  // Force a read synchronization of COUNT
	TC_COUNT32_CTRLBSET_CMD_DMAOS     = 0x5  // One-shot DMA trigger

	// EVCTRL: Event Control
	TC_COUNT32_EVCTRL_EVACT_Pos       = 0x0    // Position of EVACT field.
	TC_COUNT32_EVCTRL_EVACT_Msk       = 0x7    // Bit mask of EVACT field.
	TC_COUNT32_EVCTRL_EVACT_OFF       = 0x0    // Event action disabled
	TC_COUNT32_EVCTRL_EVACT_RETRIGGER = 0x1    // Start, restart or retrigger TC on event
	TC_COUNT32_EVCTRL_EVACT_COUNT     = 0x2    // Count on event
	TC_COUNT32_EVCTRL_EVACT_START     = 0x3    // Start TC on event
	TC_COUNT32_EVCTRL_EVACT_STAMP     = 0x4    // Time stamp capture
	TC_COUNT32_EVCTRL_EVACT_PPW       = 0x5    // Period catured in CC0, pulse width in CC1
	TC_COUNT32_EVCTRL_EVACT_PWP       = 0x6    // Period catured in CC1, pulse width in CC0
	TC_COUNT32_EVCTRL_EVACT_PW        = 0x7    // Pulse width capture
	TC_COUNT32_EVCTRL_TCINV_Pos       = 0x4    // Position of TCINV field.
	TC_COUNT32_EVCTRL_TCINV_Msk       = 0x10   // Bit mask of TCINV field.
	TC_COUNT32_EVCTRL_TCINV           = 0x10   // Bit TCINV.
	TC_COUNT32_EVCTRL_TCEI_Pos        = 0x5    // Position of TCEI field.
	TC_COUNT32_EVCTRL_TCEI_Msk        = 0x20   // Bit mask of TCEI field.
	TC_COUNT32_EVCTRL_TCEI            = 0x20   // Bit TCEI.
	TC_COUNT32_EVCTRL_OVFEO_Pos       = 0x8    // Position of OVFEO field.
	TC_COUNT32_EVCTRL_OVFEO_Msk       = 0x100  // Bit mask of OVFEO field.
	TC_COUNT32_EVCTRL_OVFEO           = 0x100  // Bit OVFEO.
	TC_COUNT32_EVCTRL_MCEO0_Pos       = 0xc    // Position of MCEO0 field.
	TC_COUNT32_EVCTRL_MCEO0_Msk       = 0x1000 // Bit mask of MCEO0 field.
	TC_COUNT32_EVCTRL_MCEO0           = 0x1000 // Bit MCEO0.
	TC_COUNT32_EVCTRL_MCEO1_Pos       = 0xd    // Position of MCEO1 field.
	TC_COUNT32_EVCTRL_MCEO1_Msk       = 0x2000 // Bit mask of MCEO1 field.
	TC_COUNT32_EVCTRL_MCEO1           = 0x2000 // Bit MCEO1.

	// INTENCLR: Interrupt Enable Clear
	TC_COUNT32_INTENCLR_OVF_Pos = 0x0  // Position of OVF field.
	TC_COUNT32_INTENCLR_OVF_Msk = 0x1  // Bit mask of OVF field.
	TC_COUNT32_INTENCLR_OVF     = 0x1  // Bit OVF.
	TC_COUNT32_INTENCLR_ERR_Pos = 0x1  // Position of ERR field.
	TC_COUNT32_INTENCLR_ERR_Msk = 0x2  // Bit mask of ERR field.
	TC_COUNT32_INTENCLR_ERR     = 0x2  // Bit ERR.
	TC_COUNT32_INTENCLR_MC0_Pos = 0x4  // Position of MC0 field.
	TC_COUNT32_INTENCLR_MC0_Msk = 0x10 // Bit mask of MC0 field.
	TC_COUNT32_INTENCLR_MC0     = 0x10 // Bit MC0.
	TC_COUNT32_INTENCLR_MC1_Pos = 0x5  // Position of MC1 field.
	TC_COUNT32_INTENCLR_MC1_Msk = 0x20 // Bit mask of MC1 field.
	TC_COUNT32_INTENCLR_MC1     = 0x20 // Bit MC1.

	// INTENSET: Interrupt Enable Set
	TC_COUNT32_INTENSET_OVF_Pos = 0x0  // Position of OVF field.
	TC_COUNT32_INTENSET_OVF_Msk = 0x1  // Bit mask of OVF field.
	TC_COUNT32_INTENSET_OVF     = 0x1  // Bit OVF.
	TC_COUNT32_INTENSET_ERR_Pos = 0x1  // Position of ERR field.
	TC_COUNT32_INTENSET_ERR_Msk = 0x2  // Bit mask of ERR field.
	TC_COUNT32_INTENSET_ERR     = 0x2  // Bit ERR.
	TC_COUNT32_INTENSET_MC0_Pos = 0x4  // Position of MC0 field.
	TC_COUNT32_INTENSET_MC0_Msk = 0x10 // Bit mask of MC0 field.
	TC_COUNT32_INTENSET_MC0     = 0x10 // Bit MC0.
	TC_COUNT32_INTENSET_MC1_Pos = 0x5  // Position of MC1 field.
	TC_COUNT32_INTENSET_MC1_Msk = 0x20 // Bit mask of MC1 field.
	TC_COUNT32_INTENSET_MC1     = 0x20 // Bit MC1.

	// INTFLAG: Interrupt Flag Status and Clear
	TC_COUNT32_INTFLAG_OVF_Pos = 0x0  // Position of OVF field.
	TC_COUNT32_INTFLAG_OVF_Msk = 0x1  // Bit mask of OVF field.
	TC_COUNT32_INTFLAG_OVF     = 0x1  // Bit OVF.
	TC_COUNT32_INTFLAG_ERR_Pos = 0x1  // Position of ERR field.
	TC_COUNT32_INTFLAG_ERR_Msk = 0x2  // Bit mask of ERR field.
	TC_COUNT32_INTFLAG_ERR     = 0x2  // Bit ERR.
	TC_COUNT32_INTFLAG_MC0_Pos = 0x4  // Position of MC0 field.
	TC_COUNT32_INTFLAG_MC0_Msk = 0x10 // Bit mask of MC0 field.
	TC_COUNT32_INTFLAG_MC0     = 0x10 // Bit MC0.
	TC_COUNT32_INTFLAG_MC1_Pos = 0x5  // Position of MC1 field.
	TC_COUNT32_INTFLAG_MC1_Msk = 0x20 // Bit mask of MC1 field.
	TC_COUNT32_INTFLAG_MC1     = 0x20 // Bit MC1.

	// STATUS: Status
	TC_COUNT32_STATUS_STOP_Pos    = 0x0  // Position of STOP field.
	TC_COUNT32_STATUS_STOP_Msk    = 0x1  // Bit mask of STOP field.
	TC_COUNT32_STATUS_STOP        = 0x1  // Bit STOP.
	TC_COUNT32_STATUS_SLAVE_Pos   = 0x1  // Position of SLAVE field.
	TC_COUNT32_STATUS_SLAVE_Msk   = 0x2  // Bit mask of SLAVE field.
	TC_COUNT32_STATUS_SLAVE       = 0x2  // Bit SLAVE.
	TC_COUNT32_STATUS_PERBUFV_Pos = 0x3  // Position of PERBUFV field.
	TC_COUNT32_STATUS_PERBUFV_Msk = 0x8  // Bit mask of PERBUFV field.
	TC_COUNT32_STATUS_PERBUFV     = 0x8  // Bit PERBUFV.
	TC_COUNT32_STATUS_CCBUFV0_Pos = 0x4  // Position of CCBUFV0 field.
	TC_COUNT32_STATUS_CCBUFV0_Msk = 0x10 // Bit mask of CCBUFV0 field.
	TC_COUNT32_STATUS_CCBUFV0     = 0x10 // Bit CCBUFV0.
	TC_COUNT32_STATUS_CCBUFV1_Pos = 0x5  // Position of CCBUFV1 field.
	TC_COUNT32_STATUS_CCBUFV1_Msk = 0x20 // Bit mask of CCBUFV1 field.
	TC_COUNT32_STATUS_CCBUFV1     = 0x20 // Bit CCBUFV1.

	// WAVE: Waveform Generation Control
	TC_COUNT32_WAVE_WAVEGEN_Pos  = 0x0 // Position of WAVEGEN field.
	TC_COUNT32_WAVE_WAVEGEN_Msk  = 0x3 // Bit mask of WAVEGEN field.
	TC_COUNT32_WAVE_WAVEGEN_NFRQ = 0x0 // Normal frequency
	TC_COUNT32_WAVE_WAVEGEN_MFRQ = 0x1 // Match frequency
	TC_COUNT32_WAVE_WAVEGEN_NPWM = 0x2 // Normal PWM
	TC_COUNT32_WAVE_WAVEGEN_MPWM = 0x3 // Match PWM

	// DRVCTRL: Control C
	TC_COUNT32_DRVCTRL_INVEN0_Pos = 0x0 // Position of INVEN0 field.
	TC_COUNT32_DRVCTRL_INVEN0_Msk = 0x1 // Bit mask of INVEN0 field.
	TC_COUNT32_DRVCTRL_INVEN0     = 0x1 // Bit INVEN0.
	TC_COUNT32_DRVCTRL_INVEN1_Pos = 0x1 // Position of INVEN1 field.
	TC_COUNT32_DRVCTRL_INVEN1_Msk = 0x2 // Bit mask of INVEN1 field.
	TC_COUNT32_DRVCTRL_INVEN1     = 0x2 // Bit INVEN1.

	// DBGCTRL: Debug Control
	TC_COUNT32_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	TC_COUNT32_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	TC_COUNT32_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// SYNCBUSY: Synchronization Status
	TC_COUNT32_SYNCBUSY_SWRST_Pos  = 0x0  // Position of SWRST field.
	TC_COUNT32_SYNCBUSY_SWRST_Msk  = 0x1  // Bit mask of SWRST field.
	TC_COUNT32_SYNCBUSY_SWRST      = 0x1  // Bit SWRST.
	TC_COUNT32_SYNCBUSY_ENABLE_Pos = 0x1  // Position of ENABLE field.
	TC_COUNT32_SYNCBUSY_ENABLE_Msk = 0x2  // Bit mask of ENABLE field.
	TC_COUNT32_SYNCBUSY_ENABLE     = 0x2  // Bit ENABLE.
	TC_COUNT32_SYNCBUSY_CTRLB_Pos  = 0x2  // Position of CTRLB field.
	TC_COUNT32_SYNCBUSY_CTRLB_Msk  = 0x4  // Bit mask of CTRLB field.
	TC_COUNT32_SYNCBUSY_CTRLB      = 0x4  // Bit CTRLB.
	TC_COUNT32_SYNCBUSY_STATUS_Pos = 0x3  // Position of STATUS field.
	TC_COUNT32_SYNCBUSY_STATUS_Msk = 0x8  // Bit mask of STATUS field.
	TC_COUNT32_SYNCBUSY_STATUS     = 0x8  // Bit STATUS.
	TC_COUNT32_SYNCBUSY_COUNT_Pos  = 0x4  // Position of COUNT field.
	TC_COUNT32_SYNCBUSY_COUNT_Msk  = 0x10 // Bit mask of COUNT field.
	TC_COUNT32_SYNCBUSY_COUNT      = 0x10 // Bit COUNT.
	TC_COUNT32_SYNCBUSY_PER_Pos    = 0x5  // Position of PER field.
	TC_COUNT32_SYNCBUSY_PER_Msk    = 0x20 // Bit mask of PER field.
	TC_COUNT32_SYNCBUSY_PER        = 0x20 // Bit PER.
	TC_COUNT32_SYNCBUSY_CC0_Pos    = 0x6  // Position of CC0 field.
	TC_COUNT32_SYNCBUSY_CC0_Msk    = 0x40 // Bit mask of CC0 field.
	TC_COUNT32_SYNCBUSY_CC0        = 0x40 // Bit CC0.
	TC_COUNT32_SYNCBUSY_CC1_Pos    = 0x7  // Position of CC1 field.
	TC_COUNT32_SYNCBUSY_CC1_Msk    = 0x80 // Bit mask of CC1 field.
	TC_COUNT32_SYNCBUSY_CC1        = 0x80 // Bit CC1.

	// COUNT: COUNT32 Count
	TC_COUNT32_COUNT_COUNT_Pos = 0x0        // Position of COUNT field.
	TC_COUNT32_COUNT_COUNT_Msk = 0xffffffff // Bit mask of COUNT field.

	// PER: COUNT32 Period
	TC_COUNT32_PER_PER_Pos = 0x0        // Position of PER field.
	TC_COUNT32_PER_PER_Msk = 0xffffffff // Bit mask of PER field.

	// CC: COUNT32 Compare and Capture
	TC_COUNT32_CC_CC_Pos = 0x0        // Position of CC field.
	TC_COUNT32_CC_CC_Msk = 0xffffffff // Bit mask of CC field.

	// PERBUF: COUNT32 Period Buffer
	TC_COUNT32_PERBUF_PERBUF_Pos = 0x0        // Position of PERBUF field.
	TC_COUNT32_PERBUF_PERBUF_Msk = 0xffffffff // Bit mask of PERBUF field.

	// CCBUF: COUNT32 Compare and Capture Buffer
	TC_COUNT32_CCBUF_CCBUF_Pos = 0x0        // Position of CCBUF field.
	TC_COUNT32_CCBUF_CCBUF_Msk = 0xffffffff // Bit mask of CCBUF field.
)

// Bitfields for TRAM: TrustRAM
const (
	// CTRLA: Control
	TRAM_CTRLA_SWRST_Pos   = 0x0  // Position of SWRST field.
	TRAM_CTRLA_SWRST_Msk   = 0x1  // Bit mask of SWRST field.
	TRAM_CTRLA_SWRST       = 0x1  // Bit SWRST.
	TRAM_CTRLA_ENABLE_Pos  = 0x1  // Position of ENABLE field.
	TRAM_CTRLA_ENABLE_Msk  = 0x2  // Bit mask of ENABLE field.
	TRAM_CTRLA_ENABLE      = 0x2  // Bit ENABLE.
	TRAM_CTRLA_TAMPERS_Pos = 0x4  // Position of TAMPERS field.
	TRAM_CTRLA_TAMPERS_Msk = 0x10 // Bit mask of TAMPERS field.
	TRAM_CTRLA_TAMPERS     = 0x10 // Bit TAMPERS.
	TRAM_CTRLA_DRP_Pos     = 0x6  // Position of DRP field.
	TRAM_CTRLA_DRP_Msk     = 0x40 // Bit mask of DRP field.
	TRAM_CTRLA_DRP         = 0x40 // Bit DRP.
	TRAM_CTRLA_SILACC_Pos  = 0x7  // Position of SILACC field.
	TRAM_CTRLA_SILACC_Msk  = 0x80 // Bit mask of SILACC field.
	TRAM_CTRLA_SILACC      = 0x80 // Bit SILACC.

	// INTENCLR: Interrupt Enable Clear
	TRAM_INTENCLR_ERR_Pos = 0x0 // Position of ERR field.
	TRAM_INTENCLR_ERR_Msk = 0x1 // Bit mask of ERR field.
	TRAM_INTENCLR_ERR     = 0x1 // Bit ERR.
	TRAM_INTENCLR_DRP_Pos = 0x1 // Position of DRP field.
	TRAM_INTENCLR_DRP_Msk = 0x2 // Bit mask of DRP field.
	TRAM_INTENCLR_DRP     = 0x2 // Bit DRP.

	// INTENSET: Interrupt Enable Set
	TRAM_INTENSET_ERR_Pos = 0x0 // Position of ERR field.
	TRAM_INTENSET_ERR_Msk = 0x1 // Bit mask of ERR field.
	TRAM_INTENSET_ERR     = 0x1 // Bit ERR.
	TRAM_INTENSET_DRP_Pos = 0x1 // Position of DRP field.
	TRAM_INTENSET_DRP_Msk = 0x2 // Bit mask of DRP field.
	TRAM_INTENSET_DRP     = 0x2 // Bit DRP.

	// INTFLAG: Interrupt Flag Status and Clear
	TRAM_INTFLAG_ERR_Pos = 0x0 // Position of ERR field.
	TRAM_INTFLAG_ERR_Msk = 0x1 // Bit mask of ERR field.
	TRAM_INTFLAG_ERR     = 0x1 // Bit ERR.
	TRAM_INTFLAG_DRP_Pos = 0x1 // Position of DRP field.
	TRAM_INTFLAG_DRP_Msk = 0x2 // Bit mask of DRP field.
	TRAM_INTFLAG_DRP     = 0x2 // Bit DRP.

	// STATUS: Status
	TRAM_STATUS_RAMINV_Pos = 0x0 // Position of RAMINV field.
	TRAM_STATUS_RAMINV_Msk = 0x1 // Bit mask of RAMINV field.
	TRAM_STATUS_RAMINV     = 0x1 // Bit RAMINV.
	TRAM_STATUS_DRP_Pos    = 0x1 // Position of DRP field.
	TRAM_STATUS_DRP_Msk    = 0x2 // Bit mask of DRP field.
	TRAM_STATUS_DRP        = 0x2 // Bit DRP.

	// SYNCBUSY: Synchronization Busy Status
	TRAM_SYNCBUSY_SWRST_Pos  = 0x0 // Position of SWRST field.
	TRAM_SYNCBUSY_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	TRAM_SYNCBUSY_SWRST      = 0x1 // Bit SWRST.
	TRAM_SYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	TRAM_SYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	TRAM_SYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.

	// DSCC: Data Scramble Control
	TRAM_DSCC_DSCKEY_Pos = 0x0        // Position of DSCKEY field.
	TRAM_DSCC_DSCKEY_Msk = 0x3fffffff // Bit mask of DSCKEY field.
	TRAM_DSCC_DSCEN_Pos  = 0x1f       // Position of DSCEN field.
	TRAM_DSCC_DSCEN_Msk  = 0x80000000 // Bit mask of DSCEN field.
	TRAM_DSCC_DSCEN      = 0x80000000 // Bit DSCEN.

	// PERMW: Permutation Write
	TRAM_PERMW_DATA_Pos = 0x0 // Position of DATA field.
	TRAM_PERMW_DATA_Msk = 0x7 // Bit mask of DATA field.

	// PERMR: Permutation Read
	TRAM_PERMR_DATA_Pos = 0x0 // Position of DATA field.
	TRAM_PERMR_DATA_Msk = 0x7 // Bit mask of DATA field.

	// RAM: TrustRAM
	TRAM_RAM_DATA_Pos = 0x0        // Position of DATA field.
	TRAM_RAM_DATA_Msk = 0xffffffff // Bit mask of DATA field.
)

// Bitfields for TRNG: True Random Generator
const (
	// CTRLA: Control A
	TRNG_CTRLA_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	TRNG_CTRLA_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	TRNG_CTRLA_ENABLE       = 0x2  // Bit ENABLE.
	TRNG_CTRLA_RUNSTDBY_Pos = 0x6  // Position of RUNSTDBY field.
	TRNG_CTRLA_RUNSTDBY_Msk = 0x40 // Bit mask of RUNSTDBY field.
	TRNG_CTRLA_RUNSTDBY     = 0x40 // Bit RUNSTDBY.

	// EVCTRL: Event Control
	TRNG_EVCTRL_DATARDYEO_Pos = 0x0 // Position of DATARDYEO field.
	TRNG_EVCTRL_DATARDYEO_Msk = 0x1 // Bit mask of DATARDYEO field.
	TRNG_EVCTRL_DATARDYEO     = 0x1 // Bit DATARDYEO.

	// INTENCLR: Interrupt Enable Clear
	TRNG_INTENCLR_DATARDY_Pos = 0x0 // Position of DATARDY field.
	TRNG_INTENCLR_DATARDY_Msk = 0x1 // Bit mask of DATARDY field.
	TRNG_INTENCLR_DATARDY     = 0x1 // Bit DATARDY.

	// INTENSET: Interrupt Enable Set
	TRNG_INTENSET_DATARDY_Pos = 0x0 // Position of DATARDY field.
	TRNG_INTENSET_DATARDY_Msk = 0x1 // Bit mask of DATARDY field.
	TRNG_INTENSET_DATARDY     = 0x1 // Bit DATARDY.

	// INTFLAG: Interrupt Flag Status and Clear
	TRNG_INTFLAG_DATARDY_Pos = 0x0 // Position of DATARDY field.
	TRNG_INTFLAG_DATARDY_Msk = 0x1 // Bit mask of DATARDY field.
	TRNG_INTFLAG_DATARDY     = 0x1 // Bit DATARDY.

	// DATA: Output Data
	TRNG_DATA_DATA_Pos = 0x0        // Position of DATA field.
	TRNG_DATA_DATA_Msk = 0xffffffff // Bit mask of DATA field.
)

// Bitfields for WDT: Watchdog Timer
const (
	// CTRLA: Control
	WDT_CTRLA_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	WDT_CTRLA_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	WDT_CTRLA_ENABLE       = 0x2  // Bit ENABLE.
	WDT_CTRLA_WEN_Pos      = 0x2  // Position of WEN field.
	WDT_CTRLA_WEN_Msk      = 0x4  // Bit mask of WEN field.
	WDT_CTRLA_WEN          = 0x4  // Bit WEN.
	WDT_CTRLA_RUNSTDBY_Pos = 0x6  // Position of RUNSTDBY field.
	WDT_CTRLA_RUNSTDBY_Msk = 0x40 // Bit mask of RUNSTDBY field.
	WDT_CTRLA_RUNSTDBY     = 0x40 // Bit RUNSTDBY.
	WDT_CTRLA_ALWAYSON_Pos = 0x7  // Position of ALWAYSON field.
	WDT_CTRLA_ALWAYSON_Msk = 0x80 // Bit mask of ALWAYSON field.
	WDT_CTRLA_ALWAYSON     = 0x80 // Bit ALWAYSON.

	// CONFIG: Configuration
	WDT_CONFIG_PER_Pos         = 0x0  // Position of PER field.
	WDT_CONFIG_PER_Msk         = 0xf  // Bit mask of PER field.
	WDT_CONFIG_PER_CYC8        = 0x0  // 8 clock cycles
	WDT_CONFIG_PER_CYC16       = 0x1  // 16 clock cycles
	WDT_CONFIG_PER_CYC32       = 0x2  // 32 clock cycles
	WDT_CONFIG_PER_CYC64       = 0x3  // 64 clock cycles
	WDT_CONFIG_PER_CYC128      = 0x4  // 128 clock cycles
	WDT_CONFIG_PER_CYC256      = 0x5  // 256 clock cycles
	WDT_CONFIG_PER_CYC512      = 0x6  // 512 clock cycles
	WDT_CONFIG_PER_CYC1024     = 0x7  // 1024 clock cycles
	WDT_CONFIG_PER_CYC2048     = 0x8  // 2048 clock cycles
	WDT_CONFIG_PER_CYC4096     = 0x9  // 4096 clock cycles
	WDT_CONFIG_PER_CYC8192     = 0xa  // 8192 clock cycles
	WDT_CONFIG_PER_CYC16384    = 0xb  // 16384 clock cycles
	WDT_CONFIG_WINDOW_Pos      = 0x4  // Position of WINDOW field.
	WDT_CONFIG_WINDOW_Msk      = 0xf0 // Bit mask of WINDOW field.
	WDT_CONFIG_WINDOW_CYC8     = 0x0  // 8 clock cycles
	WDT_CONFIG_WINDOW_CYC16    = 0x1  // 16 clock cycles
	WDT_CONFIG_WINDOW_CYC32    = 0x2  // 32 clock cycles
	WDT_CONFIG_WINDOW_CYC64    = 0x3  // 64 clock cycles
	WDT_CONFIG_WINDOW_CYC128   = 0x4  // 128 clock cycles
	WDT_CONFIG_WINDOW_CYC256   = 0x5  // 256 clock cycles
	WDT_CONFIG_WINDOW_CYC512   = 0x6  // 512 clock cycles
	WDT_CONFIG_WINDOW_CYC1024  = 0x7  // 1024 clock cycles
	WDT_CONFIG_WINDOW_CYC2048  = 0x8  // 2048 clock cycles
	WDT_CONFIG_WINDOW_CYC4096  = 0x9  // 4096 clock cycles
	WDT_CONFIG_WINDOW_CYC8192  = 0xa  // 8192 clock cycles
	WDT_CONFIG_WINDOW_CYC16384 = 0xb  // 16384 clock cycles

	// EWCTRL: Early Warning Interrupt Control
	WDT_EWCTRL_EWOFFSET_Pos      = 0x0 // Position of EWOFFSET field.
	WDT_EWCTRL_EWOFFSET_Msk      = 0xf // Bit mask of EWOFFSET field.
	WDT_EWCTRL_EWOFFSET_CYC8     = 0x0 // 8 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC16    = 0x1 // 16 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC32    = 0x2 // 32 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC64    = 0x3 // 64 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC128   = 0x4 // 128 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC256   = 0x5 // 256 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC512   = 0x6 // 512 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC1024  = 0x7 // 1024 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC2048  = 0x8 // 2048 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC4096  = 0x9 // 4096 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC8192  = 0xa // 8192 clock cycles
	WDT_EWCTRL_EWOFFSET_CYC16384 = 0xb // 16384 clock cycles

	// INTENCLR: Interrupt Enable Clear
	WDT_INTENCLR_EW_Pos = 0x0 // Position of EW field.
	WDT_INTENCLR_EW_Msk = 0x1 // Bit mask of EW field.
	WDT_INTENCLR_EW     = 0x1 // Bit EW.

	// INTENSET: Interrupt Enable Set
	WDT_INTENSET_EW_Pos = 0x0 // Position of EW field.
	WDT_INTENSET_EW_Msk = 0x1 // Bit mask of EW field.
	WDT_INTENSET_EW     = 0x1 // Bit EW.

	// INTFLAG: Interrupt Flag Status and Clear
	WDT_INTFLAG_EW_Pos = 0x0 // Position of EW field.
	WDT_INTFLAG_EW_Msk = 0x1 // Bit mask of EW field.
	WDT_INTFLAG_EW     = 0x1 // Bit EW.

	// SYNCBUSY: Synchronization Busy
	WDT_SYNCBUSY_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	WDT_SYNCBUSY_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	WDT_SYNCBUSY_ENABLE       = 0x2  // Bit ENABLE.
	WDT_SYNCBUSY_WEN_Pos      = 0x2  // Position of WEN field.
	WDT_SYNCBUSY_WEN_Msk      = 0x4  // Bit mask of WEN field.
	WDT_SYNCBUSY_WEN          = 0x4  // Bit WEN.
	WDT_SYNCBUSY_RUNSTDBY_Pos = 0x3  // Position of RUNSTDBY field.
	WDT_SYNCBUSY_RUNSTDBY_Msk = 0x8  // Bit mask of RUNSTDBY field.
	WDT_SYNCBUSY_RUNSTDBY     = 0x8  // Bit RUNSTDBY.
	WDT_SYNCBUSY_ALWAYSON_Pos = 0x4  // Position of ALWAYSON field.
	WDT_SYNCBUSY_ALWAYSON_Msk = 0x10 // Bit mask of ALWAYSON field.
	WDT_SYNCBUSY_ALWAYSON     = 0x10 // Bit ALWAYSON.
	WDT_SYNCBUSY_CLEAR_Pos    = 0x5  // Position of CLEAR field.
	WDT_SYNCBUSY_CLEAR_Msk    = 0x20 // Bit mask of CLEAR field.
	WDT_SYNCBUSY_CLEAR        = 0x20 // Bit CLEAR.

	// CLEAR: Clear
	WDT_CLEAR_CLEAR_Pos = 0x0  // Position of CLEAR field.
	WDT_CLEAR_CLEAR_Msk = 0xff // Bit mask of CLEAR field.
	WDT_CLEAR_CLEAR_KEY = 0xa5 // Clear Key
)

// Bitfields for CoreDebug: Debug Control Block
const (
	// DHCSR: Debug Halting Control and Status Register
	CoreDebug_DHCSR_C_DEBUGEN_Pos    = 0x0       // Position of C_DEBUGEN field.
	CoreDebug_DHCSR_C_DEBUGEN_Msk    = 0x1       // Bit mask of C_DEBUGEN field.
	CoreDebug_DHCSR_C_DEBUGEN        = 0x1       // Bit C_DEBUGEN.
	CoreDebug_DHCSR_C_HALT_Pos       = 0x1       // Position of C_HALT field.
	CoreDebug_DHCSR_C_HALT_Msk       = 0x2       // Bit mask of C_HALT field.
	CoreDebug_DHCSR_C_HALT           = 0x2       // Bit C_HALT.
	CoreDebug_DHCSR_C_STEP_Pos       = 0x2       // Position of C_STEP field.
	CoreDebug_DHCSR_C_STEP_Msk       = 0x4       // Bit mask of C_STEP field.
	CoreDebug_DHCSR_C_STEP           = 0x4       // Bit C_STEP.
	CoreDebug_DHCSR_C_MASKINTS_Pos   = 0x3       // Position of C_MASKINTS field.
	CoreDebug_DHCSR_C_MASKINTS_Msk   = 0x8       // Bit mask of C_MASKINTS field.
	CoreDebug_DHCSR_C_MASKINTS       = 0x8       // Bit C_MASKINTS.
	CoreDebug_DHCSR_S_SNAPSTALL_Pos  = 0x5       // Position of S_SNAPSTALL field.
	CoreDebug_DHCSR_S_SNAPSTALL_Msk  = 0x20      // Bit mask of S_SNAPSTALL field.
	CoreDebug_DHCSR_S_SNAPSTALL      = 0x20      // Bit S_SNAPSTALL.
	CoreDebug_DHCSR_S_REGRDY_Pos     = 0x10      // Position of S_REGRDY field.
	CoreDebug_DHCSR_S_REGRDY_Msk     = 0x10000   // Bit mask of S_REGRDY field.
	CoreDebug_DHCSR_S_REGRDY         = 0x10000   // Bit S_REGRDY.
	CoreDebug_DHCSR_S_HALT_Pos       = 0x11      // Position of S_HALT field.
	CoreDebug_DHCSR_S_HALT_Msk       = 0x20000   // Bit mask of S_HALT field.
	CoreDebug_DHCSR_S_HALT           = 0x20000   // Bit S_HALT.
	CoreDebug_DHCSR_S_SLEEP_Pos      = 0x12      // Position of S_SLEEP field.
	CoreDebug_DHCSR_S_SLEEP_Msk      = 0x40000   // Bit mask of S_SLEEP field.
	CoreDebug_DHCSR_S_SLEEP          = 0x40000   // Bit S_SLEEP.
	CoreDebug_DHCSR_S_LOCKUP_Pos     = 0x13      // Position of S_LOCKUP field.
	CoreDebug_DHCSR_S_LOCKUP_Msk     = 0x80000   // Bit mask of S_LOCKUP field.
	CoreDebug_DHCSR_S_LOCKUP         = 0x80000   // Bit S_LOCKUP.
	CoreDebug_DHCSR_S_SDE_Pos        = 0x14      // Position of S_SDE field.
	CoreDebug_DHCSR_S_SDE_Msk        = 0x100000  // Bit mask of S_SDE field.
	CoreDebug_DHCSR_S_SDE            = 0x100000  // Bit S_SDE.
	CoreDebug_DHCSR_S_RETIRE_ST_Pos  = 0x18      // Position of S_RETIRE_ST field.
	CoreDebug_DHCSR_S_RETIRE_ST_Msk  = 0x1000000 // Bit mask of S_RETIRE_ST field.
	CoreDebug_DHCSR_S_RETIRE_ST      = 0x1000000 // Bit S_RETIRE_ST.
	CoreDebug_DHCSR_S_RESET_ST_Pos   = 0x19      // Position of S_RESET_ST field.
	CoreDebug_DHCSR_S_RESET_ST_Msk   = 0x2000000 // Bit mask of S_RESET_ST field.
	CoreDebug_DHCSR_S_RESET_ST       = 0x2000000 // Bit S_RESET_ST.
	CoreDebug_DHCSR_S_RESTART_ST_Pos = 0x1a      // Position of S_RESTART_ST field.
	CoreDebug_DHCSR_S_RESTART_ST_Msk = 0x4000000 // Bit mask of S_RESTART_ST field.
	CoreDebug_DHCSR_S_RESTART_ST     = 0x4000000 // Bit S_RESTART_ST.

	// DCRSR: Debug Core Register Select Register
	CoreDebug_DCRSR_REGSEL_Pos = 0x0     // Position of REGSEL field.
	CoreDebug_DCRSR_REGSEL_Msk = 0x7f    // Bit mask of REGSEL field.
	CoreDebug_DCRSR_REGWnR_Pos = 0x10    // Position of REGWnR field.
	CoreDebug_DCRSR_REGWnR_Msk = 0x10000 // Bit mask of REGWnR field.
	CoreDebug_DCRSR_REGWnR     = 0x10000 // Bit REGWnR.

	// DEMCR: Debug Exception and Monitor Control Register
	CoreDebug_DEMCR_VC_CORERESET_Pos = 0x0       // Position of VC_CORERESET field.
	CoreDebug_DEMCR_VC_CORERESET_Msk = 0x1       // Bit mask of VC_CORERESET field.
	CoreDebug_DEMCR_VC_CORERESET     = 0x1       // Bit VC_CORERESET.
	CoreDebug_DEMCR_VC_MMERR_Pos     = 0x4       // Position of VC_MMERR field.
	CoreDebug_DEMCR_VC_MMERR_Msk     = 0x10      // Bit mask of VC_MMERR field.
	CoreDebug_DEMCR_VC_MMERR         = 0x10      // Bit VC_MMERR.
	CoreDebug_DEMCR_VC_NOCPERR_Pos   = 0x5       // Position of VC_NOCPERR field.
	CoreDebug_DEMCR_VC_NOCPERR_Msk   = 0x20      // Bit mask of VC_NOCPERR field.
	CoreDebug_DEMCR_VC_NOCPERR       = 0x20      // Bit VC_NOCPERR.
	CoreDebug_DEMCR_VC_CHKERR_Pos    = 0x6       // Position of VC_CHKERR field.
	CoreDebug_DEMCR_VC_CHKERR_Msk    = 0x40      // Bit mask of VC_CHKERR field.
	CoreDebug_DEMCR_VC_CHKERR        = 0x40      // Bit VC_CHKERR.
	CoreDebug_DEMCR_VC_STATERR_Pos   = 0x7       // Position of VC_STATERR field.
	CoreDebug_DEMCR_VC_STATERR_Msk   = 0x80      // Bit mask of VC_STATERR field.
	CoreDebug_DEMCR_VC_STATERR       = 0x80      // Bit VC_STATERR.
	CoreDebug_DEMCR_VC_BUSERR_Pos    = 0x8       // Position of VC_BUSERR field.
	CoreDebug_DEMCR_VC_BUSERR_Msk    = 0x100     // Bit mask of VC_BUSERR field.
	CoreDebug_DEMCR_VC_BUSERR        = 0x100     // Bit VC_BUSERR.
	CoreDebug_DEMCR_VC_INTERR_Pos    = 0x9       // Position of VC_INTERR field.
	CoreDebug_DEMCR_VC_INTERR_Msk    = 0x200     // Bit mask of VC_INTERR field.
	CoreDebug_DEMCR_VC_INTERR        = 0x200     // Bit VC_INTERR.
	CoreDebug_DEMCR_VC_HARDERR_Pos   = 0xa       // Position of VC_HARDERR field.
	CoreDebug_DEMCR_VC_HARDERR_Msk   = 0x400     // Bit mask of VC_HARDERR field.
	CoreDebug_DEMCR_VC_HARDERR       = 0x400     // Bit VC_HARDERR.
	CoreDebug_DEMCR_VC_SFERR_Pos     = 0xb       // Position of VC_SFERR field.
	CoreDebug_DEMCR_VC_SFERR_Msk     = 0x800     // Bit mask of VC_SFERR field.
	CoreDebug_DEMCR_VC_SFERR         = 0x800     // Bit VC_SFERR.
	CoreDebug_DEMCR_MON_EN_Pos       = 0x10      // Position of MON_EN field.
	CoreDebug_DEMCR_MON_EN_Msk       = 0x10000   // Bit mask of MON_EN field.
	CoreDebug_DEMCR_MON_EN           = 0x10000   // Bit MON_EN.
	CoreDebug_DEMCR_MON_PEND_Pos     = 0x11      // Position of MON_PEND field.
	CoreDebug_DEMCR_MON_PEND_Msk     = 0x20000   // Bit mask of MON_PEND field.
	CoreDebug_DEMCR_MON_PEND         = 0x20000   // Bit MON_PEND.
	CoreDebug_DEMCR_MON_STEP_Pos     = 0x12      // Position of MON_STEP field.
	CoreDebug_DEMCR_MON_STEP_Msk     = 0x40000   // Bit mask of MON_STEP field.
	CoreDebug_DEMCR_MON_STEP         = 0x40000   // Bit MON_STEP.
	CoreDebug_DEMCR_MON_REQ_Pos      = 0x13      // Position of MON_REQ field.
	CoreDebug_DEMCR_MON_REQ_Msk      = 0x80000   // Bit mask of MON_REQ field.
	CoreDebug_DEMCR_MON_REQ          = 0x80000   // Bit MON_REQ.
	CoreDebug_DEMCR_SDME_Pos         = 0x14      // Position of SDME field.
	CoreDebug_DEMCR_SDME_Msk         = 0x100000  // Bit mask of SDME field.
	CoreDebug_DEMCR_SDME             = 0x100000  // Bit SDME.
	CoreDebug_DEMCR_TRCENA_Pos       = 0x18      // Position of TRCENA field.
	CoreDebug_DEMCR_TRCENA_Msk       = 0x1000000 // Bit mask of TRCENA field.
	CoreDebug_DEMCR_TRCENA           = 0x1000000 // Bit TRCENA.

	// DAUTHCTRL: Debug Authentication Control Register
	CoreDebug_DAUTHCTRL_SPIDENSEL_Pos  = 0x0 // Position of SPIDENSEL field.
	CoreDebug_DAUTHCTRL_SPIDENSEL_Msk  = 0x1 // Bit mask of SPIDENSEL field.
	CoreDebug_DAUTHCTRL_SPIDENSEL      = 0x1 // Bit SPIDENSEL.
	CoreDebug_DAUTHCTRL_INTSPIDEN_Pos  = 0x1 // Position of INTSPIDEN field.
	CoreDebug_DAUTHCTRL_INTSPIDEN_Msk  = 0x2 // Bit mask of INTSPIDEN field.
	CoreDebug_DAUTHCTRL_INTSPIDEN      = 0x2 // Bit INTSPIDEN.
	CoreDebug_DAUTHCTRL_SPNIDENSEL_Pos = 0x2 // Position of SPNIDENSEL field.
	CoreDebug_DAUTHCTRL_SPNIDENSEL_Msk = 0x4 // Bit mask of SPNIDENSEL field.
	CoreDebug_DAUTHCTRL_SPNIDENSEL     = 0x4 // Bit SPNIDENSEL.
	CoreDebug_DAUTHCTRL_INTSPNIDEN_Pos = 0x3 // Position of INTSPNIDEN field.
	CoreDebug_DAUTHCTRL_INTSPNIDEN_Msk = 0x8 // Bit mask of INTSPNIDEN field.
	CoreDebug_DAUTHCTRL_INTSPNIDEN     = 0x8 // Bit INTSPNIDEN.

	// DSCSR: Debug Security Control and Status Register
	CoreDebug_DSCSR_SBRSELEN_Pos = 0x0     // Position of SBRSELEN field.
	CoreDebug_DSCSR_SBRSELEN_Msk = 0x1     // Bit mask of SBRSELEN field.
	CoreDebug_DSCSR_SBRSELEN     = 0x1     // Bit SBRSELEN.
	CoreDebug_DSCSR_SBRSEL_Pos   = 0x1     // Position of SBRSEL field.
	CoreDebug_DSCSR_SBRSEL_Msk   = 0x2     // Bit mask of SBRSEL field.
	CoreDebug_DSCSR_SBRSEL       = 0x2     // Bit SBRSEL.
	CoreDebug_DSCSR_CDS_Pos      = 0x10    // Position of CDS field.
	CoreDebug_DSCSR_CDS_Msk      = 0x10000 // Bit mask of CDS field.
	CoreDebug_DSCSR_CDS          = 0x10000 // Bit CDS.
	CoreDebug_DSCSR_CDSKEY_Pos   = 0x11    // Position of CDSKEY field.
	CoreDebug_DSCSR_CDSKEY_Msk   = 0x20000 // Bit mask of CDSKEY field.
	CoreDebug_DSCSR_CDSKEY       = 0x20000 // Bit CDSKEY.
)

// Bitfields for DIB: Debug Identification Block
const (
	// DLAR: SCS Software Lock Access Register
	DIB_DLAR_KEY_Pos    = 0x0        // Position of KEY field.
	DIB_DLAR_KEY_Msk    = 0xffffffff // Bit mask of KEY field.
	DIB_DLAR_KEY_UNLOCK = 0xc5acce55 // Unlock key value

	// DLSR: SCS Software Lock Status Register
	DIB_DLSR_SLI_Pos = 0x0 // Position of SLI field.
	DIB_DLSR_SLI_Msk = 0x1 // Bit mask of SLI field.
	DIB_DLSR_SLI     = 0x1 // Bit SLI.
	DIB_DLSR_SLK_Pos = 0x1 // Position of SLK field.
	DIB_DLSR_SLK_Msk = 0x2 // Bit mask of SLK field.
	DIB_DLSR_SLK     = 0x2 // Bit SLK.
	DIB_DLSR_NTT_Pos = 0x2 // Position of NTT field.
	DIB_DLSR_NTT_Msk = 0x4 // Bit mask of NTT field.
	DIB_DLSR_NTT     = 0x4 // Bit NTT.

	// DAUTHSTATUS: Debug Authentication Status Register
	DIB_DAUTHSTATUS_NSID_Pos   = 0x0  // Position of NSID field.
	DIB_DAUTHSTATUS_NSID_Msk   = 0x1  // Bit mask of NSID field.
	DIB_DAUTHSTATUS_NSID       = 0x1  // Bit NSID.
	DIB_DAUTHSTATUS_NSID_NO    = 0x2  // Non-secure invasive debug prohibited
	DIB_DAUTHSTATUS_NSID_YES   = 0x3  // Non-secure invasive debug allowed
	DIB_DAUTHSTATUS_NSNID_Pos  = 0x2  // Position of NSNID field.
	DIB_DAUTHSTATUS_NSNID_Msk  = 0x4  // Bit mask of NSNID field.
	DIB_DAUTHSTATUS_NSNID      = 0x4  // Bit NSNID.
	DIB_DAUTHSTATUS_NSNID_NO   = 0x2  // Non-secure non-invasive debug prohibited
	DIB_DAUTHSTATUS_NSNID_YES  = 0x3  // Non-secure non-invasive debug allowed
	DIB_DAUTHSTATUS_SID_Pos    = 0x4  // Position of SID field.
	DIB_DAUTHSTATUS_SID_Msk    = 0x30 // Bit mask of SID field.
	DIB_DAUTHSTATUS_SID_NOSEC  = 0x0  // Security Extension not implemented
	DIB_DAUTHSTATUS_SID_NO     = 0x2  // Secure invasive debug prohibited
	DIB_DAUTHSTATUS_SID_YES    = 0x3  // Secure invasive debug allowed
	DIB_DAUTHSTATUS_SNID_Pos   = 0x6  // Position of SNID field.
	DIB_DAUTHSTATUS_SNID_Msk   = 0xc0 // Bit mask of SNID field.
	DIB_DAUTHSTATUS_SNID_NOSEC = 0x0  // Security Extension not implemented
	DIB_DAUTHSTATUS_SNID_NO    = 0x2  // Secure non-invasive debug prohibited
	DIB_DAUTHSTATUS_SNID_YES   = 0x3  // Secure non-invasive debug allowed

	// DDEVARCH: SCS Device Architecture Register
	DIB_DDEVARCH_ARCHPART_Pos  = 0x0        // Position of ARCHPART field.
	DIB_DDEVARCH_ARCHPART_Msk  = 0xfff      // Bit mask of ARCHPART field.
	DIB_DDEVARCH_ARCHVER_Pos   = 0xc        // Position of ARCHVER field.
	DIB_DDEVARCH_ARCHVER_Msk   = 0xf000     // Bit mask of ARCHVER field.
	DIB_DDEVARCH_REVISION_Pos  = 0x10       // Position of REVISION field.
	DIB_DDEVARCH_REVISION_Msk  = 0xf0000    // Bit mask of REVISION field.
	DIB_DDEVARCH_PRESENT_Pos   = 0x14       // Position of PRESENT field.
	DIB_DDEVARCH_PRESENT_Msk   = 0x100000   // Bit mask of PRESENT field.
	DIB_DDEVARCH_PRESENT       = 0x100000   // Bit PRESENT.
	DIB_DDEVARCH_ARCHITECT_Pos = 0x15       // Position of ARCHITECT field.
	DIB_DDEVARCH_ARCHITECT_Msk = 0xffe00000 // Bit mask of ARCHITECT field.

	// DDEVTYPE: SCS Device Type Register
	DIB_DDEVTYPE_MAJOR_Pos = 0x0  // Position of MAJOR field.
	DIB_DDEVTYPE_MAJOR_Msk = 0xf  // Bit mask of MAJOR field.
	DIB_DDEVTYPE_SUB_Pos   = 0x4  // Position of SUB field.
	DIB_DDEVTYPE_SUB_Msk   = 0xf0 // Bit mask of SUB field.

	// DPIDR4: SCS Peripheral Identification Register 4
	DIB_DPIDR4_DES_2_Pos = 0x0  // Position of DES_2 field.
	DIB_DPIDR4_DES_2_Msk = 0xf  // Bit mask of DES_2 field.
	DIB_DPIDR4_SIZE_Pos  = 0x4  // Position of SIZE field.
	DIB_DPIDR4_SIZE_Msk  = 0xf0 // Bit mask of SIZE field.

	// DPIDR0: SCS Peripheral Identification Register 0
	DIB_DPIDR0_PART_0_Pos = 0x0  // Position of PART_0 field.
	DIB_DPIDR0_PART_0_Msk = 0xff // Bit mask of PART_0 field.

	// DPIDR1: SCS Peripheral Identification Register 1
	DIB_DPIDR1_PART_1_Pos = 0x0  // Position of PART_1 field.
	DIB_DPIDR1_PART_1_Msk = 0xf  // Bit mask of PART_1 field.
	DIB_DPIDR1_DES_0_Pos  = 0x4  // Position of DES_0 field.
	DIB_DPIDR1_DES_0_Msk  = 0xf0 // Bit mask of DES_0 field.

	// DPIDR2: SCS Peripheral Identification Register 2
	DIB_DPIDR2_DES_1_Pos    = 0x0  // Position of DES_1 field.
	DIB_DPIDR2_DES_1_Msk    = 0x7  // Bit mask of DES_1 field.
	DIB_DPIDR2_JEDEC_Pos    = 0x3  // Position of JEDEC field.
	DIB_DPIDR2_JEDEC_Msk    = 0x8  // Bit mask of JEDEC field.
	DIB_DPIDR2_JEDEC        = 0x8  // Bit JEDEC.
	DIB_DPIDR2_REVISION_Pos = 0x4  // Position of REVISION field.
	DIB_DPIDR2_REVISION_Msk = 0xf0 // Bit mask of REVISION field.

	// DPIDR3: SCS Peripheral Identification Register 3
	DIB_DPIDR3_CMOD_Pos   = 0x0  // Position of CMOD field.
	DIB_DPIDR3_CMOD_Msk   = 0xf  // Bit mask of CMOD field.
	DIB_DPIDR3_REVAND_Pos = 0x4  // Position of REVAND field.
	DIB_DPIDR3_REVAND_Msk = 0xf0 // Bit mask of REVAND field.

	// DCIDR0: SCS Component Identification Register 0
	DIB_DCIDR0_PRMBL_0_Pos = 0x0  // Position of PRMBL_0 field.
	DIB_DCIDR0_PRMBL_0_Msk = 0xff // Bit mask of PRMBL_0 field.

	// DCIDR1: SCS Component Identification Register 1
	DIB_DCIDR1_PRMBL_1_Pos = 0x0  // Position of PRMBL_1 field.
	DIB_DCIDR1_PRMBL_1_Msk = 0xf  // Bit mask of PRMBL_1 field.
	DIB_DCIDR1_CLASS_Pos   = 0x4  // Position of CLASS field.
	DIB_DCIDR1_CLASS_Msk   = 0xf0 // Bit mask of CLASS field.

	// DCIDR2: SCS Component Identification Register 2
	DIB_DCIDR2_PRMBL_2_Pos = 0x0  // Position of PRMBL_2 field.
	DIB_DCIDR2_PRMBL_2_Msk = 0xff // Bit mask of PRMBL_2 field.

	// DCIDR3: SCS Component Identification Register 3
	DIB_DCIDR3_PRMBL_3_Pos = 0x0  // Position of PRMBL_3 field.
	DIB_DCIDR3_PRMBL_3_Msk = 0xff // Bit mask of PRMBL_3 field.
)

// Bitfields for DWT: Data Watchpoint and Trace
const (
	// DWT_CTRL: DWT Control Register
	DWT_DWT_CTRL_CYCCNTENA_Pos   = 0x0        // Position of CYCCNTENA field.
	DWT_DWT_CTRL_CYCCNTENA_Msk   = 0x1        // Bit mask of CYCCNTENA field.
	DWT_DWT_CTRL_CYCCNTENA       = 0x1        // Bit CYCCNTENA.
	DWT_DWT_CTRL_POSTPRESET_Pos  = 0x1        // Position of POSTPRESET field.
	DWT_DWT_CTRL_POSTPRESET_Msk  = 0x1e       // Bit mask of POSTPRESET field.
	DWT_DWT_CTRL_POSTINIT_Pos    = 0x5        // Position of POSTINIT field.
	DWT_DWT_CTRL_POSTINIT_Msk    = 0x1e0      // Bit mask of POSTINIT field.
	DWT_DWT_CTRL_CYCTAP_Pos      = 0x9        // Position of CYCTAP field.
	DWT_DWT_CTRL_CYCTAP_Msk      = 0x200      // Bit mask of CYCTAP field.
	DWT_DWT_CTRL_CYCTAP          = 0x200      // Bit CYCTAP.
	DWT_DWT_CTRL_SYNCTAP_Pos     = 0xa        // Position of SYNCTAP field.
	DWT_DWT_CTRL_SYNCTAP_Msk     = 0xc00      // Bit mask of SYNCTAP field.
	DWT_DWT_CTRL_PCSAMPLENA_Pos  = 0xc        // Position of PCSAMPLENA field.
	DWT_DWT_CTRL_PCSAMPLENA_Msk  = 0x1000     // Bit mask of PCSAMPLENA field.
	DWT_DWT_CTRL_PCSAMPLENA      = 0x1000     // Bit PCSAMPLENA.
	DWT_DWT_CTRL_EXCTRCENA_Pos   = 0x10       // Position of EXCTRCENA field.
	DWT_DWT_CTRL_EXCTRCENA_Msk   = 0x10000    // Bit mask of EXCTRCENA field.
	DWT_DWT_CTRL_EXCTRCENA       = 0x10000    // Bit EXCTRCENA.
	DWT_DWT_CTRL_CPIEVTENA_Pos   = 0x11       // Position of CPIEVTENA field.
	DWT_DWT_CTRL_CPIEVTENA_Msk   = 0x20000    // Bit mask of CPIEVTENA field.
	DWT_DWT_CTRL_CPIEVTENA       = 0x20000    // Bit CPIEVTENA.
	DWT_DWT_CTRL_EXCEVTENA_Pos   = 0x12       // Position of EXCEVTENA field.
	DWT_DWT_CTRL_EXCEVTENA_Msk   = 0x40000    // Bit mask of EXCEVTENA field.
	DWT_DWT_CTRL_EXCEVTENA       = 0x40000    // Bit EXCEVTENA.
	DWT_DWT_CTRL_SLEEPEVTENA_Pos = 0x13       // Position of SLEEPEVTENA field.
	DWT_DWT_CTRL_SLEEPEVTENA_Msk = 0x80000    // Bit mask of SLEEPEVTENA field.
	DWT_DWT_CTRL_SLEEPEVTENA     = 0x80000    // Bit SLEEPEVTENA.
	DWT_DWT_CTRL_LSUEVTENA_Pos   = 0x14       // Position of LSUEVTENA field.
	DWT_DWT_CTRL_LSUEVTENA_Msk   = 0x100000   // Bit mask of LSUEVTENA field.
	DWT_DWT_CTRL_LSUEVTENA       = 0x100000   // Bit LSUEVTENA.
	DWT_DWT_CTRL_FOLDEVTENA_Pos  = 0x15       // Position of FOLDEVTENA field.
	DWT_DWT_CTRL_FOLDEVTENA_Msk  = 0x200000   // Bit mask of FOLDEVTENA field.
	DWT_DWT_CTRL_FOLDEVTENA      = 0x200000   // Bit FOLDEVTENA.
	DWT_DWT_CTRL_CYCEVTENA_Pos   = 0x16       // Position of CYCEVTENA field.
	DWT_DWT_CTRL_CYCEVTENA_Msk   = 0x400000   // Bit mask of CYCEVTENA field.
	DWT_DWT_CTRL_CYCEVTENA       = 0x400000   // Bit CYCEVTENA.
	DWT_DWT_CTRL_CYCDISS_Pos     = 0x17       // Position of CYCDISS field.
	DWT_DWT_CTRL_CYCDISS_Msk     = 0x800000   // Bit mask of CYCDISS field.
	DWT_DWT_CTRL_CYCDISS         = 0x800000   // Bit CYCDISS.
	DWT_DWT_CTRL_NOPRFCNT_Pos    = 0x18       // Position of NOPRFCNT field.
	DWT_DWT_CTRL_NOPRFCNT_Msk    = 0x1000000  // Bit mask of NOPRFCNT field.
	DWT_DWT_CTRL_NOPRFCNT        = 0x1000000  // Bit NOPRFCNT.
	DWT_DWT_CTRL_NOCYCCNT_Pos    = 0x19       // Position of NOCYCCNT field.
	DWT_DWT_CTRL_NOCYCCNT_Msk    = 0x2000000  // Bit mask of NOCYCCNT field.
	DWT_DWT_CTRL_NOCYCCNT        = 0x2000000  // Bit NOCYCCNT.
	DWT_DWT_CTRL_NOEXTTRIG_Pos   = 0x1a       // Position of NOEXTTRIG field.
	DWT_DWT_CTRL_NOEXTTRIG_Msk   = 0x4000000  // Bit mask of NOEXTTRIG field.
	DWT_DWT_CTRL_NOEXTTRIG       = 0x4000000  // Bit NOEXTTRIG.
	DWT_DWT_CTRL_NOTRCPKT_Pos    = 0x1b       // Position of NOTRCPKT field.
	DWT_DWT_CTRL_NOTRCPKT_Msk    = 0x8000000  // Bit mask of NOTRCPKT field.
	DWT_DWT_CTRL_NOTRCPKT        = 0x8000000  // Bit NOTRCPKT.
	DWT_DWT_CTRL_NUMCOMP_Pos     = 0x1c       // Position of NUMCOMP field.
	DWT_DWT_CTRL_NUMCOMP_Msk     = 0xf0000000 // Bit mask of NUMCOMP field.

	// DWT_PCSR: DWT Program Counter Sample Register
	DWT_DWT_PCSR_EIASAMPLE_Pos = 0x0        // Position of EIASAMPLE field.
	DWT_DWT_PCSR_EIASAMPLE_Msk = 0xffffffff // Bit mask of EIASAMPLE field.

	// COMPARATOR.DWT_COMP: DWT Comparator Register n
	DWT_COMPARATOR_DWT_COMP_VALUE_Pos = 0x0        // Position of VALUE field.
	DWT_COMPARATOR_DWT_COMP_VALUE_Msk = 0xffffffff // Bit mask of VALUE field.

	// COMPARATOR.DWT_FUNCTION: DWT Function Register x
	DWT_COMPARATOR_DWT_FUNCTION_MATCH_Pos     = 0x0        // Position of MATCH field.
	DWT_COMPARATOR_DWT_FUNCTION_MATCH_Msk     = 0xf        // Bit mask of MATCH field.
	DWT_COMPARATOR_DWT_FUNCTION_ACTION_Pos    = 0x4        // Position of ACTION field.
	DWT_COMPARATOR_DWT_FUNCTION_ACTION_Msk    = 0x30       // Bit mask of ACTION field.
	DWT_COMPARATOR_DWT_FUNCTION_DATAVSIZE_Pos = 0xa        // Position of DATAVSIZE field.
	DWT_COMPARATOR_DWT_FUNCTION_DATAVSIZE_Msk = 0xc00      // Bit mask of DATAVSIZE field.
	DWT_COMPARATOR_DWT_FUNCTION_MATCHED_Pos   = 0x18       // Position of MATCHED field.
	DWT_COMPARATOR_DWT_FUNCTION_MATCHED_Msk   = 0x1000000  // Bit mask of MATCHED field.
	DWT_COMPARATOR_DWT_FUNCTION_MATCHED       = 0x1000000  // Bit MATCHED.
	DWT_COMPARATOR_DWT_FUNCTION_ID_Pos        = 0x1b       // Position of ID field.
	DWT_COMPARATOR_DWT_FUNCTION_ID_Msk        = 0xf8000000 // Bit mask of ID field.

	// DWT_LAR: DWT Software Lock Access Register
	DWT_DWT_LAR_KEY_Pos    = 0x0        // Position of KEY field.
	DWT_DWT_LAR_KEY_Msk    = 0xffffffff // Bit mask of KEY field.
	DWT_DWT_LAR_KEY_UNLOCK = 0xc5acce55 // Unlock key value

	// DWT_LSR: DWT Software Lock Status Register
	DWT_DWT_LSR_SLI_Pos = 0x0 // Position of SLI field.
	DWT_DWT_LSR_SLI_Msk = 0x1 // Bit mask of SLI field.
	DWT_DWT_LSR_SLI     = 0x1 // Bit SLI.
	DWT_DWT_LSR_SLK_Pos = 0x1 // Position of SLK field.
	DWT_DWT_LSR_SLK_Msk = 0x2 // Bit mask of SLK field.
	DWT_DWT_LSR_SLK     = 0x2 // Bit SLK.
	DWT_DWT_LSR_NTT_Pos = 0x2 // Position of NTT field.
	DWT_DWT_LSR_NTT_Msk = 0x4 // Bit mask of NTT field.
	DWT_DWT_LSR_NTT     = 0x4 // Bit NTT.

	// DWT_DEVARCH: DWT Device Architecture Register
	DWT_DWT_DEVARCH_ARCHPART_Pos  = 0x0        // Position of ARCHPART field.
	DWT_DWT_DEVARCH_ARCHPART_Msk  = 0xfff      // Bit mask of ARCHPART field.
	DWT_DWT_DEVARCH_ARCHVER_Pos   = 0xc        // Position of ARCHVER field.
	DWT_DWT_DEVARCH_ARCHVER_Msk   = 0xf000     // Bit mask of ARCHVER field.
	DWT_DWT_DEVARCH_REVISION_Pos  = 0x10       // Position of REVISION field.
	DWT_DWT_DEVARCH_REVISION_Msk  = 0xf0000    // Bit mask of REVISION field.
	DWT_DWT_DEVARCH_PRESENT_Pos   = 0x14       // Position of PRESENT field.
	DWT_DWT_DEVARCH_PRESENT_Msk   = 0x100000   // Bit mask of PRESENT field.
	DWT_DWT_DEVARCH_PRESENT       = 0x100000   // Bit PRESENT.
	DWT_DWT_DEVARCH_ARCHITECT_Pos = 0x15       // Position of ARCHITECT field.
	DWT_DWT_DEVARCH_ARCHITECT_Msk = 0xffe00000 // Bit mask of ARCHITECT field.

	// DWT_DEVTYPE: DWT Device Type Register
	DWT_DWT_DEVTYPE_MAJOR_Pos = 0x0  // Position of MAJOR field.
	DWT_DWT_DEVTYPE_MAJOR_Msk = 0xf  // Bit mask of MAJOR field.
	DWT_DWT_DEVTYPE_SUB_Pos   = 0x4  // Position of SUB field.
	DWT_DWT_DEVTYPE_SUB_Msk   = 0xf0 // Bit mask of SUB field.

	// DWT_PIDR4: DWT Peripheral Identification Register 4
	DWT_DWT_PIDR4_DES_2_Pos = 0x0  // Position of DES_2 field.
	DWT_DWT_PIDR4_DES_2_Msk = 0xf  // Bit mask of DES_2 field.
	DWT_DWT_PIDR4_SIZE_Pos  = 0x4  // Position of SIZE field.
	DWT_DWT_PIDR4_SIZE_Msk  = 0xf0 // Bit mask of SIZE field.

	// DWT_PIDR0: DWT Peripheral Identification Register 0
	DWT_DWT_PIDR0_PART_0_Pos = 0x0  // Position of PART_0 field.
	DWT_DWT_PIDR0_PART_0_Msk = 0xff // Bit mask of PART_0 field.

	// DWT_PIDR1: DWT Peripheral Identification Register 1
	DWT_DWT_PIDR1_PART_1_Pos = 0x0  // Position of PART_1 field.
	DWT_DWT_PIDR1_PART_1_Msk = 0xf  // Bit mask of PART_1 field.
	DWT_DWT_PIDR1_DES_0_Pos  = 0x4  // Position of DES_0 field.
	DWT_DWT_PIDR1_DES_0_Msk  = 0xf0 // Bit mask of DES_0 field.

	// DWT_PIDR2: DWT Peripheral Identification Register 2
	DWT_DWT_PIDR2_DES_1_Pos    = 0x0  // Position of DES_1 field.
	DWT_DWT_PIDR2_DES_1_Msk    = 0x7  // Bit mask of DES_1 field.
	DWT_DWT_PIDR2_JEDEC_Pos    = 0x3  // Position of JEDEC field.
	DWT_DWT_PIDR2_JEDEC_Msk    = 0x8  // Bit mask of JEDEC field.
	DWT_DWT_PIDR2_JEDEC        = 0x8  // Bit JEDEC.
	DWT_DWT_PIDR2_REVISION_Pos = 0x4  // Position of REVISION field.
	DWT_DWT_PIDR2_REVISION_Msk = 0xf0 // Bit mask of REVISION field.

	// DWT_PIDR3: DWT Peripheral Identification Register 3
	DWT_DWT_PIDR3_CMOD_Pos   = 0x0  // Position of CMOD field.
	DWT_DWT_PIDR3_CMOD_Msk   = 0xf  // Bit mask of CMOD field.
	DWT_DWT_PIDR3_REVAND_Pos = 0x4  // Position of REVAND field.
	DWT_DWT_PIDR3_REVAND_Msk = 0xf0 // Bit mask of REVAND field.

	// DWT_CIDR0: DWT Component Identification Register 0
	DWT_DWT_CIDR0_PRMBL_0_Pos = 0x0  // Position of PRMBL_0 field.
	DWT_DWT_CIDR0_PRMBL_0_Msk = 0xff // Bit mask of PRMBL_0 field.

	// DWT_CIDR1: DWT Component Identification Register 1
	DWT_DWT_CIDR1_PRMBL_1_Pos = 0x0  // Position of PRMBL_1 field.
	DWT_DWT_CIDR1_PRMBL_1_Msk = 0xf  // Bit mask of PRMBL_1 field.
	DWT_DWT_CIDR1_CLASS_Pos   = 0x4  // Position of CLASS field.
	DWT_DWT_CIDR1_CLASS_Msk   = 0xf0 // Bit mask of CLASS field.

	// DWT_CIDR2: DWT Component Identification Register 2
	DWT_DWT_CIDR2_PRMBL_2_Pos = 0x0  // Position of PRMBL_2 field.
	DWT_DWT_CIDR2_PRMBL_2_Msk = 0xff // Bit mask of PRMBL_2 field.

	// DWT_CIDR3: DWT Component Identification Register 3
	DWT_DWT_CIDR3_PRMBL_3_Pos = 0x0  // Position of PRMBL_3 field.
	DWT_DWT_CIDR3_PRMBL_3_Msk = 0xff // Bit mask of PRMBL_3 field.
)

// Bitfields for FPB: Flash Patch and Breakpoint
const (
	// FP_CTRL: Flash Patch Control Register
	FPB_FP_CTRL_ENABLE_Pos     = 0x0        // Position of ENABLE field.
	FPB_FP_CTRL_ENABLE_Msk     = 0x1        // Bit mask of ENABLE field.
	FPB_FP_CTRL_ENABLE         = 0x1        // Bit ENABLE.
	FPB_FP_CTRL_KEY_Pos        = 0x1        // Position of KEY field.
	FPB_FP_CTRL_KEY_Msk        = 0x2        // Bit mask of KEY field.
	FPB_FP_CTRL_KEY            = 0x2        // Bit KEY.
	FPB_FP_CTRL_NUM_CODE_Pos   = 0x4        // Position of NUM_CODE field.
	FPB_FP_CTRL_NUM_CODE_Msk   = 0xf0       // Bit mask of NUM_CODE field.
	FPB_FP_CTRL_NUM_LIT_Pos    = 0x8        // Position of NUM_LIT field.
	FPB_FP_CTRL_NUM_LIT_Msk    = 0xf00      // Bit mask of NUM_LIT field.
	FPB_FP_CTRL_NUM_CODE_1_Pos = 0xc        // Position of NUM_CODE_1 field.
	FPB_FP_CTRL_NUM_CODE_1_Msk = 0x7000     // Bit mask of NUM_CODE_1 field.
	FPB_FP_CTRL_REV_Pos        = 0x1c       // Position of REV field.
	FPB_FP_CTRL_REV_Msk        = 0xf0000000 // Bit mask of REV field.

	// FP_REMAP: Flash Patch Remap Register
	FPB_FP_REMAP_REMAP_Pos  = 0x5        // Position of REMAP field.
	FPB_FP_REMAP_REMAP_Msk  = 0x1fffffe0 // Bit mask of REMAP field.
	FPB_FP_REMAP_RMPSPT_Pos = 0x1d       // Position of RMPSPT field.
	FPB_FP_REMAP_RMPSPT_Msk = 0x20000000 // Bit mask of RMPSPT field.
	FPB_FP_REMAP_RMPSPT     = 0x20000000 // Bit RMPSPT.

	// FP_COMP: Flash Patch Comparator Register n
	FPB_FP_COMP_BE_Pos     = 0x0        // Position of BE field.
	FPB_FP_COMP_BE_Msk     = 0x1        // Bit mask of BE field.
	FPB_FP_COMP_BE         = 0x1        // Bit BE.
	FPB_FP_COMP_FPADDR_Pos = 0x2        // Position of FPADDR field.
	FPB_FP_COMP_FPADDR_Msk = 0x1ffffffc // Bit mask of FPADDR field.
	FPB_FP_COMP_FE_Pos     = 0x1f       // Position of FE field.
	FPB_FP_COMP_FE_Msk     = 0x80000000 // Bit mask of FE field.
	FPB_FP_COMP_FE         = 0x80000000 // Bit FE.

	// FP_COMP_BREAKPOINT_MODE: Flash Patch Comparator Register n
	FPB_FP_COMP_BREAKPOINT_MODE_BE_Pos     = 0x0        // Position of BE field.
	FPB_FP_COMP_BREAKPOINT_MODE_BE_Msk     = 0x1        // Bit mask of BE field.
	FPB_FP_COMP_BREAKPOINT_MODE_BE         = 0x1        // Bit BE.
	FPB_FP_COMP_BREAKPOINT_MODE_BPADDR_Pos = 0x1        // Position of BPADDR field.
	FPB_FP_COMP_BREAKPOINT_MODE_BPADDR_Msk = 0xfffffffe // Bit mask of BPADDR field.

	// FP_LAR: FPB Software Lock Access Register
	FPB_FP_LAR_KEY_Pos    = 0x0        // Position of KEY field.
	FPB_FP_LAR_KEY_Msk    = 0xffffffff // Bit mask of KEY field.
	FPB_FP_LAR_KEY_UNLOCK = 0xc5acce55 // Unlock key value

	// FP_LSR: FPB Software Lock Status Register
	FPB_FP_LSR_SLI_Pos = 0x0 // Position of SLI field.
	FPB_FP_LSR_SLI_Msk = 0x1 // Bit mask of SLI field.
	FPB_FP_LSR_SLI     = 0x1 // Bit SLI.
	FPB_FP_LSR_SLK_Pos = 0x1 // Position of SLK field.
	FPB_FP_LSR_SLK_Msk = 0x2 // Bit mask of SLK field.
	FPB_FP_LSR_SLK     = 0x2 // Bit SLK.
	FPB_FP_LSR_NTT_Pos = 0x2 // Position of NTT field.
	FPB_FP_LSR_NTT_Msk = 0x4 // Bit mask of NTT field.
	FPB_FP_LSR_NTT     = 0x4 // Bit NTT.

	// FP_DEVARCH: FPB Device Architecture Register
	FPB_FP_DEVARCH_ARCHPART_Pos  = 0x0        // Position of ARCHPART field.
	FPB_FP_DEVARCH_ARCHPART_Msk  = 0xfff      // Bit mask of ARCHPART field.
	FPB_FP_DEVARCH_ARCHVER_Pos   = 0xc        // Position of ARCHVER field.
	FPB_FP_DEVARCH_ARCHVER_Msk   = 0xf000     // Bit mask of ARCHVER field.
	FPB_FP_DEVARCH_REVISION_Pos  = 0x10       // Position of REVISION field.
	FPB_FP_DEVARCH_REVISION_Msk  = 0xf0000    // Bit mask of REVISION field.
	FPB_FP_DEVARCH_PRESENT_Pos   = 0x14       // Position of PRESENT field.
	FPB_FP_DEVARCH_PRESENT_Msk   = 0x100000   // Bit mask of PRESENT field.
	FPB_FP_DEVARCH_PRESENT       = 0x100000   // Bit PRESENT.
	FPB_FP_DEVARCH_ARCHITECT_Pos = 0x15       // Position of ARCHITECT field.
	FPB_FP_DEVARCH_ARCHITECT_Msk = 0xffe00000 // Bit mask of ARCHITECT field.

	// FP_DEVTYPE: FPB Device Type Register
	FPB_FP_DEVTYPE_MAJOR_Pos = 0x0  // Position of MAJOR field.
	FPB_FP_DEVTYPE_MAJOR_Msk = 0xf  // Bit mask of MAJOR field.
	FPB_FP_DEVTYPE_SUB_Pos   = 0x4  // Position of SUB field.
	FPB_FP_DEVTYPE_SUB_Msk   = 0xf0 // Bit mask of SUB field.

	// FP_PIDR4: FP Peripheral Identification Register 4
	FPB_FP_PIDR4_DES_2_Pos = 0x0  // Position of DES_2 field.
	FPB_FP_PIDR4_DES_2_Msk = 0xf  // Bit mask of DES_2 field.
	FPB_FP_PIDR4_SIZE_Pos  = 0x4  // Position of SIZE field.
	FPB_FP_PIDR4_SIZE_Msk  = 0xf0 // Bit mask of SIZE field.

	// FP_PIDR0: FP Peripheral Identification Register 0
	FPB_FP_PIDR0_PART_0_Pos = 0x0  // Position of PART_0 field.
	FPB_FP_PIDR0_PART_0_Msk = 0xff // Bit mask of PART_0 field.

	// FP_PIDR1: FP Peripheral Identification Register 1
	FPB_FP_PIDR1_PART_1_Pos = 0x0  // Position of PART_1 field.
	FPB_FP_PIDR1_PART_1_Msk = 0xf  // Bit mask of PART_1 field.
	FPB_FP_PIDR1_DES_0_Pos  = 0x4  // Position of DES_0 field.
	FPB_FP_PIDR1_DES_0_Msk  = 0xf0 // Bit mask of DES_0 field.

	// FP_PIDR2: FP Peripheral Identification Register 2
	FPB_FP_PIDR2_DES_1_Pos    = 0x0  // Position of DES_1 field.
	FPB_FP_PIDR2_DES_1_Msk    = 0x7  // Bit mask of DES_1 field.
	FPB_FP_PIDR2_JEDEC_Pos    = 0x3  // Position of JEDEC field.
	FPB_FP_PIDR2_JEDEC_Msk    = 0x8  // Bit mask of JEDEC field.
	FPB_FP_PIDR2_JEDEC        = 0x8  // Bit JEDEC.
	FPB_FP_PIDR2_REVISION_Pos = 0x4  // Position of REVISION field.
	FPB_FP_PIDR2_REVISION_Msk = 0xf0 // Bit mask of REVISION field.

	// FP_PIDR3: FP Peripheral Identification Register 3
	FPB_FP_PIDR3_CMOD_Pos   = 0x0  // Position of CMOD field.
	FPB_FP_PIDR3_CMOD_Msk   = 0xf  // Bit mask of CMOD field.
	FPB_FP_PIDR3_REVAND_Pos = 0x4  // Position of REVAND field.
	FPB_FP_PIDR3_REVAND_Msk = 0xf0 // Bit mask of REVAND field.

	// FP_CIDR0: FP Component Identification Register 0
	FPB_FP_CIDR0_PRMBL_0_Pos = 0x0  // Position of PRMBL_0 field.
	FPB_FP_CIDR0_PRMBL_0_Msk = 0xff // Bit mask of PRMBL_0 field.

	// FP_CIDR1: FP Component Identification Register 1
	FPB_FP_CIDR1_PRMBL_1_Pos = 0x0  // Position of PRMBL_1 field.
	FPB_FP_CIDR1_PRMBL_1_Msk = 0xf  // Bit mask of PRMBL_1 field.
	FPB_FP_CIDR1_CLASS_Pos   = 0x4  // Position of CLASS field.
	FPB_FP_CIDR1_CLASS_Msk   = 0xf0 // Bit mask of CLASS field.

	// FP_CIDR2: FP Component Identification Register 2
	FPB_FP_CIDR2_PRMBL_2_Pos = 0x0  // Position of PRMBL_2 field.
	FPB_FP_CIDR2_PRMBL_2_Msk = 0xff // Bit mask of PRMBL_2 field.

	// FP_CIDR3: FP Component Identification Register 3
	FPB_FP_CIDR3_PRMBL_3_Pos = 0x0  // Position of PRMBL_3 field.
	FPB_FP_CIDR3_PRMBL_3_Msk = 0xff // Bit mask of PRMBL_3 field.
)

// Bitfields for ICB: Implementation Control Block
const (
	// ICTR: Interrupt Controller Type Register
	ICB_ICTR_INTLINESNUM_Pos = 0x0 // Position of INTLINESNUM field.
	ICB_ICTR_INTLINESNUM_Msk = 0xf // Bit mask of INTLINESNUM field.
)

// Bitfields for MPU: Memory Protection Unit
const (
	// MPU_TYPE: MPU Type Register
	MPU_MPU_TYPE_SEPARATE_Pos = 0x0    // Position of SEPARATE field.
	MPU_MPU_TYPE_SEPARATE_Msk = 0x1    // Bit mask of SEPARATE field.
	MPU_MPU_TYPE_SEPARATE     = 0x1    // Bit SEPARATE.
	MPU_MPU_TYPE_DREGION_Pos  = 0x8    // Position of DREGION field.
	MPU_MPU_TYPE_DREGION_Msk  = 0xff00 // Bit mask of DREGION field.

	// MPU_CTRL: MPU Control Register
	MPU_MPU_CTRL_ENABLE_Pos     = 0x0 // Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk     = 0x1 // Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE         = 0x1 // Bit ENABLE.
	MPU_MPU_CTRL_HFNMIENA_Pos   = 0x1 // Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk   = 0x2 // Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA       = 0x2 // Bit HFNMIENA.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2 // Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4 // Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA     = 0x4 // Bit PRIVDEFENA.

	// MPU_RNR: MPU Region Number Register
	MPU_MPU_RNR_REGION_Pos = 0x0  // Position of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff // Bit mask of REGION field.

	// MPU_RBAR: MPU Region Base Address Register
	MPU_MPU_RBAR_XN_Pos    = 0x0        // Position of XN field.
	MPU_MPU_RBAR_XN_Msk    = 0x1        // Bit mask of XN field.
	MPU_MPU_RBAR_XN        = 0x1        // Bit XN.
	MPU_MPU_RBAR_AP_Pos    = 0x1        // Position of AP field.
	MPU_MPU_RBAR_AP_Msk    = 0x6        // Bit mask of AP field.
	MPU_MPU_RBAR_AP_RWPRIV = 0x0        // Read/write by privileged code only
	MPU_MPU_RBAR_AP_RWANY  = 0x1        // Read/write by any privilege level
	MPU_MPU_RBAR_AP_RPRIV  = 0x2        // Read-only by privileged code only
	MPU_MPU_RBAR_AP_RANY   = 0x3        // Read-only by any privilege level
	MPU_MPU_RBAR_SH_Pos    = 0x3        // Position of SH field.
	MPU_MPU_RBAR_SH_Msk    = 0x18       // Bit mask of SH field.
	MPU_MPU_RBAR_SH_NO     = 0x0        // Non-shareable
	MPU_MPU_RBAR_SH_OUTER  = 0x2        // Outer shareable
	MPU_MPU_RBAR_SH_INNER  = 0x3        // Inner shareable
	MPU_MPU_RBAR_BASE_Pos  = 0x5        // Position of BASE field.
	MPU_MPU_RBAR_BASE_Msk  = 0xffffffe0 // Bit mask of BASE field.

	// MPU_RLAR: MPU Region Limit Address Register
	MPU_MPU_RLAR_EN_Pos      = 0x0        // Position of EN field.
	MPU_MPU_RLAR_EN_Msk      = 0x1        // Bit mask of EN field.
	MPU_MPU_RLAR_EN          = 0x1        // Bit EN.
	MPU_MPU_RLAR_AttrInd_Pos = 0x1        // Position of AttrInd field.
	MPU_MPU_RLAR_AttrInd_Msk = 0xe        // Bit mask of AttrInd field.
	MPU_MPU_RLAR_LIMIT_Pos   = 0x5        // Position of LIMIT field.
	MPU_MPU_RLAR_LIMIT_Msk   = 0xffffffe0 // Bit mask of LIMIT field.

	// MPU_MAIR0: MPU Memory Attribute Indirection Register 0
	MPU_MPU_MAIR0_Attr0_Pos = 0x0        // Position of Attr0 field.
	MPU_MPU_MAIR0_Attr0_Msk = 0xff       // Bit mask of Attr0 field.
	MPU_MPU_MAIR0_Attr1_Pos = 0x8        // Position of Attr1 field.
	MPU_MPU_MAIR0_Attr1_Msk = 0xff00     // Bit mask of Attr1 field.
	MPU_MPU_MAIR0_Attr2_Pos = 0x10       // Position of Attr2 field.
	MPU_MPU_MAIR0_Attr2_Msk = 0xff0000   // Bit mask of Attr2 field.
	MPU_MPU_MAIR0_Attr3_Pos = 0x18       // Position of Attr3 field.
	MPU_MPU_MAIR0_Attr3_Msk = 0xff000000 // Bit mask of Attr3 field.
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// NVIC_ISER: Interrupt Set Enable Register n
	NVIC_NVIC_ISER_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_NVIC_ISER_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// NVIC_ICER: Interrupt Clear Enable Register n
	NVIC_NVIC_ICER_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_NVIC_ICER_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// NVIC_ISPR: Interrupt Set Pending Register n
	NVIC_NVIC_ISPR_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_NVIC_ISPR_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// NVIC_ICPR: Interrupt Clear Pending Register n
	NVIC_NVIC_ICPR_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_NVIC_ICPR_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// NVIC_IABR: Interrupt Active Bit Register n
	NVIC_NVIC_IABR_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_NVIC_IABR_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// NVIC_ITNS: Interrupt Target Non-secure Register n
	NVIC_NVIC_ITNS_ITNS_Pos = 0x0        // Position of ITNS field.
	NVIC_NVIC_ITNS_ITNS_Msk = 0xffffffff // Bit mask of ITNS field.

	// NVIC_IPR: Interrupt Priority Register n
	NVIC_NVIC_IPR_PRI_N0_Pos = 0x0        // Position of PRI_N0 field.
	NVIC_NVIC_IPR_PRI_N0_Msk = 0xff       // Bit mask of PRI_N0 field.
	NVIC_NVIC_IPR_PRI_N1_Pos = 0x8        // Position of PRI_N1 field.
	NVIC_NVIC_IPR_PRI_N1_Msk = 0xff00     // Bit mask of PRI_N1 field.
	NVIC_NVIC_IPR_PRI_N2_Pos = 0x10       // Position of PRI_N2 field.
	NVIC_NVIC_IPR_PRI_N2_Msk = 0xff0000   // Bit mask of PRI_N2 field.
	NVIC_NVIC_IPR_PRI_N3_Pos = 0x18       // Position of PRI_N3 field.
	NVIC_NVIC_IPR_PRI_N3_Msk = 0xff000000 // Bit mask of PRI_N3 field.
)

// Bitfields for SCB: System Control Block
const (
	// CPUID: CPUID base register
	SCB_CPUID_Revision_Pos     = 0x0        // Position of Revision field.
	SCB_CPUID_Revision_Msk     = 0xf        // Bit mask of Revision field.
	SCB_CPUID_PartNo_Pos       = 0x4        // Position of PartNo field.
	SCB_CPUID_PartNo_Msk       = 0xfff0     // Bit mask of PartNo field.
	SCB_CPUID_Architecture_Pos = 0x10       // Position of Architecture field.
	SCB_CPUID_Architecture_Msk = 0xf0000    // Bit mask of Architecture field.
	SCB_CPUID_Variant_Pos      = 0x14       // Position of Variant field.
	SCB_CPUID_Variant_Msk      = 0xf00000   // Bit mask of Variant field.
	SCB_CPUID_Implementer_Pos  = 0x18       // Position of Implementer field.
	SCB_CPUID_Implementer_Msk  = 0xff000000 // Bit mask of Implementer field.

	// ICSR: Interrupt Control and State Register
	SCB_ICSR_VECTACTIVE_Pos     = 0x0        // Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk     = 0x1ff      // Bit mask of VECTACTIVE field.
	SCB_ICSR_RETTOBASE_Pos      = 0xb        // Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk      = 0x800      // Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE          = 0x800      // Bit RETTOBASE.
	SCB_ICSR_VECTPENDING_Pos    = 0xc        // Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk    = 0x1ff000   // Bit mask of VECTPENDING field.
	SCB_ICSR_ISRPENDING_Pos     = 0x16       // Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk     = 0x400000   // Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING         = 0x400000   // Bit ISRPENDING.
	SCB_ICSR_ISRPREEMPT_Pos     = 0x17       // Position of ISRPREEMPT field.
	SCB_ICSR_ISRPREEMPT_Msk     = 0x800000   // Bit mask of ISRPREEMPT field.
	SCB_ICSR_ISRPREEMPT         = 0x800000   // Bit ISRPREEMPT.
	SCB_ICSR_PENDSTCLR_Pos      = 0x19       // Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk      = 0x2000000  // Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR          = 0x2000000  // Bit PENDSTCLR.
	SCB_ICSR_PENDSTCLR_VALUE_0  = 0x0        // No effect
	SCB_ICSR_PENDSTCLR_VALUE_1  = 0x1        // Removes the pending state from the SysTick exception
	SCB_ICSR_PENDSTSET_Pos      = 0x1a       // Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk      = 0x4000000  // Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET          = 0x4000000  // Bit PENDSTSET.
	SCB_ICSR_PENDSTSET_VALUE_0  = 0x0        // Write: no effect; read: SysTick exception is not pending
	SCB_ICSR_PENDSTSET_VALUE_1  = 0x1        // Write: changes SysTick exception state to pending; read: SysTick exception is pending
	SCB_ICSR_PENDSVCLR_Pos      = 0x1b       // Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk      = 0x8000000  // Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR          = 0x8000000  // Bit PENDSVCLR.
	SCB_ICSR_PENDSVCLR_VALUE_0  = 0x0        // No effect
	SCB_ICSR_PENDSVCLR_VALUE_1  = 0x1        // Removes the pending state from the PendSV exception
	SCB_ICSR_PENDSVSET_Pos      = 0x1c       // Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk      = 0x10000000 // Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET          = 0x10000000 // Bit PENDSVSET.
	SCB_ICSR_PENDSVSET_VALUE_0  = 0x0        // Write: no effect; read: PendSV exception is not pending
	SCB_ICSR_PENDSVSET_VALUE_1  = 0x1        // Write: changes PendSV exception state to pending; read: PendSV exception is pending
	SCB_ICSR_PENDNMICLR_Pos     = 0x1e       // Position of PENDNMICLR field.
	SCB_ICSR_PENDNMICLR_Msk     = 0x40000000 // Bit mask of PENDNMICLR field.
	SCB_ICSR_PENDNMICLR         = 0x40000000 // Bit PENDNMICLR.
	SCB_ICSR_PENDNMISET_Pos     = 0x1f       // Position of PENDNMISET field.
	SCB_ICSR_PENDNMISET_Msk     = 0x80000000 // Bit mask of PENDNMISET field.
	SCB_ICSR_PENDNMISET         = 0x80000000 // Bit PENDNMISET.
	SCB_ICSR_PENDNMISET_VALUE_0 = 0x0        // Write: no effect; read: NMI exception is not pending
	SCB_ICSR_PENDNMISET_VALUE_1 = 0x1        // Write: changes NMI exception state to pending; read: NMI exception is pending

	// VTOR: Vector Table Offset Register
	SCB_VTOR_TBLOFF_Pos = 0x7        // Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0xffffff80 // Bit mask of TBLOFF field.

	// AIRCR: Application Interrupt and Reset Control Register
	SCB_AIRCR_VECTCLRACTIVE_Pos    = 0x1        // Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk    = 0x2        // Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE        = 0x2        // Bit VECTCLRACTIVE.
	SCB_AIRCR_VECTCLRACTIVE_NO     = 0x0        // Do not clear active state
	SCB_AIRCR_VECTCLRACTIVE_YES    = 0x1        // Clear active state
	SCB_AIRCR_SYSRESETREQ_Pos      = 0x2        // Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk      = 0x4        // Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ          = 0x4        // Bit SYSRESETREQ.
	SCB_AIRCR_SYSRESETREQ_NO       = 0x0        // Do not request a system reset
	SCB_AIRCR_SYSRESETREQ_YES      = 0x1        // Request a system reset
	SCB_AIRCR_SYSRESETREQS_Pos     = 0x3        // Position of SYSRESETREQS field.
	SCB_AIRCR_SYSRESETREQS_Msk     = 0x8        // Bit mask of SYSRESETREQS field.
	SCB_AIRCR_SYSRESETREQS         = 0x8        // Bit SYSRESETREQS.
	SCB_AIRCR_SYSRESETREQS_BOTH    = 0x0        // SYSRESETREQ functionality is available to both Security states
	SCB_AIRCR_SYSRESETREQS_SECURE  = 0x1        // SYSRESETREQ functionality is only available to Secure state
	SCB_AIRCR_BFHFNMINS_Pos        = 0xd        // Position of BFHFNMINS field.
	SCB_AIRCR_BFHFNMINS_Msk        = 0x2000     // Bit mask of BFHFNMINS field.
	SCB_AIRCR_BFHFNMINS            = 0x2000     // Bit BFHFNMINS.
	SCB_AIRCR_BFHFNMINS_SECURE     = 0x0        // BusFault, HardFault, and NMI are Secure
	SCB_AIRCR_BFHFNMINS_NON_SECURE = 0x1        // BusFault and NMI are Non-secure and exceptions can target Non-secure HardFault
	SCB_AIRCR_PRIS_Pos             = 0xe        // Position of PRIS field.
	SCB_AIRCR_PRIS_Msk             = 0x4000     // Bit mask of PRIS field.
	SCB_AIRCR_PRIS                 = 0x4000     // Bit PRIS.
	SCB_AIRCR_PRIS_SAME            = 0x0        // Priority ranges of Secure and Non-secure exceptions are identical
	SCB_AIRCR_PRIS_NS_DEPRIO       = 0x1        // Non-secure exceptions are de-prioritized
	SCB_AIRCR_ENDIANNESS_Pos       = 0xf        // Position of ENDIANNESS field.
	SCB_AIRCR_ENDIANNESS_Msk       = 0x8000     // Bit mask of ENDIANNESS field.
	SCB_AIRCR_ENDIANNESS           = 0x8000     // Bit ENDIANNESS.
	SCB_AIRCR_ENDIANNESS_LITTLE    = 0x0        // Little-endian
	SCB_AIRCR_ENDIANNESS_BIG       = 0x1        // Big-endian
	SCB_AIRCR_VECTKEY_Pos          = 0x10       // Position of VECTKEY field.
	SCB_AIRCR_VECTKEY_Msk          = 0xffff0000 // Bit mask of VECTKEY field.

	// SCR: System Control Register
	SCB_SCR_SLEEPONEXIT_Pos     = 0x1  // Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk     = 0x2  // Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT         = 0x2  // Bit SLEEPONEXIT.
	SCB_SCR_SLEEPONEXIT_VALUE_0 = 0x0  // O not sleep when returning to Thread mode
	SCB_SCR_SLEEPONEXIT_VALUE_1 = 0x1  // Enter sleep, or deep sleep, on return from an ISR
	SCB_SCR_SLEEPDEEP_Pos       = 0x2  // Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk       = 0x4  // Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP           = 0x4  // Bit SLEEPDEEP.
	SCB_SCR_SLEEPDEEP_VALUE_0   = 0x0  // Sleep
	SCB_SCR_SLEEPDEEP_VALUE_1   = 0x1  // Deep sleep
	SCB_SCR_SLEEPDEEPS_Pos      = 0x3  // Position of SLEEPDEEPS field.
	SCB_SCR_SLEEPDEEPS_Msk      = 0x8  // Bit mask of SLEEPDEEPS field.
	SCB_SCR_SLEEPDEEPS          = 0x8  // Bit SLEEPDEEPS.
	SCB_SCR_SEVONPEND_Pos       = 0x4  // Position of SEVONPEND field.
	SCB_SCR_SEVONPEND_Msk       = 0x10 // Bit mask of SEVONPEND field.
	SCB_SCR_SEVONPEND           = 0x10 // Bit SEVONPEND.
	SCB_SCR_SEVONPEND_VALUE_0   = 0x0  // Only enabled interrupts or events can wakeup the processor, disabled interrupts are excluded
	SCB_SCR_SEVONPEND_VALUE_1   = 0x1  // Enabled events and all interrupts, including disabled interrupts, can wakeup the processor

	// CCR: Configuration and Control Register
	SCB_CCR_USERSETMPEND_Pos    = 0x1     // Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk    = 0x2     // Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND        = 0x2     // Bit USERSETMPEND.
	SCB_CCR_UNALIGN_TRP_Pos     = 0x3     // Position of UNALIGN_TRP field.
	SCB_CCR_UNALIGN_TRP_Msk     = 0x8     // Bit mask of UNALIGN_TRP field.
	SCB_CCR_UNALIGN_TRP         = 0x8     // Bit UNALIGN_TRP.
	SCB_CCR_UNALIGN_TRP_VALUE_0 = 0x0     // Do not trap unaligned halfword and word accesses
	SCB_CCR_UNALIGN_TRP_VALUE_1 = 0x1     // Trap unaligned halfword and word accesses
	SCB_CCR_DIV_0_TRP_Pos       = 0x4     // Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk       = 0x10    // Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP           = 0x10    // Bit DIV_0_TRP.
	SCB_CCR_BFHFNMIGN_Pos       = 0x8     // Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk       = 0x100   // Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN           = 0x100   // Bit BFHFNMIGN.
	SCB_CCR_STKOFHFNMIGN_Pos    = 0xa     // Position of STKOFHFNMIGN field.
	SCB_CCR_STKOFHFNMIGN_Msk    = 0x400   // Bit mask of STKOFHFNMIGN field.
	SCB_CCR_STKOFHFNMIGN        = 0x400   // Bit STKOFHFNMIGN.
	SCB_CCR_DC_Pos              = 0x10    // Position of DC field.
	SCB_CCR_DC_Msk              = 0x10000 // Bit mask of DC field.
	SCB_CCR_DC                  = 0x10000 // Bit DC.
	SCB_CCR_IC_Pos              = 0x11    // Position of IC field.
	SCB_CCR_IC_Msk              = 0x20000 // Bit mask of IC field.
	SCB_CCR_IC                  = 0x20000 // Bit IC.
	SCB_CCR_BP_Pos              = 0x12    // Position of BP field.
	SCB_CCR_BP_Msk              = 0x40000 // Bit mask of BP field.
	SCB_CCR_BP                  = 0x40000 // Bit BP.

	// SHPR2: System Handler Priority Register 2
	SCB_SHPR2_PRI_11_Pos = 0x18       // Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000 // Bit mask of PRI_11 field.

	// SHPR3: System Handler Priority Register 3
	SCB_SHPR3_PRI_12_Pos = 0x0        // Position of PRI_12 field.
	SCB_SHPR3_PRI_12_Msk = 0xff       // Bit mask of PRI_12 field.
	SCB_SHPR3_PRI_14_Pos = 0x10       // Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000   // Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_15_Pos = 0x18       // Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000 // Bit mask of PRI_15 field.

	// SHCSR: System Handler Control and State Register
	SCB_SHCSR_HARDFAULTACT_Pos    = 0x2      // Position of HARDFAULTACT field.
	SCB_SHCSR_HARDFAULTACT_Msk    = 0x4      // Bit mask of HARDFAULTACT field.
	SCB_SHCSR_HARDFAULTACT        = 0x4      // Bit HARDFAULTACT.
	SCB_SHCSR_NMIACT_Pos          = 0x5      // Position of NMIACT field.
	SCB_SHCSR_NMIACT_Msk          = 0x20     // Bit mask of NMIACT field.
	SCB_SHCSR_NMIACT              = 0x20     // Bit NMIACT.
	SCB_SHCSR_SVCALLACT_Pos       = 0x7      // Position of SVCALLACT field.
	SCB_SHCSR_SVCALLACT_Msk       = 0x80     // Bit mask of SVCALLACT field.
	SCB_SHCSR_SVCALLACT           = 0x80     // Bit SVCALLACT.
	SCB_SHCSR_PENDSVACT_Pos       = 0xa      // Position of PENDSVACT field.
	SCB_SHCSR_PENDSVACT_Msk       = 0x400    // Bit mask of PENDSVACT field.
	SCB_SHCSR_PENDSVACT           = 0x400    // Bit PENDSVACT.
	SCB_SHCSR_SYSTICKACT_Pos      = 0xb      // Position of SYSTICKACT field.
	SCB_SHCSR_SYSTICKACT_Msk      = 0x800    // Bit mask of SYSTICKACT field.
	SCB_SHCSR_SYSTICKACT          = 0x800    // Bit SYSTICKACT.
	SCB_SHCSR_SVCALLPENDED_Pos    = 0xf      // Position of SVCALLPENDED field.
	SCB_SHCSR_SVCALLPENDED_Msk    = 0x8000   // Bit mask of SVCALLPENDED field.
	SCB_SHCSR_SVCALLPENDED        = 0x8000   // Bit SVCALLPENDED.
	SCB_SHCSR_HARDFAULTPENDED_Pos = 0x15     // Position of HARDFAULTPENDED field.
	SCB_SHCSR_HARDFAULTPENDED_Msk = 0x200000 // Bit mask of HARDFAULTPENDED field.
	SCB_SHCSR_HARDFAULTPENDED     = 0x200000 // Bit HARDFAULTPENDED.

	// DFSR: Debug Fault Status Register
	SCB_DFSR_HALTED_Pos   = 0x0  // Position of HALTED field.
	SCB_DFSR_HALTED_Msk   = 0x1  // Bit mask of HALTED field.
	SCB_DFSR_HALTED       = 0x1  // Bit HALTED.
	SCB_DFSR_BKPT_Pos     = 0x1  // Position of BKPT field.
	SCB_DFSR_BKPT_Msk     = 0x2  // Bit mask of BKPT field.
	SCB_DFSR_BKPT         = 0x2  // Bit BKPT.
	SCB_DFSR_DWTTRAP_Pos  = 0x2  // Position of DWTTRAP field.
	SCB_DFSR_DWTTRAP_Msk  = 0x4  // Bit mask of DWTTRAP field.
	SCB_DFSR_DWTTRAP      = 0x4  // Bit DWTTRAP.
	SCB_DFSR_VCATCH_Pos   = 0x3  // Position of VCATCH field.
	SCB_DFSR_VCATCH_Msk   = 0x8  // Bit mask of VCATCH field.
	SCB_DFSR_VCATCH       = 0x8  // Bit VCATCH.
	SCB_DFSR_EXTERNAL_Pos = 0x4  // Position of EXTERNAL field.
	SCB_DFSR_EXTERNAL_Msk = 0x10 // Bit mask of EXTERNAL field.
	SCB_DFSR_EXTERNAL     = 0x10 // Bit EXTERNAL.

	// CLIDR: Cache Level ID Register
	SCB_CLIDR_Ctype1_Pos      = 0x0        // Position of Ctype1 field.
	SCB_CLIDR_Ctype1_Msk      = 0x7        // Bit mask of Ctype1 field.
	SCB_CLIDR_Ctype1_NO       = 0x0        // No cache
	SCB_CLIDR_Ctype1_IC       = 0x1        // Instruction cache only
	SCB_CLIDR_Ctype1_DC       = 0x2        // Data cache only
	SCB_CLIDR_Ctype1_SEPARATE = 0x3        // Separate instruction and data caches
	SCB_CLIDR_Ctype1_UNIFIED  = 0x4        // Unified cache
	SCB_CLIDR_Ctype2_Pos      = 0x3        // Position of Ctype2 field.
	SCB_CLIDR_Ctype2_Msk      = 0x38       // Bit mask of Ctype2 field.
	SCB_CLIDR_Ctype2_NO       = 0x0        // No cache
	SCB_CLIDR_Ctype2_IC       = 0x1        // Instruction cache only
	SCB_CLIDR_Ctype2_DC       = 0x2        // Data cache only
	SCB_CLIDR_Ctype2_SEPARATE = 0x3        // Separate instruction and data caches
	SCB_CLIDR_Ctype2_UNIFIED  = 0x4        // Unified cache
	SCB_CLIDR_Ctype3_Pos      = 0x6        // Position of Ctype3 field.
	SCB_CLIDR_Ctype3_Msk      = 0x1c0      // Bit mask of Ctype3 field.
	SCB_CLIDR_Ctype3_NO       = 0x0        // No cache
	SCB_CLIDR_Ctype3_IC       = 0x1        // Instruction cache only
	SCB_CLIDR_Ctype3_DC       = 0x2        // Data cache only
	SCB_CLIDR_Ctype3_SEPARATE = 0x3        // Separate instruction and data caches
	SCB_CLIDR_Ctype3_UNIFIED  = 0x4        // Unified cache
	SCB_CLIDR_Ctype4_Pos      = 0x9        // Position of Ctype4 field.
	SCB_CLIDR_Ctype4_Msk      = 0xe00      // Bit mask of Ctype4 field.
	SCB_CLIDR_Ctype4_NO       = 0x0        // No cache
	SCB_CLIDR_Ctype4_IC       = 0x1        // Instruction cache only
	SCB_CLIDR_Ctype4_DC       = 0x2        // Data cache only
	SCB_CLIDR_Ctype4_SEPARATE = 0x3        // Separate instruction and data caches
	SCB_CLIDR_Ctype4_UNIFIED  = 0x4        // Unified cache
	SCB_CLIDR_Ctype5_Pos      = 0xc        // Position of Ctype5 field.
	SCB_CLIDR_Ctype5_Msk      = 0x7000     // Bit mask of Ctype5 field.
	SCB_CLIDR_Ctype5_NO       = 0x0        // No cache
	SCB_CLIDR_Ctype5_IC       = 0x1        // Instruction cache only
	SCB_CLIDR_Ctype5_DC       = 0x2        // Data cache only
	SCB_CLIDR_Ctype5_SEPARATE = 0x3        // Separate instruction and data caches
	SCB_CLIDR_Ctype5_UNIFIED  = 0x4        // Unified cache
	SCB_CLIDR_Ctype6_Pos      = 0xf        // Position of Ctype6 field.
	SCB_CLIDR_Ctype6_Msk      = 0x38000    // Bit mask of Ctype6 field.
	SCB_CLIDR_Ctype6_NO       = 0x0        // No cache
	SCB_CLIDR_Ctype6_IC       = 0x1        // Instruction cache only
	SCB_CLIDR_Ctype6_DC       = 0x2        // Data cache only
	SCB_CLIDR_Ctype6_SEPARATE = 0x3        // Separate instruction and data caches
	SCB_CLIDR_Ctype6_UNIFIED  = 0x4        // Unified cache
	SCB_CLIDR_Ctype7_Pos      = 0x12       // Position of Ctype7 field.
	SCB_CLIDR_Ctype7_Msk      = 0x1c0000   // Bit mask of Ctype7 field.
	SCB_CLIDR_Ctype7_NO       = 0x0        // No cache
	SCB_CLIDR_Ctype7_IC       = 0x1        // Instruction cache only
	SCB_CLIDR_Ctype7_DC       = 0x2        // Data cache only
	SCB_CLIDR_Ctype7_SEPARATE = 0x3        // Separate instruction and data caches
	SCB_CLIDR_Ctype7_UNIFIED  = 0x4        // Unified cache
	SCB_CLIDR_LoUIS_Pos       = 0x15       // Position of LoUIS field.
	SCB_CLIDR_LoUIS_Msk       = 0xe00000   // Bit mask of LoUIS field.
	SCB_CLIDR_LoC_Pos         = 0x18       // Position of LoC field.
	SCB_CLIDR_LoC_Msk         = 0x7000000  // Bit mask of LoC field.
	SCB_CLIDR_LoUU_Pos        = 0x1b       // Position of LoUU field.
	SCB_CLIDR_LoUU_Msk        = 0x38000000 // Bit mask of LoUU field.
	SCB_CLIDR_ICB_Pos         = 0x1e       // Position of ICB field.
	SCB_CLIDR_ICB_Msk         = 0xc0000000 // Bit mask of ICB field.
	SCB_CLIDR_ICB_NO          = 0x0        // Not disclosed in this mechanism
	SCB_CLIDR_ICB_L1          = 0x1        // L1 cache is the highest inner level
	SCB_CLIDR_ICB_L2          = 0x2        // L2 cache is the highest inner level
	SCB_CLIDR_ICB_L3          = 0x3        // L3 cache is the highest inner level

	// CTR: Cache Type Register
	SCB_CTR_IminLine_Pos = 0x0        // Position of IminLine field.
	SCB_CTR_IminLine_Msk = 0xf        // Bit mask of IminLine field.
	SCB_CTR_DminLine_Pos = 0x10       // Position of DminLine field.
	SCB_CTR_DminLine_Msk = 0xf0000    // Bit mask of DminLine field.
	SCB_CTR_ERG_Pos      = 0x14       // Position of ERG field.
	SCB_CTR_ERG_Msk      = 0xf00000   // Bit mask of ERG field.
	SCB_CTR_CWG_Pos      = 0x18       // Position of CWG field.
	SCB_CTR_CWG_Msk      = 0xf000000  // Bit mask of CWG field.
	SCB_CTR_Format_Pos   = 0x1d       // Position of Format field.
	SCB_CTR_Format_Msk   = 0xe0000000 // Bit mask of Format field.
	SCB_CTR_Format_NO    = 0x0        // No cache type information provided
	SCB_CTR_Format_YES   = 0x4        // Cache type information is provided

	// CCSIDR: Current Cache Size ID register
	SCB_CCSIDR_LineSize_Pos      = 0x0        // Position of LineSize field.
	SCB_CCSIDR_LineSize_Msk      = 0x7        // Bit mask of LineSize field.
	SCB_CCSIDR_Associativity_Pos = 0x3        // Position of Associativity field.
	SCB_CCSIDR_Associativity_Msk = 0x1ff8     // Bit mask of Associativity field.
	SCB_CCSIDR_NumSets_Pos       = 0xd        // Position of NumSets field.
	SCB_CCSIDR_NumSets_Msk       = 0xfffe000  // Bit mask of NumSets field.
	SCB_CCSIDR_WA_Pos            = 0x1c       // Position of WA field.
	SCB_CCSIDR_WA_Msk            = 0x10000000 // Bit mask of WA field.
	SCB_CCSIDR_WA                = 0x10000000 // Bit WA.
	SCB_CCSIDR_RA_Pos            = 0x1d       // Position of RA field.
	SCB_CCSIDR_RA_Msk            = 0x20000000 // Bit mask of RA field.
	SCB_CCSIDR_RA                = 0x20000000 // Bit RA.
	SCB_CCSIDR_WB_Pos            = 0x1e       // Position of WB field.
	SCB_CCSIDR_WB_Msk            = 0x40000000 // Bit mask of WB field.
	SCB_CCSIDR_WB                = 0x40000000 // Bit WB.
	SCB_CCSIDR_WT_Pos            = 0x1f       // Position of WT field.
	SCB_CCSIDR_WT_Msk            = 0x80000000 // Bit mask of WT field.
	SCB_CCSIDR_WT                = 0x80000000 // Bit WT.

	// CSSELR: Cache Size Selection Register
	SCB_CSSELR_InD_Pos   = 0x0 // Position of InD field.
	SCB_CSSELR_InD_Msk   = 0x1 // Bit mask of InD field.
	SCB_CSSELR_InD       = 0x1 // Bit InD.
	SCB_CSSELR_Level_Pos = 0x1 // Position of Level field.
	SCB_CSSELR_Level_Msk = 0xe // Bit mask of Level field.
)

// Bitfields for SysTick: SysTick Timer
const (
	// SYST_CSR: SysTick Control and Status Register
	SysTick_SYST_CSR_ENABLE_Pos    = 0x0     // Position of ENABLE field.
	SysTick_SYST_CSR_ENABLE_Msk    = 0x1     // Bit mask of ENABLE field.
	SysTick_SYST_CSR_ENABLE        = 0x1     // Bit ENABLE.
	SysTick_SYST_CSR_TICKINT_Pos   = 0x1     // Position of TICKINT field.
	SysTick_SYST_CSR_TICKINT_Msk   = 0x2     // Bit mask of TICKINT field.
	SysTick_SYST_CSR_TICKINT       = 0x2     // Bit TICKINT.
	SysTick_SYST_CSR_CLKSOURCE_Pos = 0x2     // Position of CLKSOURCE field.
	SysTick_SYST_CSR_CLKSOURCE_Msk = 0x4     // Bit mask of CLKSOURCE field.
	SysTick_SYST_CSR_CLKSOURCE     = 0x4     // Bit CLKSOURCE.
	SysTick_SYST_CSR_COUNTFLAG_Pos = 0x10    // Position of COUNTFLAG field.
	SysTick_SYST_CSR_COUNTFLAG_Msk = 0x10000 // Bit mask of COUNTFLAG field.
	SysTick_SYST_CSR_COUNTFLAG     = 0x10000 // Bit COUNTFLAG.

	// SYST_RVR: SysTick Reload Value Register
	SysTick_SYST_RVR_RELOAD_Pos = 0x18      // Position of RELOAD field.
	SysTick_SYST_RVR_RELOAD_Msk = 0x1000000 // Bit mask of RELOAD field.
	SysTick_SYST_RVR_RELOAD     = 0x1000000 // Bit RELOAD.

	// SYST_CVR: SysTick Current Value Register
	SysTick_SYST_CVR_CURRENT_Pos = 0x18      // Position of CURRENT field.
	SysTick_SYST_CVR_CURRENT_Msk = 0x1000000 // Bit mask of CURRENT field.
	SysTick_SYST_CVR_CURRENT     = 0x1000000 // Bit CURRENT.

	// SYST_CALIB: SysTick Calibration Value Register
	SysTick_SYST_CALIB_TENMS_Pos = 0x0        // Position of TENMS field.
	SysTick_SYST_CALIB_TENMS_Msk = 0xffffff   // Bit mask of TENMS field.
	SysTick_SYST_CALIB_SKEW_Pos  = 0x1e       // Position of SKEW field.
	SysTick_SYST_CALIB_SKEW_Msk  = 0x40000000 // Bit mask of SKEW field.
	SysTick_SYST_CALIB_SKEW      = 0x40000000 // Bit SKEW.
	SysTick_SYST_CALIB_NOREF_Pos = 0x1f       // Position of NOREF field.
	SysTick_SYST_CALIB_NOREF_Msk = 0x80000000 // Bit mask of NOREF field.
	SysTick_SYST_CALIB_NOREF     = 0x80000000 // Bit NOREF.
)
