//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.4
//
// <auto-generated>
//
// Generated from file `IceBox.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceBox_IceBox_h__
#define __IceBox_IceBox_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/BuiltinSequences.h>
#include <Ice/CommunicatorF.h>
#include <Ice/PropertiesF.h>
#include <Ice/SliceChecksumDict.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceBox/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 4
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEBOX_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEBOX_API /**/
#   elif defined(ICEBOX_API_EXPORTS)
#       define ICEBOX_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEBOX_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceBox
{

class Service;
class ServiceObserver;
class ServiceObserverPrx;
class ServiceManager;
class ServiceManagerPrx;

}

namespace IceBox
{

/**
 * This exception is a general failure notification. It is thrown
 * for errors such as a service encountering an error during
 * initialization, or the service manager being unable
 * to load a service executable.
 * \headerfile IceBox/IceBox.h
 */
class ICE_CLASS(ICEBOX_API) FailureException : public ::Ice::LocalExceptionHelper<FailureException, ::Ice::LocalException>
{
public:

    ICE_MEMBER(ICEBOX_API) virtual ~FailureException();

    FailureException(const FailureException&) = default;

    /**
     * The file and line number are required for all local exceptions.
     * @param file The file name in which the exception was raised, typically __FILE__.
     * @param line The line number at which the exception was raised, typically __LINE__.
     */
    FailureException(const char* file, int line) : ::Ice::LocalExceptionHelper<FailureException, ::Ice::LocalException>(file, line)
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * The file and line number are required for all local exceptions.
     * @param file The file name in which the exception was raised, typically __FILE__.
     * @param line The line number at which the exception was raised, typically __LINE__.
     * @param reason The reason for the failure.
     */
    FailureException(const char* file, int line, const ::std::string& reason) : ::Ice::LocalExceptionHelper<FailureException, ::Ice::LocalException>(file, line),
        reason(reason)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();
    /**
     * Prints this exception to the given stream.
     * @param stream The target stream.
     */
    ICE_MEMBER(ICEBOX_API) virtual void ice_print(::std::ostream& stream) const override;

    /**
     * The reason for the failure.
     */
    ::std::string reason;
};

/**
 * This exception is thrown if an attempt is made to start an
 * already-started service.
 * \headerfile IceBox/IceBox.h
 */
class ICE_CLASS(ICEBOX_API) AlreadyStartedException : public ::Ice::UserExceptionHelper<AlreadyStartedException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEBOX_API) virtual ~AlreadyStartedException();

    AlreadyStartedException(const AlreadyStartedException&) = default;

    AlreadyStartedException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();
};

/// \cond INTERNAL
static AlreadyStartedException _iceS_AlreadyStartedException_init;
/// \endcond

/**
 * This exception is thrown if an attempt is made to stop an
 * already-stopped service.
 * \headerfile IceBox/IceBox.h
 */
class ICE_CLASS(ICEBOX_API) AlreadyStoppedException : public ::Ice::UserExceptionHelper<AlreadyStoppedException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEBOX_API) virtual ~AlreadyStoppedException();

    AlreadyStoppedException(const AlreadyStoppedException&) = default;

    AlreadyStoppedException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();
};

/**
 * This exception is thrown if a service name does not refer
 * to an existing service.
 * \headerfile IceBox/IceBox.h
 */
class ICE_CLASS(ICEBOX_API) NoSuchServiceException : public ::Ice::UserExceptionHelper<NoSuchServiceException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEBOX_API) virtual ~NoSuchServiceException();

    NoSuchServiceException(const NoSuchServiceException&) = default;

    NoSuchServiceException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();
};

}

namespace IceBox
{

/**
 * An application service managed by a {@link ServiceManager}.
 * \headerfile IceBox/IceBox.h
 */
class ICE_CLASS(ICEBOX_API) Service
{
public:

    ICE_MEMBER(ICEBOX_API) virtual ~Service();

    /**
     * Start the service. The given communicator is created by the
     * {@link ServiceManager} for use by the service. This communicator may
     * also be used by other services, depending on the service
     * configuration.
     *
     * <p class="Note">The {@link ServiceManager} owns this communicator, and is
     * responsible for destroying it.
     * @param name The service's name, as determined by the
     * configuration.
     * @param communicator A communicator for use by the service.
     * @param args The service arguments that were not converted into
     * properties.
     * @throws IceBox::FailureException Raised if {@link #start} failed.
     */
    virtual void start(const ::std::string& name, const ::std::shared_ptr<::Ice::Communicator>& communicator, const ::Ice::StringSeq& args) = 0;

    /**
     * Stop the service.
     */
    virtual void stop() = 0;
};

}

namespace IceBox
{

/**
 * An Observer interface implemented by admin clients interested in the status
 * of services.
 * @see ServiceManager
 * \headerfile IceBox/IceBox.h
 */
class ICEBOX_API ServiceObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = ServiceObserverPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Receives the names of the services that were started.
     * @param services The names of the services.
     * @param current The Current object for the invocation.
     */
    virtual void servicesStarted(::Ice::StringSeq services, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_servicesStarted(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Receives the names of the services that were stopped.
     * @param services The names of the services.
     * @param current The Current object for the invocation.
     */
    virtual void servicesStopped(::Ice::StringSeq services, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_servicesStopped(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * Administers a set of {@link Service} instances.
 * @see Service
 * \headerfile IceBox/IceBox.h
 */
class ICEBOX_API ServiceManager : public virtual ::Ice::Object
{
public:

    using ProxyType = ServiceManagerPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param current The Current object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    virtual ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Start an individual service.
     * @param service The service name.
     * @param current The Current object for the invocation.
     * @throws IceBox::AlreadyStartedException If the service is already running.
     * @throws IceBox::NoSuchServiceException If no service could be found with the given name.
     */
    virtual void startService(::std::string service, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_startService(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param current The Current object for the invocation.
     * @throws IceBox::AlreadyStoppedException If the service is already stopped.
     * @throws IceBox::NoSuchServiceException If no service could be found with the given name.
     */
    virtual void stopService(::std::string service, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_stopService(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param current The Current object for the invocation.
     */
    virtual void addObserver(::std::shared_ptr<ServiceObserverPrx> observer, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_addObserver(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param current The Current object for the invocation.
     */
    virtual void shutdown(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_shutdown(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceBox
{

/**
 * An Observer interface implemented by admin clients interested in the status
 * of services.
 * @see ServiceManager
 * \headerfile IceBox/IceBox.h
 */
class ICE_CLASS(ICEBOX_API) ServiceObserverPrx : public virtual ::Ice::Proxy<ServiceObserverPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Receives the names of the services that were started.
     * @param services The names of the services.
     * @param context The Context map to send with the invocation.
     */
    void servicesStarted(const ::Ice::StringSeq& services, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServiceObserverPrx::_iceI_servicesStarted, services, context).get();
    }

    /**
     * Receives the names of the services that were started.
     * @param services The names of the services.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto servicesStartedAsync(const ::Ice::StringSeq& services, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServiceObserverPrx::_iceI_servicesStarted, services, context);
    }

    /**
     * Receives the names of the services that were started.
     * @param services The names of the services.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    servicesStartedAsync(const ::Ice::StringSeq& services,
                         ::std::function<void()> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceBox::ServiceObserverPrx::_iceI_servicesStarted, services, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEBOX_API) void _iceI_servicesStarted(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::StringSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * Receives the names of the services that were stopped.
     * @param services The names of the services.
     * @param context The Context map to send with the invocation.
     */
    void servicesStopped(const ::Ice::StringSeq& services, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServiceObserverPrx::_iceI_servicesStopped, services, context).get();
    }

    /**
     * Receives the names of the services that were stopped.
     * @param services The names of the services.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto servicesStoppedAsync(const ::Ice::StringSeq& services, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServiceObserverPrx::_iceI_servicesStopped, services, context);
    }

    /**
     * Receives the names of the services that were stopped.
     * @param services The names of the services.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    servicesStoppedAsync(const ::Ice::StringSeq& services,
                         ::std::function<void()> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceBox::ServiceObserverPrx::_iceI_servicesStopped, services, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEBOX_API) void _iceI_servicesStopped(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::StringSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ServiceObserverPrx() = default;
    friend ::std::shared_ptr<ServiceObserverPrx> IceInternal::createProxy<ServiceObserverPrx>();

    ICE_MEMBER(ICEBOX_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * Administers a set of {@link Service} instances.
 * @see Service
 * \headerfile IceBox/IceBox.h
 */
class ICE_CLASS(ICEBOX_API) ServiceManagerPrx : public virtual ::Ice::Proxy<ServiceManagerPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict>(true, this, &ServiceManagerPrx::_iceI_getSliceChecksums, context).get();
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getSliceChecksumsAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::SliceChecksumDict>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict, P>(false, this, &ServiceManagerPrx::_iceI_getSliceChecksums, context);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getSliceChecksumsAsync(::std::function<void(::Ice::SliceChecksumDict)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::SliceChecksumDict>(std::move(response), std::move(ex), std::move(sent), this, &IceBox::ServiceManagerPrx::_iceI_getSliceChecksums, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEBOX_API) void _iceI_getSliceChecksums(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::SliceChecksumDict>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Start an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @throws IceBox::AlreadyStartedException If the service is already running.
     * @throws IceBox::NoSuchServiceException If no service could be found with the given name.
     */
    void startService(const ::std::string& service, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServiceManagerPrx::_iceI_startService, service, context).get();
    }

    /**
     * Start an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto startServiceAsync(const ::std::string& service, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServiceManagerPrx::_iceI_startService, service, context);
    }

    /**
     * Start an individual service.
     * @param service The service name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    startServiceAsync(const ::std::string& service,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceBox::ServiceManagerPrx::_iceI_startService, service, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEBOX_API) void _iceI_startService(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @throws IceBox::AlreadyStoppedException If the service is already stopped.
     * @throws IceBox::NoSuchServiceException If no service could be found with the given name.
     */
    void stopService(const ::std::string& service, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServiceManagerPrx::_iceI_stopService, service, context).get();
    }

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto stopServiceAsync(const ::std::string& service, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServiceManagerPrx::_iceI_stopService, service, context);
    }

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    stopServiceAsync(const ::std::string& service,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceBox::ServiceManagerPrx::_iceI_stopService, service, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEBOX_API) void _iceI_stopService(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param context The Context map to send with the invocation.
     */
    void addObserver(const ::std::shared_ptr<ServiceObserverPrx>& observer, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServiceManagerPrx::_iceI_addObserver, observer, context).get();
    }

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto addObserverAsync(const ::std::shared_ptr<ServiceObserverPrx>& observer, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServiceManagerPrx::_iceI_addObserver, observer, context);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    addObserverAsync(const ::std::shared_ptr<ServiceObserverPrx>& observer,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceBox::ServiceManagerPrx::_iceI_addObserver, observer, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEBOX_API) void _iceI_addObserver(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<ServiceObserverPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param context The Context map to send with the invocation.
     */
    void shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServiceManagerPrx::_iceI_shutdown, context).get();
    }

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto shutdownAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServiceManagerPrx::_iceI_shutdown, context);
    }

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    shutdownAsync(::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceBox::ServiceManagerPrx::_iceI_shutdown, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEBOX_API) void _iceI_shutdown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ServiceManagerPrx() = default;
    friend ::std::shared_ptr<ServiceManagerPrx> IceInternal::createProxy<ServiceManagerPrx>();

    ICE_MEMBER(ICEBOX_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

/// \cond INTERNAL
namespace IceBox
{

using ServicePtr = ::std::shared_ptr<Service>;

using ServiceObserverPtr = ::std::shared_ptr<ServiceObserver>;
using ServiceObserverPrxPtr = ::std::shared_ptr<ServiceObserverPrx>;

using ServiceManagerPtr = ::std::shared_ptr<ServiceManager>;
using ServiceManagerPrxPtr = ::std::shared_ptr<ServiceManagerPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceBox
{

class ServiceObserver;
/// \cond INTERNAL
ICEBOX_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ServiceObserver>&);
ICEBOX_API ::IceProxy::Ice::Object* upCast(ServiceObserver*);
/// \endcond

class ServiceManager;
/// \cond INTERNAL
ICEBOX_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ServiceManager>&);
ICEBOX_API ::IceProxy::Ice::Object* upCast(ServiceManager*);
/// \endcond

}

}

namespace IceBox
{

class Service;
/// \cond INTERNAL
ICEBOX_API ::Ice::LocalObject* upCast(Service*);
/// \endcond
typedef ::IceInternal::Handle< Service> ServicePtr;

class ServiceObserver;
/// \cond INTERNAL
ICEBOX_API ::Ice::Object* upCast(ServiceObserver*);
/// \endcond
typedef ::IceInternal::Handle< ServiceObserver> ServiceObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceBox::ServiceObserver> ServiceObserverPrx;
typedef ServiceObserverPrx ServiceObserverPrxPtr;
/// \cond INTERNAL
ICEBOX_API void _icePatchObjectPtr(ServiceObserverPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ServiceManager;
/// \cond INTERNAL
ICEBOX_API ::Ice::Object* upCast(ServiceManager*);
/// \endcond
typedef ::IceInternal::Handle< ServiceManager> ServiceManagerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceBox::ServiceManager> ServiceManagerPrx;
typedef ServiceManagerPrx ServiceManagerPrxPtr;
/// \cond INTERNAL
ICEBOX_API void _icePatchObjectPtr(ServiceManagerPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceBox
{

/**
 * This exception is a general failure notification. It is thrown
 * for errors such as a service encountering an error during
 * initialization, or the service manager being unable
 * to load a service executable.
 * \headerfile IceBox/IceBox.h
 */
class ICEBOX_API FailureException : public ::Ice::LocalException
{
public:

    /**
     * The file and line number are required for all local exceptions.
     * @param file The file name in which the exception was raised, typically __FILE__.
     * @param line The line number at which the exception was raised, typically __LINE__.
     */
    FailureException(const char* file, int line);
    /**
     * One-shot constructor to initialize all data members.
     * The file and line number are required for all local exceptions.
     * @param file The file name in which the exception was raised, typically __FILE__.
     * @param line The line number at which the exception was raised, typically __LINE__.
     * @param reason The reason for the failure.
     */
    FailureException(const char* file, int line, const ::std::string& reason);
    virtual ~FailureException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Prints this exception to the given stream.
     * @param stream The target stream.
     */
    virtual void ice_print(::std::ostream& stream) const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual FailureException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * The reason for the failure.
     */
    ::std::string reason;
};

/**
 * This exception is thrown if an attempt is made to start an
 * already-started service.
 * \headerfile IceBox/IceBox.h
 */
class ICEBOX_API AlreadyStartedException : public ::Ice::UserException
{
public:

    AlreadyStartedException() {}
    virtual ~AlreadyStartedException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual AlreadyStartedException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static AlreadyStartedException _iceS_AlreadyStartedException_init;
/// \endcond

/**
 * This exception is thrown if an attempt is made to stop an
 * already-stopped service.
 * \headerfile IceBox/IceBox.h
 */
class ICEBOX_API AlreadyStoppedException : public ::Ice::UserException
{
public:

    AlreadyStoppedException() {}
    virtual ~AlreadyStoppedException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual AlreadyStoppedException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is thrown if a service name does not refer
 * to an existing service.
 * \headerfile IceBox/IceBox.h
 */
class ICEBOX_API NoSuchServiceException : public ::Ice::UserException
{
public:

    NoSuchServiceException() {}
    virtual ~NoSuchServiceException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual NoSuchServiceException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

}

namespace IceBox
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceBox::ServiceObserver::begin_servicesStarted.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceObserver_servicesStarted.
 */
class Callback_ServiceObserver_servicesStarted_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceObserver_servicesStarted_Base> Callback_ServiceObserver_servicesStartedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceBox::ServiceObserver::begin_servicesStopped.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceObserver_servicesStopped.
 */
class Callback_ServiceObserver_servicesStopped_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceObserver_servicesStopped_Base> Callback_ServiceObserver_servicesStoppedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceBox::ServiceManager::begin_getSliceChecksums.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_getSliceChecksums.
 */
class Callback_ServiceManager_getSliceChecksums_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceManager_getSliceChecksums_Base> Callback_ServiceManager_getSliceChecksumsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceBox::ServiceManager::begin_startService.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_startService.
 */
class Callback_ServiceManager_startService_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceManager_startService_Base> Callback_ServiceManager_startServicePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceBox::ServiceManager::begin_stopService.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_stopService.
 */
class Callback_ServiceManager_stopService_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceManager_stopService_Base> Callback_ServiceManager_stopServicePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceBox::ServiceManager::begin_addObserver.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_addObserver.
 */
class Callback_ServiceManager_addObserver_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceManager_addObserver_Base> Callback_ServiceManager_addObserverPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceBox::ServiceManager::begin_shutdown.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_shutdown.
 */
class Callback_ServiceManager_shutdown_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ServiceManager_shutdown_Base> Callback_ServiceManager_shutdownPtr;

}

namespace IceProxy
{

namespace IceBox
{

class ICE_CLASS(ICEBOX_API) ServiceObserver : public virtual ::Ice::Proxy<ServiceObserver, ::IceProxy::Ice::Object>
{
public:

    /**
     * Receives the names of the services that were started.
     * @param services The names of the services.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEBOX_API) void servicesStarted(const ::Ice::StringSeq& services, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_servicesStarted(_iceI_begin_servicesStarted(services, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Receives the names of the services that were started.
     * @param services The names of the services.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_servicesStarted(const ::Ice::StringSeq& services, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_servicesStarted(services, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Receives the names of the services that were started.
     * @param services The names of the services.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_servicesStarted(const ::Ice::StringSeq& services, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStarted(services, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Receives the names of the services that were started.
     * @param services The names of the services.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_servicesStarted(const ::Ice::StringSeq& services, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStarted(services, context, cb, cookie);
    }

    /**
     * Receives the names of the services that were started.
     * @param services The names of the services.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_servicesStarted(const ::Ice::StringSeq& services, const ::IceBox::Callback_ServiceObserver_servicesStartedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStarted(services, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Receives the names of the services that were started.
     * @param services The names of the services.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_servicesStarted(const ::Ice::StringSeq& services, const ::Ice::Context& context, const ::IceBox::Callback_ServiceObserver_servicesStartedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStarted(services, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_servicesStarted.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEBOX_API) void end_servicesStarted(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_servicesStarted(const ::Ice::StringSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Receives the names of the services that were stopped.
     * @param services The names of the services.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEBOX_API) void servicesStopped(const ::Ice::StringSeq& services, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_servicesStopped(_iceI_begin_servicesStopped(services, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Receives the names of the services that were stopped.
     * @param services The names of the services.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_servicesStopped(const ::Ice::StringSeq& services, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_servicesStopped(services, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Receives the names of the services that were stopped.
     * @param services The names of the services.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_servicesStopped(const ::Ice::StringSeq& services, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStopped(services, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Receives the names of the services that were stopped.
     * @param services The names of the services.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_servicesStopped(const ::Ice::StringSeq& services, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStopped(services, context, cb, cookie);
    }

    /**
     * Receives the names of the services that were stopped.
     * @param services The names of the services.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_servicesStopped(const ::Ice::StringSeq& services, const ::IceBox::Callback_ServiceObserver_servicesStoppedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStopped(services, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Receives the names of the services that were stopped.
     * @param services The names of the services.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_servicesStopped(const ::Ice::StringSeq& services, const ::Ice::Context& context, const ::IceBox::Callback_ServiceObserver_servicesStoppedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_servicesStopped(services, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_servicesStopped.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEBOX_API) void end_servicesStopped(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_servicesStopped(const ::Ice::StringSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEBOX_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEBOX_API) ServiceManager : public virtual ::Ice::Proxy<ServiceManager, ::IceProxy::Ice::Object>
{
public:

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    ICE_MEMBER(ICEBOX_API) ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSliceChecksums(_iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, cb, cookie);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::IceBox::Callback_ServiceManager_getSliceChecksumsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::IceBox::Callback_ServiceManager_getSliceChecksumsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getSliceChecksums.
     * @param result The asynchronous result object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    ICE_MEMBER(ICEBOX_API) ::Ice::SliceChecksumDict end_getSliceChecksums(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_getSliceChecksums(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Start an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @throws IceBox::AlreadyStartedException If the service is already running.
     * @throws IceBox::NoSuchServiceException If no service could be found with the given name.
     */
    ICE_MEMBER(ICEBOX_API) void startService(const ::std::string& service, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_startService(_iceI_begin_startService(service, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Start an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startService(const ::std::string& service, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_startService(service, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Start an individual service.
     * @param service The service name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startService(const ::std::string& service, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startService(service, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Start an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startService(const ::std::string& service, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startService(service, context, cb, cookie);
    }

    /**
     * Start an individual service.
     * @param service The service name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startService(const ::std::string& service, const ::IceBox::Callback_ServiceManager_startServicePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startService(service, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Start an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startService(const ::std::string& service, const ::Ice::Context& context, const ::IceBox::Callback_ServiceManager_startServicePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startService(service, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_startService.
     * @param result The asynchronous result object for the invocation.
     * @throws IceBox::AlreadyStartedException If the service is already running.
     * @throws IceBox::NoSuchServiceException If no service could be found with the given name.
     */
    ICE_MEMBER(ICEBOX_API) void end_startService(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_startService(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @throws IceBox::AlreadyStoppedException If the service is already stopped.
     * @throws IceBox::NoSuchServiceException If no service could be found with the given name.
     */
    ICE_MEMBER(ICEBOX_API) void stopService(const ::std::string& service, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_stopService(_iceI_begin_stopService(service, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopService(const ::std::string& service, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_stopService(service, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopService(const ::std::string& service, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopService(service, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopService(const ::std::string& service, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopService(service, context, cb, cookie);
    }

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopService(const ::std::string& service, const ::IceBox::Callback_ServiceManager_stopServicePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopService(service, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopService(const ::std::string& service, const ::Ice::Context& context, const ::IceBox::Callback_ServiceManager_stopServicePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopService(service, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_stopService.
     * @param result The asynchronous result object for the invocation.
     * @throws IceBox::AlreadyStoppedException If the service is already stopped.
     * @throws IceBox::NoSuchServiceException If no service could be found with the given name.
     */
    ICE_MEMBER(ICEBOX_API) void end_stopService(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_stopService(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEBOX_API) void addObserver(const ::IceBox::ServiceObserverPrx& observer, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addObserver(_iceI_begin_addObserver(observer, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObserver(const ::IceBox::ServiceObserverPrx& observer, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addObserver(observer, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObserver(const ::IceBox::ServiceObserverPrx& observer, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObserver(observer, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObserver(const ::IceBox::ServiceObserverPrx& observer, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObserver(observer, context, cb, cookie);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObserver(const ::IceBox::ServiceObserverPrx& observer, const ::IceBox::Callback_ServiceManager_addObserverPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObserver(observer, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObserver(const ::IceBox::ServiceObserverPrx& observer, const ::Ice::Context& context, const ::IceBox::Callback_ServiceManager_addObserverPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObserver(observer, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_addObserver.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEBOX_API) void end_addObserver(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_addObserver(const ::IceBox::ServiceObserverPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEBOX_API) void shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_shutdown(_iceI_begin_shutdown(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_shutdown(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(context, cb, cookie);
    }

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::IceBox::Callback_ServiceManager_shutdownPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context, const ::IceBox::Callback_ServiceManager_shutdownPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_shutdown.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEBOX_API) void end_shutdown(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEBOX_API) ::Ice::AsyncResultPtr _iceI_begin_shutdown(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEBOX_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEBOX_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceBox
{

/**
 * An application service managed by a {@link ServiceManager}.
 * \headerfile IceBox/IceBox.h
 */
class ICEBOX_API Service : public virtual ::Ice::LocalObject
{
public:

    typedef ServicePtr PointerType;

    virtual ~Service();

    /**
     * Start the service. The given communicator is created by the
     * {@link ServiceManager} for use by the service. This communicator may
     * also be used by other services, depending on the service
     * configuration.
     *
     * <p class="Note">The {@link ServiceManager} owns this communicator, and is
     * responsible for destroying it.
     * @param name The service's name, as determined by the
     * configuration.
     * @param communicator A communicator for use by the service.
     * @param args The service arguments that were not converted into
     * properties.
     * @throws IceBox::FailureException Raised if {@link #start} failed.
     */
    virtual void start(const ::std::string& name, const ::Ice::CommunicatorPtr& communicator, const ::Ice::StringSeq& args) = 0;

    /**
     * Stop the service.
     */
    virtual void stop() = 0;
};

/// \cond INTERNAL
inline bool operator==(const Service& lhs, const Service& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const Service& lhs, const Service& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}
/// \endcond

/**
 * An Observer interface implemented by admin clients interested in the status
 * of services.
 * @see ServiceManager
 * \headerfile IceBox/IceBox.h
 */
class ICEBOX_API ServiceObserver : public virtual ::Ice::Object
{
public:

    typedef ServiceObserverPrx ProxyType;
    typedef ServiceObserverPtr PointerType;

    virtual ~ServiceObserver();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Receives the names of the services that were started.
     * @param services The names of the services.
     * @param current The Current object for the invocation.
     */
    virtual void servicesStarted(const ::Ice::StringSeq& services, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_servicesStarted(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Receives the names of the services that were stopped.
     * @param services The names of the services.
     * @param current The Current object for the invocation.
     */
    virtual void servicesStopped(const ::Ice::StringSeq& services, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_servicesStopped(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const ServiceObserver& lhs, const ServiceObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ServiceObserver& lhs, const ServiceObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Administers a set of {@link Service} instances.
 * @see Service
 * \headerfile IceBox/IceBox.h
 */
class ICEBOX_API ServiceManager : public virtual ::Ice::Object
{
public:

    typedef ServiceManagerPrx ProxyType;
    typedef ServiceManagerPtr PointerType;

    virtual ~ServiceManager();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * @param current The Current object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    virtual ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Start an individual service.
     * @param service The service name.
     * @param current The Current object for the invocation.
     * @throws IceBox::AlreadyStartedException If the service is already running.
     * @throws IceBox::NoSuchServiceException If no service could be found with the given name.
     */
    virtual void startService(const ::std::string& service, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_startService(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Stop an individual service.
     * @param service The service name.
     * @param current The Current object for the invocation.
     * @throws IceBox::AlreadyStoppedException If the service is already stopped.
     * @throws IceBox::NoSuchServiceException If no service could be found with the given name.
     */
    virtual void stopService(const ::std::string& service, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_stopService(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Registers a new observer with the ServiceManager.
     * @param observer The new observer
     * @param current The Current object for the invocation.
     */
    virtual void addObserver(const ServiceObserverPrx& observer, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_addObserver(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     * @param current The Current object for the invocation.
     */
    virtual void shutdown(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_shutdown(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const ServiceManager& lhs, const ServiceManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ServiceManager& lhs, const ServiceManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IceBox::AlreadyStartedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IceBox::AlreadyStoppedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IceBox::NoSuchServiceException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}
/// \endcond

namespace IceBox
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceBox::ServiceObserver::begin_servicesStarted.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceObserver_servicesStarted.
 */
template<class T>
class CallbackNC_ServiceObserver_servicesStarted : public Callback_ServiceObserver_servicesStarted_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServiceObserver_servicesStarted(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStarted.
 */
template<class T> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStarted<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStarted.
 */
template<class T> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStarted<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStarted.
 */
template<class T> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStarted<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStarted.
 */
template<class T> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStarted<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceBox::ServiceObserver::begin_servicesStarted.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceObserver_servicesStarted.
 */
template<class T, typename CT>
class Callback_ServiceObserver_servicesStarted : public Callback_ServiceObserver_servicesStarted_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServiceObserver_servicesStarted(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStarted.
 */
template<class T, typename CT> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStarted<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStarted.
 */
template<class T, typename CT> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStarted<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStarted.
 */
template<class T, typename CT> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStarted<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStarted.
 */
template<class T, typename CT> Callback_ServiceObserver_servicesStartedPtr
newCallback_ServiceObserver_servicesStarted(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStarted<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceBox::ServiceObserver::begin_servicesStopped.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceObserver_servicesStopped.
 */
template<class T>
class CallbackNC_ServiceObserver_servicesStopped : public Callback_ServiceObserver_servicesStopped_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServiceObserver_servicesStopped(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStopped.
 */
template<class T> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStopped<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStopped.
 */
template<class T> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStopped<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStopped.
 */
template<class T> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStopped<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStopped.
 */
template<class T> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceObserver_servicesStopped<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceBox::ServiceObserver::begin_servicesStopped.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceObserver_servicesStopped.
 */
template<class T, typename CT>
class Callback_ServiceObserver_servicesStopped : public Callback_ServiceObserver_servicesStopped_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServiceObserver_servicesStopped(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStopped.
 */
template<class T, typename CT> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStopped<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStopped.
 */
template<class T, typename CT> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStopped<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStopped.
 */
template<class T, typename CT> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStopped<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceObserver::begin_servicesStopped.
 */
template<class T, typename CT> Callback_ServiceObserver_servicesStoppedPtr
newCallback_ServiceObserver_servicesStopped(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceObserver_servicesStopped<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceBox::ServiceManager::begin_getSliceChecksums.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_getSliceChecksums.
 */
template<class T>
class CallbackNC_ServiceManager_getSliceChecksums : public Callback_ServiceManager_getSliceChecksums_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::SliceChecksumDict&);

    CallbackNC_ServiceManager_getSliceChecksums(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServiceManagerPrx proxy = ServiceManagerPrx::uncheckedCast(result->getProxy());
        ::Ice::SliceChecksumDict ret;
        try
        {
            ret = proxy->end_getSliceChecksums(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_getSliceChecksums.
 */
template<class T> Callback_ServiceManager_getSliceChecksumsPtr
newCallback_ServiceManager_getSliceChecksums(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::SliceChecksumDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_getSliceChecksums<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_getSliceChecksums.
 */
template<class T> Callback_ServiceManager_getSliceChecksumsPtr
newCallback_ServiceManager_getSliceChecksums(T* instance, void (T::*cb)(const ::Ice::SliceChecksumDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_getSliceChecksums<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceBox::ServiceManager::begin_getSliceChecksums.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_getSliceChecksums.
 */
template<class T, typename CT>
class Callback_ServiceManager_getSliceChecksums : public Callback_ServiceManager_getSliceChecksums_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::SliceChecksumDict&, const CT&);

    Callback_ServiceManager_getSliceChecksums(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServiceManagerPrx proxy = ServiceManagerPrx::uncheckedCast(result->getProxy());
        ::Ice::SliceChecksumDict ret;
        try
        {
            ret = proxy->end_getSliceChecksums(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_getSliceChecksums.
 */
template<class T, typename CT> Callback_ServiceManager_getSliceChecksumsPtr
newCallback_ServiceManager_getSliceChecksums(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::SliceChecksumDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_getSliceChecksums<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_getSliceChecksums.
 */
template<class T, typename CT> Callback_ServiceManager_getSliceChecksumsPtr
newCallback_ServiceManager_getSliceChecksums(T* instance, void (T::*cb)(const ::Ice::SliceChecksumDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_getSliceChecksums<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceBox::ServiceManager::begin_startService.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_startService.
 */
template<class T>
class CallbackNC_ServiceManager_startService : public Callback_ServiceManager_startService_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServiceManager_startService(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServiceManagerPrx proxy = ServiceManagerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_startService(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_startService.
 */
template<class T> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_startService<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_startService.
 */
template<class T> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_startService<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_startService.
 */
template<class T> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_startService<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_startService.
 */
template<class T> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_startService<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceBox::ServiceManager::begin_startService.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_startService.
 */
template<class T, typename CT>
class Callback_ServiceManager_startService : public Callback_ServiceManager_startService_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServiceManager_startService(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServiceManagerPrx proxy = ServiceManagerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_startService(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_startService.
 */
template<class T, typename CT> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_startService<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_startService.
 */
template<class T, typename CT> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_startService<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_startService.
 */
template<class T, typename CT> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_startService<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_startService.
 */
template<class T, typename CT> Callback_ServiceManager_startServicePtr
newCallback_ServiceManager_startService(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_startService<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceBox::ServiceManager::begin_stopService.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_stopService.
 */
template<class T>
class CallbackNC_ServiceManager_stopService : public Callback_ServiceManager_stopService_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServiceManager_stopService(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServiceManagerPrx proxy = ServiceManagerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_stopService(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_stopService.
 */
template<class T> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_stopService<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_stopService.
 */
template<class T> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_stopService<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_stopService.
 */
template<class T> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_stopService<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_stopService.
 */
template<class T> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_stopService<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceBox::ServiceManager::begin_stopService.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_stopService.
 */
template<class T, typename CT>
class Callback_ServiceManager_stopService : public Callback_ServiceManager_stopService_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServiceManager_stopService(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServiceManagerPrx proxy = ServiceManagerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_stopService(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_stopService.
 */
template<class T, typename CT> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_stopService<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_stopService.
 */
template<class T, typename CT> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_stopService<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_stopService.
 */
template<class T, typename CT> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_stopService<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_stopService.
 */
template<class T, typename CT> Callback_ServiceManager_stopServicePtr
newCallback_ServiceManager_stopService(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_stopService<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceBox::ServiceManager::begin_addObserver.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_addObserver.
 */
template<class T>
class CallbackNC_ServiceManager_addObserver : public Callback_ServiceManager_addObserver_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServiceManager_addObserver(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_addObserver.
 */
template<class T> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_addObserver<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_addObserver.
 */
template<class T> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_addObserver<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_addObserver.
 */
template<class T> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_addObserver<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_addObserver.
 */
template<class T> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_addObserver<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceBox::ServiceManager::begin_addObserver.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_addObserver.
 */
template<class T, typename CT>
class Callback_ServiceManager_addObserver : public Callback_ServiceManager_addObserver_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServiceManager_addObserver(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_addObserver.
 */
template<class T, typename CT> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_addObserver<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_addObserver.
 */
template<class T, typename CT> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_addObserver<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_addObserver.
 */
template<class T, typename CT> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_addObserver<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_addObserver.
 */
template<class T, typename CT> Callback_ServiceManager_addObserverPtr
newCallback_ServiceManager_addObserver(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_addObserver<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceBox::ServiceManager::begin_shutdown.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_shutdown.
 */
template<class T>
class CallbackNC_ServiceManager_shutdown : public Callback_ServiceManager_shutdown_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ServiceManager_shutdown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_shutdown.
 */
template<class T> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_shutdown<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_shutdown.
 */
template<class T> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_shutdown<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_shutdown.
 */
template<class T> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_shutdown<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_shutdown.
 */
template<class T> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ServiceManager_shutdown<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceBox::ServiceManager::begin_shutdown.
 * Create a wrapper instance by calling ::IceBox::newCallback_ServiceManager_shutdown.
 */
template<class T, typename CT>
class Callback_ServiceManager_shutdown : public Callback_ServiceManager_shutdown_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ServiceManager_shutdown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_shutdown.
 */
template<class T, typename CT> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_shutdown<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_shutdown.
 */
template<class T, typename CT> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_shutdown<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_shutdown.
 */
template<class T, typename CT> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_shutdown<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceBox::ServiceManager::begin_shutdown.
 */
template<class T, typename CT> Callback_ServiceManager_shutdownPtr
newCallback_ServiceManager_shutdown(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ServiceManager_shutdown<T, CT>(instance, 0, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
