'use strict';
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
var jestDOMElementSerializer = require('pretty-format').plugins.DOMElement;
var attributesToRemovePatterns = ['ng-reflect', '_nghost', '_ngcontent', 'ng-version'];
var attributesToClean = {
    class: [/^(?:mat|cdk|ng).*-\w*\d+-\d+$/, /^ng-star-inserted$/],
    id: [/^(?:mat|cdk|ng).*-\d+$/],
    for: [/^(?:mat|cdk|ng).*-\d+$/],
    'aria-owns': [/^(?:mat|cdk|ng).*-\d+$/],
    'aria-labelledby': [/^(?:mat|cdk|ng).*-\d+$/],
    'aria-controls': [/^(?:mat|cdk|ng).*-\d+$/],
};
var hasAttributesToRemove = function (attribute) {
    return attributesToRemovePatterns
        .some(function (removePattern) { return attribute.name.startsWith(removePattern); });
};
var hasAttributesToClean = function (attribute) {
    return Object.keys(attributesToClean).some(function (removePatternKey) { return attribute.name === removePatternKey; });
};
var serialize = function (node) {
    var rest = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        rest[_i - 1] = arguments[_i];
    }
    var nodeCopy = node.cloneNode(true);
    // Remove angular-specific attributes
    Object.values(nodeCopy.attributes)
        .filter(hasAttributesToRemove)
        .forEach(function (attribute) { return nodeCopy.attributes.removeNamedItem(attribute.name); });
    // Remove angular auto-added classes
    Object.values(nodeCopy.attributes)
        .filter(hasAttributesToClean)
        .forEach(function (attribute) {
        attribute.value = attribute.value
            .split(' ')
            .filter(function (attrValue) {
            return !attributesToClean[attribute.name].some(function (attributeCleanRegex) {
                return attributeCleanRegex.test(attrValue);
            });
        })
            .join(' ');
        if (attribute.value === '') {
            nodeCopy.attributes.removeNamedItem(attribute.name);
        }
        else {
            nodeCopy.attributes.setNamedItem(attribute);
        }
    });
    return jestDOMElementSerializer.serialize.apply(jestDOMElementSerializer, __spreadArrays([nodeCopy], rest));
};
var serializeTestFn = function (val) {
    return val.attributes !== undefined && Object.values(val.attributes)
        .some(function (attribute) { return hasAttributesToRemove(attribute) || hasAttributesToClean(attribute); });
};
var test = function (val) {
    return jestDOMElementSerializer.test(val) && serializeTestFn(val);
};
module.exports = {
    serialize: serialize,
    test: test
};
