'use strict';
var printAttributes = function (val, attributes, print, indent, colors, opts) {
    return attributes
        .sort()
        .map(function (attribute) {
        return (opts.spacing +
            indent(colors.prop.open + attribute + colors.prop.close + '=') +
            colors.value.open +
            (val.componentInstance[attribute] &&
                val.componentInstance[attribute].constructor
                ? '{[Function ' +
                    val.componentInstance[attribute].constructor.name +
                    ']}'
                : "\"" + val.componentInstance[attribute] + "\"") +
            colors.value.close);
    })
        .join('');
};
var ivyEnabled = function () {
    // Should be required lazily, since it will throw an exception
    // `Cannot resolve parameters...`.
    var ɵivyEnabled = require('@angular/core').ɵivyEnabled;
    return !!ɵivyEnabled;
};
// Ivy component definition was stored on the `ngComponentDef`
// property before `9.0.0-next.10`. Since `9.0.0-next.10` it was
// renamed to `ɵcmp`.
var getComponentDef = function (type) { return type.ngComponentDef || type.ɵcmp; };
var print = function (fixture, print, indent, opts, colors) {
    var nodes = '';
    var componentAttrs = '';
    var componentName = '';
    if (ivyEnabled()) {
        var componentDef = getComponentDef(fixture.componentRef.componentType);
        componentName = componentDef.selectors[0][0];
        nodes = Array.from(fixture.componentRef.location.nativeElement.childNodes)
            .map(print)
            .join('');
    }
    else {
        componentName = fixture.componentRef._elDef.element.name;
        nodes = (fixture.componentRef._view.nodes || [])
            .filter(function (node) { return node && node.hasOwnProperty('renderElement'); })
            .map(function (node) {
            return Array.from(node.renderElement.childNodes)
                .map(print)
                .join('');
        })
            .join(opts.edgeSpacing);
    }
    var attributes = Object.keys(fixture.componentInstance);
    if (attributes.length) {
        componentAttrs += printAttributes(fixture, attributes, print, indent, colors, opts);
    }
    return ('<' +
        componentName +
        componentAttrs +
        (componentAttrs.length ? '\n' : '') +
        '>\n' +
        indent(nodes) +
        '\n</' +
        componentName +
        '>');
};
var test = function (val) {
    return val !== undefined &&
        val !== null &&
        typeof val === 'object' &&
        Object.prototype.hasOwnProperty.call(val, 'componentRef');
};
module.exports = {
    print: print,
    test: test
};
