(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/common/http'), require('@angular/core'), require('rxjs/operators'), require('ng-block-ui')) :
    typeof define === 'function' && define.amd ? define('ng-block-ui/http', ['exports', '@angular/common/http', '@angular/core', 'rxjs/operators', 'ng-block-ui'], factory) :
    (factory((global['ng-block-ui'] = global['ng-block-ui'] || {}, global['ng-block-ui'].http = {}),global.ng.common.http,global.ng.core,global.rxjs.operators,global['ng-block-ui']));
}(this, (function (exports,http,core,operators,ngBlockUi) { 'use strict';

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var BlockUIHttpSettings = (function () {
        function BlockUIHttpSettings() {
            this.settings = {};
        }
        BlockUIHttpSettings.decorators = [
            { type: core.Injectable }
        ];
        return BlockUIHttpSettings;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var BlockUIInterceptor = (function () {
        function BlockUIInterceptor(blockUIService, blockUIHttpSettings) {
            this.blockUIService = blockUIService;
            this.blockUIHttpSettings = blockUIHttpSettings;
            this.activeHttpRequests = 0;
        }
        /**
         * @param {?} request
         * @param {?} next
         * @return {?}
         */
        BlockUIInterceptor.prototype.intercept = /**
         * @param {?} request
         * @param {?} next
         * @return {?}
         */
            function (request, next) {
                var _this = this;
                var /** @type {?} */ active = false;
                if (this.shouldBlock(request)) {
                    active = true;
                    this.activeHttpRequests++;
                    this.blockUIService.start(ngBlockUi.BLOCKUI_DEFAULT);
                }
                return next.handle(request)
                    .pipe(operators.finalize(function () {
                    if (_this.shouldBlock(request)) {
                        _this.activeHttpRequests--;
                        var blockAllRequestsInProgress = _this.blockUIHttpSettings.settings.blockAllRequestsInProgress;
                        var /** @type {?} */ stopBlockUI = false;
                        if (!!blockAllRequestsInProgress && _this.activeHttpRequests <= 0) {
                            _this.activeHttpRequests = 0;
                            stopBlockUI = true;
                        }
                        else if (active) {
                            stopBlockUI = true;
                        }
                        if (stopBlockUI) {
                            var /** @type {?} */ method = blockAllRequestsInProgress ? 'stop' : 'reset';
                            _this.blockUIService[method](ngBlockUi.BLOCKUI_DEFAULT);
                        }
                    }
                }));
            };
        /**
         * @param {?} request
         * @return {?}
         */
        BlockUIInterceptor.prototype.shouldBlock = /**
         * @param {?} request
         * @return {?}
         */
            function (request) {
                var method = request.method, urlWithParams = request.urlWithParams;
                var settings = this.blockUIHttpSettings.settings;
                var /** @type {?} */ requestFilters = settings.requestFilters || [];
                return !requestFilters.some(function (f) {
                    if (f && f.method && f.url) {
                        return f.method.toUpperCase() === method && f.url.test(urlWithParams);
                    }
                    else if (typeof f === 'function') {
                        return f(request);
                    }
                    return f.test(urlWithParams);
                });
            };
        BlockUIInterceptor.decorators = [
            { type: core.Injectable }
        ];
        /** @nocollapse */
        BlockUIInterceptor.ctorParameters = function () {
            return [
                { type: ngBlockUi.BlockUIService },
                { type: BlockUIHttpSettings }
            ];
        };
        return BlockUIInterceptor;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    // Needed for AOT compiling
    var /** @type {?} */ BlockUIHttpModuleSettings = new core.InjectionToken('BlockUIHttpModuleSettings');
    /**
     * @param {?} settings
     * @return {?}
     */
    function provideSettingsInstance(settings) {
        return { settings: settings };
    }
    var BlockUIHttpModule = (function () {
        function BlockUIHttpModule() {
        }
        /**
         * @param {?=} settings
         * @return {?}
         */
        BlockUIHttpModule.forRoot = /**
         * @param {?=} settings
         * @return {?}
         */
            function (settings) {
                if (settings === void 0) {
                    settings = {};
                }
                return {
                    ngModule: BlockUIHttpModule,
                    providers: [
                        {
                            provide: BlockUIHttpModuleSettings,
                            useValue: settings
                        },
                        {
                            provide: BlockUIHttpSettings,
                            useFactory: provideSettingsInstance,
                            deps: [BlockUIHttpModuleSettings]
                        },
                        {
                            provide: http.HTTP_INTERCEPTORS,
                            useClass: BlockUIInterceptor,
                            multi: true
                        }
                    ]
                };
            };
        BlockUIHttpModule.decorators = [
            { type: core.NgModule, args: [{
                        imports: [ngBlockUi.BlockUIModule]
                    },] }
        ];
        return BlockUIHttpModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */

    exports.BlockUIHttpModule = BlockUIHttpModule;
    exports.ɵc = BlockUIHttpSettings;
    exports.ɵd = BlockUIInterceptor;
    exports.ɵa = BlockUIHttpModuleSettings;
    exports.ɵb = provideSettingsInstance;

    Object.defineProperty(exports, '__esModule', { value: true });

})));

//# sourceMappingURL=ng-block-ui-http.umd.js.map