/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Component, Input, ViewEncapsulation } from '@angular/core';
import { BlockUIInstanceService } from '../../services/block-ui-instance.service';
import { BlockUIDefaultName } from '../../constants/block-ui-default-name.constant';
export class BlockUIComponent {
    /**
     * @param {?} blockUI
     */
    constructor(blockUI) {
        this.blockUI = blockUI;
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        this.name = this.name || BlockUIDefaultName;
        this.template = this.template || this.blockUI.blockUISettings.template;
    }
}
BlockUIComponent.decorators = [
    { type: Component, args: [{
                selector: 'block-ui',
                template: `
    <ng-content></ng-content>
    <block-ui-content
      [name]="name"
      [message]="message"
      [template]="template"
      [delayStart]="delayStart"
      [delayStop]="delayStop"
    >
    </block-ui-content>
  `,
                encapsulation: ViewEncapsulation.None
            }] }
];
/** @nocollapse */
BlockUIComponent.ctorParameters = () => [
    { type: BlockUIInstanceService }
];
BlockUIComponent.propDecorators = {
    name: [{ type: Input }],
    message: [{ type: Input }],
    delayStart: [{ type: Input }],
    delayStop: [{ type: Input }],
    template: [{ type: Input }]
};
function BlockUIComponent_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIComponent.prototype.name;
    /** @type {?} */
    BlockUIComponent.prototype.message;
    /** @type {?} */
    BlockUIComponent.prototype.delayStart;
    /** @type {?} */
    BlockUIComponent.prototype.delayStop;
    /** @type {?} */
    BlockUIComponent.prototype.template;
    /** @type {?} */
    BlockUIComponent.prototype.blockUI;
}

//# sourceMappingURL=data:application/json;base64,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