/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Directive, Input, ComponentFactoryResolver, ViewContainerRef, TemplateRef, Renderer2 } from '@angular/core';
import { BlockUIContentComponent } from '../components/block-ui-content/block-ui-content.component';
import { BlockUIInstanceService } from '../services/block-ui-instance.service';
import { BlockUIDefaultName } from '../constants/block-ui-default-name.constant';
export class BlockUIDirective {
    /**
     * @param {?} blockUIService
     * @param {?} viewRef
     * @param {?} templateRef
     * @param {?} renderer
     * @param {?} componentFactoryResolver
     */
    constructor(blockUIService, viewRef, templateRef, renderer, componentFactoryResolver) {
        this.blockUIService = blockUIService;
        this.viewRef = viewRef;
        this.templateRef = templateRef;
        this.renderer = renderer;
        this.componentFactoryResolver = componentFactoryResolver;
    }
    /**
     * @param {?} name
     * @return {?}
     */
    set blockUI(name) { this.blockTarget = name; }
    ;
    /**
     * @param {?} message
     * @return {?}
     */
    set blockUIMessage(message) { this.message = message; }
    ;
    /**
     * @param {?} template
     * @return {?}
     */
    set blockUITemplate(template) { this.template = template; }
    ;
    /**
     * @param {?} delayStart
     * @return {?}
     */
    set blockUIDelayStart(delayStart) {
        this.delayStart = delayStart ? Number(delayStart) : null;
    }
    ;
    /**
     * @param {?} delayStop
     * @return {?}
     */
    set blockUIDelayStop(delayStop) {
        this.delayStop = delayStop ? Number(delayStop) : null;
    }
    ;
    /**
     * @return {?}
     */
    ngOnInit() {
        try {
            this.viewRef.createEmbeddedView(this.templateRef);
            const /** @type {?} */ parentElement = this.viewRef.element.nativeElement.nextSibling;
            if (parentElement && !this.isComponentInTemplate(parentElement)) {
                this.renderer.addClass(parentElement, 'block-ui__element');
                this.blockUIComponentRef = this.createComponent();
                let /** @type {?} */ blockUIContent = this.findContentNode(this.viewRef.element.nativeElement);
                if (blockUIContent) {
                    const /** @type {?} */ settings = this.blockUIService.getSettings();
                    parentElement.appendChild(blockUIContent);
                    this.blockUIComponentRef.instance.className = 'block-ui-wrapper--element';
                    this.blockUIComponentRef.instance.name = this.blockTarget || BlockUIDefaultName;
                    if (this.message)
                        this.blockUIComponentRef.instance.defaultMessage = this.message;
                    if (this.delayStart)
                        this.blockUIComponentRef.instance.delayStart = this.delayStart;
                    if (this.delayStop)
                        this.blockUIComponentRef.instance.delayStop = this.delayStop;
                    if (this.template || settings.template)
                        this.blockUIComponentRef.instance.templateCmp = this.template || settings.template;
                }
            }
        }
        catch (/** @type {?} */ error) {
            console.error('ng-block-ui:', error);
        }
    }
    /**
     * @param {?} element
     * @return {?}
     */
    isComponentInTemplate(element) {
        let { children } = element || [];
        children = Array.from(children).reverse();
        return children.some((el) => el.localName === 'block-ui');
    }
    /**
     * @param {?} element
     * @return {?}
     */
    findContentNode(element) {
        const { nextSibling } = element;
        return [nextSibling, nextSibling.nextSibling].find((e) => e.localName === 'block-ui-content');
    }
    /**
     * @return {?}
     */
    createComponent() {
        const /** @type {?} */ resolvedBlockUIComponent = this.componentFactoryResolver.resolveComponentFactory(BlockUIContentComponent);
        return this.viewRef.createComponent(resolvedBlockUIComponent);
    }
}
BlockUIDirective.decorators = [
    { type: Directive, args: [{ selector: '[blockUI]' },] }
];
/** @nocollapse */
BlockUIDirective.ctorParameters = () => [
    { type: BlockUIInstanceService },
    { type: ViewContainerRef },
    { type: TemplateRef },
    { type: Renderer2 },
    { type: ComponentFactoryResolver }
];
BlockUIDirective.propDecorators = {
    blockUI: [{ type: Input }],
    blockUIMessage: [{ type: Input }],
    blockUITemplate: [{ type: Input }],
    blockUIDelayStart: [{ type: Input }],
    blockUIDelayStop: [{ type: Input }]
};
function BlockUIDirective_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIDirective.prototype.blockUIComponentRef;
    /** @type {?} */
    BlockUIDirective.prototype.blockTarget;
    /** @type {?} */
    BlockUIDirective.prototype.message;
    /** @type {?} */
    BlockUIDirective.prototype.template;
    /** @type {?} */
    BlockUIDirective.prototype.delayStart;
    /** @type {?} */
    BlockUIDirective.prototype.delayStop;
    /** @type {?} */
    BlockUIDirective.prototype.blockUIService;
    /** @type {?} */
    BlockUIDirective.prototype.viewRef;
    /** @type {?} */
    BlockUIDirective.prototype.templateRef;
    /** @type {?} */
    BlockUIDirective.prototype.renderer;
    /** @type {?} */
    BlockUIDirective.prototype.componentFactoryResolver;
}

//# sourceMappingURL=data:application/json;base64,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