/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Injectable } from '@angular/core';
import { finalize } from 'rxjs/operators';
import { BlockUIService, BLOCKUI_DEFAULT } from 'ng-block-ui';
import { BlockUIHttpSettings } from './block-ui-http-settings.service';
export class BlockUIInterceptor {
    /**
     * @param {?} blockUIService
     * @param {?} blockUIHttpSettings
     */
    constructor(blockUIService, blockUIHttpSettings) {
        this.blockUIService = blockUIService;
        this.blockUIHttpSettings = blockUIHttpSettings;
        this.activeHttpRequests = 0;
    }
    /**
     * @param {?} request
     * @param {?} next
     * @return {?}
     */
    intercept(request, next) {
        let /** @type {?} */ active = false;
        if (this.shouldBlock(request)) {
            active = true;
            this.activeHttpRequests++;
            this.blockUIService.start(BLOCKUI_DEFAULT);
        }
        return next.handle(request)
            .pipe(finalize(() => {
            if (this.shouldBlock(request)) {
                this.activeHttpRequests--;
                const { blockAllRequestsInProgress } = this.blockUIHttpSettings.settings;
                let /** @type {?} */ stopBlockUI = false;
                if (!!blockAllRequestsInProgress && this.activeHttpRequests <= 0) {
                    this.activeHttpRequests = 0;
                    stopBlockUI = true;
                }
                else if (active) {
                    stopBlockUI = true;
                }
                if (stopBlockUI) {
                    const /** @type {?} */ method = blockAllRequestsInProgress ? 'stop' : 'reset';
                    this.blockUIService[method](BLOCKUI_DEFAULT);
                }
            }
        }));
    }
    /**
     * @param {?} request
     * @return {?}
     */
    shouldBlock(request) {
        const { method, urlWithParams } = request;
        const { settings } = this.blockUIHttpSettings;
        const /** @type {?} */ requestFilters = settings.requestFilters || [];
        return !requestFilters.some((f) => {
            if (f && f.method && f.url) {
                return f.method.toUpperCase() === method && f.url.test(urlWithParams);
            }
            else if (typeof f === 'function') {
                return f(request);
            }
            return f.test(urlWithParams);
        });
    }
}
BlockUIInterceptor.decorators = [
    { type: Injectable }
];
/** @nocollapse */
BlockUIInterceptor.ctorParameters = () => [
    { type: BlockUIService },
    { type: BlockUIHttpSettings }
];
function BlockUIInterceptor_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIInterceptor.prototype.activeHttpRequests;
    /** @type {?} */
    BlockUIInterceptor.prototype.blockUIService;
    /** @type {?} */
    BlockUIInterceptor.prototype.blockUIHttpSettings;
}

//# sourceMappingURL=data:application/json;base64,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