/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Injectable } from '@angular/core';
import { BlockUIActions } from '../constants/block-ui-actions.constant';
import { BlockUIInstanceService } from './block-ui-instance.service';
export class BlockUIService {
    /**
     * @param {?} blockUIInstance
     */
    constructor(blockUIInstance) {
        this.blockUIInstance = blockUIInstance;
    }
    /**
     * Starts blocking for given BlockUI instance or instances
     * @param {?} target
     * @param {?=} message
     * @return {?}
     */
    start(target, message) {
        this.dispatch(target, BlockUIActions.START, message);
    }
    /**
     * Stops blocking for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    stop(target) {
        this.dispatch(target, BlockUIActions.STOP);
    }
    /**
     * Reset blocking for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    reset(target) {
        this.dispatch(target, BlockUIActions.RESET);
    }
    /**
     * Unsubscribes for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    unsubscribe(target) {
        this.dispatch(target, BlockUIActions.UNSUBSCRIBE);
    }
    /**
     * Checks if BlockUI is actively blocking
     * @param {?=} target
     * @return {?}
     */
    isActive(target = null) {
        const /** @type {?} */ targets = target ? this.toArray(target) : null;
        const /** @type {?} */ instances = this.blockUIInstance.blockUIInstances;
        return Object.keys(instances).some((key) => {
            if (!targets) {
                return instances[key].isActive;
            }
            return targets.indexOf(instances[key].name) >= 0 && instances[key].isActive;
        });
    }
    /**
     * @param {?=} target
     * @param {?=} type
     * @param {?=} message
     * @return {?}
     */
    dispatch(target = [], type, message) {
        const /** @type {?} */ instances = this.toArray(target);
        instances.forEach(i => this.blockUIInstance.decorate(i)[type](message));
    }
    /**
     * @param {?=} target
     * @return {?}
     */
    toArray(target = []) {
        return typeof target === 'string' ? [target] : target;
    }
}
BlockUIService.decorators = [
    { type: Injectable }
];
/** @nocollapse */
BlockUIService.ctorParameters = () => [
    { type: BlockUIInstanceService }
];
function BlockUIService_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIService.prototype.blockUIInstance;
}

//# sourceMappingURL=data:application/json;base64,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