/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Component, ViewEncapsulation, Input, ViewChild, ComponentRef, TemplateRef, ComponentFactoryResolver, ViewContainerRef, ChangeDetectorRef } from '@angular/core';
import { BlockUIInstanceService } from '../../services/block-ui-instance.service';
import { BlockUIActions } from '../../constants/block-ui-actions.constant';
import { BlockUIDefaultName } from '../../constants/block-ui-default-name.constant';
import { styles } from './block-ui-content.component.style';
import { template } from './block-ui-content.component.template';
var BlockUIContentComponent = /** @class */ (function () {
    function BlockUIContentComponent(blockUI, resolver, changeDetectionRef) {
        this.blockUI = blockUI;
        this.resolver = resolver;
        this.changeDetectionRef = changeDetectionRef;
        this.name = BlockUIDefaultName;
        this.delayStart = 0;
        this.delayStop = 0;
        this.state = { startTimeout: null, stopTimeout: null, blockCount: 0 };
        this.active = false;
    }
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        this.settings = this.blockUI.getSettings();
        this.blockUISubscription = this.subscribeToBlockUI(this.blockUI.observe());
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngAfterViewInit = /**
     * @return {?}
     */
    function () {
        try {
            if (!this.templateCmp) {
                return false;
            }
            if (this.templateCmp instanceof TemplateRef) {
                this.templateOutlet.createEmbeddedView(this.templateCmp);
            }
            else {
                var /** @type {?} */ templateComp = this.resolver.resolveComponentFactory(this.templateCmp);
                this.templateCompRef = this.templateOutlet.createComponent(templateComp);
                this.updateBlockTemplate(this.message);
            }
        }
        catch (/** @type {?} */ error) {
            console.error('ng-block-ui:', error);
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngAfterViewChecked = /**
     * @return {?}
     */
    function () {
        this.detectChanges();
    };
    /**
     * @param {?} blockUI$
     * @return {?}
     */
    BlockUIContentComponent.prototype.subscribeToBlockUI = /**
     * @param {?} blockUI$
     * @return {?}
     */
    function (blockUI$) {
        var _this = this;
        return blockUI$
            .subscribe(function (event) { return _this.onDispatchedEvent(event); });
    };
    /**
     * @param {?} event
     * @return {?}
     */
    BlockUIContentComponent.prototype.onDispatchedEvent = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        switch (event.action) {
            case (BlockUIActions.START):
                this.onStart(event);
                break;
            case (BlockUIActions.STOP):
                this.onStop(event);
                break;
            case (BlockUIActions.UPDATE):
                this.onUpdate(event);
                break;
            case (BlockUIActions.RESET):
                this.onReset();
                break;
            case (BlockUIActions.UNSUBSCRIBE):
                this.onStop(event);
                this.onUnsubscribe(event.name);
                break;
        }
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIContentComponent.prototype.onStart = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var name = _a.name, message = _a.message;
        if (name === this.name) {
            var /** @type {?} */ delay = this.delayStart || this.settings.delayStart || 0;
            if (this.state.startTimeout === null) {
                if (delay === 0) {
                    this.showBlock(message);
                }
                else {
                    this.state.startTimeout = setTimeout(function () {
                        _this.showBlock(message);
                    }, delay);
                }
            }
            this.state.blockCount++;
            this.updateInstanceBlockCount();
        }
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIContentComponent.prototype.onStop = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var name = _a.name;
        if (name === this.name) {
            var /** @type {?} */ delay = this.delayStop || this.settings.delayStop || 0;
            if (this.state.blockCount > 1) {
                this.state.blockCount--;
            }
            else {
                if (!this.active) {
                    this.clearState();
                }
                else {
                    if (this.state.stopTimeout === null) {
                        if (delay === 0) {
                            this.hideBlock();
                        }
                        else {
                            this.state.stopTimeout = setTimeout(function () {
                                _this.hideBlock();
                            }, delay);
                        }
                    }
                }
            }
            this.updateInstanceBlockCount();
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.onReset = /**
     * @return {?}
     */
    function () {
        this.hideBlock();
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIContentComponent.prototype.onUpdate = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var name = _a.name, message = _a.message;
        if (name === this.name) {
            var /** @type {?} */ delay = this.delayStart || this.settings.delayStart || 0;
            if (delay === 0) {
                this.updateMessage(message);
            }
            else {
                setTimeout(function () {
                    _this.updateMessage(message);
                }, delay);
            }
        }
    };
    /**
     * @param {?} message
     * @return {?}
     */
    BlockUIContentComponent.prototype.updateMessage = /**
     * @param {?} message
     * @return {?}
     */
    function (message) {
        this.message = message || this.defaultMessage || this.settings.message;
        this.updateBlockTemplate(this.message);
        this.detectChanges();
    };
    /**
     * @param {?} message
     * @return {?}
     */
    BlockUIContentComponent.prototype.showBlock = /**
     * @param {?} message
     * @return {?}
     */
    function (message) {
        this.active = true;
        this.message = message || this.defaultMessage || this.settings.message;
        this.updateBlockTemplate(this.message);
        this.detectChanges();
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.hideBlock = /**
     * @return {?}
     */
    function () {
        this.clearState();
        this.active = false;
        this.detectChanges();
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.clearState = /**
     * @return {?}
     */
    function () {
        this.state.startTimeout != null && clearTimeout(this.state.startTimeout);
        this.state.stopTimeout != null && clearTimeout(this.state.stopTimeout);
        this.state.blockCount = 0;
        this.state.startTimeout = null;
        this.state.stopTimeout = null;
        this.updateInstanceBlockCount();
    };
    /**
     * @param {?} msg
     * @return {?}
     */
    BlockUIContentComponent.prototype.updateBlockTemplate = /**
     * @param {?} msg
     * @return {?}
     */
    function (msg) {
        if (this.templateCompRef && this.templateCompRef instanceof ComponentRef) {
            this.templateCompRef.instance.message = msg;
        }
    };
    /**
     * @param {?} name
     * @return {?}
     */
    BlockUIContentComponent.prototype.onUnsubscribe = /**
     * @param {?} name
     * @return {?}
     */
    function (name) {
        if (this.blockUISubscription && name === this.name) {
            this.blockUISubscription.unsubscribe();
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.updateInstanceBlockCount = /**
     * @return {?}
     */
    function () {
        if (this.blockUI.blockUIInstances[this.name]) {
            this.blockUI.blockUIInstances[this.name].blockCount = this.state.blockCount;
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.detectChanges = /**
     * @return {?}
     */
    function () {
        if (!this.changeDetectionRef['destroyed']) {
            this.changeDetectionRef.detectChanges();
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        this.onUnsubscribe(this.name);
    };
    BlockUIContentComponent.decorators = [
        { type: Component, args: [{
                    selector: 'block-ui-content',
                    template: template,
                    // TODO: Find how to bundle styles for npm
                    encapsulation: ViewEncapsulation.None,
                    styles: [styles]
                }] }
    ];
    /** @nocollapse */
    BlockUIContentComponent.ctorParameters = function () { return [
        { type: BlockUIInstanceService },
        { type: ComponentFactoryResolver },
        { type: ChangeDetectorRef }
    ]; };
    BlockUIContentComponent.propDecorators = {
        name: [{ type: Input }],
        delayStart: [{ type: Input }],
        delayStop: [{ type: Input }],
        defaultMessage: [{ type: Input, args: ['message',] }],
        templateCmp: [{ type: Input, args: ['template',] }],
        templateOutlet: [{ type: ViewChild, args: ['templateOutlet', { read: ViewContainerRef },] }]
    };
    return BlockUIContentComponent;
}());
export { BlockUIContentComponent };
function BlockUIContentComponent_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIContentComponent.prototype.name;
    /** @type {?} */
    BlockUIContentComponent.prototype.delayStart;
    /** @type {?} */
    BlockUIContentComponent.prototype.delayStop;
    /** @type {?} */
    BlockUIContentComponent.prototype.defaultMessage;
    /** @type {?} */
    BlockUIContentComponent.prototype.templateCmp;
    /** @type {?} */
    BlockUIContentComponent.prototype.templateOutlet;
    /** @type {?} */
    BlockUIContentComponent.prototype.state;
    /** @type {?} */
    BlockUIContentComponent.prototype.className;
    /** @type {?} */
    BlockUIContentComponent.prototype.active;
    /** @type {?} */
    BlockUIContentComponent.prototype.templateCompRef;
    /** @type {?} */
    BlockUIContentComponent.prototype.message;
    /** @type {?} */
    BlockUIContentComponent.prototype.blockUISubscription;
    /** @type {?} */
    BlockUIContentComponent.prototype.settings;
    /** @type {?} */
    BlockUIContentComponent.prototype.blockUI;
    /** @type {?} */
    BlockUIContentComponent.prototype.resolver;
    /** @type {?} */
    BlockUIContentComponent.prototype.changeDetectionRef;
}

//# sourceMappingURL=data:application/json;base64,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