/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Component, Input, ViewEncapsulation } from '@angular/core';
import { BlockUIInstanceService } from '../../services/block-ui-instance.service';
import { BlockUIDefaultName } from '../../constants/block-ui-default-name.constant';
var BlockUIComponent = /** @class */ (function () {
    function BlockUIComponent(blockUI) {
        this.blockUI = blockUI;
    }
    /**
     * @return {?}
     */
    BlockUIComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        this.name = this.name || BlockUIDefaultName;
        this.template = this.template || this.blockUI.blockUISettings.template;
    };
    BlockUIComponent.decorators = [
        { type: Component, args: [{
                    selector: 'block-ui',
                    template: "\n    <ng-content></ng-content>\n    <block-ui-content\n      [name]=\"name\"\n      [message]=\"message\"\n      [template]=\"template\"\n      [delayStart]=\"delayStart\"\n      [delayStop]=\"delayStop\"\n    >\n    </block-ui-content>\n  ",
                    encapsulation: ViewEncapsulation.None
                }] }
    ];
    /** @nocollapse */
    BlockUIComponent.ctorParameters = function () { return [
        { type: BlockUIInstanceService }
    ]; };
    BlockUIComponent.propDecorators = {
        name: [{ type: Input }],
        message: [{ type: Input }],
        delayStart: [{ type: Input }],
        delayStop: [{ type: Input }],
        template: [{ type: Input }]
    };
    return BlockUIComponent;
}());
export { BlockUIComponent };
function BlockUIComponent_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIComponent.prototype.name;
    /** @type {?} */
    BlockUIComponent.prototype.message;
    /** @type {?} */
    BlockUIComponent.prototype.delayStart;
    /** @type {?} */
    BlockUIComponent.prototype.delayStop;
    /** @type {?} */
    BlockUIComponent.prototype.template;
    /** @type {?} */
    BlockUIComponent.prototype.blockUI;
}

//# sourceMappingURL=data:application/json;base64,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