/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Injectable } from '@angular/core';
import { finalize } from 'rxjs/operators';
import { BlockUIService, BLOCKUI_DEFAULT } from 'ng-block-ui';
import { BlockUIHttpSettings } from './block-ui-http-settings.service';
var BlockUIInterceptor = /** @class */ (function () {
    function BlockUIInterceptor(blockUIService, blockUIHttpSettings) {
        this.blockUIService = blockUIService;
        this.blockUIHttpSettings = blockUIHttpSettings;
        this.activeHttpRequests = 0;
    }
    /**
     * @param {?} request
     * @param {?} next
     * @return {?}
     */
    BlockUIInterceptor.prototype.intercept = /**
     * @param {?} request
     * @param {?} next
     * @return {?}
     */
    function (request, next) {
        var _this = this;
        var /** @type {?} */ active = false;
        if (this.shouldBlock(request)) {
            active = true;
            this.activeHttpRequests++;
            this.blockUIService.start(BLOCKUI_DEFAULT);
        }
        return next.handle(request)
            .pipe(finalize(function () {
            if (_this.shouldBlock(request)) {
                _this.activeHttpRequests--;
                var blockAllRequestsInProgress = _this.blockUIHttpSettings.settings.blockAllRequestsInProgress;
                var /** @type {?} */ stopBlockUI = false;
                if (!!blockAllRequestsInProgress && _this.activeHttpRequests <= 0) {
                    _this.activeHttpRequests = 0;
                    stopBlockUI = true;
                }
                else if (active) {
                    stopBlockUI = true;
                }
                if (stopBlockUI) {
                    var /** @type {?} */ method = blockAllRequestsInProgress ? 'stop' : 'reset';
                    _this.blockUIService[method](BLOCKUI_DEFAULT);
                }
            }
        }));
    };
    /**
     * @param {?} request
     * @return {?}
     */
    BlockUIInterceptor.prototype.shouldBlock = /**
     * @param {?} request
     * @return {?}
     */
    function (request) {
        var method = request.method, urlWithParams = request.urlWithParams;
        var settings = this.blockUIHttpSettings.settings;
        var /** @type {?} */ requestFilters = settings.requestFilters || [];
        return !requestFilters.some(function (f) {
            if (f && f.method && f.url) {
                return f.method.toUpperCase() === method && f.url.test(urlWithParams);
            }
            else if (typeof f === 'function') {
                return f(request);
            }
            return f.test(urlWithParams);
        });
    };
    BlockUIInterceptor.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    BlockUIInterceptor.ctorParameters = function () { return [
        { type: BlockUIService },
        { type: BlockUIHttpSettings }
    ]; };
    return BlockUIInterceptor;
}());
export { BlockUIInterceptor };
function BlockUIInterceptor_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIInterceptor.prototype.activeHttpRequests;
    /** @type {?} */
    BlockUIInterceptor.prototype.blockUIService;
    /** @type {?} */
    BlockUIInterceptor.prototype.blockUIHttpSettings;
}

//# sourceMappingURL=data:application/json;base64,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