import { HTTP_INTERCEPTORS } from '@angular/common/http';
import { Injectable, NgModule, InjectionToken } from '@angular/core';
import { finalize } from 'rxjs/operators';
import { BlockUIService, BLOCKUI_DEFAULT, BlockUIModule } from 'ng-block-ui';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
class BlockUIHttpSettings {
    constructor() {
        this.settings = {};
    }
}
BlockUIHttpSettings.decorators = [
    { type: Injectable }
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
class BlockUIInterceptor {
    /**
     * @param {?} blockUIService
     * @param {?} blockUIHttpSettings
     */
    constructor(blockUIService, blockUIHttpSettings) {
        this.blockUIService = blockUIService;
        this.blockUIHttpSettings = blockUIHttpSettings;
        this.activeHttpRequests = 0;
    }
    /**
     * @param {?} request
     * @param {?} next
     * @return {?}
     */
    intercept(request, next) {
        let /** @type {?} */ active = false;
        if (this.shouldBlock(request)) {
            active = true;
            this.activeHttpRequests++;
            this.blockUIService.start(BLOCKUI_DEFAULT);
        }
        return next.handle(request)
            .pipe(finalize(() => {
            if (this.shouldBlock(request)) {
                this.activeHttpRequests--;
                const { blockAllRequestsInProgress } = this.blockUIHttpSettings.settings;
                let /** @type {?} */ stopBlockUI = false;
                if (!!blockAllRequestsInProgress && this.activeHttpRequests <= 0) {
                    this.activeHttpRequests = 0;
                    stopBlockUI = true;
                }
                else if (active) {
                    stopBlockUI = true;
                }
                if (stopBlockUI) {
                    const /** @type {?} */ method = blockAllRequestsInProgress ? 'stop' : 'reset';
                    this.blockUIService[method](BLOCKUI_DEFAULT);
                }
            }
        }));
    }
    /**
     * @param {?} request
     * @return {?}
     */
    shouldBlock(request) {
        const { method, urlWithParams } = request;
        const { settings } = this.blockUIHttpSettings;
        const /** @type {?} */ requestFilters = settings.requestFilters || [];
        return !requestFilters.some((f) => {
            if (f && f.method && f.url) {
                return f.method.toUpperCase() === method && f.url.test(urlWithParams);
            }
            else if (typeof f === 'function') {
                return f(request);
            }
            return f.test(urlWithParams);
        });
    }
}
BlockUIInterceptor.decorators = [
    { type: Injectable }
];
/** @nocollapse */
BlockUIInterceptor.ctorParameters = () => [
    { type: BlockUIService },
    { type: BlockUIHttpSettings }
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
// Needed for AOT compiling
const /** @type {?} */ BlockUIHttpModuleSettings = new InjectionToken('BlockUIHttpModuleSettings');
/**
 * @param {?} settings
 * @return {?}
 */
function provideSettingsInstance(settings) {
    return { settings };
}
class BlockUIHttpModule {
    /**
     * @param {?=} settings
     * @return {?}
     */
    static forRoot(settings = {}) {
        return {
            ngModule: BlockUIHttpModule,
            providers: [
                {
                    provide: BlockUIHttpModuleSettings,
                    useValue: settings
                },
                {
                    provide: BlockUIHttpSettings,
                    useFactory: provideSettingsInstance,
                    deps: [BlockUIHttpModuleSettings]
                },
                {
                    provide: HTTP_INTERCEPTORS,
                    useClass: BlockUIInterceptor,
                    multi: true
                }
            ]
        };
    }
}
BlockUIHttpModule.decorators = [
    { type: NgModule, args: [{
                imports: [BlockUIModule]
            },] }
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

export { BlockUIHttpModule, BlockUIHttpSettings as ɵc, BlockUIInterceptor as ɵd, BlockUIHttpModuleSettings as ɵa, provideSettingsInstance as ɵb };

//# sourceMappingURL=ng-block-ui-http.js.map