import { Injectable, NgModule } from '@angular/core';
import { BlockUIService, BLOCKUI_DEFAULT, BlockUIModule } from 'ng-block-ui';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
class BlockUIPreventNavigation {
    /**
     * @param {?} blockUIService
     */
    constructor(blockUIService) {
        this.blockUIService = blockUIService;
    }
    /**
     * @return {?}
     */
    canActivate() {
        return !this.blockUIService.isActive(BLOCKUI_DEFAULT);
    }
    /**
     * @return {?}
     */
    canActivateChild() {
        return !this.blockUIService.isActive(BLOCKUI_DEFAULT);
    }
}
BlockUIPreventNavigation.decorators = [
    { type: Injectable }
];
/** @nocollapse */
BlockUIPreventNavigation.ctorParameters = () => [
    { type: BlockUIService }
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
class BlockUIRouterModule {
    /**
     * @return {?}
     */
    static forRoot() {
        return {
            ngModule: BlockUIRouterModule,
            providers: [
                BlockUIPreventNavigation
            ]
        };
    }
}
BlockUIRouterModule.decorators = [
    { type: NgModule, args: [{
                imports: [
                    BlockUIModule
                ]
            },] }
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

export { BlockUIRouterModule, BlockUIPreventNavigation };

//# sourceMappingURL=ng-block-ui-router.js.map