import { HTTP_INTERCEPTORS } from '@angular/common/http';
import { Injectable, NgModule, InjectionToken } from '@angular/core';
import { finalize } from 'rxjs/operators';
import { BlockUIService, BLOCKUI_DEFAULT, BlockUIModule } from 'ng-block-ui';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIHttpSettings = /** @class */ (function () {
    function BlockUIHttpSettings() {
        this.settings = {};
    }
    BlockUIHttpSettings.decorators = [
        { type: Injectable }
    ];
    return BlockUIHttpSettings;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIInterceptor = /** @class */ (function () {
    function BlockUIInterceptor(blockUIService, blockUIHttpSettings) {
        this.blockUIService = blockUIService;
        this.blockUIHttpSettings = blockUIHttpSettings;
        this.activeHttpRequests = 0;
    }
    /**
     * @param {?} request
     * @param {?} next
     * @return {?}
     */
    BlockUIInterceptor.prototype.intercept = /**
     * @param {?} request
     * @param {?} next
     * @return {?}
     */
    function (request, next) {
        var _this = this;
        var /** @type {?} */ active = false;
        if (this.shouldBlock(request)) {
            active = true;
            this.activeHttpRequests++;
            this.blockUIService.start(BLOCKUI_DEFAULT);
        }
        return next.handle(request)
            .pipe(finalize(function () {
            if (_this.shouldBlock(request)) {
                _this.activeHttpRequests--;
                var blockAllRequestsInProgress = _this.blockUIHttpSettings.settings.blockAllRequestsInProgress;
                var /** @type {?} */ stopBlockUI = false;
                if (!!blockAllRequestsInProgress && _this.activeHttpRequests <= 0) {
                    _this.activeHttpRequests = 0;
                    stopBlockUI = true;
                }
                else if (active) {
                    stopBlockUI = true;
                }
                if (stopBlockUI) {
                    var /** @type {?} */ method = blockAllRequestsInProgress ? 'stop' : 'reset';
                    _this.blockUIService[method](BLOCKUI_DEFAULT);
                }
            }
        }));
    };
    /**
     * @param {?} request
     * @return {?}
     */
    BlockUIInterceptor.prototype.shouldBlock = /**
     * @param {?} request
     * @return {?}
     */
    function (request) {
        var method = request.method, urlWithParams = request.urlWithParams;
        var settings = this.blockUIHttpSettings.settings;
        var /** @type {?} */ requestFilters = settings.requestFilters || [];
        return !requestFilters.some(function (f) {
            if (f && f.method && f.url) {
                return f.method.toUpperCase() === method && f.url.test(urlWithParams);
            }
            else if (typeof f === 'function') {
                return f(request);
            }
            return f.test(urlWithParams);
        });
    };
    BlockUIInterceptor.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    BlockUIInterceptor.ctorParameters = function () { return [
        { type: BlockUIService },
        { type: BlockUIHttpSettings }
    ]; };
    return BlockUIInterceptor;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
// Needed for AOT compiling
var /** @type {?} */ BlockUIHttpModuleSettings = new InjectionToken('BlockUIHttpModuleSettings');
/**
 * @param {?} settings
 * @return {?}
 */
function provideSettingsInstance(settings) {
    return { settings: settings };
}
var BlockUIHttpModule = /** @class */ (function () {
    function BlockUIHttpModule() {
    }
    /**
     * @param {?=} settings
     * @return {?}
     */
    BlockUIHttpModule.forRoot = /**
     * @param {?=} settings
     * @return {?}
     */
    function (settings) {
        if (settings === void 0) { settings = {}; }
        return {
            ngModule: BlockUIHttpModule,
            providers: [
                {
                    provide: BlockUIHttpModuleSettings,
                    useValue: settings
                },
                {
                    provide: BlockUIHttpSettings,
                    useFactory: provideSettingsInstance,
                    deps: [BlockUIHttpModuleSettings]
                },
                {
                    provide: HTTP_INTERCEPTORS,
                    useClass: BlockUIInterceptor,
                    multi: true
                }
            ]
        };
    };
    BlockUIHttpModule.decorators = [
        { type: NgModule, args: [{
                    imports: [BlockUIModule]
                },] }
    ];
    return BlockUIHttpModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

export { BlockUIHttpModule, BlockUIHttpSettings as ɵc, BlockUIInterceptor as ɵd, BlockUIHttpModuleSettings as ɵa, provideSettingsInstance as ɵb };

//# sourceMappingURL=ng-block-ui-http.js.map