import { CommonModule } from '@angular/common';
import { __assign } from 'tslib';
import { ReplaySubject } from 'rxjs';
import { Injectable, Component, Input, ViewEncapsulation, ViewChild, ComponentRef, TemplateRef, ComponentFactoryResolver, ViewContainerRef, ChangeDetectorRef, Directive, Renderer2, NgModule, InjectionToken } from '@angular/core';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIActions = /** @class */ (function () {
    function BlockUIActions() {
    }
    BlockUIActions.START = 'start';
    BlockUIActions.STOP = 'stop';
    BlockUIActions.UPDATE = 'update';
    BlockUIActions.RESET = 'reset';
    BlockUIActions.UNSUBSCRIBE = 'unsubscribe';
    return BlockUIActions;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var /** @type {?} */ BlockUIDefaultName = "block-ui-main";

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIInstanceService = /** @class */ (function () {
    function BlockUIInstanceService() {
        this.blockUISettings = {};
        this.blockUIInstances = {};
        this.blockUISubject = new ReplaySubject();
        this.blockUIObservable = this.blockUISubject.asObservable();
        this.blockUIObservable.subscribe(this.blockUIMiddleware.bind(this));
    }
    /**
     * @return {?}
     */
    BlockUIInstanceService.prototype.getSettings = /**
     * @return {?}
     */
    function () {
        return this.blockUISettings;
    };
    /**
     * @param {?=} settings
     * @return {?}
     */
    BlockUIInstanceService.prototype.updateSettings = /**
     * @param {?=} settings
     * @return {?}
     */
    function (settings) {
        if (settings === void 0) { settings = {}; }
        this.blockUISettings = __assign({}, this.blockUISettings, settings);
    };
    /**
     * @param {?=} name
     * @return {?}
     */
    BlockUIInstanceService.prototype.decorate = /**
     * @param {?=} name
     * @return {?}
     */
    function (name) {
        if (name === void 0) { name = BlockUIDefaultName; }
        var /** @type {?} */ blockUI = /** @type {?} */ ({
            name: name,
            isActive: false,
            blockCount: 0,
            start: this.dispatch(this.blockUISubject, BlockUIActions.START, name),
            update: this.dispatch(this.blockUISubject, BlockUIActions.UPDATE, name),
            stop: this.dispatch(this.blockUISubject, BlockUIActions.STOP, name),
            reset: this.dispatch(this.blockUISubject, BlockUIActions.RESET, name),
            unsubscribe: this.dispatch(this.blockUISubject, BlockUIActions.UNSUBSCRIBE, name)
        });
        this.blockUIInstances[name] = this.blockUIInstances[name] || blockUI;
        return blockUI;
    };
    /**
     * @return {?}
     */
    BlockUIInstanceService.prototype.observe = /**
     * @return {?}
     */
    function () {
        return this.blockUIObservable;
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIInstanceService.prototype.blockUIMiddleware = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var action = _a.action, name = _a.name;
        var /** @type {?} */ isActive = null;
        switch (action) {
            case (BlockUIActions.START):
                isActive = true;
                break;
            case (BlockUIActions.STOP):
            case (BlockUIActions.RESET):
                isActive = false;
                break;
        }
        if (isActive !== null) {
            this.blockUIInstances[name].isActive = isActive;
        }
    };
    /**
     * @param {?} subject
     * @param {?} action
     * @param {?=} name
     * @return {?}
     */
    BlockUIInstanceService.prototype.dispatch = /**
     * @param {?} subject
     * @param {?} action
     * @param {?=} name
     * @return {?}
     */
    function (subject, action, name) {
        if (name === void 0) { name = BlockUIDefaultName; }
        return function (message) {
            subject.next({
                name: name,
                action: action,
                message: message
            });
        };
    };
    BlockUIInstanceService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    BlockUIInstanceService.ctorParameters = function () { return []; };
    return BlockUIInstanceService;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIComponent = /** @class */ (function () {
    function BlockUIComponent(blockUI) {
        this.blockUI = blockUI;
    }
    /**
     * @return {?}
     */
    BlockUIComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        this.name = this.name || BlockUIDefaultName;
        this.template = this.template || this.blockUI.blockUISettings.template;
    };
    BlockUIComponent.decorators = [
        { type: Component, args: [{
                    selector: 'block-ui',
                    template: "\n    <ng-content></ng-content>\n    <block-ui-content\n      [name]=\"name\"\n      [message]=\"message\"\n      [template]=\"template\"\n      [delayStart]=\"delayStart\"\n      [delayStop]=\"delayStop\"\n    >\n    </block-ui-content>\n  ",
                    encapsulation: ViewEncapsulation.None
                }] }
    ];
    /** @nocollapse */
    BlockUIComponent.ctorParameters = function () { return [
        { type: BlockUIInstanceService }
    ]; };
    BlockUIComponent.propDecorators = {
        name: [{ type: Input }],
        message: [{ type: Input }],
        delayStart: [{ type: Input }],
        delayStop: [{ type: Input }],
        template: [{ type: Input }]
    };
    return BlockUIComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
// Spinner style - https://github.com/lukehaas/css-loaders
var /** @type {?} */ styles = "\n.block-ui-wrapper {\n  display: none;\n  position: fixed;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  background: rgba(0, 0, 0, 0.70);\n  z-index: 30000;\n  cursor: wait;\n}\n\n.block-ui-wrapper.block-ui-wrapper--element {\n  position: absolute;\n}\n\n.block-ui-wrapper.active {\n  display: block;\n}\n\n.block-ui-wrapper.block-ui-main {\n  position: fixed;\n}\n\n.block-ui-spinner,\n.block-ui-template {\n  position: absolute;\n  top: 40%;\n  margin: 0 auto;\n  left: 0;\n  right: 0;\n  transform: translateY(-50%);\n}\n\n.block-ui-spinner > .message {\n  font-size: 1.3em;\n  text-align: center;\n  color: #fff;\n}\n\n.block-ui__element {\n  position: relative;\n}\n\n.loader,\n.loader:after {\n  border-radius: 50%;\n  width: 10em;\n  height: 10em;\n}\n.loader {\n  margin: 7px auto;\n  font-size: 5px;\n  position: relative;\n  text-indent: -9999em;\n  border-top: 1.1em solid rgba(255, 255, 255, 0.2);\n  border-right: 1.1em solid rgba(255, 255, 255, 0.2);\n  border-bottom: 1.1em solid rgba(255, 255, 255, 0.2);\n  border-left: 1.1em solid #ffffff;\n  -webkit-transform: translateZ(0);\n  -ms-transform: translateZ(0);\n  transform: translateZ(0);\n  -webkit-animation: load8 1.1s infinite linear;\n  animation: load8 1.1s infinite linear;\n}\n\n@-webkit-keyframes load8 {\n  0% {\n    -webkit-transform: rotate(0deg);\n    transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n\n@keyframes load8 {\n  0% {\n    -webkit-transform: rotate(0deg);\n    transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n";

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var /** @type {?} */ template = "\n<div class=\"block-ui-wrapper {{name}} {{className}}\" [ngClass]=\"{ 'active': active }\">\n  <div class=\"block-ui-spinner\" *ngIf=\"!templateCmp\">\n    <div class=\"loader\"></div>\n    <div *ngIf=\"message || defaultMessage\" class=\"message\">\n      {{ message || defaultMessage }}\n    </div>\n  </div>\n  <ng-template *ngIf=\"templateCmp\" #templateOutlet></ng-template>\n</div>\n";

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIContentComponent = /** @class */ (function () {
    function BlockUIContentComponent(blockUI, resolver, changeDetectionRef) {
        this.blockUI = blockUI;
        this.resolver = resolver;
        this.changeDetectionRef = changeDetectionRef;
        this.name = BlockUIDefaultName;
        this.delayStart = 0;
        this.delayStop = 0;
        this.state = { startTimeout: null, stopTimeout: null, blockCount: 0 };
        this.active = false;
    }
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        this.settings = this.blockUI.getSettings();
        this.blockUISubscription = this.subscribeToBlockUI(this.blockUI.observe());
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngAfterViewInit = /**
     * @return {?}
     */
    function () {
        try {
            if (!this.templateCmp) {
                return false;
            }
            if (this.templateCmp instanceof TemplateRef) {
                this.templateOutlet.createEmbeddedView(this.templateCmp);
            }
            else {
                var /** @type {?} */ templateComp = this.resolver.resolveComponentFactory(this.templateCmp);
                this.templateCompRef = this.templateOutlet.createComponent(templateComp);
                this.updateBlockTemplate(this.message);
            }
        }
        catch (/** @type {?} */ error) {
            console.error('ng-block-ui:', error);
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngAfterViewChecked = /**
     * @return {?}
     */
    function () {
        this.detectChanges();
    };
    /**
     * @param {?} blockUI$
     * @return {?}
     */
    BlockUIContentComponent.prototype.subscribeToBlockUI = /**
     * @param {?} blockUI$
     * @return {?}
     */
    function (blockUI$) {
        var _this = this;
        return blockUI$
            .subscribe(function (event) { return _this.onDispatchedEvent(event); });
    };
    /**
     * @param {?} event
     * @return {?}
     */
    BlockUIContentComponent.prototype.onDispatchedEvent = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        switch (event.action) {
            case (BlockUIActions.START):
                this.onStart(event);
                break;
            case (BlockUIActions.STOP):
                this.onStop(event);
                break;
            case (BlockUIActions.UPDATE):
                this.onUpdate(event);
                break;
            case (BlockUIActions.RESET):
                this.onReset();
                break;
            case (BlockUIActions.UNSUBSCRIBE):
                this.onStop(event);
                this.onUnsubscribe(event.name);
                break;
        }
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIContentComponent.prototype.onStart = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var name = _a.name, message = _a.message;
        if (name === this.name) {
            var /** @type {?} */ delay = this.delayStart || this.settings.delayStart || 0;
            if (this.state.startTimeout === null) {
                if (delay === 0) {
                    this.showBlock(message);
                }
                else {
                    this.state.startTimeout = setTimeout(function () {
                        _this.showBlock(message);
                    }, delay);
                }
            }
            this.state.blockCount++;
            this.updateInstanceBlockCount();
        }
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIContentComponent.prototype.onStop = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var name = _a.name;
        if (name === this.name) {
            var /** @type {?} */ delay = this.delayStop || this.settings.delayStop || 0;
            if (this.state.blockCount > 1) {
                this.state.blockCount--;
            }
            else {
                if (!this.active) {
                    this.clearState();
                }
                else {
                    if (this.state.stopTimeout === null) {
                        if (delay === 0) {
                            this.hideBlock();
                        }
                        else {
                            this.state.stopTimeout = setTimeout(function () {
                                _this.hideBlock();
                            }, delay);
                        }
                    }
                }
            }
            this.updateInstanceBlockCount();
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.onReset = /**
     * @return {?}
     */
    function () {
        this.hideBlock();
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIContentComponent.prototype.onUpdate = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var _this = this;
        var name = _a.name, message = _a.message;
        if (name === this.name) {
            var /** @type {?} */ delay = this.delayStart || this.settings.delayStart || 0;
            if (delay === 0) {
                this.updateMessage(message);
            }
            else {
                setTimeout(function () {
                    _this.updateMessage(message);
                }, delay);
            }
        }
    };
    /**
     * @param {?} message
     * @return {?}
     */
    BlockUIContentComponent.prototype.updateMessage = /**
     * @param {?} message
     * @return {?}
     */
    function (message) {
        this.message = message || this.defaultMessage || this.settings.message;
        this.updateBlockTemplate(this.message);
        this.detectChanges();
    };
    /**
     * @param {?} message
     * @return {?}
     */
    BlockUIContentComponent.prototype.showBlock = /**
     * @param {?} message
     * @return {?}
     */
    function (message) {
        this.active = true;
        this.message = message || this.defaultMessage || this.settings.message;
        this.updateBlockTemplate(this.message);
        this.detectChanges();
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.hideBlock = /**
     * @return {?}
     */
    function () {
        this.clearState();
        this.active = false;
        this.detectChanges();
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.clearState = /**
     * @return {?}
     */
    function () {
        this.state.startTimeout != null && clearTimeout(this.state.startTimeout);
        this.state.stopTimeout != null && clearTimeout(this.state.stopTimeout);
        this.state.blockCount = 0;
        this.state.startTimeout = null;
        this.state.stopTimeout = null;
        this.updateInstanceBlockCount();
    };
    /**
     * @param {?} msg
     * @return {?}
     */
    BlockUIContentComponent.prototype.updateBlockTemplate = /**
     * @param {?} msg
     * @return {?}
     */
    function (msg) {
        if (this.templateCompRef && this.templateCompRef instanceof ComponentRef) {
            this.templateCompRef.instance.message = msg;
        }
    };
    /**
     * @param {?} name
     * @return {?}
     */
    BlockUIContentComponent.prototype.onUnsubscribe = /**
     * @param {?} name
     * @return {?}
     */
    function (name) {
        if (this.blockUISubscription && name === this.name) {
            this.blockUISubscription.unsubscribe();
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.updateInstanceBlockCount = /**
     * @return {?}
     */
    function () {
        if (this.blockUI.blockUIInstances[this.name]) {
            this.blockUI.blockUIInstances[this.name].blockCount = this.state.blockCount;
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.detectChanges = /**
     * @return {?}
     */
    function () {
        if (!this.changeDetectionRef['destroyed']) {
            this.changeDetectionRef.detectChanges();
        }
    };
    /**
     * @return {?}
     */
    BlockUIContentComponent.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        this.onUnsubscribe(this.name);
    };
    BlockUIContentComponent.decorators = [
        { type: Component, args: [{
                    selector: 'block-ui-content',
                    template: template,
                    // TODO: Find how to bundle styles for npm
                    encapsulation: ViewEncapsulation.None,
                    styles: [styles]
                }] }
    ];
    /** @nocollapse */
    BlockUIContentComponent.ctorParameters = function () { return [
        { type: BlockUIInstanceService },
        { type: ComponentFactoryResolver },
        { type: ChangeDetectorRef }
    ]; };
    BlockUIContentComponent.propDecorators = {
        name: [{ type: Input }],
        delayStart: [{ type: Input }],
        delayStop: [{ type: Input }],
        defaultMessage: [{ type: Input, args: ['message',] }],
        templateCmp: [{ type: Input, args: ['template',] }],
        templateOutlet: [{ type: ViewChild, args: ['templateOutlet', { read: ViewContainerRef },] }]
    };
    return BlockUIContentComponent;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIService = /** @class */ (function () {
    function BlockUIService(blockUIInstance) {
        this.blockUIInstance = blockUIInstance;
    }
    /**
    * Starts blocking for given BlockUI instance or instances
    */
    /**
     * Starts blocking for given BlockUI instance or instances
     * @param {?} target
     * @param {?=} message
     * @return {?}
     */
    BlockUIService.prototype.start = /**
     * Starts blocking for given BlockUI instance or instances
     * @param {?} target
     * @param {?=} message
     * @return {?}
     */
    function (target, message) {
        this.dispatch(target, BlockUIActions.START, message);
    };
    /**
    * Stops blocking for given BlockUI instance or instances
    */
    /**
     * Stops blocking for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    BlockUIService.prototype.stop = /**
     * Stops blocking for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    function (target) {
        this.dispatch(target, BlockUIActions.STOP);
    };
    /**
    * Reset blocking for given BlockUI instance or instances
    */
    /**
     * Reset blocking for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    BlockUIService.prototype.reset = /**
     * Reset blocking for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    function (target) {
        this.dispatch(target, BlockUIActions.RESET);
    };
    /**
    * Unsubscribes for given BlockUI instance or instances
    */
    /**
     * Unsubscribes for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    BlockUIService.prototype.unsubscribe = /**
     * Unsubscribes for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    function (target) {
        this.dispatch(target, BlockUIActions.UNSUBSCRIBE);
    };
    /**
    * Checks if BlockUI is actively blocking
    */
    /**
     * Checks if BlockUI is actively blocking
     * @param {?=} target
     * @return {?}
     */
    BlockUIService.prototype.isActive = /**
     * Checks if BlockUI is actively blocking
     * @param {?=} target
     * @return {?}
     */
    function (target) {
        if (target === void 0) { target = null; }
        var /** @type {?} */ targets = target ? this.toArray(target) : null;
        var /** @type {?} */ instances = this.blockUIInstance.blockUIInstances;
        return Object.keys(instances).some(function (key) {
            if (!targets) {
                return instances[key].isActive;
            }
            return targets.indexOf(instances[key].name) >= 0 && instances[key].isActive;
        });
    };
    /**
     * @param {?=} target
     * @param {?=} type
     * @param {?=} message
     * @return {?}
     */
    BlockUIService.prototype.dispatch = /**
     * @param {?=} target
     * @param {?=} type
     * @param {?=} message
     * @return {?}
     */
    function (target, type, message) {
        var _this = this;
        if (target === void 0) { target = []; }
        var /** @type {?} */ instances = this.toArray(target);
        instances.forEach(function (i) { return _this.blockUIInstance.decorate(i)[type](message); });
    };
    /**
     * @param {?=} target
     * @return {?}
     */
    BlockUIService.prototype.toArray = /**
     * @param {?=} target
     * @return {?}
     */
    function (target) {
        if (target === void 0) { target = []; }
        return typeof target === 'string' ? [target] : target;
    };
    BlockUIService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    BlockUIService.ctorParameters = function () { return [
        { type: BlockUIInstanceService }
    ]; };
    return BlockUIService;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIDirective = /** @class */ (function () {
    function BlockUIDirective(blockUIService, viewRef, templateRef, renderer, componentFactoryResolver) {
        this.blockUIService = blockUIService;
        this.viewRef = viewRef;
        this.templateRef = templateRef;
        this.renderer = renderer;
        this.componentFactoryResolver = componentFactoryResolver;
    }
    Object.defineProperty(BlockUIDirective.prototype, "blockUI", {
        set: /**
         * @param {?} name
         * @return {?}
         */
        function (name) { this.blockTarget = name; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BlockUIDirective.prototype, "blockUIMessage", {
        set: /**
         * @param {?} message
         * @return {?}
         */
        function (message) { this.message = message; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BlockUIDirective.prototype, "blockUITemplate", {
        set: /**
         * @param {?} template
         * @return {?}
         */
        function (template) { this.template = template; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BlockUIDirective.prototype, "blockUIDelayStart", {
        set: /**
         * @param {?} delayStart
         * @return {?}
         */
        function (delayStart) {
            this.delayStart = delayStart ? Number(delayStart) : null;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BlockUIDirective.prototype, "blockUIDelayStop", {
        set: /**
         * @param {?} delayStop
         * @return {?}
         */
        function (delayStop) {
            this.delayStop = delayStop ? Number(delayStop) : null;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    BlockUIDirective.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        try {
            this.viewRef.createEmbeddedView(this.templateRef);
            var /** @type {?} */ parentElement = this.viewRef.element.nativeElement.nextSibling;
            if (parentElement && !this.isComponentInTemplate(parentElement)) {
                this.renderer.addClass(parentElement, 'block-ui__element');
                this.blockUIComponentRef = this.createComponent();
                var /** @type {?} */ blockUIContent = this.findContentNode(this.viewRef.element.nativeElement);
                if (blockUIContent) {
                    var /** @type {?} */ settings = this.blockUIService.getSettings();
                    parentElement.appendChild(blockUIContent);
                    this.blockUIComponentRef.instance.className = 'block-ui-wrapper--element';
                    this.blockUIComponentRef.instance.name = this.blockTarget || BlockUIDefaultName;
                    if (this.message)
                        this.blockUIComponentRef.instance.defaultMessage = this.message;
                    if (this.delayStart)
                        this.blockUIComponentRef.instance.delayStart = this.delayStart;
                    if (this.delayStop)
                        this.blockUIComponentRef.instance.delayStop = this.delayStop;
                    if (this.template || settings.template)
                        this.blockUIComponentRef.instance.templateCmp = this.template || settings.template;
                }
            }
        }
        catch (/** @type {?} */ error) {
            console.error('ng-block-ui:', error);
        }
    };
    /**
     * @param {?} element
     * @return {?}
     */
    BlockUIDirective.prototype.isComponentInTemplate = /**
     * @param {?} element
     * @return {?}
     */
    function (element) {
        var children = (element || []).children;
        children = Array.from(children).reverse();
        return children.some(function (el) { return el.localName === 'block-ui'; });
    };
    /**
     * @param {?} element
     * @return {?}
     */
    BlockUIDirective.prototype.findContentNode = /**
     * @param {?} element
     * @return {?}
     */
    function (element) {
        var nextSibling = element.nextSibling;
        return [nextSibling, nextSibling.nextSibling].find(function (e) { return e.localName === 'block-ui-content'; });
    };
    /**
     * @return {?}
     */
    BlockUIDirective.prototype.createComponent = /**
     * @return {?}
     */
    function () {
        var /** @type {?} */ resolvedBlockUIComponent = this.componentFactoryResolver.resolveComponentFactory(BlockUIContentComponent);
        return this.viewRef.createComponent(resolvedBlockUIComponent);
    };
    BlockUIDirective.decorators = [
        { type: Directive, args: [{ selector: '[blockUI]' },] }
    ];
    /** @nocollapse */
    BlockUIDirective.ctorParameters = function () { return [
        { type: BlockUIInstanceService },
        { type: ViewContainerRef },
        { type: TemplateRef },
        { type: Renderer2 },
        { type: ComponentFactoryResolver }
    ]; };
    BlockUIDirective.propDecorators = {
        blockUI: [{ type: Input }],
        blockUIMessage: [{ type: Input }],
        blockUITemplate: [{ type: Input }],
        blockUIDelayStart: [{ type: Input }],
        blockUIDelayStop: [{ type: Input }]
    };
    return BlockUIDirective;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var /** @type {?} */ BlockUIServiceInstance = new BlockUIInstanceService();
// Needed for AOT compiling
var /** @type {?} */ BlockUIModuleSettings = new InjectionToken('BlockUIModuleSettings');
/**
 * @param {?} settings
 * @return {?}
 */
function provideInstance(settings) {
    BlockUIServiceInstance.updateSettings(settings);
    return BlockUIServiceInstance;
}
var BlockUIModule = /** @class */ (function () {
    function BlockUIModule() {
    }
    /**
     * @param {?=} settings
     * @return {?}
     */
    BlockUIModule.forRoot = /**
     * @param {?=} settings
     * @return {?}
     */
    function (settings) {
        if (settings === void 0) { settings = {}; }
        return {
            ngModule: BlockUIModule,
            providers: [
                {
                    provide: BlockUIModuleSettings,
                    useValue: settings
                },
                {
                    provide: BlockUIInstanceService,
                    useFactory: provideInstance,
                    deps: [BlockUIModuleSettings]
                },
                BlockUIService
            ]
        };
    };
    BlockUIModule.decorators = [
        { type: NgModule, args: [{
                    imports: [
                        CommonModule
                    ],
                    entryComponents: [
                        BlockUIComponent,
                        BlockUIContentComponent
                    ],
                    declarations: [
                        BlockUIComponent,
                        BlockUIDirective,
                        BlockUIContentComponent
                    ],
                    exports: [
                        BlockUIComponent,
                        BlockUIDirective,
                        BlockUIContentComponent
                    ]
                },] }
    ];
    return BlockUIModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @param {?=} value
 * @return {?}
 */
function BlockUI(value) {
    return function (target, propertyKey, descriptor) {
        target[propertyKey] = BlockUIServiceInstance.decorate(value);
    };
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

export { BlockUIModule, BlockUIComponent, BlockUIContentComponent, BlockUI, BlockUIService, BlockUIDefaultName as BLOCKUI_DEFAULT, BlockUIModuleSettings as ɵa, provideInstance as ɵb, styles as ɵe, template as ɵd, BlockUIDirective as ɵf, BlockUIInstanceService as ɵc };

//# sourceMappingURL=ng-block-ui.js.map