(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('@angular/forms'), require('@angular/common')) :
    typeof define === 'function' && define.amd ? define('ng-bootstrap-form-validation', ['exports', '@angular/core', '@angular/forms', '@angular/common'], factory) :
    (global = global || self, factory(global['ng-bootstrap-form-validation'] = {}, global.ng.core, global.ng.forms, global.ng.common));
}(this, function (exports, core, forms, common) { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    /* global Reflect, Promise */

    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };

    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }

    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    function __rest(s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }

    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }

    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); }
    }

    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
    }

    function __awaiter(thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }

    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_) try {
                if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
                if (y = 0, t) op = [op[0] & 2, t.value];
                switch (op[0]) {
                    case 0: case 1: t = op; break;
                    case 4: _.label++; return { value: op[1], done: false };
                    case 5: _.label++; y = op[1]; op = [0]; continue;
                    case 7: op = _.ops.pop(); _.trys.pop(); continue;
                    default:
                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                        if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                        if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                        if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                        if (t[2]) _.ops.pop();
                        _.trys.pop(); continue;
                }
                op = body.call(thisArg, _);
            } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
            if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
        }
    }

    function __exportStar(m, exports) {
        for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
    }

    function __values(o) {
        var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
        if (m) return m.call(o);
        return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
    }

    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m) return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
        }
        catch (error) { e = { error: error }; }
        finally {
            try {
                if (r && !r.done && (m = i["return"])) m.call(i);
            }
            finally { if (e) throw e.error; }
        }
        return ar;
    }

    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }

    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    };

    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }

    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
        function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
    }

    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    }

    function __asyncValues(o) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
    }

    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
        return cooked;
    };

    function __importStar(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
        result.default = mod;
        return result;
    }

    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var FormValidationDirective = /** @class */ (function () {
        function FormValidationDirective() {
            this.validSubmit = new core.EventEmitter();
        }
        /**
         * @return {?}
         */
        FormValidationDirective.prototype.onSubmit = /**
         * @return {?}
         */
        function () {
            this.markAsTouchedAndDirty(this.formGroup);
            if (this.formGroup.valid) {
                this.validSubmit.emit(this.formGroup.value);
            }
        };
        /**
         * @param {?} control
         * @return {?}
         */
        FormValidationDirective.prototype.markAsTouchedAndDirty = /**
         * @param {?} control
         * @return {?}
         */
        function (control) {
            var _this = this;
            if (control instanceof forms.FormGroup) {
                Object.keys(control.controls).forEach((/**
                 * @param {?} key
                 * @return {?}
                 */
                function (key) {
                    return _this.markAsTouchedAndDirty(control.controls[key]);
                }));
            }
            else if (control instanceof forms.FormArray) {
                control.controls.forEach((/**
                 * @param {?} c
                 * @return {?}
                 */
                function (c) { return _this.markAsTouchedAndDirty(c); }));
            }
            else if (control instanceof forms.FormControl && control.enabled) {
                control.markAsDirty();
                control.markAsTouched();
                control.updateValueAndValidity();
            }
        };
        FormValidationDirective.decorators = [
            { type: core.Directive, args: [{
                        // tslint:disable-next-line:directive-selector
                        selector: "[formGroup]"
                    },] }
        ];
        FormValidationDirective.propDecorators = {
            formGroup: [{ type: core.Input }],
            validSubmit: [{ type: core.Output }],
            onSubmit: [{ type: core.HostListener, args: ["submit",] }]
        };
        return FormValidationDirective;
    }());
    if (false) {
        /** @type {?} */
        FormValidationDirective.prototype.formGroup;
        /** @type {?} */
        FormValidationDirective.prototype.validSubmit;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @enum {number} */
    var BootstrapVersion = {
        Three: 0,
        Four: 1,
    };
    BootstrapVersion[BootstrapVersion.Three] = 'Three';
    BootstrapVersion[BootstrapVersion.Four] = 'Four';

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var CUSTOM_ERROR_MESSAGES = new core.InjectionToken("ng-bootstrap-form-validation custom error messages");
    /** @type {?} */
    var BOOTSTRAP_VERSION = new core.InjectionToken("ng-bootstrap-form-validation module options");

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var MessagesComponent = /** @class */ (function () {
        function MessagesComponent(bootstrapVersion) {
            this.bootstrapVersion = bootstrapVersion;
            this.messages = (/**
             * @return {?}
             */
            function () { return []; });
        }
        Object.defineProperty(MessagesComponent.prototype, "className", {
            get: /**
             * @return {?}
             */
            function () {
                switch (this.bootstrapVersion) {
                    case BootstrapVersion.Three:
                        return "help-block";
                    case BootstrapVersion.Four:
                        return "invalid-feedback";
                }
            },
            enumerable: true,
            configurable: true
        });
        MessagesComponent.decorators = [
            { type: core.Component, args: [{
                        selector: "bfv-messages",
                        template: "\n    <span [ngClass]=\"className\" *ngFor=\"let message of messages()\">{{message}}</span>\n  ",
                        styles: ["\n      .invalid-feedback,\n      .valid-feedback {\n        display: block;\n      }\n    "]
                    }] }
        ];
        /** @nocollapse */
        MessagesComponent.ctorParameters = function () { return [
            { type: BootstrapVersion, decorators: [{ type: core.Inject, args: [BOOTSTRAP_VERSION,] }] }
        ]; };
        MessagesComponent.propDecorators = {
            messages: [{ type: core.Input }]
        };
        return MessagesComponent;
    }());
    if (false) {
        /** @type {?} */
        MessagesComponent.prototype.messages;
        /**
         * @type {?}
         * @private
         */
        MessagesComponent.prototype.bootstrapVersion;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var ɵ0 = /**
     * @param {?} label
     * @return {?}
     */
    function (label) { return label + " is required"; }, ɵ1 = /**
     * @param {?} label
     * @return {?}
     */
    function (label) { return label + " is invalid"; }, ɵ2 = /**
     * @param {?} label
     * @param {?} error
     * @return {?}
     */
    function (label, error) {
        return label + " must be at least " + error.requiredLength + " characters";
    }, ɵ3 = /**
     * @param {?} label
     * @param {?} error
     * @return {?}
     */
    function (label, error) {
        return label + " must be no longer than " + error.requiredLength + " characters";
    }, ɵ4 = /**
     * @param {?} label
     * @param {?} error
     * @return {?}
     */
    function (label, error) { return label + " is required"; }, ɵ5 = /**
     * @param {?} label
     * @param {?} error
     * @return {?}
     */
    function (label, error) { return "Invalid email address"; }, ɵ6 = /**
     * @param {?} label
     * @param {?} error
     * @return {?}
     */
    function (label, error) { return label + " must be no greater than " + error.max; }, ɵ7 = /**
     * @param {?} label
     * @param {?} error
     * @return {?}
     */
    function (label, error) { return label + " must be no less than " + error.min; };
    /** @type {?} */
    var DEFAULT_ERRORS = [
        {
            error: "required",
            format: (ɵ0)
        },
        {
            error: "pattern",
            format: (ɵ1)
        },
        {
            error: "minlength",
            format: (ɵ2)
        },
        {
            error: "maxlength",
            format: (ɵ3)
        },
        {
            error: "requiredTrue",
            format: (ɵ4)
        },
        {
            error: "email",
            format: (ɵ5)
        },
        {
            error: "max",
            format: (ɵ6)
        },
        {
            error: "min",
            format: (ɵ7)
        }
    ];

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var ErrorMessageService = /** @class */ (function () {
        function ErrorMessageService(customErrorMessages) {
            this.customErrorMessages = customErrorMessages;
            this.defaultErrors = DEFAULT_ERRORS;
            this.errorMessages = customErrorMessages.reduce((/**
             * @param {?} acc
             * @param {?} cur
             * @return {?}
             */
            function (acc, cur) { return acc.concat(cur); }), this.defaultErrors);
        }
        ErrorMessageService.decorators = [
            { type: core.Injectable, args: [{
                        providedIn: "root"
                    },] }
        ];
        /** @nocollapse */
        ErrorMessageService.ctorParameters = function () { return [
            { type: Array, decorators: [{ type: core.Inject, args: [CUSTOM_ERROR_MESSAGES,] }] }
        ]; };
        /** @nocollapse */ ErrorMessageService.ngInjectableDef = core.ɵɵdefineInjectable({ factory: function ErrorMessageService_Factory() { return new ErrorMessageService(core.ɵɵinject(CUSTOM_ERROR_MESSAGES)); }, token: ErrorMessageService, providedIn: "root" });
        return ErrorMessageService;
    }());
    if (false) {
        /**
         * @type {?}
         * @private
         */
        ErrorMessageService.prototype.defaultErrors;
        /** @type {?} */
        ErrorMessageService.prototype.errorMessages;
        /** @type {?} */
        ErrorMessageService.prototype.customErrorMessages;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var FormGroupComponent = /** @class */ (function () {
        function FormGroupComponent(elRef, errorMessageService) {
            var _this = this;
            this.elRef = elRef;
            this.errorMessageService = errorMessageService;
            this.customErrorMessages = [];
            this.validationDisabled = false;
            this.messages = (/**
             * @return {?}
             */
            function () { return _this.getMessages(); });
        }
        Object.defineProperty(FormGroupComponent.prototype, "hasErrors", {
            get: /**
             * @return {?}
             */
            function () {
                return (this.FormControlNames.some((/**
                 * @param {?} c
                 * @return {?}
                 */
                function (c) { return !c.valid && c.dirty && c.touched; })) &&
                    !this.validationDisabled);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FormGroupComponent.prototype, "hasSuccess", {
            get: /**
             * @return {?}
             */
            function () {
                return (!this.FormControlNames.some((/**
                 * @param {?} c
                 * @return {?}
                 */
                function (c) { return !c.valid; })) &&
                    this.FormControlNames.some((/**
                     * @param {?} c
                     * @return {?}
                     */
                    function (c) { return c.dirty && c.touched; })) &&
                    !this.validationDisabled);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        FormGroupComponent.prototype.ngAfterContentInit = /**
         * @return {?}
         */
        function () {
            if (this.messagesBlock) {
                this.messagesBlock.messages = this.messages;
            }
        };
        /**
         * @return {?}
         */
        FormGroupComponent.prototype.ngOnInit = /**
         * @return {?}
         */
        function () {
            this.errorMessages = this.errorMessageService.errorMessages
                .concat(this.customErrorMessages)
                .reverse();
        };
        Object.defineProperty(FormGroupComponent.prototype, "label", {
            get: /**
             * @return {?}
             */
            function () {
                /** @type {?} */
                var label = this.elRef.nativeElement.querySelector("label");
                return label && label.textContent ? label.textContent.trim() : "This field";
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FormGroupComponent.prototype, "isDirtyAndTouched", {
            get: /**
             * @return {?}
             */
            function () {
                return this.FormControlNames.some((/**
                 * @param {?} c
                 * @return {?}
                 */
                function (c) { return c.dirty && c.touched; }));
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @private
         * @return {?}
         */
        FormGroupComponent.prototype.getMessages = /**
         * @private
         * @return {?}
         */
        function () {
            var _this = this;
            /** @type {?} */
            var messages = [];
            if (!this.isDirtyAndTouched || this.validationDisabled) {
                return messages;
            }
            /** @type {?} */
            var names = this.FormControlNames.map((/**
             * @param {?} f
             * @return {?}
             */
            function (f) { return f.name; }));
            this.FormControlNames.filter((/**
             * @param {?} c
             * @param {?} i
             * @return {?}
             */
            function (c, i) {
                return !c.valid &&
                    !!c.errors &&
                    // filter out FormControlNames that share the same name - usually for radio buttons
                    names.indexOf(c.name) === i;
            })).forEach((/**
             * @param {?} control
             * @return {?}
             */
            function (control) {
                Object.keys(control.errors).forEach((/**
                 * @param {?} key
                 * @return {?}
                 */
                function (key) {
                    /** @type {?} */
                    var error = _this.errorMessages.find((/**
                     * @param {?} err
                     * @return {?}
                     */
                    function (err) { return err.error === key; }));
                    if (!error) {
                        return;
                    }
                    messages.push(error.format(_this.label, control.errors[key]));
                }));
            }));
            return messages;
        };
        FormGroupComponent.decorators = [
            { type: core.Component, args: [{
                        // tslint:disable:component-selector
                        selector: ".form-group",
                        template: "\n    <ng-content></ng-content>\n    <bfv-messages *ngIf=\"!messagesBlock\" [messages]=\"messages\"></bfv-messages>\n  "
                    }] }
        ];
        /** @nocollapse */
        FormGroupComponent.ctorParameters = function () { return [
            { type: core.ElementRef },
            { type: ErrorMessageService }
        ]; };
        FormGroupComponent.propDecorators = {
            FormControlNames: [{ type: core.ContentChildren, args: [forms.FormControlName,] }],
            customErrorMessages: [{ type: core.Input }],
            validationDisabled: [{ type: core.Input }],
            hasErrors: [{ type: core.HostBinding, args: ["class.has-error",] }],
            hasSuccess: [{ type: core.HostBinding, args: ["class.has-success",] }],
            messagesBlock: [{ type: core.ContentChild, args: [MessagesComponent, { static: false },] }]
        };
        return FormGroupComponent;
    }());
    if (false) {
        /** @type {?} */
        FormGroupComponent.prototype.FormControlNames;
        /** @type {?} */
        FormGroupComponent.prototype.customErrorMessages;
        /** @type {?} */
        FormGroupComponent.prototype.validationDisabled;
        /** @type {?} */
        FormGroupComponent.prototype.messagesBlock;
        /**
         * @type {?}
         * @private
         */
        FormGroupComponent.prototype.errorMessages;
        /** @type {?} */
        FormGroupComponent.prototype.messages;
        /**
         * @type {?}
         * @private
         */
        FormGroupComponent.prototype.elRef;
        /**
         * @type {?}
         * @private
         */
        FormGroupComponent.prototype.errorMessageService;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /**
     * @param {?} name
     * @param {?} parent
     * @return {?}
     */
    function controlPath(name, parent) {
        // tslint:disable-next-line:no-non-null-assertion
        return __spread((/** @type {?} */ (parent.path)), [name]);
    }
    var FormControlDirective = /** @class */ (function () {
        function FormControlDirective(parent, bootstrapVersion) {
            this.parent = parent;
            this.bootstrapVersion = bootstrapVersion;
        }
        Object.defineProperty(FormControlDirective.prototype, "validClass", {
            get: /**
             * @return {?}
             */
            function () {
                if (!this.control) {
                    return false;
                }
                return (this.bootstrapFour &&
                    this.control.valid &&
                    (this.control.touched || this.control.dirty));
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FormControlDirective.prototype, "invalidClass", {
            get: /**
             * @return {?}
             */
            function () {
                if (!this.control) {
                    return false;
                }
                return (this.bootstrapFour &&
                    this.control.invalid &&
                    this.control.touched &&
                    this.control.dirty);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FormControlDirective.prototype, "path", {
            get: /**
             * @return {?}
             */
            function () {
                return controlPath(this.formControlName, this.parent);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FormControlDirective.prototype, "control", {
            get: /**
             * @return {?}
             */
            function () {
                return this.formDirective && this.formDirective.getControl(this);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FormControlDirective.prototype, "formDirective", {
            get: /**
             * @return {?}
             */
            function () {
                return this.parent ? this.parent.formDirective : null;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FormControlDirective.prototype, "bootstrapFour", {
            get: /**
             * @return {?}
             */
            function () {
                return this.bootstrapVersion === BootstrapVersion.Four;
            },
            enumerable: true,
            configurable: true
        });
        FormControlDirective.decorators = [
            { type: core.Directive, args: [{
                        // tslint:disable-next-line:directive-selector
                        selector: ".form-control,.form-check-input,.custom-control-input"
                    },] }
        ];
        /** @nocollapse */
        FormControlDirective.ctorParameters = function () { return [
            { type: forms.ControlContainer, decorators: [{ type: core.Optional }, { type: core.Host }, { type: core.SkipSelf }] },
            { type: BootstrapVersion, decorators: [{ type: core.Inject, args: [BOOTSTRAP_VERSION,] }] }
        ]; };
        FormControlDirective.propDecorators = {
            formControlName: [{ type: core.Input }],
            formControl: [{ type: core.Input }],
            validClass: [{ type: core.HostBinding, args: ["class.is-valid",] }],
            invalidClass: [{ type: core.HostBinding, args: ["class.is-invalid",] }]
        };
        return FormControlDirective;
    }());
    if (false) {
        /** @type {?} */
        FormControlDirective.prototype.formControlName;
        /** @type {?} */
        FormControlDirective.prototype.formControl;
        /**
         * @type {?}
         * @private
         */
        FormControlDirective.prototype.parent;
        /**
         * @type {?}
         * @private
         */
        FormControlDirective.prototype.bootstrapVersion;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var NgBootstrapFormValidationModule = /** @class */ (function () {
        function NgBootstrapFormValidationModule() {
        }
        /**
         * @param {?=} userOptions
         * @return {?}
         */
        NgBootstrapFormValidationModule.forRoot = /**
         * @param {?=} userOptions
         * @return {?}
         */
        function (userOptions) {
            if (userOptions === void 0) { userOptions = {
                bootstrapVersion: BootstrapVersion.Four
            }; }
            return {
                ngModule: NgBootstrapFormValidationModule,
                providers: [
                    {
                        provide: CUSTOM_ERROR_MESSAGES,
                        useValue: userOptions.customErrorMessages || [],
                        multi: true
                    },
                    {
                        provide: BOOTSTRAP_VERSION,
                        useValue: userOptions.bootstrapVersion
                    },
                    ErrorMessageService
                ]
            };
        };
        NgBootstrapFormValidationModule.decorators = [
            { type: core.NgModule, args: [{
                        imports: [common.CommonModule],
                        declarations: [
                            FormValidationDirective,
                            FormGroupComponent,
                            MessagesComponent,
                            FormControlDirective
                        ],
                        exports: [
                            FormValidationDirective,
                            FormGroupComponent,
                            MessagesComponent,
                            FormControlDirective
                        ]
                    },] }
        ];
        return NgBootstrapFormValidationModule;
    }());

    exports.BOOTSTRAP_VERSION = BOOTSTRAP_VERSION;
    exports.BootstrapVersion = BootstrapVersion;
    exports.CUSTOM_ERROR_MESSAGES = CUSTOM_ERROR_MESSAGES;
    exports.FormGroupComponent = FormGroupComponent;
    exports.FormValidationDirective = FormValidationDirective;
    exports.MessagesComponent = MessagesComponent;
    exports.NgBootstrapFormValidationModule = NgBootstrapFormValidationModule;
    exports.ɵa = ErrorMessageService;
    exports.ɵb = FormControlDirective;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=ng-bootstrap-form-validation.umd.js.map
