"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular/core");
const mock_service_1 = require("../mock-service");
class Mock {
    constructor() {
        for (const method of this.__mockedMethods) {
            if (this[method]) {
                continue;
            }
            this[method] = mock_service_1.mockServiceHelper.mockFunction();
        }
        for (const output of this.__mockedOutputs) {
            if (this[output]) {
                continue;
            }
            this[output] = new core_1.EventEmitter();
        }
    }
}
exports.Mock = Mock;
class MockControlValueAccessor extends Mock {
    constructor() {
        super(...arguments);
        this.__simulateChange = (param) => { };
        this.__simulateTouch = () => { };
        this.writeValue = () => { };
    }
    registerOnChange(fn) {
        this.__simulateChange = fn;
    }
    registerOnTouched(fn) {
        this.__simulateTouch = fn;
    }
}
exports.MockControlValueAccessor = MockControlValueAccessor;
//# sourceMappingURL=Mock.js.map