"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular/core");
function decorateInputs(cls, inputs) {
    if (inputs) {
        for (const input of inputs) {
            const [key, alias] = input.split(': ');
            core_1.Input(alias)(cls.prototype, key);
        }
    }
}
exports.decorateInputs = decorateInputs;
function decorateOutputs(cls, outputs) {
    if (outputs) {
        for (const output of outputs) {
            const [key, alias] = output.split(': ');
            core_1.Output(alias)(cls.prototype, key);
        }
    }
}
exports.decorateOutputs = decorateOutputs;
function decorateQueries(cls, queries) {
    if (queries) {
        for (const key of Object.keys(queries)) {
            const query = queries[key];
            if (!query) {
                continue;
            }
            if (query.ngMetadataName === 'ContentChild') {
                core_1.ContentChild(query.selector, query)(cls.prototype, key);
            }
            if (query.ngMetadataName === 'ContentChildren') {
                core_1.ContentChildren(query.selector, query)(cls.prototype, key);
            }
            if (query.ngMetadataName === 'ViewChild') {
                core_1.ViewChild(query.selector, query)(cls.prototype, key);
            }
            if (query.ngMetadataName === 'ViewChildren') {
                core_1.ViewChildren(query.selector, query)(cls.prototype, key);
            }
        }
    }
}
exports.decorateQueries = decorateQueries;
//# sourceMappingURL=decorate.js.map