"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular/core");
class JitReflector {
    constructor() {
        this.componentModuleUrl = (type) => `./${core_1.ɵstringify(type)}`;
        this.guards = () => ({});
        this.resolveExternalReference = (ref) => ref.runtime;
        this.shallowAnnotations = () => {
            throw new Error('Not supported in JIT mode');
        };
        this._reflectionCapabilities = new core_1.ɵReflectionCapabilities();
    }
    annotations(typeOrFunc) {
        return this._reflectionCapabilities.annotations(typeOrFunc);
    }
    hasLifecycleHook(type, lcProperty) {
        return this._reflectionCapabilities.hasLifecycleHook(type, lcProperty);
    }
    parameters(typeOrFunc) {
        return this._reflectionCapabilities.parameters(typeOrFunc);
    }
    propMetadata(typeOrFunc) {
        return this._reflectionCapabilities.propMetadata(typeOrFunc);
    }
    tryAnnotations(typeOrFunc) {
        return this.annotations(typeOrFunc);
    }
}
exports.JitReflector = JitReflector;
//# sourceMappingURL=jit-reflector.js.map