"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mock_service_1 = require("../mock-service");
exports.MockOf = (mockClass, outputs) => (constructor) => {
    Object.defineProperties(constructor, {
        mockOf: { value: mockClass },
        name: { value: `MockOf${mockClass.name}` },
        nameConstructor: { value: constructor.name },
    });
    constructor.prototype.__mockedMethods = mock_service_1.mockServiceHelper.extractMethodsFromPrototype(mockClass.prototype);
    const mockedOutputs = [];
    for (const output of outputs || []) {
        mockedOutputs.push(output.split(':')[0]);
    }
    constructor.prototype.__mockedOutputs = mockedOutputs;
};
//# sourceMappingURL=mock-of.decorator.js.map