"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular/core");
const forms_1 = require("@angular/forms");
const common_1 = require("../common");
const decorate_1 = require("../common/decorate");
const reflect_1 = require("../common/reflect");
const cache = new Map();
function MockComponents(...components) {
    return components.map(component => MockComponent(component, undefined));
}
exports.MockComponents = MockComponents;
function MockComponent(component, metaData) {
    const cacheHit = cache.get(component);
    if (cacheHit) {
        return cacheHit;
    }
    const { exportAs, inputs, outputs, queries, selector } = metaData || reflect_1.directiveResolver.resolve(component);
    let template = `<ng-content></ng-content>`;
    const viewChildRefs = new Map();
    if (queries) {
        const queriesKeys = Object.keys(queries);
        const templateQueries = queriesKeys
            .map((key) => {
            const query = queries[key];
            if (query.isViewQuery) {
                return '';
            }
            if (typeof query.selector !== 'string') {
                return '';
            }
            viewChildRefs.set(query.selector, key);
            queries[`__mockView_${key}`] = new core_1.ViewChild(`__${query.selector}`, {
                read: core_1.ViewContainerRef,
                static: false,
            });
            return `
          <div *ngIf="mockRender_${query.selector}" data-key="${query.selector}">
            <ng-template #__${query.selector}></ng-template>
          </div>
        `;
        })
            .join('');
        if (templateQueries) {
            template = `
        ${template}
        ${templateQueries}
      `;
        }
    }
    const options = {
        exportAs,
        providers: [
            {
                multi: true,
                provide: forms_1.NG_VALUE_ACCESSOR,
                useExisting: core_1.forwardRef(() => ComponentMock),
            },
            {
                provide: component,
                useExisting: core_1.forwardRef(() => ComponentMock),
            },
        ],
        selector,
        template,
    };
    let ComponentMock = class ComponentMock extends common_1.MockControlValueAccessor {
        constructor(changeDetector) {
            super();
            this.__hide = (contentChildSelector) => {
                const key = viewChildRefs.get(contentChildSelector);
                if (key) {
                    this[`mockRender_${contentChildSelector}`] = false;
                    changeDetector.detectChanges();
                }
            };
            this.__render = (contentChildSelector, $implicit, variables) => {
                const key = viewChildRefs.get(contentChildSelector);
                let templateRef;
                let viewContainer;
                if (key) {
                    this[`mockRender_${contentChildSelector}`] = true;
                    changeDetector.detectChanges();
                    viewContainer = this[`__mockView_${key}`];
                    templateRef = this[key];
                    if (viewContainer && templateRef) {
                        viewContainer.clear();
                        viewContainer.createEmbeddedView(templateRef, Object.assign(Object.assign({}, variables), { $implicit }));
                        changeDetector.detectChanges();
                    }
                }
            };
        }
    };
    ComponentMock = __decorate([
        common_1.MockOf(component, outputs),
        __metadata("design:paramtypes", [core_1.ChangeDetectorRef])
    ], ComponentMock);
    decorate_1.decorateInputs(ComponentMock, inputs);
    decorate_1.decorateOutputs(ComponentMock, outputs);
    decorate_1.decorateQueries(ComponentMock, queries);
    const mockedComponent = core_1.Component(options)(ComponentMock);
    cache.set(component, mockedComponent);
    return mockedComponent;
}
exports.MockComponent = MockComponent;
//# sourceMappingURL=mock-component.js.map