"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const reflect_1 = require("../common/reflect");
const mock_component_1 = require("../mock-component");
const mock_directive_1 = require("../mock-directive");
const mock_pipe_1 = require("../mock-pipe");
function MockDeclarations(...declarations) {
    return declarations.map(MockDeclaration);
}
exports.MockDeclarations = MockDeclarations;
function MockDeclaration(declaration) {
    if (reflect_1.pipeResolver.isPipe(declaration)) {
        return mock_pipe_1.MockPipe(declaration);
    }
    const annotations = reflect_1.jitReflector.annotations(declaration);
    if (annotations.find(annotation => annotation.template !== undefined || annotation.templateUrl !== undefined)) {
        return mock_component_1.MockComponent(declaration);
    }
    return mock_directive_1.MockDirective(declaration);
}
exports.MockDeclaration = MockDeclaration;
//# sourceMappingURL=mock-declaration.js.map