"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular/core");
const common_1 = require("../common");
const decorate_1 = require("../common/decorate");
const reflect_1 = require("../common/reflect");
const cache = new Map();
function MockDirectives(...directives) {
    return directives.map(MockDirective);
}
exports.MockDirectives = MockDirectives;
function MockDirective(directive) {
    const cacheHit = cache.get(directive);
    if (cacheHit) {
        return cacheHit;
    }
    const { selector, exportAs, inputs, outputs, queries } = reflect_1.directiveResolver.resolve(directive);
    const options = {
        exportAs,
        providers: [
            {
                provide: directive,
                useExisting: core_1.forwardRef(() => DirectiveMock),
            },
        ],
        selector,
    };
    let DirectiveMock = class DirectiveMock extends common_1.MockControlValueAccessor {
        constructor(element, template, viewContainer) {
            super();
            this.__element = element;
            this.__template = template;
            this.__viewContainer = viewContainer;
            this.__isStructural = template && viewContainer;
            this.__render = ($implicit, variables) => {
                if (viewContainer && template) {
                    viewContainer.clear();
                    viewContainer.createEmbeddedView(template, Object.assign(Object.assign({}, variables), { $implicit }));
                }
            };
        }
    };
    DirectiveMock = __decorate([
        common_1.MockOf(directive, outputs),
        __param(0, core_1.Optional()),
        __param(1, core_1.Optional()),
        __param(2, core_1.Optional()),
        __metadata("design:paramtypes", [core_1.ElementRef,
            core_1.TemplateRef,
            core_1.ViewContainerRef])
    ], DirectiveMock);
    decorate_1.decorateInputs(DirectiveMock, inputs);
    decorate_1.decorateOutputs(DirectiveMock, outputs);
    decorate_1.decorateQueries(DirectiveMock, queries);
    const mockedDirective = core_1.Directive(options)(DirectiveMock);
    cache.set(directive, mockedDirective);
    return mockedDirective;
}
exports.MockDirective = MockDirective;
//# sourceMappingURL=mock-directive.js.map