import { DebugNode, Type } from '@angular/core';
import { MockedDebugElement } from '../mock-render';
import { MockedFunction } from '../mock-service';
export declare const MockHelper: {
    find<T>(debugElement: MockedDebugElement<any>, component: Type<T>): null | MockedDebugElement<T>;
    find<T = any>(debugElement: MockedDebugElement<any>, cssSelector: string): null | MockedDebugElement<T>;
    findAll<T>(debugElement: MockedDebugElement<any>, component: Type<T>): Array<MockedDebugElement<T>>;
    findAll<T = any>(debugElement: MockedDebugElement<any>, cssSelector: string): Array<MockedDebugElement<T>>;
    findDirective<T>(debugNode: DebugNode, directive: Type<T>): undefined | T;
    findDirectiveOrFail<T>(debugNode: DebugNode, directive: Type<T>): T;
    findDirectives<T>(debugNode: DebugNode, directive: Type<T>): T[];
    findOrFail<T>(debugElement: MockedDebugElement<any>, component: Type<T>): MockedDebugElement<T>;
    findOrFail<T = any>(debugElement: MockedDebugElement<any>, cssSelector: string): MockedDebugElement<T>;
    getDirective<T>(debugNode: DebugNode, directive: Type<T>): undefined | T;
    getDirectiveOrFail<T>(debugNode: DebugNode, directive: Type<T>): T;
    mockService<T = MockedFunction>(instance: any, name: string, style?: 'get' | 'set'): T;
};
