"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const platform_browser_1 = require("@angular/platform-browser");
const mock_service_1 = require("../mock-service");
function nestedCheck(result, node, callback) {
    const element = callback(node);
    if (element) {
        result.push(element);
    }
    const childNodes = node.childNodes ? node.childNodes : [];
    childNodes.forEach(childNode => {
        nestedCheck(result, childNode, callback);
    });
}
exports.MockHelper = {
    getDirectiveOrFail: (debugNode, directive) => {
        const result = exports.MockHelper.getDirective(debugNode, directive);
        if (!result) {
            throw new Error(`Cannot find a directive via MockHelper.getDirectiveOrFail`);
        }
        return result;
    },
    getDirective: (debugNode, directive) => {
        try {
            return debugNode.injector.get(directive);
        }
        catch (error) {
        }
        if (!debugNode || !debugNode.parent) {
            return undefined;
        }
        const prevNode = debugNode.nativeNode.previousSibling;
        if (!prevNode || prevNode.nodeName !== '#comment') {
            return undefined;
        }
        const matches = debugNode.parent.queryAllNodes(node => node.nativeNode === prevNode);
        if (matches.length === 0) {
            return undefined;
        }
        const matchedNode = matches[0];
        try {
            return matchedNode.injector.get(directive);
        }
        catch (error) {
            return undefined;
        }
    },
    findDirectiveOrFail: (debugNode, directive) => {
        const result = exports.MockHelper.findDirective(debugNode, directive);
        if (!result) {
            throw new Error(`Cannot find a directive via MockHelper.findDirectiveOrFail`);
        }
        return result;
    },
    findDirective: (debugNode, directive) => {
        const result = [];
        nestedCheck(result, debugNode, node => {
            try {
                return node.injector.get(directive);
            }
            catch (error) {
                return undefined;
            }
        });
        return result.length ? result[0] : undefined;
    },
    findDirectives: (debugNode, directive) => {
        const result = [];
        nestedCheck(result, debugNode, node => {
            try {
                return node.injector.get(directive);
            }
            catch (error) {
                return undefined;
            }
        });
        return result;
    },
    findOrFail: (el, sel) => {
        const result = exports.MockHelper.find(el, sel);
        if (!result) {
            throw new Error(`Cannot find an element via MockHelper.findOrFail`);
        }
        return result;
    },
    find: (el, sel) => {
        const term = typeof sel === 'string' ? platform_browser_1.By.css(sel) : platform_browser_1.By.directive(sel);
        return el.query(term);
    },
    findAll: (el, sel) => {
        const term = typeof sel === 'string' ? platform_browser_1.By.css(sel) : platform_browser_1.By.directive(sel);
        return el.queryAll(term);
    },
    mockService: (instance, name, style) => mock_service_1.mockServiceHelper.mock(instance, name, style),
};
//# sourceMappingURL=mock-helper.js.map