"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
const common_1 = require("@angular/common");
const core_1 = require("@angular/core");
const common_2 = require("../common");
const reflect_1 = require("../common/reflect");
const mock_declaration_1 = require("../mock-declaration");
const mock_service_1 = require("../mock-service");
const cache = new Map();
const neverMockProvidedToken = [
    'InjectionToken Application Initializer',
    'InjectionToken EventManagerPlugins',
    'InjectionToken HammerGestureConfig',
];
const neverMockProvidedFunction = [
    'ApplicationInitStatus',
    'DomRendererFactory2',
    'DomSharedStylesHost',
    'EventManager',
    'RendererFactory2',
];
const mockProvider = (provider) => {
    const provide = typeof provider === 'object' && provider.provide ? provider.provide : provider;
    const multi = typeof provider === 'object' && provider.multi;
    if (typeof provide === 'object' &&
        provide.ngMetadataName === 'InjectionToken' &&
        neverMockProvidedToken.includes(provide.toString())) {
        return provider;
    }
    if (typeof provide === 'function' && neverMockProvidedFunction.includes(provide.name)) {
        return provider;
    }
    return {
        multi,
        provide,
        useValue: mock_service_1.MockService(provide),
    };
};
const flatten = (values, result = []) => {
    if (Array.isArray(values)) {
        values.forEach((value) => flatten(value, result));
    }
    else {
        result.push(values);
    }
    return result;
};
const isModule = (object) => {
    const annotations = reflect_1.jitReflector.annotations(object);
    const ngMetadataNames = annotations.map(annotation => annotation.__proto__.ngMetadataName);
    return ngMetadataNames.indexOf('NgModule') !== -1;
};
const isModuleWithProviders = (object) => typeof object.ngModule !== 'undefined' && isModule(object.ngModule);
function MockModule(module) {
    let ngModule;
    let ngModuleProviders;
    let moduleMockPointer;
    if (isModuleWithProviders(module)) {
        ngModule = module.ngModule;
        if (module.providers) {
            ngModuleProviders = module.providers;
        }
    }
    else {
        ngModule = module;
    }
    if (NEVER_MOCK.includes(ngModule)) {
        return module;
    }
    const cacheHit = cache.get(ngModule);
    if (cacheHit) {
        moduleMockPointer = cacheHit;
    }
    else {
        let ModuleMock = class ModuleMock extends common_2.Mock {
        };
        ModuleMock = __decorate([
            core_1.NgModule(MockIt(ngModule)),
            common_2.MockOf(ngModule)
        ], ModuleMock);
        moduleMockPointer = ModuleMock;
        cache.set(ngModule, moduleMockPointer);
    }
    if (ngModuleProviders) {
        return {
            ngModule: moduleMockPointer,
            providers: flatten(ngModuleProviders)
                .map(mockProvider)
                .filter(provider => !!provider),
        };
    }
    return moduleMockPointer;
}
exports.MockModule = MockModule;
const NEVER_MOCK = [common_1.CommonModule];
function MockIt(module) {
    const mockedModule = {};
    const { declarations = [], entryComponents = [], imports = [], providers = [] } = reflect_1.ngModuleResolver.resolve(module);
    if (imports.length) {
        mockedModule.imports = flatten(imports).map((instance) => {
            if (isModule(instance)) {
                return MockModule(instance);
            }
            if (isModuleWithProviders(instance)) {
                return MockModule(instance);
            }
            return mock_declaration_1.MockDeclaration(instance);
        });
    }
    if (declarations.length) {
        mockedModule.declarations = flatten(declarations).map(mock_declaration_1.MockDeclaration);
    }
    if (entryComponents.length) {
        mockedModule.entryComponents = flatten(entryComponents).map(mock_declaration_1.MockDeclaration);
    }
    if (providers.length) {
        mockedModule.providers = flatten(providers)
            .map(mockProvider)
            .filter(provider => !!provider);
    }
    if (mockedModule.declarations || mockedModule.imports) {
        mockedModule.exports = [];
        if (mockedModule.imports) {
            const onlyModules = mockedModule.imports
                .map(instance => {
                if (isModule(instance)) {
                    return instance;
                }
                if (isModuleWithProviders(instance)) {
                    return instance.ngModule;
                }
                return undefined;
            })
                .filter(instance => instance);
            mockedModule.exports = [...mockedModule.exports, ...onlyModules];
        }
        if (mockedModule.declarations) {
            mockedModule.exports = [...mockedModule.exports, ...mockedModule.declarations];
        }
    }
    return mockedModule;
}
//# sourceMappingURL=mock-module.js.map