import { DebugElement, Provider, Type } from '@angular/core';
import { ComponentFixture } from '@angular/core/testing';
export declare type DebugElementField = 'attributes' | 'childNodes' | 'children' | 'classes' | 'context' | 'injector' | 'listeners' | 'name' | 'nativeElement' | 'nativeNode' | 'parent' | 'properties' | 'providerTokens' | 'query' | 'queryAll' | 'queryAllNodes' | 'references' | 'styles' | 'triggerEventHandler';
export declare type MockedDebugElement<T> = {
    componentInstance: T;
} & Pick<DebugElement, DebugElementField>;
export interface IMockRenderOptions {
    detectChanges?: boolean;
    providers?: Provider[];
}
export interface MockedComponentFixture<C = any, F = undefined> extends ComponentFixture<F> {
    point: MockedDebugElement<C>;
}
declare function MockRender<MComponent, TComponent extends {
    [key: string]: any;
}>(template: Type<MComponent>, params: TComponent, detectChanges?: boolean | IMockRenderOptions): MockedComponentFixture<MComponent, TComponent>;
declare function MockRender<MComponent>(template: Type<MComponent>): MockedComponentFixture<MComponent>;
declare function MockRender<MComponent, TComponent extends {
    [key: string]: any;
}>(template: string, params: TComponent, detectChanges?: boolean | IMockRenderOptions): MockedComponentFixture<any, TComponent>;
declare function MockRender<MComponent>(template: string): MockedComponentFixture;
export { MockRender };
