"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular/core");
const testing_1 = require("@angular/core/testing");
const reflect_1 = require("../common/reflect");
function MockRender(template, params, flags = true) {
    const flagsObject = typeof flags === 'boolean' ? { detectChanges: flags } : flags;
    let mockedTemplate = '';
    if (typeof template === 'string') {
        mockedTemplate = template;
    }
    else {
        const { inputs, outputs, selector } = reflect_1.directiveResolver.resolve(template);
        mockedTemplate += `<${selector}`;
        if (inputs) {
            inputs.forEach((definition) => {
                const [property, alias] = definition.split(': ');
                if (alias && params && typeof params[alias]) {
                    mockedTemplate += ` [${alias}]="${alias}"`;
                }
                else if (property && params && typeof params[property]) {
                    mockedTemplate += ` [${property}]="${property}"`;
                }
            });
        }
        if (outputs) {
            outputs.forEach((definition) => {
                const [property, alias] = definition.split(': ');
                if (alias && params && typeof params[alias]) {
                    mockedTemplate += ` (${alias})="${alias}($event)"`;
                }
                else if (property && params && typeof params[property]) {
                    mockedTemplate += ` (${property})="${property}($event)"`;
                }
            });
        }
        mockedTemplate += `></${selector}>`;
    }
    const options = {
        providers: flagsObject.providers,
        selector: 'mock-render',
        template: mockedTemplate,
    };
    const component = core_1.Component(options)(class MockRenderComponent {
        constructor() {
            Object.assign(this, params);
        }
    });
    testing_1.getTestBed()._instantiated = false;
    testing_1.getTestBed()._moduleFactory = undefined;
    testing_1.TestBed.configureTestingModule({
        declarations: [component],
    });
    const fixture = testing_1.TestBed.createComponent(component);
    if (flagsObject.detectChanges) {
        fixture.detectChanges();
    }
    fixture.point = fixture.debugElement.children[0];
    return fixture;
}
exports.MockRender = MockRender;
//# sourceMappingURL=mock-render.js.map