"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const isFunc = (value) => {
    if (typeof value !== 'function') {
        return false;
    }
    const proto = value.toString();
    if (proto.match(/^\(/) !== null) {
        return true;
    }
    return proto.match(/^function\s*\(/) !== null;
};
const isClass = (value) => {
    if (typeof value !== 'function') {
        return false;
    }
    if (isFunc(value)) {
        return false;
    }
    const proto = value.toString();
    if (proto.match(/^class\b/) !== null) {
        return true;
    }
    return proto.match(/^function\s*\(/) === null;
};
const isInst = (value) => {
    if (value === null) {
        return false;
    }
    if (typeof value !== 'object') {
        return false;
    }
    if (value.ngMetadataName === 'InjectionToken') {
        return false;
    }
    return typeof value.__proto__ === 'object';
};
let customMockFunction;
const mockServiceHelperPrototype = {
    mockFunction: (mockName) => {
        if (customMockFunction) {
            return customMockFunction(mockName);
        }
        return () => undefined;
    },
    registerMockFunction: (mockFunction) => {
        customMockFunction = mockFunction;
    },
    createMockFromPrototype: (service) => {
        const methods = mockServiceHelperPrototype.extractMethodsFromPrototype(service);
        const value = {};
        for (const method of methods) {
            if (value[method]) {
                continue;
            }
            const mockName = `${service.constructor ? service.constructor.name : 'unknown'}.${method}`;
            value[method] = mockServiceHelperPrototype.mockFunction(mockName);
        }
        if (typeof value === 'object') {
            value.__proto__ = service;
        }
        return value;
    },
    extractMethodsFromPrototype: (service) => {
        const result = [];
        let prototype = service;
        while (prototype && Object.getPrototypeOf(prototype) !== null) {
            for (const method of Object.getOwnPropertyNames(prototype)) {
                if (method === 'constructor') {
                    continue;
                }
                const descriptor = Object.getOwnPropertyDescriptor(prototype, method);
                const isGetterSetter = descriptor && (descriptor.get || descriptor.set);
                if (isGetterSetter || result.indexOf(method) !== -1) {
                    continue;
                }
                result.push(method);
            }
            prototype = Object.getPrototypeOf(prototype);
        }
        return result;
    },
    mock: (instance, name, style) => {
        const def = Object.getOwnPropertyDescriptor(instance, name);
        if (def && def[style || 'value']) {
            return def[style || 'value'];
        }
        const mockName = `${typeof instance.prototype === 'function' ? instance.prototype.name : 'unknown'}.${name}${style ? `:${style}` : ''}`;
        const mock = mockServiceHelperPrototype.mockFunction(mockName);
        Object.defineProperty(instance, name, {
            [style || 'value']: mock,
        });
        return mock;
    },
};
(window || global).ngMocksMockServiceHelper =
    (window || global).ngMocksMockServiceHelper || mockServiceHelperPrototype;
const localHelper = (window || global).ngMocksMockServiceHelper;
exports.mockServiceHelper = (window || global).ngMocksMockServiceHelper;
function MockService(service, mockNamePrefix) {
    let value;
    if (isClass(service)) {
        value = localHelper.createMockFromPrototype(service.prototype);
    }
    else if (isFunc(service)) {
        value = localHelper.mockFunction(`func:${mockNamePrefix ? mockNamePrefix : service.name || 'arrow-function'}`);
    }
    else if (Array.isArray(service)) {
        value = [];
    }
    else if (isInst(service)) {
        value =
            typeof service.constructor === 'function'
                ? localHelper.createMockFromPrototype(service.constructor.prototype)
                : {};
        for (const property of Object.keys(service)) {
            const mock = MockService(service[property], `${mockNamePrefix ? mockNamePrefix : 'instance'}.${property}`);
            if (mock !== undefined) {
                value[property] = mock;
            }
        }
        value.__proto__ = service.__proto__;
    }
    return value;
}
exports.MockService = MockService;
//# sourceMappingURL=mock-service.js.map