(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('@angular/forms'), require('@angular/common')) :
    typeof define === 'function' && define.amd ? define('ngx-bootstrap/pagination', ['exports', '@angular/core', '@angular/forms', '@angular/common'], factory) :
    (global = global || self, factory((global['ngx-bootstrap'] = global['ngx-bootstrap'] || {}, global['ngx-bootstrap'].pagination = {}), global.ng.core, global.ng.forms, global.ng.common));
}(this, function (exports, core, forms, common) { 'use strict';

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /**
     * Provides default values for Pagination and pager components
     */
    var PaginationConfig = /** @class */ (function () {
        function PaginationConfig() {
            this.main = {
                maxSize: void 0,
                itemsPerPage: 10,
                boundaryLinks: false,
                directionLinks: true,
                firstText: 'First',
                previousText: 'Previous',
                nextText: 'Next',
                lastText: 'Last',
                pageBtnClass: '',
                rotate: true
            };
            this.pager = {
                itemsPerPage: 15,
                previousText: '« Previous',
                nextText: 'Next »',
                pageBtnClass: '',
                align: true
            };
        }
        PaginationConfig.decorators = [
            { type: core.Injectable }
        ];
        return PaginationConfig;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var PAGER_CONTROL_VALUE_ACCESSOR = {
        provide: forms.NG_VALUE_ACCESSOR,
        /* tslint:disable-next-line: no-use-before-declare */
        useExisting: core.forwardRef((/**
         * @return {?}
         */
        function () { return PagerComponent; })),
        multi: true
    };
    var PagerComponent = /** @class */ (function () {
        function PagerComponent(elementRef, paginationConfig, changeDetection) {
            this.elementRef = elementRef;
            this.changeDetection = changeDetection;
            /**
             * fired when total pages count changes, $event:number equals to total pages count
             */
            this.numPages = new core.EventEmitter();
            /**
             * fired when page was changed, $event:{page, itemsPerPage} equals to
             * object with current page index and number of items per page
             */
            this.pageChanged = new core.EventEmitter();
            this.onChange = Function.prototype;
            this.onTouched = Function.prototype;
            this.inited = false;
            this._page = 1;
            this.elementRef = elementRef;
            if (!this.config) {
                this.configureOptions(Object.assign({}, paginationConfig.main, paginationConfig.pager));
            }
        }
        Object.defineProperty(PagerComponent.prototype, "itemsPerPage", {
            /** maximum number of items per page. If value less than 1 will display all items on one page */
            get: /**
             * maximum number of items per page. If value less than 1 will display all items on one page
             * @return {?}
             */
            function () {
                return this._itemsPerPage;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */
            function (v) {
                this._itemsPerPage = v;
                this.totalPages = this.calculateTotalPages();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PagerComponent.prototype, "totalItems", {
            /** total number of items in all pages */
            get: /**
             * total number of items in all pages
             * @return {?}
             */
            function () {
                return this._totalItems;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */
            function (v) {
                this._totalItems = v;
                this.totalPages = this.calculateTotalPages();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PagerComponent.prototype, "totalPages", {
            get: /**
             * @return {?}
             */
            function () {
                return this._totalPages;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */
            function (v) {
                this._totalPages = v;
                this.numPages.emit(v);
                if (this.inited) {
                    this.selectPage(this.page);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PagerComponent.prototype, "page", {
            get: /**
             * @return {?}
             */
            function () {
                return this._page;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */
            function (value) {
                /** @type {?} */
                var _previous = this._page;
                this._page = value > this.totalPages ? this.totalPages : value || 1;
                this.changeDetection.markForCheck();
                if (_previous === this._page || typeof _previous === 'undefined') {
                    return;
                }
                this.pageChanged.emit({
                    page: this._page,
                    itemsPerPage: this.itemsPerPage
                });
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} config
         * @return {?}
         */
        PagerComponent.prototype.configureOptions = /**
         * @param {?} config
         * @return {?}
         */
        function (config) {
            this.config = Object.assign({}, config);
        };
        /**
         * @return {?}
         */
        PagerComponent.prototype.ngOnInit = /**
         * @return {?}
         */
        function () {
            if (typeof window !== 'undefined') {
                this.classMap = this.elementRef.nativeElement.getAttribute('class') || '';
            }
            // watch for maxSize
            this.maxSize =
                typeof this.maxSize !== 'undefined' ? this.maxSize : this.config.maxSize;
            this.rotate =
                typeof this.rotate !== 'undefined' ? this.rotate : this.config.rotate;
            this.boundaryLinks =
                typeof this.boundaryLinks !== 'undefined'
                    ? this.boundaryLinks
                    : this.config.boundaryLinks;
            this.directionLinks =
                typeof this.directionLinks !== 'undefined'
                    ? this.directionLinks
                    : this.config.directionLinks;
            this.pageBtnClass =
                typeof this.pageBtnClass !== 'undefined'
                    ? this.pageBtnClass
                    : this.config.pageBtnClass;
            // base class
            this.itemsPerPage =
                typeof this.itemsPerPage !== 'undefined'
                    ? this.itemsPerPage
                    : this.config.itemsPerPage;
            this.totalPages = this.calculateTotalPages();
            // this class
            this.pages = this.getPages(this.page, this.totalPages);
            this.inited = true;
        };
        /**
         * @param {?} value
         * @return {?}
         */
        PagerComponent.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this.page = value;
            this.pages = this.getPages(this.page, this.totalPages);
        };
        /**
         * @param {?} key
         * @return {?}
         */
        PagerComponent.prototype.getText = /**
         * @param {?} key
         * @return {?}
         */
        function (key) {
            // tslint:disable-next-line:no-any
            return ((/** @type {?} */ (this)))[key + "Text"] || ((/** @type {?} */ (this))).config[key + "Text"];
        };
        /**
         * @return {?}
         */
        PagerComponent.prototype.noPrevious = /**
         * @return {?}
         */
        function () {
            return this.page === 1;
        };
        /**
         * @return {?}
         */
        PagerComponent.prototype.noNext = /**
         * @return {?}
         */
        function () {
            return this.page === this.totalPages;
        };
        /**
         * @param {?} fn
         * @return {?}
         */
        PagerComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
        function (fn) {
            this.onChange = fn;
        };
        /**
         * @param {?} fn
         * @return {?}
         */
        PagerComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
        function (fn) {
            this.onTouched = fn;
        };
        /**
         * @param {?} page
         * @param {?=} event
         * @return {?}
         */
        PagerComponent.prototype.selectPage = /**
         * @param {?} page
         * @param {?=} event
         * @return {?}
         */
        function (page, event) {
            if (event) {
                event.preventDefault();
            }
            if (!this.disabled) {
                if (event && event.target) {
                    // tslint:disable-next-line:no-any
                    /** @type {?} */
                    var target = event.target;
                    target.blur();
                }
                this.writeValue(page);
                this.onChange(this.page);
            }
        };
        // Create page object used in template
        // Create page object used in template
        /**
         * @protected
         * @param {?} num
         * @param {?} text
         * @param {?} active
         * @return {?}
         */
        PagerComponent.prototype.makePage = 
        // Create page object used in template
        /**
         * @protected
         * @param {?} num
         * @param {?} text
         * @param {?} active
         * @return {?}
         */
        function (num, text, active) {
            return { text: text, number: num, active: active };
        };
        /**
         * @protected
         * @param {?} currentPage
         * @param {?} totalPages
         * @return {?}
         */
        PagerComponent.prototype.getPages = /**
         * @protected
         * @param {?} currentPage
         * @param {?} totalPages
         * @return {?}
         */
        function (currentPage, totalPages) {
            /** @type {?} */
            var pages = [];
            // Default page limits
            /** @type {?} */
            var startPage = 1;
            /** @type {?} */
            var endPage = totalPages;
            /** @type {?} */
            var isMaxSized = typeof this.maxSize !== 'undefined' && this.maxSize < totalPages;
            // recompute if maxSize
            if (isMaxSized) {
                if (this.rotate) {
                    // Current page is displayed in the middle of the visible ones
                    startPage = Math.max(currentPage - Math.floor(this.maxSize / 2), 1);
                    endPage = startPage + this.maxSize - 1;
                    // Adjust if limit is exceeded
                    if (endPage > totalPages) {
                        endPage = totalPages;
                        startPage = endPage - this.maxSize + 1;
                    }
                }
                else {
                    // Visible pages are paginated with maxSize
                    startPage =
                        (Math.ceil(currentPage / this.maxSize) - 1) * this.maxSize + 1;
                    // Adjust last page if limit is exceeded
                    endPage = Math.min(startPage + this.maxSize - 1, totalPages);
                }
            }
            // Add page number links
            for (var num = startPage; num <= endPage; num++) {
                /** @type {?} */
                var page = this.makePage(num, num.toString(), num === currentPage);
                pages.push(page);
            }
            // Add links to move between page sets
            if (isMaxSized && !this.rotate) {
                if (startPage > 1) {
                    /** @type {?} */
                    var previousPageSet = this.makePage(startPage - 1, '...', false);
                    pages.unshift(previousPageSet);
                }
                if (endPage < totalPages) {
                    /** @type {?} */
                    var nextPageSet = this.makePage(endPage + 1, '...', false);
                    pages.push(nextPageSet);
                }
            }
            return pages;
        };
        // base class
        // base class
        /**
         * @protected
         * @return {?}
         */
        PagerComponent.prototype.calculateTotalPages = 
        // base class
        /**
         * @protected
         * @return {?}
         */
        function () {
            /** @type {?} */
            var totalPages = this.itemsPerPage < 1
                ? 1
                : Math.ceil(this.totalItems / this.itemsPerPage);
            return Math.max(totalPages || 0, 1);
        };
        PagerComponent.decorators = [
            { type: core.Component, args: [{
                        selector: 'pager',
                        template: "<ul class=\"pager\">\n  <li [class.disabled]=\"noPrevious()\" [class.previous]=\"align\"\n      [ngClass]=\"{'pull-left': align, 'float-left': align}\"\n      class=\"{{ pageBtnClass }}\">\n    <a href (click)=\"selectPage(page - 1, $event)\">{{ getText('previous') }}</a>\n  </li>\n  <li [class.disabled]=\"noNext()\" [class.next]=\"align\"\n      [ngClass]=\"{'pull-right': align, 'float-right': align}\"\n      class=\"{{ pageBtnClass }}\">\n    <a href (click)=\"selectPage(page + 1, $event)\">{{ getText('next') }}</a>\n  </li>\n</ul>\n",
                        providers: [PAGER_CONTROL_VALUE_ACCESSOR]
                    }] }
        ];
        /** @nocollapse */
        PagerComponent.ctorParameters = function () { return [
            { type: core.ElementRef },
            { type: PaginationConfig },
            { type: core.ChangeDetectorRef }
        ]; };
        PagerComponent.propDecorators = {
            align: [{ type: core.Input }],
            maxSize: [{ type: core.Input }],
            boundaryLinks: [{ type: core.Input }],
            directionLinks: [{ type: core.Input }],
            firstText: [{ type: core.Input }],
            previousText: [{ type: core.Input }],
            nextText: [{ type: core.Input }],
            lastText: [{ type: core.Input }],
            rotate: [{ type: core.Input }],
            pageBtnClass: [{ type: core.Input }],
            disabled: [{ type: core.Input }],
            numPages: [{ type: core.Output }],
            pageChanged: [{ type: core.Output }],
            itemsPerPage: [{ type: core.Input }],
            totalItems: [{ type: core.Input }]
        };
        return PagerComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var PAGINATION_CONTROL_VALUE_ACCESSOR = {
        provide: forms.NG_VALUE_ACCESSOR,
        /* tslint:disable-next-line: no-use-before-declare */
        useExisting: core.forwardRef((/**
         * @return {?}
         */
        function () { return PaginationComponent; })),
        multi: true
    };
    var PaginationComponent = /** @class */ (function () {
        function PaginationComponent(elementRef, paginationConfig, changeDetection) {
            this.elementRef = elementRef;
            this.changeDetection = changeDetection;
            /**
             * fired when total pages count changes, $event:number equals to total pages count
             */
            this.numPages = new core.EventEmitter();
            /**
             * fired when page was changed, $event:{page, itemsPerPage} equals to object
             * with current page index and number of items per page
             */
            this.pageChanged = new core.EventEmitter();
            this.onChange = Function.prototype;
            this.onTouched = Function.prototype;
            this.inited = false;
            this._page = 1;
            this.elementRef = elementRef;
            if (!this.config) {
                this.configureOptions(paginationConfig.main);
            }
        }
        Object.defineProperty(PaginationComponent.prototype, "itemsPerPage", {
            /** maximum number of items per page. If value less than 1 will display all items on one page */
            get: /**
             * maximum number of items per page. If value less than 1 will display all items on one page
             * @return {?}
             */
            function () {
                return this._itemsPerPage;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */
            function (v) {
                this._itemsPerPage = v;
                this.totalPages = this.calculateTotalPages();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaginationComponent.prototype, "totalItems", {
            /** total number of items in all pages */
            get: /**
             * total number of items in all pages
             * @return {?}
             */
            function () {
                return this._totalItems;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */
            function (v) {
                this._totalItems = v;
                this.totalPages = this.calculateTotalPages();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaginationComponent.prototype, "totalPages", {
            get: /**
             * @return {?}
             */
            function () {
                return this._totalPages;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */
            function (v) {
                this._totalPages = v;
                this.numPages.emit(v);
                if (this.inited) {
                    this.selectPage(this.page);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PaginationComponent.prototype, "page", {
            get: /**
             * @return {?}
             */
            function () {
                return this._page;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */
            function (value) {
                /** @type {?} */
                var _previous = this._page;
                this._page = value > this.totalPages ? this.totalPages : value || 1;
                this.changeDetection.markForCheck();
                if (_previous === this._page || typeof _previous === 'undefined') {
                    return;
                }
                this.pageChanged.emit({
                    page: this._page,
                    itemsPerPage: this.itemsPerPage
                });
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} config
         * @return {?}
         */
        PaginationComponent.prototype.configureOptions = /**
         * @param {?} config
         * @return {?}
         */
        function (config) {
            this.config = Object.assign({}, config);
        };
        /**
         * @return {?}
         */
        PaginationComponent.prototype.ngOnInit = /**
         * @return {?}
         */
        function () {
            if (typeof window !== 'undefined') {
                this.classMap = this.elementRef.nativeElement.getAttribute('class') || '';
            }
            // watch for maxSize
            this.maxSize =
                typeof this.maxSize !== 'undefined' ? this.maxSize : this.config.maxSize;
            this.rotate =
                typeof this.rotate !== 'undefined' ? this.rotate : this.config.rotate;
            this.boundaryLinks =
                typeof this.boundaryLinks !== 'undefined'
                    ? this.boundaryLinks
                    : this.config.boundaryLinks;
            this.directionLinks =
                typeof this.directionLinks !== 'undefined'
                    ? this.directionLinks
                    : this.config.directionLinks;
            this.pageBtnClass =
                typeof this.pageBtnClass !== 'undefined'
                    ? this.pageBtnClass
                    : this.config.pageBtnClass;
            // base class
            this.itemsPerPage =
                typeof this.itemsPerPage !== 'undefined'
                    ? this.itemsPerPage
                    : this.config.itemsPerPage;
            this.totalPages = this.calculateTotalPages();
            // this class
            this.pages = this.getPages(this.page, this.totalPages);
            this.inited = true;
        };
        /**
         * @param {?} value
         * @return {?}
         */
        PaginationComponent.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            this.page = value;
            this.pages = this.getPages(this.page, this.totalPages);
        };
        /**
         * @param {?} key
         * @return {?}
         */
        PaginationComponent.prototype.getText = /**
         * @param {?} key
         * @return {?}
         */
        function (key) {
            // tslint:disable-next-line:no-any
            return ((/** @type {?} */ (this)))[key + "Text"] || ((/** @type {?} */ (this))).config[key + "Text"];
        };
        /**
         * @return {?}
         */
        PaginationComponent.prototype.noPrevious = /**
         * @return {?}
         */
        function () {
            return this.page === 1;
        };
        /**
         * @return {?}
         */
        PaginationComponent.prototype.noNext = /**
         * @return {?}
         */
        function () {
            return this.page === this.totalPages;
        };
        /**
         * @param {?} fn
         * @return {?}
         */
        PaginationComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
        function (fn) {
            this.onChange = fn;
        };
        /**
         * @param {?} fn
         * @return {?}
         */
        PaginationComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
        function (fn) {
            this.onTouched = fn;
        };
        /**
         * @param {?} page
         * @param {?=} event
         * @return {?}
         */
        PaginationComponent.prototype.selectPage = /**
         * @param {?} page
         * @param {?=} event
         * @return {?}
         */
        function (page, event) {
            if (event) {
                event.preventDefault();
            }
            if (!this.disabled) {
                if (event && event.target) {
                    // tslint:disable-next-line:no-any
                    /** @type {?} */
                    var target = event.target;
                    target.blur();
                }
                this.writeValue(page);
                this.onChange(this.page);
            }
        };
        // Create page object used in template
        // Create page object used in template
        /**
         * @protected
         * @param {?} num
         * @param {?} text
         * @param {?} active
         * @return {?}
         */
        PaginationComponent.prototype.makePage = 
        // Create page object used in template
        /**
         * @protected
         * @param {?} num
         * @param {?} text
         * @param {?} active
         * @return {?}
         */
        function (num, text, active) {
            return { text: text, number: num, active: active };
        };
        /**
         * @protected
         * @param {?} currentPage
         * @param {?} totalPages
         * @return {?}
         */
        PaginationComponent.prototype.getPages = /**
         * @protected
         * @param {?} currentPage
         * @param {?} totalPages
         * @return {?}
         */
        function (currentPage, totalPages) {
            /** @type {?} */
            var pages = [];
            // Default page limits
            /** @type {?} */
            var startPage = 1;
            /** @type {?} */
            var endPage = totalPages;
            /** @type {?} */
            var isMaxSized = typeof this.maxSize !== 'undefined' && this.maxSize < totalPages;
            // recompute if maxSize
            if (isMaxSized) {
                if (this.rotate) {
                    // Current page is displayed in the middle of the visible ones
                    startPage = Math.max(currentPage - Math.floor(this.maxSize / 2), 1);
                    endPage = startPage + this.maxSize - 1;
                    // Adjust if limit is exceeded
                    if (endPage > totalPages) {
                        endPage = totalPages;
                        startPage = endPage - this.maxSize + 1;
                    }
                }
                else {
                    // Visible pages are paginated with maxSize
                    startPage =
                        (Math.ceil(currentPage / this.maxSize) - 1) * this.maxSize + 1;
                    // Adjust last page if limit is exceeded
                    endPage = Math.min(startPage + this.maxSize - 1, totalPages);
                }
            }
            // Add page number links
            for (var num = startPage; num <= endPage; num++) {
                /** @type {?} */
                var page = this.makePage(num, num.toString(), num === currentPage);
                pages.push(page);
            }
            // Add links to move between page sets
            if (isMaxSized && !this.rotate) {
                if (startPage > 1) {
                    /** @type {?} */
                    var previousPageSet = this.makePage(startPage - 1, '...', false);
                    pages.unshift(previousPageSet);
                }
                if (endPage < totalPages) {
                    /** @type {?} */
                    var nextPageSet = this.makePage(endPage + 1, '...', false);
                    pages.push(nextPageSet);
                }
            }
            return pages;
        };
        // base class
        // base class
        /**
         * @protected
         * @return {?}
         */
        PaginationComponent.prototype.calculateTotalPages = 
        // base class
        /**
         * @protected
         * @return {?}
         */
        function () {
            /** @type {?} */
            var totalPages = this.itemsPerPage < 1
                ? 1
                : Math.ceil(this.totalItems / this.itemsPerPage);
            return Math.max(totalPages || 0, 1);
        };
        PaginationComponent.decorators = [
            { type: core.Component, args: [{
                        selector: 'pagination',
                        template: "<ul class=\"pagination\" [ngClass]=\"classMap\">\n  <li class=\"pagination-first page-item\"\n      *ngIf=\"boundaryLinks\"\n      [class.disabled]=\"noPrevious()||disabled\">\n    <a class=\"page-link\" href (click)=\"selectPage(1, $event)\"\n       [innerHTML]=\"getText('first')\"></a>\n  </li>\n\n  <li class=\"pagination-prev page-item\"\n      *ngIf=\"directionLinks\"\n      [class.disabled]=\"noPrevious()||disabled\">\n    <a class=\"page-link\" href (click)=\"selectPage(page - 1, $event)\"\n       [innerHTML]=\"getText('previous')\"></a>\n  </li>\n\n  <li *ngFor=\"let pg of pages\"\n      [class.active]=\"pg.active\"\n      [class.disabled]=\"disabled&&!pg.active\"\n      class=\"pagination-page page-item\">\n    <a class=\"page-link\" href (click)=\"selectPage(pg.number, $event)\"\n       [innerHTML]=\"pg.text\"></a>\n  </li>\n\n  <li class=\"pagination-next page-item\"\n      *ngIf=\"directionLinks\"\n      [class.disabled]=\"noNext()||disabled\">\n    <a class=\"page-link\" href (click)=\"selectPage(page + 1, $event)\"\n       [innerHTML]=\"getText('next')\"></a></li>\n\n  <li class=\"pagination-last page-item\"\n      *ngIf=\"boundaryLinks\"\n      [class.disabled]=\"noNext()||disabled\">\n    <a class=\"page-link\" href (click)=\"selectPage(totalPages, $event)\"\n       [innerHTML]=\"getText('last')\"></a></li>\n</ul>\n",
                        providers: [PAGINATION_CONTROL_VALUE_ACCESSOR]
                    }] }
        ];
        /** @nocollapse */
        PaginationComponent.ctorParameters = function () { return [
            { type: core.ElementRef },
            { type: PaginationConfig },
            { type: core.ChangeDetectorRef }
        ]; };
        PaginationComponent.propDecorators = {
            align: [{ type: core.Input }],
            maxSize: [{ type: core.Input }],
            boundaryLinks: [{ type: core.Input }],
            directionLinks: [{ type: core.Input }],
            firstText: [{ type: core.Input }],
            previousText: [{ type: core.Input }],
            nextText: [{ type: core.Input }],
            lastText: [{ type: core.Input }],
            rotate: [{ type: core.Input }],
            pageBtnClass: [{ type: core.Input }],
            disabled: [{ type: core.Input }],
            numPages: [{ type: core.Output }],
            pageChanged: [{ type: core.Output }],
            itemsPerPage: [{ type: core.Input }],
            totalItems: [{ type: core.Input }]
        };
        return PaginationComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var PaginationModule = /** @class */ (function () {
        function PaginationModule() {
        }
        /**
         * @return {?}
         */
        PaginationModule.forRoot = /**
         * @return {?}
         */
        function () {
            return { ngModule: PaginationModule, providers: [PaginationConfig] };
        };
        PaginationModule.decorators = [
            { type: core.NgModule, args: [{
                        imports: [common.CommonModule],
                        declarations: [PagerComponent, PaginationComponent],
                        exports: [PagerComponent, PaginationComponent]
                    },] }
        ];
        return PaginationModule;
    }());

    exports.PagerComponent = PagerComponent;
    exports.PaginationComponent = PaginationComponent;
    exports.PaginationConfig = PaginationConfig;
    exports.PaginationModule = PaginationModule;
    exports.ɵa = PAGER_CONTROL_VALUE_ACCESSOR;
    exports.ɵb = PAGINATION_CONTROL_VALUE_ACCESSOR;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=ngx-bootstrap-pagination.umd.js.map
