/**
 * Configuration service for the Popover directive.
 * You can inject this service, typically in your root component, and customize
 * the values of its properties in order to provide default values for all the
 * popovers used in the application.
 */
export declare class PopoverConfig {
    /** sets disable adaptive position */
    adaptivePosition: boolean;
    /**
     * Placement of a popover. Accepts: "top", "bottom", "left", "right", "auto"
     */
    placement: string;
    /**
     * Specifies events that should trigger. Supports a space separated list of
     * event names.
     */
    triggers: string;
    outsideClick: boolean;
    /**
     * A selector specifying the element the popover should be appended to.
     */
    container: string;
    /** delay before showing the tooltip */
    delay: number;
}
