/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
/**
 * Default values provider for tooltip
 */
export class TooltipConfig {
    constructor() {
        /**
         * sets disable adaptive position
         */
        this.adaptivePosition = true;
        /**
         * tooltip placement, supported positions: 'top', 'bottom', 'left', 'right'
         */
        this.placement = 'top';
        /**
         * array of event names which triggers tooltip opening
         */
        this.triggers = 'hover focus';
        /**
         * delay before showing the tooltip
         */
        this.delay = 0;
    }
}
TooltipConfig.decorators = [
    { type: Injectable }
];
if (false) {
    /**
     * sets disable adaptive position
     * @type {?}
     */
    TooltipConfig.prototype.adaptivePosition;
    /**
     * tooltip placement, supported positions: 'top', 'bottom', 'left', 'right'
     * @type {?}
     */
    TooltipConfig.prototype.placement;
    /**
     * array of event names which triggers tooltip opening
     * @type {?}
     */
    TooltipConfig.prototype.triggers;
    /**
     * a selector specifying the element the tooltip should be appended to.
     * @type {?}
     */
    TooltipConfig.prototype.container;
    /**
     * delay before showing the tooltip
     * @type {?}
     */
    TooltipConfig.prototype.delay;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9vbHRpcC5jb25maWcuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9uZ3gtYm9vdHN0cmFwL3Rvb2x0aXAvIiwic291cmNlcyI6WyJ0b29sdGlwLmNvbmZpZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBQUEsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLGVBQWUsQ0FBQzs7OztBQUkzQyxNQUFNLE9BQU8sYUFBYTtJQUQxQjs7OztRQUdFLHFCQUFnQixHQUFHLElBQUksQ0FBQzs7OztRQUV4QixjQUFTLEdBQUcsS0FBSyxDQUFDOzs7O1FBRWxCLGFBQVEsR0FBRyxhQUFhLENBQUM7Ozs7UUFJekIsVUFBSyxHQUFHLENBQUMsQ0FBQztJQUNaLENBQUM7OztZQVpBLFVBQVU7Ozs7Ozs7SUFHVCx5Q0FBd0I7Ozs7O0lBRXhCLGtDQUFrQjs7Ozs7SUFFbEIsaUNBQXlCOzs7OztJQUV6QixrQ0FBa0I7Ozs7O0lBRWxCLDhCQUFVIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW5qZWN0YWJsZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuXG4vKiogRGVmYXVsdCB2YWx1ZXMgcHJvdmlkZXIgZm9yIHRvb2x0aXAgKi9cbkBJbmplY3RhYmxlKClcbmV4cG9ydCBjbGFzcyBUb29sdGlwQ29uZmlnIHtcbiAgLyoqIHNldHMgZGlzYWJsZSBhZGFwdGl2ZSBwb3NpdGlvbiAqL1xuICBhZGFwdGl2ZVBvc2l0aW9uID0gdHJ1ZTtcbiAgLyoqIHRvb2x0aXAgcGxhY2VtZW50LCBzdXBwb3J0ZWQgcG9zaXRpb25zOiAndG9wJywgJ2JvdHRvbScsICdsZWZ0JywgJ3JpZ2h0JyAqL1xuICBwbGFjZW1lbnQgPSAndG9wJztcbiAgLyoqIGFycmF5IG9mIGV2ZW50IG5hbWVzIHdoaWNoIHRyaWdnZXJzIHRvb2x0aXAgb3BlbmluZyAqL1xuICB0cmlnZ2VycyA9ICdob3ZlciBmb2N1cyc7XG4gIC8qKiBhIHNlbGVjdG9yIHNwZWNpZnlpbmcgdGhlIGVsZW1lbnQgdGhlIHRvb2x0aXAgc2hvdWxkIGJlIGFwcGVuZGVkIHRvLiAqL1xuICBjb250YWluZXI6IHN0cmluZztcbiAgLyoqIGRlbGF5IGJlZm9yZSBzaG93aW5nIHRoZSB0b29sdGlwICovXG4gIGRlbGF5ID0gMDtcbn1cbiJdfQ==