(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core')) :
    typeof define === 'function' && define.amd ? define('ngx-bootstrap/utils', ['exports', '@angular/core'], factory) :
    (global = global || self, factory((global['ngx-bootstrap'] = global['ngx-bootstrap'] || {}, global['ngx-bootstrap'].utils = {}), global.ng.core));
}(this, function (exports, core) { 'use strict';

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /**
     * @copyright Valor Software
     * @copyright Angular ng-bootstrap team
     */
    var Trigger = /** @class */ (function () {
        function Trigger(open, close) {
            this.open = open;
            this.close = close || open;
        }
        /**
         * @return {?}
         */
        Trigger.prototype.isManual = /**
         * @return {?}
         */
        function () {
            return this.open === 'manual' || this.close === 'manual';
        };
        return Trigger;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var DEFAULT_ALIASES = {
        hover: ['mouseover', 'mouseout'],
        focus: ['focusin', 'focusout']
    };
    /* tslint:disable-next-line: no-any */
    /**
     * @param {?} triggers
     * @param {?=} aliases
     * @return {?}
     */
    function parseTriggers(triggers, aliases) {
        if (aliases === void 0) { aliases = DEFAULT_ALIASES; }
        /** @type {?} */
        var trimmedTriggers = (triggers || '').trim();
        if (trimmedTriggers.length === 0) {
            return [];
        }
        /** @type {?} */
        var parsedTriggers = trimmedTriggers
            .split(/\s+/)
            .map((/**
         * @param {?} trigger
         * @return {?}
         */
        function (trigger) { return trigger.split(':'); }))
            .map((/**
         * @param {?} triggerPair
         * @return {?}
         */
        function (triggerPair) {
            /** @type {?} */
            var alias = aliases[triggerPair[0]] || triggerPair;
            return new Trigger(alias[0], alias[1]);
        }));
        /** @type {?} */
        var manualTriggers = parsedTriggers.filter((/**
         * @param {?} triggerPair
         * @return {?}
         */
        function (triggerPair) {
            return triggerPair.isManual();
        }));
        if (manualTriggers.length > 1) {
            throw new Error('Triggers parse error: only one manual trigger is allowed');
        }
        if (manualTriggers.length === 1 && parsedTriggers.length > 1) {
            throw new Error('Triggers parse error: manual trigger can\'t be mixed with other triggers');
        }
        return parsedTriggers;
    }
    /**
     * @param {?} renderer
     * @param {?} target
     * @param {?} triggers
     * @param {?} showFn
     * @param {?} hideFn
     * @param {?} toggleFn
     * @return {?}
     */
    function listenToTriggers(renderer, 
    /* tslint:disable-next-line: no-any */
    target, triggers, showFn, hideFn, toggleFn) {
        /** @type {?} */
        var parsedTriggers = parseTriggers(triggers);
        /* tslint:disable-next-line: no-any */
        /** @type {?} */
        var listeners = [];
        if (parsedTriggers.length === 1 && parsedTriggers[0].isManual()) {
            return Function.prototype;
        }
        parsedTriggers.forEach((/**
         * @param {?} trigger
         * @return {?}
         */
        function (trigger) {
            if (trigger.open === trigger.close) {
                listeners.push(renderer.listen(target, trigger.open, toggleFn));
                return;
            }
            listeners.push(renderer.listen(target, trigger.open, showFn), renderer.listen(target, trigger.close, hideFn));
        }));
        return (/**
         * @return {?}
         */
        function () {
            listeners.forEach((/**
             * @param {?} unsubscribeFn
             * @return {?}
             */
            function (unsubscribeFn) { return unsubscribeFn(); }));
        });
    }
    /**
     * @param {?} renderer
     * @param {?} options
     * @return {?}
     */
    function listenToTriggersV2(renderer, options) {
        /** @type {?} */
        var parsedTriggers = parseTriggers(options.triggers);
        /** @type {?} */
        var target = options.target;
        // do nothing
        if (parsedTriggers.length === 1 && parsedTriggers[0].isManual()) {
            return Function.prototype;
        }
        // all listeners
        /* tslint:disable-next-line: no-any */
        /** @type {?} */
        var listeners = [];
        // lazy listeners registration
        /** @type {?} */
        var _registerHide = [];
        /** @type {?} */
        var registerHide = (/**
         * @return {?}
         */
        function () {
            // add hide listeners to unregister array
            _registerHide.forEach((/**
             * @param {?} fn
             * @return {?}
             */
            function (fn) { return listeners.push(fn()); }));
            // register hide events only once
            _registerHide.length = 0;
        });
        // register open\close\toggle listeners
        parsedTriggers.forEach((/**
         * @param {?} trigger
         * @return {?}
         */
        function (trigger) {
            /** @type {?} */
            var useToggle = trigger.open === trigger.close;
            /** @type {?} */
            var showFn = useToggle ? options.toggle : options.show;
            if (!useToggle) {
                _registerHide.push((/**
                 * @return {?}
                 */
                function () {
                    return renderer.listen(target, trigger.close, options.hide);
                }));
            }
            listeners.push(renderer.listen(target, trigger.open, (/**
             * @return {?}
             */
            function () { return showFn(registerHide); })));
        }));
        return (/**
         * @return {?}
         */
        function () {
            listeners.forEach((/**
             * @param {?} unsubscribeFn
             * @return {?}
             */
            function (unsubscribeFn) { return unsubscribeFn(); }));
        });
    }
    /**
     * @param {?} renderer
     * @param {?} options
     * @return {?}
     */
    function registerOutsideClick(renderer, options) {
        if (!options.outsideClick) {
            return Function.prototype;
        }
        /* tslint:disable-next-line: no-any */
        return renderer.listen('document', 'click', (/**
         * @param {?} event
         * @return {?}
         */
        function (event) {
            if (options.target && options.target.contains(event.target)) {
                return undefined;
            }
            if (options.targets &&
                options.targets.some((/**
                 * @param {?} target
                 * @return {?}
                 */
                function (target) { return target.contains(event.target); }))) {
                return undefined;
            }
            options.hide();
        }));
    }
    /**
     * @param {?} renderer
     * @param {?} options
     * @return {?}
     */
    function registerEscClick(renderer, options) {
        if (!options.outsideEsc) {
            return Function.prototype;
        }
        return renderer.listen('document', 'keyup.esc', (/**
         * @param {?} event
         * @return {?}
         */
        function (event) {
            if (options.target && options.target.contains(event.target)) {
                return undefined;
            }
            if (options.targets &&
                options.targets.some((/**
                 * @param {?} target
                 * @return {?}
                 */
                function (target) { return target.contains(event.target); }))) {
                return undefined;
            }
            options.hide();
        }));
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * JS version of browser APIs. This library can only run in the browser.
     * @type {?}
     */
    var win = (typeof window !== 'undefined' && window) || (/** @type {?} */ ({}));
    /** @type {?} */
    var document$1 = win.document;
    /** @type {?} */
    var location = win.location;
    /** @type {?} */
    var gc = win.gc ? (/**
     * @return {?}
     */
    function () { return win.gc(); }) : (/**
     * @return {?}
     */
    function () { return null; });
    /** @type {?} */
    var performance = win.performance ? win.performance : null;
    /** @type {?} */
    var Event = win.Event;
    /** @type {?} */
    var MouseEvent = win.MouseEvent;
    /** @type {?} */
    var KeyboardEvent = win.KeyboardEvent;
    /** @type {?} */
    var EventTarget = win.EventTarget;
    /** @type {?} */
    var History = win.History;
    /** @type {?} */
    var Location = win.Location;
    /** @type {?} */
    var EventListener = win.EventListener;

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var guessedVersion;
    /**
     * @return {?}
     */
    function _guessBsVersion() {
        if (typeof document === 'undefined') {
            return null;
        }
        /** @type {?} */
        var spanEl = document.createElement('span');
        spanEl.innerText = 'test bs version';
        document.body.appendChild(spanEl);
        spanEl.classList.add('d-none');
        /** @type {?} */
        var rect = spanEl.getBoundingClientRect();
        document.body.removeChild(spanEl);
        if (!rect) {
            return 'bs3';
        }
        return rect.top === 0 ? 'bs4' : 'bs3';
    }
    /**
     * @param {?} theme
     * @return {?}
     */
    function setTheme(theme) {
        guessedVersion = theme;
    }
    // todo: in ngx-bootstrap, bs4 will became a default one
    /**
     * @return {?}
     */
    function isBs3() {
        if (typeof win === 'undefined') {
            return true;
        }
        if (typeof win.__theme === 'undefined') {
            if (guessedVersion) {
                return guessedVersion === 'bs3';
            }
            guessedVersion = _guessBsVersion();
            return guessedVersion === 'bs3';
        }
        return win.__theme !== 'bs4';
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /**
     * @template T
     */
    var   /**
     * @template T
     */
    LinkedList = /** @class */ (function () {
        function LinkedList() {
            this.length = 0;
            this.asArray = [];
            // Array methods overriding END
        }
        /**
         * @param {?} position
         * @return {?}
         */
        LinkedList.prototype.get = /**
         * @param {?} position
         * @return {?}
         */
        function (position) {
            if (this.length === 0 || position < 0 || position >= this.length) {
                return void 0;
            }
            /** @type {?} */
            var current = this.head;
            for (var index = 0; index < position; index++) {
                current = current.next;
            }
            return current.value;
        };
        /**
         * @param {?} value
         * @param {?=} position
         * @return {?}
         */
        LinkedList.prototype.add = /**
         * @param {?} value
         * @param {?=} position
         * @return {?}
         */
        function (value, position) {
            if (position === void 0) { position = this.length; }
            if (position < 0 || position > this.length) {
                throw new Error('Position is out of the list');
            }
            /* tslint:disable-next-line: no-any*/
            /** @type {?} */
            var node = {
                value: value,
                next: undefined,
                previous: undefined
            };
            if (this.length === 0) {
                this.head = node;
                this.tail = node;
                this.current = node;
            }
            else {
                if (position === 0) {
                    // first node
                    node.next = this.head;
                    this.head.previous = node;
                    this.head = node;
                }
                else if (position === this.length) {
                    // last node
                    this.tail.next = node;
                    node.previous = this.tail;
                    this.tail = node;
                }
                else {
                    // node in middle
                    /** @type {?} */
                    var currentPreviousNode = this.getNode(position - 1);
                    /** @type {?} */
                    var currentNextNode = currentPreviousNode.next;
                    currentPreviousNode.next = node;
                    currentNextNode.previous = node;
                    node.previous = currentPreviousNode;
                    node.next = currentNextNode;
                }
            }
            this.length++;
            this.createInternalArrayRepresentation();
        };
        /**
         * @param {?=} position
         * @return {?}
         */
        LinkedList.prototype.remove = /**
         * @param {?=} position
         * @return {?}
         */
        function (position) {
            if (position === void 0) { position = 0; }
            if (this.length === 0 || position < 0 || position >= this.length) {
                throw new Error('Position is out of the list');
            }
            if (position === 0) {
                // first node
                this.head = this.head.next;
                if (this.head) {
                    // there is no second node
                    this.head.previous = undefined;
                }
                else {
                    // there is no second node
                    this.tail = undefined;
                }
            }
            else if (position === this.length - 1) {
                // last node
                this.tail = this.tail.previous;
                this.tail.next = undefined;
            }
            else {
                // middle node
                /** @type {?} */
                var removedNode = this.getNode(position);
                removedNode.next.previous = removedNode.previous;
                removedNode.previous.next = removedNode.next;
            }
            this.length--;
            this.createInternalArrayRepresentation();
        };
        /**
         * @param {?} position
         * @param {?} value
         * @return {?}
         */
        LinkedList.prototype.set = /**
         * @param {?} position
         * @param {?} value
         * @return {?}
         */
        function (position, value) {
            if (this.length === 0 || position < 0 || position >= this.length) {
                throw new Error('Position is out of the list');
            }
            /** @type {?} */
            var node = this.getNode(position);
            node.value = value;
            this.createInternalArrayRepresentation();
        };
        /**
         * @return {?}
         */
        LinkedList.prototype.toArray = /**
         * @return {?}
         */
        function () {
            return this.asArray;
        };
        /* tslint:disable-next-line: no-any*/
        /* tslint:disable-next-line: no-any*/
        /**
         * @param {?} fn
         * @return {?}
         */
        LinkedList.prototype.findAll = /* tslint:disable-next-line: no-any*/
        /**
         * @param {?} fn
         * @return {?}
         */
        function (fn) {
            /** @type {?} */
            var current = this.head;
            /* tslint:disable-next-line: no-any*/
            /** @type {?} */
            var result = [];
            for (var index = 0; index < this.length; index++) {
                if (fn(current.value, index)) {
                    result.push({ index: index, value: current.value });
                }
                current = current.next;
            }
            return result;
        };
        // Array methods overriding start
        // Array methods overriding start
        /**
         * @param {...?} args
         * @return {?}
         */
        LinkedList.prototype.push = 
        // Array methods overriding start
        /**
         * @param {...?} args
         * @return {?}
         */
        function () {
            var _this = this;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            /* tslint:disable-next-line: no-any*/
            args.forEach((/**
             * @param {?} arg
             * @return {?}
             */
            function (arg) {
                _this.add(arg);
            }));
            return this.length;
        };
        /**
         * @return {?}
         */
        LinkedList.prototype.pop = /**
         * @return {?}
         */
        function () {
            if (this.length === 0) {
                return undefined;
            }
            /** @type {?} */
            var last = this.tail;
            this.remove(this.length - 1);
            return last.value;
        };
        /**
         * @param {...?} args
         * @return {?}
         */
        LinkedList.prototype.unshift = /**
         * @param {...?} args
         * @return {?}
         */
        function () {
            var _this = this;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            args.reverse();
            /* tslint:disable-next-line: no-any*/
            args.forEach((/**
             * @param {?} arg
             * @return {?}
             */
            function (arg) {
                _this.add(arg, 0);
            }));
            return this.length;
        };
        /**
         * @return {?}
         */
        LinkedList.prototype.shift = /**
         * @return {?}
         */
        function () {
            if (this.length === 0) {
                return undefined;
            }
            /** @type {?} */
            var lastItem = this.head.value;
            this.remove();
            return lastItem;
        };
        /* tslint:disable-next-line: no-any*/
        /* tslint:disable-next-line: no-any*/
        /**
         * @param {?} fn
         * @return {?}
         */
        LinkedList.prototype.forEach = /* tslint:disable-next-line: no-any*/
        /**
         * @param {?} fn
         * @return {?}
         */
        function (fn) {
            /** @type {?} */
            var current = this.head;
            for (var index = 0; index < this.length; index++) {
                fn(current.value, index);
                current = current.next;
            }
        };
        /**
         * @param {?} value
         * @return {?}
         */
        LinkedList.prototype.indexOf = /**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            /** @type {?} */
            var current = this.head;
            /** @type {?} */
            var position = 0;
            for (var index = 0; index < this.length; index++) {
                if (current.value === value) {
                    position = index;
                    break;
                }
                current = current.next;
            }
            return position;
        };
        /* tslint:disable-next-line: no-any*/
        /* tslint:disable-next-line: no-any*/
        /**
         * @param {?} fn
         * @return {?}
         */
        LinkedList.prototype.some = /* tslint:disable-next-line: no-any*/
        /**
         * @param {?} fn
         * @return {?}
         */
        function (fn) {
            /** @type {?} */
            var current = this.head;
            /** @type {?} */
            var result = false;
            while (current && !result) {
                if (fn(current.value)) {
                    result = true;
                    break;
                }
                current = current.next;
            }
            return result;
        };
        /* tslint:disable-next-line: no-any*/
        /* tslint:disable-next-line: no-any*/
        /**
         * @param {?} fn
         * @return {?}
         */
        LinkedList.prototype.every = /* tslint:disable-next-line: no-any*/
        /**
         * @param {?} fn
         * @return {?}
         */
        function (fn) {
            /** @type {?} */
            var current = this.head;
            /** @type {?} */
            var result = true;
            while (current && result) {
                if (!fn(current.value)) {
                    result = false;
                }
                current = current.next;
            }
            return result;
        };
        /**
         * @return {?}
         */
        LinkedList.prototype.toString = /**
         * @return {?}
         */
        function () {
            return '[Linked List]';
        };
        /* tslint:disable-next-line: no-any*/
        /* tslint:disable-next-line: no-any*/
        /**
         * @param {?} fn
         * @return {?}
         */
        LinkedList.prototype.find = /* tslint:disable-next-line: no-any*/
        /**
         * @param {?} fn
         * @return {?}
         */
        function (fn) {
            /** @type {?} */
            var current = this.head;
            /** @type {?} */
            var result;
            for (var index = 0; index < this.length; index++) {
                if (fn(current.value, index)) {
                    result = current.value;
                    break;
                }
                current = current.next;
            }
            return result;
        };
        /* tslint:disable-next-line: no-any*/
        /* tslint:disable-next-line: no-any*/
        /**
         * @param {?} fn
         * @return {?}
         */
        LinkedList.prototype.findIndex = /* tslint:disable-next-line: no-any*/
        /**
         * @param {?} fn
         * @return {?}
         */
        function (fn) {
            /** @type {?} */
            var current = this.head;
            /** @type {?} */
            var result;
            for (var index = 0; index < this.length; index++) {
                if (fn(current.value, index)) {
                    result = index;
                    break;
                }
                current = current.next;
            }
            return result;
        };
        /* tslint:disable-next-line: no-any*/
        /* tslint:disable-next-line: no-any*/
        /**
         * @protected
         * @param {?} position
         * @return {?}
         */
        LinkedList.prototype.getNode = /* tslint:disable-next-line: no-any*/
        /**
         * @protected
         * @param {?} position
         * @return {?}
         */
        function (position) {
            if (this.length === 0 || position < 0 || position >= this.length) {
                throw new Error('Position is out of the list');
            }
            /** @type {?} */
            var current = this.head;
            for (var index = 0; index < position; index++) {
                current = current.next;
            }
            return current;
        };
        /**
         * @protected
         * @return {?}
         */
        LinkedList.prototype.createInternalArrayRepresentation = /**
         * @protected
         * @return {?}
         */
        function () {
            /* tslint:disable-next-line: no-any*/
            /** @type {?} */
            var outArray = [];
            /** @type {?} */
            var current = this.head;
            while (current) {
                outArray.push(current.value);
                current = current.next;
            }
            this.asArray = outArray;
        };
        return LinkedList;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /*tslint:disable:no-invalid-this */
    /* tslint:disable-next-line: no-any */
    /**
     * @param {?=} defaultValue
     * @return {?}
     */
    function OnChange(defaultValue) {
        /** @type {?} */
        var sufix = 'Change';
        /* tslint:disable-next-line: no-any */
        return (/**
         * @param {?} target
         * @param {?} propertyKey
         * @return {?}
         */
        function OnChangeHandler(target, propertyKey) {
            /** @type {?} */
            var _key = " __" + propertyKey + "Value";
            Object.defineProperty(target, propertyKey, {
                /* tslint:disable-next-line: no-any */
                get: /* tslint:disable-next-line: no-any */
                /**
                 * @return {?}
                 */
                function () {
                    return this[_key];
                },
                /* tslint:disable-next-line: no-any */
                set: /* tslint:disable-next-line: no-any */
                /**
                 * @param {?} value
                 * @return {?}
                 */
                function (value) {
                    /** @type {?} */
                    var prevValue = this[_key];
                    this[_key] = value;
                    if (prevValue !== value && this[propertyKey + sufix]) {
                        this[propertyKey + sufix].emit(value);
                    }
                }
            });
        });
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var Utils = /** @class */ (function () {
        function Utils() {
        }
        /* tslint:disable-next-line: no-any */
        /* tslint:disable-next-line: no-any */
        /**
         * @param {?} element
         * @return {?}
         */
        Utils.reflow = /* tslint:disable-next-line: no-any */
        /**
         * @param {?} element
         * @return {?}
         */
        function (element) {
            /* tslint:disable-next-line: no-any */
            ((/**
             * @param {?} bs
             * @return {?}
             */
            function (bs) { return bs; }))(element.offsetHeight);
        };
        // source: https://github.com/jquery/jquery/blob/master/src/css/var/getStyles.js
        /* tslint:disable-next-line: no-any */
        // source: https://github.com/jquery/jquery/blob/master/src/css/var/getStyles.js
        /* tslint:disable-next-line: no-any */
        /**
         * @param {?} elem
         * @return {?}
         */
        Utils.getStyles = 
        // source: https://github.com/jquery/jquery/blob/master/src/css/var/getStyles.js
        /* tslint:disable-next-line: no-any */
        /**
         * @param {?} elem
         * @return {?}
         */
        function (elem) {
            // Support: IE <=11 only, Firefox <=30 (#15098, #14150)
            // IE throws on elements created in popups
            // FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
            /** @type {?} */
            var view = elem.ownerDocument.defaultView;
            if (!view || !view.opener) {
                view = win;
            }
            return view.getComputedStyle(elem);
        };
        return Utils;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var _messagesHash = {};
    /** @type {?} */
    var _hideMsg = typeof console === 'undefined' || !('warn' in console);
    /**
     * @param {?} msg
     * @return {?}
     */
    function warnOnce(msg) {
        if (!core.isDevMode() || _hideMsg || msg in _messagesHash) {
            return;
        }
        _messagesHash[msg] = true;
        /*tslint:disable-next-line*/
        console.warn(msg);
    }

    exports.LinkedList = LinkedList;
    exports.OnChange = OnChange;
    exports.Trigger = Trigger;
    exports.Utils = Utils;
    exports.document = document$1;
    exports.isBs3 = isBs3;
    exports.listenToTriggers = listenToTriggers;
    exports.listenToTriggersV2 = listenToTriggersV2;
    exports.parseTriggers = parseTriggers;
    exports.registerEscClick = registerEscClick;
    exports.registerOutsideClick = registerOutsideClick;
    exports.setTheme = setTheme;
    exports.warnOnce = warnOnce;
    exports.window = win;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=ngx-bootstrap-utils.umd.js.map
