"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _fs = require("fs");

var prettier = _interopRequireWildcard(require("prettier"));

var _path = require("path");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var _default = (directory, files, {
  check,
  config,
  onExamineFile,
  onCheckFile,
  onWriteFile
} = {}) => {
  for (const relative of files) {
    onExamineFile && onExamineFile(relative);
    const file = (0, _path.join)(directory, relative);
    const options = Object.assign({}, prettier.resolveConfig.sync(file, {
      config,
      editorconfig: true
    }), {
      filepath: file
    });
    const input = (0, _fs.readFileSync)(file, 'utf8');

    if (check) {
      const isFormatted = prettier.check(input, options);
      onCheckFile && onCheckFile(relative, isFormatted);
      continue;
    }

    const output = prettier.format(input, options);

    if (output !== input) {
      (0, _fs.writeFileSync)(file, output);
      onWriteFile && onWriteFile(relative);
    }
  }
};

exports.default = _default;