/*
 * Decompiled with CFR 0.152.
 */
package pdftk.com.lowagie.text.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import pdftk.com.lowagie.text.Document;
import pdftk.com.lowagie.text.DocumentException;
import pdftk.com.lowagie.text.pdf.BadPdfFormatException;
import pdftk.com.lowagie.text.pdf.PRIndirectReference;
import pdftk.com.lowagie.text.pdf.PRStream;
import pdftk.com.lowagie.text.pdf.PdfAcroForm;
import pdftk.com.lowagie.text.pdf.PdfAnnotation;
import pdftk.com.lowagie.text.pdf.PdfArray;
import pdftk.com.lowagie.text.pdf.PdfBoolean;
import pdftk.com.lowagie.text.pdf.PdfContents;
import pdftk.com.lowagie.text.pdf.PdfDictionary;
import pdftk.com.lowagie.text.pdf.PdfDocument;
import pdftk.com.lowagie.text.pdf.PdfException;
import pdftk.com.lowagie.text.pdf.PdfImportedPage;
import pdftk.com.lowagie.text.pdf.PdfIndirectReference;
import pdftk.com.lowagie.text.pdf.PdfLiteral;
import pdftk.com.lowagie.text.pdf.PdfName;
import pdftk.com.lowagie.text.pdf.PdfObject;
import pdftk.com.lowagie.text.pdf.PdfOutline;
import pdftk.com.lowagie.text.pdf.PdfPage;
import pdftk.com.lowagie.text.pdf.PdfReader;
import pdftk.com.lowagie.text.pdf.PdfReaderInstance;
import pdftk.com.lowagie.text.pdf.PdfStream;
import pdftk.com.lowagie.text.pdf.PdfString;
import pdftk.com.lowagie.text.pdf.PdfWriter;

public class PdfCopy
extends PdfWriter {
    protected HashMap indirects = null;
    protected HashMap indirectMap = null;
    protected int currentObjectNum = 1;
    protected PdfReader reader = null;
    protected PdfIndirectReference topPageParent = null;
    protected ArrayList pageNumbersToRefs = new ArrayList();
    protected PdfIndirectReference m_new_bookmarks = null;
    protected PdfIndirectReference m_new_extensions = null;
    protected HashSet fullFormFieldNames = null;
    protected HashSet topFormFieldNames = null;
    protected HashMap topFormFieldReadersData = null;

    public PdfCopy(Document document, OutputStream os) throws DocumentException {
        super(os);
        document.addDocListener(this.getPdfDocument());
        this.getPdfDocument().setWriter(this);
        this.indirectMap = new HashMap();
        this.fullFormFieldNames = new HashSet();
        this.topFormFieldNames = new HashSet();
        this.topFormFieldReadersData = new HashMap();
    }

    @Override
    public void open() {
        super.open();
        this.topPageParent = this.getPdfIndirectReference();
        this.getRoot().setLinearMode(this.topPageParent);
    }

    @Override
    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber) throws IOException {
        if (this.currentPdfReaderInstance != null) {
            if (this.currentPdfReaderInstance.getReader() != reader) {
                try {
                    this.currentPdfReaderInstance.getReader().close();
                    this.currentPdfReaderInstance.getReaderFile().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.currentPdfReaderInstance = reader.getPdfReaderInstance(this);
            }
        } else {
            this.currentPdfReaderInstance = reader.getPdfReaderInstance(this);
        }
        return this.currentPdfReaderInstance.getImportedPage(pageNumber);
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        PRIndirectReference parent_iref;
        RefKey parent_key;
        IndirectReferences parent_ref;
        PdfObject parent_obj;
        PdfDictionary in_dict;
        PdfObject type;
        PdfObject in_obj;
        PdfIndirectReference retVal;
        RefKey key = new RefKey(in);
        IndirectReferences iRef = (IndirectReferences)this.indirects.get(key);
        boolean recurse_b = true;
        if (iRef != null) {
            retVal = iRef.getRef();
            if (iRef.getCopied()) {
                return retVal;
            }
        } else {
            retVal = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(retVal);
            this.indirects.put(key, iRef);
        }
        if ((in_obj = PdfReader.getPdfObject(in)) != null && in_obj.isDictionary() && PdfName.PAGE.equals(type = (in_dict = (PdfDictionary)in_obj).get(PdfName.TYPE)) && (parent_obj = in_dict.get(PdfName.PARENT)) != null && parent_obj.isIndirect() && ((parent_ref = (IndirectReferences)this.indirects.get(parent_key = new RefKey(parent_iref = (PRIndirectReference)parent_obj))) == null || !parent_ref.getCopied())) {
            recurse_b = false;
        }
        if (recurse_b) {
            iRef.setCopied();
            PdfObject obj = this.copyObject(PdfReader.getPdfObjectRelease(in));
            this.addToBody(obj, retVal);
        }
        return retVal;
    }

    public PdfDictionary copyDictionary(PdfDictionary in) throws IOException, BadPdfFormatException {
        PdfDictionary out = new PdfDictionary();
        PdfObject type = in.get(PdfName.TYPE);
        for (PdfName key : in.getKeys()) {
            PdfObject value = in.get(key);
            if (PdfName.PAGE.equals(type)) {
                if (key.equals(PdfName.PARENT)) {
                    out.put(PdfName.PARENT, this.topPageParent);
                    continue;
                }
                if (key.equals(PdfName.B)) continue;
                out.put(key, this.copyObject(value));
                continue;
            }
            out.put(key, this.copyObject(value));
        }
        return out;
    }

    protected PdfStream copyStream(PRStream in) throws IOException, BadPdfFormatException {
        PRStream out = new PRStream(in, null);
        for (PdfName key : in.getKeys()) {
            PdfObject value = in.get(key);
            out.put(key, this.copyObject(value));
        }
        return out;
    }

    protected PdfArray copyArray(PdfArray in) throws IOException, BadPdfFormatException {
        PdfArray out = new PdfArray();
        for (PdfObject value : in.getArrayList()) {
            out.add(this.copyObject(value));
        }
        return out;
    }

    protected PdfObject copyObject(PdfObject in) throws IOException, BadPdfFormatException {
        switch (in.type) {
            case 6: {
                return this.copyDictionary((PdfDictionary)in);
            }
            case 10: {
                return this.copyIndirect((PRIndirectReference)in);
            }
            case 5: {
                return this.copyArray((PdfArray)in);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return in;
            }
            case 7: {
                return this.copyStream((PRStream)in);
            }
        }
        if (in.type < 0) {
            String lit = ((PdfLiteral)in).toString();
            if (lit.equals("true") || lit.equals("false")) {
                return new PdfBoolean(lit);
            }
            return new PdfLiteral(lit);
        }
        System.err.println("CANNOT COPY type " + in.type);
        return null;
    }

    protected int setFromIPage(PdfImportedPage iPage) {
        int pageNum = iPage.getPageNumber();
        PdfReaderInstance inst = this.currentPdfReaderInstance = iPage.getPdfReaderInstance();
        this.reader = inst.getReader();
        this.setFromReader(this.reader);
        return pageNum;
    }

    public void setFromReader(PdfReader reader) {
        this.reader = reader;
        this.indirects = (HashMap)this.indirectMap.get(reader);
        if (this.indirects == null) {
            this.indirects = new HashMap();
            this.indirectMap.put(reader, this.indirects);
            PdfDictionary catalog = reader.getCatalog();
            PRIndirectReference ref = (PRIndirectReference)catalog.get(PdfName.PAGES);
            this.indirects.put(new RefKey(ref), new IndirectReferences(this.topPageParent));
        }
    }

    public void addPage(PdfImportedPage iPage) throws IOException, BadPdfFormatException, DocumentException {
        int pageNum = this.setFromIPage(iPage);
        PdfDictionary thePage = this.reader.getPageN(pageNum);
        PRIndirectReference origRef = this.reader.getPageOrigRef(pageNum);
        this.reader.releasePage(pageNum);
        RefKey key = new RefKey(origRef);
        PdfIndirectReference pageRef = null;
        IndirectReferences iRef = (IndirectReferences)this.indirects.get(key);
        if (iRef != null) {
            pageRef = iRef.getRef();
        } else {
            pageRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(pageRef);
            this.indirects.put(key, iRef);
        }
        this.pageReferences.add(pageRef);
        ++this.currentPageNumber;
        if (!iRef.getCopied()) {
            PdfDictionary acroForm;
            PdfObject dr_obj;
            PdfDictionary catalog;
            PdfObject acroForm_obj;
            PdfDictionary catalog_obj;
            iRef.setCopied();
            if (!this.topFormFieldReadersData.containsKey(this.reader)) {
                this.topFormFieldReadersData.put(this.reader, new TopFormFieldData());
            }
            TopFormFieldData readerData = (TopFormFieldData)this.topFormFieldReadersData.get(this.reader);
            PdfObject annots = PdfReader.getPdfObject(thePage.get(PdfName.ANNOTS));
            if (annots != null && annots.isArray()) {
                ArrayList annots_arr = ((PdfArray)annots).getArrayList();
                for (Object annot_ref_obj : annots_arr) {
                    PdfDictionary annot;
                    PdfObject subtype;
                    PdfIndirectReference annot_ref;
                    PdfObject annot_obj;
                    if (annot_ref_obj == null || !((PdfObject)annot_ref_obj).isIndirect() || (annot_obj = PdfReader.getPdfObject(annot_ref = (PdfIndirectReference)annot_ref_obj)) == null || !annot_obj.isDictionary() || !PdfName.WIDGET.equals(subtype = PdfReader.getPdfObject((annot = (PdfDictionary)annot_obj).get(PdfName.SUBTYPE)))) continue;
                    String full_name = "";
                    String top_name = "";
                    boolean is_unicode_b = false;
                    PdfObject tt_obj = PdfReader.getPdfObject(annot.get(PdfName.T));
                    if (tt_obj != null && tt_obj.isString()) {
                        PdfString tt = (PdfString)tt_obj;
                        top_name = tt.toString();
                        is_unicode_b = is_unicode_b || PdfString.isUnicode(tt.getBytes());
                    }
                    PdfIndirectReference parent_ref = (PdfIndirectReference)annot.get(PdfName.PARENT);
                    while (parent_ref != null && parent_ref.isIndirect()) {
                        annot_ref = parent_ref;
                        annot = (PdfDictionary)PdfReader.getPdfObject(annot_ref);
                        parent_ref = (PdfIndirectReference)annot.get(PdfName.PARENT);
                        tt_obj = PdfReader.getPdfObject(annot.get(PdfName.T));
                        if (tt_obj == null || !tt_obj.isString()) continue;
                        PdfString tt = (PdfString)tt_obj;
                        if (top_name.length() != 0) {
                            full_name = full_name + top_name;
                            full_name = full_name + ".";
                        }
                        top_name = tt.toString();
                        is_unicode_b = is_unicode_b || PdfString.isUnicode(tt.getBytes());
                    }
                    if (readerData.allNames.contains(top_name)) {
                        this.fullFormFieldNames.add(full_name + top_name + ".");
                        continue;
                    }
                    if (this.fullFormFieldNames.contains(full_name + top_name + ".")) {
                        int new_parent_name_ii = 1;
                        String new_parent_name = Integer.toString(new_parent_name_ii);
                        while (this.fullFormFieldNames.contains(full_name + top_name + "." + new_parent_name + ".") || this.topFormFieldNames.contains(new_parent_name) && !readerData.newNamesKids.containsKey(new_parent_name)) {
                            new_parent_name = Integer.toString(++new_parent_name_ii);
                        }
                        PdfIndirectReference new_parent_ref = null;
                        PdfArray new_parent_kids = null;
                        if (readerData.newNamesKids.containsKey(new_parent_name)) {
                            new_parent_ref = (PdfIndirectReference)readerData.newNamesRefs.get(new_parent_name);
                            new_parent_kids = (PdfArray)readerData.newNamesKids.get(new_parent_name);
                        } else {
                            PdfDictionary new_parent = new PdfDictionary();
                            PdfString new_parent_name_pdf = new PdfString(new_parent_name);
                            if (is_unicode_b) {
                                new_parent_name_pdf = new PdfString(new_parent_name, "UTF-16");
                            }
                            new_parent_ref = this.reader.getPRIndirectReference(new_parent);
                            new_parent.put(PdfName.T, new_parent_name_pdf);
                            new_parent_kids = new PdfArray();
                            PRIndirectReference new_parent_kids_ref = this.reader.getPRIndirectReference(new_parent_kids);
                            new_parent.put(PdfName.KIDS, new_parent_kids_ref);
                            readerData.newNamesRefs.put(new_parent_name, new_parent_ref);
                            readerData.newNamesKids.put(new_parent_name, new_parent_kids);
                            readerData.allNames.add(new_parent_name);
                            this.topFormFieldNames.add(new_parent_name);
                        }
                        annot.put(PdfName.PARENT, new_parent_ref);
                        new_parent_kids.add(annot_ref);
                        this.fullFormFieldNames.add(full_name + top_name + "." + new_parent_name + ".");
                        continue;
                    }
                    readerData.allNames.add(top_name);
                    this.topFormFieldNames.add(top_name);
                    this.fullFormFieldNames.add(full_name + top_name + ".");
                }
            }
            PdfDictionary newPage = this.copyDictionary(thePage);
            PdfObject annots2 = PdfReader.getPdfObject(thePage.get(PdfName.ANNOTS));
            if (annots2 != null && annots2.isArray()) {
                ArrayList annots_arr = ((PdfArray)annots2).getArrayList();
                for (PdfObject annot_ref_obj : annots_arr) {
                    PdfDictionary annot;
                    PdfObject subtype;
                    PdfIndirectReference annot_ref;
                    PdfObject annot_obj;
                    if (annot_ref_obj == null || !annot_ref_obj.isIndirect() || (annot_obj = PdfReader.getPdfObject(annot_ref = (PdfIndirectReference)annot_ref_obj)) == null || !annot_obj.isDictionary() || !PdfName.WIDGET.equals(subtype = PdfReader.getPdfObject((annot = (PdfDictionary)annot_obj).get(PdfName.SUBTYPE)))) continue;
                    PdfIndirectReference parent_ref = (PdfIndirectReference)annot.get(PdfName.PARENT);
                    while (parent_ref != null && parent_ref.isIndirect()) {
                        annot_ref = parent_ref;
                        annot = (PdfDictionary)PdfReader.getPdfObject(annot_ref);
                        parent_ref = (PdfIndirectReference)annot.get(PdfName.PARENT);
                    }
                    RefKey annot_key = new RefKey(annot_ref);
                    IndirectReferences annot_iRef = (IndirectReferences)this.indirects.get(annot_key);
                    PdfAcroForm acroForm2 = this.getAcroForm();
                    acroForm2.addDocumentField(annot_iRef.getRef());
                }
            }
            if ((catalog_obj = this.reader.getCatalog()) != null && catalog_obj.isDictionary() && (acroForm_obj = PdfReader.getPdfObject((catalog = catalog_obj).get(PdfName.ACROFORM))) != null && acroForm_obj.isDictionary() && (dr_obj = PdfReader.getPdfObject((acroForm = (PdfDictionary)acroForm_obj).get(PdfName.DR))) != null && dr_obj.isDictionary()) {
                PdfDictionary dr = (PdfDictionary)dr_obj;
                PdfAcroForm acroForm_target = this.getAcroForm();
                PdfDictionary dr_target = (PdfDictionary)PdfReader.getPdfObject(acroForm_target.get(PdfName.DR));
                if (dr_target == null) {
                    PdfDictionary dr_copy = this.copyDictionary(dr);
                    acroForm_target.put(PdfName.DR, dr_copy);
                } else {
                    for (PdfName dr_key : dr.getKeys()) {
                        PdfObject dr_val = dr.get(dr_key);
                        if (dr_target.contains(dr_key)) continue;
                        dr_target.put(dr_key, this.copyObject(dr_val));
                    }
                }
            }
            newPage.put(PdfName.PARENT, this.topPageParent);
            this.addToBody((PdfObject)newPage, pageRef);
        }
        this.getRoot().addPage(pageRef);
        this.pageNumbersToRefs.add(pageRef);
    }

    @Override
    public PdfIndirectReference getPageReference(int page) {
        if (page < 0 || page > this.pageNumbersToRefs.size()) {
            throw new IllegalArgumentException("Invalid page number " + page);
        }
        return (PdfIndirectReference)this.pageNumbersToRefs.get(page - 1);
    }

    @Override
    protected PdfDictionary getCatalog(PdfIndirectReference rootObj) throws DocumentException {
        PdfDocument.PdfCatalog catalog = this.getPdfDocument().getCatalog(rootObj);
        if (this.m_new_bookmarks != null) {
            catalog.put(PdfName.OUTLINES, this.m_new_bookmarks);
        }
        if (this.m_new_extensions != null) {
            catalog.put(PdfName.EXTENSIONS, this.m_new_extensions);
        }
        return catalog;
    }

    public void setOutlines(PdfIndirectReference outlines) {
        this.m_new_bookmarks = outlines;
    }

    public void setExtensions(PdfIndirectReference extensions) {
        this.m_new_extensions = extensions;
    }

    @Override
    public void close() {
        if (this.open) {
            PdfReaderInstance ri = this.currentPdfReaderInstance;
            this.getPdfDocument().close();
            super.close();
            if (ri != null) {
                try {
                    ri.getReader().close();
                    ri.getReaderFile().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public PdfIndirectReference add(PdfOutline outline) {
        return null;
    }

    @Override
    public void addAnnotation(PdfAnnotation annot) {
    }

    @Override
    PdfIndirectReference add(PdfPage page, PdfContents contents) throws PdfException {
        return null;
    }

    protected static class RefKey {
        int num = 0;
        int gen = 0;

        RefKey(int num, int gen) {
            this.num = num;
            this.gen = gen;
        }

        RefKey(PdfIndirectReference ref) {
            this.num = ref.getNumber();
            this.gen = ref.getGeneration();
        }

        RefKey(PRIndirectReference ref) {
            this.num = ref.getNumber();
            this.gen = ref.getGeneration();
        }

        public int hashCode() {
            return (this.gen << 16) + this.num;
        }

        public boolean equals(Object o) {
            RefKey other = (RefKey)o;
            return this.gen == other.gen && this.num == other.num;
        }

        public String toString() {
            return "" + this.num + " " + this.gen;
        }
    }

    static class IndirectReferences {
        PdfIndirectReference theRef = null;
        boolean hasCopied = false;

        IndirectReferences(PdfIndirectReference ref) {
            this.theRef = ref;
            this.hasCopied = false;
        }

        void setCopied() {
            this.hasCopied = true;
        }

        boolean getCopied() {
            return this.hasCopied;
        }

        PdfIndirectReference getRef() {
            return this.theRef;
        }
    }

    protected class TopFormFieldData {
        HashMap newNamesRefs = new HashMap();
        HashMap newNamesKids = new HashMap();
        HashSet allNames = new HashSet();
    }
}

