12.2 Sending OSC

# Sending OSC

In addition to receiving OSC and working with it using Time State, we
can also send out OSC messages in time with our music (just like we can
send out MIDI messages in time with our music). We just need to know
which IP address and port we're sending to. Let's give it a try:

```
use_osc "localhost", 4560
osc "/hello/world"
```

If you run the code above, you'll notice that Sonic Pi is sending itself
an OSC message! This is because we set the IP address to the current
machine and the port to the default OSC in port. This is essentially the
same as posting a letter to yourself - the OSC packet is created, leaves
Sonic Pi, gets to the network stack of the operating system which then
routes the packed back to Sonic Pi and then it's received as a standard
OSC message and is visible in the cue logger as the incoming message
`/osc:127.0.0.1:4560/hello/world`. (Notice how Sonic Pi automatically prefixes all
incoming OSC messages with `/osc` and then the hostname and port of the sender.)

## Sending OSC to other programs

Of course, sending OSC messages to ourselves may be fun but it's not
that useful. The real benefit starts when we send messages to other
programs:


```
use_osc "localhost", 123456
osc "/hello/world"
```

In this case we're assuming there's another program on the same machine
listening to port 123456. If there is, then it will receive a
`"/hello/world` OSC message with which it can do what it wants.

If our program is running on another machine, we need to know its IP
address which we use instead of `"localhost"`:

```
use_osc "192.168.10.23", 123456
osc "/hello/world"
```

Now we can send OSC messages to any device reachable to us via our local
networks and even the internet!
