/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.model.node;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import org.gephi.graph.api.Node;
import org.gephi.lib.gleem.linalg.Vecf;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.model.node.NodeModel;

public class NodeDiskModel
extends NodeModel {
    public int modelType;
    public int modelBorderType;

    public NodeDiskModel(Node node) {
        super(node);
    }

    @Override
    public void display(GL2 gl, GLU glu, VizModel vizModel) {
        boolean selec = this.selected;
        boolean neighbor = false;
        this.highlight = false;
        if (vizModel.isAutoSelectNeighbor() && this.mark && !selec) {
            selec = true;
            this.highlight = true;
            neighbor = true;
        }
        this.mark = false;
        gl.glPushMatrix();
        float size = this.node.size() * 2.0f;
        gl.glTranslatef(this.node.x(), this.node.y(), this.node.z());
        gl.glScalef(size, size, 1.0f);
        if (!selec) {
            if (vizModel.getConfig().isLightenNonSelected()) {
                float[] lightColor = vizModel.getBackgroundColorComponents();
                float lightColorFactor = vizModel.getConfig().getLightenNonSelectedFactor();
                float r = this.node.r();
                float g = this.node.g();
                float b = this.node.b();
                gl.glColor3f(r + (lightColor[0] - r) * lightColorFactor, g + (lightColor[1] - g) * lightColorFactor, b + (lightColor[2] - b) * lightColorFactor);
                gl.glCallList(this.modelType);
                if (this.modelBorderType != 0) {
                    float rborder = 0.498f * r;
                    float gborder = 0.498f * g;
                    float bborder = 0.498f * b;
                    gl.glColor3f(rborder + (lightColor[0] - rborder) * lightColorFactor, gborder + (lightColor[1] - gborder) * lightColorFactor, bborder + (lightColor[2] - bborder) * lightColorFactor);
                    gl.glCallList(this.modelBorderType);
                }
            } else {
                float r = this.node.r();
                float g = this.node.g();
                float b = this.node.b();
                gl.glColor3f(r, g, b);
                gl.glCallList(this.modelType);
                if (this.modelBorderType != 0) {
                    float rborder = 0.498f * r;
                    float gborder = 0.498f * g;
                    float bborder = 0.498f * b;
                    gl.glColor3f(rborder, gborder, bborder);
                    gl.glCallList(this.modelBorderType);
                }
            }
        } else {
            float bborder;
            float gborder;
            float rborder;
            float b;
            float g;
            float r;
            if (vizModel.isUniColorSelected()) {
                if (neighbor) {
                    r = vizModel.getConfig().getUniColorSelectedNeigborColor()[0];
                    g = vizModel.getConfig().getUniColorSelectedNeigborColor()[1];
                    b = vizModel.getConfig().getUniColorSelectedNeigborColor()[2];
                } else {
                    r = vizModel.getConfig().getUniColorSelectedColor()[0];
                    g = vizModel.getConfig().getUniColorSelectedColor()[1];
                    b = vizModel.getConfig().getUniColorSelectedColor()[2];
                }
                rborder = 0.498f * r;
                gborder = 0.498f * g;
                bborder = 0.498f * b;
            } else {
                rborder = this.node.r();
                gborder = this.node.g();
                bborder = this.node.b();
                r = Math.min(1.0f, 0.5f * rborder + 0.5f);
                g = Math.min(1.0f, 0.5f * gborder + 0.5f);
                b = Math.min(1.0f, 0.5f * bborder + 0.5f);
            }
            gl.glColor3f(r, g, b);
            gl.glCallList(this.modelType);
            if (this.modelBorderType != 0) {
                gl.glColor3f(rborder, gborder, bborder);
                gl.glCallList(this.modelBorderType);
            }
        }
        gl.glPopMatrix();
    }

    @Override
    public boolean selectionTest(Vecf distanceFromMouse, float selectionSize) {
        return distanceFromMouse.get(2) - selectionSize < this.node.size();
    }

    @Override
    public float getCollisionDistance(double angle) {
        return this.node.size();
    }
}

