/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class CheckConstPrivateProperties
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType MISSING_CONST_PROPERTY = DiagnosticType.disabled("JSC_MISSING_CONST_PROPERTY", "Private property {0} is never modified, use the @const annotation");
    private final AbstractCompiler compiler;
    private final List<Node> candidates = new ArrayList<Node>();
    private final Set<String> modified = new HashSet<String>();

    CheckConstPrivateProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    private void reportMissingConst(NodeTraversal t) {
        for (Node n : this.candidates) {
            String propName = n.getLastChild().getString();
            if (this.modified.contains(propName)) continue;
            t.report(n, MISSING_CONST_PROPERTY, propName);
        }
        this.candidates.clear();
        this.modified.clear();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                this.reportMissingConst(t);
                break;
            }
            case GETELEM: 
            case GETPROP: {
                Node lastChild = n.getLastChild();
                if (!lastChild.isString()) {
                    return;
                }
                String propName = lastChild.getString();
                if (this.isCandidatePropertyDefinition(n)) {
                    this.candidates.add(n);
                    break;
                }
                if (!this.isModificationOp(n)) break;
                this.modified.add(propName);
                break;
            }
        }
    }

    private boolean isCandidatePropertyDefinition(Node n) {
        if (!NodeUtil.isLhsOfAssign(n)) {
            return false;
        }
        Node target = n.getFirstChild();
        if (!target.isThis() && !this.isConstructor(target)) {
            return false;
        }
        JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
        return info != null && info.getVisibility() == JSDocInfo.Visibility.PRIVATE && !info.isConstant() && !info.hasTypedefType() && !info.hasEnumParameterType() && !info.isInterface() && !this.isFunctionProperty(n);
    }

    private boolean isFunctionProperty(Node n) {
        if (n.isGetElem()) {
            return false;
        }
        Node assignedValue = NodeUtil.getAssignedValue(n);
        return assignedValue != null && assignedValue.isFunction();
    }

    private boolean isModificationOp(Node n) {
        Node parent = n.getParent();
        if (n != parent.getFirstChild()) {
            return false;
        }
        return NodeUtil.isAssignmentOp(parent) || parent.isInc() || parent.isDec() || parent.isDelProp();
    }

    private boolean isConstructor(Node n) {
        JSType type = n.getJSType();
        return type != null && (type.isConstructor() || type.isInterface());
    }
}

