/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;
import java.util.function.Consumer;

public final class ParsingUtil {
    private ParsingUtil() {
    }

    public static void getParamOrPatternNames(Node n, Consumer<Node> cb) {
        Preconditions.checkNotNull(n);
        switch (n.getToken()) {
            case EMPTY: 
            case GETELEM: 
            case GETPROP: {
                break;
            }
            case NAME: {
                cb.accept(n);
                break;
            }
            case ITER_REST: 
            case OBJECT_REST: 
            case STRING_KEY: 
            case DEFAULT_VALUE: {
                ParsingUtil.getParamOrPatternNames(n.getFirstChild(), cb);
                break;
            }
            case COMPUTED_PROP: {
                ParsingUtil.getParamOrPatternNames(n.getSecondChild(), cb);
                break;
            }
            case OBJECT_PATTERN: 
            case ARRAY_PATTERN: 
            case PARAM_LIST: {
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    ParsingUtil.getParamOrPatternNames(c, cb);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected parameter structure");
            }
        }
    }
}

