/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components.gradientslider;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.UIManager;

public class PaintUtils {
    public static final Color[] whites = new Color[]{new Color(255, 255, 255, 50), new Color(255, 255, 255, 100), new Color(255, 255, 255, 150)};
    public static final Color[] blacks = new Color[]{new Color(0, 0, 0, 50), new Color(0, 0, 0, 100), new Color(0, 0, 0, 150)};

    public static Color getFocusRingColor() {
        Color obj = UIManager.getColor("focusRing");
        if (obj instanceof Color) {
            return obj;
        }
        return new Color(64, 113, 167);
    }

    public static void paintFocus(Graphics2D g, Shape shape, int biggestStroke) {
        Color focusColor = PaintUtils.getFocusRingColor();
        Color[] focusArray = new Color[]{new Color(focusColor.getRed(), focusColor.getGreen(), focusColor.getBlue(), 255), new Color(focusColor.getRed(), focusColor.getGreen(), focusColor.getBlue(), 170), new Color(focusColor.getRed(), focusColor.getGreen(), focusColor.getBlue(), 110)};
        g.setStroke(new BasicStroke(biggestStroke));
        g.setColor(focusArray[2]);
        g.draw(shape);
        g.setStroke(new BasicStroke(biggestStroke - 1));
        g.setColor(focusArray[1]);
        g.draw(shape);
        g.setStroke(new BasicStroke(biggestStroke - 2));
        g.setColor(focusArray[0]);
        g.draw(shape);
        g.setStroke(new BasicStroke(1.0f));
    }

    public static void drawBevel(Graphics g, Rectangle r) {
        PaintUtils.drawColors(blacks, g, r.x, r.y + r.height, r.x + r.width, r.y + r.height, 5);
        PaintUtils.drawColors(blacks, g, r.x + r.width, r.y, r.x + r.width, r.y + r.height, 3);
        PaintUtils.drawColors(whites, g, r.x, r.y, r.x + r.width, r.y, 1);
        PaintUtils.drawColors(whites, g, r.x, r.y, r.x, r.y + r.height, 7);
        g.setColor(new Color(120, 120, 120));
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private static void drawColors(Color[] colors, Graphics g, int x1, int y1, int x2, int y2, int direction) {
        for (int a = 0; a < colors.length; ++a) {
            g.setColor(colors[colors.length - a - 1]);
            if (direction == 5) {
                g.drawLine(x1, y1 - a, x2, y2 - a);
                continue;
            }
            if (direction == 1) {
                g.drawLine(x1, y1 + a, x2, y2 + a);
                continue;
            }
            if (direction == 3) {
                g.drawLine(x1 - a, y1, x2 - a, y2);
                continue;
            }
            if (direction != 7) continue;
            g.drawLine(x1 + a, y1, x2 + a, y2);
        }
    }
}

